/* -*-C++-*-
*******************************************************************************
*
* File:         test_microtune.cc
* Description:  send tuning command to microtune 4937
*
*******************************************************************************
*/

/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <microtune_eval_board.h>

int main (int argc, char **argv)
{
  int		which = 1;	// the parallel port the board is connected to
  double	target_freq;
  double	actual_freq;
  
  if (argc != 2)
    target_freq = 95.5;
  else
    target_freq = strtod (argv[1], 0);

  if (target_freq == 0.0){
    fprintf (stderr, "usage: test_microtune freq-in-MHz\n");
    exit (1);
  }

  target_freq *= 1e6;
  
  microtune_eval_board *eb = new microtune_eval_board (which);

  if (!eb->board_present_p ())
    fprintf (stderr, "Eval board is NOT present\n");

  while (1){
    if (!eb->set_RF_freq (target_freq, &actual_freq)){
      printf ("0");
    }
    else {
      printf ("1");
    }
  }

  return 0;
}
