/* -*- c++ -*- */
/*
 * Copyright 2003 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <GrFloatToComplex.h>
#include <stdio.h>
#include <stdexcept>


GrFloatToComplex::GrFloatToComplex ()
  : VrSigProc (1, sizeof (float), sizeof (VrComplex))
{
}

int
GrFloatToComplex::work (VrSampleRange output, void *ao[],
			VrSampleRange inputs[], void *ai[])
{
  VrComplex *out = ((VrComplex **)ao)[0];
  float     *rl   = ((float **)ai)[0];
  float	    *im   = ((float **)ai)[1];
  
  switch (getNumberInputs ()){
  case 1:
    for (unsigned int i = 0; i < output.size; i++){
      out[i] = VrComplex (rl[i], 0);
    }
    return output.size;

  case 2:
    for (unsigned int i = 0; i < output.size; i++){
      out[i] = VrComplex (rl[i], im[i]);
    }
    return output.size;

  default:
    fprintf (stderr, "GrFloatToComplex: invalid number of inputs\n");
    throw std::runtime_error ("wrong number of inputs");
  }
}
