/* -*- Mode: c++ -*- */
/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#ifndef _GRPAMMOD_H_
#define _GRPAMMOD_H_

#include <VrSigProc.h>
#include <vector>

using std::vector;

template<class iType,class oType> 
class GrPAMMod : public VrSigProc {
protected:
  vector<oType> constellation;
public: 
  virtual const char *name() { return "GrPAMMod"; }
  virtual int work(VrSampleRange output, void *o[],
		   VrSampleRange inputs[], void *i[]);
  GrPAMMod(int bits);
};

template<class iType,class oType> int
GrPAMMod<iType,oType>::work(VrSampleRange output, void *ao[],
			      VrSampleRange inputs[], void *ai[])
{
  iType **i = (iType **)ai;
  oType **o = (oType **)ao;
  int size = output.size;

  while(size-- > 0) {
    {
        *o[0]++ = constellation[*i[0]++];
    }
  }
  return output.size;
}

template<class iType,class oType> 
GrPAMMod<iType,oType>::GrPAMMod(int bits)
  : VrSigProc(1, sizeof(iType), sizeof(oType))
{
  constellation.resize(1<<bits);
  for(int i=0; i< ((1<<bits) ); i++)
    constellation[i] = -(1<<bits) + 2*i + 1;   // May need to adjust this order
}
#endif
