#
# Copyright 2003 Free Software Foundation, Inc.
# 
# This file is part of GNU Radio
# 
# GNU Radio is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# GNU Radio is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with GNU Radio; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.
# 

# this import is needed with python2.1
# from __future__ import nested_scopes

import re, os

# set srcdir to the directory that contains Makefile.am
try:
    srcdir = os.environ['srcdir']
except KeyError, e:
    srcdir = "."
srcdir = srcdir + '/'
# sys.path.append(srcdir)


# signatures defines which variations to generate (input, output, taps)

signatures = [ 'CCF', 'FCC', 'CCC', 'FFF', 'SCC', 'SIS', 'FSF' ]


copyright = '''/* -*- c++ -*- */
/*
 * Copyright 2003 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
'''

def i_code (code3):
    return code3[0]

def o_code (code3):
    return code3[1]

def tap_code (code3):
    return code3[2]

def i_type (code3):
    return char_to_type[i_code (code3)]

def o_type (code3):
    return char_to_type[o_code (code3)]

def tap_type (code3):
    return char_to_type[tap_code (code3)]


char_to_type = {}
char_to_type['C'] = 'VrComplex'
char_to_type['F'] = 'float'
char_to_type['S'] = 'short'
char_to_type['I'] = 'int'

char_to_builder = {}
char_to_builder['F'] = 'gr_fir_builderF'
char_to_builder['C'] = 'gr_fir_builderC'
char_to_builder['S'] = 'gr_fir_builderS'

def do_substitution (d, in_file, out_file):
    def repl (match_obj):
        key = match_obj.group (1)
        # print key
        return kludge_d[key]
    
    global kludge_d
    kludge_d = d
    inp = in_file.read ()
    out = re.sub (r"@([a-zA-Z0-9_]+)@", repl, inp)
    out_file.write (out)

def open_src (name, mode):
    global srcdir
    return open (os.path.join (srcdir, name), mode)
