/* -*- Mode: c++ -*-
 *
 *  Copyright 1997 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 */


#ifndef _VRTESTCOUNTSINK_H_
#define _VRTESTCOUNTSINK_H_

#include <VrSink.h>
#include <pthread.h>

template<class iType> 
class VrTestCountSink : public VrSink<iType> {
  iType counter;
public:
  virtual const char *name() { return "VrTestCountSink"; }
  virtual void work(timestamp ts, unsigned int size, iType *i[]);
  virtual void initialize();
};

template<class iType> void
VrTestCountSink<iType>::initialize()
{
  counter=0;
}

template<class iType> void
VrTestCountSink<iType>::work(timestamp ts, unsigned int size, iType *i[])
{ 

  sync(ts); //simulate sequential Sink
  
  int size_save = size;
  timestamp ts_save=ts;

  while(size-- > 0) {
    //waste some time
    int n=ts;
    for(int ii=0; ii<5;ii++)
      n += n % 13;

    if(*i[0] != counter) {
      fprintf(stderr, "Value at ts=%lld is %d instead of %d\n",
		ts, (int) *i[0], (int) ts);
    }
    i[0]++; counter++;
  }

  //  if(size_save > 0)
  //    cerr<<size_save<<" complete["<<pthread_self()<<"] at "<<ts_save<<"."<<endl;
  
}

#endif





