/* -*- Mode: c++ -*- 
 *
 *  Copyright 1997 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 */


#ifndef _VRAMPLITUDEDEMOD_H_
#define _VRAMPLITUDEDEMOD_H_

#include <VrSigProc.h>
#include <math.h>

template<class oType> 
class VrAmplitudeDemod : public VrSigProc<complex,oType> {
protected:
  float gain,avgTime;
  float lastAvg, lastDiff;
public: 
  void setGain(float g){ gain = g; return;}
  virtual void work(int n);
  virtual void initialize();
  VrAmplitudeDemod(float g);
  VrAmplitudeDemod(float g, float tavg);
  VrAmplitudeDemod();
};

template<class oType> void
VrAmplitudeDemod<oType>::work(int n)
{
  float avg;
  complex *inputArray;

  while(n>0) {
    int len = getHistory();

    avg = 0;

    float temp, max = 0, min = 0, diff;

    // Compute Average value of sequence
    inputArray = inputReadPtr(-len+1);
    for (int i=0;i < len; i++) {
      temp  = sqrt(real(inputArray[i] * conj(inputArray[i])));
      avg += temp;
      //      if (temp > max) max = temp;
      //      if (temp < min) min = temp;
      //      diff = max-min;
      //cout << diff << " " << gain << " " << temp <<" " <<  lastAvg <<" " << lastDiff << endl;
      outputWrite((oType)(gain * (temp - lastAvg)));
      
    }
    max = 0;
    min = avg;
    lastDiff = diff;
    lastAvg = avg / (float)len;

    // Jump ahead, so that we can go back and compute the average value
    incReadPtr(n);

    n-=len;
  }
  return;
}

template<class oType> void
VrAmplitudeDemod<oType>::initialize()
{
  setHistory((int)(getInputSamplingFrequencyN(0) * avgTime));
  setOutputSize((int)(getInputSamplingFrequencyN(0) * avgTime));
}

template<class oType> 
VrAmplitudeDemod<oType>::VrAmplitudeDemod(float g)
  :gain(g),avgTime(0.1)
{
}
template<class oType> 
VrAmplitudeDemod<oType>::VrAmplitudeDemod(float g,float tavg)
  :gain(g),avgTime(tavg)
{
}

template<class oType> 
VrAmplitudeDemod<oType>::VrAmplitudeDemod()
  :gain(1),avgTime(0.1)
{
}

#endif









