#ifndef _MULTICHANNEL_H_
#define _MULTICHANNEL_H_

#include <qwidget.h>
#include <VrTypes.h>

template<class oType> class VrAR5000Source;
template<class iType> class VrComplexFIRfilter;
// template<class iType> class VrComplexCascadefilter;
template<class iType, class oType> class VrRealFIRfilter;
template<class oType> class VrQuadratureDemod;
template<class iType> class VrQFFTSink;
template<class iType> class VrAudioSink;
class VrMultiTask;
template<class oType> class VrZeroSource;

class Channel;
class QTimer;

class Multichannel : public QWidget
{
  Q_OBJECT

  static const int numChannels = 4;

  QTimer *timer;

  Channel *channel[numChannels];

  Channel *left;
  Channel *right;

  VrAR5000Source<char> *source;

  VrComplexFIRfilter<char> *chan_filter;

  //  VrComplexCascadefilter<complex> *cascade_filter[numChannels];

  VrQFFTSink<complex> *chan_FFT[numChannels];

  VrQuadratureDemod<float> *left_demod;
  VrRealFIRfilter<float,short> *left_if_filter;

  VrQuadratureDemod<float> *right_demod;
  VrRealFIRfilter<float,short> *right_if_filter;
  VrAudioSink<short> *audio;
  
  VrMultiTask *mtask;

  VrZeroSource<short> *zero;

  void updateAudio();

public:
  Multichannel(QWidget *p = 0, const char *name = 0);
  ~Multichannel();

public slots:
  void leftClicked();
  void rightClicked();
  void doWork();

};

#endif
