/* -*- c++ -*- */
/*
 * Copyright 2005 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <gr_msg_queue.h>

gr_msg_queue_sptr
gr_make_msg_queue ()
{
  return gr_msg_queue_sptr (new gr_msg_queue ());
}


gr_msg_queue::gr_msg_queue ()
  : d_cond(&d_mutex), /*d_head(0), d_tail(0),*/ d_count(0)
{
}

gr_msg_queue::~gr_msg_queue ()
{
  flush ();
}

void
gr_msg_queue::insert_tail (gr_message_sptr msg)
{
  omni_mutex_lock	l(d_mutex);

  if (d_tail == 0){
    d_tail = d_head = msg;
    //msg->d_next = 0;
    msg->d_next.reset();
  }
  else {
    d_tail->d_next = msg;
    d_tail = msg;
    //msg->d_next = 0;
    msg->d_next.reset();
  }
  d_count++;
  d_cond.signal ();
}

gr_message_sptr
gr_msg_queue::delete_head ()
{
  omni_mutex_lock 	l(d_mutex);
  gr_message_sptr	m;

  while ((m = d_head) == 0)
    d_cond.wait ();

  d_head = m->d_next;
  if (d_head == 0){
    //d_tail = 0;
    d_tail.reset();
  }

  d_count--;
  // m->d_next = 0;
  m->d_next.reset();
  return m;
}

gr_message_sptr
gr_msg_queue::delete_head_nowait ()
{
  omni_mutex_lock 	l(d_mutex);
  gr_message_sptr	m;

  if ((m = d_head) == 0){
    //return 0;
    return gr_message_sptr();
  }

  d_head = m->d_next;
  if (d_head == 0){
    //d_tail = 0;
    d_tail.reset();
  }

  d_count--;
  //m->d_next = 0;
  m->d_next.reset();
  return m;
}

void
gr_msg_queue::flush ()
{
  gr_message_sptr	m;

  while ((m = delete_head_nowait ()) != 0)
    ;
}
