/* -*- c++ -*- */
/*
 * Copyright 2006 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef INCLUDED_GR_CHUNKS_TO_SYMBOLS_BF_H
#define INCLUDED_GR_CHUNKS_TO_SYMBOLS_BF_H

#include <gr_sync_interpolator.h>

class gr_chunks_to_symbols_bf;
typedef boost::shared_ptr<gr_chunks_to_symbols_bf> gr_chunks_to_symbols_bf_sptr;

gr_chunks_to_symbols_bf_sptr 
gr_make_chunks_to_symbols_bf (const std::vector<float> symbol_table);

/*!
 * \brief Map a stream of symbol indexes (unpacked bytes) to stream of real constellation points.
 * \ingroup block
 *
 * input: stream of bytes; output: stream of float
 *
 * The combination of gr_packed_to_unpacked_bb followed by
 * gr_chunks_to_symbols_bf or gr_chunks_to_symbols_bc handles the
 * general case of mapping from a stream of bytes into arbitrary float
 * or complex symbols.
 *
 * \sa gr_packed_to_unpacked_bb, gr_unpacked_to_packed_bb,
 * \sa gr_chunks_to_symbols_bf, gr_chunks_to_symbols_bc.
 */
class gr_chunks_to_symbols_bf : public gr_sync_block
{
  friend gr_chunks_to_symbols_bf_sptr 
  gr_make_chunks_to_symbols_bf (const std::vector<float> symbol_table);

  const std::vector<float> d_symbol_table;
  gr_chunks_to_symbols_bf (const std::vector<float> symbol_table);

 public:
  int work (int noutput_items,
	    gr_vector_const_void_star &input_items,
	    gr_vector_void_star &output_items);
};

#endif /* INCLUDED_GR_CHUNKS_TO_SYMBOLS_BF_H */
