/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.debug.Debug;
import gnu.jel.debug.Tester;

class IntegerStack {
    private int[] data;
    private int count = 0;

    public IntegerStack(int initCapacity) {
        this.data = new int[initCapacity];
    }

    public IntegerStack() {
        this(30);
    }

    public IntegerStack copy() {
        IntegerStack res = new IntegerStack(this.data.length);
        res.count = this.count;
        int i = 0;
        while (i < this.count) {
            res.data[i] = this.data[i];
            ++i;
        }
        return res;
    }

    public final void push(int what) {
        if (this.count >= this.data.length) {
            this.incCap(this.count + 1);
        }
        this.data[this.count++] = what;
    }

    public final int peek() {
        return this.data[this.count - 1];
    }

    public final int pop() {
        return this.data[--this.count];
    }

    public final int size() {
        return this.count;
    }

    public static void swap(IntegerStack one, int oneLim, IntegerStack other, int otherLim) {
        IntegerStack temp = null;
        if (one.size() > oneLim) {
            temp = new IntegerStack();
        }
        while (one.size() > oneLim) {
            temp.push(one.pop());
        }
        while (other.size() > otherLim) {
            one.push(other.pop());
        }
        while (temp != null && temp.size() > 0) {
            other.push(temp.pop());
        }
    }

    private void incCap(int minCapacity) {
        int[] old_data = this.data;
        int oldSize = this.data.length;
        int newSize = oldSize * 2;
        if (newSize < minCapacity) {
            newSize = minCapacity;
        }
        this.data = new int[newSize];
        System.arraycopy(old_data, 0, this.data, 0, this.count);
    }

    public static void main(String[] args) {
        Tester t = new Tester(System.out);
        IntegerStack.test(t);
        t.summarize();
    }

    public static void test(Tester t) {
        IntegerStack is = null;
        try {
            t.startTest("Make a new stack.");
            is = new IntegerStack(1);
            t.testOK();
        }
        catch (Throwable e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        try {
            t.startTest("push(10)");
            is.push(10);
            t.testOK();
        }
        catch (Throwable e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        try {
            t.startTest("peek()==10");
            t.compare(is.peek(), 10);
        }
        catch (Throwable e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        try {
            t.startTest("push(10); pop()==10");
            is.push(10);
            t.compare(is.pop(), 10);
        }
        catch (Throwable e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        try {
            t.startTest("push(11)");
            is.push(11);
            t.testOK();
        }
        catch (Throwable e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        try {
            t.startTest("peek(0)=11");
            t.compare(is.peek(), 11);
        }
        catch (Throwable e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        try {
            t.startTest("push(12); pop()==12");
            is.push(12);
            t.compare(is.pop(), 12);
        }
        catch (Throwable e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        try {
            t.startTest("pop()==11");
            t.compare(is.pop(), 11);
        }
        catch (Throwable e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        try {
            t.startTest("pop()==10");
            t.compare(is.pop(), 10);
        }
        catch (Throwable e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        try {
            t.startTest("size()==0");
            t.compare(is.size(), 0);
        }
        catch (Throwable e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
    }
}

