
(defun bak ()
  (interactive)
  (assert os-type--linux-p)
  (unix-bak-rest-files)
  )

(require 'cull-same-dates)
(require 'cull-size-quota)

(defun unix-bak-rest-files ()
  (save-window-excursion

    (progn
      (if (file-exists-p "/media/www/C1TB")
          (make-directory "/media/www/C1TB/home/bak/baz"   'PARENTS))
      (if (file-exists-p "/media/www/C80GB")
          (make-directory "/media/www/C80GB/home/bak/baz"   'PARENTS))
      (if (file-exists-p "/media/www/D153GB")
          (make-directory "/media/www/D153GB/home/bak/baz"  'PARENTS))
      (if (file-exists-p "/media/www/F2TB")
          (make-directory "/media/www/F2TB/home/bak/baz"    'PARENTS))
      (if (file-exists-p "/media/www/G16GB")
          (make-directory "/media/www/G16GB/home/bak/baz"   'PARENTS))
      (if (file-exists-p "/media/www/H16GB")
          (make-directory "/media/www/I16GB/home/bak/baz"   'PARENTS))
      (if (file-exists-p "/media/www/I16GB")
          (make-directory "/media/www/H16GB/home/bak/baz"   'PARENTS))
      (if (file-exists-p "/media/www/K2TB")
          (make-directory "/media/www/K2TB/home/bak/baz"    'PARENTS))
      (if (file-exists-p "/media/www/BLU16GB")
          (make-directory "/media/www/BLU16GB/home/bak/baz" 'PARENTS))
      (if (file-exists-p "/media/www/GRN16GB")
          (make-directory "/media/www/BLU16GB/home/bak/baz" 'PARENTS))
      (if (file-exists-p "/media/www/WD2TB")
          (make-directory "/media/www/WD2TB/home/bak/baz" 'PARENTS))
      (if (file-exists-p "/media/www/WD2TB2")
          (make-directory "/media/www/WD2TB2/home/bak/baz" 'PARENTS))
      )

    (progn
      (datify--dir "~/bak")
      (datify--dir "~/bak/baz")
      (if (file-exists-p "/media/www/C1TB/home/bak")
          (datify--dir "/media/www/C1TB/home/bak"))
      (if (file-exists-p "/media/www/C80GB/home/bak")
          (datify--dir "/media/www/C80GB/home/bak"))
      (if (file-exists-p "/media/www/F2TB/home/bak")
          (datify--dir "/media/www/F2TB/home/bak"))
      (if (file-exists-p "/media/www/G16GB/home/bak")
          (datify--dir "/media/www/G16GB/home/bak"))
      (if (file-exists-p "/media/www/H16GB/home/bak")
          (datify--dir "/media/www/H16GB/home/bak"))
      (if (file-exists-p "/media/www/I16GB/home/bak")
          (datify--dir "/media/www/I16GB/home/bak"))
      (if (file-exists-p "/media/www/J600GB/home/bak")
          (datify--dir "/media/www/J600GB/home/bak"))
      (if (file-exists-p "/media/www/K2TB/home/bak")
          (datify--dir "/media/www/K2TB/home/bak"))
      (if (file-exists-p "/media/www/BLU16GB/home/bak")
          (datify--dir "/media/www/BLU16GB/home/bak"))
      (if (file-exists-p "/media/www/GRN16GB/home/bak")
          (datify--dir "/media/www/GRN16GB/home/bak"))
      (if (file-exists-p "/media/www/WD2TB/home/bak")
          (datify--dir "/media/www/WD2TB/home/bak"))
      (if (file-exists-p "/media/www/WD2TB2/home/bak")
          (datify--dir "/media/www/WD2TB2/home/bak"))
      )
    (progn
      (cull-same-dates "~/bak")
      (if (file-exists-p "/media/www/C1TB/home/bak")
          (cull-same-dates "/media/www/C1TB/home/bak"))
      (if (file-exists-p "/media/www/C80GB/home/bak")
          (cull-same-dates "/media/www/C80GB/home/bak"))
      ;;(if (file-exists-p "/media/www/F2TB/home/bak")
      ;;    (cull-same-dates "/media/www/F2TB/home/bak"))
      (if (file-exists-p "/media/www/G16GB/home/bak")
          (cull-same-dates "/media/www/G16GB/home/bak"))
      ;;(if (file-exists-p "/media/www/H16GB/home/bak")
      ;;    (cull-same-dates "/media/www/H16GB/home/bak"))
      ;;(if (file-exists-p "/media/www/I16GB/home/bak")
      ;;    (cull-same-dates "/media/www/I16GB/home/bak"))
      ;;(if (file-exists-p "/media/www/J600GB/home/bak")
      ;;    (cull-same-dates "/media/www/J600GB/home/bak"))
      ;;(if (file-exists-p "/media/www/K2TB/home/bak")
      ;;    (cull-same-dates "/media/www/K2TB/home/bak"))
      (if (file-exists-p "/media/www/BLU16GB/home/bak")
          (cull-same-dates "/media/www/BLU16GB/home/bak"))
      (if (file-exists-p "/media/www/GRN16GB/home/bak")
          (cull-same-dates "/media/www/GRN16GB/home/bak"))
      (if (file-exists-p "/media/www/WD2TB/home/bak")
          (cull-same-dates "/media/www/WD2TB/home/bak"))
      (if (file-exists-p "/media/www/WD2TB2/home/bak")
          (cull-same-dates "/media/www/WD2TB2/home/bak"))
      )
    (progn
      (cull-same-dates "~/bak/baz")
      (if (file-exists-p "/media/www/C80GB/home/bak/baz")
          (cull-same-dates "/media/www/C80GB/home/bak/baz"))
      ;;(if (file-exists-p "/media/www/F2TB/home/bak/baz")
      ;;    (cull-same-dates "/media/www/F2TB/home/bak/baz"))
      (if (file-exists-p "/media/www/G16GB/home/bak/baz")
          (cull-same-dates "/media/www/G16GB/home/bak/baz"))
      ;;(if (file-exists-p "/media/www/H16GB/home/bak/baz")
      ;;    (cull-same-dates "/media/www/H16GB/home/bak/baz"))
      ;;(if (file-exists-p "/media/www/I16GB/home/bak/baz")
      ;;    (cull-same-dates "/media/www/I16GB/home/bak/baz"))
      ;;(if (file-exists-p "/media/www/J600GB/home/bak/baz")
      ;;    (cull-same-dates "/media/www/J600GB/home/bak/baz"))
      ;;(if (file-exists-p "/media/www/K2TB/home/bak/baz")
      ;;    (cull-same-dates "/media/www/K2TB/home/bak/baz"))
      (if (file-exists-p "/media/www/BLU16GB/home/bak/baz")
          (cull-same-dates "/media/www/BLU16GB/home/bak/baz"))
      (if (file-exists-p "/media/www/GRN16GB/home/bak/baz")
          (cull-same-dates "/media/www/GRN16GB/home/bak/baz"))
      (if (file-exists-p "/media/www/WD2TB/home/bak/baz")
          (cull-same-dates "/media/www/WD2TB/home/bak/baz"))
      (if (file-exists-p "/media/www/WD2TB2/home/bak/baz")
          (cull-same-dates "/media/www/WD2TB2/home/bak/baz"))
      )
    (progn
      (cull-size-quota "~/bak")
      (if (file-exists-p "/media/www/C80GB/home/bak")
          (cull-size-quota "/media/www/C80GB/home/bak"))
      ;;(if (file-exists-p "/media/www/F2TB/home/bak")
      ;;    (cull-size-quota "/media/www/F2TB/home/bak"))
      (if (file-exists-p "/media/www/G16GB/home/bak")
          (cull-size-quota "/media/www/G16GB/home/bak"))
      ;;(if (file-exists-p "/media/www/H16GB/home/bak")
      ;;    (cull-size-quota "/media/www/H16GB/home/bak"))
      ;;(if (file-exists-p "/media/www/I16GB/home/bak")
      ;;    (cull-size-quota "/media/www/I16GB/home/bak"))
      ;;(if (file-exists-p "/media/www/J600GB/home/bak")
      ;;    (cull-size-quota "/media/www/J600GB/home/bak"))
      ;;(if (file-exists-p "/media/www/K2TB/home/bak")
      ;;    (cull-size-quota "/media/www/K2TB/home/bak"))
      (if (file-exists-p "/media/www/BLU16GB/home/bak")
          (cull-size-quota "/media/www/BLU16GB/home/bak"))
      (if (file-exists-p "/media/www/GRN16GB/home/bak")
          (cull-size-quota "/media/www/GRN16GB/home/bak"))
      (if (file-exists-p "/media/www/WD2TB/home/bak")
          (cull-size-quota "/media/www/WD2TB/home/bak"))
      (if (file-exists-p "/media/www/WD2TB2/home/bak")
          (cull-size-quota "/media/www/WD2TB2/home/bak"))
      )
    (progn
      (cull-size-quota "~/bak/baz")
      (if (file-exists-p "/media/www/C1TB/home/bak/baz")
          (cull-size-quota "/media/www/C1TB/home/bak/baz"))
      (if (file-exists-p "/media/www/C80GB/home/bak/baz")
          (cull-size-quota "/media/www/C80GB/home/bak/baz"))
      ;;(if (file-exists-p "/media/www/F2TB/home/bak/baz")
      ;;  (cull-size-quota "/media/www/F2TB/home/bak/baz"))
      (if (file-exists-p "/media/www/G16GB/home/bak/baz")
          (cull-size-quota "/media/www/G16GB/home/bak/baz"))
      ;;(if (file-exists-p "/media/www/H16GB/home/bak/baz")
      ;;    (cull-size-quota "/media/www/H16GB/home/bak/baz"))
      ;;(if (file-exists-p "/media/www/I16GB/home/bak/baz")
      ;;    (cull-size-quota "/media/www/I16GB/home/bak/baz"))
      ;;(if (file-exists-p "/media/www/J600GB/home/bak/baz")
      ;;    (cull-size-quota "/media/www/J600GB/home/bak/baz"))
      ;;(if (file-exists-p "/media/www/K2TB/home/bak/baz")
      ;;    (cull-size-quota "/media/www/K2TB/home/bak/baz"))
      (if (file-exists-p "/media/www/BLU16GB/home/bak/baz")
          (cull-size-quota "/media/www/BLU16GB/home/bak/baz"))
      (if (file-exists-p "/media/www/GRN16GB/home/bak/baz")
          (cull-size-quota "/media/www/GRN16GB/home/bak/baz"))
      (if (file-exists-p "/media/www/WD2TB/home/bak/baz")
          (cull-size-quota "/media/www/WD2TB/home/bak/baz"))
      (if (file-exists-p "/media/www/WD2TB2/home/bak/baz")
          (cull-size-quota "/media/www/WD2TB2/home/bak/baz"))
      )
    (demises-get-demises)
    (message "Completed M-x bak")
    ))

(provide 'bak-unix)
;;; bak-unix.el ends here
