/* Copyright (C) 1997 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

#ifndef _SYS_ACCT_H

#define _SYS_ACCT_H	1
#include <features.h>

#define	__need_time_t
#include <time.h>


__BEGIN_DECLS

#define ACCT_COMM 16

struct acct
  {
    char ac_comm[ACCT_COMM];		/* Accounting command name.  */
    time_t ac_utime;			/* Accounting user time.  */
    time_t ac_stime;			/* Accounting system time.  */
    time_t ac_etime;			/* Accounting elapsed time.  */
    time_t ac_btime;			/* Beginning time.  */
    long ac_uid;			/* Accounting user ID.  */
    long ac_gid;			/* Accounting group ID.  */
    unsigned long int ac_tty;		/* Controlling tty.  */
    /* Please note that the value of the `ac_tty' field, a device number,
       is encoded differently in the kernel and for the libc dev_t type.  */
    char ac_flag;			/* Accounting flag.  */
    long int ac_minflt;			/* Accounting minor pagefaults.  */
    long int ac_majflt;			/* Accounting major pagefaults.  */
    long int ac_exitcode;		/* Accounting process exitcode.  */
  };

enum
  {
    AFORK = 0001,		/* Has executed fork, but no exec.  */
    ASU = 0002,			/* Used super-user privileges.  */
    ACORE = 0004,		/* Dumped core.  */
    AXSIG = 0010		/* Killed by a signal.  */
  };

#define AHZ     100


/* Switch process accounting on and off.  */
extern int acct __P ((__const char *__filename));

__END_DECLS

#endif	/* sys/acct.h */
