/**
 * GNU LibreJS - A browser add-on to block nonfree nontrivial JavaScript.
 * *
 * Copyright (C) 2011, 2012 Loic J. Duros
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see  <http://www.gnu.org/licenses/>.
 *
 */

/**
 * The following module is intended to perform tasks when the
 * add-on is enabled and disabled.
 */ 

const {Cc, Ci, Cu, Cm, Cr} = require("chrome");

const httpObserver = require("http_observer/http_request_observer");

const jsLoadObserver = require("js_load_observer/js_load_observer");

const narcissusWorker = require("narcissus_parser/narcissus_worker");

const caching = require("http_observer/caching");

const prompt = Cc["@mozilla.org/embedcomp/prompt-service;1"].
                                    getService(Ci.nsIPromptService);

const tabs = require('tabs');

var clearCache;

// check if there's an update on gnu.org.
// provide a link in widget panel if there is an update.
var update = require('addon_management/update');

var clearAndReloadAll = function () {
    caching.clearAllCache();
    for each (var tab in tabs) {
	tab.reload();
    }
};

/**
 * Stop the httpObserver when the add-on
 * is disabled or removed.
 */
exports.onUnload = function(reason) {

 if (reason == "disable" || 
     reason == "shutdown" ||
     reason == "upgrade" ||
     reason == "downgrade") {
     // console.log("disable");

     httpObserver.removeHttpObserver();
     jsLoadObserver.removeJsLoadObserver();
     narcissusWorker.stopWorker();
 }

};

exports.onLoad = function () {
    try {
    var clearCache = prompt.confirm(null, "LibreJS installation", "In order to analyze the pages you have already loaded, LibreJS must reload all your tabs and windows.\n\nIf you have many tabs opened, it can take long and slow down your browser. If you only have a few tabs opened, click 'OK' to reload them; if you have many tabs opened, click 'Cancel' and refresh the tabs you are using manually.");
    if (clearCache) {
	clearAndReloadAll();
    }
    } catch (e) {
	console.log(e);
    }
}