/* modiface.h

   written by Don Maszle
   8 October 1991
   
   Copyright (c) 1993.  Don Maszle, Frederic Bois.  All rights reserved.

   -- Revisions -----
     Logfile:  SCCS/s.modiface.h
    Revision:  1.1
        Date:  7/14/93
     Modtime:  19:11:18
      Author:  @a
   -- SCCS  ---------

   
*/

#ifndef _MODIFACE_INCLUDED

/* ----- Inclusions  */

#include "hungtype.h"
#include "lexfn.h"


/* ----- Constants  */

/* ----- Enumerations  */

/* ----- Typedefs  */

/*. #ifndef HANDLE */
/*. typedef WORD HANDLE; */
/*. #endif */
typedef HANDLE HVAR;	/* Handle to a model variable  */
typedef HVAR *PHVAR;	/* and a pointer to the handle */

/* ----- Macros  */

/* The following macros are provided to make the interfacing of old
   calculation routines easier.  The controlRec and paramRec passed
   to calcDeriv(), scale() and calcJacob() are not needed by the
   model generator code file.  The model is known to these routines.
   
   By including this file (modiface.h) at the beginning of a file of
   calculations routines, e.g. difsub.c, the file should compile and
   link to the new model code without error.  The following macros
   definitions will substitute for the prototypes of what were
   function calls in the original code.  
   
   Ultimately, the routines should actually be changed to reflect the
   changes in the structure of the program.
*/


#define calcDeriv(pparmRec, pdTime, pdStates, pcontrolRec, pdDeriv) \
        CalcDeriv(pdStates, pdDeriv, pdTime)

#define scale(control, param)	ScaleModel()

#define calcJacob(n, param, pdTime, pdStates, ppdSave) \
        CalcJacob((pdStates), (ppdSave), pdTime)



/* MonteCarlo
   
   - For MonteCarlo simulation rewrite monte carlo handler into
     DoSimulation() structure.
*/
	  
/*
   Optimize
   
   - For optimization, interface to these procedures.
   - Rewrite Optimization handler into DoSimulation() structure.
   
   simplexe(V.simplex, V.ySimplex, &nbrdx, &rTolerance, &nbrdIter, &V);
   powell(V.x, initDir, nbrdx, rTolerance, &nbrdIter, &V.optimum, &V);
   fletcher(V.x, nbrdx, rTolerance, &nbrdIter, &V.optimum, &V);
   mtCarlo(V.x, nbrdx, rTolerance, &nbrdIter, &V.optimum, &V);
*/
	  
/* ----- Globals/Externals  */


/* ----- Prototypes  */

  /* Model Initialization and calculation */
	  
void InitModel (void);	/* Initialize model to nominal values */
void ScaleModel (void);	/* Scale the model as defined */

void CalcDeriv (double rgModelVars[], double rgDerivs[], PDOUBLE pdTime);
void CalcJacob (double rgModelVars[], double *rgdSave[], PDOUBLE pdTime);
void CalcOutputs (double rgModelVars[], double rgDerivs[], PDOUBLE pdTime);

void CalcInputs (PDOUBLE pdTime);




  /* For exchanging info with the model */

PDOUBLE GetModelVector (void);	/* Vector of model vars */
int	GetNModelVars (void);	/* Number of model vars */
int	GetNStates (void);	/* First n Model vars are states */


  /* All interactions with individual variables and parameters
     of the model are managed through HANDLEs.  The variable name
     is submitted and a handle to the variable, HVAR, is returned.
     This handle can then be used to get the current value of the
     variable, or to change the value.
     
     Note that inputs are defined by IFN function records and thus
     have a separate assignment routine.  For inputs, GetVarValue()
     returns the current value of the input, as defined in the last
     calculation, and SetInput() takes a pointer to a defining IFN
     record.  The record is copied into the model, and is assumed to
     be valid--no verification of parameters is performed.
*/

			         
HVAR  GetVarHandle (PSTR szName); /* Returns a handle to szName */

double GetVarValue (HVAR hVar);   /* Returns current value of hVar */

BOOL IsInput (HVAR hVar);       /* Returns TRUE if hVar is an input */
BOOL IsState (HVAR hVar);       /* Returns TRUE if hVar is an state */
BOOL IsOutput (HVAR hVar);      /* Returns TRUE if hVar is an output */
BOOL IsModelVar (HVAR hVar);    /* Returns TRUE if hVar is an state or out */
BOOL IsParm (HVAR hVar);        /* Returns TRUE if hVar is an parm */

				/* Finds time of next input transition */
void UpdateInputs (PDOUBLE pdTime, PDOUBLE pdNextTransTime);

BOOL SetInput (HVAR hVar,	 /* Returns TRUE if assignment succeeds */
	       PIFN pInputFnRecord);	/* Function description for hvar */

BOOL SetVar (HVAR hVar,		 /* Returns  TRUE if assignment succeeds */
             double dVal);		/* Value to be assigned */

int ModelIndex (HVAR hvar);	 /* Returns the index of a model variable */

#define _MODIFACE_INCLUDED
#endif
