/* -*-c-*- -------------- mixvm_loop.c :
 * Implementation of mix vm command loop.
 * ------------------------------------------------------------------
 * Copyright (C) 2000 jose antonio ortega ruiz <jaortega@acm.org>
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *  
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *  
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *  
 */



#include <mixlib/mix.h>
#include <stdio.h>
#include <readline/readline.h>
#include <readline/history.h>
#include "mixvm_command.h"

/* A static variable for holding the line. */
static char *line_read = (char *)NULL;
static const char *PROMPT = N_("MIX > ");

/* Read a string, and return a pointer to it.  Returns NULL on EOF. */
static char *
rl_gets ()
{
  /* If the buffer has already been allocated, return the memory
     to the free pool. */
  if (line_read)
    {
      g_free (line_read);
      line_read = (char *)NULL;
    }
     
  /* Get a line from the user. */
  line_read = readline ((char *)PROMPT);
     
  /* If the line has any text in it, save it on the history. */
  if (line_read && *line_read)
    add_history (line_read);
     
  return (line_read);
}


/* The main command loop of the virtual machine  */
void
mix_vmloop (const gchar *file)
{
  mixvm_cmd_init ((char *)file);
  while ( mixvm_cmd_exec (rl_gets ()) ) 
    ;
}


