/* modriessen.c: -*- C -*-  Hacks that Gerrit Riessen required. */

#include "modules.h"

#if defined (__cplusplus)
extern "C"
{
#endif

static void pf_stream_coerce (PFunArgs);

static PFunDesc ftab[] =
{
  /*   tag           complex? debug_level          code    */
  { "STREAM-COERCE",    0,       0,       pf_stream_coerce },
  { (char *)NULL,       0,       0,       (PFunHandler *)NULL }
};

MODULE_INITIALIZE ("riessen", ftab)

DEFINE_SECTION (RIESSEN-MODULE, hacks; stream hacks,
"The functions in this module are those that Gerrit Riessen found useful in
his ongoing use of Meta-HTML.", "")

DEFUN (pf_stream_coerce, stream &key type=(FILE|TCP|PROG),
"Coerce the type of <var stream> from what it is to what it is not.
There has to be a better way.")
{
  MHTMLStream *stream = mhtml_get_stream_reference (vars);
  char *type_name = mhtml_evaluate_string (get_value (vars, "TYPE"));
  int type = mhtml_stream_type (type_name);
  xfree (type_name);
  
  switch (type)
    {
    case mhtml_stream_FILE: stream->type = mhtml_stream_FILE; break;
    case mhtml_stream_TCP:  stream->type = mhtml_stream_TCP; break;
    case mhtml_stream_PROG: stream->type = mhtml_stream_PROG; break;
    }
}

#if defined (__cplusplus)
}
#endif
