#if defined (HAVE_CONFIG_H)
#  include "config.h"
#endif

#if defined (HAVE_PRAGMA_GCC_DIAGNOSTIC)
   // This one needs to be global.
#  pragma GCC diagnostic ignored "-Wunused-function"
   // Disable these warnings for code that is generated by flex,
   // including pattern rules.  Push the current state so we can
   // restore the warning state prior to functions we define at
   // the bottom of the file.
#  pragma GCC diagnostic push
#  pragma GCC diagnostic ignored "-Wold-style-cast"
#  pragma GCC diagnostic ignored "-Wsign-compare"
#  pragma GCC diagnostic ignored "-Wzero-as-null-pointer-constant"
#  if defined (HAVE_WARN_IMPLICIT_FALLTHROUGH)
#    pragma GCC diagnostic ignored "-Wimplicit-fallthrough"
#  endif
#endif

// Define away the deprecated register storage class specifier to avoid
// potential warnings about it.
#if ! defined (register)
#  define register
#endif

#line 28 "libinterp/parse-tree/lex.cc"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 1
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* TODO: this is always defined, so inline it */
#define yyconst const

#if defined(__GNUC__) && __GNUC__ >= 3
#define yynoreturn __attribute__((__noreturn__))
#else
#define yynoreturn
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* An opaque pointer. */
#ifndef YY_TYPEDEF_YY_SCANNER_T
#define YY_TYPEDEF_YY_SCANNER_T
typedef void* yyscan_t;
#endif

/* For convenience, these vars (plus the bison vars far below)
   are macros in the reentrant scanner. */
#define yyin yyg->yyin_r
#define yyout yyg->yyout_r
#define yyextra yyg->yyextra_r
#define yyleng yyg->yyleng_r
#define yytext yyg->yytext_r
#define yylineno (YY_CURRENT_BUFFER_LVALUE->yy_bs_lineno)
#define yycolumn (YY_CURRENT_BUFFER_LVALUE->yy_bs_column)
#define yy_flex_debug yyg->yy_flex_debug_r

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN yyg->yy_start = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((yyg->yy_start - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE octave_restart(yyin ,yyscanner )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)
    #define YY_LINENO_REWIND_TO(ptr)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = yyg->yy_hold_char; \
		YY_RESTORE_YY_MORE_OFFSET \
		yyg->yy_c_buf_p = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, yyg->yytext_ptr , yyscanner )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	int yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via octave_restart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( yyg->yy_buffer_stack \
                          ? yyg->yy_buffer_stack[yyg->yy_buffer_stack_top] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE yyg->yy_buffer_stack[yyg->yy_buffer_stack_top]

void octave_restart (FILE *input_file ,yyscan_t yyscanner );
void octave__switch_to_buffer (YY_BUFFER_STATE new_buffer ,yyscan_t yyscanner );
YY_BUFFER_STATE octave__create_buffer (FILE *file,int size ,yyscan_t yyscanner );
void octave__delete_buffer (YY_BUFFER_STATE b ,yyscan_t yyscanner );
void octave__flush_buffer (YY_BUFFER_STATE b ,yyscan_t yyscanner );
void octave_push_buffer_state (YY_BUFFER_STATE new_buffer ,yyscan_t yyscanner );
void octave_pop_buffer_state (yyscan_t yyscanner );

static void octave_ensure_buffer_stack (yyscan_t yyscanner );
static void octave__load_buffer_state (yyscan_t yyscanner );
static void octave__init_buffer (YY_BUFFER_STATE b,FILE *file ,yyscan_t yyscanner );

#define YY_FLUSH_BUFFER octave__flush_buffer(YY_CURRENT_BUFFER ,yyscanner)

YY_BUFFER_STATE octave__scan_buffer (char *base,yy_size_t size ,yyscan_t yyscanner );
YY_BUFFER_STATE octave__scan_string (yyconst char *yy_str ,yyscan_t yyscanner );
YY_BUFFER_STATE octave__scan_bytes (yyconst char *bytes,int len ,yyscan_t yyscanner );

void *octave_alloc (yy_size_t ,yyscan_t yyscanner );
void *octave_realloc (void *,yy_size_t ,yyscan_t yyscanner );
void octave_free (void * ,yyscan_t yyscanner );

#define yy_new_buffer octave__create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        octave_ensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            octave__create_buffer(yyin,YY_BUF_SIZE ,yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        octave_ensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            octave__create_buffer(yyin,YY_BUF_SIZE ,yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define octave_wrap(yyscanner) (/*CONSTCOND*/1)
#define YY_SKIP_YYWRAP

typedef unsigned char YY_CHAR;

typedef int yy_state_type;

#define yytext_ptr yytext_r

static yy_state_type yy_get_previous_state (yyscan_t yyscanner );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  ,yyscan_t yyscanner);
static int yy_get_next_buffer (yyscan_t yyscanner );
static void yynoreturn yy_fatal_error (yyconst char* msg ,yyscan_t yyscanner );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	yyg->yytext_ptr = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	yyg->yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yyg->yy_c_buf_p = yy_cp;

#define YY_NUM_RULES 119
#define YY_END_OF_BUFFER 120
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[266] =
    {   0,
        0,    0,    5,    5,   10,   10,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  120,  118,
       51,   60,   60,   91,   62,  118,   56,   76,   61,   96,
       97,   80,   88,   92,   89,   98,   81,   50,   50,   63,
       87,   78,   99,   79,  118,   59,   14,   82,   15,   83,
       56,   56,  116,   77,  117,   90,   51,  118,    9,    8,
        3,    3,    7,  119,    5,    6,    4,    9,   10,   11,
       11,   12,   13,   10,    1,    1,  119,   19,   19,  119,
      119,   22,   22,   22,   22,   39,   40,   40,   24,   38,
      119,   43,   44,   44,   42,   47,   46,  119,   45,   51,

        0,   60,   74,    0,   20,   20,   56,    0,   85,  114,
       84,  102,   94,  100,   95,  101,   93,   66,   64,   65,
        0,   67,   50,   68,   69,  103,   50,   50,    0,    0,
       48,    0,   71,   72,   75,   58,    0,   53,   53,    0,
      104,  110,   56,   56,  115,   86,   73,   51,    0,    0,
        9,    8,    3,    0,    3,    5,    6,    0,   10,   11,
       10,    1,    0,   19,   19,    0,    0,    0,    0,    0,
        0,   22,    0,   21,   21,   39,   40,   23,    0,   37,
       37,   36,   36,   25,   27,   28,   29,   30,   31,   32,
       33,   37,   43,   44,   41,   46,   45,    0,   57,  111,

       70,  107,  105,  106,    0,  108,   50,    0,  109,  112,
       49,   50,   50,    0,   50,   50,   58,    0,    0,   54,
       54,   56,    0,   16,   16,    0,    0,   17,   17,    0,
       18,   18,    0,    0,   35,   35,   25,   26,   45,   57,
        0,  113,    0,   52,   52,    0,   50,   50,   50,   58,
        0,   55,    0,    2,    2,    0,   34,   34,   25,   45,
       57,   50,   58,   57,    0
    } ;

static yyconst YY_CHAR yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    4,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    5,    6,    7,    8,    7,    9,   10,   11,
       12,   13,   14,   15,   16,   17,   18,   19,   20,   21,
       21,   21,   21,   21,   21,   22,   22,   23,   24,   25,
       26,   27,   28,   29,   30,   31,   30,   32,   32,   30,
        8,    8,   33,   33,    8,    8,    8,    8,    8,    8,
        8,    8,    8,    8,    8,    8,    8,   34,    8,    8,
       35,   36,   37,   38,   39,    1,   40,   41,   30,   32,

       42,   43,   44,    8,   33,   33,    8,    8,    8,   45,
        8,    8,    8,   46,   47,   48,    8,   49,    8,   50,
        8,    8,   51,   52,   53,   54,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst YY_CHAR yy_meta[55] =
    {   0,
        1,    2,    3,    3,    1,    4,    2,    5,    1,    6,
        2,    2,    1,    1,    2,    1,    7,    1,    8,    8,
        8,    8,    1,    2,    1,    1,    1,    1,    9,   10,
       10,   10,   11,    5,    2,   12,    2,    1,   11,   10,
       10,   10,   10,    5,    5,    5,    5,    5,    5,    5,
        2,    1,    2,    1
    } ;

static yyconst flex_uint16_t yy_base[299] =
    {   0,
        0,   53,   59,  111,   54,   83,  619,  618,   64,   75,
       91,   95,  102,  127,  137,  139,  163,  212,  618,  820,
       57,  820,  614,  590,  820,   69,  586,   66,  820,  820,
      820,   75,   90,  820,  108,  253,  583,  275,  119,  820,
      820,  582,  483,  482,    0,  820,  820,  152,  820,  481,
      103,  110,  820,   77,  820,  480,   82,  170,    0,  503,
      820,  500,  820,   77,  116,  145,  820,  485,  168,  820,
      498,  820,  820,  170,  820,  497,  176,  820,  496,  181,
      183,  820,  174,  495,  186,    0,  820,  494,  490,  478,
      324,    0,  820,  491,  478,  820,  485,  820,  469,  215,

      188,  820,  820,  196,  820,  481,  453,    0,  820,  820,
      455,  820,  820,  820,  820,  820,  820,  203,  454,  452,
      460,  450,  279,  427,  408,  820,  365,    0,  199,  211,
      820,    0,  820,  820,  820,  388,  274,  820,  397,  220,
      820,  820,  199,  220,  820,  820,  820,  233,  279,  282,
        0,  394,  820,  261,  391,  268,  276,  374,  303,  820,
      313,  820,  319,  820,  386,  329,  337,  335,  344,  347,
      331,  820,  347,  820,  373,    0,  820,  820,  354,  820,
      353,  820,  363,  339,  820,  820,  820,  820,  820,  820,
      820,    0,    0,  820,  820,  361,  325,    0,  307,  820,

      278,  820,  820,  820,  349,  820,  360,  392,  820,  820,
      820,  396,  400,  402,  421,  269,  276,    0,  358,  820,
      287,  366,  423,  820,  284,  406,  428,  820,  277,  442,
      820,  247,  445,  448,  820,  245,  436,    0,  224,  222,
        0,  820,  433,  820,  234,  442,  446,  450,  193,  184,
       98,  820,  455,  820,  165,  471,  820,  158,  820,  141,
      120,  471,  108,   94,  820,  510,  522,  534,  546,  558,
      570,  582,  594,  602,  609,  620,  632,  644,  656,  668,
      679,  691,  699,  706,  710,  716,  727,  732,  738,  745,
      756,  761,  768,  779,  787,  794,  801,  808

    } ;

static yyconst flex_int16_t yy_def[299] =
    {   0,
      265,    1,  266,  266,    1,    1,  267,  267,  268,  268,
      269,  269,  270,  270,  271,  271,  272,  272,  265,  265,
      265,  265,  265,  265,  265,  273,  274,  265,  265,  265,
      265,  265,  265,  265,  265,  265,  265,  265,   38,  265,
      265,  265,  265,  265,  275,  265,  265,  265,  265,  265,
      274,  274,  265,  265,  265,  265,  265,  273,  276,  265,
      265,  265,  265,  277,  265,  265,  265,  265,  265,  265,
      265,  265,  265,  265,  265,  265,  278,  265,  265,  278,
      278,  265,  265,  265,  279,  280,  265,  265,  265,  265,
      281,  282,  265,  265,  265,  265,  265,  265,  283,  265,

      273,  265,  265,  273,  265,  265,  274,  284,  265,  265,
      265,  265,  265,  265,  265,  265,  265,  265,  265,  265,
      265,  265,  265,  265,  265,  265,  265,   39,  265,  265,
      265,  285,  265,  265,  265,  286,  265,  265,  265,  287,
      265,  265,  274,  274,  265,  265,  265,  265,  273,  273,
      276,  265,  265,  277,  265,  265,  265,  265,  265,  265,
      265,  265,  278,  265,  265,  278,  278,  278,  278,  265,
      279,  265,  279,  265,  265,  280,  265,  265,  265,  265,
      265,  265,  265,  265,  265,  265,  265,  265,  265,  265,
      265,  288,  282,  265,  265,  265,  283,  289,  290,  265,

      265,  265,  265,  265,  291,  265,  265,  265,  265,  265,
      265,  265,  265,  265,  265,  292,  286,  293,  287,  265,
      265,  274,  273,  265,  265,  294,  278,  265,  265,  278,
      265,  265,  265,  265,  265,  265,  265,  288,  295,  290,
      296,  265,  291,  265,  265,  265,  265,  265,  292,  297,
      265,  265,  294,  265,  265,  265,  265,  265,  265,  295,
      298,  265,  297,  298,    0,  265,  265,  265,  265,  265,
      265,  265,  265,  265,  265,  265,  265,  265,  265,  265,
      265,  265,  265,  265,  265,  265,  265,  265,  265,  265,
      265,  265,  265,  265,  265,  265,  265,  265

    } ;

static yyconst flex_uint16_t yy_nxt[875] =
    {   0,
       20,   21,   22,   23,   24,   25,   26,   27,   28,   29,
       30,   31,   32,   33,   34,   35,   36,   37,   38,   39,
       39,   39,   40,   41,   42,   43,   44,   45,   46,   27,
       27,   27,   27,   27,   47,   48,   49,   50,   27,   27,
       27,   27,   27,   51,   27,   27,   52,   27,   27,   27,
       53,   54,   55,   56,   57,   69,   70,   71,  100,   58,
       60,   61,   62,  101,   63,   64,   78,   79,   63,   65,
       66,  105,  106,   67,  109,   68,   80,   78,   79,  153,
      155,   81,   67,  148,   74,   70,   71,  111,  149,   58,
       72,  110,   83,   65,   84,   66,   83,   85,   84,  251,

      112,   85,  145,  113,   87,   88,   73,   89,  252,   65,
      241,   66,   60,   61,   62,  114,   63,   64,   90,   72,
       63,   65,   66,  115,  218,   67,  156,   68,  146,   87,
       88,  108,   89,  116,   67,   73,  241,   91,  108,   93,
       94,   93,   94,   90,  143,   65,   95,   66,   95,  265,
      156,  144,  265,  137,  138,  139,  157,  198,  140,  265,
      257,   65,   91,   66,   97,   98,  156,  254,  265,  159,
       99,  161,  105,  106,  101,  170,  149,  141,  164,  165,
      171,  157,  166,  164,  165,  164,  165,  167,  174,  175,
      105,  106,   99,   99,   99,   99,   99,  157,  105,  106,

      218,   99,   99,   99,   99,   99,   99,   99,   99,   99,
       99,   99,   99,   97,   98,  201,  100,  213,  213,   99,
      150,  101,  220,  221,  214,  131,  214,  108,  202,  215,
      215,  215,  215,  168,  148,  169,  244,  213,  241,  149,
      198,   99,   99,   99,   99,   99,  222,  235,  108,  231,
       99,   99,   99,   99,   99,   99,   99,   99,   99,   99,
       99,   99,  117,  153,  155,  118,  119,  222,  120,  121,
      122,  123,  123,  123,  123,  137,  138,  139,  156,  228,
      140,  105,  106,  223,  224,  225,  224,  157,  124,  220,
      125,  127,  218,  128,  128,  128,  128,  207,  207,  207,

      207,  131,  156,  242,  159,  129,  130,  131,  132,  101,
      208,  131,  157,  128,  161,  129,  130,  207,  156,  149,
      208,  164,  165,  241,  132,  181,  182,  183,  157,  150,
      166,  164,  165,  174,  175,  167,  227,  228,  229,  164,
      165,  198,  184,  184,  184,  230,  231,  232,  170,  174,
      175,  244,  245,  171,  234,  235,  236,  237,  237,  237,
      220,  221,  196,  185,  186,  182,  187,  251,  188,  189,
      233,  190,  191,  192,  211,  174,  252,  211,  207,  207,
      207,  207,  211,  212,  212,  212,  212,  168,  164,  169,
      226,  208,  131,  153,  108,  152,  130,  131,  207,  138,

      211,  208,  211,  212,  218,  246,  130,  246,  254,  255,
      247,  247,  247,  247,  212,  212,  212,  212,  213,  213,
      215,  215,  215,  215,  223,  224,  225,  130,  131,  227,
      228,  229,  131,  210,  212,  244,  245,  130,  213,  248,
      248,  248,  248,  230,  231,  232,  256,  257,  258,  234,
      235,  236,  209,  131,  259,  259,  259,  254,  255,  248,
      247,  247,  247,  247,  262,  262,  262,  262,  248,  248,
      248,  248,  256,  257,  258,  206,  205,  204,  131,  203,
      200,  108,  131,  105,  262,  198,  196,  195,  248,  262,
      262,  262,  262,  194,  179,  178,  177,  172,  164,  162,

      160,  158,  153,  131,  152,  147,  142,  135,  134,  262,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   75,   75,   75,   75,   75,   75,   75,   75,
       75,   75,   75,   75,   77,   77,   77,   77,   77,   77,
       77,   77,   77,   77,   77,   77,   82,   82,   82,   82,
       82,   82,   82,   82,   82,   82,   82,   82,   86,   86,
       86,   86,   86,   86,   86,   86,   86,   86,   86,   86,
       92,   92,   92,   92,   92,   92,   92,   92,   92,   92,
       92,   92,   96,   96,   96,   96,   96,   96,   96,   96,
       96,   96,   96,   96,  104,  104,  104,  104,  104,  104,

      104,  104,  104,  104,  104,  104,  107,  133,  126,  107,
      107,  107,  107,  136,  108,  103,  102,  265,  136,  136,
      151,   76,   76,  265,  151,  265,  265,  151,  151,  151,
      151,  151,  154,  154,  154,  154,  154,  154,  154,  154,
      154,  154,  154,  154,  163,  163,  163,  163,  163,  163,
      163,  163,  163,  163,  163,  163,  173,  173,  173,  173,
      173,  173,  173,  173,  173,  173,  173,  173,  176,  176,
      265,  265,  176,  176,  265,  176,  176,  176,  176,  180,
      180,  180,  180,  180,  180,  180,  180,  180,  180,  180,
      180,  193,  193,  265,  193,  193,  265,  193,  193,  193,

      193,  193,  193,  197,  265,  197,  197,  265,  197,  197,
      199,  265,  265,  265,  265,  199,  199,  216,  265,  216,
      217,  265,  217,  217,  265,  217,  217,  219,  219,  219,
      219,  219,  219,  219,  219,  219,  219,  219,  219,  238,
      265,  238,  239,  265,  265,  265,  265,  239,  239,  240,
      265,  240,  240,  265,  240,  240,  243,  243,  243,  243,
      243,  243,  243,  243,  243,  243,  243,  243,  249,  265,
      249,  249,  250,  265,  265,  265,  265,  250,  250,  253,
      253,  253,  253,  253,  253,  253,  253,  253,  253,  253,
      253,  260,  265,  260,  260,  265,  260,  260,  261,  265,

      265,  265,  265,  261,  261,  263,  265,  263,  263,  265,
      263,  263,  264,  265,  264,  264,  265,  264,  264,   19,
      265,  265,  265,  265,  265,  265,  265,  265,  265,  265,
      265,  265,  265,  265,  265,  265,  265,  265,  265,  265,
      265,  265,  265,  265,  265,  265,  265,  265,  265,  265,
      265,  265,  265,  265,  265,  265,  265,  265,  265,  265,
      265,  265,  265,  265,  265,  265,  265,  265,  265,  265,
      265,  265,  265,  265
    } ;

static yyconst flex_int16_t yy_chk[875] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    2,    5,    5,    5,   21,    2,
        3,    3,    3,   21,    3,    3,    9,    9,    3,    3,
        3,   26,   26,    3,   28,    3,   10,   10,   10,   64,
       64,   10,    3,   57,    6,    6,    6,   32,   57,    6,
        5,   28,   11,    3,   11,    3,   12,   11,   12,  251,

       32,   12,   54,   33,   13,   13,    5,   13,  251,    3,
      264,    3,    4,    4,    4,   33,    4,    4,   13,    6,
        4,    4,    4,   35,  263,    4,   65,    4,   54,   14,
       14,   51,   14,   35,    4,    6,  261,   13,   52,   15,
       15,   16,   16,   14,   51,    4,   15,    4,   16,   39,
       65,   52,   39,   48,   48,   48,   66,  260,   48,   39,
      258,    4,   14,    4,   17,   17,   65,  255,   39,   69,
       17,   74,   58,   58,   69,   83,   74,   48,   77,   77,
       83,   66,   80,   80,   80,   81,   81,   80,   85,   85,
      101,  101,   17,   17,   17,   17,   17,   66,  104,  104,

      250,   17,   17,   17,   17,   17,   17,   17,   17,   17,
       17,   17,   17,   18,   18,  118,  100,  129,  129,   18,
       58,  100,  140,  140,  130,  249,  130,  143,  118,  130,
      130,  130,  130,   81,  148,   81,  245,  129,  240,  148,
      239,   18,   18,   18,   18,   18,  143,  236,  144,  232,
       18,   18,   18,   18,   18,   18,   18,   18,   18,   18,
       18,   18,   36,  154,  154,   36,   36,  144,   36,   36,
       36,   36,   36,   36,   36,  137,  137,  137,  156,  229,
      137,  149,  149,  150,  150,  150,  225,  157,   36,  221,
       36,   38,  217,   38,   38,   38,   38,  123,  123,  123,

      123,  216,  156,  201,  159,   38,   38,   38,   38,  159,
      123,  123,  157,   38,  161,   38,   38,  123,  156,  161,
      123,  163,  163,  199,   38,   91,   91,   91,  157,  149,
      166,  166,  166,  171,  171,  166,  168,  168,  168,  167,
      167,  197,   91,   91,   91,  169,  169,  169,  170,  173,
      173,  205,  205,  170,  181,  181,  181,  184,  184,  184,
      219,  219,  196,   91,   91,  183,   91,  222,   91,   91,
      179,   91,   91,   91,  127,  175,  222,  127,  207,  207,
      207,  207,  127,  127,  127,  127,  127,  167,  165,  167,
      158,  207,  207,  155,  222,  152,  127,  127,  207,  139,

      127,  207,  127,  127,  136,  208,  127,  208,  226,  226,
      208,  208,  208,  208,  212,  212,  212,  212,  213,  213,
      214,  214,  214,  214,  223,  223,  223,  212,  212,  227,
      227,  227,  213,  125,  212,  243,  243,  212,  213,  215,
      215,  215,  215,  230,  230,  230,  233,  233,  233,  234,
      234,  234,  124,  215,  237,  237,  237,  253,  253,  215,
      246,  246,  246,  246,  247,  247,  247,  247,  248,  248,
      248,  248,  256,  256,  256,  122,  121,  120,  247,  119,
      111,  107,  248,  106,  247,   99,   97,   95,  248,  262,
      262,  262,  262,   94,   90,   89,   88,   84,   79,   76,

       71,   68,   62,  262,   60,   56,   50,   44,   43,  262,
      266,  266,  266,  266,  266,  266,  266,  266,  266,  266,
      266,  266,  267,  267,  267,  267,  267,  267,  267,  267,
      267,  267,  267,  267,  268,  268,  268,  268,  268,  268,
      268,  268,  268,  268,  268,  268,  269,  269,  269,  269,
      269,  269,  269,  269,  269,  269,  269,  269,  270,  270,
      270,  270,  270,  270,  270,  270,  270,  270,  270,  270,
      271,  271,  271,  271,  271,  271,  271,  271,  271,  271,
      271,  271,  272,  272,  272,  272,  272,  272,  272,  272,
      272,  272,  272,  272,  273,  273,  273,  273,  273,  273,

      273,  273,  273,  273,  273,  273,  274,   42,   37,  274,
      274,  274,  274,  275,   27,   24,   23,   19,  275,  275,
      276,    8,    7,    0,  276,    0,    0,  276,  276,  276,
      276,  276,  277,  277,  277,  277,  277,  277,  277,  277,
      277,  277,  277,  277,  278,  278,  278,  278,  278,  278,
      278,  278,  278,  278,  278,  278,  279,  279,  279,  279,
      279,  279,  279,  279,  279,  279,  279,  279,  280,  280,
        0,    0,  280,  280,    0,  280,  280,  280,  280,  281,
      281,  281,  281,  281,  281,  281,  281,  281,  281,  281,
      281,  282,  282,    0,  282,  282,    0,  282,  282,  282,

      282,  282,  282,  283,    0,  283,  283,    0,  283,  283,
      284,    0,    0,    0,    0,  284,  284,  285,    0,  285,
      286,    0,  286,  286,    0,  286,  286,  287,  287,  287,
      287,  287,  287,  287,  287,  287,  287,  287,  287,  288,
        0,  288,  289,    0,    0,    0,    0,  289,  289,  290,
        0,  290,  290,    0,  290,  290,  291,  291,  291,  291,
      291,  291,  291,  291,  291,  291,  291,  291,  292,    0,
      292,  292,  293,    0,    0,    0,    0,  293,  293,  294,
      294,  294,  294,  294,  294,  294,  294,  294,  294,  294,
      294,  295,    0,  295,  295,    0,  295,  295,  296,    0,

        0,    0,    0,  296,  296,  297,    0,  297,  297,    0,
      297,  297,  298,    0,  298,  298,    0,  298,  298,  265,
      265,  265,  265,  265,  265,  265,  265,  265,  265,  265,
      265,  265,  265,  265,  265,  265,  265,  265,  265,  265,
      265,  265,  265,  265,  265,  265,  265,  265,  265,  265,
      265,  265,  265,  265,  265,  265,  265,  265,  265,  265,
      265,  265,  265,  265,  265,  265,  265,  265,  265,  265,
      265,  265,  265,  265
    } ;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
#line 1 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
/*

Copyright (C) 1993-2018 John W. Eaton

This file is part of Octave.

Octave is free software: you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Octave is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Octave; see the file COPYING.  If not, see
<https://www.gnu.org/licenses/>.

*/
/*
We are using the pure parser interface and the reentrant lexer
interface but the Octave parser and lexer are NOT properly
reentrant because both still use many global variables.  It should be
safe to create a parser object and call it while another parser
object is active (to parse a callback function while the main
interactive parser is waiting for input, for example) if you take
care to properly save and restore (typically with an unwind_protect
object) relevant global values before and after the nested call.
*/









#line 86 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"

#include <cctype>
#include <cstring>

#include <iostream>
#include <set>
#include <sstream>
#include <string>
#include <stack>

#include "cmd-edit.h"
#include "lo-mappers.h"
#include "quit.h"
#include "unistd-wrappers.h"

// These would be alphabetical, but oct-parse.h must be included before
// oct-gperf.h and oct-parse.h must be included after token.h and the tree
// class declarations.  We can't include oct-parse.h in oct-gperf.h
// because it may not be protected to allow it to be included multiple
// times.

#include "Cell.h"
#include "defun.h"
#include "error.h"
#include "errwarn.h"
#include "input.h"
#include "interpreter-private.h"
#include "interpreter.h"
#include "lex.h"
#include "octave.h"
#include "ov.h"
#include "parse.h"
#include "pt-all.h"
#include "symtab.h"
#include "token.h"
#include "utils.h"
#include "variables.h"
#include "oct-parse.h"
#include "oct-gperf.h"

// FIXME: with bison 3.x, OCTAVE_STYPE appears in the generated
// oct-parse.h file, but there is no definition for YYSTYPE, which is
// needed by the code that is generated by flex.  I can't seem to find a
// way to tell flex to use OCTAVE_STYPE instead of YYSTYPE in the code
// it generates, or to tell bison to provide the definition of YYSTYPE
// in the generated oct-parse.h file.

#if defined (OCTAVE_STYPE_IS_DECLARED) && ! defined YYSTYPE
#  define YYSTYPE OCTAVE_STYPE
#endif

#define YY_NO_UNISTD_H 1
#define isatty octave_isatty_wrapper

#if ! (defined (FLEX_SCANNER)                                           \
       && defined (YY_FLEX_MAJOR_VERSION) && YY_FLEX_MAJOR_VERSION >= 2 \
       && defined (YY_FLEX_MINOR_VERSION) && YY_FLEX_MINOR_VERSION >= 5)
#error lex.l requires flex version 2.5.4 or later
#endif

#define YY_EXTRA_TYPE octave::base_lexer *
#define curr_lexer yyextra

// Arrange to get input via readline.

#if defined (YY_INPUT)
#  undef YY_INPUT
#endif
#define YY_INPUT(buf, result, max_size)                 \
  result = curr_lexer->fill_flex_buffer (buf, max_size)

// Try to avoid crashing out completely on fatal scanner errors.

#if defined (YY_FATAL_ERROR)
#  undef YY_FATAL_ERROR
#endif
#define YY_FATAL_ERROR(msg)                     \
   (octave_get_extra (yyscanner))->fatal_error (msg)

#define CMD_OR_OP(PATTERN, TOK, COMPAT)                                 \
   do                                                                   \
     {                                                                  \
       curr_lexer->lexer_debug (PATTERN);                               \
                                                                        \
       if (curr_lexer->looks_like_command_arg ())                       \
         {                                                              \
           yyless (0);                                                  \
           curr_lexer->push_start_state (COMMAND_START);                \
         }                                                              \
       else                                                             \
         {                                                              \
           return curr_lexer->handle_op_internal (TOK, false, COMPAT);  \
         }                                                              \
     }                                                                  \
   while (0)

#define CMD_OR_COMPUTED_ASSIGN_OP(PATTERN, TOK)                         \
   do                                                                   \
     {                                                                  \
       curr_lexer->lexer_debug (PATTERN);                               \
                                                                        \
       if (curr_lexer->previous_token_may_be_command ()                 \
           && curr_lexer->space_follows_previous_token ())              \
         {                                                              \
           yyless (0);                                                  \
           curr_lexer->push_start_state (COMMAND_START);                \
         }                                                              \
       else                                                             \
         {                                                              \
           return curr_lexer->handle_language_extension_op (PATTERN, TOK, \
                                                            false);     \
         }                                                              \
     }                                                                  \
   while (0)

#define CMD_OR_UNARY_OP(PATTERN, TOK, COMPAT)                           \
   do                                                                   \
     {                                                                  \
       curr_lexer->lexer_debug (PATTERN);                               \
                                                                        \
       if (curr_lexer->previous_token_may_be_command ())                \
         {                                                              \
           if (curr_lexer->looks_like_command_arg ())                   \
             {                                                          \
               yyless (0);                                              \
               curr_lexer->push_start_state (COMMAND_START);            \
             }                                                          \
           else                                                         \
             {                                                          \
               return curr_lexer->handle_op_internal (TOK, false, COMPAT); \
             }                                                          \
         }                                                              \
       else                                                             \
         {                                                              \
           int tok                                                      \
           = (COMPAT                                                    \
              ? curr_lexer->handle_unary_op (TOK)                       \
              : curr_lexer->handle_language_extension_unary_op (TOK));  \
                                                                        \
           if (tok < 0)                                                 \
             {                                                          \
               yyless (0);                                              \
               curr_lexer->xunput (',');                                \
               /* Adjust for comma that was not really in the input stream. */ \
               curr_lexer->m_current_input_column--;                    \
             }                                                          \
           else                                                         \
             {                                                          \
               return tok;                                              \
             }                                                          \
         }                                                              \
     }                                                                  \
   while (0)

// We can't rely on the trick used elsewhere of sticking ASCII 1 in
// the input buffer and recognizing it as a special case because ASCII
// 1 is a valid character for a character string.  If we are at the
// end of the buffer, ask for more input.  If we are at the end of the
// file, deal with it.  Otherwise, just keep going with the text from
// the current buffer.
#define HANDLE_STRING_CONTINUATION                      \
   do                                                   \
     {                                                  \
       curr_lexer->decrement_promptflag ();             \
       curr_lexer->m_input_line_number++;               \
       curr_lexer->m_current_input_column = 1;          \
                                                        \
       if (curr_lexer->is_push_lexer ())                \
         {                                              \
           if (curr_lexer->at_end_of_buffer ())         \
             return -1;                                 \
                                                        \
           if (curr_lexer->at_end_of_file ())           \
             return curr_lexer->handle_end_of_input (); \
         }                                              \
     }                                                  \
   while (0)

// When a command argument boundary is detected, push out the
// current argument being built.  This one seems like a good
// candidate for a function call.

#define COMMAND_ARG_FINISH                                              \
   do                                                                   \
     {                                                                  \
       if (curr_lexer->m_string_text.empty ())                          \
         break;                                                         \
                                                                        \
       int retval = curr_lexer->handle_token (curr_lexer->m_string_text, \
                                              SQ_STRING);               \
                                                                        \
       curr_lexer->m_string_text = "";                                  \
       curr_lexer->m_command_arg_paren_count = 0;                       \
                                                                        \
       yyless (0);                                                      \
                                                                        \
       return retval;                                                   \
     }                                                                  \
   while (0)

#define HANDLE_IDENTIFIER(pattern, get_set)                             \
   do                                                                   \
     {                                                                  \
       curr_lexer->lexer_debug (pattern);                               \
                                                                        \
       int tok = curr_lexer->previous_token_value ();                   \
                                                                        \
       if (curr_lexer->whitespace_is_significant ()                     \
           && curr_lexer->space_follows_previous_token ()               \
           && ! (tok == '[' || tok == '{'                               \
                 || curr_lexer->previous_token_is_binop ()))            \
         {                                                              \
           yyless (0);                                                  \
           unput (',');                                                 \
         }                                                              \
       else                                                             \
         {                                                              \
           if (! curr_lexer->m_looking_at_decl_list                     \
               && curr_lexer->previous_token_may_be_command ())         \
             {                                                          \
               yyless (0);                                              \
               curr_lexer->push_start_state (COMMAND_START);            \
             }                                                          \
           else                                                         \
             {                                                          \
               if (get_set)                                             \
                 {                                                      \
                   yyless (3);                                          \
                   curr_lexer->m_maybe_classdef_get_set_method = false; \
                 }                                                      \
                                                                        \
               int id_tok = curr_lexer->handle_identifier ();           \
                                                                        \
               if (id_tok >= 0)                                         \
                 return curr_lexer->count_token_internal (id_tok);      \
             }                                                          \
         }                                                              \
     }                                                                  \
   while (0)

static bool Vdisplay_tokens = false;

static unsigned int Vtoken_count = 0;

// Internal variable for lexer debugging state.
static bool lexer_debug_flag = false;

#line 1029 "libinterp/parse-tree/lex.cc"

#define INITIAL 0
#define COMMAND_START 1
#define MATRIX_START 2
#define INPUT_FILE_START 3
#define BLOCK_COMMENT_START 4
#define LINE_COMMENT_START 5
#define DQ_STRING_START 6
#define SQ_STRING_START 7
#define FQ_IDENT_START 8

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

/* Holds the entire state of the reentrant scanner. */
struct yyguts_t
    {

    /* User-defined. Not touched by flex. */
    YY_EXTRA_TYPE yyextra_r;

    /* The rest are the same as the globals declared in the non-reentrant scanner. */
    FILE *yyin_r, *yyout_r;
    size_t yy_buffer_stack_top; /**< index of top of stack. */
    size_t yy_buffer_stack_max; /**< capacity of stack. */
    YY_BUFFER_STATE * yy_buffer_stack; /**< Stack as an array. */
    char yy_hold_char;
    int yy_n_chars;
    int yyleng_r;
    char *yy_c_buf_p;
    int yy_init;
    int yy_start;
    int yy_did_buffer_switch_on_eof;
    int yy_start_stack_ptr;
    int yy_start_stack_depth;
    int *yy_start_stack;
    yy_state_type yy_last_accepting_state;
    char* yy_last_accepting_cpos;

    int yylineno_r;
    int yy_flex_debug_r;

    char *yytext_r;
    int yy_more_flag;
    int yy_more_len;

    YYSTYPE * yylval_r;

    }; /* end struct yyguts_t */

static int yy_init_globals (yyscan_t yyscanner );

    /* This must go here because YYSTYPE and YYLTYPE are included
     * from bison output in section 1.*/
    #    define yylval yyg->yylval_r
    
int octave_lex_init (yyscan_t* scanner);

int octave_lex_init_extra (YY_EXTRA_TYPE user_defined,yyscan_t* scanner);

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int octave_lex_destroy (yyscan_t yyscanner );

int octave_get_debug (yyscan_t yyscanner );

void octave_set_debug (int debug_flag ,yyscan_t yyscanner );

YY_EXTRA_TYPE octave_get_extra (yyscan_t yyscanner );

void octave_set_extra (YY_EXTRA_TYPE user_defined ,yyscan_t yyscanner );

FILE *octave_get_in (yyscan_t yyscanner );

void octave_set_in  (FILE * _in_str ,yyscan_t yyscanner );

FILE *octave_get_out (yyscan_t yyscanner );

void octave_set_out  (FILE * _out_str ,yyscan_t yyscanner );

			int octave_get_leng (yyscan_t yyscanner );

char *octave_get_text (yyscan_t yyscanner );

int octave_get_lineno (yyscan_t yyscanner );

void octave_set_lineno (int _line_number ,yyscan_t yyscanner );

int octave_get_column  (yyscan_t yyscanner );

void octave_set_column (int _column_no ,yyscan_t yyscanner );

YYSTYPE * octave_get_lval (yyscan_t yyscanner );

void octave_set_lval (YYSTYPE * yylval_param ,yyscan_t yyscanner );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int octave_wrap (yyscan_t yyscanner );
#else
extern int octave_wrap (yyscan_t yyscanner );
#endif
#endif

#ifndef YY_NO_UNPUT
    
    static void yyunput (int c,char *buf_ptr  ,yyscan_t yyscanner);
    
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int ,yyscan_t yyscanner);
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * ,yyscan_t yyscanner);
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int yyinput (yyscan_t yyscanner );
#else
static int input (yyscan_t yyscanner );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, (size_t) yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = (int) fread(buf, 1, max_size, yyin))==0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg , yyscanner)
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int octave_lex \
               (YYSTYPE * yylval_param ,yyscan_t yyscanner);

#define YY_DECL int octave_lex \
               (YYSTYPE * yylval_param , yyscan_t yyscanner)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

#define YY_RULE_SETUP \
	if ( yyleng > 0 ) \
		YY_CURRENT_BUFFER_LVALUE->yy_at_bol = \
				(yytext[yyleng - 1] == '\n'); \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    yylval = yylval_param;

	if ( !yyg->yy_init )
		{
		yyg->yy_init = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! yyg->yy_start )
			yyg->yy_start = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			octave_ensure_buffer_stack (yyscanner);
			YY_CURRENT_BUFFER_LVALUE =
				octave__create_buffer(yyin,YY_BUF_SIZE ,yyscanner);
		}

		octave__load_buffer_state(yyscanner );
		}

	{
#line 352 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"



// Make script and function files start with an invalid token. This makes
// the parser go down a special path.


#line 1323 "libinterp/parse-tree/lex.cc"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
		yy_cp = yyg->yy_c_buf_p;

		/* Support of yytext. */
		*yy_cp = yyg->yy_hold_char;

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = yyg->yy_start;
		yy_current_state += YY_AT_BOL();
yy_match:
		do
			{
			YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)] ;
			if ( yy_accept[yy_current_state] )
				{
				yyg->yy_last_accepting_state = yy_current_state;
				yyg->yy_last_accepting_cpos = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 266 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (flex_int16_t) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 820 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = yyg->yy_last_accepting_cpos;
			yy_current_state = yyg->yy_last_accepting_state;
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = yyg->yy_hold_char;
			yy_cp = yyg->yy_last_accepting_cpos;
			yy_current_state = yyg->yy_last_accepting_state;
			goto yy_find_action;

case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 359 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<INPUT_FILE_START>{ANY_INCLUDING_NL}");

    curr_lexer->xunput (yytext[0]);

    // May be reset later if we see "function" or "classdef" appears
    // as the first token.
    curr_lexer->m_reading_script_file = true;

    curr_lexer->pop_start_state ();

    return curr_lexer->show_token (INPUT_FILE);
  }
	YY_BREAK
case YY_STATE_EOF(INPUT_FILE_START):
#line 373 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<INPUT_FILE_START><<EOF>>");

    // May be reset later if we see "function" or "classdef" appears
    // as the first token.
    curr_lexer->m_reading_script_file = true;

    curr_lexer->pop_start_state ();

    return curr_lexer->show_token (INPUT_FILE);
  }
	YY_BREAK

// Help and other command-style functions.


// Commands can be continued on a second line using the ellipsis.
// If an argument is in construction, it is completed.

case 2:
/* rule 2 can match eol */
YY_RULE_SETUP
#line 394 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<COMMAND_START>(\\.\\.\\.){ANY_EXCEPT_NL}*{NL}");

    COMMAND_ARG_FINISH;

    curr_lexer->m_input_line_number++;
    curr_lexer->m_current_input_column = 1;

    HANDLE_STRING_CONTINUATION;
  }
	YY_BREAK

// Commands normally end at the end of a line or a semicolon.

case 3:
/* rule 3 can match eol */
YY_RULE_SETUP
#line 409 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<COMMAND_START>({CCHAR}{ANY_EXCEPT_NL}*)?{NL}");

    COMMAND_ARG_FINISH;

    curr_lexer->m_input_line_number++;
    curr_lexer->m_current_input_column = 1;
    curr_lexer->m_looking_for_object_index = false;
    curr_lexer->m_at_beginning_of_statement = true;
    curr_lexer->pop_start_state ();

    return curr_lexer->handle_token ('\n');
  }
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 423 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<COMMAND_START>[\\,\\;]");

    if (yytext[0] != ',' || curr_lexer->m_command_arg_paren_count == 0)
      {
        COMMAND_ARG_FINISH;
        curr_lexer->m_looking_for_object_index = false;
        curr_lexer->m_at_beginning_of_statement = true;
        curr_lexer->pop_start_state ();
        return curr_lexer->handle_token (yytext[0]);
      }
    else
      curr_lexer->m_string_text += yytext;

    curr_lexer->m_current_input_column += yyleng;
  }
	YY_BREAK

// Unbalanced parentheses serve as pseudo-quotes: they are included in
// the final argument string, but they cause parentheses and quotes to
// be slurped into that argument as well.

case 5:
YY_RULE_SETUP
#line 446 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<COMMAND_START>[\\(\\[\\{]+");

    curr_lexer->m_command_arg_paren_count += yyleng;
    curr_lexer->m_string_text += yytext;
    curr_lexer->m_current_input_column += yyleng;
  }
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 454 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
   curr_lexer->lexer_debug ("<COMMAND_START>[\\)\\]\\}]+");

   curr_lexer->m_command_arg_paren_count -= yyleng;
   curr_lexer->m_string_text += yytext;
   curr_lexer->m_current_input_column += yyleng;
}
	YY_BREAK

// Handle quoted strings.  Quoted strings that are not separated by
// whitespace from other argument text are combined with that previous
// text.  For instance,
//
//   command 'text1'"text2"
//
// has a single argument text1text2, not two separate arguments.
// That's why we must test to see if we are in command argument mode
// when processing the end of a string.

case 7:
YY_RULE_SETUP
#line 474 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<COMMAND_START>[\\\"\\']");

    if (curr_lexer->m_command_arg_paren_count == 0)
      curr_lexer->begin_string (yytext[0] == '"'
                                ? DQ_STRING_START : SQ_STRING_START);
    else
      curr_lexer->m_string_text += yytext;

    curr_lexer->m_current_input_column += yyleng;
  }
	YY_BREAK

// In standard command argument processing, whitespace separates
// arguments.  In the presence of unbalanced parentheses, it is
// incorporated into the argument.

case 8:
YY_RULE_SETUP
#line 492 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<COMMAND_START>{S}*");

    if (curr_lexer->m_command_arg_paren_count == 0)
      COMMAND_ARG_FINISH;
    else
      curr_lexer->m_string_text += yytext;

    curr_lexer->m_current_input_column += yyleng;
  }
	YY_BREAK

// Everything else is slurped into the command arguments.

case 9:
YY_RULE_SETUP
#line 507 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<COMMAND_START>([\\.]|[^#% \\t\\r\\n\\.\\,\\;\\\"\\'\\(\\[\\{\\}\\]\\)]*");

    curr_lexer->m_string_text += yytext;
    curr_lexer->m_current_input_column += yyleng;
  }
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 514 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<MATRIX_START>{S}*");

    curr_lexer->mark_previous_token_trailing_space ();
  }
	YY_BREAK
case 11:
/* rule 11 can match eol */
YY_RULE_SETUP
#line 520 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<MATRIX_START>{NL}");

    curr_lexer->m_input_line_number++;
    curr_lexer->m_current_input_column = 1;

    if (curr_lexer->m_nesting_level.is_paren ())
      curr_lexer->warn_language_extension ("bare newline inside parentheses");
    else
      {
        int tok = curr_lexer->previous_token_value ();

        if (! (tok == ';' || tok == '[' || tok == '{'))
          {
            curr_lexer->xunput (';');
            // Adjust for semicolon that was not really in the input stream.
            curr_lexer->m_current_input_column--;
          }
      }
  }
	YY_BREAK

// For this and the next two rules, we're looking at ']', and we
// need to know if the next token is '=' or '=='.
//
// It would have been so much easier if the delimiters were simply
// different for the expression on the left hand side of the equals
// operator.
//
// It's also a pain in the ass to decide whether to insert a comma
// after seeing a ']' character...

// FIXME: we need to handle block comments here.

case 12:
YY_RULE_SETUP
#line 555 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<MATRIX_START>\\]");

    curr_lexer->m_looking_at_object_index.pop_front ();

    curr_lexer->m_looking_for_object_index = true;
    curr_lexer->m_at_beginning_of_statement = false;

    curr_lexer->handle_close_bracket (']');

    return curr_lexer->count_token (']');
  }
	YY_BREAK

// FIXME: we need to handle block comments here.

case 13:
YY_RULE_SETUP
#line 572 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<MATRIX_START>\\}*");

    curr_lexer->m_looking_at_object_index.pop_front ();

    curr_lexer->m_looking_for_object_index = true;
    curr_lexer->m_at_beginning_of_statement = false;

    curr_lexer->handle_close_bracket ('}');

    return curr_lexer->count_token ('}');
  }
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 585 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("\\[");

        bool unput_comma = false;

    if (curr_lexer->whitespace_is_significant ()
        && curr_lexer->space_follows_previous_token ())
      {
        int tok = curr_lexer->previous_token_value ();

        if (! (tok == '[' || tok == '{'
               || curr_lexer->previous_token_is_binop ()))
          unput_comma = true;
      }

    if (unput_comma)
      {
        yyless (0);
        curr_lexer->xunput (',');
        // Adjust for comma that was not really in the input stream.
        curr_lexer->m_current_input_column--;
      }
    else
      {
        curr_lexer->m_nesting_level.bracket ();

        curr_lexer->m_looking_at_object_index.push_front (false);

        curr_lexer->m_current_input_column += yyleng;
        curr_lexer->m_looking_for_object_index = false;
        curr_lexer->m_at_beginning_of_statement = false;

        if (curr_lexer->m_defining_func
            && ! curr_lexer->m_parsed_function_name.top ())
          curr_lexer->m_looking_at_return_list = true;
        else
          curr_lexer->m_looking_at_matrix_or_assign_lhs = true;

        curr_lexer->decrement_promptflag ();

        curr_lexer->m_bracketflag++;

        curr_lexer->push_start_state (MATRIX_START);

        return curr_lexer->count_token ('[');
      }
  }
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 633 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("\\]");

    curr_lexer->m_nesting_level.remove ();

    curr_lexer->m_looking_at_object_index.pop_front ();

    curr_lexer->m_looking_for_object_index = true;
    curr_lexer->m_at_beginning_of_statement = false;

    return curr_lexer->handle_token (']');
  }
	YY_BREAK

// Gobble comments.


// Start of a block comment.  If the comment marker appears immediately
// after a block of full-line comments, finish the full line comment
// block.

case 16:
/* rule 16 can match eol */
YY_RULE_SETUP
#line 656 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("^{S}*{CCHAR}\\{{S}*{NL}");

    yyless (0);

    if (curr_lexer->start_state () == LINE_COMMENT_START)
      {
        if (! curr_lexer->m_comment_text.empty ())
          curr_lexer->finish_comment (octave::comment_elt::full_line);

        curr_lexer->pop_start_state ();
      }

    curr_lexer->decrement_promptflag ();

    curr_lexer->push_start_state (BLOCK_COMMENT_START);

  }
	YY_BREAK
case 17:
/* rule 17 can match eol */
YY_RULE_SETUP
#line 675 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<BLOCK_COMMENT_START>^{S}*{CCHAR}\\{{S}*{NL}");

    curr_lexer->m_input_line_number++;
    curr_lexer->m_current_input_column = 1;

    if (curr_lexer->m_block_comment_nesting_level)
      curr_lexer->m_comment_text = "\n";

    curr_lexer->m_block_comment_nesting_level++;
  }
	YY_BREAK

// End of a block comment.  If this block comment is nested inside
// another, wait for the outermost block comment block to be closed
// before storing the comment.

case 18:
/* rule 18 can match eol */
YY_RULE_SETUP
#line 693 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<BLOCK_COMMENT_START>^{S}*{CCHAR}\\}{S}*{NL}");

    curr_lexer->m_input_line_number++;
    curr_lexer->m_current_input_column = 1;

    if (curr_lexer->m_block_comment_nesting_level > 1)
      curr_lexer->m_comment_text = "\n";
    else
      curr_lexer->finish_comment (octave::comment_elt::block);

    curr_lexer->m_block_comment_nesting_level--;

    if (curr_lexer->m_block_comment_nesting_level == 0)
      {
        curr_lexer->increment_promptflag ();

        curr_lexer->pop_start_state ();
      }
  }
	YY_BREAK

// Body of a block comment.

case 19:
/* rule 19 can match eol */
YY_RULE_SETUP
#line 718 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<BLOCK_COMMENT_START>{ANY_EXCEPT_NL}*{NL}");

    curr_lexer->m_input_line_number++;
    curr_lexer->m_current_input_column = 1;
    curr_lexer->m_comment_text += yytext;
  }
	YY_BREAK

// Full-line or end-of-line comment.

case 20:
/* rule 20 can match eol */
YY_RULE_SETUP
#line 730 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("{S}*{CCHAR}{ANY_EXCEPT_NL}*{NL}");

    curr_lexer->push_start_state (LINE_COMMENT_START);
    yyless (0);
  }
	YY_BREAK
case 21:
/* rule 21 can match eol */
YY_RULE_SETUP
#line 737 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<LINE_COMMENT_START>{S}*{CCHAR}{ANY_EXCEPT_NL}*{NL}");

    bool full_line_comment = curr_lexer->m_current_input_column == 1;
    curr_lexer->m_input_line_number++;
    curr_lexer->m_current_input_column = 1;

    bool have_space = false;
    size_t len = yyleng;
    size_t i = 0;
    while (i < len)
      {
        char c = yytext[i];
        if (c == ' ' || c == '\t')
          {
            have_space = true;
            i++;
          }
        else
          break;
      }

    size_t num_comment_chars = 0;

    while (i < len)
      {
        char c = yytext[i];
        if (c == '#' || c == '%')
          {
            num_comment_chars++;
            i++;
          }
        else
          break;
      }

    curr_lexer->m_comment_text += &yytext[i];

    if (full_line_comment)
      {
        if (num_comment_chars == 1 && yytext[i++] == '{')
          {
            bool looks_like_block_comment = true;

            while (i < len)
              {
                char c = yytext[i++];
                if (! (c == ' ' || c == '\t' || c == '\n' || c == '\r'))
                  {
                    looks_like_block_comment = false;
                    break;
                  }
              }

            if (looks_like_block_comment)
              {
                yyless (0);

                curr_lexer->finish_comment (octave::comment_elt::full_line);

                curr_lexer->pop_start_state ();
              }
          }
      }
    else
      {
        if (have_space)
          curr_lexer->mark_previous_token_trailing_space ();

        curr_lexer->finish_comment (octave::comment_elt::end_of_line);

        curr_lexer->pop_start_state ();

        curr_lexer->xunput ('\n');
        curr_lexer->m_input_line_number--;
      }
  }
	YY_BREAK

// End of a block of full-line comments.

case 22:
/* rule 22 can match eol */
YY_RULE_SETUP
#line 819 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<LINE_COMMENT_START>{ANY_INCLUDING_NL}");

    curr_lexer->xunput (yytext[0]);

    curr_lexer->finish_comment (octave::comment_elt::full_line);

    curr_lexer->pop_start_state ();
  }
	YY_BREAK

// End of a block of full-line comments.

case YY_STATE_EOF(LINE_COMMENT_START):
#line 833 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<LINE_COMMENT_START><<EOF>>");

    curr_lexer->finish_comment (octave::comment_elt::full_line);

    curr_lexer->pop_start_state ();
  }
	YY_BREAK

// Double-quoted character strings.

case 23:
YY_RULE_SETUP
#line 845 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>\\\"\\\"");

    curr_lexer->m_current_input_column += yyleng;
    curr_lexer->m_string_text += '"';
  }
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 852 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>\\\"");

    curr_lexer->m_current_input_column++;

    curr_lexer->pop_start_state ();

    if (curr_lexer->start_state() != COMMAND_START)
      {
        curr_lexer->m_looking_for_object_index = true;
        curr_lexer->m_at_beginning_of_statement = false;

        curr_lexer->push_token (new octave::token (DQ_STRING,
                                                   curr_lexer->m_string_text,
                                                   curr_lexer->m_string_line,
                                                   curr_lexer->m_string_column));

        curr_lexer->m_string_text = "";

        return curr_lexer->count_token_internal (DQ_STRING);
      }
  }
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 875 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>\\\\[0-7]{1,3}");

    curr_lexer->m_current_input_column += yyleng;

    int result;
    sscanf (yytext+1, "%o", &result);

    if (result > 0xff)
      {
        octave::token *tok
          = new octave::token (LEXICAL_ERROR,
                               "invalid octal escape sequence in character string",
                               curr_lexer->m_input_line_number,
                               curr_lexer->m_current_input_column);

        curr_lexer->push_token (tok);

        return curr_lexer->count_token_internal (LEXICAL_ERROR);
      }
    else
      curr_lexer->m_string_text += static_cast<unsigned char> (result);
  }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 899 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>\\\\x[0-9a-fA-F]+");

    curr_lexer->m_current_input_column += yyleng;

    int result;
    sscanf (yytext+2, "%x", &result);

    // Truncate the value silently instead of checking the range like
    // we do for octal above.  This is to match C/C++ where any number
    // of digits is allowed but the value is implementation-defined if
    // it exceeds the range of the character type.
    curr_lexer->m_string_text += static_cast<unsigned char> (result);
  }
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 914 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>\"\\\\a\"");

    curr_lexer->m_current_input_column += yyleng;
    curr_lexer->m_string_text += '\a';
  }
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 921 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>\"\\\\b\"");

    curr_lexer->m_current_input_column += yyleng;
    curr_lexer->m_string_text += '\b';
  }
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 928 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>\"\\\\f\"");

    curr_lexer->m_current_input_column += yyleng;
    curr_lexer->m_string_text += '\f';
  }
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 935 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>\"\\\\n\"");

    curr_lexer->m_current_input_column += yyleng;
    curr_lexer->m_string_text += '\n';
  }
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 942 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>\"\\\\r\"");

    curr_lexer->m_current_input_column += yyleng;
    curr_lexer->m_string_text += '\r';
  }
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 949 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>\"\\\\t\"");

    curr_lexer->m_current_input_column += yyleng;
    curr_lexer->m_string_text += '\t';
  }
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 956 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>\"\\\\v\"");

    curr_lexer->m_current_input_column += yyleng;
    curr_lexer->m_string_text += '\v';
  }
	YY_BREAK
case 34:
/* rule 34 can match eol */
YY_RULE_SETUP
#line 963 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>(\\.\\.\\.){S}*{NL}");

    static const char *msg = "'...' continuations in double-quoted character strings are obsolete and will not be allowed in a future version of Octave; please use '\\' instead";

    std::string nm = curr_lexer->m_fcn_file_full_name;

    if (nm.empty ())
      warning_with_id ("Octave:deprecated-syntax", "%s", msg);
    else
      warning_with_id ("Octave:deprecated-syntax",
                       "%s; near line %d of file '%s'", msg,
                       curr_lexer->m_input_line_number, nm.c_str ());

    HANDLE_STRING_CONTINUATION;
  }
	YY_BREAK
case 35:
/* rule 35 can match eol */
YY_RULE_SETUP
#line 980 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>\\\\{S}+{NL}");

    static const char *msg = "white space and comments after continuation markers in double-quoted character strings are obsolete and will not be allowed in a future version of Octave";

    std::string nm = curr_lexer->m_fcn_file_full_name;

    if (nm.empty ())
      warning_with_id ("Octave:deprecated-syntax", "%s", msg);
    else
      warning_with_id ("Octave:deprecated-syntax",
                       "%s; near line %d of file '%s'", msg,
                       curr_lexer->m_input_line_number, nm.c_str ());

    HANDLE_STRING_CONTINUATION;
  }
	YY_BREAK
case 36:
/* rule 36 can match eol */
YY_RULE_SETUP
#line 997 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>\\\\{NL}");

    HANDLE_STRING_CONTINUATION;
  }
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 1003 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>\\\\.");

    curr_lexer->m_current_input_column += yyleng;
    curr_lexer->m_string_text += yytext[1];
  }
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 1010 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>\\.");

    curr_lexer->m_current_input_column++;
    curr_lexer->m_string_text += yytext[0];
  }
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 1017 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>[^\\.\\\\\\r\\n\\\"]+");

    curr_lexer->m_current_input_column += yyleng;
    curr_lexer->m_string_text += yytext;
  }
	YY_BREAK
case 40:
/* rule 40 can match eol */
YY_RULE_SETUP
#line 1024 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>{NL}");

    octave::token *tok
      = new octave::token (LEXICAL_ERROR,
                           "unterminated character string constant",
                           curr_lexer->m_input_line_number,
                           curr_lexer->m_current_input_column);

    curr_lexer->push_token (tok);

    curr_lexer->m_input_line_number++;
    curr_lexer->m_current_input_column = 1;

    return curr_lexer->count_token_internal (LEXICAL_ERROR);
  }
	YY_BREAK

// Single-quoted character strings.

case 41:
YY_RULE_SETUP
#line 1045 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<SQ_STRING_START>\\'\\'");

    curr_lexer->m_current_input_column += yyleng;
    curr_lexer->m_string_text += '\'';
  }
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 1052 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<SQ_STRING_START>\\'");

    curr_lexer->m_current_input_column++;

    curr_lexer->pop_start_state ();

    if (curr_lexer->start_state() != COMMAND_START)
      {
        curr_lexer->m_looking_for_object_index = true;
        curr_lexer->m_at_beginning_of_statement = false;

        curr_lexer->push_token (new octave::token (SQ_STRING,
                                                   curr_lexer->m_string_text,
                                                   curr_lexer->m_string_line,
                                                   curr_lexer->m_string_column));

        curr_lexer->m_string_text = "";

        return curr_lexer->count_token_internal (SQ_STRING);
      }
  }
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 1075 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<SQ_STRING_START>[^\\'\\n\\r]+");

    curr_lexer->m_current_input_column += yyleng;
    curr_lexer->m_string_text += yytext;
  }
	YY_BREAK
case 44:
/* rule 44 can match eol */
YY_RULE_SETUP
#line 1082 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<SQ_STRING_START>{NL}");

    octave::token *tok
      = new octave::token (LEXICAL_ERROR,
                           "unterminated character string constant",
                           curr_lexer->m_input_line_number,
                           curr_lexer->m_current_input_column);

    curr_lexer->push_token (tok);

    curr_lexer->m_input_line_number++;
    curr_lexer->m_current_input_column = 1;

    return curr_lexer->count_token_internal (LEXICAL_ERROR);
  }
	YY_BREAK

// Fully-qualified identifiers (used for classdef).

case 45:
YY_RULE_SETUP
#line 1103 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<FQ_IDENT_START>{FQIDENT}");
    curr_lexer->pop_start_state ();

    int id_tok = curr_lexer->handle_fq_identifier ();

    if (id_tok >= 0)
      {
        curr_lexer->m_looking_for_object_index = true;

        return curr_lexer->count_token_internal (id_tok);
      }
  }
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 1117 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->m_current_input_column += yyleng;

    curr_lexer->mark_previous_token_trailing_space ();
  }
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 1123 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    yyless (0);
    curr_lexer->pop_start_state ();
  }
	YY_BREAK

// Imaginary numbers.

case 48:
YY_RULE_SETUP
#line 1132 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("{NUMBER}{Im}");

    if (curr_lexer->previous_token_may_be_command ()
        &&  curr_lexer->space_follows_previous_token ())
      {
        yyless (0);
        curr_lexer->push_start_state (COMMAND_START);
      }
    else
      {
        int tok = curr_lexer->previous_token_value ();

        if (curr_lexer->whitespace_is_significant ()
            && curr_lexer->space_follows_previous_token ()
            && ! (tok == '[' || tok == '{'
                  || curr_lexer->previous_token_is_binop ()))
          {
            yyless (0);
            unput (',');
          }
        else
          {
            curr_lexer->handle_number ();
            return curr_lexer->count_token_internal (IMAG_NUM);
          }
      }
  }
	YY_BREAK

// Real numbers.  Don't grab the '.' part of a dot operator as part of
// the constant.

case 49:
*yy_cp = yyg->yy_hold_char; /* undo effects of setting up yytext */
yyg->yy_c_buf_p = yy_cp -= 2;
YY_DO_BEFORE_ACTION; /* set up yytext again */
#line 1167 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
case 50:
YY_RULE_SETUP
#line 1167 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("{D}{D_}*/\\.[\\*/\\\\^\\']|{NUMBER}");

    if (curr_lexer->previous_token_may_be_command ()
        &&  curr_lexer->space_follows_previous_token ())
      {
        yyless (0);
        curr_lexer->push_start_state (COMMAND_START);
      }
    else
      {
        int tok = curr_lexer->previous_token_value ();

        if (curr_lexer->whitespace_is_significant ()
            && curr_lexer->space_follows_previous_token ()
            && ! (tok == '[' || tok == '{'
                  || curr_lexer->previous_token_is_binop ()))
          {
            yyless (0);
            unput (',');
          }
        else
          {
            curr_lexer->handle_number ();
            return curr_lexer->count_token_internal (NUM);
          }
      }
  }
	YY_BREAK

// Eat whitespace.  Whitespace inside matrix constants is handled by
// the <MATRIX_START> start state code above.

case 51:
YY_RULE_SETUP
#line 1201 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->m_current_input_column += yyleng;

    curr_lexer->mark_previous_token_trailing_space ();
  }
	YY_BREAK

// Continuation lines.  Allow arbitrary text after continuations.

case 52:
/* rule 52 can match eol */
YY_RULE_SETUP
#line 1211 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("\\.\\.\\.{ANY_EXCEPT_NL}*{NL}");

    curr_lexer->handle_continuation ();
  }
	YY_BREAK

// Deprecated C preprocessor style continuation markers.

case 53:
/* rule 53 can match eol */
#line 1222 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
case 54:
/* rule 54 can match eol */
YY_RULE_SETUP
#line 1222 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("\\\\{S}*{NL}|\\\\{S}*{CCHAR}{ANY_EXCEPT_NL}*{NL}");

    static const char *msg = "using continuation marker \\ outside of double quoted strings is deprecated and will be removed from a future version of Octave, use ... instead";

    std::string nm = curr_lexer->m_fcn_file_full_name;

    if (nm.empty ())
      warning_with_id ("Octave:deprecated-syntax", "%s", msg);
    else
      warning_with_id ("Octave:deprecated-syntax",
                       "%s; near line %d of file '%s'", msg,
                       curr_lexer->m_input_line_number, nm.c_str ());

    curr_lexer->handle_continuation ();
  }
	YY_BREAK

// End of file.

case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(COMMAND_START):
case YY_STATE_EOF(MATRIX_START):
case YY_STATE_EOF(BLOCK_COMMENT_START):
case YY_STATE_EOF(DQ_STRING_START):
case YY_STATE_EOF(SQ_STRING_START):
case YY_STATE_EOF(FQ_IDENT_START):
#line 1243 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
   return curr_lexer->handle_end_of_input ();
  }
	YY_BREAK

// Identifiers.

// Don't allow get and set to be recognized as keywords if they are
// followed by "(".

case 55:
YY_RULE_SETUP
#line 1254 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    HANDLE_IDENTIFIER ("(set|get){S}*\\(", true);
  }
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 1258 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    HANDLE_IDENTIFIER ("{IDENT}", false);
  }
	YY_BREAK

// Superclass method identifiers.

case 57:
YY_RULE_SETUP
#line 1266 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("{IDENT}@{FQIDENT}");

    if (curr_lexer->previous_token_may_be_command ())
      {
        yyless (0);
        curr_lexer->push_start_state (COMMAND_START);
      }
    else
      {
        int id_tok = curr_lexer->handle_superclass_identifier ();

        if (id_tok >= 0)
          {
            curr_lexer->m_looking_for_object_index = true;

            return curr_lexer->count_token_internal (id_tok);
          }
      }
  }
	YY_BREAK

// Metaclass query

case 58:
YY_RULE_SETUP
#line 1291 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("\\?{FQIDENT}");

    if (curr_lexer->previous_token_may_be_command ()
        &&  curr_lexer->space_follows_previous_token ())
      {
        yyless (0);
        curr_lexer->push_start_state (COMMAND_START);
      }
    else
      {
        int id_tok = curr_lexer->handle_meta_identifier ();

        if (id_tok >= 0)
          {
            curr_lexer->m_looking_for_object_index = true;

            return curr_lexer->count_token_internal (id_tok);
          }
      }
  }
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 1313 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("@");

    if (curr_lexer->previous_token_may_be_command ()
        &&  curr_lexer->space_follows_previous_token ())
      {
        yyless (0);
        curr_lexer->push_start_state (COMMAND_START);
      }
    else
      {
        int tok = curr_lexer->previous_token_value ();

        if (curr_lexer->whitespace_is_significant ()
            && curr_lexer->space_follows_previous_token ()
            && ! (tok == '[' || tok == '{'
                  || curr_lexer->previous_token_is_binop ()))
          {
            yyless (0);
            unput (',');
          }
        else
          {
            curr_lexer->m_current_input_column++;

            curr_lexer->m_looking_at_function_handle++;
            curr_lexer->m_looking_for_object_index = false;
            curr_lexer->m_at_beginning_of_statement = false;

            return curr_lexer->count_token ('@');
          }
      }
  }
	YY_BREAK

// A new line character.  New line characters inside matrix constants
// are handled by the <MATRIX_START> start state code above.  If closest
// nesting is inside parentheses, don't return a row separator.

case 60:
/* rule 60 can match eol */
YY_RULE_SETUP
#line 1353 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("{NL}");

    if (curr_lexer->m_nesting_level.is_paren ())
      {
        curr_lexer->m_input_line_number++;
        curr_lexer->m_current_input_column = 1;

        curr_lexer->m_at_beginning_of_statement = false;
        curr_lexer->warn_language_extension
          ("bare newline inside parentheses");
      }
    else if (curr_lexer->m_nesting_level.none ()
        || curr_lexer->m_nesting_level.is_anon_fcn_body ())
      {
        curr_lexer->m_input_line_number++;
        curr_lexer->m_current_input_column = 1;

        curr_lexer->m_at_beginning_of_statement = true;

        return curr_lexer->count_token ('\n');
      }
    else if (curr_lexer->m_nesting_level.is_bracket_or_brace ())
      {
        octave::token *tok
          = new octave::token (LEXICAL_ERROR,
                               "unexpected internal lexer error",
                               curr_lexer->m_input_line_number,
                               curr_lexer->m_current_input_column);

        curr_lexer->push_token (tok);

        curr_lexer->m_input_line_number++;
        curr_lexer->m_current_input_column = 1;

        return curr_lexer->count_token_internal (LEXICAL_ERROR);
      }
  }
	YY_BREAK

// Single quote can either be the beginning of a string or a transpose
// operator.

case 61:
YY_RULE_SETUP
#line 1397 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("'");

    if (curr_lexer->previous_token_may_be_command ()
        &&  curr_lexer->space_follows_previous_token ())
      {
        curr_lexer->m_current_input_column++;
        curr_lexer->push_start_state (COMMAND_START);
        curr_lexer->begin_string (SQ_STRING_START);
      }
    else if (curr_lexer->m_at_beginning_of_statement)
      {
        curr_lexer->m_current_input_column++;
        curr_lexer->begin_string (SQ_STRING_START);
      }
    else
      {
        int tok = curr_lexer->previous_token_value ();

        if (curr_lexer->whitespace_is_significant ())
          {
            if (curr_lexer->space_follows_previous_token ())
              {
                if (tok == '[' || tok == '{'
                    || curr_lexer->previous_token_is_binop ())
                  {
                    curr_lexer->m_current_input_column++;
                    curr_lexer->begin_string (SQ_STRING_START);
                  }
                else
                  {
                    yyless (0);
                    curr_lexer->xunput (',');
                    // Adjust for comma that was not really in the input stream.
                    curr_lexer->m_current_input_column--;
                  }
              }
            else
              {
                if (tok == '[' || tok == '{'
                    || curr_lexer->previous_token_is_binop ()
                    || curr_lexer->previous_token_is_keyword ())
                  {
                    curr_lexer->m_current_input_column++;
                    curr_lexer->begin_string (SQ_STRING_START);
                  }
                else
                  return curr_lexer->count_token (HERMITIAN);
              }
          }
        else
          {
            if (! tok || tok == '[' || tok == '{' || tok == '('
                || curr_lexer->previous_token_is_binop ()
                || curr_lexer->previous_token_is_keyword ())
              {
                curr_lexer->m_current_input_column++;
                curr_lexer->begin_string (SQ_STRING_START);
              }
            else
              return curr_lexer->count_token (HERMITIAN);
          }
      }
  }
	YY_BREAK

// Double quotes always begin strings.

case 62:
YY_RULE_SETUP
#line 1466 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("\\\"");

    if (curr_lexer->previous_token_may_be_command ()
        &&  curr_lexer->space_follows_previous_token ())
      {
        curr_lexer->m_current_input_column++;
        curr_lexer->push_start_state (COMMAND_START);
        curr_lexer->begin_string (DQ_STRING_START);
      }
    else
      {
        int tok = curr_lexer->previous_token_value ();

        if (curr_lexer->whitespace_is_significant ())
          {
            if (curr_lexer->space_follows_previous_token ())
              {
                if (tok == '[' || tok == '{'
                    || curr_lexer->previous_token_is_binop ())
                  {
                    curr_lexer->m_current_input_column++;
                    curr_lexer->begin_string (DQ_STRING_START);
                  }
                else
                  {
                    yyless (0);
                    curr_lexer->xunput (',');
                    // Adjust for comma that was not really in the input stream.
                    curr_lexer->m_current_input_column--;
                  }
              }
            else
              {
                curr_lexer->m_current_input_column++;
                curr_lexer->begin_string (DQ_STRING_START);
              }
          }
        else
          {
            curr_lexer->m_current_input_column++;
            curr_lexer->begin_string (DQ_STRING_START);
          }
      }
  }
	YY_BREAK

// Other operators.

case 63:
YY_RULE_SETUP
#line 1516 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_OP (":", ':', true); }
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 1517 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_OP (".+", EPLUS, false); }
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 1518 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_OP (".-", EMINUS, false); }
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 1519 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_OP (".*", EMUL, true); }
	YY_BREAK
case 67:
YY_RULE_SETUP
#line 1520 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("./", EDIV, true); }
	YY_BREAK
case 68:
YY_RULE_SETUP
#line 1521 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_OP (".\\", ELEFTDIV, true); }
	YY_BREAK
case 69:
YY_RULE_SETUP
#line 1522 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_OP (".^", EPOW, true); }
	YY_BREAK
case 70:
YY_RULE_SETUP
#line 1523 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_OP (".**", EPOW, false); }
	YY_BREAK
case 71:
YY_RULE_SETUP
#line 1524 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("<=", EXPR_LE, true); }
	YY_BREAK
case 72:
YY_RULE_SETUP
#line 1525 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("==", EXPR_EQ, true); }
	YY_BREAK
case 73:
YY_RULE_SETUP
#line 1526 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("~=", EXPR_NE, true); }
	YY_BREAK
case 74:
YY_RULE_SETUP
#line 1527 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("!=", EXPR_NE, false); }
	YY_BREAK
case 75:
YY_RULE_SETUP
#line 1528 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_OP (">=", EXPR_GE, true); }
	YY_BREAK
case 76:
YY_RULE_SETUP
#line 1529 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("&", EXPR_AND, true); }
	YY_BREAK
case 77:
YY_RULE_SETUP
#line 1530 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("|", EXPR_OR, true); }
	YY_BREAK
case 78:
YY_RULE_SETUP
#line 1531 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("<", EXPR_LT, true); }
	YY_BREAK
case 79:
YY_RULE_SETUP
#line 1532 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_OP (">", EXPR_GT, true); }
	YY_BREAK
case 80:
YY_RULE_SETUP
#line 1533 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("*", '*', true); }
	YY_BREAK
case 81:
YY_RULE_SETUP
#line 1534 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("/", '/', true); }
	YY_BREAK

// In Matlab, '\' may also trigger command syntax.

case 82:
YY_RULE_SETUP
#line 1540 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ return curr_lexer->handle_op ("\\", LEFTDIV); }
	YY_BREAK
case 83:
YY_RULE_SETUP
#line 1542 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("^", POW, true); }
	YY_BREAK
case 84:
YY_RULE_SETUP
#line 1543 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("**", POW, false); }
	YY_BREAK
case 85:
YY_RULE_SETUP
#line 1544 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("&&", EXPR_AND_AND, true); }
	YY_BREAK
case 86:
YY_RULE_SETUP
#line 1545 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("||", EXPR_OR_OR, true); }
	YY_BREAK
case 87:
YY_RULE_SETUP
#line 1547 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    bool at_beginning_of_statement
      = (! (curr_lexer->whitespace_is_significant ()
            || curr_lexer->m_looking_at_object_index.front ()));

    return curr_lexer->handle_op (";", ';', at_beginning_of_statement);
  }
	YY_BREAK
case 88:
YY_RULE_SETUP
#line 1555 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_UNARY_OP ("+", '+', true); }
	YY_BREAK
case 89:
YY_RULE_SETUP
#line 1556 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_UNARY_OP ("-", '-', true); }
	YY_BREAK
case 90:
YY_RULE_SETUP
#line 1558 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_UNARY_OP ("~", EXPR_NOT, true); }
	YY_BREAK
case 91:
YY_RULE_SETUP
#line 1559 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_UNARY_OP ("!", EXPR_NOT, false); }
	YY_BREAK
case 92:
YY_RULE_SETUP
#line 1561 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    bool at_beginning_of_statement
      = (! (curr_lexer->whitespace_is_significant ()
            || curr_lexer->m_looking_at_object_index.front ()));

    return curr_lexer->handle_op (",", ',', at_beginning_of_statement);
  }
	YY_BREAK
case 93:
YY_RULE_SETUP
#line 1569 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    return curr_lexer->handle_op (".'", TRANSPOSE, false);
  }
	YY_BREAK
case 94:
YY_RULE_SETUP
#line 1573 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_UNARY_OP ("++", PLUS_PLUS, false); }
	YY_BREAK
case 95:
YY_RULE_SETUP
#line 1574 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_UNARY_OP ("--", MINUS_MINUS, false); }
	YY_BREAK
case 96:
YY_RULE_SETUP
#line 1576 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("(");

    bool unput_comma = false;

    if (curr_lexer->whitespace_is_significant ()
        && curr_lexer->space_follows_previous_token ())
      {
        int tok = curr_lexer->previous_token_value ();

        if (! (tok == '[' || tok == '{'
               || curr_lexer->previous_token_is_binop ()))
          unput_comma = true;
      }

    if (unput_comma)
      {
        yyless (0);
        curr_lexer->xunput (',');
        // Adjust for comma that was not really in the input stream.
        curr_lexer->m_current_input_column--;
      }
    else
      {
        // If we are looking for an object index, then push TRUE for
        // m_looking_at_object_index.  Otherwise, just push whatever state
        // is current (so that we can pop it off the stack when we find
        // the matching close paren).

        curr_lexer->m_looking_at_object_index.push_front
          (curr_lexer->m_looking_for_object_index);

        curr_lexer->m_looking_at_indirect_ref = false;
        curr_lexer->m_looking_for_object_index = false;
        curr_lexer->m_at_beginning_of_statement = false;

        curr_lexer->m_nesting_level.paren ();
        curr_lexer->decrement_promptflag ();

        return curr_lexer->handle_token ('(');
      }
  }
	YY_BREAK
case 97:
YY_RULE_SETUP
#line 1619 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug (")");

    curr_lexer->m_nesting_level.remove ();
    curr_lexer->m_current_input_column++;

    curr_lexer->m_looking_at_object_index.pop_front ();

    curr_lexer->m_looking_for_object_index = true;
    curr_lexer->m_at_beginning_of_statement = false;

    if (curr_lexer->m_looking_at_anon_fcn_args)
      {
        curr_lexer->m_looking_at_anon_fcn_args = false;
        curr_lexer->m_nesting_level.anon_fcn_body ();
      }

    return curr_lexer->count_token (')');
  }
	YY_BREAK
case 98:
YY_RULE_SETUP
#line 1639 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug (".");

    if (curr_lexer->previous_token_may_be_command ()
        && curr_lexer->space_follows_previous_token ())
      {
        yyless (0);
        curr_lexer->push_start_state (COMMAND_START);
      }
    else
      {
        curr_lexer->m_looking_for_object_index = false;
        curr_lexer->m_at_beginning_of_statement = false;

        return curr_lexer->handle_token ('.');
      }
  }
	YY_BREAK

// = and op= operators.

case 99:
YY_RULE_SETUP
#line 1661 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->maybe_mark_previous_token_as_variable ();

    return curr_lexer->handle_op ("=", '=');
  }
	YY_BREAK
case 100:
YY_RULE_SETUP
#line 1667 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_COMPUTED_ASSIGN_OP ("+=", ADD_EQ); }
	YY_BREAK
case 101:
YY_RULE_SETUP
#line 1668 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_COMPUTED_ASSIGN_OP ("-=", SUB_EQ); }
	YY_BREAK
case 102:
YY_RULE_SETUP
#line 1669 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_COMPUTED_ASSIGN_OP ("*=", MUL_EQ); }
	YY_BREAK
case 103:
YY_RULE_SETUP
#line 1670 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_COMPUTED_ASSIGN_OP ("/=", DIV_EQ); }
	YY_BREAK
case 104:
YY_RULE_SETUP
#line 1671 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_COMPUTED_ASSIGN_OP ("\\=", LEFTDIV_EQ); }
	YY_BREAK
case 105:
YY_RULE_SETUP
#line 1672 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_COMPUTED_ASSIGN_OP (".+=", ADD_EQ); }
	YY_BREAK
case 106:
YY_RULE_SETUP
#line 1673 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_COMPUTED_ASSIGN_OP (".-=", SUB_EQ); }
	YY_BREAK
case 107:
YY_RULE_SETUP
#line 1674 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_COMPUTED_ASSIGN_OP (".*=", EMUL_EQ); }
	YY_BREAK
case 108:
YY_RULE_SETUP
#line 1675 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_COMPUTED_ASSIGN_OP ("./=", EDIV_EQ); }
	YY_BREAK
case 109:
YY_RULE_SETUP
#line 1676 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_COMPUTED_ASSIGN_OP (".\\=", ELEFTDIV_EQ); }
	YY_BREAK
case 110:
YY_RULE_SETUP
#line 1677 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_COMPUTED_ASSIGN_OP ("^=", POW_EQ); }
	YY_BREAK
case 111:
YY_RULE_SETUP
#line 1678 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_COMPUTED_ASSIGN_OP ("^=", POW_EQ); }
	YY_BREAK
case 112:
YY_RULE_SETUP
#line 1679 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_COMPUTED_ASSIGN_OP (".^=", EPOW_EQ); }
	YY_BREAK
case 113:
YY_RULE_SETUP
#line 1680 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_COMPUTED_ASSIGN_OP (".^=", EPOW_EQ); }
	YY_BREAK
case 114:
YY_RULE_SETUP
#line 1681 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_COMPUTED_ASSIGN_OP ("&=", AND_EQ); }
	YY_BREAK
case 115:
YY_RULE_SETUP
#line 1682 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{ CMD_OR_COMPUTED_ASSIGN_OP ("|=", OR_EQ); }
	YY_BREAK

// In Matlab, '{' may also trigger command syntax.

case 116:
YY_RULE_SETUP
#line 1688 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("{");

    bool unput_comma = false;

    if (curr_lexer->whitespace_is_significant ()
        && curr_lexer->space_follows_previous_token ())
      {
        int tok = curr_lexer->previous_token_value ();

        if (! (tok == '[' || tok == '{'
               || curr_lexer->previous_token_is_binop ()))
          unput_comma = true;
      }

    if (unput_comma)
      {
        yyless (0);
        curr_lexer->xunput (',');
        // Adjust for comma that was not really in the input stream.
        curr_lexer->m_current_input_column--;
      }
    else
      {
        curr_lexer->m_nesting_level.brace ();

        curr_lexer->m_looking_at_object_index.push_front
          (curr_lexer->m_looking_for_object_index);

        curr_lexer->m_current_input_column += yyleng;
        curr_lexer->m_looking_for_object_index = false;
        curr_lexer->m_at_beginning_of_statement = false;

        curr_lexer->decrement_promptflag ();

        curr_lexer->m_braceflag++;

        curr_lexer->push_start_state (MATRIX_START);

        return curr_lexer->count_token ('{');
      }
  }
	YY_BREAK
case 117:
YY_RULE_SETUP
#line 1731 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("}");

    curr_lexer->m_looking_at_object_index.pop_front ();

    curr_lexer->m_looking_for_object_index = true;
    curr_lexer->m_at_beginning_of_statement = false;

    curr_lexer->m_nesting_level.remove ();

    return curr_lexer->handle_token ('}');
  }
	YY_BREAK

// Unrecognized input is a lexical error.

case 118:
YY_RULE_SETUP
#line 1748 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug (".");

    curr_lexer->xunput (yytext[0]);

    int c = curr_lexer->text_yyinput ();

    if (c == 1)
      return -1;
    else if (c == EOF)
      return curr_lexer->handle_end_of_input ();
    else
      {
        std::ostringstream buf;

        buf << "invalid character '"
            << undo_string_escape (static_cast<char> (c))
            << "' (ASCII " << c << ")";

        octave::token *tok
          = new octave::token (LEXICAL_ERROR, buf.str (),
                               curr_lexer->m_input_line_number,
                               curr_lexer->m_current_input_column);

        curr_lexer->push_token (tok);

        curr_lexer->m_current_input_column++;

        return curr_lexer->count_token_internal (LEXICAL_ERROR);
      }
  }
	YY_BREAK

#if defined (HAVE_PRAGMA_GCC_DIAGNOSTIC)
   // Disable these warnings for flex code.
#  pragma GCC diagnostic ignored "-Wold-style-cast"
#  pragma GCC diagnostic ignored "-Wunused-parameter"
#endif

case 119:
YY_RULE_SETUP
#line 1788 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"
ECHO;
	YY_BREAK
#line 3202 "libinterp/parse-tree/lex.cc"

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - yyg->yytext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = yyg->yy_hold_char;
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * octave_lex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( yyg->yy_c_buf_p <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			yyg->yy_c_buf_p = yyg->yytext_ptr + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state( yyscanner );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state , yyscanner);

			yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++yyg->yy_c_buf_p;
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = yyg->yy_c_buf_p;
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer( yyscanner ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				yyg->yy_did_buffer_switch_on_eof = 0;

				if ( octave_wrap(yyscanner ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					yyg->yy_c_buf_p = yyg->yytext_ptr + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				yyg->yy_c_buf_p =
					yyg->yytext_ptr + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				yyg->yy_c_buf_p =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars];

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of octave_lex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = yyg->yytext_ptr;
	int number_to_move, i;
	int ret_val;

	if ( yyg->yy_c_buf_p > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( yyg->yy_c_buf_p - yyg->yytext_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (yyg->yy_c_buf_p - yyg->yytext_ptr - 1);

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) (yyg->yy_c_buf_p - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					octave_realloc((void *) b->yy_ch_buf,b->yy_buf_size + 2 ,yyscanner );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = NULL;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			yyg->yy_c_buf_p = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			yyg->yy_n_chars, num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	if ( yyg->yy_n_chars == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			octave_restart(yyin  ,yyscanner);
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((yyg->yy_n_chars + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		int new_size = yyg->yy_n_chars + number_to_move + (yyg->yy_n_chars >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) octave_realloc((void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf,new_size ,yyscanner );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
	}

	yyg->yy_n_chars += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	yyg->yytext_ptr = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (yyscan_t yyscanner)
{
	yy_state_type yy_current_state;
	char *yy_cp;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	yy_current_state = yyg->yy_start;
	yy_current_state += YY_AT_BOL();

	for ( yy_cp = yyg->yytext_ptr + YY_MORE_ADJ; yy_cp < yyg->yy_c_buf_p; ++yy_cp )
		{
		YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			yyg->yy_last_accepting_state = yy_current_state;
			yyg->yy_last_accepting_cpos = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 266 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (flex_int16_t) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state , yyscan_t yyscanner)
{
	int yy_is_jam;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner; /* This var may be unused depending upon options. */
	char *yy_cp = yyg->yy_c_buf_p;

	YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		yyg->yy_last_accepting_state = yy_current_state;
		yyg->yy_last_accepting_cpos = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 266 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (flex_int16_t) yy_c];
	yy_is_jam = (yy_current_state == 265);

	(void)yyg;
	return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT

    static void yyunput (int c, char * yy_bp , yyscan_t yyscanner)
{
	char *yy_cp;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    yy_cp = yyg->yy_c_buf_p;

	/* undo effects of setting up yytext */
	*yy_cp = yyg->yy_hold_char;

	if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		int number_to_move = yyg->yy_n_chars + 2;
		char *dest = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[
					YY_CURRENT_BUFFER_LVALUE->yy_buf_size + 2];
		char *source =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move];

		while ( source > YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars =
			yyg->yy_n_chars = (int) YY_CURRENT_BUFFER_LVALUE->yy_buf_size;

		if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;

	yyg->yytext_ptr = yy_bp;
	yyg->yy_hold_char = *yy_cp;
	yyg->yy_c_buf_p = yy_cp;
}

#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (yyscan_t yyscanner)
#else
    static int input  (yyscan_t yyscanner)
#endif

{
	int c;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	*yyg->yy_c_buf_p = yyg->yy_hold_char;

	if ( *yyg->yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( yyg->yy_c_buf_p < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			/* This was really a NUL. */
			*yyg->yy_c_buf_p = '\0';

		else
			{ /* need more input */
			int offset = yyg->yy_c_buf_p - yyg->yytext_ptr;
			++yyg->yy_c_buf_p;

			switch ( yy_get_next_buffer( yyscanner ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					octave_restart(yyin ,yyscanner);

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( octave_wrap(yyscanner ) )
						return 0;

					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput(yyscanner);
#else
					return input(yyscanner);
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					yyg->yy_c_buf_p = yyg->yytext_ptr + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) yyg->yy_c_buf_p;	/* cast for 8-bit char's */
	*yyg->yy_c_buf_p = '\0';	/* preserve yytext */
	yyg->yy_hold_char = *++yyg->yy_c_buf_p;

	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = (c == '\n');

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * @param yyscanner The scanner object.
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void octave_restart  (FILE * input_file , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! YY_CURRENT_BUFFER ){
        octave_ensure_buffer_stack (yyscanner);
		YY_CURRENT_BUFFER_LVALUE =
            octave__create_buffer(yyin,YY_BUF_SIZE ,yyscanner);
	}

	octave__init_buffer(YY_CURRENT_BUFFER,input_file ,yyscanner);
	octave__load_buffer_state(yyscanner );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * @param yyscanner The scanner object.
 */
    void octave__switch_to_buffer  (YY_BUFFER_STATE  new_buffer , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	/* TODO. We should be able to replace this entire function body
	 * with
	 *		octave_pop_buffer_state();
	 *		octave_push_buffer_state(new_buffer);
     */
	octave_ensure_buffer_stack (yyscanner);
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	octave__load_buffer_state(yyscanner );

	/* We don't actually know whether we did this switch during
	 * EOF (octave_wrap()) processing, but the only time this flag
	 * is looked at is after octave_wrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	yyg->yy_did_buffer_switch_on_eof = 1;
}

static void octave__load_buffer_state  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	yyg->yytext_ptr = yyg->yy_c_buf_p = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	yyg->yy_hold_char = *yyg->yy_c_buf_p;
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * @param yyscanner The scanner object.
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE octave__create_buffer  (FILE * file, int  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) octave_alloc(sizeof( struct yy_buffer_state ) ,yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in octave__create_buffer()" );

	b->yy_buf_size = (yy_size_t)size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) octave_alloc(b->yy_buf_size + 2 ,yyscanner );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in octave__create_buffer()" );

	b->yy_is_our_buffer = 1;

	octave__init_buffer(b,file ,yyscanner);

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with octave__create_buffer()
 * @param yyscanner The scanner object.
 */
    void octave__delete_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		octave_free((void *) b->yy_ch_buf ,yyscanner );

	octave_free((void *) b ,yyscanner );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a octave_restart() or at EOF.
 */
    static void octave__init_buffer  (YY_BUFFER_STATE  b, FILE * file , yyscan_t yyscanner)

{
	int oerrno = errno;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	octave__flush_buffer(b ,yyscanner);

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then octave__init_buffer was _probably_
     * called from octave_restart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * @param yyscanner The scanner object.
 */
    void octave__flush_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		octave__load_buffer_state(yyscanner );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  @param yyscanner The scanner object.
 */
void octave_push_buffer_state (YY_BUFFER_STATE new_buffer , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if (new_buffer == NULL)
		return;

	octave_ensure_buffer_stack(yyscanner);

	/* This block is copied from octave__switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		yyg->yy_buffer_stack_top++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from octave__switch_to_buffer. */
	octave__load_buffer_state(yyscanner );
	yyg->yy_did_buffer_switch_on_eof = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  @param yyscanner The scanner object.
 */
void octave_pop_buffer_state (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if (!YY_CURRENT_BUFFER)
		return;

	octave__delete_buffer(YY_CURRENT_BUFFER ,yyscanner);
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if (yyg->yy_buffer_stack_top > 0)
		--yyg->yy_buffer_stack_top;

	if (YY_CURRENT_BUFFER) {
		octave__load_buffer_state(yyscanner );
		yyg->yy_did_buffer_switch_on_eof = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void octave_ensure_buffer_stack (yyscan_t yyscanner)
{
	int num_to_alloc;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if (!yyg->yy_buffer_stack) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
      num_to_alloc = 1; /* After all that talk, this was set to 1 anyways... */
		yyg->yy_buffer_stack = (struct yy_buffer_state**)octave_alloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in octave_ensure_buffer_stack()" );

		memset(yyg->yy_buffer_stack, 0, num_to_alloc * sizeof(struct yy_buffer_state*));

		yyg->yy_buffer_stack_max = num_to_alloc;
		yyg->yy_buffer_stack_top = 0;
		return;
	}

	if (yyg->yy_buffer_stack_top >= (yyg->yy_buffer_stack_max) - 1){

		/* Increase the buffer to prepare for a possible push. */
		yy_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = yyg->yy_buffer_stack_max + grow_size;
		yyg->yy_buffer_stack = (struct yy_buffer_state**)octave_realloc
								(yyg->yy_buffer_stack,
								num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in octave_ensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset(yyg->yy_buffer_stack + yyg->yy_buffer_stack_max, 0, grow_size * sizeof(struct yy_buffer_state*));
		yyg->yy_buffer_stack_max = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE octave__scan_buffer  (char * base, yy_size_t  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return NULL;

	b = (YY_BUFFER_STATE) octave_alloc(sizeof( struct yy_buffer_state ) ,yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in octave__scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = NULL;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	octave__switch_to_buffer(b ,yyscanner );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to octave_lex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       octave__scan_bytes() instead.
 */
YY_BUFFER_STATE octave__scan_string (yyconst char * yystr , yyscan_t yyscanner)
{
    
	return octave__scan_bytes(yystr,(int) strlen(yystr) ,yyscanner);
}

/** Setup the input buffer state to scan the given bytes. The next call to octave_lex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE octave__scan_bytes  (yyconst char * yybytes, int  _yybytes_len , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = (yy_size_t) (_yybytes_len + 2);
	buf = (char *) octave_alloc(n ,yyscanner );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in octave__scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = octave__scan_buffer(buf,n ,yyscanner);
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in octave__scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yynoreturn yy_fatal_error (yyconst char* msg , yyscan_t yyscanner)
{
	struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	(void)yyg;
	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = yyg->yy_hold_char; \
		yyg->yy_c_buf_p = yytext + yyless_macro_arg; \
		yyg->yy_hold_char = *yyg->yy_c_buf_p; \
		*yyg->yy_c_buf_p = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the user-defined data for this scanner.
 * @param yyscanner The scanner object.
 */
YY_EXTRA_TYPE octave_get_extra  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyextra;
}

/** Get the current line number.
 * @param yyscanner The scanner object.
 */
int octave_get_lineno  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        if (! YY_CURRENT_BUFFER)
            return 0;
    
    return yylineno;
}

/** Get the current column number.
 * @param yyscanner The scanner object.
 */
int octave_get_column  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        if (! YY_CURRENT_BUFFER)
            return 0;
    
    return yycolumn;
}

/** Get the input stream.
 * @param yyscanner The scanner object.
 */
FILE *octave_get_in  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyin;
}

/** Get the output stream.
 * @param yyscanner The scanner object.
 */
FILE *octave_get_out  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyout;
}

/** Get the length of the current token.
 * @param yyscanner The scanner object.
 */
int octave_get_leng  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyleng;
}

/** Get the current token.
 * @param yyscanner The scanner object.
 */

char *octave_get_text  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yytext;
}

/** Set the user-defined data. This data is never touched by the scanner.
 * @param user_defined The data to be associated with this scanner.
 * @param yyscanner The scanner object.
 */
void octave_set_extra (YY_EXTRA_TYPE  user_defined , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyextra = user_defined ;
}

/** Set the current line number.
 * @param _line_number line number
 * @param yyscanner The scanner object.
 */
void octave_set_lineno (int  _line_number , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        /* lineno is only valid if an input buffer exists. */
        if (! YY_CURRENT_BUFFER )
           YY_FATAL_ERROR( "octave_set_lineno called with no buffer" );
    
    yylineno = _line_number;
}

/** Set the current column.
 * @param _column_no column number
 * @param yyscanner The scanner object.
 */
void octave_set_column (int  _column_no , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        /* column is only valid if an input buffer exists. */
        if (! YY_CURRENT_BUFFER )
           YY_FATAL_ERROR( "octave_set_column called with no buffer" );
    
    yycolumn = _column_no;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * @param yyscanner The scanner object.
 * @see octave__switch_to_buffer
 */
void octave_set_in (FILE *  _in_str , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyin = _in_str ;
}

void octave_set_out (FILE *  _out_str , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyout = _out_str ;
}

int octave_get_debug  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yy_flex_debug;
}

void octave_set_debug (int  _bdebug , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yy_flex_debug = _bdebug ;
}

/* Accessor methods for yylval and yylloc */

YYSTYPE * octave_get_lval  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yylval;
}

void octave_set_lval (YYSTYPE *  yylval_param , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yylval = yylval_param;
}

/* User-visible API */

/* octave_lex_init is special because it creates the scanner itself, so it is
 * the ONLY reentrant function that doesn't take the scanner as the last argument.
 * That's why we explicitly handle the declaration, instead of using our macros.
 */

int octave_lex_init(yyscan_t* ptr_yy_globals)

{
    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }

    *ptr_yy_globals = (yyscan_t) octave_alloc ( sizeof( struct yyguts_t ), NULL );

    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }

    /* By setting to 0xAA, we expose bugs in yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));

    return yy_init_globals ( *ptr_yy_globals );
}

/* octave_lex_init_extra has the same functionality as octave_lex_init, but follows the
 * convention of taking the scanner as the last argument. Note however, that
 * this is a *pointer* to a scanner, as it will be allocated by this call (and
 * is the reason, too, why this function also must handle its own declaration).
 * The user defined value in the first argument will be available to octave_alloc in
 * the yyextra field.
 */

int octave_lex_init_extra(YY_EXTRA_TYPE yy_user_defined,yyscan_t* ptr_yy_globals )

{
    struct yyguts_t dummy_yyguts;

    octave_set_extra (yy_user_defined, &dummy_yyguts);

    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }

    *ptr_yy_globals = (yyscan_t) octave_alloc ( sizeof( struct yyguts_t ), &dummy_yyguts );

    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }

    /* By setting to 0xAA, we expose bugs in
    yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));

    octave_set_extra (yy_user_defined, *ptr_yy_globals);

    return yy_init_globals ( *ptr_yy_globals );
}

static int yy_init_globals (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from octave_lex_destroy(), so don't allocate here.
     */

    yyg->yy_buffer_stack = NULL;
    yyg->yy_buffer_stack_top = 0;
    yyg->yy_buffer_stack_max = 0;
    yyg->yy_c_buf_p = NULL;
    yyg->yy_init = 0;
    yyg->yy_start = 0;

    yyg->yy_start_stack_ptr = 0;
    yyg->yy_start_stack_depth = 0;
    yyg->yy_start_stack =  NULL;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = NULL;
    yyout = NULL;
#endif

    /* For future reference: Set errno on error, since we are called by
     * octave_lex_init()
     */
    return 0;
}

/* octave_lex_destroy is for both reentrant and non-reentrant scanners. */
int octave_lex_destroy  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		octave__delete_buffer(YY_CURRENT_BUFFER ,yyscanner );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		octave_pop_buffer_state(yyscanner);
	}

	/* Destroy the stack itself. */
	octave_free(yyg->yy_buffer_stack ,yyscanner);
	yyg->yy_buffer_stack = NULL;

    /* Destroy the start condition stack. */
        octave_free(yyg->yy_start_stack ,yyscanner );
        yyg->yy_start_stack = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * octave_lex() is called, initialization will occur. */
    yy_init_globals( yyscanner);

    /* Destroy the main struct (reentrant only). */
    octave_free ( yyscanner , yyscanner );
    yyscanner = NULL;
    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n , yyscan_t yyscanner)
{
	struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	(void)yyg;

	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s , yyscan_t yyscanner)
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

#define YYTABLES_NAME "yytables"

#line 1788 "/home/jwe/src/octave-stable/libinterp/parse-tree/lex.ll"



#if defined (HAVE_PRAGMA_GCC_DIAGNOSTIC)
   // Restore prevailing warning state for remainder of the file.
#  pragma GCC diagnostic pop
#endif

void *
octave_alloc (yy_size_t size, yyscan_t)
{
  return std::malloc (size);
}

void *
octave_realloc (void *ptr, yy_size_t size, yyscan_t)
{
  return std::realloc (ptr, size);
}

void
octave_free (void *ptr, yyscan_t)
{
  std::free (ptr);
}

static void
display_character (char c)
{
  if (isgraph (c))
    std::cerr << c;
  else
    switch (c)
      {
      case 0:
        std::cerr << "NUL";
        break;

      case 1:
        std::cerr << "SOH";
        break;

      case 2:
        std::cerr << "STX";
        break;

      case 3:
        std::cerr << "ETX";
        break;

      case 4:
        std::cerr << "EOT";
        break;

      case 5:
        std::cerr << "ENQ";
        break;

      case 6:
        std::cerr << "ACK";
        break;

      case 7:
        std::cerr << "\\a";
        break;

      case 8:
        std::cerr << "\\b";
        break;

      case 9:
        std::cerr << "\\t";
        break;

      case 10:
        std::cerr << "\\n";
        break;

      case 11:
        std::cerr << "\\v";
        break;

      case 12:
        std::cerr << "\\f";
        break;

      case 13:
        std::cerr << "\\r";
        break;

      case 14:
        std::cerr << "SO";
        break;

      case 15:
        std::cerr << "SI";
        break;

      case 16:
        std::cerr << "DLE";
        break;

      case 17:
        std::cerr << "DC1";
        break;

      case 18:
        std::cerr << "DC2";
        break;

      case 19:
        std::cerr << "DC3";
        break;

      case 20:
        std::cerr << "DC4";
        break;

      case 21:
        std::cerr << "NAK";
        break;

      case 22:
        std::cerr << "SYN";
        break;

      case 23:
        std::cerr << "ETB";
        break;

      case 24:
        std::cerr << "CAN";
        break;

      case 25:
        std::cerr << "EM";
        break;

      case 26:
        std::cerr << "SUB";
        break;

      case 27:
        std::cerr << "ESC";
        break;

      case 28:
        std::cerr << "FS";
        break;

      case 29:
        std::cerr << "GS";
        break;

      case 30:
        std::cerr << "RS";
        break;

      case 31:
        std::cerr << "US";
        break;

      case 32:
        std::cerr << "SPACE";
        break;

      case 127:
        std::cerr << "DEL";
        break;
      }
}

namespace octave
{
  bool
  is_keyword (const std::string& s)
  {
    // Parsing function names like "set.property_name" inside
    // classdef-style class definitions is simplified by handling the
    // "set" and "get" portions of the names using the same mechanism
    // as is used for keywords.  However, they are not really keywords
    // in the language, so omit them from the list of possible
    // keywords.  Likewise for "enumeration", "events", "methods", and
    // "properties".

    return (octave_kw_hash::in_word_set (s.c_str (), s.length ()) != nullptr
            && ! (s == "set" || s == "get"
                  || s == "enumeration" || s == "events"
                  || s == "methods" || s == "properties"));
  }
}

DEFUN (iskeyword, args, ,
       doc: /* -*- texinfo -*-
@deftypefn  {} {} iskeyword ()
@deftypefnx {} {} iskeyword (@var{name})
Return true if @var{name} is an Octave keyword.

If @var{name} is omitted, return a list of keywords.
@seealso{isvarname, exist}
@end deftypefn */)
{
  octave_value retval;

  int nargin = args.length ();

  if (nargin > 1)
    print_usage ();

  if (nargin == 0)
    {
      // Neither set nor get are keywords.  See the note in the
      // is_keyword function for additional details.

      string_vector lst (TOTAL_KEYWORDS);

      int j = 0;

      for (int i = 0; i < TOTAL_KEYWORDS; i++)
        {
          std::string kword = wordlist[i].name;

          if (kword != "set" && kword != "get")
            lst[j++] = kword;
        }

      lst.resize (j);

      retval = Cell (lst.sort ());
    }
  else
    {
      std::string name = args(0).xstring_value ("iskeyword: NAME must be a string");
      retval = octave::is_keyword (name);
    }

  return retval;
}

/*

%!assert (iskeyword ("for"))
%!assert (iskeyword ("fort"), false)
%!assert (iskeyword ("fft"), false)
%!assert (iskeyword ("get"), false)
%!assert (iskeyword ("set"), false)

%!error iskeyword ("A", "B")
%!error <NAME must be a string> iskeyword (1)

*/

DEFUN (__display_tokens__, args, nargout,
       doc: /* -*- texinfo -*-
@deftypefn {} {} __display_tokens__ ()
Query or set the internal variable that determines whether Octave's
lexer displays tokens as they are read.
@seealso{__lexer_debug_flag__, __token_count__}
@end deftypefn */)
{
  return SET_INTERNAL_VARIABLE (display_tokens);
}

DEFUN (__token_count__, , ,
       doc: /* -*- texinfo -*-
@deftypefn {} {} __token_count__ ()
Return the number of language tokens processed since Octave startup.
@seealso{__lexer_debug_flag__, __display_tokens__}
@end deftypefn */)
{
  return octave_value (Vtoken_count);
}

DEFUN (__lexer_debug_flag__, args, nargout,
       doc: /* -*- texinfo -*-
@deftypefn  {} {@var{val} =} __lexer_debug_flag__ ()
@deftypefnx {} {@var{old_val} =} __lexer_debug_flag__ (@var{new_val})
Query or set the internal flag that determines whether Octave's lexer prints
debug information as it processes an expression.
@seealso{__display_tokens__, __token_count__, __parse_debug_flag__}
@end deftypefn */)
{
  octave_value retval;

  retval = set_internal_variable (lexer_debug_flag, args, nargout,
                                  "__lexer_debug_flag__");

  return retval;
}

namespace octave
{
  void
  lexical_feedback::symbol_table_context::clear (void)
  {
    while (! m_frame_stack.empty ())
      m_frame_stack.pop_front ();
  }

  void
  lexical_feedback::symbol_table_context::pop (void)
  {
    if (empty ())
      panic_impossible ();

    m_frame_stack.pop_front ();
  }

  symbol_scope
  lexical_feedback::symbol_table_context::curr_scope (void) const
  {
    if (empty ())
      {
        symbol_scope scope
          = __get_current_scope__ ("lexical_feedback::symbol_table_context::curr_scope");

        return scope;
      }
    else
      return m_frame_stack.front ();
  }

  symbol_scope
  lexical_feedback::symbol_table_context::parent_scope (void) const
  {
    size_t sz = size ();

    return (sz > 1
            ? m_frame_stack[1]
            : (sz == 1 ? m_frame_stack[0] : symbol_scope ()));
  }

  lexical_feedback::~lexical_feedback (void)
  {
    m_tokens.clear ();
  }

  void
  lexical_feedback::init (void)
  {
    // The closest paren, brace, or bracket nesting is not an object
    // index.
    m_looking_at_object_index.push_front (false);
  }

  void
  lexical_feedback::reset (void)
  {
    m_end_of_input = false;
    m_at_beginning_of_statement = true;
    m_looking_at_anon_fcn_args = false;
    m_looking_at_return_list = false;
    m_looking_at_parameter_list = false;
    m_looking_at_decl_list = false;
    m_looking_at_initializer_expression = false;
    m_looking_at_matrix_or_assign_lhs = false;
    m_looking_for_object_index = false;
    m_looking_at_indirect_ref = false;
    m_parsing_class_method = false;
    m_parsing_classdef = false;
    m_maybe_classdef_get_set_method = false;
    m_parsing_classdef_get_method = false;
    m_parsing_classdef_set_method = false;
    m_quote_is_transpose = false;
    m_force_script = false;
    m_reading_fcn_file = false;
    m_reading_script_file = false;
    m_reading_classdef_file = false;
    m_buffer_function_text = false;
    m_input_line_number = 1;
    m_current_input_column = 1;
    m_bracketflag = 0;
    m_braceflag = 0;
    m_looping = 0;
    m_defining_func = 0;
    m_looking_at_function_handle = 0;
    m_block_comment_nesting_level = 0;
    m_command_arg_paren_count = 0;
    m_token_count = 0;
    m_current_input_line = "";
    m_comment_text = "";
    m_help_text = "";
    m_function_text = "";
    m_string_text = "";
    m_string_line = 0;
    m_string_column = 0;
    m_fcn_file_name = "";
    m_fcn_file_full_name = "";
    m_dir_name = "";
    m_package_name = "";
    m_looking_at_object_index.clear ();
    m_looking_at_object_index.push_front (false);

    while (! m_parsed_function_name.empty ())
      m_parsed_function_name.pop ();

    m_pending_local_variables.clear ();
    m_symtab_context.clear ();
    m_nesting_level.reset ();
    m_tokens.clear ();
  }

  int
  lexical_feedback::previous_token_value (void) const
  {
    const token *tok = m_tokens.front ();
    return tok ? tok->token_value () : 0;
  }

  bool
  lexical_feedback::previous_token_value_is (int tok_val) const
  {
    const token *tok = m_tokens.front ();
    return tok ? tok->token_value_is (tok_val) : false;
  }

  void
  lexical_feedback::mark_previous_token_trailing_space (void)
  {
    token *tok = m_tokens.front ();
    if (tok && ! previous_token_value_is ('\n'))
      tok->mark_trailing_space ();
  }

  bool
  lexical_feedback::space_follows_previous_token (void) const
  {
    const token *tok = m_tokens.front ();
    return tok ? tok->space_follows_token () : false;
  }

  bool
  lexical_feedback::previous_token_is_binop (void) const
  {
    int tok = previous_token_value ();

    return (tok == '+' || tok == '-' || tok == '@'
            || tok == ',' || tok == ';' || tok == '*' || tok == '/'
            || tok == ':' || tok == '=' || tok == ADD_EQ
            || tok == AND_EQ || tok == DIV_EQ || tok == EDIV
            || tok == EDIV_EQ || tok == ELEFTDIV || tok == ELEFTDIV_EQ
            || tok == EMINUS || tok == EMUL || tok == EMUL_EQ
            || tok == EPOW || tok == EPOW_EQ || tok == EXPR_AND
            || tok == EXPR_AND_AND || tok == EXPR_EQ || tok == EXPR_GE
            || tok == EXPR_GT || tok == EXPR_LE || tok == EXPR_LT
            || tok == EXPR_NE || tok == EXPR_NOT || tok == EXPR_OR
            || tok == EXPR_OR_OR || tok == LEFTDIV || tok == LEFTDIV_EQ
            || tok == MUL_EQ || tok == OR_EQ || tok == POW
            || tok == POW_EQ || tok == SUB_EQ);
  }

  bool
  lexical_feedback::previous_token_is_keyword (void) const
  {
    const token *tok = m_tokens.front ();
    return tok ? tok->is_keyword () : false;
  }

  bool
  lexical_feedback::previous_token_may_be_command (void) const
  {
    const token *tok = m_tokens.front ();
    return tok ? tok->may_be_command () : false;
  }

  void
  lexical_feedback::maybe_mark_previous_token_as_variable (void)
  {
    token *tok = m_tokens.front ();

    if (tok && tok->is_symbol ())
      m_pending_local_variables.insert (tok->symbol_name ());
  }

  void
  lexical_feedback::mark_as_variables (const std::list<std::string>& lst)
  {
    for (const auto& var : lst)
      m_pending_local_variables.insert (var);
  }
}

static bool
looks_like_copyright (const std::string& s)
{
  bool retval = false;

  if (! s.empty ())
    {
      size_t offset = s.find_first_not_of (" \t");

      retval = (s.substr (offset, 9) == "Copyright"
                || s.substr (offset, 6) == "Author");
    }

  return retval;
}

static bool
looks_like_shebang (const std::string& s)
{
  return ((! s.empty ()) && (s[0] == '!'));
}

namespace octave
{
  void
  base_lexer::input_buffer::fill (const std::string& input, bool eof_arg)
  {
    m_buffer = input;
    m_chars_left = m_buffer.length ();
    m_pos = m_buffer.c_str ();
    m_eof = eof_arg;
  }

  int
  base_lexer::input_buffer::copy_chunk (char *buf, size_t max_size)
  {
    static const char * const eol = "\n";

    size_t len = max_size > m_chars_left ? m_chars_left : max_size;
    assert (len > 0);

    memcpy (buf, m_pos, len);

    m_chars_left -= len;
    m_pos += len;

    // Make sure input ends with a new line character.
    if (m_chars_left == 0 && buf[len-1] != '\n')
      {
        if (len < max_size)
          {
            // There is enough room to plug the newline character in
            // the buffer.
            buf[len++] = '\n';
          }
        else
          {
            // There isn't enough room to plug the newline character
            // in the buffer so arrange to have it returned on the next
            // call to base_lexer::read.
            m_pos = eol;
            m_chars_left = 1;
          }
      }

    return len;
  }

  base_lexer::~base_lexer (void)
  {
    octave_lex_destroy (m_scanner);
  }

  void
  base_lexer::init (void)
  {
    octave_lex_init (&m_scanner);

    // Make base_lexer object available through yyextra in
    // flex-generated lexer.
    octave_set_extra (this, m_scanner);

    clear_start_state ();
  }

  // Inside Flex-generated functions, yyg is the scanner cast to its real
  // type.  Some flex macros that we use in base_lexer member functions
  // (for example, BEGIN) use yyg.  If we could perform the actions of
  // these macros with functions instead, we could eliminate the
  // OCTAVE_YYG macro.

#define OCTAVE_YYG                                                      \
  struct yyguts_t *yyg = static_cast<struct yyguts_t*> (m_scanner)

  void
  base_lexer::reset (void)
  {
    // Start off on the right foot.
    clear_start_state ();

    m_symtab_context.clear ();

    // We do want a prompt by default.
    promptflag (1);

    // Only ask for input from stdin if we are expecting interactive
    // input.

    if (application::interactive ()
        && ! (m_reading_fcn_file
              || m_reading_classdef_file
              || m_reading_script_file
              || input_from_eval_string ()))
      octave_restart (stdin, m_scanner);

    lexical_feedback::reset ();

    m_comment_buf.reset ();
  }

  void
  base_lexer::prep_for_file (void)
  {
    m_reading_script_file = true;

    push_start_state (INPUT_FILE_START);
  }

  void
  base_lexer::begin_string (int state)
  {
    m_string_line = m_input_line_number;
    m_string_column = m_current_input_column;

    push_start_state (state);
  }

  int
  base_lexer::handle_end_of_input (void)
  {
    lexer_debug ("<<EOF>>");

    if (m_block_comment_nesting_level != 0)
      {
        warning ("block comment open at end of input");

        if ((m_reading_fcn_file || m_reading_script_file || m_reading_classdef_file)
            && ! m_fcn_file_name.empty ())
          warning ("near line %d of file '%s.m'",
                   m_input_line_number, m_fcn_file_name.c_str ());
      }

    return handle_token (END_OF_INPUT);
  }

  char *
  base_lexer::flex_yytext (void)
  {
    return octave_get_text (m_scanner);
  }

  int
  base_lexer::flex_yyleng (void)
  {
    return octave_get_leng (m_scanner);
  }

  int
  base_lexer::text_yyinput (void)
  {
    int c = yyinput (m_scanner);

    if (lexer_debug_flag)
      {
        std::cerr << "I: ";
        display_character (c);
        std::cerr << std::endl;
      }

    // Convert CRLF into just LF and single CR into LF.

    if (c == '\r')
      {
        c = yyinput (m_scanner);

        if (lexer_debug_flag)
          {
            std::cerr << "I: ";
            display_character (c);
            std::cerr << std::endl;
          }

        if (c != '\n')
          {
            xunput (c);
            c = '\n';
          }
      }

    return c;
  }

  void
  base_lexer::xunput (char c, char *buf)
  {
    if (c != EOF)
      {
        if (lexer_debug_flag)
          {
            std::cerr << "U: ";
            display_character (c);
            std::cerr << std::endl;
          }

        yyunput (c, buf, m_scanner);
      }
  }

  void
  base_lexer::xunput (char c)
  {
    char *yytxt = flex_yytext ();

    xunput (c, yytxt);
  }

  bool
  base_lexer::looking_at_space (void)
  {
    int c = text_yyinput ();
    xunput (c);
    return (c == ' ' || c == '\t');
  }

  bool
  base_lexer::inside_any_object_index (void)
  {
    bool retval = false;

    for (const bool is_obj_idx : m_looking_at_object_index)
      {
        if (is_obj_idx)
          {
            retval = true;
            break;
          }
      }

    return retval;
  }

  bool
  base_lexer::is_variable (const std::string& name,
                           const symbol_scope& scope)
  {
    return ((scope && scope.is_variable (name))
            || (m_pending_local_variables.find (name)
                != m_pending_local_variables.end ()));
  }

  // Handle keywords.  Return -1 if the keyword should be ignored.

  int
  base_lexer::is_keyword_token (const std::string& s)
  {
    int l = m_input_line_number;
    int c = m_current_input_column;

    int len = s.length ();

    const octave_kw *kw = octave_kw_hash::in_word_set (s.c_str (), len);

    if (kw)
      {
        bool previous_at_bos = m_at_beginning_of_statement;

        // May be reset to true for some token types.
        m_at_beginning_of_statement = false;

        token *tok_val = nullptr;

        switch (kw->kw_id)
          {
          case break_kw:
          case catch_kw:
          case continue_kw:
          case else_kw:
          case otherwise_kw:
          case return_kw:
          case unwind_protect_cleanup_kw:
            m_at_beginning_of_statement = true;
            break;

          case persistent_kw:
          case global_kw:
            m_looking_at_decl_list = true;
            break;

          case case_kw:
          case elseif_kw:
          case until_kw:
            break;

          case end_kw:
            if (inside_any_object_index ()
                || (m_defining_func
                    && ! (m_looking_at_return_list
                          || m_parsed_function_name.top ())))
              {
                m_at_beginning_of_statement = previous_at_bos;
                return 0;
              }

            tok_val = new token (end_kw, token::simple_end, l, c);
            m_at_beginning_of_statement = true;
            break;

          case end_try_catch_kw:
            tok_val = new token (end_try_catch_kw, token::try_catch_end, l, c);
            m_at_beginning_of_statement = true;
            break;

          case end_unwind_protect_kw:
            tok_val = new token (end_unwind_protect_kw,
                                 token::unwind_protect_end, l, c);
            m_at_beginning_of_statement = true;
            break;

          case endfor_kw:
            tok_val = new token (endfor_kw, token::for_end, l, c);
            m_at_beginning_of_statement = true;
            break;

          case endfunction_kw:
            tok_val = new token (endfunction_kw, token::function_end, l, c);
            m_at_beginning_of_statement = true;
            break;

          case endif_kw:
            tok_val = new token (endif_kw, token::if_end, l, c);
            m_at_beginning_of_statement = true;
            break;

          case endparfor_kw:
            tok_val = new token (endparfor_kw, token::parfor_end, l, c);
            m_at_beginning_of_statement = true;
            break;

          case endswitch_kw:
            tok_val = new token (endswitch_kw, token::switch_end, l, c);
            m_at_beginning_of_statement = true;
            break;

          case endwhile_kw:
            tok_val = new token (endwhile_kw, token::while_end, l, c);
            m_at_beginning_of_statement = true;
            break;

          case endclassdef_kw:
            tok_val = new token (endclassdef_kw, token::classdef_end, l, c);
            m_at_beginning_of_statement = true;
            break;

          case endenumeration_kw:
            tok_val = new token (endenumeration_kw, token::enumeration_end, l, c);
            m_at_beginning_of_statement = true;
            break;

          case endevents_kw:
            tok_val = new token (endevents_kw, token::events_end, l, c);
            m_at_beginning_of_statement = true;
            break;

          case endmethods_kw:
            tok_val = new token (endmethods_kw, token::methods_end, l, c);
            m_at_beginning_of_statement = true;
            break;

          case endproperties_kw:
            tok_val = new token (endproperties_kw, token::properties_end, l, c);
            m_at_beginning_of_statement = true;
            break;


          case for_kw:
          case parfor_kw:
          case while_kw:
            decrement_promptflag ();
            m_looping++;
            break;

          case do_kw:
            m_at_beginning_of_statement = true;
            decrement_promptflag ();
            m_looping++;
            break;

          case try_kw:
          case unwind_protect_kw:
            m_at_beginning_of_statement = true;
            decrement_promptflag ();
            break;

          case if_kw:
          case switch_kw:
            decrement_promptflag ();
            break;

          case get_kw:
          case set_kw:
            // 'get' and 'set' are keywords in classdef method
            // declarations.
            if (! m_maybe_classdef_get_set_method)
              {
                m_at_beginning_of_statement = previous_at_bos;
                return 0;
              }
            break;

          case enumeration_kw:
          case events_kw:
          case methods_kw:
          case properties_kw:
            // 'properties', 'methods' and 'events' are keywords for
            // classdef blocks.
            if (! m_parsing_classdef)
              {
                m_at_beginning_of_statement = previous_at_bos;
                return 0;
              }
            // fall through ...

          case classdef_kw:
            // 'classdef' is always a keyword.
            decrement_promptflag ();

            if (! m_force_script && m_token_count == 0 && input_from_file ())
              {
                m_reading_classdef_file = true;
                m_reading_script_file = false;
              }
            break;

          case function_kw:
            decrement_promptflag ();

            m_defining_func++;
            m_parsed_function_name.push (false);

            if (! m_force_script && m_token_count == 0 && input_from_file ())
              {
                m_reading_fcn_file = true;
                m_reading_script_file = false;
              }

            if (! (m_reading_fcn_file || m_reading_script_file
                   || m_reading_classdef_file))
              {
                // Input must be coming from the terminal or stdin?
                m_buffer_function_text = true;
                m_function_text += (m_current_input_line + "\n");

                m_input_line_number = 1;
              }
            break;

          case magic_file_kw:
            {
              if ((m_reading_fcn_file || m_reading_script_file
                   || m_reading_classdef_file)
                  && ! m_fcn_file_full_name.empty ())
                tok_val = new token (magic_file_kw, m_fcn_file_full_name, l, c);
              else
                tok_val = new token (magic_file_kw, "stdin", l, c);
            }
            break;

          case magic_line_kw:
            tok_val = new token (magic_line_kw, static_cast<double> (l),
                                 "", l, c);
            break;

          default:
            panic_impossible ();
          }

        if (! tok_val)
          tok_val = new token (kw->tok, true, l, c);

        push_token (tok_val);

        return kw->tok;
      }

    return 0;
  }

  bool
  base_lexer::fq_identifier_contains_keyword (const std::string& s)
  {
    size_t p1 = 0;
    size_t p2;

    std::string s_part;

    do
      {
        p2 = s.find ('.', p1);

        if (p2 != std::string::npos)
          {
            s_part = s.substr (p1, p2 - p1);
            p1 = p2 + 1;
          }
        else
          s_part = s.substr (p1);

        if (is_keyword_token (s_part))
          return true;
      }
    while (p2 != std::string::npos);

    return false;
  }

  bool
  base_lexer::whitespace_is_significant (void)
  {
    return (m_nesting_level.is_bracket ()
            || (m_nesting_level.is_brace ()
                && ! m_looking_at_object_index.front ()));
  }
}

static inline bool
looks_like_bin (const char *s, int len)
{
  return (len > 2 && s[0] == '0' && (s[1] == 'b' || s[1] == 'B'));
}

static inline bool
looks_like_hex (const char *s, int len)
{
  return (len > 2 && s[0] == '0' && (s[1] == 'x' || s[1] == 'X'));
}

namespace octave
{
  void
  base_lexer::handle_number (void)
  {
    double value = 0.0;
    int nread = 0;

    char *yytxt = flex_yytext ();

    // Strip any underscores
    char *tmptxt = strsave (yytxt);
    char *rptr = tmptxt;
    char *wptr = tmptxt;
    while (*rptr)
      {
        *wptr = *rptr++;
        wptr += (*wptr != '_');
      }
    *wptr = '\0';

    if (looks_like_hex (tmptxt, strlen (tmptxt)))
      {
        uintmax_t long_int_value;

        nread = sscanf (tmptxt, "%jx", &long_int_value);

        value = static_cast<double> (long_int_value);
      }
    else if (looks_like_bin (tmptxt, strlen (tmptxt)))
      {
        uintmax_t long_int_value = 0;

        for (size_t i = 0; i < strlen (tmptxt); i++)
          {
            if (tmptxt[i] == '0')
              long_int_value <<= 1;
            else if (tmptxt[i] == '1')
            {
              long_int_value <<= 1;
              long_int_value += 1;
            }
          }

        value = static_cast<double> (long_int_value);

        nread = 1;  // Just to pass the assert stmt below
      }
    else
      {
        char *idx = strpbrk (tmptxt, "Dd");

        if (idx)
          *idx = 'e';

        nread = sscanf (tmptxt, "%lf", &value);
      }

    delete [] tmptxt;

    // If yytext doesn't contain a valid number, we are in deep doo doo.

    assert (nread == 1);

    m_looking_for_object_index = false;
    m_at_beginning_of_statement = false;

    push_token (new token (NUM, value, yytxt, m_input_line_number,
                           m_current_input_column));

    m_current_input_column += flex_yyleng ();
  }

  void
  base_lexer::handle_continuation (void)
  {
    char *yytxt = flex_yytext ();
    int yylng = flex_yyleng ();

    int offset = 1;
    if (yytxt[0] == '\\')
      warn_language_extension_continuation ();
    else
      offset = 3;

    bool have_space = false;
    while (offset < yylng)
      {
        char c = yytxt[offset];
        if (c == ' ' || c == '\t')
          {
            have_space = true;
            offset++;
          }
        else
          break;
      }

    if (have_space)
      mark_previous_token_trailing_space ();

    bool have_comment = false;
    while (offset < yylng)
      {
        char c = yytxt[offset];
        if (c == '#' || c == '%')
          {
            have_comment = true;
            offset++;
          }
        else
          break;
      }

    if (have_comment)
      {
        m_comment_text = &yytxt[offset];

        // finish_comment sets m_at_beginning_of_statement to true but
        // that's not be correct if we are handling a continued
        // statement.  Preserve the current state.

        bool saved_bos = m_at_beginning_of_statement;

        finish_comment (comment_elt::end_of_line);

        m_at_beginning_of_statement = saved_bos;
      }

    decrement_promptflag ();
    m_input_line_number++;
    m_current_input_column = 1;
  }

  void
  base_lexer::finish_comment (comment_elt::comment_type typ)
  {
    bool copyright = looks_like_copyright (m_comment_text);

    if (m_nesting_level.none () && m_help_text.empty () && ! m_comment_text.empty ()
        && ! copyright && ! looks_like_shebang (m_comment_text))
      m_help_text = m_comment_text;

    if (copyright)
      typ = comment_elt::copyright;

    m_comment_buf.append (m_comment_text, typ);

    m_comment_text = "";

    m_at_beginning_of_statement = true;
  }

  int
  base_lexer::handle_close_bracket (int bracket_type)
  {
    int retval = bracket_type;

    if (! m_nesting_level.none ())
      {
        m_nesting_level.remove ();

        if (bracket_type == ']')
          m_bracketflag--;
        else if (bracket_type == '}')
          m_braceflag--;
        else
          panic_impossible ();
      }

    pop_start_state ();

    return retval;
  }

  bool
  base_lexer::looks_like_command_arg (void)
  {
    bool space_before = space_follows_previous_token ();
    bool space_after = looking_at_space ();

    return (space_before && ! space_after
            && previous_token_may_be_command ());
  }

  int
  base_lexer::handle_superclass_identifier (void)
  {
    std::string meth = flex_yytext ();

    size_t pos = meth.find ("@");
    std::string cls = meth.substr (pos + 1);
    meth = meth.substr (0, pos);

    bool kw_token = (is_keyword_token (meth)
                     || fq_identifier_contains_keyword (cls));

    if (kw_token)
      {
        token *tok
          = new token (LEXICAL_ERROR,
                       "method, class, and package names may not be keywords",
                       m_input_line_number, m_current_input_column);

        push_token (tok);

        return count_token_internal (LEXICAL_ERROR);
      }

    push_token (new token (SUPERCLASSREF, meth, cls,
                           m_input_line_number, m_current_input_column));

    m_current_input_column += flex_yyleng ();

    return SUPERCLASSREF;
  }

  int
  base_lexer::handle_meta_identifier (void)
  {
    std::string cls = std::string(flex_yytext ()).substr (1);

    if (fq_identifier_contains_keyword (cls))
      {
        token *tok = new token (LEXICAL_ERROR,
                                "class and package names may not be keywords",
                                m_input_line_number, m_current_input_column);
        push_token (tok);

        return count_token_internal (LEXICAL_ERROR);
      }

    push_token (new token (METAQUERY, cls, m_input_line_number,
                           m_current_input_column));

    m_current_input_column += flex_yyleng ();

    return METAQUERY;
  }

  int
  base_lexer::handle_fq_identifier (void)
  {
    std::string fq_id = flex_yytext ();

    if (fq_identifier_contains_keyword (fq_id))
      {
        token *tok
          = new token (LEXICAL_ERROR,
                       "function, method, class, and package names may not be keywords",
                       m_input_line_number, m_current_input_column);

        push_token (tok);

        return count_token_internal (LEXICAL_ERROR);
      }

    push_token (new token (FQ_IDENT, fq_id, m_input_line_number,
                           m_current_input_column));

    m_current_input_column += flex_yyleng ();

    return FQ_IDENT;
  }

  // Figure out exactly what kind of token to return when we have seen
  // an identifier.  Handles keywords.  Return -1 if the identifier
  // should be ignored.

  int
  base_lexer::handle_identifier (void)
  {
    std::string ident = flex_yytext ();

    // If we are expecting a structure element, avoid recognizing
    // keywords and other special names and return STRUCT_ELT, which is
    // a string that is also a valid identifier.

    if (m_looking_at_indirect_ref)
      {
        push_token (new token (STRUCT_ELT, ident, m_input_line_number,
                               m_current_input_column));

        m_looking_for_object_index = true;

        m_current_input_column += flex_yyleng ();

        return STRUCT_ELT;
      }

    // If ident is a keyword token, then is_keyword_token will set
    // m_at_beginning_of_statement.  For example, if tok is an IF
    // token, then m_at_beginning_of_statement will be false.

    int kw_token = is_keyword_token (ident);

    if (m_looking_at_function_handle)
      {
        if (kw_token)
          {
            token *tok
              = new token (LEXICAL_ERROR,
                           "function handles may not refer to keywords",
                           m_input_line_number, m_current_input_column);

            push_token (tok);

            return count_token_internal (LEXICAL_ERROR);
          }
        else
          {
            push_token (new token (FCN_HANDLE, ident, m_input_line_number,
                                   m_current_input_column));

            m_current_input_column += flex_yyleng ();
            m_looking_for_object_index = true;

            m_at_beginning_of_statement = false;

            return FCN_HANDLE;
          }
      }

    // If we have a regular keyword, return it.
    // Keywords can be followed by identifiers.

    if (kw_token)
      {
        if (kw_token >= 0)
          {
            m_current_input_column += flex_yyleng ();
            m_looking_for_object_index = false;
          }

        // The call to is_keyword_token set m_at_beginning_of_statement.

        return kw_token;
      }

    // Find the token in the symbol table.

    symbol_scope scope = m_symtab_context.curr_scope ();

    symbol_record sr = (scope ? scope.insert (ident) : symbol_record (ident));

    token *tok = new token (NAME, sr, m_input_line_number, m_current_input_column);

    // The following symbols are handled specially so that things like
    //
    //   pi +1
    //
    // are parsed as an addition expression instead of as a command-style
    // function call with the argument "+1".

    if (m_at_beginning_of_statement
        && (! (is_variable (ident, scope)
               || ident == "e" || ident == "pi"
               || ident == "I" || ident == "i"
               || ident == "J" || ident == "j"
               || ident == "Inf" || ident == "inf"
               || ident == "NaN" || ident == "nan")))
      tok->mark_may_be_command ();

    push_token (tok);

    m_current_input_column += flex_yyleng ();

    // The magic end index can't be indexed.

    if (ident != "end")
      m_looking_for_object_index = true;

    m_at_beginning_of_statement = false;

    return NAME;
  }

  void
  base_lexer::maybe_warn_separator_insert (char sep)
  {
    std::string nm = m_fcn_file_full_name;

    if (nm.empty ())
      warning_with_id ("Octave:separator-insert",
                       "potential auto-insertion of '%c' near line %d",
                       sep, m_input_line_number);
    else
      warning_with_id ("Octave:separator-insert",
                       "potential auto-insertion of '%c' near line %d of file %s",
                       sep, m_input_line_number, nm.c_str ());
  }

  void
  base_lexer::warn_single_quote_string (void)
  {
    std::string nm = m_fcn_file_full_name;

    if (nm.empty ())
      warning_with_id ("Octave:single-quote-string",
                       "single quote delimited string near line %d",
                       m_input_line_number);
    else
      warning_with_id ("Octave:single-quote-string",
                       "single quote delimited string near line %d of file %s",
                       m_input_line_number, nm.c_str ());
  }

  void
  base_lexer::warn_language_extension (const std::string& msg)
  {
    std::string nm = m_fcn_file_full_name;

    if (nm.empty ())
      warning_with_id ("Octave:language-extension",
                       "Octave language extension used: %s",
                       msg.c_str ());
    else
      warning_with_id ("Octave:language-extension",
                       "Octave language extension used: %s near line %d offile %s",
                       msg.c_str (), m_input_line_number, nm.c_str ());
  }

  void
  base_lexer::maybe_warn_language_extension_comment (char c)
  {
    if (c == '#')
      warn_language_extension ("# used as comment character");
  }

  void
  base_lexer::warn_language_extension_continuation (void)
  {
    warn_language_extension ("\\ used as line continuation marker");
  }

  void
  base_lexer::warn_language_extension_operator (const std::string& op)
  {
    std::string t = op;
    int n = t.length ();
    if (t[n-1] == '\n')
      t.resize (n-1);
    warn_language_extension (t + " used as operator");
  }

  void
  base_lexer::push_token (token *tok)
  {
    YYSTYPE *lval = octave_get_lval (m_scanner);
    lval->tok_val = tok;
    m_tokens.push (tok);
  }

  token *
  base_lexer::current_token (void)
  {
    YYSTYPE *lval = octave_get_lval (m_scanner);
    return lval->tok_val;
  }

  void
  base_lexer::display_token (int tok)
  {
    switch (tok)
      {
      case '=': std::cerr << "'='\n"; break;
      case ':': std::cerr << "':'\n"; break;
      case '-': std::cerr << "'-'\n"; break;
      case '+': std::cerr << "'+'\n"; break;
      case '*': std::cerr << "'*'\n"; break;
      case '/': std::cerr << "'/'\n"; break;
      case ADD_EQ: std::cerr << "ADD_EQ\n"; break;
      case SUB_EQ: std::cerr << "SUB_EQ\n"; break;
      case MUL_EQ: std::cerr << "MUL_EQ\n"; break;
      case DIV_EQ: std::cerr << "DIV_EQ\n"; break;
      case LEFTDIV_EQ: std::cerr << "LEFTDIV_EQ\n"; break;
      case POW_EQ: std::cerr << "POW_EQ\n"; break;
      case EMUL_EQ: std::cerr << "EMUL_EQ\n"; break;
      case EDIV_EQ: std::cerr << "EDIV_EQ\n"; break;
      case ELEFTDIV_EQ: std::cerr << "ELEFTDIV_EQ\n"; break;
      case EPOW_EQ: std::cerr << "EPOW_EQ\n"; break;
      case AND_EQ: std::cerr << "AND_EQ\n"; break;
      case OR_EQ: std::cerr << "OR_EQ\n"; break;
      case EXPR_AND_AND: std::cerr << "EXPR_AND_AND\n"; break;
      case EXPR_OR_OR: std::cerr << "EXPR_OR_OR\n"; break;
      case EXPR_AND: std::cerr << "EXPR_AND\n"; break;
      case EXPR_OR: std::cerr << "EXPR_OR\n"; break;
      case EXPR_NOT: std::cerr << "EXPR_NOT\n"; break;
      case EXPR_LT: std::cerr << "EXPR_LT\n"; break;
      case EXPR_LE: std::cerr << "EXPR_LE\n"; break;
      case EXPR_EQ: std::cerr << "EXPR_EQ\n"; break;
      case EXPR_NE: std::cerr << "EXPR_NE\n"; break;
      case EXPR_GE: std::cerr << "EXPR_GE\n"; break;
      case EXPR_GT: std::cerr << "EXPR_GT\n"; break;
      case LEFTDIV: std::cerr << "LEFTDIV\n"; break;
      case EMUL: std::cerr << "EMUL\n"; break;
      case EDIV: std::cerr << "EDIV\n"; break;
      case ELEFTDIV: std::cerr << "ELEFTDIV\n"; break;
      case EPLUS: std::cerr << "EPLUS\n"; break;
      case EMINUS: std::cerr << "EMINUS\n"; break;
      case HERMITIAN: std::cerr << "HERMITIAN\n"; break;
      case TRANSPOSE: std::cerr << "TRANSPOSE\n"; break;
      case PLUS_PLUS: std::cerr << "PLUS_PLUS\n"; break;
      case MINUS_MINUS: std::cerr << "MINUS_MINUS\n"; break;
      case POW: std::cerr << "POW\n"; break;
      case EPOW: std::cerr << "EPOW\n"; break;

      case NUM:
      case IMAG_NUM:
        {
          token *tok_val = current_token ();
          std::cerr << (tok == NUM ? "NUM" : "IMAG_NUM")
                    << " [" << tok_val->number () << "]\n";
        }
        break;

      case STRUCT_ELT:
        {
          token *tok_val = current_token ();
          std::cerr << "STRUCT_ELT [" << tok_val->text () << "]\n";
        }
        break;

      case NAME:
        {
          token *tok_val = current_token ();
          symbol_record sr = tok_val->sym_rec ();
          std::cerr << "NAME [" << sr.name () << "]\n";
        }
        break;

      case END: std::cerr << "END\n"; break;

      case DQ_STRING:
      case SQ_STRING:
        {
          token *tok_val = current_token ();

          std::cerr << (tok == DQ_STRING ? "DQ_STRING" : "SQ_STRING")
                    << " [" << tok_val->text () << "]\n";
        }
        break;

      case FOR: std::cerr << "FOR\n"; break;
      case WHILE: std::cerr << "WHILE\n"; break;
      case DO: std::cerr << "DO\n"; break;
      case UNTIL: std::cerr << "UNTIL\n"; break;
      case IF: std::cerr << "IF\n"; break;
      case ELSEIF: std::cerr << "ELSEIF\n"; break;
      case ELSE: std::cerr << "ELSE\n"; break;
      case SWITCH: std::cerr << "SWITCH\n"; break;
      case CASE: std::cerr << "CASE\n"; break;
      case OTHERWISE: std::cerr << "OTHERWISE\n"; break;
      case BREAK: std::cerr << "BREAK\n"; break;
      case CONTINUE: std::cerr << "CONTINUE\n"; break;
      case FUNC_RET: std::cerr << "FUNC_RET\n"; break;
      case UNWIND: std::cerr << "UNWIND\n"; break;
      case CLEANUP: std::cerr << "CLEANUP\n"; break;
      case TRY: std::cerr << "TRY\n"; break;
      case CATCH: std::cerr << "CATCH\n"; break;
      case GLOBAL: std::cerr << "GLOBAL\n"; break;
      case PERSISTENT: std::cerr << "PERSISTENT\n"; break;
      case FCN_HANDLE: std::cerr << "FCN_HANDLE\n"; break;
      case END_OF_INPUT: std::cerr << "END_OF_INPUT\n\n"; break;
      case LEXICAL_ERROR: std::cerr << "LEXICAL_ERROR\n\n"; break;
      case FCN: std::cerr << "FCN\n"; break;
      case INPUT_FILE: std::cerr << "INPUT_FILE\n"; break;
      case SUPERCLASSREF: std::cerr << "SUPERCLASSREF\n"; break;
      case METAQUERY: std::cerr << "METAQUERY\n"; break;
      case GET: std::cerr << "GET\n"; break;
      case SET: std::cerr << "SET\n"; break;
      case PROPERTIES: std::cerr << "PROPERTIES\n"; break;
      case METHODS: std::cerr << "METHODS\n"; break;
      case EVENTS: std::cerr << "EVENTS\n"; break;
      case CLASSDEF: std::cerr << "CLASSDEF\n"; break;
      case '\n': std::cerr << "\\n\n"; break;
      case '\r': std::cerr << "\\r\n"; break;
      case '\t': std::cerr << "TAB\n"; break;
      default:
        {
          if (tok < 256 && tok > 31)
            std::cerr << static_cast<char> (tok) << "\n";
          else
            std::cerr << "UNKNOWN(" << tok << ")\n";
        }
        break;
      }
  }

  void
  base_lexer::fatal_error (const char *msg)
  {
    error ("fatal lexer error: %s", msg);
  }

  void
  base_lexer::lexer_debug (const char *pattern)
  {
    if (lexer_debug_flag)
      {
        std::cerr << std::endl;

        display_start_state ();

        std::cerr << "P: " << pattern << std::endl;
        std::cerr << "T: " << flex_yytext () << std::endl;
      }
  }

  void
  base_lexer::push_start_state (int state)
  {
    OCTAVE_YYG;

    start_state_stack.push (state);

    BEGIN (start_state ());
  }

  void
  base_lexer::pop_start_state (void)
  {
    OCTAVE_YYG;

    start_state_stack.pop ();

    BEGIN (start_state ());
  }

  void
  base_lexer::clear_start_state (void)
  {
    while (! start_state_stack.empty ())
      start_state_stack.pop ();

    push_start_state (INITIAL);
  }

  void
  base_lexer::display_start_state (void) const
  {
    std::cerr << "S: ";

    switch (start_state ())
      {
      case INITIAL:
        std::cerr << "INITIAL" << std::endl;
        break;

      case COMMAND_START:
        std::cerr << "COMMAND_START" << std::endl;
        break;

      case MATRIX_START:
        std::cerr << "MATRIX_START" << std::endl;
        break;

      case INPUT_FILE_START:
        std::cerr << "INPUT_FILE_BEGIN" << std::endl;
        break;

      case BLOCK_COMMENT_START:
        std::cerr << "BLOCK_COMMENT_START" << std::endl;
        break;

      case LINE_COMMENT_START:
        std::cerr << "LINE_COMMENT_START" << std::endl;
        break;

      case DQ_STRING_START:
        std::cerr << "DQ_STRING_START" << std::endl;
        break;

      case SQ_STRING_START:
        std::cerr << "SQ_STRING_START" << std::endl;
        break;

      default:
        std::cerr << "UNKNOWN START STATE!" << std::endl;
        break;
      }
  }

  int
  base_lexer::handle_op (const char *pattern, int tok, bool bos)
  {
    lexer_debug (pattern);

    return handle_op_internal (tok, bos, true);
  }

  int
  base_lexer::handle_language_extension_op (const char *pattern, int tok,
                                                   bool bos)
  {
    lexer_debug (pattern);

    return handle_op_internal (tok, bos, false);
  }

  bool
  base_lexer::maybe_unput_comma_before_unary_op (int tok)
  {
    int prev_tok = previous_token_value ();

    bool unput_comma = false;

    if (whitespace_is_significant () && space_follows_previous_token ())
      {
        int c = text_yyinput ();
        xunput (c);

        bool space_after = (c == ' ' || c == '\t');

        if (! (prev_tok == '[' || prev_tok == '{'
               || previous_token_is_binop ()
               || ((tok == '+' || tok == '-') && space_after)))
          unput_comma = true;
      }

    return unput_comma;
  }

  int
  base_lexer::handle_unary_op (int tok, bool bos)
  {
    return maybe_unput_comma_before_unary_op (tok)
      ? -1 : handle_op_internal (tok, bos, true);
  }

  int
  base_lexer::handle_language_extension_unary_op (int tok, bool bos)
  {
    return maybe_unput_comma_before_unary_op (tok)
      ? -1 : handle_op_internal (tok, bos, false);
  }

  int
  base_lexer::handle_op_internal (int tok, bool bos, bool compat)
  {
    if (! compat)
      warn_language_extension_operator (flex_yytext ());

    push_token (new token (tok, m_input_line_number, m_current_input_column));

    m_current_input_column += flex_yyleng ();
    m_looking_for_object_index = false;
    m_at_beginning_of_statement = bos;

    return count_token_internal (tok);
  }

  int
  base_lexer::handle_token (const std::string& name, int tok)
  {
    token *tok_val = new token (tok, name, m_input_line_number,
                                m_current_input_column);

    return handle_token (tok, tok_val);
  }

  int
  base_lexer::handle_token (int tok, token *tok_val)
  {
    if (! tok_val)
      tok_val = new token (tok, m_input_line_number, m_current_input_column);

    push_token (tok_val);

    m_current_input_column += flex_yyleng ();

    return count_token_internal (tok);
  }

  int
  base_lexer::count_token (int tok)
  {
    token *tok_val = new token (tok, m_input_line_number, m_current_input_column);

    push_token (tok_val);

    return count_token_internal (tok);
  }

  int
  base_lexer::count_token_internal (int tok)
  {
    if (tok != '\n')
      {
        Vtoken_count++;
        m_token_count++;
      }

    return show_token (tok);
  }

  int
  base_lexer::show_token (int tok)
  {
    if (Vdisplay_tokens)
      display_token (tok);

    if (lexer_debug_flag)
      {
        std::cerr << "R: ";
        display_token (tok);
        std::cerr << std::endl;
      }

    return tok;
  }

  void
  base_lexer::enable_fq_identifier (void)
  {
    push_start_state (FQ_IDENT_START);
  }

  int
  lexer::fill_flex_buffer (char *buf, unsigned max_size)
  {
    int status = 0;

    if (m_input_buf.empty ())
      {
        bool eof = false;
        m_current_input_line = m_reader.get_input (eof);

        m_input_buf.fill (m_current_input_line, eof);

        // Attempt to capture text for functions defined on the
        // command line.
        //
        // FIXME: the handling of newline here seems a bit clumsy.
        //
        // See also comments in push_lexer::append_input.

        if (m_buffer_function_text)
          {
            if (! m_current_input_line.empty ())
            {
              m_function_text += m_current_input_line;
              if (m_current_input_line.back () != '\n')
                m_function_text += '\n';
            }
          }
      }

    if (! m_input_buf.empty ())
      status = m_input_buf.copy_chunk (buf, max_size);
    else
      status = YY_NULL;

    return status;
  }

  void
  push_lexer::append_input (const std::string& input, bool eof)
  {
    // FIXME: input may contain more than one line, so how can we
    // properly start buffering input for command-line functions?
    //
    // Currently, base_lexer::is_keyword_token starts buffering text
    // for command-line functions by setting the initial value of
    // m_function_text to m_current_input_line when function_kw is
    // recognized.  To make that work, we need to do something like
    // maintain a queue of input strings and pass them to the flex
    // buffer one line at a time, while also setting
    // m_current_input_line.  Some care will be needed if a single line
    // of input arrives in multiple calls to append_input.

    m_input_buf.fill (input, eof);
  }

  int
  push_lexer::fill_flex_buffer (char *buf, unsigned max_size)
  {
    int status = 0;

    if (m_input_buf.empty () && ! m_input_buf.at_eof ())
      m_input_buf.fill (std::string (1, static_cast<char> (1)), false);

    if (! m_input_buf.empty ())
      status = m_input_buf.copy_chunk (buf, max_size);
    else
      status = YY_NULL;

    return status;
  }
}

