/*
  The oSIP library implements the Session Initiation Protocol (SIP -rfc3261-)
  Copyright (C) 2001-2020 Aymeric MOIZARD amoizard@antisip.com
  
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/



#ifndef _OSIP_HEADERS_H_
#define _OSIP_HEADERS_H_

#include <osipparser2/osip_port.h>
#include <osipparser2/osip_const.h>
#include <osipparser2/osip_uri.h>

#include <osipparser2/headers/osip_header.h>
#include <osipparser2/headers/osip_accept.h>
#include <osipparser2/headers/osip_accept_encoding.h>
#include <osipparser2/headers/osip_accept_language.h>
#include <osipparser2/headers/osip_alert_info.h>
#include <osipparser2/headers/osip_allow.h>
#include <osipparser2/headers/osip_authentication_info.h>
#include <osipparser2/headers/osip_authorization.h>
#include <osipparser2/headers/osip_call_id.h>
#include <osipparser2/headers/osip_call_info.h>
#include <osipparser2/headers/osip_contact.h>
#include <osipparser2/headers/osip_content_disposition.h>
#include <osipparser2/headers/osip_content_encoding.h>
#include <osipparser2/headers/osip_content_length.h>
#include <osipparser2/headers/osip_content_type.h>
#include <osipparser2/headers/osip_cseq.h>
#include <osipparser2/headers/osip_error_info.h>
#include <osipparser2/headers/osip_from.h>
#include <osipparser2/headers/osip_mime_version.h>
#include <osipparser2/headers/osip_proxy_authenticate.h>
#include <osipparser2/headers/osip_proxy_authentication_info.h>
#include <osipparser2/headers/osip_proxy_authorization.h>
#include <osipparser2/headers/osip_record_route.h>
#include <osipparser2/headers/osip_route.h>
#include <osipparser2/headers/osip_to.h>
#include <osipparser2/headers/osip_via.h>
#include <osipparser2/headers/osip_www_authenticate.h>

/**
 * @file osip_headers.h
 * @brief oSIP osip_headers definition.
 */

/**
 * @defgroup oSIP_HEADERS oSIP headers definitions
 * @ingroup osip2_parser
 * @{
 */

/** @} */

#endif
