/* glue.c   --   C utilities for interpreter
   B. Boser, 1/95
*/

#include <stdlib.h>
#include <stdio.h>

/* ------------------------------------------------------------------------------- */
/* signal handler */

#include <signal.h>

static void sig_handler(int sig) {
    /* call Sather (which should rise an exception & never return) */
    C_GLUE_sig_handler(sig);

    /* never return */
    fprintf(stderr, "\n***** INTERNAL FATAL ERROR: returned from signal handler\n");
    exit(-1);
};  /* sig_handler */

void appoint_sig_handler(int sig) {
    signal(sig, sig_handler);
};  /* appoint_sig_handler */

/* ------------------------------------------------------------------------------- */
/* redirect stderr */

#include <sys/types.h>
#include <sys/file.h>
#include <fcntl.h>

int open_write(char *path) {
    return open(path, O_WRONLY, 0);
};  /* open_write */

/* ------------------------------------------------------------------------------- */
/* missing functions */

#ifdef __MIPSEL

#include <math.h>

double scalbn(double f, int n) {
    return scalb(f, n);
};  /* scalbn */

double aint(double f) {
    return rint(f);         /* hack hack hack hack hack hack hack hack hack */
};  /* aint */

#endif

/* ------------------------------------------------------------------------------- */
/* C aliases (hack) */
/* there is currently now way to declare an external void* argument in Sather
   so, (e.g) str.sa sais
	memcpy(r:STR,s:EXT_OB,i:INT):EXT_OB;
   and matlab.sa sais
	memcpy(m: MATD, mx_p: EXT_OB, bytes: INT): EXT_OB;
   and the compiler barfs at the two incompatible definitions.
   The hack below makes memcpy_matlab an alias for memcpy ...
*/

#ifdef __MIPSEL
int
#else
void *
#endif
memcpy_matlab(void *s1, const void *s2, size_t n) {
    return memcpy(s1, s2, n);
};  /* memcpy_matlab */
