#!/usr/bin/python

# GNU Solfege - eartraining for GNOME
# Copyright (C) 2000, 2001  Tom Cato Amundsen
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# This script is used to launch Solfege when running
# it from the source dir without installing.

#from __future__ import nested_scopes

#import gc
#gc.set_debug(gc.DEBUG_LEAK)
#gc.disable()

import sys

if sys.version_info < (2, 1):
    print "Solfege need Python 2.1 or newer. Your python seems to be too old."
    print "Do not report bugs in Solfege before you upgrade your python interpreter."

import src.configureoutput

import src.rcfile
src.rcfile.copy_rc14_file()
import src.cfg

src.cfg.initialise(None, "default.config", "~/.solfegerc%i.%i" %
  (src.configureoutput.MAJOR_VERSION, src.configureoutput.MINOR_VERSION))

if not src.configureoutput.WITH_GNOME:
    sys.path.insert(0, "gnomeemu")

import src.i18n
src.i18n.initialise("share/locale")

import __main__, time
__main__._st = time.clock()
if '--txtui' in sys.argv:
    import src.txtui
else:
    import src.mainwin

