#! /bin/sh
# Copyright (C) 1996-2012 Free Software Foundation, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# Test to make sure intermediate .c files are built from vala sources
# in non-recursive automake mode.

required="libtool"
. ./defs || Exit 1

cat >> 'configure.ac' << 'END'
AC_PROG_CC
AM_PROG_AR
AC_PROG_LIBTOOL
AM_PROG_VALAC
AC_OUTPUT
END

cat > 'Makefile.am' <<'END'
bin_PROGRAMS = src/zardoz
src_zardoz_SOURCES = src/zardoz.vala

lib_LTLIBRARIES = src/libzardoz.la
src_libzardoz_la_SOURCES = src/zardoz-foo.vala src/zardoz-bar.vala
END

: > ltmain.sh
: > config.sub
: > config.guess

$ACLOCAL
$AUTOMAKE -a

grep 'VALAC' Makefile.in
grep 'src_zardoz_OBJECTS' Makefile.in
grep 'src_libzardoz_la_OBJECTS' Makefile.in
grep 'src_zardoz_vala.stamp' Makefile.in
grep 'src_libzardoz_la_vala.stamp' Makefile.in
grep 'zardoz\.c' Makefile.in
grep 'src/zardoz-foo\.c' Makefile.in
