#include "available-stubs.h"

#ifdef HAVE_LOCALE_H
#include <locale.h>
#ifdef HAVE_LIBINTL_H
#include <libintl.h>
#endif
#include "checker_api.h"

/* compiled from: . */
#ifdef HAVE_dcgettext
/* From `/usr/include/libintl.h:25'.  */
char * chkr_stub_dcgettext (const char * arg0, const char * arg1, int arg2) __asm__ (CHKR_PREFIX ("dcgettext"));
char *
chkr_stub_dcgettext (const char * arg0, const char * arg1, int arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (char), CHKR_RO, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (char), CHKR_RO, "arg1");
#if USE_BI_JUMP
  __builtin_jump (dcgettext);
#else
  return dcgettext (arg0, arg1, arg2);
  {
    char * res;
    res = dcgettext (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_dcgettext */

#ifdef HAVE_dgettext
/* From `/usr/include/libintl.h:26'.  */
char * chkr_stub_dgettext (const char * arg0, const char * arg1) __asm__ (CHKR_PREFIX ("dgettext"));
char *
chkr_stub_dgettext (const char * arg0, const char * arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (char), CHKR_RO, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (char), CHKR_RO, "arg1");
#if USE_BI_JUMP
  __builtin_jump (dgettext);
#else
  return dgettext (arg0, arg1);
  {
    char * res;
    res = dgettext (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_dgettext */

#ifdef HAVE_gettext
/* From `/usr/include/libintl.h:27'.  */
char * chkr_stub_gettext (const char * arg0) __asm__ (CHKR_PREFIX ("gettext"));
char *
chkr_stub_gettext (const char * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (char), CHKR_RO, "arg0");
#if USE_BI_JUMP
  __builtin_jump (gettext);
#else
  return gettext (arg0);
  {
    char * res;
    res = gettext (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_gettext */

#ifdef HAVE_textdomain
/* From `/usr/include/libintl.h:28'.  */
char * chkr_stub_textdomain (const char * arg0) __asm__ (CHKR_PREFIX ("textdomain"));
char *
chkr_stub_textdomain (const char * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (char), CHKR_RO, "arg0");
#if USE_BI_JUMP
  __builtin_jump (textdomain);
#else
  return textdomain (arg0);
  {
    char * res;
    res = textdomain (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_textdomain */

#ifdef HAVE_bindtextdomain
/* From `/usr/include/libintl.h:29'.  */
char * chkr_stub_bindtextdomain (const char * arg0, const char * arg1) __asm__ (CHKR_PREFIX ("bindtextdomain"));
char *
chkr_stub_bindtextdomain (const char * arg0, const char * arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (char), CHKR_RO, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (char), CHKR_RO, "arg1");
#if USE_BI_JUMP
  __builtin_jump (bindtextdomain);
#else
  return bindtextdomain (arg0, arg1);
  {
    char * res;
    res = bindtextdomain (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_bindtextdomain */

#ifdef HAVE_wdinit
/* From `/usr/include/libintl.h:33'.  */
int chkr_stub_wdinit (void ) __asm__ (CHKR_PREFIX ("wdinit"));
int
chkr_stub_wdinit (void )
{
#if USE_BI_JUMP
  __builtin_jump (wdinit);
#else
  return wdinit ();
  {
    int res;
    res = wdinit ();
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_wdinit */

#ifdef HAVE_wdchkind
/* From `/usr/include/libintl.h:34'.  */
int chkr_stub_wdchkind (wchar_t arg0) __asm__ (CHKR_PREFIX ("wdchkind"));
int
chkr_stub_wdchkind (wchar_t arg0)
{
#if USE_BI_JUMP
  __builtin_jump (wdchkind);
#else
  return wdchkind (arg0);
  {
    int res;
    res = wdchkind (arg0);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_wdchkind */

#ifdef HAVE_wdbindf
/* From `/usr/include/libintl.h:35'.  */
int chkr_stub_wdbindf (wchar_t arg0, wchar_t arg1, int arg2) __asm__ (CHKR_PREFIX ("wdbindf"));
int
chkr_stub_wdbindf (wchar_t arg0, wchar_t arg1, int arg2)
{
#if USE_BI_JUMP
  __builtin_jump (wdbindf);
#else
  return wdbindf (arg0, arg1, arg2);
  {
    int res;
    res = wdbindf (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_wdbindf */

#ifdef HAVE_wddelim
/* From `/usr/include/libintl.h:36'.  */
wchar_t * chkr_stub_wddelim (wchar_t arg0, wchar_t arg1, int arg2) __asm__ (CHKR_PREFIX ("wddelim"));
wchar_t *
chkr_stub_wddelim (wchar_t arg0, wchar_t arg1, int arg2)
{
#if USE_BI_JUMP
  __builtin_jump (wddelim);
#else
  return wddelim (arg0, arg1, arg2);
  {
    wchar_t * res;
    res = wddelim (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_wddelim */

#ifdef HAVE_mcfiller
/* From `/usr/include/libintl.h:37'.  */
wchar_t chkr_stub_mcfiller (void ) __asm__ (CHKR_PREFIX ("mcfiller"));
wchar_t
chkr_stub_mcfiller (void )
{
#if USE_BI_JUMP
  __builtin_jump (mcfiller);
#else
  return mcfiller ();
  {
    wchar_t res;
    res = mcfiller ();
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mcfiller */

#ifdef HAVE_mcwrap
/* From `/usr/include/libintl.h:38'.  */
int chkr_stub_mcwrap (void ) __asm__ (CHKR_PREFIX ("mcwrap"));
int
chkr_stub_mcwrap (void )
{
#if USE_BI_JUMP
  __builtin_jump (mcwrap);
#else
  return mcwrap ();
  {
    int res;
    res = mcwrap ();
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mcwrap */

#ifdef HAVE_setlocale
/* From `/usr/include/locale.h:64'.  */
char * chkr_stub_setlocale (int cathegorie, const char *locale) __asm__ (CHKR_PREFIX ("setlocale"));
char *
chkr_stub_setlocale (int cathegorie, const char *locale)
{
  char * res;

  stubs_chkr_check_str (locale, CHKR_RO, "locale");

  res = setlocale (cathegorie, locale);
  if (res != locale)
    stubs_chkr_set_right (res, strlen (res) + 1, CHKR_RO);
  return res;
}
#endif /* HAVE_setlocale */

#ifdef HAVE_localeconv
/* From `/usr/include/locale.h:65'.  */
struct lconv * chkr_stub_localeconv (void ) __asm__ (CHKR_PREFIX ("localeconv"));
struct lconv *
chkr_stub_localeconv (void )
{
#if USE_BI_JUMP
  __builtin_jump (localeconv);
#else
  return localeconv ();
  {
    struct lconv * res;
    res = localeconv ();
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_localeconv */


#endif /* HAVE_LOCALE_H */
