# Check whether free (NULL) is supposed to work.

# Copyright (C) 2003, 2004 Free Software Foundation, Inc.

# This file is free software, distributed under the terms of the GNU
# General Public License.  As a special exception to the GNU General
# Public License, this file may be distributed as part of a program
# that contains a configuration script generated by Autoconf, under
# the same distribution terms as the rest of that program.

# Written by Paul Eggert.

# We can't test for free (NULL) even at runtime, since it might
# happen to "work" for our test program, but not in general.  So, be
# conservative and use feature tests for relatively modern hosts,
# where free (NULL) is known to work.  This costs a bit of
# performance on some older hosts, but we can fix that later if
# needed.

AC_DEFUN([gl_FUNC_FREE],
[
  AC_CHECK_HEADERS_ONCE(unistd.h)
  AC_CACHE_CHECK([whether free (NULL) is known to work],
    [gl_cv_func_free],
    [AC_COMPILE_IFELSE(
       [AC_LANG_PROGRAM(
	  [[@%:@if HAVE_UNISTD_H
	      @%:@include <unistd.h>
	    @%:@endif]],
	  [[@%:@if _POSIX_VERSION < 199009L && \
	        (defined unix || defined _unix || defined _unix_ \
	         || defined __unix || defined __unix__)
	      @%:@error "'free (NULL)' is not known to work"
	    @%:@endif]])],
       [gl_cv_func_free=yes],
       [gl_cv_func_free=no])])

  if test $gl_cv_func_free = no; then
    AC_LIBOBJ(free)
    AC_DEFINE(free, rpl_free,
      [Define to rpl_free if the replacement function should be used.])
  fi
])

# Prerequisites of lib/free.c.
AC_DEFUN([gl_PREREQ_FREE], [:])
