;;; quick-b5.el  -*- lexical-binding:t -*-
;; Quail package ‘chinese-b5-quick’
;;   Generated by the command ‘miscdic-convert’
;;   Source dictionary file: cangjie-table.b5
;;   Copyright notice of the source file
;;------------------------------------------------------
;; # Copyright 2001 Christian Wittern <wittern@iis.sinica.edu.tw>
;; #
;; # Permission to copy and distribute both modified and
;; # unmodified versions is granted without royalty provided
;; # this notice is preserved.
;;------------------------------------------------------

;;; Code:

(require 'quail)
(quail-define-package "chinese-b5-quick" "Chinese-BIG5" "簡B" t
"中文輸入【簡易】BIG5

	漢語簡易輸入鍵盤

   [Q 手] [W 田] [E 水] [R 口] [T 廿] [Y 卜] [U 山] [I 戈] [O 人] [P 心]

    [A 日] [S 尸] [D 木] [F 火] [G 土] [H 竹] [J 十] [L 中]

      [Z  ] [X 難] [C 金] [V 女] [B 月] [N 弓] [M 一]

\\<quail-translation-docstring>"
  '(("." . quail-next-translation-block)
   ("," . quail-prev-translation-block))
  nil nil)

(quail-define-rules
("a"	"日曰")
("aa"	"昌晶暑間暗曙昍暙闍閶閽闇")
("ab"	"明晞晴閒昺晡暠暪曘曞")
("ac"	"暝闐題曠顥顯晪暊曊闠")
("ad"	"杲昧閑旴冔暆閫闑")
("ae"	"曼最暇暖暴曖曝昄昅昹晙閿闅")
("af"	"景晾照煦暸闌闖炅炚晱焛暕煝暩暻鴠曛曣鱀鶗鶡鷃鷐鷴鷳曭")
("ag"	"旺量閏閨曜堲晊塈暀閮曈閵闉闛曤")
("ah"	"易閉暘影昒昐昜晜晹尟閟")
("ai"	"昤時閎閩閥曇旳昡戥暷")
("aj"	"早旱暉暈聞曄闡闢旰閈晬暔閛暲曋暺")
("ak"	"昊映閔闋旲旼旻猒暌晸暯暾閺曒闃闞曮")
("al"	"即昂昕晰閘昦昴郿鄤曏")
("am"	"旦昀星閂晅暄暨閆暡曌閾闒闟")
("an"	"門剔旯昑昲閌")
("ao"	"是曷晁閃歇閡闕昃欥昳暵暰曚歞")
("ap"	"昆匙悶曬昵曨")
("aq"	"闈暐暽韙闥")
("ar"	"昭晌問晤晷閣閤暱閭闊闆昫晑閜誾謈")
("as"	"昨勗曦昉昈昮晟晇勖閍")
("at"	"昇昱開盟闔關閞暟曀闓")
("au"	"巴冒既眉晃冕晚閱曉岊旵旽昢晥晛晼晻晲閐毼毷毾閹闀闚")
("av"	"艮晏晨暍曩閬闤")
("aw"	"晒闣")
("ax"	"閻閰")
("ay"	"晦閼")
("b"	"月")
("ba"	"脂睹貊賭膾贈胉眴腊睧腤膱賰瞷瞺")
("bb"	"朋肺骨脯睛賄膈冪瞞購髓肭豽睄睊睎睔腢膌瞝貒瞲膼臑矊髇")
("bc"	"貝具冥腆瞑瞋膩賺賸臏贖臢胑貁賏賟瞚膹頯瞶顐矉顝矌贔髍髕")
("bd"	"孚爭采脖睏睬睜瞇髁冞盱胣眛貤眯脬腜貅賝臊矂")
("be"	"受服肢股爰販愛腹腺骰滕膝眅朘脙脧腏睖睩朡腶皸賕瞍骳貑臌臒雘矎矍貜")
("bf"	"炙祭然賒膘瞟縣瞧瞭鵬騰鷂鸚睒瞅膆賧鴅瞗縢膫膴膲瞴繇臐鵙矄臕鵰鵩臙鶤鶪鶢鶻矘")
("bg"	"肚眶睦睢腫貍膛墾瞠雕瞳臃瞿雞胵眭脭脞脡脽塍睚腛雎膣膗朣膧臛矐臞矔")
("bh"	"彤盼眇豺財彩彫腸膠賜膨肜豸胏胗眕睇贂")
("bi"	"肘肱冠冤眩豹腑膊賤爵賻髑髖矚肕肒眃胘胠胕戙脟睋骫蜰膞膙螣臅臗蠈颻髆蠫")
("bj"	"罕肝軍脾睥賊辭盰肸豻眲睅脺睟腩骭膟貏賥瞕膵賱瞫瞱髀貚贉")
("bk"	"奚朕胭胸敗腋睽膜瞰网狊胈胦眹朠睙腠瞁瞙骹貕骾貘贆覹矙")
("bl"	"胛腳鼎肵盺胂眒胹郥郛鄆郹郻鄍賗骱鼏膷")
("bm"	"且肛胚胝腔腥睡賦囗盷胜眐脛貾貹腄貆翢瞈膕膻髊")
("bn"	"冗刖肌刪盯則剛胰貯骯肊刐刞肐盵肮肣胇眝胻剮眱眵脝貥腧睮貐甖")
("bo"	"冢眨眺豚腴貶睫睞賅骸臉朦瞼矇胅胍朒朓眣胲脁脥腞睼瞛瞨臄")
("bp"	"眠腮懇臆懸朧矓腍膍瞣骴貔")
("bq"	"用胖眸舜腱瞬眻貄膦瞵")
("br"	"同周胎胴胳貂貼貽貉賂瞎賠骷膳骼膽謄谿瞻贍冏咼朐胊眙眧眳腒睭腡膇賙賳貙髂譻")
("bs"	"凸肋助肪胯勝膀贓臟眄盻胙眑骻臇矏")
("bt"	"冊皿胼脰瞌瞪臚髒體豋膉膃賹贐")
("bu"	"甩目見乳岡肥肫盹胞胱脆脫覓腕腌亂睨貌罌朊朏眈眊胐乿脘脕睆睍睌腃貀貺睕睠腯瞃覞虢瞡膮膬賵覭覶氍髐鼆")
("bv"	"妥罔脈眼脤脹腰腿賑賬嬰膿臘髏盳眓胺眽腇媵腲膢瞜貗")
("bw"	"腦瞄貓腷膰")
("bx"	"舀臍")
("by"	"丹腓脢")
("c"	"金")
("ca"	"曾鉑錯鈤銆鍺錩錔錉鍇鐠鐕")
("cb"	"鈉鈽銷鋪錦鎬鎘鏑鑰鈅鈰鉔鉓銪鋗錆錥錹錋錀鍗鎙鏞鐍鏼鐹鑐鑈鑴")
("cc"	"釜貧頒頌鋇鎖鎮鐮鑽谼鉥錤錪鍞顉鎌鏔鐨鐀鐉鐼鑌鑕鑫")
("cd"	"銖錚鎳鑠釪釨鉌銤銌銇銝鋍錞錁鍒鍱鎎鎟鏬鏿鏶鐰鐷鑅")
("ce"	"鈑鈹錄鍍鍛鍰鏝鑤鈒鈙銢鋄銶鋟鋑錣鋷錂鍜鍐鍑鎪鎩鏮鏺鑀鑊鑗钁")
("cf"	"鍊鍬鎢鏢鏍鑣炃鈥鳻錟錼錝鎷鎍鵜鵒鏚鏣鐐鐎鶲钂")
("cg"	"鈕銓銼鋰錐鍾鏜鏗鐘鐵鑼坌釷鉒銍銈銋鋌錴鍠鍷鏙鑸鑵")
("ch"	"分弟鈔鉍銻錫鍚釤釮鈖銵鎀豂鏐鏒鐋鐊鐬銹")
("ci"	"公釵釣釩鈴鉉錢鏘鐲鑄谹釸鈦鈆鈜鈺鉧鉣銩鋐鋝鋨螸鎡鎒鎛鏹鏄鏀鐏鐖鑆鑮鑱钃")
("cj"	"針鋅鋒銲鏈鐸鑷釬鈄鉺銔錍錌鍕鎨鏎鐔鏵鑝")
("ck"	"父鈸鉸鎂鍥鏃攽敓釱鈌鉠銦鋘鍭豃鏌鐓鏾钀")
("cl"	"斧卻釧爺鉀鉚弚邠郤鈏釿銂鄫鋉鎯")
("cm"	"翁釭鈞鉗錘鏟鉦鉭鉏鉎鉽銊谾鋞錏鋋鍹鎉鎈鏏鑯")
("cn"	"剃爹釘釗鈐瓮釔釕釚釳鈧鉶鉹銕鋓鍆甑鍘鑏")
("co"	"欲欽鈇錠釽鉯鈲銚鋏錸鍉鎵鏇鏦鏷鐌鐻鐩鐱鑳")
("cp"	"忿慾鋼釴鈊鈚鉈鈮鈱銠鋱鋕憌錵鍶懖鎞鎴鏕鏸鐿豅鑢鑨")
("cq"	"鍵谻鉡鉾鍏鏻鐽")
("cr"	"谷釦鈷鉛鉤銅銘鉻鋁鋸錡錮鍋鎔鎚鎗鈳鉊鉆鈶鉰鉐谽銛銗鉿銣銡鋙鋯鋊鋦鋡錧錒錭鋿鍼鍣鍧鎝鎕鏂鐑鑩")
("cs"	"兮鈣鉅銬鋤鍔鎊鐫釢釫鈁鋮銙鐒鐪鑶")
("ct"	"盆鉼錳鎰鑑鑪弅鈃鋀錛鎧鎑鐙鑉")
("cu"	"兌岔爸鈍鉋銑銳鏡鐃釓毤鈀鈂鈗銃鉬銫銧鋎鋧錈鋺錓鋾鍎鎲鎤")
("cv"	"銀銨錶鏤鑲釹鉞銥鋃鋩鋠鋹鎃鍖鍻鍡鎱鐶鑞")
("cw"	"鈾鈿錙錨鐳鐺鎦鐇鑭")
("cx"	"鏽錎鍤鑇")
("cy"	"釙鉲鉖鋂")
("d"	"木")
("da"	"杳柏楮楷槽檜櫓栒栺棤棔椿榰榗槆槢樴橧橁櫡櫧")
("db"	"柿柄梢桶棘棗棉棚槁構橘橢橋朿枘柟栜栯梋桸棆棈楈楀楄楴楜椯榍榾樀樆樠槦樇檛檎檽檷韝欈")
("dc"	"棋楨槓頗橫賴檳櫃櫝朳枳柶柼栱梖椪椇榠槏槙樍賚樲橨樻檟櫇櫍欑韥")
("dd"	"李林株梱棵森榛樑橾杅杝杍柂栫桴桲梌梊棌椈棎棞棦椕椸楪楙楺榤樔樼橖檁韕韖韘櫟櫯")
("de"	"皮枝板梭梂棣椒樣隸极杸柀梫桼棱棷棳棴椵楥椴榎槾樧檓檴櫠櫌欉")
("df"	"杯杰柬紮棕焚楝禁標槭樵柰梑棪椋楸榚榪榡榞槂槱樏橑橪鶆鶇鶒鷘欓鸉欙")
("dg"	"杜枉柱框桂栓梃椎榷櫂檯權杻桎埜梐桯梩桷梉桽楏楻榳樘樦橦橍檉欋欏")
("dh"	"才材杉杪枴彬梯楊鬱枒枌柲桫梤棼楌樛槮橕檅")
("di"	"寸村杓松梵棧韌楓槐榭樽樹機檮櫥杈杋构枟柎柃蚻榑榯蜤槸槫橶檥檒欂欃蠜韣欘欚")
("dj"	"末杆杵枓枰梓桿棹楠楫榫樟樺皯枺栮桻椑椊楎槔榵韎槤槲樥橝橭樿檡櫆韗韟韡")
("dk"	"杖枚校敕梗楔模樊橄檄夬杕柍柭栚猌楱楩楑槉榩榽韍樉橔")
("dl"	"束析柳柙梆榔椰槨櫛朻柛桏栭栦楖梀梛郴郲棩郼鼒")
("dm"	"本杠柑查柢桓栩植極榻整檀枑枃柸柤柦栻桱翉椌椏棫梴楦楂棰槎槥槿樝槶橿櫪櫼欞")
("dn"	"刺杭杼剌栘桁榆檸刌朾朹机杚枔柫桋栵梣棽楟楋椼橩檦")
("do"	"來柩核桃楚樅樸橡檢檬枎杴柣柧柉栨梜欶棶椓楰椗椽僰樕槬橛檖檨檚檺櫞")
("dp"	"枇棍想懋麓欐朼杙杺杹柁柅栳惁棯棇楒憖橞檍櫳")
("dq"	"韋棒攀杽柈揧楗椲舝橉樨檞櫸")
("dr"	"杏枯柯枸桔桐格梧棺椅楛榕槍槌樞檐櫚礬櫺柘枷柌枮栝桮梮梏梒桾梠棓椐棝椆椥楉楁椷榶榙韐橏檹檶櫙櫮")
("ds"	"朽枋柞楞榜榨朸杇枍柜枵柺柪栲桍梬樗橯檇櫋")
("dt"	"柵械楹橙檻枅枻柆栟梇梪榼榿榓橀韞櫨")
("du"	"札杞枕杷相梳桅皰梔梡概楣榣橇橈櫬欖杌杬杶枆枙柷柮枹桄梲棬棡楯榹榥樈槻槴檤櫏")
("dv"	"根婪棲樓櫻桉桹桭桵椄棖椹楬椳椻榱榬榐樾橠韔檭櫰欀")
("dw"	"東柚棟榴檔檣欄栖椔楢楅瑍榃樄橎檑櫑欗")
("dx"	"樁韜槄橚櫅櫹")
("dy"	"朴柝梅柊栴棜棑榧檌")
("e"	"水")
("ea"	"汨泊洵渚湣漕潛澗汩沓涾涽淐湆湝湷滏潳潽潧潪澮瀦")
("eb"	"沛洧消浦涓涌清淪淆湖渭湍溯溝滑漓滴漏滿滯潸潮濡瀰灞汭淯浠淜湇湑湡渧滈滆溎溍漘漰滫潃滽潏潲濄澫濔濿濷瀡瀹灊")
("ec"	"泗洪淇淦滇演漬潰潠濂澦濱瀆瀨瀕汃泬沭浿浾湴淟湞溟溓滜濆澒潢潩鋈澬鎏鍌鍙瀇濻瀢瀩顙瀵瀷瀻灒灝灦灨")
("ed"	"汙池沐沬染柒桑浮梁淳淋深淨游渠溧粱滌潺澡灤洊洙浡涍涂浨涃淭淉淗渫湤溱滁滘溙滹漅澖潗澯澲濼")
("ee"	"沒汲泳波浸浚淑涵渡湲漾漆漫潑澱濩瀑汳汥沝淩淥敪淼溰滱漃漮澓潻濴濲瀔瀀瀫灁")
("ef"	"涼淙淡源滅漂漯漁潦潔潟燙濕鴻瀉鯊沶洃溈湅渿湠湫溔溹溲漹漈潶潕潐潫澋澿濝瀌瀠鵽瀿瀳鸂")
("eg"	"汪注浬涅涯淫淮渥湮湩湟塗溼潼潤濯濰灌灘圣洭洼洷垽浧淕堻湹塣溦漼漜漟澭濉瀍瀅瀖灈灉灅灕")
("eh"	"沙汾泌涕涉湯渺滲澎沏沕泲沴浵漻滮漡濊濏灪")
("ei"	"叉汐汍汎汰法泓泠蚤淺淞滋溥滷潯濁濤濺汊汋沄汯泫泭浤涐淂渢溽溞溾漙漒澍澐濈澪濧璗瀎瀜灂瀺灟魙")
("ej"	"汁汗汛沫洱淬湃渾滓準漳漣潭澤汻泙涆涬淖湳渳湒滸滭潬澕澣澼濣濢灄灛")
("ek"	"決沃汶泱洶液淚湊渙溪溴漠澈澳激瀲汏汱沷洨洑浂洇洢浭浟涘涋洖淏渼渜湀湨湥渶潎漵滶漺澉澂潡潣澞")
("el"	"沖沂泖洲浙淵淅湎漸汌沜洏浺洍涑淠漷澌濎瀄濞")
("em"	"江沍沮泜洹涇涎渲渣溺澶澀瀚瀝沚泔泍泹泩涳淢淔淽渱湦溠滻漍澅潝瀣瀸灗")
("en"	"汀汽沆沸洌涔涮湔測渝濘瀏瀛灣氿汔沀泞洟洬洐剟浰淛渟漧滼瀱")
("eo"	"泅泛洮浹涿漩漢漱濠濛濮泆泒浞淀淶欼湜溛溷潀漇漎潒濋澽澨澰歠")
("ep"	"沁沘沱泥泯洩涊添混懣濾灑汦沎泚淴淰惉溒漉漶潓澺澸濍濦濨懘瀧瀗")
("eq"	"洋津泮洚洠浶挲湋湕滃潾潿潷澥")
("er"	"河沽沾沼沿治洞活洽洛浴浩淌涸涪減渦溶滄漪澹呇泂泃泀泇沰洳洄洺洁洉涒浯浻涫涺淍涻湉渽湁渃渮湱渹硰溏滒碆漚澔潞瀯")
("es"	"污沔湧渤滂氻汸泐洰泑洿洘涄淓澇")
("et"	"泣泄洫盜溢溘溫澄澧濫盪瀘汧汫洴浢渀盓渰湓漭濜濭瀊灃灆灩")
("eu"	"氾汕沈沉沅沌況泡流洗洸洎浥淹淘港湘溉湄滬澆澠濬汜沋沇泏洈浣浘涗浼涀涴淈淝淲淣毲渻湸湚滉滵漞瀙灀灚灠")
("ev"	"汝派娑浪婆淒湛渴裟滾漲濃澴汒泧洝浽渨滖滍漊瀁瀤瀼瀴灢")
("ew"	"油酒淄溜潘瀋瀾沺洒浀涷湢渵滀濇澢灡")
("ex"	"滔濟瀟淊潚")
("ey"	"汴海淤泝洀灖")
("f"	"火")
("fa"	"粕嘗熾燴糟焟粨熠糌熸糬")
("fb"	"肖炳脊常烯幣精糊燸糯帣烠烳焆焨煇煲煪熇熁膋熵熥糈燏燆糒燤爚糲")
("fc"	"烘煩賞糞類烡熐熉頖熿熼燲顃鎣爌纇顲")
("fd"	"米籽棠煤榮燦燥爍灺炑烰焞溳滐熂粿糅燊爃")
("fe"	"叛煆煖燮燬糠爆粄焌敥滎熳燰")
("ff"	"炎煉熒粽燎燃糕縈燻黨鶯鱉焱絭煂熛禜燋燚爊鶺鷩爣")
("fg"	"灶堂雀塋煙煌瑩糧耀炄炷烓烇粈烶煁煡粴觠熞燿爅爟粧")
("fh"	"少券炒粉煬糝灱粅焍烿牚爩")
("fi"	"灼炫螢燭糰炂炩籿燖燇糔糐燨糨蟞燽爝爞蠽")
("fj"	"料焊烽粹輝炓籵籸粁粖焠焯溤溮煣粺熚燂燀燁燡")
("fk"	"尖敉敝敞煥粳燉燠糢炔炆炴粀焲煸獘燘糗")
("fl"	"鄰炘粌郯")
("fm"	"粗煽灴炟炡烜烒烴烻焢糑翷爧")
("fn"	"判炕削彆弮籺剡烆瑐瓽熪甇糋甐")
("fo"	"炊豢燧尐烑烗烼欻焮熯蹩")
("fp"	"焜熄燜斃烢憋熝熜燱麊")
("fq"	"半拳烊掌犖燐牶揱溿煒韏")
("fr"	"尚炯炤烙焙熔糖營糙烔烚焗焐焓焀粘粡溡煠煢煻熗熰謍")
("fs"	"劣炬炸烤勞粔爔")
("ft"	"粒煜弊燈燼爐烅粣焺熅熆熤爁糮")
("fu"	"光卷炮省眷氅燒瞥炖炾党烍粑粍烷焥亃溗粯熀熩覢罃覮虩鄨齤爦")
("fv"	"煨裳籹烺嫈滊嫳粻粼熡褮爙")
("fw"	"當爛粞煔燔醟糷")
("fx"	"焰熽爓")
("fy"	"炵烞烸")
("g"	"土")
("ga"	"堵增赭馨堷韾")
("gb"	"冉埔堉趙幫壩埇埽堋埥堣堶塉塙塥墉墆塴墑壖趫毊")
("gc"	"赤填赫墳賣頡壙贅埧塓塤趛鋆赬贄壝趪鏊鏧顤趲")
("gd"	"地圩垀垛垺埻堔堁埩埰堞塛趎趓槷趜壈趮")
("ge"	"圾坡赧報殼鼓穀趣轂夌埐埭堎埱嗀彀嗀墁榖漀瞉敼縠赮觳豰皾鷇")
("gf"	"坏塢熬熱熹壎燾埮堜墂燅縶鴶趭鵱驁騺鰲鷙")
("gg"	"圭埋堆墊臺坴垤垚埕埆堐堙堹堭墔趖墥趡趯鼞")
("gh"	"場彭趁坋埸赻趀墋")
("gi"	"去寺封執塊塒壽螫圴坶坽埒埶堍堸尌赨塼墫壿螜壔螯蟄鼜")
("gj"	"坪幸埠埤趕聱聲鼙毐垶赶埣墇墠趠墿鞤")
("gk"	"埂埃敖赦堠塽墩坱垘赽堧塻獒墽墺壧")
("gl"	"圳圻坤赳郝邽邿垹墎鼘")
("gm"	"址均坩坦垣域壺塌墟壇翹壢坯坵坻埴埏埡赹堩埵趄塕堽壼趐墐翿")
("gn"	"坑圢圪坅刲坲垿埁堬趍趔墘甏")
("go"	"坎走垓堤款塚壕垗欯瑗趑趒墣壉歖趧")
("gp"	"志懿坁坭坨垞恚塨塶愨慹")
("gq"	"墀摯坢垟垏埲煓摮摰")
("gr"	"吉坷垢培喜堝超嗇塘塔嘉趟磬坫坰垌垥埼堌堿塎趌趏墡赯謷謦謺嚭鼛囍")
("gs"	"圬劫坊城垮勢劼坳赲堮塝墈壾")
("gt"	"垃盍壹塭壴塏墱壏壒盩壚壣")
("gu"	"圯起堯境罄趨瞽鼇圠圮坉垝垙垸赸埢堀堈堄堳趉亄赩覟墝鼁鼀趬覿")
("gv"	"垠袁喪堪堰越壞壤垵埌堨塿朅鼚")
("gw"	"墦埬堛塯趥墻")
("gx"	"埳壛")
("gy"	"坍卦坼赴鼕")
("h"	"竹")
("ha"	"白昏徇香舶筍箔箸稽簪簡籍昋昝皙稓皛氆徻濌簎艚氌穭馫")
("hb"	"帛肩帥師稍稀策犒稱稿篇篙篩歸魎魑籥帠舑幋稐筩筲艄犕稰稨箐箍皜艑犞篝篟穚篱艜魈簥犡簼簻鶳鼱黐")
("hc"	"貿須箕與質積興頹輿颶簧簣犢簾贊顧籟黌籲秫犋舼稘頎稹篊頧篔篢鴥穔簀顊顅簨魌穨馦鶀穬籅鼰贕鼸籫軉")
("hd"	"乎禾朱朵牠釆季竽徐臬梨梟稞躲孵槃箏魅學築篠牸秝棨犉稃稌稕稛筡艀艅箖箘箷艓篥篨馞鵌皪")
("he"	"反役彼後段泉皈叟殷舨般毬復黍毀稜稷黎艘馥穫簸颼籐殳彶笈笝笯徦稄煰稯箙鬾艐毈毇澩鵔犦忁籙齂艭犪鸔灥")
("hf"	"系秋烏鳥毯鳳禦篤鵝鵠纂鱟爨衃徖扊舄熏綮舕熧穄篜縏鴔鴩鴟燢穛篻鴸鴰鵅鵃鴭簝鵖鵚爂犥鯬鵳鶂鵯鵹皫穮鶞鶣鶖黧飉魒鷎鶹鷌鷍鷑鷮鷭鷽鸄鸒")
("hg"	"壬牡往皇重凰徨程筐雇稚艇種雒篁籬籮垕垼牷衄秷觕筌筀稑筳艎壆犝篞篧穜簊艟魋鵻籉籊觷鼮籗籦")
("hh"	"身物秒秘第穆穋穢颺釁舠牬秎秭笏牻笫稊颩颬馝篎穇篸鼢簜飂飋")
("hi"	"凡么丟夙舟卵我私的待禹風射特鬼得符舷等筏箋魄篡篾魏簿籌彴彸牣彾瓝牳皊蚕笭舲皒蛗睾箹蝵斶穖篿螽簙艤颾鼭璺衊皭穱籛魕艬瓥鸃")
("hj"	"千卑阜拜科竿皋秤秣稈筑箄魁篷聳鼾簞釋夆皁戽毧斞衈煐稗筸艂箤皞篳簟簰簳鞶轝籜鼲")
("hk"	"夭囪戾牧秧笑臭啟皎奧微筷徹徵篌鴃徽簇黴囟笅筊徯煟筱徶瞂氁箯魃徼敿徾簆鼤鼣皦簢鼥籔鰴鼵鼳鷻鼷")
("hl"	"斤卯印卹所秉邸卿御郵節鼻鄱卬种邾郋郈舯郜筇笚舺郳郫笻鄅鄔鄋鄎箅鄡鬿鄮篽篰酇籪")
("hm"	"氐生征竺垂牲牴徑扇租甜笨笙筠筵箝箠翩篛翱錕翻籤徂彽笁舡迣甡秠秪笉牼笪犆煘稙稢箜艖鬳簅篲簂魊鼪舋魖齇")
("hn"	"几行利刮制剁彿衍航躬移術剩街衙銜劉箭衛衝劓衡衢衎笐笒笰衒衖衕鳦瑏筣鳧甀甂甃箌劄甈箾衚颲鼽簃齀籈劗籯")
("ho"	"八爪乏失瓜欣臾徒秩徙從徠筮稼篆簌歟簽彳瓞笊徥筄臮歃筴歍歋箑箛箂篋篴簁簐穟艞籇艨躗籧")
("hp"	"氏牝皂乖忝怎乘息舐悉舵愁愆稔慇舔德慫憩篦鴕穗懲穩籠乇秅秕秖秜笓皉秺笢毸馜簏颸徿犤")
("hq"	"牛律徉犁掣筆毽肇舉甪牪徫舽揫煋搫稦徲篫犩")
("hr"	"各向后舌吞告和咎徊牯徜笞船喬犄皓筒答稠管箇颱磐箴躺颳艙黏軀簷鼯譽扂扃秮徛徟牾牿秸笴笥笤笳笘笱笸舸毰筈筎筘稒筥筶犗箈颭箬簉礐簭鼫鼩礜簬齁嚳譥讆")
("hs"	"戶乍彷秀房舫動笮甥筋徬粵舅勳犧牞劮竻勂秬舴舿筰勫篣艕簩艣軂籩")
("ht"	"升血扁笠算艋皚盤盥籃艦盉笄舁皏笲筭篕艗簋簠簦馧鵿籚艫")
("hu"	"毛卮先自禿兒爬秈看盾舢島笆兜扈嵇循皖稅筧箱範覺癿戺峊秏毨瓟眚笎舥虒笵笣兟毳犈犅筅徭筦艉覛犓穊箎颮皝箵艏艒覣嶨嶴篹篪篘臲穘馣鷈鼶齆")
("hv"	"委很裊鼠製簑簍穠魍鼴笀扆媝稂媻筤嬃魆褩躽艛犣忀穰齃齈齉")
("hw"	"留笛番釉穡鼬籀籣徆牰毢秞舳稫皤簹艡籓飀")
("hx"	"臼稻簫臿穧艩")
("hy"	"冬斥徘扉靠箊篚馡鼨")
("i"	"戈")
("ia"	"昶庴廜廥禬")
("ib"	"甫席朗庸廟膺禸凊廗禘禰禲禴")
("ic"	"朮麻貳廉祺資禎廣賡鏖麒凎剢貣貵廎廙禛顑顣黂禷禶")
("id"	"床凜糜麋祂庥枲凈庨栥祩秶粢楶祼禖廩穈麇麜")
("ie"	"永冰求度凌康廄皴廈祿廢慶庋祋庪庱祲廋禐黀麚")
("if"	"為庶戚馮熊鳶鷓鷹炱絫廌緳廡禚禡麃凞鴘縻鴾鵏鶊鶶鷛爢")
("ig"	"社准庭座塵庄庢凐隿凗塱塺禋廛觱麈廱")
("ih"	"戊祕參廖尨庌庬禓")
("ii"	"戍冷府麼廚禱魔麝戔礿庤尃祔祛廆廕螚禨螷飆蠯")
("ij"	"戎庫禪庳軬祽禈廦禫麛")
("ik"	"犬矣祆救廠敷犮冹祅祓猋廒禊麌")
("il"	"州祁祈郎神廊廓臧鄘廝庍邰祌祄郕郙鄬凘鄜鄺")
("im"	"式戌底或祉祖祗冱彧祤廑禢禤麆麠")
("in"	"划序冽瓷廁麂庈剆瓵剫剼劘")
("io"	"之次庚庾腐凝蹙庂庣欴祑庹庲欸祧禔禒廞禭")
("ip"	"弋庇怠祇恣能鹿惑感態慼憑應龐廳庀忒庛怷麀廘禗慦廲麤")
("iq"	"牟庠祥摩麟禕犘廨廯")
("ir"	"台冶店咨咸凋唐祐祠禍磨禧冾凅祏祜祒祫凔祰禂麔麙")
("is"	"成祚礽祊")
("it"	"弁戒盛盞禮廬庰盚祴廅")
("iu"	"允尤庖祀祝庵廂視麾庉冼祪祹毿禠麍麑")
("iv"	"良姿威裘禳戉凄祣祳廔餈麎廮")
("iw"	"凍畚福庮廇廧")
("ix"	"麡")
("iy"	"靡")
("j"	"十")
("ja"	"者耆宿暫窨")
("jb"	"帘宥胡宵寓朝輔輛輪轎竊巿窉軜寎輎輤輣輲麶")
("jc"	"穴真寅賁實賓戴賽額鏨顛寶竇寊軹寘輁頍窴賨頞顁轒鑋")
("jd"	"未字宇孝孛宋案栽寐窠寨榦麴穻寀窏窙孷槧輠橐窱輮寱檕轃轈櫜轏轢")
("je"	"支寇寂寢輟軗寑寖嘏毄漦輘輹鼖")
("jf"	"宗索煮察寮寫窯鴣繫騫寪輬鳷窵鴳鵓轑鵷鶈鶟鶘鶦鶷鷏鶾鶱鷒鸋")
("jg"	"室窒耋塞輊塹截窪釐窐軠臷軴輇漥墼雗")
("jh"	"穿寡寥宓軫剺轇")
("ji"	"守宏軔專麥博戟蜜寬轉蠹穸軓蛓軵軨戭輚攳螒麮蟗蟿轙轛")
("jj"	"廾車南宰軒辜幹載斡輯轟軯窣窲轋轚")
("jk"	"丈吏故突教窗較寞輳竅轍宎穾軑窔軷軮窫")
("jl"	"宦斬都麵宧窌郣郪輀鄟窷")
("jm"	"士宜直空宣翅軾輕翰窿矗軧窢翥翸轣")
("jn"	"究事穹剋軌剜乾割寧窮輸宁宄穵剚軡軶剸窬麧")
("jo"	"定家窕軟軼麩疌宨窆窊寁寔胾軱寙輆疐窳歕寲窾蹇蹔斄轐")
("jp"	"它宅老惠輥憲寵軝悹惌窸轆轗")
("jq"	"牢搴犛擊韓轔甯麰")
("jr"	"古官哉客害宮容寄窘窖軻寤窩豁轄宕耇宭軺軥軩輅寣輑輍輖磛輷謇")
("js"	"考協勃窄窈勀宬寯")
("jt"	"卉寍軿轀轞轤麷")
("ju"	"七克完宛軋耄軏密軛窟兢輒輓窺宒窀窅窋窇軘軞寋軦輐氂輗輴麭竀竁罊覾")
("jv"	"安妻宴宸裁輞寰輾轅竄囊嫠寠窶褰輵轕轘")
("jw"	"宙富軸審輜輻酨輶轓轖轠")
("jx"	"窞")
("jy"	"寒輈")
("k"	"大乂")
("ka"	"旭奢猖奭旮瓡瘏痻瘖獪癐")
("kb"	"布有希肴狷病脅帶猜痛獅猾瘠瘸瘺癘癟冇狶猏痏猢猵痡痟尳痭獝獢獳獮癇獼癵")
("kc"	"狽賀痲頰獷獺癩癲狖疻頄痶獚瘨癪")
("kd"	"存架猓猙痳狳猱痚犑痵")
("ke"	"友疫疲殺痠瘦瘢獲狻攲敧殽猳猣犍獌瘕瘝癈獶癜獿玃")
("kf"	"灰狄奈疢痰鳩駕療鵪狋煍煚綔獠獡瘭瘵瘰鴐獯鴮鵊鵗鵟鵸鷞鷯鸑")
("kg"	"在狂奎狸痊雄玀癱尪狃狅狴疰尰痤痽獞瘞獾癰")
("kh"	"疹瘍犽猀痧痝獩瘳")
("ki"	"丸太狩套痔奪瘋獨厹尥狑痋猦煄瘙瘣")
("kj"	"瘁痺獐瘴癖犴狨耷猝猈癉奲")
("kk"	"爻狡疾爽猴獄瘓癥猰瘈瘊獙獥瘯瘼癓玁")
("kl"	"尬狎疥郁夼狆奅狾郟郗郩痹奫獑癤玂")
("km"	"左狙症疳疽疸猩痙弒瘧狉狚狌疘狟翃狿戫瘥瘽癃")
("kn"	"九刈夷疙剎痍痢瘉獰犰犵犺疔刳狒奓剞猁疿猘痑瓻痸瘌")
("ko"	"夾狐疚狹瓠獗癡狣疺欷痎欹猭瓿瘃瘐獛瘚獫瘲閷")
("kp"	"疵痣勰癒癮疕狔狫疧疪悐猑瘜瘛瘱")
("kq"	"癬羍痒獬")
("kr"	"加右奇狗痂痞痴奩瘩瘡狜狤狪訄哿狺痁痀猗猞痌痐猧痦犌瑔痯痾痼瘑瘔癚")
("ks"	"力夸癆夯劦痄")
("kt"	"奔猛盔痘瘟尷狦疶")
("ku"	"尢犯奄疝疤疣匏癌狁毠峱虓猇猊馗毻牏瓾痷獍獟")
("kv"	"狠狼痕袈猥猿痿獵癢奿狘姭猲獦獧癙獽癭")
("kw"	"猶瘤奮癗")
("kx"	"癠")
("ky"	"疼瘀痱犿痗")
("l"	"中")
("la"	"帕書褚幟褶蚎衵帾袙蛨袹蝫蜡裮蝔螬蟙襘蠩襫")
("lb"	"巾冑胄背蛹補蜻牖蝴蝙褊鬧蠕蠣帩蚋衲蚺蛃袡蛸蜎蜅裐蜦裲蝑蝟蝺褅褙螖螄褯螪螭螮褵蟜襋襉襦蠵")
("lc"	"幀費貴順頫冀螟鬨牘袕幁幎幊幘蜞幩蝜蝢賮螾蟦蟥蟤蟘蠀蠊蠙襭襩襶")
("ld"	"蛛牒裸蝶褓衪蚞袘棐袸袾蜉蜍裍蜳蜾蜠蝣蝚褋幧螓褬蟂蟝蠂襙蠑")
("le"	"版被幔蝦複帔沊蚑衱衼蚾蛷蝃蜬蝂裰裬蝯蝬蝮褑蟃襏蠖襮蠼")
("lf"	"鴆螞鴦螺襟朄裧幠幜蟡螈螐蟅螵褾蟟蟔蟭鷜鷫")
("lg"	"衽帷蛀蛙蛭蜓裡幢蝗螳幄蜌裎蜼蝩螲蟶蠗蠸蠷")
("lh"	"初衫蚜暢蜴虭蚡衯袗蛖幓裼蝪蟉襂蟛")
("li"	"帆虫蚣蛉蛾褥蟲蟻襪虳衩帴蚿蚹袨袪牋蛶蜙蜚螝幬襁幭幮蟳蟣襑蠋襡蠛襺襼蠾")
("lj"	"蚪蚌牌蜂幛裨蝌輩褲蟀蟑蟬虷蜱幝蝻褌褳蟫襌蠌襗")
("lk"	"史央蚊袂斐蛟袱蜈數蟆襖帗蚗蚥奜蛂袚蛜裀幙蜧蝡蝧褉螏螇螑襒鬫")
("ll"	"川片申串邶蚓蜥螂邥虯蚚蚧衶鄁蝍蜵裫蝒鄪幯螹襣")
("lm"	"虹韭晝蚶蛆蚯袒畫幗翡蟈蚐袀蚳蚽袛袓蛵蜮蜒蝖螉褟螼蟺襢蠮襳")
("ln"	"弗鬥蜊劃蝓褕帄刜虰虮虼剕蚢蚙衿蛦蛚煃蝏")
("lo"	"兆蠍蠔帙蚨蚇衭蛈蛌袟幏蛺蜁裌蜨蝭蝝褆褖幪褷蟓襆襐襚襝蠓")
("lp"	"北曳忠衹患蛇悲蟋襬虴蚍蚔袉螅褦螰蟌蟪幰蠬襱襹")
("lq"	"聿羋幃牉袢蛘蛑袶蝆褘襻")
("lr"	"帖蛄蚵蛔蛤蛞裙裕蜘蜩裯蝸褡蟾帢牊蛁蛅蚼袑袧蛣袺袼袷袽蜛裾幨螛螗褣蟢襜")
("ls"	"蚱螃甹蚷蚴袎牓蟧")
("lt"	"盅盎盡蜢蟒襤蠱帡蛢裋螘蝹褞蠦衋")
("lu"	"儿胤袍帽幌蛻蜆覜蜿蜷褫蟯蠅襯冘帊帎帨蚖蚆蚅蚘蚝衴艴蛫裗裞蜣蜪蜺裷裺氀蝷蝞蝐螔褼襓鬩鬮")
("lv"	"虻婁帳裴褐褪螻褸蠟婓蛝裉蜋蜄裖蜲裱蝘蝛蝎褗螁餥蠉襛蠰蠳")
("lw"	"由袖幅蛐幡蝠蟠襠丳蚰蝀蝤褔蟷蠝襴")
("lx"	"肅幍蜭蠐蠨")
("ly"	"非褂蚸裶蝳")
("m"	"一")
("ma"	"百珀厝晉殉豬醋曆珣朁殙琩皕瑄碏酯璔醏璯磳霫")
("mb"	"丙再玥珮砸脣硝瑚瑞硼厲璃霄礪霸襾珃珛琄琋獀碃碖碲碥豨酺酳殢璊碻霈璚磞磭醐醑礄瓀醨鬵瓋礝醹瓗")
("mc"	"頁貢頂琪項碰碘賈頑頊瑣碩璜磧頸頭磺殯願礦贗瓚珙珼厧琠頇殞瑱銎殥磏磌豏霟璸璵霣殰礗豶霬礥礩顠礸")
("md"	"于厚栗殊珠硃琳琛粟酥碟酵酴醇臻霖璨礫玗矷孬珔酏殍琈厤琤硱硢碄碅碀雽瑧瑮璅瑹磔磉醂霂璪磼磲醚櫫瓅醾")
("me"	"汞歿泵玻夏破球豉瑕碌酸憂豭璦霞覆瓊醱砅砐砓砯殏酘殔琡琭猺瑑碫碬醊醁醙瓁夒鬷靆靉")
("mf"	"不示原烈焉票瑪碳碼鴉璟礁醮鵡醺烎琮琰鳱殦鳽鳿鴀鴈磩磥豲鮤鴯鴷燹醥鵛礤鶝礯鷊鷅瓙醼鷣鷢鸍黶鸝")
("mg"	"王至玨型班珪堊理斑雁雅碓璀確霆霍壓霪霾厔厘垔砫珵珽硅确臸雃酲醀璡磪醛礭瓘靃")
("mh"	"牙形珍砂砌瑟殤厂厊歾玡玢厖殄珌砑砏耏珶酚硥雰獂獊覅雺彯碭璆磣磟璱醪霦鬺")
("mi"	"云歹玉瓦矽玲耐虺砝辱酌戛殘琺雲蜃零瑰磁魂璣磚融磯醜璽飄蠶魘玊玓玹砡砪砱酎珴琖硪蛩硹戩瑵蝁酹瑼磈醆璕磠霐礒蟨礡霨礣蠠霵釂")
("mj"	"干平砰覃琿碎碑璋醉鞏霹玕玤玝矸厗厙玶珥酐硨璉豍殫璭磹磾璻礔醰鞷醳")
("mk"	"天攻更玟玫政殃致敔酗敢硬雯瑛厭爾霰釅奀攷殀玦耎珓珚琝瑒雵殠碤璈磎磝磢璥礅豯霙礉璷覈霺瓛礹")
("ml"	"而邢邪斫面砷鬲琊瑯酬需酈靨丌亓邗邘邛玔邧玠邴邳珅玾珋砎郅郖郠郚奡鄄鄏鄑鄠鄢鄾厴霩酃")
("mm"	"二三工互五丕正亙酉亞武亟歪砥砠雪殖甦酣硿瑾磋歷翮醒殲靂靈厎巠玒矼殂玵珇珝砵豇厜殌硜殛犐瑋碔雸瑳碴硾殣殭翲醝礓靋")
("mn"	"丁刊列刑到酊副琍硎琴剽瑜劂甄亍刓玎瓨矻剄珩砨砩琌豟獉碠霒霠")
("mo"	"仄巫玖豕兩砍砭厥琢歌璞瓢殮璩礎礙豖砆珧豗殎琁珿覂硤歅猻碇豥跫豩雿璇瑽醍璲豵霥礞醭醵")
("mp"	"死玳恐惡琵琨愿麗瓏忑玭矺砒恧玼砣酡璁憨麉醷靇釃")
("mq"	"甭璘磷肂珜珒硉琫揅猼")
("mr"	"可石吾否殆玷哥唇珞砧琯琦碉酪酩瑭碧酷磊噩霑醣露珂珈玿珆珨砢砳珸琀珺硈硌硐殕琚琱琣硞酤酟酠犎碚碕酮厬瑢瑲碢磍磄醅霅璐礂霘霝磿醧醽")
("ms"	"丐功巧勁砟雩磅勵霧万丏厏琇臹酢雱磡醡")
("mt"	"弄豆盂珊盃研磕磴醞醴幵玴殈砬豜殟磑殪璒醓豱醢醠璶瓂醯礛豷霯")
("mu"	"兀元厄玩琉砲配現硫琥琶硯瑁碗電雹瑤豌醃霓靦霜璿兀旡厒矹卼珫玸珖珗殑硊豝酖酕殗琬巰瑊碙覝覡磃醄殧虣磽黿礵霿")
("mv"	"辰耍要琅裂碣碾震霎環餮瓖瓔饜釀靄匚姴硍硠硭豤碪碨霋嬮霢醲霮")
("mw"	"西瑙雷霤硒璠璫磻礌礑瓃礧")
("mx"	"霽璾")
("my"	"下雨霉霏玬砃厞珘琲碡")
("n"	"弓")
("na"	"陌階魯鯧鰭陼矠觰鮨鰆鰼鰽鱠鱨")
("nb"	"胥隋隅隔隨孺彌鮪鯖陃陏弰脀弸陯魶隬鯆鮹鯞鰅鰗鰝鰤鬻鱊鱎觿鱱")
("nc"	"小負隕預夤隒彉隤頠頲鍪顄鯕鐆鰜鰿鱮")
("nd"	"子孕弛柔桀除穌孖阤陎陱楘鮇檃鮢鮽鯙鯚鰈鰇觻鰷鱢鱳")
("ne"	"及阪函陂陵陬發鰥觼鰻夃氶弢癹觙觩觨敻魬鯄鯪鯫鰒彏鱍")
("nf"	"灸孫魚煞隙際燄鴛鯀騖鯨鰍鶸鰾尕烝孮弶鳵駌隰鮛鵵騭鶔鶩鰶觾鷸")
("ng"	"丑廷角陛陞陸隍墜墮鮭鯉堥隉隀觟墬鯥鰉鰹鱹")
("nh"	"矛陽觴陟魛魦魵鮅鯓")
("ni"	"夕弘多兔弦虱附強蛋陰蝨毚蟹觸弣阹戣戤触隗蜑魡蝥魼鮒蟊螴鰣瓕鱄鱒鱘鱴")
("nj"	"阡弭陣斛陴障彈鰱阠彃鞪觶鱆")
("nk"	"又孜奐癸鮫觖陾隞敶魰隩鯁鯸鰬")
("nl"	"弔引鄧鯽觓陑郔鄈觫鼐魻鮞酁")
("nm"	"孑丞延阻弱陘隆陲彊疆阯弤阺弳孲翗觝觛隓隡魟魱魾魽鰨鱈鱋鱣")
("nn"	"了予阬矜弼粥凳阣陊隃劀魧甔劖")
("no"	"久孓欠疋孤弧承孩飛陡陝象隊隄豫隧險鱖陔陜欿觚鮂鮡鯠鯷鱁鱌")
("np"	"陀急怨恿隱隴鰓阰愻魠魤鮀隳鯤鯰鱺")
("nq"	"舛甬建降解鮮鱗丮觲鰎")
("nr"	"名阿夠陪詹鯛鱔鱷弨阽陭矞觡彄觭鮐魺鮕鮈鮚鮦鮥鮯謽鯃鮶鯦鰔鰫鱵")
("ns"	"乃防勇勉觔務阞阼陓魴鮓鰳")
("nt"	"阱孟盈登隘鱸盄隑孻鱧")
("nu"	"乙孔危色免阮院疏陶魷鮑龜夗阢弝阨阭孢巹眢觥觤瞀嶞觬隢魨氄郺鮠鯇鮿鮵鮸鯢鰩鱙鱦")
("nv"	"限陋張飧妴婺隇隈彋鯜鰋鱞")
("nw"	"陳鯔鰡鱕")
("nx"	"陷卍隮鱐鱭")
("ny"	"外陫鯡")
("o"	"人")
("oa"	"伯佰借倡偺偕智會僧僭儈儲侚偣偆傮僣矰韽龤")
("ob"	"內佈佩佾侑俑俏倩倆倫偶偏脩備傭禽飾僑僩儒餚矯伂仴氝俙倗偝偁偊偳傋氰傰僪舖餔餬龠")
("oc"	"兵供俱偵貨貪貸債傾賃僎領價頜儐頷償仈伿倛倎偩傔傎僋僨僓儥鎥饙饌饋儹顩饡")
("od"	"仔他休余侏保俘氣條傑集餘柋栠偞偨僳僝餑橆罅餼饓龢")
("oe"	"伋侵俊隻假氯飯傻優雙餿饅伎汆俅复倰俶夎敆傣僈僾餕餟儤瀪矱")
("of"	"伙你係偽氮焦無絛僚鴒繁鴿黛鯈鶴儻尒伓佘倞倓倷倧烋缹偢焂傃傌傿僄傺傶溣僬儰僸鳹儑餤鴙儦鵂鵀儵鵨鶬儽鷡鷦鸙")
("og"	"仕任全住坐佳佺隹俚堡飪催雉僮僱儸罐侄侳俇侹倠偓偅偟傕矬雂僿雓儓雔餭饈儺糴讎雥")
("oh"	"入乒份氛修傷僇伢佖飶儩餳饖")
("oi"	"付令仞乓伐伶每侍俄俯傅傀傳蝕儀餓儔餞餽儳饑饞伀伝佉伭俬俴倯偫偑僔戧餺")
("oj"	"什午仟倖俾斜傘餌僻罈仵伻佴倅倬隼偮傇傽僆僤鞗餫")
("ok"	"仗矢伊伏攸使侯便俟倣候氤缺做倏敏敘傚傲餃斂儼佒佼俁矨偰偀傒敜飫傸餀儆儌餪餱饃")
("ol"	"介仲仰伸卸命邱郃偭氕价伄伒氘氚侕氠矧鄇鄃飹鄦餗鄶")
("om"	"仁丘伍企佐但低俎缸倥值氫缽翎氬翕僅僵饉仨仜仩仝体伾俓倵倕傞傝翛儃韱儮饘")
("on"	"乞仃仇今伉佇佛例侈俐俞氟倒們飢停側偷創舒劍劊仉气仡仱刉佤侀侇侺剉倳瓴飣劁儜儚甒餰")
("oo"	"伕肉似佚佻俠促氦傢飲僕像儉歙伬侅佽肏倢欱偍傱僉歈僛跾儊儗餩歛餯饛")
("op"	"化代仳佗佬念悠您傯愈億憊餛儷伈侘佌侂忥怹怤倱屔恁偲悆飥僁僽儢儱矲龕")
("oq"	"件年伴佣佯俸拿氧偉健舞侔牮僯犨")
("or"	"合何估佑伽伺佔佝含知舍信侶俗侷倌倍倚倨個倘倉偌售傖飼飴僖餉館佁佶侗佪佸侞佫佮俉俖倜啎傛缿傴餂餇儋樖饇饎")
("os"	"仍仿氖作矩傍飭雋仂佢侉俜僗")
("ot"	"位併侖盒短氳餅儘伳侐弇偋缾餖盦饁饐罏")
("ou"	"仙缶侃岱岳倦俺倔倪飩毓飽僥覦饒仚屳优伔伅佡氙佹侁俋俔侻俛倇俷峹偗氪傜傂僊嵞毹僦僶儭")
("ov"	"佞依食倀倭氨偃偎偯袋矮儂餒餵佷侒姇俍侲俀俵衾偡偠偈僂儇餧儠餲儴饟")
("ow"	"佃儅儡餾氥偪偤畣酓畬僠")
("ox"	"儕餡偛")
("oy"	"仆侮俳佧佟侜氡")
("p"	"心")
("pa"	"旨旬怕皆惜憎曶恉恂惛愔慒慴憯")
("pb"	"怖匍悄情惰惴慵懦怲悀悁悕惀惼愶愲慲憰憪憡憍")
("pc"	"怵頃慎頓慣憤穎懶怬惍貰慊慏愩憒潁熲顈懭懫懻")
("pd"	"也悖悸惇慄愾懍匊恘悃悇粊惏惈惵惸憟懆橤")
("pe"	"愎慷慢皺忮忣怓悛惙惾愋愯懮懪戄")
("pf"	"恢愀憬憔憮怀炰悰惔惊愫慓駂憭鴇鴝繠鵴鶛鶵戃")
("pg"	"忸怪惟惶雊憧懂雛懼坒恇恮悝悜慳慛墯懽觺")
("ph"	"切勿必悌惕慘忉怭毖愓憀憉")
("pi"	"丫勺勾忖忪怯恃愧怜惤慅慱憳懤懱")
("pj"	"悍悴悻悼憚懾忏匉忤怦惲愅慞憛懌")
("pk"	"匆匈快怏憫懊忕忷恔恟悷慀慔慡憿懨")
("pl"	"悚鄒慚忡忻邲斪郇愐")
("pm"	"勻怔性怛恆惺懺怚怌悾愃慬慖恒")
("pn"	"刎刨怫惻愉乜勼忔忴恞恀匑懧懰")
("po"	"愜疑忺怢恌欨惿懅憸懥懞")
("pp"	"比忽怩惚憶憾忯怋恅悿惃惢憓")
("pq"	"肄憐懈怑甮")
("pr"	"句怡恰恬恫恪悟惦惆愴怙怊怗怐恛恄恦訇悎悺惝匒愘慥慪憺")
("ps"	"劬愣愕慟怍怮勓勩")
("pt"	"世恤慍愷恲悈")
("pu"	"屯包忱恍悅芻惋慨慌懵忨忳匋怳怉毞匎悒悗惓覕愮憱憢憴")
("pv"	"忙恨悽悵惘愒懷怴悢袃愖愝愄慺懁懩懹")
("pw"	"甸匐惱怞恓愊慉")
("px"	"慆懠")
("py"	"悔忭悱")
("q"	"手")
("qa"	"拍指春措揩替摺抇晢揝搘搢摍撦摿耤擼")
("qb"	"青捎捕捐掃掄揣揹搞搆摘耦擒撾攜抈抪抩拺捅掯掮掤掅揥揟揙搠搹搰搚摛撊撟撱耩擩擿")
("qc"	"扒拱責損撰擴擷捇掽捵掑摃搷搛摜撗撌銴頛擯攢")
("qd"	"耒拖捆秦探掙採掬揉搽操靜扜扡拵耔挬捊捈栔捰揲揓搮搡摷槼擛擽攗")
("qe"	"技扳投披泰授援搬搜撥撮擭擾攫扱捄捘洯掫掇捸摋耰")
("qf"	"素掠捺揀揪摭撩撫撚擦抔拻掞焎撝絜搣摀搎摽摵摞鳺攃鶄攩攥纛")
("qg"	"扭拄拴挂挺挫捱推握摧撞擁擢攤挃拰捔捚揘揰搉觢撋攉攡")
("qh"	"抄扮拐揚摻抮捗耖摎摥")
("qi"	"找拇拎持毒耘搏搔蜇撙耨攙蠢扠扚抎抾拊捋蛪摶撠撏擉擣攭")
("qj"	"丰抖抹抨捍掉揖揮摔撢輦擇攆攝扞扦挕捙捀捽捭揇搟摓摙撣擗")
("qk"	"抉抆拔契奏挨掖捩揆揍換撇撤摸撒擻扙扷抰挍挭捑揳撖擏撽擙擫")
("ql"	"折抑邦押挪撕擲扴邞抻挋揤郬揶摲擳擤鄻")
("qm"	"扛扯抵拭拯捏彗控捶搓摑擅拑抯挳掝掗挻揎揯搦搨搧攕")
("qn"	"打抗抒拂挖捌捫擰扢扲拸拶捯揨揃揄攍")
("qo"	"夫扶抓挑挾捉捷掀提撲撳據撿靛擬扻抶抸掟掾摦摐踅撅擨攓")
("qp"	"托批抿拽捻慧撼擺攏扺抳挓恝悊掭掍揌惷摁摝摠憃攄攇攦")
("qq"	"奉拌挈捧撐撻掱掰揵搿摨")
("qr"	"扣招拓拈拘抬拮括拾哲捂捨耜搪搭搶誓擔擱挏挌砉挶捃捁掊掂掎据耞耛揈硩搳搥摳撂撘")
("qs"	"扔拒拋拗拷勣搾撈擄扐挎拹耟搒耡摴耪")
("qt"	"拉拚拼耕摒抴揜搤搕搵撜攎")
("qu"	"扎把扼拙抱挽耙耗捲掘掩掏規搖搗撓撬齧攪攬扤扥抌抏扰抁扽抭捖挹挩挸捥掜摡揗搊搋摬摫靘靚")
("qv"	"表按振接揭摟攘拫挀挔挼捼掁揠揕揋搌裚嫢擖擐擃耬擸攁攐攌攖攛攮")
("qw"	"抽描播擋擂攔揊揂搐")
("qx"	"舂插擠掐搯")
("qy"	"扑拆掛排抃挴攠")
("r"	"口")
("ra"	"啪唱嗜嘈踏嚐嚕躇咰唶喑喈喒暋噌噆踖噲踳噾蹜蹧蹭躤")
("rb"	"吊吶哨唷哺唏啃啼喘喟嘀嘲嘴噙蹄踹嚅蹣蹦肙咂呥咘啢喁嗃嗋嗝嗍踊踃噊嘺踚踽蹁嚆蹐蹢蹛蹻躎")
("rc"	"只叭哄趴員巽跡嘛嘖噴踫噸嚇蹟顎躓呬哧唄唭嗛嗊嗔嗩嗿噀嘳嘪踑蹎嚝蹞嚬蹪嚽囋躦")
("rd"	"吁呆味呼咪咻哮喋嗓跺跦踝踩噪蹂躁囌吇咮哱唋趶啍啋喿喍嗏嘄踍踘蹀躒")
("re"	"吸吱呶唆啜跛噯踱唚啵跂趿喥嗄嗖敯踆嘬踙踧踜嚄嚃嚘嚗蹳躞躩躨")
("rf"	"啖啾嗦嗎嗚嗉鳴嘹嘿噤鵑嚥鷺吙吥噅喣嘕嘌嘁嘸踿鴞嚓蹠鶚鷕鷤")
("rg"	"吐呈哇哩唯喔喱踵雖躍囉躪吜咥唑唃啀喤跓跬跮跧嗺踛踓噰嚁嚜蹚囃嚾躔躣")
("rh"	"叨吩吻吵呀嘐踢咇唦哤喭跈踄噦踼")
("ri"	"吋吆咐哦喲嗤戢嘎嘰踐戰蹲嚼躅囀躊囈囑吰呔呿呣呤哷趵跗嗕跱噂噚噣蹡嚵囆躕")
("rj"	"啤喃單嗥嗶嘩蹕囁躡吘呯咡咠哻啐啅啈斝嘝嗹嘽嘾踤踔噿蹥")
("rk"	"吳吠咬哎咽咿哭唉哽唳喚喉喫跋嗅跤嗾嗷噢蹊獸嚴吷呅哅敃趹嗼噉噳噭躈")
("rl"	"叩叫听呻呷哪唧郢啣鄂嘟鄙嘶躑吤哳郘啷喌喕鄖斲鄲鄳鄵")
("rm"	"叼呸咀啞趾喧喳唾嗟嗡噓蹉蹋呁咁呾呠呧咺唌跙嘒嘓蹅嚦躖")
("rn"	"叮吃別吭吟咒咦咧哼喇喻嚀刡咑咈哆唎趷唰嗲跠跢嘜劋踰")
("ro"	"呎吹足呱咳啄趺喙跌跳嗽嘆噗噱噬嚎嚏蹤蹼蹶咷唗哫唊啶啑唻跿踀噘踕噞噷踶蹝躆")
("rp"	"叱民吒呢唸跎嗯愍噫嚨吪呡咾呲跜跐跩跽噁踗蹗躘")
("rq"	"咩躂吽哖哞唪喡跘噠蹸躌")
("rr"	"呂呵咖咕品哈咯唁唔啊啁喀喊跆嗣嗆路嘔跼嘻踟踞器囂呫呴咍咭哃咶唅哠啥喏喎跍跖跏跕嗐嗒跲嘂碞踣踮踦蹌嚚")
("rs"	"另叻咋勛距跨嘮踴呺呦咢嗙")
("rt"	"啦跚嗑噎蹬呏哢趼啽跇嗌嗢跰嚍嚂嚧")
("ru"	"巳兄吧呃吮吼邑咄咆咱啕唬跑號跪踡蹺蹴吨唈唴唵啒唲跁喨喦嵒嗈嗂跣黽嘧睯踂噈嘵踠氉嚙嚫躚囓鼉")
("rv"	"喝喂跟嘍噥噶嚷嚶饕哏哸唼喓啿踉踥踒噮踸蹍辴囅躐躟囔躥")
("rw"	"哂噹唒喵跴踾蹓蹯躝")
("rx"	"啗嘯蹈躋喢嚌蹖嚪")
("ry"	"咚啡嗨唹跅踇")
("s"	"尸")
("sa"	"屠習層職馹鬊鬐騽驓鬙鬠")
("sb"	"匝帚屑匾腎髯臂臀騙鬍驕屌聃幦翯駽髾屩鬅鬌鬗驈驨")
("sc"	"匹咫匱賢駟頤翼鑒鬚鬢驥屄頨鋻頵聵賾贀騏顟鬒鬑屭驞顳")
("sd"	"屎屘孱馳檗匜棸屧髹駼騍糪騥驏驧")
("se"	"尿取屐馭殿履毆駿翍馺敺翪髲駸騄騢騣騪鬘")
("sf"	"耿馬熙緊熨鬃騵驃騾鷗焄焣鳭翞鳲鴄燛繄翵屪鵋鵘繴镽鶋鶌鶠鷚鷖鷵黳鷿鸐驠驫")
("sg"	"匡屆屋堅匯聖翟駐壁朢壂駤駩髽騅雡騜匷驖驩")
("sh"	"刀劈匢翂髟翏駜駗髳駹鬄驂鬖")
("si"	"刃尉聆尋戮駙戳璧鬆騷屬耾馰蜸駖瑿螶颿飁騩")
("sj"	"耳辟翠聶驛屖聑馯匰翬駍駬駥髶翴騂駻髼騲驆騿驔驊驒")
("sk"	"尹改馱駁駛髮翇镺駃駇翭聧駮駰騃騤騱鬕驐")
("sl"	"匠臣匣那邵耶郡聊郾馴鄹邔卲翀郰聏臦鄝馽鄩臩駷斸")
("sm"	"刁羽翳羾聇聝聜駓駔髬聬騸騹驉驙")
("sn"	"刷甌尻匟刵耵耹剭匭聤鬁甓騚鬋鬎聹")
("so"	"尺臥聚歐駭驗驟翐镻翜屣翨駣毉騋騛騠躄")
("sp"	"尼屁忌忍屍恥慝慰駝髭聰聽驪馲憵騉騬驄")
("sq"	"犀群肆擘羼掔犚騝驎")
("sr"	"召司叵君局居匿區聒駒駱髻臨騎譬驅匼屙翑聐硻駉駘駋髫駧髺駶騇騆聸騧騞")
("ss"	"巨劻聘騁劭聈髣駏")
("st"	"屏羿屜翌監豎駢聯鹽驢异翋馵匴駴盬")
("su"	"己已凹尾兕屈耽髡髦覽驍耴毦毣覗馻髧翫镼髱駪駾騊鬈騶鼊驦")
("sv"	"長展娶屢屨褽襞鬣妀匽婜媐嫛翣嬖褧駺騕騔騴鬞鬟驤鬤")
("sw"	"醫屇駎髷騮")
("sx"	"驌")
("sy"	"匪屝騑")
("t"	"廿")
("ta"	"昔荀曹普著暮蓿薯藉藷菖萻萶萫蓍薈鞜藸蘵")
("tb"	"芾苒朔莆期菁萌萬蒂葫葡幕蒿蓆蒲鞘藕芮苪冓茦莔莃莦菕菺黹萭萹蒴蒚蒱蓇蒨蔏蔕蓪蓨蕅蕀蕑蕱蕎鞙薃薖薷薾藡黼羺蘛蘥蘬")
("tc"	"共並其典兼黃蘋鑿萁菳萯蓂蒹蔩頩蕡蕆蕢蕦薕薠薋蕻蕷羵藇藚藬顜藾顢蘱韇顴")
("td"	"芋某荐茶茱荸荼孳棻菌菊菜業葉葆檠鞠鞣藥孽藻蘇蘗芓茠莩莯菋菻葹葇槊蒤蓁蒢鞂蔝蓧蕖蔾鞢蘪蘜")
("te"	"芟芰菠菱菽菔葭蔓蔆蕞叢藤夔芨苃羖羕莍荾莈菆菣菡菉皵羧萲葰葠葮靸蓌蒰蒑鞁蔻蔎蔱蔋蕧蕔薣蕸薆薐藙藜藑蘉羻韄")
("tf"	"芣羔荻煎蒜蒸蓀蔗蔡燕蕉蕪薰薦鞦鵲驀蘸驚韉鸛苂苶菼蒍萰萩綦蒝蓔羰蔫蔈蔒蔂蔦羱蕮蕠蕬鵧鴱藀藄蘤薸爇藨鯗蘌鶜鶿鶧蘩鶼鷁鷋蘻韅鷷鷰鷬鷨虆鸏")
("tg"	"荏荃基羞莊塑董墓鞋薹難藺蘿芏茌茥荎茬莝莛莥萑雈葟蒮蓷蓶蕫蕥薙蕹黈藋薶雚藿蘣蘳蘲蘺虇")
("th"	"芽芬茅茂剪莎蕩芀芴苾羒莏菞蒶蓼蔘蕛黺薚薉虋")
("ti"	"芍芸苓茲羚尊菟戡義對蒐蔚蔭蔑蔣薄繭藝丼芃芄刱芶苻苰苺茷茧莪菘菂蛬靮葑葯蒬蒪蓐蒔鞃蓻蓺蓴蓾蕓蕁蕺薎薅蕶薵薱蟴藱蠆蟼蠤鞿蘶蠲飌")
("tj"	"卅茉革茸草莘萃萍華斟葷蓮蓬蕈薜薛芊苹茙茿莗羢萆靬葞葺萳輂斠蓒靺蔊蓽斢蕇鞞藫蘀")
("tk"	"艾美英茵莫奠散敬猷葵鞅蔽薇鞭羹藪芠芛芵芺茇茭荍茯菝葖葔蒺蒛蓛蔟蔜薁薂黻藈藢蘞")
("tl"	"芹芥茆斯鄞鄭鄴薪邯郱茞荋斮菥鄀靳靷鄚斳蔀蔪蓹鄯薌薡鄸酀鄿蘄鞹酄")
("tm"	"甘芷苯酋差莖翔萱蓊靼薑薩羶韁芢苴苤茳荁堇羝荺莚菹菧菫萓羥葅菙葒蒫蒻蒩靻翦蔧蓳蔖蔮蕤薤鞚馘藶蘙虀虃")
("tn"	"前苧荊瓶莉夢甍薊艼艽芎苀芧芞芩茀剒荑茢茤荇羜羛荶靪羠莿菿菛葶葥萷萴靲蒯羭蕍薴薽藅藭藰蘅蘮")
("to"	"芝芙茨莢欺萊菰萸羨歉蒙歎蕨躉歡芡羑苬苡苵荄荴莁莰羡萣萐菮歁蓏蓗蔌蓫蓰蓯蔙薟藃藂薿鞮羷藗蘧躠臡")
("tp"	"花芯恙恭慈惹靴慕蔥蕊蕙薨芅芘苨苠荖茈莣荵惎菎菾葸葾愬蓖蒠蔍蕄懃憼薏薧懟藘藣藯蘢蘟戁")
("tq"	"羊葦摹擎蘚韃拲荈菶葎蒘靽蕣蕼薢薘藆鞬藦")
("tr"	"苛苦茄若苔苟茴茹茗莒荷善菩菅落萵蓉蓓蒼蘑警茍苕苫茼茖茩荅莕莙菏菇菪菬萿葀葴葋蒟蓎蒧鞀羬蓲諅鞊鞈蕗薝鞝鞫藲藞鞳蘁蘦虈碁")
("ts"	"芳苣荔勒勘莠募勤萼羲藏勸艿苲苭荂莋荿莇莮菃葧葝葃葂葄蒡靿勱蓩")
("tt"	"井并益莽葬蒞蓋藍蘆蘊卌苙荓荳菈萛蓱葐豊靾薀鞡藎鞥蘴")
("tu"	"羌芭巷范茁苜苑苞首荒莞莧菴萄葩靶蔬藐覲韆觀芑芫芚芼芤茺茪莐莌艵菀萒菤萉菢靰羦葙蔇萺蓅鞄蔤蔨蔰瞢蕘蕝鞔薍覯氋藽齹虌")
("tv"	"芒姜甚茫萋萎萇葛農蓑羯鞍養艱藹茛荌莨荽菨菵蒆葽葚葳葌蒎葨蒗蔉蔞鞎蕵薞薳藒鞨鞻蘘蘡蘹蘾")
("tw"	"曲苗蓄蔔蕃蕾薔藩蘭苖茜莤菑菄菗蒏葍蔯蕕羳藟蘠")
("tx"	"蕭舊薺萏")
("ty"	"莓菸菲芐苳蔠蘼")
("u"	"山")
("ua"	"岶峋崏嶆嶍嶒嶜")
("ub"	"峭崩崙崤嵩峟峬崝嵎崹嵽嶠巂雟巋")
("uc"	"嶼嶺顓巔岤崟崸嵿顗巑")
("ud"	"崢嶸崞崺嵥嵲嶪櫱糱")
("ue"	"岐岌峻岋岥崚嵕")
("uf"	"炭祟崇嵨嶕嶚")
("ug"	"崖崔峌峚崲嵀嶊嶉巏糶")
("uh"	"匕岈岉嵃崵嵺嵾")
("ui"	"峙幽峨蚩崧嵐巉巍屻岭嵫崶嵬嶈嵹嶟嶬嶯巀颽巇蠥")
("uj"	"岸峰峷崋崥崒嵙輋嶂嶧嶭")
("uk"	"凶嶽巖岆岟敳獃巘")
("ul"	"耑嶄屮岓岕岬峏酆酅")
("um"	"崆嵯岯岨峘嵼")
("un"	"屹岑凱剴岒岪峛峓剬崳崱嵉剻")
("uo"	"峽崁嵌嶔豳峐崨崍崼歂嵷嶡嶮嶷")
("up"	"岷崑岮峔鬯崽嵊巃")
("uq"	"嵂嶙嶰")
("ur"	"岩峒峪崎嶇岵岣岢岧峉峇峈峆峿峮崌崮嵅嵱嵣嵢巆")
("us"	"屴岠岝岰峸崿嶀嶗嶲")
("ut"	"豈嶝豐豔岍岦")
("uu"	"出兇峴崛崗覬艷屼屺屾艸岏峗峞芔崦嵋茻嶢")
("uv"	"崴峖峎崀崣嵁嵑嶁嶱嶩巕")
("uw"	"岫崠崰崷嵧嶓")
("uy"	"嶵")
("v"	"女")
("va"	"娼婚絢緒縉縮織繒繪響媎媋絔嬂緡曫")
("vb"	"帑娟納婦婿媾絹嫡嫦綿綸嬌締編縞繃妠姌姷姵帤婧婂媦媥媩媏絺綃嫞綪緉嫷縃縎嬭嬬縭繘繑繻孈纗")
("vc"	"嫌縑縝嬪績縯繽續鑾娸婰媜嫇嫹嬇嬚縜繢嬾纊纈纘")
("vd"	"好她妹紆巢媒彙綑綵嫻槳樂繅孿姀孥姝婐婇絁媟媬媃絑嫀綍綒嫭綧綝嬠縔縥繰欒")
("ve"	"奴妓級媛嫂綾綠綴綬漿線緞緩縵彔娵婈婌婽絿綅嫚嫝緅緮嬡繌繓孇纋")
("vf"	"糸災妳絮絲媽嫖嫘嫣綜嫵練駑縲縹繚鷥鸞紑婃婒婛焋媯嫄嫊嫬緂綡嫽嫶縓縤鴢縩鴽嬿繺鶅纁鶨鶭")
("vg"	"壯妞妊娃姪娌紐絰維纏妵姾娗紝婬娾紸媓絓絟綎墏緟嬞嬥嬯繀雝纆纙")
("vh"	"妙姊娣紗紛緲繆縿妢妼娏紾婸綈絼嫪緆")
("vi"	"妁姆戕紂紉約娥紜將絃幾縛嬤繈繼蠡纔蠻妘妐妶姈紈紘娹紶紨媸媿媷嫥縟嬦縳螿繜蠁孎蠿")
("vj"	"奸婢絨綽嬋緝緙縫繹奷妦妺娀紏婞婥婩婻媶嫜綷綼嫴嬅緷縡繂縪縺繟")
("vk"	"收妖狀姣姻奘娛紋紱絞嫉嫩獎緻繳變妏姎紁奊娭紎紻媄絪媺綆嫫綟緛緶緱嬓縸繖嬽奱孍")
("vl"	"糾娜姬紳鄉綁緬斷凵妎妡妽斨紃娕紖紒媔絒綀鄛")
("vm"	"姐姓紅組經綞纖爿丱妅姏妲姃姮娙婭紺絊娷媗嫋緎綖嫿緪嬗嬔縒繣繵孅")
("vn"	"妤弩姨紇剝紼婷剿彎妗糽姼娳紓紟紵媮媊絎緰嬣嬼劙")
("vo"	"以姒姚嫁綻緣緹縱彖娖婕婝紩媞絘絯絩嫙嫨緁嬐疀縼繉縰繸纀臠")
("vp"	"妣妮姥怒恕紕紙媳媲總戀奼婖紽彘絏嫕緄緦嬨繐繶孋纚")
("vq"	"姅絆絳緯縴攣姩拏挐牂繗繲繨")
("vr"	"如姑始婀紹媧結絡給嫗綰綺綢嬉緘嚮繕轡姁妱姡姞姶姤姛姳姠牁娮砮婠婟婤婄婍絅絇紿婼絧嫆綌絽嫟牄綹嫸緺縋縖繾")
("vs"	"幻奶幼努妒妨娉紡勦姖姱嫮縍")
("vt"	"妍姍姘紲媼縊彝媕絣盝嬁縕嬧盭纑")
("vu"	"妃紀娓娩純邕婉統絀媚絕綱嬈縐繞繩孀巒纜奾妧姺姽娊紞紌婘婗媢絖媱媰絻綄綣綯綩緗縌矕")
("vv"	"妝姦娘娠婊綏裝網嬝縷孃饗纓奻姲娞婑媴緀緌嬛縗繷繯孌纕")
("vw"	"妯細緇畿牆嬸繙醬甾紬媌媹嬏緧嬙")
("vx"	"繡嫍縚")
("vy"	"終緋")
("w"	"田")
("wa"	"署黯罾")
("wb"	"囿胃圃囧圊圇圌罥羃")
("wc"	"四異貫買圓顆黷圚顒黰")
("wd"	"囝困果囷罦罧罺櫐圞")
("we"	"畈畟敤畯瑆畷罬斀")
("wf"	"累黑罵鴨羈罘羆黥纍鷝鷶羉鸅鸀鸓")
("wg"	"里畦墅墨罹壘羅罜罣畽罿黫壨")
("wh"	"囫畛罞黲")
("wi"	"母禺蜀團疇囹畤罻")
("wj"	"毋圉畢睪罩毌圛罼")
("wk"	"因畎畋默斁奰")
("wl"	"甲甽界畀")
("wm"	"國置疊畇罡罝罭黚翾")
("wn"	"野夥罰黔囥町罽黟")
("wo"	"囚眾歜圂欭罛")
("wp"	"思毗恩愚罷囮毘罠慁罳黓")
("wq"	"畔圍疄")
("wr"	"回固圄罟略畸點黠圁詈礨羇黵")
("ws"	"男黝嬲")
("wt"	"圔黭")
("wu"	"囤圈黜瑂畹罨黕黖黤黦罍")
("wv"	"畏園囡甿褁瞏圜黮")
("ww"	"圖畾罶")
("wy"	"罪罫")
("y"	"卜")
("ya"	"迫音詣詢諸遭諧諳譜識迿誻諙謵譇旝譖齰")
("yb"	"市肓育肯帝帟訥逍通遇遍靖端膏膂誦誚誧遘膚請論適諦謂講邁謫邇譎齲旆迶离逋斒旓詴遄歶遰諝諞諯遹骿謞謪謧譋譑齵")
("yc"	"六亦貞述貲旗選遺頻謙顏韻讀顫龔贛顱讚訹賌遉頏虡鈭諆頝頦錖謓謮譔贇旟譧齞齎顪贙齻")
("yd"	"杗迂迆享施迤桌柴訏訑迷棄途稟誅遊諄課諍謀諜謎譟斿虖竫粲誄誖諃謋謼齫")
("ye"	"叔歧返設竣詠詖逮遐敲遝毅諼護敁殶敊逑逡逯毃諏諔叡皻謖謢謏皽謾竷譭邍讂頀齱")
("yf"	"京紊烹逖紫詼遜熟諒談遮諫遼齋譙鶉讜祡鳪鳼鴗旚謜鮆鵁謶謤齌譕鶁鵫鶙鶐龒鷟讌鷲鷾鸇鸆虪鸕鸗")
("yg"	"主望逞逛童註逵進詮遑雍塾誑雌誰壅暹壑離雜韹壟邏齷迋觜誆詿遳諲諻讙")
("yh"	"步彥彪訝診歲彰諺謬迓玅虙訬逤逿虨齖齴")
("yi"	"玄玆討孰訟鹵逸詩颯導諷遵戲謝譏議齡讒竑歭訒旍竤詅戠誸諓虥譐譸蠪")
("yj"	"斗辛迅卒卓計訐訊率許連逢章評運誶辨辦避瓣譁譚辮譯辯聾顰迕逴諀遧諢諵諿韸謘謰譂嚲讘")
("yk"	"文交夜放奕效虔送族訣敦虞詨誤敵遨邀謨獻迖迗訞敨詙誒敹遫謑韺譈譀龑讞")
("yl"	"迎近郊訓訢速逝部郭新鄗辣邙邟邡旂竦詶鄐鄣齗齘")
("ym"	"上止些虐訌旌產逕虛証詛詆試遢誼誕謹齟讖与翊斌詌亶瑎甝詡誙諠謔諈韰謆邅謯翽譠譅鹺亹譾斖讈齏")
("yn"	"亢亨迄刻亭訂剖訖處剷逾劇劑嬴諭甕羸贏斻迒瓬迾迻瑀誃劌甋謻齕蠃甗臝鸁")
("yo"	"亥迭畝逃旋逐該遂誣豪諛齒遽邃瓤齪鹼欬欳旐胔詄歆誂豦歊歑諑誺遯歔諟遾斔螤旞譣譹譺")
("yp"	"此忘氓亳託旎訛意詫誌認慮龍齜邐虍忐忞迡惄詑訿誋諗憝諰齔謥譓齥譿讔戇龘")
("yq"	"牽詳達違諱遴遲邂逄詊撉")
("yr"	"占吝言迦迢迥迨站迴追逅高商這造啻詞詁詔訶週裔詰話詬詻訾過旖語誥遣韶調諮諾譆譫鹹齣譴齬呰迠竘迵适迼砦逜詀詗詒逭詷詺逽諴謒謳譗齠齝礱讋齮讟")
("ys"	"方劾旁訪透詐虜誇誠誘虧謗邊卣迉迮勍逌詎詏勯諤勴謣勷齶")
("yt"	"立弈迸逗誡盧謐證衁衧詍誁竮諡邆謚髜齍齛齸")
("yu"	"充乩盲虎亮兗記訕逆毫竟就督詭道遁睿說遙遞遷親氈謊謠邈競巟辿迍旄眥訰訧旒覘詘詵覤諕誽氃虤遶遻謅謕罋覷譊譝齙齯齺齾")
("yv"	"亡妄衣巡妾哀旅衰衷退袞逶裒遏竭裹遠褒諉謁諶餐褻襄還邋齦襲讓玈袤袬袌袲裛裻誫誏褎諘飺褭褱褢謱譪譨饔裏")
("yw"	"迪畜迺逼遛斕遒諨旛譒讄讅讕")
("yx"	"齊諂")
("yy"	"卞卡於訃訴誨誹旃")
("z;" "；﹔，、﹐﹑")
("z:" "：︰﹕．。‧﹒·")
("z'" "’‘")
("z\"" "”“〝〞〃")
("z\\" "＼﹨╲")
("z|" "｜︱︳∣")
("z/" "／∕╱")
("z?" "？﹖")
("z<" "〈＜﹤︿∠")
("z>" "〉＞﹥﹀")
("z[" "〔【﹝︹︻「『﹁﹃")
("z]" "〕】﹞︺︼」』﹂﹄")
("z{" "｛﹛︷ ")
("z}" "｝﹜︸")
("z`" "‵′")
("z~" "～﹋﹌︴﹏")
("z!" "！﹗")
("z@" "＠﹫")
("z#" "＃﹟")
("z$" "＄﹩")
("z%" "％﹪")
("z&" "＆﹠")
("z*" "＊﹡※☆★")
("z(" "（﹙︵")
("z)" "）﹚︶")
("z-" "–—¯￣－﹣")
("z_" "＿ˍ")
("z=" "＝﹦")
("z+" "＋﹢")
)
;; Local Variables:
;; version-control: never
;; no-update-autoloads: t
;; End:

;;; quick-b5.el ends here
