/*********************************************************************
Functions dealing with general aspects of all Gnuastro.

Original author:
     Mohammad Akhlaghi <mohammad@akhlaghi.org>
Contributing author(s):
     Pedram Ashofteh Ardakani <pedramardakani@pm.me>
Copyright (C) 2016-2022 Free Software Foundation, Inc.

Gnuastro is free software: you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation, either version 3 of the License, or (at your
option) any later version.

Gnuastro is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with Gnuastro. If not, see <http://www.gnu.org/licenses/>.
**********************************************************************/
#ifndef __GAL_CONFIG_H__
#define __GAL_CONFIG_H__

/* Include other headers if necessary here. Note that other header files
   must be included before the C++ preparations below */


/* The restrict keyword might not be present on some systems, so we are
   redefining it here based on the checks in 'configure.ac', see there for
   more comments. */
#define restrict __restrict__


/* Configuration macros: */

#define GAL_CONFIG_VERSION                  "0.18.71-c982"

#define GAL_CONFIG_HAVE_PYTHON              1
#define GAL_CONFIG_HAVE_LIBGIT2             1
#define GAL_CONFIG_HAVE_GNUMAKE_H           1
#define GAL_CONFIG_HAVE_WCSLIB_DIS_H        1
#define GAL_CONFIG_HAVE_WCSLIB_MJDREF       1
#define GAL_CONFIG_HAVE_WCSLIB_OBSFIX       1
#define GAL_CONFIG_HAVE_WCSLIB_VERSION      1
#define GAL_CONFIG_HAVE_FITS_IS_REENTRANT   1
#define GAL_CONFIG_HAVE_GSL_INTERP_STEFFEN  1

#define GAL_CONFIG_HAVE_PTHREAD_BARRIER     1

#define GAL_CONFIG_SIZEOF_LONG              8
#define GAL_CONFIG_SIZEOF_SIZE_T            8


/* C++ Preparations */
#undef __BEGIN_C_DECLS
#undef __END_C_DECLS
#ifdef __cplusplus
# define __BEGIN_C_DECLS extern "C" {
# define __END_C_DECLS }
#else
# define __BEGIN_C_DECLS                /* empty */
# define __END_C_DECLS                  /* empty */
#endif
/* End of C++ preparations */



/* Actual header contants (the above were for the Pre-processor). */
__BEGIN_C_DECLS  /* From C++ preparations */






__END_C_DECLS    /* From C++ preparations */

#endif           /* __GAL_CONFIG_H__ */
