/* A Bison parser, made by GNU Bison 3.3.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2019 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Undocumented macros, especially those whose name start with YY_,
   are private implementation details.  Do not rely on them.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "3.3.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 28 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:337  */

#include <config.h>

#include <stdlib.h>
#include <string.h>

#define	COB_IN_PARSER	1
#include "cobc.h"
#include "tree.h"

#ifndef	_STDLIB_H
#define	_STDLIB_H 1
#endif

#define YYSTYPE			cb_tree
#define yyerror(x)		cb_error_always ("%s", x)

#define emit_statement(x) \
do { \
  if (!skip_statements) { \
	CB_ADD_TO_CHAIN (x, current_program->exec_list); \
  } \
}  ONCE_COB

#define push_expr(type, node) \
  current_expr = cb_build_list (cb_int (type), node, current_expr)

/* Statement terminator definitions */
#define TERM_NONE		0
#define TERM_ACCEPT		1U
#define TERM_ADD		2U
#define TERM_CALL		3U
#define TERM_COMPUTE		4U
#define TERM_DELETE		5U
#define TERM_DISPLAY		6U
#define TERM_DIVIDE		7U
#define TERM_EVALUATE		8U
#define TERM_IF			9U
#define TERM_JSON		10U
#define TERM_MODIFY		11U
#define TERM_MULTIPLY		12U
#define TERM_PERFORM		13U
#define TERM_READ		14U
#define TERM_RECEIVE		15U
#define TERM_RETURN		16U
#define TERM_REWRITE		17U
#define TERM_SEARCH		18U
#define TERM_START		19U
#define TERM_STRING		20U
#define TERM_SUBTRACT		21U
#define TERM_UNSTRING		22U
#define TERM_WRITE		23U
#define TERM_XML		24U
#define TERM_MAX		25U	/* Always last entry, used for array size */

#define	TERMINATOR_WARNING(x,z)	terminator_warning (x, TERM_##z, #z)
#define	TERMINATOR_ERROR(x,z)	terminator_error (x, TERM_##z, #z)
#define	TERMINATOR_CLEAR(x,z)	terminator_clear (x, TERM_##z)

/* Defines for duplicate checks */
/* Note - We use <= 16 for common item definitions and */
/* > 16 for non-common item definitions e.g. REPORT and SCREEN */
#define	SYN_CLAUSE_1		(1U << 0)
#define	SYN_CLAUSE_2		(1U << 1)
#define	SYN_CLAUSE_3		(1U << 2)
#define	SYN_CLAUSE_4		(1U << 3)
#define	SYN_CLAUSE_5		(1U << 4)
#define	SYN_CLAUSE_6		(1U << 5)
#define	SYN_CLAUSE_7		(1U << 6)
#define	SYN_CLAUSE_8		(1U << 7)
#define	SYN_CLAUSE_9		(1U << 8)
#define	SYN_CLAUSE_10		(1U << 9)
#define	SYN_CLAUSE_11		(1U << 10)
#define	SYN_CLAUSE_12		(1U << 11)
#define	SYN_CLAUSE_13		(1U << 12)
#define	SYN_CLAUSE_14		(1U << 13)
#define	SYN_CLAUSE_15		(1U << 14)
#define	SYN_CLAUSE_16		(1U << 15)
#define	SYN_CLAUSE_17		(1U << 16)
#define	SYN_CLAUSE_18		(1U << 17)
#define	SYN_CLAUSE_19		(1U << 18)
#define	SYN_CLAUSE_20		(1U << 19)
#define	SYN_CLAUSE_21		(1U << 20)
#define	SYN_CLAUSE_22		(1U << 21)
#define	SYN_CLAUSE_23		(1U << 22)
#define	SYN_CLAUSE_24		(1U << 23)
#define	SYN_CLAUSE_25		(1U << 24)
#define	SYN_CLAUSE_26		(1U << 25)
#define	SYN_CLAUSE_27		(1U << 26)
#define	SYN_CLAUSE_28		(1U << 27)
#define	SYN_CLAUSE_29		(1U << 28)
#define	SYN_CLAUSE_30		(1U << 29)
#define	SYN_CLAUSE_31		(1U << 30)
#define	SYN_CLAUSE_32		(1U << 31)

#define	EVAL_DEPTH		32
#define	PROG_DEPTH		16

/* Global variables */

struct cb_program		*current_program = NULL;
struct cb_statement		*current_statement = NULL;
struct cb_label			*current_section = NULL;
struct cb_label			*current_paragraph = NULL;
struct cb_field		*external_defined_fields_ws;
struct cb_field		*external_defined_fields_global;
cb_tree				defined_prog_list = NULL;
int				cb_exp_line = 0;

cb_tree				cobc_printer_node = NULL;
int				functions_are_all = 0;
int				non_const_word = 0;
int				suppress_data_exceptions = 0;
unsigned int			cobc_repeat_last_token = 0;
unsigned int			cobc_in_id = 0;
unsigned int			cobc_in_procedure = 0;
unsigned int			cobc_in_repository = 0;
unsigned int			cobc_force_literal = 0;
unsigned int			cobc_cs_check = 0;
unsigned int			cobc_allow_program_name = 0;
unsigned int			cobc_in_xml_generate_body = 0;
unsigned int			cobc_in_json_generate_body = 0;

/* Local variables */

enum tallying_phrase {
	NO_PHRASE,
	FOR_PHRASE,
	CHARACTERS_PHRASE,
	ALL_LEADING_TRAILING_PHRASES,
	VALUE_REGION_PHRASE
};

enum key_clause_type {
	NO_KEY,
	RECORD_KEY,
	RELATIVE_KEY
};

static struct cb_statement	*main_statement;

static cb_tree			current_expr;
static struct cb_field		*current_field;
static struct cb_field		*control_field;
static struct cb_field		*description_field;
static struct cb_file		*current_file;
static struct cb_cd		*current_cd;
static struct cb_report		*current_report;
static struct cb_report		*report_instance;
static struct cb_key_component	*key_component_list;

static struct cb_file		*linage_file;
static cb_tree			next_label_list;

static const char			*stack_progid[PROG_DEPTH];

static enum cb_storage		current_storage;

static cb_tree			perform_stack;
static cb_tree			qualifier;
static cb_tree			keys_list;

static cb_tree			save_tree;
static cb_tree			start_tree;

static unsigned int		check_unreached;
static unsigned int		within_typedef_definition;
static unsigned int		in_declaratives;
static unsigned int		in_debugging;
static unsigned int		current_linage;
static unsigned int		report_count;
static unsigned int		first_prog;
static unsigned int		setup_from_identification;
static unsigned int		use_global_ind;
static unsigned int		same_area;
static unsigned int		inspect_keyword;
static unsigned int		main_flag_set;
static int			next_label_id;
static int			eval_level;
static int			eval_inc;
static int			eval_inc2;
static int			depth;
static int			first_nested_program;
static int			call_mode;
static int			size_mode;
static cob_flags_t		set_attr_val_on;
static cob_flags_t		set_attr_val_off;
static cob_flags_t		check_duplicate;
static cob_flags_t		check_on_off_duplicate;
static cob_flags_t		check_pic_duplicate;
static cob_flags_t		check_line_col_duplicate;
static unsigned int		skip_statements;
static unsigned int		start_debug;
static unsigned int		save_debug;
static unsigned int		needs_field_debug;
static unsigned int		needs_debug_item;
static unsigned int		env_div_seen;
static cob_flags_t		header_check;
static unsigned int		call_nothing;
static enum tallying_phrase	previous_tallying_phrase;
static cb_tree			default_rounded_mode;
static enum key_clause_type	key_type;

static int			ext_dyn_specified;
static enum cb_assign_device	assign_device;
 
static enum cb_display_type	display_type;
static int			is_first_display_item;
static cb_tree			advancing_value;
static cb_tree			upon_value;
static cb_tree			line_column;

static cb_tree			ml_suppress_list;
static cb_tree			xml_encoding;
static int			with_xml_dec;
static int			with_attrs;

static cb_tree			alphanumeric_collation;
static cb_tree			national_collation;

static enum cb_ml_suppress_category	ml_suppress_category;

static int			term_array[TERM_MAX];
static cb_tree			eval_check[EVAL_DEPTH][EVAL_DEPTH];

static const char		*backup_source_file = NULL;
static int			backup_source_line = 0;

/* Defines for header presence */

#define	COBC_HD_ENVIRONMENT_DIVISION	(1U << 0)
#define	COBC_HD_CONFIGURATION_SECTION	(1U << 1)
#define	COBC_HD_SPECIAL_NAMES		(1U << 2)
#define	COBC_HD_INPUT_OUTPUT_SECTION	(1U << 3)
#define	COBC_HD_FILE_CONTROL		(1U << 4)
#define	COBC_HD_I_O_CONTROL		(1U << 5)
#define	COBC_HD_DATA_DIVISION		(1U << 6)
#define	COBC_HD_FILE_SECTION		(1U << 7)
#define	COBC_HD_WORKING_STORAGE_SECTION	(1U << 8)
#define	COBC_HD_LOCAL_STORAGE_SECTION	(1U << 9)
#define	COBC_HD_LINKAGE_SECTION		(1U << 10)
#define	COBC_HD_COMMUNICATION_SECTION	(1U << 11)
#define	COBC_HD_REPORT_SECTION		(1U << 12)
#define	COBC_HD_SCREEN_SECTION		(1U << 13)
#define	COBC_HD_PROCEDURE_DIVISION	(1U << 14)
#define	COBC_HD_PROGRAM_ID		(1U << 15)
#define	COBC_HD_SOURCE_COMPUTER		(1U << 16)
#define	COBC_HD_OBJECT_COMPUTER		(1U << 17)
#define	COBC_HD_REPOSITORY		(1U << 18)

/* Static functions */

static void
begin_statement (const char *name, const unsigned int term)
{
	if (check_unreached) {
		cb_warning (cb_warn_unreachable, _("unreachable statement '%s'"), name);
	}
	current_paragraph->flag_statement = 1;
	current_statement = cb_build_statement (name);
	CB_TREE (current_statement)->source_file = cb_source_file;
	CB_TREE (current_statement)->source_line = cb_source_line;
	current_statement->flag_in_debug = in_debugging;
	emit_statement (CB_TREE (current_statement));
	if (term) {
		term_array[term]++;
	}
	main_statement = current_statement;
}

static void
restore_backup_pos (cb_tree item)
{
	item->source_file = backup_source_file;
	item->source_line = backup_source_line;
}

static void
begin_statement_from_backup_pos (const char *name, const unsigned int term)
{
	current_paragraph->flag_statement = 1;
	current_statement = cb_build_statement (name);
	restore_backup_pos (CB_TREE (current_statement));
	current_statement->flag_in_debug = in_debugging;
	emit_statement (CB_TREE (current_statement));
	if (term) {
		term_array[term]++;
	}
	main_statement = current_statement;
	if (check_unreached) {
		cb_warning_x (cb_warn_unreachable, CB_TREE (current_statement), _("unreachable statement '%s'"), name);
	}
}

/* create a new statement with base attributes of current_statement
   and set this as new current_statement */
static void
begin_implicit_statement (void)
{
	struct cb_statement	*new_statement;
	new_statement = cb_build_statement (NULL);
	new_statement->common = current_statement->common;
	new_statement->name = current_statement->name;
	new_statement->flag_in_debug = !!in_debugging;
	new_statement->flag_implicit = 1;
	current_statement = new_statement;
	main_statement->body = cb_list_add (main_statement->body,
					    CB_TREE (current_statement));
}

# if 0 /* activate only for debugging purposes for attribs
	FIXME: Replace by DEBUG_LOG function */
static
void print_bits (cob_flags_t num)
{
	unsigned int 	size = sizeof (cob_flags_t);
	unsigned int	max_pow = 1 << (size * 8 - 1);
	int 		i = 0;

	for(; i < size * 8; ++i){
		/* Print last bit and shift left. */
		fprintf (stderr, "%u ", num & max_pow ? 1 : 0);
		num = num << 1;
	}
	fprintf (stderr, "\n");
}
#endif

/* functions for storing current position and
   assigning it to a cb_tree after its parsing is finished */
static COB_INLINE
void backup_current_pos (void)
{
	backup_source_file = cb_source_file;
	backup_source_line = cb_source_line;
}

#if 0 /* currently not used */
static COB_INLINE
void set_pos_from_backup (cb_tree x)
{
	x->source_file = backup_source_file;
	x->source_line = backup_source_line;
}
#endif

static void
emit_entry (const char *name, const int encode, cb_tree using_list, cb_tree convention)
{
	cb_tree		l;
	cb_tree		check_list;
	cb_tree		label;
	cb_tree		x;
	cb_tree		entry_conv;
	struct cb_field	*f, *ret_f;
	int			param_num;
	char		buff[COB_MINI_BUFF];

	snprintf (buff, (size_t)COB_MINI_MAX, "E$%s", name);
	label = cb_build_label (cb_build_reference (buff), NULL);
	if (encode) {
		CB_LABEL (label)->name = cb_encode_program_id (name, 0, cb_fold_call);
		CB_LABEL (label)->orig_name = name;
	} else {
		CB_LABEL (label)->name = name;
		CB_LABEL (label)->orig_name = current_program->orig_program_id;
	}
	CB_LABEL (label)->flag_begin = 1;
	CB_LABEL (label)->flag_entry = 1;
	label->source_line = backup_source_line;
	emit_statement (label);

	if (current_program->flag_debugging) {
		emit_statement (cb_build_debug (cb_debug_contents,
						"START PROGRAM", NULL));
	}

	param_num = 1;
	check_list = NULL;
	for (l = using_list; l; l = CB_CHAIN (l)) {
		x = CB_VALUE (l);
		if (cb_try_ref (x) != cb_error_node) {
			f = CB_FIELD (cb_ref (x));
			if (!current_program->flag_chained) {
				if (f->storage != CB_STORAGE_LINKAGE) {
					cb_error_x (x, _("'%s' is not in LINKAGE SECTION"), f->name);
				}
				if (f->flag_item_based || f->flag_external) {
					cb_error_x (x, _("'%s' cannot be BASED/EXTERNAL"), f->name);
				}
				f->flag_is_pdiv_parm = 1;
			} else {
				if (f->storage != CB_STORAGE_WORKING) {
					cb_error_x (x, _("'%s' is not in WORKING-STORAGE SECTION"), f->name);
				}
				f->flag_chained = 1;
				f->param_num = param_num;
				param_num++;
			}
			if (f->level != 01 && f->level != 77) {
				cb_error_x (x, _("'%s' not level 01 or 77"), f->name);
			}
			if (f->redefines) {
				cb_error_x (x, _("'%s' REDEFINES field not allowed here"), f->name);
			}
			/* add a "receiving" entry for the USING parameter */
			if (cb_listing_xref) {
				cobc_xref_link (&f->xref, CB_REFERENCE (x)->common.source_line, 1);
			}
			if (CB_PURPOSE_INT (l) == CB_CALL_BY_REFERENCE) {
				check_list = cb_list_add (check_list, x);
			}
		}
	}

	if (check_list != NULL) {
		for (l = check_list; l; l = CB_CHAIN (l)) {
			cb_tree	l2 = CB_VALUE (l);
			x = cb_ref (l2);
			if (x != cb_error_node) {
				for (l2 = check_list; l2 != l; l2 = CB_CHAIN (l2)) {
					if (cb_ref (CB_VALUE (l2)) == x) {
						cb_error_x (l,
							_("duplicate USING BY REFERENCE item '%s'"),
							cb_name (CB_VALUE (l)));
						CB_VALUE (l) = cb_error_node;
						break;
					}
				}
			}
		}
	}

	if (current_program->returning &&
		cb_ref (current_program->returning) != cb_error_node) {
		ret_f = CB_FIELD (cb_ref (current_program->returning));
		if (ret_f->redefines) {
			cb_error_x (current_program->returning,
				_("'%s' REDEFINES field not allowed here"), ret_f->name);
		}
	} else {
		ret_f = NULL;
	}

	/* Check returning item against using items when FUNCTION */
	if (current_program->prog_type == COB_MODULE_TYPE_FUNCTION && ret_f) {
		for (l = using_list; l; l = CB_CHAIN (l)) {
			x = CB_VALUE (l);
			if (CB_VALID_TREE (x) && cb_ref (x) != cb_error_node) {
				f = CB_FIELD (cb_ref (x));
				if (ret_f == f) {
					cb_error_x (x, _("'%s' USING item duplicates RETURNING item"), f->name);
				}
			}
		}
	}

	for (l = current_program->entry_list; l; l = CB_CHAIN (l)) {
		struct cb_label *check = CB_LABEL (CB_PURPOSE (l));
		if (strcmp (name, check->name) == 0) {
			cb_error_x (CB_TREE (current_statement),
				    _("ENTRY '%s' duplicated"), name);
		}
	}

	if (convention) {
		entry_conv = convention;
	} else {
		entry_conv = current_program->entry_convention;
	}

	current_program->entry_list =
		cb_list_append (current_program->entry_list,
				CB_BUILD_PAIR (label, CB_BUILD_PAIR(entry_conv, using_list)));
}

static void
emit_entry_goto (const char *name)
{
	cb_tree		l;
	cb_tree		label;
	char		buff[COB_MINI_BUFF];

	snprintf (buff, (size_t)COB_MINI_MAX, "E$%s", name);
	label = cb_build_label (cb_build_reference (buff), NULL);
	CB_LABEL (label)->name = name;
	CB_LABEL (label)->orig_name = name;
	CB_LABEL (label)->flag_begin = 1;
	CB_LABEL (label)->flag_entry = 1;
	CB_LABEL (label)->flag_entry_for_goto = 1;
	label->source_line = backup_source_line;
	emit_statement (label);

	for (l = current_program->entry_list_goto; l; l = CB_CHAIN (l)) {
		struct cb_label *real_label = CB_LABEL (CB_VALUE (l));
		if (strcmp (name, real_label->name) == 0) {
			cb_error_x (CB_TREE (current_statement),
				    _("ENTRY FOR GO TO '%s' duplicated"), name);
		}
	}

	if (current_program->entry_list_goto) {
		current_program->entry_list_goto =
			cb_list_add (current_program->entry_list_goto, label);
	} else {
		current_program->entry_list_goto = CB_LIST_INIT (label);
	}
}

static size_t
increment_depth (void)
{
	if (++depth >= PROG_DEPTH) {
		cb_error (_("maximum nested program depth exceeded (%d)"),
			  PROG_DEPTH);
		return 1;
	}
	return 0;
}

static void
terminator_warning (cb_tree stmt, const unsigned int termid,
		    const char *name)
{
	char		terminator[32];

	check_unreached = 0;
	if (term_array[termid]) {
		term_array[termid]--;
	/* LCOV_EXCL_START */
	} else {
		cobc_err_msg ("call to '%s' without any open term for %s",
			"terminator_warning", name);
		COBC_ABORT ();
	}
	/* LCOV_EXCL_STOP */
	snprintf (terminator, 32, "END-%s", name);
	if (is_reserved_word (terminator)) {
		cb_warning_x (cb_warn_terminator, CB_TREE (current_statement),
			_("%s statement not terminated by %s"), name, terminator);
	}

	/* Free tree associated with terminator */
	if (stmt) {
		cobc_parse_free (stmt);
	}
}

static void
terminator_error (cb_tree stmt, const unsigned int termid, const char *name)
{
	char		terminator[32];

	check_unreached = 0;
	if (term_array[termid]) {
		term_array[termid]--;
	/* LCOV_EXCL_START */
	} else {
		cobc_err_msg ("call to '%s' without any open term for %s",
			"terminator_error", name);
		COBC_ABORT ();
	}
	/* LCOV_EXCL_STOP */
	snprintf (terminator, 32, "END-%s", name);
	if (is_reserved_word (terminator)) {
		cb_error_x (CB_TREE (current_statement),
			_("%s statement not terminated by %s"), name, terminator);
	} else {
		cb_error_x (CB_TREE (current_statement),
			_("%s statement not terminated"), name);
	}

	/* Free tree associated with terminator */
	if (stmt) {
		cobc_parse_free (stmt);
	}
}

static void
terminator_clear (cb_tree stmt, const unsigned int termid)
{
	struct cb_perform	*p;
	check_unreached = 0;
	if (term_array[termid]) {
		term_array[termid]--;
	/* LCOV_EXCL_START */
	} else {
		cobc_err_msg ("call to '%s' without any open term for %s",
			"terminator_warning", current_statement->name);
		COBC_ABORT ();
	}
	/* LCOV_EXCL_STOP */
	if (termid == TERM_PERFORM
	 && perform_stack) {
		p = CB_PERFORM (CB_VALUE (perform_stack));
		if (p->perform_type == CB_PERFORM_UNTIL) {
			cb_terminate_cond ();
		}
	}
	/* Free tree associated with terminator */
	if (stmt) {
		cobc_parse_free (stmt);
	}
}

static int
literal_value (cb_tree x)
{
	if (x == cb_space) {
		return ' ';
	} else if (x == cb_zero) {
		return '0';
	} else if (x == cb_quote) {
		return cb_flag_apostrophe ? '\'' : '"';
	} else if (x == cb_null) {
		return 0;
	} else if (x == cb_low) {
		return 0;
	} else if (x == cb_high) {
		return 255;
	} else if (CB_TREE_CLASS (x) == CB_CLASS_NUMERIC) {
		return cb_get_int (x);
	} else {
		return CB_LITERAL (x)->data[0];
	}
}

static void
setup_use_file (struct cb_file *fileptr)
{
	struct cb_file	*newptr;

	if (fileptr->organization == COB_ORG_SORT) {
		cb_error (_("USE statement invalid for SORT file"));
	}
	if (fileptr->flag_global) {
		newptr = cobc_parse_malloc (sizeof(struct cb_file));
		*newptr = *fileptr;
		newptr->handler = current_section;
		newptr->handler_prog = current_program;
		if (!use_global_ind) {
			current_program->local_file_list =
				cb_list_add (current_program->local_file_list,
					     CB_TREE (newptr));
		} else {
			current_program->global_file_list =
				cb_list_add (current_program->global_file_list,
					     CB_TREE (newptr));
		}
	} else {
		fileptr->handler = current_section;
	}
}

/* note: same message in field.c */
static int
emit_duplicate_clause_message (const char *clause)
{
	/* FIXME: replace by a new warning level that is set
	   to warn/error depending on cb_relaxed_syntax_checks */
	if (cb_relaxed_syntax_checks) {
		cb_warning (COBC_WARN_FILLER, _("duplicate %s clause"), clause);
		return 0;
	}
	cb_error (_("duplicate %s clause"), clause);
	return 1;
}

static int
check_repeated (const char *clause, const cob_flags_t bitval,
			cob_flags_t *already_seen)
{
	if (*already_seen & bitval) {
		return emit_duplicate_clause_message (clause);
	}
	*already_seen |= bitval;
	return 0;
}

static void
emit_conflicting_clause_message (const char *clause, const char *conflicting)
{
	if (cb_relaxed_syntax_checks) {
		cb_warning (COBC_WARN_FILLER, _("cannot specify both %s and %s; %s is ignored"),
			clause, conflicting, clause);
	} else {
		cb_error (_("cannot specify both %s and %s"),
			clause, conflicting);
	}

}


static void
error_if_no_page_lines_limit (const char *phrase)
{
	if (!current_report->lines && !current_report->t_lines) {
		cb_error (_("Cannot specify %s without number of lines on page"),
			  phrase);
	}
}

static void
setup_occurs (void)
{
	check_repeated ("OCCURS", SYN_CLAUSE_7, &check_pic_duplicate);
	if (current_field->indexes == COB_MAX_SUBSCRIPTS) {
		cb_error (_("maximum OCCURS depth exceeded (%d)"),
			COB_MAX_SUBSCRIPTS);
	} else {
		current_field->indexes++;
	}

	if (current_field->flag_unbounded) {
		if (current_field->storage != CB_STORAGE_LINKAGE) {
			cb_error_x (CB_TREE(current_field), _("'%s' is not in LINKAGE SECTION"),
				cb_name (CB_TREE(current_field)));
		}
	}

	if (current_field->flag_item_based) {
		cb_error (_("%s and %s are mutually exclusive"), "BASED", "OCCURS");
	} else if (current_field->flag_external) {
		cb_error (_("%s and %s are mutually exclusive"), "EXTERNAL", "OCCURS");
	}
	current_field->flag_occurs = 1;
}

static void
setup_occurs_min_max (cb_tree occurs_min, cb_tree occurs_max)
{
	if (occurs_max) {
		current_field->occurs_min = cb_get_int (occurs_min);
		if (occurs_max != cb_int0) {
			current_field->occurs_max = cb_get_int (occurs_max);
			if (!current_field->depending) {
				if (cb_relaxed_syntax_checks) {
					cb_warning (COBC_WARN_FILLER, _("TO phrase without DEPENDING phrase"));
					cb_warning (COBC_WARN_FILLER, _("maximum number of occurrences assumed to be exact number"));
					current_field->occurs_min = 1; /* CHECKME: why using 1 ? */
				} else {
					cb_error (_("TO phrase without DEPENDING phrase"));
				}
			}
			if (current_field->occurs_max <= current_field->occurs_min) {
				cb_error (_("OCCURS TO must be greater than OCCURS FROM"));
			}
		} else {
			current_field->occurs_max = 0;
		}
	} else {
		current_field->occurs_min = 1; /* CHECKME: why using 1 ? */
		current_field->occurs_max = cb_get_int (occurs_min);
		if (current_field->depending) {
			cb_verify (cb_odo_without_to, _("OCCURS DEPENDING ON without TO phrase"));
		}
	}
}

static void
check_relaxed_syntax (const cob_flags_t lev)
{
	const char	*s;

	switch (lev) {
	case COBC_HD_ENVIRONMENT_DIVISION:
		s = "ENVIRONMENT DIVISION";
		break;
	case COBC_HD_CONFIGURATION_SECTION:
		s = "CONFIGURATION SECTION";
		break;
	case COBC_HD_SPECIAL_NAMES:
		s = "SPECIAL-NAMES";
		break;
	case COBC_HD_INPUT_OUTPUT_SECTION:
		s = "INPUT-OUTPUT SECTION";
		break;
	case COBC_HD_FILE_CONTROL:
		s = "FILE-CONTROL";
		break;
	case COBC_HD_I_O_CONTROL:
		s = "I-O-CONTROL";
		break;
	case COBC_HD_DATA_DIVISION:
		s = "DATA DIVISION";
		break;
	case COBC_HD_FILE_SECTION:
		s = "FILE SECTION";
		break;
	case COBC_HD_WORKING_STORAGE_SECTION:
		s = "WORKING-STORAGE SECTION";
		break;
	case COBC_HD_LOCAL_STORAGE_SECTION:
		s = "LOCAL-STORAGE SECTION";
		break;
	case COBC_HD_LINKAGE_SECTION:
		s = "LINKAGE SECTION";
		break;
	case COBC_HD_COMMUNICATION_SECTION:
		s = "COMMUNICATION SECTION";
		break;
	case COBC_HD_REPORT_SECTION:
		s = "REPORT SECTION";
		break;
	case COBC_HD_SCREEN_SECTION:
		s = "SCREEN SECTION";
		break;
	case COBC_HD_PROCEDURE_DIVISION:
		s = "PROCEDURE DIVISION";
		break;
	case COBC_HD_PROGRAM_ID:
		s = "PROGRAM-ID";
		break;
	/* LCOV_EXCL_START */
	default:
		s = _("unknown");
		break;
	/* LCOV_EXCL_STOP */
	}
	if (cb_relaxed_syntax_checks) {
		cb_warning (COBC_WARN_FILLER, _("%s header missing - assumed"), s);
	} else {
		cb_error (_("%s header missing"), s);
	}
}

static void
program_init_without_program_id (void)
{
	cb_tree		l;

	current_section = NULL;
	current_paragraph = NULL;
	l = cb_build_alphanumeric_literal (demangle_name,
		strlen (demangle_name));
	current_program->program_name = (char *)CB_LITERAL (l)->data;
	current_program->program_id
		= cb_build_program_id (current_program->program_name, 0);
	current_program->prog_type = COB_MODULE_TYPE_PROGRAM;
	if (!main_flag_set) {
		main_flag_set = 1;
		current_program->flag_main = cobc_flag_main;
	}
	check_relaxed_syntax (COBC_HD_PROGRAM_ID);
}

/* check if headers are present - return 0 if fine, 1 if missing
   Lev1 must always be present and is checked
   Lev2/3/4, if non-zero (forced) may be present
*/
static int
check_headers_present (const cob_flags_t lev1, const cob_flags_t lev2,
		       const cob_flags_t lev3, const cob_flags_t lev4)
{
	int ret = 0;
	if (!(header_check & lev1)) {
		header_check |= lev1;
		check_relaxed_syntax (lev1);
		ret = 1;
	}
	if (lev2) {
		if (!(header_check & lev2)) {
			header_check |= lev2;
			check_relaxed_syntax (lev2);
			ret = 1;
		}
	}
	if (lev3) {
		if (!(header_check & lev3)) {
			header_check |= lev3;
			check_relaxed_syntax (lev3);
			ret = 1;
		}
	}
	if (lev4) {
		if (!(header_check & lev4)) {
			header_check |= lev4;
			check_relaxed_syntax (lev4);
			ret = 1;
		}
	}
	return ret;
}

/*
  TO-DO: Refactor header checks - have several header_checks: division_header,
  section_header, paragraph_header, sentence_type
*/
static void
set_conf_section_part (const cob_flags_t part)
{
	header_check &= ~COBC_HD_SOURCE_COMPUTER;
	header_check &= ~COBC_HD_OBJECT_COMPUTER;
	header_check &= ~COBC_HD_SPECIAL_NAMES;
	header_check &= ~COBC_HD_REPOSITORY;
	header_check |= part;
}

static const char *
get_conf_section_part_name (const cob_flags_t part)
{
	if (part == COBC_HD_SOURCE_COMPUTER) {
		return "SOURCE-COMPUTER";
	} else if (part == COBC_HD_OBJECT_COMPUTER) {
		return "OBJECT-COMPUTER";
	} else if (part == COBC_HD_SPECIAL_NAMES) {
		return "SPECIAL-NAMES";
	} else if (part == COBC_HD_REPOSITORY) {
		return "REPOSITORY";
	/* LCOV_EXCL_START */
	} else {
		/* This should never happen (and therefore doesn't get a translation) */
		cb_error ("unexpected configuration section part " CB_FMT_LLU, part);
		COBC_ABORT ();
	/* LCOV_EXCL_STOP */
	}
}

static int
get_conf_section_part_order (const cob_flags_t part)
{
	if (part == COBC_HD_SOURCE_COMPUTER) {
		return 1;
	} else if (part == COBC_HD_OBJECT_COMPUTER) {
		return 2;
	} else if (part == COBC_HD_SPECIAL_NAMES) {
		return 3;
	} else if (part == COBC_HD_REPOSITORY) {
		return 4;
	/* LCOV_EXCL_START */
	} else {
		/* This should never happen (and therefore doesn't get a translation) */
		cb_error ("unexpected configuration section part " CB_FMT_LLU, part);
		COBC_ABORT ();
	/* LCOV_EXCL_STOP */
	}
}

static void
check_conf_section_order (const cob_flags_t part)
{
	const cob_flags_t	prev_part
		= header_check & (COBC_HD_SOURCE_COMPUTER
				  | COBC_HD_OBJECT_COMPUTER
				  | COBC_HD_SPECIAL_NAMES
				  | COBC_HD_REPOSITORY);
#define MESSAGE_LEN 100
	char			message[MESSAGE_LEN] = { '\0' };

	if (prev_part == 0) {
		return;
	}

	if (prev_part == part) {
		cb_error (_("duplicate %s"), get_conf_section_part_name (part));
	} else if (get_conf_section_part_order (part) < get_conf_section_part_order (prev_part)) {
		snprintf (message, MESSAGE_LEN, _("%s incorrectly after %s"),
			  get_conf_section_part_name (part),
			  get_conf_section_part_name (prev_part));
		cb_verify (cb_incorrect_conf_sec_order, message);
	}
}

#undef MESSAGE_LEN

static void
build_words_for_nested_programs (void)
{
	cb_tree		x;
	cb_tree		y;

	/* Inherit special name mnemonics from parent */
	for (x = current_program->mnemonic_spec_list; x; x = CB_CHAIN (x)) {
		y = cb_build_reference (cb_name(CB_PURPOSE(x)));
		if (CB_SYSTEM_NAME_P (CB_VALUE(x))) {
			cb_define (y, CB_VALUE(x));
		} else {
			cb_build_constant (y, CB_VALUE(x));
		}
	}

	/* Inherit class names from parent */
	for (x = current_program->class_name_list; x; x = CB_CHAIN(x)) {
		y = cb_build_reference (cb_name(CB_VALUE(x)));
		cb_define (y, CB_VALUE(x));
	}
}

static void
clear_initial_values (void)
{
	perform_stack = NULL;
	current_statement = NULL;
	main_statement = NULL;
	qualifier = NULL;
	in_declaratives = 0;
	in_debugging = 0;
	use_global_ind = 0;
	check_duplicate = 0;
	check_pic_duplicate = 0;
	skip_statements = 0;
	start_debug = 0;
	save_debug = 0;
	needs_field_debug = 0;
	needs_debug_item = 0;
	env_div_seen = 0;
	header_check = 0;
	next_label_id = 0;
	current_linage = 0;
	set_attr_val_on = 0;
	set_attr_val_off = 0;
	report_count = 0;
	current_storage = CB_STORAGE_WORKING;
	eval_level = 0;
	eval_inc = 0;
	eval_inc2 = 0;
	inspect_keyword = 0;
	check_unreached = 0;
	cobc_in_id = 0;
	cobc_in_procedure = 0;
	cobc_in_repository = 0;
	cobc_force_literal = 0;
	cobc_in_xml_generate_body = 0;
	cobc_in_json_generate_body = 0;
	non_const_word = 0;
	suppress_data_exceptions = 0;
	same_area = 1;
	memset ((void *)eval_check, 0, sizeof(eval_check));
	memset ((void *)term_array, 0, sizeof(term_array));
	linage_file = NULL;
	current_file = NULL;
	current_cd = NULL;
	current_report = NULL;
	report_instance = NULL;
	next_label_list = NULL;
	default_rounded_mode = cb_int (COB_STORE_ROUND);
}

/*
  We must check for redefinitions of program-names and external program names
  outside of the usual reference/word_list methods as it may have to be done in
  a case-sensitive way.
*/
static void
begin_scope_of_program_name (struct cb_program *program)
{
	const char	*prog_name = program->program_name;
	const char	*prog_id = program->orig_program_id;
	const char	*elt_name;
	const char	*elt_id;
	cb_tree		l;

	/* Error if a program with the same name has been defined. */
	for (l = defined_prog_list; l; l = CB_CHAIN (l)) {
		elt_name = ((struct cb_program *) CB_VALUE (l))->program_name;
		elt_id = ((struct cb_program *) CB_VALUE (l))->orig_program_id;
		if (cb_fold_call && strcasecmp (prog_name, elt_name) == 0) {
			cb_error_x ((cb_tree) program,
				    _("redefinition of program name '%s'"),
				    elt_name);
		} else if (strcmp (prog_id, elt_id) == 0) {
		        cb_error_x ((cb_tree) program,
				    _("redefinition of program ID '%s'"),
				    elt_id);
			return;
		}
	}

	/* Otherwise, add the program to the list. */
	defined_prog_list = cb_list_add (defined_prog_list,
					 (cb_tree) program);
}

static void
remove_program_name (struct cb_list *l, struct cb_list *prev)
{
	if (prev == NULL) {
		defined_prog_list = l->chain;
	} else {
		prev->chain = l->chain;
	}
	cobc_parse_free (l);
}

/* Remove the program from defined_prog_list, if necessary. */
static void
end_scope_of_program_name (struct cb_program *program, const unsigned char type)
{
	struct	cb_list	*prev = NULL;
	struct	cb_list *l = (struct cb_list *) defined_prog_list;

	/* create empty entry if the program has no PROCEDURE DIVISION, error for UDF */
	if (!program->entry_list) {
		if (type == COB_MODULE_TYPE_FUNCTION) {
			cb_error (_("FUNCTION '%s' has no PROCEDURE DIVISION"), program->program_name);
		} else {
			emit_entry (program->program_id, 0, NULL, NULL);
		}
	}
	program->last_source_line = backup_source_line;

	if (program->nested_level == 0) {
		return;
	}

	/* Remove any subprograms */
	l = CB_LIST (defined_prog_list);
	while (l) {
		if (CB_PROGRAM (l->value)->nested_level > program->nested_level) {
			remove_program_name (l, prev);
		} else {
			prev = l;
		}
		if (prev && prev->chain != NULL) {
			l = CB_LIST (prev->chain);
		} else {
			l = NULL;
		}
	}

	/* Remove the specified program, if it is not COMMON */
	if (!program->flag_common) {
		l = (struct cb_list *) defined_prog_list;
		while (l) {
			/* The nested_level check is for the pathological case
			   where two nested programs have the same name */
			if (0 == strcmp (program->orig_program_id,
					 CB_PROGRAM (l->value)->orig_program_id)
			    && program->nested_level == CB_PROGRAM (l->value)->nested_level) {
				remove_program_name (l, prev);
				if (prev && prev->chain != NULL) {
					l = CB_LIST (prev->chain);
				} else {
					l = NULL;
				}
				break;
			} else {
				prev = l;
				if (l->chain != NULL) {
					l = CB_LIST (l->chain);
				} else {
					l = NULL;
				}
			}
		}
	}
}

static void
setup_program_start (void)
{
	if (setup_from_identification) {
		setup_from_identification = 0;
		return;
	}
	current_section = NULL;
	current_paragraph = NULL;

	if (depth != 0 && first_nested_program) {
		check_headers_present (COBC_HD_PROCEDURE_DIVISION, 0, 0, 0);
	}
	first_nested_program = 1;
}

static int
setup_program (cb_tree id, cb_tree as_literal, const unsigned char type)
{
	const char	*external_name = NULL;

	setup_program_start ();

	/* finish last program/function */
	if (!first_prog) {
		if (!current_program->flag_validated) {
			current_program->flag_validated = 1;
			cb_validate_program_body (current_program);
		}

		clear_initial_values ();
		current_program = cb_build_program (current_program, depth);
		if (depth) {
			build_words_for_nested_programs();
		}
		cb_set_intr_when_compiled ();
		cb_build_registers ();
		cb_add_external_defined_registers ();
	} else {
		first_prog = 0;
	}

	/* set internal name */
	if (CB_LITERAL_P (id)) {
		current_program->program_name = (char *)CB_LITERAL (id)->data;
	} else {
		current_program->program_name = CB_NAME (id);
	}
	stack_progid[depth] = current_program->program_name;
	current_program->prog_type = type;

	if (depth != 0 && type == COB_MODULE_TYPE_FUNCTION) {
		cb_error (_("functions may not be defined within a program/function"));
	}

	if (increment_depth ()) {
		return 1;
	}

	/* set external name if specified */
	if (as_literal) {
		external_name = (const char *)CB_LITERAL (as_literal)->data;
	} else {
		external_name = current_program->program_name;
	}

	/* build encoded external PROGRAM-ID */
	current_program->program_id
		= cb_build_program_id (external_name, type == COB_MODULE_TYPE_FUNCTION);

	if (type == COB_MODULE_TYPE_PROGRAM) {
		if (!main_flag_set) {
			main_flag_set = 1;
			current_program->flag_main = !!cobc_flag_main;
		}
	} else { /* COB_MODULE_TYPE_FUNCTION */
		current_program->flag_recursive = 1;
	}

	if (CB_REFERENCE_P (id)) {
		cb_define (id, CB_TREE (current_program));
	}

	begin_scope_of_program_name (current_program);

	return 0;
}

static void
decrement_depth (const char *name, const unsigned char type)
{
	int	d;

	if (depth) {
		depth--;
	}

	if (!strcmp (stack_progid[depth], name)) {
		return;
	}

	if (type == COB_MODULE_TYPE_FUNCTION) {
		cb_error (_("END FUNCTION '%s' is different from FUNCTION-ID '%s'"),
			  name, stack_progid[depth]);
		return;
	}

	/* Set depth to that of whatever program we just ended, if it exists. */
	for (d = depth; d >= 0; --d) {
		if (!strcmp (stack_progid[d], name)) {
			depth = d;
			return;
		}
	}

	if (depth != d) {
		cb_error (_("END PROGRAM '%s' is different from PROGRAM-ID '%s'"),
			  name, stack_progid[depth]);
	}
}

static void
clean_up_program (cb_tree name, const unsigned char type)
{
	char		*s;

	end_scope_of_program_name (current_program, type);

	if (name) {
		if (CB_LITERAL_P (name)) {
			s = (char *)(CB_LITERAL (name)->data);
		} else {
			s = (char *)(CB_NAME (name));
		}

		decrement_depth (s, type);
	}

	current_section = NULL;
	current_paragraph = NULL;
	if (!current_program->flag_validated) {
		current_program->flag_validated = 1;
		cb_validate_program_body (current_program);
	}
}

static const char *
get_literal_or_word_name (const cb_tree x)
{
	if (CB_LITERAL_P (x)) {
		return (const char *) CB_LITERAL (x)->data;
	} else { /* CB_REFERENCE_P (x) */
		return (const char *) CB_NAME (x);
	}
}

/* verify and set currency symbol used in picture (compile time) and - if no currency
   string is explicitly set (which is currently not implemented) - as currency string
   (run time for display and [de-]editing)*/
static void
set_currency_picture_symbol (const cb_tree x)
{
	unsigned char	*s		= CB_LITERAL (x)->data;

	if (CB_LITERAL (x)->size != 1) {
		cb_error_x (x, _("currency symbol must be one character long"));
		return;
	}
	switch (*s) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'N':
	case 'P':
	case 'R':
	case 'S':
	case 'V':
	case 'X':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'n':
	case 'p':
	case 'r':
	case 's':
	case 'v':
	case 'x':
	case 'z':
	case '+':
	case '-':
	case ',':
	case '.':
	case '*':
	case '/':
	case ';':
	case '(':
	case ')':
	case '=':
	case '\'':
	case '"':
	case ' ':
#if 0 /* note: MicroFocus also dissalows L (VAX) and G (OSVS) */
	case 'L':
	case 'G':
	case 'l':
	case 'g':
#endif
		cb_error_x (x, _("invalid character '%c' in currency symbol"), s[0]);
		return;
	default:
		break;
	}
	current_program->currency_symbol = s[0];
}

/* Return 1 if the prototype name is the same as the current function's. */
static int
check_prototype_redefines_current_element (const cb_tree prototype_name)
{
	const char	*name = get_literal_or_word_name (prototype_name);

	if (strcasecmp (name, current_program->program_name) == 0) {
		cb_warning_x (COBC_WARN_FILLER, prototype_name,
			_("prototype has same name as current function and will be ignored"));
		return 1;
	}

	return 0;
}

/* Returns 1 if the prototype has been duplicated. */
static int
check_for_duplicate_prototype (const cb_tree prototype_name,
			       const cb_tree prototype)
{
	cb_tree	dup;

	if (CB_WORD_COUNT (prototype_name) > 0) {
		/* Make sure the duplicate is a prototype */
		dup = cb_ref (prototype_name);
		if (!CB_PROTOTYPE_P (dup)) {
			redefinition_error (prototype_name);
			return 1;
		}

		/* Check the duplicate prototypes match */
		if (strcmp (CB_PROTOTYPE (prototype)->ext_name,
			    CB_PROTOTYPE (dup)->ext_name)
		    || CB_PROTOTYPE (prototype)->type != CB_PROTOTYPE (dup)->type) {
			cb_error_x (prototype_name,
				    _("duplicate REPOSITORY entries for '%s' do not match"),
				    get_literal_or_word_name (prototype_name));
		} else {
			cb_warning_x (COBC_WARN_FILLER, prototype_name,
				      _("duplicate REPOSITORY entry for '%s'"),
				      get_literal_or_word_name (prototype_name));
		}
		return 1;
	}

	return 0;
}

static void
setup_prototype (cb_tree prototype_name, cb_tree ext_name,
		  const int type, const int is_current_element)
{
	cb_tree	prototype;
	int	name_redefinition_allowed;

	if (!is_current_element
	    && check_prototype_redefines_current_element (prototype_name)) {
		return;
	}

	prototype = cb_build_prototype (prototype_name, ext_name, type);

	if (!is_current_element
	    && check_for_duplicate_prototype (prototype_name, prototype)) {
		return;
	}

	name_redefinition_allowed = type == COB_MODULE_TYPE_PROGRAM
		&& is_current_element && cb_program_name_redefinition;
	if (!name_redefinition_allowed) {
		if (CB_LITERAL_P (prototype_name)) {
			cb_define (cb_build_reference ((const char *)CB_LITERAL (prototype_name)->data), prototype);
		} else {
			cb_define (prototype_name, prototype);
		}

		if (type == COB_MODULE_TYPE_PROGRAM) {
			current_program->program_spec_list =
				cb_list_add (current_program->program_spec_list, prototype);
		} else { /* COB_MODULE_TYPE_FUNCTION */
			current_program->user_spec_list =
				cb_list_add (current_program->user_spec_list, prototype);
		}
	}
}

static void
error_if_record_delimiter_incompatible (const int organization,
					const char *organization_name)
{
	int	is_compatible;

	if (!current_file->flag_delimiter) {
		return;
	}

	if (organization == COB_ORG_LINE_SEQUENTIAL) {
		is_compatible = current_file->organization == COB_ORG_SEQUENTIAL
			|| current_file->organization == COB_ORG_LINE_SEQUENTIAL;
	} else {
		is_compatible = current_file->organization == organization;
	}

	if (!is_compatible) {
		cb_error (_("ORGANIZATION %s is incompatible with RECORD DELIMITER"),
			  organization_name);
	}
}

static int
set_current_field (cb_tree level, cb_tree name)
{
	cb_tree	x  = cb_build_field_tree (level, name, current_field,
					  current_storage, current_file, 0);
	/* Free tree associated with level number */
	cobc_parse_free (level);

	if (CB_INVALID_TREE (x)) {
		return 1;
	} else {
		current_field = CB_FIELD (x);
		check_pic_duplicate = 0;
		if (current_field->level == 1 || current_field->level == 77) {
			within_typedef_definition = 0;
		}
	}

	return 0;
}

static void
setup_external_definition (cb_tree x, const int type)
{
	/* note: syntax checks for conflicting clauses
	         are done in inherit_external_definition */

	if (x != cb_error_node) {
		struct cb_field *f = CB_FIELD (cb_ref (x));

		/* additional checks if the definition isn't provided by type */
		if (type != 1 /* called with SAME AS / LIKE data-name */ ) {
			if (f->level == 88) {
				cb_error (_("condition-name not allowed here: '%s'"), cb_name (x));
				x = cb_error_node;
			}
			/* note: the following are not explicit specified but implied with
			   LIKE as ILE-COBOL does not have those sections */
			if (f->storage == CB_STORAGE_SCREEN) {
				cb_error (_("SCREEN item cannot be used here"));
				x = cb_error_node;
			} else if (f->storage == CB_STORAGE_REPORT) {
				cb_error (_("REPORT item cannot be used here"));
				x = cb_error_node;
			}
			if (type == 0) {
				/* rules that apply only to SAME AS */
				if (f->flag_is_typedef) {
					cb_error (_("TYPEDEF item cannot be used here"));
					x = cb_error_node;
				}
			}
		}

		if (current_field->level == 77) {
			if (type != 2 /* called with LIKE */
			 && f->children) {
				cb_error (_("elementary item expected"));
				x = cb_error_node;
			}
		} else {
			struct cb_field *p;
			for (p = current_field; p; p = p->parent) {
				if (p == f) {
					cb_error (_("item may not reference itself"));
					x = cb_error_node;
					break;
				}
			}
			for (p = f->parent; p; p = p->parent) {
				if (p->usage != CB_USAGE_DISPLAY) {
					cb_error (_("item may not be subordinate to any item with USAGE clause"));
				} else if (p->flag_sign_clause) {
					cb_error (_("item may not be subordinate to any item with SIGN clause"));
				} else {
					continue;
				}
				x = cb_error_node;
				break;
			}
		}
	}

	if (x == cb_error_node) {
		current_field->flag_is_verified = 1;
		current_field->flag_invalid = 1;
		current_field->external_definition = cb_error_node;
	} else {
		current_field->external_definition = cb_ref (x);
	}
}

static void
setup_external_definition_type (cb_tree x)
{
	if (!check_repeated ("TYPE TO", SYN_CLAUSE_31, &check_pic_duplicate)) {
		if (current_field->external_definition) {
			emit_conflicting_clause_message ("SAME AS", "TYPE TO");
		}
		setup_external_definition (x, 1);
	}
}

/* verifies that no conflicting clauses are used and
   inherits the definition of the original field specified
   by SAME AS or by type_name */
static void
inherit_external_definition (cb_tree lvl)
{
	/* note: REDEFINES (clause 1) is allowed with RM/COBOL but not COBOL 2002+ */
	static const cob_flags_t	allowed_clauses =
		SYN_CLAUSE_1 | SYN_CLAUSE_2 | SYN_CLAUSE_3 | SYN_CLAUSE_7 | SYN_CLAUSE_12;
	cob_flags_t	tested = check_pic_duplicate & ~(allowed_clauses);
	if (tested != SYN_CLAUSE_30 && tested != SYN_CLAUSE_31
	 && tested != 0 /* USAGE as TYPE TO */) {
		struct cb_field *fld = CB_FIELD (current_field->external_definition);
		cb_error_x (CB_TREE(current_field), _("illegal combination of %s with other clauses"),
			fld->flag_is_typedef ? "TYPE TO" : "SAME AS");
		current_field->flag_is_verified = 1;
		current_field->flag_invalid = 1;
	} else {
		struct cb_field *fld = CB_FIELD (current_field->external_definition);
		int new_level = lvl ? cb_get_level (lvl) : 0;
		int old_level = current_field->level;
		copy_into_field (fld, current_field);
		if (new_level > 1 && new_level < 66 && new_level > old_level) {
			cb_error_x (lvl, _("entry following %s may not be subordinate to it"),
				fld->flag_is_typedef ? "TYPE TO" : "SAME AS");
		}
	}
}

static cb_tree
get_finalized_description_tree (void)
{
	struct cb_field *p;

	/* finalize last field if target of SAME AS / TYPEDEF */
	if (current_field && !CB_INVALID_TREE (current_field->external_definition)) {
		inherit_external_definition (NULL);
	}

	/* validate the complete current "block" */
	for (p = description_field; p; p = p->sister) {
		cb_validate_field (p);
	}
	return CB_TREE (description_field);
}

static void
check_not_both (const cob_flags_t flag1, const cob_flags_t flag2,
		const char *flag1_name, const char *flag2_name,
		const cob_flags_t flags, const cob_flags_t flag_to_set)
{
	if (flag_to_set == flag1 && (flags & flag2)) {
		cb_error (_("cannot specify both %s and %s"),
			  flag1_name, flag2_name);
	} else if (flag_to_set == flag2 && (flags & flag1)) {
		cb_error (_("cannot specify both %s and %s"),
			  flag1_name, flag2_name);

	}
}

static COB_INLINE COB_A_INLINE void
check_not_highlight_and_lowlight (const cob_flags_t flags,
				  const cob_flags_t flag_to_set)
{
	check_not_both (COB_SCREEN_HIGHLIGHT, COB_SCREEN_LOWLIGHT,
			"HIGHLIGHT", "LOWLIGHT", flags, flag_to_set);
}

static void
set_screen_attr (const char *clause, const cob_flags_t bitval)
{
	if (current_field->screen_flag & bitval) {
		emit_duplicate_clause_message (clause);
	} else {
		current_field->screen_flag |= bitval;
	}
}

static void
set_attr_with_conflict (const char *clause, const cob_flags_t bitval,
			const char *confl_clause, const cob_flags_t confl_bit,
			const int local_check_duplicate, cob_flags_t *flags)
{
	if (local_check_duplicate && (*flags & bitval)) {
		emit_duplicate_clause_message (clause);
	} else if (*flags & confl_bit) {
		emit_conflicting_clause_message (clause, confl_clause);
	} else {
		*flags |= bitval;
	}
}

static COB_INLINE COB_A_INLINE void
set_screen_attr_with_conflict (const char *clause, const cob_flags_t bitval,
			       const char *confl_clause,
			       const cob_flags_t confl_bit)
{
	set_attr_with_conflict (clause, bitval, confl_clause, confl_bit, 1,
				&current_field->screen_flag);
}

static COB_INLINE COB_A_INLINE int
has_dispattr (const cob_flags_t attrib)
{
	return current_statement->attr_ptr
		&& current_statement->attr_ptr->dispattrs & attrib;
}

static void
attach_attrib_to_cur_stmt (void)
{
	if (!current_statement->attr_ptr) {
		current_statement->attr_ptr =
			cobc_parse_malloc (sizeof(struct cb_attr_struct));
	}
}

static COB_INLINE COB_A_INLINE void
set_dispattr (const cob_flags_t attrib)
{
	attach_attrib_to_cur_stmt ();
	current_statement->attr_ptr->dispattrs |= attrib;
}

static COB_INLINE COB_A_INLINE void
set_dispattr_with_conflict (const char *attrib_name, const cob_flags_t attrib,
			    const char *confl_name,
			    const cob_flags_t confl_attrib)
{
	attach_attrib_to_cur_stmt ();
	set_attr_with_conflict (attrib_name, attrib, confl_name, confl_attrib, 0,
				&current_statement->attr_ptr->dispattrs);
}

static void
bit_set_attr (const cb_tree on_off, const cob_flags_t attr_val)
{
	if (on_off == cb_int1) {
		set_attr_val_on |= attr_val;
	} else {
		set_attr_val_off |= attr_val;
	}
}

static void
set_field_attribs (cb_tree fgc, cb_tree bgc, cb_tree scroll,
		   cb_tree timeout, cb_tree prompt, cb_tree size_is)
{
	/* [WITH] FOREGROUND-COLOR [IS] */
	if (fgc) {
		current_statement->attr_ptr->fgc = fgc;
	}
	/* [WITH] BACKGROUND-COLOR [IS] */
	if (bgc) {
		current_statement->attr_ptr->bgc = bgc;
	}
	/* [WITH] SCROLL UP | DOWN */
	if (scroll) {
		current_statement->attr_ptr->scroll = scroll;
	}
	/* [WITH] TIME-OUT [AFTER] */
	if (timeout) {
		current_statement->attr_ptr->timeout = timeout;
	}
	/* [WITH] PROMPT CHARACTER [IS] */
	if (prompt) {
		current_statement->attr_ptr->prompt = prompt;
	}
	/* [WITH] SIZE [IS] */
	if (size_is) {
		current_statement->attr_ptr->size_is = size_is;
	}
}

static void
set_attribs (cb_tree fgc, cb_tree bgc, cb_tree scroll,
	     cb_tree timeout, cb_tree prompt, cb_tree size_is,
	     const cob_flags_t attrib)
{
	attach_attrib_to_cur_stmt ();
	set_field_attribs (fgc, bgc, scroll, timeout, prompt, size_is);

	current_statement->attr_ptr->dispattrs |= attrib;
}

static void
set_attribs_with_conflict  (cb_tree fgc, cb_tree bgc, cb_tree scroll,
			    cb_tree timeout, cb_tree prompt, cb_tree size_is,
			    const char *clause_name, const cob_flags_t attrib,
			    const char *confl_name, const cob_flags_t confl_attrib)
{
	attach_attrib_to_cur_stmt ();
	set_field_attribs (fgc, bgc, scroll, timeout, prompt, size_is);

	set_dispattr_with_conflict (clause_name, attrib, confl_name,
				    confl_attrib);
}

static cob_flags_t
zero_conflicting_flag (const cob_flags_t screen_flag, cob_flags_t parent_flag,
				const cob_flags_t flag1, const cob_flags_t flag2)
{
	if (screen_flag & flag1) {
		parent_flag &= ~flag2;
	} else if (screen_flag & flag2) {
		parent_flag &= ~flag1;
	}

	return parent_flag;
}

static cob_flags_t
zero_conflicting_flags (const cob_flags_t screen_flag, cob_flags_t parent_flag)
{
	parent_flag = zero_conflicting_flag (screen_flag, parent_flag,
					     COB_SCREEN_BLANK_LINE,
					     COB_SCREEN_BLANK_SCREEN);
	parent_flag = zero_conflicting_flag (screen_flag, parent_flag,
					     COB_SCREEN_ERASE_EOL,
					     COB_SCREEN_ERASE_EOS);
	parent_flag = zero_conflicting_flag (screen_flag, parent_flag,
					     COB_SCREEN_HIGHLIGHT,
					     COB_SCREEN_LOWLIGHT);

	return parent_flag;
}

static void
check_and_set_usage (const enum cb_usage usage)
{
	check_repeated ("USAGE", SYN_CLAUSE_5, &check_pic_duplicate);
	current_field->usage = usage;
}

static void
check_preceding_tallying_phrases (const enum tallying_phrase phrase)
{
	switch (phrase) {
	case FOR_PHRASE:
		if (previous_tallying_phrase == ALL_LEADING_TRAILING_PHRASES) {
			cb_error (_("FOR phrase cannot immediately follow ALL/LEADING/TRAILING"));
		} else if (previous_tallying_phrase == FOR_PHRASE) {
			cb_error (_("missing CHARACTERS/ALL/LEADING/TRAILING phrase after FOR phrase"));
		}
		break;

	case ALL_LEADING_TRAILING_PHRASES:
		if (previous_tallying_phrase == CHARACTERS_PHRASE
			   || previous_tallying_phrase == ALL_LEADING_TRAILING_PHRASES) {
			cb_error (_("missing value between ALL/LEADING/TRAILING words"));
		}
		/* fall through */
	case CHARACTERS_PHRASE:
		if (previous_tallying_phrase == NO_PHRASE) {
			cb_error (_("missing FOR phrase before CHARACTERS/ALL/LEADING/TRAILING phrase"));
		}
		break;

	case VALUE_REGION_PHRASE:
		if (!(previous_tallying_phrase == ALL_LEADING_TRAILING_PHRASES
		      || previous_tallying_phrase == VALUE_REGION_PHRASE)) {
			cb_error (_("missing ALL/LEADING/TRAILING before value"));
		}
		break;

	/* LCOV_EXCL_START */
	default:
		/* This should never happen (and therefore doesn't get a translation) */
		cb_error ("unexpected tallying phrase");
		COBC_ABORT();
	/* LCOV_EXCL_STOP */
	}

	previous_tallying_phrase = phrase;
}

static int
has_relative_pos (struct cb_field const *field)
{
	return !!(field->screen_flag
		  & (COB_SCREEN_LINE_PLUS | COB_SCREEN_LINE_MINUS
		     | COB_SCREEN_COLUMN_PLUS | COB_SCREEN_COLUMN_MINUS));
}

static int
is_recursive_call (cb_tree target)
{
	const char *target_name = "";

	if (CB_LITERAL_P (target)) {
		target_name = (const char *)(CB_LITERAL(target)->data);
	} else if (CB_REFERENCE_P (target)
		   && CB_PROTOTYPE_P (cb_ref (target))) {
		target_name = CB_PROTOTYPE (cb_ref (target))->ext_name;
	}

	return !strcmp (target_name, current_program->orig_program_id);
}

static cb_tree
check_not_88_level (cb_tree x)
{
	struct cb_field	*f;

	if (x == cb_error_node) {
		return cb_error_node;
	}
	if (!CB_REF_OR_FIELD_P(x)) {
		return x;
	}

	f = CB_FIELD_PTR (x);

	if (f->level == 88) {
#if 0	/* note: we may consider to support the extension (if existing) to
		         reference a condition-name target by the condition-name */
		if (cb_verify (cb_condition_references_data, _("use of condition-name in place of data-name"))) {
			return CB_TREE (f->parent);
		}
#else
		cb_error (_("condition-name not allowed here: '%s'"), cb_name (x));
		/* invalidate field to prevent same error in typeck.c (validate_one) */
		/* FIXME: If we really need the additional check here then we missed
		          a call to cb_validate_one() somewhere */
		return cb_error_node; 
#endif
	} else {
		return x;
	}
}

static int
is_screen_field (cb_tree x)
{
	if (CB_FIELD_P (x)) {
		return (CB_FIELD (x))->storage == CB_STORAGE_SCREEN;
	} else if (CB_REFERENCE_P (x)) {
		return is_screen_field (cb_ref (x));
	} else {
		return 0;
	}
}

static void
error_if_no_advancing_in_screen_display (cb_tree advancing)
{
	if (advancing != cb_int1) {
		cb_error (_("cannot specify NO ADVANCING in screen DISPLAY"));
	}
}

static cb_tree
get_default_display_device (void)
{
	if (current_program->flag_console_is_crt
	    || cb_console_is_crt) {
		return cb_null;
	} else {
		return cb_int0;
	}
}

static COB_INLINE COB_A_INLINE int
contains_one_screen_field (struct cb_list *x_list)
{
	return (cb_tree) x_list != cb_null
		&& cb_list_length ((cb_tree) x_list) == 1
		&& is_screen_field (x_list->value);
}

static int
contains_only_screen_fields (struct cb_list *x_list)
{
	if ((cb_tree) x_list == cb_null) {
		return 0;
	}

	for (; x_list; x_list = (struct cb_list *) x_list->chain) {
		if (!is_screen_field (x_list->value)) {
			return 0;
		}
	}

	return 1;
}

static int
contains_fields_and_screens (struct cb_list *x_list)
{
	int	field_seen = 0;
	int	screen_seen = 0;

	if ((cb_tree) x_list == cb_null) {
		return 0;
	}

	for (; x_list; x_list = (struct cb_list *) x_list->chain) {
		if (is_screen_field (x_list->value)) {
			screen_seen = 1;
		} else {
			field_seen = 1;
		}
	}

	return screen_seen && field_seen;
}

static enum cb_display_type
deduce_display_type (cb_tree x_list, cb_tree local_upon_value, cb_tree local_line_column,
		     struct cb_attr_struct * const attr_ptr)
{
	int	using_default_device_which_is_crt =
		local_upon_value == NULL && get_default_display_device () == cb_null;

	/* TODO: Separate CGI DISPLAYs here */
	if (contains_only_screen_fields ((struct cb_list *) x_list)) {
		if (!contains_one_screen_field ((struct cb_list *) x_list)
		    || attr_ptr) {
			cb_verify_x (x_list, cb_accept_display_extensions,
				     _("non-standard DISPLAY"));
		}

		if (local_upon_value != NULL && local_upon_value != cb_null) {
			cb_error_x (x_list, _("screens may only be displayed on CRT"));
		}

		return SCREEN_DISPLAY;
	} else if (contains_fields_and_screens ((struct cb_list *) x_list)) {
		cb_error_x (x_list, _("cannot mix screens and fields in the same DISPLAY statement"));
		return MIXED_DISPLAY;
	} else if (local_line_column || attr_ptr) {
		if (local_upon_value != NULL && local_upon_value != cb_null) {
			cb_error_x (x_list, _("screen clauses may only be used for DISPLAY on CRT"));
		}

		cb_verify_x (x_list, cb_accept_display_extensions,
			     _("non-standard DISPLAY"));

		return FIELD_ON_SCREEN_DISPLAY;
	} else if (local_upon_value == cb_null || using_default_device_which_is_crt) {
		/* This is the only format permitted by the standard */
		return FIELD_ON_SCREEN_DISPLAY;
	} else if (display_type == FIELD_ON_SCREEN_DISPLAY && local_upon_value == NULL) {
		/* This is for when fields without clauses follow fields with screen clauses */
		return FIELD_ON_SCREEN_DISPLAY;
	} else {
		return DEVICE_DISPLAY;
	}
}

static void
set_display_type (cb_tree x_list, cb_tree local_upon_value,
		  cb_tree local_line_column, struct cb_attr_struct * const attr_ptr)
{
	display_type = deduce_display_type (x_list, local_upon_value, local_line_column, attr_ptr);
}

static void
error_if_different_display_type (cb_tree x_list, cb_tree local_upon_value,
				 cb_tree local_line_column, struct cb_attr_struct * const attr_ptr)
{
	const enum cb_display_type	type =
		deduce_display_type (x_list, local_upon_value, local_line_column, attr_ptr);

	/* Avoid re-displaying the same error for mixed DISPLAYs */
	if (type == display_type || display_type == MIXED_DISPLAY) {
		return;
	}

	if (type != MIXED_DISPLAY) {
		if (type == SCREEN_DISPLAY || display_type == SCREEN_DISPLAY) {
			cb_error_x (x_list, _("cannot mix screens and fields in the same DISPLAY statement"));
		} else {
			/*
			  The only other option is that there is a mix of
			  FIELD_ON_SCREEN_DISPLAY and DEVICE_DISPLAY.
			*/
			cb_error_x (x_list, _("ambiguous DISPLAY; put items to display on device in separate DISPLAY"));
		}
	}

	display_type = MIXED_DISPLAY;
}

static void
error_if_not_usage_display_or_nonnumeric_lit (cb_tree x)
{
	const int	is_numeric_literal = CB_NUMERIC_LITERAL_P (x);
	const int	is_field_with_usage_not_display =
		CB_REFERENCE_P (x) && CB_FIELD (cb_ref (x))
		&& CB_FIELD (cb_ref (x))->usage != CB_USAGE_DISPLAY;

	if (is_numeric_literal) {
		cb_error_x (x, _("%s is not an alphanumeric literal"), CB_LITERAL (x)->data);
	} else if (is_field_with_usage_not_display) {
		cb_error_x (x, _("'%s' is not USAGE DISPLAY"), cb_name (x));
	}
}

static void
check_validate_item (cb_tree x)
{
	struct cb_field	*f;
	enum cb_class	tree_class;

	if (CB_INVALID_TREE(x) || x->tag != CB_TAG_REFERENCE) {
		return;
	}
	x = cb_ref (x);
	if (CB_INVALID_TREE (x) || !CB_FIELD_P (x)) {
		cb_error (_("invalid target for %s"), "VALIDATE");
		return;
	}

	f = CB_FIELD (x);
	tree_class = CB_TREE_CLASS(f);
	if (is_screen_field(x)) {
		cb_error (_("SCREEN item cannot be used here"));
	} else if (f->level == 66) {
		cb_error (_("RENAMES item may not be used here"));
	} else if (f->flag_any_length) {
		cb_error (_("ANY LENGTH item not allowed here"));
	} else if (tree_class == CB_CLASS_INDEX
		|| tree_class == CB_CLASS_OBJECT
		|| tree_class == CB_CLASS_POINTER) {
		cb_error (_("item '%s' has wrong class for VALIDATE"), cb_name (x));
	}
}

static void
error_if_following_every_clause (void)
{
	if (ml_suppress_list
	    && CB_ML_SUPPRESS (CB_VALUE (ml_suppress_list))->target == CB_ML_SUPPRESS_TYPE) {
		cb_error (_("WHEN clause must follow EVERY clause"));
	}
}

static void
prepend_to_ml_suppress_list (cb_tree suppress_entry)
{
	cb_tree	new_list_head = CB_LIST_INIT (suppress_entry);
	cb_list_append (new_list_head, ml_suppress_list);
	ml_suppress_list = new_list_head;
}

static void
add_identifier_to_ml_suppress_conds (cb_tree identifier)
{
	cb_tree suppress_id = cb_build_ml_suppress_clause ();
	CB_ML_SUPPRESS (suppress_id)->target = CB_ML_SUPPRESS_IDENTIFIER;
	CB_ML_SUPPRESS (suppress_id)->identifier = identifier;
	prepend_to_ml_suppress_list (suppress_id);
}

static void
add_when_to_ml_suppress_conds (cb_tree when_list)
{
	struct cb_ml_suppress_clause	*last_suppress_clause;
	cb_tree	suppress_all;

	/*
	  If the preceding clause in SUPPRESS was an identifier, the WHEN
	  belongs to the identifier. If EVERY was preceding, the WHEN belongs to
	  the EVERY. Otherwise, the WHEN acts on the entire record.
	*/
	if (ml_suppress_list) {
		last_suppress_clause = CB_ML_SUPPRESS (CB_VALUE (ml_suppress_list));
		if ((last_suppress_clause->target == CB_ML_SUPPRESS_IDENTIFIER
		     || last_suppress_clause->target == CB_ML_SUPPRESS_TYPE)
		    && !last_suppress_clause->when_list) {
			last_suppress_clause->when_list = when_list;
			return;
		}
	}

	suppress_all = cb_build_ml_suppress_clause ();
	CB_ML_SUPPRESS (suppress_all)->when_list = when_list;
	prepend_to_ml_suppress_list (suppress_all);
}

static void
add_type_to_ml_suppress_conds (enum cb_ml_suppress_category category,
			       enum cb_ml_type ml_type)
{
	cb_tree	suppress_type = cb_build_ml_suppress_clause ();
	CB_ML_SUPPRESS (suppress_type)->target = CB_ML_SUPPRESS_TYPE;
	CB_ML_SUPPRESS (suppress_type)->category = category;
	CB_ML_SUPPRESS (suppress_type)->ml_type = ml_type;
	prepend_to_ml_suppress_list (suppress_type);
}

static void
set_record_size (cb_tree min, cb_tree max)
{
	int record_min, record_max;

	if (min) {
		record_min = cb_get_int (min);
		if (record_min < 0) {
			/* already handled by integer check */
		} else {
			current_file->record_min = record_min;
		}
	} else {
		record_min = 0;
	}
	if (!max) return;
	record_max = cb_get_int (max);
	if (record_max < 0) {
		/* already handled by integer check */
		return;
	} else if (record_max == 0) {
		/* Note: standard COBOL does not allow zero at all, use the related
		         configuration option */
		if (cb_records_mismatch_record_clause >= CB_ERROR) {
			cb_error (_("non-zero value expected"));
		}
		return;
	}
	if (current_file->organization == COB_ORG_INDEXED
	 && record_max > MAX_FD_RECORD_IDX)  {
		cb_error (_("RECORD size (IDX) exceeds maximum allowed (%d)"),
			MAX_FD_RECORD_IDX);
		current_file->record_max = MAX_FD_RECORD_IDX;
	} else if (record_max > MAX_FD_RECORD)  {
		cb_error (_("RECORD size exceeds maximum allowed (%d)"),
			MAX_FD_RECORD);
		current_file->record_max = MAX_FD_RECORD;
	} else {
		if (record_max <= record_min)  {
			cb_error (_("RECORD clause invalid"));
		}
		current_file->record_max = record_max;
	}
}


#line 2300 "parser.c" /* yacc.c:337  */
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 1
#endif

/* In a future release of Bison, this section will be replaced
   by #include "y.tab.h".  */
#ifndef YY_YY_PARSER_H_INCLUDED
# define YY_YY_PARSER_H_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int yydebug;
#endif

/* Token type.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    TOKEN_EOF = 0,
    THREEDIMENSIONAL = 258,
    ABSENT = 259,
    ACCEPT = 260,
    ACCESS = 261,
    ACTIVEX = 262,
    ACTION = 263,
    ACTUAL = 264,
    ADD = 265,
    ADDRESS = 266,
    ADJUSTABLE_COLUMNS = 267,
    ADVANCING = 268,
    AFTER = 269,
    ALIGNMENT = 270,
    ALL = 271,
    ALLOCATE = 272,
    ALLOWING = 273,
    ALPHABET = 274,
    ALPHABETIC = 275,
    ALPHABETIC_LOWER = 276,
    ALPHABETIC_UPPER = 277,
    ALPHANUMERIC = 278,
    ALPHANUMERIC_EDITED = 279,
    ALSO = 280,
    ALTER = 281,
    ALTERNATE = 282,
    AND = 283,
    ANY = 284,
    APPLY = 285,
    ARE = 286,
    AREA = 287,
    AREAS = 288,
    ARGUMENT_NUMBER = 289,
    ARGUMENT_VALUE = 290,
    ARITHMETIC = 291,
    AS = 292,
    ASCENDING = 293,
    ASCII = 294,
    ASSIGN = 295,
    AT = 296,
    ATTRIBUTE = 297,
    ATTRIBUTES = 298,
    AUTO = 299,
    AUTO_DECIMAL = 300,
    AUTO_SPIN = 301,
    AUTOMATIC = 302,
    AWAY_FROM_ZERO = 303,
    BACKGROUND_COLOR = 304,
    BACKGROUND_HIGH = 305,
    BACKGROUND_LOW = 306,
    BACKGROUND_STANDARD = 307,
    BAR = 308,
    BASED = 309,
    BEFORE = 310,
    BELL = 311,
    BINARY = 312,
    BINARY_C_LONG = 313,
    BINARY_CHAR = 314,
    BINARY_DOUBLE = 315,
    BINARY_LONG = 316,
    BINARY_SEQUENTIAL = 317,
    BINARY_SHORT = 318,
    BIT = 319,
    BITMAP = 320,
    BITMAP_END = 321,
    BITMAP_HANDLE = 322,
    BITMAP_NUMBER = 323,
    BITMAP_START = 324,
    BITMAP_TIMER = 325,
    BITMAP_TRAILING = 326,
    BITMAP_TRANSPARENT_COLOR = 327,
    BITMAP_WIDTH = 328,
    BLANK = 329,
    BLINK = 330,
    BLOCK = 331,
    BOTTOM = 332,
    BOX = 333,
    BOXED = 334,
    BULK_ADDITION = 335,
    BUSY = 336,
    BUTTONS = 337,
    BY = 338,
    BYTE_LENGTH = 339,
    C = 340,
    CALENDAR_FONT = 341,
    CALL = 342,
    CANCEL = 343,
    CANCEL_BUTTON = 344,
    CAPACITY = 345,
    CARD_PUNCH = 346,
    CARD_READER = 347,
    CASSETTE = 348,
    CCOL = 349,
    CD = 350,
    CELL = 351,
    CELL_COLOR = 352,
    CELL_DATA = 353,
    CELL_FONT = 354,
    CELL_PROTECTION = 355,
    CENTER = 356,
    CENTERED = 357,
    CENTERED_HEADINGS = 358,
    CENTURY_DATE = 359,
    CF = 360,
    CH = 361,
    CHAINING = 362,
    CHARACTER = 363,
    CHARACTERS = 364,
    CHECK_BOX = 365,
    CLASS = 366,
    CLASSIFICATION = 367,
    CLASS_NAME = 368,
    CLEAR_SELECTION = 369,
    CLINE = 370,
    CLINES = 371,
    CLOSE = 372,
    COBOL = 373,
    CODE = 374,
    CODE_SET = 375,
    COLLATING = 376,
    COL = 377,
    COLOR = 378,
    COLORS = 379,
    COLS = 380,
    COLUMN = 381,
    COLUMN_COLOR = 382,
    COLUMN_DIVIDERS = 383,
    COLUMN_FONT = 384,
    COLUMN_HEADINGS = 385,
    COLUMN_PROTECTION = 386,
    COLUMNS = 387,
    COMBO_BOX = 388,
    COMMA = 389,
    COMMAND_LINE = 390,
    COMMA_DELIM = 391,
    COMMIT = 392,
    COMMON = 393,
    COMMUNICATION = 394,
    COMP = 395,
    COMPUTE = 396,
    COMP_0 = 397,
    COMP_1 = 398,
    COMP_2 = 399,
    COMP_3 = 400,
    COMP_4 = 401,
    COMP_5 = 402,
    COMP_6 = 403,
    COMP_N = 404,
    COMP_X = 405,
    CONCATENATE_FUNC = 406,
    CONDITION = 407,
    CONFIGURATION = 408,
    CONSTANT = 409,
    CONTAINS = 410,
    CONTENT = 411,
    CONTENT_LENGTH_FUNC = 412,
    CONTENT_OF_FUNC = 413,
    CONTINUE = 414,
    CONTROL = 415,
    CONTROLS = 416,
    CONVERSION = 417,
    CONVERTING = 418,
    COPY = 419,
    COPY_SELECTION = 420,
    CORE_INDEX = 421,
    CORRESPONDING = 422,
    COUNT = 423,
    CRT = 424,
    CRT_UNDER = 425,
    CSIZE = 426,
    CURRENCY = 427,
    CURRENT_DATE_FUNC = 428,
    CURSOR = 429,
    CURSOR_COL = 430,
    CURSOR_COLOR = 431,
    CURSOR_FRAME_WIDTH = 432,
    CURSOR_ROW = 433,
    CURSOR_X = 434,
    CURSOR_Y = 435,
    CUSTOM_PRINT_TEMPLATE = 436,
    CYCLE = 437,
    CYL_INDEX = 438,
    CYL_OVERFLOW = 439,
    DASHED = 440,
    DATA = 441,
    DATA_COLUMNS = 442,
    DATA_TYPES = 443,
    DATE = 444,
    DATE_ENTRY = 445,
    DAY = 446,
    DAY_OF_WEEK = 447,
    DE = 448,
    DEBUGGING = 449,
    DECIMAL_POINT = 450,
    DECLARATIVES = 451,
    DEFAULT = 452,
    DEFAULT_BUTTON = 453,
    DEFAULT_FONT = 454,
    DELETE = 455,
    DELIMITED = 456,
    DELIMITER = 457,
    DEPENDING = 458,
    DESCENDING = 459,
    DESTINATION = 460,
    DESTROY = 461,
    DETAIL = 462,
    DISABLE = 463,
    DISC = 464,
    DISK = 465,
    DISP = 466,
    DISPLAY = 467,
    DISPLAY_COLUMNS = 468,
    DISPLAY_FORMAT = 469,
    DISPLAY_OF_FUNC = 470,
    DIVIDE = 471,
    DIVIDERS = 472,
    DIVIDER_COLOR = 473,
    DIVISION = 474,
    DOTDASH = 475,
    DOTTED = 476,
    DRAG_COLOR = 477,
    DROP_DOWN = 478,
    DROP_LIST = 479,
    DOWN = 480,
    DUPLICATES = 481,
    DYNAMIC = 482,
    EBCDIC = 483,
    EC = 484,
    ECHO = 485,
    EGI = 486,
    EIGHTY_EIGHT = 487,
    ENABLE = 488,
    ELEMENT = 489,
    ELSE = 490,
    EMI = 491,
    ENCRYPTION = 492,
    ENCODING = 493,
    END = 494,
    END_ACCEPT = 495,
    END_ADD = 496,
    END_CALL = 497,
    END_COMPUTE = 498,
    END_COLOR = 499,
    END_DELETE = 500,
    END_DISPLAY = 501,
    END_DIVIDE = 502,
    END_EVALUATE = 503,
    END_FUNCTION = 504,
    END_IF = 505,
    END_JSON = 506,
    END_MODIFY = 507,
    END_MULTIPLY = 508,
    END_PERFORM = 509,
    END_PROGRAM = 510,
    END_READ = 511,
    END_RECEIVE = 512,
    END_RETURN = 513,
    END_REWRITE = 514,
    END_SEARCH = 515,
    END_START = 516,
    END_STRING = 517,
    END_SUBTRACT = 518,
    END_UNSTRING = 519,
    END_WRITE = 520,
    END_XML = 521,
    ENGRAVED = 522,
    ENSURE_VISIBLE = 523,
    ENTRY = 524,
    ENTRY_CONVENTION = 525,
    ENTRY_FIELD = 526,
    ENTRY_REASON = 527,
    ENVIRONMENT = 528,
    ENVIRONMENT_NAME = 529,
    ENVIRONMENT_VALUE = 530,
    EOL = 531,
    EOP = 532,
    EOS = 533,
    EQUAL = 534,
    ERASE = 535,
    ERROR = 536,
    ESCAPE = 537,
    ESCAPE_BUTTON = 538,
    ESI = 539,
    EVALUATE = 540,
    EVENT = 541,
    EVENT_LIST = 542,
    EVENT_STATUS = 543,
    EVERY = 544,
    EXCEPTION = 545,
    EXCEPTION_CONDITION = 546,
    EXCEPTION_VALUE = 547,
    EXPAND = 548,
    EXCLUSIVE = 549,
    EXIT = 550,
    EXPONENTIATION = 551,
    EXTEND = 552,
    EXTENDED_SEARCH = 553,
    EXTERNAL = 554,
    EXTERNAL_FORM = 555,
    F = 556,
    FD = 557,
    FH__FCD = 558,
    FH__KEYDEF = 559,
    FILE_CONTROL = 560,
    FILE_ID = 561,
    FILE_LIMIT = 562,
    FILE_LIMITS = 563,
    FILE_NAME = 564,
    FILE_POS = 565,
    FILL_COLOR = 566,
    FILL_COLOR2 = 567,
    FILL_PERCENT = 568,
    FILLER = 569,
    FINAL = 570,
    FINISH_REASON = 571,
    FIRST = 572,
    FIXED = 573,
    FIXED_FONT = 574,
    FIXED_WIDTH = 575,
    FLAT = 576,
    FLAT_BUTTONS = 577,
    FLOAT_BINARY_128 = 578,
    FLOAT_BINARY_32 = 579,
    FLOAT_BINARY_64 = 580,
    FLOAT_DECIMAL_16 = 581,
    FLOAT_DECIMAL_34 = 582,
    FLOAT_DECIMAL_7 = 583,
    FLOAT_EXTENDED = 584,
    FLOAT_LONG = 585,
    FLOAT_SHORT = 586,
    FLOATING = 587,
    FONT = 588,
    FOOTING = 589,
    FOR = 590,
    FOREGROUND_COLOR = 591,
    FOREVER = 592,
    FORMATTED_DATE_FUNC = 593,
    FORMATTED_DATETIME_FUNC = 594,
    FORMATTED_TIME_FUNC = 595,
    FRAME = 596,
    FRAMED = 597,
    FREE = 598,
    FROM = 599,
    FROM_CRT = 600,
    FULL = 601,
    FULL_HEIGHT = 602,
    FUNCTION = 603,
    FUNCTION_ID = 604,
    FUNCTION_NAME = 605,
    GENERATE = 606,
    GIVING = 607,
    GLOBAL = 608,
    GO = 609,
    GO_BACK = 610,
    GO_FORWARD = 611,
    GO_HOME = 612,
    GO_SEARCH = 613,
    GOBACK = 614,
    GRAPHICAL = 615,
    GREATER = 616,
    GREATER_OR_EQUAL = 617,
    GRID = 618,
    GROUP = 619,
    GROUP_VALUE = 620,
    HANDLE = 621,
    HAS_CHILDREN = 622,
    HEADING = 623,
    HEADING_COLOR = 624,
    HEADING_DIVIDER_COLOR = 625,
    HEADING_FONT = 626,
    HEAVY = 627,
    HEIGHT_IN_CELLS = 628,
    HIDDEN_DATA = 629,
    HIGHLIGHT = 630,
    HIGH_COLOR = 631,
    HIGH_VALUE = 632,
    HOT_TRACK = 633,
    HSCROLL = 634,
    HSCROLL_POS = 635,
    ICON = 636,
    ID = 637,
    IDENTIFIED = 638,
    IDENTIFICATION = 639,
    IF = 640,
    IGNORE = 641,
    IGNORING = 642,
    IN = 643,
    INDEPENDENT = 644,
    INDEX = 645,
    INDEXED = 646,
    INDICATE = 647,
    INITIALIZE = 648,
    INITIALIZED = 649,
    INITIATE = 650,
    INPUT = 651,
    INPUT_OUTPUT = 652,
    INQUIRE = 653,
    INSERTION_INDEX = 654,
    INSERT_ROWS = 655,
    INSPECT = 656,
    INTERMEDIATE = 657,
    INTO = 658,
    INTRINSIC = 659,
    INVALID = 660,
    INVALID_KEY = 661,
    IS = 662,
    ITEM = 663,
    ITEM_TEXT = 664,
    ITEM_TO_ADD = 665,
    ITEM_TO_DELETE = 666,
    ITEM_TO_EMPTY = 667,
    ITEM_VALUE = 668,
    I_O = 669,
    I_O_CONTROL = 670,
    JSON = 671,
    JUSTIFIED = 672,
    KEPT = 673,
    KEY = 674,
    KEYBOARD = 675,
    LABEL = 676,
    LABEL_OFFSET = 677,
    LARGE_FONT = 678,
    LARGE_OFFSET = 679,
    LAST = 680,
    LAST_ROW = 681,
    LAYOUT_DATA = 682,
    LAYOUT_MANAGER = 683,
    LEADING = 684,
    LEADING_SHIFT = 685,
    LEAVE = 686,
    LEFT = 687,
    LEFTLINE = 688,
    LEFT_TEXT = 689,
    LENGTH = 690,
    LENGTH_OF = 691,
    LENGTH_FUNC = 692,
    LESS = 693,
    LESS_OR_EQUAL = 694,
    LEVEL_NUMBER = 695,
    LIKE = 696,
    LIMIT = 697,
    LIMITS = 698,
    LINAGE = 699,
    LINAGE_COUNTER = 700,
    LINE = 701,
    LINE_COUNTER = 702,
    LINE_LIMIT = 703,
    LINE_SEQUENTIAL = 704,
    LINES = 705,
    LINES_AT_ROOT = 706,
    LINKAGE = 707,
    LIST_BOX = 708,
    LITERAL = 709,
    LM_RESIZE = 710,
    LOC = 711,
    LOCALE = 712,
    LOCALE_DATE_FUNC = 713,
    LOCALE_TIME_FUNC = 714,
    LOCALE_TIME_FROM_FUNC = 715,
    LOCAL_STORAGE = 716,
    LOCK = 717,
    LOCK_HOLDING = 718,
    LONG_DATE = 719,
    LOWER = 720,
    LOWERED = 721,
    LOWER_CASE_FUNC = 722,
    LOWLIGHT = 723,
    LOW_COLOR = 724,
    LOW_VALUE = 725,
    MAGNETIC_TAPE = 726,
    MANUAL = 727,
    MASS_UPDATE = 728,
    MASTER_INDEX = 729,
    MAX_LINES = 730,
    MAX_PROGRESS = 731,
    MAX_TEXT = 732,
    MAX_VAL = 733,
    MEMORY = 734,
    MEDIUM_FONT = 735,
    MENU = 736,
    MERGE = 737,
    MESSAGE = 738,
    MINUS = 739,
    MIN_VAL = 740,
    MNEMONIC_NAME = 741,
    MODE = 742,
    MODIFY = 743,
    MODULES = 744,
    MOVE = 745,
    MULTILINE = 746,
    MULTIPLE = 747,
    MULTIPLY = 748,
    NAME = 749,
    NAMESPACE = 750,
    NAMESPACE_PREFIX = 751,
    NATIONAL = 752,
    NATIONAL_EDITED = 753,
    NATIONAL_OF_FUNC = 754,
    NATIVE = 755,
    NAVIGATE_URL = 756,
    NEAREST_AWAY_FROM_ZERO = 757,
    NEAREST_EVEN = 758,
    NEAREST_TOWARD_ZERO = 759,
    NEGATIVE = 760,
    NESTED = 761,
    NEW = 762,
    NEXT = 763,
    NEXT_ITEM = 764,
    NEXT_GROUP = 765,
    NEXT_PAGE = 766,
    NO = 767,
    NO_ADVANCING = 768,
    NO_AUTOSEL = 769,
    NO_AUTO_DEFAULT = 770,
    NO_BOX = 771,
    NO_DATA = 772,
    NO_DIVIDERS = 773,
    NO_ECHO = 774,
    NO_F4 = 775,
    NO_FOCUS = 776,
    NO_GROUP_TAB = 777,
    NO_KEY_LETTER = 778,
    NOMINAL = 779,
    NO_SEARCH = 780,
    NO_UPDOWN = 781,
    NONNUMERIC = 782,
    NORMAL = 783,
    NOT = 784,
    NOTAB = 785,
    NOTHING = 786,
    NOTIFY = 787,
    NOTIFY_CHANGE = 788,
    NOTIFY_DBLCLICK = 789,
    NOTIFY_SELCHANGE = 790,
    NOT_END = 791,
    NOT_EOP = 792,
    NOT_ESCAPE = 793,
    NOT_EQUAL = 794,
    NOT_EXCEPTION = 795,
    NOT_INVALID_KEY = 796,
    NOT_OVERFLOW = 797,
    NOT_SIZE_ERROR = 798,
    NUM_COL_HEADINGS = 799,
    NUM_ROWS = 800,
    NUMBER = 801,
    NUMBERS = 802,
    NUMERIC = 803,
    NUMERIC_EDITED = 804,
    NUMVALC_FUNC = 805,
    OBJECT = 806,
    OBJECT_COMPUTER = 807,
    OCCURS = 808,
    OF = 809,
    OFF = 810,
    OK_BUTTON = 811,
    OMITTED = 812,
    ON = 813,
    ONLY = 814,
    OPEN = 815,
    OPTIONAL = 816,
    OPTIONS = 817,
    OR = 818,
    ORDER = 819,
    ORGANIZATION = 820,
    OTHER = 821,
    OTHERS = 822,
    OUTPUT = 823,
    OVERLAP_LEFT = 824,
    OVERLAP_TOP = 825,
    OVERLINE = 826,
    PACKED_DECIMAL = 827,
    PADDING = 828,
    PASCAL = 829,
    PAGE = 830,
    PAGE_COUNTER = 831,
    PAGE_SETUP = 832,
    PAGED = 833,
    PARAGRAPH = 834,
    PARENT = 835,
    PARSE = 836,
    PASSWORD = 837,
    PERFORM = 838,
    PERMANENT = 839,
    PH = 840,
    PF = 841,
    PHYSICAL = 842,
    PICTURE = 843,
    PICTURE_SYMBOL = 844,
    PIXEL = 845,
    PLACEMENT = 846,
    PLUS = 847,
    POINTER = 848,
    POP_UP = 849,
    POS = 850,
    POSITION = 851,
    POSITION_SHIFT = 852,
    POSITIVE = 853,
    PRESENT = 854,
    PREVIOUS = 855,
    PRINT = 856,
    PRINT_CONTROL = 857,
    PRINT_NO_PROMPT = 858,
    PRINT_PREVIEW = 859,
    PRINTER = 860,
    PRINTER_1 = 861,
    PRINTING = 862,
    PRIORITY = 863,
    PROCEDURE = 864,
    PROCEDURES = 865,
    PROCEED = 866,
    PROCESSING = 867,
    PROGRAM = 868,
    PROGRAM_ID = 869,
    PROGRAM_NAME = 870,
    PROGRAM_POINTER = 871,
    PROGRESS = 872,
    PROHIBITED = 873,
    PROMPT = 874,
    PROPERTIES = 875,
    PROPERTY = 876,
    PROTECTED = 877,
    PURGE = 878,
    PUSH_BUTTON = 879,
    QUERY_INDEX = 880,
    QUEUE = 881,
    QUOTE = 882,
    RADIO_BUTTON = 883,
    RAISE = 884,
    RAISED = 885,
    RANDOM = 886,
    RD = 887,
    READ = 888,
    READERS = 889,
    READ_ONLY = 890,
    READY_TRACE = 891,
    RECEIVE = 892,
    RECORD = 893,
    RECORD_DATA = 894,
    RECORD_OVERFLOW = 895,
    RECORD_TO_ADD = 896,
    RECORD_TO_DELETE = 897,
    RECORDING = 898,
    RECORDS = 899,
    RECURSIVE = 900,
    REDEFINES = 901,
    REEL = 902,
    REFERENCE = 903,
    REFERENCES = 904,
    REFRESH = 905,
    REGION_COLOR = 906,
    RELATIVE = 907,
    RELEASE = 908,
    REMAINDER = 909,
    REMOVAL = 910,
    RENAMES = 911,
    REORG_CRITERIA = 912,
    REPLACE = 913,
    REPLACING = 914,
    REPORT = 915,
    REPORTING = 916,
    REPORTS = 917,
    REPOSITORY = 918,
    REQUIRED = 919,
    REREAD = 920,
    RERUN = 921,
    RESERVE = 922,
    RESET = 923,
    RESET_TRACE = 924,
    RESET_GRID = 925,
    RESET_LIST = 926,
    RESET_TABS = 927,
    RETRY = 928,
    RETURN = 929,
    RETURNING = 930,
    REVERSE = 931,
    REVERSE_FUNC = 932,
    REVERSE_VIDEO = 933,
    REVERSED = 934,
    REWIND = 935,
    REWRITE = 936,
    RF = 937,
    RH = 938,
    RIGHT = 939,
    RIGHT_ALIGN = 940,
    RIMMED = 941,
    ROLLBACK = 942,
    ROUNDED = 943,
    ROUNDING = 944,
    ROW_COLOR = 945,
    ROW_COLOR_PATTERN = 946,
    ROW_DIVIDERS = 947,
    ROW_FONT = 948,
    ROW_HEADINGS = 949,
    ROW_PROTECTION = 950,
    RUN = 951,
    S = 952,
    SAME = 953,
    SAVE_AS = 954,
    SAVE_AS_NO_PROMPT = 955,
    SCREEN = 956,
    SCREEN_CONTROL = 957,
    SCROLL = 958,
    SCROLL_BAR = 959,
    SD = 960,
    SEARCH = 961,
    SEARCH_OPTIONS = 962,
    SEARCH_TEXT = 963,
    SECONDS = 964,
    SECTION = 965,
    SECURE = 966,
    SEGMENT = 967,
    SEGMENT_LIMIT = 968,
    SELECT = 969,
    SELECTION_INDEX = 970,
    SELECTION_TEXT = 971,
    SELECT_ALL = 972,
    SELF_ACT = 973,
    SEMI_COLON = 974,
    SEND = 975,
    SENTENCE = 976,
    SEPARATE = 977,
    SEPARATION = 978,
    SEQUENCE = 979,
    SEQUENTIAL = 980,
    SET = 981,
    SEVENTY_EIGHT = 982,
    SHADING = 983,
    SHADOW = 984,
    SHARING = 985,
    SHORT_DATE = 986,
    SHOW_LINES = 987,
    SHOW_NONE = 988,
    SHOW_SEL_ALWAYS = 989,
    SIGN = 990,
    SIGNED = 991,
    SIGNED_INT = 992,
    SIGNED_LONG = 993,
    SIGNED_SHORT = 994,
    SIXTY_SIX = 995,
    SIZE = 996,
    SIZE_ERROR = 997,
    SMALL_FONT = 998,
    SORT = 999,
    SORT_MERGE = 1000,
    SORT_ORDER = 1001,
    SOURCE = 1002,
    SOURCE_COMPUTER = 1003,
    SPACE = 1004,
    SPECIAL_NAMES = 1005,
    SPINNER = 1006,
    SQUARE = 1007,
    STANDARD = 1008,
    STANDARD_1 = 1009,
    STANDARD_2 = 1010,
    STANDARD_BINARY = 1011,
    STANDARD_DECIMAL = 1012,
    START = 1013,
    START_X = 1014,
    START_Y = 1015,
    STATIC = 1016,
    STATIC_LIST = 1017,
    STATUS = 1018,
    STATUS_BAR = 1019,
    STATUS_TEXT = 1020,
    STDCALL = 1021,
    STEP = 1022,
    STOP = 1023,
    STRING = 1024,
    STRONG = 1025,
    STYLE = 1026,
    SUB_QUEUE_1 = 1027,
    SUB_QUEUE_2 = 1028,
    SUB_QUEUE_3 = 1029,
    SUBSTITUTE_FUNC = 1030,
    SUBSTITUTE_CASE_FUNC = 1031,
    SUBTRACT = 1032,
    SUBWINDOW = 1033,
    SUM = 1034,
    SUPPRESS = 1035,
    SUPPRESS_XML = 1036,
    SYMBOLIC = 1037,
    SYNCHRONIZED = 1038,
    SYSTEM_DEFAULT = 1039,
    SYSTEM_INFO = 1040,
    SYSTEM_OFFSET = 1041,
    TAB = 1042,
    TAB_TO_ADD = 1043,
    TAB_TO_DELETE = 1044,
    TABLE = 1045,
    TALLYING = 1046,
    TEMPORARY = 1047,
    TAPE = 1048,
    TERMINAL = 1049,
    TERMINATE = 1050,
    TERMINAL_INFO = 1051,
    TERMINATION_VALUE = 1052,
    TEST = 1053,
    TEXT = 1054,
    THAN = 1055,
    THEN = 1056,
    THREAD = 1057,
    THREADS = 1058,
    THRU = 1059,
    THUMB_POSITION = 1060,
    TILED_HEADINGS = 1061,
    TIME = 1062,
    TIME_OUT = 1063,
    TIMES = 1064,
    TITLE = 1065,
    TITLE_POSITION = 1066,
    TO = 1067,
    TOK_AMPER = 1068,
    TOK_CLOSE_PAREN = 1069,
    TOK_COLON = 1070,
    TOK_DIV = 1071,
    TOK_DOT = 1072,
    TOK_EQUAL = 1073,
    TOK_EXTERN = 1074,
    TOK_FALSE = 1075,
    TOK_FILE = 1076,
    TOK_GREATER = 1077,
    TOK_INITIAL = 1078,
    TOK_LESS = 1079,
    TOK_MINUS = 1080,
    TOK_MUL = 1081,
    TOK_NULL = 1082,
    TOK_OVERFLOW = 1083,
    TOK_OPEN_PAREN = 1084,
    TOK_PLUS = 1085,
    TOK_TRUE = 1086,
    TOP = 1087,
    TOWARD_GREATER = 1088,
    TOWARD_LESSER = 1089,
    TRACK = 1090,
    TRACKS = 1091,
    TRACK_AREA = 1092,
    TRACK_LIMIT = 1093,
    TRADITIONAL_FONT = 1094,
    TRAILING = 1095,
    TRAILING_SHIFT = 1096,
    TRANSFORM = 1097,
    TRANSPARENT = 1098,
    TREE_VIEW = 1099,
    TRIM_FUNC = 1100,
    TRUNCATION = 1101,
    TYPE = 1102,
    TYPEDEF = 1103,
    U = 1104,
    UCS_4 = 1105,
    UNBOUNDED = 1106,
    UNDERLINE = 1107,
    UNFRAMED = 1108,
    UNIT = 1109,
    UNLOCK = 1110,
    UNSIGNED = 1111,
    UNSIGNED_INT = 1112,
    UNSIGNED_LONG = 1113,
    UNSIGNED_SHORT = 1114,
    UNSORTED = 1115,
    UNSTRING = 1116,
    UNTIL = 1117,
    UP = 1118,
    UPDATE = 1119,
    UPDATERS = 1120,
    UPON = 1121,
    UPON_ARGUMENT_NUMBER = 1122,
    UPON_COMMAND_LINE = 1123,
    UPON_ENVIRONMENT_NAME = 1124,
    UPON_ENVIRONMENT_VALUE = 1125,
    UPPER = 1126,
    UPPER_CASE_FUNC = 1127,
    USAGE = 1128,
    USE = 1129,
    USE_ALT = 1130,
    USE_RETURN = 1131,
    USE_TAB = 1132,
    USER = 1133,
    USER_DEFAULT = 1134,
    USER_FUNCTION_NAME = 1135,
    USING = 1136,
    UTF_8 = 1137,
    UTF_16 = 1138,
    V = 1139,
    VALIDATE = 1140,
    VALIDATING = 1141,
    VALUE = 1142,
    VALUE_FORMAT = 1143,
    VARIABLE = 1144,
    VARIANT = 1145,
    VARYING = 1146,
    VERTICAL = 1147,
    VERY_HEAVY = 1148,
    VIRTUAL_WIDTH = 1149,
    VOLATILE = 1150,
    VPADDING = 1151,
    VSCROLL = 1152,
    VSCROLL_BAR = 1153,
    VSCROLL_POS = 1154,
    VTOP = 1155,
    WAIT = 1156,
    WEB_BROWSER = 1157,
    WHEN = 1158,
    WHEN_COMPILED_FUNC = 1159,
    WHEN_XML = 1160,
    WIDTH = 1161,
    WIDTH_IN_CELLS = 1162,
    WINDOW = 1163,
    WITH = 1164,
    WORD = 1165,
    WORDS = 1166,
    WORKING_STORAGE = 1167,
    WRAP = 1168,
    WRITE = 1169,
    WRITE_ONLY = 1170,
    WRITE_VERIFY = 1171,
    WRITERS = 1172,
    X = 1173,
    XML = 1174,
    XML_DECLARATION = 1175,
    Y = 1176,
    YYYYDDD = 1177,
    YYYYMMDD = 1178,
    ZERO = 1179,
    SHIFT_PREFER = 1180
  };
#endif
/* Tokens.  */
#define TOKEN_EOF 0
#define THREEDIMENSIONAL 258
#define ABSENT 259
#define ACCEPT 260
#define ACCESS 261
#define ACTIVEX 262
#define ACTION 263
#define ACTUAL 264
#define ADD 265
#define ADDRESS 266
#define ADJUSTABLE_COLUMNS 267
#define ADVANCING 268
#define AFTER 269
#define ALIGNMENT 270
#define ALL 271
#define ALLOCATE 272
#define ALLOWING 273
#define ALPHABET 274
#define ALPHABETIC 275
#define ALPHABETIC_LOWER 276
#define ALPHABETIC_UPPER 277
#define ALPHANUMERIC 278
#define ALPHANUMERIC_EDITED 279
#define ALSO 280
#define ALTER 281
#define ALTERNATE 282
#define AND 283
#define ANY 284
#define APPLY 285
#define ARE 286
#define AREA 287
#define AREAS 288
#define ARGUMENT_NUMBER 289
#define ARGUMENT_VALUE 290
#define ARITHMETIC 291
#define AS 292
#define ASCENDING 293
#define ASCII 294
#define ASSIGN 295
#define AT 296
#define ATTRIBUTE 297
#define ATTRIBUTES 298
#define AUTO 299
#define AUTO_DECIMAL 300
#define AUTO_SPIN 301
#define AUTOMATIC 302
#define AWAY_FROM_ZERO 303
#define BACKGROUND_COLOR 304
#define BACKGROUND_HIGH 305
#define BACKGROUND_LOW 306
#define BACKGROUND_STANDARD 307
#define BAR 308
#define BASED 309
#define BEFORE 310
#define BELL 311
#define BINARY 312
#define BINARY_C_LONG 313
#define BINARY_CHAR 314
#define BINARY_DOUBLE 315
#define BINARY_LONG 316
#define BINARY_SEQUENTIAL 317
#define BINARY_SHORT 318
#define BIT 319
#define BITMAP 320
#define BITMAP_END 321
#define BITMAP_HANDLE 322
#define BITMAP_NUMBER 323
#define BITMAP_START 324
#define BITMAP_TIMER 325
#define BITMAP_TRAILING 326
#define BITMAP_TRANSPARENT_COLOR 327
#define BITMAP_WIDTH 328
#define BLANK 329
#define BLINK 330
#define BLOCK 331
#define BOTTOM 332
#define BOX 333
#define BOXED 334
#define BULK_ADDITION 335
#define BUSY 336
#define BUTTONS 337
#define BY 338
#define BYTE_LENGTH 339
#define C 340
#define CALENDAR_FONT 341
#define CALL 342
#define CANCEL 343
#define CANCEL_BUTTON 344
#define CAPACITY 345
#define CARD_PUNCH 346
#define CARD_READER 347
#define CASSETTE 348
#define CCOL 349
#define CD 350
#define CELL 351
#define CELL_COLOR 352
#define CELL_DATA 353
#define CELL_FONT 354
#define CELL_PROTECTION 355
#define CENTER 356
#define CENTERED 357
#define CENTERED_HEADINGS 358
#define CENTURY_DATE 359
#define CF 360
#define CH 361
#define CHAINING 362
#define CHARACTER 363
#define CHARACTERS 364
#define CHECK_BOX 365
#define CLASS 366
#define CLASSIFICATION 367
#define CLASS_NAME 368
#define CLEAR_SELECTION 369
#define CLINE 370
#define CLINES 371
#define CLOSE 372
#define COBOL 373
#define CODE 374
#define CODE_SET 375
#define COLLATING 376
#define COL 377
#define COLOR 378
#define COLORS 379
#define COLS 380
#define COLUMN 381
#define COLUMN_COLOR 382
#define COLUMN_DIVIDERS 383
#define COLUMN_FONT 384
#define COLUMN_HEADINGS 385
#define COLUMN_PROTECTION 386
#define COLUMNS 387
#define COMBO_BOX 388
#define COMMA 389
#define COMMAND_LINE 390
#define COMMA_DELIM 391
#define COMMIT 392
#define COMMON 393
#define COMMUNICATION 394
#define COMP 395
#define COMPUTE 396
#define COMP_0 397
#define COMP_1 398
#define COMP_2 399
#define COMP_3 400
#define COMP_4 401
#define COMP_5 402
#define COMP_6 403
#define COMP_N 404
#define COMP_X 405
#define CONCATENATE_FUNC 406
#define CONDITION 407
#define CONFIGURATION 408
#define CONSTANT 409
#define CONTAINS 410
#define CONTENT 411
#define CONTENT_LENGTH_FUNC 412
#define CONTENT_OF_FUNC 413
#define CONTINUE 414
#define CONTROL 415
#define CONTROLS 416
#define CONVERSION 417
#define CONVERTING 418
#define COPY 419
#define COPY_SELECTION 420
#define CORE_INDEX 421
#define CORRESPONDING 422
#define COUNT 423
#define CRT 424
#define CRT_UNDER 425
#define CSIZE 426
#define CURRENCY 427
#define CURRENT_DATE_FUNC 428
#define CURSOR 429
#define CURSOR_COL 430
#define CURSOR_COLOR 431
#define CURSOR_FRAME_WIDTH 432
#define CURSOR_ROW 433
#define CURSOR_X 434
#define CURSOR_Y 435
#define CUSTOM_PRINT_TEMPLATE 436
#define CYCLE 437
#define CYL_INDEX 438
#define CYL_OVERFLOW 439
#define DASHED 440
#define DATA 441
#define DATA_COLUMNS 442
#define DATA_TYPES 443
#define DATE 444
#define DATE_ENTRY 445
#define DAY 446
#define DAY_OF_WEEK 447
#define DE 448
#define DEBUGGING 449
#define DECIMAL_POINT 450
#define DECLARATIVES 451
#define DEFAULT 452
#define DEFAULT_BUTTON 453
#define DEFAULT_FONT 454
#define DELETE 455
#define DELIMITED 456
#define DELIMITER 457
#define DEPENDING 458
#define DESCENDING 459
#define DESTINATION 460
#define DESTROY 461
#define DETAIL 462
#define DISABLE 463
#define DISC 464
#define DISK 465
#define DISP 466
#define DISPLAY 467
#define DISPLAY_COLUMNS 468
#define DISPLAY_FORMAT 469
#define DISPLAY_OF_FUNC 470
#define DIVIDE 471
#define DIVIDERS 472
#define DIVIDER_COLOR 473
#define DIVISION 474
#define DOTDASH 475
#define DOTTED 476
#define DRAG_COLOR 477
#define DROP_DOWN 478
#define DROP_LIST 479
#define DOWN 480
#define DUPLICATES 481
#define DYNAMIC 482
#define EBCDIC 483
#define EC 484
#define ECHO 485
#define EGI 486
#define EIGHTY_EIGHT 487
#define ENABLE 488
#define ELEMENT 489
#define ELSE 490
#define EMI 491
#define ENCRYPTION 492
#define ENCODING 493
#define END 494
#define END_ACCEPT 495
#define END_ADD 496
#define END_CALL 497
#define END_COMPUTE 498
#define END_COLOR 499
#define END_DELETE 500
#define END_DISPLAY 501
#define END_DIVIDE 502
#define END_EVALUATE 503
#define END_FUNCTION 504
#define END_IF 505
#define END_JSON 506
#define END_MODIFY 507
#define END_MULTIPLY 508
#define END_PERFORM 509
#define END_PROGRAM 510
#define END_READ 511
#define END_RECEIVE 512
#define END_RETURN 513
#define END_REWRITE 514
#define END_SEARCH 515
#define END_START 516
#define END_STRING 517
#define END_SUBTRACT 518
#define END_UNSTRING 519
#define END_WRITE 520
#define END_XML 521
#define ENGRAVED 522
#define ENSURE_VISIBLE 523
#define ENTRY 524
#define ENTRY_CONVENTION 525
#define ENTRY_FIELD 526
#define ENTRY_REASON 527
#define ENVIRONMENT 528
#define ENVIRONMENT_NAME 529
#define ENVIRONMENT_VALUE 530
#define EOL 531
#define EOP 532
#define EOS 533
#define EQUAL 534
#define ERASE 535
#define ERROR 536
#define ESCAPE 537
#define ESCAPE_BUTTON 538
#define ESI 539
#define EVALUATE 540
#define EVENT 541
#define EVENT_LIST 542
#define EVENT_STATUS 543
#define EVERY 544
#define EXCEPTION 545
#define EXCEPTION_CONDITION 546
#define EXCEPTION_VALUE 547
#define EXPAND 548
#define EXCLUSIVE 549
#define EXIT 550
#define EXPONENTIATION 551
#define EXTEND 552
#define EXTENDED_SEARCH 553
#define EXTERNAL 554
#define EXTERNAL_FORM 555
#define F 556
#define FD 557
#define FH__FCD 558
#define FH__KEYDEF 559
#define FILE_CONTROL 560
#define FILE_ID 561
#define FILE_LIMIT 562
#define FILE_LIMITS 563
#define FILE_NAME 564
#define FILE_POS 565
#define FILL_COLOR 566
#define FILL_COLOR2 567
#define FILL_PERCENT 568
#define FILLER 569
#define FINAL 570
#define FINISH_REASON 571
#define FIRST 572
#define FIXED 573
#define FIXED_FONT 574
#define FIXED_WIDTH 575
#define FLAT 576
#define FLAT_BUTTONS 577
#define FLOAT_BINARY_128 578
#define FLOAT_BINARY_32 579
#define FLOAT_BINARY_64 580
#define FLOAT_DECIMAL_16 581
#define FLOAT_DECIMAL_34 582
#define FLOAT_DECIMAL_7 583
#define FLOAT_EXTENDED 584
#define FLOAT_LONG 585
#define FLOAT_SHORT 586
#define FLOATING 587
#define FONT 588
#define FOOTING 589
#define FOR 590
#define FOREGROUND_COLOR 591
#define FOREVER 592
#define FORMATTED_DATE_FUNC 593
#define FORMATTED_DATETIME_FUNC 594
#define FORMATTED_TIME_FUNC 595
#define FRAME 596
#define FRAMED 597
#define FREE 598
#define FROM 599
#define FROM_CRT 600
#define FULL 601
#define FULL_HEIGHT 602
#define FUNCTION 603
#define FUNCTION_ID 604
#define FUNCTION_NAME 605
#define GENERATE 606
#define GIVING 607
#define GLOBAL 608
#define GO 609
#define GO_BACK 610
#define GO_FORWARD 611
#define GO_HOME 612
#define GO_SEARCH 613
#define GOBACK 614
#define GRAPHICAL 615
#define GREATER 616
#define GREATER_OR_EQUAL 617
#define GRID 618
#define GROUP 619
#define GROUP_VALUE 620
#define HANDLE 621
#define HAS_CHILDREN 622
#define HEADING 623
#define HEADING_COLOR 624
#define HEADING_DIVIDER_COLOR 625
#define HEADING_FONT 626
#define HEAVY 627
#define HEIGHT_IN_CELLS 628
#define HIDDEN_DATA 629
#define HIGHLIGHT 630
#define HIGH_COLOR 631
#define HIGH_VALUE 632
#define HOT_TRACK 633
#define HSCROLL 634
#define HSCROLL_POS 635
#define ICON 636
#define ID 637
#define IDENTIFIED 638
#define IDENTIFICATION 639
#define IF 640
#define IGNORE 641
#define IGNORING 642
#define IN 643
#define INDEPENDENT 644
#define INDEX 645
#define INDEXED 646
#define INDICATE 647
#define INITIALIZE 648
#define INITIALIZED 649
#define INITIATE 650
#define INPUT 651
#define INPUT_OUTPUT 652
#define INQUIRE 653
#define INSERTION_INDEX 654
#define INSERT_ROWS 655
#define INSPECT 656
#define INTERMEDIATE 657
#define INTO 658
#define INTRINSIC 659
#define INVALID 660
#define INVALID_KEY 661
#define IS 662
#define ITEM 663
#define ITEM_TEXT 664
#define ITEM_TO_ADD 665
#define ITEM_TO_DELETE 666
#define ITEM_TO_EMPTY 667
#define ITEM_VALUE 668
#define I_O 669
#define I_O_CONTROL 670
#define JSON 671
#define JUSTIFIED 672
#define KEPT 673
#define KEY 674
#define KEYBOARD 675
#define LABEL 676
#define LABEL_OFFSET 677
#define LARGE_FONT 678
#define LARGE_OFFSET 679
#define LAST 680
#define LAST_ROW 681
#define LAYOUT_DATA 682
#define LAYOUT_MANAGER 683
#define LEADING 684
#define LEADING_SHIFT 685
#define LEAVE 686
#define LEFT 687
#define LEFTLINE 688
#define LEFT_TEXT 689
#define LENGTH 690
#define LENGTH_OF 691
#define LENGTH_FUNC 692
#define LESS 693
#define LESS_OR_EQUAL 694
#define LEVEL_NUMBER 695
#define LIKE 696
#define LIMIT 697
#define LIMITS 698
#define LINAGE 699
#define LINAGE_COUNTER 700
#define LINE 701
#define LINE_COUNTER 702
#define LINE_LIMIT 703
#define LINE_SEQUENTIAL 704
#define LINES 705
#define LINES_AT_ROOT 706
#define LINKAGE 707
#define LIST_BOX 708
#define LITERAL 709
#define LM_RESIZE 710
#define LOC 711
#define LOCALE 712
#define LOCALE_DATE_FUNC 713
#define LOCALE_TIME_FUNC 714
#define LOCALE_TIME_FROM_FUNC 715
#define LOCAL_STORAGE 716
#define LOCK 717
#define LOCK_HOLDING 718
#define LONG_DATE 719
#define LOWER 720
#define LOWERED 721
#define LOWER_CASE_FUNC 722
#define LOWLIGHT 723
#define LOW_COLOR 724
#define LOW_VALUE 725
#define MAGNETIC_TAPE 726
#define MANUAL 727
#define MASS_UPDATE 728
#define MASTER_INDEX 729
#define MAX_LINES 730
#define MAX_PROGRESS 731
#define MAX_TEXT 732
#define MAX_VAL 733
#define MEMORY 734
#define MEDIUM_FONT 735
#define MENU 736
#define MERGE 737
#define MESSAGE 738
#define MINUS 739
#define MIN_VAL 740
#define MNEMONIC_NAME 741
#define MODE 742
#define MODIFY 743
#define MODULES 744
#define MOVE 745
#define MULTILINE 746
#define MULTIPLE 747
#define MULTIPLY 748
#define NAME 749
#define NAMESPACE 750
#define NAMESPACE_PREFIX 751
#define NATIONAL 752
#define NATIONAL_EDITED 753
#define NATIONAL_OF_FUNC 754
#define NATIVE 755
#define NAVIGATE_URL 756
#define NEAREST_AWAY_FROM_ZERO 757
#define NEAREST_EVEN 758
#define NEAREST_TOWARD_ZERO 759
#define NEGATIVE 760
#define NESTED 761
#define NEW 762
#define NEXT 763
#define NEXT_ITEM 764
#define NEXT_GROUP 765
#define NEXT_PAGE 766
#define NO 767
#define NO_ADVANCING 768
#define NO_AUTOSEL 769
#define NO_AUTO_DEFAULT 770
#define NO_BOX 771
#define NO_DATA 772
#define NO_DIVIDERS 773
#define NO_ECHO 774
#define NO_F4 775
#define NO_FOCUS 776
#define NO_GROUP_TAB 777
#define NO_KEY_LETTER 778
#define NOMINAL 779
#define NO_SEARCH 780
#define NO_UPDOWN 781
#define NONNUMERIC 782
#define NORMAL 783
#define NOT 784
#define NOTAB 785
#define NOTHING 786
#define NOTIFY 787
#define NOTIFY_CHANGE 788
#define NOTIFY_DBLCLICK 789
#define NOTIFY_SELCHANGE 790
#define NOT_END 791
#define NOT_EOP 792
#define NOT_ESCAPE 793
#define NOT_EQUAL 794
#define NOT_EXCEPTION 795
#define NOT_INVALID_KEY 796
#define NOT_OVERFLOW 797
#define NOT_SIZE_ERROR 798
#define NUM_COL_HEADINGS 799
#define NUM_ROWS 800
#define NUMBER 801
#define NUMBERS 802
#define NUMERIC 803
#define NUMERIC_EDITED 804
#define NUMVALC_FUNC 805
#define OBJECT 806
#define OBJECT_COMPUTER 807
#define OCCURS 808
#define OF 809
#define OFF 810
#define OK_BUTTON 811
#define OMITTED 812
#define ON 813
#define ONLY 814
#define OPEN 815
#define OPTIONAL 816
#define OPTIONS 817
#define OR 818
#define ORDER 819
#define ORGANIZATION 820
#define OTHER 821
#define OTHERS 822
#define OUTPUT 823
#define OVERLAP_LEFT 824
#define OVERLAP_TOP 825
#define OVERLINE 826
#define PACKED_DECIMAL 827
#define PADDING 828
#define PASCAL 829
#define PAGE 830
#define PAGE_COUNTER 831
#define PAGE_SETUP 832
#define PAGED 833
#define PARAGRAPH 834
#define PARENT 835
#define PARSE 836
#define PASSWORD 837
#define PERFORM 838
#define PERMANENT 839
#define PH 840
#define PF 841
#define PHYSICAL 842
#define PICTURE 843
#define PICTURE_SYMBOL 844
#define PIXEL 845
#define PLACEMENT 846
#define PLUS 847
#define POINTER 848
#define POP_UP 849
#define POS 850
#define POSITION 851
#define POSITION_SHIFT 852
#define POSITIVE 853
#define PRESENT 854
#define PREVIOUS 855
#define PRINT 856
#define PRINT_CONTROL 857
#define PRINT_NO_PROMPT 858
#define PRINT_PREVIEW 859
#define PRINTER 860
#define PRINTER_1 861
#define PRINTING 862
#define PRIORITY 863
#define PROCEDURE 864
#define PROCEDURES 865
#define PROCEED 866
#define PROCESSING 867
#define PROGRAM 868
#define PROGRAM_ID 869
#define PROGRAM_NAME 870
#define PROGRAM_POINTER 871
#define PROGRESS 872
#define PROHIBITED 873
#define PROMPT 874
#define PROPERTIES 875
#define PROPERTY 876
#define PROTECTED 877
#define PURGE 878
#define PUSH_BUTTON 879
#define QUERY_INDEX 880
#define QUEUE 881
#define QUOTE 882
#define RADIO_BUTTON 883
#define RAISE 884
#define RAISED 885
#define RANDOM 886
#define RD 887
#define READ 888
#define READERS 889
#define READ_ONLY 890
#define READY_TRACE 891
#define RECEIVE 892
#define RECORD 893
#define RECORD_DATA 894
#define RECORD_OVERFLOW 895
#define RECORD_TO_ADD 896
#define RECORD_TO_DELETE 897
#define RECORDING 898
#define RECORDS 899
#define RECURSIVE 900
#define REDEFINES 901
#define REEL 902
#define REFERENCE 903
#define REFERENCES 904
#define REFRESH 905
#define REGION_COLOR 906
#define RELATIVE 907
#define RELEASE 908
#define REMAINDER 909
#define REMOVAL 910
#define RENAMES 911
#define REORG_CRITERIA 912
#define REPLACE 913
#define REPLACING 914
#define REPORT 915
#define REPORTING 916
#define REPORTS 917
#define REPOSITORY 918
#define REQUIRED 919
#define REREAD 920
#define RERUN 921
#define RESERVE 922
#define RESET 923
#define RESET_TRACE 924
#define RESET_GRID 925
#define RESET_LIST 926
#define RESET_TABS 927
#define RETRY 928
#define RETURN 929
#define RETURNING 930
#define REVERSE 931
#define REVERSE_FUNC 932
#define REVERSE_VIDEO 933
#define REVERSED 934
#define REWIND 935
#define REWRITE 936
#define RF 937
#define RH 938
#define RIGHT 939
#define RIGHT_ALIGN 940
#define RIMMED 941
#define ROLLBACK 942
#define ROUNDED 943
#define ROUNDING 944
#define ROW_COLOR 945
#define ROW_COLOR_PATTERN 946
#define ROW_DIVIDERS 947
#define ROW_FONT 948
#define ROW_HEADINGS 949
#define ROW_PROTECTION 950
#define RUN 951
#define S 952
#define SAME 953
#define SAVE_AS 954
#define SAVE_AS_NO_PROMPT 955
#define SCREEN 956
#define SCREEN_CONTROL 957
#define SCROLL 958
#define SCROLL_BAR 959
#define SD 960
#define SEARCH 961
#define SEARCH_OPTIONS 962
#define SEARCH_TEXT 963
#define SECONDS 964
#define SECTION 965
#define SECURE 966
#define SEGMENT 967
#define SEGMENT_LIMIT 968
#define SELECT 969
#define SELECTION_INDEX 970
#define SELECTION_TEXT 971
#define SELECT_ALL 972
#define SELF_ACT 973
#define SEMI_COLON 974
#define SEND 975
#define SENTENCE 976
#define SEPARATE 977
#define SEPARATION 978
#define SEQUENCE 979
#define SEQUENTIAL 980
#define SET 981
#define SEVENTY_EIGHT 982
#define SHADING 983
#define SHADOW 984
#define SHARING 985
#define SHORT_DATE 986
#define SHOW_LINES 987
#define SHOW_NONE 988
#define SHOW_SEL_ALWAYS 989
#define SIGN 990
#define SIGNED 991
#define SIGNED_INT 992
#define SIGNED_LONG 993
#define SIGNED_SHORT 994
#define SIXTY_SIX 995
#define SIZE 996
#define SIZE_ERROR 997
#define SMALL_FONT 998
#define SORT 999
#define SORT_MERGE 1000
#define SORT_ORDER 1001
#define SOURCE 1002
#define SOURCE_COMPUTER 1003
#define SPACE 1004
#define SPECIAL_NAMES 1005
#define SPINNER 1006
#define SQUARE 1007
#define STANDARD 1008
#define STANDARD_1 1009
#define STANDARD_2 1010
#define STANDARD_BINARY 1011
#define STANDARD_DECIMAL 1012
#define START 1013
#define START_X 1014
#define START_Y 1015
#define STATIC 1016
#define STATIC_LIST 1017
#define STATUS 1018
#define STATUS_BAR 1019
#define STATUS_TEXT 1020
#define STDCALL 1021
#define STEP 1022
#define STOP 1023
#define STRING 1024
#define STRONG 1025
#define STYLE 1026
#define SUB_QUEUE_1 1027
#define SUB_QUEUE_2 1028
#define SUB_QUEUE_3 1029
#define SUBSTITUTE_FUNC 1030
#define SUBSTITUTE_CASE_FUNC 1031
#define SUBTRACT 1032
#define SUBWINDOW 1033
#define SUM 1034
#define SUPPRESS 1035
#define SUPPRESS_XML 1036
#define SYMBOLIC 1037
#define SYNCHRONIZED 1038
#define SYSTEM_DEFAULT 1039
#define SYSTEM_INFO 1040
#define SYSTEM_OFFSET 1041
#define TAB 1042
#define TAB_TO_ADD 1043
#define TAB_TO_DELETE 1044
#define TABLE 1045
#define TALLYING 1046
#define TEMPORARY 1047
#define TAPE 1048
#define TERMINAL 1049
#define TERMINATE 1050
#define TERMINAL_INFO 1051
#define TERMINATION_VALUE 1052
#define TEST 1053
#define TEXT 1054
#define THAN 1055
#define THEN 1056
#define THREAD 1057
#define THREADS 1058
#define THRU 1059
#define THUMB_POSITION 1060
#define TILED_HEADINGS 1061
#define TIME 1062
#define TIME_OUT 1063
#define TIMES 1064
#define TITLE 1065
#define TITLE_POSITION 1066
#define TO 1067
#define TOK_AMPER 1068
#define TOK_CLOSE_PAREN 1069
#define TOK_COLON 1070
#define TOK_DIV 1071
#define TOK_DOT 1072
#define TOK_EQUAL 1073
#define TOK_EXTERN 1074
#define TOK_FALSE 1075
#define TOK_FILE 1076
#define TOK_GREATER 1077
#define TOK_INITIAL 1078
#define TOK_LESS 1079
#define TOK_MINUS 1080
#define TOK_MUL 1081
#define TOK_NULL 1082
#define TOK_OVERFLOW 1083
#define TOK_OPEN_PAREN 1084
#define TOK_PLUS 1085
#define TOK_TRUE 1086
#define TOP 1087
#define TOWARD_GREATER 1088
#define TOWARD_LESSER 1089
#define TRACK 1090
#define TRACKS 1091
#define TRACK_AREA 1092
#define TRACK_LIMIT 1093
#define TRADITIONAL_FONT 1094
#define TRAILING 1095
#define TRAILING_SHIFT 1096
#define TRANSFORM 1097
#define TRANSPARENT 1098
#define TREE_VIEW 1099
#define TRIM_FUNC 1100
#define TRUNCATION 1101
#define TYPE 1102
#define TYPEDEF 1103
#define U 1104
#define UCS_4 1105
#define UNBOUNDED 1106
#define UNDERLINE 1107
#define UNFRAMED 1108
#define UNIT 1109
#define UNLOCK 1110
#define UNSIGNED 1111
#define UNSIGNED_INT 1112
#define UNSIGNED_LONG 1113
#define UNSIGNED_SHORT 1114
#define UNSORTED 1115
#define UNSTRING 1116
#define UNTIL 1117
#define UP 1118
#define UPDATE 1119
#define UPDATERS 1120
#define UPON 1121
#define UPON_ARGUMENT_NUMBER 1122
#define UPON_COMMAND_LINE 1123
#define UPON_ENVIRONMENT_NAME 1124
#define UPON_ENVIRONMENT_VALUE 1125
#define UPPER 1126
#define UPPER_CASE_FUNC 1127
#define USAGE 1128
#define USE 1129
#define USE_ALT 1130
#define USE_RETURN 1131
#define USE_TAB 1132
#define USER 1133
#define USER_DEFAULT 1134
#define USER_FUNCTION_NAME 1135
#define USING 1136
#define UTF_8 1137
#define UTF_16 1138
#define V 1139
#define VALIDATE 1140
#define VALIDATING 1141
#define VALUE 1142
#define VALUE_FORMAT 1143
#define VARIABLE 1144
#define VARIANT 1145
#define VARYING 1146
#define VERTICAL 1147
#define VERY_HEAVY 1148
#define VIRTUAL_WIDTH 1149
#define VOLATILE 1150
#define VPADDING 1151
#define VSCROLL 1152
#define VSCROLL_BAR 1153
#define VSCROLL_POS 1154
#define VTOP 1155
#define WAIT 1156
#define WEB_BROWSER 1157
#define WHEN 1158
#define WHEN_COMPILED_FUNC 1159
#define WHEN_XML 1160
#define WIDTH 1161
#define WIDTH_IN_CELLS 1162
#define WINDOW 1163
#define WITH 1164
#define WORD 1165
#define WORDS 1166
#define WORKING_STORAGE 1167
#define WRAP 1168
#define WRITE 1169
#define WRITE_ONLY 1170
#define WRITE_VERIFY 1171
#define WRITERS 1172
#define X 1173
#define XML 1174
#define XML_DECLARATION 1175
#define Y 1176
#define YYYYDDD 1177
#define YYYYMMDD 1178
#define ZERO 1179
#define SHIFT_PREFER 1180

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef int YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif


extern YYSTYPE yylval;

int yyparse (void);

#endif /* !YY_YY_PARSER_H_INCLUDED  */



#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif

#ifndef YY_ATTRIBUTE
# if (defined __GNUC__                                               \
      && (2 < __GNUC__ || (__GNUC__ == 2 && 96 <= __GNUC_MINOR__)))  \
     || defined __SUNPRO_C && 0x5110 <= __SUNPRO_C
#  define YY_ATTRIBUTE(Spec) __attribute__(Spec)
# else
#  define YY_ATTRIBUTE(Spec) /* empty */
# endif
#endif

#ifndef YY_ATTRIBUTE_PURE
# define YY_ATTRIBUTE_PURE   YY_ATTRIBUTE ((__pure__))
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# define YY_ATTRIBUTE_UNUSED YY_ATTRIBUTE ((__unused__))
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

#if defined __GNUC__ && ! defined __ICC && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN \
    _Pragma ("GCC diagnostic push") \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")\
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif


#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYSIZE_T yynewbytes;                                            \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / sizeof (*yyptr);                          \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, (Count) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYSIZE_T yyi;                         \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   18002

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  926
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  1307
/* YYNRULES -- Number of rules.  */
#define YYNRULES  3166
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  4485

#define YYUNDEFTOK  2
#define YYMAXUTOK   1180

/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                                \
  ((unsigned) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_uint16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     805,   806,   807,   808,   809,   810,   811,   812,   813,   814,
     815,   816,   817,   818,   819,   820,   821,   822,   823,   824,
     825,   826,   827,   828,   829,   830,   831,   832,   833,   834,
     835,   836,   837,   838,   839,   840,   841,   842,   843,   844,
     845,   846,   847,   848,   849,   850,   851,   852,   853,   854,
     855,   856,   857,   858,   859,   860,   861,   862,   863,   864,
     865,   866,   867,   868,   869,   870,   871,   872,   873,   874,
     875,   876,   877,   878,   879,   880,   881,   882,   883,   884,
     885,   886,   887,   888,   889,   890,   891,   892,   893,   894,
     895,   896,   897,   898,   899,   900,   901,   902,   903,   904,
     905,   906,   907,   908,   909,   910,   911,   912,   913,   914,
     915,   916,   917,   918,   919,   920,   921,   922,   923,   924,
     925
};

#if YYDEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  3306,  3306,  3306,  3340,  3341,  3345,  3345,  3354,  3355,
    3359,  3360,  3364,  3364,  3376,  3387,  3395,  3399,  3403,  3404,
    3409,  3408,  3421,  3420,  3435,  3439,  3433,  3451,  3452,  3456,
    3465,  3465,  3470,  3474,  3469,  3490,  3489,  3505,  3516,  3523,
    3524,  3531,  3532,  3535,  3536,  3540,  3549,  3558,  3559,  3566,
    3567,  3571,  3575,  3581,  3583,  3591,  3598,  3600,  3604,  3611,
    3615,  3619,  3635,  3638,  3648,  3650,  3657,  3661,  3665,  3671,
    3673,  3680,  3684,  3688,  3692,  3701,  3706,  3707,  3716,  3720,
    3721,  3731,  3733,  3737,  3738,  3742,  3743,  3744,  3745,  3746,
    3753,  3752,  3763,  3764,  3767,  3768,  3781,  3780,  3794,  3795,
    3796,  3797,  3801,  3802,  3806,  3807,  3808,  3809,  3813,  3821,
    3830,  3829,  3837,  3841,  3847,  3851,  3856,  3863,  3873,  3887,
    3898,  3902,  3906,  3910,  3917,  3918,  3925,  3924,  3937,  3939,
    3940,  3947,  3948,  3952,  3956,  3962,  3963,  3970,  3977,  3982,
    3993,  4007,  4010,  4011,  4014,  4018,  4019,  4020,  4021,  4022,
    4023,  4024,  4025,  4026,  4027,  4028,  4029,  4030,  4031,  4039,
    4038,  4057,  4068,  4089,  4097,  4100,  4101,  4105,  4112,  4127,
    4148,  4147,  4172,  4171,  4180,  4179,  4189,  4191,  4195,  4199,
    4200,  4206,  4212,  4218,  4227,  4228,  4235,  4242,  4252,  4258,
    4266,  4276,  4280,  4287,  4291,  4296,  4295,  4306,  4310,  4317,
    4318,  4319,  4320,  4321,  4322,  4326,  4327,  4334,  4349,  4352,
    4359,  4367,  4371,  4382,  4402,  4410,  4421,  4422,  4429,  4443,
    4444,  4448,  4469,  4490,  4491,  4495,  4499,  4517,  4519,  4523,
    4530,  4532,  4542,  4563,  4630,  4633,  4642,  4661,  4677,  4695,
    4713,  4730,  4748,  4747,  4775,  4781,  4782,  4791,  4792,  4800,
    4801,  4806,  4805,  4845,  4846,  4852,  4853,  4862,  4863,  4864,
    4865,  4866,  4867,  4868,  4869,  4870,  4871,  4872,  4873,  4874,
    4875,  4876,  4877,  4878,  4879,  4880,  4906,  4916,  4926,  4937,
    4948,  4979,  4982,  4986,  4990,  4994,  4999,  5003,  5011,  5015,
    5019,  5027,  5028,  5029,  5030,  5034,  5035,  5036,  5037,  5038,
    5039,  5040,  5044,  5052,  5056,  5064,  5068,  5075,  5076,  5082,
    5089,  5090,  5091,  5098,  5153,  5156,  5161,  5160,  5186,  5189,
    5193,  5203,  5214,  5213,  5221,  5225,  5231,  5235,  5240,  5247,
    5257,  5268,  5283,  5300,  5302,  5303,  5309,  5309,  5316,  5320,
    5324,  5331,  5332,  5333,  5337,  5343,  5344,  5348,  5354,  5355,
    5371,  5372,  5376,  5382,  5388,  5394,  5407,  5418,  5417,  5426,
    5436,  5449,  5461,  5476,  5515,  5518,  5525,  5526,  5530,  5530,
    5534,  5539,  5557,  5568,  5575,  5576,  5582,  5595,  5596,  5597,
    5603,  5611,  5612,  5618,  5628,  5638,  5648,  5658,  5659,  5666,
    5674,  5675,  5676,  5683,  5684,  5688,  5689,  5690,  5691,  5697,
    5725,  5726,  5727,  5728,  5734,  5739,  5743,  5747,  5748,  5755,
    5756,  5757,  5758,  5759,  5760,  5761,  5762,  5769,  5768,  5784,
    5785,  5789,  5792,  5793,  5799,  5803,  5807,  5808,  5817,  5814,
    5828,  5829,  5833,  5841,  5842,  5850,  5851,  5855,  5875,  5874,
    5897,  5904,  5908,  5914,  5915,  5919,  5929,  5944,  5945,  5946,
    5947,  5948,  5949,  5950,  5951,  5952,  5959,  5966,  5966,  5966,
    5972,  5981,  5990,  6000,  6001,  6008,  6009,  6013,  6014,  6021,
    6032,  6037,  6048,  6049,  6053,  6054,  6060,  6071,  6089,  6090,
    6094,  6095,  6096,  6100,  6107,  6114,  6123,  6132,  6133,  6134,
    6135,  6136,  6145,  6146,  6152,  6189,  6190,  6200,  6215,  6216,
    6220,  6234,  6252,  6254,  6253,  6271,  6272,  6276,  6293,  6292,
    6313,  6314,  6318,  6319,  6320,  6323,  6325,  6326,  6330,  6331,
    6335,  6336,  6337,  6338,  6339,  6340,  6341,  6342,  6343,  6344,
    6345,  6349,  6353,  6355,  6359,  6360,  6364,  6365,  6366,  6367,
    6368,  6369,  6370,  6373,  6375,  6376,  6380,  6381,  6385,  6386,
    6387,  6388,  6389,  6390,  6394,  6399,  6401,  6400,  6416,  6420,
    6420,  6433,  6434,  6438,  6439,  6440,  6442,  6441,  6461,  6478,
    6484,  6486,  6490,  6497,  6501,  6512,  6515,  6527,  6528,  6530,
    6534,  6538,  6544,  6548,  6552,  6556,  6560,  6564,  6568,  6576,
    6580,  6584,  6588,  6592,  6596,  6607,  6608,  6612,  6613,  6617,
    6618,  6619,  6623,  6624,  6628,  6672,  6675,  6683,  6682,  6695,
    6723,  6722,  6737,  6741,  6748,  6754,  6758,  6765,  6766,  6770,
    6771,  6772,  6773,  6774,  6775,  6776,  6777,  6778,  6779,  6782,
    6784,  6788,  6792,  6796,  6797,  6798,  6799,  6800,  6801,  6802,
    6803,  6804,  6805,  6806,  6807,  6808,  6809,  6810,  6811,  6812,
    6813,  6814,  6815,  6816,  6823,  6844,  6858,  6859,  6862,  6871,
    6889,  6913,  6914,  6924,  6952,  6955,  6963,  6964,  6968,  6993,
    6992,  7004,  7012,  7029,  7041,  7058,  7075,  7096,  7097,  7104,
    7106,  7114,  7129,  7140,  7141,  7142,  7173,  7180,  7184,  7189,
    7193,  7198,  7207,  7211,  7215,  7219,  7223,  7227,  7231,  7235,
    7239,  7243,  7247,  7251,  7256,  7261,  7265,  7269,  7273,  7278,
    7282,  7287,  7291,  7296,  7301,  7306,  7310,  7314,  7322,  7326,
    7330,  7338,  7342,  7346,  7350,  7354,  7358,  7362,  7366,  7370,
    7378,  7386,  7390,  7394,  7398,  7402,  7406,  7414,  7415,  7418,
    7420,  7421,  7422,  7423,  7424,  7425,  7428,  7430,  7436,  7443,
    7456,  7465,  7466,  7475,  7482,  7494,  7512,  7513,  7517,  7518,
    7522,  7523,  7526,  7527,  7532,  7533,  7540,  7541,  7547,  7549,
    7551,  7550,  7559,  7560,  7564,  7586,  7587,  7591,  7616,  7617,
    7620,  7622,  7625,  7632,  7633,  7638,  7649,  7660,  7669,  7671,
    7672,  7682,  7693,  7720,  7719,  7728,  7729,  7733,  7734,  7737,
    7739,  7751,  7760,  7775,  7798,  7817,  7819,  7818,  7838,  7840,
    7839,  7855,  7857,  7856,  7867,  7868,  7875,  7874,  7900,  7901,
    7902,  7909,  7915,  7920,  7921,  7927,  7934,  7935,  7936,  7940,
    7947,  7948,  7952,  7962,  8001,  8012,  8013,  8027,  8040,  8041,
    8044,  8045,  8050,  8051,  8052,  8053,  8054,  8055,  8067,  8081,
    8095,  8109,  8123,  8136,  8137,  8142,  8141,  8151,  8163,  8164,
    8168,  8169,  8170,  8171,  8172,  8173,  8174,  8175,  8176,  8177,
    8178,  8179,  8180,  8181,  8182,  8183,  8184,  8188,  8195,  8199,
    8203,  8204,  8205,  8212,  8216,  8224,  8227,  8235,  8245,  8246,
    8251,  8254,  8259,  8263,  8271,  8278,  8287,  8292,  8299,  8300,
    8301,  8305,  8313,  8314,  8315,  8322,  8326,  8333,  8338,  8344,
    8351,  8357,  8367,  8371,  8378,  8380,  8384,  8388,  8392,  8396,
    8403,  8411,  8412,  8415,  8417,  8421,  8425,  8439,  8454,  8457,
    8459,  8463,  8467,  8471,  8478,  8499,  8503,  8504,  8508,  8529,
    8537,  8546,  8548,  8547,  8566,  8567,  8571,  8572,  8576,  8579,
    8578,  8629,  8641,  8628,  8685,  8705,  8707,  8711,  8716,  8721,
    8725,  8729,  8734,  8739,  8744,  8749,  8758,  8762,  8766,  8770,
    8774,  8780,  8784,  8789,  8795,  8799,  8804,  8809,  8814,  8819,
    8824,  8829,  8838,  8842,  8846,  8851,  8855,  8859,  8863,  8867,
    8871,  8875,  8879,  8890,  8895,  8900,  8904,  8905,  8906,  8907,
    8908,  8909,  8910,  8911,  8920,  8925,  8936,  8937,  8944,  8945,
    8946,  8947,  8948,  8949,  8950,  8951,  8952,  8955,  8958,  8959,
    8960,  8961,  8962,  8963,  8970,  8971,  8976,  8977,  8980,  8982,
    8986,  8987,  8991,  8992,  8996,  8997,  9001,  9002,  9006,  9007,
    9008,  9009,  9010,  9013,  9014,  9015,  9016,  9017,  9019,  9020,
    9022,  9023,  9027,  9028,  9029,  9030,  9032,  9034,  9036,  9037,
    9038,  9039,  9040,  9041,  9042,  9043,  9044,  9050,  9051,  9052,
    9053,  9054,  9055,  9056,  9057,  9058,  9059,  9063,  9064,  9069,
    9070,  9071,  9072,  9073,  9077,  9085,  9086,  9087,  9088,  9089,
    9090,  9091,  9092,  9093,  9094,  9095,  9097,  9099,  9100,  9101,
    9105,  9106,  9107,  9108,  9109,  9110,  9111,  9112,  9113,  9114,
    9119,  9120,  9121,  9122,  9123,  9124,  9125,  9126,  9127,  9128,
    9133,  9134,  9145,  9146,  9170,  9171,  9188,  9191,  9192,  9193,
    9196,  9200,  9201,  9202,  9203,  9204,  9205,  9206,  9207,  9208,
    9209,  9210,  9211,  9212,  9213,  9214,  9215,  9221,  9222,  9223,
    9243,  9244,  9245,  9246,  9247,  9248,  9249,  9250,  9254,  9255,
    9256,  9257,  9258,  9259,  9265,  9266,  9267,  9268,  9269,  9270,
    9271,  9272,  9277,  9279,  9280,  9281,  9286,  9287,  9288,  9292,
    9293,  9294,  9295,  9296,  9297,  9308,  9309,  9310,  9311,  9316,
    9319,  9320,  9321,  9322,  9323,  9325,  9330,  9331,  9332,  9338,
    9339,  9340,  9341,  9342,  9343,  9344,  9345,  9346,  9347,  9351,
    9352,  9353,  9354,  9355,  9356,  9357,  9358,  9359,  9360,  9361,
    9362,  9363,  9364,  9366,  9367,  9368,  9369,  9370,  9371,  9372,
    9373,  9374,  9375,  9376,  9377,  9378,  9379,  9380,  9381,  9382,
    9385,  9386,  9387,  9395,  9396,  9397,  9401,  9402,  9403,  9407,
    9408,  9411,  9412,  9413,  9416,  9425,  9426,  9427,  9428,  9429,
    9430,  9431,  9432,  9433,  9434,  9435,  9436,  9437,  9439,  9440,
    9441,  9442,  9443,  9444,  9445,  9446,  9447,  9448,  9455,  9459,
    9463,  9464,  9465,  9466,  9467,  9468,  9469,  9470,  9476,  9477,
    9478,  9483,  9484,  9489,  9494,  9495,  9499,  9500,  9505,  9506,
    9510,  9511,  9512,  9517,  9518,  9522,  9523,  9527,  9528,  9532,
    9536,  9536,  9540,  9544,  9544,  9548,  9552,  9553,  9557,  9558,
    9562,  9570,  9572,  9576,  9583,  9593,  9596,  9600,  9607,  9619,
    9629,  9638,  9643,  9653,  9675,  9642,  9703,  9703,  9737,  9741,
    9740,  9754,  9753,  9773,  9774,  9779,  9801,  9803,  9807,  9818,
    9820,  9828,  9836,  9844,  9850,  9854,  9890,  9892,  9900,  9903,
    9916,  9921,  9931,  9966,  9968,  9967, 10004, 10005, 10009, 10010,
   10011, 10029, 10030, 10042, 10041, 10087, 10088, 10092, 10137, 10157,
   10160, 10189, 10194, 10188, 10207, 10207, 10247, 10255, 10256, 10257,
   10258, 10259, 10260, 10261, 10262, 10263, 10264, 10265, 10266, 10267,
   10268, 10269, 10270, 10271, 10272, 10273, 10274, 10275, 10276, 10277,
   10278, 10279, 10280, 10281, 10282, 10284, 10285, 10286, 10287, 10288,
   10289, 10290, 10291, 10292, 10293, 10294, 10295, 10296, 10297, 10298,
   10300, 10301, 10302, 10303, 10304, 10305, 10306, 10307, 10308, 10309,
   10310, 10311, 10312, 10313, 10314, 10315, 10316, 10317, 10318, 10319,
   10320, 10335, 10347, 10346, 10357, 10356, 10391, 10390, 10401, 10405,
   10409, 10415, 10421, 10426, 10431, 10436, 10441, 10447, 10453, 10457,
   10463, 10467, 10472, 10476, 10480, 10484, 10488, 10492, 10496, 10500,
   10514, 10521, 10522, 10529, 10529, 10541, 10545, 10549, 10556, 10560,
   10564, 10571, 10572, 10576, 10578, 10582, 10583, 10587, 10588, 10592,
   10596, 10597, 10606, 10607, 10612, 10613, 10617, 10618, 10622, 10638,
   10654, 10667, 10675, 10683, 10690, 10696, 10702, 10707, 10713, 10718,
   10723, 10736, 10741, 10746, 10752, 10758, 10764, 10771, 10775, 10779,
   10783, 10787, 10798, 10803, 10808, 10813, 10818, 10823, 10829, 10835,
   10840, 10846, 10852, 10858, 10865, 10870, 10875, 10882, 10889, 10895,
   10898, 10898, 10902, 10913, 10914, 10915, 10919, 10920, 10921, 10925,
   10926, 10930, 10934, 10953, 10952, 10961, 10965, 10972, 10976, 10984,
   10985, 10989, 10993, 11004, 11003, 11013, 11017, 11028, 11030, 11043,
   11044, 11052, 11051, 11060, 11061, 11065, 11071, 11071, 11078, 11077,
   11094, 11093, 11162, 11166, 11165, 11181, 11185, 11189, 11197, 11200,
   11208, 11216, 11220, 11224, 11228, 11232, 11251, 11257, 11277, 11281,
   11291, 11295, 11300, 11304, 11303, 11320, 11321, 11326, 11334, 11368,
   11370, 11374, 11383, 11396, 11399, 11403, 11407, 11412, 11435, 11436,
   11440, 11441, 11445, 11449, 11453, 11464, 11468, 11475, 11479, 11487,
   11491, 11498, 11505, 11509, 11520, 11519, 11531, 11535, 11542, 11543,
   11553, 11552, 11560, 11561, 11565, 11570, 11578, 11579, 11580, 11581,
   11582, 11587, 11586, 11598, 11599, 11607, 11606, 11615, 11622, 11626,
   11636, 11648, 11647, 11668, 11669, 11669, 11684, 11683, 11692, 11699,
   11710, 11709, 11718, 11722, 11726, 11731, 11739, 11743, 11754, 11753,
   11762, 11765, 11767, 11773, 11775, 11776, 11777, 11778, 11786, 11785,
   11797, 11801, 11805, 11809, 11813, 11814, 11815, 11816, 11817, 11818,
   11819, 11823, 11831, 11840, 11841, 11846, 11845, 11889, 11893, 11899,
   11901, 11905, 11906, 11910, 11911, 11915, 11919, 11924, 11928, 11929,
   11933, 11937, 11941, 11945, 11952, 11953, 11958, 11957, 11974, 11981,
   11981, 11993, 11997, 12005, 12006, 12007, 12018, 12017, 12035, 12037,
   12041, 12042, 12046, 12050, 12051, 12052, 12053, 12058, 12063, 12057,
   12077, 12078, 12083, 12088, 12082, 12107, 12106, 12128, 12129, 12130,
   12134, 12135, 12140, 12143, 12150, 12163, 12175, 12182, 12183, 12189,
   12190, 12194, 12195, 12196, 12197, 12198, 12199, 12203, 12206, 12210,
   12211, 12212, 12216, 12217, 12218, 12219, 12223, 12224, 12229, 12230,
   12234, 12244, 12260, 12265, 12271, 12277, 12282, 12287, 12293, 12299,
   12305, 12311, 12318, 12322, 12326, 12330, 12334, 12339, 12344, 12349,
   12354, 12360, 12365, 12370, 12377, 12387, 12391, 12402, 12401, 12410,
   12414, 12418, 12422, 12426, 12433, 12437, 12448, 12447, 12459, 12458,
   12466, 12465, 12475, 12499, 12512, 12511, 12538, 12546, 12547, 12552,
   12563, 12574, 12588, 12596, 12604, 12605, 12610, 12616, 12626, 12638,
   12644, 12654, 12667, 12666, 12678, 12676, 12690, 12691, 12696, 12771,
   12772, 12773, 12774, 12778, 12779, 12783, 12787, 12798, 12797, 12809,
   12813, 12838, 12852, 12875, 12898, 12919, 12943, 12946, 12954, 12953,
   12962, 12973, 12972, 12981, 12994, 12993, 13006, 13011, 13022, 13026,
   13037, 13057, 13056, 13065, 13069, 13075, 13082, 13085, 13092, 13098,
   13104, 13109, 13121, 13120, 13128, 13136, 13137, 13141, 13142, 13143,
   13148, 13151, 13158, 13162, 13170, 13177, 13178, 13179, 13180, 13181,
   13182, 13183, 13195, 13198, 13208, 13207, 13215, 13222, 13235, 13234,
   13246, 13247, 13254, 13253, 13262, 13266, 13267, 13268, 13272, 13273,
   13274, 13275, 13282, 13281, 13302, 13312, 13320, 13324, 13331, 13336,
   13341, 13346, 13351, 13356, 13364, 13365, 13369, 13374, 13380, 13382,
   13383, 13384, 13385, 13389, 13417, 13420, 13424, 13428, 13432, 13439,
   13446, 13456, 13455, 13468, 13473, 13466, 13485, 13488, 13495, 13496,
   13500, 13508, 13512, 13522, 13521, 13531, 13538, 13540, 13547, 13546,
   13559, 13558, 13571, 13572, 13576, 13580, 13591, 13590, 13598, 13602,
   13613, 13612, 13621, 13625, 13632, 13636, 13647, 13646, 13655, 13656,
   13660, 13688, 13689, 13693, 13694, 13695, 13696, 13700, 13701, 13705,
   13706, 13707, 13711, 13712, 13720, 13721, 13725, 13726, 13732, 13741,
   13742, 13743, 13748, 13749, 13750, 13754, 13761, 13777, 13778, 13779,
   13785, 13784, 13796, 13808, 13805, 13822, 13819, 13835, 13843, 13850,
   13854, 13867, 13874, 13886, 13889, 13894, 13898, 13911, 13918, 13919,
   13923, 13924, 13927, 13928, 13933, 13976, 13980, 13990, 13989, 14002,
   14001, 14009, 14014, 14024, 14039, 14038, 14048, 14077, 14078, 14082,
   14086, 14090, 14094, 14101, 14102, 14106, 14110, 14113, 14115, 14119,
   14128, 14129, 14130, 14133, 14135, 14139, 14143, 14147, 14155, 14156,
   14160, 14161, 14165, 14169, 14179, 14190, 14189, 14198, 14203, 14204,
   14208, 14209, 14210, 14214, 14215, 14219, 14223, 14224, 14228, 14232,
   14236, 14246, 14245, 14253, 14263, 14274, 14273, 14282, 14289, 14293,
   14304, 14303, 14315, 14324, 14327, 14331, 14335, 14342, 14346, 14356,
   14368, 14367, 14376, 14380, 14389, 14390, 14395, 14398, 14406, 14410,
   14417, 14425, 14429, 14440, 14439, 14447, 14450, 14455, 14457, 14461,
   14467, 14468, 14469, 14470, 14473, 14475, 14482, 14481, 14495, 14496,
   14497, 14498, 14499, 14500, 14501, 14502, 14506, 14507, 14511, 14512,
   14518, 14527, 14534, 14535, 14539, 14543, 14547, 14553, 14559, 14563,
   14567, 14571, 14580, 14584, 14588, 14597, 14606, 14607, 14611, 14620,
   14621, 14625, 14629, 14638, 14647, 14659, 14658, 14667, 14666, 14718,
   14719, 14736, 14737, 14740, 14741, 14750, 14753, 14758, 14763, 14773,
   14790, 14795, 14805, 14823, 14822, 14832, 14845, 14848, 14856, 14859,
   14864, 14869, 14877, 14878, 14879, 14880, 14881, 14882, 14886, 14894,
   14895, 14899, 14903, 14914, 14913, 14924, 14932, 14943, 14950, 14954,
   14958, 14966, 14978, 14981, 14988, 14992, 14999, 15000, 15001, 15002,
   15009, 15008, 15017, 15024, 15024, 15034, 15035, 15039, 15053, 15054,
   15059, 15060, 15064, 15065, 15069, 15073, 15084, 15083, 15092, 15096,
   15100, 15104, 15112, 15116, 15126, 15137, 15138, 15145, 15144, 15152,
   15159, 15172, 15171, 15179, 15193, 15192, 15200, 15217, 15216, 15226,
   15234, 15235, 15240, 15241, 15246, 15253, 15254, 15259, 15266, 15267,
   15271, 15272, 15276, 15280, 15290, 15289, 15304, 15309, 15321, 15320,
   15329, 15330, 15331, 15332, 15333, 15337, 15365, 15368, 15380, 15390,
   15395, 15400, 15405, 15413, 15453, 15454, 15458, 15518, 15528, 15551,
   15552, 15553, 15554, 15558, 15567, 15574, 15585, 15618, 15619, 15623,
   15629, 15645, 15646, 15653, 15652, 15664, 15674, 15675, 15680, 15683,
   15687, 15691, 15698, 15699, 15703, 15704, 15705, 15709, 15713, 15723,
   15722, 15735, 15746, 15733, 15757, 15759, 15763, 15764, 15768, 15772,
   15784, 15793, 15803, 15806, 15816, 15819, 15827, 15830, 15839, 15843,
   15850, 15858, 15861, 15870, 15874, 15881, 15889, 15892, 15896, 15897,
   15898, 15901, 15903, 15911, 15912, 15916, 15921, 15926, 15933, 15938,
   15943, 15951, 15955, 15962, 15966, 15977, 15976, 15993, 15988, 15999,
   16001, 16004, 16006, 16009, 16011, 16015, 16016, 16032, 16033, 16034,
   16044, 16048, 16055, 16063, 16064, 16068, 16069, 16073, 16081, 16082,
   16087, 16088, 16089, 16099, 16103, 16110, 16118, 16119, 16123, 16131,
   16132, 16133, 16143, 16147, 16154, 16162, 16163, 16167, 16175, 16176,
   16177, 16187, 16191, 16198, 16206, 16207, 16211, 16221, 16222, 16223,
   16233, 16237, 16244, 16252, 16253, 16257, 16267, 16268, 16269, 16279,
   16283, 16290, 16298, 16299, 16303, 16314, 16315, 16322, 16324, 16333,
   16337, 16344, 16352, 16353, 16357, 16367, 16368, 16378, 16382, 16389,
   16397, 16398, 16402, 16412, 16413, 16417, 16418, 16428, 16432, 16439,
   16447, 16448, 16452, 16463, 16466, 16475, 16478, 16486, 16490, 16499,
   16503, 16510, 16511, 16517, 16522, 16530, 16537, 16537, 16548, 16549,
   16553, 16554, 16556, 16558, 16560, 16561, 16563, 16564, 16565, 16566,
   16567, 16569, 16570, 16571, 16574, 16576, 16580, 16583, 16585, 16586,
   16587, 16588, 16589, 16590, 16592, 16593, 16594, 16595, 16596, 16599,
   16600, 16604, 16605, 16609, 16610, 16614, 16615, 16619, 16623, 16629,
   16633, 16639, 16641, 16642, 16646, 16647, 16648, 16652, 16653, 16654,
   16658, 16662, 16666, 16667, 16668, 16671, 16672, 16682, 16694, 16703,
   16719, 16728, 16744, 16759, 16760, 16765, 16774, 16780, 16790, 16804,
   16826, 16830, 16851, 16855, 16876, 16888, 16902, 16916, 16917, 16922,
   16928, 16929, 16934, 16943, 16945, 16950, 16964, 16965, 16966, 16973,
   16984, 16985, 16989, 16997, 16998, 17002, 17003, 17007, 17019, 17023,
   17030, 17039, 17040, 17046, 17055, 17066, 17083, 17087, 17094, 17095,
   17096, 17103, 17104, 17108, 17112, 17119, 17120, 17124, 17125, 17129,
   17130, 17131, 17132, 17136, 17140, 17144, 17148, 17152, 17156, 17160,
   17181, 17191, 17195, 17202, 17203, 17204, 17208, 17209, 17210, 17211,
   17212, 17216, 17220, 17227, 17228, 17229, 17230, 17234, 17238, 17245,
   17257, 17269, 17283, 17284, 17288, 17289, 17293, 17300, 17307, 17308,
   17315, 17316, 17323, 17324, 17325, 17329, 17330, 17334, 17338, 17342,
   17346, 17347, 17351, 17355, 17356, 17360, 17364, 17365, 17374, 17378,
   17383, 17384, 17390, 17394, 17398, 17402, 17403, 17409, 17413, 17417,
   17418, 17422, 17429, 17439, 17458, 17479, 17498, 17516, 17523, 17530,
   17537, 17547, 17551, 17558, 17562, 17569, 17579, 17589, 17599, 17612,
   17638, 17642, 17650, 17650, 17663, 17668, 17676, 17684, 17688, 17698,
   17713, 17735, 17755, 17759, 17766, 17780, 17781, 17782, 17783, 17784,
   17785, 17789, 17793, 17810, 17814, 17821, 17822, 17823, 17824, 17825,
   17826, 17827, 17831, 17832, 17833, 17834, 17840, 17844, 17848, 17852,
   17856, 17860, 17865, 17869, 17873, 17877, 17881, 17885, 17889, 17893,
   17900, 17901, 17905, 17906, 17907, 17908, 17912, 17913, 17914, 17915,
   17916, 17920, 17924, 17928, 17935, 17939, 17943, 17950, 17957, 17964,
   17974, 17974, 17990, 17997, 18007, 18014, 18024, 18028, 18041, 18045,
   18060, 18068, 18069, 18073, 18074, 18075, 18079, 18080, 18085, 18088,
   18096, 18099, 18106, 18108, 18109, 18113, 18114, 18118, 18119, 18120,
   18125, 18128, 18141, 18145, 18153, 18157, 18161, 18165, 18169, 18173,
   18177, 18181, 18188, 18189, 18193, 18194, 18204, 18205, 18214, 18218,
   18222, 18226, 18233, 18234, 18235, 18236, 18237, 18238, 18239, 18240,
   18241, 18242, 18243, 18244, 18245, 18246, 18247, 18248, 18249, 18250,
   18251, 18252, 18253, 18254, 18255, 18256, 18257, 18258, 18259, 18260,
   18261, 18262, 18263, 18264, 18265, 18266, 18267, 18268, 18269, 18270,
   18271, 18272, 18273, 18274, 18275, 18276, 18277, 18278, 18279, 18280,
   18281, 18282, 18283, 18287, 18288, 18289, 18290, 18291, 18292, 18293,
   18294, 18295, 18296, 18297, 18298, 18299, 18300, 18301, 18302, 18303,
   18304, 18305, 18306, 18307, 18308, 18309, 18316, 18316, 18317, 18317,
   18318, 18318, 18319, 18319, 18320, 18320, 18320, 18321, 18321, 18322,
   18322, 18323, 18323, 18324, 18324, 18325, 18325, 18326, 18326, 18327,
   18327, 18328, 18328, 18329, 18329, 18330, 18330, 18331, 18331, 18332,
   18332, 18333, 18333, 18334, 18334, 18335, 18335, 18336, 18336, 18337,
   18337, 18338, 18338, 18339, 18339, 18340, 18340, 18340, 18341, 18341,
   18341, 18342, 18342, 18343, 18343, 18344, 18344, 18345, 18345, 18346,
   18346, 18347, 18347, 18347, 18348, 18348, 18348, 18349, 18349, 18349,
   18349, 18350, 18350, 18350, 18351, 18351, 18352, 18352, 18353, 18353,
   18353, 18354, 18354, 18354, 18355, 18355, 18356, 18356, 18357, 18357,
   18358, 18358, 18359, 18359, 18360, 18360, 18361, 18361, 18362, 18362,
   18363, 18363, 18364, 18364, 18364, 18365, 18365, 18365, 18365, 18366,
   18366, 18367, 18367, 18368, 18368, 18369, 18369, 18370, 18370, 18371,
   18371, 18372, 18372, 18372, 18373, 18373, 18374, 18374, 18375, 18375,
   18376, 18376, 18376, 18377, 18377, 18378, 18378, 18379, 18379, 18380,
   18380, 18381, 18381, 18382, 18382, 18383, 18383, 18384, 18384, 18385,
   18385, 18386, 18386, 18387, 18387, 18388, 18388, 18389, 18389, 18390,
   18390, 18390, 18394, 18394, 18395, 18395, 18396, 18396, 18397, 18397,
   18397, 18397, 18398, 18398, 18399, 18399, 18400, 18400, 18401, 18401,
   18402, 18402, 18403, 18403, 18404, 18404, 18405, 18405, 18405, 18406,
   18406, 18407, 18407, 18408, 18408, 18409, 18409, 18410, 18410, 18411,
   18411, 18414, 18414, 18415, 18415, 18416, 18416, 18417, 18417, 18418,
   18418, 18419, 18419, 18420, 18420, 18421, 18421
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || 1
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "$undefined", "\"3D\"", "ABSENT", "ACCEPT",
  "ACCESS", "\"ACTIVE-X\"", "ACTION", "ACTUAL", "ADD", "ADDRESS",
  "\"ADJUSTABLE-COLUMNS\"", "ADVANCING", "AFTER", "ALIGNMENT", "ALL",
  "ALLOCATE", "ALLOWING", "ALPHABET", "ALPHABETIC", "\"ALPHABETIC-LOWER\"",
  "\"ALPHABETIC-UPPER\"", "ALPHANUMERIC", "\"ALPHANUMERIC-EDITED\"",
  "ALSO", "ALTER", "ALTERNATE", "AND", "ANY", "APPLY", "ARE", "AREA",
  "AREAS", "\"ARGUMENT-NUMBER\"", "\"ARGUMENT-VALUE\"", "ARITHMETIC", "AS",
  "ASCENDING", "ASCII", "ASSIGN", "AT", "ATTRIBUTE", "ATTRIBUTES", "AUTO",
  "\"AUTO-DECIMAL\"", "\"AUTO-SPIN\"", "AUTOMATIC", "\"AWAY-FROM-ZERO\"",
  "\"BACKGROUND-COLOR\"", "\"BACKGROUND-HIGH\"", "\"BACKGROUND-LOW\"",
  "\"BACKGROUND-STANDARD\"", "BAR", "BASED", "BEFORE", "BELL", "BINARY",
  "\"BINARY-C-LONG\"", "\"BINARY-CHAR\"", "\"BINARY-DOUBLE\"",
  "\"BINARY-LONG\"", "\"BINARY-SEQUENTIAL\"", "\"BINARY-SHORT\"", "BIT",
  "BITMAP", "\"BITMAP-END\"", "\"BITMAP-HANDLE\"", "\"BITMAP-NUMBER\"",
  "\"BITMAP-START\"", "\"BITMAP-TIMER\"", "\"BITMAP-TRAILING\"",
  "\"BITMAP-TRANSPARENT-COLOR\"", "\"BITMAP-WIDTH\"", "BLANK", "BLINK",
  "BLOCK", "BOTTOM", "BOX", "BOXED", "\"BULK-ADDITION\"", "BUSY",
  "BUTTONS", "BY", "\"BYTE-LENGTH\"", "C", "\"CALENDAR-FONT\"", "CALL",
  "CANCEL", "\"CANCEL-BUTTON\"", "CAPACITY", "\"CARD-PUNCH\"",
  "\"CARD-READER\"", "CASSETTE", "CCOL", "CD", "CELL", "\"CELL-COLOR\"",
  "\"CELL-DATA\"", "\"CELL-FONT\"", "\"CELL-PROTECTION\"", "CENTER",
  "CENTERED", "\"CENTERED-HEADINGS\"", "\"CENTURY-DATE\"", "CF", "CH",
  "CHAINING", "CHARACTER", "CHARACTERS", "\"CHECK-BOX\"", "CLASS",
  "CLASSIFICATION", "\"class-name\"", "\"CLEAR-SELECTION\"", "CLINE",
  "CLINES", "CLOSE", "COBOL", "CODE", "\"CODE-SET\"", "COLLATING", "COL",
  "COLOR", "COLORS", "COLS", "COLUMN", "\"COLUMN-COLOR\"",
  "\"COLUMN-DIVIDERS\"", "\"COLUMN-FONT\"", "\"COLUMN-HEADINGS\"",
  "\"COLUMN-PROTECTION\"", "COLUMNS", "\"COMBO-BOX\"", "COMMA",
  "\"COMMAND-LINE\"", "\"comma delimiter\"", "COMMIT", "COMMON",
  "COMMUNICATION", "COMP", "COMPUTE", "\"COMP-0\"", "\"COMP-1\"",
  "\"COMP-2\"", "\"COMP-3\"", "\"COMP-4\"", "\"COMP-5\"", "\"COMP-6\"",
  "\"COMP-N\"", "\"COMP-X\"", "\"FUNCTION CONCATENATE\"", "CONDITION",
  "CONFIGURATION", "CONSTANT", "CONTAINS", "CONTENT",
  "\"FUNCTION CONTENT-LENGTH\"", "\"FUNCTION CONTENT-OF\"", "CONTINUE",
  "CONTROL", "CONTROLS", "CONVERSION", "CONVERTING", "COPY",
  "\"COPY-SELECTION\"", "\"CORE-INDEX\"", "CORRESPONDING", "COUNT", "CRT",
  "\"CRT-UNDER\"", "CSIZE", "CURRENCY", "\"FUNCTION CURRENT-DATE\"",
  "CURSOR", "\"CURSOR-COL\"", "\"CURSOR-COLOR\"", "\"CURSOR-FRAME-WIDTH\"",
  "\"CURSOR-ROW\"", "\"CURSOR-X\"", "\"CURSOR-Y\"",
  "\"CUSTOM-PRINT-TEMPLATE\"", "CYCLE", "\"CYL-INDEX\"",
  "\"CYL-OVERFLOW\"", "DASHED", "DATA", "\"DATA-COLUMNS\"",
  "\"DATA-TYPES\"", "DATE", "\"DATE-ENTRY\"", "DAY", "\"DAY-OF-WEEK\"",
  "DE", "DEBUGGING", "\"DECIMAL-POINT\"", "DECLARATIVES", "DEFAULT",
  "\"DEFAULT-BUTTON\"", "\"DEFAULT-FONT\"", "DELETE", "DELIMITED",
  "DELIMITER", "DEPENDING", "DESCENDING", "DESTINATION", "DESTROY",
  "DETAIL", "DISABLE", "DISC", "DISK", "DISP", "DISPLAY",
  "\"DISPLAY-COLUMNS\"", "\"DISPLAY-FORMAT\"", "\"FUNCTION DISPLAY-OF\"",
  "DIVIDE", "DIVIDERS", "\"DIVIDER-COLOR\"", "DIVISION", "DOTDASH",
  "DOTTED", "\"DRAG-COLOR\"", "\"DROP-DOWN\"", "\"DROP-LIST\"", "DOWN",
  "DUPLICATES", "DYNAMIC", "EBCDIC", "EC", "ECHO", "EGI",
  "\"level-number 88\"", "ENABLE", "ELEMENT", "ELSE", "EMI", "ENCRYPTION",
  "ENCODING", "END", "\"END-ACCEPT\"", "\"END-ADD\"", "\"END-CALL\"",
  "\"END-COMPUTE\"", "\"END-COLOR\"", "\"END-DELETE\"", "\"END-DISPLAY\"",
  "\"END-DIVIDE\"", "\"END-EVALUATE\"", "\"END FUNCTION\"", "\"END-IF\"",
  "\"END-JSON\"", "\"END-MODIFY\"", "\"END-MULTIPLY\"", "\"END-PERFORM\"",
  "\"END PROGRAM\"", "\"END-READ\"", "\"END-RECEIVE\"", "\"END-RETURN\"",
  "\"END-REWRITE\"", "\"END-SEARCH\"", "\"END-START\"", "\"END-STRING\"",
  "\"END-SUBTRACT\"", "\"END-UNSTRING\"", "\"END-WRITE\"", "\"END-XML\"",
  "ENGRAVED", "\"ENSURE-VISIBLE\"", "ENTRY", "\"ENTRY-CONVENTION\"",
  "\"ENTRY-FIELD\"", "\"ENTRY-REASON\"", "ENVIRONMENT",
  "\"ENVIRONMENT-NAME\"", "\"ENVIRONMENT-VALUE\"", "EOL", "EOP", "EOS",
  "EQUAL", "ERASE", "ERROR", "ESCAPE", "\"ESCAPE-BUTTON\"", "ESI",
  "EVALUATE", "EVENT", "\"EVENT-LIST\"", "\"EVENT STATUS\"", "EVERY",
  "EXCEPTION", "\"EXCEPTION CONDITION\"", "\"EXCEPTION-VALUE\"", "EXPAND",
  "EXCLUSIVE", "EXIT", "\"exponentiation operator\"", "EXTEND",
  "\"EXTENDED-SEARCH\"", "EXTERNAL", "\"EXTERNAL-FORM\"", "F", "FD",
  "\"FH--FCD\"", "\"FH--KEYDEF\"", "\"FILE-CONTROL\"", "\"FILE-ID\"",
  "\"FILE-LIMIT\"", "\"FILE-LIMITS\"", "\"FILE-NAME\"", "\"FILE-POS\"",
  "\"FILL-COLOR\"", "\"FILL-COLOR2\"", "\"FILL-PERCENT\"", "FILLER",
  "FINAL", "\"FINISH-REASON\"", "FIRST", "FIXED", "\"FIXED-FONT\"",
  "\"FIXED-WIDTH\"", "FLAT", "\"FLAT-BUTTONS\"", "\"FLOAT-BINARY-128\"",
  "\"FLOAT-BINARY-32\"", "\"FLOAT-BINARY-64\"", "\"FLOAT-DECIMAL-16\"",
  "\"FLOAT-DECIMAL-34\"", "\"FLOAT-DECIMAL-7\"", "\"FLOAT-EXTENDED\"",
  "\"FLOAT-LONG\"", "\"FLOAT-SHORT\"", "FLOATING", "FONT", "FOOTING",
  "FOR", "\"FOREGROUND-COLOR\"", "FOREVER", "\"FUNCTION FORMATTED-DATE\"",
  "\"FUNCTION FORMATTED-DATETIME\"", "\"FUNCTION FORMATTED-TIME\"",
  "FRAME", "FRAMED", "FREE", "FROM", "\"FROM CRT\"", "FULL",
  "\"FULL-HEIGHT\"", "FUNCTION", "\"FUNCTION-ID\"",
  "\"intrinsic function name\"", "GENERATE", "GIVING", "GLOBAL", "GO",
  "\"GO-BACK\"", "\"GO-FORWARD\"", "\"GO-HOME\"", "\"GO-SEARCH\"",
  "GOBACK", "GRAPHICAL", "GREATER", "\"GREATER OR EQUAL\"", "GRID",
  "GROUP", "\"GROUP-VALUE\"", "HANDLE", "\"HAS-CHILDREN\"", "HEADING",
  "\"HEADING-COLOR\"", "\"HEADING-DIVIDER-COLOR\"", "\"HEADING-FONT\"",
  "HEAVY", "\"HEIGHT-IN-CELLS\"", "\"HIDDEN-DATA\"", "HIGHLIGHT",
  "\"HIGH-COLOR\"", "\"HIGH-VALUE\"", "\"HOT-TRACK\"", "HSCROLL",
  "\"HSCROLL-POS\"", "ICON", "ID", "IDENTIFIED", "IDENTIFICATION", "IF",
  "IGNORE", "IGNORING", "IN", "INDEPENDENT", "INDEX", "INDEXED",
  "INDICATE", "INITIALIZE", "INITIALIZED", "INITIATE", "INPUT",
  "\"INPUT-OUTPUT\"", "INQUIRE", "\"INSERTION-INDEX\"", "\"INSERT-ROWS\"",
  "INSPECT", "INTERMEDIATE", "INTO", "INTRINSIC", "INVALID",
  "\"INVALID KEY\"", "IS", "ITEM", "\"ITEM-TEXT\"", "\"ITEM-TO_ADD\"",
  "\"ITEM-TO_DELETE\"", "\"ITEM-TO_EMPTY\"", "\"ITEM-VALUE\"", "\"I-O\"",
  "\"I-O-CONTROL\"", "JSON", "JUSTIFIED", "KEPT", "KEY", "KEYBOARD",
  "LABEL", "\"LABEL-OFFSET\"", "\"LARGE-FONT\"", "\"LARGE-OFFSET\"",
  "LAST", "\"LAST-ROW\"", "\"LAYOUT-DATA\"", "\"LAYOUT-MANAGER\"",
  "LEADING", "\"LEADING-SHIFT\"", "LEAVE", "LEFT", "LEFTLINE",
  "\"LEFT-TEXT\"", "LENGTH", "\"LENGTH OF\"",
  "\"FUNCTION LENGTH/BYTE-LENGTH\"", "LESS", "\"LESS OR EQUAL\"",
  "\"level-number\"", "LIKE", "LIMIT", "LIMITS", "LINAGE",
  "\"LINAGE-COUNTER\"", "LINE", "\"LINE-COUNTER\"", "\"LINE LIMIT\"",
  "\"LINE-SEQUENTIAL\"", "LINES", "\"LINES-AT-ROOT\"", "LINKAGE",
  "\"LIST-BOX\"", "\"Literal\"", "\"LM-RESIZE\"", "LOC", "LOCALE",
  "\"FUNCTION LOCALE-DATE\"", "\"FUNCTION LOCALE-TIME\"",
  "\"FUNCTION LOCALE-TIME-FROM-SECONDS\"", "\"LOCAL-STORAGE\"", "LOCK",
  "\"LOCK-HOLDING\"", "\"LONG-DATE\"", "LOWER", "LOWERED",
  "\"FUNCTION LOWER-CASE\"", "LOWLIGHT", "\"LOW-COLOR\"", "\"LOW-VALUE\"",
  "\"MAGNETIC-TAPE\"", "MANUAL", "\"MASS-UPDATE\"", "\"MASTER-INDEX\"",
  "\"MAX-LINES\"", "\"MAX-PROGRESS\"", "\"MAX-TEXT\"", "\"MAX-VAL\"",
  "MEMORY", "\"MEDIUM-FONT\"", "MENU", "MERGE", "MESSAGE", "MINUS",
  "\"MIN-VAL\"", "\"Mnemonic name\"", "MODE", "MODIFY", "MODULES", "MOVE",
  "MULTILINE", "MULTIPLE", "MULTIPLY", "NAME", "NAMESPACE",
  "\"NAMESPACE-PREFIX\"", "NATIONAL", "\"NATIONAL-EDITED\"",
  "\"FUNCTION NATIONAL-OF\"", "NATIVE", "\"NAVIGATE-URL\"",
  "\"NEAREST-AWAY-FROM-ZERO\"", "\"NEAREST-EVEN\"",
  "\"NEAREST-TOWARD-ZERO\"", "NEGATIVE", "NESTED", "NEW", "NEXT",
  "\"NEXT-ITEM\"", "\"NEXT GROUP\"", "\"NEXT PAGE\"", "NO",
  "\"NO ADVANCING\"", "\"NO-AUTOSEL\"", "\"NO-AUTO-DEFAULT\"",
  "\"NO-BOX\"", "\"NO DATA\"", "\"NO-DIVIDERS\"", "\"NO-ECHO\"",
  "\"NO-F4\"", "\"NO-FOCUS\"", "\"NO-GROUP-TAB\"", "\"NO-KEY-LETTER\"",
  "NOMINAL", "\"NO-SEARCH\"", "\"NO-UPDOWN\"", "NONNUMERIC", "NORMAL",
  "NOT", "NOTAB", "NOTHING", "NOTIFY", "\"NOTIFY-CHANGE\"",
  "\"NOTIFY-DBLCLICK\"", "\"NOTIFY-SELCHANGE\"", "\"NOT END\"",
  "\"NOT EOP\"", "\"NOT ESCAPE\"", "\"NOT EQUAL\"", "\"NOT EXCEPTION\"",
  "\"NOT INVALID KEY\"", "\"NOT OVERFLOW\"", "\"NOT SIZE ERROR\"",
  "\"NUM-COL-HEADINGS\"", "\"NUM-ROWS\"", "NUMBER", "NUMBERS", "NUMERIC",
  "\"NUMERIC-EDITED\"", "\"FUNCTION NUMVAL-C\"", "OBJECT",
  "\"OBJECT-COMPUTER\"", "OCCURS", "OF", "OFF", "\"OK-BUTTON\"", "OMITTED",
  "ON", "ONLY", "OPEN", "OPTIONAL", "OPTIONS", "OR", "ORDER",
  "ORGANIZATION", "OTHER", "OTHERS", "OUTPUT", "\"OVERLAP-LEFT\"",
  "\"OVERLAP-TOP\"", "OVERLINE", "\"PACKED-DECIMAL\"", "PADDING", "PASCAL",
  "PAGE", "\"PAGE-COUNTER\"", "\"PAGE-SETUP\"", "PAGED", "PARAGRAPH",
  "PARENT", "PARSE", "PASSWORD", "PERFORM", "PERMANENT", "PH", "PF",
  "PHYSICAL", "PICTURE", "\"PICTURE SYMBOL\"", "PIXEL", "PLACEMENT",
  "PLUS", "POINTER", "\"POP-UP\"", "POS", "POSITION", "\"POSITION-SHIFT\"",
  "POSITIVE", "PRESENT", "PREVIOUS", "PRINT", "\"PRINT-CONTROL\"",
  "\"PRINT-NO-PROMPT\"", "\"PRINT-PREVIEW\"", "PRINTER", "\"PRINTER-1\"",
  "PRINTING", "PRIORITY", "PROCEDURE", "PROCEDURES", "PROCEED",
  "PROCESSING", "PROGRAM", "\"PROGRAM-ID\"", "\"program name\"",
  "\"PROGRAM-POINTER\"", "PROGRESS", "PROHIBITED", "PROMPT", "PROPERTIES",
  "PROPERTY", "PROTECTED", "PURGE", "\"PUSH-BUTTON\"", "\"QUERY-INDEX\"",
  "QUEUE", "QUOTE", "\"RADIO-BUTTON\"", "RAISE", "RAISED", "RANDOM", "RD",
  "READ", "READERS", "\"READ-ONLY\"", "\"READY TRACE\"", "RECEIVE",
  "RECORD", "\"RECORD-DATA\"", "\"RECORD-OVERFLOW\"", "\"RECORD-TO-ADD\"",
  "\"RECORD-TO-DELETE\"", "RECORDING", "RECORDS", "RECURSIVE", "REDEFINES",
  "REEL", "REFERENCE", "REFERENCES", "REFRESH", "\"REGION-COLOR\"",
  "RELATIVE", "RELEASE", "REMAINDER", "REMOVAL", "RENAMES",
  "\"REORG-CRITERIA\"", "REPLACE", "REPLACING", "REPORT", "REPORTING",
  "REPORTS", "REPOSITORY", "REQUIRED", "REREAD", "RERUN", "RESERVE",
  "RESET", "\"RESET TRACE\"", "\"RESET-GRID\"", "\"RESET-LIST\"",
  "\"RESET-TABS\"", "RETRY", "RETURN", "RETURNING", "REVERSE",
  "\"FUNCTION REVERSE\"", "\"REVERSE-VIDEO\"", "REVERSED", "REWIND",
  "REWRITE", "RF", "RH", "RIGHT", "\"RIGHT-ALIGN\"", "RIMMED", "ROLLBACK",
  "ROUNDED", "ROUNDING", "\"ROW-COLOR\"", "\"ROW-COLOR-PATTERN\"",
  "\"ROW-DIVIDERS\"", "\"ROW-FONT\"", "\"ROW-HEADINGS\"",
  "\"ROW-PROTECTION\"", "RUN", "S", "SAME", "\"SAVE-AS\"",
  "\"SAVE-AS-NO-PROMPT\"", "SCREEN", "\"SCREEN CONTROL\"", "SCROLL",
  "\"SCROLL-BAR\"", "SD", "SEARCH", "\"SEARCH-OPTIONS\"",
  "\"SEARCH-TEXT\"", "SECONDS", "SECTION", "SECURE", "SEGMENT",
  "\"SEGMENT-LIMIT\"", "SELECT", "\"SELECTION-INDEX\"",
  "\"SELECTION-TEXT\"", "\"SELECTION-ALL\"", "\"SELF-ACT\"",
  "\"semi-colon\"", "SEND", "SENTENCE", "SEPARATE", "SEPARATION",
  "SEQUENCE", "SEQUENTIAL", "SET", "\"level-number 78\"", "SHADING",
  "SHADOW", "SHARING", "\"SHORT-DATE\"", "\"SHOW-LINES\"", "\"SHOW-NONE\"",
  "\"SHOW-SEL-ALWAYS\"", "SIGN", "SIGNED", "\"SIGNED-INT\"",
  "\"SIGNED-LONG\"", "\"SIGNED-SHORT\"", "\"level-number 66\"", "SIZE",
  "\"SIZE ERROR\"", "\"SMALL-FONT\"", "SORT", "\"SORT-MERGE\"",
  "\"SORT-ORDER\"", "SOURCE", "\"SOURCE-COMPUTER\"", "SPACE",
  "\"SPECIAL-NAMES\"", "SPINNER", "SQUARE", "STANDARD", "\"STANDARD-1\"",
  "\"STANDARD-2\"", "\"STANDARD-BINARY\"", "\"STANDARD-DECIMAL\"", "START",
  "\"START-X\"", "\"START-Y\"", "STATIC", "\"STATIC-LIST\"", "STATUS",
  "\"STATUS-BAR\"", "\"STATUS-TEXT\"", "STDCALL", "STEP", "STOP", "STRING",
  "STRONG", "STYLE", "\"SUB-QUEUE-1\"", "\"SUB-QUEUE-2\"",
  "\"SUB-QUEUE-3\"", "\"FUNCTION SUBSTITUTE\"",
  "\"FUNCTION SUBSTITUTE-CASE\"", "SUBTRACT", "SUBWINDOW", "SUM",
  "SUPPRESS", "\"SUPPRESS\"", "SYMBOLIC", "SYNCHRONIZED",
  "\"SYSTEM-DEFAULT\"", "\"SYSTEM-INFO\"", "\"SYSTEM-OFFSET\"", "TAB",
  "\"TAB-TO-ADD\"", "\"TAB-TO-DELETE\"", "TABLE", "TALLYING", "TEMPORARY",
  "TAPE", "TERMINAL", "TERMINATE", "\"TERMINAL-INFO\"",
  "\"TERMINATION-VALUE\"", "TEST", "TEXT", "THAN", "THEN", "THREAD",
  "THREADS", "THRU", "\"THUMB-POSITION\"", "\"TILED-HEADINGS\"", "TIME",
  "\"TIME-OUT\"", "TIMES", "TITLE", "\"TITLE-POSITION\"", "TO", "\"&\"",
  "\")\"", "\":\"", "\"/\"", "\".\"", "\"=\"", "\"EXTERN\"", "\"FALSE\"",
  "\"FILE\"", "\">\"", "\"INITIAL\"", "\"<\"", "\"-\"", "\"*\"",
  "\"NULL\"", "\"OVERFLOW\"", "\"(\"", "\"+\"", "\"TRUE\"", "TOP",
  "\"TOWARD-GREATER\"", "\"TOWARD-LESSER\"", "TRACK", "TRACKS",
  "\"TRACK-AREA\"", "\"TRACK-LIMIT\"", "\"TRADITIONAL-FONT\"", "TRAILING",
  "\"TRAILING-SHIFT\"", "TRANSFORM", "TRANSPARENT", "\"TREE-VIEW\"",
  "\"FUNCTION TRIM\"", "TRUNCATION", "TYPE", "TYPEDEF", "U", "\"UCS-4\"",
  "UNBOUNDED", "UNDERLINE", "UNFRAMED", "UNIT", "UNLOCK", "UNSIGNED",
  "\"UNSIGNED-INT\"", "\"UNSIGNED-LONG\"", "\"UNSIGNED-SHORT\"",
  "UNSORTED", "UNSTRING", "UNTIL", "UP", "UPDATE", "UPDATERS", "UPON",
  "\"UPON ARGUMENT-NUMBER\"", "\"UPON COMMAND-LINE\"",
  "\"UPON ENVIRONMENT-NAME\"", "\"UPON ENVIRONMENT-VALUE\"", "UPPER",
  "\"FUNCTION UPPER-CASE\"", "USAGE", "USE", "\"USE-ALT\"",
  "\"USE-RETURN\"", "\"USE-TAB\"", "USER", "\"USER-DEFAULT\"",
  "\"user function name\"", "USING", "\"UTF-8\"", "\"UTF-16\"", "V",
  "VALIDATE", "VALIDATING", "VALUE", "\"VALUE-FORMAT\"", "VARIABLE",
  "VARIANT", "VARYING", "VERTICAL", "\"VERY-HEAVY\"", "\"VIRTUAL-WIDTH\"",
  "VOLATILE", "VPADDING", "VSCROLL", "\"VSCROLL-BAR\"", "\"VSCROLL-POS\"",
  "VTOP", "WAIT", "\"WEB-BROWSER\"", "WHEN", "\"FUNCTION WHEN-COMPILED\"",
  "\"WHEN\"", "WIDTH", "\"WIDTH-IN-CELLS\"", "WINDOW", "WITH",
  "\"Identifier\"", "WORDS", "\"WORKING-STORAGE\"", "WRAP", "WRITE",
  "\"WRITE-ONLY\"", "\"WRITE-VERIFY\"", "WRITERS", "X", "XML",
  "\"XML-DECLARATION\"", "Y", "YYYYDDD", "YYYYMMDD", "ZERO",
  "SHIFT_PREFER", "$accept", "start", "$@1", "compilation_group",
  "nested_list", "$@2", "source_element_list", "source_element",
  "simple_prog", "$@3", "program_definition", "function_definition",
  "_end_program_list", "end_program_list", "end_program", "$@4",
  "end_function", "$@5", "_program_body", "$@6", "$@7",
  "_identification_header", "identification_header",
  "identification_or_id", "program_id_paragraph", "$@8", "$@9",
  "function_id_paragraph", "$@10", "program_id_name", "end_program_name",
  "_as_literal", "_program_type", "program_type_clause",
  "init_or_recurse_and_common", "init_or_recurse", "_options_paragraph",
  "_options_clauses", "_arithmetic_clause", "arithmetic_choice",
  "_default_rounded_clause", "_entry_convention_clause", "convention_type",
  "_intermediate_rounding_clause", "intermediate_rounding_choice",
  "_environment_division", "_environment_header", "_configuration_section",
  "_configuration_header", "_configuration_paragraphs",
  "configuration_paragraphs", "configuration_paragraph",
  "source_computer_paragraph", "$@11", "_source_computer_entry",
  "_with_debugging_mode", "object_computer_paragraph", "$@12",
  "_object_computer_entry", "object_clauses_list", "object_clauses",
  "object_computer_memory", "object_computer_sequence",
  "program_collating_sequence", "$@13", "program_coll_sequence_values",
  "object_computer_segment", "object_computer_class", "locale_class",
  "computer_words", "repository_paragraph", "$@14", "_repository_entry",
  "repository_list", "repository_name", "repository_name_list",
  "special_names_header", "special_names_sentence", "special_name_list",
  "special_name", "mnemonic_name_clause", "$@15", "mnemonic_choices",
  "_special_name_mnemonic_on_off", "on_off_clauses", "on_off_clauses_1",
  "alphabet_name_clause", "@16", "alphabet_definition", "@17", "@18",
  "alphabet_target_alphanumeric", "alphabet_target_national",
  "alphabet_type_alphanumeric", "alphabet_type_national",
  "alphabet_type_common", "alphabet_literal_list", "alphabet_literal",
  "@19", "alphabet_also_sequence", "alphabet_lits", "space_or_zero",
  "symbolic_characters_clause", "_sym_in_word", "symbolic_collection",
  "symbolic_chars_list", "symbolic_chars_phrase", "char_list",
  "integer_list", "symbolic_constant_clause", "symbolic_constant_list",
  "symbolic_constant", "class_name_clause", "class_item_list",
  "class_item", "_class_type", "_in_alphabet", "locale_clause",
  "currency_sign_clause", "_with_pic_symbol", "decimal_point_clause",
  "numeric_sign_clause", "cursor_clause", "crt_status_clause",
  "screen_control", "event_status", "top_clause", "$@20",
  "_input_output_section", "_input_output_header", "_file_control_header",
  "_file_control_sequence", "file_control_entry", "$@21",
  "_select_clauses_or_error", "_select_clause_sequence", "select_clause",
  "assign_clause", "_assign_device_or_line_adv_file", "assign_device",
  "general_device_name", "line_seq_device_name", "line_adv_file",
  "_ext_clause", "ext_clause", "assignment_name", "access_mode_clause",
  "access_mode", "alternative_record_key_clause", "_password_clause",
  "password_clause", "$@22", "_suppress_clause",
  "collating_sequence_clause", "collating_sequence", "$@23",
  "coll_sequence_values", "collating_sequence_clause_key", "alphabet_name",
  "file_status_clause", "_file_or_sort", "lock_mode_clause", "$@24",
  "lock_mode", "_lock_with", "_with_rollback", "with_rollback",
  "_with_mass_update", "organization_clause", "organization",
  "padding_character_clause", "record_delimiter_clause", "$@25",
  "record_delimiter_option", "record_key_clause", "_split_keys",
  "source_is", "split_key_list", "$@26", "split_key",
  "relative_key_clause", "reserve_clause", "no_or_integer",
  "sharing_clause", "sharing_option", "file_limit_clause", "thru_list",
  "actual_key_clause", "nominal_key_clause", "track_area_clause",
  "track_limit_clause", "_i_o_control", "i_o_control_header",
  "_i_o_control_entries", "i_o_control_list", "i_o_control_clause",
  "same_clause", "_same_option", "apply_clause",
  "obsolete_dos_vs_apply_phrase", "multiple_file_tape_clause", "$@27",
  "multiple_file_list", "multiple_file", "_multiple_file_position",
  "rerun_clause", "_on_assignment", "rerun_event", "_data_division",
  "$@28", "_data_division_header", "data_division_header",
  "_file_section_header", "_file_description_sequence", "file_description",
  "file_description_entry", "$@29", "file_type",
  "_file_description_clause_sequence", "file_description_clause",
  "block_contains_clause", "_records_or_characters", "record_clause",
  "_record_depending", "_from_integer", "_to_integer",
  "label_records_clause", "value_of_clause", "file_id", "valueof_name",
  "data_records_clause", "linage_clause", "_linage_sequence",
  "linage_lines", "linage_footing", "linage_top", "linage_bottom",
  "recording_mode_clause", "recording_mode", "u_or_s", "code_set_clause",
  "_for_sub_records_clause", "report_clause", "report_keyword",
  "rep_name_list", "_communication_section", "$@30",
  "_communication_description_sequence", "communication_description",
  "communication_description_entry", "$@31",
  "_communication_description_clause_sequence",
  "communication_description_clause", "_input_cd_clauses",
  "named_input_cd_clauses", "named_input_cd_clause",
  "unnamed_input_cd_clauses", "_output_cd_clauses", "output_cd_clauses",
  "output_cd_clause", "_i_o_cd_clauses", "named_i_o_cd_clauses",
  "named_i_o_cd_clause", "unnamed_i_o_cd_clauses",
  "_working_storage_section", "$@32", "_record_description_list", "$@33",
  "record_description_list", "data_description", "$@34", "level_number",
  "_filler", "_entry_name", "user_entry_name", "_const_global",
  "lit_or_length", "con_source", "fp32_usage", "fp64_usage", "fp128_usage",
  "pointer_len", "renames_entry", "_renames_thru", "condition_name_entry",
  "$@35", "constant_entry", "$@36", "constant_source",
  "constant_78_source", "constant_expression_list", "constant_expression",
  "_data_description_clause_sequence", "data_description_clause_sequence",
  "data_description_clause", "redefines_clause", "like_clause",
  "_length_modifier", "length_modifier", "same_as_clause",
  "typedef_clause", "_strong", "external_clause", "_as_extname",
  "_global_clause", "global_clause", "special_names_clause", "$@37",
  "special_names_target", "volatile_clause", "picture_clause",
  "_pic_locale_format", "_is_locale_name", "locale_name", "type_to_clause",
  "usage_clause", "usage", "double_usage", "_font_name", "_layout_name",
  "sign_clause", "report_occurs_clause", "_occurs_step", "occurs_clause",
  "_occurs_to_integer", "_occurs_from_integer", "_occurs_integer_to",
  "_occurs_depending", "_capacity_in", "_occurs_initialized",
  "_occurs_keys_and_indexed", "$@38", "occurs_keys", "occurs_key_list",
  "occurs_key_field", "ascending_or_descending", "_occurs_indexed",
  "occurs_indexed", "occurs_index_list", "occurs_index",
  "justified_clause", "synchronized_clause", "_left_or_right",
  "blank_clause", "based_clause", "value_clause", "$@39",
  "value_item_list", "value_item", "_false_is", "any_length_clause",
  "external_form_clause", "identified_by_clause", "_local_storage_section",
  "$@40", "_linkage_section", "$@41", "_report_section", "$@42",
  "_report_description_sequence", "report_description", "$@43",
  "_report_description_options", "report_description_option",
  "control_clause", "control_field_list", "control_final_tag",
  "control_identifier_list", "control_identifier", "page_limit_clause",
  "page_line_column", "page_limit_cols", "integer_or_zero_or_ident",
  "_page_heading_list", "page_detail", "heading_clause", "first_detail",
  "last_heading", "last_detail", "footing_clause",
  "_report_group_description_list", "report_group_description_entry",
  "$@44", "_report_group_options", "report_group_option", "type_is_clause",
  "type_option", "_control_heading_final", "_or_page",
  "_control_footing_final", "next_group_clause", "next_group_plus",
  "next_page", "sum_clause_list", "_reset_clause", "data_or_final",
  "present_when_condition", "present_absent", "_page_or_id", "page_or_ids",
  "report_varying_clause", "line_clause", "line_keyword_clause",
  "_line_clause_options", "line_clause_option", "column_clause",
  "col_keyword_clause", "_orientation", "_left_right_center",
  "col_or_plus", "column_integer_list", "column_integer", "source_clause",
  "group_indicate_clause", "_screen_section", "$@45",
  "_screen_description_list", "screen_description_list",
  "screen_description", "$@46", "$@47", "$@48", "_screen_options",
  "screen_option", "control_definition", "control_type_name",
  "control_type", "control_item", "_control_attributes",
  "control_attributes", "control_attribute", "control_style",
  "control_property", "control_style_name", "control_property_name",
  "control_style_name_generic", "control_property_name_generic",
  "control_style_name_label", "control_property_name_label",
  "control_style_name_entry_field", "control_property_name_entry_field",
  "control_style_name_push_button", "control_property_name_push_button",
  "control_style_name_check_box", "control_property_name_radio_button",
  "control_style_name_list_box", "control_property_name_list_box",
  "control_style_name_combo_box", "control_style_name_frame",
  "control_property_name_frame", "control_style_name_tab_control",
  "control_property_name_tab_control", "control_style_name_bar",
  "control_property_name_bar", "control_property_name_bitmap",
  "control_style_name_grid", "control_property_name_grid",
  "control_style_name_tree_view", "control_property_name_tree_view",
  "control_property_name_web_browser", "control_style_name_activex",
  "control_property_name_activex", "control_style_name_date_entry",
  "control_property_name_date_entry", "control_style_type",
  "control_property_type", "changeable_control_properties",
  "changeable_control_property", "changeable_window_properties",
  "changeable_window_property", "eol", "eos", "_plus", "plus",
  "plus_tokens", "minus", "minus_tokens", "control_size",
  "control_size_unit", "_cell", "screen_line_number",
  "_screen_line_plus_minus", "screen_col_number", "_screen_col_plus_minus",
  "screen_occurs_clause", "screen_global_clause", "_procedure_division",
  "procedure_division", "$@49", "$@50", "$@51", "$@52",
  "_procedure_using_chaining", "$@53", "$@54", "procedure_param_list",
  "procedure_param", "_procedure_type", "_size_optional",
  "size_is_integer", "_acu_size", "_procedure_optional",
  "_procedure_returning", "_procedure_declaratives", "$@55",
  "_procedure_list", "procedure", "section_header", "$@56",
  "_use_statement", "paragraph_header", "invalid_statement", "_segment",
  "statement_list", "@57", "@58", "statements", "$@59", "statement",
  "accept_statement", "$@60", "accept_body", "$@61", "$@62",
  "accp_identifier", "field_with_pos_specifier", "$@63", "pos_specifier",
  "pos_specifier_value", "identifier_or_numeric_literal",
  "_accept_clauses", "accept_clauses", "accept_clause",
  "accept_from_screen_clauses", "accept_from_screen_clause",
  "lines_or_number", "at_line_column", "line_number", "column_number",
  "mode_is_block", "accp_attr", "_key_dest", "key_dest", "no_echo",
  "reverse_video", "update_default", "_end_accept", "add_statement",
  "$@64", "add_body", "_add_to", "_end_add", "allocate_statement", "$@65",
  "allocate_body", "_loc", "allocate_returning", "alter_statement", "$@66",
  "alter_body", "alter_entry", "_proceed_to", "call_statement", "$@67",
  "call_body", "$@68", "_conv_linkage", "$@69", "conv_linkage_option",
  "_mnemonic_conv", "mnemonic_conv", "program_or_prototype",
  "_id_or_lit_or_func_as", "nested_or_prototype", "call_using", "$@70",
  "call_param_list", "call_param", "_call_type", "call_returning",
  "return_give", "null_or_omitted", "call_exception_phrases",
  "_call_on_exception", "call_on_exception", "_call_not_on_exception",
  "call_not_on_exception", "_end_call", "cancel_statement", "$@71",
  "cancel_body", "id_or_lit_or_program_name", "close_statement", "$@72",
  "close_body", "close_files", "_close_option", "close_window", "$@73",
  "_close_display_option", "compute_statement", "$@74", "compute_body",
  "_end_compute", "commit_statement", "continue_statement", "$@75",
  "_continue_after_phrase", "$@76", "destroy_statement", "$@77",
  "destroy_body", "delete_statement", "$@78", "delete_body",
  "delete_file_list", "_end_delete", "disable_statement", "$@79",
  "enable_disable_handling", "_enable_disable_key", "communication_mode",
  "display_statement", "$@80", "display_body", "screen_or_device_display",
  "display_list", "display_atom", "$@81", "disp_list",
  "_with_display_attr", "display_attrs", "display_clauses",
  "display_clause", "display_upon", "crt_under", "display_erase", "$@82",
  "display_pos_specifier", "field_or_literal_or_erase_with_pos_specifier",
  "$@83", "field_or_literal_or_erase_list", "field_or_literal_or_erase",
  "display_message_box", "$@84", "_display_message_clauses",
  "display_message_clauses", "display_message_clause", "display_window",
  "$@85", "$@86", "sub_or_window", "display_floating_window", "$@87",
  "$@88", "display_initial_window", "$@89", "initial_type", "_graphical",
  "_upon_window_handle", "window_handle", "display_window_clauses",
  "display_window_clause", "shadow", "boxed", "_top_or_bottom",
  "_left_or_centered_or_right", "no_scroll_wrap", "pop_up_or_handle",
  "pop_up_area", "handle_is_in", "disp_attr", "_end_display",
  "divide_statement", "$@90", "divide_body", "_end_divide",
  "enable_statement", "$@91", "entry_statement", "$@92", "$@93",
  "entry_body", "entry_goto_body", "evaluate_statement", "$@94",
  "evaluate_body", "evaluate_subject_list", "evaluate_subject",
  "evaluate_condition_list", "evaluate_case_list", "evaluate_case",
  "evaluate_other", "evaluate_when_list", "$@95", "$@96",
  "evaluate_object_list", "evaluate_object", "_evaluate_thru_expr",
  "_end_evaluate", "exit_statement", "$@97", "exit_body",
  "exit_program_returning", "free_statement", "$@98", "free_body",
  "generate_statement", "$@99", "generate_body", "goto_statement", "$@100",
  "go_body", "goto_depending", "goback_statement", "if_statement", "$@101",
  "if_else_statements", "_if_then", "if_true", "if_false", "_end_if",
  "initialize_statement", "$@102", "initialize_body", "_initialize_filler",
  "_initialize_value", "_initialize_replacing",
  "initialize_replacing_list", "initialize_replacing_item",
  "initialize_category", "_initialize_default", "initiate_statement",
  "$@103", "initiate_body", "inquire_statement", "$@104", "inquire_body",
  "inspect_statement", "$@105", "inspect_body", "send_identifier",
  "inspect_list", "inspect_tallying", "$@106", "inspect_replacing",
  "inspect_converting", "tallying_list", "tallying_item", "replacing_list",
  "replacing_item", "rep_keyword", "replacing_region", "inspect_region",
  "inspect_before", "inspect_after", "json_generate_statement", "$@107",
  "json_generate_body", "$@108", "$@109", "_json_suppress",
  "json_suppress_list", "json_suppress_entry", "_end_json",
  "json_parse_statement", "$@110", "json_parse_body", "_with_detail",
  "merge_statement", "$@111", "modify_statement", "$@112", "modify_body",
  "_end_modify", "move_statement", "$@113", "move_body",
  "multiply_statement", "$@114", "multiply_body", "_end_multiply",
  "open_statement", "$@115", "open_body", "open_file_entry",
  "_open_exclusive", "open_mode", "_open_sharing", "_open_option",
  "lock_allowing", "open_lock_option", "allowing_option", "allowing_all",
  "open_option_sequential", "osvs_input_mode", "perform_statement",
  "$@116", "perform_body", "$@117", "$@118", "_end_perform",
  "end_perform_or_dot", "perform_procedure", "_perform_option",
  "perform_test", "cond_or_exit", "perform_varying_list",
  "perform_varying", "_by_phrase", "purge_statement", "$@119",
  "raise_statement", "$@120", "raise_body", "exception_name",
  "read_statement", "$@121", "read_body", "_read_into", "_lock_phrases",
  "ignoring_lock", "advancing_lock_or_retry", "_retry_phrase",
  "retry_phrase", "retry_options", "_extended_with_lock",
  "extended_with_lock", "_read_key", "read_handler", "_end_read",
  "ready_statement", "receive_statement", "$@122", "receive_body",
  "message_or_segment", "_data_sentence_phrases", "_no_data_sentence",
  "no_data_sentence", "_with_data_sentence", "with_data_sentence",
  "_end_receive", "release_statement", "$@123", "release_body",
  "reset_statement", "return_statement", "$@124", "return_body",
  "_end_return", "rewrite_statement", "$@125", "rewrite_body",
  "_with_lock", "with_lock", "_end_rewrite", "rollback_statement",
  "search_statement", "$@126", "search_body", "search_varying",
  "search_at_end", "search_whens", "search_when", "_end_search",
  "send_statement", "$@127", "send_body", "_from_identifier",
  "from_identifier", "with_indicator", "_replacing_line", "set_statement",
  "$@128", "set_body", "on_or_off", "up_or_down", "set_environment",
  "set_attr", "set_attr_clause", "set_attr_one", "set_to", "set_up_down",
  "set_to_on_off_sequence", "set_to_on_off", "set_to_true_false_sequence",
  "set_to_true_false", "set_last_exception_to_off", "set_thread_priority",
  "sort_statement", "$@129", "sort_body", "@130", "_sort_key_list",
  "_key_sort_list", "_sort_duplicates", "_sort_collating", "sort_input",
  "sort_output", "start_statement", "$@131", "start_body",
  "_sizelen_clause", "_start_key", "start_op", "disallowed_op",
  "not_equal_op", "_end_start", "stop_statement", "$@132",
  "stop_returning", "_status_x", "stop_argument", "stop_literal",
  "string_statement", "$@133", "string_body", "string_items", "$@134",
  "string_item_list", "string_item", "_string_delimited",
  "string_delimiter", "_with_pointer", "_end_string", "subtract_statement",
  "$@135", "subtract_body", "_end_subtract", "suppress_statement",
  "_printing", "terminate_statement", "$@136", "terminate_body",
  "transform_statement", "$@137", "transform_body", "unlock_statement",
  "$@138", "unlock_body", "unstring_statement", "$@139", "unstring_body",
  "_unstring_delimited", "unstring_delimited_list",
  "unstring_delimited_item", "unstring_into", "unstring_into_item",
  "_unstring_into_delimiter", "_unstring_tallying", "_end_unstring",
  "validate_statement", "$@140", "validate_fields", "use_statement",
  "$@141", "use_phrase", "use_file_exception", "use_global",
  "use_file_exception_target", "use_debugging", "debugging_list",
  "debugging_target", "_all_refs", "use_start_end", "program_start_end",
  "use_reporting", "use_exception_list", "use_exception", "use_ex_keyw",
  "write_statement", "$@142", "write_body", "from_option", "write_option",
  "before_or_after", "write_handler", "_end_write",
  "xml_generate_statement", "$@143", "xml_generate_body", "$@144", "$@145",
  "_with_encoding_xml_dec_and_attrs", "with_encoding_xml_dec_and_attrs",
  "with_encoding_xml_dec_and_attr", "encoding_xml_dec_and_attr",
  "_xml_gen_namespace", "_xml_gen_namespace_prefix", "_name_of",
  "identifier_name_list", "identifier_is_name", "_type_of",
  "identifier_type_list", "identifier_is_type", "_xml_type", "ml_type",
  "_xml_gen_suppress", "xml_suppress_list", "xml_suppress_entry",
  "xml_suppress_generic_opt", "xml_suppress_when_list", "_end_xml",
  "xml_parse_statement", "$@146", "xml_parse_body", "$@147",
  "_with_encoding", "_returning_national", "_validating_with",
  "schema_file_or_record_name", "_accept_exception_phrases",
  "_accp_on_exception", "accp_on_exception", "escape_or_exception",
  "_accp_not_on_exception", "accp_not_on_exception",
  "not_escape_or_not_exception", "_display_exception_phrases",
  "_disp_on_exception", "disp_on_exception", "_disp_not_on_exception",
  "disp_not_on_exception", "_xml_exception_phrases", "_xml_on_exception",
  "xml_on_exception", "_xml_not_on_exception", "xml_not_on_exception",
  "_json_exception_phrases", "_json_on_exception", "json_on_exception",
  "_json_not_on_exception", "json_not_on_exception",
  "on_size_error_phrases", "_on_size_error", "on_size_error",
  "_not_on_size_error", "not_on_size_error", "_on_overflow_phrases",
  "_on_overflow", "on_overflow", "_not_on_overflow", "not_on_overflow",
  "return_at_end", "at_end", "_at_end_clause", "at_end_clause",
  "_not_at_end_clause", "not_at_end_clause", "at_eop_clauses",
  "_at_eop_clause", "at_eop_clause", "_not_at_eop_clause",
  "not_at_eop_clause", "_invalid_key_phrases", "invalid_key_phrases",
  "_invalid_key_sentence", "invalid_key_sentence",
  "_not_invalid_key_sentence", "not_invalid_key_sentence", "_thread_start",
  "_thread_handle", "thread_reference_optional", "_scroll_lines",
  "_count_in", "condition", "expr", "partial_expr", "$@148", "expr_tokens",
  "expr_token", "_not_expr", "not_expr", "condition_or_class", "eq", "gt",
  "lt", "ge", "le", "exp_list", "_e_sep", "exp", "exp_term", "exp_factor",
  "exp_unary", "exp_atom", "line_linage_page_counter", "arithmetic_x_list",
  "arithmetic_x", "record_name", "file_or_record_name", "table_name",
  "file_name_list", "file_file_name_list", "file_name", "cd_name",
  "report_name", "mnemonic_name_list", "mnemonic_name", "entry_name_list",
  "entry_name", "procedure_name_list", "procedure_name", "label",
  "integer_label", "reference_list", "reference", "_reference",
  "single_reference_list", "single_reference", "optional_reference_list",
  "optional_reference", "reference_or_literal", "undefined_word",
  "unique_word", "target_x_list", "target_x", "_x_list", "x_list", "x",
  "call_x", "x_common", "length_of_register", "report_x_list", "expr_x",
  "arith_x", "arith_nonzero_x", "numeric_literal", "non_numeric_literal",
  "nonzero_numeric_literal", "prog_or_entry", "alnum_or_id",
  "simple_display_value", "simple_display_all_value", "inspect_from",
  "inspect_to", "simple_value", "simple_all_value", "id_or_lit",
  "id_or_lit_or_func", "id_or_lit_or_length_or_func", "num_id_or_lit",
  "positive_id_or_lit", "pos_num_id_or_lit_or_zero", "pos_num_id_or_lit",
  "from_parameter", "sub_identifier", "table_identifier",
  "sub_identifier_1", "display_identifier", "numeric_identifier",
  "identifier_or_file_name", "identifier_field", "type_name", "identifier",
  "identifier_1", "identifier_list", "target_identifier",
  "target_identifier_1", "display_identifier_or_alphabet_name",
  "qualified_word", "unqualified_word", "$@149", "unqualified_word_check",
  "subref", "refmod", "integer", "symbolic_integer",
  "unsigned_pos_integer", "integer_or_zero", "class_value", "literal",
  "basic_literal", "basic_value", "zero_spaces_high_low_values",
  "function", "func_no_parm", "func_one_parm", "func_multi_parm",
  "func_refmod", "func_args", "trim_args", "length_arg", "$@150",
  "numvalc_args", "locale_dt_args", "formatted_datetime_args",
  "formatted_time_args", "not_const_word", "flag_all", "flag_duplicates",
  "flag_initialized", "flag_initialized_to", "to_init_val", "_flag_next",
  "_flag_not", "flag_optional", "flag_rounded", "round_mode",
  "round_choice", "flag_separate", "_from_idx_to_idx", "_dest_index",
  "error_stmt_recover", "verb", "scope_terminator", "_advancing", "_after",
  "_are", "_area", "_areas", "_as", "_at", "_before", "_binary", "_box",
  "_by", "_character", "_characters", "_collating", "_contains",
  "_controls", "_control", "_data", "_end_of", "_every", "_file", "_for",
  "_from", "_in", "_in_equal", "_in_order", "_index", "_indicate",
  "_initial", "_into", "_is", "_is_equal", "_is_are", "_is_are_equal",
  "_is_in", "_key", "_line", "_line_or_lines", "_limits", "_lines",
  "_lock", "_message", "_mode", "_new", "_number", "_number_or_numbers",
  "_of", "_on", "_on_for", "_onoff_status", "_other", "_others",
  "_procedure", "_program", "_protected", "_record", "_records", "_right",
  "_sign", "_signed", "_sign_is", "_size", "_standard", "_status",
  "_symbolic", "_tape", "_terminal", "_then", "_times", "_to", "_up",
  "_when", "_when_set_to", "_with", "_with_for", "column_or_col",
  "columns_or_cols", "column_or_cols", "column_or_col_or_position_or_pos",
  "comp_equal", "exception_or_error", "file_limit_or_limits", "in_of",
  "label_option", "line_or_lines", "lock_records",
  "object_char_or_word_or_modules", "records", "reel_or_unit",
  "size_or_length", "length_of", "track_or_tracks", "using_or_varying",
  "detail_keyword", "ch_keyword", "cf_keyword", "ph_keyword", "pf_keyword",
  "rh_keyword", "rf_keyword", "control_keyword", YY_NULLPTR
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     805,   806,   807,   808,   809,   810,   811,   812,   813,   814,
     815,   816,   817,   818,   819,   820,   821,   822,   823,   824,
     825,   826,   827,   828,   829,   830,   831,   832,   833,   834,
     835,   836,   837,   838,   839,   840,   841,   842,   843,   844,
     845,   846,   847,   848,   849,   850,   851,   852,   853,   854,
     855,   856,   857,   858,   859,   860,   861,   862,   863,   864,
     865,   866,   867,   868,   869,   870,   871,   872,   873,   874,
     875,   876,   877,   878,   879,   880,   881,   882,   883,   884,
     885,   886,   887,   888,   889,   890,   891,   892,   893,   894,
     895,   896,   897,   898,   899,   900,   901,   902,   903,   904,
     905,   906,   907,   908,   909,   910,   911,   912,   913,   914,
     915,   916,   917,   918,   919,   920,   921,   922,   923,   924,
     925,   926,   927,   928,   929,   930,   931,   932,   933,   934,
     935,   936,   937,   938,   939,   940,   941,   942,   943,   944,
     945,   946,   947,   948,   949,   950,   951,   952,   953,   954,
     955,   956,   957,   958,   959,   960,   961,   962,   963,   964,
     965,   966,   967,   968,   969,   970,   971,   972,   973,   974,
     975,   976,   977,   978,   979,   980,   981,   982,   983,   984,
     985,   986,   987,   988,   989,   990,   991,   992,   993,   994,
     995,   996,   997,   998,   999,  1000,  1001,  1002,  1003,  1004,
    1005,  1006,  1007,  1008,  1009,  1010,  1011,  1012,  1013,  1014,
    1015,  1016,  1017,  1018,  1019,  1020,  1021,  1022,  1023,  1024,
    1025,  1026,  1027,  1028,  1029,  1030,  1031,  1032,  1033,  1034,
    1035,  1036,  1037,  1038,  1039,  1040,  1041,  1042,  1043,  1044,
    1045,  1046,  1047,  1048,  1049,  1050,  1051,  1052,  1053,  1054,
    1055,  1056,  1057,  1058,  1059,  1060,  1061,  1062,  1063,  1064,
    1065,  1066,  1067,  1068,  1069,  1070,  1071,  1072,  1073,  1074,
    1075,  1076,  1077,  1078,  1079,  1080,  1081,  1082,  1083,  1084,
    1085,  1086,  1087,  1088,  1089,  1090,  1091,  1092,  1093,  1094,
    1095,  1096,  1097,  1098,  1099,  1100,  1101,  1102,  1103,  1104,
    1105,  1106,  1107,  1108,  1109,  1110,  1111,  1112,  1113,  1114,
    1115,  1116,  1117,  1118,  1119,  1120,  1121,  1122,  1123,  1124,
    1125,  1126,  1127,  1128,  1129,  1130,  1131,  1132,  1133,  1134,
    1135,  1136,  1137,  1138,  1139,  1140,  1141,  1142,  1143,  1144,
    1145,  1146,  1147,  1148,  1149,  1150,  1151,  1152,  1153,  1154,
    1155,  1156,  1157,  1158,  1159,  1160,  1161,  1162,  1163,  1164,
    1165,  1166,  1167,  1168,  1169,  1170,  1171,  1172,  1173,  1174,
    1175,  1176,  1177,  1178,  1179,  1180
};
# endif

#define YYPACT_NINF -3978

#define yypact_value_is_default(Yystate) \
  (!!((Yystate) == (-3978)))

#define YYTABLE_NINF -3134

#define yytable_value_is_error(Yytable_value) \
  0

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const yytype_int16 yypact[] =
{
   -3978,   465,     4, -3978, -3978, -3978,  1886, -3978,   -46, -3978,
   -3978,  1357, -3978, -3978, -3978,    10, -3978,   999,   546, -3978,
    1136, -3978, -3978, -3978,   -46,   -46,   692,  1557,  1665, -3978,
    1632,  1111,  1127,  1744,  1760, -3978,  1616, -3978,  1846,  1243,
    1911,  1427,  1754,  2267,   871,   871, -3978, -3978,  1744, -3978,
   -3978, -3978, -3978,   976,  1456,  1891, -3978,  1969, -3978,  1394,
   -3978,  1401,  1526, -3978,  1924,   111,   111,  1480,  1523,  1616,
    1616,  1616,   111,  1548,  1437,  1444,  1616,  1457,  1470,   317,
   -3978, -3978, -3978,  2267, -3978, -3978, -3978, -3978, -3978, -3978,
    1391, -3978, -3978, -3978, -3978,  1902, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,  2261,
    2261,   941, -3978,   941, -3978, -3978, -3978, -3978, -3978,  1813,
    1616,  1900,  1489,  1529,  1600, -3978, -3978,  1502,  1503, -3978,
   -3978, -3978, -3978,   227,  1616, -3978,  1616,  1416,  2195,  1416,
    1616,  1616, -3978, -3978,  1416, -3978, -3978, -3978,  1420,  1421,
    1616,  1550, -3978, -3978, -3978, -3978,  1425, -3978,  1884,  1531,
   -3978, -3978, -3978,  1533,  1537, -3978,  1616,   108,  1651,  1538,
   -3978,  2122, -3978, -3978, -3978,  1553,   -18, -3978, -3978,   -89,
     227, -3978,  1616,   553,  1416,  1889,   -27, -3978, -3978, -3978,
   -3978,  1920,  1505,    56,    -1, -3978,  1451, -3978,  1420, -3978,
    1616, -3978,  1421, -3978,    86, -3978,   111, -3978, -3978, -3978,
   -3978, -3978,  1536,   782,  1616,   102, -3978, -3978, -3978,   858,
   -3978, -3978,   666, -3978, -3978, -3978, -3978,  1616, -3978, -3978,
    7592,  8207, -3978, -3978, -3978,  1465, -3978,   876,   118,  1562,
    1412, -3978, -3978,   612, -3978, -3978, -3978,   580,  1202, -3978,
   -3978, -3978,  -254, -3978, -3978,  1416, -3978,  1677, -3978,  1660,
   -3978,  1616, -3978, -3978,   165, -3978, -3978, -3978, -3978, -3978,
     531,  2269,  2279,    95,  1493, -3978,   160, -3978, -3978,    69,
   -3978,   212, -3978, -3978, -3978, -3978,  1957, -3978,   782, -3978,
    2007,   111,   111, -3978,  1536,  1598,   113, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978,   750,   668,  8758, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978,  2088, -3978, -3978, -3978, -3978,
   -3978,   -28, -3978, -3978, -3978, -3978, -3978,   -11, -3978, -3978,
   -3978, -3978,  1699, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
    1408, -3978, -3978,  1817, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978,    18, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978,  1718,  2296, -3978,
     432,  1623, -3978, -3978, -3978,  1876, -3978,   111,  2427, -3978,
    1880,  1027, -3978,   426, -3978, -3978, -3978, -3978, -3978, -3978,
    1616,  1616, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978,  1313, -3978,  1638, -3978, -3978,  1855, -3978, -3978, -3978,
    1616,  1993, -3978, -3978, -3978, -3978,   704,  1616, -3978, -3978,
    1725,  2049, -3978,  2261,  1250,  2261,  1637, -3978, -3978,  1641,
    2263,  1544, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
    1642, -3978, -3978,  1957, -3978,   111, -3978, -3978, -3978, -3978,
   -3978, -3978,  -256, -3978, -3978, -3978,  1847, -3978,  2321, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
    1552, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978,  -265, 10997, 16491,   119,   668,    96,  1365,   321,  2449,
     549,   107,   924, 10137, 12148,   924,  2117,   668,  1233,  1272,
     321,  1416,  1667, -3978, -3978, 12148, -3978,  5744,   321,  1570,
      -3,  5365, -3978, -3978,  1416,    -3, 11414, 12148, -3978,  2187,
    -101,  1574,   -84,  1577,  1574,  1416,  1577,  1035,   132,  1574,
     209,  1416,  1577, -3978, -3978, -3978, -3978,  1416, -3978, -3978,
   -3978, -3978, -3978, -3978,  1661, -3978, 11341, -3978, -3978,  1570,
     173,  1416,  1577,  9171,  1416,  1035, -3978, -3978,  1671,  1779,
    2030,  1420,  1420,  1420,   959,  1678, 13083, -3978, -3978, -3978,
    2056, -3978, -3978, -3978, -3978,  1880,  1667,  1667,  1943,  1880,
    1880,  1667,  1880,  1880,  1667,  1880,  1880,  1680, -3978,  2210,
     216, -3978, -3978, -3978,  2470,  1686, -3978, -3978,  1256,  2069,
    1595, -3978, -3978,  1202,  2057,  1993, -3978, -3978,   599, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,  2028, -3978,
    1544, -3978, -3978, -3978, -3978, -3978, -3978,    79, -3978,   166,
    2276, -3978, 14627,  1688,  2035,  2178,  1943, -3978, -3978, -3978,
    1416, -3978, -3978,  1698,  1703,  1706, -3978, -3978,  1707,   -27,
     -27,  1708,  1709,  1711, -3978, -3978,  1712,   -27, -3978, -3978,
   -3978,  1416,  1713, -3978,  1706, -3978,  2302, -3978, 11525, -3978,
   -3978, 17078, -3978, -3978, -3978,  1715,  1719,  1720, -3978, 16920,
   16491, 16920, -3978,   137,  1151, -3978,  2255, -3978, -3978, 17078,
   -3978,   385,  1642, -3978, -3978,   119, -3978,  1740, -3978,   -27,
   -3978,  2311,  -101, -3978, -3978,    96, -3978, -3978, -3978, -3978,
   -3978,  1577, -3978,  -164,  1943,  2314, -3978,   467, -3978,  1866,
   -3978, -3978,  1661,  1642, -3978, -3978,  1577,  2315,  1921,  2400,
   -3978, -3978,  1416,  1768,  1771, -3978, -3978, -3978,  1574, -3978,
    2203, -3978,  1520,  2488, -3978, -3978, -3978, -3978, -3978,  2322,
     100, 11769, -3978, -3978, -3978, -3978,  1662,  1688, -3978, -3978,
   -3978, -3978, -3978,  2203, 10489,  1524,  1528,  2323,   283, -3978,
    1761,  2121, -3978, -3978, -3978,  2328,   101, -3978, -3978, -3978,
   10645, -3978, -3978,  2395,   -28, -3978, -3978, -3978,   321, -3978,
   -3978, -3978, -3978, -3978,  2309, -3978, -3978,  1778, -3978, -3978,
     176, -3978,  1570, -3978, -3978,  1416, 10033,   939, -3978,   970,
   -3978,    41, -3978, -3978, -3978,  1416,  1416, -3978, -3978, -3978,
    1751,  9279,   939,  2329, 12148, -3978,  1772,  2330,  2502, -3978,
    1556, -3978,  1547, -3978, -3978, 13544,  1784, -3978, -3978,  1681,
   -3978, -3978,  2331,   -53,  2335,  -132, -3978,  2244, -3978,  2336,
    1921,  1687,  2337, -3978,  2244,  1416,  2339,  1710, -3978, -3978,
    2258, 17078,  2313, -3978, -3978, -3978, -3978, -3978, -3978,  2118,
   -3978,   321, -3978, -3978, -3978,  1997,  -183, -3978,   130,  2565,
   -3978,   104, -3978,  2347,  1478,  6015, -3978, 16491,  1783, -3978,
    2357,  2217, 12148,  1416,  1416,  2358, 11914,  1570, -3978, -3978,
    -294, -3978, -3978, -3978, -3978,  7895, -3978,  2278, -3978, -3978,
     718, -3978,  2359,  2423, -3978, -3978,  1416, -3978,  2360,  2244,
    1416,  1416, -3978,  1809,  1918,  2177, -3978, -3978,  1974,  1815,
   -3978,  1818, -3978, -3978, -3978,  2480, -3978,  1539,  5589,  1416,
    1416,  1993, -3978,  1993,  1577,  1577,  1993,  1577,  1577,  1416,
    1577,  1577, -3978,  1845, -3978,    97, -3978, -3978, -3978, -3978,
    2307, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978,  1193, -3978,   155, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,    74, -3978,
   -3978, -3978, -3978, -3978, -3978,  1733,  -108, -3978, -3978,   122,
   -3978, -3978,  1972, -3978, -3978, 14627,   217, -3978, -3978,  1616,
   -3978, 14627, -3978, -3978, -3978,  1340,  1841,  9038,    13,  1416,
   -3978,  2481,  4934,   -70,  1838, 16491, 16491, 14697, -3978, -3978,
    1741,  1743, 16491, 16491, 16491, 17078,  1746,  1840, 17078, -3978,
   -3978, -3978, 12259,  2306, -3978, -3978,  1642, -3978, 16491, -3978,
   17078, 16491, -3978, -3978,  1139, -3978,  2260, 16491, 16491, 16491,
   16491, 16491, -3978,  1642, -3978, -3978,  2204, -3978,  2048,  2207,
   -3978, -3978,  9171, -3978,  1416,  -164, -3978, -3978, -3978,   -37,
     977,  1416, -3978, -3978, -3978, -3978, -3978, 16491,  2179, -3978,
    1783, -3978, 16491,  1577, -3978, -3978, -3978, -3978,  1991, -3978,
   -3978, -3978, -3978, -3978, -3978,  -145,  1662, -3978,  1762, -3978,
   12148, -3978, -3978, -3978, -3978, -3978,  2129,  2381, -3978, -3978,
   10489,   354,  6901, -3978,  1160,  1807,  1766,   100,   100,   100,
     100, -3978, -3978, 12148, 12259, -3978,  1552, -3978, -3978,  1233,
   -3978, -3978,  1775, -3978,   262, -3978, -3978,  -202, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, 10839, -3978, -3978, -3978,
    1485, -3978, -3978, -3978,  2221,   -25, -3978,  2444,  1499,  2367,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978,   -71, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,  1993, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
     -71, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, 10033, -3978,   -71,
     -71,   -71,   939, -3978,  1323,   149, -3978, -3978,  2025, -3978,
   -3978,  2435,  2343,  2435,  2286,   115, 16491, -3978, -3978,   -82,
    6536, -3978, -3978,   123, 14040,   939, -3978, -3978,  1881,   321,
   -3978, -3978, 12259, -3978, -3978, -3978, -3978, -3978,  1964,  1943,
   -3978,  1118, -3978,  2334,  2334,  1172,  1893,  1563,  1892, -3978,
     545, -3978, -3978,  1897, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978,  1921, -3978, -3978, -3978, -3978,  2299,  5365, -3978, -3978,
   -3978,  2308, -3978, -3978, -3978,  1991,  2475, -3978, -3978,  1416,
    2475,  1416,  1800,   136,  1903, -3978, -3978,  1642, -3978,  1904,
   -3978, -3978,   942,  1906,  1536, -3978, -3978,  8433, -3978,  2636,
     235,   105, -3978, -3978, -3978,  1616, -3978,   649, 12148, -3978,
   -3978,  1019,    67,  1317, 16491, -3978, -3978, -3978,  1416, 12148,
   -3978,  2520,  2379,  2382, -3978, -3978, 12259, -3978, -3978, -3978,
   -3978, 17078, -3978, -3978, -3978, -3978, -3978,  2645,  2326, -3978,
   -3978, -3978,   422,  2465,  2388,  2465,   -40,   876, -3978,  1917,
    2029,  2080,  1854,  1007, -3978, -3978, -3978, 15114,  1007,  2587,
    1616,   738,   738,  1616,    17,  1813,  1616,  2712, -3978,  2190,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
     111,  1517,  1929, -3978,  7805,  1416, -3978,  1880,  1880,   731,
    1577, -3978,  1577,  1880,  1577,  1577,  1880,  1577,  1577, -3978,
    2587,  1943,  1943,  2103,  1577, -3978, -3978, -3978,  1193, -3978,
   -3978, -3978, -3978,   -27, -3978, -3978,   661, -3978, -3978, -3978,
   -3978,  2297,    83,    83,  -250,  1931,  1614, -3978, -3978, -3978,
   -3978,  2674, -3978, -3978, -3978,  2205, -3978, -3978, -3978, -3978,
    2205,   271, -3978,  1616, -3978, -3978, -3978, -3978, -3978,  1616,
   -3978, -3978,  1616, -3978,  1616, -3978, -3978, -3978, -3978, -3978,
      64, -3978, -3978, -3978,  2644, -3978, -3978, -3978, -3978, -3978,
   -3978,   -16, -3978, -3978, -3978,  2739, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978,  2338,  2013,   276, -3978,  2619,  1288, -3978,
   -3978, -3978, -3978, -3978,  1614, -3978, -3978, -3978,  1833,  1837,
   -3978, 17078,  1614,  2341,  1998,  1999,  2218, -3978, -3978, -3978,
   -3978, -3978,  2271, -3978, -3978, -3978, -3978, -3978,  1943,  1943,
   -3978,   768, -3978,  1416,   112,  1311,  1949,   267,  1952, -3978,
     303,   700, 17078, -3978, -3978,   416,  1953,  1954,  1956,   460,
   -3978,  1642, -3978,  1959, -3978,  1416,   478,  1960,  1943,  2437,
     295, -3978,    44,   -74,   321,  1396,  1965,   483, -3978,  1981,
    2204,  1151,  1151, -3978, -3978, -3978,  1993,  2120,  1985,   119,
   -3978, -3978,   895,  2761,   641, -3978, -3978,  2119,  2145, -3978,
    1260,  1616, -3978, -3978,   598, -3978,  1942,     0, -3978, -3978,
   -3978,  2383, -3978, -3978, 12148, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978,     1, -3978, -3978,  6024, -3978, -3978,  5112,   -82,
   -3978, -3978, -3978, -3978,   840, -3978,  1616, -3978,   359,   -82,
   -3978, -3978, -3978, -3978,   -13,  1616, -3978, -3978, -3978,  6901,
   -3978, -3978,  1160, -3978, -3978,  1642,  1416, -3978, -3978, -3978,
   -3978, -3978, -3978,  2451,   295,  2453,  2352,  1926, -3978,  4734,
    2235, -3978, -3978, -3978, -3978, -3978, -3978,  1885,  1485, -3978,
   -3978, -3978, -3978, -3978,  1667, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978,   143, -3978,  1880, -3978, -3978, -3978,
    2560, -3978,  1667, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
    2152,  1667, -3978, -3978, -3978,  1416, -3978, -3978,  1416, -3978,
    1416,  1416,  1416, -3978,  2000, -3978, -3978,  1642, -3978,  2730,
   -3978, -3978, -3978,  1404, -3978,  1323,  5001, -3978, -3978, -3978,
    1416, -3978,  1416,   103,   324,  2590, -3978, -3978,   814, -3978,
   -3978, -3978, -3978, 12148, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978,   321,   321,   295,
    2468,  1800,  1991,  1563,  2433, 13599,   -33,  5232,  1416,   119,
    2005, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,   422,
    2308,  1416, -3978, -3978, -3978, -3978,  1416,   975,   570, -3978,
    1922, -3978,  1923, -3978,   422,    73, 17078,  2268,  1299,   289,
   -3978,   768,  2270, -3978, -3978, -3978, 12148,  1536,  1536,  1536,
    1536,  1536,  1536,  1536,  1536,   235, -3978,   774,     0,   -67,
   -3978,  2064,  2064, -3978, -3978, -3978, 16491, 16171,  1317,  -199,
   -3978,  2645, -3978,  1416,  1416,   295,  2476,  1993,  2017, -3978,
    2814,  1416,   864, -3978, -3978,  1991,  2819, -3978, -3978,  1416,
   -3978,  2159,  2599, -3978, -3978, -3978,  2022,  2130,  2140,  1173,
   -3978,  1958, -3978,  2490,  1416,   -48, -3978, -3978,  -336,  -327,
     608,   616,   881, -3978,  1944, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978,  2801, -3978,  2162,  1416, -3978,  1157, -3978,  2394, -3978,
   -3978,  1416,  2818,  2450, -3978, -3978, -3978,  -144,  1667, -3978,
   -3978, -3978,  1616, -3978, -3978, 15500, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
    1086,  -106,   292,  2503, -3978,  1993,  1595,  1173,  1173,  1950,
    -184,   851,  1993,  1970,  1616, -3978, -3978, -3978,   -93,  1871,
   -3978, -3978, -3978, -3978,  1813,  2341,  1921,  1667, -3978, -3978,
   -3978,  2138,  2341,  1616,  2756,   364,   -42,   -43,  1800, -3978,
   -3978, -3978,  1616,  1616, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978,  2104, -3978,  2407, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,  2147,  2815,
    1173, -3978,  1577,  1577, -3978, -3978,  1880, -3978,  1577,  1577,
    1577,   613,  1577, -3978,  1577,  1193, -3978,  1733,  1616,  1616,
    1966, -3978,   174, -3978,  -331,  -285,   390, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978,  1742,  1416,   182, -3978, -3978,
   -3978,   217,   217, -3978, -3978, -3978, -3978,   217,   217,   271,
     217, -3978, -3978, -3978,  1616,   814, -3978,   814, -3978,   271,
    2433,  1616,  2060,   773,  2421,  2421, -3978, -3978, -3978,  1614,
   -3978, -3978, -3978, -3978, -3978, -3978,   188, -3978,  1577,  1577,
   -3978, -3978, -3978,  1866, 15246,  1715, 16365,  1715, -3978,  2063,
   -3978, -3978,  1416,  1715,  1715,  1715, 17078, -3978,  1866,   744,
    1715,   -70, -3978, -3978, -3978,  2340,  2136,    46,  2527,   295,
   16427,  1715,  1715,   522, -3978,  2120, -3978,   321, -3978, -3978,
   -3978,  2334, -3978, -3978, -3978, -3978, -3978,  2368, -3978, -3978,
   -3978,   666, -3978, -3978, 16491, -3978, -3978, -3978, -3978,  2344,
    2478,   869,  1807,  1061, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978,   217, -3978, -3978,   217, -3978, -3978,
   -3978, -3978,   842,  2648,   217,   814,   814,   217, -3978, -3978,
   -3978,  3309,  3309,   321, -3978,   321, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978,  2864, -3978,  2087,    -7,  4734, -3978,
   -3978, -3978, -3978, -3978,  1416, -3978, -3978, -3978,  2657,  2008,
    1278,   339,  2010, -3978, -3978, -3978, -3978, -3978,   522, 17078,
   -3978, -3978,  2811, -3978,  1659, -3978, -3978,  5001, -3978,  1659,
    2563,  2564,  2734,     8, -3978, -3978,  2181, -3978, -3978,  2341,
    1014, -3978, -3978, -3978, 12148,   321, -3978,   321,   312,  1577,
   -3978,  1416, -3978, -3978,   -22, -3978, -3978, -3978,  2889, -3978,
    2562, -3978, -3978, -3978,   146,   110, -3978, -3978, -3978, -3978,
    2371,  2670,     0, -3978,   -31, -3978, -3978,  5744, -3978,  1923,
    2251, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, 12148, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978,   -10, -3978,  1416, -3978, -3978, -3978,
    1540, -3978, -3978, -3978, 16491, -3978, 12148, 12148,  1311, -3978,
    1432,  -221,  2324, 12003,  1866,  1866, -3978,   321,  2097, -3978,
     522, -3978,  2353, -3978, 17078, -3978,  2713,  2127, -3978,   570,
   -3978,  1002,  2734,  2425,  2038, 17078,  2830,   876, -3978,  2109,
    2219, -3978,  2892,  1616, -3978,  2123, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
    2004,  3791, -3978, -3978,  2102, -3978,  2843,  2086,  2126,    61,
   -3978, -3978, -3978,  1416, -3978, -3978, -3978, -3978,  2031,  4144,
   -3978,  2902, -3978,  2645, -3978,  2170,  2223,  2223,  2037, -3978,
    2892, -3978,  2137,  2613, -3978, -3978, -3978,  1950, -3978, -3978,
   -3978, -3978, -3978, -3978,  2500,    72,  2433,   480,  1616, -3978,
   -3978,  1616, -3978,  1616,  1616,  2341,  1194, -3978,  1616,  1449,
    1616,  1616,  1616,  1616, -3978,  1844, -3978,   312,   851,  1993,
    1616,  1813,  2399, -3978,  2229,   851,  1577,  1577,  1577,  1577,
    1577,  1577, -3978,  2361, -3978, -3978,  2930, -3978, -3978, -3978,
   -3978, -3978, -3978,  1616,  2220,  2398, -3978, -3978, -3978,  2764,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978,   869, -3978,  1203, -3978, -3978,
    1416,   289, -3978, -3978,  2148, -3978, -3978, -3978,  1616,   256,
   -3978, -3978, -3978, -3978,   810, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978,  2620, -3978, -3978, -3978,  2611,
   -3978, -3978, -3978, -3978, -3978, -3978,  2614, -3978, -3978,  1446,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978,  1552,  2753, -3978,
    1286, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,   -82,
     -82,   -82,   -82, 12148, -3978,  1061, -3978,  7280, -3978, -3978,
   -3978, -3978,  1943, -3978, -3978, -3978, -3978, -3978, -3978,  1648,
     217,  2470, -3978, -3978, -3978, 14787, -3978, -3978, -3978,   117,
   -3978, -3978, -3978, -3978,  6295, 14787,   295,  2317,   295,  2318,
      93,  4734, -3978, -3978, -3978, -3978, -3978,  2864, -3978, -3978,
   -3978, -3978,  1278, -3978,  2781, -3978, -3978,  1667, -3978,  1659,
   -3978, -3978,  1659,   522,  2151,  2151, -3978,  2954,  2920, -3978,
   -3978, -3978,  2433, -3978,  2483,  2771,  -121, -3978, -3978,  2415,
   -3978, -3978,   295,  2414,  2414,  2422, -3978,   221, -3978,  2728,
   -3978, -3978, -3978,  1416, 12148,  1880,  2521,  2566, -3978,   904,
   -3978, -3978, -3978,  -104, -3978, -3978, -3978,  2798,  2469, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978,  2525, -3978, -3978, -3978,
    2542, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,  1311,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978,  2447,  2164,  1616,
   -3978, -3978, -3978,   810,  2620,   295,  2116, -3978, -3978,  2814,
   -3978,  2433,  2734,  2433,  -221,  1566, -3978, -3978,  1717, -3978,
   -3978,  1800,  2384, -3978,   111, -3978,   876, -3978,   876, -3978,
    2180, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
    2196, -3978,  2892, -3978,  2837,  1416, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978,   373, -3978, -3978,  2547, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978,  2549, -3978, -3978,  2433,  2661,  2197,  1993,
    2197,  2266,  2098, -3978, -3978, -3978, -3978, -3978, -3978,  2556,
   -3978,   869,   170, -3978, -3978,  2756, -3978, -3978, -3978,  2892,
    1993,   199,  1416, -3978, -3978, -3978, -3978,  1993, -3978,  1660,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,   882,   882,
     511,  1416,  1616, -3978, -3978,  3164, -3978,  1416, -3978, -3978,
     851, -3978,  1416,  1416, -3978, -3978, -3978, -3978,  2903,   731,
    1416,  1616,  1416,  -108, -3978,   851,  2212,  1577, -3978,  1993,
   -3978,  1193,  1076,   326,  1164,  1616, -3978, -3978,  2101,  2201,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,   289,
   -3978, -3978,  2624,  2816, -3978,  1926, -3978, -3978, -3978,  3309,
   12148, 12148, 12148, 12148, -3978, -3978, -3978, -3978, -3978,  1416,
   -3978,   -82, -3978, -3978, -3978, -3978,  2214,  -262, -3978, -3978,
     321, -3978,   321,  4529, -3978,   989,    29, -3978, -3978, -3978,
   -3978, -3978,  2937,  2828, -3978, -3978,  1659, -3978, 12148, 12148,
   -3978, -3978,  1416,  2483,  1943,  2246, -3978,  2419,  1577,  1006,
    1416, -3978, -3978, -3978, -3978, -3978, -3978,   116, -3978, -3978,
   -3978, -3978, -3978,  2518, -3978,  -181, -3978, -3978,  2519,  1184,
   -3978, -3978, -3978,  2949,  2571, -3978,  1616,  1098, -3978, -3978,
     688,  2572,  2574, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978,  1416, -3978,  2816, -3978, -3978, -3978,  2224, -3978,  1416,
   -3978,  1416, -3978, -3978, -3978, -3978, -3978,  2501,  2760, -3978,
   -3978, -3978, -3978,    75,  1038,  2431, -3978, -3978, -3978, -3978,
   -3978,   147,  -397, -3978, -3978,  1943, -3978, -3978,  2892, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978,  2228,  2134,  1993,  2233, -3978,  2845, -3978,  2847,  1616,
   -3978, -3978, -3978, -3978,  2288, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978,  1416,   114,  2903,  1360, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978,  1416, -3978, -3978,
   -3978, -3978,  2709, -3978, -3978, -3978, -3978,  3044, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978,   610,   728, -3978, -3978, -3978,
   -3978, -3978,    88,   894, -3978, -3978, -3978,  1416,  1133,  1616,
   -3978,   665,  1595,  2254,   851, -3978, -3978,  2567,  3036, -3978,
   -3978, -3978,  1131,  -196, -3978, -3978, -3978, -3978,   289,  2624,
     810,   -28, 14787, -3978, -3978, -3978, -3978, -3978,  1416,   -82,
   -3978, -3978,   810,   810, -3978, -3978, 12148, -3978, -3978, -3978,
   -3978, 12148, -3978, -3978, -3978, -3978, -3978,  2246,  1416,  1416,
     945,  1616,  1577,  1577,  2456, -3978, -3978, -3978,  2493, -3978,
   -3978, -3978, -3978, -3978, -3978,  2386, -3978, -3978, -3978, -3978,
    5536,  2208, -3978,  1416, -3978, -3978,  2371,  2670, -3978, -3978,
   -3978, -3978,   810,  1572, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978,  2576,    75, -3978,    99,  2166, -3978, -3978,
    1616, -3978,  2442,  -118, -3978,  2354, -3978,  2259,  1416, -3978,
   -3978, -3978, -3978,  1993,  2684,  1880,  1880,  1519,  1993, -3978,
     851,   851, -3978, -3978, -3978, -3978,  2749, -3978, -3978,  2137,
    1993,   894,  1416,  1680, -3978, -3978, -3978, -3978,  1416, -3978,
   -3978, -3978, -3978, -3978,  1616, -3978,  2507, -3978, -3978, -3978,
    -296,  -194,  -296, -3978,  1595,  1616,  1616,  1595,   851, -3978,
    1616,  1616, -3978, -3978,  2606, -3978,   197,  2281,   289, -3978,
     269,   128, -3978, 12148, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978,  1416, -3978,  1616,  1416, -3978, -3978, -3978, -3978,
   -3978,  2550,  2805,   119,  1577,  1616, -3978, -3978, -3978, 17078,
   -3978, -3978, -3978, -3978,  5744, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978,  1859, -3978, -3978, -3978,
    1589, -3978,  1681,  2484,  2897,  1616,  2483, -3978, -3978, 17078,
   -3978, -3978, -3978,   119,    -2,  1570, -3978, 12921, -3978, -3978,
    -118,  2283,  2290,  1616, -3978, -3978,  1519,  1416,  1416,  2645,
   -3978,  2707, -3978,   324,  2341,   341, -3978, -3978, -3978,  3062,
    2903, -3978,    92, -3978, -3978, -3978, -3978, -3978,    92, -3978,
    1416,  1416,   -65, -3978, -3978,  2417, -3978,  2633, -3978, -3978,
    1595,  1595, -3978, -3978, -3978, -3978,  2366,   257,   289, -3978,
   -3978, -3978, -3978, -3978,  2573,   -36,  1943, -3978, -3978, -3978,
   -3978, -3978,  1416, -3978,   945, -3978,   212, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978,   119, -3978,  1642, -3978, -3978,
    2454,  2363, -3978,  2293,    14,  1880, 17078,  2274, -3978, -3978,
   -3978, -3978,  -192, -3978,  2301,  1541,  2310, -3978, -3978,   147,
   -3978,  1519, -3978, -3978, -3978, -3978,  1616,   324,   851,  2921,
    2507,   145,  1616, -3978, -3978, -3978, -3978, -3978,  2568, -3978,
   -3978,  1076,   326, -3978, -3978,  1616,  2929, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978,  1416, -3978, -3978, -3978, -3978,
    1416, -3978,  1769,  1577,  2316, -3978, -3978, -3978,   139,  2632,
    1943,  2348,  1036,   427,  1395,   151, -3978, -3978,  2602, -3978,
   -3978, -3978,  1966, -3978, -3978, -3978, -3978, -3978,  1880, -3978,
    2351, -3978,  2910,  1416,  1327,  2641,  3116,   271,  2327, -3978,
   -3978, -3978, -3978,  2532, -3978,  1577,  1257,   139, -3978, -3978,
    1616, -3978,  1416,   250, -3978, -3978, -3978, -3978,  2603,  2856,
      55,  2731,  2732,  2942,  2714, -3978,   427, -3978,  1349,   394,
    2345,  1024, 15714,   814, -3978, -3978, -3978,  1966, -3978,  1416,
    2249, -3978, -3978, -3978,  1407, -3978, -3978,   624,  1616,  1616,
   -3978, -3978, -3978,  1880, -3978, -3978, -3978,  2600,  1416, -3978,
   17078,  1416, -3978,  1616,  1190,   -87,   250, -3978, -3978,  1036,
   -3978, -3978, -3978, -3978, -3978, -3978,  1616,  2604,  1416,  1616,
    1616,  1616,  1616, -3978,  2736,     7,  2741, -3978,  2723, -3978,
    1747, -3978, -3978,  1416,  2993,  1355,  2744,    21,  2746,  2733,
   -3978,  1000, -3978, -3978,  1416,  2373, -3978,  1173,  1173,  1542,
   -3978, -3978, -3978, -3978,  2817,  3050,   -97, -3978,  1616, -3978,
   -3978, -3978, -3978,   -96, -3978,  2205,  2205,  1616,   -82,   359,
    1616,  5365, -3978, -3978, -3978, -3978,  2205,   -82, -3978,  2941,
    1993, -3978,  3065, -3978, -3978,   -82, -3978, -3978,  1416, -3978,
   -3978,  1416, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978,  2823,  2205, -3978, -3978, -3978,  6536, -3978,
   -3978,   106,   624, -3978, -3978,  1595,  1595,   -54, -3978, -3978,
   -3978, -3978,  1406, -3978, -3978, -3978,  1406,  1406, -3978, -3978,
   -3978, -3978, -3978, -3978,  2615, -3978, -3978, -3978,  1416,  1993,
   -3978,  1416,  1416,  1416,  1416,  1616,  1616,  1616,  1616,  1616,
   -3978,  1416,  1616,  1616,  1616,  1616,  1616,  1616,  1616,  1616,
    1616,  1616,  1616, -3978,  1416,  1616, -3978, -3978,  1173,  1173,
     534,  2743, -3978,  1616, -3978, -3978,  1416,  1416, -3978, -3978,
     217, -3978, -3978, -3978,  1616, -3978,  1616,   217,   814, -3978,
   -3978,   217, -3978, -3978,   217,  2197,  1616,   814, -3978, -3978,
   -3978, -3978, -3978,  6536,  1544, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978,  1577, -3978, -3978, -3978,
   -3978,   -87, -3978,  2197, -3978, -3978, -3978, -3978,  1416,  1416,
    1416,  1416,  1416,  1416,  1416,  1416,  1416,  1416,  1416,  1416,
    1416,  1416,  1416,  1416,  1416,  1416,  1416, -3978, -3978, -3978,
   -3978, -3978,  1429, -3978, -3978, -3978, 13422, -3978,   869,  1416,
   -3978, -3978,  1231,  1231, -3978, -3978, -3978, -3978, -3978,   204,
   -3978,   869, -3978, -3978, 16347, -3978, -3978,  2707, -3978, -3978,
   -3978, -3978, -3978,  1416, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978,  1416, -3978,  1621,   752,   818,
   -3978, -3978,   534,  2364, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978,   217, -3978, -3978,   217, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978,  1416,  1416,   244,  1616,
    1616,  1799,  1616, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
    1729, -3978, -3978, -3978, -3978,  1416, -3978, -3978, -3978,  1616,
     534,   534, -3978,  2821,  1616,  1616,   534, 14455,  1416,   534,
   -3978, -3978, -3978,   534,   534, -3978, -3978, -3978, -3978,  2799,
    1535,  2712,  1616,  1993, -3978,  1616,  1943, -3978,  -105,  1416,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978,   175, -3978, -3978,   897, -3978,   889, -3978,
   -3978, -3978, -3978,  1535,  1416, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978,  1173, -3978,  1514,  2233, 16975, 16975,  1907,  2849,
    2691,  2691,  1867,  5744, -3978, -3978,   897,  -173, -3978, -3978,
   -3978,  1993,  -173, -3978,   179,  1416, -3978, -3978, -3978, -3978,
   -3978, -3978,  1993, -3978,  2197,  1866, 16726, -3978, -3978,  1462,
    1620, -3978, -3978,  1640, -3978, -3978, -3978, -3978,   986,   986,
   -3978, -3978, -3978, -3978, 16975, -3978,   855,   855,  2691,  2691,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,  1173, -3978,
    1416, -3978,  2847, -3978,  1880,  1416, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978,   -90,   142,  3117, -3978, -3978,
   -3978,   855, -3978, -3978,  2626,  2627, -3978, -3978,  2436,   -77,
   -3978,  2642, -3978,  2642, -3978,  2642, -3978,  2642, 16975, -3978,
   -3978, -3978,  1993, -3978, -3978, -3978, -3978,  2631, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
       2,     0,    12,     1,     3,     5,    27,     4,    53,    31,
      30,    27,     8,    10,    11,     0,    28,     0,     0,    13,
      76,     9,    35,    32,    53,    53,     0,    56,     0,    24,
      79,     0,     0,    16,     0,    29,  3009,    54,    62,     0,
     430,     0,   245,    81,     0,     0,    20,    14,    17,    18,
      22,    15,  3010,     0,     0,    64,    77,     0,    25,   433,
     431,     0,     0,    75,   247,     0,     0,     0,  3076,  3009,
    3009,  3009,     0,     0,     0,     0,  3009,     0,     0,  2971,
     242,   159,    78,    82,    83,    85,    86,    89,    87,    88,
       0,   142,   145,   146,   147,   208,   148,   150,   149,   151,
     152,   153,   154,   155,   156,   157,   158,    38,    37,    41,
      41,     0,    19,     0,    58,    59,    60,    61,    57,  3040,
    3009,    69,     0,  1336,     0,   435,    80,     0,     0,   249,
    2644,  2643,   170,   227,  3009,  3077,  3009,     0,     0,     0,
    3009,  3009,    96,   126,     0,    90,   140,  2972,     0,     0,
    3009,  3009,    84,   144,   141,   143,     0,   207,     0,     0,
      33,    40,    39,     0,     0,  3041,  3009,     0,     0,     0,
     432,     0,    26,  1331,  1384,     0,   428,   246,   248,   387,
     176,  2990,  3009,     0,     0,     0,  2750,   238,  2632,   236,
     241,     0,     0,    98,   128,   240,    92,   574,   218,   219,
    3009,  2645,   210,   211,  3014,   214,     0,  2759,  2187,  2186,
     160,   164,   167,  3055,  3009,     0,   209,    42,    36,  3009,
      21,    23,     0,    66,    68,    67,    65,  3009,    55,  1332,
       0,     0,   434,   441,   442,   555,   436,   558,     0,     0,
    2847,   250,   244,   390,   171,   172,   174,     0,     0,   228,
     229,   239,   234,  3128,  3129,     0,   232,     0,  2970,  3083,
    3066,  3009,   124,    97,  3065,   102,   104,   105,   106,   107,
    3065,     0,  2973,     0,     0,   127,     0,   131,    91,    94,
     220,     0,   212,  3016,  3015,   215,     0,   243,  3055,  3058,
    3057,     0,     0,   161,   165,     0,     0,  2854,  2855,  2856,
    2857,  2858,  2859,  2860,  2861,    63,     0,  1598,     0,  1452,
    1563,  1573,  1581,  1588,  1644,  1650,  1670,  1665,  1671,  1680,
    1676,  1688,  1698,  1827,  1836,  1838,  1844,  1877,  1888,  1891,
    1894,  1886,  1901,  1912,  1934,  1938,  1942,     0,  1998,  2000,
    2006,  2010,     0,  2016,  2050,  2077,  2079,  2084,  2114,  2115,
    2131,  2134,  2135,  2140,  2149,  2150,  2163,  2176,  2215,  2233,
       0,  2270,  2286,  2295,  2297,  1366,  2301,  2304,  2307,  2324,
    2363,     0,  1386,  1387,  1388,  1389,  1390,  1391,  1392,  1393,
    1395,  1394,  1396,  1398,  1397,  1399,  1400,  1401,  1402,  1403,
    1404,  1405,  1406,  1407,  1408,  1409,  1410,  1411,  1412,  1413,
    1414,  1415,  1416,  1417,  1418,  1419,  1420,  1421,  1422,  1423,
    1424,  1425,  1426,  1427,  1428,  1429,  1430,  1431,  1432,  1433,
    1434,  1435,  1436,  1437,  1438,  1439,  1440,  1441,  1442,  1443,
    1444,  1445,  1446,  1447,  1448,  1449,  1385,     0,   502,   437,
    2830,     0,  2614,   438,   389,     0,  2848,     0,     0,   417,
    3050,   400,   388,     0,   393,   395,   396,   408,   397,   398,
    3009,  3009,   177,   178,  2768,  2764,  2769,  2767,  2765,  2770,
    2766,   230,   223,   225,  3108,   233,     0,  2751,   237,  3084,
    3009,     0,   101,   103,    99,   125,  3065,  3009,  2974,   109,
       0,     0,   138,    41,     0,    41,     0,   129,   132,     0,
       0,     0,  2779,  2775,  2780,  2778,  2776,  2781,  2777,   221,
    2771,  2773,  2760,   213,   216,     0,  3056,   168,   162,   163,
     166,    34,    45,    48,    52,    51,  3065,    46,    47,    71,
      72,    73,    74,    70,  1602,  1605,  1604,  1600,  1601,  1603,
    1592,  1599,  2872,  2873,  2874,  2875,  2876,  2877,  2878,  2879,
    2880,  2881,  2882,  2883,  2884,  2870,  2923,  2924,  2925,  2926,
    2927,  2928,  2929,  2930,  2931,  2932,  2933,  2934,  2935,  2936,
    2937,  2938,  2939,  2940,  2941,  2942,  2943,  2944,  2945,  2885,
    2886,  2887,  2888,  2889,  2890,  2891,  2892,  2893,  2894,  2896,
    2895,  2897,  2898,  2899,  2900,  2901,  2902,  2903,  2904,  2905,
    2906,  2907,  2908,  2909,  2910,  2911,  2912,  2913,  2914,  2915,
    2916,  2917,  2868,  2918,  2919,  2920,  2921,  2922,  1451,  2869,
    2871,  1483,     0,     0,     0,  1598,     0,     0,     0,  1673,
       0,     0,  1693,  1739,     0,  1693,     0,  1598,  2536,  1879,
       0,     0,  3099,  1629,  1628,     0,  1900,     0,     0,     0,
       0,     0,  1981,  1993,     0,     0,     0,     0,  1450,  2021,
    2523,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2266,  2269,  2253,  2267,  2528,  2268,  2255,
    2264,  2256,  2265,  2736,  2740,  2273,     0,  2296,  2294,     0,
    1384,     0,     0,     0,     0,     0,  2379,  2425,     0,     0,
     805,     0,     0,     0,   560,     0,     0,   564,   565,   563,
       0,   440,   443,  2849,   251,  3050,  3099,  3099,  3048,  3050,
    3050,  3099,  3050,  3050,  3099,  3050,  3050,  2987,  3051,  2985,
       0,   401,   402,   403,  2952,     0,   391,   394,     0,     0,
       0,   224,   222,     0,     0,     0,   118,   100,  2752,   110,
     133,   134,   137,   139,   135,   136,   130,    93,     0,  2772,
       0,   217,   169,    50,    44,    49,  1593,  1338,  1482,  2750,
    1561,  1454,  1493,     0,  3038,  1481,  3048,  2806,  2804,  2807,
       0,  2800,  2808,     0,     0,  2814,  3145,  3146,     0,  2597,
    2599,     0,     0,     0,  2803,  2669,     0,  2601,  2805,  2809,
    2810,     0,     0,  2802,  2814,  2801,  1571,  2661,  1569,  2653,
    2656,     0,  2655,  2659,  2660,  2811,     0,     0,  2670,     0,
       0,     0,  1574,     0,  2586,  2589,  2591,  2594,  2679,     0,
    2596,  2836,  2677,  2678,  2629,  1582,  1583,     0,  2625,  2627,
    2626,  1642,  2523,  2708,  1649,  1645,  1646,  1648,  2707,  1661,
    1651,  1652,  1653,  1656,  3048,  1668,  2744,     0,  2603,  2850,
    2648,  2743,  2748,  2649,  1674,  1672,     0,  1686,  3069,  2977,
    1677,  2741,  1679,  3093,     0,  1695,  1697,  1689,     0,  1736,
    1770,  1769,  2775,  2965,  1718,  1768,  1761,  1767,  1760,  1825,
    2450,  2651,  1713,  1715,  1705,  1706,  1719,     0,  1707,  1708,
    1757,  1709,  1710,  1770,  1712,     0,  2655,  1834,     0,  1837,
       0,     0,  1839,  1851,  1850,  1875,     0,  1847,  1849,  2535,
    3009,  1881,  1885,  1883,  1886,  1884,  1878,  1889,  1890,  2646,
    1892,  1893,  3100,  1895,  2623,  1887,  2534,  1906,  2533,  1913,
    1915,  2616,  1935,  1936,  1027,  1776,     0,     0,  1939,  1026,
    1943,     0,  1945,  1946,  1947,     0,     0,  1999,  2219,  2728,
    2729,  2845,     0,  2004,     0,  2007,     0,  2014,     0,  2022,
    2017,  2018,     0,  2994,  2051,  2063,     0,  2615,  2078,     0,
    2080,  2082,  2112,  2842,  2129,     0,  2132,  2366,  2606,  2138,
    3069,     0,  2147,  2607,  2366,     0,  2161,  2154,  2609,  2164,
    2167,     0,     0,  2619,  2177,  2178,  2179,  2180,  2181,  2182,
    2206,  2183,  2209,  2184,  2185,     0,     0,  2617,     0,     0,
    2727,  2748,  2216,  2251,  2238,  2257,  2527,     0,  2738,  2739,
    2284,     0,     0,     0,     0,  2292,     0,  2298,  2299,  1372,
    1378,  1367,  1368,  1369,  1371,     0,  2302,     0,  2731,  2305,
    3071,  2710,  2322,  2310,  2709,  2711,  2325,  2326,  2377,  2366,
       0,     0,   556,     0,     0,   808,   607,   610,     0,     0,
     561,     0,   571,   572,   566,   573,   569,  3009,     0,     0,
       0,     0,  3049,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2988,  3091,  2986,     0,   307,   425,   308,  2953,
    2989,   392,   183,   182,   203,   199,  2752,   204,   188,   202,
     200,   180,   181,   201,   173,   179,   190,   191,   193,   185,
     186,   187,   175,   184,   331,   231,   226,   235,     0,   121,
     123,   122,   119,   120,  2637,     0,  2989,    95,  2774,     0,
    1341,  1339,  1360,  1562,  1453,  1493,  2960,  2962,  1498,  3009,
    1479,  1494,  1495,  1497,  1499,     0,     0,  2979,     0,     0,
    3039,     0,     0,     0,     0,     0,     0,     0,  2798,  2820,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2799,
    1572,  1564,     0,     0,  2654,  2662,  2663,  2664,     0,  2786,
       0,     0,  2593,  2676,     0,  2592,  2838,     0,     0,     0,
       0,     0,  2680,  2681,  2682,  2837,  1577,  1584,  1586,     0,
    1643,  1589,  1608,  1647,     0,  1656,  3141,  3142,  1654,     0,
    1657,     0,  1669,  1666,  3123,  3122,  2604,     0,  2852,  2605,
    2746,  2747,     0,  1683,  1684,  1687,  1681,  3070,  2097,  2978,
    1678,  2742,  3094,  1694,  1696,  1691,  1719,  1771,     0,  2966,
       0,  1826,  1699,  1381,  1381,  1704,  2456,  2453,  1714,  1711,
    2652,  3107,     0,  1738,     0,  1772,     0,  2450,  2450,  2450,
    2450,  1835,  1828,     0,     0,  1840,  1592,  1876,  1845,  2536,
    1862,  1846,  1853,  1854,  1381,  2552,  2550,  3010,  2556,  2553,
    2545,  2549,  2547,  2548,  2544,  2546,  2537,  2538,  2551,  2540,
       0,  1882,  1880,  2647,     0,  1898,  1907,  1908,  1917,     0,
    1937,  1775,  1107,  1136,  1104,  1186,  1121,  1120,  1185,  1187,
    1209,  1188,  1172,  1255,  1289,  1205,  1234,  1208,  1231,  1277,
    1180,  1203,  1199,  1206,  1229,  1275,  1106,  1109,  1216,  1213,
    1105,  1212,  1211,  1261,  1133,  1215,  1134,  1290,  1138,  1198,
    1227,  1224,  1251,  1242,  1279,  1078,  1252,  1262,  1225,  1160,
    1162,  1161,  1228,  1263,  1264,  1265,  1266,  1124,  1125,  1254,
    1217,  1219,  1218,  1223,  1158,  1239,  1132,  1241,  1248,  1249,
    1140,  1142,  1253,  1145,  1084,  1237,  2995,  1183,  1159,  1131,
    1101,  1260,  1100,  1103,  1102,  1258,  1250,  1226,  1210,  1271,
    1246,  1247,  1182,  1268,  1269,  1270,  1259,  1274,     0,  1135,
    1236,  1232,  1235,  1267,  1222,  1233,  1141,  1174,  1204,  1200,
    1196,  1207,  1230,  1272,  1273,  1240,  1143,  1144,  1108,  1276,
    1137,  1181,  1139,  1220,  1221,  1257,  1173,  1175,  1077,  1146,
    1163,  1184,  1256,  1288,  1214,  1197,  1238,  1179,  1202,  1201,
    2995,  1037,  1052,  1053,  1054,  1055,  1056,  1057,  1058,  1059,
    1060,  1061,  1062,  1063,  1064,  1065,  1066,  1940,  1294,  2995,
    2995,  2995,  1941,  1298,     0,  1968,  1952,  1944,  1949,  1950,
    1951,  1991,     0,  1991,     0,  2223,     0,  2730,  2846,  3011,
    2002,  1030,  1032,  3017,     0,  2003,  2005,  2001,     0,     0,
    2015,  2011,     0,  2019,  2026,  2023,  2025,  2024,  2027,  3048,
    2065,  2629,  2713,  2525,  2525,     0,  2061,     0,     0,  2712,
    2626,   577,  2714,     0,  2524,  2083,  2081,  2113,  2085,  2843,
    2844,  3069,  2130,  2116,  2118,  2119,     0,     0,  2133,  2139,
    2136,  2087,  2608,  2148,  2141,  2097,  2156,  2162,  2151,     0,
    2156,     0,  3107,  2165,     0,  2696,  2702,  2703,  2704,     0,
    2207,  2210,     0,     0,     0,  2618,  2189,     0,  2188,     0,
       0,  2746,  2252,  2234,  2240,  3009,  2241,  2236,     0,  2254,
    2259,     0,  2581,  2579,     0,  2737,  2285,  2271,     0,  2274,
    2275,  2278,     0,     0,  2293,  2287,     0,  2300,  1373,  1377,
    1370,     0,  3072,  3073,  2306,  2323,  2308,  2967,     0,  2327,
    2378,  2364,  2368,  2423,     0,  2423,  2429,   558,   503,     0,
       0,   811,     0,   666,  2830,   562,   568,  3009,   575,  2975,
    3009,     0,     0,  3009,  2975,  3040,  3009,  2950,   439,     0,
     444,   447,   448,   449,   450,   451,   452,   453,   454,   455,
       0,     0,     0,   252,  3069,   404,  2630,  3050,  3050,     0,
     412,  2610,   405,  3050,   406,   414,  3050,   407,   416,  3092,
    2975,  3048,  3048,     0,     0,   189,   192,   195,     0,  3136,
    3138,  3137,   108,  2754,  2753,   111,     0,  2752,  1596,  1597,
    1595,     0,  1346,  1346,     0,     0,  2437,  2717,  1510,  2715,
    2716,     0,  1496,  3119,  3118,  3044,  3121,  3120,  1508,  1509,
    3044,     0,  1514,  3009,  1528,  1529,  1530,  1516,  1518,  3009,
    2980,  1519,  3009,  1560,  3009,  1521,  1524,  1522,  1523,  1525,
       0,  1554,  1555,  1532,  1534,  3068,  1535,  1558,  1556,  1557,
    1526,  3101,  1537,  1527,  1515,  2948,  1539,  1559,  1542,  1500,
    1531,  1536,  1541,     0,     0,     0,  2689,     0,  1488,  1492,
    1491,  1484,  1480,  1475,  2437,  3115,  3114,  1472,  1463,  1465,
    1466,     0,  2437,  3024,     0,     0,     0,  1506,  1456,  1461,
    1460,  1470,     0,  1478,  1458,  1477,  1459,  2693,  3048,  3048,
    2692,     0,  2666,     0,  2581,  2579,     0,  2581,     0,  2816,
    2581,     0,     0,  2598,  2600,  2581,     0,     0,     0,  2581,
    2673,  2674,  2675,     0,  2602,     0,  2581,     0,  3048,  2744,
    2477,  1570,  2748,  2649,     0,     0,     0,  2581,  2595,  2840,
    1577,  2585,  2584,  2588,  2587,  2590,     0,  1579,     0,     0,
    2628,  1590,     0,  1606,  1663,  1655,  1660,     0,     0,  2650,
    2477,  3009,  2851,  2745,     0,  1685,  2989,  2513,  2098,  2099,
    1690,     0,  1737,  1762,  1746,  2455,  1382,  2458,  2451,  2457,
    2452,  2454,     0,  1728,  1727,  1716,  1723,  1725,     0,  3011,
    1813,  1814,  1815,  1802,     0,  1805,  3009,  1806,  2983,  3011,
    1809,  1810,  1816,  1811,  3101,  3009,  1812,  1819,  1817,  1720,
    1721,  1745,  1740,  1741,  1743,  1744,     0,  1758,  1765,  1702,
    1703,  1700,  1701,     0,  2477,     0,     0,  1612,  1848,     0,
    1862,  1855,  1852,  1857,  1858,  1864,  1856,     0,  2555,  2539,
    2566,  2567,  2568,  2557,  3099,  2574,  2577,  2576,  2578,  2570,
    2563,  2565,  2564,  2569,  2571,  2573,  2575,  2541,  2558,  2559,
    2560,  2561,  2562,  2622,  1898,  2620,  3050,  1896,  2624,  1909,
    1910,  1381,  3099,  1925,  1926,  1928,  1930,  1931,  1927,  1929,
    1920,  3099,  1916,  2996,  2997,     0,  1036,  1293,     0,  1295,
       0,     0,     0,  1299,     0,  2749,  2698,  2699,  1969,     0,
    1971,  1970,  1972,  1954,  1964,     0,     0,  1948,  1992,  1982,
       0,  1994,     0,  2225,     0,     0,  3012,  3013,     0,  1031,
    3019,  3018,  3020,     0,  1072,  1195,  1156,  1099,  1115,  1166,
    1085,  1189,  1164,  1113,  1081,  1194,  1281,  1191,  1177,  1110,
    1178,  1176,  1147,  1149,  1152,  1111,  1165,  1119,  1168,  1117,
    1157,  1154,  1070,  1169,  1190,  1079,  1123,  1244,  1282,  1093,
    1151,  1087,  1094,  1114,  1086,  1170,  1284,  1171,  1082,  1130,
    1285,  1069,  1076,  1096,  1127,  1128,  1097,  1112,  1073,  1074,
    1129,  1067,  1150,  1095,  1080,  1286,  1153,  1192,  1075,  1280,
    1243,  1287,  1245,  1098,  1116,  1148,  1068,  1193,  1283,  1083,
    1118,  1126,  1092,  1278,  1090,  1091,  1167,  1155,  1088,  1089,
    1122,  1071,  1035,  1038,  1039,  1040,  1041,  1042,  1043,  1044,
    1045,  1046,  1047,  1048,  1049,  1050,  1051,     0,  2008,  2477,
       0,  3107,  2097,     0,  2993,  2063,  2053,     0,     0,     0,
       0,   586,   582,   585,   584,   583,   588,   737,   599,   595,
     597,   598,   600,   596,   601,   738,   589,  2690,   602,   603,
     578,   591,   592,   593,   587,   590,   581,   580,  2064,     0,
    2087,     0,  2367,  2724,  2725,  2726,     0,     0,  2143,  1381,
       0,  2155,     0,  2169,  2368,     0,     0,     0,     0,     0,
    2208,     0,     0,  2212,  2211,  2203,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2191,  2192,  2845,  2513,     0,
    2258,  3087,  3087,  2582,  2583,  2756,     0,     0,     0,  2282,
    2276,  2967,  2277,     0,     0,  2477,     0,  1379,     0,  2968,
    2831,     0,  2282,  2373,  2372,  2097,  2946,  2424,  2380,     0,
    2426,  2431,     0,   557,   505,   806,     0,     0,   941,  3014,
     608,     0,   667,     0,     0,     0,   792,   687,  3078,  3078,
    3078,  3078,  3078,   688,  3103,   689,   690,   691,   693,   694,
     695,   696,   698,   697,   700,   733,   731,   732,   734,   735,
     699,   705,   701,  3074,     0,   736,   760,   702,   677,   703,
     704,     0,  2957,  3081,   716,   717,   715,   788,  3099,   719,
     720,   718,  3009,   675,   567,  3009,   631,   633,   636,   634,
     635,   637,   639,   638,   653,   640,   642,   641,   683,   692,
     643,   644,   645,   646,   647,   648,   649,   650,   651,   652,
       0,     0,  2957,     0,  2976,     0,     0,  3014,  3014,     0,
       0,     0,     0,     0,  3009,   498,  2951,   499,     0,     0,
     500,   445,   446,   254,  3040,  3024,  3069,  3099,  3126,  3127,
     352,     0,  3024,  3009,  2969,  3024,   354,     0,  3107,   335,
     253,   334,  3009,  3009,   256,   257,   262,   267,   264,   321,
     265,   268,     0,   269,     0,   259,   351,   260,   261,   266,
     263,   258,   270,   271,   272,   273,   274,   275,     0,  2963,
    3014,  2631,     0,     0,  3147,  3148,  3050,  2611,     0,     0,
       0,     0,     0,   426,   399,     0,   194,     0,  3009,  3009,
     112,  1594,  1346,  1343,  1349,     0,  1346,  1361,  1362,  1333,
    2443,  2444,  2448,  2449,  1455,  2445,  1550,  2440,  1381,  1513,
    3045,     0,     0,  2761,  1501,  2718,  2719,     0,     0,     0,
       0,  1517,  1553,  1540,  3009,  2529,  3102,  2529,  2949,     0,
    2993,  3009,     0,     0,     0,     0,  1476,  1462,  1464,  2437,
    1473,  3025,  1467,  1468,  1469,  1507,  2959,  1471,     0,     0,
    2695,  2665,  2694,  2850,     0,  2811,     0,  2811,  2815,     0,
    2790,  2821,     0,  2811,  2811,  2811,     0,  2792,  2850,     0,
    2811,     0,  1381,  1381,  1565,  2483,  2480,  2746,  2747,  2477,
       0,  2811,  2811,     0,  2839,  1579,  1578,     0,  1575,  1587,
    1585,  2525,  1610,  1611,  1607,  1609,  1662,     0,  1659,  1658,
    1667,     0,  1675,  2102,     0,  1381,  1381,  1682,  2514,  2520,
    2517,     0,  1772,  1748,  1384,  1734,  1735,  1732,  1731,  1733,
    1730,  1724,  1726,  1729,     0,  1803,  1804,     0,  1303,  1305,
    1807,  1808,     0,     0,     0,  2529,  2529,     0,  1722,  1742,
    1773,  3107,  3107,     0,  1829,     0,  1843,  1841,  1613,  1842,
    1872,  1869,  1871,  1870,  1863,  1866,  1873,  1381,     0,  2543,
    2542,  2572,  1897,  2621,     0,  1381,  1911,  1902,  1905,     0,
       0,  1932,     0,  1297,  1296,  1302,  1301,  1300,     0,     0,
    1965,  1967,     0,  1960,  1974,  1961,  1962,  1953,  1956,  1974,
       0,  2702,  2531,  1996,  2226,  2217,     0,   778,   779,  3024,
    2998,  1034,  1292,  1291,  1033,  2009,  2012,     0,     0,     0,
     579,     0,  2052,  1381,     0,  2070,  2066,  2071,  2067,  2072,
       0,  2062,   594,  2069,  2089,  2120,  2088,  1381,  1381,  2137,
    2502,     0,  2513,  2144,     0,  2157,  2536,     0,  2152,  2158,
    2174,  2173,  2172,  2171,  2170,  2190,  2213,  2721,  2214,  2720,
    2722,  2723,  2202,     0,  2205,  2194,  2195,  2196,  2200,  2197,
    2201,  2198,  2199,  2193,  2846,  2250,     0,  2247,  2248,  2242,
       0,  2235,  3144,  3143,     0,  3088,  2262,  2262,  2580,  2757,
       0,  2486,     0,     0,  2850,  2850,  2288,     0,     0,  1380,
       0,  2832,  2311,  2312,     0,  2315,  2318,  2320,  2316,  2143,
    2947,     0,  2531,     0,  2433,     0,   504,   558,   809,     0,
       0,   429,     0,  3009,   668,   605,   801,   802,  3079,   730,
     729,   722,   721,   728,   727,   726,   725,   724,   723,  3104,
       0,     0,  3075,   786,   656,  2734,   764,     0,   756,   679,
     676,   654,  2958,     0,  3082,   789,   790,   787,     0,     0,
     632,   664,   803,  2967,   669,   661,  2862,  2862,     0,   609,
       0,   576,   467,   495,  3139,  3140,  2640,   476,  2638,  3131,
    3130,   469,  2642,  2641,  3034,  2971,  2993,     0,  3009,   473,
     472,  3009,   501,  3009,  3009,  3024,   303,   355,  3009,  3069,
    3009,  3009,  3009,  3009,   374,  2954,   375,     0,     0,     0,
    3009,  3040,   322,  2964,     0,     0,   409,   410,     0,   413,
     415,   418,   419,   422,   427,   424,   196,   197,  2755,  2752,
    2752,   113,  1344,  3009,     0,  1358,  1354,  1347,  1348,  1363,
    2438,  2446,  1381,  1551,  1552,  2732,  2439,  2441,  2447,  1511,
    1512,  1545,  1543,  1520,  1544,     0,  1547,     0,  1546,  1548,
       0,     0,  1487,  1486,     0,  1490,  1489,  1474,  3009,  1457,
    1502,  1504,  2667,  2668,  2477,  2827,  2796,  2829,  2797,  2791,
    2825,  2793,  2794,  2795,  2823,  2864,  2818,  2819,  2789,  2650,
    2485,  2482,  2478,  2484,  2479,  2481,  2745,  1566,  2812,     0,
    2787,  2788,  2841,  2705,  2706,  1576,  1580,  1592,     0,  2853,
       0,  2519,  2522,  2515,  2521,  2516,  2518,  1692,  1763,  3011,
    3011,  3011,  3011,     0,  1747,  1749,  1750,     0,  1822,  1820,
    1304,  1306,  3048,  1821,  1824,  1823,  1818,  1791,  1788,  3021,
       0,  2952,  1787,  1790,  1781,  1759,  1777,  1783,  1784,  1794,
    1785,  1779,  1798,  1799,     0,  1766,  2477,  2603,  2477,  2603,
    1619,     0,  2536,  1868,  1860,  1861,  1859,  1865,  1899,  1904,
    1909,  1918,  1921,  1922,  2981,  3096,  1914,  3099,  1919,  1974,
    2700,  2701,  1974,     0,  3005,  3005,  1959,  1975,  1976,  1957,
    1963,  1958,  2993,  1983,  2396,     0,  2227,   322,  2221,     0,
    2999,  2224,  2477,  3059,  3059,     0,  2028,  2029,  2526,  2057,
    2059,  2060,  2056,     0,     0,  3050,     0,  2108,  2090,  2103,
    2096,  2092,  2105,     0,  1381,  1381,  2117,  2126,  2123,  2501,
    2504,  2495,  2503,  2496,  2142,  2145,     0,  1381,  1381,  2159,
    3026,  2166,  2204,  2249,  2239,  2243,  2244,  2245,  2246,  2237,
    2260,  2263,  2261,  2758,  1381,  1381,  2272,  2492,  2489,  3009,
    2280,  2279,  2281,  2477,  2864,  2477,  1375,  2303,  2697,  2831,
    2314,  2993,  2531,  2993,  2486,  2374,  2371,  2370,  3028,  2381,
    2432,  3107,     0,  2430,     0,   506,   558,   807,   558,   812,
       0,   626,   628,   627,   621,   625,   623,   624,   620,   622,
     619,   798,   793,   795,     0,     0,   604,   791,  1021,  1017,
    1018,  1011,  1015,  1023,  1009,   739,  1016,  1008,   746,  1014,
     710,  1010,  1012,  1013,  1022,   707,   709,  1019,   711,  1020,
     706,   714,   713,     0,   655,   657,  2993,   758,  3097,   761,
    3097,     0,     0,   659,  2735,   682,   686,   685,   684,     0,
     663,     0,     0,   662,   660,  2969,   748,   749,   613,   612,
       0,   457,     0,   494,  2639,  3035,   478,     0,   460,  3083,
     487,   489,   493,   492,   488,   490,   486,   491,     0,     0,
       0,     0,  3009,   306,   305,   281,   304,     0,   354,   350,
       0,   357,     0,     0,  2955,  2956,   373,   376,  2971,     0,
       0,  3009,     0,  2989,   353,   380,     0,   411,   420,     0,
     421,     0,   114,   115,     0,  3009,  1353,  1359,     0,     0,
    1334,  2442,  1533,  3132,  3133,  2530,  1549,  1538,  1485,     0,
    1503,  1567,  3001,  2866,  2813,  1612,  1664,  2101,  2100,  3107,
       0,     0,     0,     0,  1756,  1751,  2984,  3023,  3022,     0,
    1780,  3011,  1778,  1793,  1792,  1795,     0,     0,  1786,  1831,
       0,  1830,     0,  1614,  1615,  1349,     0,  1867,  1874,  1381,
    1923,  2982,     0,     0,  1955,  1966,  1974,  3006,     0,     0,
    1977,  1978,     0,  2396,  3048,  1986,  1997,     0,     0,  2230,
    2220,  3000,  2013,  3060,   377,   378,   379,     0,  2049,  3111,
    2047,  2048,  2046,  3110,  2020,  2030,  2031,  2033,     0,     0,
    2058,  2054,  2073,  2075,     0,  2093,  3009,  2513,  2091,  2104,
       0,     0,     0,  2107,  2128,  2125,  2121,  2127,  2122,  2124,
    2146,  2153,  2160,  3027,  2175,  2494,  2491,  2487,  2493,  2488,
    2490,     0,  2290,  2866,  2289,  2328,  1374,     0,  2313,     0,
    2317,     0,  2309,  1381,  1381,  2365,  2376,  2510,  2507,  2375,
    3029,  3030,  2369,  2384,     0,     0,   508,   507,   810,   814,
     942,     0,   799,   796,   616,  3048,   619,   611,   614,   617,
     606,   740,   741,   745,   744,   743,   742,   708,   747,   712,
    2691,     0,     0,     0,   756,  3098,     0,   757,   762,  3009,
     681,   680,   665,   804,     0,   671,   674,   673,   670,  2863,
     468,   459,   458,   456,   496,   477,  2971,   465,   474,   471,
     475,   470,   311,   312,   310,   309,   383,     0,   295,   296,
     297,   291,   292,   286,   298,   299,   287,     0,   300,   301,
     290,   288,   289,   294,   293,     0,   280,   284,   285,   282,
     384,   356,     0,   364,   372,   385,   386,  2633,     0,  3009,
     323,     0,     0,     0,     0,   423,   198,     0,     0,  1350,
    1351,  1355,     0,  1356,  1364,  1366,  1505,  3002,     0,  3001,
    2477,  1623,  1764,  1755,  1754,  1752,  1753,  1801,     0,  3011,
    1796,  1797,  2477,  2477,  1616,  1617,     0,  1621,  1620,  1622,
    1903,     0,  1933,  1973,  1980,  1979,  2532,  1986,     0,     0,
    2468,  3009,  2228,     0,     0,  2218,  2222,  2044,  3061,  2041,
    2043,  2042,  2035,  2040,  2032,     0,  2038,  2036,  2037,  2034,
       0,     0,  2095,     0,  2086,  2111,  2502,  2499,  2110,  2094,
    2106,  2283,  2477,  2336,  1376,  2319,  2321,  2509,  2512,  2505,
    2511,  2506,  2508,  2392,  2385,  2386,     0,     0,  2434,  2435,
    3009,   510,   813,   944,   797,     0,   794,     0,     0,   618,
     658,   765,   759,     0,   766,  3050,  3050,   768,     0,   672,
       0,     0,   479,   480,   481,   482,     0,   461,  2992,   467,
       0,   364,     0,  2987,  3149,  3150,   277,   276,     0,   361,
     360,   359,   362,   358,  3009,   366,   314,   368,  2634,   332,
     341,   348,   341,   337,     0,  3009,  3009,   324,     0,   381,
    3009,  3009,  1352,  1345,     0,  1366,  1384,     0,     0,  1568,
    1632,  3007,  1800,     0,  1833,  1832,  1618,  2658,  2657,  2733,
    1924,  1984,  2397,  2398,  3009,  1987,  1988,  1990,  1381,  1381,
    1995,  2474,  2471,     0,  2231,  3009,  3062,  2039,  2045,     0,
    2076,  2684,  2683,  2685,     0,  2109,  2497,  2498,  2500,  2291,
    2960,  2362,  2361,  2337,  2329,  2330,  2948,  2331,  2332,  2333,
    2334,  2357,     0,     0,     0,  3009,  2396,  2387,  2391,     0,
    2390,  2388,  2436,     0,  2989,     0,   815,     0,   948,   943,
     945,     0,     0,  3009,   615,   767,   768,     0,     0,  2967,
     753,   773,   774,   775,  3024,   772,   678,   485,   484,  2959,
    2971,   466,  2833,   279,   302,   278,   367,   316,  2833,   315,
     365,     0,  3036,   339,   344,     0,   340,     0,   338,   330,
       0,     0,   325,   382,  2752,  2752,     0,  1384,     0,  2867,
    1381,  1381,  1381,  1591,  1639,  1635,  3048,  3008,  1626,  1631,
    1630,  1625,     0,  1782,  2468,  2399,     0,  1989,  2473,  2476,
    2469,  2475,  2470,  2472,  2229,     0,  2686,  2687,  2688,  2074,
       0,  3085,  2358,  2359,     0,  3050,     0,  2401,  2389,  2427,
     509,   511,  3005,   816,     0,   949,     0,   946,  3106,     0,
     755,   768,   763,  2752,   769,   776,  3009,     0,     0,   463,
     314,     0,  3009,   363,   370,   371,   369,  3037,     0,   347,
     349,   326,   327,   116,   117,  3009,     0,  2865,  1637,  1641,
    1638,  1633,  1640,  1634,  1636,     0,  1624,  1985,  2400,  2232,
       0,  3086,     0,     0,  2360,  2355,  2354,  2353,     0,  2394,
    3048,  2411,  2459,   532,     0,     0,   954,   955,     0,   947,
     800,   754,   782,   783,   785,  2752,   771,   483,  3050,   462,
     318,  2835,     0,     0,     0,     0,     0,     0,     0,  1627,
    2356,  3125,  3124,  3063,  2612,     0,  2349,  2343,  2344,  2346,
    3009,  2393,     0,     0,  2382,  1381,  1381,  2428,  2465,  2462,
    3009,     0,     0,     0,     0,   513,   533,   534,   515,   543,
       0,  3009,  3080,     0,   952,  1006,   784,   777,  2635,     0,
       0,   313,  2834,   317,     0,  3134,  3135,   345,  3009,  3009,
    1357,  1365,  3064,  3050,  2613,  2352,  2347,  2350,     0,  2345,
       0,  2402,  2403,  3009,     0,     0,  2412,  2413,  2415,  2459,
    2464,  2467,  2460,  2466,  2461,  2463,  3009,     0,     0,  3009,
    3009,  3009,  3009,   535,     0,  3039,     0,  3090,     0,   512,
     516,   518,   517,     0,     0,     0,     0,     0,     0,     0,
     514,   544,   546,   545,     0,     0,   820,  3014,  3014,  3031,
     853,   819,   823,   824,     0,     0,     0,   978,  3009,   966,
     967,   968,   959,  3103,   960,  3044,  3044,  3009,  3011,  2983,
    3009,     0,   983,   976,   963,   977,  3044,  3011,   964,     0,
       0,   975,   985,   982,   980,  3011,   965,   979,     0,   986,
     974,     0,  1001,   995,   999,   998,   996,  1000,   956,  1002,
     997,   981,   969,     0,  3044,  1007,  1025,  1024,  1028,  2636,
     464,     0,   345,   342,   346,     0,     0,     0,  2351,  2348,
    2395,  2404,     0,  2408,  2410,  2409,  2406,  2406,  2420,  2416,
    2784,  2785,  2782,  2783,  2417,  2421,  2414,  2383,     0,     0,
     541,     0,     0,     0,     0,  3009,  3009,  3009,  3009,  3009,
     519,     0,  3009,  3009,  3009,  3009,  3009,  3009,  3009,  3009,
    3009,  3009,  3009,   547,     0,  3009,  3165,  3166,  3014,  3014,
       0,   817,   821,  3009,   829,   825,   827,   828,   830,   832,
       0,   957,   958,   991,  3009,   989,  3009,     0,     0,   961,
     962,     0,  1004,   987,     0,  3097,  3009,     0,  1005,  1003,
    1329,   990,   955,  1029,     0,   205,   206,   320,   343,   328,
     329,  2342,  2339,  2341,  2340,  2335,  2338,  2405,  2419,  2407,
    2418,     0,   536,  3097,   540,   538,   542,   537,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3032,  3033,  2763,
     840,   835,  3028,   839,  2762,   838,     0,   854,     0,   826,
     831,   994,  1325,  1321,   992,   972,   973,   993,   988,  1318,
    1328,     0,   971,   970,  3080,   319,  2422,   780,   528,   524,
     525,   529,   527,     0,   530,   520,   526,   521,   522,   523,
     552,   548,   549,   553,   551,     0,   550,   833,  3029,  3030,
     834,   837,     0,     0,   855,   573,   822,  1313,  1310,  1314,
    1311,  1326,  1309,  1327,  1312,     0,  1322,  1323,     0,  1319,
    1317,  1315,  1316,   984,   539,   781,     0,     0,     0,  3009,
    3009,     0,  3009,   841,   842,   843,   844,   845,   846,   836,
       0,   857,   858,  1324,  1320,     0,   554,  3152,  3151,  3009,
       0,     0,  3154,     0,  3009,  3009,     0,  3080,     0,     0,
     852,   848,  3153,     0,     0,   847,   913,  3113,  3112,  3003,
    3044,  2950,  3009,     0,   912,  3009,  3048,   856,  3009,     0,
     863,   865,   864,   866,   875,   867,   869,   872,   859,   860,
     861,   871,   873,     0,   876,   862,   923,   868,     0,   870,
     874,  3116,  3117,  3044,     0,   849,   851,   850,  3004,   940,
    3047,  3046,  3014,   922,     0,   756,     0,     0,     0,     0,
    3042,  3042,     0,     0,   925,   920,   923,     0,  1308,   927,
     935,   936,     0,   938,   929,     0,   921,   900,   898,   899,
     894,   897,     0,   895,  3097,  2850,   902,  2671,  3156,     0,
       0,  3158,  3160,     0,  3164,  3162,   877,   882,  3052,  3052,
     879,   883,   878,   884,     0,  3043,   914,   914,  3042,  3042,
     907,   924,   926,   937,   934,   933,   931,   932,  3014,   930,
       0,   896,   762,   939,  3050,     0,   901,  2672,  3155,  3159,
    3157,  3163,  3161,  3054,  3053,   885,   890,     0,   918,   916,
     908,   914,   917,   910,     0,     0,   928,   531,   751,     0,
     904,   888,   880,   888,   893,   888,   881,   888,     0,   915,
     909,   911,     0,   750,   906,   903,   905,     0,   887,   886,
     892,   891,   919,   752,   889
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -3978, -3978, -3978, -3978, -3978, -3978, -3978,  3196, -3978, -3978,
   -3978, -3978, -3978, -3978,  3160, -3978, -3978, -3978,  2085, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,  3166,
    3096,   183, -3978, -3978, -3978,  2690, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978,  3130, -3978, -3978, -3978, -3978, -3978, -3978, -3978,  2945,
    1067, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,  3020,
   -3978, -3978, -3978, -3978,  2943, -3978, -3978, -3978, -3978,  3127,
   -3978, -3978, -3978, -3978,  2927, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978,  2485, -3978,  2107, -3978, -3978,
   -1638, -3978, -3978, -3978, -3978, -3978,  3023, -3978, -3978, -3978,
   -3978,  3029, -3978, -3978,  2762, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,  -589,
   -3978, -3978, -3978, -3978,  1232, -3978, -3978, -3978, -2277, -3978,
   -3978, -3978, -3978, -3978,  -388,  -826, -3557, -3978, -3978,   428,
   -3978, -3978, -3978, -3978, -3978,  -363, -3978, -3978, -3978,  -502,
   -3978, -3978, -3978, -3978,   423, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978,  2788, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978,   411, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978,  -356, -3978, -3978, -3978,    58,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978,  -736, -3978, -3978, -3978,  -666,
   -3978, -3978,  -738, -3978, -3978, -3978, -1571, -3978, -3978,  2557,
   -3978, -3365, -3978, -3402,  -694, -3978,  -959,  1137, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3192, -3978, -3978, -3978,
   -3978, -1880, -3978, -3978,   967, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978,  1643, -3978, -3978, -3978, -3978,
   -2726, -3978, -3978, -3978, -1044, -2682,   495, -1300, -3978, -3978,
   -2547, -3978, -3978, -3978, -3303, -3978, -3978, -1167, -3978, -3978,
   -3323, -3978,  -550,  -455, -3978,  1266, -3978, -3457, -3978,  -601,
   -2469, -3978, -3978, -2387, -3978, -1609, -3978,   497, -1804, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978,  -848, -3712, -3978,
   -3978,  -973, -1967, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -2215, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3977, -3978,
   -3978, -3978, -3978, -1096, -3978, -3978, -3978, -3978, -3978, -3978,
   -1098, -3978, -3978, -3978, -3978, -3978, -3978, -3978,  -426, -3978,
   -3978, -3978,  -867, -3978, -3978,  -582, -3978,  2634, -3978,  -771,
   -1468, -3978,  -730, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978,  1821,  2333, -1009,
    -729,  -727, -3978, -2348, -3978,  -917, -3978, -3978, -3978, -3978,
    -728, -3978,  -757, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978,  1606,  -177, -3978,    26,   458,
   -3978, -3978, -3978, -3978, -3978, -3042, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978,   211, -3978, -3978,  -150, -3978,  3072, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978,  2408, -1533, -3978,
    2165, -3978,  2153, -3978,   433, -3978,  -746, -3978, -3978, -1050,
   -3978, -3978,   441,  2157, -1142,  1585, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978,  1486,   812, -3978, -3978, -3978,
    2487, -3978, -3978, -3978, -3978, -3978, -1223, -3978, -3978,  1390,
   -3978, -3978, -3978, -3978,    78, -3978, -3978,    45, -3978, -3978,
   -1005, -3978, -3978, -3978,  -446, -3978,  -444, -3978, -3978, -3978,
   -3978,  2479, -3978, -3978, -3978, -3978,  2110, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,  2694,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978,  2439, -3978, -3978,
    2090, -3978, -3978,  1458, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978,  1424, -3978, -3978, -3978, -3978,   397, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,  2438,   802,
    2683, -2306, -2693, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -1790, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,  2068, -3978,
   -3978,  2066, -3978, -3978, -3978, -3978,   761,   378, -3978, -3978,
   -3978, -3978, -3978,  2428, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978,  1399, -3978, -3978, -3978, -3978, -3978, -3978,
     374, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,   376,
    2051, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978,  1878, -3978, -3978,   753, -3978,
    1370, -3978, -3978, -2171,   366,   368, -3978, -3978, -3978, -3978,
   -3978,  -149, -3978,  -288,  1887, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978,  2401, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978,    54, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3259,  1247, -3978, -3978, -3978,   355, -3978,
   -3978, -3978, -3978, -3978, -3978,  -315, -3978, -3978, -3978,  1219,
   -3978, -3978, -3978, -1260,   736, -3978, -3978,   352, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,   344, -3978,
     347, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978,   670, -1457, -3978, -3978, -3978, -3978, -3978,
   -3978,  1835,   734, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978,  -114, -3978, -3978, -3978, -3978,
    1195, -3978, -3978, -3978,  2387, -3978,  2390, -3978, -3978, -3978,
   -3978,  2724, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978,   701, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
    1808, -3978, -3978,  1180, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978,   325, -3978,  1181, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -3978,  -492, -3978, -3978, -3978, -3978, -3978,  -284, -3978,
   -3978, -3978, -3978,  -564,  1235,  1248, -3978, -3978, -3978, -3978,
   -3978, -3978, -3978, -3978, -3978,  -154, -3978, -3978, -3978, -3007,
   -3978,  -240, -3978, -3978,  -538,  -663, -3570, -3978, -3978,  -541,
   -3978, -3978,  1801, -3978, -3978, -3978, -3978, -3978, -3978, -3978,
   -3978, -1572, -3978,   990, -3978, -3978,   994, -3978,  1140, -3978,
    2161, -3978,  2167,  -539, -3978,  -488, -3978,  -486,  -350, -3978,
    -236, -3978,  -234, -1745, -3978,   932, -3978,   935,   349, -3978,
     371, -3978,   367, -3978, -3978, -3978, -2545,  -110, -2068, -3978,
   -3978,    76, -3978,    80, -2135,   356, -3978,   910, -3978,   913,
    2608, -1412,  2775, -1120, -2402, -2092,  -604, -1819, -3978, -3978,
    2156, -3978,  2169,  1525, -1921,   758,   764,   767,   769,   993,
     389,  -456,   978,  1003, -3978,  1476,   206, -1095,  -562,  -647,
    2763,  2466, -1058, -3978,  -213,  1268,  -683, -3978,  -978, -3978,
    1506, -3978,  -570, -3978,  2253,   293,  -116, -3978, -3978, -1092,
   -3978,   679, -2681,   -55,  3263,  -593,  -527, -3978,  -553,  1608,
   -3978,   -38,    82, -3978, -1093, -2147, -3978,  -143, -3978,   -69,
   -3978,  1292,  -910, -3978,  1474,   481, -2651,   765,  -631,  2265,
   -3978, -2302, -2391, -2740,  -359,  -542,  -639,  -739,  -587, -3978,
   -2385, -3978, -2673, -3978,   470,  -459, -3978, -3978, -3978, -1503,
     -80, -3380, -3978,  1073,  -755,  -781,  -151,  2968, -3978, -2187,
    2740,  -276,  3327,  -500,  -689,  -308, -3978, -3978, -3978,    23,
    2680, -3978, -3978, -3978, -3978,  1143, -3978, -3978,  1861, -3978,
    -252, -3978, -3978, -3978, -3978,  1294, -3978, -2437, -3978,   971,
     717,   424,   144, -3978, -3978, -3978, -3978,  -190,  -822,   550,
   -3978,  1185, -1898, -3978, -3978, -3978, -1570, -2209, -2699, -1338,
    -289, -3978, -3978, -3978, -3978, -3978,  -100,  -161, -3978, -2008,
     743, -3978,    19, -3978, -2833, -3978,   -26, -1818, -2200, -3978,
   -3978, -2263, -3978,  -700, -3978, -3978, -3978,  2735, -1583, -2378,
   -1663,  -847,  -720,  -650,  -896,  3226,   501, -3978, -3978,  2990,
   -3978,  -808, -3978, -3978, -3978,   181, -3978,   338, -3978,  1316,
   -2167, -3978, -3978, -3978, -3055,  -638,  1626, -3978, -3978,  1697,
   -3978, -3978, -1159, -3978,  2369, -3978, -3978, -3978,  -595, -3978,
    -681,  -411, -3978,  1894,  1124, -3978, -3978,   318, -3978, -3879,
    -839, -3978, -3978, -3978, -3978, -3978, -3978
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,     1,     2,     4,     5,     6,    11,    12,     7,     8,
      13,    14,    47,    48,    49,   111,    51,   113,    19,    40,
     123,    15,    16,    17,    24,    32,   219,    25,    31,   109,
     163,   159,   295,   526,   527,   528,    20,    37,    38,   118,
      55,   121,   226,   169,   533,    29,    30,    42,    43,    82,
      83,    84,    85,   196,   278,   499,    86,   193,   263,   264,
     265,   266,   267,   489,  1136,  1685,   268,   269,  1132,   270,
      87,   194,   275,   276,   277,   494,    88,    89,    90,    91,
      92,   151,   210,   519,   211,   212,    93,   180,   244,   460,
     461,   245,   246,  1114,  1122,  1115,  1116,  1117,  2405,  2836,
    1118,  4157,    94,   157,    95,   202,   203,   204,   513,    96,
     198,   199,    97,   471,   472,   182,   742,    98,    99,   475,
     100,   101,   102,   103,   104,   105,   106,   150,    63,    64,
     129,   179,   241,  1078,  1653,  1654,  2364,  2365,  3455,  3456,
    3457,  3458,  3459,  3195,  3196,  1097,  2366,  3435,  2367,  3738,
    3739,  3822,  3931,  2368,  2369,  3213,  3470,  2370,  1125,  2371,
    2372,  2373,  2374,  3623,  3743,  4063,  3744,  3746,  2375,  2376,
    2377,  2378,  3462,  3613,  2379,  3616,  3617,  3740,  3741,  3824,
    2380,  2381,  2815,  2382,  3016,  2383,  3215,  2384,  2385,  2386,
    2387,   242,   243,   452,   453,   454,   455,   734,   456,   457,
     458,   727,  2831,  2832,  3220,   459,   729,  1672,    58,   235,
      59,    60,   125,   176,   236,   237,   712,   238,  1077,  1640,
    1641,  3423,  1642,  3879,  3599,  3171,  1643,  1644,  2801,  3429,
    1645,  1646,  3425,  3592,  3593,  3594,  3595,  1647,  3186,  3187,
    1648,  3173,  1649,  1650,  2339,   700,  2234,  2726,  3095,  3096,
    3571,  3704,  3801,  3979,  3980,  3981,  3982,  3915,  3916,  3917,
    3990,  3991,  3992,  3993,   438,  1617,   439,   440,   704,   705,
    1627,   706,  1073,  1074,   200,  2322,  3110,  2150,  2151,  2152,
    2153,  2154,   707,  3116,   708,  1622,   709,  1623,  2779,  3387,
    3388,  3111,  2294,  2295,  2296,  2297,  2298,  3144,  3145,  2299,
    2300,  3164,  2301,  3160,  2241,  2302,  2303,  3162,  3418,  2304,
    2305,  2760,  3151,  3411,  2306,  2307,  2308,  2309,  3397,  3399,
    2310,  4334,  4473,  2311,  3150,  3404,  2757,  3587,  3147,  3716,
    3720,  3817,  3721,  3722,  3723,  3724,  4274,  3725,  3872,  3873,
    2312,  2313,  2767,  2314,  2315,  2316,  3382,  3112,  3113,  3576,
    2317,  2318,  2319,  1065,  2727,  1621,  3098,  2238,  3379,  3572,
    3706,  3865,  3921,  4001,  4002,  4125,  4126,  4127,  4128,  4003,
    4200,  4201,  4202,  4247,  4283,  4284,  4285,  4286,  4287,  4288,
    4121,  4207,  4292,  4307,  4338,  4339,  4406,  4462,  4478,  4466,
    4340,  4390,  4391,  4341,  4436,  4475,  4342,  4343,  4450,  4451,
    4344,  4345,  4346,  4375,  4376,  4347,  4348,  4428,  4429,  4379,
    4380,  4381,  4349,  4350,  2731,  3573,  3709,  3710,  3711,  3867,
    3868,  4058,  3922,  4048,  3924,  3142,  4055,   946,  4152,  1490,
    1491,  1492,  1493,  2102,  1451,  2103,  1452,  2104,  1453,  2105,
    1454,  2106,  1455,  2107,  1456,  2108,  1457,  2109,  2110,  1458,
    2111,  1459,  2112,  1460,  1461,  2113,  1462,  2114,  1463,  1464,
    2115,  1465,  2116,  1466,  2621,  1976,  1467,  1468,  1472,  1473,
    2550,  2551,  4377,  4378,  4262,  4263,  4264,  4218,  4271,  4272,
    4135,  4268,  4133,  4265,  4049,  4050,   172,   173,   307,  2849,
    3485,   174,  1142,  1693,  1692,  2412,  2413,  2414,  2845,  2846,
    3633,  3228,  1695,  3230,  3635,   690,  1041,  1042,  2217,  3356,
    1043,  1044,  2708,  1865,  1866,  2534,  1045,   231,   372,   373,
     621,   770,  1145,  2466,   771,   772,   773,  1159,  1757,  1758,
    1150,  1151,  1152,  2879,  2880,  1784,  2954,  1708,  1709,  1154,
    1749,  2852,  2853,  4051,  1898,  1752,  1144,   374,   622,   806,
    1183,  1181,   375,   623,   822,  1837,  2508,   376,   624,   835,
     836,  1839,   377,   625,   841,  2511,   767,  1139,  1691,   540,
     541,  1841,  1842,  2514,  2569,  2970,  3273,  3274,  3275,  3640,
     645,  3771,  3763,  3843,  3764,  3841,  3765,  1211,   378,   626,
     845,   846,   379,   627,   850,   851,  1218,   852,  1214,  2516,
     380,   628,   855,  1223,   381,   382,   629,   865,  1232,   383,
     631,   870,   384,   630,   867,  1233,  1236,   385,   632,   877,
    1860,   878,   386,   633,   889,   890,   891,   892,  1261,   893,
    1263,  1899,  1875,  1876,  1877,  2539,   894,  1246,   895,   896,
     897,  1902,  1903,   898,  2533,  2934,  2935,  2936,   899,  1265,
    2561,   900,   901,  2532,  3249,   902,  2562,   903,  1248,  1907,
     947,  2955,  2956,  2957,  2958,  2959,  3266,  2960,  2961,  2962,
    2963,  1900,  1252,   387,   634,   907,  1272,   388,   635,   389,
     637,  1916,   912,  2567,   390,   638,   915,   916,   917,  1281,
    1282,  1283,  1922,  1284,  1919,  2578,  2574,  2575,  2973,  1278,
     391,   639,   926,   646,   392,   640,   927,   393,   641,   930,
     394,   642,   933,  1957,   395,   396,   647,  1960,  1307,  1961,
    2585,  2587,   397,   648,   939,  1308,  1970,  2591,  2982,  2983,
    2984,  2986,   398,   649,   942,   399,   650,   948,   400,   651,
     950,   951,  1477,  1478,  1996,  1479,  1480,  2607,  2608,  1993,
    1994,  1995,  2601,  2996,  2997,  2998,   401,   955,  1481,  3293,
    3774,  3520,  3655,  3656,  1999,   402,   956,  1483,  3004,   403,
     654,   404,   655,   963,  1497,   405,   656,   965,   406,   657,
     967,  1501,   407,   659,   970,   971,   972,  1508,  2122,  3314,
    3315,  3539,  3532,  3533,  3316,  3317,   408,   660,   974,  2633,
    2634,  3321,  3022,  1513,  1514,  1515,  2636,  2638,  2639,  3541,
     409,   661,   410,   662,   980,  1526,   411,   663,   982,  2167,
    3027,  3028,  3029,  1857,  1858,  1859,  3328,  3031,  3327,  3544,
    1528,   412,   413,   664,   984,  1536,  3036,  3338,  3037,  3336,
    3038,  1533,   414,   665,   986,   415,   416,   666,   989,  1540,
     417,   667,   992,  2652,  2653,  1544,   418,   419,   668,   996,
    1550,  2170,  2658,  2659,  1548,   420,   669,   999,  1552,  1553,
    2174,  3051,   421,   670,  1004,   213,  1569,  1005,  1006,  2195,
    2196,  1007,  1008,  1009,  1010,  1011,  1012,  1013,  1014,   422,
     671,   957,  3006,  1485,  3300,  2003,  2615,  3299,  3525,   423,
     672,  1023,  2198,  1577,  2686,  2687,  2688,  1573,   424,  1025,
    1579,  3060,   679,   680,   425,   685,  1030,  1031,  1032,  1589,
    1590,  2212,  3071,  2701,  1587,   426,   686,  1035,  1595,   427,
     688,   428,   689,  1037,   429,   691,  1046,   430,   692,  1049,
     431,   693,  1052,  1608,  2712,  2713,  2222,  2715,  3082,  3084,
    1606,   432,   694,  1056,  3357,  3553,  3684,  3685,  3686,  4165,
    3687,  3897,  3898,  3948,  3688,  3857,  3689,  3690,  3691,  3692,
     433,   695,  1058,  1538,  2225,  2226,  3365,  1611,   434,  1060,
    1613,  3373,  3959,  3563,  3564,  3565,  3701,  3696,  3901,  3295,
    3652,  3653,  3861,  3951,  3952,  4168,  4169,  3904,  3956,  3957,
    4079,  4084,  2228,   435,  1061,  1615,  3862,  2231,  2724,  3092,
    3568,  2424,  2856,  2425,  2426,  2850,  2427,  2428,  1255,  1870,
    1256,  1868,  1257,  3907,  3964,  3908,  3962,  3909,  3660,  3782,
    3661,  3780,  3662,  2494,  2904,  2495,  2902,  2496,  3066,  3349,
    3067,  3347,  3068,  2649,  3545,  3677,  2650,  3041,  3042,  3366,
    3561,  3367,  3559,  3368,  2527,  2528,  2925,  2529,  2923,  2530,
     975,  2125,   681,  2866,  3003,   937,   938,   919,   920,  1296,
    1297,  1927,  1298,  1947,  1948,  1949,  1950,  1951,  1952,  1582,
    2206,  1795,   824,   825,   826,   827,   807,   857,  1226,   993,
     994,   997,  1660,  3854,  1661,   774,   943,  1016,  1017,  1954,
    1955,  1305,  1516,   838,   839,  1655,  2793,  3619,  3927,  1133,
    2787,  2788,  2794,   132,   205,   928,   859,  1259,   808,   809,
    3646,   810,   811,  4396,  1809,   830,  3670,  1759,  2156,  3401,
    1791,  2471,  2609,  3077,  1984,  2989,  1555,  2912,   847,  1053,
    1518,  1698,  2434,  2668,  2669,  2162,  1699,   958,  1020,  1047,
    2610,  3648,  2754,  3155,   812,   683,   872,   860,   861,  1986,
     684,  1134,  1135,  1684,  1028,  1029,  1700,   514,  2436,  4205,
     473,   813,   510,   511,  4085,   814,   815,   816,   817,  1189,
    1168,  1817,  1801,  1802,  1813,  1806,  1796,  1798,   710,  2714,
    3820,  1206,  1830,  2504,  1531,  1494,   447,  1229,  1852,   305,
    3166,  3243,  3490,   618,   619,   620,  2721,  2449,  2337,  1100,
    3206,  2763,  1155,  1156,  2824,  1250,  2415,   271,   149,   490,
    2325,  1240,  1753,  3282,  2552,  1095,  1093,   183,  3600,   976,
    1975,  3011,  3488,  4359,  3288,  3772,  1300,  2008,   286,  2013,
    3259,  2462,  3344,  3372,  4120,  3176,  3828,  3984,   166,  4416,
    4134,  4362,  1083,   730,  4445,   291,  3304,  3667,  3943,   272,
    1754,  2389,  1604,  2753,   136,  2740,  2321,   480,  3852,  2696,
    3985,  1670,  1243,  2987,  3406,  2553,  2447,  2750,  3577,  2964,
    3319,  4351,  4251,  4353,  4054,  1227,  3893,  2390,   255,  2791,
    3235,  3937,  1682,  2329,  1220,  2694,   818,  2396,  3608,  4299,
    4305,  4409,  4410,  4411,  4412,  4413,  4006
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
     214,   759,   905,  1786,   934,   509,  1038,  1066,  1067,  1068,
      53,   133,  1075,  2240,  1675,  1751,  1512,   140,   987,   247,
    1578,   187,  2009,   190,   230,   443,  1153,  1662,   195,  1664,
    1665,  1019,  1667,  1668,   918,  2637,  2884,  2220,  1565,  2732,
    2406,  2854,  2431,   137,   138,   139,  2233,  2432,  2863,  2783,
     144,  2895,  2334,  1917,   837,   940,  1163,   188,  2869,   188,
    1238,  2544,  1177,  2691,   188,  1079,   858,   959,   251,  1084,
    1085,  2554,  1087,  1088,  3093,  1090,  1091,  1018,  1080,  1081,
     904,  1231,  2804,  1086,   959,  1816,  1089,  1820,  2543,  2808,
    3153,  1554,  2812,  2813,   167,  3408,  3178,  1826,   288,  2651,
    2576,  3584,  2126,   130,   188,  2520,  3043,  1230,   184,  2558,
     185,   491,   130,   929,   191,   192,  2631,   283, -3107,   441,
    2441,   929,  4154,   869,   206,   215,  1279,  2784,  2785,  2859,
    2860,  3237,  3527,  1036,  1221,  2861,  2862,  3208,  2864,  3766,
     222,   854,  3698,   929,  3216,  2810, -2729, -2730,   995,  1755,
    3609,   287,  3920, -3050,  2010,  3896,   248,   944,  4464,  3025,
     294,   496,  3289,   501,   258,  1988,  2219,   823, -2969,  2564,
    2535,  2536,  2324, -1337,   281,   477,  2219, -3065,  1956,  1914,
    1677,   147,  1541,  1679,  1785,  3507,  1140,   854,   292,  4370,
    2825,  3590,  2456,   296,  1170,  1171,  4096, -1335, -3107,  1787,
    2460,   306,  1176,  2203,  1474,  1487,   979,  1688,  3707,  2445,
    4109,  1874,  2555,  2798,   959, -3107,  1450,  2155,  4124,  3263,
     854, -2055,  2452,  3966,   488,  4461,   223,   181,   501,  1146,
    4371,  1509,  3020,  1788,  1789,   481,   517,   518,  4474,  3307,
    1231,  2974,  2938,  4161,  1209,  2939,  1196,  1585,  2203, -2967,
   -2989,   522,  2943,  3855,  3760,  2946,  2965,  2219,  1989,  1310,
    1138,  1723,  3262, -3107,  3814,   837,  1571,  3073,  3074,  1934,
    -818,   293,  3262,   258, -3107,  3297,  2689, -2969, -2771, -3107,
    4425,   207,  3331, -3107,   233,  2168,  3517,   973,  2765,  2799,
    4080,  2187,   768,   160,  2442,  1593,  3034,  1146, -3107,    52,
    4269, -3109,    52,  1003,  2661,  3805,   854,  2417,  3421,  2662,
    2188,  -818,  -818, -3107,  3332,   833,  2388,  1973, -3107, -3050,
    3089,  3064, -2830,  2776,   643,  2006,   239,  1288,  3013,  2762,
     746, -3107,   854,   181, -2615, -3107,  1671,  3699,  1260,  3414,
     652, -3107,  4162,   954,  3415,  3707,  1956,   273, -3107, -2989,
    4131,  1534,  1185,    -6,  1597,  1566,  3008,  2663,  3045,    22,
    4163,   253,  2617,  2847,  1194, -3024,  1273, -2168,  2692,   696,
    1202,  3881, -2168,  2789,  2626,   953,  3863,  2461, -2959,  -770,
    4064,  3708, -2959,  4081,  4078,  1055,    -6,  2736,    -6,   524,
    1253, -3107,   714,  3810, -3107,  1146, -2740,  3827, -2738,  1153,
    2738,  1303,  4304,  2203,  3784,  1153,  2525,  2119,  3046,  2738,
    2843,   207,   523,  1303,   853,  4210,  1598,   868,  1562,  3088,
   -2168, -3070, -1337, -3105,    52,  1846,   147,   735, -1337,   834,
    1545,  3045,  3308,  3874,   738,   739,  2223,  4297,  3000,  2203,
    4453,  3500,  2870,  3636,  3799,   492, -1335,   959, -3107,  1853,
     983,  4298, -1335,   990,   745,  1529,   448,  4465,  3416,  1024,
     762,   748,    52,  1983,  2420,     3,  1990,  1756,    52,  2814,
    2706,   148,  2421,  2219,  4469,  1847, -2959,  2224,   854,  1050,
   -2959,  3046,  1001,  1216,   929,  2854,  1983,  1003,  3871,  4407,
   -3107,  1303,  3874,   284, -2676,  1612,  3836,  4210,  3312,  3486,
    2737,  2215,  4167,  1187,  -818,  4064,  3575,   502,   273,  3465,
    1923,   833,   833,   833,  4164,  1873,    18,  3044,  3708,  3461,
    2739,  1204, -1337,  1599,   502,  2844,  3849,   254,  2618,  2741,
    2011,  3767, -3107,  3026,  3473,   259, -3095,  3610,   501,  3954,
    2766,  2526,  3192,  1790,   840,  -770, -1335,  1530,   862,  3264,
     843,   207,  2203,   502,   253, -1337,  3309, -1337,  -818,  3760,
     862,   931,   181,  1680, -3107,  3048,  2811,   525,   862,  2790,
     653,  1583,  3391,   834,   960,   789,   249,   790,  1991, -1335,
    1535, -1335,   786,   787,   503,   988,   502,   988,   998,   502,
    1021,   960,  4372,  3757,  1128,  2410,  2203,  1953, -3099,   697,
     504,   503,  2848,   462, -3107,  4132,  2537,  3065, -3107,   702,
    2189,  4426,   274,  3742,  2203,   988,  2404,   504,    -6,  2203,
     858,   789, -3108,   790,    23,   240,   501,  3035,  3528,  1564,
     503,  3287,  3910,  3986,  1002,  2548,  2778,  2549,  1215,   258,
    1254,  2703,   448, -2969,   259,   769,   504,   644,  3260, -2615,
    1098,  3501,  3310,  1234,   789,   474,   790,  3882, -3107,  3768,
    2418,   181,  4082,   503,   701,  2616,   503,  1522,  2190,   260,
    1096,   207,   502,   728,  2693,   918,   751,  3508,   755,   504,
    3360, -2676,   504, -3109,  2408,  3769,  1274,   234,  3625,  3797,
    1217,  2218,  3392,  1558, -3109,  1003,  1689,  1864,   502,  1521,
    1475, -2993, -2959,  2191,  1792,   829,   797,   932,  3911,  2481,
     474,   844,   858,   474,   297,   474,  1805,  1805,  1805,   833,
     254,   960, -2554,  2160, -2989,  2433,  -818,  3597,   474,  2499,
    1756, -2967,  1825, -3107,  2777,  1958,  2007,  1450,  3432,   760,
     789, -2967,   790,   207,  -283,   474,  1224,  1974,  3637,   503,
    3529,  4199,   797,   534,  2907,   840,  4206,   505,   524,  2576,
    3298,  2803,  1849,  3053,   474,   504,   789,  2837,   790,   261,
    4275,  1850,  3856,   274,   505,   503,  1854,   862,   260,  1205,
   -3065,  3180,  3546,  2461, -2055,   797,  2204, -1337,  3179,  2123,
    1853,   504,  3762,  3629,  4270,  3021,  3393,  3333,  3181,  3262,
   -2959,  3265, -3009,   505,  4254, -3099,  2192,  2749,  1944,  3761,
    2975, -1335,   258,   186,  4097,  3800, -2969,  2800,  3284,  1856,
     186,  3285, -2967,  2155,  3014,  1874,   186, -2973,  4110,   828,
     682,  2204,  1476,   186,   856,  2004,   505,  4083,  2492,   505,
     186,  1149,  3611,  3422,   502,  3967,   856,  2446,   862, -1342,
    2446, -2959, -2959,  3394,   856,  4155,   442,   833,   833,   833,
     862,  2459,  2629,  4427,   833,   833,   833,  1812, -3024,   474,
    1812,   797,  3417,  1027,   224,  1584,   856,  3987,   261,   506,
     833,  2205,  1812,   833,  3177,   186,  3311,  2877,  1690,   833,
     833,   833,   833,   833,  2540,  1520,   506,   797,  3759,   502,
    3312,   829,   829,   829,  1055,   945,  2118,   186, -3009,  3727,
    3728,  2538,   789,  2193,   790,   998,  3509,   474,   449,   833,
    2874,   503,   505,   186,   833,   506, -2826,   225,  1747,  2878,
    1658,   862,  1659,  1027,  1584,  1663,   525,   504,   862,  1674,
     858,  2012,  1567,  3492,  1673,  3015,  3591,  3753,   505, -2959,
   -2959,  2401,  2402,   854,   960,  3770,  3419,   507,   506,  1678,
    1141,   506,  1197,  1656,  1657,  2719,   262,  1198,  -818,  3864,
   -2967, -3009,   929,  1666,   507,  1686,   503,   497,   474,   485,
   -2967,  3530,   482,   186,   474,  1681,  2204,   502,   207,  1992,
    1039, -1342,   504,  1568,  3292, -3107,   201,  2878,  3612,   188,
     188,   474,  3678,   507,  1280,   493,   186,  2392,  2393,   188,
     259,   677,   131,  2398,  1039,  1985,  2399,   186,  3837,  3700,
    1855,   131,  2204,   474,   474,   828,   828,   828,   442,   186,
    4156,  3819, -3107,  3531,   858,  1303,   507,  2493, -2967,   507,
     186,  2498,   186,   797,   506, -2168, -2168, -3107,  3798,   186,
     250,  1651,   186,  1934,   508,   474,  1129,  1517,  2157,  1848,
    -818, -2967,  4394,   856,   503, -1340,   960,  2497,  2468,  2469,
     506,   508,  2435,  3359,  1039,  3361,  2488,   463,  4373,  1924,
     504, -2828, -3107,  1040, -3107,   474,   186,  2194,  2407, -3070,
    4220,   775,   450,   831,   505,  2990,   848,  3762,  2491,  2917,
     508,   871,  1822,   906,   449,  -283,  3332,  1040,  -559,   829,
    1687,  3250,  3251,  3252,  3253,  3513,  3395,  2478,  4227,   186,
     949,   952,   507,  1701,   451,   949,   186,   186,  2208,  1873,
    3313,   442,   981,   508,   856,  2204,   508,  3877,  3402,  3241,
    2985,  1697,  3433, -3107,   260,  3859,   856,  1026,   507,   505,
    3045, -3095,  2576, -3107,   535,  3955,  3097,  3988,  2409,   702,
     186,  1048,  3626,  1054,  1057,  1925,  1512,  1040,   298,   299,
     300,   932,   703,  2896,  3268,  3632,  3977,  3182,   833,  2204,
    3620,   186,  -283,   259,  3997,  3998,   186,  3032, -3089,   289,
    3912,   701,  3548,  3989,  1822,  3627,  4042,  2204,  -283,   186,
    3046, -2676,  2204,  3161,   283,   186, -3132, -1340,  3479,  3913,
   -2676, -2676,  3396,  2667,  2647, -2676,   506,   856,    26,   508,
    1872,  3269,  2470,  3271,   856,   840,  3914,  1756,   959,  2165,
   -2824,   186,  4073,   828,  3389,  3658,  3434,   505,  3211,  3986,
    4043,  1197,   536,   736,   261,   508,  1198,   829,   829,   829,
    1164,   752,   529,   530,   829,   829,   829,  1977,  2929,  3547,
    1216,  2164,   858,   474,  3536,    52,  2665,  3302,   207,  2510,
     829,   506, -3133,   829, -2822,  4069,   833, -2967,   450,   829,
     829,   829,   829,   829,   301,  1225,  2545,  2479,  2940,  1193,
    1193,  1193, -2817,  1558,   507,  1102,  2581,  2502,  1963,  4070,
    2201,  1964,  1965,  2684,   186,  2792,  2584,  2522,  3383,   829,
     451, -3107,   181,  2685,   829,   848,  -559,   260,  2841,   502,
     873,  4443, -3107,   843,  2589,   107,  3905,  2868,  3352,  3183,
    3354,   483,  2472,  2592,  2826,  2827,  3428,  2647,   874,  4432,
    2829,  2830,  1241,   207,  2738,  2332,  4074,  3749,   484,   507,
    3752, -1307,  2738,  2492, -2740,  -283,  1602,    -7,  3523,   506,
   -3009,  3480,  1603,    27,  3184,  3383, -3107,  1469,   531,  3185,
     866,   828,   828,   828,  1027,  4044,  2327,   186,   828,   828,
     828,  2400,  2328,  1130,  2756,  2771,  2772,   789,  1819,   790,
   -3107,   508,   153,  2894,   828,   161,   503,   828, -1774, -2830,
    3276,  2512,  3009,   828,   828,   828,   828,   828,  4374,    28,
      65,   181,   504,   643,    52,  1311, -3107,   261,  4448,   862,
    1988,  3193,  1822,  1197,  4075,  1482,  1484,  3621,  1198,   537,
    4449,    52,   186,   828,   538,  2944,  2945,   507,   828,  2734,
    1901,   485,  2930,  3498,   186,  1519,   508,  2397,  4073,  2397,
    2180,  2397,  2397,  4045,  2397,  2397,   207, -3107,  4199,   442,
    2624,  3816,  1703,  1558,  2743,  1867,  1704,  1217,  2966,  2773,
    2968,  1556,  2745,  3831,  3832,  2705,   114,  -283,  1131,   474,
    1819,  4258,   862,  3987,  1103,  3659,   108,   539,  1003,  4258,
    2990,  3604,   875,  3194,  1812,  1926,  3940,  1193,  4042,   302,
     303,  3605,    66,  1592,  2525,  1930,  1931,  1932,  3579,    35,
    2513,  2648,   304,  1989,  2480,  1962,  1822, -3038,   797,  1963,
     186,   747,  1964,  1965,  2625,  3377,  1609,  3378,  2933, -1330,
    1614,  1616,  3012,   474,   508,  4046,  1985,   502,  2805,  2391,
    2670,  2546,  4043,  2941,  4444,   290,  3505,  2202,  -951,  2197,
     474,  2751,  2493,   483,  1765,  -283,   162,  2617,   474,  2641,
      67,  1766,  4074,    68,  2130,    69,  2394,  2395,   829,   505,
    1104,  3017,  3032, -2989,  3524,   188,  3906,  3086,  3010,   464,
     284,  4330,  3789,  3476,  2897,   207,    70,  2873,  3974,  3333,
     929,  1303,  1944,    36,  -951,  2340,   532,  2243,  1933,  3999,
     753,  2320,  2323,  -559,  2326,  3622,  -951,  2331,  2333,  -283,
    2335,   207,  3075,  3680,   503,  1629,  -559,  2738,   207,  -283,
     921,  2131,  2132,  2133,  2134,  4332,  2135,   959,  1760,  1761,
     504,   960, -2989,  1104,  2648,  1193,  1193,  1193,  -283,  2526,
    4075,  3614,  1193,  1193,  1193,  1810,  3537,  1105,  1810,  3233,
    2768,  -951,  -283,  3234,   754,  3693,   465,  3538,  1193,  1630,
    1810,  1193, -3132,  1107,  2157,   731,   829,  1193,  1193,  1193,
    1193,  1193,   466,  2994,  -951,   -43, -3132,  4044,   186,    71,
    1470,  3643,  1054,   186,  1844,  2506,   702,  2437,  1558,  2992,
     464,   506,   828,  2438,  3245,  2524,  2439,  1193,  2440,   703,
     502,   740,  1193,  3276,  3598,   856,  2136,  2137,  1819,  2806,
    1105, -1774,  3615,  1106,  2995,  4257,  2906,  4076,   876,  4260,
    2881,  1990,  2472,  2618,   186,  1631,  1107,  4260, -3133,   115,
    2843,  -951,   116,   117,  1904,   960,   644,  2747,  4077,     9,
     862,    10, -3133,  3087,   862,  3639,  2828,  3222,  3223,  1471,
    2698,  2700,  3995,  4215,  2178,  4045,  1108,  3644,  3645,   840,
    4333,   186,  4222,  3988,  1934,   186, -2989,   465,   856,   507,
    3217,   732,   733,   474,   186,  1966,  1967,   503, -1330,   186,
   -1774, -1968,  3977,   466, -1330,    41,  1705,   505,  4159,  4160,
     828,  3918,   186,   504, -3089,  1574,  4438,  4116,  4117,  3989,
    2435,  3681,  1819,  2492,  3080, -3107,  2670,  3679,  2670,  3919,
    2435,  3945,  -951,   474, -2991,  2755,  2341,  1522,  3681,  3934,
    1109, -1307,  2761,  4258,  3995,  2521,  1968,  1969,  4211,   467,
    4312,  3818,  3975,  1991,   862,  4214,  2774,  4046,  4335,  4217,
    2350,  4000,  4219,  3363,  1504,  2844,  1935,  1936,    72,  1521,
     969,   922,   186, -2021,  1765,   923,   991,  2623, -1968,  3567,
    2547,  1766,   673,  3682,  4261,  4266,   508,  3946,  1558,  2557,
    2342,  2931,   130,  2448, -1968,  4248,  3204,  3205, -1330,  4249,
    3682,  4418,  -951,  1109,    39,   924,  2138,  2139,  2140,  2141,
    2142,  2143,  2144,  2145,  2146,  2351,  2420,  1575,   833,   833,
    2927,  1935,  1936,  1576,  2421,  4302,  3947,   181,  2932,   506,
    3719, -1330,   186, -1330,  3790, -3038,  2670,  2670,  4197,  4198,
    4336,   502,  4419,  1937,  1938,  3683,  1697, -2775,    44,   978,
    2933, -2775,   985,   474,  2775,  1706,  1707,  1000,  4278,    73,
     467,   445,  1110,  1505,    45,   186,    52,  -497,   186,   476,
     505,   468, -2021,  1828,  4439,  4279,  1193,    52,  4433,  4303,
    1632,  1506,  -951,  4293,  1197,  3935,  4294,  1199,   207,  1198,
   -2021,  3936,  2525,   446,  4441, -3089,   500,  1200,  1937,  1938,
    2916,  4103,   925,  1633,  4118,  4119,  3974,   507,  4440,  4280,
    1939,  -497,  4297,  4417,  -951,  3247,  1966,  1967,   503,    46,
    4382,  2967,  2493,  2969,   207,  1110,  4298,  2163,  4442,    50,
    1111,  1112,  4398,  4302,   504,   842,  4392,  2147,  2698,  2171,
    2698,  2173,  4387,    52,  1940,  4388,   856,   911,  2671,   469,
     856, -1968,  2899,  1941,  2127,   674,  3257,   862,   862,   862,
    4454,  4455,  1942,    54,  2909,  3935,  4281,  1968,  1969,   840,
    3891,  3936,  3047,   913,  1193,  3258,  4259,  -497,  2209,  3892,
      56,  4260,   468,  2128,   914,   858,  2709,  4399,  2920,  4282,
     186,  1556,   506,  2675,  2676,  2677,  2678,  2679,  2680,  2681,
    2682,  2430,  4360,  1943,   508,  1197,  2867,  1237,  2867,  4389,
    1198,   208,  -951,    76,   209,  3248, -3089,    57,  1303,   960,
    4297,  3198,  4104,  3364,   675,   208,  4258,  2526,   209,    33,
      34,  1197,  3976,  2454,  4298,  1507,  1198,  1113,  2455,  2183,
     856, -3089, -3089, -3089, -2021,  2758,   470,  4105,  4106,  4107,
    2184,  3977,  2207,  2881,   960,   862,  1197,    61,   171,  1985,
     469,  1198,  1197, -1330,   119,   858,  1245,  1198,  3978,  3813,
     507,    62,  2422, -1968,  2423,  3386,  2148,   676,  1794,  1797,
    1800,   120,  4386,  3370,  2735,  -951,   833,  3371,   833,  -951,
    -497,   505,  2588,    79,  2782,  1831,  1832,  1634,  1812,  2149,
    1113,  2795,  1635,  2474,  1827, -2959,  2476,  2833,   122,  2835,
    4422,  2397,   833,  1978,  2482,  4424,  2867,  2867,  2486,  1636,
    4138,  1637,  1833,  1834,  1835,  2489,  2816,  1517,   154,  4144,
     677,  2500,  1980,  1981,  1982,   124,   833,  4147,   126,  4395,
    4397,  1197,  3256,    80,  -497,  1760,  1198,  2914,  4456,   128,
    3975, -1968,  2670,   186,  3232,  2842,   127,   470,  3059,  2842,
    3522,  1556,   908,   134,  1992,  -951,  3063,   508,  4479,  4437,
    4480,   188,  4481,   935,   142,  2882,  2883,  1197,   135,   186,
    3244,   143,  1198,  2473,   966,   968,  2769,  4447,     9,  2320,
      10,  1197,  1810,   849,   145,   442,  1198,   181,  -497,  2523,
    2422,  4420,  2423,   141,  2802,  4290,    65,   146,   829,   829,
     156,  1558,  -497,   506,  2671,  1192,  2671,  1195,   158,  1558,
     165,    81,   168,  1944,  2755,  -951,   170,  1945,  2797,  1946,
     175,  2875,  2876,  4047, -1968,  -497,  1807,  1808,   186,   177,
     178,  4482,  2991,   856,   856,   856,   186,  2809, -1968,   189,
     197,   201,   678,  4310,  4311,   216,  2818,  2819,   217,  4315,
     227,   229,  4355,   252,  4260,   257,  4356,  4357,   218,  3283,
     220,   960,   960,  4136,   221,   228,  1638,   960,   960,   960,
     960,   262,  1945,  4136,  1946,   960,  2890,   960,  3278,   960,
     232,   507,  1904, -3089,   256,  3324,  2560,   437,    66,   444,
    2655,   487,  2839,  2840,  2937,  -951,   833, -2708, -2708, -2708,
   -2708,  1267,  1268,  1269,  1270, -2707, -2707, -2707, -2707,   478,
     488,   479,   188,   495,  2671,  2671,  1558,  1909,  1910,  1911,
    1912,   512,   828,   828,   516,   521,  1184,  1558,  2865,   862,
     658,   856,  3574,   636,   687,  2871,  1639,   862,   698,  3386,
    2742,  2744,  2746,  2748,  2914,   699,    67,   713,   728,    68,
     711,    69,   743,  -951,   744,  2593,  1104,   207,  2594,   749,
    2595,  2596,  2597,   750,   756,   760,  1521,   758,   757,   765,
     260,   766,    70,   864,   960,  3664,  2611,   960,   508,  1157,
    2612,   910,  2613,   186,   960,   960,   960,   960,  2622,   932,
     941,   969,  4400,   862,   977,   862,  3641,   442,  1062,  1063,
    1027,  1064,  4401,  4402, -3089,  1070,  1076,  1082,  2886,  1094,
    2888,  1092,  1099,  1101,  1521,  1124,  2891,  2892,  2893,  -497,
    3976,  1127,  1184,  2898,  -497,  1137,  1143,  1158,  1160, -3089,
   -3089, -3089,  1162,  1105,  2910,  2911,  1106,  1165,  1299,  3977,
    3413,  -497,  1166,  -497,  1985,  1167,  1169,  1172,  1173,  1107,
    1174,  1175,  1178,  1180,  1188,   862,  3978,   862,  1190,  1191,
    1219,  1201,  1208,  1210,  1228,    71,   829,  1222,   829,  1237,
    1235,  1239,  1242,  1247,   715,  1244,  1249,  4403,  1251,  1108,
    1271,  1262,  1498,  1275,  3518,  1276,  1277,  1301,  1304,  1306,
    1486,  1496,   829,  1500,  1499,  1502,  1524,  1527,  1537,  4404,
    4405,  1525,  1532,   716,  1539,  1519,  1543,  1542,  2640,  1547,
    2670,  1549,  1551,  1559,  1003,  1563,   829,  1570,  1572,  3118,
     717,   718,  1584,  2397,  2397,  4047,  2397,  2397,  2833,  1586,
    1588,  1594,  1601,  1605,  1607,  1610,  1618,   862,  1619,  1620,
    1624,  2645,  1625,  1580,  1628,  1626,  2646,  1309,  1669,  2858,
    1591,   960,   181,  1683,  1184,  2664,  1556,  1694,  1711,  1762,
    1793,  1803,  1815,  1804,  1829,  3119,  1814,  4361,  1824,  1838,
    1836,   834,  3833,  3834,  1856,  3578,  1851,  3120,  3209,  1254,
    1863,  1253,  1523,  1906,  1908,  1953,  1193,  1193,  1920,  1959,
     828,  1972,   828,  2704,  1475,  2009,  1998,  2000,  -497,  2002,
    4361,  2716,  2716,  2117,  2121,  2159,  1109,  2129,  4337,  2722,
    2124,  2158,  2161,  2900,  2901,   856,   828,  3114,  3502,   474,
    3503,  2166,  3121,   856,  2169,  2176,  2177,  2991,  2179,  2186,
    2671,  2211,  1581,  2213,    72,   719,  2214,  3569,  2219,  2221,
     828,  2227,  2229,  3152,  2235,  3122,  2921,  2922,   188,  2236,
    2237,  2239,  2324,  2336,  2338,   188,  2343,  2403,  2419,  2411,
    2429,  2430,  2444,  2448,  2451,  2453,  2457,  2450,  -497,  2458,
    2461,  2463,  2464,  2475,  2465,  2467,  2477,  2483,  2484,   856,
    2485,   856,  3188,  2487,  2490,  3189,   829,  3190,  3191,  2501,
    4052,   131,  3197,  3928,  3200,  3201,  3202,  3203,  2976, -2661,
    1821,   960,  3123,  2503,  3210,  2507,  2979,  2509,  2515,  2518,
    2519,  2577,  2531,  2563,  2397,  2565,  2566,  2568, -3048,  2579,
    2586,  2590,  2598,  2599,  1517,    73,  2620,  3224,  1110,    74,
    2627,   973,  2642,  2666,  2673,  2656,  2657,  2695,  2707,  2710,
    2711,   856,  2720,   856,  2723,  4059,  1521,  2725,  1521,  2728,
    2729,  2730,  1157,  2734,  3019,  2733,  2752,  2749,  1157,  2670,
    3870,  2759,  3239,   501, -3048,  2762,  2781,  2764,  3039,  3040,
    2786,  2796,  1517,  2807,   258,  3101, -3048,  2820,  1184,  2821,
     960,  2822,  2823,  3124,  2872,  1756, -2752,  2889,  2493, -2739,
    2918,  1913,  1915,  2492,  2525,  2526,   862,  2942,   862,  2971,
     720,  2972,  2980,  1521,  2993,  2981,  2855,  2988,  3001, -2732,
     828,   721,  3002,  3023,  1299,  3007,  3024,  2648,   501,  2647,
    3050, -3048,  1219,   856,  3076,  3081,  3079,  3069,  3083,  1119,
    3101,  1509,  3090,  1760,  3091,  3094,  3099,  3115,  3117,  3100,
      75,  3143,   862,  3146, -3048,  3717,  3718,  3148,  3149,  3159,
    3163,  3154,  1861,  3126,  1193,  3165,  1193,  3168,  3172,  3170,
    3175,  1120,  1121,  3212,  3214,  3221,  1810,  3219,  1878,  3227,
    3229,  3225,  3238, -2666,  3242,  3246, -2737,  3281,  2994,    76,
    1193,  3270,  3272,  2913,  3287,  2995,  1509,  3294,  3296,  3301,
    3303,  3306,  3320,  3325,  3034,  3326,  3035,  3340,  3343,  3064,
    3355, -3048,  3065,  1113,  1193,   862,  3375,  3380,  3407,  2670,
    3381,   848,  3398,  3400,  2397,  3403,  3405,  3409,  3410,  4166,
    3412,  3483,   147,  1075,  3487,    77,  3474,    78,  3484,  3420,
    3511,  3489,  3803,  3127,  3499,  3512,  3426,  3519,  3521,   722,
   -3108,  3535,  3540,  3542,  3549,  3390,  3550,  3363,  3364,  3376,
    3570,  3554,  3580,  3351,  3581,  3583,  3845,  3649,  3585,    79,
    3586,  3589,  3471,  3602,  2978,  3129,  1656,  3603,  3628,  3631,
    3666,  3477,  3478,  3231,  3630,  3665,  3668,   723,  3475,  1556,
    3674,  3695, -3048,  3481,  3705,  3436,  3702,  2611,  3715,  3713,
    3712,  3460,  4052,  3729,   724,  3756,  3463,  3464,  2671,  3737,
    3659,  3795,   188,  3758,  3467,  3658,  3469,  3794,  3719,    80,
    3807,  3018,  3808,  3680,  3829,  1521,  3830,  3835,  3430,  3430,
    2120,   188,  1521,  3761,  3853,  3850,  3851,   188,  3866,  2670,
     188,  3860,   188,   188,  3878,  3888,  3884,  3869,  3900,  3903,
     188,  3930,   188,  3102, -3048,   188,  3932,  3895,  3938,  3939,
    3902,  3942, -3048,  3906,  3941,  3858,  3905,  3971,  4352,  3972,
    3969,  3970,  4061,  3923,  4068,  4095,  3054,  4089,  4099,   960,
    4098,  4102,  3996,  4108,  1193,  4111,  3437,  4115,  4112,  4123,
    4122,  2442,   856,  4146,   856,  2185,  4150,    81,  4171,  3607,
    2913,  4291,  2005, -2830,  1556,  3468,  2200,  3472,  3102,  4312,
     862,  4358,   862,  4414,  1517,  1556,  1517,  1591,  4415,  3482,
    4468,  4470,  4471,  4472,  2216,  4477,  4484,    21,   112,   164,
    3786,   110,   763,   152,   502,   486,   279,   155,   856,   498,
    3526,   520, -3048,  1676,  1123,   282,  3131,   280,  3929, -3048,
    3132,  3880,  3673,   741,  3748,  2614,  4158,  3199,  3732,  3826,
    3207,   737,  3218,  3730,  4100,  3334,  3335,  3431,  2435,  2175,
    3973,  1517,  3582,  4113, -3048,  3438,  3439,  3440,  3341,  3342,
    2630,  1069,  2770,  4331,  3158,  4458,  2242,  3876,  3815,   502,
    2619,  3926,   786,   787,  2199,  3345,  3346,  3169,  4209,  4289,
    4421,   856, -3048,  4423,  3806,  4224,  3925,  4153,  1979,   961,
    4139,   503,  4140,  4067,   988,  1495,  4267,  4151,  4143,  2416,
    3543,  3506,  3226,   436,  1702,  1264,  3133,   504,  2391,  2397,
    1696,  3236,  3240,  2232,  1750,  2443,  2505,  2915,  3504,  3844,
    3842,  3601,  1207,  3491,  1213,  1845,  2559,   786,   787,   909,
    1258,  3481,  3255,  2541,  2928,   848,  1862,  2671,   962,  2977,
    2855,  1266,   725,   726,   188,  3384,   503,  1918,  1921,  3277,
    1146,  3618,  1302,  2582,  3279,  1082,  1997,   188,  3280,  1971,
    2999,  3788,   504,  2600,  3291,  3290,  3134,  3777,  3651,  3534,
    2001,  1503,  2632,  3441,  3442,  3606,  3443,  3793,  3322,  2644,
    3030,  3329,  3339,  3588,  3337,  2172,  2947,   188,  2948,  3085,
    2683,  1558,  3694,  3049,   188,  1022,  1560,  2210,  3062,  3899,
    3103,  1561,  2717,  2718,  3358,  3949,  3792,  2643,   960,  2660,
    3697, -1789,  3775,  4071,  4170,  4086,  2230,  2857,  1871,  2851,
    4087,  3965,  3963,  1869,  3847, -3048,  3783,  3781,  2905, -3048,
    2903, -2959,  3407,  3362,  3348, -2959,  3676,  3726,  3899,  3350,
    2926,  3369,  2924,  3624,  3562,  1015,  3137,  3560,  3055,  3731,
    1212,  2397,  1929,  2580,  3056,  3103,  1928,  3057,  1059,  3058,
    2583,  1546,  1840,  1517,   505,  3424,  3174,   285,  3647,  2602,
    1517,  3671,  1184,  2672,  3286,  3078,   856,  1843,   856,  4142,
    2838,   761,  4226,  1126,  1179,  2244,  3823,  2671,  1558,  2755,
    3510,  2690,  2919,  2640,  3167,  3663,  3791,  3552,  3353,  4363,
    3848,  3261,  4250,  3734,  3139, -3048,  4384,  2780,  3638,  1161,
     188,   188,  4255,  4446,   515,  3305,   764,  3427,  2697,   505,
    2556,  4252,  3733,  4062,  1710,  2834,  2330,  3466,  3735,  4408,
       0,     0,     0,  1521,     0,     0,     0,     0,     0,     0,
       0,  2517,     0,  3802,  3703,     0,     0,     0,   188,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   960,     0,
    3444,  3445,     0,     0,     0, -3048,     0,     0,     0,     0,
       0,     0,  1878,     0,  3557,  3558,     0,  4256,     0, -3048,
       0,     0,     0,   840,  3446,     0,   506,     0,  3736,     0,
    4273,     0,     0,     0,     0,  3385,     0,     0,     0,  3750,
    3751,  3811,  3812, -3048,  3754,  3755,  4367,  2671,     0,     0,
    3447,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3669,   840,  3825,  3825,     0,     0,  3776,     0,
       0,   848,     0,     0,     0,  3448,     0,   188,   188,  3785,
    3894,   506,  1558,     0,     0, -3048,     0,     0,     0,     0,
       0,  3104,     0,  3105,  4225,     0,     0,     0,     0,     0,
     188,   188,  3106,  3107,   507,     0,  3108,  3109,     0,  3796,
    3885,  3886,     0,     0,     0,  2949,     0,     0,   960,     0,
       0,     0,  3944,     0,     0,     0,     0,  3809,     0,     0,
    2768, -3048,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -3048,     0,   840,  3104,     0,  3105, -3048,
       0, -3048,     0,  2165,     0,     0,     0,  3106,  3107,   507,
       0,  3108,  3109,     0,     0,     0,     0,     0,     0,  3497,
       0,     0,  3449,     0,     0,     0,     0,     0,   188,     0,
       0, -1789,     0,     0,     0,  2164,     0,     0,     0,     0,
       0,     0,     0,     0,     0, -2959,     0,     0,     0,  2950,
       0,   508,  3516,     0,     0,  3450,     0,  3933,     0,  3451,
    3452,     0,  4057,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4459,     0,     0,     0,     0,     0,
    3875,     0,     0,     0,  2674,  3453,  3883,     0,  3118,     0,
       0,     0,     0,   188,     0,     0,     0,   960,     0,  3887,
       0,     0,     0,  4060,     0,     0,   508,     0,  2628,     0,
       0,  3551,  1523,     0,     0,     0,     0,     0,     0,  3555,
       0,  3556,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3119,     0,     0,     0,     0,   188,
       0,     0,     0,     0,     0,     0,  3120,     0,     0,     0,
       0,     0,     0,     0,     0,  2654,     0,     0,     0,  3778,
    3779,     0,     0,     0,  3950,     0,     0,     0,     0,  4145,
       0,     0,     0,     0,  3968,     0,     0,     0,     0,     0,
       0,  1517,     0,     0,     0,  4004,  4053,     0,     0,     0,
       0,  3121,     0,  2951, -2959, -2959,  2702,     0,     0,     0,
       0,     0,  4065,  4066,     0,     0,     0,     0,     0,  2702,
       0,     0,     0,     0,  3122,     0,     0,  4072,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4173,     0,
    4088,     0,     0,  4091,  4092,  4093,  4094,     0,     0,     0,
     832,     0,     0,  2397,     0,   863,     0,  3454,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   863,  3642,  4204,
       0,  3838,  3839,  3840,     0,   863,     0,     0,     0,     0,
       0,  3123,  4130,     0,     0,     0,     0,  4216,  3654,  3657,
       0,  4137,     0, -1789,  4141,     0,  4223,   863,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3672,     0,     0,  3675,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2952,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3714,     0,
     960,     0,     0,     0,     0,  2817,     0,   960,   833,   833,
       0,   960,  3124,     0,   960,     0,     0,     0,     0,  4178,
    4179,  4180,  4181,  4182,     0,     0,  4184,  4185,  4186,  4187,
    4188,  4189,  4190,  4191,  4192,  4193,  4194,     0,   833,  4196,
       0,     0,     0,     0,     0,     0,     0,  4208,     0,     0,
       0,  4204,     0,     0,     0,     0,   833,     0,  4212,     0,
    4213,     0,     0,     0,     0,     0,  3960,  3961,     0, -1789,
    4221,     0,  3654,     0,  3125,  3657,     0,     0,     0,     0,
       0,     0,  3126,     0,     0,     0,     0,     0,  1186,     0,
       0,  2953,     0,     0,     0,  3156,   832,   832,   832,  4204,
    4204,     0,     0,     0,     0,  4204,  1203,     0,  4204,     0,
     833,     0,  4204,  4204,     0,     0,     0,     0,     0,  1556,
       0,     0,  4365,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   863,   960,     0,     0,   960,     0,
       0,     0,     0,     0,     0,     0,     0,  4383,  4053,     0,
       0,  2247,  2248,  2249,  2250,  2251,     0,  2252,  2253,     0,
       0,     0,  3127,  4393,     0,     0,     0,     0,   474,  3128,
       0,     0,     0,     0,     0,     0,  4204,     0,     0,     0,
    4383,  4204,  1184,     0,     0,     0,     0,     0,     0,     0,
       0,  4431,  3846,     0,  3129,     0,     0,     0,     0,     0,
       0,     0,     0,  4300,  4301,   863,  4306,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1556,   863,     0,     0,
       0,     0,  3130,  4309,     0,     0,     0,     0,  4313,  4314,
       0,  3052,     0,     0,  2255,     0,  2256,  2257,  2137,  2258,
    2259,  2260,  2261,  2262,  2263,     0,  4364,     0,     0,  4366,
       0,     0,  4368,     0,  3061,  3061,     0,     0,     0,     0,
    3005,  3072,     0,     0,     0,  3889,     0,     0,     0,     0,
    3890,  4483,     0,     0,     0,     0,     0,     0,  1557,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   863,     0,
       0,  3033,     0,     0,     0,   863,     0,     0,     0,     0,
       0,     0,     0,     0,   832,     0,  2264,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3953,  3958,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3983,  3994,
       0,     0,     0,  4056,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3131,  2654,     0,     0,  3132,
    1556,  3953,     0,     0,     0,     0,  3958,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4090,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   829,   829,
       0,     0,     0,  4101,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4114,     0,     0,  2265,  2266,  2267,
    2268,  2269,     0,     0,  2145,  2270,  4129,     0,   829,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2163,   832,   832,   832,  3133,   829,     0,     0,   832,
     832,   832,  1811,     0,     0,  1811,     0,     0,  4148,  1823,
    2271,  4149,     0,     0,     0,   832,     0,  1811,   832,     0,
       0,     0,     0,     0,   832,   832,   832,   832,   832,     0,
       0,     0,     0,     0,  2272,     0,     0,     0,     0,     0,
   -1619,  3254,     0,     0,     0, -1619,     0,     0,     0,     0,
     829,     0,     0,     0,   832,  3134,     0,     0,  4172,   832,
       0,  4174,  4175,  4176,  4177,     0,     0,     0,     0,  3135,
       0,  4183,   828,   828,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4195,     0,     0,     0,     0,     0,
    4203,  1905,     0,  3136,     0,     0,  4129,  4129,     0,     0,
       0,  1823,   828,     0,     0,     0,     0,     0,  2855,     0,
       0,     0,  2219,     0,     0,     0,     0,  2855,     0,     0,
     828,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3323,     0,     0,  3137,     0,     0,     0,     0,
       0,  2275,     0,     0,     0,     0,     0,     0,  4228,  4229,
    4230,  4231,  4232,  4233,  4234,  4235,  4236,  4237,  4238,  4239,
    4240,  4241,  4242,  4243,  4244,  4245,  4246,     0,     0,     0,
       0,     0,     0,     0,   828,     0,     0,     0,   848,  4129,
   -1619,  3138,     0,     0,     0, -2967, -1619, -1619,     0,     0,
       0,   848,     0,  3139,     0,     0,     0,     0,     0,  3140,
       0,  3141, -1619,  4276,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3318,  4277,  2277,     0,     0,     0,
       0,     0,  4203,     0,     0,     0,  3330,     0,     0,     0,
       0,     0,     0,     0,     0,  2570,     0,  2279,     0,     0,
       0,     0,     0,     0,     0, -2536,  4295,  4296,     0,     0,
   -2536,     0,     0,     0, -2536, -2536, -2536,     0,     0,     0,
    2280,     0, -2536,  2571,     0,  4308,     0,     0,     0,     0,
    4203,  4203,     0,     0,     0,     0,  4203,     0,  4354,  4203,
       0,     0,     0,  4203,  4203,     0,     0,     0,  3374,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4369,
       0,  1987,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   832,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4385,     0,   863,     0,     0,  1823,
       0,     0,     0,     0,     0,     0,  1193,  1193,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -2536,     0,     0,
       0,     0,     0,     0,     0,  4430,     0,     0,  3493,  3494,
    3495,  3496,     0,     0,     0,     0,  1193, -1619, -1619, -1619,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -1619,
       0,  2284,  2285,  2286,  1193, -2536,  4452,  4452,     0,   863,
       0, -2536, -2536,     0,     0,     0,  3514,  3515,     0,     0,
    4457,     0,     0,     0,     0,  4460, -1619, -2536,     0,     0,
       0,   832,     0,     0,     0,  4463,  4467,     0,     0,     0,
       0,  4452,     0,  1823,     0,     0,     0,     0,  1557,  4476,
       0,     0,     0,     0,     0,     0,     0,     0,  1193,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -1619, -1619, -1619,     0,  1763,  1764,
       0,     0,     0,     0, -1619,     0, -1619,     0,     0,     0,
       0,     0,     0, -1619,     0,     0,     0, -1619, -1619, -1619,
       0,     0,     0,     0,     0,     0, -1619,     0,     0, -1619,
       0,  2289,  2290,  2291,     0,     0,     0,     0,     0,     0,
       0,     0,  3318, -2536,     0, -1619,     0,  2603,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -2536,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3157,     0,     0,     0,     0,  1765,
       0,     0,     0,     0,     0,     0,  1766,     0,     0,  1767,
    3566,     0, -2536, -2536, -2536,     0,     0,     0,     0, -1619,
       0,     0,     0,     0, -2536,     0, -1619,     0,     0,     0,
       0,     0,     0,     0,     0, -2536, -2536,     0,  1557,     0,
       0,     0,     0,     0,     0, -1619,     0,     0,     0,     0,
    2604, -2536,     0,     0,     0,     0,     0,     0,     0,  3650,
       0,     0,  3596,  1768,     0,  1769,  1770,     0,     0,  1811,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -2536,     0,     0,     0,     0,     0,   863,     0,     0,
       0,   863,   777,     0,     0,     0, -1619,     0,   778,   779,
       0,  1879,  1880,  1881,  1882,     0,     0,     0,  1883, -2536,
   -2536, -2536, -2536, -2536,   781,     0,     0, -2967,     0, -2536,
    3634, -2536,     0,     0,     0,     0,  1884,  1885, -2536,     0,
       0,     0, -2536, -2536, -2536,     0,     0,     0,     0,     0,
       0, -2536,     0,     0, -2536,     0, -1619,  1771,     0,  1772,
       0,     0,     0,     0,     0,     0,  1773,     0,     0,     0,
   -2536,     0,     0,     0,  1774,     0,     0,     0,     0,  1905,
       0,     0,     0,   936,     0,  1886,     0,     0,     0, -2536,
       0,   863,     0, -2536,     0,     0,     0,     0, -2536,     0,
       0,  3773, -2536, -2536, -2536,     0,     0,     0,     0,     0,
   -2536,  3566,     0, -2536,     0,     0,     0,     0,     0,     0,
   -1619,     0,     0, -2536,  1887,     0,     0,     0, -1619,     0,
       0,     0, -2536,     0, -2536,     0,     0,     0,     0,     0,
       0, -2536,     0,     0,     0,     0,     0, -2536,     0,     0,
       0,     0,     0,     0, -1619, -1619,     0,     0,     0,     0,
   -2536,     0,     0,     0,     0,     0,     0,  3745,  3747,  3745,
       0,     0,  1987,  1557,     0,     0,     0,     0,     0,     0,
    1775,     0, -2536,     0,     0,     0,     0,     0,     0,   782,
     783,   784,     0,     0,     0, -2536,     0,     0,     0,     0,
       0,   785,     0,     0,     0,     0, -1619,     0,     0,     0,
       0, -2536,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -1619,     0,     0,     0,   502,     0,
    1776,   501,     0, -2536,  1777, -1619,     0,     0,     0, -2536,
   -2536,     0,  1888,     0,     0,     0,     0,     0,     0,     0,
       0, -1619,     0,     0,     0, -2536,     0,     0,     0, -1619,
       0, -2536,     0,     0,     0,     0, -2967,     0,     0,     0,
    1003,     0,     0,     0,     0,     0,     0,     0,     0,  3821,
    2605,     0,     0, -1619,     0,  3821,     0,     0,   788, -1619,
       0,     0,     0,     0,   863,   863,   863,     0,  1889,     0,
       0,     0,     0, -1619,     0,   503,     0,     0,     0,   791,
     792,   793,     0,     0,     0,     0,     0,     0,   794,     0,
       0,   504,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -2536,     0,     0,     0,  1890,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1557,     0,     0,     0,     0,     0, -2536,
   -2536, -2536,     0,     0,     0,     0,   777,     0,     0,     0,
       0,     0,   778,   779,     0,     0,     0,  2635, -2536,     0,
       0,     0,     0,   832,   832,     0,     0,     0,   781,     0,
       0,     0,   863,     0,     0,     0,     0,     0, -2536,     0,
   -2536,   796, -2536,     0,  2572,     0, -2536,     0, -2536, -2536,
   -2536, -2536,     0, -2536, -2536,  2573,     0,     0,     0,     0,
   -2536, -2536, -2536,     0,     0,     0,     0,     0,     0, -2536,
    1891,     0, -2536,     0,     0,     0,     0,     0,     0,     0,
    1652,     0,     0, -2536, -2536,  -255,     0,     0,  -255,     0,
       0,     0,     0,     0,     0,     0, -2536,     0,     0, -2536,
       0,     0,     0,     0, -2536,     0,  -255,     0,  4005,     0,
       0,     0,     0,     0,     0,  2542,     0,     0,   505,  -255,
       0,     0,     0,     0,  3745,  1778,     0,     0, -2536, -2536,
       0,     0,     0,     0, -2536,     0,  -255,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -2536,     0,
       0,     0,     0,     0,     0,     0,     0, -2536, -2536, -2536,
   -2536, -2536,     0,     0,     0,     0,     0, -2536,   798, -2536,
       0,     0,     0,  1892,     0,     0, -2536,   777,     0,     0,
   -2536, -2536, -2536,   778,   779,     0,     0,     0,     0, -2536,
       0,     0, -2536,   782,   783,   784,     0,     0,     0,   781,
    -255,     0,     0,     0,     0,   785,     0,     0, -2536,  1779,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1780,     0,     0,     0,     0,     0,     0, -2536,     0,     0,
       0,  1781,   502,     0,     0,   936,     0,     0,     0,     0,
     506,     0,     0,     0,     0, -2536,     0,     0,     0,  3745,
   -2536, -2536,     0,     0, -2536, -2536, -2536,     0,     0,     0,
       0, -2536, -2536,     0,     0,     0,   799,   800,     0,     0,
   -2536,     0, -2536,     0,     0,     0,     0,     0,  1737, -2536,
    1738,  1739,     0,     0,     0, -2536,     0,     0,     0,     0,
       0,   832,   788,   832,     0,     0,     0,     0, -2536,     0,
    1893,     0,  1782,  1811,     0,  1894,     0,     0,     0,   503,
       0,     0,     0,   791,   792,   793,   863,   832,   507,     0,
   -2536,     0,   794,     0,   863,   504,     0,     0,     0,     0,
       0,  2606,     0,     0,  1783,     0,   802,     0,     0,     0,
       0,   832,     0,  1895,     0,     0,     0, -2536,     0, -2536,
       0,     0,     0,     0,     0,  1896,     0,     0,     0,     0,
       0,     0,     0,   803,   782,   783,   784,     0,     0,     0,
       0,   804,     0,     0,     0,     0,   785,     0,     0,     0,
     863,     0,   863,     0,     0, -2536,  -255,  -255,     0,     0,
       0, -2536, -2536,     0,     0,   805,     0,     0,     0, -2536,
       0,   186,     0,     0,     0,   796,     0, -2536,     0,     0,
       0,     0,     0,     0,     0,   508,  1557,     0,     0,     0,
       0,     0,     0,     0,  1557,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   863,     0,   863,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1897,     0,     0,     0,     0,     0,
       0,   786,   787,   788,     0,     0,     0,     0,     0,     0,
    -255, -2536,     0,     0,     0,     0,     0,     0,     0,     0,
    3400,     0,   505,     0,   791,   792,   793,     0,     0,     0,
       0,     0,     0,   794,     0,     0,     0, -2536, -2536,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   832,     0, -2536,     0,     0,   776,     0,     0,     0,
       0,   501,     0,     0,   863,  -255,     0,     0,     0,     0,
   -2536,  1557,   798,     0,     0,     0, -2536,     0, -2536,     0,
   -2536,  -255,  1557,     0, -2536,     0, -2536, -2536, -2536, -2536,
       0, -2536, -2536,     0,     0,  1146,     0,     0,     0,     0,
       0,     0,     0, -3107, -3107, -3107, -3107, -2536,     0,     0,
   -3107,     0, -2536, -2536, -2536,     0,   796,     0,     0,     0,
       0,     0,     0,     0, -2536,     0,     0,     0, -3107, -3107,
       0,     0,     0,     0, -2536, -2536, -2536,     0,     0,     0,
       0,     0, -2536,  -255,   506,     0,     0,     0,     0,     0,
       0, -2536,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -2536,     0,     0,     0,
     799,   800, -2536,     0,     0,     0, -2959, -3107,     0,     0,
   -2959, -2536,     0,     0,  -255,     0, -2536,     0,     0,     0,
       0,     0,  -255,     0,     0,     0,   777,     0,     0,     0,
       0,     0,   778,   779,     0,     0,     0,     0,     0, -2536,
   -2536, -2536, -2536, -2536,     0,     0, -3107,     0,   781, -2536,
       0, -2536,   507,     0,     0,     0,     0,     0, -2536,     0,
       0,     0, -2536, -2536, -2536,     0,     0,     0,     0,     0,
     802, -2536,     0,   798, -2536,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -255,     0,     0,
   -2536,     0,     0,     0,     0,     0,     0,   803,     0,     0,
       0,  -255,     0,     0,     0,   804,     0,     0,     0, -2536,
       0,     0,     0,     0,     0,     0,  -255,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   805,
       0,     0,     0, -2536,     0,   186,     0,     0,     0,     0,
       0,     0,     0, -2536,     0,     0,     0,     0,     0,   508,
       0,     0, -2536,   863, -2536,   863, -3107,     0,     0,     0,
       0, -2536,     0,     0, -3107,     0,     0, -2536,     0,     0,
       0,   799,   800,  -255,  -255,     0,     0,     0,     0,  -255,
   -2536,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  -255,     0,     0,     0,     0,     0,   863,
       0,     0, -2536,     0,  1879,  1880,  1881,  1882,     0,     0,
       0,  1883,  -255,   782,   783,   784,     0,     0,     0,     0,
   -3107,     0,     0,     0,     0,   785,     0,   643,     0,  1884,
    1885, -2536,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   802,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   502,     0,     0,     0,     0,     0,     0, -3107,
       0,     0,   863,     0,     0,     0,  -255,     0,   803,     0,
    -255,     0,     0,     0,     0,     0,   804,     0,  1886,     0,
       0, -2536,     0,     0,     0,     0,  -255,  -255,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     805,     0,     0,     0,     0,     0,   186,     0,     0,     0,
     786,   787,   788,     0,     0,     0,     0,  1887,     0,     0,
     789,     0,   790,     0,     0,     0,     0,     0,     0,   503,
   -2959,     0,     0,   791,   792,   793,     0,     0,     0,     0,
       0,     0,   794,     0,     0,   504,     0,     0,     0,     0,
       0,     0, -3107, -2536,     0,     0,     0,     0,     0,     0,
       0,   795,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1149,     0,     0,     0,     0,     0,     0,     0, -2536,
   -2536,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -3107,     0, -2845,
       0,     0,     0, -3107,  1312,     0,     0,     0, -2845,     0,
       0,  1313,     0,     0,     0,     0,     0,     0, -2536,     0,
   -2536,     0, -2536, -2845,     0,   796, -2536,     0, -2536, -2536,
   -2536, -2536,     0, -2536, -2536,  1888,     0,     0,     0,     0,
       0,  1314, -2845,     0,     0,     0,     0,     0,     0, -2536,
       0,   797,     0,     0,     0, -3107,     0,   863,     0,   863,
       0, -2845,  1315,  1316,  1317,  1318,  1319,  1320,  1321,  1322,
       0,     0,     0, -2845, -2845, -2845, -2536,  1323, -2845, -2959,
   -2959,     0,  1324,     0, -2536, -2845,     0,     0,     0,     0,
       0,  1889,     0,  1325,  1326,  1327,  1328, -2845,     0, -2845,
   -2845,     0,   505,     0,     0,     0,     0,     0, -2536,     0,
    1329,     0,     0,     0, -2536,     0,     0,     0,     0,     0,
    1330,     0,     0,  1331,  1332,  1333, -2845,  1334, -2536,     0,
    1890,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     644,     0,   798,     0,     0,     0,     0,     0,     0,     0,
   -3107,  1335, -3107, -3107,     0,     0,     0,     0,     0,     0,
    1336,  1337,  1338,  1339,  1340,  1341,  1342,  1343,     0,     0,
       0, -2845, -3107,  1344,  1345,     0,     0, -3107,     0,     0,
       0,     0,     0,     0, -2845,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1346,
    1347,     0,     0,  1348,  1349,     0, -2845, -2845,  1350, -2845,
   -2845,     0,     0,  1891,   506, -3107,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -3107,     0,     0,
    1351,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     799,   800,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -2845,  1352,     0,     0,  3267,  1353,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -2845,
       0,     0,     0,  1354,     0,     0,     0,     0,  1355,  1356,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   507,     0,     0,  1357,  1358,  1359,  1360,  1361,
       0,     0,  1362,     0,     0,     0, -2845, -2845, -2845,     0,
     802,     0,     0,     0,     0,     0,  1892,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -3107,     0, -2845,     0,
       0,     0,     0, -2845,     0,     0,     0,   803,     0,     0,
    1872,  1363,  1364,  1365,  1366,   804,     0,     0,     0,     0,
    1367,  1368,     0,  1369,     0,  1370,  1371,  1372, -2845, -2845,
    1373,     0,  1374,     0, -2845, -2845,  1375,     0,     0,   805,
       0,     0,     0,     0,   474,   186,     0,     0,     0,     0,
       0,     0,     0,   474,     0,  1376,  1377,     0,     0,   508,
       0,     0,     0,     0,  1378,  1379,  1380,  1381,  1382,  1383,
    1879,  1880,  1881,  1882,     0,     0,     0,  1883,  1384,     0,
       0,     0,  1385,     0,     0,     0,  1387,     0, -2845,     0,
   -2845,  1737,     0,  1738,  1739,  1884,  1885,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -2845,     0,     0,
       0,     0,     0,  1893,     0,     0,  3787,     0,  1894,     0,
   -2845, -2845, -2845,     0,     0,  1388,     0,     0,     0,  1389,
       0,  1390,  1391,  1392,  1393,     0,     0,     0,     0,     0,
       0,  1394,     0,     0,  1886,     0,  1557, -2845,     0,     0,
       0,     0,     0,     0,     0,     0,  1895,  1395,     0,     0,
       0,     0,     0,     0,     0,  1396,     0,     0,  1896,     0,
   -2845, -2845, -2845,     0, -2845,     0, -2845, -2845,     0, -2845,
       0, -2845, -2845,  1887,     0,  1488, -2845,     0, -2845, -2845,
   -2845, -2845,     0,     0,     0,     0,     0,     0,     0,     0,
    1397,  1398,     0,     0, -2845,     0,     0,     0,     0,     0,
       0,     0, -2845,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0, -2845, -2845,     0,     0,     0,
       0,     0,     0,  1399, -2845,     0,  1400,     0,     0,     0,
   -2845,     0,     0,  1557,     0,     0,     0,  1401,     0,     0,
       0,     0,     0,  1402,     0,     0,     0,  1403,     0,  1404,
    1405,     0,     0,     0,     0,     0,     0,  1897,     0,     0,
       0,     0,     0,  1406,     0,     0,  1407,  1408,     0,     0,
       0,  1409,     0,     0,     0,     0, -2845,     0,     0,     0,
       0, -2845,     0,     0,     0,  1410,     0,  1411,  1412,     0,
       0,  1888,     0,     0,     0,     0,  1413,  1414,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1415,  1416,  1417,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -2845, -2845, -2845,     0,     0,     0,  1418,  1419,  1420,  1421,
   -2845,  1422,     0,     0,     0,  1423,  1424,  1889,     0,     0,
       0,     0,     0,  1425,  1426,     0,     0,     0,     0,     0,
       0,  1427,  1428,  1429, -2845,     0,     0,     0,     0,  1430,
       0,     0,     0,     0,  1431,     0,     0, -2845, -2845, -2845,
   -2845,     0,     0,     0,     0,     0,  1890,  1557,     0,     0,
       0,   308,  1432,     0,     0,   309,     0, -2845, -2845,     0,
     310,     0,     0,     0,     0,  1433,  1434,   311, -2845,     0,
       0,  1435,     0,     0,     0,     0,   312,  1489,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1436,  1437,     0,     0, -2845,     0,
       0,     0,     0,  1438,     0,     0,     0,     0,     0,     0,
       0,  1439, -2845, -2845,     0,     0,     0,  1440,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   313,   314,  1891,
       0,     0,     0,     0,     0,     0,     0,  1441,     0, -2845,
       0,     0,     0,  1442,     0,     0,     0,     0,     0, -2845,
       0,     0,     0,     0,     0,     0, -2845,   315,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -2845,     0,     0,
       0, -2845, -2845, -2845,     0,     0,     0,   316,     0,     0,
       0,   317,     0,     0,  1443,     0,     0,     0, -2845, -2845,
    1444,     0,  1445, -2845, -2845,  1446, -2845,     0,     0,   318,
       0,     0,  1447, -2845,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1448,     0,     0,  1449,     0,     0,
       0,     0,     0,     0,     0,     0, -1383,     0,     0,     0,
       0,     0,  1892,     0,     0,     0,     0,     0,     0,     0,
     319,     0,     0,     0,     0,     0,   320,     0,   321,     0,
       0,     0,   322,     0,     0,     0,   323,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   324,     0, -1383,     0,     0,     0, -1383,
   -1383, -1383, -1383, -1383,     0, -1383, -1383, -1383, -1383,     0,
   -1383, -1383,     0, -1383, -1383,     0, -1383, -1383, -1383, -1383,
   -1383, -1383, -1383, -1383, -1383, -1383, -1383,     0,     0,   325,
       0,     0,     0,     0,     0,     0,     0, -1383,     0,     0,
       0,     0, -1383,     0,     0,   326,     0,     0,     0,     0,
   -1383,     0,     0,     0,     0,   327,     0,  1737,     0,  1738,
    1739,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   308,     0,     0,     0,   309,     0,  1893,
       0,     0,   310,     0,  1894,     0,     0,     0,     0,   311,
       0,     0,     0,     0,     0,     0,     0,     0,   312,     0,
       0,     0,     0,   328,     0,     0,     0,     0,     0,     0,
       0,   329,     0,     0,   330,     0,     0,     0,     0,   331,
       0,     0,  1895,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1896,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   332,     0,     0,     0,     0,
       0,     0,     0,   333,     0,   334,     0,     0,   335,   313,
     314,   336,     0,     0,     0,     0, -1383,     0,     0,     0,
       0,     0,     0,   832,   832,     0,   337,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   315,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   832,     0,     0,     0,     0,     0,   316,
       0,     0,     0,   317,     0,     0,     0,     0,     0,     0,
       0,   832,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   318,     0,  1897,     0,     0,     0,     0,     0,     0,
       0,     0,   338,     0,     0,     0,     0,     0,   339,     0,
     340,     0,     0,   341,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   342,     0,
       0,     0,   319,     0,     0,   832,     0, -1383,   320,     0,
     321,     0,     0,     0,   322,     0,     0,     0,   323,     0,
       0,  2344,     0,     0,  2345,     0, -1383, -1383, -1383,     0,
   -1383, -1383, -1383, -1383,     0,   324,     0,     0,     0,     0,
       0,     0,  2346,     0,     0,     0,     0,     0,     0,     0,
     343,     0,     0,     0,     0,  2347,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   325,     0,   344,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   326,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   327,     0,     0,
       0,     0,     0,     0,     0,     0,   308,     0,     0,     0,
     309,     0,     0,   345,     0,   310,     0,     0,     0,   346,
       0,     0,   311,   347,     0,     0,   348,   349,     0,     0,
       0,   312,     0,     0,     0,     0,   488,     0,     0,     0,
       0,     0,     0,   350,     0,   328,     0,     0,     0,     0,
       0,     0,     0,   329,     0,     0,   330,     0,     0,   351,
       0,   331,     0,     0,   352,     0,     0,     0,     0,     0,
       0,   353,     0,     0,     0,     0,     0,   354,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   332,     0,     0,
       0,     0,   313,   314,     0,   333,   355,   334,     0,     0,
     335,     0,     0,   336,     0,     0,     0,     0,     0,     0,
     356,     0,     0,     0,     0,     0,   357,     0,   337,     0,
       0,     0,   315,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -1383,     0,   358,     0,     0,     0,     0,     0,
       0,     0,   316,     0,     0,     0,   317,     0,   359,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   360,   361,
       0,     0,     0,     0,   318,     0,     0,   362,     0,     0,
     363,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   338,   364,     0,     0,     0,     0,
     339,     0,   340,     0,     0,   341,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   319,     0, -1383,     0,     0,
     342,   320,     0,   321,     0,     0,     0,   322, -1383,     0,
       0,   323,  2348,  2349,     0,     0,     0,     0,     0,     0,
       0,     0,   366,     0,     0,     0,     0,     0,   324,     0,
       0,     0,     0,     0,     0,   367,     0,     0,     0,     0,
       0,   368,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   343,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   325,   369,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   344,     0,     0,     0,     0,
     326,     0,     0, -1383,     0,     0,     0,     0,     0,     0,
     327,     0,     0,     0,   370,     0,  2350,     0,     0,   371,
       0,     0,     0,     0,     0,     0,     0,     0,   308,     0,
       0,     0,   309,     0,     0,   345,     0,   310,     0,     0,
       0,   346,     0,     0,   311,   347,     0,     0,   348,   349,
       0,     0,     0,   312,     0,     0,     0,     0,   328,     0,
       0,     0,     0,     0,     0,   350,   329,     0,     0,   330,
       0,  2351,     0,     0,   331,     0,     0,     0,     0,     0,
       0,   351,     0,     0,     0,     0,   352,  -336,     0,     0,
       0,     0,     0,   353,     0,     0,     0,     0,     0,   354,
     332,     0,     0,     0,     0,     0,     0,     0,   333,     0,
     334,     0,     0,   335,   313,   314,   336,     0,   355,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   337,   356,     0,     0,     0,     0,     0,   357,     0,
       0,     0,     0,     0,   315,     0,     0,     0,     0,  2352,
       0,     0,     0,     0,     0,     0,   358,     0,     0,     0,
       0,     0,     0,     0,   316,     0,     0,     0,   317,     0,
     359,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     360,   361,     0,     0,     0,     0,   318,     0,     0,   362,
    2353,     0,   363,     0,     0,     0,     0,   338,  2354,     0,
       0,     0,     0,   339,     0,   340,     0,   364,   341,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   342,     0,     0,     0,   319,     0,   365,
       0,     0,     0,   320,     0,   321,     0,     0,     0,   322,
       0,     0,     0,   323,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   366,     0,     0,     0,     0,     0,
     324,     0,     0,  2355,   776,     0,     0,   367,     0,   501,
       0,     0,     0,   368,     0,   343,     0,  2356,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2357,     0,     0,     0,   325,   369,   344,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   326,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   327,     0,     0,     0,   370,     0,     0,     0,
       0,   371,     0,     0,     0,     0,     0,     0,   345,     0,
       0,     0,     0,     0,   346,     0,     0,     0,   347, -2973,
       0,   348,   349,     0,     0,  2358,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   350,  2359,
     328,     0,     0,     0,     0,     0,     0,     0,   329,     0,
       0,   330,     0,     0,   351,     0,   331,     0,  -333,   352,
       0,     0,     0,     0,     0,     0,   353,     0,     0,     0,
       0,     0,   354,     0,   777,     0,     0,     0,     0,     0,
     778,   779,   332,     0,     0,     0,     0,     0,     0,     0,
     333,   355,   334,     0,     0,   335,   781,     0,   336,     0,
       0,     0,     0,     0,     0,   356,     0,     0,     0,     0,
       0,   357,  2360,   337,     0,     0,  2361,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   358,
       0,     0,  2362,  2363,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   359,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   360,   361,     0,     0,     0,     0,     0,
       0,     0,   362,     0,     0,   363,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   338,
     364,     0,     0,     0,     0,   339,     0,   340,     0,     0,
     341,     0,  2181,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1600,     0,     0,   342,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   366,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     367,     0,     0,     0,     0,     0,   368,     0,     0,     0,
       0,     0,     0,   542,     0,     0,     0,   343,   543,     0,
       0,   782,   783,   784,     0,   544,     0,     0,     0,     0,
     369,     0,     0,   785,   545,     0,     0,     0,     0,     0,
     344,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   370,
     502,     0,     0,     0,   371,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     345,     0,     0,     0,     0,     0,   346,     0,     0,     0,
     347,     0,     0,   348,   349,   546,   547,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     350,     0,     0,     0,     0,     0,     0,     0,   786,   787,
     788,     0,     0,     0,     0,   548,   351,     0,   789,     0,
     790,   352,     0,     0,     0,     0,     0,   503,   353,     0,
       0,   791,   792,   793,   354,   549,     0,     0,     0,   550,
     794,     0,     0,   504,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   355,     0,     0,     0,   551,     0,   795,
       0,     0,     0,     0,     0,     0,     0,   356,     0,     0,
       0,     0,     0,   357,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   358,     0,     0,     0,     0,     0,     0,   552,     0,
       0,     0,     0,     0,     0,   359,     0,     0,     0,     0,
     553,     0,     0,     0,   554,   360,   361,     0,     0,     0,
       0,     0,     0,   796,   362,     0,     0,   363,     0,     0,
       0,     0,     0,   555,     0,     0,     0,     0,   556,   557,
     558,   559,   364,   560,   561,   562,   563,     0,   564,   797,
     565,   566,   567,     0,   568,   569,   570,   571,   572,   573,
     574,   575,   576,   577,   578,     0,     0,   579,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   580,     0,     0,     0,     0,     0,   366,
       0,     0,     0,   581,     0,     0,     0,     0,     0,     0,
     505,     0,   367,     0,     0,     0,     0,     0,   368,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1712,     0,     0,     0,     0,  1713,  1714,  1715,
    1716,     0,   369,     0,  1717,     0,     0,     0,     0,     0,
       0,   582,     0,     0,     0,     0,     0,     0,     0,   583,
     798,     0,   584,  1718,     0,     0,     0,   585,     0,     0,
       0,   370,     0,     0,     0,     0,   371,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   586,     0,     0,     0,     0,     0,     0,
       0,   587,     0,   588,     0,     0,   589,     0,     0,   590,
       0,  1719,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2182,     0,     0,     0,     0,     0,
       0,     0,   506,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1720,     0,
    1721,     0,     0,     0,     0,     0,     0,     0,   799,   800,
       0,     0,  1722,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1723,     0,     0,     0,     0,
     591,     0,     0,     0,     0,     0,   592,     0,   593,     0,
       0,   594,     0,  2183,     0,     0,     0,     0,     0,     0,
     507,     0,     0,     0,  2184,     0,   595,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   802,     0,
       0,     0,     0,     0,     0,     0,     0,  1312,     0,     0,
       0,     0,     0,     0,  1313,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   803,     0,     0,     0,     0,
       0,     0,     0,   804,     0,     0,     0,     0,   596,     0,
       0,     0,   777,     0,  1314,     0,     0,     0,   778,   779,
       0,     0,     0,     0,     0,     0,     0,   805,     0,     0,
       0,   597,     0,   186,   781,  1315,  1316,  1317,  1318,  1319,
    1320,  1321,  1322,     0,     0,     0,     0,   508,     0,     0,
    1323,     0,     0,     0,     0,  1324,     0,     0,     0,     0,
       0,     0,     0,     0,  1724,     0,  1325,  1326,  1327,  1328,
       0,     0,     0,     0,  1725,     0,     0,     0,     0,     0,
       0,   598,     0,  1329,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1330,     0,     0,  1331,  1332,  1333,     0,
    1334,   599,     0,  1726,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   600,     0,     0,     0,     0,     0,     0,   601,
       0,     0,     0,     0,  1335,   602,     0,     0,     0,     0,
       0,     0,     0,  1336,  1337,  1338,  1339,  1340,  1341,  1342,
    1343,     0,     0,     0,   603,     0,  1344,  1345,     0,     0,
       0,  1727,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   604,     0,     0,     0,     0,     0,
       0,     0,  1346,  1347,     0,     0,  1348,  1349,     0,     0,
       0,  1350,   605,  1728,     0,     0,  1729,     0,     0,   782,
     783,   784,     0,     0,     0,     0,   606,     0,     0,     0,
       0,   785,     0,  1351,     0,     0,   607,   608,     0,     0,
       0,     0,     0,     0,     0,   609,     0,     0,   610,     0,
       0,     0,     0,     0,     0,     0,     0,  1352,     0,     0,
    1730,  1353,     0,   611,     0,     0,     0,  1731,     0,     0,
       0,     0,     0,     0,     0,     0,  1354,     0,     0,     0,
       0,  1355,  1356,     0,     0,   612,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1357,  1358,
    1359,  1360,  1361,  1732,     0,  1362,     0,     0,     0,     0,
     613,     0,     0,     0,     0,     0,     0,     0,   788,  1733,
       0,     0,     0,   614,     0,     0,     0,     0,     0,   615,
       0,     0,     0,     0,     0,  1051,     0,     0,     0,   791,
     792,   793,     0,     0,  1363,  1364,  1365,  1366,   794,     0,
       0,     0,     0,  1367,  1368,     0,  1369,     0,  1370,  1371,
    1372,     0,     0,  1373,     0,  1374,     0,  1734,     0,  1375,
    1735,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   616,     0,     0,     0,     0,   617,  1376,  1377,
       0,     0,     0,     0,     0,     0,     0,  1378,  1379,  1380,
    1381,  1382,  1383,     0,     0,     0,     0,     0,     0,     0,
       0,  1384,  1736,     0,     0,  1385,     0,     0,     0,  1387,
       0,     0,     0,     0,  1737,     0,  1738,  1739,     0,     0,
       0,   796,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1740,     0,     0,     0,
       0,  1741,     0,     0,     0,     0,     0,     0,  1388,  1742,
       0,     0,  1389,     0,  1390,  1391,  1392,  1393,     0,     0,
       0,     0,     0,     0,  1394,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -3067,
    1395,     0,     0,     0,     0,     0,     0,     0,  1396,     0,
       0,  1743,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1488,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1397,  1398,  1744,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1745,     0,   798,     0,
       0,     0,     0,     0,     0,     0,  1399,     0,     0,  1400,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1401,     0,     0,     0,     0,     0,  1402,     0,     0,     0,
    1403,     0,  1404,  1405,     0,     0,     0,     0,     0,     0,
    1746,     0,     0,     0,     0,     0,  1406,     0,     0,  1407,
    1408,     0,  1747,     0,  1409,     0,     0,     0,     0,  1748,
       0,     0,     0,     0,     0,     0,     0,     0,  1410,     0,
    1411,  1412,     0,     0,     0,     0,     0,     0,     0,  1413,
    1414,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   799,   800,     0,  1415,
    1416,  1417,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1418,
    1419,  1420,  1421,     0,  1422,     0,     0,     0,  1423,  1424,
       0,     0,     0,     0,     0,     0,  1425,  1426,     0,     0,
       0,     0,     0,     0,  1427,  1428,  1429,     0,     0,     0,
       0,     0,  1430,     0,     0,     0,     0,  1431,     0,     0,
       0,     0,     0,     0,     0,     0,   802,     0,     0,     0,
       0,     0,     0,     0,     0,  1432,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1433,  1434,
       0,  1312,     0,   803,  1435,     0,     0,     0,  1313,     0,
    1489,   804,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1436,  1437,     0,
       0,     0,     0,     0,     0,   805,  1438,     0,  1314,     0,
       0,   186,     0,     0,  1439,     0,     0,     0,     0,     0,
    1440,     0,     0,     0,     0,     0,     0,     0,     0,  1315,
    1316,  1317,  1318,  1319,  1320,  1321,  1322,     0,     0,     0,
       0,     0,     0,     0,  1323,     0,     0,     0,     0,  1324,
    1441,     0,     0,     0,     0,     0,  1442,     0,     0,     0,
    1325,  1326,  1327,  1328,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1329,   776,     0,
       0,     0,     0,   501,     0,     0,     0,  1330,     0,     0,
    1331,  1332,  1333,     0,  1334,     0,     0,  1443,     0,     0,
       0,     0,     0,  1444,     0,  1445,     0,     0,  1446,     0,
       0,     0,     0,     0,     0,  1447,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1448,  1335,     0,
    1449,     0,     0,     0,     0,     0,     0,  1336,  1337,  1338,
    1339,  1340,  1341,  1342,  1343,     0,     0,     0,     0,     0,
    1344,  1345,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1346,  1347,     0,     0,
    1348,  1349,     0,     0,     0,  1350,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1351,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   777,     0,
       0,     0,     0,     0,   778,   779,     0,     0,     0,     0,
       0,  1352,     0,     0,     0,  1353,     0,     0,     0,     0,
     781,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1354,     0,     0,     0,     0,  1355,  1356,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1357,  1358,  1359,  1360,  1361,     0,     0,  1362,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1363,  1364,
    1365,  1366,     0,     0,     0,     0,     0,  1367,  1368,     0,
    1369,     0,  1370,  1371,  1372,     0,     0,  1373,     0,  1374,
       0,     0,     0,  1375,     0,     0,     0,   879,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1376,  1377,     0,     0,     0,     0,     0,     0,
       0,  1378,  1379,  1380,  1381,  1382,  1383,     0,     0,     0,
       0,     0,     0,     0,     0,  1384,     0,     0,     0,  1385,
    1386,     0,     0,  1387,     0,     0,     0,     0,     0,   880,
       0,     0,     0,     0,     0,   782,   783,   784,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   785,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     776,     0,  1388,     0,     0,   501,  1389,     0,  1390,  1391,
    1392,  1393,     0,     0,   502,     0,     0,     0,  1394,     0,
       0,     0,     0,     0,     0,     0,   881,     0,     0,     0,
   -1717,     0,     0,     0,  1395,     0,     0,     0, -1717, -1717,
   -1717, -1717,  1396,     0,     0, -1717,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -1717, -1717,     0,     0,     0,     0,     0,
       0,     0,   786,   787,   788,     0,     0,  1397,  1398,     0,
       0,     0,   789,     0,   790,     0,     0,     0,     0,     0,
       0,   882,     0,     0,     0,   791,   792,   793,     0,     0,
       0,     0,     0,     0,   794,     0,     0,   504,     0,     0,
    1399, -1717, -1717,  1400,     0, -1717,     0,     0,     0,     0,
     883,     0,     0,   795,  1401,     0,     0,     0,     0,     0,
    1402,     0,     0,     0,  1403,     0,  1404,  1405,     0,     0,
     777,     0,     0,     0,     0,     0,   778,   779,     0,     0,
    1406, -1717,     0,  1407,  1408,     0,   776,     0,  1409,     0,
       0,   501,   781,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1410,  1285,  1411,  1412,     0,     0,     0,     0,
       0,     0,     0,  1413,  1414,     0,     0,   796,     0,     0,
       0,     0,     0,     0,   884,     0,     0,     0,     0,     0,
       0,     0,     0,  1415,  1416,  1417,     0,     0,     0,     0,
       0,     0,     0,   797,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1418,  1419,  1420,  1421,     0,  1422,     0,
       0,     0,  1423,  1424,     0,     0,     0,     0,     0,     0,
    1425,  1426,     0,     0,     0,     0,     0,     0,  1427,  1428,
    1429,     0,     0,     0,     0,     0,  1430,     0,     0,     0,
       0,  1431,     0,     0,   505,     0,     0,     0,     0, -1717,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1432,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1433,  1434,     0,     0,   777,     0,  1435,     0,
       0,     0,   778,   779,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   798,     0,     0,     0,   781,     0,
       0,  1436,  1437,     0,     0, -1717,     0,   782,   783,   784,
    1438,     0,     0,     0,     0,     0,     0,     0,  1439,   785,
       0,     0,     0,     0,  1440,     0,     0,     0,     0,     0,
     776,     0,     0,     0,     0,   501,     0,     0,     0, -3009,
   -3009, -3009,     0,     0, -1717,     0,   502,  1285,     0,     0,
       0,     0,     0,     0,  1441,     0,     0,     0,     0,     0,
    1442,     0,     0,     0,     0,     0,   506,     0,     0,     0,
     885,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   799,   800,     0,   886,     0,     0,     0,     0,
       0,  1443,     0,     0,   786,   787,   788,  1444,     0,  1445,
       0,     0,  1446,     0,   789, -1717,   790,     0,     0,  1447,
       0,  1286,     0,   503,     0,     0,     0,   791,   792,   793,
       0,  1448, -3009,     0,  1449,     0,   794, -1717,     0,   504,
     887,     0,     0,     0,   507,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   795, -1717,     0,     0,     0,
       0,     0,   802,   782,   783,   784,     0,     0,     0,     0,
     777,     0,     0,     0,     0,   785,   778,   779,     0,     0,
       0,     0, -1717,     0,     0,     0,     0,     0,   776,   803,
       0,     0,   781,   501,     0,     0,     0,   804,     0,     0,
       0,     0,   502,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   796,
       0,   805,     0,     0,     0,   888,     0,   186,     0,     0,
       0,     0,  1287,     0,     0,     0,     0,     0,     0,     0,
   -1717,   508,     0,     0,     0,   797,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     786,   787,   788,     0, -1717, -1717,     0,     0,     0,     0,
     789,     0,   790,     0,     0,     0,     0,     0,     0,   503,
       0,     0,     0,   791,   792,   793,     0,     0,     0,     0,
       0,     0,   794,     0,     0,   504,   505,     0, -3009,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   795,     0,     0,     0,  1286,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   777,     0,
       0,     0,     0,     0,   778,   779,     0,     0,     0,     0,
       0,     0,     0,     0,   780, -1717,   798, -1717, -1717,     0,
     781,     0,     0,     0,  1288,     0,     0,   782,   783,   784,
       0,     0,     0,     0,     0,     0,     0, -1717,     0,   785,
       0,     0, -1717,     0,     0,   796,     0,     0,     0,     0,
   -3009, -3009,     0,     0,     0,     0,     0,     0,  1289,     0,
       0,     0,     0,     0,     0,     0,   502,     0,     0,     0,
       0,   797,     0,     0,     0,     0,     0,     0,     0,     0,
   -1717,     0,     0,     0,     0,     0,     0,     0,   506,     0,
       0,     0, -1717,     0,     0,     0,  1287,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   799,   800,     0,     0,     0,     0,
       0,     0,   505,     0,   786,   787,   788, -3009, -3009,     0,
       0,     0,     0,     0,   789,     0,   790,     0,     0,     0,
       0,     0,     0,   503,     0,     0,     0,   791,   792,   793,
       0,     0,     0,     0,     0,     0,   794,     0,     0,   504,
       0,     0,     0,     0,     0,     0,   507,     0,     0,     0,
       0,     0,   798,     0,     0,   795,     0,     0,     0,     0,
       0,     0,     0,     0,   802,   782,   783,   784,     0,     0,
       0, -1717,     0,     0, -3009,     0,     0,   785,     0,     0,
       0,     0,   776,     0,     0, -1717,     0,   501,     0,     0,
       0,   803,     0,     0,     0,     0,     0,     0,  1288,   804,
       0,     0,     0,     0,   502,     0,     0,     0, -3009,     0,
       0,     0,     0,     0,     0,     0,     0, -3009,     0,   796,
       0,     0,     0,   805,   506,     0, -3009,     0, -1717,   186,
       0,     0,  1289,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   508,     0,   797,     0,     0,     0,     0,
     799,   800,     0,     0,     0,   776,     0,     0,     0,     0,
     501,     0,   786,   787,   788,     0,     0, -3009,     0,     0,
       0,     0,   789,     0,   790,     0,     0,     0,     0,     0,
       0,   503,     0,     0,     0,   791,   792,   793,     0,  1290,
       0,  1291,     0,     0,   794,     0,   505,   504,     0,     0,
    1292,  1293,   507,     0,  1294,  1295,     0,     0,     0,     0,
       0,     0,     0,   795,     0,     0,     0,     0,     0,     0,
     802,     0,   777,     0,     0,     0,     0,     0,   778,   779,
       0,     0,     0,     0,     0,     0,     0,     0,  1033,     0,
       0,     0,     0,     0,   781,     0,   798,   803,     0,     0,
       0,     0,     0,     0,     0,   804,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   776,     0,     0,     0,
       0,   501,     0,     0,     0,     0,     0,   796,     0,   805,
       0,     0,     0,     0,     0,   186,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   777,     0,     0,     0,   508,
       0,   778,   779,   797,     0,     0,     0,     0,     0,     0,
       0,   964,     0,     0,     0,     0,     0,   781,   506,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   799,   800,     0,     0,     0,     0,
       0,     0,     0,     0,   505,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1290,     0,  1291,     0, -3009,     0,     0,
       0, -3009,     0, -3009,  1292,  1293,   507,     0,  1294,  1295,
       0,     0,     0,     0,   798,     0,   777,     0,     0,   782,
     783,   784,   778,   779,   802,     0,     0,     0,     0,     0,
       0,   785,     0,     0,     0,     0,     0,     0,   781,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   803,     0,     0,     0,     0,     0,     0,   502,   804,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   805,     0,     0,   506,     0,     0,   186,
       0,     0,   782,   783,   784,     0,     0,     0,     0,     0,
       0,     0,     0,   508,   785,     0,     0,     0,     0,     0,
       0,     0,   799,   800,     0,     0,   786,   787,   788,     0,
     776,     0,     0,     0,     0,   501,   789,   801,   790,     0,
       0,   502,     0,     0,     0,   503,     0,     0,     0,   791,
     792,   793,     0,     0,     0,     0,     0,     0,   794,     0,
       0,   504,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   507,     0,     0,   795,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   802,     0,     0,     0,     0,     0,     0,   786,
     787,   788,     0,     0,     0,     0,     0,     0,     0,   789,
       0,   790,     0,   782,   783,   784,     0,     0,   503,   803,
       0,     0,   791,   792,   793,   785,     0,   804,     0,     0,
       0,   794,     0,     0,   504,     0,     0,     0,     0,     0,
       0,   796,     0,     0,     0,     0,     0,     0,     0,     0,
     795,   805,   502,     0,     0,     0,     0,   186,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   797,     0,     0,
     777,   508,     0,     0,     0,   776,   778,   779,     0,     0,
     501,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   781,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     786,   787,   788,     0,   796,     0,     0,     0,   505,     0,
     789,     0,   790,     0,     0,     0,     0,     0,     0,   503,
       0,     0,     0,   791,   792,   793,     0,     0,     0,     0,
     797,     0,   794,     0,     0,   504,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   795,     0,     0,   776,     0,     0,     0,   798,   501,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   505,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   777,     0,     0,     0,     0,
       0,   778,   779,     0,     0,   796,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   781,     0,     0,
     506,   798,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   797,     0,     0,     0,     0,     0,   782,   783,   784,
       0,     0,     0,     0,     0,     0,   799,   800,     0,   785,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1034,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   502,     0,     0,     0,
       0,     0,   505,     0,   777,     0,     0,     0,     0,   776,
     778,   779,     0,   506,   501,     0,     0,     0,   507,     0,
       0,     0,     0,     0,     0,     0,   781,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   802,     0,     0,   799,
     800,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   798,     0,   786,   787,   788,     0,     0,     0,
       0,     0,     0,   803,   789,     0,   790,     0,     0,     0,
       0,   804,     0,   503,     0,     0,     0,   791,   792,   793,
       0,     0,     0,     0,     0,     0,   794,     0,     0,   504,
       0,   507,     0,     0,     0,   805,     0,     0,     0,     0,
       0,   186,   782,   783,   784,   795,     0,     0,  1596,   802,
       0,     0,     0,     0,   785,   508,     0,     0,     0,     0,
    1818,     0,     0,     0,   506,   501,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   803,     0,     0,     0,
       0,   502,     0,     0,   804,     0,     0,     0,     0,   777,
     799,   800,     0,     0,     0,   778,   779,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   805,   796,
       0,   781,     0,     0,   186,     0,   884,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1182,   508,     0,
       0,   782,   783,   784,     0,   797,     0,     0,     0,   786,
     787,   788,   507,   785,     0,     0,     0,     0,     0,   789,
       0,   790,     0,     0,     0,     0,     0,     0,   503,     0,
     802,     0,   791,   792,   793,     0,     0,     0,     0,     0,
     502,   794,     0,     0,   504,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   505,   803,     0,     0,
     795,     0,     0,     0,     0,   804,     0,     0,     0,     0,
     777,     0,     0,     0,     0,     0,   778,   779,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   805,
       0,     0,   781,     0,     0,   186,     0,     0,   786,   787,
     788,     0,     0,     0,     0,     0,   798,     0,   789,   508,
     790,     0,     0,     0,     0,     0,     0,   503,     0,     0,
       0,   791,   792,   793,   796,     0,     0,     0,     0,     0,
     794,     0,     0,   504,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   782,   783,   784,   795,
     797,     0,     0,     0,     0,     0,     0,     0,   785,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   506,     0,
       0,     0,     0,     0,     0,   502,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   505,     0,     0,   799,   800,     0,     0,     0,     0,
       0,     0,     0,   796,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   797,
       0,     0,     0,   786,   787,   788,     0,     0,     0,     0,
       0,   798,     0,   789,     0,   790,   507,   782,   783,   784,
       0,     0,   503,     0,     0,     0,   791,   792,   793,   785,
       0,     0,     0,     0,   802,   794,     0,     0,   504,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     505,     0,     0,     0,   795,     0,   502,     0,     0,     0,
       0,   803,     0,     0,     0,     0,     0,     0,     0,   804,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   506,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   805,     0,     0,     0,     0,     0,   186,
     798,     0,     0,     0,     0,     0,     0,     0,     0,   799,
     800,     0,     0,   508,   786,   787,   788,     0,   796,     0,
       0,     0,     0,     0,   789,     0,   790,     0,     0,     0,
       0,     0,     0,   503,     0,     0,     0,   791,   792,   793,
       0,     0,     0,     0,   797,     0,   794,     0,     0,   504,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   507,     0,     0,  3070,   795,     0,     0,     0,     0,
       0,     0,   506,     0,     0,     0,     0,     0,     0,   802,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   505,     0,     0,   799,   800,
       0,     0,     0,     0,     0,     0,   803,     0,     0,     0,
       0,     0,     0,     0,   804,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   796,
       0,     0,     0,     0,     0,     0,     0,     0,   805,     0,
       0,     0,     0,     0,   186,   798,     0,     0,     0,     0,
     507,     0,     0,     0,     0,   797,     0,     0,   508,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   802,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   803,     0,     0,     0,     0,
       0,     0,     0,   804,     0,     0,   505,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   506,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   805,     0,     0,
       0,     0,     0,   186,     0,     0,     0,     0,     0,     0,
       0,     0,  3804,   799,   800,     0,     0,   508,  -570,     0,
       0,     0,     0,     0,     0,     0,   798,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  -570,     0,     0,     0,     0,
    -570,  -570,  -570,  -570,  -570,   507,     0,  -570,  -570,  -570,
    -570,  -570,  -570,     0,  -570,  -570,  -570,     0,     0,     0,
       0,     0,     0,   802,     0,  -570,  -570,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   506,     0,
       0,     0,     0,     0,     0,  -570,     0,     0,     0,     0,
     803,     0,     0,     0,     0,     0,     0,     0,   804,     0,
       0,  -570,     0,     0,   799,   800,  -570,     0,     0,     0,
       0,     0,     0,  -570,  -570,     0,     0,  -570,     0,     0,
       0,     0,   805,     0,  -570,     0,     0,     0,   186,     0,
       0,  -570,     0,  -570,  -570,  -570,  -570,  -570,  -570,  -570,
    -570,  -570,   508,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1071,     0,   507,     0,     0,     0,
       0,     0,  -570,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   802,     0,     0,     0,     0,     0,
       0,  -570,  -570,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   803,     0,  -570,     0,     0,     0,  -570,     0,   804,
    -570,  -570,  -570,  -570,  -570,     0,  -570,  -570,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -570,     0,     0,
       0,     0,     0,   805,     0,     0,     0,     0,     0,   186,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   508,     0,     0,     0,     0,     0,     0,
       0,     0,  -570,     0,     0,     0,     0,     0,     0,     0,
       0,  -570,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  -570,     0,  -570,  -570,  -570,  -570,  -570,
    -570,  -570,  -570,  -570,     0,  1072,     0,     0,     0,     0,
       0,     0,     0,     0,  -570,  -570,  -570,  -570,  -570,     0,
       0,  -570,  -570,     0,     0,     0,     0,  -570,     0,     0,
       0,     0,  -570,     0,     0,  -570,     0,  -570,     0,     0,
       0,     0,     0,     0,  -570,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  -570,     0,     0,  -570,     0,     0,
       0,     0,     0,     0,     0,  -570,  -570,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -570,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -570,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -570,     0,
       0,     0,  -570,     0,     0,     0,     0,     0,     0,     0,
    -570,     0,     0,     0,  -570,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -570,     0,     0,
       0,  -570,     0,     0,  -570,     0,     0,     0,     0,     0,
       0,     0,  -570,  -570,     0,     0,     0,     0,     0,  -570,
       0,     0,     0,     0,     0,     0,     0,  1072,     0,     0,
       0,     0,     0,     0,     0,     0,  -570,  -570,  -570,  -570,
    -570,     0,     0,  -570,  -570,     0,     0,     0,  -570,     0,
       0,     0,     0,  4253,     0,     0,  -570,     0,     0,     0,
       0,     0,     0,  -570,     0,     0,  -570,     0,     0,     0,
    -570,     0,     0,     0,     0,     0,     0,     0,     0,  -570,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  -570,     0,     0,     0,
       0,     0,  -570,  -570,  -570,     0,  -570,     0,     0,  -570,
    -570,  -570,  -570,  -570,     0,  -570,  -570,     0,     0,     0,
    -570,     0,  -570,  -570,     0,     0,  -570,     0,     0,     0,
    -570,     0,     0,     0,     0,     0,     0,     0,     0,  -570,
       0,     0,  -570,     0,  -570,     0,  -570,  -570,     0,     0,
       0,     0,     0,     0,  -570,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -570,     0,     0,
    -570,     0,     0,     0,  -570,  -570,     0,  -570,  -570,  -570,
       0,     0,     0,     0,  -570,     0,     0,     0,     0,     0,
     501,     0,  -570,     0,  -570,  -570,  -570,  -570,  -570,  -570,
    -570,  -570,  -570,     0,     0,     0,     0,     0,     0,     0,
    -570,     0,     0,     0,     0,  -570,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -570,     0,  -570,
    -570,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   501,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  -570,     0,     0,  1509,     0,
       0,     0,  -570,     0,  -570,     0,  -570,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  -570,  -570,     0,  -570,  -570,
    -570,     0,  -570,     0,     0,     0,     0,     0,     0,     0,
       0,  -570,     0,     0,  -570,     0,  -570,     0,     0,     0,
       0,     0,     0,  1509,     0,  -570,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   777,     0,     0,     0,  -570,
       0,   778,   779,     0,     0,     0,     0,     0,  -570,     0,
       0,     0,     0,     0,     0,     0,     0,   781,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  -570,
       0,     0,     0,  -570,     0,     0,  1072,     0,  -570,     0,
       0,     0,     0,     0,  -570,  -570,  -570,  -570,  -570,  -570,
     777,     0,  -570,  -570,     0,     0,   778,   779,     0,     0,
       0,  -570,     0,     0,     0,  -570,     0,     0,     0,     0,
       0,     0,   781,  -570,     0,     0,     0,     0,  -570,  -570,
    -570,  -570,     0,     0,     0,     0,  -570,     0,  -570,     0,
       0,     0,     0,     0,  -570,     0,     0,     0,     0,     0,
       0,     0,  -570,     0,     0,     0,     0,     0,  -570,     0,
       0,     0,  -570,     0,     0,     0,     0,     0,  -570,     0,
    -570,  -570,  -570,  -570,     0,     0,     0,     0,     0,     0,
       0,   197,     0,  -570,     0,     0,     0,     0,     0,  -570,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -570,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  -570,     0,  -570,     0,
       0,     0,  -570,     0,     0,     0,     0,     0,     0,     0,
       0,  1510,   782,   783,   784,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   785,     0,     0,     0,     0,     0,
    -570,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  -570,
       0,   502,     0,  -570,     0,     0,     0,     0,     0,     0,
    -570,  -570,  -570,     0,     0,     0,  1510,   782,   783,   784,
    -570,  -570,  -570,     0,     0,     0,     0,     0,     0,   785,
       0,     0,     0,     0,     0,     0,  -570,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    -570,     0,     0,     0,     0,  -570,   502,     0,  -570,   786,
     787,   788,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   197,  -570,     0,     0,     0,  1511,     0,
       0,     0,   791,   792,   793,     0,     0,     0,     0,     0,
    -570,   794,     0,     0,   504,  -570,     0,     0,     0,     0,
       0,  -570,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   786,   787,   788,     0,  -570,     0,
       0,     0,     0,  2014,     0,     0,     0,     0,     0,     0,
       0,     0,  2015,   503,     0,     0,     0,   791,   792,   793,
       0,     0,     0,     0,     0,     0,   794,  2016,     0,   504,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2017,     0,     0,     0,
       0,     0,     0,     0,   796,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2018,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2019,  2020,  2021,
       0,     0,  2022,     0,     0,     0,     0,     0,     0,  2023,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2024,     0,  2025,  2026,     0,     0,     0,     0,   796,
       0,     0,     0,     0,     0,     0,     0,  -570,     0,  -570,
    -570,  -570,     0,     0,     0,     0,     0,     0,     0,  -570,
    2027,   505,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -570,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   798,     0,     0,     0,  2028,   505,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2029,  -570,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2030,  2031,  -570,  2032,  2033,     0,     0,     0,     0,  -570,
       0,     0,     0,     0,     0,     0,   798,     0,     0,  -570,
    -570,  -570,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   506,     0,  -570,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2034,     0,  -570,
       0,     0,     0,  -570,     0,     0,     0,     0,     0,   799,
     800,     0,     0,  2035,     0,     0,     0,     0,     0,     0,
       0,     0,   197,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -3107,     0,     0,     0,     0,     0,   506,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2036,  2037,  2038,     0,     0,     0,     0,     0,     0,     0,
       0,   507,     0,     0,   799,   800,     0,     0,     0,     0,
       0,     0,  2039,     0,     0,     0,     0,  2040,     0,   802,
       0,     0,     0,     0,     0,     0,     0, -3107,     0,     0,
       0,     0,     0,     0,     0,     0, -2068,     0,     0,     0,
       0,     0,  2041,  2042,     0,     0,   803,     0,  2043,  2044,
       0,     0,     0,     0,   804,     0,   507,     0,     0,     0,
       0,     0,     0,     0,     0, -2068,     0,     0,     0,     0,
       0,     0,     0,     0,   802,     0,     0,     0,   805,     0,
       0,     0,     0,   474,   186,     0,     0,     0,     0,  4316,
       0, -2068,     0,     0,     0,     0,     0,     0,   508,     0,
       0,   803,  2045,     0,  2046,     0,     0,     0,     0,   804,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -2068,  2047,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   805,  2048,  2049,  2050,     0,   474,   186,
       0,     0,  2247,  2248,  2249,  2250,  2251,     0,  2252,  2253,
       0,     0,     0,   508,     0,     0,     0,     0,     0,  2254,
       0,  2051,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2052,  2053,  2054,     0,  2055,     0,
    2056,  2057,     0,  2058,     0,  2059,  2060,     0,     0,     0,
    2061,     0,  2062,  2063,  2064,  2065,     0,  4317,     0,     0,
    1765,  4318,     0,     0,     0,     0,     0,  1766,  2066,     0,
       0,     0,     0,     0,     0,  2255,  2067,  2256,  2257,  2137,
    2258,  2259,  2260,  2261,  2262,  2263,     0,     0,     0,  2068,
    2069,     0,     0,     0,     0,     0,     0,     0,  2070,     0,
       0,     0,     0,     0,  2071,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2264,  1146,     0,
    2072, -3107,     0,     0,     0,  2073, -3107, -3107, -3107, -3107,
       0,     0,  1147, -3107,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -3107,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2074,  2075,  2076,     0,     0,     0,
       0,     0,     0,     0,  2077,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -2959,
   -3107,     0,     0, -2959,     0,     0,     0,     0,  2078,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2079,  2080,  2081,  2082,     0,     0,     0,  2265,  2266,
    2267,  2268,  2269,     0,     0,  2145,  2270, -3107,     0, -3107,
       0,  2083,  2084,     0,     0,     0,     0,     0,     0,     0,
       0, -3107,  2085,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4319,
       0,  2271,     0,     0, -3107,     0,     0,     0,  1146,     0,
       0,     0,  2086,     0,     0,     0, -3107, -3107, -3107, -3107,
       0,     0,     0, -3107,     0,  2272,  2087,  2088,   777,     0,
       0,     0,     0,     0,   778,   779,     0,     0,     0,     0,
       0, -3107, -3107,     0,  2947,     0,  2948,     0,     0,     0,
     781,     0,  2273,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2089,     0,     0,     0,     0,     0, -1789,
       0,     0,     0,  2090,     0,     0,     0,     0,     0,     0,
    2091,  4320,     0,     0,     0,  4321,     0,     0,     0, -2959,
   -3107,  2092,     0, -2959,     0,  2093,  2094,  2095,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2096,  2097,     0,     0,     0,  2098,  2099,     0,
    2100,     0,     0,     0,     0,     0,     0,  2101,     0, -3107,
       0,     0,  2275,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -3107,     0,  4322,     0,     0,     0,     0,
       0,     0,  1148, -3107,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -3107,     0,     0,     0,     0,     0,  4323,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2277,     0,     0,
       0,     0,     0,     0,     0,   782,   783,   784,     0,     0,
       0,     0,     0,  2278,     0,     0, -3107,   785,  2279,     0,
       0,     0,     0,     0,  4324,     0,     0,     0,     0,     0,
   -3107,     0,     0,     0,     0,     0,     0, -3107,     0,     0,
       0,  2280,     0, -2959,   502,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -3107,     0,     0, -3107,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1149,     0,     0,     0,     0,     0,
       0,     0,     0, -3107,     0,     0,     0,     0,     0,     0,
       0,     0,   786,   787,   788,     0,     0,     0,     0, -3107,
       0,     0,   789,  2245,   790,     0, -3107,     0,     0,     0,
       0,   503,     0,  2949,     0,   791,   792,   793,     0,     0,
       0,     0, -3107,     0,   794,     0,     0,   504,  2246,     0,
       0,  2247,  2248,  2249,  2250,  2251,     0,  2252,  2253,     0,
       0,     0, -3107,     0,     0,     0,     0,     0,  2254,     0,
    2283,     0,  2284,  2285,  2286,     0,     0,     0, -3107,     0,
       0,     0,  4325,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -1789,
       0,     0, -2959, -2959,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -2959,  4326,     0,     0,  2950,     0,     0,
       0,     0,     0,     0,     0,     0, -3107,   796,     0, -3107,
       0,     0,     0,     0,  2255, -3107,  2256,  2257,  2137,  2258,
    2259,  2260,  2261,  2262,  2263,     0,     0,     0,     0,     0,
       0,     0,  4327,   797,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -3107,     0,     0,     0,     0,     0,     0,     0, -3107,
       0,     0,  4328, -3107,     0, -3107, -3107,     0,     0,     0,
       0,     0,  2289,  2290,  2291,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   505, -3107,  2264,     0,  2292,     0,
   -3107,     0,     0,     0,     0,     0,     0,     0, -3107,     0,
       0,     0,  2239,     0,     0,     0,  4329,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -3107,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -3107,     0,
       0,     0,     0,     0,   798,     0,     0,     0,     0,     0,
   -3107,  2951, -2959, -2959,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   777,     0,     0,
       0,     0,     0,   778,   779,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -3107,     0,     0,     0,     0,   781,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -2961, -3107,     0,  2265,  2266,  2267,
    2268,  2269,     0,     0,  2145,  2270,   506,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -3107,     0, -3107, -3107,     0,     0,     0,
       0, -1789,   799,   800,     0,     0,     0,     0,     0, -3107,
    2271,     0,     0,     0,     0, -3107,     0,     0,     0,     0,
   -3107, -3107,     0,     0,     0,     0,     0,     0, -3107,     0,
       0,     0,     0,     0,  2272,     0,     0,     0,     0,     0,
       0,  1799,     0,     0,     0,     0,  2952,     0,     0,     0,
       0,    52,   819,     0,   507,     0,   820,   821, -3107,  2245,
       0,  2273,     0,     0,     0,     0,   474,     0,     0,     0,
   -3107,     0,   802, -3080,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2246,  2274,     0,  2247,  2248,  2249,
    2250,  2251,     0,  2252,  2253,     0,     0,     0,     0,   803,
       0,     0,     0,     0,  2254,     0,     0,   804,     0,     0,
       0,     0,     0,     0,   782,   783,   784,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   785, -1789,     0,     0,
       0,   805,     0,     0,     0,     0,     0,   186,     0,     0,
       0,  2275,     0,     0,     0,     0,     0,     0,     0,  2953,
       0,   508,     0,   502,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -3107,
    2255,     0,  2256,  2257,  2137,  2258,  2259,  2260,  2261,  2262,
    2263,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2276,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   786,   787,   788,     0,     0,  2277,     0,     0,     0,
       0,   789,     0,   790,     0,     0,   474,     0,     0,     0,
     503,     0,  2278,     0,   791,   792,   793,  2279,     0,     0,
       0,     0,  2264,   794,     0,     0,   504,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2280,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4007,     0,
    2281,     0,     0,  4008,  4009,  4010,  4011,     0,     0,     0,
    4012,  2247,  2248,  2249,  2250,  2251,     0,  2252,  2253,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4013,  4014,
       0,     0,     0,     0,     0,     0,   796,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4015,     0,
       0,     0,  2282,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   797,  2265,  2266,  2267,  2268,  2269,     0,  4016,
    2145,  2270,     0,     0,     0,     0,  1703,  4017,     0,     0,
    1704,     0,     0,     0,     0,     0,     0,     0,     0,  2283,
       0,  2284,  2285,  2286,  2255,     0,  2256,  2257,  2137,  2258,
    2259,  2260,  2261,  2262,  2263,     0,  2271,     0,     0,     0,
       0,     0,     0,   505,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4018,     0,     0,     0,     0,
    2272,     0,     0,     0,     0,     0,     0,  2287,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    52,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2273,     0,     0,
       0,     0,     0,   798,     0,     0,  2264,     0,     0, -3080,
       0,  -629,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2274,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -3080,     0,     0,     0,     0,     0,
       0,  2288,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2289,  2290,  2291,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2292,     0,     0,
       0,     0,     0,     0,  4019,   506,     0,  2275,     0,     0,
       0,  2239,     0,     0,     0,     0,     0,     0,     0,  2293,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   799,   800,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2885,     0,     0,     0,     0,  2265,  2266,  2267,
    2268,  2269,     0,     0,  2145,  2270,     0,     0,     0,     0,
    4020,     0,     0,  2276,     0,     0,     0,     0,  4021,     0,
    4022,     0,     0,     0,     0,     0,     0, -3009,     0,     0,
       0,   819,  2277,   507,     0,   820,   821,  4023,     0,     0,
    2271,     0,     0,     0,     0,     0,     0,     0,  2278,  4024,
       0,   802,     0,  2279,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2272,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2280,     0,   803,     0,
       0,    52,     0,     0,     0,     0,   804,     0,     0,     0,
       0,  2273,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2281,  4025,     0,     0,
     805,     0,     0,     0,     0,     0,   186,     0,     0,     0,
    4026,     0,     0,     0,  4027,     0,     0,     0,     0,     0,
     508,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4028,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2282,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2275,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4029,     0,     0,     0,
       0,     0,     0,  1731,     0,  2283,     0,  2284,  2285,  2286,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4030,     0,  1732,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2287,     0,  4031,  2277,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2278,     0,     0,     0,     0,  2279,     0,  1706,
    1707,     0,     0,     0,     0,     0,     0,  -630,     0,     0,
       0,     0,   777,     0,     0,     0,     0,     0,   778,   779,
    2280,     0,     0,  4032,     0,     0,     0,     0,     0,     0,
   -3080,     0,     0,     0,   781,     0,     0,  2288,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2289,  2290,  2291,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2292,     0,     0,     0,     0,  4033,     0,
       0,     0,     0,     0,     0,     0,     0,  2239,     0,     0,
    1737,  4007,  1738,  1739,     0,  2293,  4008,  4009,  4010,  4011,
       0,     0,     0,  4012,  2247,  2248,  2249,  2250,  2251,     0,
    2252,  2253,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4013,  4014,     0,     0,  4034,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4015,     0,     0,     0,     0,     0,     0,     0,  2283,
       0,  2284,  2285,  2286,     0,  4035,     0,     0,     0,     0,
       0,     0,  4016,     0,     0,     0,     0,  4036,     0,  1703,
    4017,     0,     0,  1704,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2255,     0,  2256,
    2257,  2137,  2258,  2259,  2260,  2261,  2262,  2263,     0,     0,
       0,  4037,     0,     0,     0,     0,     0,     0,     0,   782,
     783,   784,     0,     0,     0,     0,   777,     0,  4018,     0,
       0,   785,   778,   779,     0,     0,  4038,     0,     0,     0,
       0,  -950,     0,     0,     0,     0,     0,  4039,   781,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   502,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2264,
       0,     0,     0,     0,     0,     0,  4040,     0,     0,     0,
       0,  2289,  2290,  2291,     0,     0,     0,     0,   777,     0,
       0,     0,     0,     0,   778,   779,     0,  2292,     0,     0,
       0,     0,     0,     0,     0,  4041,     0,     0,     0,     0,
     781,  2239,     0,     0,     0,     0,   786,   787,   788,     0,
       0,     0,     0,     0,     0,     0,   789,     0,   790,     0,
       0,     0,     0,     0,     0,   503,     0,  4019,     0,   791,
     792,   793,     0,     0,     0,     0,     0,     0,   794,     0,
       0,   504,   777,     0,     0,     0,     0,     0,   778,   779,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   781,     0,     0,     0,     0,     0,
    2265,  2266,  2267,  2268,  2269,     0,     0,  2145,  2270,     0,
       0,     0,     0,  4020,     0,     0,     0,     0,     0,     0,
       0,  4021,     0,  4022,     0,     0,     0,     0,     0,     0,
   -3009,     0,     0,   782,   783,   784,     0,     0,     0,     0,
    4023,     0,     0,  2271,     0,   785,     0,     0,     0,     0,
       0,   796,  4024,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2272,     0,     0,
       0,     0,   502,     0,     0,     0,     0,   797,     0,     0,
       0,     0,     0,     0,    52,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2273,   782,   783,   784,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   785,     0,     0,
    4025,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4026,     0,     0,     0,  4027,   505,     0,
     786,   787,   788,     0,   502,     0,     0,     0,     0,     0,
     789,     0,   790,     0,     0,  4028,     0,     0,     0,   503,
       0,     0,     0,   791,   792,   793,     0,     0,     0,   782,
     783,   784,   794,     0,     0,   504,     0,     0,     0,     0,
       0,   785,     0,     0,  2275,     0,     0,     0,   798,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4029,
       0,     0,   786,   787,   788,     0,  1731,     0,   502,     0,
       0,     0,   789,     0,   790,     0,     0,   777,     0,     0,
       0,   503,     0,   778,   779,   791,   792,   793,     0,     0,
       0,     0,     0,     0,   794,     0,     0,   504,     0,   781,
    4030,     0,  1732,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   796,     0,     0,  4031,  2277,
     506,     0,     0,     0,     0,     0,   786,   787,   788,     0,
       0,     0,     0,     0,     0,  2278,   789,     0,   790,     0,
    2279,   797,  1706,  1707,     0,   503,   799,   800,     0,   791,
     792,   793,     0,     0,     0,     0,     0,     0,   794,     0,
       0,   504,     0,  2280,     0,     0,  4032,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   796,     0,     0,
       0,     0,     0,     0,     0,  2699,     0,     0,     0,     0,
       0,     0,   505,     0,     0,     0,   819,     0,   507,     0,
     820,   821,     0,   797,     0,     0,     0,     0,     0,     0,
       0,  4033,     0,     0,     0,     0,   802,     0,     0,     0,
       0,     0,     0,  1737,     0,  1738,  1739,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   796,   798,   803,     0,     0,     0,     0,     0,     0,
       0,   804,     0,     0,   505,     0,     0,     0,  4034,     0,
       0,     0,     0,     0,   782,   783,   784,   797,     0,     0,
       0,   777,     0,     0,     0,   805,   785,   778,   779,     0,
       0,   186,  2283,     0,  2284,  2285,  2286,     0,  4035,     0,
       0,     0,     0,   781,     0,   508,     0,     0,     0,     0,
    4036,     0,     0,   502,   798,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   506,     0,     0,     0,   505,     0,
       0,     0,     0,     0,     0,     0,   777,     0,     0,     0,
       0,     0,   778,   779,  4037,     0,     0,     0,     0,     0,
     799,   800,     0,     0,     0,     0,     0,     0,   781,     0,
       0,  2887,     0,     0,     0,     0,     0,     0,     0,  4038,
       0,   786,   787,   788,  -953,     0,     0,     0,   798,     0,
    4039,   789,     0,   790,     0,     0,   506,     0,     0,     0,
     503,     0,     0,     0,   791,   792,   793,     0,     0,     0,
     819,     0,   507,   794,   820,   821,   504,     0,     0,  4040,
       0,     0,   799,   800,  2289,  2290,  2291,     0,     0,     0,
     802,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2292,     0,     0,     0,     0,     0,     0,     0,  4041,   777,
       0,     0,     0,     0,  2239,   778,   779,   803,     0,     0,
     506,  2908,     0,     0,     0,   804,     0,     0,     0,     0,
       0,   781,   819,     0,   507,     0,   820,   821,   782,   783,
     784,     0,     0,     0,     0,     0,   799,   800,     0,   805,
     785,     0,   802,     0,     0,   186,   796,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   508,
       0,     0,     0,     0,     0,     0,     0,   502,     0,   803,
       0,     0,   797,     0,     0,     0,     0,   804,     0,     0,
       0,     0,     0,   782,   783,   784,   819,     0,   507,     0,
     820,   821,     0,     0,     0,   785,     0,     0,     0,     0,
       0,   805,     0,     0,     0,     0,   802,   186,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   508,   502,   505,     0,   786,   787,   788,     0,     0,
       0,     0,     0,   803,     0,   789,     0,   790,     0,     0,
       0,   804,     0,     0,   503,     0,     0,     0,   791,   792,
     793,     0,     0,     0,     0,     0,     0,   794,     0,     0,
     504,     0,     0,     0,  4434,   805,     0,     0,     0,     0,
       0,   186,     0,   798,     0,     0,     0,     0,     0,     0,
     786,   787,   788,     0,     0,   508,   782,   783,   784,     0,
     789,     0,   790,     0,     0,     0,     0,     0,   785,   503,
       0,     0,     0,   791,   792,   793,     0,     0,     0,     0,
       0,     0,   794,     0,     0,   504,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   502,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     796,     0,     0,     0,     0,   506,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   797,     0,     0,     0,
       0,   799,   800,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   788,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   796,     0,     0,     0,     0,
       0,     0,   503,     0,     0,     0,   791,   792,   793,     0,
       0,     0,     0,     0,     0,   794,     0,   505,   504,     0,
       0,   797,     0,   507,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   802,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4435,     0,     0,     0,     0,   798,   803,     0,
       0,     0,   505,     0,     0,     0,   804,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   796,     0,
     805,     0,     0,     0,     0,     0,   186,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     508,     0,   798,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   506,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   799,   800,     0,     0,     0,
       0,     0,     0,     0,     0,   505,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   506,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   507,     0,   820,
     799,   800,     0,     0,     0,   798,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   802,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   803,     0,     0,     0,     0,     0,     0,     0,
     804,     0,   507,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     802,     0,     0,     0,   805,     0,     0,   506,     0,     0,
     186,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   508,     0,     0,   803,     0,     0,
       0,     0,     0,   799,   800,   804,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   805,
       0,     0,     0,     0,     0,   186,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   508,
       0,     0,     0,     0,     0,   507,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   802,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     803,     0,     0,     0,     0,     0,     0,     0,   804,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   805,     0,     0,     0,     0,     0,   186,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   508
};

static const yytype_int16 yycheck[] =
{
     151,   501,   633,  1162,   642,   281,   689,   701,   702,   703,
      36,    66,   706,  1622,  1106,  1157,   975,    72,   665,   180,
    1025,   137,  1490,   139,   174,   238,   772,  1085,   144,  1087,
    1088,   670,  1090,  1091,   638,  2127,  2473,  1607,  1016,  2239,
    1678,  2426,  1705,    69,    70,    71,  1617,  1710,  2439,  2326,
      76,  2488,  1635,  1276,   624,   648,   776,   137,  2449,   139,
     868,  1879,   801,  2198,   144,   715,   628,   654,   184,   719,
     720,  1889,   722,   723,  2725,   725,   726,   670,   716,   717,
     633,   862,  2345,   721,   671,  1178,   724,  1182,  1878,  2352,
    2763,  1001,  2355,  2356,   120,  3150,  2795,  1190,   212,  2167,
    1919,  3404,  1514,     1,   184,  1850,  2651,   862,   134,  1899,
     136,    16,     1,   640,   140,   141,  2124,    31,    43,     1,
      56,   648,    16,    16,   150,   151,    25,  2327,  2328,  2431,
    2432,  2871,    16,   686,   854,  2437,  2438,  2818,  2440,    11,
     166,    11,    43,   670,  2825,  2354,    42,    42,    16,   136,
      62,   206,     1,    38,    31,    16,   182,   160,    16,    13,
     215,     1,  2995,    16,   108,    16,    83,   623,   112,  1914,
     169,   170,   155,     0,   200,   255,    83,   121,   203,  1274,
      25,   109,   990,   109,  1162,   156,   107,    11,   214,    14,
    2390,    77,  1764,   219,   789,   790,   189,     0,   238,   269,
    1772,   227,   797,   136,   163,   960,   290,    85,  3573,   225,
     189,  1261,   225,   306,   801,   207,   946,  1517,   315,   102,
      11,   254,  1755,   168,   121,   315,   118,   335,    16,    41,
      55,    84,   254,   303,   304,   261,   291,   292,   315,    18,
    1021,   248,  2544,   297,   839,  2547,   109,  1028,   136,   156,
      23,   138,  2554,   239,   290,  2557,  2562,    83,   109,   942,
     760,   197,  2955,   194,  3721,   835,  1021,  2704,  2705,   279,
     119,   169,  2965,   108,   419,   396,  2197,   112,   352,   473,
     101,   454,   386,   479,   302,  1545,  3293,   388,   432,   382,
     377,    56,   557,   110,   230,  1034,   186,    41,   462,   407,
      96,    80,   407,   486,   231,  3707,    11,   557,   109,   236,
      75,   160,   161,   238,   418,   623,  1654,   388,   226,   204,
    2722,   542,   440,   429,   352,   407,   415,   529,    16,    37,
     481,   512,    11,   335,   168,   589,   239,   238,   891,   169,
     351,   226,   396,   651,   174,  3710,   203,   348,   512,    23,
     446,   483,   811,   349,  1037,   225,  2619,   284,   462,   349,
     414,   388,    38,   648,   820,   407,    83,   231,   435,   351,
     829,   226,   236,   557,  2119,   651,   568,   419,   122,    38,
    3937,  3573,   126,   470,  3954,   693,   382,   435,   384,   645,
     290,   687,   447,  3716,   593,    41,   352,   462,   352,  1145,
     736,   928,  4281,   136,  3663,  1151,   406,  1502,   512,   736,
     741,   454,   299,   940,   627,  4127,   710,   630,  1011,  2721,
     284,    57,   249,   820,   407,   462,   109,     1,   255,   454,
     994,   462,   211,  3813,   460,   461,    14,   193,  2609,   136,
    4417,   703,  2450,  3485,  3703,   350,   249,  1034,   334,  1230,
     663,   207,   255,   666,   480,   508,    30,   315,   288,   672,
     515,   487,   407,  1472,   282,     0,   317,   454,   407,   512,
    2215,   154,   290,    83,  4451,   512,   122,    55,    11,   692,
     126,   512,   273,   647,  1011,  2870,  1495,   486,  3811,  4368,
     314,  1018,  3872,   407,   109,  1059,   239,  4209,   679,  3239,
     548,  1596,  4072,   811,   353,  4062,   903,   377,   348,  3208,
     248,   819,   820,   821,   568,  1261,   562,  2652,  3710,  3200,
     856,   829,   349,   817,   377,   856,  3785,   554,   204,   856,
     407,   403,   386,   387,  3215,   479,   197,   449,    16,   289,
     684,   541,  2805,   613,   624,   204,   349,   600,   628,   432,
     454,   454,   136,   377,   388,   382,   335,   384,   407,   290,
     640,   641,   335,   489,   418,  2657,   202,   823,   648,   753,
     581,  1027,   199,   454,   654,   445,    23,   447,   429,   382,
     712,   384,   435,   436,   454,   665,   377,   667,   668,   377,
     670,   671,   417,  3635,   745,  1687,   136,   454,   239,   581,
     470,   454,   887,    23,   512,   701,   605,   828,   462,   727,
     375,   432,   613,   909,   136,   695,  1674,   470,   614,   136,
    1182,   445,   687,   447,   614,   714,    16,   517,   512,   812,
     454,   823,   205,   239,   425,   276,   344,   278,   851,   108,
     540,  2211,    30,   112,   479,   910,   470,   675,  2950,   483,
     730,   913,   431,   866,   445,   909,   447,   512,   512,   531,
     910,   335,   749,   454,   232,  2003,   454,   975,   433,   613,
     454,   454,   377,   558,   741,  1279,   493,   648,   495,   470,
    3082,   296,   470,   462,    23,   557,   403,   705,    23,  3696,
     854,  1601,   319,  1001,   473,   486,   574,  1250,   377,   975,
     659,   802,   446,   468,  1163,   623,   576,   812,   281,  1802,
     909,   615,  1274,   909,    48,   909,  1172,  1173,  1174,  1027,
     554,   801,   924,  1531,   497,   454,   575,  3426,   909,  1824,
     454,   648,  1188,   512,   840,  1305,   818,  1467,   227,   813,
     445,   648,   447,   454,    16,   909,   279,   818,  3488,   454,
     634,   924,   576,    85,  2499,   835,  4121,   627,   645,  2578,
     881,  2344,  1221,  2684,   909,   470,   445,  2405,   447,   713,
    4227,  1227,   758,   613,   627,   454,  1232,   857,   613,   394,
     724,   301,  3327,   419,   817,   576,   719,   614,  2796,  1509,
    1571,   470,   828,  3474,   590,   817,   423,   901,   318,  3492,
     446,   684,   910,   627,  4206,   910,   571,   903,   818,   540,
     817,   614,   108,   910,   807,   817,   112,   910,  2989,   673,
     910,  2992,   648,  2123,   512,  1875,   910,   724,   807,   623,
     360,   719,   791,   910,   628,  1485,   627,   924,   543,   627,
     910,   487,   754,   644,   377,   790,   640,   863,   928,   675,
     863,   595,   596,   480,   648,   749,   910,  1165,  1166,  1167,
     940,  1771,  2122,   684,  1172,  1173,  1174,  1175,   910,   909,
    1178,   576,   702,   829,   766,   829,   670,   483,   713,   749,
    1188,   814,  1190,  1191,   812,   910,   665,  2459,   766,  1197,
    1198,  1199,  1200,  1201,  1872,   975,   749,   576,  3638,   377,
     679,   819,   820,   821,  1212,   908,  1499,   910,   891,  3590,
    3591,   910,   445,   678,   447,   995,   887,   909,   492,  1227,
    2453,   454,   627,   910,  1232,   749,   814,   819,   864,   741,
    1081,  1011,  1083,   829,   829,  1086,   823,   470,  1018,  1100,
    1502,   818,   812,  3249,  1095,   633,   832,  3628,   627,   595,
     596,  1671,  1672,    11,  1034,   827,  3165,   827,   749,   804,
     881,   749,   825,  1079,  1080,  2225,   910,   830,   817,  3802,
     887,   910,  1499,  1089,   827,  1136,   454,   817,   909,   910,
     887,   865,   817,   910,   909,   911,   719,   377,   454,   840,
     817,   817,   470,   863,  3002,   920,   910,   741,   910,  1079,
    1080,   909,  3547,   827,   903,   910,   910,  1657,  1658,  1089,
     479,   802,   910,  1663,   817,  1474,  1666,   910,  3758,   920,
    1233,   910,   719,   909,   909,   819,   820,   821,   910,   910,
     924,  3730,   462,   917,  1596,  1562,   827,   742,   648,   827,
     910,  1822,   910,   576,   749,   909,   910,   901,  3699,   910,
     497,  1077,   910,   279,   924,   909,   457,   975,  1517,  1220,
     909,   887,  4365,   857,   454,   675,  1146,  1822,  1788,  1789,
     749,   924,  1711,  3081,   817,  3083,  1815,   497,   903,   817,
     470,   814,   512,   910,   435,   909,   910,   852,  1683,   725,
    4145,   621,   666,   623,   627,  2598,   626,   828,  1818,  2511,
     924,   631,  1182,   633,   492,   377,   418,   910,   232,  1027,
    1136,  2929,  2930,  2931,  2932,  3286,   743,   814,  4173,   910,
     650,   651,   827,  1149,   698,   655,   910,   910,  1584,  1875,
     909,   910,   662,   924,   928,   719,   924,  3818,  3146,  2884,
     801,   924,   631,   119,   613,  3796,   940,   677,   827,   627,
     462,   812,  2971,   512,   486,   905,  2727,   763,   497,   727,
     910,   691,   497,   693,   694,   903,  2125,   910,   502,   503,
     504,   812,   740,   429,  2964,    44,   782,   697,  1486,   719,
      47,   910,   454,   479,   160,   161,   910,  2644,   794,   407,
     763,   232,  3327,   799,  1274,  3472,  3922,   719,   470,   910,
     512,   816,   719,  2773,    31,   910,   454,   817,    44,   782,
     825,   826,   839,   924,   239,   830,   749,  1011,   219,   924,
     866,  2966,   454,  2968,  1018,  1305,   799,   454,  1815,  1537,
     814,   910,    42,  1027,  3114,   290,   725,   627,  2821,   239,
    3922,   825,   574,   817,   713,   924,   830,  1165,  1166,  1167,
     780,     1,   502,   503,  1172,  1173,  1174,  1408,   197,  3327,
     647,  1537,  1824,   909,    80,   407,  2176,  3012,   454,  1839,
    1188,   749,   454,  1191,   814,  3948,  1584,   887,   666,  1197,
    1198,  1199,  1200,  1201,   618,   818,   446,   587,   446,   819,
     820,   821,   814,  1601,   827,    39,  1934,   814,    20,  3950,
     281,    23,    24,   529,   910,   454,  1956,   709,  3112,  1227,
     698,   687,   335,   539,  1232,   845,   440,   613,  2410,   377,
     396,   335,   418,   454,  1962,   454,   290,  2447,  3073,   849,
    3075,   264,  1791,  1971,  2392,  2393,   454,   239,   414,  4394,
    2398,  2399,   872,   454,   736,  1634,   156,  3624,   817,   827,
    3627,   454,   736,   543,   809,   627,   638,     0,   352,   749,
     353,   197,   644,   817,   884,  3169,   462,   428,   618,   889,
     821,  1165,  1166,  1167,   829,  3922,   638,   910,  1172,  1173,
    1174,  1670,   644,   784,   227,   299,   300,   445,  1182,   447,
     741,   924,     1,  2486,  1188,   454,   454,  1191,   428,   440,
    2970,   506,   388,  1197,  1198,  1199,  1200,  1201,   511,   273,
      19,   335,   470,   352,   407,   945,   512,   713,   563,  1499,
      16,   227,  1502,   825,   234,   955,   956,   294,   830,   761,
     575,   407,   910,  1227,   766,  2555,  2556,   827,  1232,   353,
     280,   910,   381,  3261,   910,   975,   924,  1660,    42,  1662,
    1564,  1664,  1665,  3922,  1667,  1668,   454,   593,   924,   910,
    2013,  3724,   122,  1771,   856,  1254,   126,   854,  2563,   383,
    2565,  1001,   856,  3750,  3751,  2214,   500,   749,   879,   909,
    1274,   592,  1562,   483,   228,   540,   615,   819,   486,   592,
    2993,   881,   568,   299,  1802,  1284,  3887,  1027,  4224,   833,
     834,   891,   111,  1033,   406,    20,    21,    22,  3388,   817,
     615,   536,   846,   109,   814,    16,  1596,   168,   576,    20,
     910,   817,    23,    24,  2117,  3096,  1056,  3098,  2533,     0,
    1060,  1061,  2627,   909,   924,  3922,  1995,   377,  2346,  1655,
    2179,   701,  4224,   701,   558,   763,   557,   528,     7,  1575,
     909,  2271,   742,   486,   125,   827,   615,    38,   909,  2129,
     169,   132,   156,   172,     1,   174,   835,   836,  1486,   627,
     377,  2629,  3029,   497,   568,  1655,   540,   575,   564,   377,
     407,  4307,  3674,  3221,   840,   454,   195,   814,   239,   901,
    2117,  2118,   818,    36,    53,  1650,   846,  1623,   113,   575,
     350,  1627,  1628,   727,  1630,   472,    65,  1633,  1634,   881,
    1636,   454,  2707,    41,   454,    76,   740,   736,   454,   891,
     348,    58,    59,    60,    61,  4307,    63,  2214,  1158,  1159,
     470,  1711,   655,   377,   536,  1165,  1166,  1167,   910,   541,
     234,   747,  1172,  1173,  1174,  1175,   462,   454,  1178,   446,
    2288,   110,   924,   450,   404,  3553,   454,   473,  1188,   120,
    1190,  1191,   910,   470,  2123,   638,  1584,  1197,  1198,  1199,
    1200,  1201,   470,    14,   133,   817,   924,  4224,   910,   288,
     741,  3499,  1212,   910,  1214,  1836,   727,  1713,  1996,  2599,
     377,   749,  1486,  1719,  2917,  1856,  1722,  1227,  1724,   740,
     377,   388,  1232,  3273,   344,  1499,   143,   144,  1502,  2347,
     454,   741,   818,   457,    55,   484,  2497,   527,   794,   830,
    2466,   317,  2181,   204,   910,   186,   470,   830,   910,   753,
     741,   190,   756,   757,  1264,  1815,   675,   856,   548,   382,
    1820,   384,   924,  2721,  1824,  3490,  2396,  2839,  2840,   810,
    2206,  2207,  3919,  4138,   812,  4224,   500,  3502,  3503,  1839,
    4307,   910,  4147,   763,   279,   910,   194,   454,  1562,   827,
    2828,   744,   745,   909,   910,   497,   498,   454,   249,   910,
     810,   377,   782,   470,   255,   153,   446,   627,  4065,  4066,
    1584,   396,   910,   470,   794,   317,   334,  3997,  3998,   799,
    2439,   229,  1596,   543,  2714,   901,  2445,  3552,  2447,   414,
    2449,   554,   271,   909,   454,  2274,   299,  2125,   229,   492,
     627,   924,  2281,   592,  3991,  1851,   548,   549,  4130,   627,
     368,  3729,   483,   429,  1914,  4137,   750,  4224,  4307,  4141,
     391,   817,  4144,   277,   297,   856,   361,   362,   457,  2125,
     294,   579,   910,   297,   125,   583,   821,  2008,   454,   821,
    1886,   132,   454,   291,  4212,  4213,   924,   610,  2176,  1895,
     353,   810,     1,    14,   470,   446,    32,    33,   349,   450,
     291,    14,   341,   627,   219,   613,   323,   324,   325,   326,
     327,   328,   329,   330,   331,   446,   282,   419,  2206,  2207,
    2531,   361,   362,   425,   290,   106,   649,   335,   847,   749,
     391,   382,   910,   384,    55,   168,  2555,  2556,  4118,  4119,
    4307,   377,    55,   438,   439,   353,   924,   809,   817,   661,
    2935,   813,   664,   909,   848,   595,   596,   669,   317,   548,
     627,   529,   749,   396,   817,   910,   407,    76,   910,   252,
     627,   749,   396,   814,   334,   334,  1486,   407,  4395,   160,
     421,   414,   421,  4265,   825,   638,  4268,   816,   454,   830,
     414,   644,   406,   561,   334,   626,   279,   826,   438,   439,
    2507,   626,   710,   444,   442,   443,   239,   827,   368,   368,
     505,   120,   193,  4371,   453,   709,   497,   498,   454,   255,
    4348,  2563,   742,  2565,   454,   749,   207,  1537,   368,   249,
     754,   755,   105,   106,   470,   625,  4364,   454,  2474,  1549,
    2476,  1551,   508,   407,   539,   511,  1820,   637,  2179,   827,
    1824,   627,  2491,   548,   862,   627,   388,  2117,  2118,  2119,
    4418,  4419,   557,   197,  2500,   638,   425,   548,   549,  2129,
     281,   644,  2656,   820,  1584,   407,   825,   186,  1588,   290,
     817,   830,   749,   891,   831,  2627,  2217,   160,  2524,   448,
     910,  1601,   749,  2187,  2188,  2189,  2190,  2191,  2192,  2193,
    2194,   546,   547,   598,   924,   825,  2445,   638,  2447,   575,
     830,   555,   551,   702,   558,   809,   747,   186,  2625,  2179,
     193,   652,   747,   537,   696,   555,   592,   541,   558,    24,
      25,   825,   763,   825,   207,   568,   830,   924,   830,   820,
    1914,   772,   773,   774,   568,  2276,   924,   772,   773,   774,
     831,   782,   815,  2879,  2214,  2215,   825,   710,   609,  2598,
     827,   830,   825,   614,   688,  2707,   878,   830,   799,  3719,
     827,   397,   538,   749,   540,  3114,   593,   749,  1165,  1166,
    1167,   270,  4362,   446,  2244,   624,  2474,   450,  2476,   628,
     299,   627,  1961,   782,  2325,  1197,  1198,   638,  2486,   616,
     924,  2332,   643,  1794,  1191,   613,  1797,  2400,   219,  2402,
    4377,  2404,  2500,  1450,  1805,  4382,  2555,  2556,  1809,   660,
    4018,   662,  1199,  1200,  1201,  1816,  2357,  2125,   817,  4027,
     802,   815,  1469,  1470,  1471,   821,  2524,  4035,   817,  4366,
    4367,   825,  2942,   832,   353,  1755,   830,  2503,  4428,   305,
     483,   827,  2871,   910,  2865,  2412,   710,   924,  2694,  2416,
    3298,  1771,   634,   763,   840,   704,   814,   924,  4463,  4396,
    4465,  2331,  4467,   645,   817,  2468,  2469,   825,   735,   910,
     814,   817,   830,  1793,   656,   657,  2292,  4414,   382,  2295,
     384,   825,  1802,   908,   817,   910,   830,   335,   407,   337,
     538,  4373,   540,   735,  2339,  4252,    19,   817,  2206,  2207,
     388,  2599,   421,   749,  2445,   819,  2447,   821,    37,  2607,
     487,   910,   402,   818,  2763,   764,   817,   822,  2334,   824,
     710,  2454,  2455,  3922,   910,   444,  1173,  1174,   910,   817,
     817,  4468,  2598,  2117,  2118,  2119,   910,  2353,   924,   134,
     910,   910,   924,  4300,  4301,   910,  2362,  2363,   454,  4306,
     689,   219,  4309,   454,   830,   840,  4313,  4314,   817,  2987,
     817,  2431,  2432,  4016,   817,   817,   817,  2437,  2438,  2439,
    2440,   910,   822,  4026,   824,  2445,  2482,  2447,  2972,  2449,
     817,   827,  1902,   626,   454,  3025,  1906,   912,   111,   817,
    2169,   112,  2408,  2409,  2534,   844,  2694,   867,   868,   869,
     870,   867,   868,   869,   870,   867,   868,   869,   870,   722,
     121,   741,  2482,   910,  2555,  2556,  2714,  1267,  1268,  1269,
    1270,   454,  2206,  2207,   407,   817,   808,  2725,  2444,  2499,
     721,  2215,  3381,   335,   607,  2451,   887,  2507,   710,  3388,
    2249,  2250,  2251,  2252,  2710,   139,   169,   561,   558,   172,
     817,   174,   804,   902,   589,  1975,   377,   454,  1978,   724,
    1980,  1981,  1982,   404,   817,   813,  2732,   194,   817,   138,
     613,   909,   195,    14,  2544,  3523,  1996,  2547,   924,   772,
    2000,   354,  2002,   910,  2554,  2555,  2556,  2557,  2008,   812,
     910,   294,   575,  2563,   910,  2565,  3491,   910,   817,   710,
     829,   461,   585,   586,   747,   817,   440,   554,  2475,   289,
    2477,   821,    32,   817,  2780,   910,  2483,  2484,  2485,   638,
     763,   454,   904,  2490,   643,   487,   240,   829,   483,   772,
     773,   774,   344,   454,  2501,  2502,   457,   829,   920,   782,
    3161,   660,   829,   662,  2993,   829,   829,   829,   829,   470,
     829,   829,   829,   241,   829,  2625,   799,  2627,   829,   829,
     853,   296,   812,   242,   688,   288,  2474,   243,  2476,   638,
     245,   161,   794,   360,   137,   794,    78,   660,   246,   500,
     247,   909,   964,   812,  3294,   454,   248,   182,   269,   801,
     829,   252,  2500,   253,   812,    83,   802,   256,   344,   682,
     683,   910,   257,   166,   258,  2125,   259,   910,  2128,   260,
    3239,   891,   344,   290,   486,   608,  2524,    42,   261,     7,
     183,   184,   829,  2826,  2827,  4224,  2829,  2830,  2831,   262,
     403,   263,   344,   264,   201,   265,   817,  2707,   710,   452,
     656,  2161,   817,  1025,   154,   817,  2166,   940,   793,  2428,
    1032,  2721,   335,   910,  1036,  2175,  2176,   675,   807,   168,
     812,   910,   812,   910,   394,    53,   910,  4320,   352,   611,
     456,   454,  3754,  3755,   673,  3385,   487,    65,  2819,   540,
     908,   290,   975,   866,   908,   454,  2206,  2207,   903,   235,
    2474,   314,  2476,  2213,   659,  4153,   251,   344,   817,   403,
    4353,  2221,  2222,   812,   730,   798,   627,   804,  4307,  2229,
     366,   809,   403,  2492,  2493,  2499,  2500,  2733,  3270,   909,
    3272,   403,   110,  2507,   239,   812,   812,  2993,   812,    83,
    2871,   201,  1025,   344,   457,   298,   344,  3374,    83,   403,
    2524,   266,   344,  2759,   817,   133,  2525,  2526,  2818,   710,
     660,   887,   155,    31,   554,  2825,   817,   644,   817,   452,
      76,   546,   108,    14,   741,   136,   923,   419,   887,   922,
     419,   763,   763,   814,   546,   494,   814,   814,   814,  2563,
     814,  2565,  2798,   814,   814,  2801,  2694,  2803,  2804,   814,
    3922,   910,  2808,  3875,  2810,  2811,  2812,  2813,  2577,   352,
    1182,  2871,   190,   812,  2820,   675,  2585,   812,    37,   680,
     655,   566,   419,   352,  3017,   352,   454,   881,     7,   924,
     250,   659,   812,    83,  2732,   548,   226,  2843,   749,   552,
     352,   388,   817,   555,   554,   903,   903,   763,   352,   812,
      16,  2625,    13,  2627,   675,  3927,  3112,   238,  3114,   817,
     710,   701,  1145,   353,  2633,   887,   684,   903,  1151,  3488,
    3809,   457,  2878,    16,    53,    37,   353,   407,  2647,  2648,
     910,   891,  2780,   725,   108,    28,    65,   763,  1260,   462,
    2950,   724,    57,   271,   814,   454,   910,   814,   742,   352,
     512,  1273,  1274,   543,   406,   541,  2966,   239,  2968,    25,
     463,   804,   235,  3169,    83,   887,  2426,   887,   335,   335,
    2694,   474,   168,    14,  1296,   724,   344,   536,    16,   239,
     659,   110,  1215,  2707,   817,   202,   563,   593,   791,   850,
      28,    84,   497,  2453,   886,    95,   817,   804,   924,   710,
     663,   829,  3012,    90,   133,  3585,  3586,   851,   812,    37,
     770,   910,  1245,   341,  2474,   722,  2476,   910,   335,   812,
     450,   882,   883,   554,   725,    25,  2486,   596,  1261,   561,
     196,   741,   814,   352,   344,   212,   352,   186,    14,   702,
    2500,   654,   654,  2503,   823,    55,    84,   494,   207,   564,
     566,   559,   254,   462,   186,   419,   517,   462,   446,   542,
     874,   190,   828,   924,  2524,  3075,   612,   817,  3149,  3638,
     804,  2531,   455,   454,  3217,   344,   809,   741,   910,  4067,
     454,   910,   109,  3707,   390,   748,   804,   750,   817,  3170,
      83,   205,  3705,   421,   810,   197,  3177,   781,   609,   602,
     512,   512,    83,   462,   462,  3115,   462,   277,   537,  3094,
     609,   817,   814,  3069,   910,   812,  3766,  3506,   203,   782,
     203,   763,  3213,   344,  2584,   453,  3172,    13,   804,    23,
     567,  3222,  3223,  2852,   497,   609,   680,   640,  3219,  2599,
     862,   495,   271,  3224,   632,  3191,   910,  2607,   394,   820,
     726,  3197,  4224,   334,   657,   479,  3202,  3203,  3239,   582,
     540,   194,  3172,   812,  3210,   290,  3212,   613,   391,   832,
     817,  2631,   812,    41,   687,  3381,   473,   741,  3188,  3189,
    1502,  3191,  3388,   540,   821,   661,   753,  3197,   817,  3758,
    3200,   847,  3202,  3203,   203,   196,   558,   817,   496,   781,
    3210,   780,  3212,   296,   333,  3215,   226,   821,   497,    23,
    3860,   609,   341,   540,   817,  3795,   290,   205,  4307,   435,
     419,   419,   903,   551,   554,   419,  2686,   553,   435,  3239,
     419,   168,   817,   419,  2694,   419,  3192,   794,   435,   119,
     353,   230,  2966,   108,  2968,  1567,   353,   910,   563,  3455,
    2710,   817,  1485,   440,  2714,  3211,  1578,  3213,   296,   368,
    3270,   392,  3272,   344,  3112,  2725,  3114,  1589,   507,  3225,
      83,   575,   575,   767,  1596,   563,   575,    11,    48,   113,
    3669,    45,   522,    83,   377,   270,   196,    90,  3012,   276,
    3300,   294,   421,  1116,   739,   202,   624,   198,  3878,   428,
     628,  3820,  3540,   471,  3622,  2003,  4062,  2809,  3601,  3741,
    2817,   453,  2831,  3599,  3980,  3034,  3035,  3189,  3887,  1552,
    3916,  3169,  3403,  3991,   453,    91,    92,    93,  3047,  3048,
    2123,   704,  2295,  4307,  2769,  4432,  1623,  3817,  3723,   377,
    2004,  3872,   435,   436,  1577,  3064,  3065,  2780,  4126,  4252,
    4376,  3075,   481,  4381,  3710,  4152,  3868,  4058,  1467,   655,
    4019,   454,  4019,  3943,  3374,   962,  4213,  4054,  4026,  1693,
    3326,  3275,  2844,   231,  1151,   897,   704,   470,  3424,  3522,
    1145,  2870,  2879,  1616,  1157,  1730,  1830,  2505,  3273,  3765,
    3764,  3437,   835,  3245,   845,  1215,  1902,   435,   436,   635,
     891,  3482,  2935,  1875,  2532,  2865,  1246,  3488,   655,  2578,
    2870,   903,   915,   916,  3424,   508,   454,  1279,  1282,  2971,
      41,  3467,   924,  1954,  2980,   554,  1478,  3437,  2982,  1308,
    2607,  3669,   470,  1993,  2998,  2997,   764,  3655,  3517,  3315,
    1483,   970,  2125,   209,   210,  3455,   212,  3692,  3023,  2160,
    2644,  3029,  3038,  3409,  3037,  1550,    77,  3467,    79,  2719,
    2195,  3699,  3553,  2659,  3474,   671,  1009,  1589,  2697,  3858,
     563,  1011,  2222,  2222,  3079,  3897,  3690,  2159,  3488,  2174,
    3564,   102,  3652,  3951,  4077,  3956,  1615,  2427,  1257,  2425,
    3959,  3909,  3908,  1256,  3774,   624,  3662,  3661,  2496,   628,
    2495,   122,  3583,  3084,  3067,   126,  3546,  3588,  3897,  3068,
    2530,  3085,  2529,  3469,  3368,   670,   844,  3367,  2690,  3600,
     842,  3664,  1296,  1928,  2690,   563,  1287,  2690,   695,  2690,
    1954,   995,  1209,  3381,   627,  3172,  2787,   204,  3506,  1995,
    3388,  3540,  1864,  2181,  2993,  2710,  3270,  1212,  3272,  4021,
    2407,   513,  4171,   743,   804,  1624,  3738,  3638,  3796,  3948,
    3279,  2197,  2521,  3023,  2777,  3521,  3686,  3353,  3074,  4321,
    3776,  2951,  4202,  3603,   902,   704,  4353,  2322,  3489,   774,
    3590,  3591,  4206,  4409,   288,  3014,   526,  3179,  2202,   627,
    1894,  4202,  3602,  3934,  1155,  2401,  1632,  3209,  3608,  4368,
      -1,    -1,    -1,  3809,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1844,    -1,  3704,  3570,    -1,    -1,    -1,  3628,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3638,    -1,
     396,   397,    -1,    -1,    -1,   764,    -1,    -1,    -1,    -1,
      -1,    -1,  1875,    -1,  3363,  3364,    -1,  4208,    -1,   778,
      -1,    -1,    -1,  3663,   420,    -1,   749,    -1,  3614,    -1,
    4221,    -1,    -1,    -1,    -1,   758,    -1,    -1,    -1,  3625,
    3626,  3717,  3718,   802,  3630,  3631,  4326,  3758,    -1,    -1,
     446,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3540,  3703,  3740,  3741,    -1,    -1,  3654,    -1,
      -1,  3161,    -1,    -1,    -1,   471,    -1,  3717,  3718,  3665,
    3853,   749,  3950,    -1,    -1,   844,    -1,    -1,    -1,    -1,
      -1,   814,    -1,   816,  4154,    -1,    -1,    -1,    -1,    -1,
    3740,  3741,   825,   826,   827,    -1,   829,   830,    -1,  3695,
    3831,  3832,    -1,    -1,    -1,   366,    -1,    -1,  3758,    -1,
      -1,    -1,  3895,    -1,    -1,    -1,    -1,  3713,    -1,    -1,
    4328,   890,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   902,    -1,  3785,   814,    -1,   816,   908,
      -1,   910,    -1,  4021,    -1,    -1,    -1,   825,   826,   827,
      -1,   829,   830,    -1,    -1,    -1,    -1,    -1,    -1,  3259,
      -1,    -1,   568,    -1,    -1,    -1,    -1,    -1,  3818,    -1,
      -1,   432,    -1,    -1,    -1,  4021,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   446,    -1,    -1,    -1,   450,
      -1,   924,  3292,    -1,    -1,   601,    -1,  3883,    -1,   605,
     606,    -1,  3923,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4434,    -1,    -1,    -1,    -1,    -1,
    3816,    -1,    -1,    -1,  2186,   631,  3822,    -1,     7,    -1,
      -1,    -1,    -1,  3883,    -1,    -1,    -1,  3887,    -1,  3835,
      -1,    -1,    -1,  3929,    -1,    -1,   924,    -1,  2121,    -1,
      -1,  3351,  2125,    -1,    -1,    -1,    -1,    -1,    -1,  3359,
      -1,  3361,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    53,    -1,    -1,    -1,    -1,  3929,
      -1,    -1,    -1,    -1,    -1,    -1,    65,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2168,    -1,    -1,    -1,  3658,
    3659,    -1,    -1,    -1,  3900,    -1,    -1,    -1,    -1,  4030,
      -1,    -1,    -1,    -1,  3910,    -1,    -1,    -1,    -1,    -1,
      -1,  3809,    -1,    -1,    -1,  3921,  3922,    -1,    -1,    -1,
      -1,   110,    -1,   594,   595,   596,  2209,    -1,    -1,    -1,
      -1,    -1,  3938,  3939,    -1,    -1,    -1,    -1,    -1,  2222,
      -1,    -1,    -1,    -1,   133,    -1,    -1,  3953,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4089,    -1,
    3966,    -1,    -1,  3969,  3970,  3971,  3972,    -1,    -1,    -1,
     623,    -1,    -1,  4166,    -1,   628,    -1,   793,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   640,  3498,  4120,
      -1,  3760,  3761,  3762,    -1,   648,    -1,    -1,    -1,    -1,
      -1,   190,  4008,    -1,    -1,    -1,    -1,  4138,  3518,  3519,
      -1,  4017,    -1,   684,  4020,    -1,  4147,   670,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3540,    -1,    -1,  3543,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   729,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3578,    -1,
    4130,    -1,    -1,    -1,    -1,  2358,    -1,  4137,  4366,  4367,
      -1,  4141,   271,    -1,  4144,    -1,    -1,    -1,    -1,  4095,
    4096,  4097,  4098,  4099,    -1,    -1,  4102,  4103,  4104,  4105,
    4106,  4107,  4108,  4109,  4110,  4111,  4112,    -1,  4396,  4115,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4123,    -1,    -1,
      -1,  4252,    -1,    -1,    -1,    -1,  4414,    -1,  4134,    -1,
    4136,    -1,    -1,    -1,    -1,    -1,  3905,  3906,    -1,   810,
    4146,    -1,  3652,    -1,   333,  3655,    -1,    -1,    -1,    -1,
      -1,    -1,   341,    -1,    -1,    -1,    -1,    -1,   811,    -1,
      -1,   832,    -1,    -1,    -1,     1,   819,   820,   821,  4300,
    4301,    -1,    -1,    -1,    -1,  4306,   829,    -1,  4309,    -1,
    4468,    -1,  4313,  4314,    -1,    -1,    -1,    -1,    -1,  3699,
      -1,    -1,  4323,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   857,  4265,    -1,    -1,  4268,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4348,  4224,    -1,
      -1,    57,    58,    59,    60,    61,    -1,    63,    64,    -1,
      -1,    -1,   421,  4364,    -1,    -1,    -1,    -1,   909,   428,
      -1,    -1,    -1,    -1,    -1,    -1,  4377,    -1,    -1,    -1,
    4381,  4382,  2624,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4392,  3772,    -1,   453,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4279,  4280,   928,  4282,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3796,   940,    -1,    -1,
      -1,    -1,   481,  4299,    -1,    -1,    -1,    -1,  4304,  4305,
      -1,  2673,    -1,    -1,   140,    -1,   142,   143,   144,   145,
     146,   147,   148,   149,   150,    -1,  4322,    -1,    -1,  4325,
      -1,    -1,  4328,    -1,  2696,  2697,    -1,    -1,    -1,    -1,
    2613,  2703,    -1,    -1,    -1,  3845,    -1,    -1,    -1,    -1,
    3850,  4472,    -1,    -1,    -1,    -1,    -1,    -1,  1001,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1011,    -1,
      -1,  2644,    -1,    -1,    -1,  1018,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1027,    -1,   212,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3902,  3903,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3918,  3919,
      -1,    -1,    -1,  3923,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   624,  2719,    -1,    -1,   628,
    3950,  3951,    -1,    -1,    -1,    -1,  3956,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3968,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4366,  4367,
      -1,    -1,    -1,  3983,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3994,    -1,    -1,   323,   324,   325,
     326,   327,    -1,    -1,   330,   331,  4006,    -1,  4396,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4021,  1165,  1166,  1167,   704,  4414,    -1,    -1,  1172,
    1173,  1174,  1175,    -1,    -1,  1178,    -1,    -1,  4038,  1182,
     366,  4041,    -1,    -1,    -1,  1188,    -1,  1190,  1191,    -1,
      -1,    -1,    -1,    -1,  1197,  1198,  1199,  1200,  1201,    -1,
      -1,    -1,    -1,    -1,   390,    -1,    -1,    -1,    -1,    -1,
      11,  2933,    -1,    -1,    -1,    16,    -1,    -1,    -1,    -1,
    4468,    -1,    -1,    -1,  1227,   764,    -1,    -1,  4088,  1232,
      -1,  4091,  4092,  4093,  4094,    -1,    -1,    -1,    -1,   778,
      -1,  4101,  4366,  4367,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4114,    -1,    -1,    -1,    -1,    -1,
    4120,  1264,    -1,   802,    -1,    -1,  4126,  4127,    -1,    -1,
      -1,  1274,  4396,    -1,    -1,    -1,    -1,    -1,  4138,    -1,
      -1,    -1,    83,    -1,    -1,    -1,    -1,  4147,    -1,    -1,
    4414,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3024,    -1,    -1,   844,    -1,    -1,    -1,    -1,
      -1,   497,    -1,    -1,    -1,    -1,    -1,    -1,  4178,  4179,
    4180,  4181,  4182,  4183,  4184,  4185,  4186,  4187,  4188,  4189,
    4190,  4191,  4192,  4193,  4194,  4195,  4196,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4468,    -1,    -1,    -1,  4208,  4209,
     151,   890,    -1,    -1,    -1,   156,   157,   158,    -1,    -1,
      -1,  4221,    -1,   902,    -1,    -1,    -1,    -1,    -1,   908,
      -1,   910,   173,  4233,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3017,  4245,   572,    -1,    -1,    -1,
      -1,    -1,  4252,    -1,    -1,    -1,  3029,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     1,    -1,   593,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    11,  4276,  4277,    -1,    -1,
      16,    -1,    -1,    -1,    20,    21,    22,    -1,    -1,    -1,
     616,    -1,    28,    29,    -1,  4295,    -1,    -1,    -1,    -1,
    4300,  4301,    -1,    -1,    -1,    -1,  4306,    -1,  4308,  4309,
      -1,    -1,    -1,  4313,  4314,    -1,    -1,    -1,  3091,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4329,
      -1,  1474,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1486,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4354,    -1,  1499,    -1,    -1,  1502,
      -1,    -1,    -1,    -1,    -1,    -1,  4366,  4367,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   113,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4385,    -1,    -1,  3250,  3251,
    3252,  3253,    -1,    -1,    -1,    -1,  4396,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   350,
      -1,   737,   738,   739,  4414,   151,  4416,  4417,    -1,  1562,
      -1,   157,   158,    -1,    -1,    -1,  3288,  3289,    -1,    -1,
    4430,    -1,    -1,    -1,    -1,  4435,   377,   173,    -1,    -1,
      -1,  1584,    -1,    -1,    -1,  4445,  4446,    -1,    -1,    -1,
      -1,  4451,    -1,  1596,    -1,    -1,    -1,    -1,  1601,  4459,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4468,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   435,   436,   437,    -1,    34,    35,
      -1,    -1,    -1,    -1,   445,    -1,   447,    -1,    -1,    -1,
      -1,    -1,    -1,   454,    -1,    -1,    -1,   458,   459,   460,
      -1,    -1,    -1,    -1,    -1,    -1,   467,    -1,    -1,   470,
      -1,   857,   858,   859,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3315,   279,    -1,   486,    -1,    16,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     296,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   910,    -1,    -1,    -1,    -1,   125,
      -1,    -1,    -1,    -1,    -1,    -1,   132,    -1,    -1,   135,
    3373,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,   550,
      -1,    -1,    -1,    -1,   350,    -1,   557,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   361,   362,    -1,  1771,    -1,
      -1,    -1,    -1,    -1,    -1,   576,    -1,    -1,    -1,    -1,
     109,   377,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3511,
      -1,    -1,  3425,   189,    -1,   191,   192,    -1,    -1,  1802,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   407,    -1,    -1,    -1,    -1,    -1,  1820,    -1,    -1,
      -1,  1824,   151,    -1,    -1,    -1,   627,    -1,   157,   158,
      -1,    49,    50,    51,    52,    -1,    -1,    -1,    56,   435,
     436,   437,   438,   439,   173,    -1,    -1,   648,    -1,   445,
    3483,   447,    -1,    -1,    -1,    -1,    74,    75,   454,    -1,
      -1,    -1,   458,   459,   460,    -1,    -1,    -1,    -1,    -1,
      -1,   467,    -1,    -1,   470,    -1,   677,   273,    -1,   275,
      -1,    -1,    -1,    -1,    -1,    -1,   282,    -1,    -1,    -1,
     486,    -1,    -1,    -1,   290,    -1,    -1,    -1,    -1,  1902,
      -1,    -1,    -1,     1,    -1,   123,    -1,    -1,    -1,   505,
      -1,  1914,    -1,    11,    -1,    -1,    -1,    -1,    16,    -1,
      -1,  3643,    20,    21,    22,    -1,    -1,    -1,    -1,    -1,
      28,  3564,    -1,   529,    -1,    -1,    -1,    -1,    -1,    -1,
     741,    -1,    -1,   539,   162,    -1,    -1,    -1,   749,    -1,
      -1,    -1,   548,    -1,   550,    -1,    -1,    -1,    -1,    -1,
      -1,   557,    -1,    -1,    -1,    -1,    -1,   563,    -1,    -1,
      -1,    -1,    -1,    -1,   775,   776,    -1,    -1,    -1,    -1,
     576,    -1,    -1,    -1,    -1,    -1,    -1,  3620,  3621,  3622,
      -1,    -1,  1995,  1996,    -1,    -1,    -1,    -1,    -1,    -1,
     396,    -1,   598,    -1,    -1,    -1,    -1,    -1,    -1,   338,
     339,   340,    -1,    -1,    -1,   113,    -1,    -1,    -1,    -1,
      -1,   350,    -1,    -1,    -1,    -1,   827,    -1,    -1,    -1,
      -1,   627,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   845,    -1,    -1,    -1,   377,    -1,
     446,    16,    -1,   151,   450,   856,    -1,    -1,    -1,   157,
     158,    -1,   280,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   872,    -1,    -1,    -1,   173,    -1,    -1,    -1,   880,
      -1,   677,    -1,    -1,    -1,    -1,   887,    -1,    -1,    -1,
     486,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3732,
     429,    -1,    -1,   904,    -1,  3738,    -1,    -1,   437,   910,
      -1,    -1,    -1,    -1,  2117,  2118,  2119,    -1,   336,    -1,
      -1,    -1,    -1,   924,    -1,   454,    -1,    -1,    -1,   458,
     459,   460,    -1,    -1,    -1,    -1,    -1,    -1,   467,    -1,
      -1,   470,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   749,    -1,    -1,    -1,   375,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2176,    -1,    -1,    -1,    -1,    -1,   775,
     776,   279,    -1,    -1,    -1,    -1,   151,    -1,    -1,    -1,
      -1,    -1,   157,   158,    -1,    -1,    -1,   295,   296,    -1,
      -1,    -1,    -1,  2206,  2207,    -1,    -1,    -1,   173,    -1,
      -1,    -1,  2215,    -1,    -1,    -1,    -1,    -1,   814,    -1,
     816,   550,   818,    -1,   820,    -1,   822,    -1,   824,   825,
     826,   827,    -1,   829,   830,   831,    -1,    -1,    -1,    -1,
     338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,   845,
     468,    -1,   350,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       1,    -1,    -1,   361,   362,     6,    -1,    -1,     9,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   872,    -1,    -1,   377,
      -1,    -1,    -1,    -1,   880,    -1,    27,    -1,  3921,    -1,
      -1,    -1,    -1,    -1,    -1,   513,    -1,    -1,   627,    40,
      -1,    -1,    -1,    -1,  3937,   701,    -1,    -1,   904,   407,
      -1,    -1,    -1,    -1,   910,    -1,    57,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   924,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   435,   436,   437,
     438,   439,    -1,    -1,    -1,    -1,    -1,   445,   677,   447,
      -1,    -1,    -1,   571,    -1,    -1,   454,   151,    -1,    -1,
     458,   459,   460,   157,   158,    -1,    -1,    -1,    -1,   467,
      -1,    -1,   470,   338,   339,   340,    -1,    -1,    -1,   173,
     121,    -1,    -1,    -1,    -1,   350,    -1,    -1,   486,   785,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     796,    -1,    -1,    -1,    -1,    -1,    -1,   505,    -1,    -1,
      -1,   807,   377,    -1,    -1,     1,    -1,    -1,    -1,    -1,
     749,    -1,    -1,    -1,    -1,    11,    -1,    -1,    -1,  4062,
      16,   529,    -1,    -1,    20,    21,    22,    -1,    -1,    -1,
      -1,   539,    28,    -1,    -1,    -1,   775,   776,    -1,    -1,
     548,    -1,   550,    -1,    -1,    -1,    -1,    -1,   676,   557,
     678,   679,    -1,    -1,    -1,   563,    -1,    -1,    -1,    -1,
      -1,  2474,   437,  2476,    -1,    -1,    -1,    -1,   576,    -1,
     698,    -1,   878,  2486,    -1,   703,    -1,    -1,    -1,   454,
      -1,    -1,    -1,   458,   459,   460,  2499,  2500,   827,    -1,
     598,    -1,   467,    -1,  2507,   470,    -1,    -1,    -1,    -1,
      -1,   840,    -1,    -1,   910,    -1,   845,    -1,    -1,    -1,
      -1,  2524,    -1,   741,    -1,    -1,    -1,   113,    -1,   627,
      -1,    -1,    -1,    -1,    -1,   753,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   872,   338,   339,   340,    -1,    -1,    -1,
      -1,   880,    -1,    -1,    -1,    -1,   350,    -1,    -1,    -1,
    2563,    -1,  2565,    -1,    -1,   151,   307,   308,    -1,    -1,
      -1,   157,   158,    -1,    -1,   904,    -1,    -1,    -1,   677,
      -1,   910,    -1,    -1,    -1,   550,    -1,   173,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   924,  2599,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2607,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2625,    -1,  2627,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   852,    -1,    -1,    -1,    -1,    -1,
      -1,   435,   436,   437,    -1,    -1,    -1,    -1,    -1,    -1,
     391,   749,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     454,    -1,   627,    -1,   458,   459,   460,    -1,    -1,    -1,
      -1,    -1,    -1,   467,    -1,    -1,    -1,   775,   776,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2694,    -1,   279,    -1,    -1,    11,    -1,    -1,    -1,
      -1,    16,    -1,    -1,  2707,   446,    -1,    -1,    -1,    -1,
     296,  2714,   677,    -1,    -1,    -1,   814,    -1,   816,    -1,
     818,   462,  2725,    -1,   822,    -1,   824,   825,   826,   827,
      -1,   829,   830,    -1,    -1,    41,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    49,    50,    51,    52,   845,    -1,    -1,
      56,    -1,   338,   339,   340,    -1,   550,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   350,    -1,    -1,    -1,    74,    75,
      -1,    -1,    -1,    -1,   872,   361,   362,    -1,    -1,    -1,
      -1,    -1,   880,   524,   749,    -1,    -1,    -1,    -1,    -1,
      -1,   377,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   904,    -1,    -1,    -1,
     775,   776,   910,    -1,    -1,    -1,   122,   123,    -1,    -1,
     126,   407,    -1,    -1,   565,    -1,   924,    -1,    -1,    -1,
      -1,    -1,   573,    -1,    -1,    -1,   151,    -1,    -1,    -1,
      -1,    -1,   157,   158,    -1,    -1,    -1,    -1,    -1,   435,
     436,   437,   438,   439,    -1,    -1,   162,    -1,   173,   445,
      -1,   447,   827,    -1,    -1,    -1,    -1,    -1,   454,    -1,
      -1,    -1,   458,   459,   460,    -1,    -1,    -1,    -1,    -1,
     845,   467,    -1,   677,   470,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   638,    -1,    -1,
     486,    -1,    -1,    -1,    -1,    -1,    -1,   872,    -1,    -1,
      -1,   652,    -1,    -1,    -1,   880,    -1,    -1,    -1,   505,
      -1,    -1,    -1,    -1,    -1,    -1,   667,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   904,
      -1,    -1,    -1,   529,    -1,   910,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   539,    -1,    -1,    -1,    -1,    -1,   924,
      -1,    -1,   548,  2966,   550,  2968,   281,    -1,    -1,    -1,
      -1,   557,    -1,    -1,   280,    -1,    -1,   563,    -1,    -1,
      -1,   775,   776,   724,   725,    -1,    -1,    -1,    -1,   730,
     576,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   744,    -1,    -1,    -1,    -1,    -1,  3012,
      -1,    -1,   598,    -1,    49,    50,    51,    52,    -1,    -1,
      -1,    56,   763,   338,   339,   340,    -1,    -1,    -1,    -1,
     336,    -1,    -1,    -1,    -1,   350,    -1,   352,    -1,    74,
      75,   627,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   845,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   377,    -1,    -1,    -1,    -1,    -1,    -1,   375,
      -1,    -1,  3075,    -1,    -1,    -1,   817,    -1,   872,    -1,
     821,    -1,    -1,    -1,    -1,    -1,   880,    -1,   123,    -1,
      -1,   677,    -1,    -1,    -1,    -1,   837,   838,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     904,    -1,    -1,    -1,    -1,    -1,   910,    -1,    -1,    -1,
     435,   436,   437,    -1,    -1,    -1,    -1,   162,    -1,    -1,
     445,    -1,   447,    -1,    -1,    -1,    -1,    -1,    -1,   454,
     446,    -1,    -1,   458,   459,   460,    -1,    -1,    -1,    -1,
      -1,    -1,   467,    -1,    -1,   470,    -1,    -1,    -1,    -1,
      -1,    -1,   468,   749,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   486,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   487,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   775,
     776,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   513,    -1,     3,
      -1,    -1,    -1,   528,     8,    -1,    -1,    -1,    12,    -1,
      -1,    15,    -1,    -1,    -1,    -1,    -1,    -1,   814,    -1,
     816,    -1,   818,    27,    -1,   550,   822,    -1,   824,   825,
     826,   827,    -1,   829,   830,   280,    -1,    -1,    -1,    -1,
      -1,    45,    46,    -1,    -1,    -1,    -1,    -1,    -1,   845,
      -1,   576,    -1,    -1,    -1,   571,    -1,  3270,    -1,  3272,
      -1,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      -1,    -1,    -1,    77,    78,    79,   872,    81,    82,   595,
     596,    -1,    86,    -1,   880,    89,    -1,    -1,    -1,    -1,
      -1,   336,    -1,    97,    98,    99,   100,   101,    -1,   103,
     104,    -1,   627,    -1,    -1,    -1,    -1,    -1,   904,    -1,
     114,    -1,    -1,    -1,   910,    -1,    -1,    -1,    -1,    -1,
     124,    -1,    -1,   127,   128,   129,   130,   131,   924,    -1,
     375,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     675,    -1,   677,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     676,   165,   678,   679,    -1,    -1,    -1,    -1,    -1,    -1,
     174,   175,   176,   177,   178,   179,   180,   181,    -1,    -1,
      -1,   185,   698,   187,   188,    -1,    -1,   703,    -1,    -1,
      -1,    -1,    -1,    -1,   198,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   213,
     214,    -1,    -1,   217,   218,    -1,   220,   221,   222,   223,
     224,    -1,    -1,   468,   749,   741,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   753,    -1,    -1,
     244,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     775,   776,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   267,   268,    -1,    -1,   512,   272,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   283,
      -1,    -1,    -1,   287,    -1,    -1,    -1,    -1,   292,   293,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   827,    -1,    -1,   309,   310,   311,   312,   313,
      -1,    -1,   316,    -1,    -1,    -1,   320,   321,   322,    -1,
     845,    -1,    -1,    -1,    -1,    -1,   571,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   852,    -1,   342,    -1,
      -1,    -1,    -1,   347,    -1,    -1,    -1,   872,    -1,    -1,
     866,   355,   356,   357,   358,   880,    -1,    -1,    -1,    -1,
     364,   365,    -1,   367,    -1,   369,   370,   371,   372,   373,
     374,    -1,   376,    -1,   378,   379,   380,    -1,    -1,   904,
      -1,    -1,    -1,    -1,   909,   910,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   909,    -1,   399,   400,    -1,    -1,   924,
      -1,    -1,    -1,    -1,   408,   409,   410,   411,   412,   413,
      49,    50,    51,    52,    -1,    -1,    -1,    56,   422,    -1,
      -1,    -1,   426,    -1,    -1,    -1,   430,    -1,   432,    -1,
     434,   676,    -1,   678,   679,    74,    75,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   451,    -1,    -1,
      -1,    -1,    -1,   698,    -1,    -1,  3669,    -1,   703,    -1,
     464,   465,   466,    -1,    -1,   469,    -1,    -1,    -1,   473,
      -1,   475,   476,   477,   478,    -1,    -1,    -1,    -1,    -1,
      -1,   485,    -1,    -1,   123,    -1,  3699,   491,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   741,   501,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   509,    -1,    -1,   753,    -1,
     514,   515,   516,    -1,   518,    -1,   520,   521,    -1,   523,
      -1,   525,   526,   162,    -1,   529,   530,    -1,   532,   533,
     534,   535,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     544,   545,    -1,    -1,   548,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   556,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   569,   570,    -1,    -1,    -1,
      -1,    -1,    -1,   577,   578,    -1,   580,    -1,    -1,    -1,
     584,    -1,    -1,  3796,    -1,    -1,    -1,   591,    -1,    -1,
      -1,    -1,    -1,   597,    -1,    -1,    -1,   601,    -1,   603,
     604,    -1,    -1,    -1,    -1,    -1,    -1,   852,    -1,    -1,
      -1,    -1,    -1,   617,    -1,    -1,   620,   621,    -1,    -1,
      -1,   625,    -1,    -1,    -1,    -1,   630,    -1,    -1,    -1,
      -1,   635,    -1,    -1,    -1,   639,    -1,   641,   642,    -1,
      -1,   280,    -1,    -1,    -1,    -1,   650,   651,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   670,   671,   672,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     684,   685,   686,    -1,    -1,    -1,   690,   691,   692,   693,
     694,   695,    -1,    -1,    -1,   699,   700,   336,    -1,    -1,
      -1,    -1,    -1,   707,   708,    -1,    -1,    -1,    -1,    -1,
      -1,   715,   716,   717,   718,    -1,    -1,    -1,    -1,   723,
      -1,    -1,    -1,    -1,   728,    -1,    -1,   731,   732,   733,
     734,    -1,    -1,    -1,    -1,    -1,   375,  3950,    -1,    -1,
      -1,     1,   746,    -1,    -1,     5,    -1,   751,   752,    -1,
      10,    -1,    -1,    -1,    -1,   759,   760,    17,   762,    -1,
      -1,   765,    -1,    -1,    -1,    -1,    26,   771,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   788,   789,    -1,    -1,   792,    -1,
      -1,    -1,    -1,   797,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   805,   806,   807,    -1,    -1,    -1,   811,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    87,    88,   468,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   841,    -1,   843,
      -1,    -1,    -1,   847,    -1,    -1,    -1,    -1,    -1,   853,
      -1,    -1,    -1,    -1,    -1,    -1,   860,   117,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   871,    -1,    -1,
      -1,   875,   876,   877,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,    -1,    -1,   888,    -1,    -1,    -1,   892,   893,
     894,    -1,   896,   897,   898,   899,   900,    -1,    -1,   159,
      -1,    -1,   906,   907,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   918,    -1,    -1,   921,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   186,    -1,    -1,    -1,
      -1,    -1,   571,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     200,    -1,    -1,    -1,    -1,    -1,   206,    -1,   208,    -1,
      -1,    -1,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   233,    -1,   235,    -1,    -1,    -1,   239,
     240,   241,   242,   243,    -1,   245,   246,   247,   248,    -1,
     250,   251,    -1,   253,   254,    -1,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,    -1,    -1,   269,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   277,    -1,    -1,
      -1,    -1,   282,    -1,    -1,   285,    -1,    -1,    -1,    -1,
     290,    -1,    -1,    -1,    -1,   295,    -1,   676,    -1,   678,
     679,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,     1,    -1,    -1,    -1,     5,    -1,   698,
      -1,    -1,    10,    -1,   703,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    26,    -1,
      -1,    -1,    -1,   343,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,    -1,    -1,   354,    -1,    -1,    -1,    -1,   359,
      -1,    -1,   741,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   753,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   385,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   393,    -1,   395,    -1,    -1,   398,    87,
      88,   401,    -1,    -1,    -1,    -1,   406,    -1,    -1,    -1,
      -1,    -1,    -1,  4366,  4367,    -1,   416,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   117,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4396,    -1,    -1,    -1,    -1,    -1,   137,
      -1,    -1,    -1,   141,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4414,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   159,    -1,   852,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   482,    -1,    -1,    -1,    -1,    -1,   488,    -1,
     490,    -1,    -1,   493,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   508,    -1,
      -1,    -1,   200,    -1,    -1,  4468,    -1,   517,   206,    -1,
     208,    -1,    -1,    -1,   212,    -1,    -1,    -1,   216,    -1,
      -1,     6,    -1,    -1,     9,    -1,   536,   537,   538,    -1,
     540,   541,   542,   543,    -1,   233,    -1,    -1,    -1,    -1,
      -1,    -1,    27,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     560,    -1,    -1,    -1,    -1,    40,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   269,    -1,   583,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   285,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   295,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,     1,    -1,    -1,    -1,
       5,    -1,    -1,   623,    -1,    10,    -1,    -1,    -1,   629,
      -1,    -1,    17,   633,    -1,    -1,   636,   637,    -1,    -1,
      -1,    26,    -1,    -1,    -1,    -1,   121,    -1,    -1,    -1,
      -1,    -1,    -1,   653,    -1,   343,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,    -1,    -1,   354,    -1,    -1,   669,
      -1,   359,    -1,    -1,   674,    -1,    -1,    -1,    -1,    -1,
      -1,   681,    -1,    -1,    -1,    -1,    -1,   687,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   385,    -1,    -1,
      -1,    -1,    87,    88,    -1,   393,   706,   395,    -1,    -1,
     398,    -1,    -1,   401,    -1,    -1,    -1,    -1,    -1,    -1,
     720,    -1,    -1,    -1,    -1,    -1,   726,    -1,   416,    -1,
      -1,    -1,   117,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   742,    -1,   744,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   137,    -1,    -1,    -1,   141,    -1,   758,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   768,   769,
      -1,    -1,    -1,    -1,   159,    -1,    -1,   777,    -1,    -1,
     780,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   482,   795,    -1,    -1,    -1,    -1,
     488,    -1,   490,    -1,    -1,   493,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   200,    -1,   817,    -1,    -1,
     508,   206,    -1,   208,    -1,    -1,    -1,   212,   828,    -1,
      -1,   216,   307,   308,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   842,    -1,    -1,    -1,    -1,    -1,   233,    -1,
      -1,    -1,    -1,    -1,    -1,   855,    -1,    -1,    -1,    -1,
      -1,   861,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   560,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   269,   885,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   583,    -1,    -1,    -1,    -1,
     285,    -1,    -1,   903,    -1,    -1,    -1,    -1,    -1,    -1,
     295,    -1,    -1,    -1,   914,    -1,   391,    -1,    -1,   919,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     1,    -1,
      -1,    -1,     5,    -1,    -1,   623,    -1,    10,    -1,    -1,
      -1,   629,    -1,    -1,    17,   633,    -1,    -1,   636,   637,
      -1,    -1,    -1,    26,    -1,    -1,    -1,    -1,   343,    -1,
      -1,    -1,    -1,    -1,    -1,   653,   351,    -1,    -1,   354,
      -1,   446,    -1,    -1,   359,    -1,    -1,    -1,    -1,    -1,
      -1,   669,    -1,    -1,    -1,    -1,   674,   462,    -1,    -1,
      -1,    -1,    -1,   681,    -1,    -1,    -1,    -1,    -1,   687,
     385,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   393,    -1,
     395,    -1,    -1,   398,    87,    88,   401,    -1,   706,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   416,   720,    -1,    -1,    -1,    -1,    -1,   726,    -1,
      -1,    -1,    -1,    -1,   117,    -1,    -1,    -1,    -1,   524,
      -1,    -1,    -1,    -1,    -1,    -1,   744,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   137,    -1,    -1,    -1,   141,    -1,
     758,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     768,   769,    -1,    -1,    -1,    -1,   159,    -1,    -1,   777,
     565,    -1,   780,    -1,    -1,    -1,    -1,   482,   573,    -1,
      -1,    -1,    -1,   488,    -1,   490,    -1,   795,   493,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   508,    -1,    -1,    -1,   200,    -1,   817,
      -1,    -1,    -1,   206,    -1,   208,    -1,    -1,    -1,   212,
      -1,    -1,    -1,   216,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   842,    -1,    -1,    -1,    -1,    -1,
     233,    -1,    -1,   638,    11,    -1,    -1,   855,    -1,    16,
      -1,    -1,    -1,   861,    -1,   560,    -1,   652,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   667,    -1,    -1,    -1,   269,   885,   583,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   285,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   295,    -1,    -1,    -1,   914,    -1,    -1,    -1,
      -1,   919,    -1,    -1,    -1,    -1,    -1,    -1,   623,    -1,
      -1,    -1,    -1,    -1,   629,    -1,    -1,    -1,   633,   724,
      -1,   636,   637,    -1,    -1,   730,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   653,   744,
     343,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,    -1,
      -1,   354,    -1,    -1,   669,    -1,   359,    -1,   763,   674,
      -1,    -1,    -1,    -1,    -1,    -1,   681,    -1,    -1,    -1,
      -1,    -1,   687,    -1,   151,    -1,    -1,    -1,    -1,    -1,
     157,   158,   385,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     393,   706,   395,    -1,    -1,   398,   173,    -1,   401,    -1,
      -1,    -1,    -1,    -1,    -1,   720,    -1,    -1,    -1,    -1,
      -1,   726,   817,   416,    -1,    -1,   821,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   744,
      -1,    -1,   837,   838,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   758,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   768,   769,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   777,    -1,    -1,   780,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   482,
     795,    -1,    -1,    -1,    -1,   488,    -1,   490,    -1,    -1,
     493,    -1,   269,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   817,    -1,    -1,   508,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   842,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     855,    -1,    -1,    -1,    -1,    -1,   861,    -1,    -1,    -1,
      -1,    -1,    -1,     5,    -1,    -1,    -1,   560,    10,    -1,
      -1,   338,   339,   340,    -1,    17,    -1,    -1,    -1,    -1,
     885,    -1,    -1,   350,    26,    -1,    -1,    -1,    -1,    -1,
     583,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   914,
     377,    -1,    -1,    -1,   919,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     623,    -1,    -1,    -1,    -1,    -1,   629,    -1,    -1,    -1,
     633,    -1,    -1,   636,   637,    87,    88,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     653,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   435,   436,
     437,    -1,    -1,    -1,    -1,   117,   669,    -1,   445,    -1,
     447,   674,    -1,    -1,    -1,    -1,    -1,   454,   681,    -1,
      -1,   458,   459,   460,   687,   137,    -1,    -1,    -1,   141,
     467,    -1,    -1,   470,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   706,    -1,    -1,    -1,   159,    -1,   486,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   720,    -1,    -1,
      -1,    -1,    -1,   726,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   744,    -1,    -1,    -1,    -1,    -1,    -1,   200,    -1,
      -1,    -1,    -1,    -1,    -1,   758,    -1,    -1,    -1,    -1,
     212,    -1,    -1,    -1,   216,   768,   769,    -1,    -1,    -1,
      -1,    -1,    -1,   550,   777,    -1,    -1,   780,    -1,    -1,
      -1,    -1,    -1,   235,    -1,    -1,    -1,    -1,   240,   241,
     242,   243,   795,   245,   246,   247,   248,    -1,   250,   576,
     252,   253,   254,    -1,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,    -1,    -1,   269,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   285,    -1,    -1,    -1,    -1,    -1,   842,
      -1,    -1,    -1,   295,    -1,    -1,    -1,    -1,    -1,    -1,
     627,    -1,   855,    -1,    -1,    -1,    -1,    -1,   861,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    44,    -1,    -1,    -1,    -1,    49,    50,    51,
      52,    -1,   885,    -1,    56,    -1,    -1,    -1,    -1,    -1,
      -1,   343,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     677,    -1,   354,    75,    -1,    -1,    -1,   359,    -1,    -1,
      -1,   914,    -1,    -1,    -1,    -1,   919,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   385,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   393,    -1,   395,    -1,    -1,   398,    -1,    -1,   401,
      -1,   123,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   741,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   749,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   160,    -1,
     162,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   775,   776,
      -1,    -1,   174,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   197,    -1,    -1,    -1,    -1,
     482,    -1,    -1,    -1,    -1,    -1,   488,    -1,   490,    -1,
      -1,   493,    -1,   820,    -1,    -1,    -1,    -1,    -1,    -1,
     827,    -1,    -1,    -1,   831,    -1,   508,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   845,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,     8,    -1,    -1,
      -1,    -1,    -1,    -1,    15,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   872,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   880,    -1,    -1,    -1,    -1,   560,    -1,
      -1,    -1,   151,    -1,    45,    -1,    -1,    -1,   157,   158,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   904,    -1,    -1,
      -1,   583,    -1,   910,   173,    66,    67,    68,    69,    70,
      71,    72,    73,    -1,    -1,    -1,    -1,   924,    -1,    -1,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   336,    -1,    97,    98,    99,   100,
      -1,    -1,    -1,    -1,   346,    -1,    -1,    -1,    -1,    -1,
      -1,   633,    -1,   114,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   124,    -1,    -1,   127,   128,   129,    -1,
     131,   653,    -1,   375,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   674,    -1,    -1,    -1,    -1,    -1,    -1,   681,
      -1,    -1,    -1,    -1,   165,   687,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   174,   175,   176,   177,   178,   179,   180,
     181,    -1,    -1,    -1,   706,    -1,   187,   188,    -1,    -1,
      -1,   433,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   726,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   213,   214,    -1,    -1,   217,   218,    -1,    -1,
      -1,   222,   744,   465,    -1,    -1,   468,    -1,    -1,   338,
     339,   340,    -1,    -1,    -1,    -1,   758,    -1,    -1,    -1,
      -1,   350,    -1,   244,    -1,    -1,   768,   769,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   777,    -1,    -1,   780,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   268,    -1,    -1,
     512,   272,    -1,   795,    -1,    -1,    -1,   519,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   287,    -1,    -1,    -1,
      -1,   292,   293,    -1,    -1,   817,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   309,   310,
     311,   312,   313,   555,    -1,   316,    -1,    -1,    -1,    -1,
     842,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   437,   571,
      -1,    -1,    -1,   855,    -1,    -1,    -1,    -1,    -1,   861,
      -1,    -1,    -1,    -1,    -1,   454,    -1,    -1,    -1,   458,
     459,   460,    -1,    -1,   355,   356,   357,   358,   467,    -1,
      -1,    -1,    -1,   364,   365,    -1,   367,    -1,   369,   370,
     371,    -1,    -1,   374,    -1,   376,    -1,   619,    -1,   380,
     622,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   914,    -1,    -1,    -1,    -1,   919,   399,   400,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   408,   409,   410,
     411,   412,   413,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   422,   664,    -1,    -1,   426,    -1,    -1,    -1,   430,
      -1,    -1,    -1,    -1,   676,    -1,   678,   679,    -1,    -1,
      -1,   550,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   698,    -1,    -1,    -1,
      -1,   703,    -1,    -1,    -1,    -1,    -1,    -1,   469,   711,
      -1,    -1,   473,    -1,   475,   476,   477,   478,    -1,    -1,
      -1,    -1,    -1,    -1,   485,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   741,
     501,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   509,    -1,
      -1,   753,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   529,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   544,   545,   787,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   808,    -1,   677,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   577,    -1,    -1,   580,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     591,    -1,    -1,    -1,    -1,    -1,   597,    -1,    -1,    -1,
     601,    -1,   603,   604,    -1,    -1,    -1,    -1,    -1,    -1,
     852,    -1,    -1,    -1,    -1,    -1,   617,    -1,    -1,   620,
     621,    -1,   864,    -1,   625,    -1,    -1,    -1,    -1,   871,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   639,    -1,
     641,   642,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   650,
     651,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   775,   776,    -1,   670,
     671,   672,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   690,
     691,   692,   693,    -1,   695,    -1,    -1,    -1,   699,   700,
      -1,    -1,    -1,    -1,    -1,    -1,   707,   708,    -1,    -1,
      -1,    -1,    -1,    -1,   715,   716,   717,    -1,    -1,    -1,
      -1,    -1,   723,    -1,    -1,    -1,    -1,   728,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   845,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   746,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   759,   760,
      -1,     8,    -1,   872,   765,    -1,    -1,    -1,    15,    -1,
     771,   880,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   788,   789,    -1,
      -1,    -1,    -1,    -1,    -1,   904,   797,    -1,    45,    -1,
      -1,   910,    -1,    -1,   805,    -1,    -1,    -1,    -1,    -1,
     811,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    66,
      67,    68,    69,    70,    71,    72,    73,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    81,    -1,    -1,    -1,    -1,    86,
     841,    -1,    -1,    -1,    -1,    -1,   847,    -1,    -1,    -1,
      97,    98,    99,   100,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   114,    11,    -1,
      -1,    -1,    -1,    16,    -1,    -1,    -1,   124,    -1,    -1,
     127,   128,   129,    -1,   131,    -1,    -1,   888,    -1,    -1,
      -1,    -1,    -1,   894,    -1,   896,    -1,    -1,   899,    -1,
      -1,    -1,    -1,    -1,    -1,   906,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   918,   165,    -1,
     921,    -1,    -1,    -1,    -1,    -1,    -1,   174,   175,   176,
     177,   178,   179,   180,   181,    -1,    -1,    -1,    -1,    -1,
     187,   188,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   213,   214,    -1,    -1,
     217,   218,    -1,    -1,    -1,   222,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   244,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   151,    -1,
      -1,    -1,    -1,    -1,   157,   158,    -1,    -1,    -1,    -1,
      -1,   268,    -1,    -1,    -1,   272,    -1,    -1,    -1,    -1,
     173,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     287,    -1,    -1,    -1,    -1,   292,   293,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   309,   310,   311,   312,   313,    -1,    -1,   316,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   355,   356,
     357,   358,    -1,    -1,    -1,    -1,    -1,   364,   365,    -1,
     367,    -1,   369,   370,   371,    -1,    -1,   374,    -1,   376,
      -1,    -1,    -1,   380,    -1,    -1,    -1,   280,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   399,   400,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   408,   409,   410,   411,   412,   413,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   422,    -1,    -1,    -1,   426,
     427,    -1,    -1,   430,    -1,    -1,    -1,    -1,    -1,   332,
      -1,    -1,    -1,    -1,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   350,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      11,    -1,   469,    -1,    -1,    16,   473,    -1,   475,   476,
     477,   478,    -1,    -1,   377,    -1,    -1,    -1,   485,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   389,    -1,    -1,    -1,
      41,    -1,    -1,    -1,   501,    -1,    -1,    -1,    49,    50,
      51,    52,   509,    -1,    -1,    56,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    74,    75,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   435,   436,   437,    -1,    -1,   544,   545,    -1,
      -1,    -1,   445,    -1,   447,    -1,    -1,    -1,    -1,    -1,
      -1,   454,    -1,    -1,    -1,   458,   459,   460,    -1,    -1,
      -1,    -1,    -1,    -1,   467,    -1,    -1,   470,    -1,    -1,
     577,   122,   123,   580,    -1,   126,    -1,    -1,    -1,    -1,
     483,    -1,    -1,   486,   591,    -1,    -1,    -1,    -1,    -1,
     597,    -1,    -1,    -1,   601,    -1,   603,   604,    -1,    -1,
     151,    -1,    -1,    -1,    -1,    -1,   157,   158,    -1,    -1,
     617,   162,    -1,   620,   621,    -1,    11,    -1,   625,    -1,
      -1,    16,   173,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   639,    28,   641,   642,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   650,   651,    -1,    -1,   550,    -1,    -1,
      -1,    -1,    -1,    -1,   557,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   670,   671,   672,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   576,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   690,   691,   692,   693,    -1,   695,    -1,
      -1,    -1,   699,   700,    -1,    -1,    -1,    -1,    -1,    -1,
     707,   708,    -1,    -1,    -1,    -1,    -1,    -1,   715,   716,
     717,    -1,    -1,    -1,    -1,    -1,   723,    -1,    -1,    -1,
      -1,   728,    -1,    -1,   627,    -1,    -1,    -1,    -1,   280,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   746,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   759,   760,    -1,    -1,   151,    -1,   765,    -1,
      -1,    -1,   157,   158,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   677,    -1,    -1,    -1,   173,    -1,
      -1,   788,   789,    -1,    -1,   336,    -1,   338,   339,   340,
     797,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   805,   350,
      -1,    -1,    -1,    -1,   811,    -1,    -1,    -1,    -1,    -1,
      11,    -1,    -1,    -1,    -1,    16,    -1,    -1,    -1,    20,
      21,    22,    -1,    -1,   375,    -1,   377,    28,    -1,    -1,
      -1,    -1,    -1,    -1,   841,    -1,    -1,    -1,    -1,    -1,
     847,    -1,    -1,    -1,    -1,    -1,   749,    -1,    -1,    -1,
     753,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   775,   776,    -1,   778,    -1,    -1,    -1,    -1,
      -1,   888,    -1,    -1,   435,   436,   437,   894,    -1,   896,
      -1,    -1,   899,    -1,   445,   446,   447,    -1,    -1,   906,
      -1,   296,    -1,   454,    -1,    -1,    -1,   458,   459,   460,
      -1,   918,   113,    -1,   921,    -1,   467,   468,    -1,   470,
     823,    -1,    -1,    -1,   827,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   486,   487,    -1,    -1,    -1,
      -1,    -1,   845,   338,   339,   340,    -1,    -1,    -1,    -1,
     151,    -1,    -1,    -1,    -1,   350,   157,   158,    -1,    -1,
      -1,    -1,   513,    -1,    -1,    -1,    -1,    -1,    11,   872,
      -1,    -1,   173,    16,    -1,    -1,    -1,   880,    -1,    -1,
      -1,    -1,   377,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   550,
      -1,   904,    -1,    -1,    -1,   908,    -1,   910,    -1,    -1,
      -1,    -1,   407,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     571,   924,    -1,    -1,    -1,   576,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     435,   436,   437,    -1,   595,   596,    -1,    -1,    -1,    -1,
     445,    -1,   447,    -1,    -1,    -1,    -1,    -1,    -1,   454,
      -1,    -1,    -1,   458,   459,   460,    -1,    -1,    -1,    -1,
      -1,    -1,   467,    -1,    -1,   470,   627,    -1,   279,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   486,    -1,    -1,    -1,   296,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   151,    -1,
      -1,    -1,    -1,    -1,   157,   158,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   167,   676,   677,   678,   679,    -1,
     173,    -1,    -1,    -1,   529,    -1,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   698,    -1,   350,
      -1,    -1,   703,    -1,    -1,   550,    -1,    -1,    -1,    -1,
     361,   362,    -1,    -1,    -1,    -1,    -1,    -1,   563,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   377,    -1,    -1,    -1,
      -1,   576,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     741,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   749,    -1,
      -1,    -1,   753,    -1,    -1,    -1,   407,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   775,   776,    -1,    -1,    -1,    -1,
      -1,    -1,   627,    -1,   435,   436,   437,   438,   439,    -1,
      -1,    -1,    -1,    -1,   445,    -1,   447,    -1,    -1,    -1,
      -1,    -1,    -1,   454,    -1,    -1,    -1,   458,   459,   460,
      -1,    -1,    -1,    -1,    -1,    -1,   467,    -1,    -1,   470,
      -1,    -1,    -1,    -1,    -1,    -1,   827,    -1,    -1,    -1,
      -1,    -1,   677,    -1,    -1,   486,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   845,   338,   339,   340,    -1,    -1,
      -1,   852,    -1,    -1,   505,    -1,    -1,   350,    -1,    -1,
      -1,    -1,    11,    -1,    -1,   866,    -1,    16,    -1,    -1,
      -1,   872,    -1,    -1,    -1,    -1,    -1,    -1,   529,   880,
      -1,    -1,    -1,    -1,   377,    -1,    -1,    -1,   539,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   548,    -1,   550,
      -1,    -1,    -1,   904,   749,    -1,   557,    -1,   909,   910,
      -1,    -1,   563,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   924,    -1,   576,    -1,    -1,    -1,    -1,
     775,   776,    -1,    -1,    -1,    11,    -1,    -1,    -1,    -1,
      16,    -1,   435,   436,   437,    -1,    -1,   598,    -1,    -1,
      -1,    -1,   445,    -1,   447,    -1,    -1,    -1,    -1,    -1,
      -1,   454,    -1,    -1,    -1,   458,   459,   460,    -1,   814,
      -1,   816,    -1,    -1,   467,    -1,   627,   470,    -1,    -1,
     825,   826,   827,    -1,   829,   830,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   486,    -1,    -1,    -1,    -1,    -1,    -1,
     845,    -1,   151,    -1,    -1,    -1,    -1,    -1,   157,   158,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   167,    -1,
      -1,    -1,    -1,    -1,   173,    -1,   677,   872,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   880,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    11,    -1,    -1,    -1,
      -1,    16,    -1,    -1,    -1,    -1,    -1,   550,    -1,   904,
      -1,    -1,    -1,    -1,    -1,   910,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   151,    -1,    -1,    -1,   924,
      -1,   157,   158,   576,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   167,    -1,    -1,    -1,    -1,    -1,   173,   749,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   775,   776,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   627,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   814,    -1,   816,    -1,   818,    -1,    -1,
      -1,   822,    -1,   824,   825,   826,   827,    -1,   829,   830,
      -1,    -1,    -1,    -1,   677,    -1,   151,    -1,    -1,   338,
     339,   340,   157,   158,   845,    -1,    -1,    -1,    -1,    -1,
      -1,   350,    -1,    -1,    -1,    -1,    -1,    -1,   173,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   872,    -1,    -1,    -1,    -1,    -1,    -1,   377,   880,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   904,    -1,    -1,   749,    -1,    -1,   910,
      -1,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   924,   350,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   775,   776,    -1,    -1,   435,   436,   437,    -1,
      11,    -1,    -1,    -1,    -1,    16,   445,   790,   447,    -1,
      -1,   377,    -1,    -1,    -1,   454,    -1,    -1,    -1,   458,
     459,   460,    -1,    -1,    -1,    -1,    -1,    -1,   467,    -1,
      -1,   470,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   827,    -1,    -1,   486,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   845,    -1,    -1,    -1,    -1,    -1,    -1,   435,
     436,   437,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   445,
      -1,   447,    -1,   338,   339,   340,    -1,    -1,   454,   872,
      -1,    -1,   458,   459,   460,   350,    -1,   880,    -1,    -1,
      -1,   467,    -1,    -1,   470,    -1,    -1,    -1,    -1,    -1,
      -1,   550,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     486,   904,   377,    -1,    -1,    -1,    -1,   910,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   576,    -1,    -1,
     151,   924,    -1,    -1,    -1,    11,   157,   158,    -1,    -1,
      16,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   173,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     435,   436,   437,    -1,   550,    -1,    -1,    -1,   627,    -1,
     445,    -1,   447,    -1,    -1,    -1,    -1,    -1,    -1,   454,
      -1,    -1,    -1,   458,   459,   460,    -1,    -1,    -1,    -1,
     576,    -1,   467,    -1,    -1,   470,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   486,    -1,    -1,    11,    -1,    -1,    -1,   677,    16,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   627,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   151,    -1,    -1,    -1,    -1,
      -1,   157,   158,    -1,    -1,   550,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   173,    -1,    -1,
     749,   677,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   576,    -1,    -1,    -1,    -1,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,   775,   776,    -1,   350,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   790,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   377,    -1,    -1,    -1,
      -1,    -1,   627,    -1,   151,    -1,    -1,    -1,    -1,    11,
     157,   158,    -1,   749,    16,    -1,    -1,    -1,   827,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   173,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   845,    -1,    -1,   775,
     776,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   677,    -1,   435,   436,   437,    -1,    -1,    -1,
      -1,    -1,    -1,   872,   445,    -1,   447,    -1,    -1,    -1,
      -1,   880,    -1,   454,    -1,    -1,    -1,   458,   459,   460,
      -1,    -1,    -1,    -1,    -1,    -1,   467,    -1,    -1,   470,
      -1,   827,    -1,    -1,    -1,   904,    -1,    -1,    -1,    -1,
      -1,   910,   338,   339,   340,   486,    -1,    -1,   344,   845,
      -1,    -1,    -1,    -1,   350,   924,    -1,    -1,    -1,    -1,
      11,    -1,    -1,    -1,   749,    16,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   872,    -1,    -1,    -1,
      -1,   377,    -1,    -1,   880,    -1,    -1,    -1,    -1,   151,
     775,   776,    -1,    -1,    -1,   157,   158,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   904,   550,
      -1,   173,    -1,    -1,   910,    -1,   557,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   812,   924,    -1,
      -1,   338,   339,   340,    -1,   576,    -1,    -1,    -1,   435,
     436,   437,   827,   350,    -1,    -1,    -1,    -1,    -1,   445,
      -1,   447,    -1,    -1,    -1,    -1,    -1,    -1,   454,    -1,
     845,    -1,   458,   459,   460,    -1,    -1,    -1,    -1,    -1,
     377,   467,    -1,    -1,   470,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   627,   872,    -1,    -1,
     486,    -1,    -1,    -1,    -1,   880,    -1,    -1,    -1,    -1,
     151,    -1,    -1,    -1,    -1,    -1,   157,   158,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   904,
      -1,    -1,   173,    -1,    -1,   910,    -1,    -1,   435,   436,
     437,    -1,    -1,    -1,    -1,    -1,   677,    -1,   445,   924,
     447,    -1,    -1,    -1,    -1,    -1,    -1,   454,    -1,    -1,
      -1,   458,   459,   460,   550,    -1,    -1,    -1,    -1,    -1,
     467,    -1,    -1,   470,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   338,   339,   340,   486,
     576,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   350,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   749,    -1,
      -1,    -1,    -1,    -1,    -1,   377,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   627,    -1,    -1,   775,   776,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   550,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   576,
      -1,    -1,    -1,   435,   436,   437,    -1,    -1,    -1,    -1,
      -1,   677,    -1,   445,    -1,   447,   827,   338,   339,   340,
      -1,    -1,   454,    -1,    -1,    -1,   458,   459,   460,   350,
      -1,    -1,    -1,    -1,   845,   467,    -1,    -1,   470,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     627,    -1,    -1,    -1,   486,    -1,   377,    -1,    -1,    -1,
      -1,   872,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   880,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   749,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   904,    -1,    -1,    -1,    -1,    -1,   910,
     677,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   775,
     776,    -1,    -1,   924,   435,   436,   437,    -1,   550,    -1,
      -1,    -1,    -1,    -1,   445,    -1,   447,    -1,    -1,    -1,
      -1,    -1,    -1,   454,    -1,    -1,    -1,   458,   459,   460,
      -1,    -1,    -1,    -1,   576,    -1,   467,    -1,    -1,   470,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   827,    -1,    -1,   741,   486,    -1,    -1,    -1,    -1,
      -1,    -1,   749,    -1,    -1,    -1,    -1,    -1,    -1,   845,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   627,    -1,    -1,   775,   776,
      -1,    -1,    -1,    -1,    -1,    -1,   872,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   880,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   550,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   904,    -1,
      -1,    -1,    -1,    -1,   910,   677,    -1,    -1,    -1,    -1,
     827,    -1,    -1,    -1,    -1,   576,    -1,    -1,   924,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   845,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   872,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   880,    -1,    -1,   627,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   749,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   904,    -1,    -1,
      -1,    -1,    -1,   910,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,     1,   775,   776,    -1,    -1,   924,     7,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   677,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    44,    -1,    -1,    -1,    -1,
      49,    50,    51,    52,    53,   827,    -1,    56,    57,    58,
      59,    60,    61,    -1,    63,    64,    65,    -1,    -1,    -1,
      -1,    -1,    -1,   845,    -1,    74,    75,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   749,    -1,
      -1,    -1,    -1,    -1,    -1,    94,    -1,    -1,    -1,    -1,
     872,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   880,    -1,
      -1,   110,    -1,    -1,   775,   776,   115,    -1,    -1,    -1,
      -1,    -1,    -1,   122,   123,    -1,    -1,   126,    -1,    -1,
      -1,    -1,   904,    -1,   133,    -1,    -1,    -1,   910,    -1,
      -1,   140,    -1,   142,   143,   144,   145,   146,   147,   148,
     149,   150,   924,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,     1,    -1,   827,    -1,    -1,    -1,
      -1,    -1,   171,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   845,    -1,    -1,    -1,    -1,    -1,
      -1,   190,    29,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   872,    -1,   212,    -1,    -1,    -1,    54,    -1,   880,
      57,    58,    59,    60,    61,    -1,    63,    64,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    74,    -1,    -1,
      -1,    -1,    -1,   904,    -1,    -1,    -1,    -1,    -1,   910,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   924,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   271,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   280,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   140,    -1,   142,   143,   144,   145,   146,
     147,   148,   149,   150,    -1,   314,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   323,   324,   325,   326,   327,    -1,
      -1,   330,   331,    -1,    -1,    -1,    -1,   336,    -1,    -1,
      -1,    -1,   341,    -1,    -1,   344,    -1,   346,    -1,    -1,
      -1,    -1,    -1,    -1,   353,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   363,    -1,    -1,   366,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   212,   375,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   390,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   407,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   417,    -1,
      -1,    -1,   421,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     429,    -1,    -1,    -1,   433,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   446,    -1,    -1,
      -1,   450,    -1,    -1,   453,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   299,   300,    -1,    -1,    -1,    -1,    -1,   468,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   314,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   323,   324,   325,   326,
     327,    -1,    -1,   330,   331,    -1,    -1,    -1,   497,    -1,
      -1,    -1,    -1,     1,    -1,    -1,     4,    -1,    -1,    -1,
      -1,    -1,    -1,   512,    -1,    -1,   353,    -1,    -1,    -1,
     519,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   366,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   383,    -1,    -1,    -1,
      -1,    -1,   551,   390,   553,    -1,   555,    -1,    -1,    57,
      58,    59,    60,    61,    -1,    63,    64,    -1,    -1,    -1,
     407,    -1,   571,   572,    -1,    -1,    74,    -1,    -1,    -1,
     417,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   588,
      -1,    -1,   429,    -1,   593,    -1,   595,   596,    -1,    -1,
      -1,    -1,    -1,    -1,   441,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   616,    -1,    -1,
     619,    -1,    -1,    -1,   122,   624,    -1,   125,   126,   628,
      -1,    -1,    -1,    -1,   132,    -1,    -1,    -1,    -1,    -1,
      16,    -1,   140,    -1,   142,   143,   144,   145,   146,   147,
     148,   149,   150,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     497,    -1,    -1,    -1,    -1,   664,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   676,    -1,   678,
     679,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    16,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   704,    -1,    -1,    84,    -1,
      -1,    -1,   711,    -1,   212,    -1,   553,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   572,   735,    -1,   737,   738,
     739,    -1,   741,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   588,    -1,    -1,   753,    -1,   593,    -1,    -1,    -1,
      -1,    -1,    -1,    84,    -1,   764,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   151,    -1,    -1,    -1,   616,
      -1,   157,   158,    -1,    -1,    -1,    -1,    -1,   787,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   173,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   646,
      -1,    -1,    -1,   812,    -1,    -1,   314,    -1,   817,    -1,
      -1,    -1,    -1,    -1,   823,   323,   324,   325,   326,   327,
     151,    -1,   330,   331,    -1,    -1,   157,   158,    -1,    -1,
      -1,   840,    -1,    -1,    -1,   844,    -1,    -1,    -1,    -1,
      -1,    -1,   173,   852,    -1,    -1,    -1,    -1,   857,   858,
     859,   698,    -1,    -1,    -1,    -1,   364,    -1,   366,    -1,
      -1,    -1,    -1,    -1,   873,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   881,    -1,    -1,    -1,    -1,    -1,   887,    -1,
      -1,    -1,   390,    -1,    -1,    -1,    -1,    -1,   735,    -1,
     737,   738,   739,   902,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   910,    -1,   750,    -1,    -1,    -1,    -1,    -1,   417,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   429,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   783,    -1,   446,    -1,
      -1,    -1,   450,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   337,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   350,    -1,    -1,    -1,    -1,    -1,
     817,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   497,
      -1,   377,    -1,   840,    -1,    -1,    -1,    -1,    -1,    -1,
     847,   848,   510,    -1,    -1,    -1,   337,   338,   339,   340,
     857,   858,   859,    -1,    -1,    -1,    -1,    -1,    -1,   350,
      -1,    -1,    -1,    -1,    -1,    -1,   873,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     887,    -1,    -1,    -1,    -1,   553,   377,    -1,   895,   435,
     436,   437,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   910,   572,    -1,    -1,    -1,   454,    -1,
      -1,    -1,   458,   459,   460,    -1,    -1,    -1,    -1,    -1,
     588,   467,    -1,    -1,   470,   593,    -1,    -1,    -1,    -1,
      -1,   599,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   435,   436,   437,    -1,   616,    -1,
      -1,    -1,    -1,     3,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    12,   454,    -1,    -1,    -1,   458,   459,   460,
      -1,    -1,    -1,    -1,    -1,    -1,   467,    27,    -1,   470,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   550,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    65,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    77,    78,    79,
      -1,    -1,    82,    -1,    -1,    -1,    -1,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   101,    -1,   103,   104,    -1,    -1,    -1,    -1,   550,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   735,    -1,   737,
     738,   739,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   747,
     130,   627,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   779,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   677,    -1,    -1,    -1,   185,   627,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   198,   817,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     220,   221,   840,   223,   224,    -1,    -1,    -1,    -1,   847,
      -1,    -1,    -1,    -1,    -1,    -1,   677,    -1,    -1,   857,
     858,   859,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   749,    -1,   873,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,    -1,   887,
      -1,    -1,    -1,   891,    -1,    -1,    -1,    -1,    -1,   775,
     776,    -1,    -1,   283,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   910,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   798,    -1,    -1,    -1,    -1,    -1,   749,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     320,   321,   322,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   827,    -1,    -1,   775,   776,    -1,    -1,    -1,    -1,
      -1,    -1,   342,    -1,    -1,    -1,    -1,   347,    -1,   845,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   798,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   862,    -1,    -1,    -1,
      -1,    -1,   372,   373,    -1,    -1,   872,    -1,   378,   379,
      -1,    -1,    -1,    -1,   880,    -1,   827,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   891,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   845,    -1,    -1,    -1,   904,    -1,
      -1,    -1,    -1,   909,   910,    -1,    -1,    -1,    -1,     4,
      -1,   862,    -1,    -1,    -1,    -1,    -1,    -1,   924,    -1,
      -1,   872,   432,    -1,   434,    -1,    -1,    -1,    -1,   880,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     891,   451,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   904,   464,   465,   466,    -1,   909,   910,
      -1,    -1,    57,    58,    59,    60,    61,    -1,    63,    64,
      -1,    -1,    -1,   924,    -1,    -1,    -1,    -1,    -1,    74,
      -1,   491,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   514,   515,   516,    -1,   518,    -1,
     520,   521,    -1,   523,    -1,   525,   526,    -1,    -1,    -1,
     530,    -1,   532,   533,   534,   535,    -1,   122,    -1,    -1,
     125,   126,    -1,    -1,    -1,    -1,    -1,   132,   548,    -1,
      -1,    -1,    -1,    -1,    -1,   140,   556,   142,   143,   144,
     145,   146,   147,   148,   149,   150,    -1,    -1,    -1,   569,
     570,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   578,    -1,
      -1,    -1,    -1,    -1,   584,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   212,    41,    -1,
     630,    44,    -1,    -1,    -1,   635,    49,    50,    51,    52,
      -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    75,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   684,   685,   686,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   694,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   122,
     123,    -1,    -1,   126,    -1,    -1,    -1,    -1,   718,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   731,   732,   733,   734,    -1,    -1,    -1,   323,   324,
     325,   326,   327,    -1,    -1,   330,   331,   160,    -1,   162,
      -1,   751,   752,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   174,   762,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   364,
      -1,   366,    -1,    -1,   197,    -1,    -1,    -1,    41,    -1,
      -1,    -1,   792,    -1,    -1,    -1,    49,    50,    51,    52,
      -1,    -1,    -1,    56,    -1,   390,   806,   807,   151,    -1,
      -1,    -1,    -1,    -1,   157,   158,    -1,    -1,    -1,    -1,
      -1,    74,    75,    -1,    77,    -1,    79,    -1,    -1,    -1,
     173,    -1,   417,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   843,    -1,    -1,    -1,    -1,    -1,   102,
      -1,    -1,    -1,   853,    -1,    -1,    -1,    -1,    -1,    -1,
     860,   446,    -1,    -1,    -1,   450,    -1,    -1,    -1,   122,
     123,   871,    -1,   126,    -1,   875,   876,   877,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   892,   893,    -1,    -1,    -1,   897,   898,    -1,
     900,    -1,    -1,    -1,    -1,    -1,    -1,   907,    -1,   162,
      -1,    -1,   497,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   336,    -1,   510,    -1,    -1,    -1,    -1,
      -1,    -1,   345,   346,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   375,    -1,    -1,    -1,    -1,    -1,   553,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   572,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,   588,    -1,    -1,   419,   350,   593,    -1,
      -1,    -1,    -1,    -1,   599,    -1,    -1,    -1,    -1,    -1,
     433,    -1,    -1,    -1,    -1,    -1,    -1,   280,    -1,    -1,
      -1,   616,    -1,   446,   377,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   465,    -1,    -1,   468,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   487,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   336,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   435,   436,   437,    -1,    -1,    -1,    -1,   512,
      -1,    -1,   445,    29,   447,    -1,   519,    -1,    -1,    -1,
      -1,   454,    -1,   366,    -1,   458,   459,   460,    -1,    -1,
      -1,    -1,   375,    -1,   467,    -1,    -1,   470,    54,    -1,
      -1,    57,    58,    59,    60,    61,    -1,    63,    64,    -1,
      -1,    -1,   555,    -1,    -1,    -1,    -1,    -1,    74,    -1,
     735,    -1,   737,   738,   739,    -1,    -1,    -1,   571,    -1,
      -1,    -1,   747,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   432,
      -1,    -1,   595,   596,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   446,   779,    -1,    -1,   450,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   619,   550,    -1,   622,
      -1,    -1,    -1,    -1,   140,   468,   142,   143,   144,   145,
     146,   147,   148,   149,   150,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   817,   576,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   664,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   512,
      -1,    -1,   847,   676,    -1,   678,   679,    -1,    -1,    -1,
      -1,    -1,   857,   858,   859,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   627,   698,   212,    -1,   873,    -1,
     703,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   711,    -1,
      -1,    -1,   887,    -1,    -1,    -1,   891,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   571,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   741,    -1,
      -1,    -1,    -1,    -1,   677,    -1,    -1,    -1,    -1,    -1,
     753,   594,   595,   596,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   151,    -1,    -1,
      -1,    -1,    -1,   157,   158,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   787,    -1,    -1,    -1,    -1,   173,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   807,   808,    -1,   323,   324,   325,
     326,   327,    -1,    -1,   330,   331,   749,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   676,    -1,   678,   679,    -1,    -1,    -1,
      -1,   684,   775,   776,    -1,    -1,    -1,    -1,    -1,   852,
     366,    -1,    -1,    -1,    -1,   698,    -1,    -1,    -1,    -1,
     703,   864,    -1,    -1,    -1,    -1,    -1,    -1,   871,    -1,
      -1,    -1,    -1,    -1,   390,    -1,    -1,    -1,    -1,    -1,
      -1,   814,    -1,    -1,    -1,    -1,   729,    -1,    -1,    -1,
      -1,   407,   825,    -1,   827,    -1,   829,   830,   741,    29,
      -1,   417,    -1,    -1,    -1,    -1,   909,    -1,    -1,    -1,
     753,    -1,   845,   429,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    54,   441,    -1,    57,    58,    59,
      60,    61,    -1,    63,    64,    -1,    -1,    -1,    -1,   872,
      -1,    -1,    -1,    -1,    74,    -1,    -1,   880,    -1,    -1,
      -1,    -1,    -1,    -1,   338,   339,   340,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   350,   810,    -1,    -1,
      -1,   904,    -1,    -1,    -1,    -1,    -1,   910,    -1,    -1,
      -1,   497,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   832,
      -1,   924,    -1,   377,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   852,
     140,    -1,   142,   143,   144,   145,   146,   147,   148,   149,
     150,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   553,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   435,   436,   437,    -1,    -1,   572,    -1,    -1,    -1,
      -1,   445,    -1,   447,    -1,    -1,   909,    -1,    -1,    -1,
     454,    -1,   588,    -1,   458,   459,   460,   593,    -1,    -1,
      -1,    -1,   212,   467,    -1,    -1,   470,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     616,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    44,    -1,
     646,    -1,    -1,    49,    50,    51,    52,    -1,    -1,    -1,
      56,    57,    58,    59,    60,    61,    -1,    63,    64,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    74,    75,
      -1,    -1,    -1,    -1,    -1,    -1,   550,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    94,    -1,
      -1,    -1,   698,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   576,   323,   324,   325,   326,   327,    -1,   115,
     330,   331,    -1,    -1,    -1,    -1,   122,   123,    -1,    -1,
     126,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   735,
      -1,   737,   738,   739,   140,    -1,   142,   143,   144,   145,
     146,   147,   148,   149,   150,    -1,   366,    -1,    -1,    -1,
      -1,    -1,    -1,   627,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   171,    -1,    -1,    -1,    -1,
     390,    -1,    -1,    -1,    -1,    -1,    -1,   783,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   407,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   417,    -1,    -1,
      -1,    -1,    -1,   677,    -1,    -1,   212,    -1,    -1,   429,
      -1,   817,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   441,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   840,    -1,    -1,    -1,    -1,    -1,
      -1,   847,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   857,   858,   859,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   873,    -1,    -1,
      -1,    -1,    -1,    -1,   280,   749,    -1,   497,    -1,    -1,
      -1,   887,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   895,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   775,   776,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   786,    -1,    -1,    -1,    -1,   323,   324,   325,
     326,   327,    -1,    -1,   330,   331,    -1,    -1,    -1,    -1,
     336,    -1,    -1,   553,    -1,    -1,    -1,    -1,   344,    -1,
     346,    -1,    -1,    -1,    -1,    -1,    -1,   353,    -1,    -1,
      -1,   825,   572,   827,    -1,   829,   830,   363,    -1,    -1,
     366,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   588,   375,
      -1,   845,    -1,   593,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   390,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   616,    -1,   872,    -1,
      -1,   407,    -1,    -1,    -1,    -1,   880,    -1,    -1,    -1,
      -1,   417,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   646,   433,    -1,    -1,
     904,    -1,    -1,    -1,    -1,    -1,   910,    -1,    -1,    -1,
     446,    -1,    -1,    -1,   450,    -1,    -1,    -1,    -1,    -1,
     924,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   468,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   698,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   497,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   512,    -1,    -1,    -1,
      -1,    -1,    -1,   519,    -1,   735,    -1,   737,   738,   739,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   553,    -1,   555,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   783,    -1,   571,   572,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   588,    -1,    -1,    -1,    -1,   593,    -1,   595,
     596,    -1,    -1,    -1,    -1,    -1,    -1,   817,    -1,    -1,
      -1,    -1,   151,    -1,    -1,    -1,    -1,    -1,   157,   158,
     616,    -1,    -1,   619,    -1,    -1,    -1,    -1,    -1,    -1,
     840,    -1,    -1,    -1,   173,    -1,    -1,   847,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   857,   858,   859,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   873,    -1,    -1,    -1,    -1,   664,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   887,    -1,    -1,
     676,    44,   678,   679,    -1,   895,    49,    50,    51,    52,
      -1,    -1,    -1,    56,    57,    58,    59,    60,    61,    -1,
      63,    64,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    74,    75,    -1,    -1,   711,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    94,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   735,
      -1,   737,   738,   739,    -1,   741,    -1,    -1,    -1,    -1,
      -1,    -1,   115,    -1,    -1,    -1,    -1,   753,    -1,   122,
     123,    -1,    -1,   126,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   140,    -1,   142,
     143,   144,   145,   146,   147,   148,   149,   150,    -1,    -1,
      -1,   787,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   338,
     339,   340,    -1,    -1,    -1,    -1,   151,    -1,   171,    -1,
      -1,   350,   157,   158,    -1,    -1,   812,    -1,    -1,    -1,
      -1,   817,    -1,    -1,    -1,    -1,    -1,   823,   173,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   377,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   212,
      -1,    -1,    -1,    -1,    -1,    -1,   852,    -1,    -1,    -1,
      -1,   857,   858,   859,    -1,    -1,    -1,    -1,   151,    -1,
      -1,    -1,    -1,    -1,   157,   158,    -1,   873,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   881,    -1,    -1,    -1,    -1,
     173,   887,    -1,    -1,    -1,    -1,   435,   436,   437,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   445,    -1,   447,    -1,
      -1,    -1,    -1,    -1,    -1,   454,    -1,   280,    -1,   458,
     459,   460,    -1,    -1,    -1,    -1,    -1,    -1,   467,    -1,
      -1,   470,   151,    -1,    -1,    -1,    -1,    -1,   157,   158,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   173,    -1,    -1,    -1,    -1,    -1,
     323,   324,   325,   326,   327,    -1,    -1,   330,   331,    -1,
      -1,    -1,    -1,   336,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   344,    -1,   346,    -1,    -1,    -1,    -1,    -1,    -1,
     353,    -1,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
     363,    -1,    -1,   366,    -1,   350,    -1,    -1,    -1,    -1,
      -1,   550,   375,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   390,    -1,    -1,
      -1,    -1,   377,    -1,    -1,    -1,    -1,   576,    -1,    -1,
      -1,    -1,    -1,    -1,   407,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   417,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   350,    -1,    -1,
     433,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   446,    -1,    -1,    -1,   450,   627,    -1,
     435,   436,   437,    -1,   377,    -1,    -1,    -1,    -1,    -1,
     445,    -1,   447,    -1,    -1,   468,    -1,    -1,    -1,   454,
      -1,    -1,    -1,   458,   459,   460,    -1,    -1,    -1,   338,
     339,   340,   467,    -1,    -1,   470,    -1,    -1,    -1,    -1,
      -1,   350,    -1,    -1,   497,    -1,    -1,    -1,   677,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   512,
      -1,    -1,   435,   436,   437,    -1,   519,    -1,   377,    -1,
      -1,    -1,   445,    -1,   447,    -1,    -1,   151,    -1,    -1,
      -1,   454,    -1,   157,   158,   458,   459,   460,    -1,    -1,
      -1,    -1,    -1,    -1,   467,    -1,    -1,   470,    -1,   173,
     553,    -1,   555,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   550,    -1,    -1,   571,   572,
     749,    -1,    -1,    -1,    -1,    -1,   435,   436,   437,    -1,
      -1,    -1,    -1,    -1,    -1,   588,   445,    -1,   447,    -1,
     593,   576,   595,   596,    -1,   454,   775,   776,    -1,   458,
     459,   460,    -1,    -1,    -1,    -1,    -1,    -1,   467,    -1,
      -1,   470,    -1,   616,    -1,    -1,   619,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   550,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   814,    -1,    -1,    -1,    -1,
      -1,    -1,   627,    -1,    -1,    -1,   825,    -1,   827,    -1,
     829,   830,    -1,   576,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   664,    -1,    -1,    -1,    -1,   845,    -1,    -1,    -1,
      -1,    -1,    -1,   676,    -1,   678,   679,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   550,   677,   872,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   880,    -1,    -1,   627,    -1,    -1,    -1,   711,    -1,
      -1,    -1,    -1,    -1,   338,   339,   340,   576,    -1,    -1,
      -1,   151,    -1,    -1,    -1,   904,   350,   157,   158,    -1,
      -1,   910,   735,    -1,   737,   738,   739,    -1,   741,    -1,
      -1,    -1,    -1,   173,    -1,   924,    -1,    -1,    -1,    -1,
     753,    -1,    -1,   377,   677,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   749,    -1,    -1,    -1,   627,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   151,    -1,    -1,    -1,
      -1,    -1,   157,   158,   787,    -1,    -1,    -1,    -1,    -1,
     775,   776,    -1,    -1,    -1,    -1,    -1,    -1,   173,    -1,
      -1,   786,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   812,
      -1,   435,   436,   437,   817,    -1,    -1,    -1,   677,    -1,
     823,   445,    -1,   447,    -1,    -1,   749,    -1,    -1,    -1,
     454,    -1,    -1,    -1,   458,   459,   460,    -1,    -1,    -1,
     825,    -1,   827,   467,   829,   830,   470,    -1,    -1,   852,
      -1,    -1,   775,   776,   857,   858,   859,    -1,    -1,    -1,
     845,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     873,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   881,   151,
      -1,    -1,    -1,    -1,   887,   157,   158,   872,    -1,    -1,
     749,   814,    -1,    -1,    -1,   880,    -1,    -1,    -1,    -1,
      -1,   173,   825,    -1,   827,    -1,   829,   830,   338,   339,
     340,    -1,    -1,    -1,    -1,    -1,   775,   776,    -1,   904,
     350,    -1,   845,    -1,    -1,   910,   550,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   924,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   377,    -1,   872,
      -1,    -1,   576,    -1,    -1,    -1,    -1,   880,    -1,    -1,
      -1,    -1,    -1,   338,   339,   340,   825,    -1,   827,    -1,
     829,   830,    -1,    -1,    -1,   350,    -1,    -1,    -1,    -1,
      -1,   904,    -1,    -1,    -1,    -1,   845,   910,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   924,   377,   627,    -1,   435,   436,   437,    -1,    -1,
      -1,    -1,    -1,   872,    -1,   445,    -1,   447,    -1,    -1,
      -1,   880,    -1,    -1,   454,    -1,    -1,    -1,   458,   459,
     460,    -1,    -1,    -1,    -1,    -1,    -1,   467,    -1,    -1,
     470,    -1,    -1,    -1,   668,   904,    -1,    -1,    -1,    -1,
      -1,   910,    -1,   677,    -1,    -1,    -1,    -1,    -1,    -1,
     435,   436,   437,    -1,    -1,   924,   338,   339,   340,    -1,
     445,    -1,   447,    -1,    -1,    -1,    -1,    -1,   350,   454,
      -1,    -1,    -1,   458,   459,   460,    -1,    -1,    -1,    -1,
      -1,    -1,   467,    -1,    -1,   470,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   377,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     550,    -1,    -1,    -1,    -1,   749,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   576,    -1,    -1,    -1,
      -1,   775,   776,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   437,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   550,    -1,    -1,    -1,    -1,
      -1,    -1,   454,    -1,    -1,    -1,   458,   459,   460,    -1,
      -1,    -1,    -1,    -1,    -1,   467,    -1,   627,   470,    -1,
      -1,   576,    -1,   827,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   845,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   866,    -1,    -1,    -1,    -1,   677,   872,    -1,
      -1,    -1,   627,    -1,    -1,    -1,   880,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   550,    -1,
     904,    -1,    -1,    -1,    -1,    -1,   910,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     924,    -1,   677,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   749,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   775,   776,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   627,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   749,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   827,    -1,   829,
     775,   776,    -1,    -1,    -1,   677,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   845,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   872,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     880,    -1,   827,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     845,    -1,    -1,    -1,   904,    -1,    -1,   749,    -1,    -1,
     910,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   924,    -1,    -1,   872,    -1,    -1,
      -1,    -1,    -1,   775,   776,   880,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   904,
      -1,    -1,    -1,    -1,    -1,   910,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   924,
      -1,    -1,    -1,    -1,    -1,   827,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   845,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     872,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   880,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   904,    -1,    -1,    -1,    -1,    -1,   910,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   924
};

  /* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
     symbol of state STATE-NUM.  */
static const yytype_uint16 yystos[] =
{
       0,   927,   928,     0,   929,   930,   931,   934,   935,   382,
     384,   932,   933,   936,   937,   947,   948,   949,   562,   944,
     962,   933,   349,   614,   950,   953,   219,   817,   273,   971,
     972,   954,   951,   944,   944,   817,    36,   963,   964,   219,
     945,   153,   973,   974,   817,   817,   255,   938,   939,   940,
     249,   942,   407,  2162,   197,   966,   817,   186,  1134,  1136,
    1137,   710,   397,  1054,  1055,    19,   111,   169,   172,   174,
     195,   288,   457,   548,   552,   663,   702,   748,   750,   782,
     832,   910,   975,   976,   977,   978,   982,   996,  1002,  1003,
    1004,  1005,  1006,  1012,  1028,  1030,  1035,  1038,  1043,  1044,
    1046,  1047,  1048,  1049,  1050,  1051,  1052,   454,   615,   955,
     955,   941,   940,   943,   500,   753,   756,   757,   965,   688,
     270,   967,   219,   946,   821,  1138,   817,   710,   305,  1056,
       1,   910,  2039,  2039,   763,   735,  2190,  2162,  2162,  2162,
    2039,   735,   817,   817,  2162,   817,   817,   109,   154,  2144,
    1053,  1007,   977,     1,   817,  1005,   388,  1029,    37,   957,
     957,   454,   615,   956,   956,   487,  2174,  2162,   402,   969,
     817,   609,  1412,  1413,  1417,   710,  1139,   817,   817,  1057,
    1013,   335,  1041,  2153,  2162,  2162,   910,  2032,  2086,   134,
    2032,  2162,  2162,   983,   997,  2032,   979,   910,  1036,  1037,
    1200,   910,  1031,  1032,  1033,  2040,  2162,   454,   555,   558,
    1008,  1010,  1011,  1801,  2092,  2162,   910,   454,   817,   952,
     817,   817,  2162,   118,   766,   819,   968,   689,   817,   219,
    1442,  1443,   817,   302,   705,  1135,  1140,  1141,  1143,   415,
     714,  1058,  1117,  1118,  1014,  1017,  1018,  2153,  2162,    23,
     497,  2032,   454,   388,   554,  2214,   454,   840,   108,   479,
     613,   713,   910,   984,   985,   986,   987,   988,   992,   993,
     995,  2143,  2185,   348,   613,   998,   999,  1000,   980,   995,
    1037,  2162,  1032,    31,   407,  2040,  2164,  2039,  1801,   407,
     763,  2181,  2162,   169,  2039,   958,  2162,    48,   502,   503,
     504,   618,   833,   834,   846,  2125,  2162,  1414,     1,     5,
      10,    17,    26,    87,    88,   117,   137,   141,   159,   200,
     206,   208,   212,   216,   233,   269,   285,   295,   343,   351,
     354,   359,   385,   393,   395,   398,   401,   416,   482,   488,
     490,   493,   508,   560,   583,   623,   629,   633,   636,   637,
     653,   669,   674,   681,   687,   706,   720,   726,   744,   758,
     768,   769,   777,   780,   795,   817,   842,   855,   861,   885,
     914,   919,  1444,  1445,  1473,  1478,  1483,  1488,  1514,  1518,
    1526,  1530,  1531,  1535,  1538,  1543,  1548,  1599,  1603,  1605,
    1610,  1626,  1630,  1633,  1636,  1640,  1641,  1648,  1658,  1661,
    1664,  1682,  1691,  1695,  1697,  1701,  1704,  1708,  1722,  1736,
    1738,  1742,  1757,  1758,  1768,  1771,  1772,  1776,  1782,  1783,
    1791,  1798,  1815,  1825,  1834,  1840,  1851,  1855,  1857,  1860,
    1863,  1866,  1877,  1896,  1904,  1929,  1444,   912,  1190,  1192,
    1193,     1,   910,  2020,   817,   529,   561,  2122,    30,   492,
     666,   698,  1119,  1120,  1121,  1122,  1124,  1125,  1126,  1131,
    1015,  1016,    23,   497,   377,   454,   470,   627,   749,   827,
     924,  1039,  1040,  2096,   909,  1045,  2205,  2086,   722,   741,
    2193,  2162,   817,   986,   817,   910,   985,   112,   121,   989,
    2145,    16,   350,   910,  1001,   910,     1,   817,  1000,   981,
    2205,    16,   377,   454,   470,   627,   749,   827,   924,  2097,
    2098,  2099,   454,  1034,  2093,  2181,   407,  2039,  2039,  1009,
    1010,   817,   138,   299,   645,   823,   959,   960,   961,   502,
     503,   618,   846,   970,    85,   486,   574,   761,   766,   819,
    1495,  1496,     5,    10,    17,    26,    87,    88,   117,   137,
     141,   159,   200,   212,   216,   235,   240,   241,   242,   243,
     245,   246,   247,   248,   250,   252,   253,   254,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   269,
     285,   295,   343,   351,   354,   359,   385,   393,   395,   398,
     401,   482,   488,   490,   493,   508,   560,   583,   633,   653,
     674,   681,   687,   706,   726,   744,   758,   768,   769,   777,
     780,   795,   817,   842,   855,   861,   914,   919,  2129,  2130,
    2131,  1446,  1474,  1479,  1484,  1489,  1515,  1519,  1527,  1532,
    1539,  1536,  1544,  1549,  1600,  1604,   335,  1606,  1611,  1627,
    1631,  1634,  1637,   352,   675,  1506,  1629,  1642,  1649,  1659,
    1662,  1665,   351,   581,  1696,  1698,  1702,  1705,   721,  1709,
    1723,  1737,  1739,  1743,  1759,  1769,  1773,  1777,  1784,  1792,
    1799,  1816,  1826,   454,   627,   696,   749,   802,   924,  1838,
    1839,  1988,  2080,  2081,  2086,  1841,  1852,   607,  1856,  1858,
    1431,  1861,  1864,  1867,  1878,  1897,   351,   581,   710,   139,
    1171,   232,   727,   740,  1194,  1195,  1197,  1208,  1210,  1212,
    2114,   817,  1142,   561,  2039,   137,   166,   183,   184,   298,
     463,   474,   602,   640,   657,   915,   916,  1127,   558,  1132,
    2179,   638,   744,   745,  1123,     1,   817,  1121,  2162,  2162,
     388,  1040,  1042,   804,   589,  2162,  2092,   817,  2162,   724,
     404,   957,     1,   350,   404,   957,   817,   817,   194,  2099,
     813,  2093,  2039,   961,  2185,   138,   909,  1492,   557,   910,
    1447,  1450,  1451,  1452,  2021,  2080,    11,   151,   157,   158,
     167,   173,   338,   339,   340,   350,   435,   436,   437,   445,
     447,   458,   459,   460,   467,   486,   550,   576,   677,   775,
     776,   790,   845,   872,   880,   904,  1475,  2012,  2044,  2045,
    2047,  2048,  2080,  2097,  2101,  2102,  2103,  2104,  2222,   825,
     829,   830,  1480,  2007,  2008,  2009,  2010,  2011,  2012,  2048,
    2051,  2080,  2098,  2101,   454,  1485,  1486,  2028,  2029,  2030,
    2086,  1490,  1495,   454,   615,  1516,  1517,  2064,  2080,   908,
    1520,  1521,  1523,  2020,    11,  1528,  2012,  2013,  2014,  2042,
    2083,  2084,  2086,  2098,    14,  1533,   821,  1540,  2020,    16,
    1537,  2080,  2082,   396,   414,   568,   794,  1545,  1547,   280,
     332,   389,   454,   483,   557,   753,   778,   823,   908,  1550,
    1551,  1552,  1553,  1555,  1562,  1564,  1565,  1566,  1569,  1574,
    1577,  1578,  1581,  1583,  2044,  2064,  2080,  1601,  2045,  1545,
     354,  1495,  1608,   820,   831,  1612,  1613,  1614,  1992,  1993,
    1994,   348,   579,   583,   613,   710,  1628,  1632,  2041,  2042,
    1635,  2086,   812,  1638,  2201,  2045,     1,  1991,  1992,  1650,
    2041,   910,  1660,  2022,   160,   908,  1353,  1586,  1663,  2080,
    1666,  1667,  2080,  2097,  2101,  1683,  1692,  1817,  2073,  2074,
    2086,  1353,  1586,  1699,   167,  1703,  2045,  1706,  2045,   294,
    1710,  1711,  1712,   388,  1724,  1986,  2155,   910,  2021,   290,
    1740,  2080,  1744,  2020,  1760,  2021,  1770,  2015,  2086,  1774,
    2020,   821,  1778,  2015,  2016,    16,  1785,  2017,  2086,  1793,
    2021,   273,   425,   486,  1800,  1803,  1804,  1807,  1808,  1809,
    1810,  1811,  1812,  1813,  1814,  1988,  2023,  2024,  2041,  2072,
    2074,  2086,  1817,  1827,  2020,  1835,  2080,   829,  2090,  2091,
    1842,  1843,  1844,   167,   790,  1853,  2044,  1859,  2022,   817,
     910,  1432,  1433,  1436,  1437,  1442,  1862,  2075,  2080,  1865,
    2020,   454,  1868,  2065,  2080,  2101,  1879,  2080,  1898,  2016,
    1905,  1930,   817,   710,   461,  1279,  1200,  1200,  1200,  1195,
     817,     1,   314,  1198,  1199,  1200,   440,  1144,  1059,  2179,
    2201,  2201,   554,  2178,  2179,  2179,  2201,  2179,  2179,  2201,
    2179,  2179,   821,  2152,   289,  2151,   454,  1071,  2086,    32,
    2135,   817,    39,   228,   377,   454,   457,   470,   500,   627,
     749,   754,   755,   924,  1019,  1021,  1022,  1023,  1026,   850,
     882,   883,  1020,  1021,   910,  1084,  2096,   454,  2092,   457,
     784,   879,   994,  2035,  2087,  2088,   990,   487,  2099,  1493,
     107,   881,  1418,   240,  1472,  1448,    41,    55,   345,   487,
    1456,  1457,  1458,  1462,  1465,  2138,  2139,  2205,   829,  1453,
     483,  2173,   344,  2178,  2080,   829,   829,   829,  2106,   829,
    2214,  2214,   829,   829,   829,   829,  2214,  2073,   829,  2106,
     241,  1477,   812,  1476,  2045,  2081,  2098,  2101,   829,  2105,
     829,   829,  2011,  2080,  2007,  2011,   109,   825,   830,   816,
     826,   296,  2081,  2098,  2101,   394,  2117,  1486,   812,  2214,
     242,  1513,  1986,  1517,  1524,  2020,   647,   854,  1522,  2205,
    2220,  2178,   243,  1529,   279,   818,  2014,  2211,   688,  2123,
    2090,  2091,  1534,  1541,  2020,   245,  1542,   638,  2187,   161,
    2147,  2080,   794,  2198,   794,  2021,  1563,   360,  1584,    78,
    2141,   246,  1598,   290,   540,  1944,  1946,  1948,  1553,  2043,
    2044,  1554,   909,  1556,  1453,  1575,  1584,   867,   868,   869,
     870,   247,  1602,    83,   403,   812,   454,   248,  1625,    25,
     903,  1615,  1616,  1617,  1619,    28,   296,   407,   529,   563,
     814,   816,   825,   826,   829,   830,  1995,  1996,  1998,  2045,
    2162,   182,  1629,  2042,   269,  2027,   801,  1644,  1651,  2205,
    2022,  2080,     8,    15,    45,    66,    67,    68,    69,    70,
      71,    72,    73,    81,    86,    97,    98,    99,   100,   114,
     124,   127,   128,   129,   131,   165,   174,   175,   176,   177,
     178,   179,   180,   181,   187,   188,   213,   214,   217,   218,
     222,   244,   268,   272,   287,   292,   293,   309,   310,   311,
     312,   313,   316,   355,   356,   357,   358,   364,   365,   367,
     369,   370,   371,   374,   376,   380,   399,   400,   408,   409,
     410,   411,   412,   413,   422,   426,   427,   430,   469,   473,
     475,   476,   477,   478,   485,   501,   509,   544,   545,   577,
     580,   591,   597,   601,   603,   604,   617,   620,   621,   625,
     639,   641,   642,   650,   651,   670,   671,   672,   690,   691,
     692,   693,   695,   699,   700,   707,   708,   715,   716,   717,
     723,   728,   746,   759,   760,   765,   788,   789,   797,   805,
     811,   841,   847,   888,   894,   896,   899,   906,   918,   921,
    1358,  1360,  1362,  1364,  1366,  1368,  1370,  1372,  1375,  1377,
    1379,  1380,  1382,  1384,  1385,  1387,  1389,  1392,  1393,   428,
     741,   810,  1394,  1395,   163,   659,   791,  1668,  1669,  1671,
    1672,  1684,  2080,  1693,  2080,  1819,   829,  2090,   529,   771,
    1355,  1356,  1357,  1358,  2121,  1394,   252,  1700,  2045,   812,
     253,  1707,    83,  1711,   297,   396,   414,   568,  1713,    84,
     337,   454,  1202,  1729,  1730,  1731,  2028,  2048,  2066,  2080,
    2086,  2097,  2101,  2205,   802,   910,  1741,   256,  1756,   508,
     600,  2120,   257,  1767,   483,   712,  1761,   344,  1899,   258,
    1775,  2187,   910,   259,  1781,  1899,  2017,   260,  1790,   891,
    1786,   344,  1794,  1795,  2058,  2062,  2080,  2098,  2101,   290,
    1810,  1812,  2041,   608,   812,  2024,   225,   812,   863,  1802,
      42,  2090,   261,  1833,   317,   419,   425,  1829,  1506,  1836,
    2045,  2205,  2005,  2007,   829,  2091,   262,  1850,   403,  1845,
    1846,  2045,  2080,  2073,   263,  1854,   344,  2022,   710,   817,
     817,   344,   638,   644,  2188,   264,  1876,   201,  1869,  2080,
     265,  1903,  1899,  1906,  2080,  1931,  2080,  1191,   817,   710,
     452,  1281,  1211,  1213,   656,   817,   817,  1196,   154,    76,
     120,   186,   421,   444,   638,   643,   660,   662,   817,   887,
    1145,  1146,  1148,  1152,  1153,  1156,  1157,  1163,  1166,  1168,
    1169,  2162,     1,  1060,  1061,  2031,  2032,  2032,  2092,  2092,
    2018,  2020,  2018,  2092,  2018,  2018,  2032,  2018,  2018,   793,
    2197,   239,  1133,  2092,  2153,  2035,  1023,    25,   804,   109,
     489,   911,  2218,   910,  2089,   991,  2153,  2162,    85,   574,
     766,  1494,  1420,  1419,   675,  1428,  1456,   924,  2067,  2072,
    2092,  2162,  1458,   122,   126,   446,   595,   596,  1463,  1464,
    2210,   807,    44,    49,    50,    51,    52,    56,    75,   123,
     160,   162,   174,   197,   336,   346,   375,   433,   465,   468,
     512,   519,   555,   571,   619,   622,   664,   676,   678,   679,
     698,   703,   711,   753,   787,   808,   852,   864,   871,  1466,
    1469,  1470,  1471,  2148,  2186,   136,   454,  1454,  1455,  2053,
    2080,  2080,   168,    34,    35,   125,   132,   135,   189,   191,
     192,   273,   275,   282,   290,   396,   446,   450,   701,   785,
     796,   807,   878,   910,  1461,  2024,  2208,   269,   303,   304,
     613,  2056,  2081,   812,  2005,  2007,  2112,  2005,  2113,   814,
    2005,  2108,  2109,   910,   910,  2007,  2111,  2111,  2111,  2050,
    2080,  2098,  2101,  2110,   910,   812,  2050,  2107,    11,  2012,
    2013,  2045,  2086,  2098,   352,  2007,  2050,  2005,   814,   394,
    2118,  2008,  2008,  2009,  2009,  2009,   456,  1481,   611,  1487,
    2030,  1497,  1498,  2065,  2080,  1522,   462,   512,  2153,  2081,
    2007,   487,  2124,  2091,  2007,  2020,   673,  1749,  1750,  1751,
    1546,  2205,  1556,   908,  2044,  1439,  1440,  1439,  1947,  1948,
    1945,  1946,   866,  1462,  1465,  1558,  1559,  1560,  2205,    49,
      50,    51,    52,    56,    74,    75,   123,   162,   280,   336,
     375,   468,   571,   698,   703,   741,   753,   852,  1470,  1557,
    1597,   280,  1567,  1568,  2080,  2098,   866,  1585,   908,  1944,
    1944,  1944,  1944,  2045,  2013,  2045,  1607,  1492,  1614,  1620,
     903,  1617,  1618,   248,   817,   903,  1439,  1997,  1998,  1996,
      20,    21,    22,   113,   279,   361,   362,   438,   439,   505,
     539,   548,   557,   598,   818,   822,   824,  1999,  2000,  2001,
    2002,  2003,  2004,   454,  2025,  2026,   203,  1639,  2028,   235,
    1643,  1645,    16,    20,    23,    24,   497,   498,   548,   549,
    1652,  1656,   314,   388,   818,  2156,  1391,  2092,  2156,  1393,
    2156,  2156,  2156,  1395,  2060,  2081,  2085,  2098,    16,   109,
     317,   429,   840,  1675,  1676,  1677,  1670,  1671,   251,  1690,
     344,  1690,   403,  1821,  2179,  2205,   407,   818,  2163,  1356,
      31,   407,   818,  2165,     3,    12,    27,    46,    65,    77,
      78,    79,    82,    89,   101,   103,   104,   130,   185,   198,
     220,   221,   223,   224,   267,   283,   320,   321,   322,   342,
     347,   372,   373,   378,   379,   432,   434,   451,   464,   465,
     466,   491,   514,   515,   516,   518,   520,   521,   523,   525,
     526,   530,   532,   533,   534,   535,   548,   556,   569,   570,
     578,   584,   630,   635,   684,   685,   686,   694,   718,   731,
     732,   733,   734,   751,   752,   762,   792,   806,   807,   843,
     853,   860,   871,   875,   876,   877,   892,   893,   897,   898,
     900,   907,  1359,  1361,  1363,  1365,  1367,  1369,  1371,  1373,
    1374,  1376,  1378,  1381,  1383,  1386,  1388,   812,  2041,  2013,
    2045,   730,  1714,  2178,   366,  1987,  1987,   862,   891,   804,
       1,    58,    59,    60,    61,    63,   143,   144,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   454,   593,   616,
    1203,  1204,  1205,  1206,  1207,  1243,  2054,  2081,   809,   798,
    2187,   403,  2071,  2080,  2097,  2101,   403,  1745,  1749,   239,
    1787,  2080,  1787,  2080,  1796,  2205,   812,   812,   812,   812,
    1801,   269,   741,   820,   831,  2045,    83,    56,    75,   375,
     433,   468,   571,   678,   852,  1805,  1806,  2162,  1828,  2205,
    2045,   281,   528,   136,   719,   814,  2006,   815,  2007,  2080,
    1846,   201,  1847,   344,   344,  2013,  2045,  1434,  2058,    83,
    2142,   403,  1872,    14,    55,  1900,  1901,   266,  1928,   344,
    1928,  1933,  2205,  1192,  1172,   817,   710,   660,  1283,   887,
    1271,  1230,  1231,  2162,  2114,    29,    54,    57,    58,    59,
      60,    61,    63,    64,    74,   140,   142,   143,   145,   146,
     147,   148,   149,   150,   212,   323,   324,   325,   326,   327,
     331,   366,   390,   417,   441,   497,   553,   572,   588,   593,
     616,   646,   698,   735,   737,   738,   739,   783,   847,   857,
     858,   859,   873,   895,  1218,  1219,  1220,  1221,  1222,  1225,
    1226,  1228,  1231,  1232,  1235,  1236,  1240,  1241,  1242,  1243,
    1246,  1249,  1266,  1267,  1269,  1270,  1271,  1276,  1277,  1278,
    2162,  2192,  1201,  2162,   155,  2146,  2162,   638,   644,  2219,
    2219,  2162,  2146,  2162,  2174,  2162,    31,  2134,   554,  1170,
    2039,   299,   353,   817,     6,     9,    27,    40,   307,   308,
     391,   446,   524,   565,   573,   638,   652,   667,   730,   744,
     817,   821,   837,   838,  1062,  1063,  1072,  1074,  1079,  1080,
    1083,  1085,  1086,  1087,  1088,  1094,  1095,  1096,  1097,  1100,
    1106,  1107,  1109,  1111,  1113,  1114,  1115,  1116,  2145,  2187,
    2213,  2032,  2179,  2179,   835,   836,  2223,  2020,  2179,  2179,
    2146,  2178,  2178,   644,  2018,  1024,  1026,  2214,    23,   497,
    2035,   452,  1421,  1422,  1423,  2142,  1421,   557,   910,   817,
     282,   290,   538,   540,  1937,  1939,  1940,  1942,  1943,    76,
     546,  2176,  2176,   454,  2068,  2072,  2094,  2162,  2162,  2162,
    2162,    56,   230,  1471,   108,   225,   863,  2202,    14,  2133,
     419,   741,  1454,   136,   825,   830,  1937,   923,   922,  2058,
    1937,   419,  2167,   763,   763,   546,  1449,   494,  2178,  2178,
     454,  2057,  2081,  2080,  2006,   814,  2006,   814,   814,   587,
     814,  2050,  2006,   814,   814,   814,  2006,   814,  2073,  2006,
     814,  2178,   543,   742,  1959,  1961,  1963,  2090,  2091,  2013,
     815,   814,   814,   812,  2119,  1481,  2092,   675,  1482,   812,
    2028,  1491,   506,   615,  1499,    37,  1525,  2205,   680,   655,
    1959,  2162,   709,   337,  2153,   406,   541,  1980,  1981,  1983,
    1985,   419,  1579,  1570,  1441,   169,   170,   605,   910,  1561,
    2024,  1559,   513,  1597,  2163,   446,   701,  2162,   276,   278,
    1396,  1397,  2150,  2201,  2163,   225,  2202,  2162,  1597,  1568,
    2080,  1576,  1582,   352,  1959,   352,   454,  1609,   881,  1500,
       1,    29,   820,   831,  1622,  1623,  1993,   566,  1621,   924,
    1999,  2201,  1639,  2026,  2179,  1646,   250,  1647,  1439,  2201,
     659,  1653,  2201,  2080,  2080,  2080,  2080,  2080,   812,    83,
    1676,  1678,  2060,    16,   109,   429,   840,  1673,  1674,  2058,
    2076,  2080,  2080,  2080,  1080,  1822,  2145,    38,   204,  1261,
     226,  1390,  2080,  2092,  2044,  2041,  1959,   352,  2205,  1749,
    1203,  2155,  1730,  1725,  1726,   295,  1732,  1991,  1733,  1734,
    2080,  2028,   817,  1901,  1745,  2080,  2080,   239,   536,  1969,
    1972,  1974,  1779,  1780,  2205,  1439,   903,   903,  1788,  1789,
    1900,   231,   236,   284,  2080,  2058,   555,   924,  2069,  2070,
    2072,  2092,  2057,   554,  2045,  1801,  1801,  1801,  1801,  1801,
    1801,  1801,  1801,  1806,   529,   539,  1830,  1831,  1832,  2000,
    2121,  1980,   435,   741,  2221,   763,  2195,  2195,  2007,   814,
    2007,  1849,  2205,  2142,  2080,  2073,  1959,   352,  1438,  2092,
     812,    16,  1870,  1871,  2115,  1873,  2080,  1849,  1873,  1749,
      13,  2132,  2080,   675,  1934,   238,  1173,  1280,   817,   710,
     701,  1340,  2164,   887,   353,  2086,   435,   548,   736,   856,
    2191,   856,  2191,   856,  2191,   856,  2191,   856,  2191,   903,
    2203,  2178,   684,  2189,  2078,  2081,   227,  1252,  2092,   457,
    1237,  2081,    37,  2137,   407,   432,   684,  1268,  2201,  2162,
    1220,   299,   300,   383,   750,   848,   429,   840,   344,  1214,
    2137,   353,  2092,  1084,  2164,  2164,   910,  2036,  2037,   557,
     753,  2215,   454,  2032,  2038,  2092,   891,  2162,   306,   382,
     910,  1154,  2039,  2174,  2167,  2187,  2201,   725,  2167,  2162,
    2143,   202,  2167,  2167,   512,  1108,  2092,  2205,  2162,  2162,
     763,   462,   724,    57,  2140,  2164,  2018,  2018,  2179,  2018,
    2018,  1128,  1129,  2020,  2220,  2020,  1025,  1026,  2089,  2162,
    2162,  2035,  1422,   741,   856,  1424,  1425,   648,   887,  1415,
    1941,  1942,  1467,  1468,  2076,  2080,  1938,  1939,  1439,  2067,
    2067,  2067,  2067,  2068,  2067,  2162,  1989,  2070,  1989,  2068,
    2155,  2162,   814,   814,  1454,  2053,  2053,  1937,   741,  1459,
    1460,  1462,  2020,  2020,  2123,   786,  2105,   786,  2105,   814,
    2032,  2105,  2105,  2105,  2050,  2123,   429,   840,  2105,  2081,
    1439,  1439,  1962,  1963,  1960,  1961,  2091,  1959,   814,  2007,
    2105,  2105,  2063,  2080,  2097,  1482,  2042,  1987,   512,  2125,
    2007,  1439,  1439,  1984,  1985,  1982,  1983,  2064,  1585,   197,
     381,   810,   847,  1506,  1571,  1572,  1573,  1442,  2067,  2067,
     446,   701,   239,  2067,  1989,  1989,  2067,    77,    79,   366,
     450,   594,   729,   832,  1462,  1587,  1588,  1589,  1590,  1591,
    1593,  1594,  1595,  1596,  2205,  1587,  2013,  2014,  2013,  2014,
    1501,    25,   804,  1624,   248,   817,  1439,  1622,  2080,  1439,
     235,   887,  1654,  1655,  1656,   801,  1657,  2199,   887,  2061,
    2085,  2097,  2058,    83,    14,    55,  1679,  1680,  1681,  1674,
    1679,   335,   168,  1990,  1694,  2205,  1818,   724,  2167,   388,
     564,  2157,  2013,    16,   512,   633,  1110,  2018,  2080,  1439,
     254,   817,  1728,    14,   344,    13,   387,  1746,  1747,  1748,
    1750,  1753,  1780,  2205,   186,   517,  1762,  1764,  1766,  1439,
    1439,  1973,  1974,  1972,  1980,   462,   512,  1992,  1991,  1788,
     659,  1797,  2045,  2000,  2080,  2001,  2002,  2003,  2004,  2007,
    1837,  2045,  1837,   814,   542,   828,  1964,  1966,  1968,   593,
     741,  1848,  2045,  2123,  2123,  2013,   817,  2059,  2063,   563,
    2058,   202,  1874,   791,  1875,  1779,   575,  2024,  2067,  1990,
     497,   886,  1935,  2062,    95,  1174,  1175,  1192,  1282,   817,
     710,    28,   296,   563,   814,   816,   825,   826,   829,   830,
    1202,  1217,  1273,  1274,  2162,   804,  1209,   924,     7,    53,
      65,   110,   133,   190,   271,   333,   341,   421,   428,   453,
     481,   624,   628,   704,   764,   778,   802,   844,   890,   902,
     908,   910,  1351,   829,  1223,  1224,    90,  1254,   851,   812,
    1250,  1238,  2162,  2078,   910,  2079,     1,   910,  1242,    37,
    1229,  2142,  1233,   770,  1227,   722,  2126,  2126,   910,  1273,
     812,  1151,   335,  1167,  2037,   450,  2171,   812,  2144,  2155,
     301,   318,   697,   849,   884,   889,  1164,  1165,  2162,  2162,
    2162,  2162,  2167,   227,   299,  1069,  1070,  2162,   652,  1095,
    2162,  2162,  2162,  2162,    32,    33,  2136,  1110,  2038,  2092,
    2162,  2174,   554,  1081,   725,  1112,  2038,  2018,  1129,   596,
    1130,    25,  2035,  2035,  2162,   741,  1425,   561,  1427,   196,
    1429,  1439,  2064,   446,   450,  2216,  1468,  2069,   814,  2162,
    1460,  1959,   344,  2127,   814,  1492,   212,   709,   809,  1580,
    2163,  2163,  2163,  2163,  2045,  1573,  2178,   388,   407,  2166,
    2067,  2135,  1588,   102,   432,   684,  1592,   512,  1597,  1959,
     654,  1959,   654,  1502,  1503,  1504,  2142,  1623,  1992,  1646,
    1655,   186,  2149,  2201,  1679,  1679,  2061,   823,  2160,  2160,
    1681,  1680,  2155,  1685,   494,  1915,   207,   396,   881,  1823,
    1820,   564,  1959,   566,  2182,  2182,   559,    18,   211,   335,
     431,   665,   679,   909,  1715,  1716,  1720,  1721,  2205,  2206,
     254,  1727,  1734,  2045,  2179,   462,   419,  1754,  1752,  1753,
    2205,   386,   418,   901,  1439,  1439,  1765,  1766,  1763,  1764,
     462,  1439,  1439,   446,  2168,  1439,  1439,  1967,  1968,  1965,
    1966,  2162,  1959,  2127,  1959,   874,  1435,  1880,  1871,  2155,
    1990,  2155,  1964,   277,   537,  1902,  1975,  1977,  1979,  1981,
     446,   450,  2169,  1907,  2205,   612,  2039,  1192,  1192,  1284,
     817,   804,  1272,  1274,   508,   758,  1202,  1215,  1216,  1217,
    2086,   199,   319,   423,   480,   743,   839,  1244,   455,  1245,
     454,  2055,  2155,   344,  1251,   809,  2200,  2092,  2200,   741,
     910,  1239,   454,  2064,   169,   174,   288,   702,  1234,  2143,
    2092,   109,   644,  1147,  2031,  1158,  2092,  2193,   454,  1155,
    2086,  1155,   227,   631,   725,  1073,  2032,  2162,    91,    92,
      93,   209,   210,   212,   396,   397,   420,   446,   471,   568,
     601,   605,   606,   631,   793,  1064,  1065,  1066,  1067,  1068,
    2032,  2038,  1098,  2032,  2032,  2144,  2223,  2032,  2162,  2032,
    1082,  2153,  2162,  2038,   804,  2092,  1026,  2153,  2153,    44,
     197,  2092,  2162,   910,   817,  1416,  2069,   390,  2158,   205,
    2128,  1500,  1587,  2045,  2045,  2045,  2045,  2080,  2163,   810,
     703,   913,  2014,  2014,  1503,   557,  1424,   156,   648,   887,
    1439,    83,   197,  1679,  2045,  2045,  2080,  1915,  2178,   781,
    1687,   609,  2018,   352,   568,  1824,  2086,    16,   512,   634,
     865,   917,  1718,  1719,  1720,   512,    80,   462,   473,  1717,
      83,  1735,   462,  2162,  1755,  1970,  1972,  1974,  1980,   462,
     462,  2080,  2128,  1881,   817,  2080,  2080,  1439,  1439,  1978,
    1979,  1976,  1977,  1909,  1910,  1911,  2205,   821,  1936,  2015,
     609,  1176,  1285,  1341,  1202,   903,  1275,  2204,  2178,  1217,
     814,   910,  2092,   812,  1250,   203,   203,  1253,  2162,   763,
      77,   832,  1159,  1160,  1161,  1162,  2205,  2144,   344,  1150,
    2154,  2032,   344,    13,   881,   891,  2086,  2097,  2224,    62,
     449,   754,   910,  1099,   747,   818,  1101,  1102,  2032,  2033,
      47,   294,   472,  1089,  2162,    23,   497,  1084,   804,  2038,
     497,    23,    44,  1426,  2205,  1430,  1431,  2069,  2158,  1959,
    1505,  1506,  2080,  2163,  1959,  1959,  2046,  2047,  2077,  2081,
    2045,  1687,  1916,  1917,  2080,  1688,  1689,  2080,   290,   540,
    1954,  1956,  1958,  2162,  2018,   609,   567,  2183,   680,  2048,
    2052,  2055,  2080,  2101,   862,  2080,  1973,  1971,  1972,  1959,
      41,   229,   291,   353,  1882,  1883,  1884,  1886,  1890,  1892,
    1893,  1894,  1895,  2138,  2153,   495,  1913,  1911,    43,   238,
     920,  1912,   910,  2162,  1177,   632,  1286,  1197,  1212,  1342,
    1343,  1344,   726,   820,  2080,   394,  1255,  2179,  2179,   391,
    1256,  1258,  1259,  1260,  1261,  1263,  2092,  2038,  2038,   334,
    1151,  2092,  1101,  2086,  2152,  2086,  2162,   582,  1075,  1076,
    1103,  1104,   909,  1090,  1092,  2205,  1093,  2205,  1090,  1084,
    2162,  2162,  1084,  2038,  2162,  2162,   479,  1431,   812,  2069,
     290,   540,   828,  1508,  1510,  1512,    11,   403,   531,   557,
     827,  1507,  2161,  2045,  1686,  1917,  2162,  1689,  1439,  1439,
    1957,  1958,  1955,  1956,  1729,  2162,  2081,  2098,  2101,  1991,
      55,  2133,  1894,  1741,   613,   194,  2162,  1915,  2062,  1729,
     817,  1178,  2153,  2022,     1,  1199,  1344,   817,   812,  2162,
    1256,  2032,  2032,  2142,  1263,  1259,  2167,  1257,  2138,  2144,
    2116,  2205,  1077,  2116,  1105,  2032,  1105,   462,  2172,   687,
     473,  1084,  1084,  2035,  2035,   741,   239,  2069,  1439,  1439,
    1439,  1511,  1512,  1509,  1510,  2178,  2080,  1954,  2097,  1729,
     661,   753,  2194,   821,  2019,   239,   758,  1891,  2179,  2062,
     847,  1918,  1932,   568,  2160,  1287,   817,  1345,  1346,   817,
    1202,  1256,  1264,  1265,  2087,  2162,  1258,  2038,   203,  1149,
    1075,   226,   512,  2162,   558,  2153,  2153,  2162,   196,  2080,
    2080,   281,   290,  2212,  2020,   821,    16,  1887,  1888,  2081,
     496,  1914,  2178,   781,  1923,   290,   540,  1949,  1951,  1953,
     205,   281,   763,   782,   799,  1183,  1184,  1185,   396,   414,
       1,  1288,  1348,   551,  1350,  1351,  1265,  2034,  2035,  2179,
     780,  1078,   226,  2032,   492,   638,   644,  2217,   497,    23,
    2068,   817,   609,  2184,  2020,   554,   610,   649,  1889,  1888,
    2162,  1919,  1920,  2080,   289,   905,  1924,  1925,  2080,  1908,
    1439,  1439,  1952,  1953,  1950,  1951,   168,   790,  2162,   419,
     419,   205,   435,  1185,   239,   483,   763,   782,   799,  1179,
    1180,  1181,  1182,  2080,  2173,  2196,   239,   483,   763,   799,
    1186,  1187,  1188,  1189,  2080,  2196,   817,   160,   161,   575,
     817,  1289,  1290,  1295,  2162,  2205,  2232,    44,    49,    50,
      51,    52,    56,    74,    75,    94,   115,   123,   171,   280,
     336,   344,   346,   363,   375,   433,   446,   450,   468,   512,
     553,   571,   619,   664,   711,   741,   753,   787,   812,   823,
     852,   881,  1236,  1241,  1246,  1266,  1269,  1271,  1349,  1410,
    1411,  1469,  1470,  2162,  2210,  1352,  2080,  2092,  1347,  2035,
    2032,   903,  2217,  1091,  1092,  2162,  2162,  2179,   554,  2078,
    2062,  1920,  2162,    42,   156,   234,   527,   548,  1922,  1926,
     377,   470,   749,   924,  1927,  2100,  1925,  1949,  2162,   553,
    2080,  2162,  2162,  2162,  2162,   419,   189,   807,   419,   435,
    1181,  2080,   168,   626,   747,   772,   773,   774,   419,   189,
     807,   419,   435,  1188,  2080,   794,  2164,  2164,   442,   443,
    2170,  1306,   353,   119,   315,  1291,  1292,  1293,  1294,  2080,
    2162,   446,   701,  1408,  2176,  1406,  2176,  2162,  2163,  1396,
    1397,  2162,  2071,  1406,  2163,  2092,   108,  2163,  2080,  2080,
     353,  1408,  1354,  1355,    16,   749,   924,  1027,  1091,  1084,
    1084,   297,   396,   414,   568,  1885,  2018,  1922,  1921,  1922,
    1921,   563,  2080,  2092,  2080,  2080,  2080,  2080,  2162,  2162,
    2162,  2162,  2162,  2080,  2162,  2162,  2162,  2162,  2162,  2162,
    2162,  2162,  2162,  2162,  2162,  2080,  2162,  2164,  2164,   924,
    1296,  1297,  1298,  2080,  2092,  2095,  1197,  1307,  2162,  1293,
    1294,  2067,  2162,  2162,  2067,  2076,  2092,  2067,  1403,  2067,
    2200,  2162,  2076,  2092,  1348,  2099,  2100,  2200,  2080,  2080,
    2080,  2080,  2080,  2080,  2080,  2080,  2080,  2080,  2080,  2080,
    2080,  2080,  2080,  2080,  2080,  2080,  2080,  1299,   446,   450,
    2169,  2208,  2216,     1,  1199,  1200,  2064,   484,   592,   825,
     830,  1399,  1400,  1401,  1402,  1409,  1399,  1401,  1407,    96,
     590,  1404,  1405,  2064,  1262,  1263,  2080,  2080,   317,   334,
     368,   425,   448,  1300,  1301,  1302,  1303,  1304,  1305,  1297,
    1298,   817,  1308,  2067,  2067,  2080,  2080,   193,   207,  2225,
    2162,  2162,   106,   160,  2225,  2226,  2162,  1309,  2080,  2162,
    1298,  1298,   368,  2162,  2162,  1298,     4,   122,   126,   364,
     446,   450,   510,   553,   599,   747,   779,   817,   847,   891,
    1236,  1240,  1241,  1246,  1247,  1266,  1269,  1271,  1310,  1311,
    1316,  1319,  1322,  1323,  1326,  1327,  1328,  1331,  1332,  1338,
    1339,  2207,  2208,  2209,  2080,  1298,  1298,  1298,   392,  2159,
     547,  2176,  2177,  2134,  2162,  2092,  2162,  2178,  2162,  2080,
      14,    55,   417,   903,   511,  1329,  1330,  1398,  1399,  1335,
    1336,  1337,  1399,  2092,  2177,  2080,  2164,   508,   511,   575,
    1317,  1318,  1399,  2092,  1250,  2051,  2049,  2051,   105,   160,
     575,   585,   586,   660,   682,   683,  1312,  2225,  2226,  2227,
    2228,  2229,  2230,  2231,   344,   507,  2175,  2175,    14,    55,
    1991,  1329,  2095,  1336,  2095,   101,   432,   684,  1333,  1334,
    2080,  2092,  2200,  2123,   668,   866,  1320,  2051,   334,   334,
     368,   334,   368,   335,   558,  2180,  2180,  2051,   563,   575,
    1324,  1325,  2080,  1324,  2175,  2175,  2164,  2080,  1253,  2179,
    2080,   315,  1313,  2080,    16,   315,  1315,  2080,    83,  1324,
     575,   575,   767,  1248,   315,  1321,  2080,   563,  1314,  1314,
    1314,  1314,  2051,  2092,   575
};

  /* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint16 yyr1[] =
{
       0,   926,   928,   927,   929,   929,   931,   930,   932,   932,
     933,   933,   935,   934,   936,   937,   938,   938,   939,   939,
     941,   940,   943,   942,   945,   946,   944,   947,   947,   948,
     949,   949,   951,   952,   950,   954,   953,   955,   955,   956,
     956,   957,   957,   958,   958,   959,   959,   959,   959,   960,
     960,   961,   961,   962,   962,   963,   964,   964,   965,   965,
     965,   965,   966,   966,   967,   967,   968,   968,   968,   969,
     969,   970,   970,   970,   970,   971,   972,   972,   973,   974,
     974,   975,   975,   976,   976,   977,   977,   977,   977,   977,
     979,   978,   980,   980,   981,   981,   983,   982,   984,   984,
     984,   984,   985,   985,   986,   986,   986,   986,   987,   988,
     990,   989,   991,   991,   991,   991,   991,   991,   992,   993,
     994,   994,   994,   994,   995,   995,   997,   996,   998,   998,
     998,   999,   999,  1000,  1000,  1000,  1000,  1000,  1001,  1001,
    1002,  1003,  1004,  1004,  1004,  1005,  1005,  1005,  1005,  1005,
    1005,  1005,  1005,  1005,  1005,  1005,  1005,  1005,  1005,  1007,
    1006,  1008,  1008,  1008,  1008,  1009,  1009,  1010,  1011,  1011,
    1013,  1012,  1015,  1014,  1016,  1014,  1017,  1017,  1018,  1019,
    1019,  1019,  1019,  1019,  1020,  1020,  1020,  1020,  1021,  1021,
    1021,  1022,  1022,  1023,  1023,  1024,  1023,  1025,  1025,  1026,
    1026,  1026,  1026,  1026,  1026,  1027,  1027,  1028,  1029,  1029,
    1030,  1031,  1031,  1032,  1033,  1033,  1034,  1034,  1035,  1036,
    1036,  1037,  1038,  1039,  1039,  1040,  1040,  1041,  1041,  1041,
    1042,  1042,  1043,  1044,  1045,  1045,  1046,  1047,  1048,  1049,
    1050,  1051,  1053,  1052,  1054,  1055,  1055,  1056,  1056,  1057,
    1057,  1059,  1058,  1060,  1060,  1061,  1061,  1062,  1062,  1062,
    1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,
    1062,  1062,  1062,  1062,  1062,  1062,  1063,  1063,  1063,  1063,
    1063,  1064,  1064,  1064,  1065,  1065,  1065,  1065,  1065,  1065,
    1065,  1066,  1066,  1066,  1066,  1067,  1067,  1067,  1067,  1067,
    1067,  1067,  1068,  1069,  1069,  1070,  1070,  1071,  1071,  1072,
    1073,  1073,  1073,  1074,  1075,  1075,  1077,  1076,  1078,  1078,
    1078,  1079,  1081,  1080,  1082,  1082,  1082,  1082,  1082,  1082,
    1083,  1084,  1085,  1086,  1086,  1086,  1088,  1087,  1089,  1089,
    1089,  1090,  1090,  1090,  1090,  1091,  1091,  1092,  1093,  1093,
    1094,  1094,  1095,  1095,  1095,  1095,  1096,  1098,  1097,  1099,
    1099,  1099,  1099,  1100,  1101,  1101,  1102,  1102,  1104,  1103,
    1103,  1105,  1106,  1107,  1108,  1108,  1109,  1110,  1110,  1110,
    1111,  1112,  1112,  1113,  1114,  1115,  1116,  1117,  1117,  1118,
    1119,  1119,  1119,  1120,  1120,  1121,  1121,  1121,  1121,  1122,
    1123,  1123,  1123,  1123,  1124,  1124,  1124,  1124,  1124,  1125,
    1125,  1125,  1125,  1125,  1125,  1125,  1125,  1127,  1126,  1128,
    1128,  1129,  1130,  1130,  1131,  1132,  1133,  1133,  1135,  1134,
    1136,  1136,  1137,  1138,  1138,  1139,  1139,  1140,  1142,  1141,
    1141,  1143,  1143,  1144,  1144,  1145,  1145,  1145,  1145,  1145,
    1145,  1145,  1145,  1145,  1145,  1145,  1146,  1147,  1147,  1147,
    1148,  1148,  1148,  1149,  1149,  1150,  1150,  1151,  1151,  1152,
    1153,  1153,  1154,  1154,  1155,  1155,  1156,  1157,  1158,  1158,
    1159,  1159,  1159,  1160,  1161,  1162,  1163,  1164,  1164,  1164,
    1164,  1164,  1165,  1165,  1166,  1167,  1167,  1168,  1169,  1169,
    1170,  1170,  1171,  1172,  1171,  1173,  1173,  1174,  1176,  1175,
    1177,  1177,  1178,  1178,  1178,  1179,  1179,  1179,  1180,  1180,
    1181,  1181,  1181,  1181,  1181,  1181,  1181,  1181,  1181,  1181,
    1181,  1182,  1183,  1183,  1184,  1184,  1185,  1185,  1185,  1185,
    1185,  1185,  1185,  1186,  1186,  1186,  1187,  1187,  1188,  1188,
    1188,  1188,  1188,  1188,  1189,  1190,  1191,  1190,  1192,  1193,
    1192,  1194,  1194,  1195,  1195,  1195,  1196,  1195,  1195,  1197,
    1198,  1198,  1199,  1199,  1200,  1201,  1201,  1202,  1202,  1202,
    1203,  1203,  1203,  1203,  1203,  1203,  1203,  1203,  1203,  1203,
    1203,  1203,  1203,  1203,  1203,  1204,  1204,  1205,  1205,  1206,
    1206,  1206,  1207,  1207,  1208,  1209,  1209,  1211,  1210,  1212,
    1213,  1212,  1214,  1214,  1215,  1215,  1215,  1216,  1216,  1217,
    1217,  1217,  1217,  1217,  1217,  1217,  1217,  1217,  1217,  1218,
    1218,  1219,  1219,  1220,  1220,  1220,  1220,  1220,  1220,  1220,
    1220,  1220,  1220,  1220,  1220,  1220,  1220,  1220,  1220,  1220,
    1220,  1220,  1220,  1220,  1221,  1222,  1223,  1223,  1224,  1225,
    1226,  1227,  1227,  1228,  1229,  1229,  1230,  1230,  1231,  1233,
    1232,  1234,  1234,  1234,  1234,  1235,  1236,  1237,  1237,  1238,
    1238,  1239,  1240,  1241,  1241,  1241,  1241,  1242,  1242,  1242,
    1242,  1242,  1242,  1242,  1242,  1242,  1242,  1242,  1242,  1242,
    1242,  1242,  1242,  1242,  1242,  1242,  1242,  1242,  1242,  1242,
    1242,  1242,  1242,  1242,  1242,  1242,  1242,  1242,  1242,  1242,
    1242,  1242,  1242,  1242,  1242,  1242,  1242,  1242,  1242,  1242,
    1242,  1242,  1242,  1242,  1242,  1242,  1242,  1243,  1243,  1244,
    1244,  1244,  1244,  1244,  1244,  1244,  1245,  1245,  1246,  1246,
    1247,  1248,  1248,  1249,  1249,  1249,  1250,  1250,  1251,  1251,
    1252,  1252,  1253,  1253,  1254,  1254,  1255,  1255,  1256,  1256,
    1257,  1256,  1256,  1256,  1258,  1259,  1259,  1260,  1261,  1261,
    1262,  1262,  1263,  1264,  1264,  1265,  1266,  1267,  1268,  1268,
    1268,  1269,  1270,  1272,  1271,  1273,  1273,  1274,  1274,  1275,
    1275,  1276,  1276,  1277,  1278,  1279,  1280,  1279,  1281,  1282,
    1281,  1283,  1284,  1283,  1285,  1285,  1287,  1286,  1288,  1288,
    1288,  1289,  1289,  1289,  1289,  1290,  1291,  1291,  1291,  1292,
    1293,  1293,  1294,  1295,  1296,  1296,  1296,  1297,  1298,  1298,
    1299,  1299,  1300,  1300,  1300,  1300,  1300,  1300,  1301,  1302,
    1303,  1304,  1305,  1306,  1306,  1308,  1307,  1307,  1309,  1309,
    1310,  1310,  1310,  1310,  1310,  1310,  1310,  1310,  1310,  1310,
    1310,  1310,  1310,  1310,  1310,  1310,  1310,  1311,  1312,  1312,
    1312,  1312,  1312,  1312,  1312,  1313,  1313,  1313,  1314,  1314,
    1315,  1315,  1315,  1315,  1316,  1317,  1317,  1317,  1318,  1318,
    1318,  1319,  1320,  1320,  1320,  1321,  1321,  1322,  1322,  1322,
    1322,  1322,  1323,  1323,  1324,  1324,  1325,  1325,  1325,  1326,
    1327,  1328,  1328,  1329,  1329,  1330,  1330,  1331,  1332,  1333,
    1333,  1334,  1334,  1334,  1335,  1335,  1336,  1336,  1337,  1338,
    1339,  1340,  1341,  1340,  1342,  1342,  1343,  1343,  1344,  1345,
    1344,  1346,  1347,  1344,  1344,  1348,  1348,  1349,  1349,  1349,
    1349,  1349,  1349,  1349,  1349,  1349,  1349,  1349,  1349,  1349,
    1349,  1349,  1349,  1349,  1349,  1349,  1349,  1349,  1349,  1349,
    1349,  1349,  1349,  1349,  1349,  1349,  1349,  1349,  1349,  1349,
    1349,  1349,  1349,  1349,  1349,  1349,  1349,  1349,  1349,  1349,
    1349,  1349,  1349,  1349,  1349,  1349,  1350,  1350,  1351,  1351,
    1351,  1351,  1351,  1351,  1351,  1351,  1351,  1351,  1351,  1351,
    1351,  1351,  1351,  1351,  1352,  1352,  1353,  1353,  1354,  1354,
    1355,  1355,  1356,  1356,  1357,  1357,  1358,  1358,  1359,  1359,
    1359,  1359,  1359,  1359,  1359,  1359,  1359,  1359,  1359,  1359,
    1359,  1359,  1360,  1360,  1360,  1360,  1360,  1360,  1360,  1360,
    1360,  1360,  1360,  1360,  1360,  1360,  1360,  1361,  1361,  1361,
    1361,  1361,  1361,  1361,  1361,  1361,  1361,  1362,  1362,  1363,
    1363,  1363,  1363,  1363,  1364,  1365,  1365,  1365,  1365,  1365,
    1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,
    1366,  1366,  1366,  1366,  1366,  1366,  1366,  1366,  1366,  1366,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1368,  1368,  1369,  1369,  1370,  1370,  1371,  1371,  1371,  1371,
    1371,  1372,  1372,  1372,  1372,  1372,  1372,  1372,  1372,  1372,
    1372,  1372,  1372,  1372,  1372,  1372,  1372,  1373,  1373,  1373,
    1374,  1374,  1374,  1374,  1374,  1374,  1374,  1374,  1375,  1375,
    1375,  1375,  1375,  1375,  1376,  1376,  1376,  1376,  1376,  1376,
    1376,  1376,  1377,  1377,  1377,  1377,  1378,  1378,  1378,  1379,
    1379,  1379,  1379,  1379,  1379,  1380,  1380,  1380,  1380,  1381,
    1381,  1381,  1381,  1381,  1381,  1381,  1382,  1382,  1382,  1382,
    1382,  1382,  1382,  1382,  1382,  1382,  1382,  1382,  1382,  1382,
    1382,  1382,  1382,  1382,  1382,  1382,  1382,  1382,  1382,  1382,
    1382,  1382,  1382,  1382,  1382,  1382,  1382,  1382,  1382,  1382,
    1382,  1382,  1382,  1382,  1382,  1382,  1382,  1382,  1382,  1382,
    1382,  1382,  1382,  1383,  1383,  1383,  1384,  1384,  1384,  1384,
    1384,  1384,  1384,  1384,  1384,  1385,  1385,  1385,  1385,  1385,
    1385,  1385,  1385,  1385,  1385,  1385,  1385,  1385,  1385,  1385,
    1385,  1385,  1385,  1385,  1385,  1385,  1385,  1385,  1386,  1387,
    1388,  1388,  1388,  1388,  1388,  1388,  1388,  1388,  1389,  1389,
    1389,  1390,  1390,  1391,  1392,  1392,  1393,  1393,  1394,  1394,
    1395,  1395,  1395,  1396,  1396,  1397,  1397,  1398,  1398,  1399,
    1400,  1400,  1401,  1402,  1402,  1403,  1404,  1404,  1405,  1405,
    1406,  1407,  1407,  1407,  1408,  1409,  1409,  1409,  1410,  1411,
    1412,  1412,  1414,  1415,  1416,  1413,  1417,  1413,  1418,  1419,
    1418,  1420,  1418,  1421,  1421,  1422,  1423,  1423,  1423,  1424,
    1424,  1424,  1424,  1424,  1424,  1425,  1426,  1426,  1427,  1427,
    1428,  1428,  1428,  1429,  1430,  1429,  1431,  1431,  1432,  1432,
    1432,  1432,  1432,  1434,  1433,  1435,  1435,  1436,  1437,  1438,
    1438,  1440,  1441,  1439,  1443,  1442,  1442,  1444,  1444,  1444,
    1444,  1444,  1444,  1444,  1444,  1444,  1444,  1444,  1444,  1444,
    1444,  1444,  1444,  1444,  1444,  1444,  1444,  1444,  1444,  1444,
    1444,  1444,  1444,  1444,  1444,  1444,  1444,  1444,  1444,  1444,
    1444,  1444,  1444,  1444,  1444,  1444,  1444,  1444,  1444,  1444,
    1444,  1444,  1444,  1444,  1444,  1444,  1444,  1444,  1444,  1444,
    1444,  1444,  1444,  1444,  1444,  1444,  1444,  1444,  1444,  1444,
    1444,  1444,  1446,  1445,  1448,  1447,  1449,  1447,  1447,  1447,
    1447,  1447,  1447,  1447,  1447,  1447,  1447,  1447,  1447,  1447,
    1447,  1447,  1447,  1447,  1447,  1447,  1447,  1447,  1447,  1447,
    1447,  1450,  1450,  1452,  1451,  1453,  1453,  1453,  1454,  1454,
    1454,  1455,  1455,  1456,  1456,  1457,  1457,  1458,  1458,  1458,
    1458,  1458,  1459,  1459,  1460,  1460,  1461,  1461,  1462,  1462,
    1462,  1463,  1464,  1465,  1466,  1466,  1466,  1466,  1466,  1466,
    1466,  1466,  1466,  1466,  1466,  1466,  1466,  1466,  1466,  1466,
    1466,  1466,  1466,  1466,  1466,  1466,  1466,  1466,  1466,  1466,
    1466,  1466,  1466,  1466,  1466,  1466,  1466,  1466,  1466,  1466,
    1467,  1467,  1468,  1469,  1469,  1469,  1470,  1470,  1470,  1471,
    1471,  1472,  1472,  1474,  1473,  1475,  1475,  1475,  1475,  1476,
    1476,  1477,  1477,  1479,  1478,  1480,  1480,  1481,  1481,  1482,
    1482,  1484,  1483,  1485,  1485,  1486,  1487,  1487,  1489,  1488,
    1491,  1490,  1492,  1493,  1492,  1494,  1494,  1494,  1495,  1495,
    1496,  1496,  1496,  1496,  1496,  1496,  1497,  1497,  1498,  1498,
    1499,  1499,  1500,  1501,  1500,  1502,  1502,  1503,  1503,  1504,
    1504,  1504,  1504,  1505,  1505,  1505,  1505,  1505,  1506,  1506,
    1507,  1507,  1508,  1508,  1508,  1509,  1509,  1510,  1510,  1511,
    1511,  1512,  1513,  1513,  1515,  1514,  1516,  1516,  1517,  1517,
    1519,  1518,  1520,  1520,  1521,  1521,  1522,  1522,  1522,  1522,
    1522,  1524,  1523,  1525,  1525,  1527,  1526,  1528,  1529,  1529,
    1530,  1532,  1531,  1533,  1534,  1533,  1536,  1535,  1537,  1537,
    1539,  1538,  1540,  1540,  1541,  1541,  1542,  1542,  1544,  1543,
    1545,  1546,  1546,  1547,  1547,  1547,  1547,  1547,  1549,  1548,
    1550,  1550,  1550,  1550,  1550,  1550,  1550,  1550,  1550,  1550,
    1550,  1551,  1551,  1552,  1552,  1554,  1553,  1555,  1555,  1556,
    1556,  1557,  1557,  1558,  1558,  1559,  1559,  1559,  1559,  1559,
    1560,  1560,  1560,  1560,  1561,  1561,  1563,  1562,  1564,  1566,
    1565,  1567,  1567,  1568,  1568,  1568,  1570,  1569,  1571,  1571,
    1572,  1572,  1573,  1573,  1573,  1573,  1573,  1575,  1576,  1574,
    1577,  1577,  1579,  1580,  1578,  1582,  1581,  1583,  1583,  1583,
    1584,  1584,  1585,  1585,  1586,  1586,  1586,  1587,  1587,  1588,
    1588,  1588,  1588,  1588,  1588,  1588,  1588,  1589,  1590,  1591,
    1591,  1591,  1592,  1592,  1592,  1592,  1593,  1593,  1594,  1594,
    1595,  1596,  1597,  1597,  1597,  1597,  1597,  1597,  1597,  1597,
    1597,  1597,  1597,  1597,  1597,  1597,  1597,  1597,  1597,  1597,
    1597,  1597,  1597,  1597,  1597,  1598,  1598,  1600,  1599,  1601,
    1601,  1601,  1601,  1601,  1602,  1602,  1604,  1603,  1606,  1605,
    1607,  1605,  1608,  1609,  1611,  1610,  1612,  1613,  1613,  1614,
    1614,  1614,  1615,  1615,  1616,  1616,  1617,  1617,  1617,  1618,
    1618,  1618,  1620,  1619,  1621,  1619,  1622,  1622,  1623,  1623,
    1623,  1623,  1623,  1624,  1624,  1625,  1625,  1627,  1626,  1628,
    1628,  1628,  1628,  1628,  1628,  1628,  1629,  1629,  1631,  1630,
    1632,  1634,  1633,  1635,  1637,  1636,  1638,  1638,  1639,  1639,
    1640,  1642,  1641,  1643,  1643,  1643,  1644,  1644,  1645,  1646,
    1647,  1647,  1649,  1648,  1650,  1651,  1651,  1652,  1652,  1652,
    1653,  1653,  1654,  1654,  1655,  1656,  1656,  1656,  1656,  1656,
    1656,  1656,  1657,  1657,  1659,  1658,  1660,  1660,  1662,  1661,
    1663,  1663,  1665,  1664,  1666,  1667,  1667,  1667,  1668,  1668,
    1668,  1668,  1670,  1669,  1671,  1672,  1673,  1673,  1674,  1674,
    1674,  1674,  1674,  1674,  1675,  1675,  1676,  1676,  1677,  1677,
    1677,  1677,  1677,  1678,  1679,  1679,  1679,  1679,  1679,  1680,
    1681,  1683,  1682,  1685,  1686,  1684,  1687,  1687,  1688,  1688,
    1689,  1690,  1690,  1692,  1691,  1693,  1694,  1694,  1696,  1695,
    1698,  1697,  1699,  1699,  1700,  1700,  1702,  1701,  1703,  1703,
    1705,  1704,  1706,  1706,  1707,  1707,  1709,  1708,  1710,  1710,
    1711,  1712,  1712,  1713,  1713,  1713,  1713,  1714,  1714,  1715,
    1715,  1715,  1715,  1715,  1716,  1716,  1717,  1717,  1717,  1718,
    1718,  1718,  1719,  1719,  1719,  1720,  1720,  1721,  1721,  1721,
    1723,  1722,  1724,  1725,  1724,  1726,  1724,  1727,  1727,  1728,
    1728,  1729,  1729,  1730,  1730,  1730,  1730,  1730,  1731,  1731,
    1732,  1732,  1733,  1733,  1734,  1735,  1735,  1737,  1736,  1739,
    1738,  1740,  1740,  1741,  1743,  1742,  1744,  1745,  1745,  1746,
    1746,  1746,  1746,  1747,  1747,  1748,  1748,  1749,  1749,  1750,
    1751,  1751,  1751,  1752,  1752,  1753,  1753,  1753,  1754,  1754,
    1755,  1755,  1756,  1756,  1757,  1759,  1758,  1760,  1761,  1761,
    1762,  1762,  1762,  1763,  1763,  1764,  1765,  1765,  1766,  1767,
    1767,  1769,  1768,  1770,  1771,  1773,  1772,  1774,  1775,  1775,
    1777,  1776,  1778,  1779,  1779,  1780,  1780,  1781,  1781,  1782,
    1784,  1783,  1785,  1785,  1786,  1786,  1787,  1787,  1788,  1788,
    1789,  1790,  1790,  1792,  1791,  1793,  1793,  1794,  1794,  1795,
    1796,  1796,  1796,  1796,  1797,  1797,  1799,  1798,  1800,  1800,
    1800,  1800,  1800,  1800,  1800,  1800,  1801,  1801,  1802,  1802,
    1803,  1804,  1805,  1805,  1806,  1806,  1806,  1806,  1806,  1806,
    1806,  1806,  1807,  1807,  1807,  1808,  1809,  1809,  1810,  1811,
    1811,  1812,  1812,  1813,  1814,  1816,  1815,  1818,  1817,  1819,
    1819,  1820,  1820,  1821,  1821,  1822,  1822,  1823,  1823,  1823,
    1824,  1824,  1824,  1826,  1825,  1827,  1828,  1828,  1829,  1829,
    1829,  1829,  1830,  1830,  1830,  1830,  1830,  1830,  1831,  1832,
    1832,  1833,  1833,  1835,  1834,  1834,  1834,  1836,  1836,  1836,
    1836,  1836,  1837,  1837,  1838,  1838,  1839,  1839,  1839,  1839,
    1841,  1840,  1842,  1844,  1843,  1845,  1845,  1846,  1847,  1847,
    1848,  1848,  1849,  1849,  1850,  1850,  1852,  1851,  1853,  1853,
    1853,  1853,  1854,  1854,  1855,  1856,  1856,  1858,  1857,  1859,
    1859,  1861,  1860,  1862,  1864,  1863,  1865,  1867,  1866,  1868,
    1869,  1869,  1870,  1870,  1871,  1872,  1872,  1873,  1874,  1874,
    1875,  1875,  1876,  1876,  1878,  1877,  1879,  1879,  1881,  1880,
    1882,  1882,  1882,  1882,  1882,  1883,  1884,  1884,  1885,  1885,
    1885,  1885,  1885,  1886,  1887,  1887,  1888,  1888,  1888,  1889,
    1889,  1889,  1889,  1890,  1891,  1891,  1892,  1893,  1893,  1894,
    1894,  1895,  1895,  1897,  1896,  1898,  1899,  1899,  1900,  1900,
    1900,  1900,  1901,  1901,  1902,  1902,  1902,  1903,  1903,  1905,
    1904,  1907,  1908,  1906,  1909,  1909,  1910,  1910,  1911,  1912,
    1912,  1912,  1913,  1913,  1914,  1914,  1915,  1915,  1916,  1916,
    1917,  1918,  1918,  1919,  1919,  1920,  1921,  1921,  1922,  1922,
    1922,  1923,  1923,  1924,  1924,  1925,  1925,  1925,  1926,  1926,
    1926,  1927,  1927,  1928,  1928,  1930,  1929,  1932,  1931,  1933,
    1933,  1934,  1934,  1935,  1935,  1936,  1936,  1937,  1937,  1937,
    1938,  1938,  1939,  1940,  1940,  1941,  1941,  1942,  1943,  1943,
    1944,  1944,  1944,  1945,  1945,  1946,  1947,  1947,  1948,  1949,
    1949,  1949,  1950,  1950,  1951,  1952,  1952,  1953,  1954,  1954,
    1954,  1955,  1955,  1956,  1957,  1957,  1958,  1959,  1959,  1959,
    1960,  1960,  1961,  1962,  1962,  1963,  1964,  1964,  1964,  1965,
    1965,  1966,  1967,  1967,  1968,  1969,  1969,  1970,  1970,  1971,
    1971,  1972,  1973,  1973,  1974,  1975,  1975,  1976,  1976,  1977,
    1978,  1978,  1979,  1980,  1980,  1981,  1981,  1982,  1982,  1983,
    1984,  1984,  1985,  1986,  1986,  1987,  1987,  1988,  1988,  1989,
    1989,  1990,  1990,  1991,  1991,  1992,  1994,  1993,  1995,  1995,
    1996,  1996,  1996,  1996,  1996,  1996,  1996,  1996,  1996,  1996,
    1996,  1996,  1996,  1996,  1997,  1997,  1998,  1999,  1999,  1999,
    1999,  1999,  1999,  1999,  1999,  1999,  1999,  1999,  1999,  1999,
    1999,  2000,  2000,  2001,  2001,  2002,  2002,  2003,  2004,  2005,
    2005,  2006,  2006,  2006,  2007,  2007,  2007,  2008,  2008,  2008,
    2009,  2009,  2010,  2010,  2010,  2011,  2011,  2012,  2012,  2012,
    2012,  2012,  2012,  2013,  2013,  2014,  2015,  2016,  2016,  2017,
    2018,  2018,  2019,  2019,  2020,  2021,  2022,  2023,  2023,  2024,
    2025,  2025,  2026,  2027,  2027,  2028,  2029,  2029,  2029,  2030,
    2031,  2031,  2032,  2033,  2033,  2034,  2034,  2035,  2036,  2036,
    2037,  2038,  2038,  2039,  2039,  2040,  2041,  2041,  2042,  2042,
    2042,  2043,  2043,  2044,  2044,  2045,  2045,  2046,  2046,  2047,
    2047,  2047,  2047,  2047,  2047,  2047,  2047,  2047,  2047,  2047,
    2048,  2049,  2049,  2050,  2050,  2050,  2051,  2051,  2051,  2051,
    2051,  2051,  2051,  2052,  2052,  2052,  2052,  2052,  2052,  2053,
    2054,  2055,  2056,  2056,  2057,  2057,  2058,  2059,  2060,  2060,
    2061,  2061,  2062,  2062,  2062,  2063,  2063,  2064,  2064,  2065,
    2065,  2065,  2066,  2066,  2066,  2067,  2067,  2067,  2068,  2068,
    2069,  2069,  2070,  2070,  2071,  2071,  2071,  2072,  2073,  2074,
    2074,  2075,  2076,  2077,  2078,  2079,  2080,  2081,  2081,  2081,
    2081,  2082,  2082,  2083,  2083,  2084,  2084,  2084,  2084,  2085,
    2086,  2086,  2088,  2087,  2089,  2089,  2090,  2091,  2091,  2092,
    2093,  2094,  2095,  2095,  2096,  2096,  2096,  2096,  2096,  2096,
    2096,  2097,  2097,  2098,  2098,  2099,  2099,  2099,  2099,  2099,
    2099,  2099,  2100,  2100,  2100,  2100,  2101,  2101,  2101,  2101,
    2101,  2101,  2101,  2101,  2101,  2101,  2101,  2101,  2101,  2101,
    2102,  2102,  2103,  2103,  2103,  2103,  2104,  2104,  2104,  2104,
    2104,  2105,  2105,  2105,  2106,  2106,  2106,  2107,  2107,  2107,
    2109,  2108,  2110,  2110,  2111,  2111,  2112,  2112,  2113,  2113,
    2114,  2115,  2115,  2116,  2116,  2116,  2117,  2117,  2118,  2118,
    2119,  2119,  2120,  2120,  2120,  2121,  2121,  2122,  2122,  2122,
    2123,  2123,  2124,  2124,  2125,  2125,  2125,  2125,  2125,  2125,
    2125,  2125,  2126,  2126,  2127,  2127,  2128,  2128,  2129,  2129,
    2129,  2129,  2130,  2130,  2130,  2130,  2130,  2130,  2130,  2130,
    2130,  2130,  2130,  2130,  2130,  2130,  2130,  2130,  2130,  2130,
    2130,  2130,  2130,  2130,  2130,  2130,  2130,  2130,  2130,  2130,
    2130,  2130,  2130,  2130,  2130,  2130,  2130,  2130,  2130,  2130,
    2130,  2130,  2130,  2130,  2130,  2130,  2130,  2130,  2130,  2130,
    2130,  2130,  2130,  2131,  2131,  2131,  2131,  2131,  2131,  2131,
    2131,  2131,  2131,  2131,  2131,  2131,  2131,  2131,  2131,  2131,
    2131,  2131,  2131,  2131,  2131,  2131,  2132,  2132,  2133,  2133,
    2134,  2134,  2135,  2135,  2136,  2136,  2136,  2137,  2137,  2138,
    2138,  2139,  2139,  2140,  2140,  2141,  2141,  2142,  2142,  2143,
    2143,  2144,  2144,  2145,  2145,  2146,  2146,  2147,  2147,  2148,
    2148,  2149,  2149,  2150,  2150,  2151,  2151,  2152,  2152,  2153,
    2153,  2154,  2154,  2155,  2155,  2156,  2156,  2156,  2157,  2157,
    2157,  2158,  2158,  2159,  2159,  2160,  2160,  2161,  2161,  2162,
    2162,  2163,  2163,  2163,  2164,  2164,  2164,  2165,  2165,  2165,
    2165,  2166,  2166,  2166,  2167,  2167,  2168,  2168,  2169,  2169,
    2169,  2170,  2170,  2170,  2171,  2171,  2172,  2172,  2173,  2173,
    2174,  2174,  2175,  2175,  2176,  2176,  2177,  2177,  2178,  2178,
    2179,  2179,  2180,  2180,  2180,  2181,  2181,  2181,  2181,  2182,
    2182,  2183,  2183,  2184,  2184,  2185,  2185,  2186,  2186,  2187,
    2187,  2188,  2188,  2188,  2189,  2189,  2190,  2190,  2191,  2191,
    2192,  2192,  2192,  2193,  2193,  2194,  2194,  2195,  2195,  2196,
    2196,  2197,  2197,  2198,  2198,  2199,  2199,  2200,  2200,  2201,
    2201,  2202,  2202,  2203,  2203,  2204,  2204,  2205,  2205,  2206,
    2206,  2206,  2207,  2207,  2208,  2208,  2209,  2209,  2210,  2210,
    2210,  2210,  2211,  2211,  2212,  2212,  2213,  2213,  2214,  2214,
    2215,  2215,  2216,  2216,  2217,  2217,  2218,  2218,  2218,  2219,
    2219,  2220,  2220,  2221,  2221,  2222,  2222,  2223,  2223,  2224,
    2224,  2225,  2225,  2226,  2226,  2227,  2227,  2228,  2228,  2229,
    2229,  2230,  2230,  2231,  2231,  2232,  2232
};

  /* YYR2[YYN] -- Number of symbols on the right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     0,     2,     1,     1,     0,     2,     1,     2,
       1,     1,     0,     2,     4,     4,     0,     1,     1,     2,
       0,     4,     0,     4,     0,     0,     6,     0,     1,     3,
       1,     1,     0,     0,     8,     0,     6,     1,     1,     1,
       1,     0,     2,     0,     3,     1,     1,     1,     1,     2,
       2,     1,     1,     0,     3,     5,     0,     3,     1,     1,
       1,     1,     0,     5,     0,     3,     1,     1,     1,     0,
       4,     1,     1,     1,     1,     3,     0,     3,     2,     0,
       3,     0,     1,     1,     2,     1,     1,     1,     1,     1,
       0,     4,     0,     3,     0,     3,     0,     4,     0,     2,
       3,     2,     1,     2,     1,     1,     1,     1,     5,     2,
       0,     4,     2,     3,     4,     4,     8,     8,     3,     4,
       1,     1,     1,     1,     1,     2,     0,     4,     0,     2,
       3,     1,     2,     3,     3,     3,     3,     3,     1,     2,
       2,     2,     1,     2,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       3,     2,     3,     3,     1,     0,     1,     1,     3,     4,
       0,     4,     0,     4,     0,     4,     0,     2,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       1,     1,     2,     1,     3,     0,     4,     1,     3,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     0,     2,
       3,     1,     2,     3,     1,     2,     1,     2,     3,     1,
       2,     3,     6,     1,     2,     1,     3,     0,     2,     2,
       0,     2,     4,     5,     0,     3,     3,     5,     3,     4,
       3,     3,     0,     4,     4,     0,     3,     0,     2,     0,
       2,     0,     5,     2,     2,     0,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     5,     5,     6,     6,
       4,     0,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     3,     0,     1,     1,     1,     1,     1,     4,
       1,     1,     1,     9,     0,     1,     0,     4,     0,     4,
       3,     1,     0,     4,     2,     3,     4,     4,     8,     8,
       6,     1,     5,     0,     1,     1,     0,     5,     2,     2,
       2,     0,     5,     6,     1,     0,     1,     2,     0,     2,
       3,     1,     1,     3,     1,     2,     4,     0,     5,     1,
       1,     1,     1,     7,     0,     2,     1,     2,     0,     2,
       2,     1,     4,     3,     1,     1,     3,     2,     2,     2,
       3,     3,     4,     4,     4,     4,     4,     0,     2,     2,
       0,     2,     3,     1,     2,     1,     1,     1,     1,     5,
       0,     1,     1,     1,     4,     4,     4,     4,     1,     6,
       6,     7,     4,     6,     4,     6,     4,     0,     6,     1,
       2,     2,     0,     2,     6,     2,     2,     3,     0,    10,
       0,     1,     3,     0,     3,     0,     2,     2,     0,     5,
       3,     1,     1,     0,     2,     2,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     5,     0,     1,     1,
       4,     6,     9,     0,     3,     0,     2,     0,     2,     3,
       5,     5,     1,     1,     1,     1,     3,     5,     0,     2,
       1,     1,     1,     4,     2,     2,     4,     1,     1,     1,
       1,     1,     1,     1,     4,     0,     2,     2,     2,     2,
       1,     2,     0,     0,     5,     0,     2,     2,     0,     5,
       0,     2,     4,     3,     4,     0,     1,     1,     1,     2,
       4,     4,     4,     4,     4,     4,     4,     4,     4,     4,
       4,    11,     0,     1,     1,     2,     4,     4,     4,     6,
       4,     3,     4,     0,     1,     1,     1,     2,     4,     4,
       4,     4,     4,     4,     6,     0,     0,     5,     0,     0,
       2,     2,     3,     1,     1,     1,     0,     4,     3,     2,
       0,     1,     1,     1,     1,     0,     2,     1,     2,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     6,     0,     2,     0,     4,     5,
       0,     7,     2,     2,     1,     3,     1,     1,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       1,     1,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     3,     0,     1,     3,     3,
       3,     0,     1,     3,     0,     2,     0,     1,     2,     0,
       4,     1,     2,     1,     1,     1,     2,     0,     5,     0,
       2,     1,     3,     1,     3,     3,     3,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     3,     3,     4,     3,
       3,     3,     4,     3,     3,     1,     1,     1,     1,     1,
       1,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       1,     1,     1,     1,     1,     1,     0,     1,     3,     3,
       6,     0,     2,     6,     8,     7,     0,     2,     0,     2,
       0,     2,     0,     3,     0,     3,     0,     1,     0,     2,
       0,     3,     1,     1,     1,     1,     2,     4,     1,     1,
       0,     1,     3,     1,     2,     1,     2,     2,     0,     1,
       1,     3,     1,     0,     5,     1,     2,     3,     1,     0,
       4,     2,     2,     2,     4,     0,     0,     5,     0,     0,
       5,     0,     0,     5,     0,     2,     0,     6,     0,     2,
       2,     2,     4,     1,     1,     2,     2,     1,     1,     1,
       1,     2,     1,     4,     2,     1,     3,     2,     1,     1,
       0,     2,     1,     1,     1,     1,     1,     3,     3,     4,
       4,     4,     3,     0,     2,     0,     5,     3,     0,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     3,     1,     1,
       3,     3,     1,     1,     1,     0,     2,     2,     0,     2,
       0,     2,     2,     1,     3,     1,     2,     1,     1,     1,
       1,     4,     0,     3,     2,     1,     1,     3,     4,     5,
       4,     5,     1,     1,     0,     2,     1,     1,     1,     6,
       2,     3,     2,     0,     2,     1,     2,     2,     4,     0,
       1,     1,     1,     1,     2,     1,     1,     2,     1,     4,
       2,     0,     0,     5,     0,     1,     2,     3,     1,     0,
       4,     0,     0,     7,     3,     0,     2,     2,     2,     1,
       1,     2,     2,     1,     1,     1,     1,     1,     1,     1,
       3,     3,     3,     3,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     4,     1,     1,     2,     3,     2,
       2,     2,     3,     3,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     2,     2,     1,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     0,     1,
       1,     2,     1,     3,     3,     2,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     3,     3,     1,     2,
       3,     3,     3,     1,     2,     1,     2,     0,     1,     1,
       1,     1,     1,     1,     1,     2,     1,     1,     0,     1,
       4,     0,     1,     1,     4,     0,     1,     1,     3,     2,
       0,     1,     0,     0,     0,    12,     0,     4,     0,     0,
       3,     0,     3,     1,     2,     5,     0,     2,     2,     0,
       3,     3,     4,     2,     1,     3,     0,     5,     0,     1,
       0,     2,     2,     0,     0,     7,     0,     2,     1,     1,
       2,     1,     1,     0,     6,     0,     2,     2,     1,     0,
       1,     0,     0,     3,     0,     2,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     2,     0,     4,     0,     4,     0,     5,     3,     3,
       3,     3,     4,     3,     4,     3,     3,     4,     4,     4,
       3,     4,     3,     4,     5,     3,     4,     3,     3,     2,
       3,     1,     1,     0,     3,     5,     4,     4,     1,     3,
       3,     1,     1,     0,     1,     1,     2,     1,     1,     1,
       2,     3,     1,     2,     1,     3,     1,     2,     2,     2,
       2,     3,     3,     3,     1,     1,     1,     2,     1,     1,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     4,     1,     1,     1,     1,     4,     1,
       2,     1,     1,     3,     3,     3,     3,     3,     3,     4,
       0,     1,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     0,     1,     0,     4,     4,     5,     6,     8,     0,
       2,     0,     1,     0,     3,     4,     5,     0,     2,     0,
       2,     0,     3,     1,     2,     4,     0,     2,     0,     4,
       0,     9,     0,     0,     4,     1,     1,     1,     0,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     0,     2,
       1,     1,     0,     0,     3,     1,     2,     2,     3,     0,
       2,     2,     2,     0,     3,     2,     2,     4,     1,     1,
       1,     1,     0,     2,     2,     0,     1,     2,     2,     0,
       1,     2,     0,     1,     0,     3,     1,     2,     1,     1,
       0,     3,     1,     1,     2,     3,     0,     1,     3,     3,
       2,     0,     4,     0,     3,     0,     4,     4,     0,     1,
       1,     0,     3,     0,     0,     4,     0,     3,     2,     1,
       0,     4,     4,     2,     1,     2,     0,     1,     0,     3,
       3,     0,     3,     0,     2,     1,     2,     1,     0,     4,
       3,     3,     3,     3,     2,     1,     1,     1,     1,     1,
       1,     2,     1,     1,     2,     0,     3,     1,     1,     0,
       2,     1,     2,     1,     2,     1,     2,     1,     1,     2,
       2,     2,     2,     2,     1,     1,     0,     3,     2,     0,
       3,     1,     2,     1,     1,     1,     0,     5,     0,     1,
       1,     2,     3,     3,     3,     3,     2,     0,     0,     5,
       1,     1,     0,     0,     7,     0,     5,     1,     1,     1,
       0,     1,     0,     2,     1,     2,     1,     1,     2,     1,
       2,     1,     5,     1,     1,     1,     2,     1,     1,     0,
       1,     1,     1,     1,     0,     1,     3,     3,     1,     1,
       4,     3,     1,     2,     2,     1,     1,     2,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     3,     1,
       3,     3,     3,     3,     3,     0,     1,     0,     4,     4,
       6,     6,     8,     8,     0,     1,     0,     3,     0,     3,
       0,     6,     4,     1,     0,     4,     2,     1,     3,     1,
       1,     1,     2,     1,     1,     2,     2,     2,     2,     3,
       3,     3,     0,     3,     0,     4,     1,     3,     2,     1,
       1,     1,     1,     0,     2,     0,     1,     0,     3,     0,
       2,     1,     2,     1,     1,     1,     0,     2,     0,     3,
       1,     0,     3,     1,     0,     3,     3,     4,     0,     3,
       2,     0,     6,     5,     3,     2,     0,     1,     0,     0,
       0,     1,     0,     3,     5,     0,     2,     0,     3,     3,
       0,     2,     1,     2,     4,     1,     1,     1,     1,     1,
       1,     1,     0,     3,     0,     3,     1,     2,     0,     3,
       2,     2,     0,     3,     2,     1,     1,     1,     2,     1,
       1,     1,     0,     3,     2,     5,     1,     2,     2,     2,
       1,     1,     1,     2,     1,     2,     4,     2,     0,     1,
       1,     1,     1,     4,     0,     1,     1,     2,     2,     3,
       3,     0,     5,     0,     0,     9,     0,     2,     1,     2,
       1,     0,     1,     0,     5,     7,     0,     2,     0,     3,
       0,     4,     2,     2,     0,     1,     0,     3,     3,     4,
       0,     4,     4,     6,     0,     1,     0,     3,     1,     2,
       6,     0,     1,     1,     1,     1,     1,     0,     3,     0,
       1,     1,     2,     1,     2,     2,     1,     1,     1,     2,
       1,     1,     1,     1,     1,     3,     1,     1,     1,     1,
       0,     3,     4,     0,     6,     0,     5,     0,     1,     1,
       1,     1,     3,     0,     2,     1,     3,     3,     0,     3,
       1,     1,     1,     3,     6,     0,     2,     0,     3,     0,
       3,     2,     1,     1,     0,     4,     7,     0,     2,     0,
       1,     2,     1,     2,     3,     3,     1,     0,     1,     1,
       4,     4,     2,     0,     1,     1,     3,     2,     0,     3,
       1,     1,     0,     1,     1,     0,     4,     5,     1,     1,
       0,     2,     2,     0,     1,     2,     0,     1,     2,     0,
       1,     0,     3,     2,     1,     0,     4,     4,     0,     1,
       0,     4,     5,     0,     1,     2,     3,     0,     1,     1,
       0,     4,     4,     6,     0,     2,     0,     2,     1,     2,
       3,     0,     1,     0,     3,     2,     5,     0,     1,     2,
       2,     2,     2,     2,     0,     2,     0,     3,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       4,     3,     1,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     4,     3,     5,     4,     1,     2,     3,     1,
       2,     3,     3,     4,     4,     0,     3,     0,     7,     0,
       5,     0,     2,     0,     3,     0,     1,     0,     2,     4,
       0,     2,     4,     0,     4,     4,     0,     3,     0,     4,
       1,     1,     1,     2,     2,     2,     2,     1,     1,     2,
       1,     0,     1,     0,     4,     2,     2,     0,     2,     1,
       4,     4,     0,     1,     1,     1,     1,     1,     1,     1,
       0,     4,     5,     0,     2,     1,     2,     2,     0,     3,
       1,     1,     0,     4,     0,     1,     0,     4,     4,     6,
       6,     8,     0,     1,     2,     0,     1,     0,     3,     1,
       2,     0,     3,     5,     0,     3,     2,     0,     4,     6,
       0,     3,     1,     3,     2,     2,     2,     3,     0,     3,
       0,     3,     0,     1,     0,     3,     1,     2,     0,     3,
       1,     1,     1,     1,     1,     7,     0,     1,     1,     1,
       1,     1,     1,     4,     1,     2,     1,     2,     3,     0,
       1,     2,     1,     3,     1,     1,     4,     1,     2,     2,
       3,     1,     1,     0,     4,     6,     0,     2,     0,     4,
       3,     3,     1,     1,     0,     1,     1,     0,     1,     0,
       5,     0,     0,    12,     0,     1,     1,     2,     2,     2,
       1,     1,     0,     4,     0,     3,     0,     3,     1,     2,
       3,     0,     3,     1,     2,     3,     0,     1,     1,     1,
       1,     0,     2,     1,     2,     1,     2,     2,     2,     2,
       1,     1,     3,     0,     1,     0,     5,     0,    10,     0,
       3,     0,     2,     0,     3,     1,     2,     0,     2,     2,
       0,     1,     3,     1,     1,     0,     1,     2,     1,     1,
       0,     2,     2,     0,     1,     2,     0,     1,     2,     0,
       2,     2,     0,     1,     2,     0,     1,     2,     0,     2,
       2,     0,     1,     2,     0,     1,     2,     0,     2,     2,
       0,     1,     2,     0,     1,     2,     0,     2,     2,     0,
       1,     2,     0,     1,     2,     2,     2,     2,     2,     0,
       1,     2,     0,     1,     2,     2,     2,     0,     1,     2,
       0,     1,     2,     0,     1,     2,     2,     0,     1,     2,
       0,     1,     2,     0,     2,     0,     3,     2,     1,     0,
       2,     0,     3,     1,     1,     1,     0,     2,     1,     2,
       1,     2,     3,     3,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     0,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     1,     1,     1,     1,     1,     1,     1,
       3,     0,     1,     1,     3,     3,     1,     3,     3,     1,
       3,     1,     2,     2,     1,     3,     1,     1,     3,     1,
       3,     1,     3,     1,     2,     2,     1,     1,     2,     1,
       1,     2,     2,     3,     1,     1,     1,     1,     2,     1,
       1,     2,     1,     0,     2,     1,     1,     1,     3,     1,
       1,     2,     1,     0,     1,     1,     2,     1,     1,     2,
       1,     1,     1,     1,     1,     1,     1,     2,     1,     1,
       3,     0,     1,     1,     2,     1,     1,     1,     1,     1,
       1,     1,     2,     2,     2,     4,     3,     5,     5,     1,
       1,     1,     2,     1,     1,     1,     1,     1,     1,     1,
       2,     2,     2,     1,     1,     1,     2,     2,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     1,     1,     1,     1,     1,     1,     3,     2,     2,
       1,     1,     2,     1,     1,     3,     2,     2,     1,     1,
       1,     3,     0,     2,     1,     3,     3,     4,     5,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     1,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     5,     5,     5,
       4,     5,     4,     5,     5,     5,     5,     5,     2,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     4,     5,     0,     3,     2,     1,     3,     3,
       0,     2,     1,     3,     1,     3,     1,     3,     1,     3,
       0,     0,     1,     0,     3,     2,     0,     1,     0,     2,
       0,     2,     0,     1,     1,     0,     1,     0,     1,     2,
       0,     2,     0,     3,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     2,     0,     5,     0,     3,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     0,     1,     0,     1,
       0,     1,     0,     1,     0,     1,     1,     0,     1,     0,
       1,     0,     1,     0,     1,     0,     1,     0,     1,     0,
       1,     0,     1,     0,     1,     0,     1,     0,     1,     0,
       1,     0,     1,     0,     3,     0,     1,     0,     1,     0,
       1,     0,     1,     0,     1,     0,     1,     1,     0,     1,
       2,     0,     1,     0,     1,     0,     1,     0,     1,     0,
       1,     0,     1,     1,     0,     1,     1,     0,     1,     1,
       1,     0,     1,     1,     0,     1,     0,     1,     0,     1,
       1,     0,     2,     2,     0,     1,     0,     1,     0,     1,
       0,     1,     0,     1,     0,     1,     1,     1,     0,     1,
       0,     1,     0,     1,     1,     0,     2,     1,     1,     0,
       1,     0,     1,     0,     1,     0,     1,     0,     1,     0,
       1,     0,     1,     1,     0,     1,     0,     1,     0,     1,
       0,     1,     2,     0,     1,     0,     1,     0,     1,     0,
       1,     0,     1,     0,     1,     0,     1,     0,     1,     0,
       1,     0,     1,     0,     1,     0,     3,     0,     1,     0,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     1,     2,     1,     2,     1,     2,
       1,     2,     1,     2,     1,     2,     2
};


#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)
#define YYEMPTY         (-2)
#define YYEOF           0

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Error token number */
#define YYTERROR        1
#define YYERRCODE       256



/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)

/* This macro is provided for backward compatibility. */
#ifndef YY_LOCATION_PRINT
# define YY_LOCATION_PRINT(File, Loc) ((void) 0)
#endif


# define YY_SYMBOL_PRINT(Title, Type, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Type, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo, int yytype, YYSTYPE const * const yyvaluep)
{
  FILE *yyoutput = yyo;
  YYUSE (yyoutput);
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyo, yytoknum[yytype], *yyvaluep);
# endif
  YYUSE (yytype);
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo, int yytype, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyo, "%s %s (",
             yytype < YYNTOKENS ? "token" : "nterm", yytname[yytype]);

  yy_symbol_value_print (yyo, yytype, yyvaluep);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yytype_int16 *yybottom, yytype_int16 *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yytype_int16 *yyssp, YYSTYPE *yyvsp, int yyrule)
{
  unsigned long yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       yystos[yyssp[yyi + 1 - yynrhs]],
                       &yyvsp[(yyi + 1) - (yynrhs)]
                                              );
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
yystrlen (const char *yystr)
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            else
              goto append;

          append:
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return (YYSIZE_T) (yystpcpy (yyres, yystr) - yyres);
}
# endif

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return 1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return 2 if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYSIZE_T *yymsg_alloc, char **yymsg,
                yytype_int16 *yyssp, int yytoken)
{
  YYSIZE_T yysize0 = yytnamerr (YY_NULLPTR, yytname[yytoken]);
  YYSIZE_T yysize = yysize0;
  enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat. */
  char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
  /* Number of reported tokens (one for the "unexpected", one per
     "expected"). */
  int yycount = 0;

  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yytoken != YYEMPTY)
    {
      int yyn = yypact[*yyssp];
      yyarg[yycount++] = yytname[yytoken];
      if (!yypact_value_is_default (yyn))
        {
          /* Start YYX at -YYN if negative to avoid negative indexes in
             YYCHECK.  In other words, skip the first -YYN actions for
             this state because they are default actions.  */
          int yyxbegin = yyn < 0 ? -yyn : 0;
          /* Stay within bounds of both yycheck and yytname.  */
          int yychecklim = YYLAST - yyn + 1;
          int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
          int yyx;

          for (yyx = yyxbegin; yyx < yyxend; ++yyx)
            if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR
                && !yytable_value_is_error (yytable[yyx + yyn]))
              {
                if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
                  {
                    yycount = 1;
                    yysize = yysize0;
                    break;
                  }
                yyarg[yycount++] = yytname[yyx];
                {
                  YYSIZE_T yysize1 = yysize + yytnamerr (YY_NULLPTR, yytname[yyx]);
                  if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
                    yysize = yysize1;
                  else
                    return 2;
                }
              }
        }
    }

  switch (yycount)
    {
# define YYCASE_(N, S)                      \
      case N:                               \
        yyformat = S;                       \
      break
    default: /* Avoid compiler warnings. */
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
# undef YYCASE_
    }

  {
    YYSIZE_T yysize1 = yysize + yystrlen (yyformat);
    if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
      yysize = yysize1;
    else
      return 2;
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return 1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yyarg[yyi++]);
          yyformat += 2;
        }
      else
        {
          yyp++;
          yyformat++;
        }
  }
  return 0;
}
#endif /* YYERROR_VERBOSE */

/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
{
  YYUSE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YYUSE (yytype);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}




/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;


/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    int yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       'yyss': related to states.
       'yyvs': related to semantic values.

       Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* The state stack.  */
    yytype_int16 yyssa[YYINITDEPTH];
    yytype_int16 *yyss;
    yytype_int16 *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    YYSIZE_T yystacksize;

  int yyn;
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yyssp = yyss = yyssa;
  yyvsp = yyvs = yyvsa;
  yystacksize = YYINITDEPTH;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY; /* Cause a token to be read.  */
  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yynewstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  *yyssp = (yytype_int16) yystate;

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    goto yyexhaustedlab;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = (YYSIZE_T) (yyssp - yyss + 1);

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        YYSTYPE *yyvs1 = yyvs;
        yytype_int16 *yyss1 = yyss;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * sizeof (*yyssp),
                    &yyvs1, yysize * sizeof (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yytype_int16 *yyss1 = yyss;
        union yyalloc *yyptr =
          (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
        if (! yyptr)
          goto yyexhaustedlab;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
# undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
                  (unsigned long) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = yylex ();
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token.  */
  yychar = YYEMPTY;

  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 3306 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	clear_initial_values ();
	current_program = NULL;
	defined_prog_list = NULL;
	cobc_cs_check = 0;
	main_flag_set = 0;
	current_program = cb_build_program (NULL, 0);
	cb_set_intr_when_compiled ();
	cb_build_registers ();
	cb_add_external_defined_registers ();
  }
#line 12186 "parser.c" /* yacc.c:1652  */
    break;

  case 3:
#line 3318 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (!current_program->flag_validated) {
		current_program->flag_validated = 1;
		cb_validate_program_body (current_program);
	}
	if (depth > 1) {
		cb_error (_("multiple PROGRAM-ID's without matching END PROGRAM"));
	}
	if (cobc_flag_main && !main_flag_set) {
		cb_error (_("executable requested but no program found"));
	}
	if (errorcount > 0) {
		YYABORT;
	}
	if (!current_program->entry_list) {
		backup_current_pos ();
		emit_entry (current_program->program_id, 0, NULL, NULL);
	}
  }
#line 12210 "parser.c" /* yacc.c:1652  */
    break;

  case 6:
#line 3345 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	first_prog = 1;
	depth = 0;
	setup_from_identification = 0;
  }
#line 12220 "parser.c" /* yacc.c:1652  */
    break;

  case 12:
#line 3364 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	program_init_without_program_id ();
  }
#line 12228 "parser.c" /* yacc.c:1652  */
    break;

  case 13:
#line 3369 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	backup_current_pos ();
	clean_up_program (NULL, COB_MODULE_TYPE_PROGRAM);
  }
#line 12237 "parser.c" /* yacc.c:1652  */
    break;

  case 16:
#line 3395 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	backup_current_pos ();
	clean_up_program (NULL, COB_MODULE_TYPE_PROGRAM);
  }
#line 12246 "parser.c" /* yacc.c:1652  */
    break;

  case 20:
#line 3409 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	backup_current_pos ();
  }
#line 12254 "parser.c" /* yacc.c:1652  */
    break;

  case 21:
#line 3413 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	first_nested_program = 0;
	clean_up_program (yyvsp[-1], COB_MODULE_TYPE_PROGRAM);
  }
#line 12263 "parser.c" /* yacc.c:1652  */
    break;

  case 22:
#line 3421 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	backup_current_pos ();
  }
#line 12271 "parser.c" /* yacc.c:1652  */
    break;

  case 23:
#line 3425 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	clean_up_program (yyvsp[-1], COB_MODULE_TYPE_FUNCTION);
  }
#line 12279 "parser.c" /* yacc.c:1652  */
    break;

  case 24:
#line 3435 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_validate_program_environment (current_program);
  }
#line 12287 "parser.c" /* yacc.c:1652  */
    break;

  case 25:
#line 3439 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	/* note:
	   we also validate all references we found so far here */
	cb_validate_program_data (current_program);
	within_typedef_definition = 0;
  }
#line 12298 "parser.c" /* yacc.c:1652  */
    break;

  case 29:
#line 3457 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	setup_program_start ();
	setup_from_identification = 1;
  }
#line 12307 "parser.c" /* yacc.c:1652  */
    break;

  case 32:
#line 3470 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cobc_in_id = 1;
  }
#line 12315 "parser.c" /* yacc.c:1652  */
    break;

  case 33:
#line 3474 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (setup_program (yyvsp[-1], yyvsp[0], COB_MODULE_TYPE_PROGRAM)) {
		YYABORT;
	}

	setup_prototype (yyvsp[-1], yyvsp[0], COB_MODULE_TYPE_PROGRAM, 1);
  }
#line 12327 "parser.c" /* yacc.c:1652  */
    break;

  case 34:
#line 3482 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cobc_cs_check = 0;
	cobc_in_id = 0;
  }
#line 12336 "parser.c" /* yacc.c:1652  */
    break;

  case 35:
#line 3490 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cobc_in_id = 1;
  }
#line 12344 "parser.c" /* yacc.c:1652  */
    break;

  case 36:
#line 3494 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (setup_program (yyvsp[-2], yyvsp[-1], COB_MODULE_TYPE_FUNCTION)) {
		YYABORT;
	}
	setup_prototype (yyvsp[-2], yyvsp[-1], COB_MODULE_TYPE_FUNCTION, 1);
	cobc_cs_check = 0;
	cobc_in_id = 0;
  }
#line 12357 "parser.c" /* yacc.c:1652  */
    break;

  case 37:
#line 3506 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (CB_REFERENCE_P (yyvsp[0]) && CB_WORD_COUNT (yyvsp[0]) > 0) {
		redefinition_error (yyvsp[0]);
	}
	/*
	  The program name is a key part of defining the current_program, so we
	  mustn't lose it (unlike in undefined_word).
	*/
	yyval = yyvsp[0];
  }
#line 12372 "parser.c" /* yacc.c:1652  */
    break;

  case 38:
#line 3517 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_trim_program_id (yyvsp[0]);
  }
#line 12380 "parser.c" /* yacc.c:1652  */
    break;

  case 40:
#line 3525 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_trim_program_id (yyvsp[0]);
  }
#line 12388 "parser.c" /* yacc.c:1652  */
    break;

  case 41:
#line 3531 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 12394 "parser.c" /* yacc.c:1652  */
    break;

  case 42:
#line 3532 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 12400 "parser.c" /* yacc.c:1652  */
    break;

  case 45:
#line 3541 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (!current_program->nested_level) {
		cb_error (_("COMMON may only be used in a contained program"));
	} else {
		current_program->flag_common = 1;
		cb_add_common_prog (current_program);
	}
  }
#line 12413 "parser.c" /* yacc.c:1652  */
    break;

  case 46:
#line 3550 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (!current_program->nested_level) {
		cb_error (_("COMMON may only be used in a contained program"));
	} else {
		current_program->flag_common = 1;
		cb_add_common_prog (current_program);
	}
  }
#line 12426 "parser.c" /* yacc.c:1652  */
    break;

  case 48:
#line 3560 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING (_("CALL prototypes"));
  }
#line 12434 "parser.c" /* yacc.c:1652  */
    break;

  case 51:
#line 3572 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_program->flag_initial = 1;
  }
#line 12442 "parser.c" /* yacc.c:1652  */
    break;

  case 52:
#line 3576 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_program->flag_recursive = 1;
  }
#line 12450 "parser.c" /* yacc.c:1652  */
    break;

  case 54:
#line 3585 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cobc_cs_check = 0;
  }
#line 12458 "parser.c" /* yacc.c:1652  */
    break;

  case 58:
#line 3605 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
/* FIXME: the IBM-compatible ARITHMETIC should only be disabled
          for the specified program (and its nested programs)
   note: ibm-strict.conf has no OPTIONS paragraph, but ibm.conf does */
	cb_arithmetic_osvs = 0;
  }
#line 12469 "parser.c" /* yacc.c:1652  */
    break;

  case 59:
#line 3612 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("STANDARD ARITHMETIC");
  }
#line 12477 "parser.c" /* yacc.c:1652  */
    break;

  case 60:
#line 3616 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("STANDARD-BINARY ARITHMETIC");
  }
#line 12485 "parser.c" /* yacc.c:1652  */
    break;

  case 61:
#line 3620 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("STANDARD-DECIMAL ARITHMETIC");
  }
#line 12493 "parser.c" /* yacc.c:1652  */
    break;

  case 62:
#line 3635 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	default_rounded_mode = cb_int (COB_STORE_ROUND);
  }
#line 12501 "parser.c" /* yacc.c:1652  */
    break;

  case 63:
#line 3639 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[0]) {
		default_rounded_mode = yyvsp[0];
	} else {
		default_rounded_mode = cb_int (COB_STORE_ROUND);
	}
  }
#line 12513 "parser.c" /* yacc.c:1652  */
    break;

  case 65:
#line 3651 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_program->entry_convention = yyvsp[0];
  }
#line 12521 "parser.c" /* yacc.c:1652  */
    break;

  case 66:
#line 3658 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int (CB_CONV_COBOL);
  }
#line 12529 "parser.c" /* yacc.c:1652  */
    break;

  case 67:
#line 3662 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int0;
  }
#line 12537 "parser.c" /* yacc.c:1652  */
    break;

  case 68:
#line 3666 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int (CB_CONV_STDCALL);
  }
#line 12545 "parser.c" /* yacc.c:1652  */
    break;

  case 70:
#line 3674 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("INTERMEDIATE ROUNDING");
  }
#line 12553 "parser.c" /* yacc.c:1652  */
    break;

  case 71:
#line 3681 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int (COB_STORE_ROUND | COB_STORE_NEAR_AWAY_FROM_ZERO);
  }
#line 12561 "parser.c" /* yacc.c:1652  */
    break;

  case 72:
#line 3685 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int (COB_STORE_ROUND | COB_STORE_NEAR_EVEN);
  }
#line 12569 "parser.c" /* yacc.c:1652  */
    break;

  case 73:
#line 3689 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int (COB_STORE_ROUND | COB_STORE_PROHIBITED);
  }
#line 12577 "parser.c" /* yacc.c:1652  */
    break;

  case 74:
#line 3693 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int (COB_STORE_ROUND | COB_STORE_TRUNCATION);
  }
#line 12585 "parser.c" /* yacc.c:1652  */
    break;

  case 77:
#line 3708 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	header_check |= COBC_HD_ENVIRONMENT_DIVISION;
  }
#line 12593 "parser.c" /* yacc.c:1652  */
    break;

  case 80:
#line 3722 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION, 0, 0, 0);
	header_check |= COBC_HD_CONFIGURATION_SECTION;
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "CONFIGURATION SECTION");
	}
  }
#line 12605 "parser.c" /* yacc.c:1652  */
    break;

  case 90:
#line 3753 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION, 0, 0);
	check_conf_section_order (COBC_HD_SOURCE_COMPUTER);
	set_conf_section_part (COBC_HD_SOURCE_COMPUTER);
  }
#line 12616 "parser.c" /* yacc.c:1652  */
    break;

  case 95:
#line 3769 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_program->flag_debugging = 1;
	needs_debug_item = 1;
	cobc_cs_check = 0;
	cb_build_debug_item ();
  }
#line 12627 "parser.c" /* yacc.c:1652  */
    break;

  case 96:
#line 3781 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION, 0, 0);
	check_conf_section_order (COBC_HD_OBJECT_COMPUTER);
	set_conf_section_part (COBC_HD_OBJECT_COMPUTER);
  }
#line 12638 "parser.c" /* yacc.c:1652  */
    break;

  case 97:
#line 3788 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cobc_cs_check = 0;
  }
#line 12646 "parser.c" /* yacc.c:1652  */
    break;

  case 108:
#line 3814 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_verify (cb_memory_size_clause, "MEMORY SIZE");
  }
#line 12654 "parser.c" /* yacc.c:1652  */
    break;

  case 109:
#line 3822 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_program->collating_sequence = alphanumeric_collation;
	current_program->collating_sequence_n = national_collation;
  }
#line 12663 "parser.c" /* yacc.c:1652  */
    break;

  case 110:
#line 3830 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	alphanumeric_collation = national_collation = NULL;
  }
#line 12671 "parser.c" /* yacc.c:1652  */
    break;

  case 112:
#line 3838 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	alphanumeric_collation = yyvsp[0];
  }
#line 12679 "parser.c" /* yacc.c:1652  */
    break;

  case 113:
#line 3842 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	alphanumeric_collation = yyvsp[-1];
	CB_PENDING_X (yyvsp[0], "NATIONAL COLLATING SEQUENCE");
	national_collation = yyvsp[0];
  }
#line 12689 "parser.c" /* yacc.c:1652  */
    break;

  case 114:
#line 3848 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	alphanumeric_collation = yyvsp[0];
  }
#line 12697 "parser.c" /* yacc.c:1652  */
    break;

  case 115:
#line 3852 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING_X (yyvsp[0], "NATIONAL COLLATING SEQUENCE");
	national_collation = yyvsp[0];
  }
#line 12706 "parser.c" /* yacc.c:1652  */
    break;

  case 116:
#line 3858 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	alphanumeric_collation = yyvsp[-4];
	CB_PENDING_X (yyvsp[0], "NATIONAL COLLATING SEQUENCE");
	national_collation = yyvsp[0];
  }
#line 12716 "parser.c" /* yacc.c:1652  */
    break;

  case 117:
#line 3865 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING_X (yyvsp[-4], "NATIONAL COLLATING SEQUENCE");
	national_collation = yyvsp[-4];
	alphanumeric_collation = yyvsp[0];
  }
#line 12726 "parser.c" /* yacc.c:1652  */
    break;

  case 118:
#line 3874 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (cb_verify (cb_section_segments, "SEGMENT LIMIT")) {
		int segnum = cb_get_int (yyvsp[0]);
		if (segnum == 0 || segnum > 49) {
			cb_error (_("segment-number must be in range of values 1 to 49"));
			yyval = NULL;
		}
	}
	/* Ignore */
  }
#line 12741 "parser.c" /* yacc.c:1652  */
    break;

  case 119:
#line 3888 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (current_program->classification) {
		cb_error (_("duplicate CLASSIFICATION clause"));
	} else {
		current_program->classification = yyvsp[0];
	}
  }
#line 12753 "parser.c" /* yacc.c:1652  */
    break;

  case 120:
#line 3899 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 12761 "parser.c" /* yacc.c:1652  */
    break;

  case 121:
#line 3903 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 12769 "parser.c" /* yacc.c:1652  */
    break;

  case 122:
#line 3907 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int1;
  }
#line 12777 "parser.c" /* yacc.c:1652  */
    break;

  case 123:
#line 3911 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int1;
  }
#line 12785 "parser.c" /* yacc.c:1652  */
    break;

  case 126:
#line 3925 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION, 0, 0);
	check_conf_section_order (COBC_HD_REPOSITORY);
	set_conf_section_part (COBC_HD_REPOSITORY);
  }
#line 12796 "parser.c" /* yacc.c:1652  */
    break;

  case 127:
#line 3932 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cobc_in_repository = 0;
  }
#line 12804 "parser.c" /* yacc.c:1652  */
    break;

  case 130:
#line 3941 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyerrok;
  }
#line 12812 "parser.c" /* yacc.c:1652  */
    break;

  case 133:
#line 3953 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	functions_are_all = 1;
  }
#line 12820 "parser.c" /* yacc.c:1652  */
    break;

  case 134:
#line 3957 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[-1] != cb_error_node) {
		setup_prototype (yyvsp[-1], yyvsp[0], COB_MODULE_TYPE_FUNCTION, 0);
	}
  }
#line 12830 "parser.c" /* yacc.c:1652  */
    break;

  case 136:
#line 3964 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	  if (yyvsp[-1] != cb_error_node
	      && cb_verify (cb_program_prototypes, _("PROGRAM phrase"))) {
		setup_prototype (yyvsp[-1], yyvsp[0], COB_MODULE_TYPE_PROGRAM, 0);
	}
  }
#line 12841 "parser.c" /* yacc.c:1652  */
    break;

  case 137:
#line 3971 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyerrok;
  }
#line 12849 "parser.c" /* yacc.c:1652  */
    break;

  case 138:
#line 3978 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_program->function_spec_list =
		cb_list_add (current_program->function_spec_list, yyvsp[0]);
  }
#line 12858 "parser.c" /* yacc.c:1652  */
    break;

  case 139:
#line 3983 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_program->function_spec_list =
		cb_list_add (current_program->function_spec_list, yyvsp[0]);
  }
#line 12867 "parser.c" /* yacc.c:1652  */
    break;

  case 140:
#line 3994 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_duplicate = 0;
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION, 0, 0);
	check_conf_section_order (COBC_HD_SPECIAL_NAMES);
	set_conf_section_part (COBC_HD_SPECIAL_NAMES);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	}
  }
#line 12882 "parser.c" /* yacc.c:1652  */
    break;

  case 159:
#line 4039 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	check_duplicate = 0;
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
		save_tree = NULL;
	} else {
		/* lookup system name with special translation
		   note: result in NULL + raised error if not found */
		save_tree = get_system_name_translated (yyvsp[0]);
	}
  }
#line 12901 "parser.c" /* yacc.c:1652  */
    break;

  case 161:
#line 4058 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (save_tree) {
		if (CB_SYSTEM_NAME(save_tree)->token != CB_DEVICE_CONSOLE) {
			cb_error_x (save_tree, _("invalid %s clause"), "");
		} else {
			current_program->flag_console_is_crt = 1;
		}
	}
  }
#line 12915 "parser.c" /* yacc.c:1652  */
    break;

  case 162:
#line 4069 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (save_tree) {
		if (CB_SYSTEM_NAME(save_tree)->token != CB_FEATURE_CONVENTION) {
			cb_error_x (save_tree, _("invalid %s clause"), "SPECIAL NAMES");
		} else if (CB_VALID_TREE (yyvsp[0])) {
			CB_SYSTEM_NAME(save_tree)->value = yyvsp[-2];
			cb_define (yyvsp[0], save_tree);
			CB_CHAIN_PAIR (current_program->mnemonic_spec_list,
					yyvsp[0], save_tree);
			/* remove non-standard context-sensitive words when identical to mnemonic */
			if (strcasecmp (CB_NAME(yyvsp[0]), "EXTERN" ) == 0 ||
			    strcasecmp (CB_NAME(yyvsp[0]), "STDCALL") == 0 ||
			    strcasecmp (CB_NAME(yyvsp[0]), "STATIC" ) == 0 ||
			    strcasecmp (CB_NAME(yyvsp[0]), "C"      ) == 0 ||
			    strcasecmp (CB_NAME(yyvsp[0]), "PASCAL" ) == 0) {
				remove_context_sensitivity (CB_NAME(yyvsp[0]), CB_CS_CALL);
			}
		}
	}
  }
#line 12940 "parser.c" /* yacc.c:1652  */
    break;

  case 163:
#line 4090 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (save_tree && CB_VALID_TREE (yyvsp[-1])) {
		cb_define (yyvsp[-1], save_tree);
		CB_CHAIN_PAIR (current_program->mnemonic_spec_list,
				yyvsp[-1], save_tree);
	}
  }
#line 12952 "parser.c" /* yacc.c:1652  */
    break;

  case 167:
#line 4106 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	  check_on_off_duplicate = 0;
  }
#line 12960 "parser.c" /* yacc.c:1652  */
    break;

  case 168:
#line 4113 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_tree		x;

	/* cb_define_switch_name checks param validity */
	x = cb_define_switch_name (yyvsp[0], save_tree, yyvsp[-2] == cb_int1);
	if (x) {
		if (yyvsp[-2] == cb_int1) {
			check_repeated ("ON", SYN_CLAUSE_1, &check_on_off_duplicate);
		} else {
			check_repeated ("OFF", SYN_CLAUSE_2, &check_on_off_duplicate);
		}
		CB_CHAIN_PAIR (current_program->mnemonic_spec_list, yyvsp[0], x);
	}
  }
#line 12979 "parser.c" /* yacc.c:1652  */
    break;

  case 169:
#line 4128 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_tree		x;

	/* cb_define_switch_name checks param validity */
	x = cb_define_switch_name (yyvsp[0], save_tree, yyvsp[-2] == cb_int1);
	if (x) {
		if (yyvsp[-2] == cb_int1) {
			check_repeated ("ON", SYN_CLAUSE_1, &check_on_off_duplicate);
		} else {
			check_repeated ("OFF", SYN_CLAUSE_2, &check_on_off_duplicate);
		}
		CB_CHAIN_PAIR (current_program->mnemonic_spec_list, yyvsp[0], x);
	}
  }
#line 12998 "parser.c" /* yacc.c:1652  */
    break;

  case 170:
#line 4148 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
		yyval = NULL;
	} else {
		/* Returns null on error */
		yyval = cb_build_alphabet_name (yyvsp[0]);
	}
  }
#line 13015 "parser.c" /* yacc.c:1652  */
    break;

  case 171:
#line 4161 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[-1]) {
		current_program->alphabet_name_list =
			cb_list_add (current_program->alphabet_name_list, yyvsp[-1]);
	}
	cobc_cs_check = 0;
  }
#line 13027 "parser.c" /* yacc.c:1652  */
    break;

  case 172:
#line 4172 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[-1];
	if (yyvsp[-1]) {
		CB_ALPHABET_NAME (yyvsp[-1])->alphabet_target = CB_ALPHABET_ALPHANUMERIC;
	}
  }
#line 13038 "parser.c" /* yacc.c:1652  */
    break;

  case 174:
#line 4180 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[-1];
	if (yyvsp[-1]) {
		CB_ALPHABET_NAME(yyvsp[-1])->alphabet_target = CB_ALPHABET_NATIONAL;
	}
  }
#line 13049 "parser.c" /* yacc.c:1652  */
    break;

  case 180:
#line 4201 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[(-1) - (1)]) {
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_ASCII;
	}
  }
#line 13059 "parser.c" /* yacc.c:1652  */
    break;

  case 181:
#line 4207 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[(-1) - (1)]) {
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_ASCII;
	}
  }
#line 13069 "parser.c" /* yacc.c:1652  */
    break;

  case 182:
#line 4213 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[(-1) - (1)]) {
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_EBCDIC;
	}
  }
#line 13079 "parser.c" /* yacc.c:1652  */
    break;

  case 183:
#line 4219 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[(-1) - (1)]) {
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_ASCII;
	}
  }
#line 13089 "parser.c" /* yacc.c:1652  */
    break;

  case 185:
#line 4229 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[(-1) - (1)]) {
		CB_PENDING_X (yyvsp[(-1) - (1)], "ALPHABET UCS-4");
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_UCS_4;
	}
  }
#line 13100 "parser.c" /* yacc.c:1652  */
    break;

  case 186:
#line 4236 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[(-1) - (1)]) {
		CB_PENDING_X (yyvsp[(-1) - (1)], "ALPHABET UTF-8");
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_UTF_8;
	}
  }
#line 13111 "parser.c" /* yacc.c:1652  */
    break;

  case 187:
#line 4243 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[(-1) - (1)]) {
		CB_PENDING_X (yyvsp[(-1) - (1)], "ALPHABET UTF-16");
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_UTF_16;
	}
  }
#line 13122 "parser.c" /* yacc.c:1652  */
    break;

  case 188:
#line 4253 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[(-1) - (1)]) {
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_NATIVE;
	}
  }
#line 13132 "parser.c" /* yacc.c:1652  */
    break;

  case 189:
#line 4259 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[(-1) - (2)]) {
		CB_ALPHABET_NAME (yyvsp[(-1) - (2)])->alphabet_type = CB_ALPHABET_LOCALE;
		CB_ALPHABET_NAME (yyvsp[(-1) - (2)])->custom_list = yyvsp[0];
		CB_PENDING_X (yyvsp[(-1) - (2)], "LOCALE ALPHABET");
	}
  }
#line 13144 "parser.c" /* yacc.c:1652  */
    break;

  case 190:
#line 4267 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[(-1) - (1)]) {
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_CUSTOM;
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->custom_list = yyvsp[0];
	}
  }
#line 13155 "parser.c" /* yacc.c:1652  */
    break;

  case 191:
#line 4277 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = CB_LIST_INIT (yyvsp[0]);
  }
#line 13163 "parser.c" /* yacc.c:1652  */
    break;

  case 192:
#line 4281 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_list_add (yyvsp[-1], yyvsp[0]);
  }
#line 13171 "parser.c" /* yacc.c:1652  */
    break;

  case 193:
#line 4288 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 13179 "parser.c" /* yacc.c:1652  */
    break;

  case 194:
#line 4292 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = CB_BUILD_PAIR (yyvsp[-2], yyvsp[0]);
  }
#line 13187 "parser.c" /* yacc.c:1652  */
    break;

  case 195:
#line 4296 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = CB_LIST_INIT (yyvsp[-1]);
  }
#line 13195 "parser.c" /* yacc.c:1652  */
    break;

  case 196:
#line 4300 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[-1];
  }
#line 13203 "parser.c" /* yacc.c:1652  */
    break;

  case 197:
#line 4307 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_list_add (yyvsp[-1], yyvsp[0]);
  }
#line 13211 "parser.c" /* yacc.c:1652  */
    break;

  case 198:
#line 4311 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_list_add (yyvsp[-3], yyvsp[0]);
  }
#line 13219 "parser.c" /* yacc.c:1652  */
    break;

  case 199:
#line 4317 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 13225 "parser.c" /* yacc.c:1652  */
    break;

  case 200:
#line 4318 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_space; }
#line 13231 "parser.c" /* yacc.c:1652  */
    break;

  case 201:
#line 4319 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_zero; }
#line 13237 "parser.c" /* yacc.c:1652  */
    break;

  case 202:
#line 4320 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_quote; }
#line 13243 "parser.c" /* yacc.c:1652  */
    break;

  case 203:
#line 4321 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_norm_high; }
#line 13249 "parser.c" /* yacc.c:1652  */
    break;

  case 204:
#line 4322 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_norm_low; }
#line 13255 "parser.c" /* yacc.c:1652  */
    break;

  case 205:
#line 4326 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_space; }
#line 13261 "parser.c" /* yacc.c:1652  */
    break;

  case 206:
#line 4327 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_zero; }
#line 13267 "parser.c" /* yacc.c:1652  */
    break;

  case 207:
#line 4335 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else if (yyvsp[-1]) {
		CB_CHAIN_PAIR (current_program->symbolic_char_list, yyvsp[-1], yyvsp[0]);
	}
  }
#line 13282 "parser.c" /* yacc.c:1652  */
    break;

  case 208:
#line 4349 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 13290 "parser.c" /* yacc.c:1652  */
    break;

  case 209:
#line 4353 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 13298 "parser.c" /* yacc.c:1652  */
    break;

  case 210:
#line 4361 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 13306 "parser.c" /* yacc.c:1652  */
    break;

  case 211:
#line 4368 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 13314 "parser.c" /* yacc.c:1652  */
    break;

  case 212:
#line 4372 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[0]) {
		yyval = cb_list_append (yyvsp[-1], yyvsp[0]);
	} else {
		yyval = yyvsp[-1];
	}
  }
#line 13326 "parser.c" /* yacc.c:1652  */
    break;

  case 213:
#line 4383 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_tree		l1;
	cb_tree		l2;

	if (cb_list_length (yyvsp[-2]) != cb_list_length (yyvsp[0])) {
		cb_error (_("invalid %s clause"), "SYMBOLIC");
		yyval = NULL;
	} else {
		l1 = yyvsp[-2];
		l2 = yyvsp[0];
		for (; l1; l1 = CB_CHAIN (l1), l2 = CB_CHAIN (l2)) {
			CB_PURPOSE (l1) = CB_VALUE (l2);
		}
		yyval = yyvsp[-2];
	}
  }
#line 13347 "parser.c" /* yacc.c:1652  */
    break;

  case 214:
#line 4403 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[0] == NULL) {
		yyval = NULL;
	} else {
		yyval = CB_LIST_INIT (yyvsp[0]);
	}
  }
#line 13359 "parser.c" /* yacc.c:1652  */
    break;

  case 215:
#line 4411 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[0] == NULL) {
		yyval = yyvsp[-1];
	} else {
		yyval = cb_list_add (yyvsp[-1], yyvsp[0]);
	}
  }
#line 13371 "parser.c" /* yacc.c:1652  */
    break;

  case 216:
#line 4421 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = CB_LIST_INIT (yyvsp[0]); }
#line 13377 "parser.c" /* yacc.c:1652  */
    break;

  case 217:
#line 4422 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_list_add (yyvsp[-1], yyvsp[0]); }
#line 13383 "parser.c" /* yacc.c:1652  */
    break;

  case 218:
#line 4431 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	}
	(void)cb_verify (cb_symbolic_constant, "SYMBOLIC CONSTANT");
  }
#line 13397 "parser.c" /* yacc.c:1652  */
    break;

  case 221:
#line 4449 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	struct cb_field *f;
	cb_tree v;

	v = CB_LIST_INIT (yyvsp[0]);
	f = CB_FIELD (cb_build_constant (yyvsp[-2], v));
	f->flag_item_78 = 1;
	f->flag_constant = 1;
	f->flag_is_global = 1;
	f->level = 1;
	f->values = v;
	cb_needs_01 = 1;
	/* Ignore return value */
	(void)cb_validate_78_item (f, 0);
  }
#line 13417 "parser.c" /* yacc.c:1652  */
    break;

  case 222:
#line 4470 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_tree		x;

	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		/* Returns null on error */
		x = cb_build_class_name (yyvsp[-4], yyvsp[-1]);
		if (x) {
			current_program->class_name_list =
				cb_list_add (current_program->class_name_list, x);
		}
	}
  }
#line 13439 "parser.c" /* yacc.c:1652  */
    break;

  case 223:
#line 4490 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = CB_LIST_INIT (yyvsp[0]); }
#line 13445 "parser.c" /* yacc.c:1652  */
    break;

  case 224:
#line 4491 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_list_add (yyvsp[-1], yyvsp[0]); }
#line 13451 "parser.c" /* yacc.c:1652  */
    break;

  case 225:
#line 4496 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 13459 "parser.c" /* yacc.c:1652  */
    break;

  case 226:
#line 4500 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (CB_TREE_CLASS (yyvsp[-2]) != CB_CLASS_NUMERIC &&
	    CB_LITERAL_P (yyvsp[-2]) && CB_LITERAL (yyvsp[-2])->size != 1) {
		cb_error (_("CLASS literal with THRU must have size 1"));
	}
	if (CB_TREE_CLASS (yyvsp[0]) != CB_CLASS_NUMERIC &&
	    CB_LITERAL_P (yyvsp[0]) && CB_LITERAL (yyvsp[0])->size != 1) {
		cb_error (_("CLASS literal with THRU must have size 1"));
	}
	if (literal_value (yyvsp[-2]) <= literal_value (yyvsp[0])) {
		yyval = CB_BUILD_PAIR (yyvsp[-2], yyvsp[0]);
	} else {
		yyval = CB_BUILD_PAIR (yyvsp[0], yyvsp[-2]);
	}
  }
#line 13479 "parser.c" /* yacc.c:1652  */
    break;

  case 228:
#line 4520 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 13487 "parser.c" /* yacc.c:1652  */
    break;

  case 229:
#line 4524 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING_X (yyvsp[0], "NATIONAL CLASS");
	yyval = cb_int0;
  }
#line 13496 "parser.c" /* yacc.c:1652  */
    break;

  case 231:
#line 4533 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING_X (yyvsp[0], _("CLASS IS integer IN alphabet-name"));
	yyval = yyvsp[0];
  }
#line 13505 "parser.c" /* yacc.c:1652  */
    break;

  case 232:
#line 4543 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		/* Returns null on error */
		cb_tree	l = cb_build_locale_name (yyvsp[-2], yyvsp[0]);
		if (l) {
			current_program->locale_list =
				cb_list_add (current_program->locale_list, l);
		}
	}
  }
#line 13525 "parser.c" /* yacc.c:1652  */
    break;

  case 233:
#line 4564 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		unsigned int	error_ind = 0;

		/* FIXME: actual allowed (depending on dialect), see FR #246 */
		check_repeated ("CURRENCY", SYN_CLAUSE_1, &check_duplicate);

		/* checks of CURRENCY SIGN (being currency string) when separate */
		if (yyvsp[0]) {
			unsigned int	char_seen = 0;
			unsigned char	*s = CB_LITERAL (yyvsp[-1])->data;

			CB_PENDING_X (yyvsp[-1], _("separate currency symbol and currency string"));
			while (*s) {
				switch (*s) {
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
				case '+':
				case '-':
				case ',':
				case '.':
				case '*':
					error_ind = 1;
					break;
				case ' ':
					break;
				default:
					char_seen = 1;
					break;
				}
				s++;
			}
			if (!char_seen) {
				error_ind = 1;
			}
		}
		if (error_ind) {
			cb_error_x (yyvsp[-1], _("invalid CURRENCY SIGN '%s'"), (char*)CB_LITERAL (yyvsp[-1])->data);
		}
		if (yyvsp[0]) {
			set_currency_picture_symbol (yyvsp[0]);
		} else {
			if (!error_ind) {
				set_currency_picture_symbol (yyvsp[-1]);
			}
		}
	}
  }
#line 13591 "parser.c" /* yacc.c:1652  */
    break;

  case 234:
#line 4630 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 13599 "parser.c" /* yacc.c:1652  */
    break;

  case 235:
#line 4634 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 13607 "parser.c" /* yacc.c:1652  */
    break;

  case 236:
#line 4643 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		check_repeated ("DECIMAL-POINT", SYN_CLAUSE_2, &check_duplicate);
		current_program->decimal_point = ',';
		current_program->numeric_separator = '.';
	}
  }
#line 13624 "parser.c" /* yacc.c:1652  */
    break;

  case 237:
#line 4662 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		current_program->flag_trailing_separate = 1;
	}
  }
#line 13639 "parser.c" /* yacc.c:1652  */
    break;

  case 238:
#line 4678 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		check_repeated ("CURSOR", SYN_CLAUSE_3, &check_duplicate);
		current_program->cursor_pos = yyvsp[0];
	}
  }
#line 13655 "parser.c" /* yacc.c:1652  */
    break;

  case 239:
#line 4696 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		check_repeated ("CRT STATUS", SYN_CLAUSE_4, &check_duplicate);
		current_program->crt_status = yyvsp[0];
	}
  }
#line 13671 "parser.c" /* yacc.c:1652  */
    break;

  case 240:
#line 4714 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		check_repeated ("SCREEN CONTROL", SYN_CLAUSE_5, &check_duplicate);
		CB_PENDING ("SCREEN CONTROL");
	}
  }
#line 13687 "parser.c" /* yacc.c:1652  */
    break;

  case 241:
#line 4731 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		check_repeated ("EVENT STATUS", SYN_CLAUSE_6, &check_duplicate);
		CB_PENDING ("EVENT STATUS");
	}
  }
#line 13703 "parser.c" /* yacc.c:1652  */
    break;

  case 242:
#line 4748 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	check_duplicate = 0;
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
		save_tree = NULL;
	} else {
		/* lookup system name
		   note: result in NULL + raised error if not found */
		save_tree = get_system_name ("TOP");
	}
  }
#line 13722 "parser.c" /* yacc.c:1652  */
    break;

  case 243:
#line 4763 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (save_tree && CB_VALID_TREE (yyvsp[0])) {
		cb_define (yyvsp[0], save_tree);
		CB_CHAIN_PAIR (current_program->mnemonic_spec_list,
				yyvsp[0], save_tree);
	}
  }
#line 13734 "parser.c" /* yacc.c:1652  */
    break;

  case 246:
#line 4783 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION, 0, 0, 0);
	header_check |= COBC_HD_INPUT_OUTPUT_SECTION;
  }
#line 13743 "parser.c" /* yacc.c:1652  */
    break;

  case 248:
#line 4793 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_INPUT_OUTPUT_SECTION, 0, 0);
	header_check |= COBC_HD_FILE_CONTROL;
  }
#line 13753 "parser.c" /* yacc.c:1652  */
    break;

  case 251:
#line 4806 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_INPUT_OUTPUT_SECTION,
			       COBC_HD_FILE_CONTROL, 0);
	check_duplicate = 0;
	if (CB_VALID_TREE (yyvsp[0])) {
		/* Build new file */
		current_file = build_file (yyvsp[0]);
		current_file->optional = CB_INTEGER (yyvsp[-1])->val;

		/* Add file to current program list */
		CB_ADD_TO_CHAIN (CB_TREE (current_file),
				 current_program->file_list);
	} else if (current_program->file_list) {
		current_program->file_list
			= CB_CHAIN (current_program->file_list);
	}
	key_type = NO_KEY;
  }
#line 13777 "parser.c" /* yacc.c:1652  */
    break;

  case 252:
#line 4826 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cobc_cs_check = 0;
	if (CB_VALID_TREE (yyvsp[-2])) {
		if (current_file->organization == COB_ORG_INDEXED
		    && key_type == RELATIVE_KEY) {
			cb_error_x (current_file->key,
				    _("cannot use RELATIVE KEY clause on INDEXED files"));
		} else if (current_file->organization == COB_ORG_RELATIVE
			   && key_type == RECORD_KEY) {
			cb_error_x (current_file->key,
				    _("cannot use RECORD KEY clause on RELATIVE files"));
		}

		validate_file (current_file, yyvsp[-2]);
	}
  }
#line 13798 "parser.c" /* yacc.c:1652  */
    break;

  case 254:
#line 4847 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyerrok;
  }
#line 13806 "parser.c" /* yacc.c:1652  */
    break;

  case 256:
#line 4854 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	/* reset context-sensitive words for next clauses */
	cobc_cs_check = CB_CS_SELECT;
  }
#line 13815 "parser.c" /* yacc.c:1652  */
    break;

  case 276:
#line 4907 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("ASSIGN", SYN_CLAUSE_1, &check_duplicate);
	if (ext_dyn_specified) {
		cb_error (_("EXTERNAL/DYNAMIC cannot be used with literals"));
	}

	current_file->assign_type = CB_ASSIGN_EXT_FILE_NAME_REQUIRED;
	current_file->assign = cb_build_assignment_name (current_file, yyvsp[0]);
  }
#line 13829 "parser.c" /* yacc.c:1652  */
    break;

  case 277:
#line 4917 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("ASSIGN", SYN_CLAUSE_1, &check_duplicate);

	/* current_file->assign_type is set by _ext_clause */
	if (!ext_dyn_specified) {
		current_file->flag_assign_no_keyword = 1;
	}
	current_file->assign = cb_build_assignment_name (current_file, yyvsp[0]);
  }
#line 13843 "parser.c" /* yacc.c:1652  */
    break;

  case 278:
#line 4927 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("ASSIGN", SYN_CLAUSE_1, &check_duplicate);
	if (ext_dyn_specified) {
		cb_error (_("EXTERNAL/DYNAMIC cannot be used with USING/VARYING"));
	}
        cb_verify (cb_assign_using_variable, "ASSIGN USING/VARYING variable");

	current_file->assign_type = CB_ASSIGN_VARIABLE_REQUIRED;
	current_file->assign = cb_build_assignment_name (current_file, yyvsp[0]);
  }
#line 13858 "parser.c" /* yacc.c:1652  */
    break;

  case 279:
#line 4938 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("ASSIGN", SYN_CLAUSE_1, &check_duplicate);
	if (ext_dyn_specified) {
		cb_error (_("EXTERNAL/DYNAMIC cannot be used with DISK FROM"));
	}
	cb_verify (cb_assign_disk_from, _("ASSIGN DISK FROM"));

	current_file->assign_type = CB_ASSIGN_VARIABLE_REQUIRED;
	current_file->assign = cb_build_assignment_name (current_file, yyvsp[0]);
  }
#line 13873 "parser.c" /* yacc.c:1652  */
    break;

  case 280:
#line 4949 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (assign_device == CB_ASSIGN_DISPLAY_DEVICE) {
		current_file->assign =
			cb_build_alphanumeric_literal ("stdout", (size_t)6);
		current_file->special = COB_SELECT_STDOUT;
	} else if (assign_device == CB_ASSIGN_KEYBOARD_DEVICE) {
		current_file->assign =
			cb_build_alphanumeric_literal ("stdin", (size_t)5);
		current_file->special = COB_SELECT_STDIN;
	} else if (assign_device == CB_ASSIGN_PRINTER_DEVICE) {
		current_file->organization = COB_ORG_LINE_SEQUENTIAL;
		current_file->assign =
			cb_build_alphanumeric_literal ("PRINTER", (size_t)7);
	} else if (assign_device == CB_ASSIGN_PRINTER_1_DEVICE) {
		current_file->organization = COB_ORG_LINE_SEQUENTIAL;
		current_file->assign =
			cb_build_alphanumeric_literal ("PRINTER-1", (size_t)9);
	} else if (assign_device == CB_ASSIGN_PRINT_DEVICE) {
		current_file->organization = COB_ORG_LINE_SEQUENTIAL;
		current_file->assign =
			cb_build_alphanumeric_literal ("LPT1", (size_t)4);
	} else if (assign_device == CB_ASSIGN_LINE_SEQ_DEVICE
		   || assign_device == CB_ASSIGN_GENERAL_DEVICE) {
		current_file->flag_fileid = 1;
	}
  }
#line 13904 "parser.c" /* yacc.c:1652  */
    break;

  case 281:
#line 4979 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	assign_device = CB_ASSIGN_NO_DEVICE;
  }
#line 13912 "parser.c" /* yacc.c:1652  */
    break;

  case 282:
#line 4983 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	assign_device = CB_ASSIGN_NO_DEVICE;
  }
#line 13920 "parser.c" /* yacc.c:1652  */
    break;

  case 284:
#line 4991 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	assign_device = CB_ASSIGN_GENERAL_DEVICE;
  }
#line 13928 "parser.c" /* yacc.c:1652  */
    break;

  case 285:
#line 4995 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_file->organization = COB_ORG_LINE_SEQUENTIAL;
	assign_device = CB_ASSIGN_LINE_SEQ_DEVICE;
  }
#line 13937 "parser.c" /* yacc.c:1652  */
    break;

  case 286:
#line 5000 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	assign_device = CB_ASSIGN_DISPLAY_DEVICE;
  }
#line 13945 "parser.c" /* yacc.c:1652  */
    break;

  case 287:
#line 5004 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	assign_device = CB_ASSIGN_KEYBOARD_DEVICE;
  }
#line 13953 "parser.c" /* yacc.c:1652  */
    break;

  case 288:
#line 5012 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	assign_device = CB_ASSIGN_PRINTER_DEVICE;
  }
#line 13961 "parser.c" /* yacc.c:1652  */
    break;

  case 289:
#line 5016 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	assign_device = CB_ASSIGN_PRINTER_1_DEVICE;
  }
#line 13969 "parser.c" /* yacc.c:1652  */
    break;

  case 290:
#line 5020 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	assign_device = CB_ASSIGN_PRINT_DEVICE;
  }
#line 13977 "parser.c" /* yacc.c:1652  */
    break;

  case 302:
#line 5045 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_file->flag_line_adv = 1;
  }
#line 13985 "parser.c" /* yacc.c:1652  */
    break;

  case 303:
#line 5052 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	ext_dyn_specified = 0;
	current_file->assign_type = cb_assign_type_default;
  }
#line 13994 "parser.c" /* yacc.c:1652  */
    break;

  case 304:
#line 5057 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	ext_dyn_specified = 1;
	cb_verify (cb_assign_ext_dyn, _("ASSIGN EXTERNAL/DYNAMIC"));
  }
#line 14003 "parser.c" /* yacc.c:1652  */
    break;

  case 305:
#line 5065 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_file->assign_type = CB_ASSIGN_EXT_FILE_NAME_REQUIRED;
  }
#line 14011 "parser.c" /* yacc.c:1652  */
    break;

  case 306:
#line 5069 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_file->assign_type = CB_ASSIGN_VARIABLE_REQUIRED;
  }
#line 14019 "parser.c" /* yacc.c:1652  */
    break;

  case 309:
#line 5083 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("ACCESS", SYN_CLAUSE_2, &check_duplicate);
  }
#line 14027 "parser.c" /* yacc.c:1652  */
    break;

  case 310:
#line 5089 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { current_file->access_mode = COB_ACCESS_SEQUENTIAL; }
#line 14033 "parser.c" /* yacc.c:1652  */
    break;

  case 311:
#line 5090 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { current_file->access_mode = COB_ACCESS_DYNAMIC; }
#line 14039 "parser.c" /* yacc.c:1652  */
    break;

  case 312:
#line 5091 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { current_file->access_mode = COB_ACCESS_RANDOM; }
#line 14045 "parser.c" /* yacc.c:1652  */
    break;

  case 313:
#line 5099 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	struct cb_alt_key *p;
	struct cb_alt_key *l;

	cb_tree composite_key;

	p = cobc_parse_malloc (sizeof (struct cb_alt_key));
	p->key = yyvsp[-4];
	p->component_list = NULL;
	if (yyvsp[-2]) {
		p->duplicates = CB_INTEGER (yyvsp[-2])->val;
	} else {
		/* note: we may add a compiler configuration here,
		         as at least ICOBOL defaults to WITH DUPLICATES
		         for ALTERNATE keys if not explicit deactivated
		*/
		p->duplicates = 0;
	}
	p->password = yyvsp[-1];
	if (yyvsp[0]) {
		p->tf_suppress = 1;
		p->char_suppress = CB_INTEGER (yyvsp[0])->val;
	} else {
		p->tf_suppress = 0;
	}
	p->next = NULL;

	/* handle split keys */
	if (yyvsp[-3]) {
		/* generate field (in w-s) for composite-key */
		composite_key = cb_build_field(yyvsp[-4]);
		if (composite_key == cb_error_node) {
			YYERROR;
		} else {
			composite_key->category = CB_CATEGORY_ALPHANUMERIC;
			((struct cb_field *)composite_key)->count = 1;
			p->key = cb_build_field_reference((struct cb_field *)composite_key, NULL);
			p->component_list = key_component_list;
		}
	}

	/* Add to the end of list */
	if (current_file->alt_key_list == NULL) {
		current_file->alt_key_list = p;
	} else {
		l = current_file->alt_key_list;
		for (; l->next; l = l->next) { ; }
		l->next = p;
	}
  }
#line 14100 "parser.c" /* yacc.c:1652  */
    break;

  case 314:
#line 5153 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 14108 "parser.c" /* yacc.c:1652  */
    break;

  case 316:
#line 5161 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("PASSWORD clause");
  }
#line 14116 "parser.c" /* yacc.c:1652  */
    break;

  case 317:
#line 5165 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 14124 "parser.c" /* yacc.c:1652  */
    break;

  case 318:
#line 5186 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 14132 "parser.c" /* yacc.c:1652  */
    break;

  case 319:
#line 5190 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int (literal_value (yyvsp[0]));
  }
#line 14140 "parser.c" /* yacc.c:1652  */
    break;

  case 320:
#line 5194 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int (literal_value (yyvsp[0]));
  }
#line 14148 "parser.c" /* yacc.c:1652  */
    break;

  case 321:
#line 5204 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("COLLATING", SYN_CLAUSE_3, &check_duplicate);
	current_file->collating_sequence = alphanumeric_collation;
	current_file->collating_sequence_n = national_collation;
	CB_PENDING ("FILE COLLATING SEQUENCE");
  }
#line 14159 "parser.c" /* yacc.c:1652  */
    break;

  case 322:
#line 5214 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	alphanumeric_collation = national_collation = NULL;
  }
#line 14167 "parser.c" /* yacc.c:1652  */
    break;

  case 324:
#line 5222 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	alphanumeric_collation = yyvsp[0];
  }
#line 14175 "parser.c" /* yacc.c:1652  */
    break;

  case 325:
#line 5226 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	alphanumeric_collation = yyvsp[-1];
	CB_PENDING_X (yyvsp[0], "NATIONAL COLLATING SEQUENCE");
	national_collation = yyvsp[0];
  }
#line 14185 "parser.c" /* yacc.c:1652  */
    break;

  case 326:
#line 5232 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	alphanumeric_collation = yyvsp[0];
  }
#line 14193 "parser.c" /* yacc.c:1652  */
    break;

  case 327:
#line 5236 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING_X (yyvsp[0], "NATIONAL COLLATING SEQUENCE");
	national_collation = yyvsp[0];
  }
#line 14202 "parser.c" /* yacc.c:1652  */
    break;

  case 328:
#line 5242 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	alphanumeric_collation = yyvsp[-4];
	CB_PENDING_X (yyvsp[0], "NATIONAL COLLATING SEQUENCE");
	national_collation = yyvsp[0];
  }
#line 14212 "parser.c" /* yacc.c:1652  */
    break;

  case 329:
#line 5249 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING_X (yyvsp[-4], "NATIONAL COLLATING SEQUENCE");
	national_collation = yyvsp[-4];
	alphanumeric_collation = yyvsp[0];
  }
#line 14222 "parser.c" /* yacc.c:1652  */
    break;

  case 330:
#line 5258 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	/* note: both entries must be resolved later on
	   and also attached to the correct key later, so just store in a list here: */
	current_file->collating_sequence_keys =
		cb_list_add(current_file->collating_sequence_keys, CB_BUILD_PAIR (yyvsp[0], yyvsp[-2]));
	CB_PENDING ("KEY COLLATING SEQUENCE");
  }
#line 14234 "parser.c" /* yacc.c:1652  */
    break;

  case 331:
#line 5269 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (CB_ALPHABET_NAME_P (cb_ref (yyvsp[0]))) {
		yyval = yyvsp[0];
	} else {
		cb_error_x (yyvsp[0], _("'%s' is not an alphabet-name"),
			cb_name (yyvsp[0]));
		yyval = cb_error_node;
	}
  }
#line 14248 "parser.c" /* yacc.c:1652  */
    break;

  case 332:
#line 5284 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("STATUS", SYN_CLAUSE_4, &check_duplicate);
	current_file->file_status = yyvsp[-1];
	if (yyvsp[0]) {
		/* add a compiler configuration if either */
		if (cb_std_define != CB_STD_IBM
		 && cb_std_define != CB_STD_MVS
		 && !cb_relaxed_syntax_checks) {
			cb_verify (CB_UNCONFORMABLE, "VSAM STATUS");
		} else {
			cb_warning (cb_warn_additional, _("%s ignored"), "VSAM STATUS");
		}
	}
  }
#line 14267 "parser.c" /* yacc.c:1652  */
    break;

  case 336:
#line 5309 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("LOCK", SYN_CLAUSE_5, &check_duplicate);
  }
#line 14275 "parser.c" /* yacc.c:1652  */
    break;

  case 338:
#line 5317 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_file->lock_mode |= COB_LOCK_MANUAL;
  }
#line 14283 "parser.c" /* yacc.c:1652  */
    break;

  case 339:
#line 5321 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_file->lock_mode |= COB_LOCK_AUTOMATIC;
  }
#line 14291 "parser.c" /* yacc.c:1652  */
    break;

  case 340:
#line 5325 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_file->lock_mode |= COB_LOCK_EXCLUSIVE;
  }
#line 14299 "parser.c" /* yacc.c:1652  */
    break;

  case 343:
#line 5334 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_file->lock_mode |= COB_LOCK_MULTIPLE;
  }
#line 14307 "parser.c" /* yacc.c:1652  */
    break;

  case 344:
#line 5338 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_file->lock_mode |= COB_LOCK_MULTIPLE;
  }
#line 14315 "parser.c" /* yacc.c:1652  */
    break;

  case 347:
#line 5349 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("WITH ROLLBACK");
  }
#line 14323 "parser.c" /* yacc.c:1652  */
    break;

  case 349:
#line 5356 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (current_file->organization == COB_ORG_INDEXED) {
		current_file->lock_mode |= COB_LOCK_EXCLUSIVE;
		/* TODO: pass extra flag to fileio */
		CB_PENDING ("WITH MASS-UPDATE");
	} else {
		cb_error (_("%s only valid with ORGANIZATION %s"), "MASS-UPDATE", "INDEXED");
	}
  }
#line 14337 "parser.c" /* yacc.c:1652  */
    break;

  case 352:
#line 5377 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("ORGANIZATION", SYN_CLAUSE_6, &check_duplicate);
	error_if_record_delimiter_incompatible (COB_ORG_INDEXED, "INDEXED");
	current_file->organization = COB_ORG_INDEXED;
  }
#line 14347 "parser.c" /* yacc.c:1652  */
    break;

  case 353:
#line 5383 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("ORGANIZATION", SYN_CLAUSE_6, &check_duplicate);
	error_if_record_delimiter_incompatible (COB_ORG_SEQUENTIAL, "SEQUENTIAL");
	current_file->organization = COB_ORG_SEQUENTIAL;
  }
#line 14357 "parser.c" /* yacc.c:1652  */
    break;

  case 354:
#line 5389 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("ORGANIZATION", SYN_CLAUSE_6, &check_duplicate);
	error_if_record_delimiter_incompatible (COB_ORG_RELATIVE, "RELATIVE");
	current_file->organization = COB_ORG_RELATIVE;
  }
#line 14367 "parser.c" /* yacc.c:1652  */
    break;

  case 355:
#line 5395 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("ORGANIZATION", SYN_CLAUSE_6, &check_duplicate);
	error_if_record_delimiter_incompatible (COB_ORG_LINE_SEQUENTIAL,
						"LINE SEQUENTIAL");
	current_file->organization = COB_ORG_LINE_SEQUENTIAL;
  }
#line 14378 "parser.c" /* yacc.c:1652  */
    break;

  case 356:
#line 5408 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("PADDING", SYN_CLAUSE_7, &check_duplicate);
	cb_verify (cb_padding_character_clause, "PADDING CHARACTER");
  }
#line 14387 "parser.c" /* yacc.c:1652  */
    break;

  case 357:
#line 5418 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("RECORD DELIMITER", SYN_CLAUSE_8, &check_duplicate);
	current_file->flag_delimiter = 1;
  }
#line 14396 "parser.c" /* yacc.c:1652  */
    break;

  case 359:
#line 5427 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (current_file->organization != COB_ORG_SEQUENTIAL) {
		cb_error (_("RECORD DELIMITER %s only allowed with SEQUENTIAL files"),
			  "STANDARD-1");
	} else if (cb_verify (cb_record_delimiter, _("RECORD DELIMITER clause"))) {
		cb_warning (cb_warn_additional,
			    _("%s ignored"), "RECORD DELIMITER STANDARD-1");
	}
  }
#line 14410 "parser.c" /* yacc.c:1652  */
    break;

  case 360:
#line 5437 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (current_file->organization != COB_ORG_SEQUENTIAL
	    && current_file->organization != COB_ORG_LINE_SEQUENTIAL) {
		cb_error (_("RECORD DELIMITER %s only allowed with (LINE) SEQUENTIAL files"),
			  "LINE-SEQUENTIAL");
	}

	if (cb_verify (cb_record_delimiter, _("RECORD DELIMITER clause"))
	    && cb_verify (cb_sequential_delimiters, _("LINE-SEQUENTIAL phrase"))) {
		current_file->organization = COB_ORG_LINE_SEQUENTIAL;
	}
  }
#line 14427 "parser.c" /* yacc.c:1652  */
    break;

  case 361:
#line 5450 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (current_file->organization != COB_ORG_SEQUENTIAL) {
		cb_error (_("RECORD DELIMITER %s only allowed with SEQUENTIAL files"),
			  "BINARY-SEQUENTIAL");
	}

	if (cb_verify (cb_record_delimiter, _("RECORD DELIMITER clause"))
	    && cb_verify (cb_sequential_delimiters, _("BINARY-SEQUENTIAL phrase"))) {
		current_file->organization = COB_ORG_SEQUENTIAL;
	}
  }
#line 14443 "parser.c" /* yacc.c:1652  */
    break;

  case 362:
#line 5462 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (current_file->organization != COB_ORG_SEQUENTIAL
	 && current_file->organization != COB_ORG_LINE_SEQUENTIAL) {
		cb_error (_("RECORD DELIMITER clause only allowed with (LINE) SEQUENTIAL files"));
	} else if (cb_verify (cb_record_delimiter, _("RECORD DELIMITER clause"))) {
		cb_warning (cb_warn_additional,
			    _("RECORD DELIMITER %s not recognized; will be ignored"), cb_name (yyvsp[0]));
	}
  }
#line 14457 "parser.c" /* yacc.c:1652  */
    break;

  case 363:
#line 5477 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_tree composite_key;

	check_repeated ("RECORD KEY", SYN_CLAUSE_9, &check_duplicate);
	current_file->key = yyvsp[-3];
	key_type = RECORD_KEY;

	/* handle split keys */
	if (yyvsp[-2]) {
		/* generate field (in w-s) for composite-key */
		composite_key = cb_build_field (yyvsp[-3]);
		if (composite_key == cb_error_node) {
			YYERROR;
		} else {
			composite_key->category = CB_CATEGORY_ALPHANUMERIC;
			((struct cb_field *)composite_key)->count = 1;
			current_file->key = cb_build_field_reference ((struct cb_field *)composite_key, NULL);
			current_file->component_list = key_component_list;
		}
	}
	current_file->password = yyvsp[-1];
	if (yyvsp[0]) {
		/* note: we *may* add a compiler configuration here,
		         as most dialects do not allow this clause
		         on primary keys */
		if (CB_INTEGER (yyvsp[0])->val) {
			/* note: see ACUCOBOL docs for implementation notes, including [RE]WRITE rules
			         and "if the underlying (file) system does not support them OPEN
					 result in (sucessfull) io-status 0M" */
			CB_PENDING (_("DUPLICATES for primary keys"));
		};

	}
  }
#line 14496 "parser.c" /* yacc.c:1652  */
    break;

  case 364:
#line 5515 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
  	yyval = NULL;
  }
#line 14504 "parser.c" /* yacc.c:1652  */
    break;

  case 365:
#line 5519 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
  	yyval = cb_int0;
  }
#line 14512 "parser.c" /* yacc.c:1652  */
    break;

  case 368:
#line 5530 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	key_component_list = NULL;
  }
#line 14520 "parser.c" /* yacc.c:1652  */
    break;

  case 371:
#line 5540 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	struct cb_key_component *c;
	struct cb_key_component *comp = cobc_main_malloc (sizeof(struct cb_key_component));
	comp->next = NULL;
	comp->component = yyvsp[0];
	if (key_component_list == NULL) {
		key_component_list = comp;
	} else {
		for (c = key_component_list; c->next != NULL; c = c->next);
		c->next = comp;
	}
  }
#line 14537 "parser.c" /* yacc.c:1652  */
    break;

  case 372:
#line 5558 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("RELATIVE KEY", SYN_CLAUSE_10, &check_duplicate);
	current_file->key = yyvsp[0];
	key_type = RELATIVE_KEY;
  }
#line 14547 "parser.c" /* yacc.c:1652  */
    break;

  case 373:
#line 5569 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("RESERVE", SYN_CLAUSE_11, &check_duplicate);
  }
#line 14555 "parser.c" /* yacc.c:1652  */
    break;

  case 376:
#line 5583 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("SHARING", SYN_CLAUSE_12, &check_duplicate);
	current_file->sharing = yyvsp[0];
  }
#line 14564 "parser.c" /* yacc.c:1652  */
    break;

  case 377:
#line 5595 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 14570 "parser.c" /* yacc.c:1652  */
    break;

  case 378:
#line 5596 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_int (COB_LOCK_OPEN_EXCLUSIVE); }
#line 14576 "parser.c" /* yacc.c:1652  */
    break;

  case 379:
#line 5597 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 14582 "parser.c" /* yacc.c:1652  */
    break;

  case 380:
#line 5604 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	(void)cb_verify (CB_OBSOLETE, "FILE-LIMIT");
	check_repeated ("FILE-LIMIT", SYN_CLAUSE_13, &check_duplicate);
  }
#line 14591 "parser.c" /* yacc.c:1652  */
    break;

  case 383:
#line 5619 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	(void)cb_verify (CB_OBSOLETE, "ACTUAL KEY");
	check_repeated ("ACTUAL KEY", SYN_CLAUSE_14, &check_duplicate);
  }
#line 14600 "parser.c" /* yacc.c:1652  */
    break;

  case 384:
#line 5629 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	(void)cb_verify (CB_OBSOLETE, "NOMINAL KEY");
	check_repeated ("NOMINAL KEY", SYN_CLAUSE_15, &check_duplicate);
  }
#line 14609 "parser.c" /* yacc.c:1652  */
    break;

  case 385:
#line 5639 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	(void)cb_verify (CB_OBSOLETE, "TRACK-AREA");
	check_repeated ("TRACK-AREA", SYN_CLAUSE_16, &check_duplicate);
  }
#line 14618 "parser.c" /* yacc.c:1652  */
    break;

  case 386:
#line 5649 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	(void)cb_verify (CB_OBSOLETE, "TRACK-LIMIT");
	check_repeated ("TRACK-LIMIT", SYN_CLAUSE_17, &check_duplicate);
  }
#line 14627 "parser.c" /* yacc.c:1652  */
    break;

  case 388:
#line 5660 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cobc_cs_check = 0;
  }
#line 14635 "parser.c" /* yacc.c:1652  */
    break;

  case 389:
#line 5667 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_headers_present(COBC_HD_ENVIRONMENT_DIVISION,
				 COBC_HD_INPUT_OUTPUT_SECTION, 0, 0);
	header_check |= COBC_HD_I_O_CONTROL;
}
#line 14645 "parser.c" /* yacc.c:1652  */
    break;

  case 392:
#line 5677 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyerrok;
  }
#line 14653 "parser.c" /* yacc.c:1652  */
    break;

  case 399:
#line 5698 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_tree l;

	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_INPUT_OUTPUT_SECTION,
			       COBC_HD_I_O_CONTROL, 0);
	switch (CB_INTEGER (yyvsp[-3])->val) {
	case 0:
		/* SAME AREA */
		break;
	case 1:
		/* SAME RECORD */
		for (l = yyvsp[0]; l; l = CB_CHAIN (l)) {
			if (CB_VALID_TREE (CB_VALUE (l))) {
				CB_FILE (cb_ref (CB_VALUE (l)))->same_clause = same_area;
			}
		}
		same_area++;
		break;
	case 2:
		/* SAME SORT-MERGE */
		break;
	}
  }
#line 14682 "parser.c" /* yacc.c:1652  */
    break;

  case 400:
#line 5725 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_int0; }
#line 14688 "parser.c" /* yacc.c:1652  */
    break;

  case 401:
#line 5726 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_int1; }
#line 14694 "parser.c" /* yacc.c:1652  */
    break;

  case 402:
#line 5727 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_int2; }
#line 14700 "parser.c" /* yacc.c:1652  */
    break;

  case 403:
#line 5728 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_int2; }
#line 14706 "parser.c" /* yacc.c:1652  */
    break;

  case 404:
#line 5735 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_program->apply_commit = yyvsp[0];
	CB_PENDING("APPLY COMMIT");
  }
#line 14715 "parser.c" /* yacc.c:1652  */
    break;

  case 405:
#line 5740 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("APPLY LOCK-HOLDING");
  }
#line 14723 "parser.c" /* yacc.c:1652  */
    break;

  case 406:
#line 5744 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("APPLY PRINT-CONTROL");
  }
#line 14731 "parser.c" /* yacc.c:1652  */
    break;

  case 408:
#line 5749 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_verify (CB_OBSOLETE, _("DOS/VS APPLY phrase"));
  }
#line 14739 "parser.c" /* yacc.c:1652  */
    break;

  case 417:
#line 5769 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	/* Fake for TAPE */
	cobc_cs_check = CB_CS_ASSIGN;
  }
#line 14748 "parser.c" /* yacc.c:1652  */
    break;

  case 418:
#line 5774 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_INPUT_OUTPUT_SECTION,
			       COBC_HD_I_O_CONTROL, 0);
	cb_verify (cb_multiple_file_tape_clause, "MULTIPLE FILE TAPE");
	cobc_cs_check = 0;
  }
#line 14760 "parser.c" /* yacc.c:1652  */
    break;

  case 428:
#line 5817 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_storage = CB_STORAGE_WORKING;
  }
#line 14768 "parser.c" /* yacc.c:1652  */
    break;

  case 432:
#line 5834 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	header_check |= COBC_HD_DATA_DIVISION;
  }
#line 14776 "parser.c" /* yacc.c:1652  */
    break;

  case 434:
#line 5843 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_storage = CB_STORAGE_FILE;
	check_headers_present (COBC_HD_DATA_DIVISION, 0, 0, 0);
	header_check |= COBC_HD_FILE_SECTION;
  }
#line 14786 "parser.c" /* yacc.c:1652  */
    break;

  case 437:
#line 5857 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (CB_VALID_TREE (current_file)) {
		if (CB_VALID_TREE (yyvsp[0])) {
			/* Do not keep Record if this is really a report */
			if (!current_file->reports) {
				finalize_file (current_file, CB_FIELD (yyvsp[0]));
			}
		} else if (!current_file->reports) {
			cb_error (_("RECORD description missing or invalid"));
		}
	}
  }
#line 14803 "parser.c" /* yacc.c:1652  */
    break;

  case 438:
#line 5875 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_storage = CB_STORAGE_FILE;
	check_headers_present (COBC_HD_DATA_DIVISION,
			       COBC_HD_FILE_SECTION, 0, 0);
	check_duplicate = 0;
	if (CB_INVALID_TREE (yyvsp[0])) {
		current_file = NULL;
		YYERROR;
	}
	current_file = CB_FILE (cb_ref (yyvsp[0]));
	if (CB_VALID_TREE (current_file)) {
		if (yyvsp[-1] == cb_int1) {
			current_file->organization = COB_ORG_SORT;
		}
		/* note: this is a HACK and should be moved */
		if (current_file->flag_finalized) {
			cb_error_x (yyvsp[0], _("duplicate file description for %s"),
				cb_name (CB_TREE (current_file)));
		}
	}
  }
#line 14829 "parser.c" /* yacc.c:1652  */
    break;

  case 440:
#line 5898 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyerrok;
  }
#line 14837 "parser.c" /* yacc.c:1652  */
    break;

  case 441:
#line 5905 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int0;
  }
#line 14845 "parser.c" /* yacc.c:1652  */
    break;

  case 442:
#line 5909 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int1;
  }
#line 14853 "parser.c" /* yacc.c:1652  */
    break;

  case 445:
#line 5920 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("EXTERNAL", SYN_CLAUSE_1, &check_duplicate);
#if	0	/* RXWRXW - Global/External */
	if (current_file->flag_global) {
		cb_error (_("file cannot have both EXTERNAL and GLOBAL clauses"));
	}
#endif
	current_file->flag_external = 1;
  }
#line 14867 "parser.c" /* yacc.c:1652  */
    break;

  case 446:
#line 5930 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("GLOBAL", SYN_CLAUSE_2, &check_duplicate);
#if	0	/* RXWRXW - Global/External */
	if (current_file->flag_external) {
		cb_error (_("file cannot have both EXTERNAL and GLOBAL clauses"));
	}
#endif
	if (current_program->prog_type == COB_MODULE_TYPE_FUNCTION) {
		cb_error (_("%s is invalid in a user FUNCTION"), "GLOBAL");
	} else {
		current_file->flag_global = 1;
		current_program->flag_file_global = 1;
	}
  }
#line 14886 "parser.c" /* yacc.c:1652  */
    break;

  case 456:
#line 5960 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("BLOCK", SYN_CLAUSE_3, &check_duplicate);
	/* ignore */
  }
#line 14895 "parser.c" /* yacc.c:1652  */
    break;

  case 460:
#line 5973 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("RECORD", SYN_CLAUSE_4, &check_duplicate);
	if (current_file->organization == COB_ORG_LINE_SEQUENTIAL) {
		cb_warning (cb_warn_additional, _("RECORD clause ignored for LINE SEQUENTIAL"));
	} else {
		set_record_size (NULL, yyvsp[-1]);
	}
  }
#line 14908 "parser.c" /* yacc.c:1652  */
    break;

  case 461:
#line 5982 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("RECORD", SYN_CLAUSE_4, &check_duplicate);
	if (current_file->organization == COB_ORG_LINE_SEQUENTIAL) {
		cb_warning (cb_warn_additional, _("RECORD clause ignored for LINE SEQUENTIAL"));
	} else {
		set_record_size (yyvsp[-3], yyvsp[-1]);
	}
  }
#line 14921 "parser.c" /* yacc.c:1652  */
    break;

  case 462:
#line 5992 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("RECORD", SYN_CLAUSE_4, &check_duplicate);
	set_record_size (yyvsp[-3], yyvsp[-2]);
	current_file->flag_check_record_varying_limits =
		current_file->record_min == 0 || current_file->record_max == 0;
  }
#line 14932 "parser.c" /* yacc.c:1652  */
    break;

  case 464:
#line 6002 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_file->record_depending = yyvsp[0];
  }
#line 14940 "parser.c" /* yacc.c:1652  */
    break;

  case 465:
#line 6008 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 14946 "parser.c" /* yacc.c:1652  */
    break;

  case 466:
#line 6009 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 14952 "parser.c" /* yacc.c:1652  */
    break;

  case 467:
#line 6013 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 14958 "parser.c" /* yacc.c:1652  */
    break;

  case 468:
#line 6014 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 14964 "parser.c" /* yacc.c:1652  */
    break;

  case 469:
#line 6022 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("LABEL", SYN_CLAUSE_5, &check_duplicate);
	cb_verify (cb_label_records_clause, "LABEL RECORDS");
  }
#line 14973 "parser.c" /* yacc.c:1652  */
    break;

  case 470:
#line 6033 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("VALUE OF", SYN_CLAUSE_6, &check_duplicate);
	cb_verify (cb_value_of_clause, "VALUE OF");
  }
#line 14982 "parser.c" /* yacc.c:1652  */
    break;

  case 471:
#line 6038 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("VALUE OF", SYN_CLAUSE_6, &check_duplicate);
	cb_verify (cb_value_of_clause, "VALUE OF");
	if (!current_file->assign) {
		current_file->assign = cb_build_assignment_name (current_file, yyvsp[0]);
	}
  }
#line 14994 "parser.c" /* yacc.c:1652  */
    break;

  case 476:
#line 6061 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("DATA", SYN_CLAUSE_7, &check_duplicate);
	cb_verify (cb_data_records_clause, "DATA RECORDS");
  }
#line 15003 "parser.c" /* yacc.c:1652  */
    break;

  case 477:
#line 6073 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("LINAGE", SYN_CLAUSE_8, &check_duplicate);
	if (current_file->organization != COB_ORG_LINE_SEQUENTIAL &&
	    current_file->organization != COB_ORG_SEQUENTIAL) {
		cb_error (_("LINAGE clause with wrong file type"));
	} else {
		current_file->linage = yyvsp[-2];
		current_file->organization = COB_ORG_LINE_SEQUENTIAL;
		if (current_linage == 0) {
			linage_file = current_file;
		}
		current_linage++;
	}
  }
#line 15022 "parser.c" /* yacc.c:1652  */
    break;

  case 483:
#line 6101 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_file->latfoot = yyvsp[0];
  }
#line 15030 "parser.c" /* yacc.c:1652  */
    break;

  case 484:
#line 6108 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_file->lattop = yyvsp[0];
  }
#line 15038 "parser.c" /* yacc.c:1652  */
    break;

  case 485:
#line 6115 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_file->latbot = yyvsp[0];
  }
#line 15046 "parser.c" /* yacc.c:1652  */
    break;

  case 486:
#line 6124 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cobc_cs_check ^= CB_CS_RECORDING;
	check_repeated ("RECORDING", SYN_CLAUSE_9, &check_duplicate);
	/* ignore */
  }
#line 15056 "parser.c" /* yacc.c:1652  */
    break;

  case 491:
#line 6137 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (current_file->organization != COB_ORG_SEQUENTIAL) {
		cb_error (_("RECORDING MODE U or S can only be used with RECORD SEQUENTIAL files"));
	}
  }
#line 15066 "parser.c" /* yacc.c:1652  */
    break;

  case 494:
#line 6153 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	struct cb_alphabet_name	*al;

	check_repeated ("CODE SET", SYN_CLAUSE_10, &check_duplicate);

	if (CB_VALID_TREE (yyvsp[-1])) {
		al = CB_ALPHABET_NAME (cb_ref (yyvsp[-1]));
		switch (al->alphabet_type) {
#ifdef	COB_EBCDIC_MACHINE
		case CB_ALPHABET_ASCII:
#else
		case CB_ALPHABET_EBCDIC:
#endif
		case CB_ALPHABET_CUSTOM:
			current_file->code_set = al;
			CB_PENDING ("CODE-SET");
			break;
		default:
			if (cb_warn_additional) {
				cb_warning_x (cb_warn_additional, yyvsp[-1], _("ignoring CODE-SET '%s'"),
						  cb_name (yyvsp[-1]));
			} else {
				CB_PENDING ("CODE-SET");
			}
			break;
		}
	}

	if (current_file->organization != COB_ORG_LINE_SEQUENTIAL &&
	    current_file->organization != COB_ORG_SEQUENTIAL) {
		cb_error (_("CODE-SET clause invalid for file type"));
	}

  }
#line 15105 "parser.c" /* yacc.c:1652  */
    break;

  case 496:
#line 6191 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	  CB_PENDING ("FOR sub-records");
	  current_file->code_set_items = CB_LIST (yyvsp[0]);
  }
#line 15114 "parser.c" /* yacc.c:1652  */
    break;

  case 497:
#line 6201 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("REPORT", SYN_CLAUSE_11, &check_duplicate);
	if (current_file->organization != COB_ORG_LINE_SEQUENTIAL &&
	    current_file->organization != COB_ORG_SEQUENTIAL) {
		cb_error (_("REPORT clause with wrong file type"));
	} else {
		current_file->reports = yyvsp[0];
		current_file->organization = COB_ORG_LINE_SEQUENTIAL;
		current_file->flag_line_adv = 1;
	}
  }
#line 15130 "parser.c" /* yacc.c:1652  */
    break;

  case 500:
#line 6221 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (CB_VALID_TREE (yyvsp[0])) {
		current_report = build_report (yyvsp[0]);
		current_report->file = current_file;
		current_program->report_list =
			cb_list_add (current_program->report_list,
				     CB_TREE (current_report));
		if (report_count == 0) {
			report_instance = current_report;
		}
		report_count++;
	}
  }
#line 15148 "parser.c" /* yacc.c:1652  */
    break;

  case 501:
#line 6235 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (CB_VALID_TREE (yyvsp[0])) {
		current_report = build_report (yyvsp[0]);
		current_report->file = current_file;
		current_program->report_list =
			cb_list_add (current_program->report_list,
				     CB_TREE (current_report));
		if (report_count == 0) {
			report_instance = current_report;
		}
		report_count++;
	}
  }
#line 15166 "parser.c" /* yacc.c:1652  */
    break;

  case 503:
#line 6254 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_storage = CB_STORAGE_COMMUNICATION;
	check_headers_present (COBC_HD_DATA_DIVISION, 0, 0, 0);
	header_check |= COBC_HD_COMMUNICATION_SECTION;
	/* add a compiler configuration if either */
	if (cb_std_define != CB_STD_85
	 && cb_std_define != CB_STD_RM
	 && cb_std_define != CB_STD_GC
	 && !cb_relaxed_syntax_checks) {
		cb_verify (CB_UNCONFORMABLE, "COMMUNICATION SECTION");
	} else if (cb_verify (CB_OBSOLETE, "COMMUNICATION SECTION")) {
		CB_PENDING ("COMMUNICATION SECTION");
	}
  }
#line 15185 "parser.c" /* yacc.c:1652  */
    break;

  case 507:
#line 6278 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (CB_VALID_TREE (current_cd)) {
		if (CB_VALID_TREE (yyvsp[0])) {
			cb_finalize_cd (current_cd, CB_FIELD (yyvsp[0]));
		} else if (!current_cd->record) {
			cb_error (_("CD record missing"));
		}
	}
  }
#line 15199 "parser.c" /* yacc.c:1652  */
    break;

  case 508:
#line 6293 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	/* CD internally defines a new file */
	if (CB_VALID_TREE (yyvsp[0])) {
		current_cd = cb_build_cd (yyvsp[0]);

		CB_ADD_TO_CHAIN (CB_TREE (current_cd),
				 current_program->cd_list);
	} else {
		current_cd = NULL;
		/* TO-DO: Is this necessary? */
		if (current_program->cd_list) {
			current_program->cd_list
				= CB_CHAIN (current_program->cd_list);
		}
	}
	check_duplicate = 0;
  }
#line 15221 "parser.c" /* yacc.c:1652  */
    break;

  case 556:
#line 6401 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_headers_present (COBC_HD_DATA_DIVISION, 0, 0, 0);
	header_check |= COBC_HD_WORKING_STORAGE_SECTION;
	current_storage = CB_STORAGE_WORKING;
  }
#line 15231 "parser.c" /* yacc.c:1652  */
    break;

  case 557:
#line 6407 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[0]) {
		CB_FIELD_ADD (current_program->working_storage, CB_FIELD (yyvsp[0]));
	}
  }
#line 15241 "parser.c" /* yacc.c:1652  */
    break;

  case 558:
#line 6416 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 15249 "parser.c" /* yacc.c:1652  */
    break;

  case 559:
#line 6420 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_field = NULL;
	control_field = NULL;
	description_field = NULL;
	cb_clear_real_field ();
  }
#line 15260 "parser.c" /* yacc.c:1652  */
    break;

  case 560:
#line 6427 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = get_finalized_description_tree ();
  }
#line 15268 "parser.c" /* yacc.c:1652  */
    break;

  case 566:
#line 6442 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (current_field && !CB_INVALID_TREE (current_field->external_definition)) {
		/* finalize last field if target of SAME AS / type-name */
		inherit_external_definition (yyvsp[-1]);
	}
	if (set_current_field (yyvsp[-1], yyvsp[0])) {
		YYERROR;
	}
	save_tree = NULL;
  }
#line 15283 "parser.c" /* yacc.c:1652  */
    break;

  case 567:
#line 6453 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (!qualifier) {
		current_field->flag_filler = 1;
	}
	if (!description_field) {
		description_field = current_field;
	}
  }
#line 15296 "parser.c" /* yacc.c:1652  */
    break;

  case 568:
#line 6462 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
#if 0 /* works fine without, leads to invalid free otherwise [COB_TREE_DEBUG] */
	/* Free tree associated with level number */
	cobc_parse_free (yyvsp[-2]);
#endif
	yyerrok;
	cb_unput_dot ();
	check_pic_duplicate = 0;
	check_duplicate = 0;
#if 0 /* CHECKME - *Why* would we want to change the field here? */
	current_field = cb_get_real_field ();
#endif
  }
#line 15314 "parser.c" /* yacc.c:1652  */
    break;

  case 569:
#line 6479 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 15322 "parser.c" /* yacc.c:1652  */
    break;

  case 572:
#line 6491 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_build_filler ();
	qualifier = NULL;
	keys_list = NULL;
	non_const_word = 0;
  }
#line 15333 "parser.c" /* yacc.c:1652  */
    break;

  case 574:
#line 6502 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
	qualifier = yyvsp[0];
	keys_list = NULL;
	non_const_word = 0;
  }
#line 15344 "parser.c" /* yacc.c:1652  */
    break;

  case 575:
#line 6512 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 15352 "parser.c" /* yacc.c:1652  */
    break;

  case 576:
#line 6516 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (current_program->prog_type == COB_MODULE_TYPE_FUNCTION) {
		cb_error (_("%s is invalid in a user FUNCTION"), "GLOBAL");
		yyval = NULL;
	} else {
		yyval = cb_null;
	}
  }
#line 15365 "parser.c" /* yacc.c:1652  */
    break;

  case 577:
#line 6527 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 15371 "parser.c" /* yacc.c:1652  */
    break;

  case 578:
#line 6528 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_build_const_length (yyvsp[0]); }
#line 15377 "parser.c" /* yacc.c:1652  */
    break;

  case 579:
#line 6530 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_build_const_length (yyvsp[0]); }
#line 15383 "parser.c" /* yacc.c:1652  */
    break;

  case 580:
#line 6535 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 15391 "parser.c" /* yacc.c:1652  */
    break;

  case 581:
#line 6539 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 15399 "parser.c" /* yacc.c:1652  */
    break;

  case 582:
#line 6545 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int1;
  }
#line 15407 "parser.c" /* yacc.c:1652  */
    break;

  case 583:
#line 6549 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int2;
  }
#line 15415 "parser.c" /* yacc.c:1652  */
    break;

  case 584:
#line 6553 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int4;
  }
#line 15423 "parser.c" /* yacc.c:1652  */
    break;

  case 585:
#line 6557 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int8;
  }
#line 15431 "parser.c" /* yacc.c:1652  */
    break;

  case 586:
#line 6561 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int ((int)sizeof(long));
  }
#line 15439 "parser.c" /* yacc.c:1652  */
    break;

  case 587:
#line 6565 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int ((int)sizeof(void *));
  }
#line 15447 "parser.c" /* yacc.c:1652  */
    break;

  case 588:
#line 6569 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (cb_binary_comp_1) {
		yyval = cb_int2;
	} else {
		yyval = cb_int ((int)sizeof(float));
	}
  }
#line 15459 "parser.c" /* yacc.c:1652  */
    break;

  case 589:
#line 6577 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int ((int)sizeof(float));
  }
#line 15467 "parser.c" /* yacc.c:1652  */
    break;

  case 590:
#line 6581 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int ((int)sizeof(double));
  }
#line 15475 "parser.c" /* yacc.c:1652  */
    break;

  case 591:
#line 6585 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int4;
  }
#line 15483 "parser.c" /* yacc.c:1652  */
    break;

  case 592:
#line 6589 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int8;
  }
#line 15491 "parser.c" /* yacc.c:1652  */
    break;

  case 593:
#line 6593 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int16;
  }
#line 15499 "parser.c" /* yacc.c:1652  */
    break;

  case 594:
#line 6597 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyerrok;
	cb_unput_dot ();
	check_pic_duplicate = 0;
	check_duplicate = 0;
	current_field = cb_get_real_field ();
  }
#line 15511 "parser.c" /* yacc.c:1652  */
    break;

  case 604:
#line 6629 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_tree renames_target = cb_ref (yyvsp[-1]);

	size_t sav = cb_needs_01;
	cb_needs_01 = 0;

	non_const_word = 0;

	if (set_current_field (yyvsp[-5], yyvsp[-4])) {
		/* error in the definition, no further checks possible */
	} else if (renames_target == cb_error_node) {
		/* error in the target, skip further checks */
		current_field->flag_invalid = 1;
	} else {
		cb_tree renames_thru = yyvsp[0];

		current_field->redefines = CB_FIELD (renames_target);
		if (renames_thru) {
			renames_thru = cb_ref (renames_thru);
		}
		if (CB_VALID_TREE (renames_thru)) {
			current_field->rename_thru = CB_FIELD (renames_thru);
		} else {
			/* If there is no THRU clause, RENAMES acts like REDEFINES. */
			current_field->pic = current_field->redefines->pic;
		}

		if (cb_validate_renames_item (current_field, yyvsp[-1], yyvsp[0])) {
			current_field->flag_invalid = 1;
		} else {
			/* ensure the reference was validated as this
			   also calculates the reference' picture and size */
			if (!current_field->redefines->flag_is_verified) {
				cb_validate_field (current_field->redefines);
			}
		}
	}
	cb_needs_01 = sav;
  }
#line 15555 "parser.c" /* yacc.c:1652  */
    break;

  case 605:
#line 6672 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 15563 "parser.c" /* yacc.c:1652  */
    break;

  case 606:
#line 6676 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0] == cb_error_node ? NULL : yyvsp[0];
  }
#line 15571 "parser.c" /* yacc.c:1652  */
    break;

  case 607:
#line 6683 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (set_current_field (yyvsp[-1], yyvsp[0])) {
		YYERROR;
	}
  }
#line 15581 "parser.c" /* yacc.c:1652  */
    break;

  case 608:
#line 6689 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_validate_88_item (current_field);
  }
#line 15589 "parser.c" /* yacc.c:1652  */
    break;

  case 609:
#line 6696 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_tree x;
	int	level;

	cobc_cs_check = 0;
	level = cb_get_level (yyvsp[-4]);
	/* Free tree associated with level number */
	cobc_parse_free (yyvsp[-4]);
	if (level != 1) {
		cb_error (_("CONSTANT item not at 01 level"));
	} else if (yyvsp[0]) {
		if (cb_verify(cb_constant_01, "01 CONSTANT")) {
			x = cb_build_constant (yyvsp[-3], yyvsp[0]);
			CB_FIELD (x)->flag_item_78 = 1;
			CB_FIELD (x)->flag_constant = 1;
			CB_FIELD (x)->level = 1;
			CB_FIELD (x)->values = yyvsp[0];
			cb_needs_01 = 1;
			if (yyvsp[-1]) {
				CB_FIELD (x)->flag_is_global = 1;
			}
			/* Ignore return value */
			(void)cb_validate_78_item (CB_FIELD (x), 0);
		}
	}
  }
#line 15620 "parser.c" /* yacc.c:1652  */
    break;

  case 610:
#line 6723 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (set_current_field (yyvsp[-1], yyvsp[0])) {
		YYERROR;
	}
  }
#line 15630 "parser.c" /* yacc.c:1652  */
    break;

  case 611:
#line 6730 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	/* Reset to last non-78 item */
	current_field = cb_validate_78_item (current_field, 0);
  }
#line 15639 "parser.c" /* yacc.c:1652  */
    break;

  case 612:
#line 6738 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 15647 "parser.c" /* yacc.c:1652  */
    break;

  case 613:
#line 6742 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = CB_LIST_INIT(cb_build_const_from (yyvsp[0]));
  }
#line 15655 "parser.c" /* yacc.c:1652  */
    break;

  case 614:
#line 6749 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (CB_VALID_TREE (current_field)) {
		current_field->values = yyvsp[0];
	}
  }
#line 15665 "parser.c" /* yacc.c:1652  */
    break;

  case 615:
#line 6755 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_field->values = CB_LIST_INIT (cb_build_const_start (current_field, yyvsp[0]));
  }
#line 15673 "parser.c" /* yacc.c:1652  */
    break;

  case 616:
#line 6759 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_field->values = CB_LIST_INIT (cb_build_const_next (current_field));
  }
#line 15681 "parser.c" /* yacc.c:1652  */
    break;

  case 617:
#line 6765 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = CB_LIST_INIT (yyvsp[0]); }
#line 15687 "parser.c" /* yacc.c:1652  */
    break;

  case 618:
#line 6766 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_list_add (yyvsp[-1], yyvsp[0]); }
#line 15693 "parser.c" /* yacc.c:1652  */
    break;

  case 619:
#line 6770 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 15699 "parser.c" /* yacc.c:1652  */
    break;

  case 620:
#line 6771 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_build_alphanumeric_literal ("(", 1); }
#line 15705 "parser.c" /* yacc.c:1652  */
    break;

  case 621:
#line 6772 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_build_alphanumeric_literal (")", 1); }
#line 15711 "parser.c" /* yacc.c:1652  */
    break;

  case 622:
#line 6773 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_build_alphanumeric_literal ("+", 1); }
#line 15717 "parser.c" /* yacc.c:1652  */
    break;

  case 623:
#line 6774 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_build_alphanumeric_literal ("-", 1); }
#line 15723 "parser.c" /* yacc.c:1652  */
    break;

  case 624:
#line 6775 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_build_alphanumeric_literal ("*", 1); }
#line 15729 "parser.c" /* yacc.c:1652  */
    break;

  case 625:
#line 6776 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_build_alphanumeric_literal ("/", 1); }
#line 15735 "parser.c" /* yacc.c:1652  */
    break;

  case 626:
#line 6777 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_build_alphanumeric_literal ("&", 1); }
#line 15741 "parser.c" /* yacc.c:1652  */
    break;

  case 627:
#line 6778 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_build_alphanumeric_literal ("|", 1); }
#line 15747 "parser.c" /* yacc.c:1652  */
    break;

  case 628:
#line 6779 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_build_alphanumeric_literal ("^", 1); }
#line 15753 "parser.c" /* yacc.c:1652  */
    break;

  case 631:
#line 6789 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	save_tree = cb_int0;
  }
#line 15761 "parser.c" /* yacc.c:1652  */
    break;

  case 654:
#line 6824 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("REDEFINES", SYN_CLAUSE_1, &check_pic_duplicate);
	if (save_tree != NULL) {
		cb_verify_x (yyvsp[0], cb_free_redefines_position,
			     _("REDEFINES clause not following entry-name"));
	}

	current_field->redefines = cb_resolve_redefines (current_field, yyvsp[0]);
	if (current_field->redefines == NULL) {
		current_field->flag_is_verified = 1;
		current_field->flag_invalid = 1;
		YYERROR;
	}
  }
#line 15780 "parser.c" /* yacc.c:1652  */
    break;

  case 655:
#line 6845 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (!check_repeated ("LIKE", SYN_CLAUSE_30, &check_pic_duplicate)) {
		if (current_field->external_definition) {
			emit_conflicting_clause_message ("TYPE TO", "SAME AS");
		}
		setup_external_definition (yyvsp[-1], 0);
		current_field->like_modifier = yyvsp[0];
		CB_PENDING_X (yyvsp[-1], "LIKE clause");
	}
  }
#line 15795 "parser.c" /* yacc.c:1652  */
    break;

  case 656:
#line 6858 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_int0; }
#line 15801 "parser.c" /* yacc.c:1652  */
    break;

  case 658:
#line 6863 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[-1];
  }
#line 15809 "parser.c" /* yacc.c:1652  */
    break;

  case 659:
#line 6872 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (!check_repeated ("SAME AS", SYN_CLAUSE_30, &check_pic_duplicate)) {
		if (current_field->external_definition) {
			emit_conflicting_clause_message ("TYPE TO", "SAME AS");
		}
		cb_verify (cb_same_as_clause, _("SAME AS clause"));
		setup_external_definition (yyvsp[0], 0);
	}


  }
#line 15825 "parser.c" /* yacc.c:1652  */
    break;

  case 660:
#line 6890 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (current_field->flag_is_typedef) {
		emit_duplicate_clause_message ("TYPEDEF");
		YYERROR;
	}
	/* note: no explicit verification as all dialects with this reserved word use it */
	current_field->flag_is_typedef = 1;
	within_typedef_definition = 1;

	if (current_field->level != 1 && current_field->level != 77) {
		cb_error (_("%s only allowed at 01/77 level"), "TYPEDEF");
	}
	if (!qualifier) {
		cb_error (_("%s requires a data name"), "TYPEDEF");
	}
	if (current_storage == CB_STORAGE_SCREEN
	 || current_storage == CB_STORAGE_REPORT) {
		cb_error (_("%s not allowed in %s"), "TYPEDEF",
			enum_explain_storage(current_storage));
	}
  }
#line 15851 "parser.c" /* yacc.c:1652  */
    break;

  case 662:
#line 6915 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("TYPEDEF STRONG");
  }
#line 15859 "parser.c" /* yacc.c:1652  */
    break;

  case 663:
#line 6925 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("EXTERNAL", SYN_CLAUSE_2, &check_pic_duplicate);
	if (current_storage != CB_STORAGE_WORKING) {
		cb_error (_("%s not allowed here"), "EXTERNAL");
	} else if (current_field->level != 1 && current_field->level != 77) {
		cb_error (_("%s only allowed at 01/77 level"), "EXTERNAL");
	} else if (!qualifier) {
		cb_error (_("%s requires a data name"), "EXTERNAL");
#if	0	/* RXWRXW - Global/External */
	} else if (current_field->flag_is_global) {
		cb_error (_("%s and %s are mutually exclusive"), "GLOBAL", "EXTERNAL");
#endif
	} else if (current_field->flag_item_based) {
		cb_error (_("%s and %s are mutually exclusive"), "BASED", "EXTERNAL");
	} else if (current_field->redefines) {
		cb_error (_("%s and %s are mutually exclusive"), "EXTERNAL", "REDEFINES");
	} else if (current_field->flag_occurs) {
		cb_error (_("%s and %s are mutually exclusive"), "EXTERNAL", "OCCURS");
	} else {
		current_field->flag_external = 1;
		current_program->flag_has_external = 1;
	}
  }
#line 15887 "parser.c" /* yacc.c:1652  */
    break;

  case 664:
#line 6952 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_field->ename = cb_to_cname (current_field->name);
  }
#line 15895 "parser.c" /* yacc.c:1652  */
    break;

  case 665:
#line 6956 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_field->ename = cb_to_cname ((const char *)CB_LITERAL (yyvsp[0])->data);
  }
#line 15903 "parser.c" /* yacc.c:1652  */
    break;

  case 668:
#line 6969 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("GLOBAL", SYN_CLAUSE_3, &check_pic_duplicate);
	if (current_field->level != 1 && current_field->level != 77) {
		cb_error (_("%s only allowed at 01/77 level"), "GLOBAL");
	} else if (!qualifier) {
		cb_error (_("%s requires a data name"), "GLOBAL");
#if	0	/* RXWRXW - Global/External */
	} else if (current_field->flag_external) {
		cb_error (_("%s and %s are mutually exclusive"), "GLOBAL", "EXTERNAL");
#endif
	} else if (current_program->prog_type == COB_MODULE_TYPE_FUNCTION) {
		cb_error (_("%s is invalid in a user FUNCTION"), "GLOBAL");
	} else if (current_storage == CB_STORAGE_LOCAL) {
		cb_error (_("%s not allowed here"), "GLOBAL");
	} else {
		current_field->flag_is_global = 1;
	}
  }
#line 15926 "parser.c" /* yacc.c:1652  */
    break;

  case 669:
#line 6993 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		cb_verify (cb_special_names_clause, "SPECIAL-NAMES clause");
	}
  }
#line 15938 "parser.c" /* yacc.c:1652  */
    break;

  case 671:
#line 7005 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (current_program->cursor_pos) {
		emit_duplicate_clause_message ("CURSOR");
	} else {
		current_program->cursor_pos = cb_build_reference (current_field->name);
	}
  }
#line 15950 "parser.c" /* yacc.c:1652  */
    break;

  case 672:
#line 7013 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (current_program->crt_status) {
		emit_duplicate_clause_message ("CRT STATUS");
	} else {
		current_program->crt_status = cb_build_reference (current_field->name);
	}
  }
#line 15962 "parser.c" /* yacc.c:1652  */
    break;

  case 673:
#line 7030 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
#if 0 /* not yet implemented */
	if (current_program->screen_control) {
		emit_duplicate_clause_message ("SCREEN CONTROL");
	} else {
		CB_PENDING ("SCREEN CONTROL");
	}
#else
	CB_PENDING ("SCREEN CONTROL");
#endif
  }
#line 15978 "parser.c" /* yacc.c:1652  */
    break;

  case 674:
#line 7042 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
#if 0 /* not yet implemented */
	if (current_program->event_status) {
		emit_duplicate_clause_message ("EVENT STATUS");
	} else {
		CB_PENDING ("EVENT STATUS");
	}
#else
	CB_PENDING ("EVENT STATUS");
#endif
  }
#line 15994 "parser.c" /* yacc.c:1652  */
    break;

  case 675:
#line 7059 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("VOLATILE", SYN_CLAUSE_24, &check_pic_duplicate);
	/* note: there is no reason to check current_storage as we only parse
	         volatile_clause and its parent tokens where applicable,
	         same is true for level 66,78,88 */
	/* missing part: always generate and initialize storage */
	CB_UNFINISHED ("VOLATILE");
	current_field->flag_volatile = 1;
	/* TODO: set VOLATILE flag for all parent fields */
  }
#line 16009 "parser.c" /* yacc.c:1652  */
    break;

  case 676:
#line 7077 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("PICTURE", SYN_CLAUSE_4, &check_pic_duplicate);
	current_field->pic = CB_PICTURE (yyvsp[-1]);

	if (CB_VALID_TREE (yyvsp[0])) {
		if (  (current_field->pic->category != CB_CATEGORY_NUMERIC
		    && current_field->pic->category != CB_CATEGORY_NUMERIC_EDITED)
		 || strpbrk (current_field->pic->orig, " CRDB-*") /* the standard seems to forbid also ',' */) {
			cb_error_x (yyvsp[-1], _("a locale-format PICTURE string must only consist of '9', '.', '+', 'Z' and the currency-sign"));
		} else {
			/* TODO: check that not we're not within a CONSTANT RECORD */
			CB_PENDING_X (yyvsp[-1], "locale-format PICTURE");
		}
	}
  }
#line 16029 "parser.c" /* yacc.c:1652  */
    break;

  case 677:
#line 7096 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 16035 "parser.c" /* yacc.c:1652  */
    break;

  case 678:
#line 7098 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	/* $2 -> optional locale-name to be used */
	yyval = yyvsp[0];
  }
#line 16044 "parser.c" /* yacc.c:1652  */
    break;

  case 680:
#line 7107 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 16052 "parser.c" /* yacc.c:1652  */
    break;

  case 681:
#line 7115 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (CB_LOCALE_NAME_P (cb_ref (yyvsp[0]))) {
		yyval = yyvsp[0];
	} else {
		cb_error_x (yyvsp[0], _("'%s' is not a locale-name"),	cb_name (yyvsp[0]));
		yyval = cb_error_node;
	}
  }
#line 16065 "parser.c" /* yacc.c:1652  */
    break;

  case 682:
#line 7130 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_verify (cb_type_to_clause, _("TYPE TO clause"));
	setup_external_definition_type (yyvsp[0]);
  }
#line 16074 "parser.c" /* yacc.c:1652  */
    break;

  case 685:
#line 7143 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	{
		cb_tree x = cb_try_ref (yyvsp[0]);
		if (!CB_INVALID_TREE (x) && CB_FIELD_P (x) && CB_FIELD (x)->flag_is_typedef) {
			if (!check_repeated ("USAGE", SYN_CLAUSE_5, &check_pic_duplicate)) {
				if (current_field->external_definition) {
					emit_conflicting_clause_message ("USAGE", "SAME AS / TYPE TO");
				} else {
					cb_verify (cb_usage_type_name, _("USAGE type-name"));
					/* replace usage by type definition */
					check_pic_duplicate &= ~SYN_CLAUSE_5;
					check_repeated ("USAGE/TYPE", SYN_CLAUSE_31, &check_pic_duplicate);
					setup_external_definition (yyvsp[0], 1);
					break;	/* everything done here */
				}
			}
			YYERROR;
		}
	}
	if (is_reserved_word (CB_NAME (yyvsp[0]))) {
		cb_error_x (yyvsp[0], _("'%s' is not a valid USAGE"), CB_NAME (yyvsp[0]));
	} else if (is_default_reserved_word (CB_NAME (yyvsp[0]))) {
		cb_error_x (yyvsp[0], _("'%s' is not defined, but is a reserved word in another dialect"),
				CB_NAME (yyvsp[0]));
	} else {
		cb_error_x (yyvsp[0], _("unknown USAGE: %s"), CB_NAME (yyvsp[0]));
	}
	check_and_set_usage (CB_USAGE_ERROR);
	YYERROR;
  }
#line 16109 "parser.c" /* yacc.c:1652  */
    break;

  case 686:
#line 7174 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_ERROR);
  }
#line 16117 "parser.c" /* yacc.c:1652  */
    break;

  case 687:
#line 7181 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_BINARY);
  }
#line 16125 "parser.c" /* yacc.c:1652  */
    break;

  case 688:
#line 7185 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_BIT);
	CB_PENDING ("USAGE BIT");
  }
#line 16134 "parser.c" /* yacc.c:1652  */
    break;

  case 689:
#line 7190 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_BINARY);
  }
#line 16142 "parser.c" /* yacc.c:1652  */
    break;

  case 690:
#line 7194 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	/* see FR #310 */
	CB_PENDING ("USAGE COMP-0");
  }
#line 16151 "parser.c" /* yacc.c:1652  */
    break;

  case 691:
#line 7199 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_field->flag_comp_1 = 1;
	if (cb_binary_comp_1) {
		check_and_set_usage (CB_USAGE_SIGNED_SHORT);
	} else {
		check_and_set_usage (CB_USAGE_FLOAT);
	}
  }
#line 16164 "parser.c" /* yacc.c:1652  */
    break;

  case 692:
#line 7208 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_DOUBLE);
  }
#line 16172 "parser.c" /* yacc.c:1652  */
    break;

  case 693:
#line 7212 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_PACKED);
  }
#line 16180 "parser.c" /* yacc.c:1652  */
    break;

  case 694:
#line 7216 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_BINARY);
  }
#line 16188 "parser.c" /* yacc.c:1652  */
    break;

  case 695:
#line 7220 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_COMP_5);
  }
#line 16196 "parser.c" /* yacc.c:1652  */
    break;

  case 696:
#line 7224 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_COMP_6);
  }
#line 16204 "parser.c" /* yacc.c:1652  */
    break;

  case 697:
#line 7228 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_COMP_X);
  }
#line 16212 "parser.c" /* yacc.c:1652  */
    break;

  case 698:
#line 7232 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_COMP_N);
  }
#line 16220 "parser.c" /* yacc.c:1652  */
    break;

  case 699:
#line 7236 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_FLOAT);
  }
#line 16228 "parser.c" /* yacc.c:1652  */
    break;

  case 700:
#line 7240 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_DISPLAY);
  }
#line 16236 "parser.c" /* yacc.c:1652  */
    break;

  case 701:
#line 7244 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_INDEX);
  }
#line 16244 "parser.c" /* yacc.c:1652  */
    break;

  case 702:
#line 7248 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_PACKED);
  }
#line 16252 "parser.c" /* yacc.c:1652  */
    break;

  case 703:
#line 7252 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_POINTER);
	current_field->flag_is_pointer = 1;
  }
#line 16261 "parser.c" /* yacc.c:1652  */
    break;

  case 704:
#line 7257 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_PROGRAM_POINTER);
	current_field->flag_is_pointer = 1;
  }
#line 16270 "parser.c" /* yacc.c:1652  */
    break;

  case 705:
#line 7262 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_HNDL);
  }
#line 16278 "parser.c" /* yacc.c:1652  */
    break;

  case 706:
#line 7266 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_HNDL_WINDOW);
  }
#line 16286 "parser.c" /* yacc.c:1652  */
    break;

  case 707:
#line 7270 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_HNDL_SUBWINDOW);
  }
#line 16294 "parser.c" /* yacc.c:1652  */
    break;

  case 708:
#line 7274 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_HNDL_FONT);
	CB_PENDING ("HANDLE OF FONT");
  }
#line 16303 "parser.c" /* yacc.c:1652  */
    break;

  case 709:
#line 7279 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_HNDL_THREAD);
  }
#line 16311 "parser.c" /* yacc.c:1652  */
    break;

  case 710:
#line 7283 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_HNDL_MENU);
	CB_PENDING ("HANDLE OF MENU");
  }
#line 16320 "parser.c" /* yacc.c:1652  */
    break;

  case 711:
#line 7288 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_HNDL_VARIANT);
  }
#line 16328 "parser.c" /* yacc.c:1652  */
    break;

  case 712:
#line 7292 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_HNDL_LM);
	CB_PENDING ("HANDLE OF LAYOUT-MANAGER");
  }
#line 16337 "parser.c" /* yacc.c:1652  */
    break;

  case 713:
#line 7297 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_HNDL);
	CB_PENDING ("HANDLE OF control-type");
  }
#line 16346 "parser.c" /* yacc.c:1652  */
    break;

  case 714:
#line 7302 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_HNDL);
	cb_error_x (yyvsp[0], _("unknown HANDLE type: %s"), CB_NAME (yyvsp[0]));
  }
#line 16355 "parser.c" /* yacc.c:1652  */
    break;

  case 715:
#line 7307 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_SIGNED_SHORT);
  }
#line 16363 "parser.c" /* yacc.c:1652  */
    break;

  case 716:
#line 7311 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_SIGNED_INT);
  }
#line 16371 "parser.c" /* yacc.c:1652  */
    break;

  case 717:
#line 7315 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
#ifdef COB_32_BIT_LONG
	check_and_set_usage (CB_USAGE_SIGNED_INT);
#else
	check_and_set_usage (CB_USAGE_SIGNED_LONG);
#endif
  }
#line 16383 "parser.c" /* yacc.c:1652  */
    break;

  case 718:
#line 7323 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_UNSIGNED_SHORT);
  }
#line 16391 "parser.c" /* yacc.c:1652  */
    break;

  case 719:
#line 7327 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_UNSIGNED_INT);
  }
#line 16399 "parser.c" /* yacc.c:1652  */
    break;

  case 720:
#line 7331 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
#ifdef COB_32_BIT_LONG
	check_and_set_usage (CB_USAGE_UNSIGNED_INT);
#else
	check_and_set_usage (CB_USAGE_UNSIGNED_LONG);
#endif
  }
#line 16411 "parser.c" /* yacc.c:1652  */
    break;

  case 721:
#line 7339 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_SIGNED_CHAR);
  }
#line 16419 "parser.c" /* yacc.c:1652  */
    break;

  case 722:
#line 7343 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_UNSIGNED_CHAR);
  }
#line 16427 "parser.c" /* yacc.c:1652  */
    break;

  case 723:
#line 7347 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_SIGNED_SHORT);
  }
#line 16435 "parser.c" /* yacc.c:1652  */
    break;

  case 724:
#line 7351 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_UNSIGNED_SHORT);
  }
#line 16443 "parser.c" /* yacc.c:1652  */
    break;

  case 725:
#line 7355 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_SIGNED_INT);
  }
#line 16451 "parser.c" /* yacc.c:1652  */
    break;

  case 726:
#line 7359 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_UNSIGNED_INT);
  }
#line 16459 "parser.c" /* yacc.c:1652  */
    break;

  case 727:
#line 7363 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_SIGNED_LONG);
  }
#line 16467 "parser.c" /* yacc.c:1652  */
    break;

  case 728:
#line 7367 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_UNSIGNED_LONG);
  }
#line 16475 "parser.c" /* yacc.c:1652  */
    break;

  case 729:
#line 7371 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
#ifdef COB_32_BIT_LONG
	check_and_set_usage (CB_USAGE_SIGNED_INT);
#else
	check_and_set_usage (CB_USAGE_SIGNED_LONG);
#endif
  }
#line 16487 "parser.c" /* yacc.c:1652  */
    break;

  case 730:
#line 7379 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
#ifdef COB_32_BIT_LONG
	check_and_set_usage (CB_USAGE_UNSIGNED_INT);
#else
	check_and_set_usage (CB_USAGE_UNSIGNED_LONG);
#endif
  }
#line 16499 "parser.c" /* yacc.c:1652  */
    break;

  case 731:
#line 7387 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_FP_BIN32);
  }
#line 16507 "parser.c" /* yacc.c:1652  */
    break;

  case 732:
#line 7391 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_FP_BIN64);
  }
#line 16515 "parser.c" /* yacc.c:1652  */
    break;

  case 733:
#line 7395 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_FP_BIN128);
  }
#line 16523 "parser.c" /* yacc.c:1652  */
    break;

  case 734:
#line 7399 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_FP_DEC64);
  }
#line 16531 "parser.c" /* yacc.c:1652  */
    break;

  case 735:
#line 7403 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_and_set_usage (CB_USAGE_FP_DEC128);
  }
#line 16539 "parser.c" /* yacc.c:1652  */
    break;

  case 736:
#line 7407 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("USAGE", SYN_CLAUSE_5, &check_pic_duplicate);
	CB_UNFINISHED ("USAGE NATIONAL");
  }
#line 16548 "parser.c" /* yacc.c:1652  */
    break;

  case 748:
#line 7437 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("SIGN", SYN_CLAUSE_6, &check_pic_duplicate);
	current_field->flag_sign_clause = 1;
	current_field->flag_sign_separate = (yyvsp[0] ? 1 : 0);
	current_field->flag_sign_leading  = 1;
  }
#line 16559 "parser.c" /* yacc.c:1652  */
    break;

  case 749:
#line 7444 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("SIGN", SYN_CLAUSE_6, &check_pic_duplicate);
	current_field->flag_sign_clause = 1;
	current_field->flag_sign_separate = (yyvsp[0] ? 1 : 0);
	current_field->flag_sign_leading  = 0;
  }
#line 16570 "parser.c" /* yacc.c:1652  */
    break;

  case 750:
#line 7458 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	/* most of the field attributes are set when parsing the phrases */;
	setup_occurs ();
	setup_occurs_min_max (yyvsp[-4], yyvsp[-3]);
  }
#line 16580 "parser.c" /* yacc.c:1652  */
    break;

  case 752:
#line 7467 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_field->step_count = cb_get_int (yyvsp[0]);
  }
#line 16588 "parser.c" /* yacc.c:1652  */
    break;

  case 753:
#line 7477 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	/* most of the field attributes are set when parsing the phrases */;
	setup_occurs ();
	setup_occurs_min_max (yyvsp[-4], yyvsp[-3]);
  }
#line 16598 "parser.c" /* yacc.c:1652  */
    break;

  case 754:
#line 7484 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_field->flag_unbounded = 1;
	if (current_field->parent) {
		current_field->parent->flag_unbounded = 1;
	}
	current_field->depending = yyvsp[-1];
	/* most of the field attributes are set when parsing the phrases */;
	setup_occurs ();
	setup_occurs_min_max (yyvsp[-6], cb_int0);
  }
#line 16613 "parser.c" /* yacc.c:1652  */
    break;

  case 755:
#line 7496 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	setup_occurs ();
	current_field->occurs_min = yyvsp[-3] ? cb_get_int (yyvsp[-3]) : 0;
	if (yyvsp[-2]) {
		current_field->occurs_max = cb_get_int (yyvsp[-2]);
		if (current_field->occurs_max <= current_field->occurs_min) {
			cb_error (_("OCCURS TO must be greater than OCCURS FROM"));
		}
	} else {
		current_field->occurs_max = 0;
	}
	CB_PENDING ("OCCURS DYNAMIC");
  }
#line 16631 "parser.c" /* yacc.c:1652  */
    break;

  case 756:
#line 7512 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 16637 "parser.c" /* yacc.c:1652  */
    break;

  case 757:
#line 7513 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 16643 "parser.c" /* yacc.c:1652  */
    break;

  case 758:
#line 7517 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 16649 "parser.c" /* yacc.c:1652  */
    break;

  case 759:
#line 7518 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 16655 "parser.c" /* yacc.c:1652  */
    break;

  case 760:
#line 7522 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 16661 "parser.c" /* yacc.c:1652  */
    break;

  case 761:
#line 7523 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[-1]; }
#line 16667 "parser.c" /* yacc.c:1652  */
    break;

  case 763:
#line 7528 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_field->depending = yyvsp[0];
  }
#line 16675 "parser.c" /* yacc.c:1652  */
    break;

  case 765:
#line 7534 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_build_index (yyvsp[0], cb_zero, 0, current_field);
	CB_FIELD_PTR (yyval)->index_type = CB_STATIC_INT_INDEX;
  }
#line 16684 "parser.c" /* yacc.c:1652  */
    break;

  case 767:
#line 7542 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	/* current_field->initialized = 1; */
  }
#line 16692 "parser.c" /* yacc.c:1652  */
    break;

  case 770:
#line 7551 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (!cb_relaxed_syntax_checks) {
		cb_error (_("INDEXED should follow ASCENDING/DESCENDING"));
	} else {
		cb_warning (cb_warn_additional, _("INDEXED should follow ASCENDING/DESCENDING"));
	}
  }
#line 16704 "parser.c" /* yacc.c:1652  */
    break;

  case 774:
#line 7565 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_tree		l;
	struct cb_key	*keys;
	int		i;
	int		nkeys;

	l = yyvsp[0];
	nkeys = cb_list_length (yyvsp[0]);
	keys = cobc_parse_malloc (sizeof (struct cb_key) * nkeys);

	for (i = 0; i < nkeys; i++) {
		keys[i].dir = CB_PURPOSE_INT (l);
		keys[i].key = CB_VALUE (l);
		l = CB_CHAIN (l);
	}
	current_field->keys = keys;
	current_field->nkeys = nkeys;
  }
#line 16727 "parser.c" /* yacc.c:1652  */
    break;

  case 777:
#line 7592 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_tree ref = NULL;
	cb_tree rchain = NULL;
	cb_tree l;

	/* create reference chaing all the way up
	   as later fields may have same name */
	if (!within_typedef_definition) {
		rchain = cb_build_full_field_reference (current_field->parent);
	}

	for (l = yyvsp[0]; l; l = CB_CHAIN (l)) {
		CB_PURPOSE (l) = yyvsp[-3];
		ref = CB_VALUE (l);
		if (CB_VALID_TREE(ref)) {
			CB_REFERENCE (ref)->chain = rchain;
		}
	}
	keys_list = cb_list_append (keys_list, yyvsp[0]);
	yyval = keys_list;
  }
#line 16753 "parser.c" /* yacc.c:1652  */
    break;

  case 778:
#line 7616 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_int (COB_ASCENDING); }
#line 16759 "parser.c" /* yacc.c:1652  */
    break;

  case 779:
#line 7617 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_int (COB_DESCENDING); }
#line 16765 "parser.c" /* yacc.c:1652  */
    break;

  case 782:
#line 7626 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_field->index_list = yyvsp[0];
  }
#line 16773 "parser.c" /* yacc.c:1652  */
    break;

  case 783:
#line 7632 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = CB_LIST_INIT (yyvsp[0]); }
#line 16779 "parser.c" /* yacc.c:1652  */
    break;

  case 784:
#line 7634 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_list_add (yyvsp[-1], yyvsp[0]); }
#line 16785 "parser.c" /* yacc.c:1652  */
    break;

  case 785:
#line 7639 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_build_index (yyvsp[0], cb_int1, 1U, current_field);
	CB_FIELD_PTR (yyval)->index_type = CB_STATIC_INT_INDEX;
  }
#line 16794 "parser.c" /* yacc.c:1652  */
    break;

  case 786:
#line 7650 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("JUSTIFIED", SYN_CLAUSE_8, &check_pic_duplicate);
	current_field->flag_justified = 1;
  }
#line 16803 "parser.c" /* yacc.c:1652  */
    break;

  case 787:
#line 7661 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("SYNCHRONIZED", SYN_CLAUSE_9, &check_pic_duplicate);
	if (cb_verify (cb_synchronized_clause, _("SYNCHRONIZED clause"))) {
		current_field->flag_synchronized = 1;
	}
  }
#line 16814 "parser.c" /* yacc.c:1652  */
    break;

  case 790:
#line 7673 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("SYNCHRONIZED RIGHT");
  }
#line 16822 "parser.c" /* yacc.c:1652  */
    break;

  case 791:
#line 7683 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("BLANK", SYN_CLAUSE_10, &check_pic_duplicate);
	current_field->flag_blank_zero = 1;
  }
#line 16831 "parser.c" /* yacc.c:1652  */
    break;

  case 792:
#line 7694 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("BASED", SYN_CLAUSE_11, &check_pic_duplicate);
	if (current_storage == CB_STORAGE_FILE) {
		cb_error (_("%s not allowed here"), "BASED");
	} else if (current_field->level != 1 && current_field->level != 77) {
		cb_error (_("%s only allowed at 01/77 level"), "BASED");
	} else if (!qualifier) {
		cb_error (_("%s requires a data name"), "BASED");
	} else if (current_field->flag_external) {
		cb_error (_("%s and %s are mutually exclusive"), "BASED", "EXTERNAL");
	} else if (current_field->redefines) {
		cb_error (_("%s and %s are mutually exclusive"), "BASED", "REDEFINES");
	} else if (current_field->flag_any_length) {
		cb_error (_("%s and %s are mutually exclusive"), "BASED", "ANY LENGTH");
	} else if (current_field->flag_occurs) {
		cb_error (_("%s and %s are mutually exclusive"), "BASED", "OCCURS");
	} else {
		current_field->flag_item_based = 1;
	}
  }
#line 16856 "parser.c" /* yacc.c:1652  */
    break;

  case 793:
#line 7720 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("VALUE", SYN_CLAUSE_12, &check_pic_duplicate);
	current_field->values = yyvsp[0];
  }
#line 16865 "parser.c" /* yacc.c:1652  */
    break;

  case 795:
#line 7728 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = CB_LIST_INIT (yyvsp[0]); }
#line 16871 "parser.c" /* yacc.c:1652  */
    break;

  case 796:
#line 7729 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_list_add (yyvsp[-1], yyvsp[0]); }
#line 16877 "parser.c" /* yacc.c:1652  */
    break;

  case 797:
#line 7733 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = CB_BUILD_PAIR (yyvsp[-2], yyvsp[0]); }
#line 16883 "parser.c" /* yacc.c:1652  */
    break;

  case 800:
#line 7740 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (current_field->level != 88) {
		cb_error (_("FALSE clause only allowed for 88 level"));
	}
	current_field->false_88 = CB_LIST_INIT (yyvsp[0]);
  }
#line 16894 "parser.c" /* yacc.c:1652  */
    break;

  case 801:
#line 7752 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("ANY", SYN_CLAUSE_14, &check_pic_duplicate);
	if (current_field->flag_item_based) {
		cb_error (_("%s and %s are mutually exclusive"), "BASED", "ANY LENGTH");
	} else {
		current_field->flag_any_length = 1;
	}
  }
#line 16907 "parser.c" /* yacc.c:1652  */
    break;

  case 802:
#line 7761 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("ANY", SYN_CLAUSE_14, &check_pic_duplicate);
	if (current_field->flag_item_based) {
		cb_error (_("%s and %s are mutually exclusive"), "BASED", "ANY NUMERIC");
	} else {
		current_field->flag_any_length = 1;
		current_field->flag_any_numeric = 1;
	}
  }
#line 16921 "parser.c" /* yacc.c:1652  */
    break;

  case 803:
#line 7776 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("EXTERNAL-FORM", SYN_CLAUSE_2, &check_pic_duplicate);
	CB_PENDING ("EXTERNAL-FORM");
	if (current_storage != CB_STORAGE_WORKING) {
		cb_error (_("%s not allowed here"), "EXTERNAL-FORM");
	} else if (current_field->level != 1) {	/* docs say: at group level */
		cb_error (_("%s only allowed at 01 level"), "EXTERNAL-FORM");
	} else if (!qualifier) {
		cb_error (_("%s requires a data name"), "EXTERNAL-FORM");
	} else if (current_field->redefines) {
		cb_error (_("%s and %s combination not allowed"), "EXTERNAL-FORM", "REDEFINES");
	} else {
		current_field->flag_is_external_form = 1;
	}
  }
#line 16941 "parser.c" /* yacc.c:1652  */
    break;

  case 804:
#line 7799 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("IDENTIFIED BY", SYN_CLAUSE_3, &check_pic_duplicate);
	if (!current_field->flag_is_external_form) {
		CB_PENDING ("EXTERNAL-FORM (IDENTIFIED BY)");
		if (current_storage != CB_STORAGE_WORKING) {
			cb_error (_("%s not allowed here"), "IDENTIFIED BY");
		} else if (!qualifier) {
			cb_error (_("%s requires a data name"), "IDENTIFIED BY");
		} else if (current_field->redefines) {
			cb_error (_("%s and %s combination not allowed"), "IDENTIFIED BY", "REDEFINES");
		}
	}
	current_field->external_form_identifier = yyvsp[0];
  }
#line 16960 "parser.c" /* yacc.c:1652  */
    break;

  case 806:
#line 7819 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_headers_present (COBC_HD_DATA_DIVISION, 0, 0, 0);
	header_check |= COBC_HD_LOCAL_STORAGE_SECTION;
	current_storage = CB_STORAGE_LOCAL;
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "LOCAL-STORAGE");
	}
  }
#line 16973 "parser.c" /* yacc.c:1652  */
    break;

  case 807:
#line 7828 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[0]) {
		current_program->local_storage = CB_FIELD (yyvsp[0]);
	}
  }
#line 16983 "parser.c" /* yacc.c:1652  */
    break;

  case 809:
#line 7840 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_headers_present (COBC_HD_DATA_DIVISION, 0, 0, 0);
	header_check |= COBC_HD_LINKAGE_SECTION;
	current_storage = CB_STORAGE_LINKAGE;
  }
#line 16993 "parser.c" /* yacc.c:1652  */
    break;

  case 810:
#line 7846 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[0]) {
		current_program->linkage_storage = CB_FIELD (yyvsp[0]);
	}
  }
#line 17003 "parser.c" /* yacc.c:1652  */
    break;

  case 812:
#line 7857 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	header_check |= COBC_HD_REPORT_SECTION;
	current_storage = CB_STORAGE_REPORT;
	description_field = NULL;
	current_program->flag_report = 1;
	cb_clear_real_field ();
  }
#line 17015 "parser.c" /* yacc.c:1652  */
    break;

  case 816:
#line 7875 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (CB_INVALID_TREE (yyvsp[0])) {
		YYERROR;
	} else {
		current_field = NULL;
		control_field = NULL;
		description_field = NULL;
		current_report = CB_REPORT_PTR (yyvsp[0]);
	}
	check_duplicate = 0;
  }
#line 17031 "parser.c" /* yacc.c:1652  */
    break;

  case 817:
#line 7888 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = get_finalized_description_tree ();

	current_program->report_storage = description_field;
	current_program->flag_report = 1;
	if (current_report->records == NULL) {
		current_report->records = description_field;
	}
	finalize_report (current_report, description_field);
  }
#line 17046 "parser.c" /* yacc.c:1652  */
    break;

  case 820:
#line 7903 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyerrok;
  }
#line 17054 "parser.c" /* yacc.c:1652  */
    break;

  case 821:
#line 7910 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("GLOBAL", SYN_CLAUSE_1, &check_duplicate);
	current_report->global = 1;
	cb_error (_("GLOBAL is not allowed with RD"));
  }
#line 17064 "parser.c" /* yacc.c:1652  */
    break;

  case 822:
#line 7916 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("CODE", SYN_CLAUSE_2, &check_duplicate);
	current_report->code_clause = yyvsp[0];
  }
#line 17073 "parser.c" /* yacc.c:1652  */
    break;

  case 825:
#line 7928 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("CONTROL", SYN_CLAUSE_3, &check_duplicate);
  }
#line 17081 "parser.c" /* yacc.c:1652  */
    break;

  case 829:
#line 7941 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_report->control_final = 1;
  }
#line 17089 "parser.c" /* yacc.c:1652  */
    break;

  case 832:
#line 7953 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	/* Add field to current control list */
	CB_ADD_TO_CHAIN (yyvsp[0], current_report->controls);
  }
#line 17098 "parser.c" /* yacc.c:1652  */
    break;

  case 833:
#line 7964 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("PAGE", SYN_CLAUSE_4, &check_duplicate);
	if (!current_report->heading) {
		current_report->heading = 1;
	}
	if (!current_report->first_detail) {
		current_report->first_detail = current_report->heading;
	}
	if (!current_report->last_control) {
		if (current_report->last_detail) {
			current_report->last_control = current_report->last_detail;
		} else if (current_report->footing) {
			current_report->last_control = current_report->footing;
		} else {
			current_report->last_control = current_report->lines;
		}
		if (current_report->t_last_detail) {
			current_report->t_last_control = current_report->t_last_detail;
		} else if (current_report->t_footing) {
			current_report->t_last_control = current_report->t_footing;
		} else if(current_report->t_lines) {
			current_report->t_last_control = current_report->t_lines;
		}
	}
	if (!current_report->last_detail && !current_report->footing) {
		current_report->last_detail = current_report->lines;
		current_report->footing = current_report->lines;
	} else if (!current_report->last_detail) {
		current_report->last_detail = current_report->footing;
	} else if (!current_report->footing) {
		current_report->footing = current_report->last_detail;
	}
	/* PAGE LIMIT values checked in finalize_report in typeck.c */
  }
#line 17137 "parser.c" /* yacc.c:1652  */
    break;

  case 834:
#line 8002 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (CB_LITERAL_P (yyvsp[-1])) {
		current_report->lines = cb_get_int (yyvsp[-1]);
		if (current_report->lines > 999) {
			cb_error ("PAGE LIMIT lines > 999");
		}
	} else {
		current_report->t_lines = yyvsp[-1];
	}
  }
#line 17152 "parser.c" /* yacc.c:1652  */
    break;

  case 836:
#line 8014 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (CB_LITERAL_P (yyvsp[-2])) {
		current_report->lines = cb_get_int (yyvsp[-2]);
		if (current_report->lines > 999) {
			cb_error ("PAGE LIMIT lines > 999");
		}
	} else {
		current_report->t_lines = yyvsp[-2];
	}
  }
#line 17167 "parser.c" /* yacc.c:1652  */
    break;

  case 837:
#line 8028 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	/* may be repeated later by page detail */
	check_repeated ("LINE LIMIT", SYN_CLAUSE_5, &check_duplicate);
	if (CB_LITERAL_P (yyvsp[-1])) {
		current_report->columns = cb_get_int (yyvsp[-1]);
	} else {
		current_report->t_columns = yyvsp[-1];
	}
  }
#line 17181 "parser.c" /* yacc.c:1652  */
    break;

  case 847:
#line 8056 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("LINE LIMIT", SYN_CLAUSE_5, &check_duplicate);
	if (CB_LITERAL_P (yyvsp[0])) {
		current_report->columns = cb_get_int (yyvsp[0]);
	} else {
		current_report->t_columns = yyvsp[0];
	}
  }
#line 17194 "parser.c" /* yacc.c:1652  */
    break;

  case 848:
#line 8068 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("HEADING", SYN_CLAUSE_6, &check_duplicate);
	error_if_no_page_lines_limit ("HEADING");

	if (CB_LITERAL_P (yyvsp[0])) {
		current_report->heading = cb_get_int (yyvsp[0]);
	} else {
		current_report->t_heading = yyvsp[0];
	}
  }
#line 17209 "parser.c" /* yacc.c:1652  */
    break;

  case 849:
#line 8082 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("FIRST DETAIL", SYN_CLAUSE_7, &check_duplicate);
	error_if_no_page_lines_limit ("FIRST DETAIL");

	if (CB_LITERAL_P (yyvsp[0])) {
		current_report->first_detail = cb_get_int (yyvsp[0]);
	} else {
		current_report->t_first_detail = yyvsp[0];
	}
  }
#line 17224 "parser.c" /* yacc.c:1652  */
    break;

  case 850:
#line 8096 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("LAST CONTROL HEADING", SYN_CLAUSE_8, &check_duplicate);
	error_if_no_page_lines_limit ("LAST CONTROL HEADING");

	if (CB_LITERAL_P (yyvsp[0])) {
		current_report->last_control = cb_get_int (yyvsp[0]);
	} else {
		current_report->t_last_control = yyvsp[0];
	}
  }
#line 17239 "parser.c" /* yacc.c:1652  */
    break;

  case 851:
#line 8110 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("LAST DETAIL", SYN_CLAUSE_9, &check_duplicate);
	error_if_no_page_lines_limit ("LAST DETAIL");

	if (CB_LITERAL_P (yyvsp[0])) {
		current_report->last_detail = cb_get_int (yyvsp[0]);
	} else {
		current_report->t_last_detail = yyvsp[0];
	}
  }
#line 17254 "parser.c" /* yacc.c:1652  */
    break;

  case 852:
#line 8124 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("FOOTING", SYN_CLAUSE_10, &check_duplicate);
	error_if_no_page_lines_limit ("FOOTING");

	if (CB_LITERAL_P (yyvsp[0])) {
		current_report->footing = cb_get_int (yyvsp[0]);
	} else {
		current_report->t_footing = yyvsp[0];
	}
  }
#line 17269 "parser.c" /* yacc.c:1652  */
    break;

  case 855:
#line 8142 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (set_current_field(yyvsp[-1], yyvsp[0])) {
		YYERROR;
	}
	if (!description_field) {
		description_field = current_field;
	}
  }
#line 17282 "parser.c" /* yacc.c:1652  */
    break;

  case 857:
#line 8152 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	/* Free tree associated with level number */
	cobc_parse_free (yyvsp[-2]);
	cb_unput_dot ();
	yyerrok;
	check_pic_duplicate = 0;
	check_duplicate = 0;
	current_field = cb_get_real_field ();
  }
#line 17296 "parser.c" /* yacc.c:1652  */
    break;

  case 877:
#line 8189 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("TYPE IS", SYN_CLAUSE_16, &check_pic_duplicate);
  }
#line 17304 "parser.c" /* yacc.c:1652  */
    break;

  case 878:
#line 8196 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_field->report_flag |= COB_REPORT_HEADING;
  }
#line 17312 "parser.c" /* yacc.c:1652  */
    break;

  case 879:
#line 8200 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_field->report_flag |= COB_REPORT_PAGE_HEADING;
  }
#line 17320 "parser.c" /* yacc.c:1652  */
    break;

  case 882:
#line 8206 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (current_report != NULL) {
		current_report->has_detail = 1;
	}
	current_field->report_flag |= COB_REPORT_DETAIL;
  }
#line 17331 "parser.c" /* yacc.c:1652  */
    break;

  case 883:
#line 8213 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_field->report_flag |= COB_REPORT_PAGE_FOOTING;
  }
#line 17339 "parser.c" /* yacc.c:1652  */
    break;

  case 884:
#line 8217 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_field->report_flag |= COB_REPORT_FOOTING;
  }
#line 17347 "parser.c" /* yacc.c:1652  */
    break;

  case 885:
#line 8224 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_field->report_flag |= COB_REPORT_CONTROL_HEADING;
  }
#line 17355 "parser.c" /* yacc.c:1652  */
    break;

  case 886:
#line 8228 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_field->report_flag |= COB_REPORT_CONTROL_HEADING;
	current_field->report_control = yyvsp[-1];
	if (yyvsp[0]) {
		current_field->report_flag |= COB_REPORT_PAGE;
	}
  }
#line 17367 "parser.c" /* yacc.c:1652  */
    break;

  case 887:
#line 8236 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_field->report_flag |= COB_REPORT_CONTROL_HEADING_FINAL;
  }
#line 17375 "parser.c" /* yacc.c:1652  */
    break;

  case 888:
#line 8245 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {yyval = NULL;}
#line 17381 "parser.c" /* yacc.c:1652  */
    break;

  case 889:
#line 8246 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {yyval = cb_int0;}
#line 17387 "parser.c" /* yacc.c:1652  */
    break;

  case 890:
#line 8251 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_field->report_flag |= COB_REPORT_CONTROL_FOOTING;
  }
#line 17395 "parser.c" /* yacc.c:1652  */
    break;

  case 891:
#line 8255 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_field->report_flag |= COB_REPORT_CONTROL_FOOTING;
	current_field->report_control = yyvsp[-1];
  }
#line 17404 "parser.c" /* yacc.c:1652  */
    break;

  case 892:
#line 8260 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_field->report_flag |= COB_REPORT_CONTROL_FOOTING_FINAL;
  }
#line 17412 "parser.c" /* yacc.c:1652  */
    break;

  case 893:
#line 8264 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_field->report_flag |= COB_REPORT_CONTROL_FOOTING;
	current_field->report_flag |= COB_REPORT_ALL;
  }
#line 17421 "parser.c" /* yacc.c:1652  */
    break;

  case 894:
#line 8272 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("NEXT GROUP", SYN_CLAUSE_17, &check_pic_duplicate);
  }
#line 17429 "parser.c" /* yacc.c:1652  */
    break;

  case 895:
#line 8279 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (CB_LITERAL_P(yyvsp[0]) && CB_LITERAL (yyvsp[0])->sign > 0) {
		current_field->report_flag |= COB_REPORT_NEXT_GROUP_PLUS;
	} else {
		current_field->report_flag |= COB_REPORT_NEXT_GROUP_LINE;
	}
	current_field->next_group_line = cb_get_int (yyvsp[0]);
  }
#line 17442 "parser.c" /* yacc.c:1652  */
    break;

  case 896:
#line 8288 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_field->report_flag |= COB_REPORT_NEXT_GROUP_PLUS;
	current_field->next_group_line = cb_get_int(yyvsp[0]);
  }
#line 17451 "parser.c" /* yacc.c:1652  */
    break;

  case 897:
#line 8293 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_field->report_flag |= COB_REPORT_NEXT_GROUP_PAGE;
  }
#line 17459 "parser.c" /* yacc.c:1652  */
    break;

  case 901:
#line 8306 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("SUM", SYN_CLAUSE_19, &check_pic_duplicate);
	current_field->report_sum_list = yyvsp[-1];
	build_sum_counter (current_report, current_field);
  }
#line 17469 "parser.c" /* yacc.c:1652  */
    break;

  case 904:
#line 8316 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_field->report_sum_upon = yyvsp[0];
  }
#line 17477 "parser.c" /* yacc.c:1652  */
    break;

  case 905:
#line 8323 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_field->report_reset = yyvsp[0];
  }
#line 17485 "parser.c" /* yacc.c:1652  */
    break;

  case 906:
#line 8327 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_field->report_flag |= COB_REPORT_RESET_FINAL;
  }
#line 17493 "parser.c" /* yacc.c:1652  */
    break;

  case 907:
#line 8334 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("PRESENT", SYN_CLAUSE_20, &check_pic_duplicate);
	current_field->report_when = yyvsp[0];
  }
#line 17502 "parser.c" /* yacc.c:1652  */
    break;

  case 908:
#line 8339 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("PRESENT", SYN_CLAUSE_20, &check_pic_duplicate);
	current_field->report_flag |= COB_REPORT_PRESENT;
	current_field->report_flag &= ~COB_REPORT_BEFORE;
  }
#line 17512 "parser.c" /* yacc.c:1652  */
    break;

  case 909:
#line 8345 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("PRESENT", SYN_CLAUSE_20, &check_pic_duplicate);
	current_field->report_flag |= COB_REPORT_PRESENT;
	current_field->report_flag &= ~COB_REPORT_BEFORE;
	current_field->report_flag |= COB_REPORT_PAGE;
  }
#line 17523 "parser.c" /* yacc.c:1652  */
    break;

  case 910:
#line 8352 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("PRESENT", SYN_CLAUSE_20, &check_pic_duplicate);
	current_field->report_flag |= COB_REPORT_PRESENT;
	current_field->report_flag |= COB_REPORT_BEFORE;
  }
#line 17533 "parser.c" /* yacc.c:1652  */
    break;

  case 911:
#line 8358 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("PRESENT", SYN_CLAUSE_20, &check_pic_duplicate);
	current_field->report_flag |= COB_REPORT_PRESENT;
	current_field->report_flag |= COB_REPORT_BEFORE;
	current_field->report_flag |= COB_REPORT_PAGE;
  }
#line 17544 "parser.c" /* yacc.c:1652  */
    break;

  case 912:
#line 8368 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_field->report_flag |= COB_REPORT_PRESENT;
  }
#line 17552 "parser.c" /* yacc.c:1652  */
    break;

  case 913:
#line 8372 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_field->report_flag |= COB_REPORT_PRESENT;
	current_field->report_flag |= COB_REPORT_NEGATE;
  }
#line 17561 "parser.c" /* yacc.c:1652  */
    break;

  case 916:
#line 8385 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_field->report_flag |= COB_REPORT_PAGE;
  }
#line 17569 "parser.c" /* yacc.c:1652  */
    break;

  case 917:
#line 8389 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_field->report_control = yyvsp[0];
  }
#line 17577 "parser.c" /* yacc.c:1652  */
    break;

  case 919:
#line 8397 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("RW VARYING clause");
  }
#line 17585 "parser.c" /* yacc.c:1652  */
    break;

  case 920:
#line 8404 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("LINE", SYN_CLAUSE_21, &check_pic_duplicate);
	current_field->report_flag |= COB_REPORT_LINE;
  }
#line 17594 "parser.c" /* yacc.c:1652  */
    break;

  case 925:
#line 8422 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_field->report_flag |= COB_REPORT_LINE_NEXT_PAGE;
  }
#line 17602 "parser.c" /* yacc.c:1652  */
    break;

  case 926:
#line 8426 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_field->report_line = cb_get_int (yyvsp[0]);
	if (yyvsp[-1]) {
		current_field->report_flag |= COB_REPORT_LINE_PLUS;
		if (current_field->report_line == 0) {
			CB_PENDING ("LINE PLUS 0");
		}
	}
  }
#line 17616 "parser.c" /* yacc.c:1652  */
    break;

  case 927:
#line 8440 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("COLUMN", SYN_CLAUSE_18, &check_pic_duplicate);
	if ((current_field->report_flag & (COB_REPORT_COLUMN_LEFT|COB_REPORT_COLUMN_RIGHT|COB_REPORT_COLUMN_CENTER))
	 && (current_field->report_flag & COB_REPORT_COLUMN_PLUS)) {
		if (cb_relaxed_syntax_checks) {
			cb_warning (COBC_WARN_FILLER, _("PLUS is not recommended with LEFT, RIGHT or CENTER"));
		} else {
			cb_error (_("PLUS is not allowed with LEFT, RIGHT or CENTER"));
		}
	}
  }
#line 17632 "parser.c" /* yacc.c:1652  */
    break;

  case 931:
#line 8464 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_field->report_flag |= COB_REPORT_COLUMN_LEFT;
  }
#line 17640 "parser.c" /* yacc.c:1652  */
    break;

  case 932:
#line 8468 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_field->report_flag |= COB_REPORT_COLUMN_RIGHT;
  }
#line 17648 "parser.c" /* yacc.c:1652  */
    break;

  case 933:
#line 8472 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_field->report_flag |= COB_REPORT_COLUMN_CENTER;
  }
#line 17656 "parser.c" /* yacc.c:1652  */
    break;

  case 934:
#line 8479 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	int colnum = cb_get_int (yyvsp[0]);
	if (colnum != 0) {
		if (current_field->parent
		 && current_field->parent->children == current_field) {
			cb_warning (COBC_WARN_FILLER, _("PLUS is ignored on first field of line"));
			if (current_field->step_count == 0) {
				current_field->step_count = colnum;
			}
		} else {
			current_field->report_flag |= COB_REPORT_COLUMN_PLUS;
		}
	} else {
		colnum = 0;
	}
	if (current_field->report_column == 0) {
		current_field->report_column = colnum;
	}
	current_field->report_num_col++;
  }
#line 17681 "parser.c" /* yacc.c:1652  */
    break;

  case 938:
#line 8509 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	int colnum;
	colnum = cb_get_int (yyvsp[0]);
	if (colnum < 0) {
		/* already handled by integer check */
	} else if (colnum == 0) {
		cb_error (_("invalid COLUMN integer; must be > 0"));
	} else if (colnum <= current_field->report_column) {
		cb_warning (COBC_WARN_FILLER, _("COLUMN numbers should increase"));
	}
	current_field->report_column_list =
			cb_list_append (current_field->report_column_list, CB_LIST_INIT (yyvsp[0]));
	if (current_field->report_column == 0) {
		current_field->report_column = colnum;
	}
	current_field->report_num_col++;
  }
#line 17703 "parser.c" /* yacc.c:1652  */
    break;

  case 939:
#line 8530 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("SOURCE", SYN_CLAUSE_22, &check_pic_duplicate);
	current_field->report_source = yyvsp[-1];
  }
#line 17712 "parser.c" /* yacc.c:1652  */
    break;

  case 940:
#line 8538 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("GROUP", SYN_CLAUSE_23, &check_pic_duplicate);
	current_field->report_flag |= COB_REPORT_GROUP_INDICATE;
  }
#line 17721 "parser.c" /* yacc.c:1652  */
    break;

  case 942:
#line 8548 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cobc_cs_check = CB_CS_SCREEN;
	current_storage = CB_STORAGE_SCREEN;
	current_field = NULL;
	description_field = NULL;
	cb_clear_real_field ();
  }
#line 17733 "parser.c" /* yacc.c:1652  */
    break;

  case 943:
#line 8556 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (description_field) {
		get_finalized_description_tree ();
		current_program->screen_storage = description_field;
		current_program->flag_screen = 1;
	}
	cobc_cs_check = 0;
  }
#line 17746 "parser.c" /* yacc.c:1652  */
    break;

  case 949:
#line 8579 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (set_current_field (yyvsp[-1], yyvsp[0])) {
		YYERROR;
	}
	if (current_field->parent) {
		current_field->screen_foreg = current_field->parent->screen_foreg;
		current_field->screen_backg = current_field->parent->screen_backg;
		current_field->screen_prompt = current_field->parent->screen_prompt;
	}
  }
#line 17761 "parser.c" /* yacc.c:1652  */
    break;

  case 950:
#line 8590 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cob_flags_t	flags;

	if (current_field->parent) {
		flags = current_field->parent->screen_flag;
		flags &= ~COB_SCREEN_BLANK_LINE;
		flags &= ~COB_SCREEN_BLANK_SCREEN;
		flags &= ~COB_SCREEN_ERASE_EOL;
		flags &= ~COB_SCREEN_ERASE_EOS;
		flags &= ~COB_SCREEN_LINE_PLUS;
		flags &= ~COB_SCREEN_LINE_MINUS;
		flags &= ~COB_SCREEN_COLUMN_PLUS;
		flags &= ~COB_SCREEN_COLUMN_MINUS;

		flags = zero_conflicting_flags (current_field->screen_flag,
						flags);

		current_field->screen_flag |= flags;
	}

	if (current_field->screen_flag & COB_SCREEN_INITIAL) {
		if (!(current_field->screen_flag & COB_SCREEN_INPUT)) {
			cb_error (_("INITIAL specified on non-input field"));
		}
	}
	if (!qualifier) {
		current_field->flag_filler = 1;
	}

	if (!description_field) {
		description_field = current_field;
	}
	if (current_field->flag_occurs
	 && !has_relative_pos (current_field)) {
		cb_error (_("relative LINE/COLUMN clause required with OCCURS"));
	}
  }
#line 17803 "parser.c" /* yacc.c:1652  */
    break;

  case 951:
#line 8629 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (set_current_field (yyvsp[-1], yyvsp[0])) {
		YYERROR;
	}

	if (current_field->parent) {
		current_field->screen_foreg = current_field->parent->screen_foreg;
		current_field->screen_backg = current_field->parent->screen_backg;
		current_field->screen_prompt = current_field->parent->screen_prompt;
	}
  }
#line 17819 "parser.c" /* yacc.c:1652  */
    break;

  case 952:
#line 8641 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("GRAPHICAL CONTROL");
  }
#line 17827 "parser.c" /* yacc.c:1652  */
    break;

  case 953:
#line 8646 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cob_flags_t	flags;

	if (current_field->parent) {
		flags = current_field->parent->screen_flag;
		flags &= ~COB_SCREEN_BLANK_LINE;
		flags &= ~COB_SCREEN_BLANK_SCREEN;
		flags &= ~COB_SCREEN_ERASE_EOL;
		flags &= ~COB_SCREEN_ERASE_EOS;
		flags &= ~COB_SCREEN_LINE_PLUS;
		flags &= ~COB_SCREEN_LINE_MINUS;
		flags &= ~COB_SCREEN_COLUMN_PLUS;
		flags &= ~COB_SCREEN_COLUMN_MINUS;

		flags = zero_conflicting_flags (current_field->screen_flag,
						flags);

		current_field->screen_flag |= flags;
	}

	if (current_field->screen_flag & COB_SCREEN_INITIAL) {
		if (!(current_field->screen_flag & COB_SCREEN_INPUT)) {
			cb_error (_("INITIAL specified on non-input field"));
		}
	}
	if (!qualifier) {
		current_field->flag_filler = 1;
	}

	if (!description_field) {
		description_field = current_field;
	}
	if (current_field->flag_occurs
	 && !has_relative_pos (current_field)) {
		cb_error (_("relative LINE/COLUMN clause required with OCCURS"));
	}
	cobc_cs_check = CB_CS_SCREEN;
  }
#line 17870 "parser.c" /* yacc.c:1652  */
    break;

  case 954:
#line 8686 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	/*
	  Tree associated with level number has already been freed; we don't
	  need to do anything here.
	*/
	yyerrok;
	cb_unput_dot ();
	check_pic_duplicate = 0;
	check_duplicate = 0;
#if	1	/* RXWRXW Screen field */
	if (current_field) {
		current_field->flag_is_verified = 1;
		current_field->flag_invalid = 1;
	}
#endif
	current_field = cb_get_real_field ();
  }
#line 17892 "parser.c" /* yacc.c:1652  */
    break;

  case 957:
#line 8712 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	set_screen_attr_with_conflict ("BLANK LINE", COB_SCREEN_BLANK_LINE,
				       "BLANK SCREEN", COB_SCREEN_BLANK_SCREEN);
  }
#line 17901 "parser.c" /* yacc.c:1652  */
    break;

  case 958:
#line 8717 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	set_screen_attr_with_conflict ("BLANK SCREEN", COB_SCREEN_BLANK_SCREEN,
				       "BLANK LINE", COB_SCREEN_BLANK_LINE);
  }
#line 17910 "parser.c" /* yacc.c:1652  */
    break;

  case 959:
#line 8722 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	set_screen_attr ("BELL", COB_SCREEN_BELL);
  }
#line 17918 "parser.c" /* yacc.c:1652  */
    break;

  case 960:
#line 8726 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	set_screen_attr ("BLINK", COB_SCREEN_BLINK);
  }
#line 17926 "parser.c" /* yacc.c:1652  */
    break;

  case 961:
#line 8730 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	set_screen_attr_with_conflict ("ERASE EOL", COB_SCREEN_ERASE_EOL,
				       "ERASE EOS", COB_SCREEN_ERASE_EOS);
  }
#line 17935 "parser.c" /* yacc.c:1652  */
    break;

  case 962:
#line 8735 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	set_screen_attr_with_conflict ("ERASE EOS", COB_SCREEN_ERASE_EOS,
				       "ERASE EOL", COB_SCREEN_ERASE_EOL);
  }
#line 17944 "parser.c" /* yacc.c:1652  */
    break;

  case 963:
#line 8740 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	set_screen_attr_with_conflict ("HIGHLIGHT", COB_SCREEN_HIGHLIGHT,
				       "LOWLIGHT", COB_SCREEN_LOWLIGHT);
  }
#line 17953 "parser.c" /* yacc.c:1652  */
    break;

  case 964:
#line 8745 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	set_screen_attr_with_conflict ("LOWLIGHT", COB_SCREEN_LOWLIGHT,
				       "HIGHLIGHT", COB_SCREEN_HIGHLIGHT);
  }
#line 17962 "parser.c" /* yacc.c:1652  */
    break;

  case 965:
#line 8750 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("STANDARD intensity");
#if 0 /* in general we could simply remove high/low, but for syntax checks
	we still need a flag */
	set_screen_attr_with_conflict ("LOWLIGHT", COB_SCREEN_LOWLIGHT,
				       "HIGHLIGHT", COB_SCREEN_HIGHLIGHT);
#endif
  }
#line 17975 "parser.c" /* yacc.c:1652  */
    break;

  case 966:
#line 8759 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("BACKGROUND intensity");
  }
#line 17983 "parser.c" /* yacc.c:1652  */
    break;

  case 967:
#line 8763 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("BACKGROUND intensity");
  }
#line 17991 "parser.c" /* yacc.c:1652  */
    break;

  case 968:
#line 8767 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("BACKGROUND intensity");
  }
#line 17999 "parser.c" /* yacc.c:1652  */
    break;

  case 969:
#line 8771 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	set_screen_attr ("REVERSE-VIDEO", COB_SCREEN_REVERSE);
  }
#line 18007 "parser.c" /* yacc.c:1652  */
    break;

  case 970:
#line 8775 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	/* set_screen_attr ("SIZE", COB_SCREEN_SIZE); */
	CB_PENDING ("SIZE clause");
	current_field->size = cb_get_int (yyvsp[0]);
  }
#line 18017 "parser.c" /* yacc.c:1652  */
    break;

  case 971:
#line 8781 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING (_("screen positions from data-item"));
  }
#line 18025 "parser.c" /* yacc.c:1652  */
    break;

  case 972:
#line 8785 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING (_("screen positions from data-item"));
	CB_PENDING ("SIZE clause");
  }
#line 18034 "parser.c" /* yacc.c:1652  */
    break;

  case 973:
#line 8790 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	/* set_screen_attr ("SIZE", COB_SCREEN_SIZE); */
	CB_PENDING ("SIZE clause");
	current_field->size = cb_get_int (yyvsp[0]);
  }
#line 18044 "parser.c" /* yacc.c:1652  */
    break;

  case 974:
#line 8796 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	set_screen_attr ("UNDERLINE", COB_SCREEN_UNDERLINE);
  }
#line 18052 "parser.c" /* yacc.c:1652  */
    break;

  case 975:
#line 8800 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	set_screen_attr ("OVERLINE", COB_SCREEN_OVERLINE);
	CB_PENDING ("OVERLINE");
  }
#line 18061 "parser.c" /* yacc.c:1652  */
    break;

  case 976:
#line 8805 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	set_screen_attr ("GRID", COB_SCREEN_GRID);
	CB_PENDING ("GRID");
  }
#line 18070 "parser.c" /* yacc.c:1652  */
    break;

  case 977:
#line 8810 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	set_screen_attr ("LEFTLINE", COB_SCREEN_LEFTLINE);
	CB_PENDING ("LEFTLINE");
  }
#line 18079 "parser.c" /* yacc.c:1652  */
    break;

  case 978:
#line 8815 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	set_screen_attr_with_conflict ("AUTO", COB_SCREEN_AUTO,
				       "TAB", COB_SCREEN_TAB);
  }
#line 18088 "parser.c" /* yacc.c:1652  */
    break;

  case 979:
#line 8820 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	set_screen_attr_with_conflict ("TAB", COB_SCREEN_TAB,
				       "AUTO", COB_SCREEN_AUTO);
  }
#line 18097 "parser.c" /* yacc.c:1652  */
    break;

  case 980:
#line 8825 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	set_screen_attr_with_conflict ("SECURE", COB_SCREEN_SECURE,
				       "NO-ECHO", COB_SCREEN_NO_ECHO);
  }
#line 18106 "parser.c" /* yacc.c:1652  */
    break;

  case 981:
#line 8830 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (cb_no_echo_means_secure) {
		set_screen_attr ("SECURE", COB_SCREEN_SECURE);
	} else {
		set_screen_attr_with_conflict ("NO-ECHO", COB_SCREEN_NO_ECHO,
					       "SECURE", COB_SCREEN_SECURE);
	}
  }
#line 18119 "parser.c" /* yacc.c:1652  */
    break;

  case 982:
#line 8839 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	set_screen_attr ("REQUIRED", COB_SCREEN_REQUIRED);
  }
#line 18127 "parser.c" /* yacc.c:1652  */
    break;

  case 983:
#line 8843 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	set_screen_attr ("FULL", COB_SCREEN_FULL);
  }
#line 18135 "parser.c" /* yacc.c:1652  */
    break;

  case 984:
#line 8847 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	set_screen_attr ("PROMPT", COB_SCREEN_PROMPT);
	current_field->screen_prompt = yyvsp[0];
  }
#line 18144 "parser.c" /* yacc.c:1652  */
    break;

  case 985:
#line 8852 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	set_screen_attr ("PROMPT", COB_SCREEN_PROMPT);
  }
#line 18152 "parser.c" /* yacc.c:1652  */
    break;

  case 986:
#line 8856 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	set_screen_attr ("INITIAL", COB_SCREEN_INITIAL);
  }
#line 18160 "parser.c" /* yacc.c:1652  */
    break;

  case 987:
#line 8860 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("LINE", SYN_CLAUSE_16, &check_pic_duplicate);
  }
#line 18168 "parser.c" /* yacc.c:1652  */
    break;

  case 988:
#line 8864 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("LINES clause");	/* note: should only occur with controls */
  }
#line 18176 "parser.c" /* yacc.c:1652  */
    break;

  case 989:
#line 8868 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	/*check_repeated ("CLINE", SYN_CLAUSE_5000, &check_pic_duplicate);*/
  }
#line 18184 "parser.c" /* yacc.c:1652  */
    break;

  case 990:
#line 8872 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("COLUMN", SYN_CLAUSE_17, &check_pic_duplicate);
  }
#line 18192 "parser.c" /* yacc.c:1652  */
    break;

  case 991:
#line 8876 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	/*check_repeated ("CCOL", SYN_CLAUSE_5001, &check_pic_duplicate);*/
  }
#line 18200 "parser.c" /* yacc.c:1652  */
    break;

  case 992:
#line 8880 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
#if 0 /* TODO: implement, and add reverse to BACKGROUND/FOREGROUND-COLOR */
	check_repeated ("COLOR", SYN_CLAUSE_19, &check_pic_duplicate);
	set_screen_attr_with_conflict ("COLOR", COB_SCREEN_COLOR,
				       "BACKGROUND-COLOR", COB_SCREEN_BACKGROUND_COLOR);
	set_screen_attr_with_conflict ("COLOR", COB_SCREEN_COLOR,
				       "FOREGROUND-COLOR", FOREGROUND_COLOR);
#endif
	CB_PENDING ("COLOR clause");
  }
#line 18215 "parser.c" /* yacc.c:1652  */
    break;

  case 993:
#line 8891 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("FOREGROUND-COLOR", SYN_CLAUSE_18, &check_pic_duplicate);
	current_field->screen_foreg = yyvsp[0];
  }
#line 18224 "parser.c" /* yacc.c:1652  */
    break;

  case 994:
#line 8896 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("BACKGROUND-COLOR", SYN_CLAUSE_19, &check_pic_duplicate);
	current_field->screen_backg = yyvsp[0];
  }
#line 18233 "parser.c" /* yacc.c:1652  */
    break;

  case 1003:
#line 8912 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = check_not_88_level (yyvsp[0]);

	check_repeated ("USING", SYN_CLAUSE_20, &check_pic_duplicate);
	current_field->screen_from = yyval;
	current_field->screen_to = yyval;
	current_field->screen_flag |= COB_SCREEN_INPUT;
  }
#line 18246 "parser.c" /* yacc.c:1652  */
    break;

  case 1004:
#line 8921 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("FROM", SYN_CLAUSE_21, &check_pic_duplicate);
	current_field->screen_from = yyvsp[0];
  }
#line 18255 "parser.c" /* yacc.c:1652  */
    break;

  case 1005:
#line 8926 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = check_not_88_level (yyvsp[0]);

	check_repeated ("TO", SYN_CLAUSE_22, &check_pic_duplicate);
	current_field->screen_to = yyval;
	current_field->screen_flag |= COB_SCREEN_INPUT;
  }
#line 18267 "parser.c" /* yacc.c:1652  */
    break;

  case 1007:
#line 8938 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cobc_cs_check |= CB_CS_GRAPHICAL_CONTROL;
  }
#line 18275 "parser.c" /* yacc.c:1652  */
    break;

  case 1307:
#line 9527 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 18281 "parser.c" /* yacc.c:1652  */
    break;

  case 1308:
#line 9528 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 18287 "parser.c" /* yacc.c:1652  */
    break;

  case 1309:
#line 9532 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_int0; }
#line 18293 "parser.c" /* yacc.c:1652  */
    break;

  case 1312:
#line 9540 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_int1; }
#line 18299 "parser.c" /* yacc.c:1652  */
    break;

  case 1316:
#line 9552 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[-1]; }
#line 18305 "parser.c" /* yacc.c:1652  */
    break;

  case 1317:
#line 9553 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_int1; }
#line 18311 "parser.c" /* yacc.c:1652  */
    break;

  case 1318:
#line 9557 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 18317 "parser.c" /* yacc.c:1652  */
    break;

  case 1319:
#line 9558 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_int0; }
#line 18323 "parser.c" /* yacc.c:1652  */
    break;

  case 1320:
#line 9563 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[0]) {
		current_field->screen_line = yyvsp[0];
	}
  }
#line 18333 "parser.c" /* yacc.c:1652  */
    break;

  case 1322:
#line 9573 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_field->screen_flag |= COB_SCREEN_LINE_PLUS;
  }
#line 18341 "parser.c" /* yacc.c:1652  */
    break;

  case 1323:
#line 9577 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_field->screen_flag |= COB_SCREEN_LINE_MINUS;
  }
#line 18349 "parser.c" /* yacc.c:1652  */
    break;

  case 1324:
#line 9584 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[0]) {
		current_field->screen_column = yyvsp[0];
	}
  }
#line 18359 "parser.c" /* yacc.c:1652  */
    break;

  case 1325:
#line 9593 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	/* Nothing */
  }
#line 18367 "parser.c" /* yacc.c:1652  */
    break;

  case 1326:
#line 9597 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_field->screen_flag |= COB_SCREEN_COLUMN_PLUS;
  }
#line 18375 "parser.c" /* yacc.c:1652  */
    break;

  case 1327:
#line 9601 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_field->screen_flag |= COB_SCREEN_COLUMN_MINUS;
  }
#line 18383 "parser.c" /* yacc.c:1652  */
    break;

  case 1328:
#line 9608 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING (_("OCCURS screen items"));
	check_repeated ("OCCURS", SYN_CLAUSE_23, &check_pic_duplicate);
	current_field->occurs_max = cb_get_int (yyvsp[-1]);
	current_field->occurs_min = current_field->occurs_max;
	current_field->indexes++;
	current_field->flag_occurs = 1;
  }
#line 18396 "parser.c" /* yacc.c:1652  */
    break;

  case 1329:
#line 9620 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING (_("GLOBAL screen items"));
  }
#line 18404 "parser.c" /* yacc.c:1652  */
    break;

  case 1330:
#line 9629 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_section = NULL;
	current_paragraph = NULL;
	check_pic_duplicate = 0;
	check_duplicate = 0;
	if (!current_program->entry_convention) {
		current_program->entry_convention = cb_int (CB_CONV_COBOL);
	}
  }
#line 18418 "parser.c" /* yacc.c:1652  */
    break;

  case 1332:
#line 9643 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	current_section = NULL;
	current_paragraph = NULL;
	check_pic_duplicate = 0;
	check_duplicate = 0;
	cobc_in_procedure = 1U;
	cb_set_system_names ();
	backup_current_pos ();
  }
#line 18432 "parser.c" /* yacc.c:1652  */
    break;

  case 1333:
#line 9653 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_tree call_conv = yyvsp[-4];
	if (yyvsp[-3]) {
		call_conv = yyvsp[-3];
		if (yyvsp[-4]) {
			/* note: $4 is likely to be a reference to SPECIAL-NAMES */
			cb_error_x (yyvsp[-3], _("%s and %s are mutually exclusive"),
				"CALL-CONVENTION", "WITH LINKAGE");
		}
	}
	if (call_conv) {
		if (current_program->entry_convention) {
			cb_warning (COBC_WARN_FILLER,
				_("overriding convention specified in ENTRY-CONVENTION"));
		}
		current_program->entry_convention = call_conv;
	} else if (!current_program->entry_convention) {
		current_program->entry_convention = cb_int (CB_CONV_COBOL);
	}
	header_check |= COBC_HD_PROCEDURE_DIVISION;
  }
#line 18458 "parser.c" /* yacc.c:1652  */
    break;

  case 1334:
#line 9675 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (current_program->flag_main
	 && !current_program->flag_chained && yyvsp[-4]) {
		cb_error (_("executable program requested but PROCEDURE/ENTRY has USING clause"));
	}
	/* Main entry point */
	emit_entry (current_program->program_id, 0, yyvsp[-4], NULL);
	current_program->num_proc_params = cb_list_length (yyvsp[-4]);
	if (current_program->source_name) {
		emit_entry (current_program->source_name, 1, yyvsp[-4], NULL);
	}
  }
#line 18475 "parser.c" /* yacc.c:1652  */
    break;

  case 1335:
#line 9688 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (current_paragraph) {
		if (current_paragraph->exit_label) {
			emit_statement (current_paragraph->exit_label);
		}
		emit_statement (cb_build_perform_exit (current_paragraph));
	}
	if (current_section) {
		if (current_section->exit_label) {
			emit_statement (current_section->exit_label);
		}
		emit_statement (cb_build_perform_exit (current_section));
	}
  }
#line 18494 "parser.c" /* yacc.c:1652  */
    break;

  case 1336:
#line 9703 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_tree label;

	/* No PROCEDURE DIVISION header here */
	/* Only a statement is allowed as first element */
	/* Thereafter, sections/paragraphs may be used */
	check_pic_duplicate = 0;
	check_duplicate = 0;
	if (!current_program->entry_convention) {
		current_program->entry_convention = cb_int (CB_CONV_COBOL);
	}
	cobc_in_procedure = 1U;
	label = cb_build_reference ("MAIN SECTION");
	current_section = CB_LABEL (cb_build_label (label, NULL));
	current_section->flag_section = 1;
	current_section->flag_dummy_section = 1;
	current_section->flag_skip_label = !!skip_statements;
	current_section->flag_declaratives = !!in_declaratives;
	current_section->xref.skip = 1;
	emit_statement (CB_TREE (current_section));
	label = cb_build_reference ("MAIN PARAGRAPH");
	current_paragraph = CB_LABEL (cb_build_label (label, NULL));
	current_paragraph->flag_declaratives = !!in_declaratives;
	current_paragraph->flag_skip_label = !!skip_statements;
	current_paragraph->flag_dummy_paragraph = 1;
	current_paragraph->xref.skip = 1;
	emit_statement (CB_TREE (current_paragraph));
	cb_set_system_names ();
  }
#line 18528 "parser.c" /* yacc.c:1652  */
    break;

  case 1338:
#line 9737 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 18536 "parser.c" /* yacc.c:1652  */
    break;

  case 1339:
#line 9741 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	call_mode = CB_CALL_BY_REFERENCE;
	size_mode = CB_SIZE_4;
  }
#line 18545 "parser.c" /* yacc.c:1652  */
    break;

  case 1340:
#line 9746 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (cb_list_length (yyvsp[0]) > MAX_CALL_FIELD_PARAMS) {
		cb_error (_("number of arguments exceeds maximum %d"),
			  MAX_CALL_FIELD_PARAMS);
	}
	yyval = yyvsp[0];
  }
#line 18557 "parser.c" /* yacc.c:1652  */
    break;

  case 1341:
#line 9754 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	call_mode = CB_CALL_BY_REFERENCE;
	if (current_program->prog_type == COB_MODULE_TYPE_FUNCTION) {
		cb_error (_("CHAINING invalid in user FUNCTION"));
	} else {
		current_program->flag_chained = 1;
	}
  }
#line 18570 "parser.c" /* yacc.c:1652  */
    break;

  case 1342:
#line 9763 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (cb_list_length (yyvsp[0]) > MAX_CALL_FIELD_PARAMS) {
		cb_error (_("number of arguments exceeds maximum %d"),
			  MAX_CALL_FIELD_PARAMS);
	}
	yyval = yyvsp[0];
  }
#line 18582 "parser.c" /* yacc.c:1652  */
    break;

  case 1343:
#line 9773 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 18588 "parser.c" /* yacc.c:1652  */
    break;

  case 1344:
#line 9775 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_list_append (yyvsp[-1], yyvsp[0]); }
#line 18594 "parser.c" /* yacc.c:1652  */
    break;

  case 1345:
#line 9780 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_tree		x;
	struct cb_field	*f;

	x = cb_build_identifier (yyvsp[-1], 0);
	if (yyvsp[-2] == cb_int1 && CB_VALID_TREE (x) && cb_ref (x) != cb_error_node) {
		f = CB_FIELD (cb_ref (x));
		f->flag_is_pdiv_opt = 1;
	}

	if (call_mode == CB_CALL_BY_VALUE
	 && CB_REFERENCE_P (yyvsp[-1])
	 && CB_FIELD (cb_ref (yyvsp[-1]))->flag_any_length) {
		cb_error_x (yyvsp[-1], _("ANY LENGTH items may only be BY REFERENCE formal parameters"));
	}

	yyval = CB_BUILD_PAIR (cb_int (call_mode), x);
	CB_SIZES (yyval) = size_mode;
  }
#line 18618 "parser.c" /* yacc.c:1652  */
    break;

  case 1347:
#line 9804 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	call_mode = CB_CALL_BY_REFERENCE;
  }
#line 18626 "parser.c" /* yacc.c:1652  */
    break;

  case 1348:
#line 9808 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (current_program->flag_chained) {
		cb_error (_("%s not allowed in CHAINED programs"), "BY VALUE");
	} else {
		CB_UNFINISHED (_("parameters passed BY VALUE"));
		call_mode = CB_CALL_BY_VALUE;
	}
  }
#line 18639 "parser.c" /* yacc.c:1652  */
    break;

  case 1350:
#line 9821 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (call_mode != CB_CALL_BY_VALUE) {
		cb_error (_("SIZE only allowed for BY VALUE items"));
	} else {
		size_mode = CB_SIZE_AUTO;
	}
  }
#line 18651 "parser.c" /* yacc.c:1652  */
    break;

  case 1351:
#line 9829 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (call_mode != CB_CALL_BY_VALUE) {
		cb_error (_("SIZE only allowed for BY VALUE items"));
	} else {
		size_mode = CB_SIZE_4;
	}
  }
#line 18663 "parser.c" /* yacc.c:1652  */
    break;

  case 1352:
#line 9837 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (call_mode != CB_CALL_BY_VALUE) {
		cb_error (_("SIZE only allowed for BY VALUE items"));
	} else {
		size_mode = CB_SIZE_AUTO | CB_SIZE_UNSIGNED;
	}
  }
#line 18675 "parser.c" /* yacc.c:1652  */
    break;

  case 1353:
#line 9845 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (size_mode) {
		size_mode |= CB_SIZE_UNSIGNED;
	}
  }
#line 18685 "parser.c" /* yacc.c:1652  */
    break;

  case 1355:
#line 9855 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	unsigned char *s = CB_LITERAL (yyvsp[0])->data;
	size_mode = 0;

	if (call_mode != CB_CALL_BY_VALUE) {
		cb_error (_("SIZE only allowed for BY VALUE items"));
	} else if (CB_LITERAL (yyvsp[0])->size != 1) {
		cb_error_x (yyvsp[0], _("invalid value for SIZE"));
	} else {
		size_mode = 0;
		switch (*s) {
		case '1':
			size_mode = CB_SIZE_1;
			break;
		case '2':
			size_mode = CB_SIZE_2;
			break;
		case '4':
			size_mode = CB_SIZE_4;
			break;
		case '8':
			size_mode = CB_SIZE_8;
			break;
		default:
			cb_error_x (yyvsp[0], _("invalid value for SIZE"));
			break;
		}
	}
  }
#line 18719 "parser.c" /* yacc.c:1652  */
    break;

  case 1357:
#line 9893 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING_X (yyvsp[-1], _("MEMORY SIZE phrase in CALL statement"));
  }
#line 18727 "parser.c" /* yacc.c:1652  */
    break;

  case 1358:
#line 9900 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int0;
  }
#line 18735 "parser.c" /* yacc.c:1652  */
    break;

  case 1359:
#line 9904 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (call_mode != CB_CALL_BY_REFERENCE) {
		cb_error (_("OPTIONAL only allowed for BY REFERENCE items"));
		yyval = cb_int0;
	} else {
		yyval = cb_int1;
	}
  }
#line 18748 "parser.c" /* yacc.c:1652  */
    break;

  case 1360:
#line 9916 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (current_program->prog_type == COB_MODULE_TYPE_FUNCTION) {
		cb_error (_("RETURNING clause is required for a FUNCTION"));
	}
  }
#line 18758 "parser.c" /* yacc.c:1652  */
    break;

  case 1361:
#line 9922 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (current_program->flag_main) {
		cb_error (_("RETURNING clause cannot be OMITTED for main program"));
	}
	if (current_program->prog_type == COB_MODULE_TYPE_FUNCTION) {
		cb_error (_("RETURNING clause cannot be OMITTED for a FUNCTION"));
	}
	current_program->flag_void = 1;
  }
#line 18772 "parser.c" /* yacc.c:1652  */
    break;

  case 1362:
#line 9932 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	struct cb_field	*f;

	if (cb_ref (yyvsp[0]) != cb_error_node) {
		f = CB_FIELD_PTR (yyvsp[0]);
		/* standard rule: returning item is allocated in the
		   activating runtime element */
		if (f->storage != CB_STORAGE_LINKAGE) {
			cb_error (_("RETURNING item is not defined in LINKAGE SECTION"));
		} else if (f->level != 1 && f->level != 77) {
			cb_error (_("RETURNING item must have level 01"));
		} else if (f->flag_occurs) {
			cb_error (_("RETURNING item should not have OCCURS"));
		} else {
			if (current_program->prog_type == COB_MODULE_TYPE_FUNCTION) {
				if (f->flag_any_length) {
					cb_error (_("function RETURNING item may not be ANY LENGTH"));
				}
				f->flag_is_returning = 1;
			}
#if 0	/* doesn't work for programs, will be fixed with allocating in the source-unit */
			current_program->returning = yyvsp[0];
#else
			if (current_program->prog_type == COB_MODULE_TYPE_FUNCTION) {
				current_program->returning = yyvsp[0];
			} else {
				CB_PENDING ("program RETURNING");
			}
#endif
		}
	}
  }
#line 18809 "parser.c" /* yacc.c:1652  */
    break;

  case 1364:
#line 9968 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	in_declaratives = 1;
	emit_statement (cb_build_comment ("DECLARATIVES"));
  }
#line 18818 "parser.c" /* yacc.c:1652  */
    break;

  case 1365:
#line 9974 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (needs_field_debug) {
		start_debug = 1;
	}
	in_declaratives = 0;
	in_debugging = 0;
	if (current_paragraph) {
		if (current_paragraph->exit_label) {
			emit_statement (current_paragraph->exit_label);
		}
		emit_statement (cb_build_perform_exit (current_paragraph));
		current_paragraph = NULL;
	}
	if (current_section) {
		if (current_section->exit_label) {
			emit_statement (current_section->exit_label);
		}
		current_section->flag_fatal_check = 1;
		emit_statement (cb_build_perform_exit (current_section));
		current_section = NULL;
	}
	skip_statements = 0;
	emit_statement (cb_build_comment ("END DECLARATIVES"));
	check_unreached = 0;
  }
#line 18848 "parser.c" /* yacc.c:1652  */
    break;

  case 1370:
#line 10012 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (next_label_list) {
		cb_tree	plabel;
		char	name[32];

		snprintf (name, sizeof(name), "L$%d", next_label_id);
		plabel = cb_build_label (cb_build_reference (name), NULL);
		CB_LABEL (plabel)->flag_next_sentence = 1;
		emit_statement (plabel);
		current_program->label_list =
			cb_list_append (current_program->label_list, next_label_list);
		next_label_list = NULL;
		next_label_id++;
	}
	/* check_unreached = 0; */
	cb_end_statement();
  }
#line 18870 "parser.c" /* yacc.c:1652  */
    break;

  case 1372:
#line 10031 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	/* check_unreached = 0; */
	cb_end_statement();
  }
#line 18879 "parser.c" /* yacc.c:1652  */
    break;

  case 1373:
#line 10042 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	non_const_word = 0;
	check_unreached = 0;
	if (cb_build_section_name (yyvsp[-1], 0) == cb_error_node) {
		YYERROR;
	}

	/* Exit the last paragraph/section */
	if (current_paragraph) {
		if (current_paragraph->exit_label) {
			emit_statement (current_paragraph->exit_label);
		}
		emit_statement (cb_build_perform_exit (current_paragraph));
	}
	if (current_section) {
		if (current_section->exit_label) {
			emit_statement (current_section->exit_label);
		}
		emit_statement (cb_build_perform_exit (current_section));
	}
	if (current_program->flag_debugging && !in_debugging) {
		if (current_paragraph || current_section) {
			emit_statement (cb_build_comment (
					"DEBUGGING - Fall through"));
			emit_statement (cb_build_debug (cb_debug_contents,
					"FALL THROUGH", NULL));
		}
	}

	/* Begin a new section */
	current_section = CB_LABEL (cb_build_label (yyvsp[-1], NULL));
	current_section->flag_section = 1;
	/* Careful here, one negation */
	current_section->flag_real_label = !in_debugging;
	current_section->flag_declaratives = !!in_declaratives;
	current_section->flag_skip_label = !!skip_statements;
	current_paragraph = NULL;
  }
#line 18922 "parser.c" /* yacc.c:1652  */
    break;

  case 1374:
#line 10082 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	emit_statement (CB_TREE (current_section));
  }
#line 18930 "parser.c" /* yacc.c:1652  */
    break;

  case 1377:
#line 10093 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_tree label;

	non_const_word = 0;
	check_unreached = 0;
	if (cb_build_section_name (yyvsp[-1], 1) == cb_error_node) {
		YYERROR;
	}

	/* Exit the last paragraph */
	if (current_paragraph) {
		if (current_paragraph->exit_label) {
			emit_statement (current_paragraph->exit_label);
		}
		emit_statement (cb_build_perform_exit (current_paragraph));
		if (current_program->flag_debugging && !in_debugging) {
			emit_statement (cb_build_comment (
					"DEBUGGING - Fall through"));
			emit_statement (cb_build_debug (cb_debug_contents,
					"FALL THROUGH", NULL));
		}
	}

	/* Begin a new paragraph */
	if (!current_section) {
		label = cb_build_reference ("MAIN SECTION");
		current_section = CB_LABEL (cb_build_label (label, NULL));
		current_section->flag_section = 1;
		current_section->flag_dummy_section = 1;
		current_section->flag_declaratives = !!in_declaratives;
		current_section->flag_skip_label = !!skip_statements;
		current_section->xref.skip = 1;
		emit_statement (CB_TREE (current_section));
	}
	current_paragraph = CB_LABEL (cb_build_label (yyvsp[-1], current_section));
	current_paragraph->flag_declaratives = !!in_declaratives;
	current_paragraph->flag_skip_label = !!skip_statements;
	current_paragraph->flag_real_label = !in_debugging;
	current_paragraph->segment = current_section->segment;
	emit_statement (CB_TREE (current_paragraph));
  }
#line 18976 "parser.c" /* yacc.c:1652  */
    break;

  case 1378:
#line 10138 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	non_const_word = 0;
	check_unreached = 0;
	if (cb_build_section_name (yyvsp[0], 0) != cb_error_node) {
		if (is_reserved_word (CB_NAME (yyvsp[0]))) {
			cb_error_x (yyvsp[0], _("'%s' is not a statement"), CB_NAME (yyvsp[0]));
		} else if (is_default_reserved_word (CB_NAME (yyvsp[0]))) {
			cb_error_x (yyvsp[0], _("unknown statement '%s'; it may exist in another dialect"),
				    CB_NAME (yyvsp[0]));
		} else {
			cb_error_x (yyvsp[0], _("unknown statement '%s'"), CB_NAME (yyvsp[0]));
		}
	}
	YYERROR;
  }
#line 18996 "parser.c" /* yacc.c:1652  */
    break;

  case 1379:
#line 10157 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 19004 "parser.c" /* yacc.c:1652  */
    break;

  case 1380:
#line 10161 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
	if (cb_verify (cb_section_segments, _("section segments"))) {
		int segnum = cb_get_int (yyvsp[0]);
		if (segnum > 99) {
			cb_error (_("SECTION segment-number must be less than or equal to 99"));
		} else {
			if (in_declaratives && segnum > 49) {
				cb_error (_("SECTION segment-number in DECLARATIVES must be less than 50"));
			}
			if (!in_declaratives) {
				current_program->flag_segments = 1;
				current_section->segment = segnum;
			} else {
				/* Simon: old version did not allow segments in declaratives at all
					ToDo: check codegen for possible missing parts */
				CB_PENDING (_("SECTION segment within DECLARATIVES"));
			}
		}
	}
  }
#line 19030 "parser.c" /* yacc.c:1652  */
    break;

  case 1381:
#line 10189 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = current_program->exec_list;
	current_program->exec_list = NULL;
	check_unreached = 0;
  }
#line 19040 "parser.c" /* yacc.c:1652  */
    break;

  case 1382:
#line 10194 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = CB_TREE (current_statement);
	current_statement = NULL;
  }
#line 19049 "parser.c" /* yacc.c:1652  */
    break;

  case 1383:
#line 10199 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_list_reverse (current_program->exec_list);
	current_program->exec_list = yyvsp[-2];
	current_statement = CB_STATEMENT (yyvsp[-1]);
  }
#line 19059 "parser.c" /* yacc.c:1652  */
    break;

  case 1384:
#line 10207 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_tree label;

	if (!current_section) {
		label = cb_build_reference ("MAIN SECTION");
		current_section = CB_LABEL (cb_build_label (label, NULL));
		current_section->flag_section = 1;
		current_section->flag_dummy_section = 1;
		current_section->flag_skip_label = !!skip_statements;
		current_section->flag_declaratives = !!in_declaratives;
		current_section->xref.skip = 1;
		emit_statement (CB_TREE (current_section));
	}
	if (!current_paragraph) {
		label = cb_build_reference ("MAIN PARAGRAPH");
		current_paragraph = CB_LABEL (cb_build_label (label, NULL));
		CB_TREE (current_paragraph)->source_file
			= CB_TREE (current_section)->source_file;
		CB_TREE (current_paragraph)->source_line
			= CB_TREE (current_section)->source_line;
		current_paragraph->flag_declaratives = !!in_declaratives;
		current_paragraph->flag_skip_label = !!skip_statements;
		current_paragraph->flag_dummy_paragraph = 1;
		current_paragraph->xref.skip = 1;
		emit_statement (CB_TREE (current_paragraph));
	}
	if (check_headers_present (COBC_HD_PROCEDURE_DIVISION, 0, 0, 0) == 1) {
		if (current_program->prog_type == COB_MODULE_TYPE_PROGRAM) {
			backup_current_pos ();
			emit_entry (current_program->program_id, 0, NULL, NULL);
		}
	}

	cobc_apply_turn_directives ();
  }
#line 19099 "parser.c" /* yacc.c:1652  */
    break;

  case 1385:
#line 10243 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cobc_cs_check = 0;
	cobc_apply_turn_directives ();
  }
#line 19108 "parser.c" /* yacc.c:1652  */
    break;

  case 1386:
#line 10248 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cobc_cs_check = 0;
	cobc_apply_turn_directives ();
  }
#line 19117 "parser.c" /* yacc.c:1652  */
    break;

  case 1450:
#line 10322 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (cb_verify (cb_next_sentence_phrase, "NEXT SENTENCE")) {
		cb_tree label;
		char	name[32];

		begin_statement ("NEXT SENTENCE", 0);
		sprintf (name, "L$%d", next_label_id);
		label = cb_build_reference (name);
		next_label_list = cb_list_add (next_label_list, label);
		emit_statement (cb_build_goto (label, NULL));
	}
	check_unreached = 0;
  }
#line 19135 "parser.c" /* yacc.c:1652  */
    break;

  case 1451:
#line 10336 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyerrok;
	cobc_cs_check = 0;
  }
#line 19144 "parser.c" /* yacc.c:1652  */
    break;

  case 1452:
#line 10347 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_statement ("ACCEPT", TERM_ACCEPT);
	cobc_cs_check = CB_CS_ACCEPT;
  }
#line 19153 "parser.c" /* yacc.c:1652  */
    break;

  case 1454:
#line 10357 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_duplicate = 0;
	check_line_col_duplicate = 0;
	line_column = NULL;
  }
#line 19163 "parser.c" /* yacc.c:1652  */
    break;

  case 1455:
#line 10363 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	/* Check for invalid use of screen clauses */
	if (current_statement->attr_ptr
	 || (!is_screen_field (yyvsp[-3]) && line_column)) {
		cb_verify_x (yyvsp[-3], cb_accept_display_extensions,
			     _("non-standard ACCEPT"));
	}

	if (cb_accept_update && !has_dispattr (COB_SCREEN_NO_UPDATE)) {
		set_dispattr (COB_SCREEN_UPDATE);
	}
	if (cb_accept_auto && !has_dispattr (COB_SCREEN_TAB)) {
		set_dispattr (COB_SCREEN_AUTO);
	}
	if (yyvsp[-3] == cb_null && current_statement->attr_ptr) {
		if (current_statement->attr_ptr->prompt) {
			emit_conflicting_clause_message ("ACCEPT OMITTED",
				_("PROMPT clause"));
		}
		if (current_statement->attr_ptr->size_is) {
			emit_conflicting_clause_message ("ACCEPT OMITTED",
				_("SIZE IS clause"));
		}
	}
	cobc_cs_check = 0;
	cb_emit_accept (yyvsp[-3], line_column, current_statement->attr_ptr);
  }
#line 19195 "parser.c" /* yacc.c:1652  */
    break;

  case 1456:
#line 10391 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_duplicate = 0;
	check_line_col_duplicate = 0;
	line_column = NULL;
  }
#line 19205 "parser.c" /* yacc.c:1652  */
    break;

  case 1457:
#line 10397 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cobc_cs_check = 0;
	CB_PENDING ("ACCEPT FROM SCREEN");
  }
#line 19214 "parser.c" /* yacc.c:1652  */
    break;

  case 1458:
#line 10402 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_accept_line_or_col (yyvsp[-2], 0);
  }
#line 19222 "parser.c" /* yacc.c:1652  */
    break;

  case 1459:
#line 10406 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_accept_line_or_col (yyvsp[-2], 1);
  }
#line 19230 "parser.c" /* yacc.c:1652  */
    break;

  case 1460:
#line 10410 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	/* information about terminal and its capabilities
	cb_emit_accept_terminal_info ($1); */
	CB_PENDING ("ACCEPT FROM TERMINAL INFO");
  }
#line 19240 "parser.c" /* yacc.c:1652  */
    break;

  case 1461:
#line 10416 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	/* information about OS and runtime features
	cb_emit_accept_system_info ($1); */
	CB_PENDING ("ACCEPT FROM SYSTEM INFO");
  }
#line 19250 "parser.c" /* yacc.c:1652  */
    break;

  case 1462:
#line 10422 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cobc_cs_check = 0;
	cb_emit_accept_date_yyyymmdd (yyvsp[-3]);
  }
#line 19259 "parser.c" /* yacc.c:1652  */
    break;

  case 1463:
#line 10427 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cobc_cs_check = 0;
	cb_emit_accept_date (yyvsp[-2]);
  }
#line 19268 "parser.c" /* yacc.c:1652  */
    break;

  case 1464:
#line 10432 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cobc_cs_check = 0;
	cb_emit_accept_day_yyyyddd (yyvsp[-3]);
  }
#line 19277 "parser.c" /* yacc.c:1652  */
    break;

  case 1465:
#line 10437 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cobc_cs_check = 0;
	cb_emit_accept_day (yyvsp[-2]);
  }
#line 19286 "parser.c" /* yacc.c:1652  */
    break;

  case 1466:
#line 10442 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_accept_day_of_week (yyvsp[-2]);
  }
#line 19294 "parser.c" /* yacc.c:1652  */
    break;

  case 1467:
#line 10448 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_accept_escape_key (yyvsp[-3]);
  }
#line 19302 "parser.c" /* yacc.c:1652  */
    break;

  case 1468:
#line 10454 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_accept_exception_status (yyvsp[-3]);
  }
#line 19310 "parser.c" /* yacc.c:1652  */
    break;

  case 1469:
#line 10458 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	/* check is data from keyboard available? "1", else "0"
	cb_emit_accept_input_status ($1); */
	CB_PENDING ("ACCEPT FROM INPUT STATUS");
  }
#line 19320 "parser.c" /* yacc.c:1652  */
    break;

  case 1470:
#line 10464 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_accept_time (yyvsp[-2]);
  }
#line 19328 "parser.c" /* yacc.c:1652  */
    break;

  case 1471:
#line 10468 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cobc_cs_check = 0;
	cb_emit_accept_user_name (yyvsp[-3]);
  }
#line 19337 "parser.c" /* yacc.c:1652  */
    break;

  case 1472:
#line 10473 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_accept_command_line (yyvsp[-2]);
  }
#line 19345 "parser.c" /* yacc.c:1652  */
    break;

  case 1473:
#line 10477 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_accept_environment (yyvsp[-3]);
  }
#line 19353 "parser.c" /* yacc.c:1652  */
    break;

  case 1474:
#line 10481 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_get_environment (yyvsp[-1], yyvsp[-4]);
  }
#line 19361 "parser.c" /* yacc.c:1652  */
    break;

  case 1475:
#line 10485 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_accept_arg_number (yyvsp[-2]);
  }
#line 19369 "parser.c" /* yacc.c:1652  */
    break;

  case 1476:
#line 10489 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_accept_arg_value (yyvsp[-3]);
  }
#line 19377 "parser.c" /* yacc.c:1652  */
    break;

  case 1477:
#line 10493 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_accept_mnemonic (yyvsp[-2], yyvsp[0]);
  }
#line 19385 "parser.c" /* yacc.c:1652  */
    break;

  case 1478:
#line 10497 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_accept_name (yyvsp[-2], yyvsp[0]);
  }
#line 19393 "parser.c" /* yacc.c:1652  */
    break;

  case 1479:
#line 10501 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_verify_x (yyvsp[-1], cb_accept_display_extensions,
		     _("non-standard ACCEPT"));

	if (cb_accept_update && !has_dispattr (COB_SCREEN_NO_UPDATE)) {
		set_dispattr (COB_SCREEN_UPDATE);
	}
	if (cb_accept_auto && !has_dispattr (COB_SCREEN_TAB)) {
		set_dispattr (COB_SCREEN_AUTO);
	}
	cobc_cs_check = 0;
	cb_emit_accept (yyvsp[-1], line_column, current_statement->attr_ptr);
  }
#line 19411 "parser.c" /* yacc.c:1652  */
    break;

  case 1480:
#line 10515 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("ACCEPT MESSAGE COUNT");
  }
#line 19419 "parser.c" /* yacc.c:1652  */
    break;

  case 1482:
#line 10523 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_null;
  }
#line 19427 "parser.c" /* yacc.c:1652  */
    break;

  case 1483:
#line 10529 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_duplicate = 0;
	check_line_col_duplicate = 0;
	line_column = NULL;
  }
#line 19437 "parser.c" /* yacc.c:1652  */
    break;

  case 1484:
#line 10535 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 19445 "parser.c" /* yacc.c:1652  */
    break;

  case 1485:
#line 10542 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	line_column = CB_BUILD_PAIR (yyvsp[-3], yyvsp[-1]);
  }
#line 19453 "parser.c" /* yacc.c:1652  */
    break;

  case 1486:
#line 10546 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	line_column = CB_BUILD_PAIR (yyvsp[-2], cb_int0);
  }
#line 19461 "parser.c" /* yacc.c:1652  */
    break;

  case 1487:
#line 10550 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	line_column = CB_BUILD_PAIR (cb_int0, yyvsp[-1]);
  }
#line 19469 "parser.c" /* yacc.c:1652  */
    break;

  case 1488:
#line 10557 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 19477 "parser.c" /* yacc.c:1652  */
    break;

  case 1489:
#line 10561 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_build_binary_op (yyvsp[-2], '+', yyvsp[0]);
  }
#line 19485 "parser.c" /* yacc.c:1652  */
    break;

  case 1490:
#line 10565 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_build_binary_op (yyvsp[-2], '-', yyvsp[0]);
  }
#line 19493 "parser.c" /* yacc.c:1652  */
    break;

  case 1498:
#line 10589 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	  check_repeated ("FROM CRT", SYN_CLAUSE_2, &check_duplicate);
  }
#line 19501 "parser.c" /* yacc.c:1652  */
    break;

  case 1499:
#line 10593 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	  check_repeated ("MODE IS BLOCK", SYN_CLAUSE_3, &check_duplicate);
  }
#line 19509 "parser.c" /* yacc.c:1652  */
    break;

  case 1501:
#line 10598 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated (_("TIME-OUT or BEFORE TIME clauses"), SYN_CLAUSE_4,
			&check_duplicate);
	set_attribs (NULL, NULL, NULL, yyvsp[0], NULL, NULL, 0);
  }
#line 19519 "parser.c" /* yacc.c:1652  */
    break;

  case 1508:
#line 10623 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	set_attr_with_conflict ("LINE", SYN_CLAUSE_1,
				_("AT screen-location"), SYN_CLAUSE_3, 1,
				&check_line_col_duplicate);

	if ((CB_LITERAL_P (yyvsp[0]) && cb_get_int (yyvsp[0]) == 0) || yyvsp[0] == cb_zero) {
		cb_verify (cb_accept_display_extensions, "LINE 0");
	}

	if (!line_column) {
		line_column = CB_BUILD_PAIR (yyvsp[0], cb_int0);
	} else {
		CB_PAIR_X (line_column) = yyvsp[0];
	}
  }
#line 19539 "parser.c" /* yacc.c:1652  */
    break;

  case 1509:
#line 10639 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	set_attr_with_conflict ("COLUMN", SYN_CLAUSE_2,
				_("AT screen-location"), SYN_CLAUSE_3, 1,
				&check_line_col_duplicate);

	if ((CB_LITERAL_P (yyvsp[0]) && cb_get_int (yyvsp[0]) == 0) || yyvsp[0] == cb_zero) {
		cb_verify (cb_accept_display_extensions, "COLUMN 0");
	}

	if (!line_column) {
		line_column = CB_BUILD_PAIR (cb_int0, yyvsp[0]);
	} else {
		CB_PAIR_Y (line_column) = yyvsp[0];
	}
  }
#line 19559 "parser.c" /* yacc.c:1652  */
    break;

  case 1510:
#line 10655 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	set_attr_with_conflict (_("AT screen-location"), SYN_CLAUSE_3,
				_("LINE or COLUMN"), SYN_CLAUSE_1 | SYN_CLAUSE_2,
				1, &check_line_col_duplicate);

	cb_verify (cb_accept_display_extensions, "AT clause");

	line_column = yyvsp[0];
  }
#line 19573 "parser.c" /* yacc.c:1652  */
    break;

  case 1511:
#line 10668 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	/* FIXME: arithmetic expression should be possible, too, only numeric literals! */
	yyval = yyvsp[0];
  }
#line 19582 "parser.c" /* yacc.c:1652  */
    break;

  case 1512:
#line 10676 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	/* FIXME: arithmetic expression should be possible, too, only numeric literals! */
	yyval = yyvsp[0];
  }
#line 19591 "parser.c" /* yacc.c:1652  */
    break;

  case 1513:
#line 10684 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cobc_cs_check = 0;
  }
#line 19599 "parser.c" /* yacc.c:1652  */
    break;

  case 1514:
#line 10691 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("AUTO", SYN_CLAUSE_5, &check_duplicate);
	set_dispattr_with_conflict ("AUTO", COB_SCREEN_AUTO,
				    "TAB", COB_SCREEN_TAB);
  }
#line 19609 "parser.c" /* yacc.c:1652  */
    break;

  case 1515:
#line 10697 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("TAB", SYN_CLAUSE_6, &check_duplicate);
	set_dispattr_with_conflict ("TAB", COB_SCREEN_TAB,
				    "AUTO", COB_SCREEN_AUTO);
  }
#line 19619 "parser.c" /* yacc.c:1652  */
    break;

  case 1516:
#line 10703 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("BELL", SYN_CLAUSE_7, &check_duplicate);
	set_dispattr (COB_SCREEN_BELL);
  }
#line 19628 "parser.c" /* yacc.c:1652  */
    break;

  case 1517:
#line 10708 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("BELL", SYN_CLAUSE_7, &check_duplicate);
	/* FIXME: do we need a COB_NO_SCREEN_BELL here?
	set_dispattr (COB_SCREEN_BELL); */
  }
#line 19638 "parser.c" /* yacc.c:1652  */
    break;

  case 1518:
#line 10714 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("BLINK", SYN_CLAUSE_8, &check_duplicate);
	set_dispattr (COB_SCREEN_BLINK);
  }
#line 19647 "parser.c" /* yacc.c:1652  */
    break;

  case 1519:
#line 10719 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("CONVERSION", SYN_CLAUSE_9, &check_duplicate);
	CB_PENDING ("ACCEPT CONVERSION");
  }
#line 19656 "parser.c" /* yacc.c:1652  */
    break;

  case 1520:
#line 10724 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	/* FIXME: arithmetic expression should be possible, too! */
	if (current_program->cursor_pos) {
		emit_duplicate_clause_message ("CURSOR");
	} else {
		/* TODO: actually reasonable and easy extension: an 
		         *offset within the field* [auto-correct to 1/max]
				 (when variable also stored back on return)
		*/
		CB_PENDING ("ACCEPT ... WITH CURSOR");
	}
  }
#line 19673 "parser.c" /* yacc.c:1652  */
    break;

  case 1521:
#line 10737 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("FULL", SYN_CLAUSE_10, &check_duplicate);
	set_dispattr (COB_SCREEN_FULL);
  }
#line 19682 "parser.c" /* yacc.c:1652  */
    break;

  case 1522:
#line 10742 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("LEFTLINE", SYN_CLAUSE_12, &check_duplicate);
	set_dispattr (COB_SCREEN_LEFTLINE);
  }
#line 19691 "parser.c" /* yacc.c:1652  */
    break;

  case 1523:
#line 10747 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("LOWER", SYN_CLAUSE_13, &check_duplicate);
	set_dispattr_with_conflict ("LOWER", COB_SCREEN_LOWER,
				    "UPPER", COB_SCREEN_UPPER);
  }
#line 19701 "parser.c" /* yacc.c:1652  */
    break;

  case 1524:
#line 10753 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("HIGHLIGHT", SYN_CLAUSE_11, &check_duplicate);
	set_dispattr_with_conflict ("HIGHLIGHT", COB_SCREEN_HIGHLIGHT,
				    "LOWLIGHT", COB_SCREEN_LOWLIGHT);
  }
#line 19711 "parser.c" /* yacc.c:1652  */
    break;

  case 1525:
#line 10759 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("LOWLIGHT", SYN_CLAUSE_14, &check_duplicate);
	set_dispattr_with_conflict ("LOWLIGHT", COB_SCREEN_LOWLIGHT,
				    "HIGHLIGHT", COB_SCREEN_HIGHLIGHT);
  }
#line 19721 "parser.c" /* yacc.c:1652  */
    break;

  case 1526:
#line 10766 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("SAME phrase");
	/* may not be specified along with the UNDERLINED, BLINK, REVERSED,
	HIGH, LOW, STANDARD, COLOR, FOREGROUND-COLOR, or BACKGROUND-COLOR phrases */
  }
#line 19731 "parser.c" /* yacc.c:1652  */
    break;

  case 1527:
#line 10772 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("STANDARD intensity");
  }
#line 19739 "parser.c" /* yacc.c:1652  */
    break;

  case 1528:
#line 10776 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("BACKGROUND intensity");
  }
#line 19747 "parser.c" /* yacc.c:1652  */
    break;

  case 1529:
#line 10780 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("BACKGROUND intensity");
  }
#line 19755 "parser.c" /* yacc.c:1652  */
    break;

  case 1530:
#line 10784 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("BACKGROUND intensity");
  }
#line 19763 "parser.c" /* yacc.c:1652  */
    break;

  case 1531:
#line 10788 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (cb_no_echo_means_secure) {
		check_repeated ("SECURE", SYN_CLAUSE_20, &check_duplicate);
		set_dispattr (COB_SCREEN_SECURE);
	} else {
		check_repeated ("NO-ECHO", SYN_CLAUSE_15, &check_duplicate);
		set_dispattr_with_conflict ("NO-ECHO", COB_SCREEN_NO_ECHO,
					    "SECURE", COB_SCREEN_SECURE);
	}
  }
#line 19778 "parser.c" /* yacc.c:1652  */
    break;

  case 1532:
#line 10799 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("OVERLINE", SYN_CLAUSE_16, &check_duplicate);
	set_dispattr (COB_SCREEN_OVERLINE);
  }
#line 19787 "parser.c" /* yacc.c:1652  */
    break;

  case 1533:
#line 10804 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("PROMPT", SYN_CLAUSE_17, &check_duplicate);
	set_attribs (NULL, NULL, NULL, NULL, yyvsp[0], NULL, COB_SCREEN_PROMPT);
  }
#line 19796 "parser.c" /* yacc.c:1652  */
    break;

  case 1534:
#line 10809 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("PROMPT", SYN_CLAUSE_17, &check_duplicate);
	set_dispattr (COB_SCREEN_PROMPT);
  }
#line 19805 "parser.c" /* yacc.c:1652  */
    break;

  case 1535:
#line 10814 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("REQUIRED", SYN_CLAUSE_18, &check_duplicate);
	set_dispattr (COB_SCREEN_REQUIRED);
  }
#line 19814 "parser.c" /* yacc.c:1652  */
    break;

  case 1536:
#line 10819 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("REVERSE-VIDEO", SYN_CLAUSE_19, &check_duplicate);
	set_dispattr (COB_SCREEN_REVERSE);
  }
#line 19823 "parser.c" /* yacc.c:1652  */
    break;

  case 1537:
#line 10824 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("SECURE", SYN_CLAUSE_20, &check_duplicate);
	set_dispattr_with_conflict ("SECURE", COB_SCREEN_SECURE,
				    "NO-ECHO", COB_SCREEN_NO_ECHO);
  }
#line 19833 "parser.c" /* yacc.c:1652  */
    break;

  case 1538:
#line 10830 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	/* FIXME: arithmetic expression should be possible, too! */
	check_repeated ("SIZE", SYN_CLAUSE_21, &check_duplicate);
	set_attribs (NULL, NULL, NULL, NULL, NULL, yyvsp[0], 0);
  }
#line 19843 "parser.c" /* yacc.c:1652  */
    break;

  case 1539:
#line 10836 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("UNDERLINE", SYN_CLAUSE_22, &check_duplicate);
	set_dispattr (COB_SCREEN_UNDERLINE);
  }
#line 19852 "parser.c" /* yacc.c:1652  */
    break;

  case 1540:
#line 10841 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("NO UPDATE", SYN_CLAUSE_23, &check_duplicate);
	set_dispattr_with_conflict ("NO UPDATE", COB_SCREEN_NO_UPDATE,
				    "UPDATE", COB_SCREEN_UPDATE);
  }
#line 19862 "parser.c" /* yacc.c:1652  */
    break;

  case 1541:
#line 10847 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("UPDATE", SYN_CLAUSE_24, &check_duplicate);
	set_dispattr_with_conflict ("UPDATE", COB_SCREEN_UPDATE,
				    "NO UPDATE", COB_SCREEN_NO_UPDATE);
  }
#line 19872 "parser.c" /* yacc.c:1652  */
    break;

  case 1542:
#line 10853 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("UPPER", SYN_CLAUSE_25, &check_duplicate);
	set_dispattr_with_conflict ("UPPER", COB_SCREEN_UPPER,
				    "LOWER", COB_SCREEN_LOWER);
  }
#line 19882 "parser.c" /* yacc.c:1652  */
    break;

  case 1543:
#line 10859 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	/* FIXME: arithmetic expression should be possible, too! */
	check_repeated ("FOREGROUND-COLOR", SYN_CLAUSE_26, &check_duplicate);
	check_repeated ("BACKGROUND-COLOR", SYN_CLAUSE_27, &check_duplicate);
	CB_PENDING ("COLOR");
  }
#line 19893 "parser.c" /* yacc.c:1652  */
    break;

  case 1544:
#line 10866 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("FOREGROUND-COLOR", SYN_CLAUSE_26, &check_duplicate);
	set_attribs (yyvsp[0], NULL, NULL, NULL, NULL, NULL, 0);
  }
#line 19902 "parser.c" /* yacc.c:1652  */
    break;

  case 1545:
#line 10871 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("BACKGROUND-COLOR", SYN_CLAUSE_27, &check_duplicate);
	set_attribs (NULL, yyvsp[0], NULL, NULL, NULL, NULL, 0);
  }
#line 19911 "parser.c" /* yacc.c:1652  */
    break;

  case 1546:
#line 10876 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("SCROLL UP", SYN_CLAUSE_28, &check_duplicate);
	set_attribs_with_conflict (NULL, NULL, yyvsp[0], NULL, NULL, NULL,
				   "SCROLL UP", COB_SCREEN_SCROLL_UP,
				   "SCROLL DOWN", COB_SCREEN_SCROLL_DOWN);
  }
#line 19922 "parser.c" /* yacc.c:1652  */
    break;

  case 1547:
#line 10883 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("SCROLL DOWN", SYN_CLAUSE_19, &check_duplicate);
	set_attribs_with_conflict (NULL, NULL, yyvsp[0], NULL, NULL, NULL,
				   "SCROLL DOWN", COB_SCREEN_SCROLL_DOWN,
				   "SCROLL UP", COB_SCREEN_SCROLL_UP);
  }
#line 19933 "parser.c" /* yacc.c:1652  */
    break;

  case 1548:
#line 10890 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated (_("TIME-OUT or BEFORE TIME clauses"), SYN_CLAUSE_4,
			&check_duplicate);
	set_attribs (NULL, NULL, NULL, yyvsp[0], NULL, NULL, 0);
  }
#line 19943 "parser.c" /* yacc.c:1652  */
    break;

  case 1552:
#line 10903 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("CONTROL KEY", SYN_CLAUSE_29, &check_duplicate);
	CB_PENDING ("CONTROL KEY");
#if 0 /* should generate the following *after* the ACCEPT is finished */
	cb_emit_accept_escape_key (yyvsp[0]);
#endif
  }
#line 19955 "parser.c" /* yacc.c:1652  */
    break;

  case 1561:
#line 10931 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_WARNING (yyvsp[(-2) - (0)], ACCEPT);
  }
#line 19963 "parser.c" /* yacc.c:1652  */
    break;

  case 1562:
#line 10935 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_CLEAR (yyvsp[(-2) - (1)], ACCEPT);
# if 0 /* activate only for debugging purposes for attribs
	FIXME: Replace by DEBUG_LOG function */
	if (current_statement->attr_ptr) {
		print_bits (current_statement->attr_ptr->dispattrs);
	} else {
		fputs("No Attribs", stderr);
	}
#endif
  }
#line 19979 "parser.c" /* yacc.c:1652  */
    break;

  case 1563:
#line 10953 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_statement ("ADD", TERM_ADD);
  }
#line 19987 "parser.c" /* yacc.c:1652  */
    break;

  case 1565:
#line 10962 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_arithmetic (yyvsp[-1], '+', cb_build_binary_list (yyvsp[-3], '+'));
  }
#line 19995 "parser.c" /* yacc.c:1652  */
    break;

  case 1566:
#line 10966 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[-3]) {
		cb_list_add (yyvsp[-4], yyvsp[-3]);
	}
	cb_emit_arithmetic (yyvsp[-1], 0, cb_build_binary_list (yyvsp[-4], '+'));
  }
#line 20006 "parser.c" /* yacc.c:1652  */
    break;

  case 1567:
#line 10973 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_corresponding (cb_build_add, yyvsp[-2], yyvsp[-4], yyvsp[-1]);
  }
#line 20014 "parser.c" /* yacc.c:1652  */
    break;

  case 1568:
#line 10977 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("ADD TABLE");
	cb_emit_tab_arithmetic (cb_build_add, yyvsp[-4], yyvsp[-6], yyvsp[-3], yyvsp[-2], yyvsp[-1]);
  }
#line 20023 "parser.c" /* yacc.c:1652  */
    break;

  case 1569:
#line 10984 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 20029 "parser.c" /* yacc.c:1652  */
    break;

  case 1570:
#line 10985 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 20035 "parser.c" /* yacc.c:1652  */
    break;

  case 1571:
#line 10990 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_WARNING (yyvsp[(-2) - (0)], ADD);
  }
#line 20043 "parser.c" /* yacc.c:1652  */
    break;

  case 1572:
#line 10994 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_CLEAR (yyvsp[(-2) - (1)], ADD);
  }
#line 20051 "parser.c" /* yacc.c:1652  */
    break;

  case 1573:
#line 11004 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_statement ("ALLOCATE", 0);
	cobc_cs_check = CB_CS_ALLOCATE;
	current_statement->flag_no_based = 1;
  }
#line 20061 "parser.c" /* yacc.c:1652  */
    break;

  case 1575:
#line 11014 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_allocate (yyvsp[-3], yyvsp[0], NULL, yyvsp[-2]);
  }
#line 20069 "parser.c" /* yacc.c:1652  */
    break;

  case 1576:
#line 11018 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[0] == NULL) {
		cb_error_x (CB_TREE (current_statement),
			    _("ALLOCATE CHARACTERS requires RETURNING clause"));
	} else {
		cb_emit_allocate (NULL, yyvsp[0], yyvsp[-4], yyvsp[-2]);
	}
  }
#line 20082 "parser.c" /* yacc.c:1652  */
    break;

  case 1578:
#line 11031 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	int adressing = cb_get_int (yyvsp[0]);

	if (adressing == 24
	 || adressing == 31) {
		cb_warning (COBC_WARN_FILLER, _("ignoring %s phrase"), "LOC");
	} else {
		cb_error (_("addressing mode should be either 24 or 31 bit"));
	}
  }
#line 20097 "parser.c" /* yacc.c:1652  */
    break;

  case 1579:
#line 11043 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 20103 "parser.c" /* yacc.c:1652  */
    break;

  case 1580:
#line 11044 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 20109 "parser.c" /* yacc.c:1652  */
    break;

  case 1581:
#line 11052 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_statement ("ALTER", 0);
	cb_verify (cb_alter_statement, "ALTER");
  }
#line 20118 "parser.c" /* yacc.c:1652  */
    break;

  case 1585:
#line 11066 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_alter (yyvsp[-3], yyvsp[0]);
  }
#line 20126 "parser.c" /* yacc.c:1652  */
    break;

  case 1588:
#line 11078 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_statement ("CALL", TERM_CALL);
	cobc_cs_check = CB_CS_CALL;
	call_nothing = 0;
	cobc_allow_program_name = 1;
	backup_current_pos ();
  }
#line 20138 "parser.c" /* yacc.c:1652  */
    break;

  case 1589:
#line 11087 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cobc_cs_check = 0;
  }
#line 20146 "parser.c" /* yacc.c:1652  */
    break;

  case 1590:
#line 11094 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cobc_allow_program_name = 0;
  }
#line 20154 "parser.c" /* yacc.c:1652  */
    break;

  case 1591:
#line 11102 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	int call_conv = 0;
	int call_conv_local = 0;

	if (current_program->prog_type == COB_MODULE_TYPE_PROGRAM
	    && !current_program->flag_recursive
	    && is_recursive_call (yyvsp[-6])) {
		cb_warning_x (COBC_WARN_FILLER, yyvsp[-6],
			_("recursive program call - assuming RECURSIVE attribute"));
		current_program->flag_recursive = 1;
	}
	call_conv = current_call_convention;
	if (yyvsp[-3]) {
		if (current_call_convention & CB_CONV_STATIC_LINK) {
			call_conv = CB_INTEGER (yyvsp[-3])->val | CB_CONV_STATIC_LINK;
		} else {
			call_conv = CB_INTEGER (yyvsp[-3])->val;
		}
		if (yyvsp[-8]) {
			/* note: $1 is likely to be a reference to SPECIAL-NAMES */
			cb_error_x (yyvsp[-3], _("%s and %s are mutually exclusive"),
				"CALL-CONVENTION", "WITH LINKAGE");
		}
	}
	if ((CB_PAIR_X (yyvsp[0]) != NULL)
	 && (call_conv & CB_CONV_STATIC_LINK)) {
		cb_warning_x (COBC_WARN_FILLER, yyvsp[-6],
		    _("STATIC CALL convention ignored because of ON EXCEPTION"));
		call_conv &= ~CB_CONV_STATIC_LINK;
	}
	if (yyvsp[-8]) {
		if (CB_INTEGER_P (yyvsp[-8])) {
			call_conv_local = CB_INTEGER (yyvsp[-8])->val;
			if ((CB_PAIR_X (yyvsp[0]) != NULL)
			 && (call_conv_local & CB_CONV_STATIC_LINK)) {
				cb_warning_x (COBC_WARN_FILLER, yyvsp[-8],
					_("ON EXCEPTION ignored because of STATIC CALL"));
				CB_PAIR_X (yyvsp[0]) = NULL;
			}
			call_conv |= call_conv_local;
			if (CB_INTEGER (yyvsp[-8])->val & CB_CONV_COBOL) {
				call_conv &= ~CB_CONV_STDCALL;
			} else {
				call_conv &= ~CB_CONV_COBOL;
			}
		} else {
			call_conv = cb_get_int(yyvsp[-8]);
		}
	}
	/* For CALL ... RETURNING NOTHING, set the call convention bit */
	if (call_nothing) {
		call_conv |= CB_CONV_NO_RET_UPD;
	}
	cb_emit_call (yyvsp[-6], yyvsp[-2], yyvsp[-1], CB_PAIR_X (yyvsp[0]), CB_PAIR_Y (yyvsp[0]),
		      cb_int (call_conv), yyvsp[-7], yyvsp[-4], backup_source_line);
  }
#line 20215 "parser.c" /* yacc.c:1652  */
    break;

  case 1592:
#line 11162 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 20223 "parser.c" /* yacc.c:1652  */
    break;

  case 1593:
#line 11166 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	/* FIXME: hack - fake cs for context-sensitive WITH ... LINKAGE */
	cobc_cs_check |= CB_CS_OPTIONS;
	backup_current_pos ();
  }
#line 20233 "parser.c" /* yacc.c:1652  */
    break;

  case 1594:
#line 11172 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[-1];
	restore_backup_pos (yyval);
	cobc_cs_check ^= CB_CS_OPTIONS;
	cb_verify_x (yyval, cb_call_convention_linkage, "WITH ... LINKAGE");
  }
#line 20244 "parser.c" /* yacc.c:1652  */
    break;

  case 1595:
#line 11182 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int (CB_CONV_STDCALL);
  }
#line 20252 "parser.c" /* yacc.c:1652  */
    break;

  case 1596:
#line 11186 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int (CB_CONV_C);
  }
#line 20260 "parser.c" /* yacc.c:1652  */
    break;

  case 1597:
#line 11190 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int (CB_CONV_PASCAL);
  }
#line 20268 "parser.c" /* yacc.c:1652  */
    break;

  case 1598:
#line 11197 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 20276 "parser.c" /* yacc.c:1652  */
    break;

  case 1599:
#line 11201 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_verify (cb_call_convention_mnemonic, "CALL-/ENTRY-CONVENTION");
	yyval = yyvsp[0];
  }
#line 20285 "parser.c" /* yacc.c:1652  */
    break;

  case 1600:
#line 11209 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (current_call_convention & CB_CONV_COBOL) {
		yyval = cb_int (CB_CONV_STATIC_LINK | CB_CONV_COBOL);
	} else {
		yyval = cb_int (CB_CONV_STATIC_LINK);
	}
  }
#line 20297 "parser.c" /* yacc.c:1652  */
    break;

  case 1601:
#line 11217 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int (CB_CONV_STDCALL);
  }
#line 20305 "parser.c" /* yacc.c:1652  */
    break;

  case 1602:
#line 11221 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int (CB_CONV_C);
  }
#line 20313 "parser.c" /* yacc.c:1652  */
    break;

  case 1603:
#line 11225 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int (CB_CONV_C);
  }
#line 20321 "parser.c" /* yacc.c:1652  */
    break;

  case 1604:
#line 11229 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int (CB_CONV_PASCAL);
  }
#line 20329 "parser.c" /* yacc.c:1652  */
    break;

  case 1605:
#line 11233 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_tree		x;

	x = cb_ref (yyvsp[0]);
	if (CB_VALID_TREE (x)) {
		if (CB_SYSTEM_NAME(x)->token != CB_FEATURE_CONVENTION) {
			cb_error_x (yyvsp[0], _("invalid mnemonic name"));
			yyval = NULL;
		} else {
			yyval = CB_SYSTEM_NAME(x)->value;
		}
	} else {
		yyval = NULL;
	}
  }
#line 20349 "parser.c" /* yacc.c:1652  */
    break;

  case 1606:
#line 11252 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (CB_LITERAL_P (yyvsp[0])) {
		cb_trim_program_id (yyvsp[0]);
	}
  }
#line 20359 "parser.c" /* yacc.c:1652  */
    break;

  case 1607:
#line 11258 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_verify (cb_program_prototypes, _("CALL/CANCEL with program-prototype-name"));
	/* hack to push the prototype name */
	if (yyvsp[0] && CB_REFERENCE_P (yyvsp[0])) {
		if (yyvsp[-1]) {
			cb_warning_x (COBC_WARN_FILLER, yyvsp[-1], _("id/literal ignored, using prototype name"));
		}
		yyval = yyvsp[0];
	} else if (yyvsp[-1] && CB_LITERAL_P (yyvsp[-1])) {
		yyval = yyvsp[-1];
	} else {
		cb_error (_("NESTED phrase is only valid with literal"));
		yyval = cb_error_node;
	}
  }
#line 20379 "parser.c" /* yacc.c:1652  */
    break;

  case 1608:
#line 11277 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 20387 "parser.c" /* yacc.c:1652  */
    break;

  case 1609:
#line 11282 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (CB_LITERAL_P (yyvsp[-1])) {
		cb_trim_program_id (yyvsp[-1]);
	}
	yyval = yyvsp[-1];
  }
#line 20398 "parser.c" /* yacc.c:1652  */
    break;

  case 1610:
#line 11292 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("NESTED phrase for CALL statement");
  }
#line 20406 "parser.c" /* yacc.c:1652  */
    break;

  case 1612:
#line 11300 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 20414 "parser.c" /* yacc.c:1652  */
    break;

  case 1613:
#line 11304 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	call_mode = CB_CALL_BY_REFERENCE;
	size_mode = CB_SIZE_4;
  }
#line 20423 "parser.c" /* yacc.c:1652  */
    break;

  case 1614:
#line 11309 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (cb_list_length (yyvsp[0]) > MAX_CALL_FIELD_PARAMS) {
		cb_error_x (CB_TREE (current_statement),
			    _("number of arguments exceeds maximum %d"),
			    MAX_CALL_FIELD_PARAMS);
	}
	yyval = yyvsp[0];
  }
#line 20436 "parser.c" /* yacc.c:1652  */
    break;

  case 1615:
#line 11320 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 20442 "parser.c" /* yacc.c:1652  */
    break;

  case 1616:
#line 11322 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_list_append (yyvsp[-1], yyvsp[0]); }
#line 20448 "parser.c" /* yacc.c:1652  */
    break;

  case 1617:
#line 11327 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (call_mode != CB_CALL_BY_REFERENCE) {
		cb_error_x (CB_TREE (current_statement),
			    _("OMITTED only allowed when arguments are passed BY REFERENCE"));
	}
	yyval = CB_BUILD_PAIR (cb_int (call_mode), cb_null);
  }
#line 20460 "parser.c" /* yacc.c:1652  */
    break;

  case 1618:
#line 11335 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	int	save_mode;	/* internal single parameter only mode */

	save_mode = call_mode;
	if (call_mode != CB_CALL_BY_REFERENCE) {
		if (CB_FILE_P (yyvsp[0]) || (CB_REFERENCE_P (yyvsp[0]) &&
		    CB_FILE_P (CB_REFERENCE (yyvsp[0])->value))) {
			cb_error_x (CB_TREE (current_statement),
				    _("invalid file name reference"));
		} else if (call_mode == CB_CALL_BY_VALUE) {
			/* FIXME: compiler configuration needed, IBM allows one-byte
			          alphanumeric items [--> a `char`], too, while
			          COBOL 2002/2014 allow only numeric literals
			   --> revise after rw-merge */
			if (cb_category_is_alpha (yyvsp[0])) {
				cb_warning_x (COBC_WARN_FILLER, yyvsp[0],
					      _("BY CONTENT assumed for alphanumeric item '%s'"),
						  cb_name (yyvsp[0]));
				call_mode = CB_CALL_BY_CONTENT;
			} else if (cb_category_is_national (yyvsp[0])) {
				cb_warning_x (COBC_WARN_FILLER, yyvsp[0],
					      _("BY CONTENT assumed for national item '%s'"),
						  cb_name (yyvsp[0]));
				call_mode = CB_CALL_BY_CONTENT;
			}
		}
	}
	yyval = CB_BUILD_PAIR (cb_int (call_mode), yyvsp[0]);
	CB_SIZES (yyval) = size_mode;
	call_mode = save_mode;
  }
#line 20496 "parser.c" /* yacc.c:1652  */
    break;

  case 1620:
#line 11371 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	call_mode = CB_CALL_BY_REFERENCE;
  }
#line 20504 "parser.c" /* yacc.c:1652  */
    break;

  case 1621:
#line 11375 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (current_program->flag_chained) {
		cb_error_x (CB_TREE (current_statement),
			    _("%s not allowed in CHAINED programs"), "BY CONTENT");
	} else {
		call_mode = CB_CALL_BY_CONTENT;
	}
  }
#line 20517 "parser.c" /* yacc.c:1652  */
    break;

  case 1622:
#line 11384 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (current_program->flag_chained) {
		cb_error_x (CB_TREE (current_statement),
			    _("%s not allowed in CHAINED programs"), "BY VALUE");
	} else {
		call_mode = CB_CALL_BY_VALUE;
	}
  }
#line 20530 "parser.c" /* yacc.c:1652  */
    break;

  case 1623:
#line 11396 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 20538 "parser.c" /* yacc.c:1652  */
    break;

  case 1624:
#line 11400 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 20546 "parser.c" /* yacc.c:1652  */
    break;

  case 1625:
#line 11404 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_null;
  }
#line 20554 "parser.c" /* yacc.c:1652  */
    break;

  case 1626:
#line 11408 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	call_nothing = CB_CONV_NO_RET_UPD;
	yyval = cb_null;
  }
#line 20563 "parser.c" /* yacc.c:1652  */
    break;

  case 1627:
#line 11413 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	struct cb_field	*f;

	if (cb_ref (yyvsp[0]) != cb_error_node) {
		f = CB_FIELD_PTR (yyvsp[0]);
		if (f->level != 1 && f->level != 77) {
			cb_error (_("RETURNING item must have level 01 or 77"));
			yyval = NULL;
		} else if (f->storage != CB_STORAGE_LINKAGE &&
			   !f->flag_item_based) {
			cb_error (_("RETURNING item must be a LINKAGE SECTION item or have BASED clause"));
			yyval = NULL;
		} else {
			yyval = cb_build_address (yyvsp[0]);
		}
	} else {
		yyval = NULL;
	}
  }
#line 20587 "parser.c" /* yacc.c:1652  */
    break;

  case 1632:
#line 11446 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = CB_BUILD_PAIR (NULL, NULL);
  }
#line 20595 "parser.c" /* yacc.c:1652  */
    break;

  case 1633:
#line 11450 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = CB_BUILD_PAIR (yyvsp[-1], yyvsp[0]);
  }
#line 20603 "parser.c" /* yacc.c:1652  */
    break;

  case 1634:
#line 11454 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[0]) {
		cb_verify (cb_not_exception_before_exception,
			_("NOT EXCEPTION before EXCEPTION"));
	}
	yyval = CB_BUILD_PAIR (yyvsp[0], yyvsp[-1]);
  }
#line 20615 "parser.c" /* yacc.c:1652  */
    break;

  case 1635:
#line 11465 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 20623 "parser.c" /* yacc.c:1652  */
    break;

  case 1636:
#line 11469 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 20631 "parser.c" /* yacc.c:1652  */
    break;

  case 1637:
#line 11476 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 20639 "parser.c" /* yacc.c:1652  */
    break;

  case 1638:
#line 11480 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_verify (cb_call_overflow, "ON OVERFLOW");
	yyval = yyvsp[0];
  }
#line 20648 "parser.c" /* yacc.c:1652  */
    break;

  case 1639:
#line 11488 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 20656 "parser.c" /* yacc.c:1652  */
    break;

  case 1640:
#line 11492 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 20664 "parser.c" /* yacc.c:1652  */
    break;

  case 1641:
#line 11499 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 20672 "parser.c" /* yacc.c:1652  */
    break;

  case 1642:
#line 11506 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_WARNING (yyvsp[(-2) - (0)], CALL);
  }
#line 20680 "parser.c" /* yacc.c:1652  */
    break;

  case 1643:
#line 11510 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_CLEAR (yyvsp[(-2) - (1)], CALL);
  }
#line 20688 "parser.c" /* yacc.c:1652  */
    break;

  case 1644:
#line 11520 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_statement ("CANCEL", 0);
	cobc_allow_program_name = 1;
  }
#line 20697 "parser.c" /* yacc.c:1652  */
    break;

  case 1645:
#line 11525 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cobc_allow_program_name = 0;
  }
#line 20705 "parser.c" /* yacc.c:1652  */
    break;

  case 1646:
#line 11532 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_cancel (yyvsp[0]);
  }
#line 20713 "parser.c" /* yacc.c:1652  */
    break;

  case 1647:
#line 11536 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_cancel (yyvsp[0]);
  }
#line 20721 "parser.c" /* yacc.c:1652  */
    break;

  case 1649:
#line 11544 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_verify (cb_program_prototypes, _("CALL/CANCEL with program-prototype-name"));
  }
#line 20729 "parser.c" /* yacc.c:1652  */
    break;

  case 1650:
#line 11553 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_statement ("CLOSE", 0);
  }
#line 20737 "parser.c" /* yacc.c:1652  */
    break;

  case 1654:
#line 11566 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_implicit_statement ();
	cb_emit_close (yyvsp[-1], yyvsp[0]);
  }
#line 20746 "parser.c" /* yacc.c:1652  */
    break;

  case 1655:
#line 11571 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_implicit_statement ();
	cb_emit_close (yyvsp[-1], yyvsp[0]);
  }
#line 20755 "parser.c" /* yacc.c:1652  */
    break;

  case 1656:
#line 11578 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_int (COB_CLOSE_NORMAL); }
#line 20761 "parser.c" /* yacc.c:1652  */
    break;

  case 1657:
#line 11579 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_int (COB_CLOSE_UNIT); }
#line 20767 "parser.c" /* yacc.c:1652  */
    break;

  case 1658:
#line 11580 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_int (COB_CLOSE_UNIT_REMOVAL); }
#line 20773 "parser.c" /* yacc.c:1652  */
    break;

  case 1659:
#line 11581 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_int (COB_CLOSE_NO_REWIND); }
#line 20779 "parser.c" /* yacc.c:1652  */
    break;

  case 1660:
#line 11582 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_int (COB_CLOSE_LOCK); }
#line 20785 "parser.c" /* yacc.c:1652  */
    break;

  case 1661:
#line 11587 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("GRAPHICAL WINDOW");
	current_statement->name = "CLOSE WINDOW";
  }
#line 20794 "parser.c" /* yacc.c:1652  */
    break;

  case 1662:
#line 11592 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_close_window (yyvsp[-1], yyvsp[0]);
  }
#line 20802 "parser.c" /* yacc.c:1652  */
    break;

  case 1663:
#line 11598 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 20808 "parser.c" /* yacc.c:1652  */
    break;

  case 1664:
#line 11599 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_int0; }
#line 20814 "parser.c" /* yacc.c:1652  */
    break;

  case 1665:
#line 11607 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_statement ("COMPUTE", TERM_COMPUTE);
  }
#line 20822 "parser.c" /* yacc.c:1652  */
    break;

  case 1667:
#line 11616 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_arithmetic (yyvsp[-3], 0, yyvsp[-1]);
  }
#line 20830 "parser.c" /* yacc.c:1652  */
    break;

  case 1668:
#line 11623 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_WARNING (yyvsp[(-2) - (0)], COMPUTE);
  }
#line 20838 "parser.c" /* yacc.c:1652  */
    break;

  case 1669:
#line 11627 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_CLEAR (yyvsp[(-2) - (1)], COMPUTE);
  }
#line 20846 "parser.c" /* yacc.c:1652  */
    break;

  case 1670:
#line 11637 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_statement ("COMMIT", 0);
	cb_emit_commit ();
  }
#line 20855 "parser.c" /* yacc.c:1652  */
    break;

  case 1671:
#line 11648 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	backup_current_pos ();
  }
#line 20863 "parser.c" /* yacc.c:1652  */
    break;

  case 1672:
#line 11652 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (!yyvsp[0]) {
		/* Do not check unreached for CONTINUE without after phrase */
		unsigned int	save_unreached = check_unreached;
		check_unreached = 0;
		begin_statement_from_backup_pos ("CONTINUE", 0);
		cb_emit_continue (NULL);
		check_unreached = save_unreached;
	} else {
		begin_statement_from_backup_pos ("CONTINUE AFTER", 0);
		cb_emit_continue (yyvsp[0]);
	}
  }
#line 20881 "parser.c" /* yacc.c:1652  */
    break;

  case 1673:
#line 11668 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = NULL;}
#line 20887 "parser.c" /* yacc.c:1652  */
    break;

  case 1674:
#line 11669 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	/* FIXME: hack - fake cs for context-sensitive SECONDS */
	cobc_cs_check = CB_CS_RETRY;
  }
#line 20896 "parser.c" /* yacc.c:1652  */
    break;

  case 1675:
#line 11674 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[-1];
  }
#line 20904 "parser.c" /* yacc.c:1652  */
    break;

  case 1676:
#line 11684 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_statement ("DESTROY", 0);
	CB_PENDING ("GRAPHICAL CONTROL");
  }
#line 20913 "parser.c" /* yacc.c:1652  */
    break;

  case 1678:
#line 11693 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_destroy (NULL);
  }
#line 20921 "parser.c" /* yacc.c:1652  */
    break;

  case 1679:
#line 11700 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_destroy (yyvsp[0]);
  }
#line 20929 "parser.c" /* yacc.c:1652  */
    break;

  case 1680:
#line 11710 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_statement ("DELETE", TERM_DELETE);
  }
#line 20937 "parser.c" /* yacc.c:1652  */
    break;

  case 1682:
#line 11719 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_delete (yyvsp[-3]);
  }
#line 20945 "parser.c" /* yacc.c:1652  */
    break;

  case 1684:
#line 11727 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_implicit_statement ();
	cb_emit_delete_file (yyvsp[0]);
  }
#line 20954 "parser.c" /* yacc.c:1652  */
    break;

  case 1685:
#line 11732 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_implicit_statement ();
	cb_emit_delete_file (yyvsp[0]);
  }
#line 20963 "parser.c" /* yacc.c:1652  */
    break;

  case 1686:
#line 11740 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_WARNING (yyvsp[(-2) - (0)], DELETE);
  }
#line 20971 "parser.c" /* yacc.c:1652  */
    break;

  case 1687:
#line 11744 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_CLEAR (yyvsp[(-2) - (1)], DELETE);
  }
#line 20979 "parser.c" /* yacc.c:1652  */
    break;

  case 1688:
#line 11754 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_statement ("DISABLE", 0);
  }
#line 20987 "parser.c" /* yacc.c:1652  */
    break;

  case 1692:
#line 11768 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	/* Add cb_verify for <= COBOL-85 */
  }
#line 20995 "parser.c" /* yacc.c:1652  */
    break;

  case 1698:
#line 11786 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_statement ("DISPLAY", TERM_DISPLAY);
	cobc_cs_check = CB_CS_DISPLAY;
	display_type = UNKNOWN_DISPLAY;
	is_first_display_item = 1;
  }
#line 21006 "parser.c" /* yacc.c:1652  */
    break;

  case 1700:
#line 11798 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_env_name (yyvsp[-2]);
  }
#line 21014 "parser.c" /* yacc.c:1652  */
    break;

  case 1701:
#line 11802 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_env_value (yyvsp[-2]);
  }
#line 21022 "parser.c" /* yacc.c:1652  */
    break;

  case 1702:
#line 11806 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_arg_number (yyvsp[-2]);
  }
#line 21030 "parser.c" /* yacc.c:1652  */
    break;

  case 1703:
#line 11810 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_command_line (yyvsp[-2]);
  }
#line 21038 "parser.c" /* yacc.c:1652  */
    break;

  case 1711:
#line 11824 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[0] != NULL) {
		error_if_different_display_type (yyvsp[0], NULL, NULL, NULL);
		cb_emit_display (yyvsp[0], NULL, cb_int1, NULL, NULL, 0,
				 display_type);
	}
  }
#line 21050 "parser.c" /* yacc.c:1652  */
    break;

  case 1712:
#line 11832 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	set_display_type (yyvsp[0], NULL, NULL, NULL);
	cb_emit_display (yyvsp[0], NULL, cb_int1, NULL, NULL, 1,
			 display_type);
  }
#line 21060 "parser.c" /* yacc.c:1652  */
    break;

  case 1715:
#line 11846 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_duplicate = 0;
	check_line_col_duplicate = 0;
	advancing_value = cb_int1;
	upon_value = NULL;
	line_column = NULL;
  }
#line 21072 "parser.c" /* yacc.c:1652  */
    break;

  case 1716:
#line 11854 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[-2] == cb_null) {
		/* Emit DISPLAY OMITTED. */
		CB_UNFINISHED_X (CB_TREE(current_statement), "DISPLAY OMITTED");
		error_if_no_advancing_in_screen_display (advancing_value);
	}

	/* Emit device or screen DISPLAY. */

	/*
	  Check that disp_list does not contain an invalid mix of fields.
	*/
	if (display_type == UNKNOWN_DISPLAY) {
		set_display_type (yyvsp[-2], upon_value, line_column,
				  current_statement->attr_ptr);
	} else {
		error_if_different_display_type (yyvsp[-2], upon_value,
						 line_column,
						 current_statement->attr_ptr);
	}

	if (display_type == SCREEN_DISPLAY
	    || display_type == FIELD_ON_SCREEN_DISPLAY) {
		error_if_no_advancing_in_screen_display (advancing_value);
	}

	cb_emit_display (yyvsp[-2], upon_value, advancing_value, line_column,
			 current_statement->attr_ptr,
			 is_first_display_item, display_type);

	is_first_display_item = 0;
  }
#line 21109 "parser.c" /* yacc.c:1652  */
    break;

  case 1717:
#line 11890 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 21117 "parser.c" /* yacc.c:1652  */
    break;

  case 1718:
#line 11894 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_null;
  }
#line 21125 "parser.c" /* yacc.c:1652  */
    break;

  case 1725:
#line 11916 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("UPON", SYN_CLAUSE_1, &check_duplicate);
  }
#line 21133 "parser.c" /* yacc.c:1652  */
    break;

  case 1726:
#line 11920 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("NO ADVANCING", SYN_CLAUSE_2, &check_duplicate);
	advancing_value = cb_int0;
  }
#line 21142 "parser.c" /* yacc.c:1652  */
    break;

  case 1727:
#line 11925 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("MODE IS BLOCK", SYN_CLAUSE_3, &check_duplicate);
  }
#line 21150 "parser.c" /* yacc.c:1652  */
    break;

  case 1730:
#line 11934 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	upon_value = cb_build_display_mnemonic (yyvsp[0]);
  }
#line 21158 "parser.c" /* yacc.c:1652  */
    break;

  case 1731:
#line 11938 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	upon_value = cb_build_display_name (yyvsp[0]);
  }
#line 21166 "parser.c" /* yacc.c:1652  */
    break;

  case 1732:
#line 11942 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	upon_value = cb_int2;
  }
#line 21174 "parser.c" /* yacc.c:1652  */
    break;

  case 1733:
#line 11946 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	upon_value = cb_null;
  }
#line 21182 "parser.c" /* yacc.c:1652  */
    break;

  case 1736:
#line 11958 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_duplicate = SYN_CLAUSE_10;
	check_line_col_duplicate = 0;
	line_column = NULL;
	set_dispattr_with_conflict ("ERASE EOS", COB_SCREEN_ERASE_EOS,
				    "ERASE EOL", COB_SCREEN_ERASE_EOL);
  }
#line 21194 "parser.c" /* yacc.c:1652  */
    break;

  case 1737:
#line 11966 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_display (CB_LIST_INIT (cb_space), cb_null, cb_int1, line_column, NULL, 1, FIELD_ON_SCREEN_DISPLAY);
  }
#line 21202 "parser.c" /* yacc.c:1652  */
    break;

  case 1738:
#line 11975 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_display (yyvsp[-1], cb_null, cb_int1, line_column, NULL, 1, FIELD_ON_SCREEN_DISPLAY);
  }
#line 21210 "parser.c" /* yacc.c:1652  */
    break;

  case 1739:
#line 11981 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_duplicate = 0;
	check_line_col_duplicate = 0;
	line_column = NULL;
  }
#line 21220 "parser.c" /* yacc.c:1652  */
    break;

  case 1740:
#line 11987 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 21228 "parser.c" /* yacc.c:1652  */
    break;

  case 1741:
#line 11994 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = CB_LIST_INIT (yyvsp[0]);
  }
#line 21236 "parser.c" /* yacc.c:1652  */
    break;

  case 1742:
#line 11998 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_list_add (yyvsp[-1], yyvsp[0]);
  }
#line 21244 "parser.c" /* yacc.c:1652  */
    break;

  case 1745:
#line 12008 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	set_dispattr_with_conflict ("ERASE EOS", COB_SCREEN_ERASE_EOS,
				    "ERASE EOL", COB_SCREEN_ERASE_EOL);
	yyval = cb_space;
  }
#line 21254 "parser.c" /* yacc.c:1652  */
    break;

  case 1746:
#line 12018 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_UNFINISHED_X (CB_TREE(current_statement), "DISPLAY MESSAGE");
	upon_value = NULL;
  }
#line 21263 "parser.c" /* yacc.c:1652  */
    break;

  case 1747:
#line 12023 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	/* for now: minimal support for display and prompt only */
	if (upon_value) {
		cb_emit_display (CB_LIST_INIT (upon_value), NULL, NULL, NULL,
				 NULL, 1, FIELD_ON_SCREEN_DISPLAY);
	}
	cb_emit_display (yyvsp[-2], NULL, NULL, NULL,
			 NULL, 1, FIELD_ON_SCREEN_DISPLAY);
	cb_emit_accept (cb_null, NULL, NULL);
  }
#line 21278 "parser.c" /* yacc.c:1652  */
    break;

  case 1752:
#line 12047 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	upon_value = yyvsp[0];
  }
#line 21286 "parser.c" /* yacc.c:1652  */
    break;

  case 1757:
#line 12058 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("GRAPHICAL WINDOW");
	current_statement->name = "DISPLAY WINDOW";
  }
#line 21295 "parser.c" /* yacc.c:1652  */
    break;

  case 1758:
#line 12063 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_duplicate = 0;
	check_line_col_duplicate = 0;
	line_column = NULL;
	upon_value = NULL; /* Hack: stores the POP-UP AREA */
  }
#line 21306 "parser.c" /* yacc.c:1652  */
    break;

  case 1759:
#line 12070 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_display_window (NULL, upon_value, yyvsp[-2], line_column,
			 current_statement->attr_ptr);
  }
#line 21315 "parser.c" /* yacc.c:1652  */
    break;

  case 1762:
#line 12083 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("GRAPHICAL WINDOW");
	current_statement->name = "DISPLAY FLOATING WINDOW";
  }
#line 21324 "parser.c" /* yacc.c:1652  */
    break;

  case 1763:
#line 12088 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_duplicate = 0;
	check_line_col_duplicate = 0;
	line_column = NULL;
	upon_value = NULL; /* Hack: stores the POP-UP AREA */
  }
#line 21335 "parser.c" /* yacc.c:1652  */
    break;

  case 1764:
#line 12095 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[-5]) {
		/* TODO: set "CELL WIDTH" and "CELL HEIGHT" to "LABEL FONT" */
		/* if not set already */
	}
	cb_emit_display_window (cb_int0, upon_value, yyvsp[-2], line_column,
			 current_statement->attr_ptr);
  }
#line 21348 "parser.c" /* yacc.c:1652  */
    break;

  case 1765:
#line 12107 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("GRAPHICAL WINDOW");
	current_statement->name = "DISPLAY INITIAL WINDOW";
	check_duplicate = 0;
	check_line_col_duplicate = 0;
	line_column = NULL;
	upon_value = NULL; /* Hack: stores the POP-UP AREA */
	/* TODO: initialize attributes for SHADOW, BOTTOM */
  }
#line 21362 "parser.c" /* yacc.c:1652  */
    break;

  case 1766:
#line 12117 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[-3]) {
		/* TODO: set "CELL WIDTH" and "CELL HEIGHT" to "LABEL FONT" */
		/* if not set already */
	}
	cb_emit_display_window (yyvsp[-4], upon_value, NULL, line_column,
			 current_statement->attr_ptr);
  }
#line 21375 "parser.c" /* yacc.c:1652  */
    break;

  case 1767:
#line 12128 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {yyval = cb_int1;}
#line 21381 "parser.c" /* yacc.c:1652  */
    break;

  case 1768:
#line 12129 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {yyval = cb_int2;}
#line 21387 "parser.c" /* yacc.c:1652  */
    break;

  case 1769:
#line 12130 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {yyval = cb_int3;}
#line 21393 "parser.c" /* yacc.c:1652  */
    break;

  case 1770:
#line 12134 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {yyval = NULL;}
#line 21399 "parser.c" /* yacc.c:1652  */
    break;

  case 1771:
#line 12135 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {yyval = cb_int1;}
#line 21405 "parser.c" /* yacc.c:1652  */
    break;

  case 1772:
#line 12140 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 21413 "parser.c" /* yacc.c:1652  */
    break;

  case 1773:
#line 12144 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 21421 "parser.c" /* yacc.c:1652  */
    break;

  case 1774:
#line 12151 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	struct cb_field	*f;

	if (cb_ref (yyvsp[0]) != cb_error_node) {
		f = CB_FIELD_PTR (yyvsp[0]);
		if (f->usage != CB_USAGE_HNDL_WINDOW
		 && f->usage != CB_USAGE_HNDL_SUBWINDOW) {
			cb_error_x (yyvsp[0], _("HANDLE must be a %s HANDLE"), "WINDOW");
		}
	}
	yyval = yyvsp[0];
  }
#line 21438 "parser.c" /* yacc.c:1652  */
    break;

  case 1775:
#line 12164 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	struct cb_field	*f;

	if (cb_ref (yyvsp[0]) != cb_error_node) {
		f = CB_FIELD_PTR (yyvsp[0]);
		if (f->usage != CB_USAGE_HNDL) {
			cb_error_x (yyvsp[0], _("HANDLE must be a generic HANDLE"));
		}
	}
	yyval = yyvsp[0];
  }
#line 21454 "parser.c" /* yacc.c:1652  */
    break;

  case 1776:
#line 12176 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_null;
  }
#line 21462 "parser.c" /* yacc.c:1652  */
    break;

  case 1780:
#line 12191 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	/* TODO: store */
  }
#line 21470 "parser.c" /* yacc.c:1652  */
    break;

  case 1787:
#line 12203 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { /* TODO: set attribute */ }
#line 21476 "parser.c" /* yacc.c:1652  */
    break;

  case 1788:
#line 12206 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { /* TODO: set attribute */ }
#line 21482 "parser.c" /* yacc.c:1652  */
    break;

  case 1789:
#line 12210 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_int0; }
#line 21488 "parser.c" /* yacc.c:1652  */
    break;

  case 1790:
#line 12211 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_int0; }
#line 21494 "parser.c" /* yacc.c:1652  */
    break;

  case 1791:
#line 12212 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_int1; }
#line 21500 "parser.c" /* yacc.c:1652  */
    break;

  case 1792:
#line 12216 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_int0; }
#line 21506 "parser.c" /* yacc.c:1652  */
    break;

  case 1793:
#line 12217 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_int1; }
#line 21512 "parser.c" /* yacc.c:1652  */
    break;

  case 1794:
#line 12218 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_int1; }
#line 21518 "parser.c" /* yacc.c:1652  */
    break;

  case 1795:
#line 12219 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_int2; }
#line 21524 "parser.c" /* yacc.c:1652  */
    break;

  case 1800:
#line 12235 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (upon_value) {
		emit_duplicate_clause_message("POP-UP AREA");
	}
	upon_value = yyvsp[0];
  }
#line 21535 "parser.c" /* yacc.c:1652  */
    break;

  case 1801:
#line 12245 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (!strcmp (current_statement->name, "DISPLAY WINDOW")) {
		cb_error_x (yyvsp[0], _("HANDLE clause invalid for %s"),
			current_statement->name);
		upon_value = cb_error_node;
	} else{
		if (upon_value) {
			emit_duplicate_clause_message("POP-UP AREA / HANDLE IN");
		}
		upon_value = yyvsp[0];
	}
  }
#line 21552 "parser.c" /* yacc.c:1652  */
    break;

  case 1802:
#line 12261 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("BELL", SYN_CLAUSE_4, &check_duplicate);
	set_dispattr (COB_SCREEN_BELL);
  }
#line 21561 "parser.c" /* yacc.c:1652  */
    break;

  case 1803:
#line 12266 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("BLANK LINE", SYN_CLAUSE_5, &check_duplicate);
	set_dispattr_with_conflict ("BLANK LINE", COB_SCREEN_BLANK_LINE,
				    "BLANK SCREEN", COB_SCREEN_BLANK_SCREEN);
  }
#line 21571 "parser.c" /* yacc.c:1652  */
    break;

  case 1804:
#line 12272 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("BLANK SCREEN", SYN_CLAUSE_6, &check_duplicate);
	set_dispattr_with_conflict ("BLANK SCREEN", COB_SCREEN_BLANK_SCREEN,
				    "BLANK LINE", COB_SCREEN_BLANK_LINE);
  }
#line 21581 "parser.c" /* yacc.c:1652  */
    break;

  case 1805:
#line 12278 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("BLINK", SYN_CLAUSE_7, &check_duplicate);
	set_dispattr (COB_SCREEN_BLINK);
  }
#line 21590 "parser.c" /* yacc.c:1652  */
    break;

  case 1806:
#line 12283 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("CONVERSION", SYN_CLAUSE_8, &check_duplicate);
	cb_warning (COBC_WARN_FILLER, _("ignoring %s phrase"), "CONVERSION");
  }
#line 21599 "parser.c" /* yacc.c:1652  */
    break;

  case 1807:
#line 12288 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("ERASE EOL", SYN_CLAUSE_9, &check_duplicate);
	set_dispattr_with_conflict ("ERASE EOL", COB_SCREEN_ERASE_EOL,
				    "ERASE EOS", COB_SCREEN_ERASE_EOS);
  }
#line 21609 "parser.c" /* yacc.c:1652  */
    break;

  case 1808:
#line 12294 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("ERASE EOS", SYN_CLAUSE_10, &check_duplicate);
	set_dispattr_with_conflict ("ERASE EOS", COB_SCREEN_ERASE_EOS,
				    "ERASE EOL", COB_SCREEN_ERASE_EOL);
  }
#line 21619 "parser.c" /* yacc.c:1652  */
    break;

  case 1809:
#line 12300 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("HIGHLIGHT", SYN_CLAUSE_11, &check_duplicate);
	set_dispattr_with_conflict ("HIGHLIGHT", COB_SCREEN_HIGHLIGHT,
				    "LOWLIGHT", COB_SCREEN_LOWLIGHT);
  }
#line 21629 "parser.c" /* yacc.c:1652  */
    break;

  case 1810:
#line 12306 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("LOWLIGHT", SYN_CLAUSE_12, &check_duplicate);
	set_dispattr_with_conflict ("LOWLIGHT", COB_SCREEN_LOWLIGHT,
				    "HIGHLIGHT", COB_SCREEN_HIGHLIGHT);
  }
#line 21639 "parser.c" /* yacc.c:1652  */
    break;

  case 1811:
#line 12313 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("SAME phrase");
	/* may not be specified along with the UNDERLINED, BLINK, REVERSED,
	HIGH, LOW, STANDARD, COLOR, FOREGROUND-COLOR, or BACKGROUND-COLOR phrases */
  }
#line 21649 "parser.c" /* yacc.c:1652  */
    break;

  case 1812:
#line 12319 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("STANDARD intensity");
  }
#line 21657 "parser.c" /* yacc.c:1652  */
    break;

  case 1813:
#line 12323 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("BACKGROUND intensity");
  }
#line 21665 "parser.c" /* yacc.c:1652  */
    break;

  case 1814:
#line 12327 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("BACKGROUND intensity");
  }
#line 21673 "parser.c" /* yacc.c:1652  */
    break;

  case 1815:
#line 12331 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("BACKGROUND intensity");
  }
#line 21681 "parser.c" /* yacc.c:1652  */
    break;

  case 1816:
#line 12335 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("OVERLINE", SYN_CLAUSE_13, &check_duplicate);
	set_dispattr (COB_SCREEN_OVERLINE);
  }
#line 21690 "parser.c" /* yacc.c:1652  */
    break;

  case 1817:
#line 12340 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("REVERSE-VIDEO", SYN_CLAUSE_14, &check_duplicate);
	set_dispattr (COB_SCREEN_REVERSE);
  }
#line 21699 "parser.c" /* yacc.c:1652  */
    break;

  case 1818:
#line 12345 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("SIZE", SYN_CLAUSE_15, &check_duplicate);
	set_attribs (NULL, NULL, NULL, NULL, NULL, yyvsp[0], 0);
  }
#line 21708 "parser.c" /* yacc.c:1652  */
    break;

  case 1819:
#line 12350 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("UNDERLINE", SYN_CLAUSE_16, &check_duplicate);
	set_dispattr (COB_SCREEN_UNDERLINE);
  }
#line 21717 "parser.c" /* yacc.c:1652  */
    break;

  case 1820:
#line 12355 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("FOREGROUND-COLOR", SYN_CLAUSE_17, &check_duplicate);
	check_repeated ("BACKGROUND-COLOR", SYN_CLAUSE_18, &check_duplicate);
	CB_PENDING ("COLOR");
  }
#line 21727 "parser.c" /* yacc.c:1652  */
    break;

  case 1821:
#line 12361 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("FOREGROUND-COLOR", SYN_CLAUSE_17, &check_duplicate);
	set_attribs (yyvsp[0], NULL, NULL, NULL, NULL, NULL, 0);
  }
#line 21736 "parser.c" /* yacc.c:1652  */
    break;

  case 1822:
#line 12366 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("BACKGROUND-COLOR", SYN_CLAUSE_18, &check_duplicate);
	set_attribs (NULL, yyvsp[0], NULL, NULL, NULL, NULL, 0);
  }
#line 21745 "parser.c" /* yacc.c:1652  */
    break;

  case 1823:
#line 12371 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("SCROLL UP", SYN_CLAUSE_19, &check_duplicate);
	set_attribs_with_conflict (NULL, NULL, yyvsp[0], NULL, NULL, NULL,
				   "SCROLL UP", COB_SCREEN_SCROLL_UP,
				   "SCROLL DOWN", COB_SCREEN_SCROLL_DOWN);
  }
#line 21756 "parser.c" /* yacc.c:1652  */
    break;

  case 1824:
#line 12378 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_repeated ("SCROLL DOWN", SYN_CLAUSE_20, &check_duplicate);
	set_attribs_with_conflict (NULL, NULL, yyvsp[0], NULL, NULL, NULL,
				   "SCROLL DOWN", COB_SCREEN_SCROLL_DOWN,
				   "SCROLL UP", COB_SCREEN_SCROLL_UP);
  }
#line 21767 "parser.c" /* yacc.c:1652  */
    break;

  case 1825:
#line 12388 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_WARNING (yyvsp[(-2) - (0)], DISPLAY);
  }
#line 21775 "parser.c" /* yacc.c:1652  */
    break;

  case 1826:
#line 12392 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_CLEAR (yyvsp[(-2) - (1)], DISPLAY);
  }
#line 21783 "parser.c" /* yacc.c:1652  */
    break;

  case 1827:
#line 12402 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_statement ("DIVIDE", TERM_DIVIDE);
  }
#line 21791 "parser.c" /* yacc.c:1652  */
    break;

  case 1829:
#line 12411 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_arithmetic (yyvsp[-1], '/', yyvsp[-3]);
  }
#line 21799 "parser.c" /* yacc.c:1652  */
    break;

  case 1830:
#line 12415 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_arithmetic (yyvsp[-1], 0, cb_build_binary_op (yyvsp[-3], '/', yyvsp[-5]));
  }
#line 21807 "parser.c" /* yacc.c:1652  */
    break;

  case 1831:
#line 12419 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_arithmetic (yyvsp[-1], 0, cb_build_binary_op (yyvsp[-5], '/', yyvsp[-3]));
  }
#line 21815 "parser.c" /* yacc.c:1652  */
    break;

  case 1832:
#line 12423 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_divide (yyvsp[-5], yyvsp[-7], yyvsp[-3], yyvsp[-1]);
  }
#line 21823 "parser.c" /* yacc.c:1652  */
    break;

  case 1833:
#line 12427 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_divide (yyvsp[-7], yyvsp[-5], yyvsp[-3], yyvsp[-1]);
  }
#line 21831 "parser.c" /* yacc.c:1652  */
    break;

  case 1834:
#line 12434 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_WARNING (yyvsp[(-2) - (0)], DIVIDE);
  }
#line 21839 "parser.c" /* yacc.c:1652  */
    break;

  case 1835:
#line 12438 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_CLEAR (yyvsp[(-2) - (1)], DIVIDE);
  }
#line 21847 "parser.c" /* yacc.c:1652  */
    break;

  case 1836:
#line 12448 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_statement ("ENABLE", 0);
  }
#line 21855 "parser.c" /* yacc.c:1652  */
    break;

  case 1838:
#line 12459 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_unreached = 0;
	begin_statement ("ENTRY", 0);
	backup_current_pos ();
  }
#line 21865 "parser.c" /* yacc.c:1652  */
    break;

  case 1840:
#line 12466 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_unreached = 0;
	begin_statement ("ENTRY FOR GO TO", 0);
	backup_current_pos ();
  }
#line 21875 "parser.c" /* yacc.c:1652  */
    break;

  case 1842:
#line 12476 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (current_program->nested_level) {
		cb_error (_("%s is invalid in nested program"), "ENTRY");
	} else if (current_program->prog_type == COB_MODULE_TYPE_FUNCTION) {
		cb_error (_("%s is invalid in a user FUNCTION"), "ENTRY");
	} else if (cb_verify (cb_entry_statement, "ENTRY")) {
		cb_tree call_conv = yyvsp[-3];
		if (yyvsp[-1]) {
			call_conv = yyvsp[-1];
			if (yyvsp[-3]) {
				/* note: $1 is likely to be a reference to SPECIAL-NAMES */
				cb_error_x (yyvsp[-1], _("%s and %s are mutually exclusive"),
					"CALL-CONVENTION", "WITH LINKAGE");
			}
		}
		if (!cobc_check_valid_name ((char *)(CB_LITERAL (yyvsp[-2])->data), ENTRY_NAME)) {
			emit_entry ((char *)(CB_LITERAL (yyvsp[-2])->data), 1, yyvsp[0], call_conv);
		}
	}
  }
#line 21900 "parser.c" /* yacc.c:1652  */
    break;

  case 1843:
#line 12500 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (cb_verify (cb_goto_entry, "ENTRY FOR GO TO")) {
		emit_entry_goto ((char *)(CB_LITERAL (yyvsp[0])->data));
	}
  }
#line 21910 "parser.c" /* yacc.c:1652  */
    break;

  case 1844:
#line 12512 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_statement ("EVALUATE", TERM_EVALUATE);
	eval_level++;
	if (eval_level >= EVAL_DEPTH) {
		cb_error (_("maximum evaluate depth exceeded (%d)"),
			  EVAL_DEPTH);
		eval_level = 0;
		eval_inc = 0;
		eval_inc2 = 0;
		YYERROR;
	} else {
		for (eval_inc = 0; eval_inc < EVAL_DEPTH; ++eval_inc) {
			eval_check[eval_level][eval_inc] = NULL;
		}
		eval_inc = 0;
		eval_inc2 = 0;
	}
	cb_end_cond (cb_any);
	cb_save_cond ();
	cb_true_side ();
  }
#line 21936 "parser.c" /* yacc.c:1652  */
    break;

  case 1846:
#line 12539 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_evaluate (yyvsp[-1], yyvsp[0]);
	eval_level--;
  }
#line 21945 "parser.c" /* yacc.c:1652  */
    break;

  case 1847:
#line 12546 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = CB_LIST_INIT (yyvsp[0]); }
#line 21951 "parser.c" /* yacc.c:1652  */
    break;

  case 1848:
#line 12548 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_list_add (yyvsp[-2], yyvsp[0]); }
#line 21957 "parser.c" /* yacc.c:1652  */
    break;

  case 1849:
#line 12553 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
	eval_check[eval_level][eval_inc++] = yyvsp[0];
	if (eval_inc >= EVAL_DEPTH) {
		cb_error (_("maximum evaluate depth exceeded (%d)"),
			  EVAL_DEPTH);
		eval_inc = 0;
		YYERROR;
	}
  }
#line 21972 "parser.c" /* yacc.c:1652  */
    break;

  case 1850:
#line 12564 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_true;
	eval_check[eval_level][eval_inc++] = NULL;
	if (eval_inc >= EVAL_DEPTH) {
		cb_error (_("maximum evaluate depth exceeded (%d)"),
			  EVAL_DEPTH);
		eval_inc = 0;
		YYERROR;
	}
  }
#line 21987 "parser.c" /* yacc.c:1652  */
    break;

  case 1851:
#line 12575 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_false;
	eval_check[eval_level][eval_inc++] = cb_false;
	if (eval_inc >= EVAL_DEPTH) {
		cb_error (_("maximum evaluate depth exceeded (%d)"),
			  EVAL_DEPTH);
		eval_inc = 0;
		YYERROR;
	}
  }
#line 22002 "parser.c" /* yacc.c:1652  */
    break;

  case 1852:
#line 12589 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (yyvsp[0]) {
		yyval = cb_list_add (yyvsp[-1], yyvsp[0]);
	} else {
		yyval = yyvsp[-1];
	}
  }
#line 22014 "parser.c" /* yacc.c:1652  */
    break;

  case 1853:
#line 12598 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 22022 "parser.c" /* yacc.c:1652  */
    break;

  case 1854:
#line 12604 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = CB_LIST_INIT (yyvsp[0]); }
#line 22028 "parser.c" /* yacc.c:1652  */
    break;

  case 1855:
#line 12606 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_list_add (yyvsp[-1], yyvsp[0]); }
#line 22034 "parser.c" /* yacc.c:1652  */
    break;

  case 1856:
#line 12612 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = CB_BUILD_CHAIN (yyvsp[0], yyvsp[-1]);
	eval_inc2 = 0;
  }
#line 22043 "parser.c" /* yacc.c:1652  */
    break;

  case 1857:
#line 12617 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	eval_inc2 = 0;
	cb_verify (cb_missing_statement,
		_("WHEN without imperative statement"));
	/* Note: we don't clear the EVALUATE terminator here
	         as we'd have to skip this later
	         [side effect: possible warning about missing terminator] */
	yyval = CB_BUILD_CHAIN (CB_LIST_INIT (cb_build_continue ()), yyvsp[-1]);
  }
#line 22057 "parser.c" /* yacc.c:1652  */
    break;

  case 1858:
#line 12627 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	eval_inc2 = 0;
	cb_verify (cb_missing_statement,
		_("WHEN without imperative statement"));
	/* Put the dot token back into the stack for reparse */
	cb_unput_dot ();
	yyval = CB_BUILD_CHAIN (CB_LIST_INIT (cb_build_continue ()), yyvsp[-1]);
  }
#line 22070 "parser.c" /* yacc.c:1652  */
    break;

  case 1859:
#line 12640 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = CB_BUILD_CHAIN (yyvsp[0], NULL);
	eval_inc2 = 0;
  }
#line 22079 "parser.c" /* yacc.c:1652  */
    break;

  case 1860:
#line 12645 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	eval_inc2 = 0;
	cb_verify (cb_missing_statement,
		_("WHEN OTHER without imperative statement"));
	/* Note: we don't clear the EVALUATE terminator here
	         as we'd have to skip this later
	         [side effect: possible warning about missing terminator] */
	yyval = NULL;
  }
#line 22093 "parser.c" /* yacc.c:1652  */
    break;

  case 1861:
#line 12655 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	eval_inc2 = 0;
	cb_verify (cb_missing_statement,
		_("WHEN OTHER without imperative statement"));
	/* Put the dot token back into the stack for reparse */
	cb_unput_dot ();
	yyval = NULL;
  }
#line 22106 "parser.c" /* yacc.c:1652  */
    break;

  case 1862:
#line 12667 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	backup_current_pos ();
  }
#line 22114 "parser.c" /* yacc.c:1652  */
    break;

  case 1863:
#line 12671 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = CB_LIST_INIT (yyvsp[0]);
	restore_backup_pos (yyval);
	eval_inc2 = 0;
  }
#line 22124 "parser.c" /* yacc.c:1652  */
    break;

  case 1864:
#line 12678 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	backup_current_pos ();
  }
#line 22132 "parser.c" /* yacc.c:1652  */
    break;

  case 1865:
#line 12682 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_list_add (yyvsp[-3], yyvsp[0]);
	restore_backup_pos (yyval);
	eval_inc2 = 0;
  }
#line 22142 "parser.c" /* yacc.c:1652  */
    break;

  case 1866:
#line 12690 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = CB_LIST_INIT (yyvsp[0]); }
#line 22148 "parser.c" /* yacc.c:1652  */
    break;

  case 1867:
#line 12692 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_list_add (yyvsp[-2], yyvsp[0]); }
#line 22154 "parser.c" /* yacc.c:1652  */
    break;

  case 1868:
#line 12697 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_tree	not0;
	cb_tree	e1;
	cb_tree	e2;
	cb_tree	x;
	cb_tree	parm1;

	not0 = cb_int0;
	e2 = yyvsp[0];
	x = NULL;
	parm1 = yyvsp[-1];
	if (eval_check[eval_level][eval_inc2]
	 && eval_check[eval_level][eval_inc2] != cb_false) {
		/* Check if the first token is NOT */
		/* It may belong to the EVALUATE, however see */
		/* below when it may be part of a partial expression */
		if (CB_PURPOSE_INT (parm1) == '!') {
			/* Pop stack if subject not TRUE / FALSE */
			not0 = cb_int1;
			x = parm1;
			parm1 = CB_CHAIN (parm1);
		}
		/* Partial expression handling */
		switch (CB_PURPOSE_INT (parm1)) {
		/* Relational conditions */
		case '<':
		case '>':
		case '[':
		case ']':
		case '~':
		case '=':
		/* Class conditions */
		case '9':
		case 'A':
		case 'L':
		case 'U':
		case 'P':
		case 'N':
		case 'O':
		case 'C':
			if (e2) {
				cb_error_x (e2, _("invalid THROUGH usage"));
				e2 = NULL;
			}
			not0 = CB_PURPOSE (parm1);
			if (x) {
				/* Rebind the NOT to the partial expression */
				parm1 = cb_build_list (cb_int ('!'), NULL, parm1);
			}
			/* Insert subject at head of list */
			parm1 = cb_build_list (cb_int ('x'),
					    eval_check[eval_level][eval_inc2], parm1);
			break;
		}
	}

	/* Build expr now */
	e1 = cb_build_expr (parm1);

	eval_inc2++;
	yyval = CB_BUILD_PAIR (not0, CB_BUILD_PAIR (e1, e2));

	if (eval_check[eval_level][eval_inc2-1] == cb_false) {
		/* It was  EVALUATE FALSE; So flip condition */
		if (e1 == cb_true)
			e1 = cb_false;
		else if (e1 == cb_false)
			e1 = cb_true;
	}
	cb_terminate_cond ();
	cb_end_cond (e1);
	cb_save_cond ();
	cb_true_side ();
  }
#line 22233 "parser.c" /* yacc.c:1652  */
    break;

  case 1869:
#line 12771 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_any; eval_inc2++; }
#line 22239 "parser.c" /* yacc.c:1652  */
    break;

  case 1870:
#line 12772 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_true; eval_inc2++; }
#line 22245 "parser.c" /* yacc.c:1652  */
    break;

  case 1871:
#line 12773 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_false; eval_inc2++; }
#line 22251 "parser.c" /* yacc.c:1652  */
    break;

  case 1872:
#line 12774 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_error_node; eval_inc2++; }
#line 22257 "parser.c" /* yacc.c:1652  */
    break;

  case 1873:
#line 12778 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 22263 "parser.c" /* yacc.c:1652  */
    break;

  case 1874:
#line 12779 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 22269 "parser.c" /* yacc.c:1652  */
    break;

  case 1875:
#line 12784 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_WARNING (yyvsp[(-2) - (0)], EVALUATE);
  }
#line 22277 "parser.c" /* yacc.c:1652  */
    break;

  case 1876:
#line 12788 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_CLEAR (yyvsp[(-2) - (1)], EVALUATE);
  }
#line 22285 "parser.c" /* yacc.c:1652  */
    break;

  case 1877:
#line 12798 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_statement ("EXIT", 0);
	cobc_cs_check = CB_CS_EXIT;
  }
#line 22294 "parser.c" /* yacc.c:1652  */
    break;

  case 1878:
#line 12803 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cobc_cs_check = 0;
  }
#line 22302 "parser.c" /* yacc.c:1652  */
    break;

  case 1879:
#line 12810 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
  /* TODO: add warning/error if there's another statement in the paragraph */
  }
#line 22310 "parser.c" /* yacc.c:1652  */
    break;

  case 1880:
#line 12814 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (in_declaratives && use_global_ind) {
		cb_error_x (CB_TREE (current_statement),
			    _("EXIT PROGRAM is not allowed within a USE GLOBAL procedure"));
	}
	if (current_program->prog_type != COB_MODULE_TYPE_PROGRAM) {
		cb_error_x (CB_TREE (current_statement),
			    _("EXIT PROGRAM not allowed within a FUNCTION"));
	}
	if (current_program->flag_main) {
		check_unreached = 0;
	} else {
		check_unreached = 1;
	}
	if (yyvsp[0]) {
		if (!current_program->cb_return_code) {
			cb_error_x (yyvsp[0], _("RETURNING/GIVING not allowed for non-returning runtime elements"));
		} else {
			cb_emit_move (yyvsp[0], CB_LIST_INIT (current_program->cb_return_code));
		}
	}
	current_statement->name = (const char *)"EXIT PROGRAM";
	cb_emit_exit (0);
  }
#line 22339 "parser.c" /* yacc.c:1652  */
    break;

  case 1881:
#line 12839 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (in_declaratives && use_global_ind) {
		cb_error_x (CB_TREE (current_statement),
			    _("EXIT FUNCTION is not allowed within a USE GLOBAL procedure"));
	}
	if (current_program->prog_type != COB_MODULE_TYPE_FUNCTION) {
		cb_error_x (CB_TREE (current_statement),
			    _("EXIT FUNCTION only allowed within a FUNCTION"));
	}
	check_unreached = 1;
	current_statement->name = (const char *)"EXIT FUNCTION";
	cb_emit_exit (0);
  }
#line 22357 "parser.c" /* yacc.c:1652  */
    break;

  case 1882:
#line 12853 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	struct cb_perform	*p;
	cb_tree			plabel;
	char			name[64];

	if (!perform_stack) {
		cb_error_x (CB_TREE (current_statement),
			    _("EXIT PERFORM is only valid with inline PERFORM"));
	} else if (CB_VALUE (perform_stack) != cb_error_node) {
		p = CB_PERFORM (CB_VALUE (perform_stack));
		if (!p->cycle_label) {
			sprintf (name, "EXIT PERFORM CYCLE %d", cb_id);
			p->cycle_label = cb_build_reference (name);
			plabel = cb_build_label (p->cycle_label, NULL);
			CB_LABEL (plabel)->flag_begin = 1;
			CB_LABEL (plabel)->flag_dummy_exit = 1;
		}
		current_statement->name = (const char *)"EXIT PERFORM CYCLE";
		cb_emit_goto (CB_LIST_INIT (p->cycle_label), NULL);
		check_unreached = 1;
	}
  }
#line 22384 "parser.c" /* yacc.c:1652  */
    break;

  case 1883:
#line 12876 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	struct cb_perform	*p;
	cb_tree			plabel;
	char			name[64];

	if (!perform_stack) {
		cb_error_x (CB_TREE (current_statement),
			    _("EXIT PERFORM is only valid with inline PERFORM"));
	} else if (CB_VALUE (perform_stack) != cb_error_node) {
		p = CB_PERFORM (CB_VALUE (perform_stack));
		if (!p->exit_label) {
			sprintf (name, "EXIT PERFORM %d", cb_id);
			p->exit_label = cb_build_reference (name);
			plabel = cb_build_label (p->exit_label, NULL);
			CB_LABEL (plabel)->flag_begin = 1;
			CB_LABEL (plabel)->flag_dummy_exit = 1;
		}
		current_statement->name = (const char *)"EXIT PERFORM";
		cb_emit_goto (CB_LIST_INIT (p->exit_label), NULL);
		check_unreached = 1;
	}
  }
#line 22411 "parser.c" /* yacc.c:1652  */
    break;

  case 1884:
#line 12899 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_tree	plabel;
	char	name[64];

	if (!current_section) {
		cb_error_x (CB_TREE (current_statement),
			    _("EXIT SECTION is only valid with an active SECTION"));
	} else {
		if (!current_section->exit_label) {
			sprintf (name, "EXIT SECTION %d", cb_id);
			current_section->exit_label = cb_build_reference (name);
			plabel = cb_build_label (current_section->exit_label, NULL);
			CB_LABEL (plabel)->flag_begin = 1;
			CB_LABEL (plabel)->flag_dummy_exit = 1;
		}
		current_statement->name = (const char *)"EXIT SECTION";
		cb_emit_goto (CB_LIST_INIT (current_section->exit_label), NULL);
		check_unreached = 1;
	}
  }
#line 22436 "parser.c" /* yacc.c:1652  */
    break;

  case 1885:
#line 12920 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_tree	plabel;
	char	name[64];

	if (!current_paragraph) {
		cb_error_x (CB_TREE (current_statement),
			    _("EXIT PARAGRAPH is only valid with an active PARAGRAPH"));
	} else {
		if (!current_paragraph->exit_label) {
			sprintf (name, "EXIT PARAGRAPH %d", cb_id);
			current_paragraph->exit_label = cb_build_reference (name);
			plabel = cb_build_label (current_paragraph->exit_label, NULL);
			CB_LABEL (plabel)->flag_begin = 1;
			CB_LABEL (plabel)->flag_dummy_exit = 1;
		}
		current_statement->name = (const char *)"EXIT PARAGRAPH";
		cb_emit_goto (CB_LIST_INIT (current_paragraph->exit_label), NULL);
		check_unreached = 1;
	}
  }
#line 22461 "parser.c" /* yacc.c:1652  */
    break;

  case 1886:
#line 12943 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 22467 "parser.c" /* yacc.c:1652  */
    break;

  case 1887:
#line 12946 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 22473 "parser.c" /* yacc.c:1652  */
    break;

  case 1888:
#line 12954 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_statement ("FREE", 0);
	current_statement->flag_no_based = 1;
  }
#line 22482 "parser.c" /* yacc.c:1652  */
    break;

  case 1890:
#line 12963 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_free (yyvsp[0]);
  }
#line 22490 "parser.c" /* yacc.c:1652  */
    break;

  case 1891:
#line 12973 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_statement ("GENERATE", 0);
  }
#line 22498 "parser.c" /* yacc.c:1652  */
    break;

  case 1893:
#line 12982 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_implicit_statement ();
	if (yyvsp[0] != cb_error_node) {
		cb_emit_generate (yyvsp[0]);
	}
  }
#line 22509 "parser.c" /* yacc.c:1652  */
    break;

  case 1894:
#line 12994 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (!current_paragraph->flag_statement) {
		current_paragraph->flag_first_is_goto = 1;
	}
	begin_statement ("GO TO", 0);
	save_debug = start_debug;
	start_debug = 0;
  }
#line 22522 "parser.c" /* yacc.c:1652  */
    break;

  case 1896:
#line 13007 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_goto (yyvsp[-1], yyvsp[0]);
	start_debug = save_debug;
  }
#line 22531 "parser.c" /* yacc.c:1652  */
    break;

  case 1897:
#line 13012 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (cb_verify (cb_goto_entry, "ENTRY FOR GO TO")) {
		cb_emit_goto_entry (yyvsp[-1], yyvsp[0]);
	}
	start_debug = save_debug;
  }
#line 22542 "parser.c" /* yacc.c:1652  */
    break;

  case 1898:
#line 13022 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_unreached = 1;
	yyval = NULL;
  }
#line 22551 "parser.c" /* yacc.c:1652  */
    break;

  case 1899:
#line 13027 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_unreached = 0;
	yyval = yyvsp[0];
  }
#line 22560 "parser.c" /* yacc.c:1652  */
    break;

  case 1900:
#line 13038 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_statement ("GOBACK", 0);
	check_unreached = 1;
	if (yyvsp[0]) {
		if (!current_program->cb_return_code) {
			cb_error_x (yyvsp[0], _("RETURNING/GIVING not allowed for non-returning runtime elements"));
		} else {
			cb_emit_move (yyvsp[0], CB_LIST_INIT (current_program->cb_return_code));
		}
	}
	cb_emit_exit (1U);
  }
#line 22577 "parser.c" /* yacc.c:1652  */
    break;

  case 1901:
#line 13057 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_statement ("IF", TERM_IF);
  }
#line 22585 "parser.c" /* yacc.c:1652  */
    break;

  case 1903:
#line 13066 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_if (yyvsp[(-1) - (5)], yyvsp[-3], yyvsp[0]);
  }
#line 22593 "parser.c" /* yacc.c:1652  */
    break;

  case 1904:
#line 13070 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_if (yyvsp[(-1) - (3)], NULL, yyvsp[0]);
	cb_verify (cb_missing_statement,
		_("IF without imperative statement"));
  }
#line 22603 "parser.c" /* yacc.c:1652  */
    break;

  case 1905:
#line 13076 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_if (yyvsp[(-1) - (2)], yyvsp[0], NULL);
  }
#line 22611 "parser.c" /* yacc.c:1652  */
    break;

  case 1906:
#line 13082 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_save_cond ();
  }
#line 22619 "parser.c" /* yacc.c:1652  */
    break;

  case 1907:
#line 13086 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_save_cond ();
  }
#line 22627 "parser.c" /* yacc.c:1652  */
    break;

  case 1908:
#line 13092 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_true_side ();
  }
#line 22635 "parser.c" /* yacc.c:1652  */
    break;

  case 1909:
#line 13098 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_false_side ();
  }
#line 22643 "parser.c" /* yacc.c:1652  */
    break;

  case 1910:
#line 13105 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_WARNING (yyvsp[(-4) - (0)], IF);
	cb_terminate_cond ();
  }
#line 22652 "parser.c" /* yacc.c:1652  */
    break;

  case 1911:
#line 13110 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_CLEAR (yyvsp[(-4) - (1)], IF);
	cb_terminate_cond ();
  }
#line 22661 "parser.c" /* yacc.c:1652  */
    break;

  case 1912:
#line 13121 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_statement ("INITIALIZE", 0);
  }
#line 22669 "parser.c" /* yacc.c:1652  */
    break;

  case 1914:
#line 13130 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_initialize (yyvsp[-4], yyvsp[-3], yyvsp[-2], yyvsp[-1], yyvsp[0]);
  }
#line 22677 "parser.c" /* yacc.c:1652  */
    break;

  case 1915:
#line 13136 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 22683 "parser.c" /* yacc.c:1652  */
    break;

  case 1916:
#line 13137 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_true; }
#line 22689 "parser.c" /* yacc.c:1652  */
    break;

  case 1917:
#line 13141 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 22695 "parser.c" /* yacc.c:1652  */
    break;

  case 1918:
#line 13142 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_true; }
#line 22701 "parser.c" /* yacc.c:1652  */
    break;

  case 1919:
#line 13143 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[-2]; }
#line 22707 "parser.c" /* yacc.c:1652  */
    break;

  case 1920:
#line 13148 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 22715 "parser.c" /* yacc.c:1652  */
    break;

  case 1921:
#line 13152 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 22723 "parser.c" /* yacc.c:1652  */
    break;

  case 1922:
#line 13159 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 22731 "parser.c" /* yacc.c:1652  */
    break;

  case 1923:
#line 13164 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_list_append (yyvsp[-1], yyvsp[0]);
  }
#line 22739 "parser.c" /* yacc.c:1652  */
    break;

  case 1924:
#line 13171 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = CB_BUILD_PAIR (yyvsp[-3], yyvsp[0]);
  }
#line 22747 "parser.c" /* yacc.c:1652  */
    break;

  case 1925:
#line 13177 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_int (CB_CATEGORY_ALPHABETIC); }
#line 22753 "parser.c" /* yacc.c:1652  */
    break;

  case 1926:
#line 13178 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_int (CB_CATEGORY_ALPHANUMERIC); }
#line 22759 "parser.c" /* yacc.c:1652  */
    break;

  case 1927:
#line 13179 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_int (CB_CATEGORY_NUMERIC); }
#line 22765 "parser.c" /* yacc.c:1652  */
    break;

  case 1928:
#line 13180 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_int (CB_CATEGORY_ALPHANUMERIC_EDITED); }
#line 22771 "parser.c" /* yacc.c:1652  */
    break;

  case 1929:
#line 13181 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_int (CB_CATEGORY_NUMERIC_EDITED); }
#line 22777 "parser.c" /* yacc.c:1652  */
    break;

  case 1930:
#line 13182 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_int (CB_CATEGORY_NATIONAL); }
#line 22783 "parser.c" /* yacc.c:1652  */
    break;

  case 1931:
#line 13183 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_int (CB_CATEGORY_NATIONAL_EDITED); }
#line 22789 "parser.c" /* yacc.c:1652  */
    break;

  case 1932:
#line 13195 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 22797 "parser.c" /* yacc.c:1652  */
    break;

  case 1933:
#line 13199 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_true;
  }
#line 22805 "parser.c" /* yacc.c:1652  */
    break;

  case 1934:
#line 13208 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_statement ("INITIATE", 0);
  }
#line 22813 "parser.c" /* yacc.c:1652  */
    break;

  case 1936:
#line 13216 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_implicit_statement ();
	if (yyvsp[0] != cb_error_node) {
		cb_emit_initiate (yyvsp[0]);
	}
  }
#line 22824 "parser.c" /* yacc.c:1652  */
    break;

  case 1937:
#line 13223 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_implicit_statement ();
	if (yyvsp[0] != cb_error_node) {
		cb_emit_initiate (yyvsp[0]);
	}
  }
#line 22835 "parser.c" /* yacc.c:1652  */
    break;

  case 1938:
#line 13235 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_statement ("INQUIRE", 0);
	cobc_cs_check = CB_CS_INQUIRE_MODIFY;
  }
#line 22844 "parser.c" /* yacc.c:1652  */
    break;

  case 1939:
#line 13240 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cobc_cs_check = 0;
  }
#line 22852 "parser.c" /* yacc.c:1652  */
    break;

  case 1942:
#line 13254 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_statement ("INSPECT", 0);
	inspect_keyword = 0;
  }
#line 22861 "parser.c" /* yacc.c:1652  */
    break;

  case 1952:
#line 13282 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	previous_tallying_phrase = NO_PHRASE;
	cb_init_tallying ();
  }
#line 22870 "parser.c" /* yacc.c:1652  */
    break;

  case 1953:
#line 13287 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (!(previous_tallying_phrase == CHARACTERS_PHRASE
	      || previous_tallying_phrase == VALUE_REGION_PHRASE)) {
		cb_error (_("TALLYING clause is incomplete"));
	} else {
		cb_emit_inspect (yyvsp[-3], yyvsp[0], TALLYING_CLAUSE);
	}

	yyval = yyvsp[-3];
  }
#line 22885 "parser.c" /* yacc.c:1652  */
    break;

  case 1954:
#line 13303 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_inspect (yyvsp[-2], yyvsp[0], REPLACING_CLAUSE);
	inspect_keyword = 0;
  }
#line 22894 "parser.c" /* yacc.c:1652  */
    break;

  case 1955:
#line 13313 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_tree		x = cb_build_converting (yyvsp[-3], yyvsp[-1], yyvsp[0]);
	cb_emit_inspect (yyvsp[-5], x, CONVERTING_CLAUSE);
  }
#line 22903 "parser.c" /* yacc.c:1652  */
    break;

  case 1956:
#line 13321 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 22911 "parser.c" /* yacc.c:1652  */
    break;

  case 1957:
#line 13325 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_list_append (yyvsp[-1], yyvsp[0]);
  }
#line 22919 "parser.c" /* yacc.c:1652  */
    break;

  case 1958:
#line 13332 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_preceding_tallying_phrases (FOR_PHRASE);
	yyval = cb_build_tallying_data (yyvsp[-1]);
  }
#line 22928 "parser.c" /* yacc.c:1652  */
    break;

  case 1959:
#line 13337 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_preceding_tallying_phrases (CHARACTERS_PHRASE);
	yyval = cb_build_tallying_characters (yyvsp[0]);
  }
#line 22937 "parser.c" /* yacc.c:1652  */
    break;

  case 1960:
#line 13342 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_preceding_tallying_phrases (ALL_LEADING_TRAILING_PHRASES);
	yyval = cb_build_tallying_all ();
  }
#line 22946 "parser.c" /* yacc.c:1652  */
    break;

  case 1961:
#line 13347 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_preceding_tallying_phrases (ALL_LEADING_TRAILING_PHRASES);
	yyval = cb_build_tallying_leading ();
  }
#line 22955 "parser.c" /* yacc.c:1652  */
    break;

  case 1962:
#line 13352 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_preceding_tallying_phrases (ALL_LEADING_TRAILING_PHRASES);
	yyval = cb_build_tallying_trailing ();
  }
#line 22964 "parser.c" /* yacc.c:1652  */
    break;

  case 1963:
#line 13357 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	check_preceding_tallying_phrases (VALUE_REGION_PHRASE);
	yyval = cb_build_tallying_value (yyvsp[-1], yyvsp[0]);
  }
#line 22973 "parser.c" /* yacc.c:1652  */
    break;

  case 1964:
#line 13364 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 22979 "parser.c" /* yacc.c:1652  */
    break;

  case 1965:
#line 13365 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_list_append (yyvsp[-1], yyvsp[0]); }
#line 22985 "parser.c" /* yacc.c:1652  */
    break;

  case 1966:
#line 13370 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_build_replacing_characters (yyvsp[-1], yyvsp[0]);
	inspect_keyword = 0;
  }
#line 22994 "parser.c" /* yacc.c:1652  */
    break;

  case 1967:
#line 13375 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 23002 "parser.c" /* yacc.c:1652  */
    break;

  case 1969:
#line 13382 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { inspect_keyword = 1; }
#line 23008 "parser.c" /* yacc.c:1652  */
    break;

  case 1970:
#line 13383 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { inspect_keyword = 2; }
#line 23014 "parser.c" /* yacc.c:1652  */
    break;

  case 1971:
#line 13384 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { inspect_keyword = 3; }
#line 23020 "parser.c" /* yacc.c:1652  */
    break;

  case 1972:
#line 13385 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { inspect_keyword = 4; }
#line 23026 "parser.c" /* yacc.c:1652  */
    break;

  case 1973:
#line 13390 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	switch (inspect_keyword) {
		case 1:
			yyval = cb_build_replacing_all (yyvsp[-3], yyvsp[-1], yyvsp[0]);
			break;
		case 2:
			yyval = cb_build_replacing_leading (yyvsp[-3], yyvsp[-1], yyvsp[0]);
			break;
		case 3:
			yyval = cb_build_replacing_first (yyvsp[-3], yyvsp[-1], yyvsp[0]);
			break;
		case 4:
			yyval = cb_build_replacing_trailing (yyvsp[-3], yyvsp[-1], yyvsp[0]);
			break;
		default:
			cb_error_x (CB_TREE (current_statement),
				    _("INSPECT missing ALL/FIRST/LEADING/TRAILING"));
			yyval = cb_build_replacing_all (yyvsp[-3], yyvsp[-1], yyvsp[0]);
			break;
	}
  }
#line 23052 "parser.c" /* yacc.c:1652  */
    break;

  case 1974:
#line 13417 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_build_inspect_region_start ();
  }
#line 23060 "parser.c" /* yacc.c:1652  */
    break;

  case 1975:
#line 13421 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_list_add (cb_build_inspect_region_start (), yyvsp[0]);
  }
#line 23068 "parser.c" /* yacc.c:1652  */
    break;

  case 1976:
#line 13425 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_list_add (cb_build_inspect_region_start (), yyvsp[0]);
  }
#line 23076 "parser.c" /* yacc.c:1652  */
    break;

  case 1977:
#line 13429 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_list_add (cb_list_add (cb_build_inspect_region_start (), yyvsp[-1]), yyvsp[0]);
  }
#line 23084 "parser.c" /* yacc.c:1652  */
    break;

  case 1978:
#line 13433 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_list_add (cb_list_add (cb_build_inspect_region_start (), yyvsp[-1]), yyvsp[0]);
  }
#line 23092 "parser.c" /* yacc.c:1652  */
    break;

  case 1979:
#line 13440 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = CB_BUILD_FUNCALL_1 ("cob_inspect_before", yyvsp[0]);
  }
#line 23100 "parser.c" /* yacc.c:1652  */
    break;

  case 1980:
#line 13447 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = CB_BUILD_FUNCALL_1 ("cob_inspect_after", yyvsp[0]);
  }
#line 23108 "parser.c" /* yacc.c:1652  */
    break;

  case 1981:
#line 13456 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_statement ("JSON GENERATE", TERM_JSON);
	cobc_in_json_generate_body = 1;
	cobc_cs_check = CB_CS_JSON_GENERATE;
  }
#line 23118 "parser.c" /* yacc.c:1652  */
    break;

  case 1983:
#line 13468 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	ml_suppress_list = NULL;
  }
#line 23126 "parser.c" /* yacc.c:1652  */
    break;

  case 1984:
#line 13473 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cobc_in_json_generate_body = 0;
	cobc_cs_check = 0;
  }
#line 23135 "parser.c" /* yacc.c:1652  */
    break;

  case 1985:
#line 13478 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_json_generate (yyvsp[-8], yyvsp[-6], yyvsp[-5], yyvsp[-3], ml_suppress_list);
  }
#line 23143 "parser.c" /* yacc.c:1652  */
    break;

  case 1986:
#line 13485 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 23151 "parser.c" /* yacc.c:1652  */
    break;

  case 1987:
#line 13489 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 23159 "parser.c" /* yacc.c:1652  */
    break;

  case 1990:
#line 13501 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	error_if_following_every_clause ();
	add_identifier_to_ml_suppress_conds (yyvsp[0]);
  }
#line 23168 "parser.c" /* yacc.c:1652  */
    break;

  case 1991:
#line 13509 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_WARNING (yyvsp[(-2) - (0)], JSON);
  }
#line 23176 "parser.c" /* yacc.c:1652  */
    break;

  case 1992:
#line 13513 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_CLEAR (yyvsp[(-2) - (1)], JSON);
  }
#line 23184 "parser.c" /* yacc.c:1652  */
    break;

  case 1993:
#line 13522 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_statement ("JSON PARSE", TERM_JSON);
	CB_PENDING (_("JSON PARSE"));
  }
#line 23193 "parser.c" /* yacc.c:1652  */
    break;

  case 1998:
#line 13547 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_statement ("MERGE", 0);
	current_statement->flag_merge = 1;
  }
#line 23202 "parser.c" /* yacc.c:1652  */
    break;

  case 2000:
#line 13559 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_statement ("MODIFY", TERM_MODIFY);
	cobc_cs_check = CB_CS_INQUIRE_MODIFY;
  }
#line 23211 "parser.c" /* yacc.c:1652  */
    break;

  case 2001:
#line 13565 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cobc_cs_check = 0;
  }
#line 23219 "parser.c" /* yacc.c:1652  */
    break;

  case 2004:
#line 13577 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_WARNING (yyvsp[(-2) - (0)], MODIFY);
  }
#line 23227 "parser.c" /* yacc.c:1652  */
    break;

  case 2005:
#line 13581 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_CLEAR (yyvsp[(-2) - (1)], MODIFY);
  }
#line 23235 "parser.c" /* yacc.c:1652  */
    break;

  case 2006:
#line 13591 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_statement ("MOVE", 0);
  }
#line 23243 "parser.c" /* yacc.c:1652  */
    break;

  case 2008:
#line 13599 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_move (yyvsp[-2], yyvsp[0]);
  }
#line 23251 "parser.c" /* yacc.c:1652  */
    break;

  case 2009:
#line 13603 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_move_corresponding (yyvsp[-2], yyvsp[0]);
  }
#line 23259 "parser.c" /* yacc.c:1652  */
    break;

  case 2010:
#line 13613 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_statement ("MULTIPLY", TERM_MULTIPLY);
  }
#line 23267 "parser.c" /* yacc.c:1652  */
    break;

  case 2012:
#line 13622 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_arithmetic (yyvsp[-1], '*', yyvsp[-3]);
  }
#line 23275 "parser.c" /* yacc.c:1652  */
    break;

  case 2013:
#line 13626 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_arithmetic (yyvsp[-1], 0, cb_build_binary_op (yyvsp[-5], '*', yyvsp[-3]));
  }
#line 23283 "parser.c" /* yacc.c:1652  */
    break;

  case 2014:
#line 13633 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_WARNING (yyvsp[(-2) - (0)], MULTIPLY);
  }
#line 23291 "parser.c" /* yacc.c:1652  */
    break;

  case 2015:
#line 13637 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_CLEAR (yyvsp[(-2) - (1)], MULTIPLY);
  }
#line 23299 "parser.c" /* yacc.c:1652  */
    break;

  case 2016:
#line 13647 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_statement ("OPEN", 0);
	cobc_cs_check = CB_CS_OPEN;
  }
#line 23308 "parser.c" /* yacc.c:1652  */
    break;

  case 2020:
#line 13661 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_tree l;
	cb_tree x;

	if ((yyvsp[-5] && yyvsp[-3]) || (yyvsp[-5] && yyvsp[0]) || (yyvsp[-3] && yyvsp[0])) {
		cb_error_x (CB_TREE (current_statement),
			    _("%s and %s are mutually exclusive"), "SHARING", _("LOCK clauses"));
	}
	if (yyvsp[0]) {
		x = yyvsp[0];
	} else if (yyvsp[-3]) {
		x = yyvsp[-3];
	} else {
		x = yyvsp[-5];
	}

	for (l = yyvsp[-1]; l; l = CB_CHAIN (l)) {
		if (CB_VALID_TREE (CB_VALUE (l))) {
			begin_implicit_statement ();
			cb_emit_open (CB_VALUE (l), yyvsp[-4], x);
		}
	}
  }
#line 23336 "parser.c" /* yacc.c:1652  */
    break;

  case 2021:
#line 13688 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 23342 "parser.c" /* yacc.c:1652  */
    break;

  case 2022:
#line 13689 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_int (COB_LOCK_OPEN_EXCLUSIVE); }
#line 23348 "parser.c" /* yacc.c:1652  */
    break;

  case 2023:
#line 13693 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_int (COB_OPEN_INPUT); }
#line 23354 "parser.c" /* yacc.c:1652  */
    break;

  case 2024:
#line 13694 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_int (COB_OPEN_OUTPUT); }
#line 23360 "parser.c" /* yacc.c:1652  */
    break;

  case 2025:
#line 13695 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_int (COB_OPEN_I_O); }
#line 23366 "parser.c" /* yacc.c:1652  */
    break;

  case 2026:
#line 13696 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_int (COB_OPEN_EXTEND); }
#line 23372 "parser.c" /* yacc.c:1652  */
    break;

  case 2027:
#line 13700 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 23378 "parser.c" /* yacc.c:1652  */
    break;

  case 2028:
#line 13701 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 23384 "parser.c" /* yacc.c:1652  */
    break;

  case 2029:
#line 13705 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 23390 "parser.c" /* yacc.c:1652  */
    break;

  case 2030:
#line 13706 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 23396 "parser.c" /* yacc.c:1652  */
    break;

  case 2031:
#line 13707 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 23402 "parser.c" /* yacc.c:1652  */
    break;

  case 2032:
#line 13711 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[-1]; }
#line 23408 "parser.c" /* yacc.c:1652  */
    break;

  case 2033:
#line 13713 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	  (void)cb_verify (CB_OBSOLETE, "OPEN LEAVE/REREAD/DISP");
	  yyval = NULL;
  }
#line 23417 "parser.c" /* yacc.c:1652  */
    break;

  case 2034:
#line 13720 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 23423 "parser.c" /* yacc.c:1652  */
    break;

  case 2035:
#line 13721 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 23429 "parser.c" /* yacc.c:1652  */
    break;

  case 2036:
#line 13725 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_int (COB_LOCK_OPEN_EXCLUSIVE); }
#line 23435 "parser.c" /* yacc.c:1652  */
    break;

  case 2037:
#line 13727 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int (COB_LOCK_OPEN_EXCLUSIVE);
	/* TODO: check for indexed; pass extra flag to fileio */
	CB_PENDING ("WITH MASS-UPDATE");
  }
#line 23445 "parser.c" /* yacc.c:1652  */
    break;

  case 2038:
#line 13733 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int (COB_LOCK_OPEN_EXCLUSIVE);
	/* TODO: check for indexed; pass extra flag to fileio */
	CB_PENDING ("WITH BULK-ADDITION");
  }
#line 23455 "parser.c" /* yacc.c:1652  */
    break;

  case 2039:
#line 13741 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_int (COB_LOCK_OPEN_EXCLUSIVE); }
#line 23461 "parser.c" /* yacc.c:1652  */
    break;

  case 2040:
#line 13742 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 23467 "parser.c" /* yacc.c:1652  */
    break;

  case 2041:
#line 13743 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 23473 "parser.c" /* yacc.c:1652  */
    break;

  case 2045:
#line 13755 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	/* FIXME: only allow for sequential files */
	/* FIXME: only allow with INPUT or OUTPUT */
	CB_PENDING ("OPEN WITH NO REWIND");
	yyval = NULL;
  }
#line 23484 "parser.c" /* yacc.c:1652  */
    break;

  case 2046:
#line 13762 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	/* FIXME: only allow for sequential / line-sequential files */
	/* FIXME: only allow with INPUT */
	/* FIXME: add actual compiler configuration */
	if (cb_warn_obsolete == COBC_WARN_AS_ERROR) {
		(void)cb_verify (CB_OBSOLETE, "OPEN REVERSED");
	} else {
		/* FIXME: set file attribute */
		CB_PENDING ("OPEN REVERSED");
	};
	yyval = NULL;
  }
#line 23501 "parser.c" /* yacc.c:1652  */
    break;

  case 2050:
#line 13785 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_statement ("PERFORM", TERM_PERFORM);
	/* Turn off field debug - PERFORM is special */
	save_debug = start_debug;
	start_debug = 0;
	cobc_cs_check = CB_CS_PERFORM;
  }
#line 23513 "parser.c" /* yacc.c:1652  */
    break;

  case 2052:
#line 13800 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_perform (yyvsp[0], yyvsp[-2], yyvsp[-3], yyvsp[-1]);
	start_debug = save_debug;
	cobc_cs_check = 0;
  }
#line 23523 "parser.c" /* yacc.c:1652  */
    break;

  case 2053:
#line 13808 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_ADD_TO_CHAIN (yyvsp[-1], perform_stack);
	/* Restore field debug before inline statements */
	start_debug = save_debug;
	cobc_cs_check = 0;
  }
#line 23534 "parser.c" /* yacc.c:1652  */
    break;

  case 2054:
#line 13815 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	perform_stack = CB_CHAIN (perform_stack);
	cb_emit_perform (yyvsp[-4], yyvsp[-1], yyvsp[-5], yyvsp[-3]);
  }
#line 23543 "parser.c" /* yacc.c:1652  */
    break;

  case 2055:
#line 13822 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_verify (cb_missing_statement,
		_("inline PERFORM without imperative statement"));
  }
#line 23552 "parser.c" /* yacc.c:1652  */
    break;

  case 2056:
#line 13827 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_perform (yyvsp[-3], NULL, yyvsp[-4], yyvsp[-2]);
	start_debug = save_debug;
	cobc_cs_check = 0;
  }
#line 23562 "parser.c" /* yacc.c:1652  */
    break;

  case 2057:
#line 13836 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (cb_relaxed_syntax_checks) {
		TERMINATOR_WARNING (yyvsp[(-6) - (0)], PERFORM);
	} else {
		TERMINATOR_ERROR (yyvsp[(-6) - (0)], PERFORM);
	}
  }
#line 23574 "parser.c" /* yacc.c:1652  */
    break;

  case 2058:
#line 13844 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_CLEAR (yyvsp[(-6) - (1)], PERFORM);
  }
#line 23582 "parser.c" /* yacc.c:1652  */
    break;

  case 2059:
#line 13851 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_CLEAR (yyvsp[(-3) - (1)], PERFORM);
  }
#line 23590 "parser.c" /* yacc.c:1652  */
    break;

  case 2060:
#line 13855 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	if (cb_relaxed_syntax_checks) {
		TERMINATOR_WARNING (yyvsp[(-3) - (1)], PERFORM);
	} else {
		TERMINATOR_ERROR (yyvsp[(-3) - (1)], PERFORM);
	}
	/* Put the dot token back into the stack for reparse */
	cb_unput_dot ();
  }
#line 23604 "parser.c" /* yacc.c:1652  */
    break;

  case 2061:
#line 13868 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	/* Return from $1 */
	CB_REFERENCE (yyvsp[0])->length = cb_true;
	CB_REFERENCE (yyvsp[0])->flag_decl_ok = 1;
	yyval = CB_BUILD_PAIR (yyvsp[0], yyvsp[0]);
  }
#line 23615 "parser.c" /* yacc.c:1652  */
    break;

  case 2062:
#line 13875 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	/* Return from $3 */
	CB_REFERENCE (yyvsp[0])->length = cb_true;
	CB_REFERENCE (yyvsp[-2])->flag_decl_ok = 1;
	CB_REFERENCE (yyvsp[0])->flag_decl_ok = 1;
	yyval = CB_BUILD_PAIR (yyvsp[-2], yyvsp[0]);
  }
#line 23627 "parser.c" /* yacc.c:1652  */
    break;

  case 2063:
#line 13886 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_build_perform_once (NULL);
  }
#line 23635 "parser.c" /* yacc.c:1652  */
    break;

  case 2064:
#line 13890 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_build_perform_times (yyvsp[-1]);
	current_program->loop_counter++;
  }
#line 23644 "parser.c" /* yacc.c:1652  */
    break;

  case 2065:
#line 13895 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_build_perform_forever (NULL);
  }
#line 23652 "parser.c" /* yacc.c:1652  */
    break;

  case 2066:
#line 13899 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_tree varying;

	if (!yyvsp[0]) {
		yyval = cb_build_perform_forever (NULL);
	} else {
		if (yyvsp[-2] == CB_AFTER)
			cb_build_perform_after_until();
		varying = CB_LIST_INIT (cb_build_perform_varying (NULL, NULL, NULL, yyvsp[0]));
		yyval = cb_build_perform_until (yyvsp[-2], varying);
	}
  }
#line 23669 "parser.c" /* yacc.c:1652  */
    break;

  case 2067:
#line 13912 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_build_perform_until (yyvsp[-2], yyvsp[0]);
  }
#line 23677 "parser.c" /* yacc.c:1652  */
    break;

  case 2068:
#line 13918 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = CB_BEFORE; }
#line 23683 "parser.c" /* yacc.c:1652  */
    break;

  case 2069:
#line 13919 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 23689 "parser.c" /* yacc.c:1652  */
    break;

  case 2070:
#line 13923 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 23695 "parser.c" /* yacc.c:1652  */
    break;

  case 2071:
#line 13924 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 23701 "parser.c" /* yacc.c:1652  */
    break;

  case 2072:
#line 13927 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = CB_LIST_INIT (yyvsp[0]); }
#line 23707 "parser.c" /* yacc.c:1652  */
    break;

  case 2073:
#line 13929 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = cb_list_add (yyvsp[-2], yyvsp[0]); }
#line 23713 "parser.c" /* yacc.c:1652  */
    break;

  case 2074:
#line 13934 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_tree		x;
	int		data_type_ok = 1;

	if (yyvsp[-5] != cb_error_node
	 && yyvsp[-3] != cb_error_node
	 && yyvsp[-2] != cb_error_node) {

		if (cb_tree_category (yyvsp[-5]) != CB_CATEGORY_NUMERIC) {
			x = cb_ref (yyvsp[-5]);
			cb_error_x (CB_TREE (current_statement),
				_("PERFORM VARYING '%s' (line %d of %s) is not a numeric field"),
				cb_name (x),x->source_line, x->source_file);
			yyval = cb_int1;
			data_type_ok = 0;
		}
		if (cb_tree_category (yyvsp[-3]) != CB_CATEGORY_NUMERIC) {
			x = cb_ref (yyvsp[-3]);
			cb_error_x (CB_TREE (current_statement),
				_("PERFORM VARYING '%s' (line %d of %s) is not a numeric field"),
				cb_name (x),x->source_line, x->source_file);
			yyval = cb_int1;
			data_type_ok = 0;
		}
		if (cb_tree_category (yyvsp[-2]) != CB_CATEGORY_NUMERIC) {
			x = cb_ref (yyvsp[-2]);
			cb_error_x (CB_TREE (current_statement),
				_("PERFORM VARYING '%s' (line %d of %s) is not a numeric field"),
				cb_name (x),x->source_line, x->source_file);
			yyval = cb_int1;
			data_type_ok = 0;
		}

		if (data_type_ok) {
			yyval = cb_build_perform_varying (yyvsp[-5], yyvsp[-3], yyvsp[-2], yyvsp[0]);
		}
	}
  }
#line 23756 "parser.c" /* yacc.c:1652  */
    break;

  case 2075:
#line 13976 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_verify (cb_perform_varying_without_by, _("PERFORM VARYING without BY phrase"));
	yyval = cb_build_numeric_literal (0, "1", 0);
  }
#line 23765 "parser.c" /* yacc.c:1652  */
    break;

  case 2076:
#line 13981 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 23773 "parser.c" /* yacc.c:1652  */
    break;

  case 2077:
#line 13990 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_statement ("PURGE", 0);
  }
#line 23781 "parser.c" /* yacc.c:1652  */
    break;

  case 2078:
#line 13994 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
  }
#line 23788 "parser.c" /* yacc.c:1652  */
    break;

  case 2079:
#line 14002 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_statement ("RAISE", 0);
  }
#line 23796 "parser.c" /* yacc.c:1652  */
    break;

  case 2081:
#line 14010 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("RAISE statement");
	/* TODO: check for level 3 error here */
  }
#line 23805 "parser.c" /* yacc.c:1652  */
    break;

  case 2082:
#line 14015 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	/* easy cheating here as we don't have any OO in */
	cb_error(_("'%s' is not an object-reference"), cb_name (yyvsp[0]));
  }
#line 23814 "parser.c" /* yacc.c:1652  */
    break;

  case 2083:
#line 14025 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	/* TODO:
	cb_tree exception = get_exception (CB_NAME($1));
	if (!exception) {
		cb_error (_("'%s' is not an exception-name"), CB_NAME ($1));
	}
	*/
  }
#line 23827 "parser.c" /* yacc.c:1652  */
    break;

  case 2084:
#line 14039 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_statement ("READ", TERM_READ);
	cobc_cs_check = CB_CS_READ;
  }
#line 23836 "parser.c" /* yacc.c:1652  */
    break;

  case 2086:
#line 14049 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cobc_cs_check = 0;

	if (CB_VALID_TREE (yyvsp[-6])) {
		struct cb_file	*cf;

		cf = CB_FILE(cb_ref (yyvsp[-6]));
		if (yyvsp[-2] && (cf->lock_mode & COB_LOCK_AUTOMATIC)) {
			cb_error_x (CB_TREE (current_statement),
				    _("LOCK clause invalid with file LOCK AUTOMATIC"));
		} else if (yyvsp[-1] &&
		      (cf->organization != COB_ORG_RELATIVE &&
		       cf->organization != COB_ORG_INDEXED)) {
			cb_error_x (CB_TREE (current_statement),
				    _("KEY clause invalid with this file type"));
		} else if (current_statement->handler_type == INVALID_KEY_HANDLER &&
			   (cf->organization != COB_ORG_RELATIVE &&
			    cf->organization != COB_ORG_INDEXED)) {
			cb_error_x (CB_TREE (current_statement),
				    _("INVALID KEY clause invalid with this file type"));
		} else {
			cb_emit_read (yyvsp[-6], yyvsp[-5], yyvsp[-3], yyvsp[-1], yyvsp[-2]);
		}
	}
  }
#line 23866 "parser.c" /* yacc.c:1652  */
    break;

  case 2087:
#line 14077 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 23872 "parser.c" /* yacc.c:1652  */
    break;

  case 2088:
#line 14078 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 23878 "parser.c" /* yacc.c:1652  */
    break;

  case 2089:
#line 14083 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 23886 "parser.c" /* yacc.c:1652  */
    break;

  case 2090:
#line 14087 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int3;
  }
#line 23894 "parser.c" /* yacc.c:1652  */
    break;

  case 2091:
#line 14091 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 23902 "parser.c" /* yacc.c:1652  */
    break;

  case 2092:
#line 14095 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 23910 "parser.c" /* yacc.c:1652  */
    break;

  case 2095:
#line 14107 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("ADVANCING ON LOCK");
  }
#line 23918 "parser.c" /* yacc.c:1652  */
    break;

  case 2099:
#line 14120 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	CB_PENDING ("RETRY");
	cobc_cs_check = 0;
  }
#line 23927 "parser.c" /* yacc.c:1652  */
    break;

  case 2105:
#line 14140 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = yyvsp[0];
  }
#line 23935 "parser.c" /* yacc.c:1652  */
    break;

  case 2106:
#line 14144 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
   yyval = cb_int5;
  }
#line 23943 "parser.c" /* yacc.c:1652  */
    break;

  case 2107:
#line 14148 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	/* TO-DO: Merge with RETRY phrase */
	yyval = cb_int4;
  }
#line 23952 "parser.c" /* yacc.c:1652  */
    break;

  case 2108:
#line 14155 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = NULL; }
#line 23958 "parser.c" /* yacc.c:1652  */
    break;

  case 2109:
#line 14156 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    { yyval = yyvsp[0]; }
#line 23964 "parser.c" /* yacc.c:1652  */
    break;

  case 2112:
#line 14166 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_WARNING (yyvsp[(-2) - (0)], READ);
  }
#line 23972 "parser.c" /* yacc.c:1652  */
    break;

  case 2113:
#line 14170 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_CLEAR (yyvsp[(-2) - (1)], READ);
  }
#line 23980 "parser.c" /* yacc.c:1652  */
    break;

  case 2114:
#line 14180 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_statement ("READY TRACE", 0);
	cb_emit_ready_trace ();
  }
#line 23989 "parser.c" /* yacc.c:1652  */
    break;

  case 2115:
#line 14190 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_statement ("RECEIVE", TERM_RECEIVE);
  }
#line 23997 "parser.c" /* yacc.c:1652  */
    break;

  case 2129:
#line 14233 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_WARNING (yyvsp[(-2) - (0)], RECEIVE);
  }
#line 24005 "parser.c" /* yacc.c:1652  */
    break;

  case 2130:
#line 14237 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_CLEAR (yyvsp[(-2) - (1)], RECEIVE);
  }
#line 24013 "parser.c" /* yacc.c:1652  */
    break;

  case 2131:
#line 14246 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_statement ("RELEASE", 0);
  }
#line 24021 "parser.c" /* yacc.c:1652  */
    break;

  case 2133:
#line 14254 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_release (yyvsp[-1], yyvsp[0]);
  }
#line 24029 "parser.c" /* yacc.c:1652  */
    break;

  case 2134:
#line 14264 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_statement ("RESET TRACE", 0);
	cb_emit_reset_trace ();
  }
#line 24038 "parser.c" /* yacc.c:1652  */
    break;

  case 2135:
#line 14274 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_statement ("RETURN", TERM_RETURN);
  }
#line 24046 "parser.c" /* yacc.c:1652  */
    break;

  case 2137:
#line 14283 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_return (yyvsp[-3], yyvsp[-1]);
  }
#line 24054 "parser.c" /* yacc.c:1652  */
    break;

  case 2138:
#line 14290 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_WARNING (yyvsp[(-2) - (0)], RETURN);
  }
#line 24062 "parser.c" /* yacc.c:1652  */
    break;

  case 2139:
#line 14294 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_CLEAR (yyvsp[(-2) - (1)], RETURN);
  }
#line 24070 "parser.c" /* yacc.c:1652  */
    break;

  case 2140:
#line 14304 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_statement ("REWRITE", TERM_REWRITE);
	/* Special in debugging mode */
	save_debug = start_debug;
	start_debug = 0;
  }
#line 24081 "parser.c" /* yacc.c:1652  */
    break;

  case 2142:
#line 14316 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	cb_emit_rewrite (yyvsp[-4], yyvsp[-3], yyvsp[-1]);
	start_debug = save_debug;
  }
#line 24090 "parser.c" /* yacc.c:1652  */
    break;

  case 2143:
#line 14324 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = NULL;
  }
#line 24098 "parser.c" /* yacc.c:1652  */
    break;

  case 2145:
#line 14332 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int1;
  }
#line 24106 "parser.c" /* yacc.c:1652  */
    break;

  case 2146:
#line 14336 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	yyval = cb_int2;
  }
#line 24114 "parser.c" /* yacc.c:1652  */
    break;

  case 2147:
#line 14343 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_WARNING (yyvsp[(-2) - (0)], REWRITE);
  }
#line 24122 "parser.c" /* yacc.c:1652  */
    break;

  case 2148:
#line 14347 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	TERMINATOR_CLEAR (yyvsp[(-2) - (1)], REWRITE);
  }
#line 24130 "parser.c" /* yacc.c:1652  */
    break;

  case 2149:
#line 14357 "/mnt/d/Programme/Entwicklung/GnuCOBOL/code/tags/gnucobol-3.1-rc1/cobc/parser.y" /* yacc.c:1652  */
    {
	begin_statement ("ROLLBACK", 0);
	cb_emit_rollback ();
  }
#line 24139 "parser.c" /* yacc.c:1652  */
    break;

  case 2150:
#line 14368 "/mnt/d/Prog