/* A Bison parser, made by GNU Bison 3.7.5.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30705

/* Bison version string.  */
#define YYBISON_VERSION "3.7.5"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 28 "../../cobc/parser.y"

#include "config.h"

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#ifdef	HAVE_STRINGS_H
#include <strings.h>
#endif

#define	COB_IN_PARSER	1
#include "cobc.h"
#include "tree.h"
#include "libcob/coblocal.h"

#define _PARSER_H	/* work around bad Windows SDK header */

#ifndef	_STDLIB_H
#define	_STDLIB_H 1
#endif

#define YYSTYPE			cb_tree
#define yyerror(x)		cb_error_always ("%s", x)

#define emit_statement(x) \
do { \
  if (!skip_statements) { \
	CB_ADD_TO_CHAIN (x, current_program->exec_list); \
  } \
}  ONCE_COB

#define push_expr(type, node) \
  current_expr = cb_build_list (cb_int (type), node, current_expr)

/* Statement terminator definitions */
#define TERM_NONE		0
#define TERM_ACCEPT		1U
#define TERM_ADD		2U
#define TERM_CALL		3U
#define TERM_COMPUTE		4U
#define TERM_DELETE		5U
#define TERM_DISPLAY		6U
#define TERM_DIVIDE		7U
#define TERM_EVALUATE		8U
#define TERM_IF			9U
#define TERM_JSON		10U
#define TERM_MODIFY		11U
#define TERM_MULTIPLY		12U
#define TERM_PERFORM		13U
#define TERM_READ		14U
#define TERM_RECEIVE		15U
#define TERM_RETURN		16U
#define TERM_REWRITE		17U
#define TERM_SEARCH		18U
#define TERM_START		19U
#define TERM_STRING		20U
#define TERM_SUBTRACT		21U
#define TERM_UNSTRING		22U
#define TERM_WRITE		23U
#define TERM_XML		24U
#define TERM_MAX		25U	/* Always last entry, used for array size */

#define	TERMINATOR_WARNING(x,z)	terminator_warning (x, TERM_##z, #z)
#define	TERMINATOR_ERROR(x,z)	terminator_error (x, TERM_##z, #z)
#define	TERMINATOR_CLEAR(x,z)	terminator_clear (x, TERM_##z)

/* Defines for duplicate checks */
/* Note - We use <= 16 for common item definitions and */
/* > 16 for non-common item definitions e.g. REPORT and SCREEN */
#define	SYN_CLAUSE_1		(1U << 0)
#define	SYN_CLAUSE_2		(1U << 1)
#define	SYN_CLAUSE_3		(1U << 2)
#define	SYN_CLAUSE_4		(1U << 3)
#define	SYN_CLAUSE_5		(1U << 4)
#define	SYN_CLAUSE_6		(1U << 5)
#define	SYN_CLAUSE_7		(1U << 6)
#define	SYN_CLAUSE_8		(1U << 7)
#define	SYN_CLAUSE_9		(1U << 8)
#define	SYN_CLAUSE_10		(1U << 9)
#define	SYN_CLAUSE_11		(1U << 10)
#define	SYN_CLAUSE_12		(1U << 11)
#define	SYN_CLAUSE_13		(1U << 12)
#define	SYN_CLAUSE_14		(1U << 13)
#define	SYN_CLAUSE_15		(1U << 14)
#define	SYN_CLAUSE_16		(1U << 15)
#define	SYN_CLAUSE_17		(1U << 16)
#define	SYN_CLAUSE_18		(1U << 17)
#define	SYN_CLAUSE_19		(1U << 18)
#define	SYN_CLAUSE_20		(1U << 19)
#define	SYN_CLAUSE_21		(1U << 20)
#define	SYN_CLAUSE_22		(1U << 21)
#define	SYN_CLAUSE_23		(1U << 22)
#define	SYN_CLAUSE_24		(1U << 23)
#define	SYN_CLAUSE_25		(1U << 24)
#define	SYN_CLAUSE_26		(1U << 25)
#define	SYN_CLAUSE_27		(1U << 26)
#define	SYN_CLAUSE_28		(1U << 27)
#define	SYN_CLAUSE_29		(1U << 28)
#define	SYN_CLAUSE_30		(1U << 29)
#define	SYN_CLAUSE_31		(1U << 30)
#define	SYN_CLAUSE_32		(1U << 31)

#define	EVAL_DEPTH		32
#define	PROG_DEPTH		16

/* Global variables */

struct cb_program		*current_program = NULL;    /* program in parse/syntax check/codegen */
struct cb_label			*current_section = NULL;
struct cb_label			*current_paragraph = NULL;
struct cb_statement		*current_statement = NULL;
cb_tree				defined_prog_list = NULL;
int				cb_exp_line = 0;

int				functions_are_all = 0;
int				non_const_word = 0;
int				suppress_data_exceptions = 0;
unsigned int			cobc_repeat_last_token = 0;
unsigned int			cobc_in_id = 0;
unsigned int			cobc_in_procedure = 0;
unsigned int			cobc_in_repository = 0;
unsigned int			cobc_force_literal = 0;
unsigned int			cobc_cs_check = 0;
unsigned int			cobc_allow_program_name = 0;
unsigned int			cobc_in_xml_generate_body = 0;
unsigned int			cobc_in_json_generate_body = 0;
unsigned int			cobc_areacheck = 0;
unsigned int			cobc_in_area_a = 0;

/* Local variables */

enum inspect_rep_keyword {
	INSPECT_REP_DEFAULT,
	INSPECT_REP_ALL,
	INSPECT_REP_LEADING,
	INSPECT_REP_FIRST,
	INSPECT_REP_TRAILING,
};

union examine_keyword {
	/* EXAMINE TALLYING/REPLACING options */
	enum {
		EXAMINE_TAL_ALL,
		EXAMINE_TAL_LEADING,
		EXAMINE_TAL_UNTIL_FIRST,
	} tallying;
	enum {
		EXAMINE_REP_ALL,
		EXAMINE_REP_LEADING,
		EXAMINE_REP_FIRST,
		EXAMINE_REP_UNTIL_FIRST,
	} replacing;
};

enum tallying_phrase {
	NO_PHRASE,
	FOR_PHRASE,
	CHARACTERS_PHRASE,
	ALL_LEADING_TRAILING_PHRASES,
	VALUE_REGION_PHRASE
};

enum key_clause_type {
	NO_KEY,
	RECORD_KEY,
	RELATIVE_KEY
};

static cb_tree			current_expr;
static struct cb_field		*current_field;
static struct cb_field		*control_field;
static struct cb_field		*description_field;
static struct cb_file		*current_file;
static struct cb_cd		*current_cd;
static struct cb_report		*current_report;
static struct cb_report		*report_instance;
static struct cb_key_component	*key_component_list;

static struct cb_file		*linage_file;
static cb_tree			next_label_list;

static const char			*stack_progid[PROG_DEPTH];

static enum cb_storage		current_storage;

static cb_tree			perform_stack;
static cb_tree			qualifier;
static cb_tree			keys_list;

static cb_tree			save_tree;
static cb_tree			start_tree;

static unsigned int		check_unreached;
static unsigned int		within_typedef_definition;
static unsigned int		in_declaratives;
static unsigned int		in_debugging;
static unsigned int		current_linage;
static unsigned int		report_count;
static unsigned int		first_prog;
static unsigned int		setup_from_identification;
static unsigned int		use_global_ind;
static unsigned int		same_area;
static enum inspect_rep_keyword	inspect_keyword;
static union examine_keyword	examine_keyword;
static unsigned int		main_flag_set;
static int			next_label_id;
static int			eval_level;
static int			eval_inc;
static int			eval_inc2;
static int			depth;
static int			first_nested_program;
static enum cb_call_mode	call_mode;
static int			size_mode;
static cob_flags_t		set_attr_val_on;
static cob_flags_t		set_attr_val_off;
static cob_flags_t		check_duplicate;
static cob_flags_t		check_on_off_duplicate;
static cob_flags_t		check_pic_duplicate;
static cob_flags_t		check_line_col_duplicate;
static unsigned int		skip_statements;
static unsigned int		start_debug;
static unsigned int		save_debug;
static unsigned int		needs_field_debug;
static unsigned int		needs_debug_item;
static unsigned int		env_div_seen;
static cob_flags_t		header_check;
static unsigned int		call_nothing;
static enum tallying_phrase	previous_tallying_phrase;
static cb_tree			default_rounded_mode;
static enum key_clause_type	key_type;

static int			ext_dyn_specified;
static enum cb_assign_device	assign_device;

static enum cb_display_type	display_type;
static int			is_first_display_item;
static cb_tree			advancing_value;
static cb_tree			upon_value;
static cb_tree			line_column;

static unsigned int		exhibit_changed;
static unsigned int		exhibit_named;

static cb_tree			ml_suppress_list;
static cb_tree			xml_encoding;
static int			with_xml_dec;
static int			with_attrs;

static cb_tree			default_collation;
static cb_tree			alphanumeric_collation;
static cb_tree			national_collation;

static enum cb_ml_suppress_category	ml_suppress_category;

static int			term_array[TERM_MAX];
static cb_tree			eval_check[EVAL_DEPTH][EVAL_DEPTH];

static const char		*backup_source_file = NULL;
static int			backup_source_line = 0;

/* Defines for header presence */

#define	COBC_HD_ENVIRONMENT_DIVISION	(1U << 0)
#define	COBC_HD_CONFIGURATION_SECTION	(1U << 1)
#define	COBC_HD_SPECIAL_NAMES		(1U << 2)
#define	COBC_HD_INPUT_OUTPUT_SECTION	(1U << 3)
#define	COBC_HD_FILE_CONTROL		(1U << 4)
#define	COBC_HD_I_O_CONTROL		(1U << 5)
#define	COBC_HD_DATA_DIVISION		(1U << 6)
#define	COBC_HD_FILE_SECTION		(1U << 7)
#define	COBC_HD_WORKING_STORAGE_SECTION	(1U << 8)
#define	COBC_HD_LOCAL_STORAGE_SECTION	(1U << 9)
#define	COBC_HD_LINKAGE_SECTION		(1U << 10)
#define	COBC_HD_COMMUNICATION_SECTION	(1U << 11)
#define	COBC_HD_REPORT_SECTION		(1U << 12)
#define	COBC_HD_SCREEN_SECTION		(1U << 13)
#define	COBC_HD_PROCEDURE_DIVISION	(1U << 14)
#define	COBC_HD_PROGRAM_ID		(1U << 15)
#define	COBC_HD_SOURCE_COMPUTER		(1U << 16)
#define	COBC_HD_OBJECT_COMPUTER		(1U << 17)
#define	COBC_HD_REPOSITORY		(1U << 18)

/* Static functions */

/* Area A enforcement */

static COB_INLINE void
check_area_a (cb_tree word) {
	if (!cobc_in_area_a && cobc_areacheck) {
		(void) cb_syntax_check_x (word, _("'%s' should start in Area A"),
					  CB_NAME (word));
	}
}

static COB_INLINE void
check_area_a_of (const char * const item) {
	if (!cobc_in_area_a && cobc_areacheck) {
		(void) cb_syntax_check (_("'%s' should start in Area A"), item);
	}
}

static COB_INLINE void
check_non_area_a (cb_tree stmt) {
	if (cobc_in_area_a && cobc_areacheck) {
		if (stmt)
			(void) cb_syntax_check_x (stmt, _("start of statement in Area A"));
		else
			(void) cb_syntax_check (_("start of statement in Area A"));
	}
}

/* Collating sequences */

/* Known collating sequences/alphabets */
enum cb_colseq {
	CB_COLSEQ_NATIVE,
	CB_COLSEQ_ASCII,
	CB_COLSEQ_EBCDIC,
};
enum cb_colseq cb_default_colseq = CB_COLSEQ_NATIVE;

/* Decipher character conversion table names */
int cb_deciph_default_colseq_name (const char * const name)
{
	if (! cb_strcasecmp (name, "ASCII")) {
		cb_default_colseq = CB_COLSEQ_ASCII;
	} else if (! cb_strcasecmp (name, "EBCDIC")) {
		cb_default_colseq = CB_COLSEQ_EBCDIC;
	} else if (! cb_strcasecmp (name, "NATIVE")) {
		cb_default_colseq = CB_COLSEQ_NATIVE;
	} else {
		return 1;
	}
	return 0;
}

static cb_tree
build_colseq_tree (const char *alphabet_name,
		      int alphabet_type,
		      int alphabet_target)
{
	const cb_tree name = cb_build_reference (alphabet_name);
	struct cb_alphabet_name * alpha;
	alpha = CB_ALPHABET_NAME (cb_build_alphabet_name (name));
	alpha->alphabet_type = alphabet_type;
	alpha->alphabet_target = alphabet_target;
	return name;
}

static cb_tree
build_colseq (enum cb_colseq colseq)
{
	switch (colseq) {
	case CB_COLSEQ_NATIVE:
		return NULL;
	case CB_COLSEQ_ASCII:
		return build_colseq_tree ("ASCII",
				      CB_ALPHABET_ASCII,
				      CB_ALPHABET_ALPHANUMERIC);
	case CB_COLSEQ_EBCDIC:
		return build_colseq_tree ("EBCDIC",
				      CB_ALPHABET_EBCDIC,
				      CB_ALPHABET_ALPHANUMERIC);
	/* LCOV_EXCL_START */
	default:
		cobc_err_msg (_("call to '%s' with invalid parameter '%s'"),
			"build_colseq", "colseq");
		COBC_ABORT ();
	}
	/* LCOV_EXCL_STOP */

}


/* Statements */

static void
begin_statement (enum cob_statement statement, const unsigned int term)
{
	if (check_unreached) {
		cb_warning (cb_warn_unreachable,
			_("unreachable statement '%s'"),
			cb_statement_name[statement]);
	}
	current_paragraph->flag_statement = 1;
	current_statement = cb_build_statement (statement);
	CB_TREE (current_statement)->source_file = cb_source_file;
	CB_TREE (current_statement)->source_line = cb_source_line;
	current_statement->flag_in_debug = in_debugging;
	check_non_area_a (CB_TREE (current_statement));
	emit_statement (CB_TREE (current_statement));
	if (term) {
		term_array[term]++;
	}
}

static void
restore_backup_pos (cb_tree item)
{
	item->source_file = backup_source_file;
	item->source_line = backup_source_line;
}

static void
begin_statement_from_backup_pos (enum cob_statement statement, const unsigned int term)
{
	current_paragraph->flag_statement = 1;
	current_statement = cb_build_statement (statement);
	restore_backup_pos (CB_TREE (current_statement));
	current_statement->flag_in_debug = in_debugging;
	emit_statement (CB_TREE (current_statement));
	if (term) {
		term_array[term]++;
	}
	if (check_unreached) {
		cb_warning_x (cb_warn_unreachable, CB_TREE (current_statement),
			_("unreachable statement '%s'"),
			cb_statement_name[statement]);
	}
}

/* create a new statement with base attributes of current_statement
   and set this as new current_statement */
static void
begin_implicit_statement (void)
{
	struct cb_statement	*new_statement;
	new_statement = cb_build_statement (current_statement->statement);
	new_statement->common = current_statement->common;
	new_statement->flag_in_debug = !!in_debugging;
	new_statement->flag_implicit = 1;
	current_statement->body = cb_list_add (current_statement->body,
					    CB_TREE (new_statement));
	current_statement = new_statement;
}

# if 0 /* activate only for debugging purposes for attribs
	FIXME: Replace by DEBUG_LOG function */
static
void print_bits (cob_flags_t num)
{
	unsigned int 	size = sizeof (cob_flags_t);
	unsigned int	max_pow = 1 << (size * 8 - 1);
	int 		i = 0;

	for(; i < size * 8; ++i){
		/* Print last bit and shift left. */
		fprintf (stderr, "%u ", num & max_pow ? 1 : 0);
		num = num << 1;
	}
	fprintf (stderr, "\n");
}
#endif

/* functions for storing current position and
   assigning it to a cb_tree after its parsing is finished */
static COB_INLINE
void backup_current_pos (void)
{
	backup_source_file = cb_source_file;
	backup_source_line = cb_source_line;
}

#if 0 /* currently not used */
static COB_INLINE
void set_pos_from_backup (cb_tree x)
{
	x->source_file = backup_source_file;
	x->source_line = backup_source_line;
}
#endif

static void
emit_entry (const char *name, const int encode, cb_tree using_list, cb_tree convention, int override_source_line)
{
	cb_tree		l;
	cb_tree		label;
	cb_tree		entry_conv;
	char		buff[COB_MINI_BUFF];

	snprintf (buff, (size_t)COB_MINI_MAX, "E$%s", name);
	label = cb_build_label (cb_build_reference (buff), NULL);
	if (encode) {
		CB_LABEL (label)->name = cb_encode_program_id (name, 0, cb_fold_call);
		CB_LABEL (label)->orig_name = name;
	} else {
		CB_LABEL (label)->name = name;
		CB_LABEL (label)->orig_name = current_program->orig_program_id;
	}
	CB_LABEL (label)->flag_begin = 1;
	CB_LABEL (label)->flag_entry = 1;
	if (override_source_line) {
		label->source_line = override_source_line;
	}
	emit_statement (label);

	if (current_program->flag_debugging) {
		emit_statement (cb_build_debug (cb_debug_contents,
						"START PROGRAM", NULL));
	}

	cb_validate_parameters_and_returning (current_program, using_list);

	for (l = current_program->entry_list; l; l = CB_CHAIN (l)) {
		struct cb_label *check = CB_LABEL (CB_PURPOSE (l));
		if (strcmp (name, check->name) == 0) {
			cb_error_x (CB_TREE (current_statement),
				    _("ENTRY '%s' duplicated"), name);
		}
	}

	if (convention) {
		entry_conv = convention;
	} else {
		entry_conv = current_program->entry_convention;
	}

	current_program->entry_list =
		cb_list_append (current_program->entry_list,
				CB_BUILD_PAIR (label, CB_BUILD_PAIR(entry_conv, using_list)));
}

/* Main entry point and the number of its main parameters */
static void
emit_main_entry (struct cb_program *program, cb_tree using_list)
{
	if (using_list) {
		program->num_proc_params = cb_list_length (using_list);
	}

	emit_entry (program->program_id, 0, using_list, NULL, 0);
	if (program->source_name) {
		emit_entry (program->source_name, 1, using_list, NULL, 0);
	}
}

static void
emit_entry_goto (const char *name)
{
	cb_tree		l;
	cb_tree		label;
	char		buff[COB_MINI_BUFF];

	snprintf (buff, (size_t)COB_MINI_MAX, "E$%s", name);
	label = cb_build_label (cb_build_reference (buff), NULL);
	CB_LABEL (label)->name = name;
	CB_LABEL (label)->orig_name = name;
	CB_LABEL (label)->flag_begin = 1;
	CB_LABEL (label)->flag_entry = 1;
	CB_LABEL (label)->flag_entry_for_goto = 1;
	label->source_line = backup_source_line;	/* CHECKME: is that correct? */
	emit_statement (label);

	for (l = current_program->entry_list_goto; l; l = CB_CHAIN (l)) {
		struct cb_label *real_label = CB_LABEL (CB_VALUE (l));
		if (strcmp (name, real_label->name) == 0) {
			cb_error_x (CB_TREE (current_statement),
				    _("ENTRY FOR GO TO '%s' duplicated"), name);
		}
	}

	if (current_program->entry_list_goto) {
		current_program->entry_list_goto =
			cb_list_add (current_program->entry_list_goto, label);
	} else {
		current_program->entry_list_goto = CB_LIST_INIT (label);
	}
}

static size_t
increment_depth (void)
{
	if (++depth >= PROG_DEPTH) {
		cb_error (_("maximum nested program depth exceeded (%d)"),
			  PROG_DEPTH);
		return 1;
	}
	return 0;
}

static void
terminator_warning (cb_tree stmt, const unsigned int termid,
		    const char *name)
{
	char		terminator[32];

	check_unreached = 0;
	if (term_array[termid]) {
		term_array[termid]--;
	/* LCOV_EXCL_START */
	} else {
		cobc_err_msg ("call to '%s' without any open term for %s",
			"terminator_warning", name);
		COBC_ABORT ();
	}
	/* LCOV_EXCL_STOP */
	snprintf (terminator, 32, "END-%s", name);
	if (is_reserved_word (terminator)) {
		cb_warning_x (cb_warn_terminator, CB_TREE (current_statement),
			_("%s statement not terminated by %s"), name, terminator);
	}

	/* Free tree associated with terminator */
	if (stmt) {
		cobc_parse_free (stmt);
	}
}

static void
terminator_error (cb_tree stmt, const unsigned int termid, const char *name)
{
	char		terminator[32];

	check_unreached = 0;
	if (term_array[termid]) {
		term_array[termid]--;
	/* LCOV_EXCL_START */
	} else {
		cobc_err_msg ("call to '%s' without any open term for %s",
			"terminator_error", name);
		COBC_ABORT ();
	}
	/* LCOV_EXCL_STOP */
	snprintf (terminator, 32, "END-%s", name);
	if (is_reserved_word (terminator)) {
		cb_error_x (CB_TREE (current_statement),
			_("%s statement not terminated by %s"), name, terminator);
	} else {
		cb_error_x (CB_TREE (current_statement),
			_("%s statement not terminated"), name);
	}

	/* Free tree associated with terminator */
	if (stmt) {
		cobc_parse_free (stmt);
	}
}

static void
terminator_clear (cb_tree stmt, const unsigned int termid)
{
	struct cb_perform	*p;
	check_unreached = 0;
	if (term_array[termid]) {
		term_array[termid]--;
	/* LCOV_EXCL_START */
	} else {
		cobc_err_msg ("call to '%s' without any open term for %s",
			"terminator_warning", cb_statement_name[current_statement->statement]);
		COBC_ABORT ();
	}
	/* LCOV_EXCL_STOP */
	if (termid == TERM_PERFORM
	 && perform_stack) {
		p = CB_PERFORM (CB_VALUE (perform_stack));
		if (p->perform_type == CB_PERFORM_UNTIL) {
			cb_terminate_cond ();
		}
	}
	/* Free tree associated with terminator */
	if (stmt) {
		cobc_parse_free (stmt);
	}
}

static void
setup_use_file (struct cb_file *fileptr)
{
	struct cb_file	*newptr;

	if (fileptr->organization == COB_ORG_SORT) {
		cb_error (_("USE statement invalid for SORT file"));
	}
	if (fileptr->flag_global) {
		newptr = cobc_parse_malloc (sizeof(struct cb_file));
		*newptr = *fileptr;
		newptr->handler = current_section;
		newptr->handler_prog = current_program;
		if (!use_global_ind) {
			current_program->local_file_list =
				cb_list_add (current_program->local_file_list,
					     CB_TREE (newptr));
		} else {
			current_program->global_file_list =
				cb_list_add (current_program->global_file_list,
					     CB_TREE (newptr));
		}
	} else {
		fileptr->handler = current_section;
	}
}

/* note: same message in field.c */
static int
emit_duplicate_clause_message (const char *clause)
{
	return cb_syntax_check (_("duplicate %s clause"), clause);
}

static int
check_repeated (const char *clause, const cob_flags_t bitval,
			cob_flags_t *already_seen)
{
	if (*already_seen & bitval) {
		return emit_duplicate_clause_message (clause);
	}
	*already_seen |= bitval;
	return 0;
}

static void
emit_conflicting_clause_message (const char *clause, const char *conflicting)
{
	if (cb_syntax_check (_("cannot specify both %s and %s"), clause, conflicting)) {
		cb_note (COBC_WARN_FILLER, 0, _("%s is ignored"), clause);
	}
}


static void
error_if_no_page_lines_limit (const char *phrase)
{
	if (!current_report->lines && !current_report->t_lines) {
		cb_error (_("cannot specify %s without number of lines on page"),
			  phrase);
	}
}

static void
setup_occurs (void)
{
	check_repeated ("OCCURS", SYN_CLAUSE_7, &check_pic_duplicate);
	if (current_field->indexes == COB_MAX_SUBSCRIPTS) {
		cb_error (_("maximum OCCURS depth exceeded (%d)"),
			COB_MAX_SUBSCRIPTS);
	} else {
		current_field->indexes++;
	}

	if (current_field->flag_unbounded) {
		if (current_field->storage != CB_STORAGE_LINKAGE) {
			cb_error_x (CB_TREE(current_field), _("'%s' is not in LINKAGE SECTION"),
				cb_name (CB_TREE(current_field)));
		}
	}

	if (current_field->flag_item_based) {
		cb_error (_("%s and %s are mutually exclusive"), "BASED", "OCCURS");
	} else if (current_field->flag_external) {
		cb_error (_("%s and %s are mutually exclusive"), "EXTERNAL", "OCCURS");
	}
	current_field->flag_occurs = 1;
}

static void
setup_occurs_min_max (cb_tree occurs_min, cb_tree occurs_max)
{
	if (occurs_max) {
		current_field->occurs_min = cb_get_int (occurs_min);
		if (occurs_max != cb_int0) {
			current_field->occurs_max = cb_get_int (occurs_max);
			if (!current_field->depending) {
				if (cb_syntax_check (_("TO phrase without DEPENDING phrase"))) {
					cb_note (COBC_WARN_FILLER, 0,
						 _("maximum number of occurrences assumed to be exact number"));
					current_field->occurs_min = 1; /* CHECKME: why using 1 ? */
				}
			}
			if (current_field->occurs_max <= current_field->occurs_min) {
				cb_error (_("OCCURS TO must be greater than OCCURS FROM"));
				current_field->occurs_max = current_field->occurs_min;
			}
		} else {
			current_field->occurs_max = 0;	/* UNBOUNDED */
		}
	} else {
		current_field->occurs_min = 1; /* CHECKME: why using 1 ? */
		current_field->occurs_max = cb_get_int (occurs_min);
		if (current_field->depending) {
			cb_verify (cb_odo_without_to, _("OCCURS DEPENDING ON without TO phrase"));
		}
	}
	/* LCOV_EXCL_START */
	if (current_field->occurs_max > COB_MAX_FIELD_SIZE) {
		/* testing here to give an early error; unlikely to be reached
		   with 64bit compilers so no own msgid for now; should be added
		   when the maximum field size is changed to be configurable */
		cb_error_x (CB_TREE (current_field),
			_("'%s' cannot be larger than %d bytes"),
			current_field->name, COB_MAX_FIELD_SIZE);
		current_field->occurs_min = current_field->occurs_max = 1;
	}
	/* LCOV_EXCL_STOP */
}

static void
check_relaxed_syntax (const cob_flags_t lev)
{
	const char	*s;

	switch (lev) {
	case COBC_HD_ENVIRONMENT_DIVISION:
		s = "ENVIRONMENT DIVISION";
		break;
	case COBC_HD_CONFIGURATION_SECTION:
		s = "CONFIGURATION SECTION";
		break;
	case COBC_HD_SPECIAL_NAMES:
		s = "SPECIAL-NAMES";
		break;
	case COBC_HD_INPUT_OUTPUT_SECTION:
		s = "INPUT-OUTPUT SECTION";
		break;
	case COBC_HD_FILE_CONTROL:
		s = "FILE-CONTROL";
		break;
	case COBC_HD_I_O_CONTROL:
		s = "I-O-CONTROL";
		break;
	case COBC_HD_DATA_DIVISION:
		s = "DATA DIVISION";
		break;
	case COBC_HD_FILE_SECTION:
		s = "FILE SECTION";
		break;
	case COBC_HD_WORKING_STORAGE_SECTION:
		s = "WORKING-STORAGE SECTION";
		break;
	case COBC_HD_LOCAL_STORAGE_SECTION:
		s = "LOCAL-STORAGE SECTION";
		break;
	case COBC_HD_LINKAGE_SECTION:
		s = "LINKAGE SECTION";
		break;
	case COBC_HD_COMMUNICATION_SECTION:
		s = "COMMUNICATION SECTION";
		break;
	case COBC_HD_REPORT_SECTION:
		s = "REPORT SECTION";
		break;
	case COBC_HD_SCREEN_SECTION:
		s = "SCREEN SECTION";
		break;
	case COBC_HD_PROCEDURE_DIVISION:
		s = "PROCEDURE DIVISION";
		break;
	case COBC_HD_PROGRAM_ID:
		s = "PROGRAM-ID";
		break;
	/* LCOV_EXCL_START */
	default:
		s = _("unknown");
		break;
	/* LCOV_EXCL_STOP */
	}
	if (cb_syntax_check (_("%s header missing"), s)) {
		cb_note (COBC_WARN_FILLER, 0, _("%s header assumed"), s);
	}
}

static void
program_init_without_program_id (void)
{
	cb_tree		l;

	current_section = NULL;
	current_paragraph = NULL;
	l = cb_build_alphanumeric_literal (demangle_name,
		strlen (demangle_name));
	current_program->program_name = (char *)CB_LITERAL (l)->data;
	current_program->program_id
		= cb_build_program_id (current_program->program_name, 0);
	current_program->prog_type = COB_MODULE_TYPE_PROGRAM;
	if (!main_flag_set) {
		main_flag_set = 1;
		current_program->flag_main = cobc_flag_main;
	}
	check_relaxed_syntax (COBC_HD_PROGRAM_ID);
}

/* check if headers are present - return 0 if fine, 1 if missing
   Lev1 must always be present and is checked
   Lev2/3/4, if non-zero (forced) may be present
*/
static int
check_headers_present (const cob_flags_t lev1, const cob_flags_t lev2,
		       const cob_flags_t lev3, const cob_flags_t lev4)
{
	int ret = 0;
	if (!(header_check & lev1)) {
		header_check |= lev1;
		check_relaxed_syntax (lev1);
		ret = 1;
	}
	if (lev2) {
		if (!(header_check & lev2)) {
			header_check |= lev2;
			check_relaxed_syntax (lev2);
			ret = 1;
		}
	}
	if (lev3) {
		if (!(header_check & lev3)) {
			header_check |= lev3;
			check_relaxed_syntax (lev3);
			ret = 1;
		}
	}
	if (lev4) {
		if (!(header_check & lev4)) {
			header_check |= lev4;
			check_relaxed_syntax (lev4);
			ret = 1;
		}
	}
	return ret;
}

/*
  TO-DO: Refactor header checks - have several header_checks: division_header,
  section_header, paragraph_header, sentence_type
*/
static void
set_conf_section_part (const cob_flags_t part)
{
	header_check &= ~COBC_HD_SOURCE_COMPUTER;
	header_check &= ~COBC_HD_OBJECT_COMPUTER;
	header_check &= ~COBC_HD_SPECIAL_NAMES;
	header_check &= ~COBC_HD_REPOSITORY;
	header_check |= part;
}

static const char *
get_conf_section_part_name (const cob_flags_t part)
{
	if (part == COBC_HD_SOURCE_COMPUTER) {
		return "SOURCE-COMPUTER";
	} else if (part == COBC_HD_OBJECT_COMPUTER) {
		return "OBJECT-COMPUTER";
	} else if (part == COBC_HD_SPECIAL_NAMES) {
		return "SPECIAL-NAMES";
	} else if (part == COBC_HD_REPOSITORY) {
		return "REPOSITORY";
	/* LCOV_EXCL_START */
	} else {
		/* This should never happen (and therefore doesn't get a translation) */
		cb_error ("unexpected configuration section part " CB_FMT_LLU, part);
		COBC_ABORT ();
	/* LCOV_EXCL_STOP */
	}
}

static int
get_conf_section_part_order (const cob_flags_t part)
{
	if (part == COBC_HD_SOURCE_COMPUTER) {
		return 1;
	} else if (part == COBC_HD_OBJECT_COMPUTER) {
		return 2;
	} else if (part == COBC_HD_SPECIAL_NAMES) {
		return 3;
	} else if (part == COBC_HD_REPOSITORY) {
		return 4;
	/* LCOV_EXCL_START */
	} else {
		/* This should never happen (and therefore doesn't get a translation) */
		cb_error ("unexpected configuration section part " CB_FMT_LLU, part);
		COBC_ABORT ();
	/* LCOV_EXCL_STOP */
	}
}

static void
check_conf_section_order (const cob_flags_t part)
{
	const cob_flags_t	prev_part
		= header_check & (COBC_HD_SOURCE_COMPUTER
				  | COBC_HD_OBJECT_COMPUTER
				  | COBC_HD_SPECIAL_NAMES
				  | COBC_HD_REPOSITORY);
#define MESSAGE_LEN 100
	char			message[MESSAGE_LEN] = { '\0' };

	if (prev_part == 0) {
		return;
	}

	if (prev_part == part) {
		cb_error (_("duplicate %s"), get_conf_section_part_name (part));
	} else if (get_conf_section_part_order (part) < get_conf_section_part_order (prev_part)) {
		snprintf (message, MESSAGE_LEN, _("%s incorrectly after %s"),
			  get_conf_section_part_name (part),
			  get_conf_section_part_name (prev_part));
		cb_verify (cb_incorrect_conf_sec_order, message);
	}
}

#undef MESSAGE_LEN

/* check if a given register is available; if it is,
   enforce code generation and add a
   "receiving" entry for it when xref is requested */
static void
cb_set_register_receiving (struct cb_field *reg_field, int mandatory)
{
	if (!reg_field) {
		if (mandatory) {
			cb_error ("missing register definition");
		}
		return;
	}
	reg_field->count++;

	if (cb_listing_xref) {
		cobc_xref_set_receiving (CB_TREE (reg_field));
	}
}

static enum cb_handler_type
get_handler_type_from_statement (struct cb_statement *statement)
{
	if (statement->statement == STMT_DISPLAY) {
		return DISPLAY_HANDLER;
	}
	if (statement->statement == STMT_XML_GENERATE
	 || statement->statement == STMT_XML_PARSE) {
		return XML_HANDLER;
	}
	if (statement->statement == STMT_JSON_GENERATE
	 || statement->statement == STMT_JSON_PARSE) {
		return JSON_HANDLER;
	}
#if 0 /* not merged yet */
	if (statement->statement == STMT_DELETE_FILE) {
		return DELETE_FILE_HANDLER;
	}
#endif
	if (statement->statement == STMT_SEND
	 || statement->statement == STMT_RECEIVE) {
		return MCS_HANDLER;
	}
	return NO_HANDLER;
}

static void
build_words_for_nested_programs (void)
{
	cb_tree		x;
	cb_tree		y;

	/* Inherit special name mnemonics from parent */
	for (x = current_program->mnemonic_spec_list; x; x = CB_CHAIN (x)) {
		y = cb_build_reference (cb_name(CB_PURPOSE(x)));
		if (CB_SYSTEM_NAME_P (CB_VALUE(x))) {
			cb_define (y, CB_VALUE(x));
		} else {
			cb_build_constant (y, CB_VALUE(x));
		}
	}

	/* Inherit class names from parent */
	for (x = current_program->class_name_list; x; x = CB_CHAIN(x)) {
		y = cb_build_reference (cb_name(CB_VALUE(x)));
		cb_define (y, CB_VALUE(x));
	}
}

static void
clear_initial_values (void)
{
	perform_stack = NULL;
	current_statement = NULL;
	qualifier = NULL;
	in_declaratives = 0;
	in_debugging = 0;
	use_global_ind = 0;
	check_duplicate = 0;
	check_pic_duplicate = 0;
	skip_statements = 0;
	start_debug = 0;
	save_debug = 0;
	needs_field_debug = 0;
	needs_debug_item = 0;
	env_div_seen = 0;
	header_check = 0;
	next_label_id = 0;
	current_linage = 0;
	set_attr_val_on = 0;
	set_attr_val_off = 0;
	report_count = 0;
	current_storage = CB_STORAGE_WORKING;
	eval_level = 0;
	eval_inc = 0;
	eval_inc2 = 0;
	inspect_keyword = INSPECT_REP_DEFAULT;
	check_unreached = 0;
	cobc_in_id = 0;
	cobc_in_procedure = 0;
	cobc_in_repository = 0;
	cobc_force_literal = 0;
	cobc_in_xml_generate_body = 0;
	cobc_in_json_generate_body = 0;
	non_const_word = 0;
	suppress_data_exceptions = 0;
	same_area = 1;
	memset ((void *)eval_check, 0, sizeof(eval_check));
	memset ((void *)term_array, 0, sizeof(term_array));
	linage_file = NULL;
	current_file = NULL;
	current_cd = NULL;
	current_report = NULL;
	report_instance = NULL;
	next_label_list = NULL;
	default_rounded_mode = cb_int (COB_STORE_ROUND);
}

/*
  We must check for redefinitions of program-names and external program names
  outside of the usual reference/word_list methods as it may have to be done in
  a case-sensitive way.
*/
static void
begin_scope_of_program_name (struct cb_program *program)
{
	const char	*prog_name = program->program_name;
	const char	*prog_id = program->orig_program_id;
	cb_tree		l;

	/*
	  Error if we find a program or prototype with the same name as the
	  given program or prototype, respectively.
	*/
	for (l = defined_prog_list; l; l = CB_CHAIN (l)) {
		const struct cb_program	*elt_program = CB_PROGRAM (CB_VALUE (l));
		const char	*elt_name = elt_program->program_name;
		const char	*elt_id = elt_program->orig_program_id;
		/*
		  If we find a program's matching prototype or a prototype's
		  matching definition, nothing needs to be done.
		*/
		if (program->flag_prototype != elt_program->flag_prototype) {
			continue;
		}

		if (cb_fold_call && strcasecmp (prog_name, elt_name) == 0) {
			cb_error_x (CB_TREE(program),
				    _("redefinition of program name '%s'"),
				    elt_name);
			return;
		} else if (strcmp (prog_id, elt_id) == 0) {
			cb_error_x (CB_TREE(program),
				    _("redefinition of program ID '%s'"),
				    elt_id);
			return;
		}
	}

	/* Otherwise, add the program to the list. */
	defined_prog_list = cb_list_add (defined_prog_list, CB_TREE (program));
}

static void
remove_program_name (struct cb_list *l, struct cb_list *prev)
{
	if (prev == NULL) {
		defined_prog_list = l->chain;
	} else {
		prev->chain = l->chain;
	}
	cobc_parse_free (l);
}

/* Remove the program from defined_prog_list, if necessary. */
static void
end_scope_of_program_name (struct cb_program *program, const unsigned char type)
{
	struct	cb_list	*prev = NULL;
	struct	cb_list *l;

	/* create empty entry if the program has no PROCEDURE DIVISION, error for UDF */
	if (!program->entry_list) {
		if (type == COB_MODULE_TYPE_FUNCTION
		/* CHECKME: That would be valid in a function-definition according to COBOL2014
		  --> How is it intended to work? */
		 && !program->flag_prototype) {
			cb_error (_("FUNCTION '%s' has no PROCEDURE DIVISION"), program->program_name);
		} else {
			emit_main_entry (program, NULL);
		}
	}
	program->last_source_line = backup_source_line;

	if (program->nested_level == 0
	 || defined_prog_list == NULL) {
		return;
	}

	/* Remove any subprograms */
	l = CB_LIST (defined_prog_list);
	while (l) {
		if (CB_PROGRAM (l->value)->nested_level > program->nested_level) {
			remove_program_name (l, prev);
		} else {
			prev = l;
		}
		if (prev && prev->chain != NULL) {
			l = CB_LIST (prev->chain);
		} else {
			l = NULL;
		}
	}

	/* Remove the specified program, if it is not COMMON */
	if (!program->flag_common) {
		l = CB_LIST (defined_prog_list);
		while (l) {
			/* The nested_level check is for the pathological case
			   where two nested programs have the same name */
			if (0 == strcmp (program->orig_program_id,
			         CB_PROGRAM (l->value)->orig_program_id)
			    && program->nested_level == CB_PROGRAM (l->value)->nested_level) {
				remove_program_name (l, prev);
				if (prev && prev->chain != NULL) {
					l = CB_LIST (prev->chain);
				} else {
					l = NULL;
				}
				break;
			} else {
				prev = l;
				if (l->chain != NULL) {
					l = CB_LIST (l->chain);
				} else {
					l = NULL;
				}
			}
		}
	}
}

static void
setup_program_start (void)
{
	if (setup_from_identification) {
		setup_from_identification = 0;
		return;
	}
	current_section = NULL;
	current_paragraph = NULL;

	if (depth != 0 && first_nested_program) {
		check_headers_present (COBC_HD_PROCEDURE_DIVISION, 0, 0, 0);
	}
	first_nested_program = 1;
}

static int
setup_program (cb_tree id, cb_tree as_literal, const unsigned char type, const int prototype)
{
	const char	*external_name = NULL;

	setup_program_start ();

	/* finish last program/function */
	if (!first_prog) {
		backup_source_file = cb_source_file;
		if (!current_program->flag_validated) {
			current_program->flag_validated = 1;
			cb_validate_program_body (current_program);
		}

		clear_initial_values ();
		current_program = cb_build_program (current_program, depth);
		if (depth) {
			build_words_for_nested_programs();
		}
		cb_source_file = "register-definition";
		cb_set_intr_when_compiled ();
		cb_build_registers ();
		cb_add_external_defined_registers ();
		cb_source_file = backup_source_file;
	} else {
		first_prog = 0;
	}

	/* set internal name */
	if (CB_LITERAL_P (id)) {
		current_program->program_name = (char *)CB_LITERAL (id)->data;
	} else {
		current_program->program_name = CB_NAME (id);
	}
	stack_progid[depth] = current_program->program_name;
	current_program->prog_type = type;
	current_program->flag_prototype = prototype;

	if (depth != 0 && type == COB_MODULE_TYPE_FUNCTION) {
		cb_error (_("functions may not be defined within a program/function"));
	}

	if (increment_depth ()) {
		return 1;
	}

	/* set external name if specified */
	if (as_literal) {
		external_name = (const char *)CB_LITERAL (as_literal)->data;
	} else {
		external_name = current_program->program_name;
	}

	/* build encoded external PROGRAM-ID */
	current_program->program_id
		= cb_build_program_id (external_name, type == COB_MODULE_TYPE_FUNCTION);

	if (type == COB_MODULE_TYPE_PROGRAM) {
		if (!main_flag_set
		 && !current_program->flag_prototype) {
			main_flag_set = 1;
			current_program->flag_main = !!cobc_flag_main;
		}
	} else { /* COB_MODULE_TYPE_FUNCTION */
		current_program->flag_recursive = 1;
	}

	if (CB_REFERENCE_P (id)) {
		cb_define (id, CB_TREE (current_program));
	}

	/* Initalize default COLLATING SEQUENCE */
	default_collation = build_colseq (cb_default_colseq);

	begin_scope_of_program_name (current_program);

	return 0;
}

static void
decrement_depth (const char *name, const unsigned char type)
{
	int	d;

	if (depth) {
		depth--;
	}

	if (!strcmp (stack_progid[depth], name)) {
		return;
	}

	if (type == COB_MODULE_TYPE_FUNCTION) {
		cb_error (_("END FUNCTION '%s' is different from FUNCTION-ID '%s'"),
			  name, stack_progid[depth]);
		return;
	}

	/* Set depth to that of whatever program we just ended, if it exists. */
	for (d = depth; d >= 0; --d) {
		if (!strcmp (stack_progid[d], name)) {
			depth = d;
			return;
		}
	}

	if (depth != d) {
		cb_error (_("END PROGRAM '%s' is different from PROGRAM-ID '%s'"),
			  name, stack_progid[depth]);
	}
}

static void
clean_up_program (cb_tree name, const unsigned char type)
{
	char		*s;

	end_scope_of_program_name (current_program, type);

	if (name) {
		if (CB_LITERAL_P (name)) {
			s = (char *)(CB_LITERAL (name)->data);
		} else {
			s = (char *)(CB_NAME (name));
		}

		decrement_depth (s, type);
	}

	current_section = NULL;
	current_paragraph = NULL;
	if (!current_program->flag_validated) {
		current_program->flag_validated = 1;
		cb_validate_program_body (current_program);
	}
}

static const char *
get_literal_or_word_name (const cb_tree x)
{
	if (CB_LITERAL_P (x)) {
		return (const char *) CB_LITERAL (x)->data;
	} else { /* CB_REFERENCE_P (x) */
		return (const char *) CB_NAME (x);
	}
}

/* verify and set currency symbol used in picture (compile time) and - if no currency
   string is explicitly set (which is currently not implemented) - as currency string
   (run time for display and [de-]editing)*/
static void
set_currency_picture_symbol (const cb_tree x)
{
	unsigned char	*s		= CB_LITERAL (x)->data;

	if (CB_LITERAL (x)->size != 1) {
		cb_error_x (x, _("currency symbol must be one character long"));
		return;
	}
	switch (*s) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'N':
	case 'P':
	case 'R':
	case 'S':
	case 'V':
	case 'X':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'n':
	case 'p':
	case 'r':
	case 's':
	case 'v':
	case 'x':
	case 'z':
	case '+':
	case '-':
	case ',':
	case '.':
	case '*':
	case '/':
	case ';':
	case '(':
	case ')':
	case '=':
	case '\'':
	case '"':
	case ' ':
#if 0 /* note: MicroFocus also dissalows L (VAX) and G (OSVS) */
	case 'L':
	case 'G':
	case 'l':
	case 'g':
#endif
		cb_error_x (x, _("invalid character '%c' in currency symbol"), s[0]);
		return;
	default:
		break;
	}
	current_program->currency_symbol = s[0];
}

/* Return 1 if the prototype name is the same as the current function's. */
static int
check_prototype_redefines_current_element (const cb_tree prototype_name)
{
	const char	*name = get_literal_or_word_name (prototype_name);

	if (strcasecmp (name, current_program->program_name) == 0) {
		cb_warning_x (COBC_WARN_FILLER, prototype_name,
			_("prototype has same name as current function and will be ignored"));
		return 1;
	}

	return 0;
}

/* Returns 1 if the prototype has been duplicated. */
static int
check_for_duplicate_prototype (const cb_tree prototype_name,
			       const cb_tree prototype)
{
	cb_tree	dup;

	if (CB_WORD_COUNT (prototype_name) > 0) {
		/* Make sure the duplicate is a prototype */
		dup = cb_ref (prototype_name);
		if (!CB_PROTOTYPE_P (dup)) {
			redefinition_error (prototype_name);
			return 1;
		}

		/* Check the duplicate prototypes match */
		if (strcmp (CB_PROTOTYPE (prototype)->ext_name,
			    CB_PROTOTYPE (dup)->ext_name)
		    || CB_PROTOTYPE (prototype)->type != CB_PROTOTYPE (dup)->type) {
			cb_error_x (prototype_name,
				    _("duplicate REPOSITORY entries for '%s' do not match"),
				    get_literal_or_word_name (prototype_name));
		} else {
			cb_warning_x (COBC_WARN_FILLER, prototype_name,
				      _("duplicate REPOSITORY entry for '%s'"),
				      get_literal_or_word_name (prototype_name));
		}
		return 1;
	}

	return 0;
}

static void
setup_prototype (cb_tree prototype_name, cb_tree ext_name,
		  const int type, const int is_current_element)
{
	cb_tree	prototype;
	int	name_redefinition_allowed;

	if (!is_current_element
	    && check_prototype_redefines_current_element (prototype_name)) {
		return;
	}

	prototype = cb_build_prototype (prototype_name, ext_name, type);

	if (!is_current_element
	 && check_for_duplicate_prototype (prototype_name, prototype)) {
		return;
	}

	name_redefinition_allowed = type == COB_MODULE_TYPE_PROGRAM
		&& is_current_element && cb_program_name_redefinition;
	if (!name_redefinition_allowed) {
		if (CB_LITERAL_P (prototype_name)) {
			cb_define (cb_build_reference ((const char *)CB_LITERAL (prototype_name)->data), prototype);
		} else {
			cb_define (prototype_name, prototype);
		}

		if (type == COB_MODULE_TYPE_PROGRAM) {
			current_program->program_spec_list =
				cb_list_add (current_program->program_spec_list, prototype);
		} else { /* COB_MODULE_TYPE_FUNCTION */
			current_program->user_spec_list =
				cb_list_add (current_program->user_spec_list, prototype);
		}
	}
}

static void
error_if_record_delimiter_incompatible (const int organization,
					const char *organization_name)
{
	int	is_compatible;

	if (!current_file->flag_delimiter) {
		return;
	}

	if (organization == COB_ORG_LINE_SEQUENTIAL) {
		is_compatible = current_file->organization == COB_ORG_SEQUENTIAL
			|| current_file->organization == COB_ORG_LINE_SEQUENTIAL;
	} else {
		is_compatible = current_file->organization == organization;
	}

	if (!is_compatible) {
		cb_error (_("ORGANIZATION %s is incompatible with RECORD DELIMITER"),
			  organization_name);
	}
}

static int
set_current_field (int level, cb_tree name)
{
	cb_tree	x  = cb_build_field_tree (level, name, current_field,
					  current_storage, current_file, 0);

	if (CB_INVALID_TREE (x)) {
		return 1;
	} else {
		current_field = CB_FIELD (x);
		check_pic_duplicate = 0;
		if (current_field->level == 1 || current_field->level == 77) {
			within_typedef_definition = 0;
		}
	}

	return 0;
}

static void
setup_external_definition (cb_tree x, const int type)
{
	/* note: syntax checks for conflicting clauses
	         are done in inherit_external_definition */

	if (x != cb_error_node) {
		struct cb_field *f = CB_FIELD (cb_ref (x));

		/* additional checks if the definition isn't provided by type */
		if (type != 1 /* called with SAME AS / LIKE data-name */ ) {
			if (f->level == 88) {
				cb_error (_("condition-name not allowed here: '%s'"), cb_name (x));
				x = cb_error_node;
			}
			/* note: the following are not explicit specified but implied with
			   LIKE as ILE-COBOL does not have those sections */
			if (f->storage == CB_STORAGE_SCREEN) {
				cb_error (_("SCREEN item cannot be used here"));
				x = cb_error_node;
			} else if (f->storage == CB_STORAGE_REPORT) {
				cb_error (_("REPORT item cannot be used here"));
				x = cb_error_node;
			}
			if (type == 0) {
				/* rules that apply only to SAME AS */
				if (f->flag_is_typedef) {
					cb_error (_("TYPEDEF item cannot be used here"));
					x = cb_error_node;
				}
			}
		}

		if (current_field->level == 77) {
			if (type != 2 /* called with LIKE */
			 && f->children) {
				cb_error (_("elementary item expected"));
				x = cb_error_node;
			}
		} else {
			struct cb_field *p = current_field;
			do {
				if (p == f) {
					cb_error (_ ("item may not reference itself"));
					x = cb_error_node;
					break;
				}
				p = p->parent;
			} while (p);
			for (p = f->parent; p; p = p->parent) {
				if (p->usage != CB_USAGE_DISPLAY) {
					cb_error (_("item may not be subordinate to any item with USAGE clause"));
				} else if (p->flag_sign_clause) {
					cb_error (_("item may not be subordinate to any item with SIGN clause"));
				} else {
					continue;
				}
				x = cb_error_node;
				break;
			}
		}
	}

	if (x == cb_error_node) {
		current_field->flag_is_verified = 1;
		current_field->flag_invalid = 1;
		current_field->external_definition = cb_error_node;
	} else {
		current_field->external_definition = cb_ref (x);
	}
}

static void
setup_external_definition_type (cb_tree x)
{
	if (!check_repeated ("TYPE TO", SYN_CLAUSE_31, &check_pic_duplicate)) {
		if (current_field->external_definition) {
			emit_conflicting_clause_message ("SAME AS", "TYPE TO");
		}
		setup_external_definition (x, 1);
	}
}

/* verifies that no conflicting clauses are used and
   inherits the definition of the original field specified
   by SAME AS or by type_name */
static void
inherit_external_definition (const int lvl)
{
	/* note: REDEFINES (clause 1) is allowed with RM/COBOL but not COBOL 2002+ */
	static const cob_flags_t	allowed_clauses =
		SYN_CLAUSE_1 | SYN_CLAUSE_2 | SYN_CLAUSE_3 | SYN_CLAUSE_7 | SYN_CLAUSE_12;
	cob_flags_t	tested = check_pic_duplicate & ~(allowed_clauses);
	if (tested != SYN_CLAUSE_30 && tested != SYN_CLAUSE_31
	 && tested != 0 /* USAGE as TYPE TO */) {
		struct cb_field *fld = CB_FIELD (current_field->external_definition);
		cb_error_x (CB_TREE(current_field), _("illegal combination of %s with other clauses"),
			fld->flag_is_typedef ? "TYPE TO" : "SAME AS");
		current_field->flag_is_verified = 1;
		current_field->flag_invalid = 1;
	} else {
		struct cb_field *fld = CB_FIELD (current_field->external_definition);
		int new_level = lvl;
		int old_level = current_field->level;
		copy_into_field (fld, current_field);
		if (new_level > 1 && new_level < 66 && new_level > old_level) {
			cb_error (_("entry following %s may not be subordinate to it"),
				fld->flag_is_typedef ? "TYPE TO" : "SAME AS");
		}
	}
}

static cb_tree
get_finalized_description_tree (void)
{
	struct cb_field *p;

	/* finalize last field if target of SAME AS / TYPEDEF */
	if (current_field && !CB_INVALID_TREE (current_field->external_definition)) {
		inherit_external_definition (0);
	}

	/* validate the complete current "block" */
	for (p = description_field; p; p = p->sister) {
		cb_validate_field (p);
	}
	return CB_TREE (description_field);
}

static void
check_not_both (const cob_flags_t flag1, const cob_flags_t flag2,
		const char *flag1_name, const char *flag2_name,
		const cob_flags_t flags, const cob_flags_t flag_to_set)
{
	if (flag_to_set == flag1 && (flags & flag2)) {
		cb_error (_("cannot specify both %s and %s"),
			  flag1_name, flag2_name);
	} else if (flag_to_set == flag2 && (flags & flag1)) {
		cb_error (_("cannot specify both %s and %s"),
			  flag1_name, flag2_name);

	}
}

static COB_INLINE COB_A_INLINE void
check_not_highlight_and_lowlight (const cob_flags_t flags,
				  const cob_flags_t flag_to_set)
{
	check_not_both (COB_SCREEN_HIGHLIGHT, COB_SCREEN_LOWLIGHT,
			"HIGHLIGHT", "LOWLIGHT", flags, flag_to_set);
}

static void
set_screen_attr (const char *clause, const cob_flags_t bitval)
{
	if (current_field->screen_flag & bitval) {
		emit_duplicate_clause_message (clause);
	} else {
		current_field->screen_flag |= bitval;
	}
}

static void
set_attr_with_conflict (const char *clause, const cob_flags_t bitval,
			const char *confl_clause, const cob_flags_t confl_bit,
			const int local_check_duplicate, cob_flags_t *flags)
{
	if (local_check_duplicate && (*flags & bitval)) {
		emit_duplicate_clause_message (clause);
	} else if (*flags & confl_bit) {
		emit_conflicting_clause_message (clause, confl_clause);
	} else {
		*flags |= bitval;
	}
}

static COB_INLINE COB_A_INLINE void
set_screen_attr_with_conflict (const char *clause, const cob_flags_t bitval,
			       const char *confl_clause,
			       const cob_flags_t confl_bit)
{
	set_attr_with_conflict (clause, bitval, confl_clause, confl_bit, 1,
				&current_field->screen_flag);
}

static COB_INLINE COB_A_INLINE int
has_dispattr (const cob_flags_t attrib)
{
	return current_statement->attr_ptr
		&& current_statement->attr_ptr->dispattrs & attrib;
}

static void
attach_attrib_to_cur_stmt (void)
{
	if (!current_statement->attr_ptr) {
		current_statement->attr_ptr =
			cobc_parse_malloc (sizeof(struct cb_attr_struct));
	}
}

static COB_INLINE COB_A_INLINE void
set_dispattr (const cob_flags_t attrib)
{
	attach_attrib_to_cur_stmt ();
	current_statement->attr_ptr->dispattrs |= attrib;
}

static COB_INLINE COB_A_INLINE void
set_dispattr_with_conflict (const char *attrib_name, const cob_flags_t attrib,
			    const char *confl_name,
			    const cob_flags_t confl_attrib)
{
	attach_attrib_to_cur_stmt ();
	set_attr_with_conflict (attrib_name, attrib, confl_name, confl_attrib, 0,
				&current_statement->attr_ptr->dispattrs);
}

static void
bit_set_attr (const cb_tree on_off, const cob_flags_t attr_val)
{
	if (on_off == cb_int1) {
		set_attr_val_on |= attr_val;
	} else {
		set_attr_val_off |= attr_val;
	}
}

static void
set_field_attribs (cb_tree fgc, cb_tree bgc, cb_tree scroll,
		   cb_tree timeout, cb_tree prompt, cb_tree size_is)
{
	/* [WITH] FOREGROUND-COLOR [IS] */
	if (fgc) {
		current_statement->attr_ptr->fgc = fgc;
	}
	/* [WITH] BACKGROUND-COLOR [IS] */
	if (bgc) {
		current_statement->attr_ptr->bgc = bgc;
	}
	/* [WITH] SCROLL UP | DOWN */
	if (scroll) {
		current_statement->attr_ptr->scroll = scroll;
	}
	/* [WITH] TIME-OUT [AFTER] */
	if (timeout) {
		current_statement->attr_ptr->timeout = timeout;
	}
	/* [WITH] PROMPT CHARACTER [IS] */
	if (prompt) {
		current_statement->attr_ptr->prompt = prompt;
	}
	/* [WITH] SIZE [IS] */
	if (size_is) {
		current_statement->attr_ptr->size_is = size_is;
	}
}

static void
set_attribs (cb_tree fgc, cb_tree bgc, cb_tree scroll,
	     cb_tree timeout, cb_tree prompt, cb_tree size_is,
	     const cob_flags_t attrib)
{
	attach_attrib_to_cur_stmt ();
	set_field_attribs (fgc, bgc, scroll, timeout, prompt, size_is);

	current_statement->attr_ptr->dispattrs |= attrib;
}

static void
set_attribs_with_conflict  (cb_tree fgc, cb_tree bgc, cb_tree scroll,
			    cb_tree timeout, cb_tree prompt, cb_tree size_is,
			    const char *clause_name, const cob_flags_t attrib,
			    const char *confl_name, const cob_flags_t confl_attrib)
{
	attach_attrib_to_cur_stmt ();
	set_field_attribs (fgc, bgc, scroll, timeout, prompt, size_is);

	set_dispattr_with_conflict (clause_name, attrib, confl_name,
				    confl_attrib);
}

static cob_flags_t
zero_conflicting_flag (const cob_flags_t screen_flag, cob_flags_t parent_flag,
				const cob_flags_t flag1, const cob_flags_t flag2)
{
	if (screen_flag & flag1) {
		parent_flag &= ~flag2;
	} else if (screen_flag & flag2) {
		parent_flag &= ~flag1;
	}

	return parent_flag;
}

static cob_flags_t
zero_conflicting_flags (const cob_flags_t screen_flag, cob_flags_t parent_flag)
{
	parent_flag = zero_conflicting_flag (screen_flag, parent_flag,
					     COB_SCREEN_BLANK_LINE,
					     COB_SCREEN_BLANK_SCREEN);
	parent_flag = zero_conflicting_flag (screen_flag, parent_flag,
					     COB_SCREEN_ERASE_EOL,
					     COB_SCREEN_ERASE_EOS);
	parent_flag = zero_conflicting_flag (screen_flag, parent_flag,
					     COB_SCREEN_HIGHLIGHT,
					     COB_SCREEN_LOWLIGHT);

	return parent_flag;
}

static void
check_and_set_usage (const enum cb_usage usage)
{
	check_repeated ("USAGE", SYN_CLAUSE_5, &check_pic_duplicate);
	current_field->usage = usage;
}

static void
check_preceding_tallying_phrases (const enum tallying_phrase phrase)
{
	switch (phrase) {
	case FOR_PHRASE:
		if (previous_tallying_phrase == ALL_LEADING_TRAILING_PHRASES) {
			cb_error (_("FOR phrase cannot immediately follow ALL/LEADING/TRAILING"));
		} else if (previous_tallying_phrase == FOR_PHRASE) {
			cb_error (_("missing CHARACTERS/ALL/LEADING/TRAILING phrase after FOR phrase"));
		}
		break;

	case ALL_LEADING_TRAILING_PHRASES:
		if (previous_tallying_phrase == CHARACTERS_PHRASE
		 || previous_tallying_phrase == ALL_LEADING_TRAILING_PHRASES) {
			cb_error (_("missing value between ALL/LEADING/TRAILING words"));
		}
		/* fall through */
	case CHARACTERS_PHRASE:
		if (previous_tallying_phrase == NO_PHRASE) {
			cb_error (_("missing FOR phrase before CHARACTERS/ALL/LEADING/TRAILING phrase"));
		}
		break;

	case VALUE_REGION_PHRASE:
		if (! ( previous_tallying_phrase == ALL_LEADING_TRAILING_PHRASES
		     || previous_tallying_phrase == VALUE_REGION_PHRASE)) {
			cb_error (_("missing ALL/LEADING/TRAILING before value"));
		}
		break;

	/* LCOV_EXCL_START */
	default:
		/* This should never happen (and therefore doesn't get a translation) */
		cb_error ("unexpected tallying phrase");
		COBC_ABORT();
	/* LCOV_EXCL_STOP */
	}

	previous_tallying_phrase = phrase;
}

static int
has_relative_pos (struct cb_field const *field)
{
	return !!(field->screen_flag
		  & ( COB_SCREEN_LINE_PLUS | COB_SCREEN_LINE_MINUS
		    | COB_SCREEN_COLUMN_PLUS | COB_SCREEN_COLUMN_MINUS));
}

static int
is_recursive_call (cb_tree target)
{
	const char *target_name = "";

	if (CB_LITERAL_P (target)) {
		target_name = (const char *)(CB_LITERAL(target)->data);
	} else if (CB_REFERENCE_P (target)
	        && CB_PROTOTYPE_P (cb_ref (target))) {
		target_name = CB_PROTOTYPE (cb_ref (target))->ext_name;
	}

	return !strcmp (target_name, current_program->orig_program_id);
}

static cb_tree
check_not_88_level (cb_tree x)
{
	struct cb_field	*f;

	if (x == cb_error_node) {
		return cb_error_node;
	}
	if (!CB_REF_OR_FIELD_P(x)) {
		return x;
	}

	f = CB_FIELD_PTR (x);

	if (f->level == 88) {
#if 0	/* note: we may consider to support the extension (if existing) to
		         reference a condition-name target by the condition-name */
		if (cb_verify (cb_condition_references_data, _("use of condition-name in place of data-name"))) {
			return CB_TREE (f->parent);
		}
#else
		cb_error (_("condition-name not allowed here: '%s'"), cb_name (x));
		/* invalidate field to prevent same error in typeck.c (validate_one) */
		/* FIXME: If we really need the additional check here then we missed
		          a call to cb_validate_one() somewhere */
		return cb_error_node;
#endif
	} else {
		return x;
	}
}

static int
is_screen_field (cb_tree x)
{
	if (CB_FIELD_P (x)) {
		return (CB_FIELD (x))->storage == CB_STORAGE_SCREEN;
	} else if (CB_REFERENCE_P (x)) {
		return is_screen_field (cb_ref (x));
	} else {
		return 0;
	}
}

static void
error_if_no_advancing_in_screen_display (cb_tree advancing)
{
	if (advancing != cb_int1) {
		cb_error (_("cannot specify NO ADVANCING in screen DISPLAY"));
	}
}

static cb_tree
get_default_display_device (void)
{
	if (current_program->flag_console_is_crt
	 || cb_console_is_crt) {
		return cb_null;
	} else {
		return cb_int0;
	}
}

static COB_INLINE COB_A_INLINE int
contains_one_screen_field (struct cb_list *l)
{
	return cb_list_length (CB_TREE(l)) == 1
		&& is_screen_field (l->value);
}

static int
contains_only_screen_fields (struct cb_list *l)
{
	for (; l; l = l->chain ? CB_LIST (l->chain) : NULL) {
		if (!is_screen_field (l->value)) {
			return 0;
		}
	}

	return 1;
}

static int
contains_fields_and_screens (struct cb_list *l)
{
	int	field_seen = 0;
	int	screen_seen = 0;

	for (; l; l = l->chain ? CB_LIST (l->chain) : NULL) {
		if (is_screen_field (l->value)) {
			screen_seen = 1;
		} else {
			field_seen = 1;
		}
	}

	return screen_seen && field_seen;
}

static enum cb_display_type
deduce_display_type (struct	cb_list *l, cb_tree local_upon_value, cb_tree local_line_column,
		     struct cb_attr_struct * const attr_ptr)
{
	int	using_default_device_which_is_crt =
		local_upon_value == NULL && get_default_display_device () == cb_null;

	/* TODO: Separate CGI DISPLAYs here */
	if (contains_only_screen_fields (l)) {
		if (!contains_one_screen_field (l)
		 || attr_ptr) {
			cb_verify_x (CB_TREE(l), cb_accept_display_extensions,
				     _("non-standard DISPLAY"));
		}

		if (local_upon_value != NULL && local_upon_value != cb_null) {
			cb_error_x (CB_TREE(l), _("screens may only be displayed on CRT"));
		}

		return SCREEN_DISPLAY;
	} else if (contains_fields_and_screens (l)) {
		cb_error_x (CB_TREE(l), _("cannot mix screens and fields in the same DISPLAY statement"));
		return MIXED_DISPLAY;
	} else if (local_line_column || attr_ptr) {
		if (local_upon_value != NULL && local_upon_value != cb_null) {
			cb_error_x (CB_TREE(l), _("screen clauses may only be used for DISPLAY on CRT"));
		}

		cb_verify_x (CB_TREE(l), cb_accept_display_extensions,
			     _("non-standard DISPLAY"));

		return FIELD_ON_SCREEN_DISPLAY;
	} else if (local_upon_value == cb_null || using_default_device_which_is_crt) {
		/* This is the only format permitted by the standard */
		return FIELD_ON_SCREEN_DISPLAY;
	} else if (display_type == FIELD_ON_SCREEN_DISPLAY && local_upon_value == NULL) {
		/* This is for when fields without clauses follow fields with screen clauses */
		return FIELD_ON_SCREEN_DISPLAY;
	} else {
		return DEVICE_DISPLAY;
	}
}

static void
set_display_type (struct cb_list *l, cb_tree local_upon_value,
		  cb_tree local_line_column, struct cb_attr_struct * const attr_ptr)
{
	display_type = deduce_display_type (l, local_upon_value, local_line_column, attr_ptr);
}

static void
error_if_different_display_type (struct cb_list *l, cb_tree local_upon_value,
				 cb_tree local_line_column, struct cb_attr_struct * const attr_ptr)
{
	const enum cb_display_type	type =
		deduce_display_type (l, local_upon_value, local_line_column, attr_ptr);

	/* Avoid re-displaying the same error for mixed DISPLAYs */
	if (type == display_type || display_type == MIXED_DISPLAY) {
		return;
	}

	if (type != MIXED_DISPLAY) {
		if (type == SCREEN_DISPLAY || display_type == SCREEN_DISPLAY) {
			cb_error_x (CB_TREE(l), _("cannot mix screens and fields in the same DISPLAY statement"));
		} else {
			/*
			  The only other option is that there is a mix of
			  FIELD_ON_SCREEN_DISPLAY and DEVICE_DISPLAY.
			*/
			cb_error_x (CB_TREE(l), _("ambiguous DISPLAY; put items to display on device in separate DISPLAY"));
		}
	}

	display_type = MIXED_DISPLAY;
}

static void
error_if_not_usage_display_or_nonnumeric_lit (cb_tree x)
{
	const int	is_numeric_literal = CB_NUMERIC_LITERAL_P (x);
	const int	is_field_with_usage_not_display =
		CB_REFERENCE_P (x) && CB_FIELD (cb_ref (x))
		&& CB_FIELD (cb_ref (x))->usage != CB_USAGE_DISPLAY;

	if (is_numeric_literal) {
		cb_error_x (x, _("%s is not an alphanumeric literal"), CB_LITERAL (x)->data);
	} else if (is_field_with_usage_not_display) {
		cb_error_x (x, _("'%s' is not USAGE DISPLAY"), cb_name (x));
	}
}

static void
check_validate_item (cb_tree x)
{
	struct cb_field	*f;
	enum cb_class	tree_class;

	if (CB_INVALID_TREE(x) || x->tag != CB_TAG_REFERENCE) {
		return;
	}
	x = cb_ref (x);
	if (CB_INVALID_TREE (x) || !CB_FIELD_P (x)) {
		cb_error (_("invalid target for %s"), "VALIDATE");
		return;
	}

	f = CB_FIELD (x);
	tree_class = CB_TREE_CLASS(f);
	if (is_screen_field(x)) {
		cb_error (_("SCREEN item cannot be used here"));
	} else if (f->level == 66) {
		cb_error (_("RENAMES item may not be used here"));
	} else if (f->flag_any_length) {
		cb_error (_("ANY LENGTH item not allowed here"));
	} else if (tree_class == CB_CLASS_INDEX
		|| tree_class == CB_CLASS_OBJECT
		|| tree_class == CB_CLASS_POINTER) {
		cb_error (_("item '%s' has wrong class for VALIDATE"), cb_name (x));
	}
}

static void
error_if_following_every_clause (void)
{
	if (ml_suppress_list
	 && CB_ML_SUPPRESS (CB_VALUE (ml_suppress_list))->target == CB_ML_SUPPRESS_TYPE) {
		cb_error (_("WHEN clause must follow EVERY clause"));
	}
}

static void
prepend_to_ml_suppress_list (cb_tree suppress_entry)
{
	cb_tree	new_list_head = CB_LIST_INIT (suppress_entry);
	cb_list_append (new_list_head, ml_suppress_list);
	ml_suppress_list = new_list_head;
}

static void
add_identifier_to_ml_suppress_conds (cb_tree identifier)
{
	cb_tree suppress_id = cb_build_ml_suppress_clause ();
	CB_ML_SUPPRESS (suppress_id)->target = CB_ML_SUPPRESS_IDENTIFIER;
	CB_ML_SUPPRESS (suppress_id)->identifier = identifier;
	prepend_to_ml_suppress_list (suppress_id);
}

static void
add_when_to_ml_suppress_conds (cb_tree when_list)
{
	struct cb_ml_suppress_clause	*last_suppress_clause;
	cb_tree	suppress_all;

	/*
	  If the preceding clause in SUPPRESS was an identifier, the WHEN
	  belongs to the identifier. If EVERY was preceding, the WHEN belongs to
	  the EVERY. Otherwise, the WHEN acts on the entire record.
	*/
	if (ml_suppress_list) {
		last_suppress_clause = CB_ML_SUPPRESS (CB_VALUE (ml_suppress_list));
		if ( (last_suppress_clause->target == CB_ML_SUPPRESS_IDENTIFIER
		   || last_suppress_clause->target == CB_ML_SUPPRESS_TYPE)
		  && !last_suppress_clause->when_list) {
			last_suppress_clause->when_list = when_list;
			return;
		}
	}

	suppress_all = cb_build_ml_suppress_clause ();
	CB_ML_SUPPRESS (suppress_all)->when_list = when_list;
	prepend_to_ml_suppress_list (suppress_all);
}

static void
add_type_to_ml_suppress_conds (enum cb_ml_suppress_category category,
			       enum cb_ml_type ml_type)
{
	cb_tree	suppress_type = cb_build_ml_suppress_clause ();
	CB_ML_SUPPRESS (suppress_type)->target = CB_ML_SUPPRESS_TYPE;
	CB_ML_SUPPRESS (suppress_type)->category = category;
	CB_ML_SUPPRESS (suppress_type)->ml_type = ml_type;
	prepend_to_ml_suppress_list (suppress_type);
}

static void
set_record_size (cb_tree min, cb_tree max)
{
	int record_min, record_max;

	if (min) {
		record_min = cb_get_int (min);
		if (record_min < 0) {
			/* already handled by integer check */
		} else {
			current_file->record_min = record_min;
		}
	} else {
		record_min = 0;
	}
	if (!max) {
		return;
	}

	record_max = cb_get_int (max);
	if (record_max < 0) {
		/* already handled by integer check */
		return;
	} else if (record_max == 0) {
		/* Note: standard COBOL does not allow zero at all, use the related
		         configuration option */
		if (cb_records_mismatch_record_clause >= CB_ERROR) {
			cb_error (_("non-zero value expected"));
		}
		return;
	}
	if (current_file->organization == COB_ORG_INDEXED
	 && record_max > MAX_FD_RECORD_IDX)  {
		cb_error (_("RECORD size (IDX) exceeds maximum allowed (%d)"),
			MAX_FD_RECORD_IDX);
		current_file->record_max = MAX_FD_RECORD_IDX;
	} else if (record_max > MAX_FD_RECORD)  {
		cb_error (_("RECORD size exceeds maximum allowed (%d)"),
			MAX_FD_RECORD);
		current_file->record_max = MAX_FD_RECORD;
	} else {
		if (record_max <= record_min)  {
			cb_error (_("RECORD clause invalid"));
		}
		current_file->record_max = record_max;
	}
}


#line 2394 "parser.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

/* Use api.header.include to #include this header
   instead of duplicating it here.  */
#ifndef YY_YY_PARSER_H_INCLUDED
# define YY_YY_PARSER_H_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int yydebug;
#endif

/* Token kinds.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    YYEMPTY = -2,
    TOKEN_EOF = 0,                 /* "end of file"  */
    YYerror = 256,                 /* error  */
    YYUNDEF = 257,                 /* "invalid token"  */
    THREEDIMENSIONAL = 258,        /* "3D"  */
    ABSENT = 259,                  /* ABSENT  */
    ACCEPT = 260,                  /* ACCEPT  */
    ACCESS = 261,                  /* ACCESS  */
    ACTIVEX = 262,                 /* "ACTIVE-X"  */
    ACTIVE_CLASS = 263,            /* "ACTIVE-CLASS"  */
    ACTION = 264,                  /* ACTION  */
    ACTUAL = 265,                  /* ACTUAL  */
    ADD = 266,                     /* ADD  */
    ADDRESS = 267,                 /* ADDRESS  */
    ADJUSTABLE_COLUMNS = 268,      /* "ADJUSTABLE-COLUMNS"  */
    ADVANCING = 269,               /* ADVANCING  */
    AFTER = 270,                   /* AFTER  */
    ALIGNED = 271,                 /* ALIGNED  */
    ALIGNMENT = 272,               /* ALIGNMENT  */
    ALL = 273,                     /* ALL  */
    ALLOCATE = 274,                /* ALLOCATE  */
    ALLOWING = 275,                /* ALLOWING  */
    ALPHABET = 276,                /* ALPHABET  */
    ALPHABETIC = 277,              /* ALPHABETIC  */
    ALPHABETIC_LOWER = 278,        /* "ALPHABETIC-LOWER"  */
    ALPHABETIC_UPPER = 279,        /* "ALPHABETIC-UPPER"  */
    ALPHANUMERIC = 280,            /* ALPHANUMERIC  */
    ALPHANUMERIC_EDITED = 281,     /* "ALPHANUMERIC-EDITED"  */
    ALSO = 282,                    /* ALSO  */
    ALTER = 283,                   /* ALTER  */
    ALTERNATE = 284,               /* ALTERNATE  */
    AND = 285,                     /* AND  */
    ANY = 286,                     /* ANY  */
    APPLY = 287,                   /* APPLY  */
    ARE = 288,                     /* ARE  */
    AREA = 289,                    /* AREA  */
    AREAS = 290,                   /* AREAS  */
    ARGUMENT_NUMBER = 291,         /* "ARGUMENT-NUMBER"  */
    ARGUMENT_VALUE = 292,          /* "ARGUMENT-VALUE"  */
    ARITHMETIC = 293,              /* ARITHMETIC  */
    AS = 294,                      /* AS  */
    ASCENDING = 295,               /* ASCENDING  */
    ASCII = 296,                   /* ASCII  */
    ASSIGN = 297,                  /* ASSIGN  */
    AT = 298,                      /* AT  */
    AT_END = 299,                  /* "AT END"  */
    ATTRIBUTE = 300,               /* ATTRIBUTE  */
    ATTRIBUTES = 301,              /* ATTRIBUTES  */
    AUTHOR = 302,                  /* AUTHOR  */
    AUTO = 303,                    /* AUTO  */
    AUTO_DECIMAL = 304,            /* "AUTO-DECIMAL"  */
    AUTO_SPIN = 305,               /* "AUTO-SPIN"  */
    AUTOMATIC = 306,               /* AUTOMATIC  */
    AWAY_FROM_ZERO = 307,          /* "AWAY-FROM-ZERO"  */
    B_AND = 308,                   /* "B-AND"  */
    B_NOT = 309,                   /* "B-NOT"  */
    B_OR = 310,                    /* "B-OR"  */
    B_XOR = 311,                   /* "B-XOR"  */
    B_SHIFT_L = 312,               /* "B-SHIFT-L"  */
    B_SHIFT_R = 313,               /* "B-SHIFT-R"  */
    B_SHIFT_LC = 314,              /* "B-SHIFT-LC"  */
    B_SHIFT_RC = 315,              /* "B-SHIFT-RC"  */
    BACKGROUND_COLOR = 316,        /* "BACKGROUND-COLOR"  */
    BACKGROUND_HIGH = 317,         /* "BACKGROUND-HIGH"  */
    BACKGROUND_LOW = 318,          /* "BACKGROUND-LOW"  */
    BACKGROUND_STANDARD = 319,     /* "BACKGROUND-STANDARD"  */
    BACKWARD = 320,                /* BACKWARD  */
    BAR = 321,                     /* BAR  */
    BASED = 322,                   /* BASED  */
    BEFORE = 323,                  /* BEFORE  */
    BELL = 324,                    /* BELL  */
    BINARY = 325,                  /* BINARY  */
    BINARY_C_LONG = 326,           /* "BINARY-C-LONG"  */
    BINARY_CHAR = 327,             /* "BINARY-CHAR"  */
    BINARY_DOUBLE = 328,           /* "BINARY-DOUBLE"  */
    BINARY_LONG = 329,             /* "BINARY-LONG"  */
    BINARY_SEQUENTIAL = 330,       /* "BINARY-SEQUENTIAL"  */
    BINARY_SHORT = 331,            /* "BINARY-SHORT"  */
    BIT = 332,                     /* BIT  */
    BITMAP = 333,                  /* BITMAP  */
    BITMAP_END = 334,              /* "BITMAP-END"  */
    BITMAP_HANDLE = 335,           /* "BITMAP-HANDLE"  */
    BITMAP_NUMBER = 336,           /* "BITMAP-NUMBER"  */
    BITMAP_START = 337,            /* "BITMAP-START"  */
    BITMAP_TIMER = 338,            /* "BITMAP-TIMER"  */
    BITMAP_TRAILING = 339,         /* "BITMAP-TRAILING"  */
    BITMAP_TRANSPARENT_COLOR = 340, /* "BITMAP-TRANSPARENT-COLOR"  */
    BITMAP_WIDTH = 341,            /* "BITMAP-WIDTH"  */
    BLANK = 342,                   /* BLANK  */
    BLINK = 343,                   /* BLINK  */
    BLOCK = 344,                   /* BLOCK  */
    BOOLEAN = 345,                 /* BOOLEAN  */
    BOTTOM = 346,                  /* BOTTOM  */
    BOX = 347,                     /* BOX  */
    BOXED = 348,                   /* BOXED  */
    BULK_ADDITION = 349,           /* "BULK-ADDITION"  */
    BUSY = 350,                    /* BUSY  */
    BUTTONS = 351,                 /* BUTTONS  */
    BY = 352,                      /* BY  */
    BYTE_LENGTH = 353,             /* "BYTE-LENGTH"  */
    C = 354,                       /* C  */
    CALENDAR_FONT = 355,           /* "CALENDAR-FONT"  */
    CALL = 356,                    /* CALL  */
    CANCEL = 357,                  /* CANCEL  */
    CANCEL_BUTTON = 358,           /* "CANCEL-BUTTON"  */
    CAPACITY = 359,                /* CAPACITY  */
    CARD_PUNCH = 360,              /* "CARD-PUNCH"  */
    CARD_READER = 361,             /* "CARD-READER"  */
    CASSETTE = 362,                /* CASSETTE  */
    CCOL = 363,                    /* CCOL  */
    CD = 364,                      /* CD  */
    CELL = 365,                    /* CELL  */
    CELL_COLOR = 366,              /* "CELL-COLOR"  */
    CELL_DATA = 367,               /* "CELL-DATA"  */
    CELL_FONT = 368,               /* "CELL-FONT"  */
    CELL_PROTECTION = 369,         /* "CELL-PROTECTION"  */
    CENTER = 370,                  /* CENTER  */
    CENTERED = 371,                /* CENTERED  */
    CENTERED_HEADINGS = 372,       /* "CENTERED-HEADINGS"  */
    CENTURY_DATE = 373,            /* "CENTURY-DATE"  */
    CF = 374,                      /* CF  */
    CH = 375,                      /* CH  */
    CHAINING = 376,                /* CHAINING  */
    CHANGED = 377,                 /* CHANGED  */
    CHARACTER = 378,               /* CHARACTER  */
    CHARACTERS = 379,              /* CHARACTERS  */
    CHECK_BOX = 380,               /* "CHECK-BOX"  */
    CLASS = 381,                   /* CLASS  */
    CLASSIFICATION = 382,          /* CLASSIFICATION  */
    CLASS_NAME = 383,              /* "class-name"  */
    CLEAR_SELECTION = 384,         /* "CLEAR-SELECTION"  */
    CLINE = 385,                   /* CLINE  */
    CLINES = 386,                  /* CLINES  */
    CLOSE = 387,                   /* CLOSE  */
    COBOL = 388,                   /* COBOL  */
    CODE = 389,                    /* CODE  */
    CODE_SET = 390,                /* "CODE-SET"  */
    COLLATING = 391,               /* COLLATING  */
    COL = 392,                     /* COL  */
    COLOR = 393,                   /* COLOR  */
    COLORS = 394,                  /* COLORS  */
    COLS = 395,                    /* COLS  */
    COLUMN = 396,                  /* COLUMN  */
    COLUMN_COLOR = 397,            /* "COLUMN-COLOR"  */
    COLUMN_DIVIDERS = 398,         /* "COLUMN-DIVIDERS"  */
    COLUMN_FONT = 399,             /* "COLUMN-FONT"  */
    COLUMN_HEADINGS = 400,         /* "COLUMN-HEADINGS"  */
    COLUMN_PROTECTION = 401,       /* "COLUMN-PROTECTION"  */
    COLUMNS = 402,                 /* COLUMNS  */
    COMBO_BOX = 403,               /* "COMBO-BOX"  */
    COMMA = 404,                   /* COMMA  */
    COMMAND_LINE = 405,            /* "COMMAND-LINE"  */
    COMMA_DELIM = 406,             /* "comma delimiter"  */
    COMMIT = 407,                  /* COMMIT  */
    COMMON = 408,                  /* COMMON  */
    COMMUNICATION = 409,           /* COMMUNICATION  */
    COMP = 410,                    /* COMP  */
    COMPUTE = 411,                 /* COMPUTE  */
    COMP_0 = 412,                  /* "COMP-0"  */
    COMP_1 = 413,                  /* "COMP-1"  */
    COMP_2 = 414,                  /* "COMP-2"  */
    COMP_3 = 415,                  /* "COMP-3"  */
    COMP_4 = 416,                  /* "COMP-4"  */
    COMP_5 = 417,                  /* "COMP-5"  */
    COMP_6 = 418,                  /* "COMP-6"  */
    COMP_N = 419,                  /* "COMP-N"  */
    COMP_X = 420,                  /* "COMP-X"  */
    CONCATENATE_FUNC = 421,        /* "FUNCTION CONCATENATE"  */
    CONDITION = 422,               /* CONDITION  */
    CONFIGURATION = 423,           /* CONFIGURATION  */
    CONSTANT = 424,                /* CONSTANT  */
    CONTAINS = 425,                /* CONTAINS  */
    CONTENT = 426,                 /* CONTENT  */
    CONTENT_LENGTH_FUNC = 427,     /* "FUNCTION CONTENT-LENGTH"  */
    CONTENT_OF_FUNC = 428,         /* "FUNCTION CONTENT-OF"  */
    CONTINUE = 429,                /* CONTINUE  */
    CONTROL = 430,                 /* CONTROL  */
    CONTROLS = 431,                /* CONTROLS  */
    CONVERSION = 432,              /* CONVERSION  */
    CONVERTING = 433,              /* CONVERTING  */
    COPY = 434,                    /* COPY  */
    COPY_SELECTION = 435,          /* "COPY-SELECTION"  */
    CORE_INDEX = 436,              /* "CORE-INDEX"  */
    CORRESPONDING = 437,           /* CORRESPONDING  */
    COUNT = 438,                   /* COUNT  */
    CRT = 439,                     /* CRT  */
    CRT_UNDER = 440,               /* "CRT-UNDER"  */
    CSIZE = 441,                   /* CSIZE  */
    CURRENCY = 442,                /* CURRENCY  */
    CURRENT_DATE_FUNC = 443,       /* "FUNCTION CURRENT-DATE"  */
    CURSOR = 444,                  /* CURSOR  */
    CURSOR_COL = 445,              /* "CURSOR-COL"  */
    CURSOR_COLOR = 446,            /* "CURSOR-COLOR"  */
    CURSOR_FRAME_WIDTH = 447,      /* "CURSOR-FRAME-WIDTH"  */
    CURSOR_ROW = 448,              /* "CURSOR-ROW"  */
    CURSOR_X = 449,                /* "CURSOR-X"  */
    CURSOR_Y = 450,                /* "CURSOR-Y"  */
    CUSTOM_PRINT_TEMPLATE = 451,   /* "CUSTOM-PRINT-TEMPLATE"  */
    CYCLE = 452,                   /* CYCLE  */
    CYL_INDEX = 453,               /* "CYL-INDEX"  */
    CYL_OVERFLOW = 454,            /* "CYL-OVERFLOW"  */
    DASHED = 455,                  /* DASHED  */
    DATA = 456,                    /* DATA  */
    DATA_COLUMNS = 457,            /* "DATA-COLUMNS"  */
    DATA_POINTER = 458,            /* "DATA-POINTER"  */
    DATA_TYPES = 459,              /* "DATA-TYPES"  */
    DATE = 460,                    /* DATE  */
    DATE_COMPILED = 461,           /* "DATE-COMPILED"  */
    DATE_ENTRY = 462,              /* "DATE-ENTRY"  */
    DATE_MODIFIED = 463,           /* "DATE-MODIFIED"  */
    DATE_WRITTEN = 464,            /* "DATE-WRITTEN"  */
    DAY = 465,                     /* DAY  */
    DAY_OF_WEEK = 466,             /* "DAY-OF-WEEK"  */
    DE = 467,                      /* DE  */
    DEBUGGING = 468,               /* DEBUGGING  */
    DECIMAL_POINT = 469,           /* "DECIMAL-POINT"  */
    DECLARATIVES = 470,            /* DECLARATIVES  */
    DEFAULT = 471,                 /* DEFAULT  */
    DEFAULT_BUTTON = 472,          /* "DEFAULT-BUTTON"  */
    DEFAULT_FONT = 473,            /* "DEFAULT-FONT"  */
    DELETE = 474,                  /* DELETE  */
    DELIMITED = 475,               /* DELIMITED  */
    DELIMITER = 476,               /* DELIMITER  */
    DEPENDING = 477,               /* DEPENDING  */
    DESCENDING = 478,              /* DESCENDING  */
    DESTINATION = 479,             /* DESTINATION  */
    DESTROY = 480,                 /* DESTROY  */
    DETAIL = 481,                  /* DETAIL  */
    DISABLE = 482,                 /* DISABLE  */
    DISC = 483,                    /* DISC  */
    DISK = 484,                    /* DISK  */
    DISP = 485,                    /* DISP  */
    DISPLAY = 486,                 /* DISPLAY  */
    DISPLAY_1 = 487,               /* "DISPLAY-1"  */
    DISPLAY_COLUMNS = 488,         /* "DISPLAY-COLUMNS"  */
    DISPLAY_FORMAT = 489,          /* "DISPLAY-FORMAT"  */
    DISPLAY_OF_FUNC = 490,         /* "FUNCTION DISPLAY-OF"  */
    DIVIDE = 491,                  /* DIVIDE  */
    DIVIDERS = 492,                /* DIVIDERS  */
    DIVIDER_COLOR = 493,           /* "DIVIDER-COLOR"  */
    DIVISION = 494,                /* DIVISION  */
    DOTDASH = 495,                 /* DOTDASH  */
    DOTTED = 496,                  /* DOTTED  */
    DRAG_COLOR = 497,              /* "DRAG-COLOR"  */
    DROP_DOWN = 498,               /* "DROP-DOWN"  */
    DROP_LIST = 499,               /* "DROP-LIST"  */
    DOWN = 500,                    /* DOWN  */
    DUPLICATES = 501,              /* DUPLICATES  */
    DYNAMIC = 502,                 /* DYNAMIC  */
    EBCDIC = 503,                  /* EBCDIC  */
    EC = 504,                      /* EC  */
    ECHO = 505,                    /* ECHO  */
    EGI = 506,                     /* EGI  */
    EIGHTY_EIGHT = 507,            /* "level-number 88"  */
    ENABLE = 508,                  /* ENABLE  */
    ELEMENT = 509,                 /* ELEMENT  */
    ELSE = 510,                    /* ELSE  */
    EMI = 511,                     /* EMI  */
    ENCRYPTION = 512,              /* ENCRYPTION  */
    ENCODING = 513,                /* ENCODING  */
    END = 514,                     /* END  */
    END_ACCEPT = 515,              /* "END-ACCEPT"  */
    END_ADD = 516,                 /* "END-ADD"  */
    END_CALL = 517,                /* "END-CALL"  */
    END_COMPUTE = 518,             /* "END-COMPUTE"  */
    END_COLOR = 519,               /* "END-COLOR"  */
    END_DELETE = 520,              /* "END-DELETE"  */
    END_DISPLAY = 521,             /* "END-DISPLAY"  */
    END_DIVIDE = 522,              /* "END-DIVIDE"  */
    END_EVALUATE = 523,            /* "END-EVALUATE"  */
    END_FUNCTION = 524,            /* "END FUNCTION"  */
    END_IF = 525,                  /* "END-IF"  */
    END_JSON = 526,                /* "END-JSON"  */
    END_MODIFY = 527,              /* "END-MODIFY"  */
    END_MULTIPLY = 528,            /* "END-MULTIPLY"  */
    END_PERFORM = 529,             /* "END-PERFORM"  */
    END_PROGRAM = 530,             /* "END PROGRAM"  */
    END_READ = 531,                /* "END-READ"  */
    END_RECEIVE = 532,             /* "END-RECEIVE"  */
    END_RETURN = 533,              /* "END-RETURN"  */
    END_REWRITE = 534,             /* "END-REWRITE"  */
    END_SEARCH = 535,              /* "END-SEARCH"  */
    END_SEND = 536,                /* "END-SEND"  */
    END_START = 537,               /* "END-START"  */
    END_STRING = 538,              /* "END-STRING"  */
    END_SUBTRACT = 539,            /* "END-SUBTRACT"  */
    END_UNSTRING = 540,            /* "END-UNSTRING"  */
    END_WRITE = 541,               /* "END-WRITE"  */
    END_XML = 542,                 /* "END-XML"  */
    ENGRAVED = 543,                /* ENGRAVED  */
    ENSURE_VISIBLE = 544,          /* "ENSURE-VISIBLE"  */
    ENTRY = 545,                   /* ENTRY  */
    ENTRY_CONVENTION = 546,        /* "ENTRY-CONVENTION"  */
    ENTRY_FIELD = 547,             /* "ENTRY-FIELD"  */
    ENTRY_REASON = 548,            /* "ENTRY-REASON"  */
    ENVIRONMENT = 549,             /* ENVIRONMENT  */
    ENVIRONMENT_NAME = 550,        /* "ENVIRONMENT-NAME"  */
    ENVIRONMENT_VALUE = 551,       /* "ENVIRONMENT-VALUE"  */
    EOL = 552,                     /* EOL  */
    EOP = 553,                     /* EOP  */
    EOS = 554,                     /* EOS  */
    EQUAL = 555,                   /* EQUAL  */
    ERASE = 556,                   /* ERASE  */
    ERROR = 557,                   /* ERROR  */
    ESCAPE = 558,                  /* ESCAPE  */
    ESCAPE_BUTTON = 559,           /* "ESCAPE-BUTTON"  */
    ESI = 560,                     /* ESI  */
    EVALUATE = 561,                /* EVALUATE  */
    EVENT = 562,                   /* EVENT  */
    EVENT_LIST = 563,              /* "EVENT-LIST"  */
    EVENT_STATUS = 564,            /* "EVENT STATUS"  */
    EVERY = 565,                   /* EVERY  */
    EXAMINE = 566,                 /* EXAMINE  */
    EXCEPTION = 567,               /* EXCEPTION  */
    EXCEPTION_CONDITION = 568,     /* "EXCEPTION CONDITION"  */
    EXCEPTION_VALUE = 569,         /* "EXCEPTION-VALUE"  */
    EXPAND = 570,                  /* EXPAND  */
    EXCLUSIVE = 571,               /* EXCLUSIVE  */
    EXHIBIT = 572,                 /* EXHIBIT  */
    EXIT = 573,                    /* EXIT  */
    EXPONENTIATION = 574,          /* "exponentiation operator"  */
    EXTEND = 575,                  /* EXTEND  */
    EXTENDED_SEARCH = 576,         /* "EXTENDED-SEARCH"  */
    EXTERNAL = 577,                /* EXTERNAL  */
    EXTERNAL_FORM = 578,           /* "EXTERNAL-FORM"  */
    F = 579,                       /* F  */
    FACTORY = 580,                 /* FACTORY  */
    FD = 581,                      /* FD  */
    FH__FCD = 582,                 /* "FH--FCD"  */
    FH__KEYDEF = 583,              /* "FH--KEYDEF"  */
    FILE_CONTROL = 584,            /* "FILE-CONTROL"  */
    FILE_ID = 585,                 /* "FILE-ID"  */
    FILE_LIMIT = 586,              /* "FILE-LIMIT"  */
    FILE_LIMITS = 587,             /* "FILE-LIMITS"  */
    FILE_NAME = 588,               /* "FILE-NAME"  */
    FILE_POS = 589,                /* "FILE-POS"  */
    FILL_COLOR = 590,              /* "FILL-COLOR"  */
    FILL_COLOR2 = 591,             /* "FILL-COLOR2"  */
    FILL_PERCENT = 592,            /* "FILL-PERCENT"  */
    FILLER = 593,                  /* FILLER  */
    FINAL = 594,                   /* FINAL  */
    FINISH_REASON = 595,           /* "FINISH-REASON"  */
    FIRST = 596,                   /* FIRST  */
    FIXED = 597,                   /* FIXED  */
    FIXED_FONT = 598,              /* "FIXED-FONT"  */
    FIXED_WIDTH = 599,             /* "FIXED-WIDTH"  */
    FLAT = 600,                    /* FLAT  */
    FLAT_BUTTONS = 601,            /* "FLAT-BUTTONS"  */
    FLOAT_BINARY_128 = 602,        /* "FLOAT-BINARY-128"  */
    FLOAT_BINARY_32 = 603,         /* "FLOAT-BINARY-32"  */
    FLOAT_BINARY_64 = 604,         /* "FLOAT-BINARY-64"  */
    FLOAT_DECIMAL_16 = 605,        /* "FLOAT-DECIMAL-16"  */
    FLOAT_DECIMAL_34 = 606,        /* "FLOAT-DECIMAL-34"  */
    FLOAT_DECIMAL_7 = 607,         /* "FLOAT-DECIMAL-7"  */
    FLOAT_EXTENDED = 608,          /* "FLOAT-EXTENDED"  */
    FLOAT_LONG = 609,              /* "FLOAT-LONG"  */
    FLOAT_SHORT = 610,             /* "FLOAT-SHORT"  */
    FLOATING = 611,                /* FLOATING  */
    FONT = 612,                    /* FONT  */
    FOOTING = 613,                 /* FOOTING  */
    FOR = 614,                     /* FOR  */
    FOREGROUND_COLOR = 615,        /* "FOREGROUND-COLOR"  */
    FOREVER = 616,                 /* FOREVER  */
    FORMAT = 617,                  /* FORMAT  */
    FORMATTED_DATE_FUNC = 618,     /* "FUNCTION FORMATTED-DATE"  */
    FORMATTED_DATETIME_FUNC = 619, /* "FUNCTION FORMATTED-DATETIME"  */
    FORMATTED_TIME_FUNC = 620,     /* "FUNCTION FORMATTED-TIME"  */
    FRAME = 621,                   /* FRAME  */
    FRAMED = 622,                  /* FRAMED  */
    FREE = 623,                    /* FREE  */
    FROM = 624,                    /* FROM  */
    FROM_CRT = 625,                /* "FROM CRT"  */
    FULL = 626,                    /* FULL  */
    FULL_HEIGHT = 627,             /* "FULL-HEIGHT"  */
    FUNCTION = 628,                /* FUNCTION  */
    FUNCTION_ID = 629,             /* "FUNCTION-ID"  */
    FUNCTION_NAME = 630,           /* "intrinsic function name"  */
    FUNCTION_POINTER = 631,        /* "FUNCTION-POINTER"  */
    GENERATE = 632,                /* GENERATE  */
    GIVING = 633,                  /* GIVING  */
    GLOBAL = 634,                  /* GLOBAL  */
    GO = 635,                      /* GO  */
    GO_BACK = 636,                 /* "GO-BACK"  */
    GO_FORWARD = 637,              /* "GO-FORWARD"  */
    GO_HOME = 638,                 /* "GO-HOME"  */
    GO_SEARCH = 639,               /* "GO-SEARCH"  */
    GOBACK = 640,                  /* GOBACK  */
    GRAPHICAL = 641,               /* GRAPHICAL  */
    GREATER = 642,                 /* GREATER  */
    GREATER_OR_EQUAL = 643,        /* "GREATER OR EQUAL"  */
    GRID = 644,                    /* GRID  */
    GROUP = 645,                   /* GROUP  */
    GROUP_VALUE = 646,             /* "GROUP-VALUE"  */
    HANDLE = 647,                  /* HANDLE  */
    HAS_CHILDREN = 648,            /* "HAS-CHILDREN"  */
    HEADING = 649,                 /* HEADING  */
    HEADING_COLOR = 650,           /* "HEADING-COLOR"  */
    HEADING_DIVIDER_COLOR = 651,   /* "HEADING-DIVIDER-COLOR"  */
    HEADING_FONT = 652,            /* "HEADING-FONT"  */
    HEAVY = 653,                   /* HEAVY  */
    HEIGHT_IN_CELLS = 654,         /* "HEIGHT-IN-CELLS"  */
    HIDDEN_DATA = 655,             /* "HIDDEN-DATA"  */
    HIGHLIGHT = 656,               /* HIGHLIGHT  */
    HIGH_COLOR = 657,              /* "HIGH-COLOR"  */
    HIGH_VALUE = 658,              /* "HIGH-VALUE"  */
    HOT_TRACK = 659,               /* "HOT-TRACK"  */
    HSCROLL = 660,                 /* HSCROLL  */
    HSCROLL_POS = 661,             /* "HSCROLL-POS"  */
    ICON = 662,                    /* ICON  */
    ID = 663,                      /* ID  */
    IDENTIFIED = 664,              /* IDENTIFIED  */
    IDENTIFICATION = 665,          /* IDENTIFICATION  */
    IF = 666,                      /* IF  */
    IGNORE = 667,                  /* IGNORE  */
    IGNORING = 668,                /* IGNORING  */
    IN = 669,                      /* IN  */
    INDEPENDENT = 670,             /* INDEPENDENT  */
    INDEX = 671,                   /* INDEX  */
    INDEXED = 672,                 /* INDEXED  */
    INDICATE = 673,                /* INDICATE  */
    INITIALIZE = 674,              /* INITIALIZE  */
    INITIALIZED = 675,             /* INITIALIZED  */
    INITIATE = 676,                /* INITIATE  */
    INPUT = 677,                   /* INPUT  */
    INPUT_OUTPUT = 678,            /* "INPUT-OUTPUT"  */
    INQUIRE = 679,                 /* INQUIRE  */
    INSERTION_INDEX = 680,         /* "INSERTION-INDEX"  */
    INSERT_ROWS = 681,             /* "INSERT-ROWS"  */
    INSPECT = 682,                 /* INSPECT  */
    INSTALLATION = 683,            /* INSTALLATION  */
    INTERMEDIATE = 684,            /* INTERMEDIATE  */
    INTO = 685,                    /* INTO  */
    INTRINSIC = 686,               /* INTRINSIC  */
    INVALID = 687,                 /* INVALID  */
    INVALID_KEY = 688,             /* "INVALID KEY"  */
    IS = 689,                      /* IS  */
    ITEM = 690,                    /* ITEM  */
    ITEM_TEXT = 691,               /* "ITEM-TEXT"  */
    ITEM_TO_ADD = 692,             /* "ITEM-TO_ADD"  */
    ITEM_TO_DELETE = 693,          /* "ITEM-TO_DELETE"  */
    ITEM_TO_EMPTY = 694,           /* "ITEM-TO_EMPTY"  */
    ITEM_VALUE = 695,              /* "ITEM-VALUE"  */
    I_O = 696,                     /* "I-O"  */
    I_O_CONTROL = 697,             /* "I-O-CONTROL"  */
    JSON = 698,                    /* JSON  */
    JUSTIFIED = 699,               /* JUSTIFIED  */
    KEPT = 700,                    /* KEPT  */
    KEY = 701,                     /* KEY  */
    KEYBOARD = 702,                /* KEYBOARD  */
    LABEL = 703,                   /* LABEL  */
    LABEL_OFFSET = 704,            /* "LABEL-OFFSET"  */
    LARGE_FONT = 705,              /* "LARGE-FONT"  */
    LARGE_OFFSET = 706,            /* "LARGE-OFFSET"  */
    LAST = 707,                    /* LAST  */
    LAST_ROW = 708,                /* "LAST-ROW"  */
    LAYOUT_DATA = 709,             /* "LAYOUT-DATA"  */
    LAYOUT_MANAGER = 710,          /* "LAYOUT-MANAGER"  */
    LEADING = 711,                 /* LEADING  */
    LEADING_SHIFT = 712,           /* "LEADING-SHIFT"  */
    LEAVE = 713,                   /* LEAVE  */
    LEFT = 714,                    /* LEFT  */
    LEFTLINE = 715,                /* LEFTLINE  */
    LEFT_TEXT = 716,               /* "LEFT-TEXT"  */
    LENGTH = 717,                  /* LENGTH  */
    LENGTH_OF = 718,               /* "LENGTH OF"  */
    LENGTH_FUNC = 719,             /* "FUNCTION LENGTH/BYTE-LENGTH"  */
    LESS = 720,                    /* LESS  */
    LESS_OR_EQUAL = 721,           /* "LESS OR EQUAL"  */
    LEVEL_NUMBER = 722,            /* "level-number"  */
    LIKE = 723,                    /* LIKE  */
    LIMIT = 724,                   /* LIMIT  */
    LIMITS = 725,                  /* LIMITS  */
    LINAGE = 726,                  /* LINAGE  */
    LINAGE_COUNTER = 727,          /* "LINAGE-COUNTER"  */
    LINE = 728,                    /* LINE  */
    LINE_COUNTER = 729,            /* "LINE-COUNTER"  */
    LINE_LIMIT = 730,              /* "LINE LIMIT"  */
    LINE_SEQUENTIAL = 731,         /* "LINE-SEQUENTIAL"  */
    LINES = 732,                   /* LINES  */
    LINES_AT_ROOT = 733,           /* "LINES-AT-ROOT"  */
    LINKAGE = 734,                 /* LINKAGE  */
    LIST_BOX = 735,                /* "LIST-BOX"  */
    LITERAL = 736,                 /* "Literal"  */
    LM_RESIZE = 737,               /* "LM-RESIZE"  */
    LOC = 738,                     /* LOC  */
    LOCALE = 739,                  /* LOCALE  */
    LOCALE_DATE_FUNC = 740,        /* "FUNCTION LOCALE-DATE"  */
    LOCALE_TIME_FUNC = 741,        /* "FUNCTION LOCALE-TIME"  */
    LOCALE_TIME_FROM_FUNC = 742,   /* "FUNCTION LOCALE-TIME-FROM-SECONDS"  */
    LOCAL_STORAGE = 743,           /* "LOCAL-STORAGE"  */
    LOCK = 744,                    /* LOCK  */
    LOCK_HOLDING = 745,            /* "LOCK-HOLDING"  */
    LONG_DATE = 746,               /* "LONG-DATE"  */
    LOWER = 747,                   /* LOWER  */
    LOWERED = 748,                 /* LOWERED  */
    LOWER_CASE_FUNC = 749,         /* "FUNCTION LOWER-CASE"  */
    LOWLIGHT = 750,                /* LOWLIGHT  */
    LOW_COLOR = 751,               /* "LOW-COLOR"  */
    LOW_VALUE = 752,               /* "LOW-VALUE"  */
    MAGNETIC_TAPE = 753,           /* "MAGNETIC-TAPE"  */
    MANUAL = 754,                  /* MANUAL  */
    MASS_UPDATE = 755,             /* "MASS-UPDATE"  */
    MASTER_INDEX = 756,            /* "MASTER-INDEX"  */
    MAX_LINES = 757,               /* "MAX-LINES"  */
    MAX_PROGRESS = 758,            /* "MAX-PROGRESS"  */
    MAX_TEXT = 759,                /* "MAX-TEXT"  */
    MAX_VAL = 760,                 /* "MAX-VAL"  */
    MEMORY = 761,                  /* MEMORY  */
    MEDIUM_FONT = 762,             /* "MEDIUM-FONT"  */
    MENU = 763,                    /* MENU  */
    MERGE = 764,                   /* MERGE  */
    MESSAGE = 765,                 /* MESSAGE  */
    MICROSECOND_TIME = 766,        /* "MICROSECOND-TIME"  */
    MINUS = 767,                   /* MINUS  */
    MIN_VAL = 768,                 /* "MIN-VAL"  */
    MNEMONIC_NAME = 769,           /* "Mnemonic name"  */
    MODE = 770,                    /* MODE  */
    MODIFY = 771,                  /* MODIFY  */
    MODULES = 772,                 /* MODULES  */
    MOVE = 773,                    /* MOVE  */
    MULTILINE = 774,               /* MULTILINE  */
    MULTIPLE = 775,                /* MULTIPLE  */
    MULTIPLY = 776,                /* MULTIPLY  */
    NAME = 777,                    /* NAME  */
    NAMED = 778,                   /* NAMED  */
    NAMESPACE = 779,               /* NAMESPACE  */
    NAMESPACE_PREFIX = 780,        /* "NAMESPACE-PREFIX"  */
    NATIONAL = 781,                /* NATIONAL  */
    NATIONAL_EDITED = 782,         /* "NATIONAL-EDITED"  */
    NATIONAL_OF_FUNC = 783,        /* "FUNCTION NATIONAL-OF"  */
    NATIVE = 784,                  /* NATIVE  */
    NAVIGATE_URL = 785,            /* "NAVIGATE-URL"  */
    NEAREST_AWAY_FROM_ZERO = 786,  /* "NEAREST-AWAY-FROM-ZERO"  */
    NEAREST_EVEN = 787,            /* "NEAREST-EVEN"  */
    NEAREST_TOWARD_ZERO = 788,     /* "NEAREST-TOWARD-ZERO"  */
    NEGATIVE = 789,                /* NEGATIVE  */
    NESTED = 790,                  /* NESTED  */
    NEW = 791,                     /* NEW  */
    NEXT = 792,                    /* NEXT  */
    NEXT_ITEM = 793,               /* "NEXT-ITEM"  */
    NEXT_GROUP = 794,              /* "NEXT GROUP"  */
    NEXT_PAGE = 795,               /* "NEXT PAGE"  */
    NO = 796,                      /* NO  */
    NO_ADVANCING = 797,            /* "NO ADVANCING"  */
    NO_AUTOSEL = 798,              /* "NO-AUTOSEL"  */
    NO_AUTO_DEFAULT = 799,         /* "NO-AUTO-DEFAULT"  */
    NO_BOX = 800,                  /* "NO-BOX"  */
    NO_DATA = 801,                 /* "NO DATA"  */
    NO_DIVIDERS = 802,             /* "NO-DIVIDERS"  */
    NO_ECHO = 803,                 /* "NO-ECHO"  */
    NO_F4 = 804,                   /* "NO-F4"  */
    NO_FOCUS = 805,                /* "NO-FOCUS"  */
    NO_GROUP_TAB = 806,            /* "NO-GROUP-TAB"  */
    NO_KEY_LETTER = 807,           /* "NO-KEY-LETTER"  */
    NO_SEARCH = 808,               /* "NO-SEARCH"  */
    NO_UPDOWN = 809,               /* "NO-UPDOWN"  */
    NOMINAL = 810,                 /* NOMINAL  */
    NONE = 811,                    /* NONE  */
    NONNUMERIC = 812,              /* NONNUMERIC  */
    NORMAL = 813,                  /* NORMAL  */
    NOT = 814,                     /* NOT  */
    NOTAB = 815,                   /* NOTAB  */
    NOTHING = 816,                 /* NOTHING  */
    NOTIFY = 817,                  /* NOTIFY  */
    NOTIFY_CHANGE = 818,           /* "NOTIFY-CHANGE"  */
    NOTIFY_DBLCLICK = 819,         /* "NOTIFY-DBLCLICK"  */
    NOTIFY_SELCHANGE = 820,        /* "NOTIFY-SELCHANGE"  */
    NOT_AT_END = 821,              /* "NOT AT END"  */
    NOT_EOP = 822,                 /* "NOT AT EOP"  */
    NOT_ON_ESCAPE = 823,           /* "NOT ON ESCAPE"  */
    NOT_EQUAL = 824,               /* "NOT EQUAL"  */
    NOT_ON_EXCEPTION = 825,        /* "NOT ON EXCEPTION"  */
    NOT_INVALID_KEY = 826,         /* "NOT INVALID KEY"  */
    NOT_ON_OVERFLOW = 827,         /* "NOT ON OVERFLOW"  */
    NOT_SIZE_ERROR = 828,          /* "NOT SIZE ERROR"  */
    NUM_COL_HEADINGS = 829,        /* "NUM-COL-HEADINGS"  */
    NUM_ROWS = 830,                /* "NUM-ROWS"  */
    NUMBER = 831,                  /* NUMBER  */
    NUMBERS = 832,                 /* NUMBERS  */
    NUMERIC = 833,                 /* NUMERIC  */
    NUMERIC_EDITED = 834,          /* "NUMERIC-EDITED"  */
    NUMVALC_FUNC = 835,            /* "FUNCTION NUMVAL-C"  */
    OBJECT = 836,                  /* OBJECT  */
    OBJECT_COMPUTER = 837,         /* "OBJECT-COMPUTER"  */
    OCCURS = 838,                  /* OCCURS  */
    OF = 839,                      /* OF  */
    OFF = 840,                     /* OFF  */
    OK_BUTTON = 841,               /* "OK-BUTTON"  */
    OMITTED = 842,                 /* OMITTED  */
    ON = 843,                      /* ON  */
    ONLY = 844,                    /* ONLY  */
    ON_ESCAPE = 845,               /* "ON ESCAPE"  */
    ON_EXCEPTION = 846,            /* "ON EXCEPTION"  */
    OPEN = 847,                    /* OPEN  */
    OPTIONAL = 848,                /* OPTIONAL  */
    OPTIONS = 849,                 /* OPTIONS  */
    OR = 850,                      /* OR  */
    ORDER = 851,                   /* ORDER  */
    ORGANIZATION = 852,            /* ORGANIZATION  */
    OTHER = 853,                   /* OTHER  */
    OTHERS = 854,                  /* OTHERS  */
    OUTPUT = 855,                  /* OUTPUT  */
    OVERLAP_LEFT = 856,            /* "OVERLAP-LEFT"  */
    OVERLAP_TOP = 857,             /* "OVERLAP-TOP"  */
    OVERLINE = 858,                /* OVERLINE  */
    PACKED_DECIMAL = 859,          /* "PACKED-DECIMAL"  */
    PADDING = 860,                 /* PADDING  */
    PASCAL = 861,                  /* PASCAL  */
    PAGE = 862,                    /* PAGE  */
    PAGE_COUNTER = 863,            /* "PAGE-COUNTER"  */
    PAGE_SETUP = 864,              /* "PAGE-SETUP"  */
    PAGED = 865,                   /* PAGED  */
    PARAGRAPH = 866,               /* PARAGRAPH  */
    PARENT = 867,                  /* PARENT  */
    PARSE = 868,                   /* PARSE  */
    PASSWORD = 869,                /* PASSWORD  */
    PERFORM = 870,                 /* PERFORM  */
    PERMANENT = 871,               /* PERMANENT  */
    PH = 872,                      /* PH  */
    PF = 873,                      /* PF  */
    PHYSICAL = 874,                /* PHYSICAL  */
    PICTURE = 875,                 /* PICTURE  */
    PICTURE_SYMBOL = 876,          /* "PICTURE SYMBOL"  */
    PIXEL = 877,                   /* PIXEL  */
    PLACEMENT = 878,               /* PLACEMENT  */
    PLUS = 879,                    /* PLUS  */
    POINTER = 880,                 /* POINTER  */
    POP_UP = 881,                  /* "POP-UP"  */
    POS = 882,                     /* POS  */
    POSITION = 883,                /* POSITION  */
    POSITION_SHIFT = 884,          /* "POSITION-SHIFT"  */
    POSITIVE = 885,                /* POSITIVE  */
    PRESENT = 886,                 /* PRESENT  */
    PREVIOUS = 887,                /* PREVIOUS  */
    PRINT = 888,                   /* PRINT  */
    PRINT_CONTROL = 889,           /* "PRINT-CONTROL"  */
    PRINT_NO_PROMPT = 890,         /* "PRINT-NO-PROMPT"  */
    PRINT_PREVIEW = 891,           /* "PRINT-PREVIEW"  */
    PRINTER = 892,                 /* PRINTER  */
    PRINTER_1 = 893,               /* "PRINTER-1"  */
    PRINTING = 894,                /* PRINTING  */
    PRIORITY = 895,                /* PRIORITY  */
    PROCEDURE = 896,               /* PROCEDURE  */
    PROCEDURES = 897,              /* PROCEDURES  */
    PROCEED = 898,                 /* PROCEED  */
    PROCESSING = 899,              /* PROCESSING  */
    PROGRAM = 900,                 /* PROGRAM  */
    PROGRAM_ID = 901,              /* "PROGRAM-ID"  */
    PROGRAM_NAME = 902,            /* "program name"  */
    PROGRAM_POINTER = 903,         /* "PROGRAM-POINTER"  */
    PROGRESS = 904,                /* PROGRESS  */
    PROHIBITED = 905,              /* PROHIBITED  */
    PROMPT = 906,                  /* PROMPT  */
    PROPERTIES = 907,              /* PROPERTIES  */
    PROPERTY = 908,                /* PROPERTY  */
    PROTECTED = 909,               /* PROTECTED  */
    PROTOTYPE = 910,               /* PROTOTYPE  */
    PURGE = 911,                   /* PURGE  */
    PUSH_BUTTON = 912,             /* "PUSH-BUTTON"  */
    QUERY_INDEX = 913,             /* "QUERY-INDEX"  */
    QUEUE = 914,                   /* QUEUE  */
    QUOTE = 915,                   /* QUOTE  */
    RADIO_BUTTON = 916,            /* "RADIO-BUTTON"  */
    RAISE = 917,                   /* RAISE  */
    RAISED = 918,                  /* RAISED  */
    RAISING = 919,                 /* RAISING  */
    RANDOM = 920,                  /* RANDOM  */
    RD = 921,                      /* RD  */
    READ = 922,                    /* READ  */
    READERS = 923,                 /* READERS  */
    READ_ONLY = 924,               /* "READ-ONLY"  */
    READY_TRACE = 925,             /* "READY TRACE"  */
    RECEIVE = 926,                 /* RECEIVE  */
    RECEIVED = 927,                /* RECEIVED  */
    RECORD = 928,                  /* RECORD  */
    RECORD_DATA = 929,             /* "RECORD-DATA"  */
    RECORD_OVERFLOW = 930,         /* "RECORD-OVERFLOW"  */
    RECORD_TO_ADD = 931,           /* "RECORD-TO-ADD"  */
    RECORD_TO_DELETE = 932,        /* "RECORD-TO-DELETE"  */
    RECORDING = 933,               /* RECORDING  */
    RECORDS = 934,                 /* RECORDS  */
    RECURSIVE = 935,               /* RECURSIVE  */
    REDEFINES = 936,               /* REDEFINES  */
    REEL = 937,                    /* REEL  */
    REFERENCE = 938,               /* REFERENCE  */
    REFERENCES = 939,              /* REFERENCES  */
    REFRESH = 940,                 /* REFRESH  */
    REGION_COLOR = 941,            /* "REGION-COLOR"  */
    RELATION = 942,                /* RELATION  */
    RELATIVE = 943,                /* RELATIVE  */
    RELEASE = 944,                 /* RELEASE  */
    REMAINDER = 945,               /* REMAINDER  */
    REMARKS = 946,                 /* REMARKS  */
    REMOVAL = 947,                 /* REMOVAL  */
    RENAMES = 948,                 /* RENAMES  */
    REORG_CRITERIA = 949,          /* "REORG-CRITERIA"  */
    REPEATED = 950,                /* REPEATED  */
    REPLACE = 951,                 /* REPLACE  */
    REPLACING = 952,               /* REPLACING  */
    REPORT = 953,                  /* REPORT  */
    REPORTING = 954,               /* REPORTING  */
    REPORTS = 955,                 /* REPORTS  */
    REPOSITORY = 956,              /* REPOSITORY  */
    REQUIRED = 957,                /* REQUIRED  */
    REREAD = 958,                  /* REREAD  */
    RERUN = 959,                   /* RERUN  */
    RESERVE = 960,                 /* RESERVE  */
    RESET = 961,                   /* RESET  */
    RESET_TRACE = 962,             /* "RESET TRACE"  */
    RESET_GRID = 963,              /* "RESET-GRID"  */
    RESET_LIST = 964,              /* "RESET-LIST"  */
    RESET_TABS = 965,              /* "RESET-TABS"  */
    RETRY = 966,                   /* RETRY  */
    RETURN = 967,                  /* RETURN  */
    RETURNING = 968,               /* RETURNING  */
    REVERSE = 969,                 /* REVERSE  */
    REVERSE_FUNC = 970,            /* "FUNCTION REVERSE"  */
    REVERSE_VIDEO = 971,           /* "REVERSE-VIDEO"  */
    REVERSED = 972,                /* REVERSED  */
    REWIND = 973,                  /* REWIND  */
    REWRITE = 974,                 /* REWRITE  */
    RF = 975,                      /* RF  */
    RH = 976,                      /* RH  */
    RIGHT = 977,                   /* RIGHT  */
    RIGHT_ALIGN = 978,             /* "RIGHT-ALIGN"  */
    RIMMED = 979,                  /* RIMMED  */
    ROLLBACK = 980,                /* ROLLBACK  */
    ROUNDED = 981,                 /* ROUNDED  */
    ROUNDING = 982,                /* ROUNDING  */
    ROW_COLOR = 983,               /* "ROW-COLOR"  */
    ROW_COLOR_PATTERN = 984,       /* "ROW-COLOR-PATTERN"  */
    ROW_DIVIDERS = 985,            /* "ROW-DIVIDERS"  */
    ROW_FONT = 986,                /* "ROW-FONT"  */
    ROW_HEADINGS = 987,            /* "ROW-HEADINGS"  */
    ROW_PROTECTION = 988,          /* "ROW-PROTECTION"  */
    RUN = 989,                     /* RUN  */
    S = 990,                       /* S  */
    SAME = 991,                    /* SAME  */
    SAVE_AS = 992,                 /* "SAVE-AS"  */
    SAVE_AS_NO_PROMPT = 993,       /* "SAVE-AS-NO-PROMPT"  */
    SCREEN = 994,                  /* SCREEN  */
    SCREEN_CONTROL = 995,          /* "SCREEN CONTROL"  */
    SCROLL = 996,                  /* SCROLL  */
    SCROLL_BAR = 997,              /* "SCROLL-BAR"  */
    SD = 998,                      /* SD  */
    SEARCH = 999,                  /* SEARCH  */
    SEARCH_OPTIONS = 1000,         /* "SEARCH-OPTIONS"  */
    SEARCH_TEXT = 1001,            /* "SEARCH-TEXT"  */
    SECONDS = 1002,                /* SECONDS  */
    SECTION = 1003,                /* SECTION  */
    SECURE = 1004,                 /* SECURE  */
    SECURITY = 1005,               /* SECURITY  */
    SEGMENT = 1006,                /* SEGMENT  */
    SEGMENT_LIMIT = 1007,          /* "SEGMENT-LIMIT"  */
    SELECT = 1008,                 /* SELECT  */
    SELECTION_INDEX = 1009,        /* "SELECTION-INDEX"  */
    SELECTION_TEXT = 1010,         /* "SELECTION-TEXT"  */
    SELECT_ALL = 1011,             /* "SELECTION-ALL"  */
    SELF_ACT = 1012,               /* "SELF-ACT"  */
    SEMI_COLON = 1013,             /* "semi-colon"  */
    SEND = 1014,                   /* SEND  */
    SENTENCE = 1015,               /* SENTENCE  */
    SEPARATE = 1016,               /* SEPARATE  */
    SEPARATION = 1017,             /* SEPARATION  */
    SEQUENCE = 1018,               /* SEQUENCE  */
    SEQUENTIAL = 1019,             /* SEQUENTIAL  */
    SET = 1020,                    /* SET  */
    SEVENTY_EIGHT = 1021,          /* "level-number 78"  */
    SHADING = 1022,                /* SHADING  */
    SHADOW = 1023,                 /* SHADOW  */
    SHARING = 1024,                /* SHARING  */
    SHORT_DATE = 1025,             /* "SHORT-DATE"  */
    SHOW_LINES = 1026,             /* "SHOW-LINES"  */
    SHOW_NONE = 1027,              /* "SHOW-NONE"  */
    SHOW_SEL_ALWAYS = 1028,        /* "SHOW-SEL-ALWAYS"  */
    SIGN = 1029,                   /* SIGN  */
    SIGNED = 1030,                 /* SIGNED  */
    SIGNED_INT = 1031,             /* "SIGNED-INT"  */
    SIGNED_LONG = 1032,            /* "SIGNED-LONG"  */
    SIGNED_SHORT = 1033,           /* "SIGNED-SHORT"  */
    SIXTY_SIX = 1034,              /* "level-number 66"  */
    SIZE = 1035,                   /* SIZE  */
    SIZE_ERROR = 1036,             /* "SIZE ERROR"  */
    SMALL_FONT = 1037,             /* "SMALL-FONT"  */
    SORT = 1038,                   /* SORT  */
    SORT_MERGE = 1039,             /* "SORT-MERGE"  */
    SORT_ORDER = 1040,             /* "SORT-ORDER"  */
    SOURCE = 1041,                 /* SOURCE  */
    SOURCE_COMPUTER = 1042,        /* "SOURCE-COMPUTER"  */
    SPACE = 1043,                  /* SPACE  */
    SPECIAL_NAMES = 1044,          /* "SPECIAL-NAMES"  */
    SPINNER = 1045,                /* SPINNER  */
    SQUARE = 1046,                 /* SQUARE  */
    STANDARD = 1047,               /* STANDARD  */
    STANDARD_1 = 1048,             /* "STANDARD-1"  */
    STANDARD_2 = 1049,             /* "STANDARD-2"  */
    STANDARD_BINARY = 1050,        /* "STANDARD-BINARY"  */
    STANDARD_DECIMAL = 1051,       /* "STANDARD-DECIMAL"  */
    START = 1052,                  /* START  */
    START_X = 1053,                /* "START-X"  */
    START_Y = 1054,                /* "START-Y"  */
    STATIC = 1055,                 /* STATIC  */
    STATIC_LIST = 1056,            /* "STATIC-LIST"  */
    STATUS = 1057,                 /* STATUS  */
    STATUS_BAR = 1058,             /* "STATUS-BAR"  */
    STATUS_TEXT = 1059,            /* "STATUS-TEXT"  */
    STDCALL = 1060,                /* STDCALL  */
    STEP = 1061,                   /* STEP  */
    STOP = 1062,                   /* STOP  */
    STRING = 1063,                 /* STRING  */
    STRONG = 1064,                 /* STRONG  */
    STYLE = 1065,                  /* STYLE  */
    SUB_QUEUE_1 = 1066,            /* "SUB-QUEUE-1"  */
    SUB_QUEUE_2 = 1067,            /* "SUB-QUEUE-2"  */
    SUB_QUEUE_3 = 1068,            /* "SUB-QUEUE-3"  */
    SUBSTITUTE_FUNC = 1069,        /* "FUNCTION SUBSTITUTE"  */
    SUBSTITUTE_CASE_FUNC = 1070,   /* "FUNCTION SUBSTITUTE-CASE"  */
    SUBTRACT = 1071,               /* SUBTRACT  */
    SUBWINDOW = 1072,              /* SUBWINDOW  */
    SUM = 1073,                    /* SUM  */
    SUPPRESS = 1074,               /* SUPPRESS  */
    SUPPRESS_XML = 1075,           /* "SUPPRESS"  */
    SYMBOLIC = 1076,               /* SYMBOLIC  */
    SYNCHRONIZED = 1077,           /* SYNCHRONIZED  */
    SYSTEM_DEFAULT = 1078,         /* "SYSTEM-DEFAULT"  */
    SYSTEM_INFO = 1079,            /* "SYSTEM-INFO"  */
    SYSTEM_OFFSET = 1080,          /* "SYSTEM-OFFSET"  */
    TAB = 1081,                    /* TAB  */
    TAB_TO_ADD = 1082,             /* "TAB-TO-ADD"  */
    TAB_TO_DELETE = 1083,          /* "TAB-TO-DELETE"  */
    TABLE = 1084,                  /* TABLE  */
    TALLYING = 1085,               /* TALLYING  */
    TEMPORARY = 1086,              /* TEMPORARY  */
    TAPE = 1087,                   /* TAPE  */
    TERMINAL = 1088,               /* TERMINAL  */
    TERMINATE = 1089,              /* TERMINATE  */
    TERMINAL_INFO = 1090,          /* "TERMINAL-INFO"  */
    TERMINATION_VALUE = 1091,      /* "TERMINATION-VALUE"  */
    TEST = 1092,                   /* TEST  */
    TEXT = 1093,                   /* TEXT  */
    THAN = 1094,                   /* THAN  */
    THEN = 1095,                   /* THEN  */
    THREAD = 1096,                 /* THREAD  */
    THREADS = 1097,                /* THREADS  */
    THRU = 1098,                   /* THRU  */
    THUMB_POSITION = 1099,         /* "THUMB-POSITION"  */
    TILED_HEADINGS = 1100,         /* "TILED-HEADINGS"  */
    TIME = 1101,                   /* TIME  */
    TIME_OUT = 1102,               /* "TIME-OUT"  */
    TIMES = 1103,                  /* TIMES  */
    TITLE = 1104,                  /* TITLE  */
    TITLE_POSITION = 1105,         /* "TITLE-POSITION"  */
    TO = 1106,                     /* TO  */
    TOK_AMPER = 1107,              /* "&"  */
    TOK_CLOSE_PAREN = 1108,        /* ")"  */
    TOK_COLON = 1109,              /* ":"  */
    TOK_DIV = 1110,                /* "/"  */
    TOK_DOT = 1111,                /* "."  */
    TOK_EQUAL = 1112,              /* "="  */
    TOK_EXTERN = 1113,             /* "EXTERN"  */
    TOK_FALSE = 1114,              /* "FALSE"  */
    TOK_FILE = 1115,               /* "FILE"  */
    TOK_GREATER = 1116,            /* ">"  */
    TOK_INITIAL = 1117,            /* "INITIAL"  */
    TOK_LESS = 1118,               /* "<"  */
    TOK_MINUS = 1119,              /* "-"  */
    TOK_MUL = 1120,                /* "*"  */
    TOK_NULL = 1121,               /* "NULL"  */
    TOK_OVERFLOW = 1122,           /* "OVERFLOW"  */
    TOK_OPEN_PAREN = 1123,         /* "("  */
    TOK_PLUS = 1124,               /* "+"  */
    TOK_TRUE = 1125,               /* "TRUE"  */
    TOP = 1126,                    /* TOP  */
    TOWARD_GREATER = 1127,         /* "TOWARD-GREATER"  */
    TOWARD_LESSER = 1128,          /* "TOWARD-LESSER"  */
    TRACK = 1129,                  /* TRACK  */
    TRACKS = 1130,                 /* TRACKS  */
    TRACK_AREA = 1131,             /* "TRACK-AREA"  */
    TRACK_LIMIT = 1132,            /* "TRACK-LIMIT"  */
    TRADITIONAL_FONT = 1133,       /* "TRADITIONAL-FONT"  */
    TRAILING = 1134,               /* TRAILING  */
    TRAILING_SHIFT = 1135,         /* "TRAILING-SHIFT"  */
    TRANSFORM = 1136,              /* TRANSFORM  */
    TRANSPARENT = 1137,            /* TRANSPARENT  */
    TREE_VIEW = 1138,              /* "TREE-VIEW"  */
    TRIM_FUNC = 1139,              /* "FUNCTION TRIM"  */
    TRUNCATION = 1140,             /* TRUNCATION  */
    TYPE = 1141,                   /* TYPE  */
    TYPEDEF = 1142,                /* TYPEDEF  */
    U = 1143,                      /* U  */
    UCS_4 = 1144,                  /* "UCS-4"  */
    UNBOUNDED = 1145,              /* UNBOUNDED  */
    UNDERLINE = 1146,              /* UNDERLINE  */
    UNFRAMED = 1147,               /* UNFRAMED  */
    UNIT = 1148,                   /* UNIT  */
    UNLOCK = 1149,                 /* UNLOCK  */
    UNSIGNED = 1150,               /* UNSIGNED  */
    UNSIGNED_INT = 1151,           /* "UNSIGNED-INT"  */
    UNSIGNED_LONG = 1152,          /* "UNSIGNED-LONG"  */
    UNSIGNED_SHORT = 1153,         /* "UNSIGNED-SHORT"  */
    UNSORTED = 1154,               /* UNSORTED  */
    UNSTRING = 1155,               /* UNSTRING  */
    UNTIL = 1156,                  /* UNTIL  */
    UP = 1157,                     /* UP  */
    UPDATE = 1158,                 /* UPDATE  */
    UPDATERS = 1159,               /* UPDATERS  */
    UPON = 1160,                   /* UPON  */
    UPON_ARGUMENT_NUMBER = 1161,   /* "UPON ARGUMENT-NUMBER"  */
    UPON_COMMAND_LINE = 1162,      /* "UPON COMMAND-LINE"  */
    UPON_ENVIRONMENT_NAME = 1163,  /* "UPON ENVIRONMENT-NAME"  */
    UPON_ENVIRONMENT_VALUE = 1164, /* "UPON ENVIRONMENT-VALUE"  */
    UPPER = 1165,                  /* UPPER  */
    UPPER_CASE_FUNC = 1166,        /* "FUNCTION UPPER-CASE"  */
    USAGE = 1167,                  /* USAGE  */
    USE = 1168,                    /* USE  */
    USE_ALT = 1169,                /* "USE-ALT"  */
    USE_RETURN = 1170,             /* "USE-RETURN"  */
    USE_TAB = 1171,                /* "USE-TAB"  */
    USER = 1172,                   /* USER  */
    USER_DEFAULT = 1173,           /* "USER-DEFAULT"  */
    USER_FUNCTION_NAME = 1174,     /* "user function name"  */
    USING = 1175,                  /* USING  */
    UTF_8 = 1176,                  /* "UTF-8"  */
    UTF_16 = 1177,                 /* "UTF-16"  */
    V = 1178,                      /* V  */
    VALID = 1179,                  /* VALID  */
    VALIDATE = 1180,               /* VALIDATE  */
    VAL_STATUS = 1181,             /* "VAL-STATUS"  */
    VALIDATE_STATUS = 1182,        /* "VALIDATE-STATUS"  */
    VALIDATING = 1183,             /* VALIDATING  */
    VALUE = 1184,                  /* VALUE  */
    VALUE_FORMAT = 1185,           /* "VALUE-FORMAT"  */
    VALUES = 1186,                 /* VALUES  */
    VARIABLE = 1187,               /* VARIABLE  */
    VARIANT = 1188,                /* VARIANT  */
    VARYING = 1189,                /* VARYING  */
    VERTICAL = 1190,               /* VERTICAL  */
    VERY_HEAVY = 1191,             /* "VERY-HEAVY"  */
    VIRTUAL_WIDTH = 1192,          /* "VIRTUAL-WIDTH"  */
    VOLATILE = 1193,               /* VOLATILE  */
    VPADDING = 1194,               /* VPADDING  */
    VSCROLL = 1195,                /* VSCROLL  */
    VSCROLL_BAR = 1196,            /* "VSCROLL-BAR"  */
    VSCROLL_POS = 1197,            /* "VSCROLL-POS"  */
    VTOP = 1198,                   /* VTOP  */
    WAIT = 1199,                   /* WAIT  */
    WEB_BROWSER = 1200,            /* "WEB-BROWSER"  */
    WHEN = 1201,                   /* WHEN  */
    WHEN_COMPILED_FUNC = 1202,     /* "FUNCTION WHEN-COMPILED"  */
    WHEN_XML = 1203,               /* "WHEN"  */
    WIDTH = 1204,                  /* WIDTH  */
    WIDTH_IN_CELLS = 1205,         /* "WIDTH-IN-CELLS"  */
    WINAPI = 1206,                 /* WINAPI  */
    WINDOW = 1207,                 /* WINDOW  */
    WITH = 1208,                   /* WITH  */
    WORD = 1209,                   /* "Identifier"  */
    WORDS = 1210,                  /* WORDS  */
    WORKING_STORAGE = 1211,        /* "WORKING-STORAGE"  */
    WRAP = 1212,                   /* WRAP  */
    WRITE = 1213,                  /* WRITE  */
    WRITE_ONLY = 1214,             /* "WRITE-ONLY"  */
    WRITE_VERIFY = 1215,           /* "WRITE-VERIFY"  */
    WRITERS = 1216,                /* WRITERS  */
    X = 1217,                      /* X  */
    XML = 1218,                    /* XML  */
    XML_DECLARATION = 1219,        /* "XML-DECLARATION"  */
    XML_SCHEMA = 1220,             /* "XML-SCHEMA"  */
    Y = 1221,                      /* Y  */
    YYYYDDD = 1222,                /* YYYYDDD  */
    YYYYMMDD = 1223,               /* YYYYMMDD  */
    ZERO = 1224,                   /* ZERO  */
    LEVEL_NUMBER_IN_AREA_A = 1225, /* "level-number (Area A)"  */
    WORD_IN_AREA_A = 1226,         /* "Identifier (Area A)"  */
    SHIFT_PREFER = 1227            /* SHIFT_PREFER  */
  };
  typedef enum yytokentype yytoken_kind_t;
#endif

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef int YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif


extern YYSTYPE yylval;

int yyparse (void);

#endif /* !YY_YY_PARSER_H_INCLUDED  */
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_THREEDIMENSIONAL = 3,           /* "3D"  */
  YYSYMBOL_ABSENT = 4,                     /* ABSENT  */
  YYSYMBOL_ACCEPT = 5,                     /* ACCEPT  */
  YYSYMBOL_ACCESS = 6,                     /* ACCESS  */
  YYSYMBOL_ACTIVEX = 7,                    /* "ACTIVE-X"  */
  YYSYMBOL_ACTIVE_CLASS = 8,               /* "ACTIVE-CLASS"  */
  YYSYMBOL_ACTION = 9,                     /* ACTION  */
  YYSYMBOL_ACTUAL = 10,                    /* ACTUAL  */
  YYSYMBOL_ADD = 11,                       /* ADD  */
  YYSYMBOL_ADDRESS = 12,                   /* ADDRESS  */
  YYSYMBOL_ADJUSTABLE_COLUMNS = 13,        /* "ADJUSTABLE-COLUMNS"  */
  YYSYMBOL_ADVANCING = 14,                 /* ADVANCING  */
  YYSYMBOL_AFTER = 15,                     /* AFTER  */
  YYSYMBOL_ALIGNED = 16,                   /* ALIGNED  */
  YYSYMBOL_ALIGNMENT = 17,                 /* ALIGNMENT  */
  YYSYMBOL_ALL = 18,                       /* ALL  */
  YYSYMBOL_ALLOCATE = 19,                  /* ALLOCATE  */
  YYSYMBOL_ALLOWING = 20,                  /* ALLOWING  */
  YYSYMBOL_ALPHABET = 21,                  /* ALPHABET  */
  YYSYMBOL_ALPHABETIC = 22,                /* ALPHABETIC  */
  YYSYMBOL_ALPHABETIC_LOWER = 23,          /* "ALPHABETIC-LOWER"  */
  YYSYMBOL_ALPHABETIC_UPPER = 24,          /* "ALPHABETIC-UPPER"  */
  YYSYMBOL_ALPHANUMERIC = 25,              /* ALPHANUMERIC  */
  YYSYMBOL_ALPHANUMERIC_EDITED = 26,       /* "ALPHANUMERIC-EDITED"  */
  YYSYMBOL_ALSO = 27,                      /* ALSO  */
  YYSYMBOL_ALTER = 28,                     /* ALTER  */
  YYSYMBOL_ALTERNATE = 29,                 /* ALTERNATE  */
  YYSYMBOL_AND = 30,                       /* AND  */
  YYSYMBOL_ANY = 31,                       /* ANY  */
  YYSYMBOL_APPLY = 32,                     /* APPLY  */
  YYSYMBOL_ARE = 33,                       /* ARE  */
  YYSYMBOL_AREA = 34,                      /* AREA  */
  YYSYMBOL_AREAS = 35,                     /* AREAS  */
  YYSYMBOL_ARGUMENT_NUMBER = 36,           /* "ARGUMENT-NUMBER"  */
  YYSYMBOL_ARGUMENT_VALUE = 37,            /* "ARGUMENT-VALUE"  */
  YYSYMBOL_ARITHMETIC = 38,                /* ARITHMETIC  */
  YYSYMBOL_AS = 39,                        /* AS  */
  YYSYMBOL_ASCENDING = 40,                 /* ASCENDING  */
  YYSYMBOL_ASCII = 41,                     /* ASCII  */
  YYSYMBOL_ASSIGN = 42,                    /* ASSIGN  */
  YYSYMBOL_AT = 43,                        /* AT  */
  YYSYMBOL_AT_END = 44,                    /* "AT END"  */
  YYSYMBOL_ATTRIBUTE = 45,                 /* ATTRIBUTE  */
  YYSYMBOL_ATTRIBUTES = 46,                /* ATTRIBUTES  */
  YYSYMBOL_AUTHOR = 47,                    /* AUTHOR  */
  YYSYMBOL_AUTO = 48,                      /* AUTO  */
  YYSYMBOL_AUTO_DECIMAL = 49,              /* "AUTO-DECIMAL"  */
  YYSYMBOL_AUTO_SPIN = 50,                 /* "AUTO-SPIN"  */
  YYSYMBOL_AUTOMATIC = 51,                 /* AUTOMATIC  */
  YYSYMBOL_AWAY_FROM_ZERO = 52,            /* "AWAY-FROM-ZERO"  */
  YYSYMBOL_B_AND = 53,                     /* "B-AND"  */
  YYSYMBOL_B_NOT = 54,                     /* "B-NOT"  */
  YYSYMBOL_B_OR = 55,                      /* "B-OR"  */
  YYSYMBOL_B_XOR = 56,                     /* "B-XOR"  */
  YYSYMBOL_B_SHIFT_L = 57,                 /* "B-SHIFT-L"  */
  YYSYMBOL_B_SHIFT_R = 58,                 /* "B-SHIFT-R"  */
  YYSYMBOL_B_SHIFT_LC = 59,                /* "B-SHIFT-LC"  */
  YYSYMBOL_B_SHIFT_RC = 60,                /* "B-SHIFT-RC"  */
  YYSYMBOL_BACKGROUND_COLOR = 61,          /* "BACKGROUND-COLOR"  */
  YYSYMBOL_BACKGROUND_HIGH = 62,           /* "BACKGROUND-HIGH"  */
  YYSYMBOL_BACKGROUND_LOW = 63,            /* "BACKGROUND-LOW"  */
  YYSYMBOL_BACKGROUND_STANDARD = 64,       /* "BACKGROUND-STANDARD"  */
  YYSYMBOL_BACKWARD = 65,                  /* BACKWARD  */
  YYSYMBOL_BAR = 66,                       /* BAR  */
  YYSYMBOL_BASED = 67,                     /* BASED  */
  YYSYMBOL_BEFORE = 68,                    /* BEFORE  */
  YYSYMBOL_BELL = 69,                      /* BELL  */
  YYSYMBOL_BINARY = 70,                    /* BINARY  */
  YYSYMBOL_BINARY_C_LONG = 71,             /* "BINARY-C-LONG"  */
  YYSYMBOL_BINARY_CHAR = 72,               /* "BINARY-CHAR"  */
  YYSYMBOL_BINARY_DOUBLE = 73,             /* "BINARY-DOUBLE"  */
  YYSYMBOL_BINARY_LONG = 74,               /* "BINARY-LONG"  */
  YYSYMBOL_BINARY_SEQUENTIAL = 75,         /* "BINARY-SEQUENTIAL"  */
  YYSYMBOL_BINARY_SHORT = 76,              /* "BINARY-SHORT"  */
  YYSYMBOL_BIT = 77,                       /* BIT  */
  YYSYMBOL_BITMAP = 78,                    /* BITMAP  */
  YYSYMBOL_BITMAP_END = 79,                /* "BITMAP-END"  */
  YYSYMBOL_BITMAP_HANDLE = 80,             /* "BITMAP-HANDLE"  */
  YYSYMBOL_BITMAP_NUMBER = 81,             /* "BITMAP-NUMBER"  */
  YYSYMBOL_BITMAP_START = 82,              /* "BITMAP-START"  */
  YYSYMBOL_BITMAP_TIMER = 83,              /* "BITMAP-TIMER"  */
  YYSYMBOL_BITMAP_TRAILING = 84,           /* "BITMAP-TRAILING"  */
  YYSYMBOL_BITMAP_TRANSPARENT_COLOR = 85,  /* "BITMAP-TRANSPARENT-COLOR"  */
  YYSYMBOL_BITMAP_WIDTH = 86,              /* "BITMAP-WIDTH"  */
  YYSYMBOL_BLANK = 87,                     /* BLANK  */
  YYSYMBOL_BLINK = 88,                     /* BLINK  */
  YYSYMBOL_BLOCK = 89,                     /* BLOCK  */
  YYSYMBOL_BOOLEAN = 90,                   /* BOOLEAN  */
  YYSYMBOL_BOTTOM = 91,                    /* BOTTOM  */
  YYSYMBOL_BOX = 92,                       /* BOX  */
  YYSYMBOL_BOXED = 93,                     /* BOXED  */
  YYSYMBOL_BULK_ADDITION = 94,             /* "BULK-ADDITION"  */
  YYSYMBOL_BUSY = 95,                      /* BUSY  */
  YYSYMBOL_BUTTONS = 96,                   /* BUTTONS  */
  YYSYMBOL_BY = 97,                        /* BY  */
  YYSYMBOL_BYTE_LENGTH = 98,               /* "BYTE-LENGTH"  */
  YYSYMBOL_C = 99,                         /* C  */
  YYSYMBOL_CALENDAR_FONT = 100,            /* "CALENDAR-FONT"  */
  YYSYMBOL_CALL = 101,                     /* CALL  */
  YYSYMBOL_CANCEL = 102,                   /* CANCEL  */
  YYSYMBOL_CANCEL_BUTTON = 103,            /* "CANCEL-BUTTON"  */
  YYSYMBOL_CAPACITY = 104,                 /* CAPACITY  */
  YYSYMBOL_CARD_PUNCH = 105,               /* "CARD-PUNCH"  */
  YYSYMBOL_CARD_READER = 106,              /* "CARD-READER"  */
  YYSYMBOL_CASSETTE = 107,                 /* CASSETTE  */
  YYSYMBOL_CCOL = 108,                     /* CCOL  */
  YYSYMBOL_CD = 109,                       /* CD  */
  YYSYMBOL_CELL = 110,                     /* CELL  */
  YYSYMBOL_CELL_COLOR = 111,               /* "CELL-COLOR"  */
  YYSYMBOL_CELL_DATA = 112,                /* "CELL-DATA"  */
  YYSYMBOL_CELL_FONT = 113,                /* "CELL-FONT"  */
  YYSYMBOL_CELL_PROTECTION = 114,          /* "CELL-PROTECTION"  */
  YYSYMBOL_CENTER = 115,                   /* CENTER  */
  YYSYMBOL_CENTERED = 116,                 /* CENTERED  */
  YYSYMBOL_CENTERED_HEADINGS = 117,        /* "CENTERED-HEADINGS"  */
  YYSYMBOL_CENTURY_DATE = 118,             /* "CENTURY-DATE"  */
  YYSYMBOL_CF = 119,                       /* CF  */
  YYSYMBOL_CH = 120,                       /* CH  */
  YYSYMBOL_CHAINING = 121,                 /* CHAINING  */
  YYSYMBOL_CHANGED = 122,                  /* CHANGED  */
  YYSYMBOL_CHARACTER = 123,                /* CHARACTER  */
  YYSYMBOL_CHARACTERS = 124,               /* CHARACTERS  */
  YYSYMBOL_CHECK_BOX = 125,                /* "CHECK-BOX"  */
  YYSYMBOL_CLASS = 126,                    /* CLASS  */
  YYSYMBOL_CLASSIFICATION = 127,           /* CLASSIFICATION  */
  YYSYMBOL_CLASS_NAME = 128,               /* "class-name"  */
  YYSYMBOL_CLEAR_SELECTION = 129,          /* "CLEAR-SELECTION"  */
  YYSYMBOL_CLINE = 130,                    /* CLINE  */
  YYSYMBOL_CLINES = 131,                   /* CLINES  */
  YYSYMBOL_CLOSE = 132,                    /* CLOSE  */
  YYSYMBOL_COBOL = 133,                    /* COBOL  */
  YYSYMBOL_CODE = 134,                     /* CODE  */
  YYSYMBOL_CODE_SET = 135,                 /* "CODE-SET"  */
  YYSYMBOL_COLLATING = 136,                /* COLLATING  */
  YYSYMBOL_COL = 137,                      /* COL  */
  YYSYMBOL_COLOR = 138,                    /* COLOR  */
  YYSYMBOL_COLORS = 139,                   /* COLORS  */
  YYSYMBOL_COLS = 140,                     /* COLS  */
  YYSYMBOL_COLUMN = 141,                   /* COLUMN  */
  YYSYMBOL_COLUMN_COLOR = 142,             /* "COLUMN-COLOR"  */
  YYSYMBOL_COLUMN_DIVIDERS = 143,          /* "COLUMN-DIVIDERS"  */
  YYSYMBOL_COLUMN_FONT = 144,              /* "COLUMN-FONT"  */
  YYSYMBOL_COLUMN_HEADINGS = 145,          /* "COLUMN-HEADINGS"  */
  YYSYMBOL_COLUMN_PROTECTION = 146,        /* "COLUMN-PROTECTION"  */
  YYSYMBOL_COLUMNS = 147,                  /* COLUMNS  */
  YYSYMBOL_COMBO_BOX = 148,                /* "COMBO-BOX"  */
  YYSYMBOL_COMMA = 149,                    /* COMMA  */
  YYSYMBOL_COMMAND_LINE = 150,             /* "COMMAND-LINE"  */
  YYSYMBOL_COMMA_DELIM = 151,              /* "comma delimiter"  */
  YYSYMBOL_COMMIT = 152,                   /* COMMIT  */
  YYSYMBOL_COMMON = 153,                   /* COMMON  */
  YYSYMBOL_COMMUNICATION = 154,            /* COMMUNICATION  */
  YYSYMBOL_COMP = 155,                     /* COMP  */
  YYSYMBOL_COMPUTE = 156,                  /* COMPUTE  */
  YYSYMBOL_COMP_0 = 157,                   /* "COMP-0"  */
  YYSYMBOL_COMP_1 = 158,                   /* "COMP-1"  */
  YYSYMBOL_COMP_2 = 159,                   /* "COMP-2"  */
  YYSYMBOL_COMP_3 = 160,                   /* "COMP-3"  */
  YYSYMBOL_COMP_4 = 161,                   /* "COMP-4"  */
  YYSYMBOL_COMP_5 = 162,                   /* "COMP-5"  */
  YYSYMBOL_COMP_6 = 163,                   /* "COMP-6"  */
  YYSYMBOL_COMP_N = 164,                   /* "COMP-N"  */
  YYSYMBOL_COMP_X = 165,                   /* "COMP-X"  */
  YYSYMBOL_CONCATENATE_FUNC = 166,         /* "FUNCTION CONCATENATE"  */
  YYSYMBOL_CONDITION = 167,                /* CONDITION  */
  YYSYMBOL_CONFIGURATION = 168,            /* CONFIGURATION  */
  YYSYMBOL_CONSTANT = 169,                 /* CONSTANT  */
  YYSYMBOL_CONTAINS = 170,                 /* CONTAINS  */
  YYSYMBOL_CONTENT = 171,                  /* CONTENT  */
  YYSYMBOL_CONTENT_LENGTH_FUNC = 172,      /* "FUNCTION CONTENT-LENGTH"  */
  YYSYMBOL_CONTENT_OF_FUNC = 173,          /* "FUNCTION CONTENT-OF"  */
  YYSYMBOL_CONTINUE = 174,                 /* CONTINUE  */
  YYSYMBOL_CONTROL = 175,                  /* CONTROL  */
  YYSYMBOL_CONTROLS = 176,                 /* CONTROLS  */
  YYSYMBOL_CONVERSION = 177,               /* CONVERSION  */
  YYSYMBOL_CONVERTING = 178,               /* CONVERTING  */
  YYSYMBOL_COPY = 179,                     /* COPY  */
  YYSYMBOL_COPY_SELECTION = 180,           /* "COPY-SELECTION"  */
  YYSYMBOL_CORE_INDEX = 181,               /* "CORE-INDEX"  */
  YYSYMBOL_CORRESPONDING = 182,            /* CORRESPONDING  */
  YYSYMBOL_COUNT = 183,                    /* COUNT  */
  YYSYMBOL_CRT = 184,                      /* CRT  */
  YYSYMBOL_CRT_UNDER = 185,                /* "CRT-UNDER"  */
  YYSYMBOL_CSIZE = 186,                    /* CSIZE  */
  YYSYMBOL_CURRENCY = 187,                 /* CURRENCY  */
  YYSYMBOL_CURRENT_DATE_FUNC = 188,        /* "FUNCTION CURRENT-DATE"  */
  YYSYMBOL_CURSOR = 189,                   /* CURSOR  */
  YYSYMBOL_CURSOR_COL = 190,               /* "CURSOR-COL"  */
  YYSYMBOL_CURSOR_COLOR = 191,             /* "CURSOR-COLOR"  */
  YYSYMBOL_CURSOR_FRAME_WIDTH = 192,       /* "CURSOR-FRAME-WIDTH"  */
  YYSYMBOL_CURSOR_ROW = 193,               /* "CURSOR-ROW"  */
  YYSYMBOL_CURSOR_X = 194,                 /* "CURSOR-X"  */
  YYSYMBOL_CURSOR_Y = 195,                 /* "CURSOR-Y"  */
  YYSYMBOL_CUSTOM_PRINT_TEMPLATE = 196,    /* "CUSTOM-PRINT-TEMPLATE"  */
  YYSYMBOL_CYCLE = 197,                    /* CYCLE  */
  YYSYMBOL_CYL_INDEX = 198,                /* "CYL-INDEX"  */
  YYSYMBOL_CYL_OVERFLOW = 199,             /* "CYL-OVERFLOW"  */
  YYSYMBOL_DASHED = 200,                   /* DASHED  */
  YYSYMBOL_DATA = 201,                     /* DATA  */
  YYSYMBOL_DATA_COLUMNS = 202,             /* "DATA-COLUMNS"  */
  YYSYMBOL_DATA_POINTER = 203,             /* "DATA-POINTER"  */
  YYSYMBOL_DATA_TYPES = 204,               /* "DATA-TYPES"  */
  YYSYMBOL_DATE = 205,                     /* DATE  */
  YYSYMBOL_DATE_COMPILED = 206,            /* "DATE-COMPILED"  */
  YYSYMBOL_DATE_ENTRY = 207,               /* "DATE-ENTRY"  */
  YYSYMBOL_DATE_MODIFIED = 208,            /* "DATE-MODIFIED"  */
  YYSYMBOL_DATE_WRITTEN = 209,             /* "DATE-WRITTEN"  */
  YYSYMBOL_DAY = 210,                      /* DAY  */
  YYSYMBOL_DAY_OF_WEEK = 211,              /* "DAY-OF-WEEK"  */
  YYSYMBOL_DE = 212,                       /* DE  */
  YYSYMBOL_DEBUGGING = 213,                /* DEBUGGING  */
  YYSYMBOL_DECIMAL_POINT = 214,            /* "DECIMAL-POINT"  */
  YYSYMBOL_DECLARATIVES = 215,             /* DECLARATIVES  */
  YYSYMBOL_DEFAULT = 216,                  /* DEFAULT  */
  YYSYMBOL_DEFAULT_BUTTON = 217,           /* "DEFAULT-BUTTON"  */
  YYSYMBOL_DEFAULT_FONT = 218,             /* "DEFAULT-FONT"  */
  YYSYMBOL_DELETE = 219,                   /* DELETE  */
  YYSYMBOL_DELIMITED = 220,                /* DELIMITED  */
  YYSYMBOL_DELIMITER = 221,                /* DELIMITER  */
  YYSYMBOL_DEPENDING = 222,                /* DEPENDING  */
  YYSYMBOL_DESCENDING = 223,               /* DESCENDING  */
  YYSYMBOL_DESTINATION = 224,              /* DESTINATION  */
  YYSYMBOL_DESTROY = 225,                  /* DESTROY  */
  YYSYMBOL_DETAIL = 226,                   /* DETAIL  */
  YYSYMBOL_DISABLE = 227,                  /* DISABLE  */
  YYSYMBOL_DISC = 228,                     /* DISC  */
  YYSYMBOL_DISK = 229,                     /* DISK  */
  YYSYMBOL_DISP = 230,                     /* DISP  */
  YYSYMBOL_DISPLAY = 231,                  /* DISPLAY  */
  YYSYMBOL_DISPLAY_1 = 232,                /* "DISPLAY-1"  */
  YYSYMBOL_DISPLAY_COLUMNS = 233,          /* "DISPLAY-COLUMNS"  */
  YYSYMBOL_DISPLAY_FORMAT = 234,           /* "DISPLAY-FORMAT"  */
  YYSYMBOL_DISPLAY_OF_FUNC = 235,          /* "FUNCTION DISPLAY-OF"  */
  YYSYMBOL_DIVIDE = 236,                   /* DIVIDE  */
  YYSYMBOL_DIVIDERS = 237,                 /* DIVIDERS  */
  YYSYMBOL_DIVIDER_COLOR = 238,            /* "DIVIDER-COLOR"  */
  YYSYMBOL_DIVISION = 239,                 /* DIVISION  */
  YYSYMBOL_DOTDASH = 240,                  /* DOTDASH  */
  YYSYMBOL_DOTTED = 241,                   /* DOTTED  */
  YYSYMBOL_DRAG_COLOR = 242,               /* "DRAG-COLOR"  */
  YYSYMBOL_DROP_DOWN = 243,                /* "DROP-DOWN"  */
  YYSYMBOL_DROP_LIST = 244,                /* "DROP-LIST"  */
  YYSYMBOL_DOWN = 245,                     /* DOWN  */
  YYSYMBOL_DUPLICATES = 246,               /* DUPLICATES  */
  YYSYMBOL_DYNAMIC = 247,                  /* DYNAMIC  */
  YYSYMBOL_EBCDIC = 248,                   /* EBCDIC  */
  YYSYMBOL_EC = 249,                       /* EC  */
  YYSYMBOL_ECHO = 250,                     /* ECHO  */
  YYSYMBOL_EGI = 251,                      /* EGI  */
  YYSYMBOL_EIGHTY_EIGHT = 252,             /* "level-number 88"  */
  YYSYMBOL_ENABLE = 253,                   /* ENABLE  */
  YYSYMBOL_ELEMENT = 254,                  /* ELEMENT  */
  YYSYMBOL_ELSE = 255,                     /* ELSE  */
  YYSYMBOL_EMI = 256,                      /* EMI  */
  YYSYMBOL_ENCRYPTION = 257,               /* ENCRYPTION  */
  YYSYMBOL_ENCODING = 258,                 /* ENCODING  */
  YYSYMBOL_END = 259,                      /* END  */
  YYSYMBOL_END_ACCEPT = 260,               /* "END-ACCEPT"  */
  YYSYMBOL_END_ADD = 261,                  /* "END-ADD"  */
  YYSYMBOL_END_CALL = 262,                 /* "END-CALL"  */
  YYSYMBOL_END_COMPUTE = 263,              /* "END-COMPUTE"  */
  YYSYMBOL_END_COLOR = 264,                /* "END-COLOR"  */
  YYSYMBOL_END_DELETE = 265,               /* "END-DELETE"  */
  YYSYMBOL_END_DISPLAY = 266,              /* "END-DISPLAY"  */
  YYSYMBOL_END_DIVIDE = 267,               /* "END-DIVIDE"  */
  YYSYMBOL_END_EVALUATE = 268,             /* "END-EVALUATE"  */
  YYSYMBOL_END_FUNCTION = 269,             /* "END FUNCTION"  */
  YYSYMBOL_END_IF = 270,                   /* "END-IF"  */
  YYSYMBOL_END_JSON = 271,                 /* "END-JSON"  */
  YYSYMBOL_END_MODIFY = 272,               /* "END-MODIFY"  */
  YYSYMBOL_END_MULTIPLY = 273,             /* "END-MULTIPLY"  */
  YYSYMBOL_END_PERFORM = 274,              /* "END-PERFORM"  */
  YYSYMBOL_END_PROGRAM = 275,              /* "END PROGRAM"  */
  YYSYMBOL_END_READ = 276,                 /* "END-READ"  */
  YYSYMBOL_END_RECEIVE = 277,              /* "END-RECEIVE"  */
  YYSYMBOL_END_RETURN = 278,               /* "END-RETURN"  */
  YYSYMBOL_END_REWRITE = 279,              /* "END-REWRITE"  */
  YYSYMBOL_END_SEARCH = 280,               /* "END-SEARCH"  */
  YYSYMBOL_END_SEND = 281,                 /* "END-SEND"  */
  YYSYMBOL_END_START = 282,                /* "END-START"  */
  YYSYMBOL_END_STRING = 283,               /* "END-STRING"  */
  YYSYMBOL_END_SUBTRACT = 284,             /* "END-SUBTRACT"  */
  YYSYMBOL_END_UNSTRING = 285,             /* "END-UNSTRING"  */
  YYSYMBOL_END_WRITE = 286,                /* "END-WRITE"  */
  YYSYMBOL_END_XML = 287,                  /* "END-XML"  */
  YYSYMBOL_ENGRAVED = 288,                 /* ENGRAVED  */
  YYSYMBOL_ENSURE_VISIBLE = 289,           /* "ENSURE-VISIBLE"  */
  YYSYMBOL_ENTRY = 290,                    /* ENTRY  */
  YYSYMBOL_ENTRY_CONVENTION = 291,         /* "ENTRY-CONVENTION"  */
  YYSYMBOL_ENTRY_FIELD = 292,              /* "ENTRY-FIELD"  */
  YYSYMBOL_ENTRY_REASON = 293,             /* "ENTRY-REASON"  */
  YYSYMBOL_ENVIRONMENT = 294,              /* ENVIRONMENT  */
  YYSYMBOL_ENVIRONMENT_NAME = 295,         /* "ENVIRONMENT-NAME"  */
  YYSYMBOL_ENVIRONMENT_VALUE = 296,        /* "ENVIRONMENT-VALUE"  */
  YYSYMBOL_EOL = 297,                      /* EOL  */
  YYSYMBOL_EOP = 298,                      /* EOP  */
  YYSYMBOL_EOS = 299,                      /* EOS  */
  YYSYMBOL_EQUAL = 300,                    /* EQUAL  */
  YYSYMBOL_ERASE = 301,                    /* ERASE  */
  YYSYMBOL_ERROR = 302,                    /* ERROR  */
  YYSYMBOL_ESCAPE = 303,                   /* ESCAPE  */
  YYSYMBOL_ESCAPE_BUTTON = 304,            /* "ESCAPE-BUTTON"  */
  YYSYMBOL_ESI = 305,                      /* ESI  */
  YYSYMBOL_EVALUATE = 306,                 /* EVALUATE  */
  YYSYMBOL_EVENT = 307,                    /* EVENT  */
  YYSYMBOL_EVENT_LIST = 308,               /* "EVENT-LIST"  */
  YYSYMBOL_EVENT_STATUS = 309,             /* "EVENT STATUS"  */
  YYSYMBOL_EVERY = 310,                    /* EVERY  */
  YYSYMBOL_EXAMINE = 311,                  /* EXAMINE  */
  YYSYMBOL_EXCEPTION = 312,                /* EXCEPTION  */
  YYSYMBOL_EXCEPTION_CONDITION = 313,      /* "EXCEPTION CONDITION"  */
  YYSYMBOL_EXCEPTION_VALUE = 314,          /* "EXCEPTION-VALUE"  */
  YYSYMBOL_EXPAND = 315,                   /* EXPAND  */
  YYSYMBOL_EXCLUSIVE = 316,                /* EXCLUSIVE  */
  YYSYMBOL_EXHIBIT = 317,                  /* EXHIBIT  */
  YYSYMBOL_EXIT = 318,                     /* EXIT  */
  YYSYMBOL_EXPONENTIATION = 319,           /* "exponentiation operator"  */
  YYSYMBOL_EXTEND = 320,                   /* EXTEND  */
  YYSYMBOL_EXTENDED_SEARCH = 321,          /* "EXTENDED-SEARCH"  */
  YYSYMBOL_EXTERNAL = 322,                 /* EXTERNAL  */
  YYSYMBOL_EXTERNAL_FORM = 323,            /* "EXTERNAL-FORM"  */
  YYSYMBOL_F = 324,                        /* F  */
  YYSYMBOL_FACTORY = 325,                  /* FACTORY  */
  YYSYMBOL_FD = 326,                       /* FD  */
  YYSYMBOL_FH__FCD = 327,                  /* "FH--FCD"  */
  YYSYMBOL_FH__KEYDEF = 328,               /* "FH--KEYDEF"  */
  YYSYMBOL_FILE_CONTROL = 329,             /* "FILE-CONTROL"  */
  YYSYMBOL_FILE_ID = 330,                  /* "FILE-ID"  */
  YYSYMBOL_FILE_LIMIT = 331,               /* "FILE-LIMIT"  */
  YYSYMBOL_FILE_LIMITS = 332,              /* "FILE-LIMITS"  */
  YYSYMBOL_FILE_NAME = 333,                /* "FILE-NAME"  */
  YYSYMBOL_FILE_POS = 334,                 /* "FILE-POS"  */
  YYSYMBOL_FILL_COLOR = 335,               /* "FILL-COLOR"  */
  YYSYMBOL_FILL_COLOR2 = 336,              /* "FILL-COLOR2"  */
  YYSYMBOL_FILL_PERCENT = 337,             /* "FILL-PERCENT"  */
  YYSYMBOL_FILLER = 338,                   /* FILLER  */
  YYSYMBOL_FINAL = 339,                    /* FINAL  */
  YYSYMBOL_FINISH_REASON = 340,            /* "FINISH-REASON"  */
  YYSYMBOL_FIRST = 341,                    /* FIRST  */
  YYSYMBOL_FIXED = 342,                    /* FIXED  */
  YYSYMBOL_FIXED_FONT = 343,               /* "FIXED-FONT"  */
  YYSYMBOL_FIXED_WIDTH = 344,              /* "FIXED-WIDTH"  */
  YYSYMBOL_FLAT = 345,                     /* FLAT  */
  YYSYMBOL_FLAT_BUTTONS = 346,             /* "FLAT-BUTTONS"  */
  YYSYMBOL_FLOAT_BINARY_128 = 347,         /* "FLOAT-BINARY-128"  */
  YYSYMBOL_FLOAT_BINARY_32 = 348,          /* "FLOAT-BINARY-32"  */
  YYSYMBOL_FLOAT_BINARY_64 = 349,          /* "FLOAT-BINARY-64"  */
  YYSYMBOL_FLOAT_DECIMAL_16 = 350,         /* "FLOAT-DECIMAL-16"  */
  YYSYMBOL_FLOAT_DECIMAL_34 = 351,         /* "FLOAT-DECIMAL-34"  */
  YYSYMBOL_FLOAT_DECIMAL_7 = 352,          /* "FLOAT-DECIMAL-7"  */
  YYSYMBOL_FLOAT_EXTENDED = 353,           /* "FLOAT-EXTENDED"  */
  YYSYMBOL_FLOAT_LONG = 354,               /* "FLOAT-LONG"  */
  YYSYMBOL_FLOAT_SHORT = 355,              /* "FLOAT-SHORT"  */
  YYSYMBOL_FLOATING = 356,                 /* FLOATING  */
  YYSYMBOL_FONT = 357,                     /* FONT  */
  YYSYMBOL_FOOTING = 358,                  /* FOOTING  */
  YYSYMBOL_FOR = 359,                      /* FOR  */
  YYSYMBOL_FOREGROUND_COLOR = 360,         /* "FOREGROUND-COLOR"  */
  YYSYMBOL_FOREVER = 361,                  /* FOREVER  */
  YYSYMBOL_FORMAT = 362,                   /* FORMAT  */
  YYSYMBOL_FORMATTED_DATE_FUNC = 363,      /* "FUNCTION FORMATTED-DATE"  */
  YYSYMBOL_FORMATTED_DATETIME_FUNC = 364,  /* "FUNCTION FORMATTED-DATETIME"  */
  YYSYMBOL_FORMATTED_TIME_FUNC = 365,      /* "FUNCTION FORMATTED-TIME"  */
  YYSYMBOL_FRAME = 366,                    /* FRAME  */
  YYSYMBOL_FRAMED = 367,                   /* FRAMED  */
  YYSYMBOL_FREE = 368,                     /* FREE  */
  YYSYMBOL_FROM = 369,                     /* FROM  */
  YYSYMBOL_FROM_CRT = 370,                 /* "FROM CRT"  */
  YYSYMBOL_FULL = 371,                     /* FULL  */
  YYSYMBOL_FULL_HEIGHT = 372,              /* "FULL-HEIGHT"  */
  YYSYMBOL_FUNCTION = 373,                 /* FUNCTION  */
  YYSYMBOL_FUNCTION_ID = 374,              /* "FUNCTION-ID"  */
  YYSYMBOL_FUNCTION_NAME = 375,            /* "intrinsic function name"  */
  YYSYMBOL_FUNCTION_POINTER = 376,         /* "FUNCTION-POINTER"  */
  YYSYMBOL_GENERATE = 377,                 /* GENERATE  */
  YYSYMBOL_GIVING = 378,                   /* GIVING  */
  YYSYMBOL_GLOBAL = 379,                   /* GLOBAL  */
  YYSYMBOL_GO = 380,                       /* GO  */
  YYSYMBOL_GO_BACK = 381,                  /* "GO-BACK"  */
  YYSYMBOL_GO_FORWARD = 382,               /* "GO-FORWARD"  */
  YYSYMBOL_GO_HOME = 383,                  /* "GO-HOME"  */
  YYSYMBOL_GO_SEARCH = 384,                /* "GO-SEARCH"  */
  YYSYMBOL_GOBACK = 385,                   /* GOBACK  */
  YYSYMBOL_GRAPHICAL = 386,                /* GRAPHICAL  */
  YYSYMBOL_GREATER = 387,                  /* GREATER  */
  YYSYMBOL_GREATER_OR_EQUAL = 388,         /* "GREATER OR EQUAL"  */
  YYSYMBOL_GRID = 389,                     /* GRID  */
  YYSYMBOL_GROUP = 390,                    /* GROUP  */
  YYSYMBOL_GROUP_VALUE = 391,              /* "GROUP-VALUE"  */
  YYSYMBOL_HANDLE = 392,                   /* HANDLE  */
  YYSYMBOL_HAS_CHILDREN = 393,             /* "HAS-CHILDREN"  */
  YYSYMBOL_HEADING = 394,                  /* HEADING  */
  YYSYMBOL_HEADING_COLOR = 395,            /* "HEADING-COLOR"  */
  YYSYMBOL_HEADING_DIVIDER_COLOR = 396,    /* "HEADING-DIVIDER-COLOR"  */
  YYSYMBOL_HEADING_FONT = 397,             /* "HEADING-FONT"  */
  YYSYMBOL_HEAVY = 398,                    /* HEAVY  */
  YYSYMBOL_HEIGHT_IN_CELLS = 399,          /* "HEIGHT-IN-CELLS"  */
  YYSYMBOL_HIDDEN_DATA = 400,              /* "HIDDEN-DATA"  */
  YYSYMBOL_HIGHLIGHT = 401,                /* HIGHLIGHT  */
  YYSYMBOL_HIGH_COLOR = 402,               /* "HIGH-COLOR"  */
  YYSYMBOL_HIGH_VALUE = 403,               /* "HIGH-VALUE"  */
  YYSYMBOL_HOT_TRACK = 404,                /* "HOT-TRACK"  */
  YYSYMBOL_HSCROLL = 405,                  /* HSCROLL  */
  YYSYMBOL_HSCROLL_POS = 406,              /* "HSCROLL-POS"  */
  YYSYMBOL_ICON = 407,                     /* ICON  */
  YYSYMBOL_ID = 408,                       /* ID  */
  YYSYMBOL_IDENTIFIED = 409,               /* IDENTIFIED  */
  YYSYMBOL_IDENTIFICATION = 410,           /* IDENTIFICATION  */
  YYSYMBOL_IF = 411,                       /* IF  */
  YYSYMBOL_IGNORE = 412,                   /* IGNORE  */
  YYSYMBOL_IGNORING = 413,                 /* IGNORING  */
  YYSYMBOL_IN = 414,                       /* IN  */
  YYSYMBOL_INDEPENDENT = 415,              /* INDEPENDENT  */
  YYSYMBOL_INDEX = 416,                    /* INDEX  */
  YYSYMBOL_INDEXED = 417,                  /* INDEXED  */
  YYSYMBOL_INDICATE = 418,                 /* INDICATE  */
  YYSYMBOL_INITIALIZE = 419,               /* INITIALIZE  */
  YYSYMBOL_INITIALIZED = 420,              /* INITIALIZED  */
  YYSYMBOL_INITIATE = 421,                 /* INITIATE  */
  YYSYMBOL_INPUT = 422,                    /* INPUT  */
  YYSYMBOL_INPUT_OUTPUT = 423,             /* "INPUT-OUTPUT"  */
  YYSYMBOL_INQUIRE = 424,                  /* INQUIRE  */
  YYSYMBOL_INSERTION_INDEX = 425,          /* "INSERTION-INDEX"  */
  YYSYMBOL_INSERT_ROWS = 426,              /* "INSERT-ROWS"  */
  YYSYMBOL_INSPECT = 427,                  /* INSPECT  */
  YYSYMBOL_INSTALLATION = 428,             /* INSTALLATION  */
  YYSYMBOL_INTERMEDIATE = 429,             /* INTERMEDIATE  */
  YYSYMBOL_INTO = 430,                     /* INTO  */
  YYSYMBOL_INTRINSIC = 431,                /* INTRINSIC  */
  YYSYMBOL_INVALID = 432,                  /* INVALID  */
  YYSYMBOL_INVALID_KEY = 433,              /* "INVALID KEY"  */
  YYSYMBOL_IS = 434,                       /* IS  */
  YYSYMBOL_ITEM = 435,                     /* ITEM  */
  YYSYMBOL_ITEM_TEXT = 436,                /* "ITEM-TEXT"  */
  YYSYMBOL_ITEM_TO_ADD = 437,              /* "ITEM-TO_ADD"  */
  YYSYMBOL_ITEM_TO_DELETE = 438,           /* "ITEM-TO_DELETE"  */
  YYSYMBOL_ITEM_TO_EMPTY = 439,            /* "ITEM-TO_EMPTY"  */
  YYSYMBOL_ITEM_VALUE = 440,               /* "ITEM-VALUE"  */
  YYSYMBOL_I_O = 441,                      /* "I-O"  */
  YYSYMBOL_I_O_CONTROL = 442,              /* "I-O-CONTROL"  */
  YYSYMBOL_JSON = 443,                     /* JSON  */
  YYSYMBOL_JUSTIFIED = 444,                /* JUSTIFIED  */
  YYSYMBOL_KEPT = 445,                     /* KEPT  */
  YYSYMBOL_KEY = 446,                      /* KEY  */
  YYSYMBOL_KEYBOARD = 447,                 /* KEYBOARD  */
  YYSYMBOL_LABEL = 448,                    /* LABEL  */
  YYSYMBOL_LABEL_OFFSET = 449,             /* "LABEL-OFFSET"  */
  YYSYMBOL_LARGE_FONT = 450,               /* "LARGE-FONT"  */
  YYSYMBOL_LARGE_OFFSET = 451,             /* "LARGE-OFFSET"  */
  YYSYMBOL_LAST = 452,                     /* LAST  */
  YYSYMBOL_LAST_ROW = 453,                 /* "LAST-ROW"  */
  YYSYMBOL_LAYOUT_DATA = 454,              /* "LAYOUT-DATA"  */
  YYSYMBOL_LAYOUT_MANAGER = 455,           /* "LAYOUT-MANAGER"  */
  YYSYMBOL_LEADING = 456,                  /* LEADING  */
  YYSYMBOL_LEADING_SHIFT = 457,            /* "LEADING-SHIFT"  */
  YYSYMBOL_LEAVE = 458,                    /* LEAVE  */
  YYSYMBOL_LEFT = 459,                     /* LEFT  */
  YYSYMBOL_LEFTLINE = 460,                 /* LEFTLINE  */
  YYSYMBOL_LEFT_TEXT = 461,                /* "LEFT-TEXT"  */
  YYSYMBOL_LENGTH = 462,                   /* LENGTH  */
  YYSYMBOL_LENGTH_OF = 463,                /* "LENGTH OF"  */
  YYSYMBOL_LENGTH_FUNC = 464,              /* "FUNCTION LENGTH/BYTE-LENGTH"  */
  YYSYMBOL_LESS = 465,                     /* LESS  */
  YYSYMBOL_LESS_OR_EQUAL = 466,            /* "LESS OR EQUAL"  */
  YYSYMBOL_LEVEL_NUMBER = 467,             /* "level-number"  */
  YYSYMBOL_LIKE = 468,                     /* LIKE  */
  YYSYMBOL_LIMIT = 469,                    /* LIMIT  */
  YYSYMBOL_LIMITS = 470,                   /* LIMITS  */
  YYSYMBOL_LINAGE = 471,                   /* LINAGE  */
  YYSYMBOL_LINAGE_COUNTER = 472,           /* "LINAGE-COUNTER"  */
  YYSYMBOL_LINE = 473,                     /* LINE  */
  YYSYMBOL_LINE_COUNTER = 474,             /* "LINE-COUNTER"  */
  YYSYMBOL_LINE_LIMIT = 475,               /* "LINE LIMIT"  */
  YYSYMBOL_LINE_SEQUENTIAL = 476,          /* "LINE-SEQUENTIAL"  */
  YYSYMBOL_LINES = 477,                    /* LINES  */
  YYSYMBOL_LINES_AT_ROOT = 478,            /* "LINES-AT-ROOT"  */
  YYSYMBOL_LINKAGE = 479,                  /* LINKAGE  */
  YYSYMBOL_LIST_BOX = 480,                 /* "LIST-BOX"  */
  YYSYMBOL_LITERAL = 481,                  /* "Literal"  */
  YYSYMBOL_LM_RESIZE = 482,                /* "LM-RESIZE"  */
  YYSYMBOL_LOC = 483,                      /* LOC  */
  YYSYMBOL_LOCALE = 484,                   /* LOCALE  */
  YYSYMBOL_LOCALE_DATE_FUNC = 485,         /* "FUNCTION LOCALE-DATE"  */
  YYSYMBOL_LOCALE_TIME_FUNC = 486,         /* "FUNCTION LOCALE-TIME"  */
  YYSYMBOL_LOCALE_TIME_FROM_FUNC = 487,    /* "FUNCTION LOCALE-TIME-FROM-SECONDS"  */
  YYSYMBOL_LOCAL_STORAGE = 488,            /* "LOCAL-STORAGE"  */
  YYSYMBOL_LOCK = 489,                     /* LOCK  */
  YYSYMBOL_LOCK_HOLDING = 490,             /* "LOCK-HOLDING"  */
  YYSYMBOL_LONG_DATE = 491,                /* "LONG-DATE"  */
  YYSYMBOL_LOWER = 492,                    /* LOWER  */
  YYSYMBOL_LOWERED = 493,                  /* LOWERED  */
  YYSYMBOL_LOWER_CASE_FUNC = 494,          /* "FUNCTION LOWER-CASE"  */
  YYSYMBOL_LOWLIGHT = 495,                 /* LOWLIGHT  */
  YYSYMBOL_LOW_COLOR = 496,                /* "LOW-COLOR"  */
  YYSYMBOL_LOW_VALUE = 497,                /* "LOW-VALUE"  */
  YYSYMBOL_MAGNETIC_TAPE = 498,            /* "MAGNETIC-TAPE"  */
  YYSYMBOL_MANUAL = 499,                   /* MANUAL  */
  YYSYMBOL_MASS_UPDATE = 500,              /* "MASS-UPDATE"  */
  YYSYMBOL_MASTER_INDEX = 501,             /* "MASTER-INDEX"  */
  YYSYMBOL_MAX_LINES = 502,                /* "MAX-LINES"  */
  YYSYMBOL_MAX_PROGRESS = 503,             /* "MAX-PROGRESS"  */
  YYSYMBOL_MAX_TEXT = 504,                 /* "MAX-TEXT"  */
  YYSYMBOL_MAX_VAL = 505,                  /* "MAX-VAL"  */
  YYSYMBOL_MEMORY = 506,                   /* MEMORY  */
  YYSYMBOL_MEDIUM_FONT = 507,              /* "MEDIUM-FONT"  */
  YYSYMBOL_MENU = 508,                     /* MENU  */
  YYSYMBOL_MERGE = 509,                    /* MERGE  */
  YYSYMBOL_MESSAGE = 510,                  /* MESSAGE  */
  YYSYMBOL_MICROSECOND_TIME = 511,         /* "MICROSECOND-TIME"  */
  YYSYMBOL_MINUS = 512,                    /* MINUS  */
  YYSYMBOL_MIN_VAL = 513,                  /* "MIN-VAL"  */
  YYSYMBOL_MNEMONIC_NAME = 514,            /* "Mnemonic name"  */
  YYSYMBOL_MODE = 515,                     /* MODE  */
  YYSYMBOL_MODIFY = 516,                   /* MODIFY  */
  YYSYMBOL_MODULES = 517,                  /* MODULES  */
  YYSYMBOL_MOVE = 518,                     /* MOVE  */
  YYSYMBOL_MULTILINE = 519,                /* MULTILINE  */
  YYSYMBOL_MULTIPLE = 520,                 /* MULTIPLE  */
  YYSYMBOL_MULTIPLY = 521,                 /* MULTIPLY  */
  YYSYMBOL_NAME = 522,                     /* NAME  */
  YYSYMBOL_NAMED = 523,                    /* NAMED  */
  YYSYMBOL_NAMESPACE = 524,                /* NAMESPACE  */
  YYSYMBOL_NAMESPACE_PREFIX = 525,         /* "NAMESPACE-PREFIX"  */
  YYSYMBOL_NATIONAL = 526,                 /* NATIONAL  */
  YYSYMBOL_NATIONAL_EDITED = 527,          /* "NATIONAL-EDITED"  */
  YYSYMBOL_NATIONAL_OF_FUNC = 528,         /* "FUNCTION NATIONAL-OF"  */
  YYSYMBOL_NATIVE = 529,                   /* NATIVE  */
  YYSYMBOL_NAVIGATE_URL = 530,             /* "NAVIGATE-URL"  */
  YYSYMBOL_NEAREST_AWAY_FROM_ZERO = 531,   /* "NEAREST-AWAY-FROM-ZERO"  */
  YYSYMBOL_NEAREST_EVEN = 532,             /* "NEAREST-EVEN"  */
  YYSYMBOL_NEAREST_TOWARD_ZERO = 533,      /* "NEAREST-TOWARD-ZERO"  */
  YYSYMBOL_NEGATIVE = 534,                 /* NEGATIVE  */
  YYSYMBOL_NESTED = 535,                   /* NESTED  */
  YYSYMBOL_NEW = 536,                      /* NEW  */
  YYSYMBOL_NEXT = 537,                     /* NEXT  */
  YYSYMBOL_NEXT_ITEM = 538,                /* "NEXT-ITEM"  */
  YYSYMBOL_NEXT_GROUP = 539,               /* "NEXT GROUP"  */
  YYSYMBOL_NEXT_PAGE = 540,                /* "NEXT PAGE"  */
  YYSYMBOL_NO = 541,                       /* NO  */
  YYSYMBOL_NO_ADVANCING = 542,             /* "NO ADVANCING"  */
  YYSYMBOL_NO_AUTOSEL = 543,               /* "NO-AUTOSEL"  */
  YYSYMBOL_NO_AUTO_DEFAULT = 544,          /* "NO-AUTO-DEFAULT"  */
  YYSYMBOL_NO_BOX = 545,                   /* "NO-BOX"  */
  YYSYMBOL_NO_DATA = 546,                  /* "NO DATA"  */
  YYSYMBOL_NO_DIVIDERS = 547,              /* "NO-DIVIDERS"  */
  YYSYMBOL_NO_ECHO = 548,                  /* "NO-ECHO"  */
  YYSYMBOL_NO_F4 = 549,                    /* "NO-F4"  */
  YYSYMBOL_NO_FOCUS = 550,                 /* "NO-FOCUS"  */
  YYSYMBOL_NO_GROUP_TAB = 551,             /* "NO-GROUP-TAB"  */
  YYSYMBOL_NO_KEY_LETTER = 552,            /* "NO-KEY-LETTER"  */
  YYSYMBOL_NO_SEARCH = 553,                /* "NO-SEARCH"  */
  YYSYMBOL_NO_UPDOWN = 554,                /* "NO-UPDOWN"  */
  YYSYMBOL_NOMINAL = 555,                  /* NOMINAL  */
  YYSYMBOL_NONE = 556,                     /* NONE  */
  YYSYMBOL_NONNUMERIC = 557,               /* NONNUMERIC  */
  YYSYMBOL_NORMAL = 558,                   /* NORMAL  */
  YYSYMBOL_NOT = 559,                      /* NOT  */
  YYSYMBOL_NOTAB = 560,                    /* NOTAB  */
  YYSYMBOL_NOTHING = 561,                  /* NOTHING  */
  YYSYMBOL_NOTIFY = 562,                   /* NOTIFY  */
  YYSYMBOL_NOTIFY_CHANGE = 563,            /* "NOTIFY-CHANGE"  */
  YYSYMBOL_NOTIFY_DBLCLICK = 564,          /* "NOTIFY-DBLCLICK"  */
  YYSYMBOL_NOTIFY_SELCHANGE = 565,         /* "NOTIFY-SELCHANGE"  */
  YYSYMBOL_NOT_AT_END = 566,               /* "NOT AT END"  */
  YYSYMBOL_NOT_EOP = 567,                  /* "NOT AT EOP"  */
  YYSYMBOL_NOT_ON_ESCAPE = 568,            /* "NOT ON ESCAPE"  */
  YYSYMBOL_NOT_EQUAL = 569,                /* "NOT EQUAL"  */
  YYSYMBOL_NOT_ON_EXCEPTION = 570,         /* "NOT ON EXCEPTION"  */
  YYSYMBOL_NOT_INVALID_KEY = 571,          /* "NOT INVALID KEY"  */
  YYSYMBOL_NOT_ON_OVERFLOW = 572,          /* "NOT ON OVERFLOW"  */
  YYSYMBOL_NOT_SIZE_ERROR = 573,           /* "NOT SIZE ERROR"  */
  YYSYMBOL_NUM_COL_HEADINGS = 574,         /* "NUM-COL-HEADINGS"  */
  YYSYMBOL_NUM_ROWS = 575,                 /* "NUM-ROWS"  */
  YYSYMBOL_NUMBER = 576,                   /* NUMBER  */
  YYSYMBOL_NUMBERS = 577,                  /* NUMBERS  */
  YYSYMBOL_NUMERIC = 578,                  /* NUMERIC  */
  YYSYMBOL_NUMERIC_EDITED = 579,           /* "NUMERIC-EDITED"  */
  YYSYMBOL_NUMVALC_FUNC = 580,             /* "FUNCTION NUMVAL-C"  */
  YYSYMBOL_OBJECT = 581,                   /* OBJECT  */
  YYSYMBOL_OBJECT_COMPUTER = 582,          /* "OBJECT-COMPUTER"  */
  YYSYMBOL_OCCURS = 583,                   /* OCCURS  */
  YYSYMBOL_OF = 584,                       /* OF  */
  YYSYMBOL_OFF = 585,                      /* OFF  */
  YYSYMBOL_OK_BUTTON = 586,                /* "OK-BUTTON"  */
  YYSYMBOL_OMITTED = 587,                  /* OMITTED  */
  YYSYMBOL_ON = 588,                       /* ON  */
  YYSYMBOL_ONLY = 589,                     /* ONLY  */
  YYSYMBOL_ON_ESCAPE = 590,                /* "ON ESCAPE"  */
  YYSYMBOL_ON_EXCEPTION = 591,             /* "ON EXCEPTION"  */
  YYSYMBOL_OPEN = 592,                     /* OPEN  */
  YYSYMBOL_OPTIONAL = 593,                 /* OPTIONAL  */
  YYSYMBOL_OPTIONS = 594,                  /* OPTIONS  */
  YYSYMBOL_OR = 595,                       /* OR  */
  YYSYMBOL_ORDER = 596,                    /* ORDER  */
  YYSYMBOL_ORGANIZATION = 597,             /* ORGANIZATION  */
  YYSYMBOL_OTHER = 598,                    /* OTHER  */
  YYSYMBOL_OTHERS = 599,                   /* OTHERS  */
  YYSYMBOL_OUTPUT = 600,                   /* OUTPUT  */
  YYSYMBOL_OVERLAP_LEFT = 601,             /* "OVERLAP-LEFT"  */
  YYSYMBOL_OVERLAP_TOP = 602,              /* "OVERLAP-TOP"  */
  YYSYMBOL_OVERLINE = 603,                 /* OVERLINE  */
  YYSYMBOL_PACKED_DECIMAL = 604,           /* "PACKED-DECIMAL"  */
  YYSYMBOL_PADDING = 605,                  /* PADDING  */
  YYSYMBOL_PASCAL = 606,                   /* PASCAL  */
  YYSYMBOL_PAGE = 607,                     /* PAGE  */
  YYSYMBOL_PAGE_COUNTER = 608,             /* "PAGE-COUNTER"  */
  YYSYMBOL_PAGE_SETUP = 609,               /* "PAGE-SETUP"  */
  YYSYMBOL_PAGED = 610,                    /* PAGED  */
  YYSYMBOL_PARAGRAPH = 611,                /* PARAGRAPH  */
  YYSYMBOL_PARENT = 612,                   /* PARENT  */
  YYSYMBOL_PARSE = 613,                    /* PARSE  */
  YYSYMBOL_PASSWORD = 614,                 /* PASSWORD  */
  YYSYMBOL_PERFORM = 615,                  /* PERFORM  */
  YYSYMBOL_PERMANENT = 616,                /* PERMANENT  */
  YYSYMBOL_PH = 617,                       /* PH  */
  YYSYMBOL_PF = 618,                       /* PF  */
  YYSYMBOL_PHYSICAL = 619,                 /* PHYSICAL  */
  YYSYMBOL_PICTURE = 620,                  /* PICTURE  */
  YYSYMBOL_PICTURE_SYMBOL = 621,           /* "PICTURE SYMBOL"  */
  YYSYMBOL_PIXEL = 622,                    /* PIXEL  */
  YYSYMBOL_PLACEMENT = 623,                /* PLACEMENT  */
  YYSYMBOL_PLUS = 624,                     /* PLUS  */
  YYSYMBOL_POINTER = 625,                  /* POINTER  */
  YYSYMBOL_POP_UP = 626,                   /* "POP-UP"  */
  YYSYMBOL_POS = 627,                      /* POS  */
  YYSYMBOL_POSITION = 628,                 /* POSITION  */
  YYSYMBOL_POSITION_SHIFT = 629,           /* "POSITION-SHIFT"  */
  YYSYMBOL_POSITIVE = 630,                 /* POSITIVE  */
  YYSYMBOL_PRESENT = 631,                  /* PRESENT  */
  YYSYMBOL_PREVIOUS = 632,                 /* PREVIOUS  */
  YYSYMBOL_PRINT = 633,                    /* PRINT  */
  YYSYMBOL_PRINT_CONTROL = 634,            /* "PRINT-CONTROL"  */
  YYSYMBOL_PRINT_NO_PROMPT = 635,          /* "PRINT-NO-PROMPT"  */
  YYSYMBOL_PRINT_PREVIEW = 636,            /* "PRINT-PREVIEW"  */
  YYSYMBOL_PRINTER = 637,                  /* PRINTER  */
  YYSYMBOL_PRINTER_1 = 638,                /* "PRINTER-1"  */
  YYSYMBOL_PRINTING = 639,                 /* PRINTING  */
  YYSYMBOL_PRIORITY = 640,                 /* PRIORITY  */
  YYSYMBOL_PROCEDURE = 641,                /* PROCEDURE  */
  YYSYMBOL_PROCEDURES = 642,               /* PROCEDURES  */
  YYSYMBOL_PROCEED = 643,                  /* PROCEED  */
  YYSYMBOL_PROCESSING = 644,               /* PROCESSING  */
  YYSYMBOL_PROGRAM = 645,                  /* PROGRAM  */
  YYSYMBOL_PROGRAM_ID = 646,               /* "PROGRAM-ID"  */
  YYSYMBOL_PROGRAM_NAME = 647,             /* "program name"  */
  YYSYMBOL_PROGRAM_POINTER = 648,          /* "PROGRAM-POINTER"  */
  YYSYMBOL_PROGRESS = 649,                 /* PROGRESS  */
  YYSYMBOL_PROHIBITED = 650,               /* PROHIBITED  */
  YYSYMBOL_PROMPT = 651,                   /* PROMPT  */
  YYSYMBOL_PROPERTIES = 652,               /* PROPERTIES  */
  YYSYMBOL_PROPERTY = 653,                 /* PROPERTY  */
  YYSYMBOL_PROTECTED = 654,                /* PROTECTED  */
  YYSYMBOL_PROTOTYPE = 655,                /* PROTOTYPE  */
  YYSYMBOL_PURGE = 656,                    /* PURGE  */
  YYSYMBOL_PUSH_BUTTON = 657,              /* "PUSH-BUTTON"  */
  YYSYMBOL_QUERY_INDEX = 658,              /* "QUERY-INDEX"  */
  YYSYMBOL_QUEUE = 659,                    /* QUEUE  */
  YYSYMBOL_QUOTE = 660,                    /* QUOTE  */
  YYSYMBOL_RADIO_BUTTON = 661,             /* "RADIO-BUTTON"  */
  YYSYMBOL_RAISE = 662,                    /* RAISE  */
  YYSYMBOL_RAISED = 663,                   /* RAISED  */
  YYSYMBOL_RAISING = 664,                  /* RAISING  */
  YYSYMBOL_RANDOM = 665,                   /* RANDOM  */
  YYSYMBOL_RD = 666,                       /* RD  */
  YYSYMBOL_READ = 667,                     /* READ  */
  YYSYMBOL_READERS = 668,                  /* READERS  */
  YYSYMBOL_READ_ONLY = 669,                /* "READ-ONLY"  */
  YYSYMBOL_READY_TRACE = 670,              /* "READY TRACE"  */
  YYSYMBOL_RECEIVE = 671,                  /* RECEIVE  */
  YYSYMBOL_RECEIVED = 672,                 /* RECEIVED  */
  YYSYMBOL_RECORD = 673,                   /* RECORD  */
  YYSYMBOL_RECORD_DATA = 674,              /* "RECORD-DATA"  */
  YYSYMBOL_RECORD_OVERFLOW = 675,          /* "RECORD-OVERFLOW"  */
  YYSYMBOL_RECORD_TO_ADD = 676,            /* "RECORD-TO-ADD"  */
  YYSYMBOL_RECORD_TO_DELETE = 677,         /* "RECORD-TO-DELETE"  */
  YYSYMBOL_RECORDING = 678,                /* RECORDING  */
  YYSYMBOL_RECORDS = 679,                  /* RECORDS  */
  YYSYMBOL_RECURSIVE = 680,                /* RECURSIVE  */
  YYSYMBOL_REDEFINES = 681,                /* REDEFINES  */
  YYSYMBOL_REEL = 682,                     /* REEL  */
  YYSYMBOL_REFERENCE = 683,                /* REFERENCE  */
  YYSYMBOL_REFERENCES = 684,               /* REFERENCES  */
  YYSYMBOL_REFRESH = 685,                  /* REFRESH  */
  YYSYMBOL_REGION_COLOR = 686,             /* "REGION-COLOR"  */
  YYSYMBOL_RELATION = 687,                 /* RELATION  */
  YYSYMBOL_RELATIVE = 688,                 /* RELATIVE  */
  YYSYMBOL_RELEASE = 689,                  /* RELEASE  */
  YYSYMBOL_REMAINDER = 690,                /* REMAINDER  */
  YYSYMBOL_REMARKS = 691,                  /* REMARKS  */
  YYSYMBOL_REMOVAL = 692,                  /* REMOVAL  */
  YYSYMBOL_RENAMES = 693,                  /* RENAMES  */
  YYSYMBOL_REORG_CRITERIA = 694,           /* "REORG-CRITERIA"  */
  YYSYMBOL_REPEATED = 695,                 /* REPEATED  */
  YYSYMBOL_REPLACE = 696,                  /* REPLACE  */
  YYSYMBOL_REPLACING = 697,                /* REPLACING  */
  YYSYMBOL_REPORT = 698,                   /* REPORT  */
  YYSYMBOL_REPORTING = 699,                /* REPORTING  */
  YYSYMBOL_REPORTS = 700,                  /* REPORTS  */
  YYSYMBOL_REPOSITORY = 701,               /* REPOSITORY  */
  YYSYMBOL_REQUIRED = 702,                 /* REQUIRED  */
  YYSYMBOL_REREAD = 703,                   /* REREAD  */
  YYSYMBOL_RERUN = 704,                    /* RERUN  */
  YYSYMBOL_RESERVE = 705,                  /* RESERVE  */
  YYSYMBOL_RESET = 706,                    /* RESET  */
  YYSYMBOL_RESET_TRACE = 707,              /* "RESET TRACE"  */
  YYSYMBOL_RESET_GRID = 708,               /* "RESET-GRID"  */
  YYSYMBOL_RESET_LIST = 709,               /* "RESET-LIST"  */
  YYSYMBOL_RESET_TABS = 710,               /* "RESET-TABS"  */
  YYSYMBOL_RETRY = 711,                    /* RETRY  */
  YYSYMBOL_RETURN = 712,                   /* RETURN  */
  YYSYMBOL_RETURNING = 713,                /* RETURNING  */
  YYSYMBOL_REVERSE = 714,                  /* REVERSE  */
  YYSYMBOL_REVERSE_FUNC = 715,             /* "FUNCTION REVERSE"  */
  YYSYMBOL_REVERSE_VIDEO = 716,            /* "REVERSE-VIDEO"  */
  YYSYMBOL_REVERSED = 717,                 /* REVERSED  */
  YYSYMBOL_REWIND = 718,                   /* REWIND  */
  YYSYMBOL_REWRITE = 719,                  /* REWRITE  */
  YYSYMBOL_RF = 720,                       /* RF  */
  YYSYMBOL_RH = 721,                       /* RH  */
  YYSYMBOL_RIGHT = 722,                    /* RIGHT  */
  YYSYMBOL_RIGHT_ALIGN = 723,              /* "RIGHT-ALIGN"  */
  YYSYMBOL_RIMMED = 724,                   /* RIMMED  */
  YYSYMBOL_ROLLBACK = 725,                 /* ROLLBACK  */
  YYSYMBOL_ROUNDED = 726,                  /* ROUNDED  */
  YYSYMBOL_ROUNDING = 727,                 /* ROUNDING  */
  YYSYMBOL_ROW_COLOR = 728,                /* "ROW-COLOR"  */
  YYSYMBOL_ROW_COLOR_PATTERN = 729,        /* "ROW-COLOR-PATTERN"  */
  YYSYMBOL_ROW_DIVIDERS = 730,             /* "ROW-DIVIDERS"  */
  YYSYMBOL_ROW_FONT = 731,                 /* "ROW-FONT"  */
  YYSYMBOL_ROW_HEADINGS = 732,             /* "ROW-HEADINGS"  */
  YYSYMBOL_ROW_PROTECTION = 733,           /* "ROW-PROTECTION"  */
  YYSYMBOL_RUN = 734,                      /* RUN  */
  YYSYMBOL_S = 735,                        /* S  */
  YYSYMBOL_SAME = 736,                     /* SAME  */
  YYSYMBOL_SAVE_AS = 737,                  /* "SAVE-AS"  */
  YYSYMBOL_SAVE_AS_NO_PROMPT = 738,        /* "SAVE-AS-NO-PROMPT"  */
  YYSYMBOL_SCREEN = 739,                   /* SCREEN  */
  YYSYMBOL_SCREEN_CONTROL = 740,           /* "SCREEN CONTROL"  */
  YYSYMBOL_SCROLL = 741,                   /* SCROLL  */
  YYSYMBOL_SCROLL_BAR = 742,               /* "SCROLL-BAR"  */
  YYSYMBOL_SD = 743,                       /* SD  */
  YYSYMBOL_SEARCH = 744,                   /* SEARCH  */
  YYSYMBOL_SEARCH_OPTIONS = 745,           /* "SEARCH-OPTIONS"  */
  YYSYMBOL_SEARCH_TEXT = 746,              /* "SEARCH-TEXT"  */
  YYSYMBOL_SECONDS = 747,                  /* SECONDS  */
  YYSYMBOL_SECTION = 748,                  /* SECTION  */
  YYSYMBOL_SECURE = 749,                   /* SECURE  */
  YYSYMBOL_SECURITY = 750,                 /* SECURITY  */
  YYSYMBOL_SEGMENT = 751,                  /* SEGMENT  */
  YYSYMBOL_SEGMENT_LIMIT = 752,            /* "SEGMENT-LIMIT"  */
  YYSYMBOL_SELECT = 753,                   /* SELECT  */
  YYSYMBOL_SELECTION_INDEX = 754,          /* "SELECTION-INDEX"  */
  YYSYMBOL_SELECTION_TEXT = 755,           /* "SELECTION-TEXT"  */
  YYSYMBOL_SELECT_ALL = 756,               /* "SELECTION-ALL"  */
  YYSYMBOL_SELF_ACT = 757,                 /* "SELF-ACT"  */
  YYSYMBOL_SEMI_COLON = 758,               /* "semi-colon"  */
  YYSYMBOL_SEND = 759,                     /* SEND  */
  YYSYMBOL_SENTENCE = 760,                 /* SENTENCE  */
  YYSYMBOL_SEPARATE = 761,                 /* SEPARATE  */
  YYSYMBOL_SEPARATION = 762,               /* SEPARATION  */
  YYSYMBOL_SEQUENCE = 763,                 /* SEQUENCE  */
  YYSYMBOL_SEQUENTIAL = 764,               /* SEQUENTIAL  */
  YYSYMBOL_SET = 765,                      /* SET  */
  YYSYMBOL_SEVENTY_EIGHT = 766,            /* "level-number 78"  */
  YYSYMBOL_SHADING = 767,                  /* SHADING  */
  YYSYMBOL_SHADOW = 768,                   /* SHADOW  */
  YYSYMBOL_SHARING = 769,                  /* SHARING  */
  YYSYMBOL_SHORT_DATE = 770,               /* "SHORT-DATE"  */
  YYSYMBOL_SHOW_LINES = 771,               /* "SHOW-LINES"  */
  YYSYMBOL_SHOW_NONE = 772,                /* "SHOW-NONE"  */
  YYSYMBOL_SHOW_SEL_ALWAYS = 773,          /* "SHOW-SEL-ALWAYS"  */
  YYSYMBOL_SIGN = 774,                     /* SIGN  */
  YYSYMBOL_SIGNED = 775,                   /* SIGNED  */
  YYSYMBOL_SIGNED_INT = 776,               /* "SIGNED-INT"  */
  YYSYMBOL_SIGNED_LONG = 777,              /* "SIGNED-LONG"  */
  YYSYMBOL_SIGNED_SHORT = 778,             /* "SIGNED-SHORT"  */
  YYSYMBOL_SIXTY_SIX = 779,                /* "level-number 66"  */
  YYSYMBOL_SIZE = 780,                     /* SIZE  */
  YYSYMBOL_SIZE_ERROR = 781,               /* "SIZE ERROR"  */
  YYSYMBOL_SMALL_FONT = 782,               /* "SMALL-FONT"  */
  YYSYMBOL_SORT = 783,                     /* SORT  */
  YYSYMBOL_SORT_MERGE = 784,               /* "SORT-MERGE"  */
  YYSYMBOL_SORT_ORDER = 785,               /* "SORT-ORDER"  */
  YYSYMBOL_SOURCE = 786,                   /* SOURCE  */
  YYSYMBOL_SOURCE_COMPUTER = 787,          /* "SOURCE-COMPUTER"  */
  YYSYMBOL_SPACE = 788,                    /* SPACE  */
  YYSYMBOL_SPECIAL_NAMES = 789,            /* "SPECIAL-NAMES"  */
  YYSYMBOL_SPINNER = 790,                  /* SPINNER  */
  YYSYMBOL_SQUARE = 791,                   /* SQUARE  */
  YYSYMBOL_STANDARD = 792,                 /* STANDARD  */
  YYSYMBOL_STANDARD_1 = 793,               /* "STANDARD-1"  */
  YYSYMBOL_STANDARD_2 = 794,               /* "STANDARD-2"  */
  YYSYMBOL_STANDARD_BINARY = 795,          /* "STANDARD-BINARY"  */
  YYSYMBOL_STANDARD_DECIMAL = 796,         /* "STANDARD-DECIMAL"  */
  YYSYMBOL_START = 797,                    /* START  */
  YYSYMBOL_START_X = 798,                  /* "START-X"  */
  YYSYMBOL_START_Y = 799,                  /* "START-Y"  */
  YYSYMBOL_STATIC = 800,                   /* STATIC  */
  YYSYMBOL_STATIC_LIST = 801,              /* "STATIC-LIST"  */
  YYSYMBOL_STATUS = 802,                   /* STATUS  */
  YYSYMBOL_STATUS_BAR = 803,               /* "STATUS-BAR"  */
  YYSYMBOL_STATUS_TEXT = 804,              /* "STATUS-TEXT"  */
  YYSYMBOL_STDCALL = 805,                  /* STDCALL  */
  YYSYMBOL_STEP = 806,                     /* STEP  */
  YYSYMBOL_STOP = 807,                     /* STOP  */
  YYSYMBOL_STRING = 808,                   /* STRING  */
  YYSYMBOL_STRONG = 809,                   /* STRONG  */
  YYSYMBOL_STYLE = 810,                    /* STYLE  */
  YYSYMBOL_SUB_QUEUE_1 = 811,              /* "SUB-QUEUE-1"  */
  YYSYMBOL_SUB_QUEUE_2 = 812,              /* "SUB-QUEUE-2"  */
  YYSYMBOL_SUB_QUEUE_3 = 813,              /* "SUB-QUEUE-3"  */
  YYSYMBOL_SUBSTITUTE_FUNC = 814,          /* "FUNCTION SUBSTITUTE"  */
  YYSYMBOL_SUBSTITUTE_CASE_FUNC = 815,     /* "FUNCTION SUBSTITUTE-CASE"  */
  YYSYMBOL_SUBTRACT = 816,                 /* SUBTRACT  */
  YYSYMBOL_SUBWINDOW = 817,                /* SUBWINDOW  */
  YYSYMBOL_SUM = 818,                      /* SUM  */
  YYSYMBOL_SUPPRESS = 819,                 /* SUPPRESS  */
  YYSYMBOL_SUPPRESS_XML = 820,             /* "SUPPRESS"  */
  YYSYMBOL_SYMBOLIC = 821,                 /* SYMBOLIC  */
  YYSYMBOL_SYNCHRONIZED = 822,             /* SYNCHRONIZED  */
  YYSYMBOL_SYSTEM_DEFAULT = 823,           /* "SYSTEM-DEFAULT"  */
  YYSYMBOL_SYSTEM_INFO = 824,              /* "SYSTEM-INFO"  */
  YYSYMBOL_SYSTEM_OFFSET = 825,            /* "SYSTEM-OFFSET"  */
  YYSYMBOL_TAB = 826,                      /* TAB  */
  YYSYMBOL_TAB_TO_ADD = 827,               /* "TAB-TO-ADD"  */
  YYSYMBOL_TAB_TO_DELETE = 828,            /* "TAB-TO-DELETE"  */
  YYSYMBOL_TABLE = 829,                    /* TABLE  */
  YYSYMBOL_TALLYING = 830,                 /* TALLYING  */
  YYSYMBOL_TEMPORARY = 831,                /* TEMPORARY  */
  YYSYMBOL_TAPE = 832,                     /* TAPE  */
  YYSYMBOL_TERMINAL = 833,                 /* TERMINAL  */
  YYSYMBOL_TERMINATE = 834,                /* TERMINATE  */
  YYSYMBOL_TERMINAL_INFO = 835,            /* "TERMINAL-INFO"  */
  YYSYMBOL_TERMINATION_VALUE = 836,        /* "TERMINATION-VALUE"  */
  YYSYMBOL_TEST = 837,                     /* TEST  */
  YYSYMBOL_TEXT = 838,                     /* TEXT  */
  YYSYMBOL_THAN = 839,                     /* THAN  */
  YYSYMBOL_THEN = 840,                     /* THEN  */
  YYSYMBOL_THREAD = 841,                   /* THREAD  */
  YYSYMBOL_THREADS = 842,                  /* THREADS  */
  YYSYMBOL_THRU = 843,                     /* THRU  */
  YYSYMBOL_THUMB_POSITION = 844,           /* "THUMB-POSITION"  */
  YYSYMBOL_TILED_HEADINGS = 845,           /* "TILED-HEADINGS"  */
  YYSYMBOL_TIME = 846,                     /* TIME  */
  YYSYMBOL_TIME_OUT = 847,                 /* "TIME-OUT"  */
  YYSYMBOL_TIMES = 848,                    /* TIMES  */
  YYSYMBOL_TITLE = 849,                    /* TITLE  */
  YYSYMBOL_TITLE_POSITION = 850,           /* "TITLE-POSITION"  */
  YYSYMBOL_TO = 851,                       /* TO  */
  YYSYMBOL_TOK_AMPER = 852,                /* "&"  */
  YYSYMBOL_TOK_CLOSE_PAREN = 853,          /* ")"  */
  YYSYMBOL_TOK_COLON = 854,                /* ":"  */
  YYSYMBOL_TOK_DIV = 855,                  /* "/"  */
  YYSYMBOL_TOK_DOT = 856,                  /* "."  */
  YYSYMBOL_TOK_EQUAL = 857,                /* "="  */
  YYSYMBOL_TOK_EXTERN = 858,               /* "EXTERN"  */
  YYSYMBOL_TOK_FALSE = 859,                /* "FALSE"  */
  YYSYMBOL_TOK_FILE = 860,                 /* "FILE"  */
  YYSYMBOL_TOK_GREATER = 861,              /* ">"  */
  YYSYMBOL_TOK_INITIAL = 862,              /* "INITIAL"  */
  YYSYMBOL_TOK_LESS = 863,                 /* "<"  */
  YYSYMBOL_TOK_MINUS = 864,                /* "-"  */
  YYSYMBOL_TOK_MUL = 865,                  /* "*"  */
  YYSYMBOL_TOK_NULL = 866,                 /* "NULL"  */
  YYSYMBOL_TOK_OVERFLOW = 867,             /* "OVERFLOW"  */
  YYSYMBOL_TOK_OPEN_PAREN = 868,           /* "("  */
  YYSYMBOL_TOK_PLUS = 869,                 /* "+"  */
  YYSYMBOL_TOK_TRUE = 870,                 /* "TRUE"  */
  YYSYMBOL_TOP = 871,                      /* TOP  */
  YYSYMBOL_TOWARD_GREATER = 872,           /* "TOWARD-GREATER"  */
  YYSYMBOL_TOWARD_LESSER = 873,            /* "TOWARD-LESSER"  */
  YYSYMBOL_TRACK = 874,                    /* TRACK  */
  YYSYMBOL_TRACKS = 875,                   /* TRACKS  */
  YYSYMBOL_TRACK_AREA = 876,               /* "TRACK-AREA"  */
  YYSYMBOL_TRACK_LIMIT = 877,              /* "TRACK-LIMIT"  */
  YYSYMBOL_TRADITIONAL_FONT = 878,         /* "TRADITIONAL-FONT"  */
  YYSYMBOL_TRAILING = 879,                 /* TRAILING  */
  YYSYMBOL_TRAILING_SHIFT = 880,           /* "TRAILING-SHIFT"  */
  YYSYMBOL_TRANSFORM = 881,                /* TRANSFORM  */
  YYSYMBOL_TRANSPARENT = 882,              /* TRANSPARENT  */
  YYSYMBOL_TREE_VIEW = 883,                /* "TREE-VIEW"  */
  YYSYMBOL_TRIM_FUNC = 884,                /* "FUNCTION TRIM"  */
  YYSYMBOL_TRUNCATION = 885,               /* TRUNCATION  */
  YYSYMBOL_TYPE = 886,                     /* TYPE  */
  YYSYMBOL_TYPEDEF = 887,                  /* TYPEDEF  */
  YYSYMBOL_U = 888,                        /* U  */
  YYSYMBOL_UCS_4 = 889,                    /* "UCS-4"  */
  YYSYMBOL_UNBOUNDED = 890,                /* UNBOUNDED  */
  YYSYMBOL_UNDERLINE = 891,                /* UNDERLINE  */
  YYSYMBOL_UNFRAMED = 892,                 /* UNFRAMED  */
  YYSYMBOL_UNIT = 893,                     /* UNIT  */
  YYSYMBOL_UNLOCK = 894,                   /* UNLOCK  */
  YYSYMBOL_UNSIGNED = 895,                 /* UNSIGNED  */
  YYSYMBOL_UNSIGNED_INT = 896,             /* "UNSIGNED-INT"  */
  YYSYMBOL_UNSIGNED_LONG = 897,            /* "UNSIGNED-LONG"  */
  YYSYMBOL_UNSIGNED_SHORT = 898,           /* "UNSIGNED-SHORT"  */
  YYSYMBOL_UNSORTED = 899,                 /* UNSORTED  */
  YYSYMBOL_UNSTRING = 900,                 /* UNSTRING  */
  YYSYMBOL_UNTIL = 901,                    /* UNTIL  */
  YYSYMBOL_UP = 902,                       /* UP  */
  YYSYMBOL_UPDATE = 903,                   /* UPDATE  */
  YYSYMBOL_UPDATERS = 904,                 /* UPDATERS  */
  YYSYMBOL_UPON = 905,                     /* UPON  */
  YYSYMBOL_UPON_ARGUMENT_NUMBER = 906,     /* "UPON ARGUMENT-NUMBER"  */
  YYSYMBOL_UPON_COMMAND_LINE = 907,        /* "UPON COMMAND-LINE"  */
  YYSYMBOL_UPON_ENVIRONMENT_NAME = 908,    /* "UPON ENVIRONMENT-NAME"  */
  YYSYMBOL_UPON_ENVIRONMENT_VALUE = 909,   /* "UPON ENVIRONMENT-VALUE"  */
  YYSYMBOL_UPPER = 910,                    /* UPPER  */
  YYSYMBOL_UPPER_CASE_FUNC = 911,          /* "FUNCTION UPPER-CASE"  */
  YYSYMBOL_USAGE = 912,                    /* USAGE  */
  YYSYMBOL_USE = 913,                      /* USE  */
  YYSYMBOL_USE_ALT = 914,                  /* "USE-ALT"  */
  YYSYMBOL_USE_RETURN = 915,               /* "USE-RETURN"  */
  YYSYMBOL_USE_TAB = 916,                  /* "USE-TAB"  */
  YYSYMBOL_USER = 917,                     /* USER  */
  YYSYMBOL_USER_DEFAULT = 918,             /* "USER-DEFAULT"  */
  YYSYMBOL_USER_FUNCTION_NAME = 919,       /* "user function name"  */
  YYSYMBOL_USING = 920,                    /* USING  */
  YYSYMBOL_UTF_8 = 921,                    /* "UTF-8"  */
  YYSYMBOL_UTF_16 = 922,                   /* "UTF-16"  */
  YYSYMBOL_V = 923,                        /* V  */
  YYSYMBOL_VALID = 924,                    /* VALID  */
  YYSYMBOL_VALIDATE = 925,                 /* VALIDATE  */
  YYSYMBOL_VAL_STATUS = 926,               /* "VAL-STATUS"  */
  YYSYMBOL_VALIDATE_STATUS = 927,          /* "VALIDATE-STATUS"  */
  YYSYMBOL_VALIDATING = 928,               /* VALIDATING  */
  YYSYMBOL_VALUE = 929,                    /* VALUE  */
  YYSYMBOL_VALUE_FORMAT = 930,             /* "VALUE-FORMAT"  */
  YYSYMBOL_VALUES = 931,                   /* VALUES  */
  YYSYMBOL_VARIABLE = 932,                 /* VARIABLE  */
  YYSYMBOL_VARIANT = 933,                  /* VARIANT  */
  YYSYMBOL_VARYING = 934,                  /* VARYING  */
  YYSYMBOL_VERTICAL = 935,                 /* VERTICAL  */
  YYSYMBOL_VERY_HEAVY = 936,               /* "VERY-HEAVY"  */
  YYSYMBOL_VIRTUAL_WIDTH = 937,            /* "VIRTUAL-WIDTH"  */
  YYSYMBOL_VOLATILE = 938,                 /* VOLATILE  */
  YYSYMBOL_VPADDING = 939,                 /* VPADDING  */
  YYSYMBOL_VSCROLL = 940,                  /* VSCROLL  */
  YYSYMBOL_VSCROLL_BAR = 941,              /* "VSCROLL-BAR"  */
  YYSYMBOL_VSCROLL_POS = 942,              /* "VSCROLL-POS"  */
  YYSYMBOL_VTOP = 943,                     /* VTOP  */
  YYSYMBOL_WAIT = 944,                     /* WAIT  */
  YYSYMBOL_WEB_BROWSER = 945,              /* "WEB-BROWSER"  */
  YYSYMBOL_WHEN = 946,                     /* WHEN  */
  YYSYMBOL_WHEN_COMPILED_FUNC = 947,       /* "FUNCTION WHEN-COMPILED"  */
  YYSYMBOL_WHEN_XML = 948,                 /* "WHEN"  */
  YYSYMBOL_WIDTH = 949,                    /* WIDTH  */
  YYSYMBOL_WIDTH_IN_CELLS = 950,           /* "WIDTH-IN-CELLS"  */
  YYSYMBOL_WINAPI = 951,                   /* WINAPI  */
  YYSYMBOL_WINDOW = 952,                   /* WINDOW  */
  YYSYMBOL_WITH = 953,                     /* WITH  */
  YYSYMBOL_WORD = 954,                     /* "Identifier"  */
  YYSYMBOL_WORDS = 955,                    /* WORDS  */
  YYSYMBOL_WORKING_STORAGE = 956,          /* "WORKING-STORAGE"  */
  YYSYMBOL_WRAP = 957,                     /* WRAP  */
  YYSYMBOL_WRITE = 958,                    /* WRITE  */
  YYSYMBOL_WRITE_ONLY = 959,               /* "WRITE-ONLY"  */
  YYSYMBOL_WRITE_VERIFY = 960,             /* "WRITE-VERIFY"  */
  YYSYMBOL_WRITERS = 961,                  /* WRITERS  */
  YYSYMBOL_X = 962,                        /* X  */
  YYSYMBOL_XML = 963,                      /* XML  */
  YYSYMBOL_XML_DECLARATION = 964,          /* "XML-DECLARATION"  */
  YYSYMBOL_XML_SCHEMA = 965,               /* "XML-SCHEMA"  */
  YYSYMBOL_Y = 966,                        /* Y  */
  YYSYMBOL_YYYYDDD = 967,                  /* YYYYDDD  */
  YYSYMBOL_YYYYMMDD = 968,                 /* YYYYMMDD  */
  YYSYMBOL_ZERO = 969,                     /* ZERO  */
  YYSYMBOL_LEVEL_NUMBER_IN_AREA_A = 970,   /* "level-number (Area A)"  */
  YYSYMBOL_WORD_IN_AREA_A = 971,           /* "Identifier (Area A)"  */
  YYSYMBOL_SHIFT_PREFER = 972,             /* SHIFT_PREFER  */
  YYSYMBOL_YYACCEPT = 973,                 /* $accept  */
  YYSYMBOL_start = 974,                    /* start  */
  YYSYMBOL_975_1 = 975,                    /* $@1  */
  YYSYMBOL_compilation_group = 976,        /* compilation_group  */
  YYSYMBOL_nested_list = 977,              /* nested_list  */
  YYSYMBOL_978_2 = 978,                    /* $@2  */
  YYSYMBOL_source_element_list = 979,      /* source_element_list  */
  YYSYMBOL_source_element = 980,           /* source_element  */
  YYSYMBOL_simple_prog = 981,              /* simple_prog  */
  YYSYMBOL_982_3 = 982,                    /* $@3  */
  YYSYMBOL_program_definition = 983,       /* program_definition  */
  YYSYMBOL_function_definition = 984,      /* function_definition  */
  YYSYMBOL__end_program_list = 985,        /* _end_program_list  */
  YYSYMBOL_end_program_list = 986,         /* end_program_list  */
  YYSYMBOL_end_program = 987,              /* end_program  */
  YYSYMBOL_988_4 = 988,                    /* $@4  */
  YYSYMBOL_end_function = 989,             /* end_function  */
  YYSYMBOL_990_5 = 990,                    /* $@5  */
  YYSYMBOL_program_prototype = 991,        /* program_prototype  */
  YYSYMBOL_992_6 = 992,                    /* $@6  */
  YYSYMBOL_993_7 = 993,                    /* $@7  */
  YYSYMBOL_function_prototype = 994,       /* function_prototype  */
  YYSYMBOL_995_8 = 995,                    /* $@8  */
  YYSYMBOL_996_9 = 996,                    /* $@9  */
  YYSYMBOL__prototype_procedure_division_header = 997, /* _prototype_procedure_division_header  */
  YYSYMBOL_998_10 = 998,                   /* $@10  */
  YYSYMBOL_control = 999,                  /* control  */
  YYSYMBOL__control_division = 1000,       /* _control_division  */
  YYSYMBOL_1001_11 = 1001,                 /* $@11  */
  YYSYMBOL__default_section = 1002,        /* _default_section  */
  YYSYMBOL_1003_12 = 1003,                 /* $@12  */
  YYSYMBOL__default_clauses = 1004,        /* _default_clauses  */
  YYSYMBOL__default_accept_clause = 1005,  /* _default_accept_clause  */
  YYSYMBOL_1006_13 = 1006,                 /* $@13  */
  YYSYMBOL__default_display_clause = 1007, /* _default_display_clause  */
  YYSYMBOL_1008_14 = 1008,                 /* $@14  */
  YYSYMBOL__program_body = 1009,           /* _program_body  */
  YYSYMBOL_1010_15 = 1010,                 /* $@15  */
  YYSYMBOL_1011_16 = 1011,                 /* $@16  */
  YYSYMBOL__identification_header = 1012,  /* _identification_header  */
  YYSYMBOL_identification_header = 1013,   /* identification_header  */
  YYSYMBOL_1014_17 = 1014,                 /* $@17  */
  YYSYMBOL_identification_or_id = 1015,    /* identification_or_id  */
  YYSYMBOL_program_id_header = 1016,       /* program_id_header  */
  YYSYMBOL_program_id_paragraph = 1017,    /* program_id_paragraph  */
  YYSYMBOL_function_id_header = 1018,      /* function_id_header  */
  YYSYMBOL_function_id_paragraph = 1019,   /* function_id_paragraph  */
  YYSYMBOL_program_id_name = 1020,         /* program_id_name  */
  YYSYMBOL_end_program_name = 1021,        /* end_program_name  */
  YYSYMBOL__as_literal = 1022,             /* _as_literal  */
  YYSYMBOL__program_type = 1023,           /* _program_type  */
  YYSYMBOL_program_type_clause = 1024,     /* program_type_clause  */
  YYSYMBOL_init_or_recurse_and_common = 1025, /* init_or_recurse_and_common  */
  YYSYMBOL_init_or_recurse = 1026,         /* init_or_recurse  */
  YYSYMBOL__options_paragraph = 1027,      /* _options_paragraph  */
  YYSYMBOL__options_clauses = 1028,        /* _options_clauses  */
  YYSYMBOL__arithmetic_clause = 1029,      /* _arithmetic_clause  */
  YYSYMBOL_arithmetic_choice = 1030,       /* arithmetic_choice  */
  YYSYMBOL__default_rounded_clause = 1031, /* _default_rounded_clause  */
  YYSYMBOL__entry_convention_clause = 1032, /* _entry_convention_clause  */
  YYSYMBOL_convention_type = 1033,         /* convention_type  */
  YYSYMBOL__intermediate_rounding_clause = 1034, /* _intermediate_rounding_clause  */
  YYSYMBOL_intermediate_rounding_choice = 1035, /* intermediate_rounding_choice  */
  YYSYMBOL__environment_division = 1036,   /* _environment_division  */
  YYSYMBOL__environment_header = 1037,     /* _environment_header  */
  YYSYMBOL_environment = 1038,             /* environment  */
  YYSYMBOL_environment_header = 1039,      /* environment_header  */
  YYSYMBOL__configuration_section = 1040,  /* _configuration_section  */
  YYSYMBOL__configuration_header = 1041,   /* _configuration_header  */
  YYSYMBOL_configuration = 1042,           /* configuration  */
  YYSYMBOL_configuration_header = 1043,    /* configuration_header  */
  YYSYMBOL__configuration_paragraphs = 1044, /* _configuration_paragraphs  */
  YYSYMBOL_configuration_paragraphs = 1045, /* configuration_paragraphs  */
  YYSYMBOL_configuration_paragraph = 1046, /* configuration_paragraph  */
  YYSYMBOL__source_computer_paragraph = 1047, /* _source_computer_paragraph  */
  YYSYMBOL_source_computer_paragraph = 1048, /* source_computer_paragraph  */
  YYSYMBOL_1049_18 = 1049,                 /* $@18  */
  YYSYMBOL__source_computer_entry = 1050,  /* _source_computer_entry  */
  YYSYMBOL__with_debugging_mode = 1051,    /* _with_debugging_mode  */
  YYSYMBOL_object_computer_paragraph = 1052, /* object_computer_paragraph  */
  YYSYMBOL_1053_19 = 1053,                 /* $@19  */
  YYSYMBOL__object_computer_entry = 1054,  /* _object_computer_entry  */
  YYSYMBOL_object_clauses_list = 1055,     /* object_clauses_list  */
  YYSYMBOL_object_clauses = 1056,          /* object_clauses  */
  YYSYMBOL_object_computer_memory = 1057,  /* object_computer_memory  */
  YYSYMBOL_object_computer_sequence = 1058, /* object_computer_sequence  */
  YYSYMBOL_program_collating_sequence = 1059, /* program_collating_sequence  */
  YYSYMBOL_1060_20 = 1060,                 /* $@20  */
  YYSYMBOL_program_coll_sequence_values = 1061, /* program_coll_sequence_values  */
  YYSYMBOL_object_computer_segment = 1062, /* object_computer_segment  */
  YYSYMBOL_object_computer_class = 1063,   /* object_computer_class  */
  YYSYMBOL_locale_class = 1064,            /* locale_class  */
  YYSYMBOL_computer_words = 1065,          /* computer_words  */
  YYSYMBOL__repository_paragraph = 1066,   /* _repository_paragraph  */
  YYSYMBOL_repository_paragraph = 1067,    /* repository_paragraph  */
  YYSYMBOL_1068_21 = 1068,                 /* $@21  */
  YYSYMBOL__repository_entry = 1069,       /* _repository_entry  */
  YYSYMBOL_repository_list = 1070,         /* repository_list  */
  YYSYMBOL_repository_name = 1071,         /* repository_name  */
  YYSYMBOL_repository_name_list = 1072,    /* repository_name_list  */
  YYSYMBOL_special_names_header = 1073,    /* special_names_header  */
  YYSYMBOL_special_names_sentence = 1074,  /* special_names_sentence  */
  YYSYMBOL_special_name_list = 1075,       /* special_name_list  */
  YYSYMBOL_special_name = 1076,            /* special_name  */
  YYSYMBOL_mnemonic_name_clause = 1077,    /* mnemonic_name_clause  */
  YYSYMBOL_1078_22 = 1078,                 /* $@22  */
  YYSYMBOL_word_or_terminal = 1079,        /* word_or_terminal  */
  YYSYMBOL_mnemonic_choices = 1080,        /* mnemonic_choices  */
  YYSYMBOL__special_name_mnemonic_on_off = 1081, /* _special_name_mnemonic_on_off  */
  YYSYMBOL_on_off_clauses = 1082,          /* on_off_clauses  */
  YYSYMBOL_on_off_clauses_1 = 1083,        /* on_off_clauses_1  */
  YYSYMBOL_alphabet_name_clause = 1084,    /* alphabet_name_clause  */
  YYSYMBOL_1085_23 = 1085,                 /* @23  */
  YYSYMBOL_alphabet_definition = 1086,     /* alphabet_definition  */
  YYSYMBOL_1087_24 = 1087,                 /* @24  */
  YYSYMBOL_1088_25 = 1088,                 /* @25  */
  YYSYMBOL_alphabet_target_alphanumeric = 1089, /* alphabet_target_alphanumeric  */
  YYSYMBOL_alphabet_target_national = 1090, /* alphabet_target_national  */
  YYSYMBOL_alphabet_type_alphanumeric = 1091, /* alphabet_type_alphanumeric  */
  YYSYMBOL_alphabet_type_national = 1092,  /* alphabet_type_national  */
  YYSYMBOL_alphabet_type_common = 1093,    /* alphabet_type_common  */
  YYSYMBOL_alphabet_literal_list = 1094,   /* alphabet_literal_list  */
  YYSYMBOL_alphabet_literal = 1095,        /* alphabet_literal  */
  YYSYMBOL_1096_26 = 1096,                 /* @26  */
  YYSYMBOL_alphabet_also_sequence = 1097,  /* alphabet_also_sequence  */
  YYSYMBOL_alphabet_lits = 1098,           /* alphabet_lits  */
  YYSYMBOL_space_or_zero = 1099,           /* space_or_zero  */
  YYSYMBOL__alphnat_target = 1100,         /* _alphnat_target  */
  YYSYMBOL__in_alphabet = 1101,            /* _in_alphabet  */
  YYSYMBOL_symbolic_characters_clause = 1102, /* symbolic_characters_clause  */
  YYSYMBOL_symbolic_collection = 1103,     /* symbolic_collection  */
  YYSYMBOL_symbolic_chars_list = 1104,     /* symbolic_chars_list  */
  YYSYMBOL_symbolic_chars_phrase = 1105,   /* symbolic_chars_phrase  */
  YYSYMBOL_char_list = 1106,               /* char_list  */
  YYSYMBOL_integer_list = 1107,            /* integer_list  */
  YYSYMBOL_symbolic_constant_clause = 1108, /* symbolic_constant_clause  */
  YYSYMBOL_symbolic_constant_list = 1109,  /* symbolic_constant_list  */
  YYSYMBOL_symbolic_constant = 1110,       /* symbolic_constant  */
  YYSYMBOL_class_name_clause = 1111,       /* class_name_clause  */
  YYSYMBOL_class_item_list = 1112,         /* class_item_list  */
  YYSYMBOL_class_item = 1113,              /* class_item  */
  YYSYMBOL_locale_clause = 1114,           /* locale_clause  */
  YYSYMBOL_xml_schema_clause = 1115,       /* xml_schema_clause  */
  YYSYMBOL_1116_27 = 1116,                 /* @27  */
  YYSYMBOL_schema_definition = 1117,       /* schema_definition  */
  YYSYMBOL_currency_sign_clause = 1118,    /* currency_sign_clause  */
  YYSYMBOL__with_pic_symbol = 1119,        /* _with_pic_symbol  */
  YYSYMBOL_decimal_point_clause = 1120,    /* decimal_point_clause  */
  YYSYMBOL_numeric_sign_clause = 1121,     /* numeric_sign_clause  */
  YYSYMBOL_cursor_clause = 1122,           /* cursor_clause  */
  YYSYMBOL_crt_status_clause = 1123,       /* crt_status_clause  */
  YYSYMBOL_screen_control = 1124,          /* screen_control  */
  YYSYMBOL_event_status = 1125,            /* event_status  */
  YYSYMBOL_top_clause = 1126,              /* top_clause  */
  YYSYMBOL_1127_28 = 1127,                 /* $@28  */
  YYSYMBOL__input_output_section = 1128,   /* _input_output_section  */
  YYSYMBOL_input_output = 1129,            /* input_output  */
  YYSYMBOL__input_output_header = 1130,    /* _input_output_header  */
  YYSYMBOL__file_control_header = 1131,    /* _file_control_header  */
  YYSYMBOL__file_control_sequence = 1132,  /* _file_control_sequence  */
  YYSYMBOL_file_control_entry = 1133,      /* file_control_entry  */
  YYSYMBOL_1134_29 = 1134,                 /* $@29  */
  YYSYMBOL_1135_30 = 1135,                 /* $@30  */
  YYSYMBOL__select_clauses_or_error = 1136, /* _select_clauses_or_error  */
  YYSYMBOL__select_clause_sequence = 1137, /* _select_clause_sequence  */
  YYSYMBOL_select_clause = 1138,           /* select_clause  */
  YYSYMBOL_assign_clause = 1139,           /* assign_clause  */
  YYSYMBOL__assign_device_or_line_adv_file = 1140, /* _assign_device_or_line_adv_file  */
  YYSYMBOL_assign_device = 1141,           /* assign_device  */
  YYSYMBOL_general_device_name = 1142,     /* general_device_name  */
  YYSYMBOL_line_seq_device_name = 1143,    /* line_seq_device_name  */
  YYSYMBOL_line_adv_file = 1144,           /* line_adv_file  */
  YYSYMBOL__ext_clause = 1145,             /* _ext_clause  */
  YYSYMBOL_ext_clause = 1146,              /* ext_clause  */
  YYSYMBOL_assignment_name = 1147,         /* assignment_name  */
  YYSYMBOL_access_mode_clause = 1148,      /* access_mode_clause  */
  YYSYMBOL_access_mode = 1149,             /* access_mode  */
  YYSYMBOL_alternate_record_key_clause = 1150, /* alternate_record_key_clause  */
  YYSYMBOL__password_clause = 1151,        /* _password_clause  */
  YYSYMBOL_password_clause = 1152,         /* password_clause  */
  YYSYMBOL_1153_31 = 1153,                 /* $@31  */
  YYSYMBOL_encryption_clause = 1154,       /* encryption_clause  */
  YYSYMBOL__suppress_clause = 1155,        /* _suppress_clause  */
  YYSYMBOL_collating_sequence_clause = 1156, /* collating_sequence_clause  */
  YYSYMBOL_collating_sequence = 1157,      /* collating_sequence  */
  YYSYMBOL_1158_32 = 1158,                 /* $@32  */
  YYSYMBOL_coll_sequence_values = 1159,    /* coll_sequence_values  */
  YYSYMBOL_collating_sequence_clause_key = 1160, /* collating_sequence_clause_key  */
  YYSYMBOL_alphabet_name = 1161,           /* alphabet_name  */
  YYSYMBOL_file_status_clause = 1162,      /* file_status_clause  */
  YYSYMBOL__file_or_sort = 1163,           /* _file_or_sort  */
  YYSYMBOL_lock_mode_clause = 1164,        /* lock_mode_clause  */
  YYSYMBOL_1165_33 = 1165,                 /* $@33  */
  YYSYMBOL_lock_mode = 1166,               /* lock_mode  */
  YYSYMBOL__lock_with = 1167,              /* _lock_with  */
  YYSYMBOL__with_rollback = 1168,          /* _with_rollback  */
  YYSYMBOL_with_rollback = 1169,           /* with_rollback  */
  YYSYMBOL__with_mass_update = 1170,       /* _with_mass_update  */
  YYSYMBOL_organization_clause = 1171,     /* organization_clause  */
  YYSYMBOL_organization = 1172,            /* organization  */
  YYSYMBOL_padding_character_clause = 1173, /* padding_character_clause  */
  YYSYMBOL_record_delimiter_clause = 1174, /* record_delimiter_clause  */
  YYSYMBOL_1175_34 = 1175,                 /* $@34  */
  YYSYMBOL_record_delimiter_option = 1176, /* record_delimiter_option  */
  YYSYMBOL_record_key_clause = 1177,       /* record_key_clause  */
  YYSYMBOL__split_keys = 1178,             /* _split_keys  */
  YYSYMBOL_source_is = 1179,               /* source_is  */
  YYSYMBOL_split_key_list = 1180,          /* split_key_list  */
  YYSYMBOL_1181_35 = 1181,                 /* $@35  */
  YYSYMBOL_split_key = 1182,               /* split_key  */
  YYSYMBOL_relative_key_clause = 1183,     /* relative_key_clause  */
  YYSYMBOL_reserve_clause = 1184,          /* reserve_clause  */
  YYSYMBOL_no_or_integer = 1185,           /* no_or_integer  */
  YYSYMBOL_sharing_clause = 1186,          /* sharing_clause  */
  YYSYMBOL_sharing_option = 1187,          /* sharing_option  */
  YYSYMBOL_file_limit_clause = 1188,       /* file_limit_clause  */
  YYSYMBOL_thru_list = 1189,               /* thru_list  */
  YYSYMBOL_actual_key_clause = 1190,       /* actual_key_clause  */
  YYSYMBOL_nominal_key_clause = 1191,      /* nominal_key_clause  */
  YYSYMBOL_track_area_clause = 1192,       /* track_area_clause  */
  YYSYMBOL_track_limit_clause = 1193,      /* track_limit_clause  */
  YYSYMBOL__i_o_control = 1194,            /* _i_o_control  */
  YYSYMBOL_i_o_control_header = 1195,      /* i_o_control_header  */
  YYSYMBOL__i_o_control_entries = 1196,    /* _i_o_control_entries  */
  YYSYMBOL_i_o_control_list = 1197,        /* i_o_control_list  */
  YYSYMBOL_i_o_control_clause = 1198,      /* i_o_control_clause  */
  YYSYMBOL_same_clause = 1199,             /* same_clause  */
  YYSYMBOL__same_option = 1200,            /* _same_option  */
  YYSYMBOL_apply_clause = 1201,            /* apply_clause  */
  YYSYMBOL_obsolete_dos_vs_apply_phrase = 1202, /* obsolete_dos_vs_apply_phrase  */
  YYSYMBOL_multiple_file_tape_clause = 1203, /* multiple_file_tape_clause  */
  YYSYMBOL_1204_36 = 1204,                 /* $@36  */
  YYSYMBOL_multiple_file_list = 1205,      /* multiple_file_list  */
  YYSYMBOL_multiple_file = 1206,           /* multiple_file  */
  YYSYMBOL__multiple_file_position = 1207, /* _multiple_file_position  */
  YYSYMBOL_rerun_clause = 1208,            /* rerun_clause  */
  YYSYMBOL__on_assignment = 1209,          /* _on_assignment  */
  YYSYMBOL_rerun_event = 1210,             /* rerun_event  */
  YYSYMBOL__prototype_environment_division = 1211, /* _prototype_environment_division  */
  YYSYMBOL__prototype_special_names_paragraph = 1212, /* _prototype_special_names_paragraph  */
  YYSYMBOL__prototype_special_names_sentence_list = 1213, /* _prototype_special_names_sentence_list  */
  YYSYMBOL_prototype_special_names_sentence_list = 1214, /* prototype_special_names_sentence_list  */
  YYSYMBOL_prototype_special_name_list = 1215, /* prototype_special_name_list  */
  YYSYMBOL_prototype_special_name = 1216,  /* prototype_special_name  */
  YYSYMBOL__data_division = 1217,          /* _data_division  */
  YYSYMBOL_1218_37 = 1218,                 /* $@37  */
  YYSYMBOL__data_division_header = 1219,   /* _data_division_header  */
  YYSYMBOL_data = 1220,                    /* data  */
  YYSYMBOL_data_division_header = 1221,    /* data_division_header  */
  YYSYMBOL_tok_file = 1222,                /* tok_file  */
  YYSYMBOL__file_section_header = 1223,    /* _file_section_header  */
  YYSYMBOL__file_description_sequence = 1224, /* _file_description_sequence  */
  YYSYMBOL_file_description = 1225,        /* file_description  */
  YYSYMBOL_file_description_entry = 1226,  /* file_description_entry  */
  YYSYMBOL_1227_38 = 1227,                 /* $@38  */
  YYSYMBOL_file_type = 1228,               /* file_type  */
  YYSYMBOL__file_description_clause_sequence = 1229, /* _file_description_clause_sequence  */
  YYSYMBOL_file_description_clause = 1230, /* file_description_clause  */
  YYSYMBOL_block_contains_clause = 1231,   /* block_contains_clause  */
  YYSYMBOL__records_or_characters = 1232,  /* _records_or_characters  */
  YYSYMBOL_record_clause = 1233,           /* record_clause  */
  YYSYMBOL__record_depending = 1234,       /* _record_depending  */
  YYSYMBOL__from_integer = 1235,           /* _from_integer  */
  YYSYMBOL__to_integer = 1236,             /* _to_integer  */
  YYSYMBOL_label_records_clause = 1237,    /* label_records_clause  */
  YYSYMBOL_value_of_clause = 1238,         /* value_of_clause  */
  YYSYMBOL_file_id = 1239,                 /* file_id  */
  YYSYMBOL_valueof_name = 1240,            /* valueof_name  */
  YYSYMBOL_data_records_clause = 1241,     /* data_records_clause  */
  YYSYMBOL_linage_clause = 1242,           /* linage_clause  */
  YYSYMBOL__linage_sequence = 1243,        /* _linage_sequence  */
  YYSYMBOL_linage_lines = 1244,            /* linage_lines  */
  YYSYMBOL_linage_footing = 1245,          /* linage_footing  */
  YYSYMBOL_linage_top = 1246,              /* linage_top  */
  YYSYMBOL_linage_bottom = 1247,           /* linage_bottom  */
  YYSYMBOL_recording_mode_clause = 1248,   /* recording_mode_clause  */
  YYSYMBOL_recording_mode = 1249,          /* recording_mode  */
  YYSYMBOL_u_or_s = 1250,                  /* u_or_s  */
  YYSYMBOL_code_set_clause = 1251,         /* code_set_clause  */
  YYSYMBOL__for_sub_records_clause = 1252, /* _for_sub_records_clause  */
  YYSYMBOL_report_clause = 1253,           /* report_clause  */
  YYSYMBOL_report_keyword = 1254,          /* report_keyword  */
  YYSYMBOL_rep_name_list = 1255,           /* rep_name_list  */
  YYSYMBOL_communication = 1256,           /* communication  */
  YYSYMBOL__communication_section = 1257,  /* _communication_section  */
  YYSYMBOL_1258_39 = 1258,                 /* $@39  */
  YYSYMBOL__communication_description_sequence = 1259, /* _communication_description_sequence  */
  YYSYMBOL_communication_description = 1260, /* communication_description  */
  YYSYMBOL_cd = 1261,                      /* cd  */
  YYSYMBOL_communication_description_entry = 1262, /* communication_description_entry  */
  YYSYMBOL_1263_40 = 1263,                 /* $@40  */
  YYSYMBOL__communication_description_clause_sequence = 1264, /* _communication_description_clause_sequence  */
  YYSYMBOL_communication_description_clause = 1265, /* communication_description_clause  */
  YYSYMBOL__input_cd_clauses = 1266,       /* _input_cd_clauses  */
  YYSYMBOL_named_input_cd_clauses = 1267,  /* named_input_cd_clauses  */
  YYSYMBOL_named_input_cd_clause = 1268,   /* named_input_cd_clause  */
  YYSYMBOL_unnamed_input_cd_clauses = 1269, /* unnamed_input_cd_clauses  */
  YYSYMBOL__output_cd_clauses = 1270,      /* _output_cd_clauses  */
  YYSYMBOL_output_cd_clauses = 1271,       /* output_cd_clauses  */
  YYSYMBOL_output_cd_clause = 1272,        /* output_cd_clause  */
  YYSYMBOL__i_o_cd_clauses = 1273,         /* _i_o_cd_clauses  */
  YYSYMBOL_named_i_o_cd_clauses = 1274,    /* named_i_o_cd_clauses  */
  YYSYMBOL_named_i_o_cd_clause = 1275,     /* named_i_o_cd_clause  */
  YYSYMBOL_unnamed_i_o_cd_clauses = 1276,  /* unnamed_i_o_cd_clauses  */
  YYSYMBOL_working_storage = 1277,         /* working_storage  */
  YYSYMBOL__working_storage_section = 1278, /* _working_storage_section  */
  YYSYMBOL_1279_41 = 1279,                 /* $@41  */
  YYSYMBOL__record_description_list = 1280, /* _record_description_list  */
  YYSYMBOL_1281_42 = 1281,                 /* $@42  */
  YYSYMBOL_record_description_list = 1282, /* record_description_list  */
  YYSYMBOL_data_description = 1283,        /* data_description  */
  YYSYMBOL_1284_43 = 1284,                 /* $@43  */
  YYSYMBOL_level_number = 1285,            /* level_number  */
  YYSYMBOL__filler = 1286,                 /* _filler  */
  YYSYMBOL__entry_name = 1287,             /* _entry_name  */
  YYSYMBOL_user_entry_name = 1288,         /* user_entry_name  */
  YYSYMBOL__const_global = 1289,           /* _const_global  */
  YYSYMBOL_lit_or_length = 1290,           /* lit_or_length  */
  YYSYMBOL_con_source = 1291,              /* con_source  */
  YYSYMBOL_fp32_usage = 1292,              /* fp32_usage  */
  YYSYMBOL_fp64_usage = 1293,              /* fp64_usage  */
  YYSYMBOL_fp128_usage = 1294,             /* fp128_usage  */
  YYSYMBOL_pointer_len = 1295,             /* pointer_len  */
  YYSYMBOL_renames_entry = 1296,           /* renames_entry  */
  YYSYMBOL__renames_thru = 1297,           /* _renames_thru  */
  YYSYMBOL_condition_name_entry = 1298,    /* condition_name_entry  */
  YYSYMBOL_1299_44 = 1299,                 /* $@44  */
  YYSYMBOL__user_entry_name = 1300,        /* _user_entry_name  */
  YYSYMBOL_constant_entry = 1301,          /* constant_entry  */
  YYSYMBOL_1302_45 = 1302,                 /* $@45  */
  YYSYMBOL_constant_source = 1303,         /* constant_source  */
  YYSYMBOL_constant_78_source = 1304,      /* constant_78_source  */
  YYSYMBOL_constant_expression_list = 1305, /* constant_expression_list  */
  YYSYMBOL_constant_expression = 1306,     /* constant_expression  */
  YYSYMBOL__data_description_clause_sequence = 1307, /* _data_description_clause_sequence  */
  YYSYMBOL_data_description_clause_sequence = 1308, /* data_description_clause_sequence  */
  YYSYMBOL_data_description_clause = 1309, /* data_description_clause  */
  YYSYMBOL_redefines_clause = 1310,        /* redefines_clause  */
  YYSYMBOL_like_clause = 1311,             /* like_clause  */
  YYSYMBOL__length_modifier = 1312,        /* _length_modifier  */
  YYSYMBOL_length_modifier = 1313,         /* length_modifier  */
  YYSYMBOL_same_as_clause = 1314,          /* same_as_clause  */
  YYSYMBOL_typedef_clause = 1315,          /* typedef_clause  */
  YYSYMBOL__strong = 1316,                 /* _strong  */
  YYSYMBOL_external_clause = 1317,         /* external_clause  */
  YYSYMBOL__as_extname = 1318,             /* _as_extname  */
  YYSYMBOL__global_clause = 1319,          /* _global_clause  */
  YYSYMBOL_global_clause = 1320,           /* global_clause  */
  YYSYMBOL_special_names_clause = 1321,    /* special_names_clause  */
  YYSYMBOL_1322_46 = 1322,                 /* $@46  */
  YYSYMBOL_special_names_target = 1323,    /* special_names_target  */
  YYSYMBOL_select_when_clause = 1324,      /* select_when_clause  */
  YYSYMBOL_1325_47 = 1325,                 /* $@47  */
  YYSYMBOL_when_choice = 1326,             /* when_choice  */
  YYSYMBOL_format_clause = 1327,           /* format_clause  */
  YYSYMBOL_format_choice = 1328,           /* format_choice  */
  YYSYMBOL_volatile_clause = 1329,         /* volatile_clause  */
  YYSYMBOL_picture_clause = 1330,          /* picture_clause  */
  YYSYMBOL_1331_48 = 1331,                 /* $@48  */
  YYSYMBOL__pic_locale_format_or_depending_on_or_byte_length = 1332, /* _pic_locale_format_or_depending_on_or_byte_length  */
  YYSYMBOL__is_locale_name = 1333,         /* _is_locale_name  */
  YYSYMBOL_locale_name = 1334,             /* locale_name  */
  YYSYMBOL_type_to_clause = 1335,          /* type_to_clause  */
  YYSYMBOL_usage_clause = 1336,            /* usage_clause  */
  YYSYMBOL_usage_clause_screen_report = 1337, /* usage_clause_screen_report  */
  YYSYMBOL__usage_is = 1338,               /* _usage_is  */
  YYSYMBOL_usage_screen_report = 1339,     /* usage_screen_report  */
  YYSYMBOL_usage = 1340,                   /* usage  */
  YYSYMBOL__to_program_type = 1341,        /* _to_program_type  */
  YYSYMBOL__to_type_name = 1342,           /* _to_type_name  */
  YYSYMBOL_conflict_usage = 1343,          /* conflict_usage  */
  YYSYMBOL__object_reference_type = 1344,  /* _object_reference_type  */
  YYSYMBOL__factory_of = 1345,             /* _factory_of  */
  YYSYMBOL__only = 1346,                   /* _only  */
  YYSYMBOL_double_usage = 1347,            /* double_usage  */
  YYSYMBOL_long_double = 1348,             /* long_double  */
  YYSYMBOL__font_name = 1349,              /* _font_name  */
  YYSYMBOL__layout_name = 1350,            /* _layout_name  */
  YYSYMBOL_sign_clause = 1351,             /* sign_clause  */
  YYSYMBOL_byte_length_clause = 1352,      /* byte_length_clause  */
  YYSYMBOL_report_occurs_clause = 1353,    /* report_occurs_clause  */
  YYSYMBOL_report_occurs_step = 1354,      /* report_occurs_step  */
  YYSYMBOL_occurs_clause = 1355,           /* occurs_clause  */
  YYSYMBOL__occurs_from_integer = 1356,    /* _occurs_from_integer  */
  YYSYMBOL__occurs_to_integer = 1357,      /* _occurs_to_integer  */
  YYSYMBOL__occurs_integer_to = 1358,      /* _occurs_integer_to  */
  YYSYMBOL__occurs_depending = 1359,       /* _occurs_depending  */
  YYSYMBOL__capacity_in = 1360,            /* _capacity_in  */
  YYSYMBOL__occurs_initialized = 1361,     /* _occurs_initialized  */
  YYSYMBOL__occurs_keys_and_indexed = 1362, /* _occurs_keys_and_indexed  */
  YYSYMBOL_1363_49 = 1363,                 /* $@49  */
  YYSYMBOL_occurs_keys = 1364,             /* occurs_keys  */
  YYSYMBOL_occurs_key_list = 1365,         /* occurs_key_list  */
  YYSYMBOL_occurs_key_field = 1366,        /* occurs_key_field  */
  YYSYMBOL_ascending_or_descending = 1367, /* ascending_or_descending  */
  YYSYMBOL__occurs_indexed = 1368,         /* _occurs_indexed  */
  YYSYMBOL_occurs_indexed = 1369,          /* occurs_indexed  */
  YYSYMBOL_occurs_index_list = 1370,       /* occurs_index_list  */
  YYSYMBOL_occurs_index = 1371,            /* occurs_index  */
  YYSYMBOL_justified_clause = 1372,        /* justified_clause  */
  YYSYMBOL_synchronized_clause = 1373,     /* synchronized_clause  */
  YYSYMBOL__left_or_right = 1374,          /* _left_or_right  */
  YYSYMBOL_blank_clause = 1375,            /* blank_clause  */
  YYSYMBOL_based_clause = 1376,            /* based_clause  */
  YYSYMBOL_value_clause = 1377,            /* value_clause  */
  YYSYMBOL_value_table_item_list = 1378,   /* value_table_item_list  */
  YYSYMBOL_value_table_item = 1379,        /* value_table_item  */
  YYSYMBOL_value_from_subscripts_is_are = 1380, /* value_from_subscripts_is_are  */
  YYSYMBOL_from_subscripts = 1381,         /* from_subscripts  */
  YYSYMBOL__to_subscripts = 1382,          /* _to_subscripts  */
  YYSYMBOL_from_to_subscripts = 1383,      /* from_to_subscripts  */
  YYSYMBOL__repeated_phrase = 1384,        /* _repeated_phrase  */
  YYSYMBOL_repeated_phrase = 1385,         /* repeated_phrase  */
  YYSYMBOL_subscripts = 1386,              /* subscripts  */
  YYSYMBOL_value_is_are = 1387,            /* value_is_are  */
  YYSYMBOL_value_item_list = 1388,         /* value_item_list  */
  YYSYMBOL_value_item = 1389,              /* value_item  */
  YYSYMBOL_value_clause_report = 1390,     /* value_clause_report  */
  YYSYMBOL_value_clause_condition = 1391,  /* value_clause_condition  */
  YYSYMBOL_1392_50 = 1392,                 /* $@50  */
  YYSYMBOL_value_item_list_in_alphabet = 1393, /* value_item_list_in_alphabet  */
  YYSYMBOL_value_item_condition_list = 1394, /* value_item_condition_list  */
  YYSYMBOL_value_item_condition = 1395,    /* value_item_condition  */
  YYSYMBOL__false_or_content_validation = 1396, /* _false_or_content_validation  */
  YYSYMBOL_false_is = 1397,                /* false_is  */
  YYSYMBOL_content_validation = 1398,      /* content_validation  */
  YYSYMBOL_valid_or_invalid = 1399,        /* valid_or_invalid  */
  YYSYMBOL__when_condition = 1400,         /* _when_condition  */
  YYSYMBOL_validate_status_clause = 1401,  /* validate_status_clause  */
  YYSYMBOL_when_error_choice = 1402,       /* when_error_choice  */
  YYSYMBOL__on_choice = 1403,              /* _on_choice  */
  YYSYMBOL_default_clause = 1404,          /* default_clause  */
  YYSYMBOL_x_or_none = 1405,               /* x_or_none  */
  YYSYMBOL_class_clause = 1406,            /* class_clause  */
  YYSYMBOL_class_option = 1407,            /* class_option  */
  YYSYMBOL_destination_clause = 1408,      /* destination_clause  */
  YYSYMBOL_present_when_clause = 1409,     /* present_when_clause  */
  YYSYMBOL_invalid_when_clause = 1410,     /* invalid_when_clause  */
  YYSYMBOL_any_length_clause = 1411,       /* any_length_clause  */
  YYSYMBOL_external_form_clause = 1412,    /* external_form_clause  */
  YYSYMBOL_identified_by_clause = 1413,    /* identified_by_clause  */
  YYSYMBOL_local_storage = 1414,           /* local_storage  */
  YYSYMBOL__local_storage_section = 1415,  /* _local_storage_section  */
  YYSYMBOL_1416_51 = 1416,                 /* $@51  */
  YYSYMBOL_linkage = 1417,                 /* linkage  */
  YYSYMBOL__linkage_section = 1418,        /* _linkage_section  */
  YYSYMBOL_1419_52 = 1419,                 /* $@52  */
  YYSYMBOL__report_section = 1420,         /* _report_section  */
  YYSYMBOL_1421_53 = 1421,                 /* $@53  */
  YYSYMBOL_1422_54 = 1422,                 /* $@54  */
  YYSYMBOL__report_description_sequence = 1423, /* _report_description_sequence  */
  YYSYMBOL_report_description = 1424,      /* report_description  */
  YYSYMBOL_1425_55 = 1425,                 /* $@55  */
  YYSYMBOL_1426_56 = 1426,                 /* $@56  */
  YYSYMBOL__report_description_options = 1427, /* _report_description_options  */
  YYSYMBOL_report_description_option = 1428, /* report_description_option  */
  YYSYMBOL_control_clause = 1429,          /* control_clause  */
  YYSYMBOL_control_field_list = 1430,      /* control_field_list  */
  YYSYMBOL_control_final_tag = 1431,       /* control_final_tag  */
  YYSYMBOL_control_identifier_list = 1432, /* control_identifier_list  */
  YYSYMBOL_control_identifier = 1433,      /* control_identifier  */
  YYSYMBOL_page_limit_clause = 1434,       /* page_limit_clause  */
  YYSYMBOL_page_line_column = 1435,        /* page_line_column  */
  YYSYMBOL_page_limit_cols = 1436,         /* page_limit_cols  */
  YYSYMBOL_integer_or_zero_or_ident = 1437, /* integer_or_zero_or_ident  */
  YYSYMBOL__page_heading_list = 1438,      /* _page_heading_list  */
  YYSYMBOL_page_detail = 1439,             /* page_detail  */
  YYSYMBOL_heading_clause = 1440,          /* heading_clause  */
  YYSYMBOL_first_detail = 1441,            /* first_detail  */
  YYSYMBOL_last_heading = 1442,            /* last_heading  */
  YYSYMBOL_last_detail = 1443,             /* last_detail  */
  YYSYMBOL_footing_clause = 1444,          /* footing_clause  */
  YYSYMBOL__report_group_description_list = 1445, /* _report_group_description_list  */
  YYSYMBOL_report_group_description_entry = 1446, /* report_group_description_entry  */
  YYSYMBOL_1447_57 = 1447,                 /* $@57  */
  YYSYMBOL__report_group_options = 1448,   /* _report_group_options  */
  YYSYMBOL_report_group_option = 1449,     /* report_group_option  */
  YYSYMBOL_type_is_clause = 1450,          /* type_is_clause  */
  YYSYMBOL_type_option = 1451,             /* type_option  */
  YYSYMBOL__control_heading_final = 1452,  /* _control_heading_final  */
  YYSYMBOL__or_page = 1453,                /* _or_page  */
  YYSYMBOL__control_footing_final = 1454,  /* _control_footing_final  */
  YYSYMBOL_next_group_clause = 1455,       /* next_group_clause  */
  YYSYMBOL_next_group_plus = 1456,         /* next_group_plus  */
  YYSYMBOL_next_page = 1457,               /* next_page  */
  YYSYMBOL_sum_clause_list = 1458,         /* sum_clause_list  */
  YYSYMBOL__reset_clause = 1459,           /* _reset_clause  */
  YYSYMBOL_data_or_final = 1460,           /* data_or_final  */
  YYSYMBOL_present_when_condition = 1461,  /* present_when_condition  */
  YYSYMBOL_present_absent = 1462,          /* present_absent  */
  YYSYMBOL__page_or_id = 1463,             /* _page_or_id  */
  YYSYMBOL_page_or_ids = 1464,             /* page_or_ids  */
  YYSYMBOL_data_varying_clause = 1465,     /* data_varying_clause  */
  YYSYMBOL_data_varying_list = 1466,       /* data_varying_list  */
  YYSYMBOL_data_varying = 1467,            /* data_varying  */
  YYSYMBOL__var_from = 1468,               /* _var_from  */
  YYSYMBOL__var_by = 1469,                 /* _var_by  */
  YYSYMBOL_line_clause = 1470,             /* line_clause  */
  YYSYMBOL_line_keyword_clause = 1471,     /* line_keyword_clause  */
  YYSYMBOL__line_clause_options = 1472,    /* _line_clause_options  */
  YYSYMBOL_line_clause_option = 1473,      /* line_clause_option  */
  YYSYMBOL_column_clause = 1474,           /* column_clause  */
  YYSYMBOL_col_keyword_clause = 1475,      /* col_keyword_clause  */
  YYSYMBOL__orientation = 1476,            /* _orientation  */
  YYSYMBOL__left_right_center = 1477,      /* _left_right_center  */
  YYSYMBOL_col_or_plus = 1478,             /* col_or_plus  */
  YYSYMBOL_column_integer_list = 1479,     /* column_integer_list  */
  YYSYMBOL_column_integer = 1480,          /* column_integer  */
  YYSYMBOL_source_clause = 1481,           /* source_clause  */
  YYSYMBOL_group_indicate_clause = 1482,   /* group_indicate_clause  */
  YYSYMBOL__screen_section = 1483,         /* _screen_section  */
  YYSYMBOL_1484_58 = 1484,                 /* $@58  */
  YYSYMBOL_1485_59 = 1485,                 /* $@59  */
  YYSYMBOL__screen_description_list = 1486, /* _screen_description_list  */
  YYSYMBOL_screen_description_list = 1487, /* screen_description_list  */
  YYSYMBOL_screen_description = 1488,      /* screen_description  */
  YYSYMBOL_1489_60 = 1489,                 /* $@60  */
  YYSYMBOL_1490_61 = 1490,                 /* $@61  */
  YYSYMBOL_1491_62 = 1491,                 /* $@62  */
  YYSYMBOL__screen_options = 1492,         /* _screen_options  */
  YYSYMBOL_screen_option = 1493,           /* screen_option  */
  YYSYMBOL_screen_value_clause = 1494,     /* screen_value_clause  */
  YYSYMBOL__value_is = 1495,               /* _value_is  */
  YYSYMBOL_control_definition = 1496,      /* control_definition  */
  YYSYMBOL_control_type_name = 1497,       /* control_type_name  */
  YYSYMBOL_control_type = 1498,            /* control_type  */
  YYSYMBOL_control_item = 1499,            /* control_item  */
  YYSYMBOL__control_attributes = 1500,     /* _control_attributes  */
  YYSYMBOL_control_attributes = 1501,      /* control_attributes  */
  YYSYMBOL_control_attribute = 1502,       /* control_attribute  */
  YYSYMBOL_control_style = 1503,           /* control_style  */
  YYSYMBOL_control_property = 1504,        /* control_property  */
  YYSYMBOL_control_style_name = 1505,      /* control_style_name  */
  YYSYMBOL_control_property_name = 1506,   /* control_property_name  */
  YYSYMBOL_control_style_name_generic = 1507, /* control_style_name_generic  */
  YYSYMBOL_control_property_name_generic = 1508, /* control_property_name_generic  */
  YYSYMBOL_control_style_name_label = 1509, /* control_style_name_label  */
  YYSYMBOL_control_property_name_label = 1510, /* control_property_name_label  */
  YYSYMBOL_control_style_name_entry_field = 1511, /* control_style_name_entry_field  */
  YYSYMBOL_control_property_name_entry_field = 1512, /* control_property_name_entry_field  */
  YYSYMBOL_control_style_name_push_button = 1513, /* control_style_name_push_button  */
  YYSYMBOL_control_property_name_push_button = 1514, /* control_property_name_push_button  */
  YYSYMBOL_control_style_name_check_box = 1515, /* control_style_name_check_box  */
  YYSYMBOL_control_property_name_radio_button = 1516, /* control_property_name_radio_button  */
  YYSYMBOL_control_style_name_list_box = 1517, /* control_style_name_list_box  */
  YYSYMBOL_control_property_name_list_box = 1518, /* control_property_name_list_box  */
  YYSYMBOL_control_style_name_combo_box = 1519, /* control_style_name_combo_box  */
  YYSYMBOL_control_style_name_frame = 1520, /* control_style_name_frame  */
  YYSYMBOL_control_property_name_frame = 1521, /* control_property_name_frame  */
  YYSYMBOL_control_style_name_tab_control = 1522, /* control_style_name_tab_control  */
  YYSYMBOL_control_property_name_tab_control = 1523, /* control_property_name_tab_control  */
  YYSYMBOL_control_style_name_bar = 1524,  /* control_style_name_bar  */
  YYSYMBOL_control_property_name_bar = 1525, /* control_property_name_bar  */
  YYSYMBOL_control_property_name_bitmap = 1526, /* control_property_name_bitmap  */
  YYSYMBOL_control_style_name_grid = 1527, /* control_style_name_grid  */
  YYSYMBOL_control_property_name_grid = 1528, /* control_property_name_grid  */
  YYSYMBOL_control_style_name_tree_view = 1529, /* control_style_name_tree_view  */
  YYSYMBOL_control_property_name_tree_view = 1530, /* control_property_name_tree_view  */
  YYSYMBOL_control_property_name_web_browser = 1531, /* control_property_name_web_browser  */
  YYSYMBOL_control_style_name_activex = 1532, /* control_style_name_activex  */
  YYSYMBOL_control_property_name_activex = 1533, /* control_property_name_activex  */
  YYSYMBOL_control_style_name_date_entry = 1534, /* control_style_name_date_entry  */
  YYSYMBOL_control_property_name_date_entry = 1535, /* control_property_name_date_entry  */
  YYSYMBOL_control_style_type = 1536,      /* control_style_type  */
  YYSYMBOL_control_property_type = 1537,   /* control_property_type  */
  YYSYMBOL_changeable_control_properties = 1538, /* changeable_control_properties  */
  YYSYMBOL_changeable_control_property = 1539, /* changeable_control_property  */
  YYSYMBOL_changeable_window_properties = 1540, /* changeable_window_properties  */
  YYSYMBOL_changeable_window_property = 1541, /* changeable_window_property  */
  YYSYMBOL_eol = 1542,                     /* eol  */
  YYSYMBOL_eos = 1543,                     /* eos  */
  YYSYMBOL__plus = 1544,                   /* _plus  */
  YYSYMBOL_plus = 1545,                    /* plus  */
  YYSYMBOL_plus_tokens = 1546,             /* plus_tokens  */
  YYSYMBOL_minus = 1547,                   /* minus  */
  YYSYMBOL_minus_tokens = 1548,            /* minus_tokens  */
  YYSYMBOL_control_size = 1549,            /* control_size  */
  YYSYMBOL_control_size_unit = 1550,       /* control_size_unit  */
  YYSYMBOL__cell = 1551,                   /* _cell  */
  YYSYMBOL_screen_line_number = 1552,      /* screen_line_number  */
  YYSYMBOL__screen_line_plus_minus = 1553, /* _screen_line_plus_minus  */
  YYSYMBOL_screen_col_number = 1554,       /* screen_col_number  */
  YYSYMBOL__screen_col_plus_minus = 1555,  /* _screen_col_plus_minus  */
  YYSYMBOL_screen_occurs_clause = 1556,    /* screen_occurs_clause  */
  YYSYMBOL_screen_global_clause = 1557,    /* screen_global_clause  */
  YYSYMBOL__prototype_data_division = 1558, /* _prototype_data_division  */
  YYSYMBOL__procedure_division = 1559,     /* _procedure_division  */
  YYSYMBOL_procedure_division = 1560,      /* procedure_division  */
  YYSYMBOL_1561_63 = 1561,                 /* $@63  */
  YYSYMBOL_1562_64 = 1562,                 /* $@64  */
  YYSYMBOL_1563_65 = 1563,                 /* $@65  */
  YYSYMBOL_1564_66 = 1564,                 /* $@66  */
  YYSYMBOL_1565_67 = 1565,                 /* $@67  */
  YYSYMBOL__procedure_using_chaining = 1566, /* _procedure_using_chaining  */
  YYSYMBOL_1567_68 = 1567,                 /* $@68  */
  YYSYMBOL_1568_69 = 1568,                 /* $@69  */
  YYSYMBOL_procedure_param_list = 1569,    /* procedure_param_list  */
  YYSYMBOL_procedure_param = 1570,         /* procedure_param  */
  YYSYMBOL__procedure_type = 1571,         /* _procedure_type  */
  YYSYMBOL__size_optional = 1572,          /* _size_optional  */
  YYSYMBOL_using_size_clause = 1573,       /* using_size_clause  */
  YYSYMBOL_size_is_integer = 1574,         /* size_is_integer  */
  YYSYMBOL__acu_size = 1575,               /* _acu_size  */
  YYSYMBOL__procedure_optional = 1576,     /* _procedure_optional  */
  YYSYMBOL__procedure_returning = 1577,    /* _procedure_returning  */
  YYSYMBOL__procedure_declaratives = 1578, /* _procedure_declaratives  */
  YYSYMBOL_1579_70 = 1579,                 /* $@70  */
  YYSYMBOL_1580_71 = 1580,                 /* $@71  */
  YYSYMBOL_1581_72 = 1581,                 /* $@72  */
  YYSYMBOL__procedure_list = 1582,         /* _procedure_list  */
  YYSYMBOL_procedure = 1583,               /* procedure  */
  YYSYMBOL_1584_73 = 1584,                 /* $@73  */
  YYSYMBOL_proc_name = 1585,               /* proc_name  */
  YYSYMBOL_section_header = 1586,          /* section_header  */
  YYSYMBOL_1587_74 = 1587,                 /* $@74  */
  YYSYMBOL__use_statement = 1588,          /* _use_statement  */
  YYSYMBOL_paragraph_header = 1589,        /* paragraph_header  */
  YYSYMBOL_invalid_statement = 1590,       /* invalid_statement  */
  YYSYMBOL__segment = 1591,                /* _segment  */
  YYSYMBOL_statement_list = 1592,          /* statement_list  */
  YYSYMBOL_1593_75 = 1593,                 /* @75  */
  YYSYMBOL_1594_76 = 1594,                 /* @76  */
  YYSYMBOL_statements = 1595,              /* statements  */
  YYSYMBOL_1596_77 = 1596,                 /* $@77  */
  YYSYMBOL_statement = 1597,               /* statement  */
  YYSYMBOL_1598_78 = 1598,                 /* $@78  */
  YYSYMBOL_accept_statement = 1599,        /* accept_statement  */
  YYSYMBOL_1600_79 = 1600,                 /* $@79  */
  YYSYMBOL_accept_body = 1601,             /* accept_body  */
  YYSYMBOL_1602_80 = 1602,                 /* $@80  */
  YYSYMBOL_1603_81 = 1603,                 /* $@81  */
  YYSYMBOL_accp_identifier = 1604,         /* accp_identifier  */
  YYSYMBOL_field_with_pos_specifier = 1605, /* field_with_pos_specifier  */
  YYSYMBOL_1606_82 = 1606,                 /* $@82  */
  YYSYMBOL__pos_specifier = 1607,          /* _pos_specifier  */
  YYSYMBOL_pos_specifier = 1608,           /* pos_specifier  */
  YYSYMBOL_pos_specifier_value = 1609,     /* pos_specifier_value  */
  YYSYMBOL_identifier_or_numeric_literal = 1610, /* identifier_or_numeric_literal  */
  YYSYMBOL__accept_clauses = 1611,         /* _accept_clauses  */
  YYSYMBOL_accept_clauses = 1612,          /* accept_clauses  */
  YYSYMBOL_accept_clause = 1613,           /* accept_clause  */
  YYSYMBOL_accept_from_screen_clauses = 1614, /* accept_from_screen_clauses  */
  YYSYMBOL_accept_from_screen_clause = 1615, /* accept_from_screen_clause  */
  YYSYMBOL_lines_or_number = 1616,         /* lines_or_number  */
  YYSYMBOL_at_line_column = 1617,          /* at_line_column  */
  YYSYMBOL_line_number = 1618,             /* line_number  */
  YYSYMBOL_column_number = 1619,           /* column_number  */
  YYSYMBOL_mode_is_block = 1620,           /* mode_is_block  */
  YYSYMBOL_accp_attr = 1621,               /* accp_attr  */
  YYSYMBOL__key_dest = 1622,               /* _key_dest  */
  YYSYMBOL_key_dest = 1623,                /* key_dest  */
  YYSYMBOL_no_echo = 1624,                 /* no_echo  */
  YYSYMBOL_reverse_video = 1625,           /* reverse_video  */
  YYSYMBOL_update_default = 1626,          /* update_default  */
  YYSYMBOL__end_accept = 1627,             /* _end_accept  */
  YYSYMBOL_add_statement = 1628,           /* add_statement  */
  YYSYMBOL_1629_83 = 1629,                 /* $@83  */
  YYSYMBOL_add_body = 1630,                /* add_body  */
  YYSYMBOL__add_to = 1631,                 /* _add_to  */
  YYSYMBOL__end_add = 1632,                /* _end_add  */
  YYSYMBOL_allocate_statement = 1633,      /* allocate_statement  */
  YYSYMBOL_1634_84 = 1634,                 /* $@84  */
  YYSYMBOL_allocate_body = 1635,           /* allocate_body  */
  YYSYMBOL__loc = 1636,                    /* _loc  */
  YYSYMBOL__allocate_returning = 1637,     /* _allocate_returning  */
  YYSYMBOL_alter_statement = 1638,         /* alter_statement  */
  YYSYMBOL_1639_85 = 1639,                 /* $@85  */
  YYSYMBOL_alter_body = 1640,              /* alter_body  */
  YYSYMBOL_alter_entry = 1641,             /* alter_entry  */
  YYSYMBOL__proceed_to = 1642,             /* _proceed_to  */
  YYSYMBOL_call_statement = 1643,          /* call_statement  */
  YYSYMBOL_1644_86 = 1644,                 /* $@86  */
  YYSYMBOL_call_body = 1645,               /* call_body  */
  YYSYMBOL_1646_87 = 1646,                 /* $@87  */
  YYSYMBOL__conv_linkage = 1647,           /* _conv_linkage  */
  YYSYMBOL_1648_88 = 1648,                 /* $@88  */
  YYSYMBOL_conv_linkage_option = 1649,     /* conv_linkage_option  */
  YYSYMBOL__mnemonic_conv = 1650,          /* _mnemonic_conv  */
  YYSYMBOL_mnemonic_conv = 1651,           /* mnemonic_conv  */
  YYSYMBOL_program_or_prototype = 1652,    /* program_or_prototype  */
  YYSYMBOL__id_or_lit_or_func_as = 1653,   /* _id_or_lit_or_func_as  */
  YYSYMBOL_nested_or_prototype = 1654,     /* nested_or_prototype  */
  YYSYMBOL_call_using = 1655,              /* call_using  */
  YYSYMBOL_1656_89 = 1656,                 /* $@89  */
  YYSYMBOL_call_param_list = 1657,         /* call_param_list  */
  YYSYMBOL_call_param = 1658,              /* call_param  */
  YYSYMBOL__call_type = 1659,              /* _call_type  */
  YYSYMBOL_call_returning = 1660,          /* call_returning  */
  YYSYMBOL_return_give = 1661,             /* return_give  */
  YYSYMBOL_null_or_omitted = 1662,         /* null_or_omitted  */
  YYSYMBOL_call_exception_phrases = 1663,  /* call_exception_phrases  */
  YYSYMBOL__call_on_exception = 1664,      /* _call_on_exception  */
  YYSYMBOL_call_on_exception = 1665,       /* call_on_exception  */
  YYSYMBOL__call_not_on_exception = 1666,  /* _call_not_on_exception  */
  YYSYMBOL_call_not_on_exception = 1667,   /* call_not_on_exception  */
  YYSYMBOL__end_call = 1668,               /* _end_call  */
  YYSYMBOL_cancel_statement = 1669,        /* cancel_statement  */
  YYSYMBOL_1670_90 = 1670,                 /* $@90  */
  YYSYMBOL_cancel_body = 1671,             /* cancel_body  */
  YYSYMBOL_cancel_list = 1672,             /* cancel_list  */
  YYSYMBOL_id_or_lit_or_program_name = 1673, /* id_or_lit_or_program_name  */
  YYSYMBOL_close_statement = 1674,         /* close_statement  */
  YYSYMBOL_1675_91 = 1675,                 /* $@91  */
  YYSYMBOL_close_body = 1676,              /* close_body  */
  YYSYMBOL_close_files = 1677,             /* close_files  */
  YYSYMBOL__close_option = 1678,           /* _close_option  */
  YYSYMBOL_close_window = 1679,            /* close_window  */
  YYSYMBOL_1680_92 = 1680,                 /* $@92  */
  YYSYMBOL__close_display_option = 1681,   /* _close_display_option  */
  YYSYMBOL_compute_statement = 1682,       /* compute_statement  */
  YYSYMBOL_1683_93 = 1683,                 /* $@93  */
  YYSYMBOL_compute_body = 1684,            /* compute_body  */
  YYSYMBOL__end_compute = 1685,            /* _end_compute  */
  YYSYMBOL_commit_statement = 1686,        /* commit_statement  */
  YYSYMBOL_continue_statement = 1687,      /* continue_statement  */
  YYSYMBOL_1688_94 = 1688,                 /* $@94  */
  YYSYMBOL__continue_after_phrase = 1689,  /* _continue_after_phrase  */
  YYSYMBOL_1690_95 = 1690,                 /* $@95  */
  YYSYMBOL_destroy_statement = 1691,       /* destroy_statement  */
  YYSYMBOL_1692_96 = 1692,                 /* $@96  */
  YYSYMBOL_destroy_body = 1693,            /* destroy_body  */
  YYSYMBOL_delete_statement = 1694,        /* delete_statement  */
  YYSYMBOL_1695_97 = 1695,                 /* $@97  */
  YYSYMBOL_delete_body = 1696,             /* delete_body  */
  YYSYMBOL_delete_file_list = 1697,        /* delete_file_list  */
  YYSYMBOL__end_delete = 1698,             /* _end_delete  */
  YYSYMBOL_disable_statement = 1699,       /* disable_statement  */
  YYSYMBOL_1700_98 = 1700,                 /* $@98  */
  YYSYMBOL_enable_disable_handling = 1701, /* enable_disable_handling  */
  YYSYMBOL__enable_disable_key = 1702,     /* _enable_disable_key  */
  YYSYMBOL_communication_mode = 1703,      /* communication_mode  */
  YYSYMBOL_display_statement = 1704,       /* display_statement  */
  YYSYMBOL_1705_99 = 1705,                 /* $@99  */
  YYSYMBOL_display_body = 1706,            /* display_body  */
  YYSYMBOL_screen_or_device_display = 1707, /* screen_or_device_display  */
  YYSYMBOL_display_list = 1708,            /* display_list  */
  YYSYMBOL_display_atom = 1709,            /* display_atom  */
  YYSYMBOL_1710_100 = 1710,                /* $@100  */
  YYSYMBOL_disp_list = 1711,               /* disp_list  */
  YYSYMBOL__with_display_attr = 1712,      /* _with_display_attr  */
  YYSYMBOL_display_attrs = 1713,           /* display_attrs  */
  YYSYMBOL_display_clauses = 1714,         /* display_clauses  */
  YYSYMBOL_display_clause = 1715,          /* display_clause  */
  YYSYMBOL__display_upon = 1716,           /* _display_upon  */
  YYSYMBOL_display_upon = 1717,            /* display_upon  */
  YYSYMBOL_crt_under = 1718,               /* crt_under  */
  YYSYMBOL_display_erase = 1719,           /* display_erase  */
  YYSYMBOL_1720_101 = 1720,                /* $@101  */
  YYSYMBOL_display_pos_specifier = 1721,   /* display_pos_specifier  */
  YYSYMBOL_field_or_literal_or_erase_with_pos_specifier = 1722, /* field_or_literal_or_erase_with_pos_specifier  */
  YYSYMBOL_1723_102 = 1723,                /* $@102  */
  YYSYMBOL_field_or_literal_or_erase_list = 1724, /* field_or_literal_or_erase_list  */
  YYSYMBOL_field_or_literal_or_erase = 1725, /* field_or_literal_or_erase  */
  YYSYMBOL_display_message_box = 1726,     /* display_message_box  */
  YYSYMBOL_1727_103 = 1727,                /* $@103  */
  YYSYMBOL__display_message_clauses = 1728, /* _display_message_clauses  */
  YYSYMBOL_display_message_clauses = 1729, /* display_message_clauses  */
  YYSYMBOL_display_message_clause = 1730,  /* display_message_clause  */
  YYSYMBOL_display_window = 1731,          /* display_window  */
  YYSYMBOL_1732_104 = 1732,                /* $@104  */
  YYSYMBOL_1733_105 = 1733,                /* $@105  */
  YYSYMBOL_sub_or_window = 1734,           /* sub_or_window  */
  YYSYMBOL_display_floating_window = 1735, /* display_floating_window  */
  YYSYMBOL_1736_106 = 1736,                /* $@106  */
  YYSYMBOL_1737_107 = 1737,                /* $@107  */
  YYSYMBOL_display_initial_window = 1738,  /* display_initial_window  */
  YYSYMBOL_1739_108 = 1739,                /* $@108  */
  YYSYMBOL_initial_type = 1740,            /* initial_type  */
  YYSYMBOL__graphical = 1741,              /* _graphical  */
  YYSYMBOL__upon_window_handle = 1742,     /* _upon_window_handle  */
  YYSYMBOL_window_handle = 1743,           /* window_handle  */
  YYSYMBOL_display_window_clauses = 1744,  /* display_window_clauses  */
  YYSYMBOL_display_window_clause = 1745,   /* display_window_clause  */
  YYSYMBOL_shadow = 1746,                  /* shadow  */
  YYSYMBOL_boxed = 1747,                   /* boxed  */
  YYSYMBOL__top_or_bottom = 1748,          /* _top_or_bottom  */
  YYSYMBOL__left_or_centered_or_right = 1749, /* _left_or_centered_or_right  */
  YYSYMBOL_no_scroll_wrap = 1750,          /* no_scroll_wrap  */
  YYSYMBOL_pop_up_or_handle = 1751,        /* pop_up_or_handle  */
  YYSYMBOL_pop_up_area = 1752,             /* pop_up_area  */
  YYSYMBOL_handle_is_in = 1753,            /* handle_is_in  */
  YYSYMBOL_disp_attr = 1754,               /* disp_attr  */
  YYSYMBOL__end_display = 1755,            /* _end_display  */
  YYSYMBOL_divide_statement = 1756,        /* divide_statement  */
  YYSYMBOL_1757_109 = 1757,                /* $@109  */
  YYSYMBOL_divide_body = 1758,             /* divide_body  */
  YYSYMBOL__end_divide = 1759,             /* _end_divide  */
  YYSYMBOL_enable_statement = 1760,        /* enable_statement  */
  YYSYMBOL_1761_110 = 1761,                /* $@110  */
  YYSYMBOL_entry = 1762,                   /* entry  */
  YYSYMBOL_entry_statement = 1763,         /* entry_statement  */
  YYSYMBOL_1764_111 = 1764,                /* $@111  */
  YYSYMBOL_1765_112 = 1765,                /* $@112  */
  YYSYMBOL_entry_body = 1766,              /* entry_body  */
  YYSYMBOL_entry_goto_body = 1767,         /* entry_goto_body  */
  YYSYMBOL_evaluate_statement = 1768,      /* evaluate_statement  */
  YYSYMBOL_1769_113 = 1769,                /* $@113  */
  YYSYMBOL_evaluate_body = 1770,           /* evaluate_body  */
  YYSYMBOL_evaluate_subject_list = 1771,   /* evaluate_subject_list  */
  YYSYMBOL_evaluate_subject = 1772,        /* evaluate_subject  */
  YYSYMBOL_evaluate_condition_list = 1773, /* evaluate_condition_list  */
  YYSYMBOL_evaluate_case_list = 1774,      /* evaluate_case_list  */
  YYSYMBOL_evaluate_case = 1775,           /* evaluate_case  */
  YYSYMBOL_evaluate_other = 1776,          /* evaluate_other  */
  YYSYMBOL_evaluate_when_list = 1777,      /* evaluate_when_list  */
  YYSYMBOL_1778_114 = 1778,                /* $@114  */
  YYSYMBOL_1779_115 = 1779,                /* $@115  */
  YYSYMBOL_evaluate_object_list = 1780,    /* evaluate_object_list  */
  YYSYMBOL_evaluate_object = 1781,         /* evaluate_object  */
  YYSYMBOL__evaluate_thru_expr = 1782,     /* _evaluate_thru_expr  */
  YYSYMBOL__end_evaluate = 1783,           /* _end_evaluate  */
  YYSYMBOL_exhibit_statement = 1784,       /* exhibit_statement  */
  YYSYMBOL_1785_116 = 1785,                /* $@116  */
  YYSYMBOL_exhibit_body = 1786,            /* exhibit_body  */
  YYSYMBOL_1787_117 = 1787,                /* $@117  */
  YYSYMBOL__changed = 1788,                /* _changed  */
  YYSYMBOL__named = 1789,                  /* _named  */
  YYSYMBOL__erase = 1790,                  /* _erase  */
  YYSYMBOL_exhibit_target_list = 1791,     /* exhibit_target_list  */
  YYSYMBOL_exhibit_target = 1792,          /* exhibit_target  */
  YYSYMBOL_exit_statement = 1793,          /* exit_statement  */
  YYSYMBOL_1794_118 = 1794,                /* $@118  */
  YYSYMBOL_exit_body = 1795,               /* exit_body  */
  YYSYMBOL_goback_exit_body = 1796,        /* goback_exit_body  */
  YYSYMBOL_free_statement = 1797,          /* free_statement  */
  YYSYMBOL_1798_119 = 1798,                /* $@119  */
  YYSYMBOL_free_body = 1799,               /* free_body  */
  YYSYMBOL_generate_statement = 1800,      /* generate_statement  */
  YYSYMBOL_1801_120 = 1801,                /* $@120  */
  YYSYMBOL_generate_body = 1802,           /* generate_body  */
  YYSYMBOL_goto_statement = 1803,          /* goto_statement  */
  YYSYMBOL_1804_121 = 1804,                /* $@121  */
  YYSYMBOL_go_body = 1805,                 /* go_body  */
  YYSYMBOL__goto_depending = 1806,         /* _goto_depending  */
  YYSYMBOL_goback_statement = 1807,        /* goback_statement  */
  YYSYMBOL_1808_122 = 1808,                /* $@122  */
  YYSYMBOL_if_statement = 1809,            /* if_statement  */
  YYSYMBOL_1810_123 = 1810,                /* $@123  */
  YYSYMBOL_if_else_statements = 1811,      /* if_else_statements  */
  YYSYMBOL__if_then = 1812,                /* _if_then  */
  YYSYMBOL_if_true = 1813,                 /* if_true  */
  YYSYMBOL_if_false = 1814,                /* if_false  */
  YYSYMBOL__end_if = 1815,                 /* _end_if  */
  YYSYMBOL_initialize_statement = 1816,    /* initialize_statement  */
  YYSYMBOL_1817_124 = 1817,                /* $@124  */
  YYSYMBOL_initialize_body = 1818,         /* initialize_body  */
  YYSYMBOL__initialize_filler = 1819,      /* _initialize_filler  */
  YYSYMBOL__initialize_value = 1820,       /* _initialize_value  */
  YYSYMBOL__initialize_replacing = 1821,   /* _initialize_replacing  */
  YYSYMBOL_initialize_replacing_list = 1822, /* initialize_replacing_list  */
  YYSYMBOL_initialize_replacing_item = 1823, /* initialize_replacing_item  */
  YYSYMBOL_initialize_category = 1824,     /* initialize_category  */
  YYSYMBOL__initialize_default = 1825,     /* _initialize_default  */
  YYSYMBOL_initiate_statement = 1826,      /* initiate_statement  */
  YYSYMBOL_1827_125 = 1827,                /* $@125  */
  YYSYMBOL_initiate_body = 1828,           /* initiate_body  */
  YYSYMBOL_inquire_statement = 1829,       /* inquire_statement  */
  YYSYMBOL_1830_126 = 1830,                /* $@126  */
  YYSYMBOL_inquire_body = 1831,            /* inquire_body  */
  YYSYMBOL_inspect_statement = 1832,       /* inspect_statement  */
  YYSYMBOL_1833_127 = 1833,                /* $@127  */
  YYSYMBOL_inspect_body = 1834,            /* inspect_body  */
  YYSYMBOL__backward = 1835,               /* _backward  */
  YYSYMBOL_send_identifier = 1836,         /* send_identifier  */
  YYSYMBOL_inspect_format_variant = 1837,  /* inspect_format_variant  */
  YYSYMBOL_examine_statement = 1838,       /* examine_statement  */
  YYSYMBOL_1839_128 = 1839,                /* $@128  */
  YYSYMBOL_examine_format_variant = 1840,  /* examine_format_variant  */
  YYSYMBOL_1841_129 = 1841,                /* $@129  */
  YYSYMBOL_examine_tallying_keyword = 1842, /* examine_tallying_keyword  */
  YYSYMBOL_examine_replacing_keyword = 1843, /* examine_replacing_keyword  */
  YYSYMBOL__examine_tallying_replacing = 1844, /* _examine_tallying_replacing  */
  YYSYMBOL_single_character_value = 1845,  /* single_character_value  */
  YYSYMBOL_inspect_tallying = 1846,        /* inspect_tallying  */
  YYSYMBOL_1847_130 = 1847,                /* $@130  */
  YYSYMBOL_inspect_replacing = 1848,       /* inspect_replacing  */
  YYSYMBOL_inspect_converting = 1849,      /* inspect_converting  */
  YYSYMBOL_tallying_list = 1850,           /* tallying_list  */
  YYSYMBOL_tallying_item = 1851,           /* tallying_item  */
  YYSYMBOL_replacing_list = 1852,          /* replacing_list  */
  YYSYMBOL_replacing_item = 1853,          /* replacing_item  */
  YYSYMBOL_rep_keyword = 1854,             /* rep_keyword  */
  YYSYMBOL_replacing_region = 1855,        /* replacing_region  */
  YYSYMBOL_inspect_region = 1856,          /* inspect_region  */
  YYSYMBOL_inspect_before = 1857,          /* inspect_before  */
  YYSYMBOL_inspect_after = 1858,           /* inspect_after  */
  YYSYMBOL_json = 1859,                    /* json  */
  YYSYMBOL_json_generate_statement = 1860, /* json_generate_statement  */
  YYSYMBOL_1861_131 = 1861,                /* $@131  */
  YYSYMBOL_json_generate_body = 1862,      /* json_generate_body  */
  YYSYMBOL_1863_132 = 1863,                /* $@132  */
  YYSYMBOL_1864_133 = 1864,                /* $@133  */
  YYSYMBOL__json_suppress = 1865,          /* _json_suppress  */
  YYSYMBOL_json_suppress_list = 1866,      /* json_suppress_list  */
  YYSYMBOL_json_suppress_entry = 1867,     /* json_suppress_entry  */
  YYSYMBOL__end_json = 1868,               /* _end_json  */
  YYSYMBOL_json_parse_statement = 1869,    /* json_parse_statement  */
  YYSYMBOL_1870_134 = 1870,                /* $@134  */
  YYSYMBOL_json_parse_body = 1871,         /* json_parse_body  */
  YYSYMBOL__with_detail = 1872,            /* _with_detail  */
  YYSYMBOL_merge_statement = 1873,         /* merge_statement  */
  YYSYMBOL_1874_135 = 1874,                /* $@135  */
  YYSYMBOL_modify_statement = 1875,        /* modify_statement  */
  YYSYMBOL_1876_136 = 1876,                /* $@136  */
  YYSYMBOL_modify_body = 1877,             /* modify_body  */
  YYSYMBOL__end_modify = 1878,             /* _end_modify  */
  YYSYMBOL_move_statement = 1879,          /* move_statement  */
  YYSYMBOL_1880_137 = 1880,                /* $@137  */
  YYSYMBOL_move_body = 1881,               /* move_body  */
  YYSYMBOL_multiply_statement = 1882,      /* multiply_statement  */
  YYSYMBOL_1883_138 = 1883,                /* $@138  */
  YYSYMBOL_multiply_body = 1884,           /* multiply_body  */
  YYSYMBOL__end_multiply = 1885,           /* _end_multiply  */
  YYSYMBOL_open_statement = 1886,          /* open_statement  */
  YYSYMBOL_1887_139 = 1887,                /* $@139  */
  YYSYMBOL_open_body = 1888,               /* open_body  */
  YYSYMBOL_open_file_entry = 1889,         /* open_file_entry  */
  YYSYMBOL__open_exclusive = 1890,         /* _open_exclusive  */
  YYSYMBOL_open_mode = 1891,               /* open_mode  */
  YYSYMBOL__open_sharing = 1892,           /* _open_sharing  */
  YYSYMBOL__open_option = 1893,            /* _open_option  */
  YYSYMBOL_lock_allowing = 1894,           /* lock_allowing  */
  YYSYMBOL_open_lock_option = 1895,        /* open_lock_option  */
  YYSYMBOL_allowing_option = 1896,         /* allowing_option  */
  YYSYMBOL_allowing_all = 1897,            /* allowing_all  */
  YYSYMBOL_open_option_sequential = 1898,  /* open_option_sequential  */
  YYSYMBOL_osvs_input_mode = 1899,         /* osvs_input_mode  */
  YYSYMBOL_perform_statement = 1900,       /* perform_statement  */
  YYSYMBOL_1901_140 = 1901,                /* $@140  */
  YYSYMBOL_perform_body = 1902,            /* perform_body  */
  YYSYMBOL_1903_141 = 1903,                /* $@141  */
  YYSYMBOL_1904_142 = 1904,                /* $@142  */
  YYSYMBOL__end_perform = 1905,            /* _end_perform  */
  YYSYMBOL_end_perform_or_dot = 1906,      /* end_perform_or_dot  */
  YYSYMBOL_perform_procedure = 1907,       /* perform_procedure  */
  YYSYMBOL__perform_option = 1908,         /* _perform_option  */
  YYSYMBOL_perform_test = 1909,            /* perform_test  */
  YYSYMBOL_cond_or_exit = 1910,            /* cond_or_exit  */
  YYSYMBOL_perform_varying_list = 1911,    /* perform_varying_list  */
  YYSYMBOL_perform_varying = 1912,         /* perform_varying  */
  YYSYMBOL__by_phrase = 1913,              /* _by_phrase  */
  YYSYMBOL_purge_statement = 1914,         /* purge_statement  */
  YYSYMBOL_1915_143 = 1915,                /* $@143  */
  YYSYMBOL_raise_statement = 1916,         /* raise_statement  */
  YYSYMBOL_1917_144 = 1917,                /* $@144  */
  YYSYMBOL_raise_body = 1918,              /* raise_body  */
  YYSYMBOL_exception_name = 1919,          /* exception_name  */
  YYSYMBOL_read_statement = 1920,          /* read_statement  */
  YYSYMBOL_1921_145 = 1921,                /* $@145  */
  YYSYMBOL_read_body = 1922,               /* read_body  */
  YYSYMBOL__read_into = 1923,              /* _read_into  */
  YYSYMBOL__lock_phrases = 1924,           /* _lock_phrases  */
  YYSYMBOL_ignoring_lock = 1925,           /* ignoring_lock  */
  YYSYMBOL_advancing_lock_or_retry = 1926, /* advancing_lock_or_retry  */
  YYSYMBOL__retry_phrase = 1927,           /* _retry_phrase  */
  YYSYMBOL_retry_phrase = 1928,            /* retry_phrase  */
  YYSYMBOL_retry_options = 1929,           /* retry_options  */
  YYSYMBOL__extended_with_lock = 1930,     /* _extended_with_lock  */
  YYSYMBOL_extended_with_lock = 1931,      /* extended_with_lock  */
  YYSYMBOL__read_key = 1932,               /* _read_key  */
  YYSYMBOL_read_handler = 1933,            /* read_handler  */
  YYSYMBOL__end_read = 1934,               /* _end_read  */
  YYSYMBOL_ready_statement = 1935,         /* ready_statement  */
  YYSYMBOL_receive_statement = 1936,       /* receive_statement  */
  YYSYMBOL_1937_146 = 1937,                /* $@146  */
  YYSYMBOL_receive_body = 1938,            /* receive_body  */
  YYSYMBOL_message_or_segment = 1939,      /* message_or_segment  */
  YYSYMBOL__data_sentence_phrases = 1940,  /* _data_sentence_phrases  */
  YYSYMBOL__no_data_sentence = 1941,       /* _no_data_sentence  */
  YYSYMBOL_no_data_sentence = 1942,        /* no_data_sentence  */
  YYSYMBOL__with_data_sentence = 1943,     /* _with_data_sentence  */
  YYSYMBOL_with_data_sentence = 1944,      /* with_data_sentence  */
  YYSYMBOL__end_receive = 1945,            /* _end_receive  */
  YYSYMBOL_release_statement = 1946,       /* release_statement  */
  YYSYMBOL_1947_147 = 1947,                /* $@147  */
  YYSYMBOL_release_body = 1948,            /* release_body  */
  YYSYMBOL_reset_statement = 1949,         /* reset_statement  */
  YYSYMBOL_return_statement = 1950,        /* return_statement  */
  YYSYMBOL_1951_148 = 1951,                /* $@148  */
  YYSYMBOL_return_body = 1952,             /* return_body  */
  YYSYMBOL__end_return = 1953,             /* _end_return  */
  YYSYMBOL_rewrite_statement = 1954,       /* rewrite_statement  */
  YYSYMBOL_1955_149 = 1955,                /* $@149  */
  YYSYMBOL_rewrite_body = 1956,            /* rewrite_body  */
  YYSYMBOL__with_lock = 1957,              /* _with_lock  */
  YYSYMBOL_with_lock = 1958,               /* with_lock  */
  YYSYMBOL__end_rewrite = 1959,            /* _end_rewrite  */
  YYSYMBOL_rollback_statement = 1960,      /* rollback_statement  */
  YYSYMBOL_search = 1961,                  /* search  */
  YYSYMBOL_search_statement = 1962,        /* search_statement  */
  YYSYMBOL_1963_150 = 1963,                /* $@150  */
  YYSYMBOL_1964_151 = 1964,                /* $@151  */
  YYSYMBOL_search_body = 1965,             /* search_body  */
  YYSYMBOL_search_all_body = 1966,         /* search_all_body  */
  YYSYMBOL__search_varying = 1967,         /* _search_varying  */
  YYSYMBOL__search_at_end = 1968,          /* _search_at_end  */
  YYSYMBOL_end_pos_token = 1969,           /* end_pos_token  */
  YYSYMBOL_search_whens = 1970,            /* search_whens  */
  YYSYMBOL_search_when = 1971,             /* search_when  */
  YYSYMBOL__end_search = 1972,             /* _end_search  */
  YYSYMBOL_end_search_pos_token = 1973,    /* end_search_pos_token  */
  YYSYMBOL_send_statement = 1974,          /* send_statement  */
  YYSYMBOL_1975_152 = 1975,                /* $@152  */
  YYSYMBOL_send_body = 1976,               /* send_body  */
  YYSYMBOL_send_body_mcs = 1977,           /* send_body_mcs  */
  YYSYMBOL_message_tag_data_item = 1978,   /* message_tag_data_item  */
  YYSYMBOL__from_identifier = 1979,        /* _from_identifier  */
  YYSYMBOL_from_identifier = 1980,         /* from_identifier  */
  YYSYMBOL_send_body_cd = 1981,            /* send_body_cd  */
  YYSYMBOL_with_indicator = 1982,          /* with_indicator  */
  YYSYMBOL__replacing_line = 1983,         /* _replacing_line  */
  YYSYMBOL_set_statement = 1984,           /* set_statement  */
  YYSYMBOL_1985_153 = 1985,                /* $@153  */
  YYSYMBOL_set_body = 1986,                /* set_body  */
  YYSYMBOL_on_or_off = 1987,               /* on_or_off  */
  YYSYMBOL_up_or_down = 1988,              /* up_or_down  */
  YYSYMBOL_set_environment = 1989,         /* set_environment  */
  YYSYMBOL_set_attr = 1990,                /* set_attr  */
  YYSYMBOL_set_attr_clause = 1991,         /* set_attr_clause  */
  YYSYMBOL_set_attr_one = 1992,            /* set_attr_one  */
  YYSYMBOL_set_to = 1993,                  /* set_to  */
  YYSYMBOL_set_up_down = 1994,             /* set_up_down  */
  YYSYMBOL_set_to_on_off_sequence = 1995,  /* set_to_on_off_sequence  */
  YYSYMBOL_set_to_on_off = 1996,           /* set_to_on_off  */
  YYSYMBOL_set_to_true_false_sequence = 1997, /* set_to_true_false_sequence  */
  YYSYMBOL_set_to_true_false = 1998,       /* set_to_true_false  */
  YYSYMBOL_set_last_exception_to_off = 1999, /* set_last_exception_to_off  */
  YYSYMBOL_set_thread_priority = 2000,     /* set_thread_priority  */
  YYSYMBOL_sort_statement = 2001,          /* sort_statement  */
  YYSYMBOL_2002_154 = 2002,                /* $@154  */
  YYSYMBOL_sort_body = 2003,               /* sort_body  */
  YYSYMBOL_2004_155 = 2004,                /* @155  */
  YYSYMBOL__sort_key_list = 2005,          /* _sort_key_list  */
  YYSYMBOL__key_sort_list = 2006,          /* _key_sort_list  */
  YYSYMBOL__sort_duplicates = 2007,        /* _sort_duplicates  */
  YYSYMBOL__sort_collating = 2008,         /* _sort_collating  */
  YYSYMBOL_sort_input = 2009,              /* sort_input  */
  YYSYMBOL_sort_output = 2010,             /* sort_output  */
  YYSYMBOL_start_statement = 2011,         /* start_statement  */
  YYSYMBOL_2012_156 = 2012,                /* $@156  */
  YYSYMBOL_start_body = 2013,              /* start_body  */
  YYSYMBOL__sizelen_clause = 2014,         /* _sizelen_clause  */
  YYSYMBOL__start_key = 2015,              /* _start_key  */
  YYSYMBOL_start_op = 2016,                /* start_op  */
  YYSYMBOL_not_equal_op = 2017,            /* not_equal_op  */
  YYSYMBOL__end_start = 2018,              /* _end_start  */
  YYSYMBOL_stop = 2019,                    /* stop  */
  YYSYMBOL_stop_statement = 2020,          /* stop_statement  */
  YYSYMBOL_2021_157 = 2021,                /* $@157  */
  YYSYMBOL_stop_returning = 2022,          /* stop_returning  */
  YYSYMBOL__status_x = 2023,               /* _status_x  */
  YYSYMBOL_stop_argument = 2024,           /* stop_argument  */
  YYSYMBOL_stop_literal = 2025,            /* stop_literal  */
  YYSYMBOL_string_statement = 2026,        /* string_statement  */
  YYSYMBOL_2027_158 = 2027,                /* $@158  */
  YYSYMBOL_string_body = 2028,             /* string_body  */
  YYSYMBOL_string_items = 2029,            /* string_items  */
  YYSYMBOL_2030_159 = 2030,                /* $@159  */
  YYSYMBOL_string_item_list = 2031,        /* string_item_list  */
  YYSYMBOL_string_item = 2032,             /* string_item  */
  YYSYMBOL__string_delimited = 2033,       /* _string_delimited  */
  YYSYMBOL_string_delimiter = 2034,        /* string_delimiter  */
  YYSYMBOL__with_pointer = 2035,           /* _with_pointer  */
  YYSYMBOL__end_string = 2036,             /* _end_string  */
  YYSYMBOL_subtract_statement = 2037,      /* subtract_statement  */
  YYSYMBOL_2038_160 = 2038,                /* $@160  */
  YYSYMBOL_subtract_body = 2039,           /* subtract_body  */
  YYSYMBOL__end_subtract = 2040,           /* _end_subtract  */
  YYSYMBOL_suppress_statement = 2041,      /* suppress_statement  */
  YYSYMBOL_2042_161 = 2042,                /* $@161  */
  YYSYMBOL__printing = 2043,               /* _printing  */
  YYSYMBOL_terminate_statement = 2044,     /* terminate_statement  */
  YYSYMBOL_2045_162 = 2045,                /* $@162  */
  YYSYMBOL_terminate_body = 2046,          /* terminate_body  */
  YYSYMBOL_transform_statement = 2047,     /* transform_statement  */
  YYSYMBOL_2048_163 = 2048,                /* $@163  */
  YYSYMBOL_transform_body = 2049,          /* transform_body  */
  YYSYMBOL_unlock_statement = 2050,        /* unlock_statement  */
  YYSYMBOL_2051_164 = 2051,                /* $@164  */
  YYSYMBOL_unlock_body = 2052,             /* unlock_body  */
  YYSYMBOL_unstring_statement = 2053,      /* unstring_statement  */
  YYSYMBOL_2054_165 = 2054,                /* $@165  */
  YYSYMBOL_unstring_body = 2055,           /* unstring_body  */
  YYSYMBOL__unstring_delimited = 2056,     /* _unstring_delimited  */
  YYSYMBOL_unstring_delimited_list = 2057, /* unstring_delimited_list  */
  YYSYMBOL_unstring_delimited_item = 2058, /* unstring_delimited_item  */
  YYSYMBOL_unstring_into = 2059,           /* unstring_into  */
  YYSYMBOL_unstring_into_item = 2060,      /* unstring_into_item  */
  YYSYMBOL__unstring_into_delimiter = 2061, /* _unstring_into_delimiter  */
  YYSYMBOL__unstring_tallying = 2062,      /* _unstring_tallying  */
  YYSYMBOL__end_unstring = 2063,           /* _end_unstring  */
  YYSYMBOL_validate_statement = 2064,      /* validate_statement  */
  YYSYMBOL_2065_166 = 2065,                /* $@166  */
  YYSYMBOL_validate_fields = 2066,         /* validate_fields  */
  YYSYMBOL_use_statement = 2067,           /* use_statement  */
  YYSYMBOL_2068_167 = 2068,                /* $@167  */
  YYSYMBOL_use_phrase = 2069,              /* use_phrase  */
  YYSYMBOL_use_file_exception = 2070,      /* use_file_exception  */
  YYSYMBOL__use_global = 2071,             /* _use_global  */
  YYSYMBOL_use_file_exception_target = 2072, /* use_file_exception_target  */
  YYSYMBOL_use_for_debugging = 2073,       /* use_for_debugging  */
  YYSYMBOL_debugging_list = 2074,          /* debugging_list  */
  YYSYMBOL_debugging_target = 2075,        /* debugging_target  */
  YYSYMBOL__all_refs = 2076,               /* _all_refs  */
  YYSYMBOL_use_at_start_end = 2077,        /* use_at_start_end  */
  YYSYMBOL_program_start_end = 2078,       /* program_start_end  */
  YYSYMBOL_use_before_reporting = 2079,    /* use_before_reporting  */
  YYSYMBOL_use_after_exception = 2080,     /* use_after_exception  */
  YYSYMBOL_use_exception_list = 2081,      /* use_exception_list  */
  YYSYMBOL_use_exception = 2082,           /* use_exception  */
  YYSYMBOL_use_ex_keyw = 2083,             /* use_ex_keyw  */
  YYSYMBOL_write_statement = 2084,         /* write_statement  */
  YYSYMBOL_2085_168 = 2085,                /* $@168  */
  YYSYMBOL_write_body = 2086,              /* write_body  */
  YYSYMBOL_from_option = 2087,             /* from_option  */
  YYSYMBOL_write_option = 2088,            /* write_option  */
  YYSYMBOL_before_or_after = 2089,         /* before_or_after  */
  YYSYMBOL_write_handler = 2090,           /* write_handler  */
  YYSYMBOL__end_write = 2091,              /* _end_write  */
  YYSYMBOL_xml = 2092,                     /* xml  */
  YYSYMBOL_xml_generate_statement = 2093,  /* xml_generate_statement  */
  YYSYMBOL_2094_169 = 2094,                /* $@169  */
  YYSYMBOL_xml_generate_body = 2095,       /* xml_generate_body  */
  YYSYMBOL_2096_170 = 2096,                /* $@170  */
  YYSYMBOL_2097_171 = 2097,                /* $@171  */
  YYSYMBOL__with_encoding_xml_dec_and_attrs = 2098, /* _with_encoding_xml_dec_and_attrs  */
  YYSYMBOL_with_encoding_xml_dec_and_attrs = 2099, /* with_encoding_xml_dec_and_attrs  */
  YYSYMBOL_with_encoding_xml_dec_and_attr = 2100, /* with_encoding_xml_dec_and_attr  */
  YYSYMBOL_encoding_xml_dec_and_attr = 2101, /* encoding_xml_dec_and_attr  */
  YYSYMBOL__xml_gen_namespace = 2102,      /* _xml_gen_namespace  */
  YYSYMBOL__xml_gen_namespace_prefix = 2103, /* _xml_gen_namespace_prefix  */
  YYSYMBOL__xml_name_of = 2104,            /* _xml_name_of  */
  YYSYMBOL_identifier_name_list = 2105,    /* identifier_name_list  */
  YYSYMBOL_identifier_is_name = 2106,      /* identifier_is_name  */
  YYSYMBOL__json_name_of = 2107,           /* _json_name_of  */
  YYSYMBOL_json_identifier_name_list = 2108, /* json_identifier_name_list  */
  YYSYMBOL_json_identifier_is_name = 2109, /* json_identifier_is_name  */
  YYSYMBOL__type_of = 2110,                /* _type_of  */
  YYSYMBOL_identifier_type_list = 2111,    /* identifier_type_list  */
  YYSYMBOL_identifier_is_type = 2112,      /* identifier_is_type  */
  YYSYMBOL__xml_type = 2113,               /* _xml_type  */
  YYSYMBOL_ml_type = 2114,                 /* ml_type  */
  YYSYMBOL__xml_gen_suppress = 2115,       /* _xml_gen_suppress  */
  YYSYMBOL_xml_suppress_list = 2116,       /* xml_suppress_list  */
  YYSYMBOL_xml_suppress_entry = 2117,      /* xml_suppress_entry  */
  YYSYMBOL_xml_suppress_generic_opt = 2118, /* xml_suppress_generic_opt  */
  YYSYMBOL_xml_suppress_when_list = 2119,  /* xml_suppress_when_list  */
  YYSYMBOL__end_xml = 2120,                /* _end_xml  */
  YYSYMBOL_xml_parse_statement = 2121,     /* xml_parse_statement  */
  YYSYMBOL_2122_172 = 2122,                /* $@172  */
  YYSYMBOL_xml_parse_body = 2123,          /* xml_parse_body  */
  YYSYMBOL_2124_173 = 2124,                /* $@173  */
  YYSYMBOL__with_encoding = 2125,          /* _with_encoding  */
  YYSYMBOL__returning_national = 2126,     /* _returning_national  */
  YYSYMBOL__validating_with = 2127,        /* _validating_with  */
  YYSYMBOL_schema_file_or_record_name = 2128, /* schema_file_or_record_name  */
  YYSYMBOL__accept_exception_phrases = 2129, /* _accept_exception_phrases  */
  YYSYMBOL__accp_on_exception = 2130,      /* _accp_on_exception  */
  YYSYMBOL_accp_on_exception = 2131,       /* accp_on_exception  */
  YYSYMBOL_escape_or_exception = 2132,     /* escape_or_exception  */
  YYSYMBOL__accp_not_on_exception = 2133,  /* _accp_not_on_exception  */
  YYSYMBOL_accp_not_on_exception = 2134,   /* accp_not_on_exception  */
  YYSYMBOL_not_escape_or_not_exception = 2135, /* not_escape_or_not_exception  */
  YYSYMBOL__common_exception_phrases = 2136, /* _common_exception_phrases  */
  YYSYMBOL__common_on_exception = 2137,    /* _common_on_exception  */
  YYSYMBOL_common_on_exception = 2138,     /* common_on_exception  */
  YYSYMBOL__common_not_on_exception = 2139, /* _common_not_on_exception  */
  YYSYMBOL_common_not_on_exception = 2140, /* common_not_on_exception  */
  YYSYMBOL_on_size_error_phrases = 2141,   /* on_size_error_phrases  */
  YYSYMBOL__on_size_error = 2142,          /* _on_size_error  */
  YYSYMBOL_on_size_error = 2143,           /* on_size_error  */
  YYSYMBOL__not_on_size_error = 2144,      /* _not_on_size_error  */
  YYSYMBOL_not_on_size_error = 2145,       /* not_on_size_error  */
  YYSYMBOL__on_overflow_phrases = 2146,    /* _on_overflow_phrases  */
  YYSYMBOL__on_overflow = 2147,            /* _on_overflow  */
  YYSYMBOL_on_overflow = 2148,             /* on_overflow  */
  YYSYMBOL__not_on_overflow = 2149,        /* _not_on_overflow  */
  YYSYMBOL_not_on_overflow = 2150,         /* not_on_overflow  */
  YYSYMBOL_return_at_end = 2151,           /* return_at_end  */
  YYSYMBOL_read_at_end = 2152,             /* read_at_end  */
  YYSYMBOL__at_end_clause = 2153,          /* _at_end_clause  */
  YYSYMBOL_at_end_clause = 2154,           /* at_end_clause  */
  YYSYMBOL__not_at_end_clause = 2155,      /* _not_at_end_clause  */
  YYSYMBOL_not_at_end_clause = 2156,       /* not_at_end_clause  */
  YYSYMBOL_at_eop_clauses = 2157,          /* at_eop_clauses  */
  YYSYMBOL__at_eop_clause = 2158,          /* _at_eop_clause  */
  YYSYMBOL_at_eop_clause = 2159,           /* at_eop_clause  */
  YYSYMBOL__not_at_eop_clause = 2160,      /* _not_at_eop_clause  */
  YYSYMBOL_not_at_eop_clause = 2161,       /* not_at_eop_clause  */
  YYSYMBOL__invalid_key_phrases = 2162,    /* _invalid_key_phrases  */
  YYSYMBOL_invalid_key_phrases = 2163,     /* invalid_key_phrases  */
  YYSYMBOL__invalid_key_sentence = 2164,   /* _invalid_key_sentence  */
  YYSYMBOL_invalid_key_sentence = 2165,    /* invalid_key_sentence  */
  YYSYMBOL__not_invalid_key_sentence = 2166, /* _not_invalid_key_sentence  */
  YYSYMBOL_not_invalid_key_sentence = 2167, /* not_invalid_key_sentence  */
  YYSYMBOL__thread_start = 2168,           /* _thread_start  */
  YYSYMBOL__thread_handle = 2169,          /* _thread_handle  */
  YYSYMBOL_thread_reference_optional = 2170, /* thread_reference_optional  */
  YYSYMBOL__scroll_lines = 2171,           /* _scroll_lines  */
  YYSYMBOL__count_in = 2172,               /* _count_in  */
  YYSYMBOL_condition = 2173,               /* condition  */
  YYSYMBOL_expr = 2174,                    /* expr  */
  YYSYMBOL_partial_expr = 2175,            /* partial_expr  */
  YYSYMBOL_2176_174 = 2176,                /* $@174  */
  YYSYMBOL_expr_tokens = 2177,             /* expr_tokens  */
  YYSYMBOL_expr_token = 2178,              /* expr_token  */
  YYSYMBOL_condition_no_is = 2179,         /* condition_no_is  */
  YYSYMBOL_expr_no_is = 2180,              /* expr_no_is  */
  YYSYMBOL_partial_expr_no_is = 2181,      /* partial_expr_no_is  */
  YYSYMBOL_2182_175 = 2182,                /* $@175  */
  YYSYMBOL_expr_tokens_no_is = 2183,       /* expr_tokens_no_is  */
  YYSYMBOL_expr_token_no_is = 2184,        /* expr_token_no_is  */
  YYSYMBOL__not_expr = 2185,               /* _not_expr  */
  YYSYMBOL_not_expr = 2186,                /* not_expr  */
  YYSYMBOL_condition_or_class = 2187,      /* condition_or_class  */
  YYSYMBOL_eq = 2188,                      /* eq  */
  YYSYMBOL_gt = 2189,                      /* gt  */
  YYSYMBOL_lt = 2190,                      /* lt  */
  YYSYMBOL_ge = 2191,                      /* ge  */
  YYSYMBOL_le = 2192,                      /* le  */
  YYSYMBOL_exp_list = 2193,                /* exp_list  */
  YYSYMBOL__e_sep = 2194,                  /* _e_sep  */
  YYSYMBOL_exp = 2195,                     /* exp  */
  YYSYMBOL_exp_term = 2196,                /* exp_term  */
  YYSYMBOL_exp_factor = 2197,              /* exp_factor  */
  YYSYMBOL_exp_unary = 2198,               /* exp_unary  */
  YYSYMBOL_exp_atom = 2199,                /* exp_atom  */
  YYSYMBOL_line_linage_page_counter = 2200, /* line_linage_page_counter  */
  YYSYMBOL_arithmetic_x_list = 2201,       /* arithmetic_x_list  */
  YYSYMBOL_arithmetic_x = 2202,            /* arithmetic_x  */
  YYSYMBOL_record_name = 2203,             /* record_name  */
  YYSYMBOL_file_or_record_name = 2204,     /* file_or_record_name  */
  YYSYMBOL_table_name = 2205,              /* table_name  */
  YYSYMBOL_file_name_list = 2206,          /* file_name_list  */
  YYSYMBOL_file_file_name_list = 2207,     /* file_file_name_list  */
  YYSYMBOL_file_name = 2208,               /* file_name  */
  YYSYMBOL_cd_name = 2209,                 /* cd_name  */
  YYSYMBOL_report_name = 2210,             /* report_name  */
  YYSYMBOL_mnemonic_name_list = 2211,      /* mnemonic_name_list  */
  YYSYMBOL_mnemonic_name = 2212,           /* mnemonic_name  */
  YYSYMBOL_entry_name_list = 2213,         /* entry_name_list  */
  YYSYMBOL_entry_name = 2214,              /* entry_name  */
  YYSYMBOL_procedure_name_list = 2215,     /* procedure_name_list  */
  YYSYMBOL_procedure_name = 2216,          /* procedure_name  */
  YYSYMBOL_label = 2217,                   /* label  */
  YYSYMBOL_integer_label = 2218,           /* integer_label  */
  YYSYMBOL_reference_list = 2219,          /* reference_list  */
  YYSYMBOL_reference = 2220,               /* reference  */
  YYSYMBOL__reference = 2221,              /* _reference  */
  YYSYMBOL_single_reference_list = 2222,   /* single_reference_list  */
  YYSYMBOL_single_reference = 2223,        /* single_reference  */
  YYSYMBOL_optional_reference_list = 2224, /* optional_reference_list  */
  YYSYMBOL_optional_reference = 2225,      /* optional_reference  */
  YYSYMBOL_reference_or_literal = 2226,    /* reference_or_literal  */
  YYSYMBOL_undefined_word = 2227,          /* undefined_word  */
  YYSYMBOL_undefined_word_but_no_error = 2228, /* undefined_word_but_no_error  */
  YYSYMBOL_unique_word = 2229,             /* unique_word  */
  YYSYMBOL_target_x_list = 2230,           /* target_x_list  */
  YYSYMBOL_target_x = 2231,                /* target_x  */
  YYSYMBOL__x_list = 2232,                 /* _x_list  */
  YYSYMBOL_x_list = 2233,                  /* x_list  */
  YYSYMBOL_x = 2234,                       /* x  */
  YYSYMBOL_call_x = 2235,                  /* call_x  */
  YYSYMBOL_x_common = 2236,                /* x_common  */
  YYSYMBOL_length_of_register = 2237,      /* length_of_register  */
  YYSYMBOL_report_x_list = 2238,           /* report_x_list  */
  YYSYMBOL_expr_x = 2239,                  /* expr_x  */
  YYSYMBOL_arith_x = 2240,                 /* arith_x  */
  YYSYMBOL_arith_nonzero_x = 2241,         /* arith_nonzero_x  */
  YYSYMBOL_numeric_literal = 2242,         /* numeric_literal  */
  YYSYMBOL_non_numeric_literal = 2243,     /* non_numeric_literal  */
  YYSYMBOL_nonzero_numeric_literal = 2244, /* nonzero_numeric_literal  */
  YYSYMBOL_prog_or_entry = 2245,           /* prog_or_entry  */
  YYSYMBOL_alnum_or_id = 2246,             /* alnum_or_id  */
  YYSYMBOL_simple_display_value = 2247,    /* simple_display_value  */
  YYSYMBOL_inspect_from = 2248,            /* inspect_from  */
  YYSYMBOL_inspect_to = 2249,              /* inspect_to  */
  YYSYMBOL_simple_value = 2250,            /* simple_value  */
  YYSYMBOL_simple_all_value = 2251,        /* simple_all_value  */
  YYSYMBOL_id_or_lit = 2252,               /* id_or_lit  */
  YYSYMBOL_id_or_lit_or_func = 2253,       /* id_or_lit_or_func  */
  YYSYMBOL_id_or_lit_or_length_or_func = 2254, /* id_or_lit_or_length_or_func  */
  YYSYMBOL_num_id_or_lit = 2255,           /* num_id_or_lit  */
  YYSYMBOL_positive_id_or_lit = 2256,      /* positive_id_or_lit  */
  YYSYMBOL_pos_num_id_or_lit_or_zero = 2257, /* pos_num_id_or_lit_or_zero  */
  YYSYMBOL_pos_num_id_or_lit = 2258,       /* pos_num_id_or_lit  */
  YYSYMBOL_from_parameter = 2259,          /* from_parameter  */
  YYSYMBOL_sub_identifier = 2260,          /* sub_identifier  */
  YYSYMBOL_table_identifier = 2261,        /* table_identifier  */
  YYSYMBOL_sub_identifier_1 = 2262,        /* sub_identifier_1  */
  YYSYMBOL_display_identifier = 2263,      /* display_identifier  */
  YYSYMBOL_numeric_identifier = 2264,      /* numeric_identifier  */
  YYSYMBOL_identifier_or_file_name = 2265, /* identifier_or_file_name  */
  YYSYMBOL_identifier_field = 2266,        /* identifier_field  */
  YYSYMBOL_type_name = 2267,               /* type_name  */
  YYSYMBOL_identifier = 2268,              /* identifier  */
  YYSYMBOL_identifier_1 = 2269,            /* identifier_1  */
  YYSYMBOL_identifier_list = 2270,         /* identifier_list  */
  YYSYMBOL_validate_for_identifier_list = 2271, /* validate_for_identifier_list  */
  YYSYMBOL_for_identifier = 2272,          /* for_identifier  */
  YYSYMBOL_target_identifier = 2273,       /* target_identifier  */
  YYSYMBOL_target_identifier_1 = 2274,     /* target_identifier_1  */
  YYSYMBOL_target_identifier_single = 2275, /* target_identifier_single  */
  YYSYMBOL_display_identifier_or_alphabet_name = 2276, /* display_identifier_or_alphabet_name  */
  YYSYMBOL_qualified_word = 2277,          /* qualified_word  */
  YYSYMBOL_unqualified_word = 2278,        /* unqualified_word  */
  YYSYMBOL_2279_176 = 2279,                /* $@176  */
  YYSYMBOL_unqualified_word_check = 2280,  /* unqualified_word_check  */
  YYSYMBOL_subref = 2281,                  /* subref  */
  YYSYMBOL_refmod = 2282,                  /* refmod  */
  YYSYMBOL_integer = 2283,                 /* integer  */
  YYSYMBOL_symbolic_integer = 2284,        /* symbolic_integer  */
  YYSYMBOL_unsigned_pos_integer = 2285,    /* unsigned_pos_integer  */
  YYSYMBOL_integer_or_zero = 2286,         /* integer_or_zero  */
  YYSYMBOL_class_value = 2287,             /* class_value  */
  YYSYMBOL_figurative_constant = 2288,     /* figurative_constant  */
  YYSYMBOL_literal = 2289,                 /* literal  */
  YYSYMBOL_basic_literal = 2290,           /* basic_literal  */
  YYSYMBOL_basic_value = 2291,             /* basic_value  */
  YYSYMBOL_zero_spaces_high_low_values = 2292, /* zero_spaces_high_low_values  */
  YYSYMBOL_function = 2293,                /* function  */
  YYSYMBOL_func_no_parm = 2294,            /* func_no_parm  */
  YYSYMBOL_func_one_parm = 2295,           /* func_one_parm  */
  YYSYMBOL_func_multi_parm = 2296,         /* func_multi_parm  */
  YYSYMBOL_func_refmod = 2297,             /* func_refmod  */
  YYSYMBOL_func_args = 2298,               /* func_args  */
  YYSYMBOL_trim_args = 2299,               /* trim_args  */
  YYSYMBOL_length_arg = 2300,              /* length_arg  */
  YYSYMBOL_2301_177 = 2301,                /* $@177  */
  YYSYMBOL_numvalc_args = 2302,            /* numvalc_args  */
  YYSYMBOL_locale_dt_args = 2303,          /* locale_dt_args  */
  YYSYMBOL_formatted_datetime_args = 2304, /* formatted_datetime_args  */
  YYSYMBOL_formatted_time_args = 2305,     /* formatted_time_args  */
  YYSYMBOL_not_const_word = 2306,          /* not_const_word  */
  YYSYMBOL_flag_all = 2307,                /* flag_all  */
  YYSYMBOL_flag_duplicates = 2308,         /* flag_duplicates  */
  YYSYMBOL__flag_initialized = 2309,       /* _flag_initialized  */
  YYSYMBOL__flag_initialized_to = 2310,    /* _flag_initialized_to  */
  YYSYMBOL__to_init_val = 2311,            /* _to_init_val  */
  YYSYMBOL__flag_next = 2312,              /* _flag_next  */
  YYSYMBOL__flag_not = 2313,               /* _flag_not  */
  YYSYMBOL_flag_optional = 2314,           /* flag_optional  */
  YYSYMBOL_flag_rounded = 2315,            /* flag_rounded  */
  YYSYMBOL_round_mode = 2316,              /* round_mode  */
  YYSYMBOL_round_choice = 2317,            /* round_choice  */
  YYSYMBOL_flag_separate = 2318,           /* flag_separate  */
  YYSYMBOL__from_idx_to_idx = 2319,        /* _from_idx_to_idx  */
  YYSYMBOL__dest_index = 2320,             /* _dest_index  */
  YYSYMBOL_error_stmt_recover = 2321,      /* error_stmt_recover  */
  YYSYMBOL_verb = 2322,                    /* verb  */
  YYSYMBOL_scope_terminator = 2323,        /* scope_terminator  */
  YYSYMBOL__dot = 2324,                    /* _dot  */
  YYSYMBOL__dot_or_else_end_of_file_control = 2325, /* _dot_or_else_end_of_file_control  */
  YYSYMBOL_level_number_in_area_a = 2326,  /* level_number_in_area_a  */
  YYSYMBOL__dot_or_else_end_of_file_description = 2327, /* _dot_or_else_end_of_file_description  */
  YYSYMBOL__dot_or_else_end_of_communication_description = 2328, /* _dot_or_else_end_of_communication_description  */
  YYSYMBOL__dot_or_else_end_of_report_description = 2329, /* _dot_or_else_end_of_report_description  */
  YYSYMBOL__dot_or_else_end_of_report_group_description = 2330, /* _dot_or_else_end_of_report_group_description  */
  YYSYMBOL__dot_or_else_end_of_record_description = 2331, /* _dot_or_else_end_of_record_description  */
  YYSYMBOL__file_control_end_delimiter = 2332, /* _file_control_end_delimiter  */
  YYSYMBOL__file_description_end_delimiter = 2333, /* _file_description_end_delimiter  */
  YYSYMBOL__record_description_end_delimiter = 2334, /* _record_description_end_delimiter  */
  YYSYMBOL__dot_or_else_area_a = 2335,     /* _dot_or_else_area_a  */
  YYSYMBOL__advancing = 2336,              /* _advancing  */
  YYSYMBOL__after = 2337,                  /* _after  */
  YYSYMBOL__are = 2338,                    /* _are  */
  YYSYMBOL__area = 2339,                   /* _area  */
  YYSYMBOL__areas = 2340,                  /* _areas  */
  YYSYMBOL__as = 2341,                     /* _as  */
  YYSYMBOL__at = 2342,                     /* _at  */
  YYSYMBOL__before = 2343,                 /* _before  */
  YYSYMBOL__binary = 2344,                 /* _binary  */
  YYSYMBOL__box = 2345,                    /* _box  */
  YYSYMBOL__by = 2346,                     /* _by  */
  YYSYMBOL__character = 2347,              /* _character  */
  YYSYMBOL__characters = 2348,             /* _characters  */
  YYSYMBOL__collating = 2349,              /* _collating  */
  YYSYMBOL__contains = 2350,               /* _contains  */
  YYSYMBOL__controls = 2351,               /* _controls  */
  YYSYMBOL__control = 2352,                /* _control  */
  YYSYMBOL__data = 2353,                   /* _data  */
  YYSYMBOL__end_of = 2354,                 /* _end_of  */
  YYSYMBOL__every = 2355,                  /* _every  */
  YYSYMBOL__file = 2356,                   /* _file  */
  YYSYMBOL__for = 2357,                    /* _for  */
  YYSYMBOL__from = 2358,                   /* _from  */
  YYSYMBOL__in = 2359,                     /* _in  */
  YYSYMBOL__in_equal = 2360,               /* _in_equal  */
  YYSYMBOL__in_order = 2361,               /* _in_order  */
  YYSYMBOL__index = 2362,                  /* _index  */
  YYSYMBOL__indicate = 2363,               /* _indicate  */
  YYSYMBOL__initial = 2364,                /* _initial  */
  YYSYMBOL__into = 2365,                   /* _into  */
  YYSYMBOL__is = 2366,                     /* _is  */
  YYSYMBOL__is_equal = 2367,               /* _is_equal  */
  YYSYMBOL__is_are = 2368,                 /* _is_are  */
  YYSYMBOL__is_are_equal = 2369,           /* _is_are_equal  */
  YYSYMBOL__is_in = 2370,                  /* _is_in  */
  YYSYMBOL__key = 2371,                    /* _key  */
  YYSYMBOL__line = 2372,                   /* _line  */
  YYSYMBOL__line_or_lines = 2373,          /* _line_or_lines  */
  YYSYMBOL__limits = 2374,                 /* _limits  */
  YYSYMBOL__lines = 2375,                  /* _lines  */
  YYSYMBOL__lock = 2376,                   /* _lock  */
  YYSYMBOL__message = 2377,                /* _message  */
  YYSYMBOL__mode = 2378,                   /* _mode  */
  YYSYMBOL__new = 2379,                    /* _new  */
  YYSYMBOL__number = 2380,                 /* _number  */
  YYSYMBOL__number_or_numbers = 2381,      /* _number_or_numbers  */
  YYSYMBOL__of = 2382,                     /* _of  */
  YYSYMBOL__on = 2383,                     /* _on  */
  YYSYMBOL__on_for = 2384,                 /* _on_for  */
  YYSYMBOL__onoff_status = 2385,           /* _onoff_status  */
  YYSYMBOL__other = 2386,                  /* _other  */
  YYSYMBOL__others = 2387,                 /* _others  */
  YYSYMBOL__procedure = 2388,              /* _procedure  */
  YYSYMBOL__program = 2389,                /* _program  */
  YYSYMBOL__protected = 2390,              /* _protected  */
  YYSYMBOL__record = 2391,                 /* _record  */
  YYSYMBOL__records = 2392,                /* _records  */
  YYSYMBOL__right = 2393,                  /* _right  */
  YYSYMBOL__sign = 2394,                   /* _sign  */
  YYSYMBOL__signed = 2395,                 /* _signed  */
  YYSYMBOL__sign_is = 2396,                /* _sign_is  */
  YYSYMBOL__size = 2397,                   /* _size  */
  YYSYMBOL__standard = 2398,               /* _standard  */
  YYSYMBOL__status = 2399,                 /* _status  */
  YYSYMBOL__symbolic = 2400,               /* _symbolic  */
  YYSYMBOL__tape = 2401,                   /* _tape  */
  YYSYMBOL__terminal = 2402,               /* _terminal  */
  YYSYMBOL__then = 2403,                   /* _then  */
  YYSYMBOL__times = 2404,                  /* _times  */
  YYSYMBOL__to = 2405,                     /* _to  */
  YYSYMBOL__up = 2406,                     /* _up  */
  YYSYMBOL__when = 2407,                   /* _when  */
  YYSYMBOL__when_set_to = 2408,            /* _when_set_to  */
  YYSYMBOL__with = 2409,                   /* _with  */
  YYSYMBOL__with_for = 2410,               /* _with_for  */
  YYSYMBOL__exception = 2411,              /* _exception  */
  YYSYMBOL_at_end = 2412,                  /* at_end  */
  YYSYMBOL_on_escape = 2413,               /* on_escape  */
  YYSYMBOL_on_exception = 2414,            /* on_exception  */
  YYSYMBOL_column_or_col = 2415,           /* column_or_col  */
  YYSYMBOL_columns_or_cols = 2416,         /* columns_or_cols  */
  YYSYMBOL_column_or_cols = 2417,          /* column_or_cols  */
  YYSYMBOL_column_or_col_or_position_or_pos = 2418, /* column_or_col_or_position_or_pos  */
  YYSYMBOL_comp_equal = 2419,              /* comp_equal  */
  YYSYMBOL_exception_or_error = 2420,      /* exception_or_error  */
  YYSYMBOL_file_limit_or_limits = 2421,    /* file_limit_or_limits  */
  YYSYMBOL_in_of = 2422,                   /* in_of  */
  YYSYMBOL_label_option = 2423,            /* label_option  */
  YYSYMBOL_line_or_lines = 2424,           /* line_or_lines  */
  YYSYMBOL_lock_records = 2425,            /* lock_records  */
  YYSYMBOL_object_char_or_word_or_modules = 2426, /* object_char_or_word_or_modules  */
  YYSYMBOL_records = 2427,                 /* records  */
  YYSYMBOL_reel_or_unit = 2428,            /* reel_or_unit  */
  YYSYMBOL_size_or_length = 2429,          /* size_or_length  */
  YYSYMBOL_length_of = 2430,               /* length_of  */
  YYSYMBOL_track_or_tracks = 2431,         /* track_or_tracks  */
  YYSYMBOL_using_or_varying = 2432,        /* using_or_varying  */
  YYSYMBOL_detail_keyword = 2433,          /* detail_keyword  */
  YYSYMBOL_ch_keyword = 2434,              /* ch_keyword  */
  YYSYMBOL_cf_keyword = 2435,              /* cf_keyword  */
  YYSYMBOL_ph_keyword = 2436,              /* ph_keyword  */
  YYSYMBOL_pf_keyword = 2437,              /* pf_keyword  */
  YYSYMBOL_rh_keyword = 2438,              /* rh_keyword  */
  YYSYMBOL_rf_keyword = 2439,              /* rf_keyword  */
  YYSYMBOL_control_keyword = 2440          /* control_keyword  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

#if defined __GNUC__ && ! defined __ICC && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                            \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if 1

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* 1 */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   22382

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  973
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  1468
/* YYNRULES -- Number of rules.  */
#define YYNRULES  3498
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  4943

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   1227


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     805,   806,   807,   808,   809,   810,   811,   812,   813,   814,
     815,   816,   817,   818,   819,   820,   821,   822,   823,   824,
     825,   826,   827,   828,   829,   830,   831,   832,   833,   834,
     835,   836,   837,   838,   839,   840,   841,   842,   843,   844,
     845,   846,   847,   848,   849,   850,   851,   852,   853,   854,
     855,   856,   857,   858,   859,   860,   861,   862,   863,   864,
     865,   866,   867,   868,   869,   870,   871,   872,   873,   874,
     875,   876,   877,   878,   879,   880,   881,   882,   883,   884,
     885,   886,   887,   888,   889,   890,   891,   892,   893,   894,
     895,   896,   897,   898,   899,   900,   901,   902,   903,   904,
     905,   906,   907,   908,   909,   910,   911,   912,   913,   914,
     915,   916,   917,   918,   919,   920,   921,   922,   923,   924,
     925,   926,   927,   928,   929,   930,   931,   932,   933,   934,
     935,   936,   937,   938,   939,   940,   941,   942,   943,   944,
     945,   946,   947,   948,   949,   950,   951,   952,   953,   954,
     955,   956,   957,   958,   959,   960,   961,   962,   963,   964,
     965,   966,   967,   968,   969,   970,   971,   972
};

#if YYDEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,  3451,  3451,  3451,  3488,  3489,  3493,  3493,  3503,  3504,
    3508,  3509,  3510,  3511,  3515,  3515,  3527,  3538,  3546,  3550,
    3554,  3555,  3560,  3559,  3573,  3572,  3587,  3622,  3585,  3642,
    3671,  3640,  3686,  3688,  3688,  3700,  3701,  3704,  3703,  3710,
    3712,  3712,  3720,  3722,  3727,  3729,  3729,  3737,  3739,  3739,
    3752,  3756,  3750,  3768,  3769,  3773,  3773,  3783,  3783,  3787,
    3795,  3827,  3834,  3846,  3857,  3864,  3865,  3872,  3873,  3877,
    3878,  3882,  3886,  3890,  3891,  3898,  3899,  3903,  3907,  3913,
    3915,  3923,  3930,  3932,  3936,  3943,  3947,  3951,  3967,  3970,
    3980,  3982,  3989,  3993,  3997,  4003,  4005,  4012,  4016,  4020,
    4024,  4033,  4038,  4039,  4042,  4044,  4053,  4057,  4058,  4061,
    4063,  4073,  4075,  4079,  4080,  4084,  4085,  4086,  4087,  4088,
    4093,  4094,  4099,  4098,  4109,  4110,  4113,  4114,  4127,  4126,
    4140,  4141,  4142,  4143,  4147,  4148,  4152,  4153,  4154,  4155,
    4159,  4167,  4176,  4175,  4183,  4187,  4193,  4197,  4202,  4209,
    4219,  4233,  4244,  4248,  4252,  4256,  4263,  4264,  4268,  4269,
    4274,  4273,  4286,  4288,  4289,  4296,  4297,  4301,  4305,  4311,
    4312,  4319,  4326,  4331,  4342,  4357,  4360,  4361,  4364,  4368,
    4369,  4370,  4371,  4372,  4373,  4374,  4375,  4376,  4377,  4378,
    4379,  4380,  4381,  4382,  4390,  4389,  4408,  4410,  4413,  4424,
    4447,  4455,  4458,  4459,  4463,  4470,  4485,  4506,  4505,  4530,
    4529,  4538,  4537,  4547,  4549,  4553,  4557,  4558,  4564,  4570,
    4576,  4585,  4586,  4593,  4600,  4610,  4616,  4624,  4634,  4638,
    4645,  4649,  4654,  4653,  4664,  4668,  4675,  4676,  4677,  4678,
    4679,  4680,  4684,  4685,  4690,  4693,  4697,  4705,  4708,  4719,
    4745,  4753,  4757,  4768,  4788,  4796,  4807,  4808,  4815,  4829,
    4830,  4834,  4853,  4884,  4885,  4889,  4893,  4914,  4936,  4935,
    4959,  4966,  4978,  5045,  5048,  5057,  5076,  5092,  5110,  5128,
    5145,  5163,  5162,  5190,  5196,  5197,  5198,  5207,  5208,  5216,
    5217,  5221,  5223,  5221,  5269,  5270,  5276,  5277,  5286,  5287,
    5288,  5289,  5290,  5291,  5292,  5293,  5294,  5295,  5296,  5297,
    5298,  5299,  5300,  5301,  5302,  5303,  5304,  5305,  5328,  5338,
    5348,  5359,  5370,  5401,  5404,  5408,  5412,  5416,  5421,  5425,
    5433,  5439,  5445,  5455,  5456,  5457,  5458,  5462,  5463,  5464,
    5465,  5466,  5467,  5468,  5472,  5480,  5484,  5492,  5496,  5503,
    5504,  5510,  5517,  5518,  5519,  5526,  5581,  5584,  5589,  5588,
    5600,  5613,  5616,  5620,  5630,  5641,  5640,  5648,  5652,  5658,
    5662,  5667,  5674,  5684,  5695,  5705,  5709,  5713,  5717,  5726,
    5737,  5739,  5740,  5746,  5746,  5753,  5757,  5761,  5768,  5769,
    5770,  5774,  5780,  5781,  5785,  5791,  5792,  5808,  5809,  5813,
    5819,  5825,  5831,  5844,  5855,  5854,  5863,  5874,  5888,  5901,
    5917,  5956,  5959,  5966,  5967,  5971,  5971,  5975,  5980,  5998,
    6009,  6016,  6017,  6023,  6036,  6037,  6038,  6044,  6052,  6053,
    6059,  6069,  6079,  6089,  6099,  6100,  6107,  6115,  6116,  6117,
    6124,  6125,  6129,  6130,  6131,  6132,  6138,  6166,  6167,  6168,
    6169,  6175,  6180,  6184,  6188,  6189,  6196,  6197,  6198,  6199,
    6200,  6201,  6202,  6203,  6210,  6209,  6225,  6226,  6230,  6233,
    6234,  6240,  6244,  6248,  6249,  6253,  6255,  6256,  6264,  6268,
    6269,  6273,  6274,  6278,  6279,  6283,  6284,  6285,  6295,  6292,
    6306,  6307,  6310,  6312,  6320,  6321,  6322,  6330,  6331,  6335,
    6355,  6354,  6378,  6385,  6390,  6397,  6398,  6402,  6412,  6427,
    6428,  6429,  6430,  6431,  6432,  6433,  6434,  6435,  6442,  6449,
    6449,  6449,  6455,  6464,  6480,  6492,  6493,  6497,  6498,  6502,
    6503,  6510,  6521,  6526,  6537,  6538,  6542,  6543,  6549,  6560,
    6578,  6579,  6583,  6584,  6585,  6589,  6596,  6603,  6612,  6621,
    6622,  6623,  6624,  6625,  6634,  6635,  6641,  6680,  6681,  6690,
    6705,  6706,  6710,  6724,  6745,  6746,  6748,  6747,  6765,  6766,
    6770,  6785,  6788,  6787,  6809,  6810,  6814,  6815,  6816,  6819,
    6821,  6822,  6826,  6827,  6831,  6832,  6833,  6834,  6835,  6836,
    6837,  6838,  6839,  6840,  6841,  6845,  6849,  6851,  6855,  6856,
    6860,  6861,  6862,  6863,  6864,  6865,  6866,  6869,  6871,  6872,
    6876,  6877,  6881,  6882,  6883,  6884,  6885,  6886,  6890,  6895,
    6896,  6899,  6897,  6914,  6918,  6918,  6931,  6932,  6936,  6937,
    6938,  6940,  6939,  6960,  6973,  6986,  6992,  6994,  6998,  7005,
    7009,  7020,  7023,  7035,  7036,  7038,  7042,  7046,  7052,  7056,
    7060,  7064,  7068,  7072,  7076,  7084,  7088,  7092,  7100,  7104,
    7108,  7112,  7123,  7124,  7128,  7129,  7133,  7134,  7138,  7139,
    7143,  7187,  7190,  7198,  7197,  7211,  7217,  7221,  7246,  7245,
    7260,  7269,  7276,  7287,  7291,  7298,  7299,  7303,  7304,  7305,
    7306,  7307,  7308,  7309,  7310,  7311,  7312,  7315,  7317,  7321,
    7325,  7329,  7330,  7331,  7332,  7333,  7334,  7335,  7336,  7337,
    7338,  7339,  7340,  7341,  7342,  7343,  7344,  7345,  7346,  7347,
    7348,  7349,  7350,  7351,  7352,  7353,  7354,  7355,  7356,  7357,
    7358,  7368,  7389,  7403,  7404,  7407,  7416,  7435,  7459,  7460,
    7470,  7498,  7501,  7509,  7510,  7514,  7539,  7538,  7550,  7558,
    7575,  7587,  7605,  7604,  7615,  7616,  7622,  7629,  7630,  7631,
    7637,  7655,  7654,  7671,  7673,  7687,  7728,  7733,  7736,  7743,
    7757,  7768,  7769,  7770,  7804,  7811,  7812,  7818,  7819,  7823,
    7827,  7832,  7837,  7845,  7849,  7854,  7861,  7865,  7870,  7879,
    7883,  7888,  7892,  7896,  7900,  7904,  7908,  7912,  7916,  7920,
    7925,  7929,  7937,  7943,  7951,  7955,  7959,  7963,  7968,  7972,
    7977,  7981,  7986,  7991,  7996,  8000,  8004,  8012,  8016,  8020,
    8028,  8032,  8036,  8040,  8044,  8048,  8052,  8056,  8060,  8068,
    8076,  8080,  8084,  8088,  8092,  8096,  8101,  8106,  8114,  8115,
    8119,  8120,  8125,  8132,  8134,  8135,  8136,  8139,  8141,  8145,
    8146,  8150,  8151,  8155,  8158,  8160,  8161,  8162,  8163,  8164,
    8165,  8168,  8170,  8176,  8183,  8195,  8210,  8219,  8220,  8229,
    8236,  8248,  8266,  8267,  8271,  8272,  8276,  8277,  8280,  8281,
    8286,  8287,  8294,  8295,  8301,  8303,  8305,  8304,  8309,  8310,
    8314,  8336,  8337,  8341,  8366,  8367,  8370,  8372,  8376,  8383,
    8384,  8389,  8407,  8418,  8438,  8439,  8440,  8447,  8458,  8485,
    8499,  8507,  8528,  8539,  8553,  8554,  8558,  8590,  8591,  8595,
    8599,  8600,  8604,  8611,  8612,  8616,  8617,  8621,  8625,  8633,
    8634,  8638,  8639,  8643,  8648,  8658,  8657,  8665,  8677,  8678,
    8682,  8683,  8687,  8689,  8690,  8694,  8705,  8712,  8713,  8716,
    8718,  8727,  8735,  8736,  8740,  8741,  8742,  8743,  8749,  8756,
    8757,  8763,  8770,  8771,  8772,  8773,  8774,  8775,  8776,  8782,
    8793,  8802,  8812,  8821,  8836,  8859,  8878,  8879,  8881,  8880,
    8904,  8905,  8907,  8906,  8924,  8925,  8927,  8925,  8937,  8938,
    8944,  8946,  8944,  8972,  8973,  8974,  8981,  8987,  8992,  8993,
    8999,  9006,  9007,  9008,  9012,  9019,  9020,  9024,  9034,  9073,
    9084,  9085,  9099,  9112,  9113,  9116,  9117,  9122,  9123,  9124,
    9125,  9126,  9127,  9139,  9153,  9167,  9181,  9195,  9208,  9209,
    9214,  9213,  9227,  9236,  9237,  9241,  9242,  9243,  9244,  9245,
    9246,  9247,  9248,  9249,  9250,  9251,  9252,  9253,  9254,  9255,
    9256,  9257,  9261,  9268,  9272,  9276,  9277,  9278,  9285,  9289,
    9297,  9300,  9308,  9318,  9319,  9324,  9327,  9332,  9336,  9344,
    9351,  9360,  9365,  9372,  9373,  9374,  9378,  9385,  9386,  9387,
    9394,  9398,  9405,  9410,  9416,  9423,  9429,  9439,  9443,  9450,
    9452,  9456,  9460,  9464,  9468,  9475,  9476,  9481,  9518,  9521,
    9529,  9532,  9539,  9550,  9551,  9554,  9556,  9560,  9564,  9578,
    9593,  9596,  9598,  9602,  9606,  9610,  9617,  9639,  9643,  9644,
    9648,  9669,  9677,  9686,  9687,  9689,  9687,  9709,  9710,  9714,
    9715,  9719,  9722,  9721,  9773,  9785,  9772,  9829,  9849,  9851,
    9855,  9860,  9865,  9869,  9873,  9878,  9883,  9888,  9893,  9902,
    9906,  9910,  9914,  9918,  9924,  9928,  9933,  9939,  9943,  9948,
    9953,  9958,  9963,  9968,  9973,  9982,  9986,  9990,  9996, 10000,
   10004, 10008, 10012, 10016, 10020, 10024, 10035, 10040, 10045, 10049,
   10050, 10051, 10052, 10053, 10054, 10055, 10056, 10065, 10070, 10081,
   10094, 10095, 10099, 10100, 10107, 10108, 10109, 10110, 10111, 10112,
   10113, 10114, 10115, 10118, 10121, 10122, 10123, 10124, 10125, 10126,
   10133, 10134, 10139, 10140, 10143, 10145, 10149, 10150, 10154, 10155,
   10156, 10160, 10161, 10165, 10166, 10170, 10171, 10172, 10173, 10174,
   10177, 10178, 10179, 10180, 10181, 10183, 10184, 10186, 10187, 10191,
   10192, 10193, 10194, 10196, 10198, 10200, 10201, 10202, 10203, 10204,
   10205, 10206, 10207, 10208, 10214, 10215, 10216, 10217, 10218, 10219,
   10220, 10221, 10222, 10223, 10227, 10228, 10233, 10234, 10235, 10236,
   10237, 10241, 10249, 10250, 10251, 10252, 10253, 10254, 10255, 10256,
   10257, 10258, 10259, 10261, 10263, 10264, 10265, 10269, 10270, 10271,
   10272, 10273, 10274, 10275, 10276, 10277, 10278, 10283, 10284, 10285,
   10286, 10287, 10288, 10289, 10290, 10291, 10292, 10297, 10298, 10309,
   10310, 10334, 10335, 10352, 10355, 10356, 10357, 10360, 10364, 10365,
   10366, 10367, 10368, 10369, 10370, 10371, 10372, 10373, 10374, 10375,
   10376, 10377, 10378, 10379, 10385, 10386, 10387, 10407, 10408, 10409,
   10410, 10411, 10412, 10413, 10414, 10418, 10419, 10420, 10421, 10422,
   10423, 10429, 10430, 10431, 10432, 10433, 10434, 10435, 10436, 10441,
   10443, 10444, 10445, 10450, 10451, 10452, 10456, 10457, 10458, 10459,
   10460, 10461, 10472, 10473, 10474, 10475, 10480, 10483, 10484, 10485,
   10486, 10487, 10489, 10494, 10495, 10496, 10502, 10503, 10504, 10505,
   10506, 10507, 10508, 10509, 10510, 10511, 10515, 10516, 10517, 10518,
   10519, 10520, 10521, 10522, 10523, 10524, 10525, 10526, 10527, 10528,
   10530, 10531, 10532, 10533, 10534, 10535, 10536, 10537, 10538, 10539,
   10540, 10541, 10542, 10543, 10544, 10545, 10546, 10549, 10550, 10551,
   10559, 10560, 10561, 10565, 10566, 10567, 10571, 10572, 10575, 10576,
   10577, 10580, 10589, 10590, 10591, 10592, 10593, 10594, 10595, 10596,
   10597, 10598, 10599, 10600, 10601, 10603, 10604, 10605, 10606, 10607,
   10608, 10609, 10610, 10611, 10612, 10619, 10623, 10627, 10628, 10629,
   10630, 10631, 10632, 10633, 10634, 10640, 10641, 10642, 10647, 10648,
   10653, 10658, 10659, 10663, 10664, 10669, 10670, 10674, 10675, 10676,
   10681, 10682, 10686, 10687, 10691, 10692, 10696, 10700, 10700, 10704,
   10708, 10708, 10712, 10716, 10717, 10721, 10722, 10726, 10734, 10736,
   10740, 10747, 10757, 10760, 10764, 10771, 10783, 10789, 10791, 10798,
   10807, 10811, 10813, 10823, 10846, 10811, 10872, 10872, 10908, 10912,
   10911, 10925, 10924, 10944, 10945, 10950, 10972, 10974, 10978, 10989,
   10991, 10995, 11003, 11012, 11020, 11026, 11030, 11074, 11076, 11084,
   11087, 11100, 11105, 11115, 11150, 11152, 11159, 11161, 11151, 11192,
   11193, 11197, 11198, 11200, 11199, 11218, 11219, 11230, 11234, 11243,
   11242, 11288, 11289, 11293, 11338, 11361, 11364, 11393, 11399, 11392,
   11415, 11415, 11454, 11462, 11463, 11464, 11465, 11466, 11467, 11468,
   11469, 11470, 11471, 11472, 11473, 11474, 11475, 11476, 11477, 11478,
   11479, 11480, 11481, 11482, 11483, 11484, 11485, 11486, 11487, 11488,
   11489, 11490, 11491, 11493, 11494, 11495, 11496, 11497, 11498, 11499,
   11500, 11501, 11502, 11503, 11504, 11505, 11506, 11507, 11509, 11510,
   11511, 11512, 11513, 11514, 11515, 11516, 11517, 11518, 11519, 11520,
   11521, 11522, 11523, 11524, 11525, 11526, 11527, 11528, 11530, 11529,
   11545, 11557, 11556, 11567, 11566, 11601, 11600, 11611, 11615, 11619,
   11625, 11631, 11636, 11641, 11646, 11651, 11657, 11663, 11667, 11673,
   11677, 11681, 11686, 11690, 11694, 11698, 11702, 11706, 11710, 11714,
   11728, 11735, 11736, 11743, 11743, 11754, 11756, 11760, 11764, 11768,
   11775, 11779, 11783, 11790, 11791, 11795, 11797, 11801, 11802, 11806,
   11807, 11811, 11815, 11816, 11825, 11826, 11831, 11832, 11836, 11837,
   11841, 11857, 11873, 11886, 11894, 11902, 11909, 11915, 11921, 11926,
   11932, 11937, 11942, 11955, 11960, 11965, 11971, 11977, 11983, 11990,
   11994, 11998, 12002, 12006, 12017, 12022, 12028, 12033, 12038, 12043,
   12049, 12055, 12060, 12066, 12072, 12078, 12085, 12090, 12095, 12102,
   12109, 12115, 12118, 12118, 12122, 12133, 12134, 12135, 12139, 12140,
   12141, 12145, 12146, 12150, 12154, 12173, 12172, 12181, 12185, 12192,
   12196, 12204, 12205, 12209, 12213, 12224, 12223, 12233, 12237, 12248,
   12250, 12263, 12264, 12272, 12271, 12280, 12281, 12285, 12291, 12291,
   12298, 12297, 12314, 12313, 12397, 12401, 12400, 12416, 12420, 12424,
   12432, 12435, 12443, 12451, 12455, 12459, 12463, 12467, 12471, 12490,
   12496, 12516, 12520, 12530, 12534, 12539, 12543, 12542, 12559, 12560,
   12565, 12573, 12577, 12599, 12601, 12605, 12618, 12635, 12638, 12642,
   12646, 12651, 12674, 12675, 12679, 12680, 12684, 12688, 12692, 12703,
   12707, 12714, 12718, 12726, 12730, 12737, 12744, 12748, 12759, 12758,
   12770, 12771, 12780, 12784, 12791, 12792, 12802, 12801, 12809, 12810,
   12814, 12821, 12829, 12830, 12831, 12832, 12833, 12838, 12837, 12849,
   12850, 12858, 12857, 12866, 12873, 12877, 12887, 12899, 12898, 12920,
   12923, 12923, 12938, 12937, 12946, 12953, 12964, 12963, 12972, 12976,
   12983, 12990, 12998, 13002, 13013, 13012, 13021, 13024, 13026, 13032,
   13034, 13035, 13036, 13037, 13045, 13044, 13056, 13060, 13064, 13068,
   13072, 13073, 13077, 13078, 13079, 13080, 13081, 13082, 13086, 13094,
   13105, 13106, 13111, 13110, 13157, 13161, 13167, 13169, 13173, 13174,
   13178, 13179, 13183, 13187, 13192, 13196, 13197, 13202, 13205, 13209,
   13213, 13217, 13221, 13228, 13229, 13234, 13233, 13250, 13257, 13257,
   13269, 13273, 13280, 13281, 13282, 13292, 13291, 13309, 13311, 13315,
   13316, 13320, 13324, 13325, 13326, 13327, 13332, 13337, 13331, 13351,
   13352, 13357, 13364, 13356, 13383, 13382, 13405, 13406, 13407, 13411,
   13412, 13417, 13420, 13427, 13440, 13452, 13459, 13460, 13466, 13467,
   13471, 13472, 13473, 13474, 13475, 13476, 13480, 13483, 13487, 13488,
   13489, 13493, 13494, 13495, 13496, 13500, 13501, 13506, 13507, 13511,
   13521, 13537, 13542, 13548, 13554, 13559, 13564, 13570, 13576, 13582,
   13588, 13595, 13599, 13603, 13607, 13611, 13616, 13621, 13626, 13631,
   13637, 13642, 13647, 13654, 13664, 13668, 13679, 13678, 13687, 13691,
   13695, 13699, 13703, 13710, 13714, 13725, 13724, 13734, 13737, 13736,
   13744, 13743, 13753, 13777, 13790, 13789, 13816, 13826, 13827, 13832,
   13843, 13854, 13868, 13876, 13884, 13885, 13890, 13896, 13906, 13918,
   13924, 13934, 13947, 13946, 13958, 13956, 13970, 13971, 13976, 14051,
   14052, 14053, 14054, 14058, 14059, 14063, 14067, 14077, 14076, 14090,
   14089, 14130, 14130, 14131, 14131, 14132, 14132, 14135, 14144, 14155,
   14156, 14164, 14163, 14175, 14179, 14197, 14211, 14234, 14257, 14278,
   14301, 14305, 14313, 14314, 14324, 14323, 14332, 14343, 14342, 14351,
   14366, 14365, 14378, 14383, 14394, 14398, 14409, 14409, 14424, 14423,
   14432, 14436, 14442, 14449, 14452, 14459, 14465, 14471, 14476, 14488,
   14487, 14495, 14503, 14504, 14508, 14509, 14510, 14515, 14518, 14525,
   14529, 14537, 14544, 14545, 14546, 14547, 14548, 14549, 14550, 14562,
   14565, 14575, 14574, 14582, 14591, 14604, 14603, 14615, 14616, 14623,
   14622, 14631, 14640, 14641, 14645, 14646, 14647, 14651, 14652, 14653,
   14654, 14661, 14660, 14670, 14669, 14719, 14750, 14751, 14752, 14756,
   14757, 14758, 14759, 14763, 14764, 14768, 14775, 14790, 14789, 14810,
   14820, 14828, 14832, 14839, 14844, 14849, 14854, 14859, 14864, 14872,
   14873, 14877, 14882, 14888, 14890, 14891, 14892, 14893, 14897, 14925,
   14928, 14932, 14936, 14940, 14947, 14954, 14962, 14965, 14964, 14978,
   14983, 14976, 14994, 14995, 14999, 15000, 15004, 15012, 15016, 15026,
   15025, 15037, 15048, 15049, 15056, 15055, 15068, 15067, 15080, 15081,
   15085, 15089, 15100, 15099, 15107, 15111, 15122, 15121, 15130, 15134,
   15141, 15145, 15156, 15155, 15164, 15165, 15169, 15197, 15198, 15202,
   15203, 15204, 15205, 15209, 15210, 15214, 15215, 15216, 15220, 15221,
   15229, 15230, 15234, 15235, 15241, 15250, 15251, 15252, 15257, 15258,
   15259, 15263, 15270, 15286, 15287, 15288, 15294, 15293, 15305, 15317,
   15314, 15331, 15328, 15344, 15352, 15359, 15363, 15376, 15382, 15394,
   15397, 15402, 15406, 15420, 15427, 15428, 15432, 15433, 15436, 15437,
   15442, 15485, 15489, 15499, 15498, 15511, 15510, 15518, 15523, 15532,
   15547, 15546, 15556, 15585, 15586, 15590, 15594, 15598, 15602, 15609,
   15610, 15614, 15618, 15621, 15623, 15627, 15636, 15637, 15638, 15642,
   15643, 15647, 15651, 15655, 15663, 15664, 15668, 15669, 15673, 15677,
   15687, 15698, 15697, 15706, 15711, 15712, 15716, 15717, 15718, 15722,
   15723, 15727, 15731, 15732, 15736, 15740, 15744, 15754, 15753, 15761,
   15771, 15782, 15781, 15790, 15797, 15801, 15812, 15811, 15823, 15832,
   15835, 15839, 15843, 15850, 15854, 15864, 15874, 15877, 15876, 15883,
   15882, 15891, 15899, 15908, 15909, 15914, 15917, 15925, 15931, 15935,
   15942, 15950, 15954, 15969, 15979, 15978, 15986, 15987, 15993, 16011,
   16022, 16024, 16028, 16047, 16051, 16058, 16059, 16060, 16061, 16064,
   16066, 16073, 16072, 16086, 16087, 16088, 16089, 16090, 16091, 16092,
   16093, 16097, 16098, 16102, 16103, 16109, 16118, 16125, 16126, 16130,
   16134, 16138, 16144, 16150, 16154, 16158, 16162, 16171, 16175, 16179,
   16183, 16187, 16196, 16205, 16206, 16210, 16219, 16220, 16224, 16228,
   16237, 16246, 16258, 16257, 16267, 16265, 16318, 16319, 16336, 16337,
   16340, 16341, 16350, 16353, 16358, 16363, 16373, 16390, 16395, 16405,
   16423, 16422, 16432, 16445, 16448, 16456, 16459, 16464, 16469, 16477,
   16478, 16479, 16480, 16481, 16482, 16491, 16492, 16496, 16500, 16509,
   16512, 16511, 16522, 16529, 16537, 16551, 16558, 16562, 16566, 16574,
   16585, 16586, 16590, 16594, 16601, 16602, 16603, 16604, 16611, 16610,
   16619, 16626, 16626, 16636, 16637, 16641, 16655, 16656, 16661, 16662,
   16666, 16667, 16671, 16675, 16686, 16685, 16694, 16698, 16702, 16706,
   16714, 16718, 16728, 16728, 16740, 16741, 16748, 16747, 16755, 16764,
   16777, 16776, 16784, 16796, 16795, 16803, 16820, 16819, 16829, 16837,
   16838, 16843, 16844, 16849, 16856, 16857, 16862, 16869, 16870, 16874,
   16875, 16879, 16883, 16893, 16892, 16907, 16912, 16924, 16923, 16932,
   16933, 16934, 16935, 16936, 16940, 16968, 16971, 16983, 16993, 16998,
   17003, 17008, 17016, 17056, 17057, 17061, 17121, 17131, 17154, 17155,
   17156, 17157, 17161, 17170, 17176, 17186, 17213, 17217, 17218, 17222,
   17228, 17244, 17245, 17252, 17251, 17263, 17273, 17274, 17279, 17282,
   17286, 17290, 17297, 17298, 17302, 17303, 17304, 17308, 17312, 17320,
   17323, 17322, 17336, 17347, 17334, 17358, 17360, 17364, 17365, 17369,
   17373, 17385, 17394, 17404, 17407, 17417, 17420, 17428, 17431, 17440,
   17444, 17451, 17459, 17462, 17469, 17473, 17480, 17484, 17492, 17495,
   17504, 17508, 17515, 17523, 17526, 17530, 17531, 17532, 17535, 17537,
   17545, 17546, 17550, 17555, 17560, 17567, 17572, 17577, 17585, 17589,
   17596, 17600, 17611, 17610, 17639, 17634, 17654, 17657, 17665, 17666,
   17670, 17671, 17676, 17677, 17693, 17694, 17695, 17705, 17709, 17716,
   17724, 17725, 17729, 17730, 17734, 17742, 17743, 17748, 17749, 17750,
   17760, 17764, 17771, 17779, 17780, 17784, 17794, 17795, 17796, 17806,
   17810, 17817, 17825, 17826, 17830, 17840, 17841, 17842, 17852, 17856,
   17863, 17871, 17872, 17876, 17887, 17888, 17900, 17902, 17911, 17915,
   17922, 17930, 17931, 17935, 17945, 17946, 17956, 17960, 17967, 17975,
   17976, 17980, 17990, 17991, 17995, 17996, 18006, 18010, 18017, 18025,
   18026, 18030, 18041, 18044, 18053, 18056, 18064, 18068, 18077, 18081,
   18088, 18089, 18101, 18106, 18114, 18121, 18121, 18132, 18133, 18137,
   18138, 18140, 18142, 18144, 18145, 18147, 18148, 18149, 18150, 18151,
   18153, 18154, 18155, 18156, 18157, 18158, 18159, 18160, 18161, 18162,
   18163, 18167, 18172, 18180, 18187, 18187, 18198, 18199, 18203, 18204,
   18205, 18206, 18208, 18209, 18211, 18212, 18213, 18214, 18215, 18217,
   18218, 18219, 18220, 18221, 18222, 18223, 18224, 18225, 18226, 18229,
   18231, 18235, 18238, 18240, 18241, 18242, 18243, 18244, 18245, 18247,
   18248, 18249, 18250, 18251, 18255, 18256, 18260, 18261, 18265, 18266,
   18270, 18271, 18275, 18279, 18285, 18289, 18295, 18297, 18298, 18302,
   18303, 18304, 18308, 18309, 18310, 18311, 18312, 18313, 18314, 18315,
   18316, 18317, 18321, 18325, 18329, 18330, 18331, 18332, 18335, 18336,
   18346, 18358, 18367, 18383, 18392, 18408, 18423, 18424, 18429, 18438,
   18444, 18454, 18468, 18493, 18497, 18518, 18522, 18543, 18555, 18569,
   18583, 18584, 18589, 18595, 18596, 18601, 18610, 18612, 18617, 18631,
   18632, 18633, 18640, 18651, 18652, 18656, 18664, 18665, 18669, 18670,
   18674, 18686, 18690, 18697, 18706, 18707, 18713, 18722, 18731, 18745,
   18762, 18766, 18773, 18774, 18775, 18782, 18783, 18787, 18791, 18798,
   18799, 18803, 18804, 18808, 18809, 18810, 18811, 18815, 18819, 18823,
   18827, 18831, 18852, 18862, 18866, 18873, 18874, 18875, 18879, 18880,
   18881, 18882, 18883, 18887, 18891, 18898, 18899, 18900, 18901, 18905,
   18909, 18916, 18928, 18940, 18954, 18955, 18959, 18960, 18964, 18971,
   18972, 18979, 18980, 18987, 18988, 18989, 18993, 18994, 18998, 19002,
   19006, 19010, 19011, 19015, 19019, 19020, 19024, 19028, 19029, 19038,
   19042, 19047, 19048, 19054, 19058, 19062, 19066, 19067, 19073, 19077,
   19081, 19082, 19086, 19093, 19103, 19122, 19143, 19162, 19180, 19187,
   19194, 19201, 19211, 19215, 19222, 19226, 19233, 19255, 19268, 19275,
   19279, 19283, 19287, 19293, 19294, 19310, 19336, 19340, 19348, 19348,
   19361, 19366, 19374, 19382, 19386, 19396, 19411, 19433, 19453, 19457,
   19464, 19478, 19486, 19487, 19488, 19489, 19490, 19491, 19495, 19499,
   19515, 19519, 19525, 19525, 19528, 19529, 19530, 19531, 19537, 19541,
   19545, 19549, 19553, 19557, 19562, 19567, 19571, 19575, 19579, 19583,
   19587, 19591, 19598, 19599, 19603, 19604, 19605, 19606, 19610, 19611,
   19612, 19613, 19614, 19618, 19622, 19626, 19633, 19637, 19641, 19648,
   19655, 19662, 19672, 19672, 19688, 19695, 19705, 19712, 19722, 19726,
   19739, 19743, 19758, 19766, 19767, 19771, 19772, 19773, 19777, 19778,
   19783, 19786, 19794, 19797, 19805, 19807, 19808, 19812, 19813, 19817,
   19818, 19819, 19824, 19827, 19840, 19844, 19852, 19856, 19860, 19864,
   19868, 19872, 19876, 19880, 19887, 19888, 19892, 19893, 19903, 19904,
   19913, 19917, 19921, 19925, 19932, 19933, 19934, 19935, 19936, 19937,
   19938, 19939, 19940, 19941, 19942, 19943, 19944, 19945, 19946, 19947,
   19948, 19949, 19950, 19951, 19952, 19953, 19954, 19955, 19956, 19957,
   19958, 19959, 19960, 19961, 19962, 19963, 19964, 19965, 19966, 19967,
   19968, 19969, 19970, 19971, 19972, 19973, 19974, 19975, 19976, 19977,
   19978, 19979, 19980, 19981, 19982, 19983, 19987, 19988, 19989, 19990,
   19991, 19992, 19993, 19994, 19995, 19996, 19997, 19998, 19999, 20000,
   20001, 20002, 20003, 20004, 20005, 20006, 20007, 20008, 20009, 20013,
   20014, 20021, 20022, 20031, 20040, 20041, 20042, 20051, 20054, 20057,
   20060, 20061, 20062, 20071, 20071, 20071, 20071, 20074, 20074, 20074,
   20077, 20077, 20077, 20077, 20078, 20078, 20078, 20081, 20082, 20087,
   20099, 20099, 20100, 20100, 20101, 20101, 20102, 20102, 20103, 20103,
   20103, 20104, 20104, 20105, 20105, 20106, 20106, 20107, 20107, 20108,
   20108, 20109, 20109, 20110, 20110, 20111, 20111, 20112, 20112, 20113,
   20113, 20114, 20114, 20115, 20115, 20116, 20116, 20117, 20117, 20118,
   20118, 20119, 20119, 20120, 20120, 20121, 20121, 20122, 20122, 20123,
   20123, 20123, 20124, 20124, 20124, 20125, 20125, 20126, 20126, 20127,
   20127, 20128, 20128, 20129, 20129, 20130, 20130, 20130, 20131, 20131,
   20131, 20132, 20132, 20132, 20132, 20133, 20133, 20133, 20134, 20134,
   20135, 20135, 20136, 20136, 20136, 20137, 20137, 20137, 20138, 20138,
   20139, 20139, 20140, 20140, 20141, 20141, 20142, 20142, 20143, 20143,
   20144, 20144, 20145, 20145, 20146, 20146, 20147, 20147, 20147, 20148,
   20148, 20148, 20148, 20149, 20149, 20150, 20150, 20151, 20151, 20152,
   20152, 20153, 20153, 20154, 20154, 20155, 20155, 20155, 20156, 20156,
   20157, 20157, 20158, 20158, 20159, 20159, 20159, 20160, 20160, 20161,
   20161, 20162, 20162, 20163, 20163, 20164, 20164, 20165, 20165, 20166,
   20166, 20167, 20167, 20168, 20168, 20169, 20169, 20170, 20170, 20171,
   20171, 20172, 20172, 20173, 20173, 20173, 20175, 20175, 20179, 20179,
   20180, 20180, 20181, 20181, 20182, 20182, 20183, 20183, 20184, 20184,
   20185, 20185, 20185, 20185, 20186, 20186, 20187, 20187, 20188, 20188,
   20189, 20189, 20190, 20190, 20191, 20191, 20192, 20192, 20193, 20193,
   20193, 20194, 20194, 20195, 20195, 20196, 20196, 20197, 20197, 20198,
   20198, 20199, 20199, 20202, 20202, 20203, 20203, 20204, 20204, 20205,
   20205, 20206, 20206, 20207, 20207, 20208, 20208, 20209, 20209
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if 1
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "\"3D\"", "ABSENT",
  "ACCEPT", "ACCESS", "\"ACTIVE-X\"", "\"ACTIVE-CLASS\"", "ACTION",
  "ACTUAL", "ADD", "ADDRESS", "\"ADJUSTABLE-COLUMNS\"", "ADVANCING",
  "AFTER", "ALIGNED", "ALIGNMENT", "ALL", "ALLOCATE", "ALLOWING",
  "ALPHABET", "ALPHABETIC", "\"ALPHABETIC-LOWER\"", "\"ALPHABETIC-UPPER\"",
  "ALPHANUMERIC", "\"ALPHANUMERIC-EDITED\"", "ALSO", "ALTER", "ALTERNATE",
  "AND", "ANY", "APPLY", "ARE", "AREA", "AREAS", "\"ARGUMENT-NUMBER\"",
  "\"ARGUMENT-VALUE\"", "ARITHMETIC", "AS", "ASCENDING", "ASCII", "ASSIGN",
  "AT", "\"AT END\"", "ATTRIBUTE", "ATTRIBUTES", "AUTHOR", "AUTO",
  "\"AUTO-DECIMAL\"", "\"AUTO-SPIN\"", "AUTOMATIC", "\"AWAY-FROM-ZERO\"",
  "\"B-AND\"", "\"B-NOT\"", "\"B-OR\"", "\"B-XOR\"", "\"B-SHIFT-L\"",
  "\"B-SHIFT-R\"", "\"B-SHIFT-LC\"", "\"B-SHIFT-RC\"",
  "\"BACKGROUND-COLOR\"", "\"BACKGROUND-HIGH\"", "\"BACKGROUND-LOW\"",
  "\"BACKGROUND-STANDARD\"", "BACKWARD", "BAR", "BASED", "BEFORE", "BELL",
  "BINARY", "\"BINARY-C-LONG\"", "\"BINARY-CHAR\"", "\"BINARY-DOUBLE\"",
  "\"BINARY-LONG\"", "\"BINARY-SEQUENTIAL\"", "\"BINARY-SHORT\"", "BIT",
  "BITMAP", "\"BITMAP-END\"", "\"BITMAP-HANDLE\"", "\"BITMAP-NUMBER\"",
  "\"BITMAP-START\"", "\"BITMAP-TIMER\"", "\"BITMAP-TRAILING\"",
  "\"BITMAP-TRANSPARENT-COLOR\"", "\"BITMAP-WIDTH\"", "BLANK", "BLINK",
  "BLOCK", "BOOLEAN", "BOTTOM", "BOX", "BOXED", "\"BULK-ADDITION\"",
  "BUSY", "BUTTONS", "BY", "\"BYTE-LENGTH\"", "C", "\"CALENDAR-FONT\"",
  "CALL", "CANCEL", "\"CANCEL-BUTTON\"", "CAPACITY", "\"CARD-PUNCH\"",
  "\"CARD-READER\"", "CASSETTE", "CCOL", "CD", "CELL", "\"CELL-COLOR\"",
  "\"CELL-DATA\"", "\"CELL-FONT\"", "\"CELL-PROTECTION\"", "CENTER",
  "CENTERED", "\"CENTERED-HEADINGS\"", "\"CENTURY-DATE\"", "CF", "CH",
  "CHAINING", "CHANGED", "CHARACTER", "CHARACTERS", "\"CHECK-BOX\"",
  "CLASS", "CLASSIFICATION", "\"class-name\"", "\"CLEAR-SELECTION\"",
  "CLINE", "CLINES", "CLOSE", "COBOL", "CODE", "\"CODE-SET\"", "COLLATING",
  "COL", "COLOR", "COLORS", "COLS", "COLUMN", "\"COLUMN-COLOR\"",
  "\"COLUMN-DIVIDERS\"", "\"COLUMN-FONT\"", "\"COLUMN-HEADINGS\"",
  "\"COLUMN-PROTECTION\"", "COLUMNS", "\"COMBO-BOX\"", "COMMA",
  "\"COMMAND-LINE\"", "\"comma delimiter\"", "COMMIT", "COMMON",
  "COMMUNICATION", "COMP", "COMPUTE", "\"COMP-0\"", "\"COMP-1\"",
  "\"COMP-2\"", "\"COMP-3\"", "\"COMP-4\"", "\"COMP-5\"", "\"COMP-6\"",
  "\"COMP-N\"", "\"COMP-X\"", "\"FUNCTION CONCATENATE\"", "CONDITION",
  "CONFIGURATION", "CONSTANT", "CONTAINS", "CONTENT",
  "\"FUNCTION CONTENT-LENGTH\"", "\"FUNCTION CONTENT-OF\"", "CONTINUE",
  "CONTROL", "CONTROLS", "CONVERSION", "CONVERTING", "COPY",
  "\"COPY-SELECTION\"", "\"CORE-INDEX\"", "CORRESPONDING", "COUNT", "CRT",
  "\"CRT-UNDER\"", "CSIZE", "CURRENCY", "\"FUNCTION CURRENT-DATE\"",
  "CURSOR", "\"CURSOR-COL\"", "\"CURSOR-COLOR\"", "\"CURSOR-FRAME-WIDTH\"",
  "\"CURSOR-ROW\"", "\"CURSOR-X\"", "\"CURSOR-Y\"",
  "\"CUSTOM-PRINT-TEMPLATE\"", "CYCLE", "\"CYL-INDEX\"",
  "\"CYL-OVERFLOW\"", "DASHED", "DATA", "\"DATA-COLUMNS\"",
  "\"DATA-POINTER\"", "\"DATA-TYPES\"", "DATE", "\"DATE-COMPILED\"",
  "\"DATE-ENTRY\"", "\"DATE-MODIFIED\"", "\"DATE-WRITTEN\"", "DAY",
  "\"DAY-OF-WEEK\"", "DE", "DEBUGGING", "\"DECIMAL-POINT\"",
  "DECLARATIVES", "DEFAULT", "\"DEFAULT-BUTTON\"", "\"DEFAULT-FONT\"",
  "DELETE", "DELIMITED", "DELIMITER", "DEPENDING", "DESCENDING",
  "DESTINATION", "DESTROY", "DETAIL", "DISABLE", "DISC", "DISK", "DISP",
  "DISPLAY", "\"DISPLAY-1\"", "\"DISPLAY-COLUMNS\"", "\"DISPLAY-FORMAT\"",
  "\"FUNCTION DISPLAY-OF\"", "DIVIDE", "DIVIDERS", "\"DIVIDER-COLOR\"",
  "DIVISION", "DOTDASH", "DOTTED", "\"DRAG-COLOR\"", "\"DROP-DOWN\"",
  "\"DROP-LIST\"", "DOWN", "DUPLICATES", "DYNAMIC", "EBCDIC", "EC", "ECHO",
  "EGI", "\"level-number 88\"", "ENABLE", "ELEMENT", "ELSE", "EMI",
  "ENCRYPTION", "ENCODING", "END", "\"END-ACCEPT\"", "\"END-ADD\"",
  "\"END-CALL\"", "\"END-COMPUTE\"", "\"END-COLOR\"", "\"END-DELETE\"",
  "\"END-DISPLAY\"", "\"END-DIVIDE\"", "\"END-EVALUATE\"",
  "\"END FUNCTION\"", "\"END-IF\"", "\"END-JSON\"", "\"END-MODIFY\"",
  "\"END-MULTIPLY\"", "\"END-PERFORM\"", "\"END PROGRAM\"", "\"END-READ\"",
  "\"END-RECEIVE\"", "\"END-RETURN\"", "\"END-REWRITE\"", "\"END-SEARCH\"",
  "\"END-SEND\"", "\"END-START\"", "\"END-STRING\"", "\"END-SUBTRACT\"",
  "\"END-UNSTRING\"", "\"END-WRITE\"", "\"END-XML\"", "ENGRAVED",
  "\"ENSURE-VISIBLE\"", "ENTRY", "\"ENTRY-CONVENTION\"", "\"ENTRY-FIELD\"",
  "\"ENTRY-REASON\"", "ENVIRONMENT", "\"ENVIRONMENT-NAME\"",
  "\"ENVIRONMENT-VALUE\"", "EOL", "EOP", "EOS", "EQUAL", "ERASE", "ERROR",
  "ESCAPE", "\"ESCAPE-BUTTON\"", "ESI", "EVALUATE", "EVENT",
  "\"EVENT-LIST\"", "\"EVENT STATUS\"", "EVERY", "EXAMINE", "EXCEPTION",
  "\"EXCEPTION CONDITION\"", "\"EXCEPTION-VALUE\"", "EXPAND", "EXCLUSIVE",
  "EXHIBIT", "EXIT", "\"exponentiation operator\"", "EXTEND",
  "\"EXTENDED-SEARCH\"", "EXTERNAL", "\"EXTERNAL-FORM\"", "F", "FACTORY",
  "FD", "\"FH--FCD\"", "\"FH--KEYDEF\"", "\"FILE-CONTROL\"", "\"FILE-ID\"",
  "\"FILE-LIMIT\"", "\"FILE-LIMITS\"", "\"FILE-NAME\"", "\"FILE-POS\"",
  "\"FILL-COLOR\"", "\"FILL-COLOR2\"", "\"FILL-PERCENT\"", "FILLER",
  "FINAL", "\"FINISH-REASON\"", "FIRST", "FIXED", "\"FIXED-FONT\"",
  "\"FIXED-WIDTH\"", "FLAT", "\"FLAT-BUTTONS\"", "\"FLOAT-BINARY-128\"",
  "\"FLOAT-BINARY-32\"", "\"FLOAT-BINARY-64\"", "\"FLOAT-DECIMAL-16\"",
  "\"FLOAT-DECIMAL-34\"", "\"FLOAT-DECIMAL-7\"", "\"FLOAT-EXTENDED\"",
  "\"FLOAT-LONG\"", "\"FLOAT-SHORT\"", "FLOATING", "FONT", "FOOTING",
  "FOR", "\"FOREGROUND-COLOR\"", "FOREVER", "FORMAT",
  "\"FUNCTION FORMATTED-DATE\"", "\"FUNCTION FORMATTED-DATETIME\"",
  "\"FUNCTION FORMATTED-TIME\"", "FRAME", "FRAMED", "FREE", "FROM",
  "\"FROM CRT\"", "FULL", "\"FULL-HEIGHT\"", "FUNCTION", "\"FUNCTION-ID\"",
  "\"intrinsic function name\"", "\"FUNCTION-POINTER\"", "GENERATE",
  "GIVING", "GLOBAL", "GO", "\"GO-BACK\"", "\"GO-FORWARD\"", "\"GO-HOME\"",
  "\"GO-SEARCH\"", "GOBACK", "GRAPHICAL", "GREATER",
  "\"GREATER OR EQUAL\"", "GRID", "GROUP", "\"GROUP-VALUE\"", "HANDLE",
  "\"HAS-CHILDREN\"", "HEADING", "\"HEADING-COLOR\"",
  "\"HEADING-DIVIDER-COLOR\"", "\"HEADING-FONT\"", "HEAVY",
  "\"HEIGHT-IN-CELLS\"", "\"HIDDEN-DATA\"", "HIGHLIGHT", "\"HIGH-COLOR\"",
  "\"HIGH-VALUE\"", "\"HOT-TRACK\"", "HSCROLL", "\"HSCROLL-POS\"", "ICON",
  "ID", "IDENTIFIED", "IDENTIFICATION", "IF", "IGNORE", "IGNORING", "IN",
  "INDEPENDENT", "INDEX", "INDEXED", "INDICATE", "INITIALIZE",
  "INITIALIZED", "INITIATE", "INPUT", "\"INPUT-OUTPUT\"", "INQUIRE",
  "\"INSERTION-INDEX\"", "\"INSERT-ROWS\"", "INSPECT", "INSTALLATION",
  "INTERMEDIATE", "INTO", "INTRINSIC", "INVALID", "\"INVALID KEY\"", "IS",
  "ITEM", "\"ITEM-TEXT\"", "\"ITEM-TO_ADD\"", "\"ITEM-TO_DELETE\"",
  "\"ITEM-TO_EMPTY\"", "\"ITEM-VALUE\"", "\"I-O\"", "\"I-O-CONTROL\"",
  "JSON", "JUSTIFIED", "KEPT", "KEY", "KEYBOARD", "LABEL",
  "\"LABEL-OFFSET\"", "\"LARGE-FONT\"", "\"LARGE-OFFSET\"", "LAST",
  "\"LAST-ROW\"", "\"LAYOUT-DATA\"", "\"LAYOUT-MANAGER\"", "LEADING",
  "\"LEADING-SHIFT\"", "LEAVE", "LEFT", "LEFTLINE", "\"LEFT-TEXT\"",
  "LENGTH", "\"LENGTH OF\"", "\"FUNCTION LENGTH/BYTE-LENGTH\"", "LESS",
  "\"LESS OR EQUAL\"", "\"level-number\"", "LIKE", "LIMIT", "LIMITS",
  "LINAGE", "\"LINAGE-COUNTER\"", "LINE", "\"LINE-COUNTER\"",
  "\"LINE LIMIT\"", "\"LINE-SEQUENTIAL\"", "LINES", "\"LINES-AT-ROOT\"",
  "LINKAGE", "\"LIST-BOX\"", "\"Literal\"", "\"LM-RESIZE\"", "LOC",
  "LOCALE", "\"FUNCTION LOCALE-DATE\"", "\"FUNCTION LOCALE-TIME\"",
  "\"FUNCTION LOCALE-TIME-FROM-SECONDS\"", "\"LOCAL-STORAGE\"", "LOCK",
  "\"LOCK-HOLDING\"", "\"LONG-DATE\"", "LOWER", "LOWERED",
  "\"FUNCTION LOWER-CASE\"", "LOWLIGHT", "\"LOW-COLOR\"", "\"LOW-VALUE\"",
  "\"MAGNETIC-TAPE\"", "MANUAL", "\"MASS-UPDATE\"", "\"MASTER-INDEX\"",
  "\"MAX-LINES\"", "\"MAX-PROGRESS\"", "\"MAX-TEXT\"", "\"MAX-VAL\"",
  "MEMORY", "\"MEDIUM-FONT\"", "MENU", "MERGE", "MESSAGE",
  "\"MICROSECOND-TIME\"", "MINUS", "\"MIN-VAL\"", "\"Mnemonic name\"",
  "MODE", "MODIFY", "MODULES", "MOVE", "MULTILINE", "MULTIPLE", "MULTIPLY",
  "NAME", "NAMED", "NAMESPACE", "\"NAMESPACE-PREFIX\"", "NATIONAL",
  "\"NATIONAL-EDITED\"", "\"FUNCTION NATIONAL-OF\"", "NATIVE",
  "\"NAVIGATE-URL\"", "\"NEAREST-AWAY-FROM-ZERO\"", "\"NEAREST-EVEN\"",
  "\"NEAREST-TOWARD-ZERO\"", "NEGATIVE", "NESTED", "NEW", "NEXT",
  "\"NEXT-ITEM\"", "\"NEXT GROUP\"", "\"NEXT PAGE\"", "NO",
  "\"NO ADVANCING\"", "\"NO-AUTOSEL\"", "\"NO-AUTO-DEFAULT\"",
  "\"NO-BOX\"", "\"NO DATA\"", "\"NO-DIVIDERS\"", "\"NO-ECHO\"",
  "\"NO-F4\"", "\"NO-FOCUS\"", "\"NO-GROUP-TAB\"", "\"NO-KEY-LETTER\"",
  "\"NO-SEARCH\"", "\"NO-UPDOWN\"", "NOMINAL", "NONE", "NONNUMERIC",
  "NORMAL", "NOT", "NOTAB", "NOTHING", "NOTIFY", "\"NOTIFY-CHANGE\"",
  "\"NOTIFY-DBLCLICK\"", "\"NOTIFY-SELCHANGE\"", "\"NOT AT END\"",
  "\"NOT AT EOP\"", "\"NOT ON ESCAPE\"", "\"NOT EQUAL\"",
  "\"NOT ON EXCEPTION\"", "\"NOT INVALID KEY\"", "\"NOT ON OVERFLOW\"",
  "\"NOT SIZE ERROR\"", "\"NUM-COL-HEADINGS\"", "\"NUM-ROWS\"", "NUMBER",
  "NUMBERS", "NUMERIC", "\"NUMERIC-EDITED\"", "\"FUNCTION NUMVAL-C\"",
  "OBJECT", "\"OBJECT-COMPUTER\"", "OCCURS", "OF", "OFF", "\"OK-BUTTON\"",
  "OMITTED", "ON", "ONLY", "\"ON ESCAPE\"", "\"ON EXCEPTION\"", "OPEN",
  "OPTIONAL", "OPTIONS", "OR", "ORDER", "ORGANIZATION", "OTHER", "OTHERS",
  "OUTPUT", "\"OVERLAP-LEFT\"", "\"OVERLAP-TOP\"", "OVERLINE",
  "\"PACKED-DECIMAL\"", "PADDING", "PASCAL", "PAGE", "\"PAGE-COUNTER\"",
  "\"PAGE-SETUP\"", "PAGED", "PARAGRAPH", "PARENT", "PARSE", "PASSWORD",
  "PERFORM", "PERMANENT", "PH", "PF", "PHYSICAL", "PICTURE",
  "\"PICTURE SYMBOL\"", "PIXEL", "PLACEMENT", "PLUS", "POINTER",
  "\"POP-UP\"", "POS", "POSITION", "\"POSITION-SHIFT\"", "POSITIVE",
  "PRESENT", "PREVIOUS", "PRINT", "\"PRINT-CONTROL\"",
  "\"PRINT-NO-PROMPT\"", "\"PRINT-PREVIEW\"", "PRINTER", "\"PRINTER-1\"",
  "PRINTING", "PRIORITY", "PROCEDURE", "PROCEDURES", "PROCEED",
  "PROCESSING", "PROGRAM", "\"PROGRAM-ID\"", "\"program name\"",
  "\"PROGRAM-POINTER\"", "PROGRESS", "PROHIBITED", "PROMPT", "PROPERTIES",
  "PROPERTY", "PROTECTED", "PROTOTYPE", "PURGE", "\"PUSH-BUTTON\"",
  "\"QUERY-INDEX\"", "QUEUE", "QUOTE", "\"RADIO-BUTTON\"", "RAISE",
  "RAISED", "RAISING", "RANDOM", "RD", "READ", "READERS", "\"READ-ONLY\"",
  "\"READY TRACE\"", "RECEIVE", "RECEIVED", "RECORD", "\"RECORD-DATA\"",
  "\"RECORD-OVERFLOW\"", "\"RECORD-TO-ADD\"", "\"RECORD-TO-DELETE\"",
  "RECORDING", "RECORDS", "RECURSIVE", "REDEFINES", "REEL", "REFERENCE",
  "REFERENCES", "REFRESH", "\"REGION-COLOR\"", "RELATION", "RELATIVE",
  "RELEASE", "REMAINDER", "REMARKS", "REMOVAL", "RENAMES",
  "\"REORG-CRITERIA\"", "REPEATED", "REPLACE", "REPLACING", "REPORT",
  "REPORTING", "REPORTS", "REPOSITORY", "REQUIRED", "REREAD", "RERUN",
  "RESERVE", "RESET", "\"RESET TRACE\"", "\"RESET-GRID\"",
  "\"RESET-LIST\"", "\"RESET-TABS\"", "RETRY", "RETURN", "RETURNING",
  "REVERSE", "\"FUNCTION REVERSE\"", "\"REVERSE-VIDEO\"", "REVERSED",
  "REWIND", "REWRITE", "RF", "RH", "RIGHT", "\"RIGHT-ALIGN\"", "RIMMED",
  "ROLLBACK", "ROUNDED", "ROUNDING", "\"ROW-COLOR\"",
  "\"ROW-COLOR-PATTERN\"", "\"ROW-DIVIDERS\"", "\"ROW-FONT\"",
  "\"ROW-HEADINGS\"", "\"ROW-PROTECTION\"", "RUN", "S", "SAME",
  "\"SAVE-AS\"", "\"SAVE-AS-NO-PROMPT\"", "SCREEN", "\"SCREEN CONTROL\"",
  "SCROLL", "\"SCROLL-BAR\"", "SD", "SEARCH", "\"SEARCH-OPTIONS\"",
  "\"SEARCH-TEXT\"", "SECONDS", "SECTION", "SECURE", "SECURITY", "SEGMENT",
  "\"SEGMENT-LIMIT\"", "SELECT", "\"SELECTION-INDEX\"",
  "\"SELECTION-TEXT\"", "\"SELECTION-ALL\"", "\"SELF-ACT\"",
  "\"semi-colon\"", "SEND", "SENTENCE", "SEPARATE", "SEPARATION",
  "SEQUENCE", "SEQUENTIAL", "SET", "\"level-number 78\"", "SHADING",
  "SHADOW", "SHARING", "\"SHORT-DATE\"", "\"SHOW-LINES\"", "\"SHOW-NONE\"",
  "\"SHOW-SEL-ALWAYS\"", "SIGN", "SIGNED", "\"SIGNED-INT\"",
  "\"SIGNED-LONG\"", "\"SIGNED-SHORT\"", "\"level-number 66\"", "SIZE",
  "\"SIZE ERROR\"", "\"SMALL-FONT\"", "SORT", "\"SORT-MERGE\"",
  "\"SORT-ORDER\"", "SOURCE", "\"SOURCE-COMPUTER\"", "SPACE",
  "\"SPECIAL-NAMES\"", "SPINNER", "SQUARE", "STANDARD", "\"STANDARD-1\"",
  "\"STANDARD-2\"", "\"STANDARD-BINARY\"", "\"STANDARD-DECIMAL\"", "START",
  "\"START-X\"", "\"START-Y\"", "STATIC", "\"STATIC-LIST\"", "STATUS",
  "\"STATUS-BAR\"", "\"STATUS-TEXT\"", "STDCALL", "STEP", "STOP", "STRING",
  "STRONG", "STYLE", "\"SUB-QUEUE-1\"", "\"SUB-QUEUE-2\"",
  "\"SUB-QUEUE-3\"", "\"FUNCTION SUBSTITUTE\"",
  "\"FUNCTION SUBSTITUTE-CASE\"", "SUBTRACT", "SUBWINDOW", "SUM",
  "SUPPRESS", "\"SUPPRESS\"", "SYMBOLIC", "SYNCHRONIZED",
  "\"SYSTEM-DEFAULT\"", "\"SYSTEM-INFO\"", "\"SYSTEM-OFFSET\"", "TAB",
  "\"TAB-TO-ADD\"", "\"TAB-TO-DELETE\"", "TABLE", "TALLYING", "TEMPORARY",
  "TAPE", "TERMINAL", "TERMINATE", "\"TERMINAL-INFO\"",
  "\"TERMINATION-VALUE\"", "TEST", "TEXT", "THAN", "THEN", "THREAD",
  "THREADS", "THRU", "\"THUMB-POSITION\"", "\"TILED-HEADINGS\"", "TIME",
  "\"TIME-OUT\"", "TIMES", "TITLE", "\"TITLE-POSITION\"", "TO", "\"&\"",
  "\")\"", "\":\"", "\"/\"", "\".\"", "\"=\"", "\"EXTERN\"", "\"FALSE\"",
  "\"FILE\"", "\">\"", "\"INITIAL\"", "\"<\"", "\"-\"", "\"*\"",
  "\"NULL\"", "\"OVERFLOW\"", "\"(\"", "\"+\"", "\"TRUE\"", "TOP",
  "\"TOWARD-GREATER\"", "\"TOWARD-LESSER\"", "TRACK", "TRACKS",
  "\"TRACK-AREA\"", "\"TRACK-LIMIT\"", "\"TRADITIONAL-FONT\"", "TRAILING",
  "\"TRAILING-SHIFT\"", "TRANSFORM", "TRANSPARENT", "\"TREE-VIEW\"",
  "\"FUNCTION TRIM\"", "TRUNCATION", "TYPE", "TYPEDEF", "U", "\"UCS-4\"",
  "UNBOUNDED", "UNDERLINE", "UNFRAMED", "UNIT", "UNLOCK", "UNSIGNED",
  "\"UNSIGNED-INT\"", "\"UNSIGNED-LONG\"", "\"UNSIGNED-SHORT\"",
  "UNSORTED", "UNSTRING", "UNTIL", "UP", "UPDATE", "UPDATERS", "UPON",
  "\"UPON ARGUMENT-NUMBER\"", "\"UPON COMMAND-LINE\"",
  "\"UPON ENVIRONMENT-NAME\"", "\"UPON ENVIRONMENT-VALUE\"", "UPPER",
  "\"FUNCTION UPPER-CASE\"", "USAGE", "USE", "\"USE-ALT\"",
  "\"USE-RETURN\"", "\"USE-TAB\"", "USER", "\"USER-DEFAULT\"",
  "\"user function name\"", "USING", "\"UTF-8\"", "\"UTF-16\"", "V",
  "VALID", "VALIDATE", "\"VAL-STATUS\"", "\"VALIDATE-STATUS\"",
  "VALIDATING", "VALUE", "\"VALUE-FORMAT\"", "VALUES", "VARIABLE",
  "VARIANT", "VARYING", "VERTICAL", "\"VERY-HEAVY\"", "\"VIRTUAL-WIDTH\"",
  "VOLATILE", "VPADDING", "VSCROLL", "\"VSCROLL-BAR\"", "\"VSCROLL-POS\"",
  "VTOP", "WAIT", "\"WEB-BROWSER\"", "WHEN", "\"FUNCTION WHEN-COMPILED\"",
  "\"WHEN\"", "WIDTH", "\"WIDTH-IN-CELLS\"", "WINAPI", "WINDOW", "WITH",
  "\"Identifier\"", "WORDS", "\"WORKING-STORAGE\"", "WRAP", "WRITE",
  "\"WRITE-ONLY\"", "\"WRITE-VERIFY\"", "WRITERS", "X", "XML",
  "\"XML-DECLARATION\"", "\"XML-SCHEMA\"", "Y", "YYYYDDD", "YYYYMMDD",
  "ZERO", "\"level-number (Area A)\"", "\"Identifier (Area A)\"",
  "SHIFT_PREFER", "$accept", "start", "$@1", "compilation_group",
  "nested_list", "$@2", "source_element_list", "source_element",
  "simple_prog", "$@3", "program_definition", "function_definition",
  "_end_program_list", "end_program_list", "end_program", "$@4",
  "end_function", "$@5", "program_prototype", "$@6", "$@7",
  "function_prototype", "$@8", "$@9",
  "_prototype_procedure_division_header", "$@10", "control",
  "_control_division", "$@11", "_default_section", "$@12",
  "_default_clauses", "_default_accept_clause", "$@13",
  "_default_display_clause", "$@14", "_program_body", "$@15", "$@16",
  "_identification_header", "identification_header", "$@17",
  "identification_or_id", "program_id_header", "program_id_paragraph",
  "function_id_header", "function_id_paragraph", "program_id_name",
  "end_program_name", "_as_literal", "_program_type",
  "program_type_clause", "init_or_recurse_and_common", "init_or_recurse",
  "_options_paragraph", "_options_clauses", "_arithmetic_clause",
  "arithmetic_choice", "_default_rounded_clause",
  "_entry_convention_clause", "convention_type",
  "_intermediate_rounding_clause", "intermediate_rounding_choice",
  "_environment_division", "_environment_header", "environment",
  "environment_header", "_configuration_section", "_configuration_header",
  "configuration", "configuration_header", "_configuration_paragraphs",
  "configuration_paragraphs", "configuration_paragraph",
  "_source_computer_paragraph", "source_computer_paragraph", "$@18",
  "_source_computer_entry", "_with_debugging_mode",
  "object_computer_paragraph", "$@19", "_object_computer_entry",
  "object_clauses_list", "object_clauses", "object_computer_memory",
  "object_computer_sequence", "program_collating_sequence", "$@20",
  "program_coll_sequence_values", "object_computer_segment",
  "object_computer_class", "locale_class", "computer_words",
  "_repository_paragraph", "repository_paragraph", "$@21",
  "_repository_entry", "repository_list", "repository_name",
  "repository_name_list", "special_names_header", "special_names_sentence",
  "special_name_list", "special_name", "mnemonic_name_clause", "$@22",
  "word_or_terminal", "mnemonic_choices", "_special_name_mnemonic_on_off",
  "on_off_clauses", "on_off_clauses_1", "alphabet_name_clause", "@23",
  "alphabet_definition", "@24", "@25", "alphabet_target_alphanumeric",
  "alphabet_target_national", "alphabet_type_alphanumeric",
  "alphabet_type_national", "alphabet_type_common",
  "alphabet_literal_list", "alphabet_literal", "@26",
  "alphabet_also_sequence", "alphabet_lits", "space_or_zero",
  "_alphnat_target", "_in_alphabet", "symbolic_characters_clause",
  "symbolic_collection", "symbolic_chars_list", "symbolic_chars_phrase",
  "char_list", "integer_list", "symbolic_constant_clause",
  "symbolic_constant_list", "symbolic_constant", "class_name_clause",
  "class_item_list", "class_item", "locale_clause", "xml_schema_clause",
  "@27", "schema_definition", "currency_sign_clause", "_with_pic_symbol",
  "decimal_point_clause", "numeric_sign_clause", "cursor_clause",
  "crt_status_clause", "screen_control", "event_status", "top_clause",
  "$@28", "_input_output_section", "input_output", "_input_output_header",
  "_file_control_header", "_file_control_sequence", "file_control_entry",
  "$@29", "$@30", "_select_clauses_or_error", "_select_clause_sequence",
  "select_clause", "assign_clause", "_assign_device_or_line_adv_file",
  "assign_device", "general_device_name", "line_seq_device_name",
  "line_adv_file", "_ext_clause", "ext_clause", "assignment_name",
  "access_mode_clause", "access_mode", "alternate_record_key_clause",
  "_password_clause", "password_clause", "$@31", "encryption_clause",
  "_suppress_clause", "collating_sequence_clause", "collating_sequence",
  "$@32", "coll_sequence_values", "collating_sequence_clause_key",
  "alphabet_name", "file_status_clause", "_file_or_sort",
  "lock_mode_clause", "$@33", "lock_mode", "_lock_with", "_with_rollback",
  "with_rollback", "_with_mass_update", "organization_clause",
  "organization", "padding_character_clause", "record_delimiter_clause",
  "$@34", "record_delimiter_option", "record_key_clause", "_split_keys",
  "source_is", "split_key_list", "$@35", "split_key",
  "relative_key_clause", "reserve_clause", "no_or_integer",
  "sharing_clause", "sharing_option", "file_limit_clause", "thru_list",
  "actual_key_clause", "nominal_key_clause", "track_area_clause",
  "track_limit_clause", "_i_o_control", "i_o_control_header",
  "_i_o_control_entries", "i_o_control_list", "i_o_control_clause",
  "same_clause", "_same_option", "apply_clause",
  "obsolete_dos_vs_apply_phrase", "multiple_file_tape_clause", "$@36",
  "multiple_file_list", "multiple_file", "_multiple_file_position",
  "rerun_clause", "_on_assignment", "rerun_event",
  "_prototype_environment_division", "_prototype_special_names_paragraph",
  "_prototype_special_names_sentence_list",
  "prototype_special_names_sentence_list", "prototype_special_name_list",
  "prototype_special_name", "_data_division", "$@37",
  "_data_division_header", "data", "data_division_header", "tok_file",
  "_file_section_header", "_file_description_sequence", "file_description",
  "file_description_entry", "$@38", "file_type",
  "_file_description_clause_sequence", "file_description_clause",
  "block_contains_clause", "_records_or_characters", "record_clause",
  "_record_depending", "_from_integer", "_to_integer",
  "label_records_clause", "value_of_clause", "file_id", "valueof_name",
  "data_records_clause", "linage_clause", "_linage_sequence",
  "linage_lines", "linage_footing", "linage_top", "linage_bottom",
  "recording_mode_clause", "recording_mode", "u_or_s", "code_set_clause",
  "_for_sub_records_clause", "report_clause", "report_keyword",
  "rep_name_list", "communication", "_communication_section", "$@39",
  "_communication_description_sequence", "communication_description", "cd",
  "communication_description_entry", "$@40",
  "_communication_description_clause_sequence",
  "communication_description_clause", "_input_cd_clauses",
  "named_input_cd_clauses", "named_input_cd_clause",
  "unnamed_input_cd_clauses", "_output_cd_clauses", "output_cd_clauses",
  "output_cd_clause", "_i_o_cd_clauses", "named_i_o_cd_clauses",
  "named_i_o_cd_clause", "unnamed_i_o_cd_clauses", "working_storage",
  "_working_storage_section", "$@41", "_record_description_list", "$@42",
  "record_description_list", "data_description", "$@43", "level_number",
  "_filler", "_entry_name", "user_entry_name", "_const_global",
  "lit_or_length", "con_source", "fp32_usage", "fp64_usage", "fp128_usage",
  "pointer_len", "renames_entry", "_renames_thru", "condition_name_entry",
  "$@44", "_user_entry_name", "constant_entry", "$@45", "constant_source",
  "constant_78_source", "constant_expression_list", "constant_expression",
  "_data_description_clause_sequence", "data_description_clause_sequence",
  "data_description_clause", "redefines_clause", "like_clause",
  "_length_modifier", "length_modifier", "same_as_clause",
  "typedef_clause", "_strong", "external_clause", "_as_extname",
  "_global_clause", "global_clause", "special_names_clause", "$@46",
  "special_names_target", "select_when_clause", "$@47", "when_choice",
  "format_clause", "format_choice", "volatile_clause", "picture_clause",
  "$@48", "_pic_locale_format_or_depending_on_or_byte_length",
  "_is_locale_name", "locale_name", "type_to_clause", "usage_clause",
  "usage_clause_screen_report", "_usage_is", "usage_screen_report",
  "usage", "_to_program_type", "_to_type_name", "conflict_usage",
  "_object_reference_type", "_factory_of", "_only", "double_usage",
  "long_double", "_font_name", "_layout_name", "sign_clause",
  "byte_length_clause", "report_occurs_clause", "report_occurs_step",
  "occurs_clause", "_occurs_from_integer", "_occurs_to_integer",
  "_occurs_integer_to", "_occurs_depending", "_capacity_in",
  "_occurs_initialized", "_occurs_keys_and_indexed", "$@49", "occurs_keys",
  "occurs_key_list", "occurs_key_field", "ascending_or_descending",
  "_occurs_indexed", "occurs_indexed", "occurs_index_list", "occurs_index",
  "justified_clause", "synchronized_clause", "_left_or_right",
  "blank_clause", "based_clause", "value_clause", "value_table_item_list",
  "value_table_item", "value_from_subscripts_is_are", "from_subscripts",
  "_to_subscripts", "from_to_subscripts", "_repeated_phrase",
  "repeated_phrase", "subscripts", "value_is_are", "value_item_list",
  "value_item", "value_clause_report", "value_clause_condition", "$@50",
  "value_item_list_in_alphabet", "value_item_condition_list",
  "value_item_condition", "_false_or_content_validation", "false_is",
  "content_validation", "valid_or_invalid", "_when_condition",
  "validate_status_clause", "when_error_choice", "_on_choice",
  "default_clause", "x_or_none", "class_clause", "class_option",
  "destination_clause", "present_when_clause", "invalid_when_clause",
  "any_length_clause", "external_form_clause", "identified_by_clause",
  "local_storage", "_local_storage_section", "$@51", "linkage",
  "_linkage_section", "$@52", "_report_section", "$@53", "$@54",
  "_report_description_sequence", "report_description", "$@55", "$@56",
  "_report_description_options", "report_description_option",
  "control_clause", "control_field_list", "control_final_tag",
  "control_identifier_list", "control_identifier", "page_limit_clause",
  "page_line_column", "page_limit_cols", "integer_or_zero_or_ident",
  "_page_heading_list", "page_detail", "heading_clause", "first_detail",
  "last_heading", "last_detail", "footing_clause",
  "_report_group_description_list", "report_group_description_entry",
  "$@57", "_report_group_options", "report_group_option", "type_is_clause",
  "type_option", "_control_heading_final", "_or_page",
  "_control_footing_final", "next_group_clause", "next_group_plus",
  "next_page", "sum_clause_list", "_reset_clause", "data_or_final",
  "present_when_condition", "present_absent", "_page_or_id", "page_or_ids",
  "data_varying_clause", "data_varying_list", "data_varying", "_var_from",
  "_var_by", "line_clause", "line_keyword_clause", "_line_clause_options",
  "line_clause_option", "column_clause", "col_keyword_clause",
  "_orientation", "_left_right_center", "col_or_plus",
  "column_integer_list", "column_integer", "source_clause",
  "group_indicate_clause", "_screen_section", "$@58", "$@59",
  "_screen_description_list", "screen_description_list",
  "screen_description", "$@60", "$@61", "$@62", "_screen_options",
  "screen_option", "screen_value_clause", "_value_is",
  "control_definition", "control_type_name", "control_type",
  "control_item", "_control_attributes", "control_attributes",
  "control_attribute", "control_style", "control_property",
  "control_style_name", "control_property_name",
  "control_style_name_generic", "control_property_name_generic",
  "control_style_name_label", "control_property_name_label",
  "control_style_name_entry_field", "control_property_name_entry_field",
  "control_style_name_push_button", "control_property_name_push_button",
  "control_style_name_check_box", "control_property_name_radio_button",
  "control_style_name_list_box", "control_property_name_list_box",
  "control_style_name_combo_box", "control_style_name_frame",
  "control_property_name_frame", "control_style_name_tab_control",
  "control_property_name_tab_control", "control_style_name_bar",
  "control_property_name_bar", "control_property_name_bitmap",
  "control_style_name_grid", "control_property_name_grid",
  "control_style_name_tree_view", "control_property_name_tree_view",
  "control_property_name_web_browser", "control_style_name_activex",
  "control_property_name_activex", "control_style_name_date_entry",
  "control_property_name_date_entry", "control_style_type",
  "control_property_type", "changeable_control_properties",
  "changeable_control_property", "changeable_window_properties",
  "changeable_window_property", "eol", "eos", "_plus", "plus",
  "plus_tokens", "minus", "minus_tokens", "control_size",
  "control_size_unit", "_cell", "screen_line_number",
  "_screen_line_plus_minus", "screen_col_number", "_screen_col_plus_minus",
  "screen_occurs_clause", "screen_global_clause",
  "_prototype_data_division", "_procedure_division", "procedure_division",
  "$@63", "$@64", "$@65", "$@66", "$@67", "_procedure_using_chaining",
  "$@68", "$@69", "procedure_param_list", "procedure_param",
  "_procedure_type", "_size_optional", "using_size_clause",
  "size_is_integer", "_acu_size", "_procedure_optional",
  "_procedure_returning", "_procedure_declaratives", "$@70", "$@71",
  "$@72", "_procedure_list", "procedure", "$@73", "proc_name",
  "section_header", "$@74", "_use_statement", "paragraph_header",
  "invalid_statement", "_segment", "statement_list", "@75", "@76",
  "statements", "$@77", "statement", "$@78", "accept_statement", "$@79",
  "accept_body", "$@80", "$@81", "accp_identifier",
  "field_with_pos_specifier", "$@82", "_pos_specifier", "pos_specifier",
  "pos_specifier_value", "identifier_or_numeric_literal",
  "_accept_clauses", "accept_clauses", "accept_clause",
  "accept_from_screen_clauses", "accept_from_screen_clause",
  "lines_or_number", "at_line_column", "line_number", "column_number",
  "mode_is_block", "accp_attr", "_key_dest", "key_dest", "no_echo",
  "reverse_video", "update_default", "_end_accept", "add_statement",
  "$@83", "add_body", "_add_to", "_end_add", "allocate_statement", "$@84",
  "allocate_body", "_loc", "_allocate_returning", "alter_statement",
  "$@85", "alter_body", "alter_entry", "_proceed_to", "call_statement",
  "$@86", "call_body", "$@87", "_conv_linkage", "$@88",
  "conv_linkage_option", "_mnemonic_conv", "mnemonic_conv",
  "program_or_prototype", "_id_or_lit_or_func_as", "nested_or_prototype",
  "call_using", "$@89", "call_param_list", "call_param", "_call_type",
  "call_returning", "return_give", "null_or_omitted",
  "call_exception_phrases", "_call_on_exception", "call_on_exception",
  "_call_not_on_exception", "call_not_on_exception", "_end_call",
  "cancel_statement", "$@90", "cancel_body", "cancel_list",
  "id_or_lit_or_program_name", "close_statement", "$@91", "close_body",
  "close_files", "_close_option", "close_window", "$@92",
  "_close_display_option", "compute_statement", "$@93", "compute_body",
  "_end_compute", "commit_statement", "continue_statement", "$@94",
  "_continue_after_phrase", "$@95", "destroy_statement", "$@96",
  "destroy_body", "delete_statement", "$@97", "delete_body",
  "delete_file_list", "_end_delete", "disable_statement", "$@98",
  "enable_disable_handling", "_enable_disable_key", "communication_mode",
  "display_statement", "$@99", "display_body", "screen_or_device_display",
  "display_list", "display_atom", "$@100", "disp_list",
  "_with_display_attr", "display_attrs", "display_clauses",
  "display_clause", "_display_upon", "display_upon", "crt_under",
  "display_erase", "$@101", "display_pos_specifier",
  "field_or_literal_or_erase_with_pos_specifier", "$@102",
  "field_or_literal_or_erase_list", "field_or_literal_or_erase",
  "display_message_box", "$@103", "_display_message_clauses",
  "display_message_clauses", "display_message_clause", "display_window",
  "$@104", "$@105", "sub_or_window", "display_floating_window", "$@106",
  "$@107", "display_initial_window", "$@108", "initial_type", "_graphical",
  "_upon_window_handle", "window_handle", "display_window_clauses",
  "display_window_clause", "shadow", "boxed", "_top_or_bottom",
  "_left_or_centered_or_right", "no_scroll_wrap", "pop_up_or_handle",
  "pop_up_area", "handle_is_in", "disp_attr", "_end_display",
  "divide_statement", "$@109", "divide_body", "_end_divide",
  "enable_statement", "$@110", "entry", "entry_statement", "$@111",
  "$@112", "entry_body", "entry_goto_body", "evaluate_statement", "$@113",
  "evaluate_body", "evaluate_subject_list", "evaluate_subject",
  "evaluate_condition_list", "evaluate_case_list", "evaluate_case",
  "evaluate_other", "evaluate_when_list", "$@114", "$@115",
  "evaluate_object_list", "evaluate_object", "_evaluate_thru_expr",
  "_end_evaluate", "exhibit_statement", "$@116", "exhibit_body", "$@117",
  "_changed", "_named", "_erase", "exhibit_target_list", "exhibit_target",
  "exit_statement", "$@118", "exit_body", "goback_exit_body",
  "free_statement", "$@119", "free_body", "generate_statement", "$@120",
  "generate_body", "goto_statement", "$@121", "go_body", "_goto_depending",
  "goback_statement", "$@122", "if_statement", "$@123",
  "if_else_statements", "_if_then", "if_true", "if_false", "_end_if",
  "initialize_statement", "$@124", "initialize_body", "_initialize_filler",
  "_initialize_value", "_initialize_replacing",
  "initialize_replacing_list", "initialize_replacing_item",
  "initialize_category", "_initialize_default", "initiate_statement",
  "$@125", "initiate_body", "inquire_statement", "$@126", "inquire_body",
  "inspect_statement", "$@127", "inspect_body", "_backward",
  "send_identifier", "inspect_format_variant", "examine_statement",
  "$@128", "examine_format_variant", "$@129", "examine_tallying_keyword",
  "examine_replacing_keyword", "_examine_tallying_replacing",
  "single_character_value", "inspect_tallying", "$@130",
  "inspect_replacing", "inspect_converting", "tallying_list",
  "tallying_item", "replacing_list", "replacing_item", "rep_keyword",
  "replacing_region", "inspect_region", "inspect_before", "inspect_after",
  "json", "json_generate_statement", "$@131", "json_generate_body",
  "$@132", "$@133", "_json_suppress", "json_suppress_list",
  "json_suppress_entry", "_end_json", "json_parse_statement", "$@134",
  "json_parse_body", "_with_detail", "merge_statement", "$@135",
  "modify_statement", "$@136", "modify_body", "_end_modify",
  "move_statement", "$@137", "move_body", "multiply_statement", "$@138",
  "multiply_body", "_end_multiply", "open_statement", "$@139", "open_body",
  "open_file_entry", "_open_exclusive", "open_mode", "_open_sharing",
  "_open_option", "lock_allowing", "open_lock_option", "allowing_option",
  "allowing_all", "open_option_sequential", "osvs_input_mode",
  "perform_statement", "$@140", "perform_body", "$@141", "$@142",
  "_end_perform", "end_perform_or_dot", "perform_procedure",
  "_perform_option", "perform_test", "cond_or_exit",
  "perform_varying_list", "perform_varying", "_by_phrase",
  "purge_statement", "$@143", "raise_statement", "$@144", "raise_body",
  "exception_name", "read_statement", "$@145", "read_body", "_read_into",
  "_lock_phrases", "ignoring_lock", "advancing_lock_or_retry",
  "_retry_phrase", "retry_phrase", "retry_options", "_extended_with_lock",
  "extended_with_lock", "_read_key", "read_handler", "_end_read",
  "ready_statement", "receive_statement", "$@146", "receive_body",
  "message_or_segment", "_data_sentence_phrases", "_no_data_sentence",
  "no_data_sentence", "_with_data_sentence", "with_data_sentence",
  "_end_receive", "release_statement", "$@147", "release_body",
  "reset_statement", "return_statement", "$@148", "return_body",
  "_end_return", "rewrite_statement", "$@149", "rewrite_body",
  "_with_lock", "with_lock", "_end_rewrite", "rollback_statement",
  "search", "search_statement", "$@150", "$@151", "search_body",
  "search_all_body", "_search_varying", "_search_at_end", "end_pos_token",
  "search_whens", "search_when", "_end_search", "end_search_pos_token",
  "send_statement", "$@152", "send_body", "send_body_mcs",
  "message_tag_data_item", "_from_identifier", "from_identifier",
  "send_body_cd", "with_indicator", "_replacing_line", "set_statement",
  "$@153", "set_body", "on_or_off", "up_or_down", "set_environment",
  "set_attr", "set_attr_clause", "set_attr_one", "set_to", "set_up_down",
  "set_to_on_off_sequence", "set_to_on_off", "set_to_true_false_sequence",
  "set_to_true_false", "set_last_exception_to_off", "set_thread_priority",
  "sort_statement", "$@154", "sort_body", "@155", "_sort_key_list",
  "_key_sort_list", "_sort_duplicates", "_sort_collating", "sort_input",
  "sort_output", "start_statement", "$@156", "start_body",
  "_sizelen_clause", "_start_key", "start_op", "not_equal_op",
  "_end_start", "stop", "stop_statement", "$@157", "stop_returning",
  "_status_x", "stop_argument", "stop_literal", "string_statement",
  "$@158", "string_body", "string_items", "$@159", "string_item_list",
  "string_item", "_string_delimited", "string_delimiter", "_with_pointer",
  "_end_string", "subtract_statement", "$@160", "subtract_body",
  "_end_subtract", "suppress_statement", "$@161", "_printing",
  "terminate_statement", "$@162", "terminate_body", "transform_statement",
  "$@163", "transform_body", "unlock_statement", "$@164", "unlock_body",
  "unstring_statement", "$@165", "unstring_body", "_unstring_delimited",
  "unstring_delimited_list", "unstring_delimited_item", "unstring_into",
  "unstring_into_item", "_unstring_into_delimiter", "_unstring_tallying",
  "_end_unstring", "validate_statement", "$@166", "validate_fields",
  "use_statement", "$@167", "use_phrase", "use_file_exception",
  "_use_global", "use_file_exception_target", "use_for_debugging",
  "debugging_list", "debugging_target", "_all_refs", "use_at_start_end",
  "program_start_end", "use_before_reporting", "use_after_exception",
  "use_exception_list", "use_exception", "use_ex_keyw", "write_statement",
  "$@168", "write_body", "from_option", "write_option", "before_or_after",
  "write_handler", "_end_write", "xml", "xml_generate_statement", "$@169",
  "xml_generate_body", "$@170", "$@171",
  "_with_encoding_xml_dec_and_attrs", "with_encoding_xml_dec_and_attrs",
  "with_encoding_xml_dec_and_attr", "encoding_xml_dec_and_attr",
  "_xml_gen_namespace", "_xml_gen_namespace_prefix", "_xml_name_of",
  "identifier_name_list", "identifier_is_name", "_json_name_of",
  "json_identifier_name_list", "json_identifier_is_name", "_type_of",
  "identifier_type_list", "identifier_is_type", "_xml_type", "ml_type",
  "_xml_gen_suppress", "xml_suppress_list", "xml_suppress_entry",
  "xml_suppress_generic_opt", "xml_suppress_when_list", "_end_xml",
  "xml_parse_statement", "$@172", "xml_parse_body", "$@173",
  "_with_encoding", "_returning_national", "_validating_with",
  "schema_file_or_record_name", "_accept_exception_phrases",
  "_accp_on_exception", "accp_on_exception", "escape_or_exception",
  "_accp_not_on_exception", "accp_not_on_exception",
  "not_escape_or_not_exception", "_common_exception_phrases",
  "_common_on_exception", "common_on_exception",
  "_common_not_on_exception", "common_not_on_exception",
  "on_size_error_phrases", "_on_size_error", "on_size_error",
  "_not_on_size_error", "not_on_size_error", "_on_overflow_phrases",
  "_on_overflow", "on_overflow", "_not_on_overflow", "not_on_overflow",
  "return_at_end", "read_at_end", "_at_end_clause", "at_end_clause",
  "_not_at_end_clause", "not_at_end_clause", "at_eop_clauses",
  "_at_eop_clause", "at_eop_clause", "_not_at_eop_clause",
  "not_at_eop_clause", "_invalid_key_phrases", "invalid_key_phrases",
  "_invalid_key_sentence", "invalid_key_sentence",
  "_not_invalid_key_sentence", "not_invalid_key_sentence", "_thread_start",
  "_thread_handle", "thread_reference_optional", "_scroll_lines",
  "_count_in", "condition", "expr", "partial_expr", "$@174", "expr_tokens",
  "expr_token", "condition_no_is", "expr_no_is", "partial_expr_no_is",
  "$@175", "expr_tokens_no_is", "expr_token_no_is", "_not_expr",
  "not_expr", "condition_or_class", "eq", "gt", "lt", "ge", "le",
  "exp_list", "_e_sep", "exp", "exp_term", "exp_factor", "exp_unary",
  "exp_atom", "line_linage_page_counter", "arithmetic_x_list",
  "arithmetic_x", "record_name", "file_or_record_name", "table_name",
  "file_name_list", "file_file_name_list", "file_name", "cd_name",
  "report_name", "mnemonic_name_list", "mnemonic_name", "entry_name_list",
  "entry_name", "procedure_name_list", "procedure_name", "label",
  "integer_label", "reference_list", "reference", "_reference",
  "single_reference_list", "single_reference", "optional_reference_list",
  "optional_reference", "reference_or_literal", "undefined_word",
  "undefined_word_but_no_error", "unique_word", "target_x_list",
  "target_x", "_x_list", "x_list", "x", "call_x", "x_common",
  "length_of_register", "report_x_list", "expr_x", "arith_x",
  "arith_nonzero_x", "numeric_literal", "non_numeric_literal",
  "nonzero_numeric_literal", "prog_or_entry", "alnum_or_id",
  "simple_display_value", "inspect_from", "inspect_to", "simple_value",
  "simple_all_value", "id_or_lit", "id_or_lit_or_func",
  "id_or_lit_or_length_or_func", "num_id_or_lit", "positive_id_or_lit",
  "pos_num_id_or_lit_or_zero", "pos_num_id_or_lit", "from_parameter",
  "sub_identifier", "table_identifier", "sub_identifier_1",
  "display_identifier", "numeric_identifier", "identifier_or_file_name",
  "identifier_field", "type_name", "identifier", "identifier_1",
  "identifier_list", "validate_for_identifier_list", "for_identifier",
  "target_identifier", "target_identifier_1", "target_identifier_single",
  "display_identifier_or_alphabet_name", "qualified_word",
  "unqualified_word", "$@176", "unqualified_word_check", "subref",
  "refmod", "integer", "symbolic_integer", "unsigned_pos_integer",
  "integer_or_zero", "class_value", "figurative_constant", "literal",
  "basic_literal", "basic_value", "zero_spaces_high_low_values",
  "function", "func_no_parm", "func_one_parm", "func_multi_parm",
  "func_refmod", "func_args", "trim_args", "length_arg", "$@177",
  "numvalc_args", "locale_dt_args", "formatted_datetime_args",
  "formatted_time_args", "not_const_word", "flag_all", "flag_duplicates",
  "_flag_initialized", "_flag_initialized_to", "_to_init_val",
  "_flag_next", "_flag_not", "flag_optional", "flag_rounded", "round_mode",
  "round_choice", "flag_separate", "_from_idx_to_idx", "_dest_index",
  "error_stmt_recover", "verb", "scope_terminator", "_dot",
  "_dot_or_else_end_of_file_control", "level_number_in_area_a",
  "_dot_or_else_end_of_file_description",
  "_dot_or_else_end_of_communication_description",
  "_dot_or_else_end_of_report_description",
  "_dot_or_else_end_of_report_group_description",
  "_dot_or_else_end_of_record_description", "_file_control_end_delimiter",
  "_file_description_end_delimiter", "_record_description_end_delimiter",
  "_dot_or_else_area_a", "_advancing", "_after", "_are", "_area", "_areas",
  "_as", "_at", "_before", "_binary", "_box", "_by", "_character",
  "_characters", "_collating", "_contains", "_controls", "_control",
  "_data", "_end_of", "_every", "_file", "_for", "_from", "_in",
  "_in_equal", "_in_order", "_index", "_indicate", "_initial", "_into",
  "_is", "_is_equal", "_is_are", "_is_are_equal", "_is_in", "_key",
  "_line", "_line_or_lines", "_limits", "_lines", "_lock", "_message",
  "_mode", "_new", "_number", "_number_or_numbers", "_of", "_on",
  "_on_for", "_onoff_status", "_other", "_others", "_procedure",
  "_program", "_protected", "_record", "_records", "_right", "_sign",
  "_signed", "_sign_is", "_size", "_standard", "_status", "_symbolic",
  "_tape", "_terminal", "_then", "_times", "_to", "_up", "_when",
  "_when_set_to", "_with", "_with_for", "_exception", "at_end",
  "on_escape", "on_exception", "column_or_col", "columns_or_cols",
  "column_or_cols", "column_or_col_or_position_or_pos", "comp_equal",
  "exception_or_error", "file_limit_or_limits", "in_of", "label_option",
  "line_or_lines", "lock_records", "object_char_or_word_or_modules",
  "records", "reel_or_unit", "size_or_length", "length_of",
  "track_or_tracks", "using_or_varying", "detail_keyword", "ch_keyword",
  "cf_keyword", "ph_keyword", "pf_keyword", "rh_keyword", "rf_keyword",
  "control_keyword", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_int16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     805,   806,   807,   808,   809,   810,   811,   812,   813,   814,
     815,   816,   817,   818,   819,   820,   821,   822,   823,   824,
     825,   826,   827,   828,   829,   830,   831,   832,   833,   834,
     835,   836,   837,   838,   839,   840,   841,   842,   843,   844,
     845,   846,   847,   848,   849,   850,   851,   852,   853,   854,
     855,   856,   857,   858,   859,   860,   861,   862,   863,   864,
     865,   866,   867,   868,   869,   870,   871,   872,   873,   874,
     875,   876,   877,   878,   879,   880,   881,   882,   883,   884,
     885,   886,   887,   888,   889,   890,   891,   892,   893,   894,
     895,   896,   897,   898,   899,   900,   901,   902,   903,   904,
     905,   906,   907,   908,   909,   910,   911,   912,   913,   914,
     915,   916,   917,   918,   919,   920,   921,   922,   923,   924,
     925,   926,   927,   928,   929,   930,   931,   932,   933,   934,
     935,   936,   937,   938,   939,   940,   941,   942,   943,   944,
     945,   946,   947,   948,   949,   950,   951,   952,   953,   954,
     955,   956,   957,   958,   959,   960,   961,   962,   963,   964,
     965,   966,   967,   968,   969,   970,   971,   972,   973,   974,
     975,   976,   977,   978,   979,   980,   981,   982,   983,   984,
     985,   986,   987,   988,   989,   990,   991,   992,   993,   994,
     995,   996,   997,   998,   999,  1000,  1001,  1002,  1003,  1004,
    1005,  1006,  1007,  1008,  1009,  1010,  1011,  1012,  1013,  1014,
    1015,  1016,  1017,  1018,  1019,  1020,  1021,  1022,  1023,  1024,
    1025,  1026,  1027,  1028,  1029,  1030,  1031,  1032,  1033,  1034,
    1035,  1036,  1037,  1038,  1039,  1040,  1041,  1042,  1043,  1044,
    1045,  1046,  1047,  1048,  1049,  1050,  1051,  1052,  1053,  1054,
    1055,  1056,  1057,  1058,  1059,  1060,  1061,  1062,  1063,  1064,
    1065,  1066,  1067,  1068,  1069,  1070,  1071,  1072,  1073,  1074,
    1075,  1076,  1077,  1078,  1079,  1080,  1081,  1082,  1083,  1084,
    1085,  1086,  1087,  1088,  1089,  1090,  1091,  1092,  1093,  1094,
    1095,  1096,  1097,  1098,  1099,  1100,  1101,  1102,  1103,  1104,
    1105,  1106,  1107,  1108,  1109,  1110,  1111,  1112,  1113,  1114,
    1115,  1116,  1117,  1118,  1119,  1120,  1121,  1122,  1123,  1124,
    1125,  1126,  1127,  1128,  1129,  1130,  1131,  1132,  1133,  1134,
    1135,  1136,  1137,  1138,  1139,  1140,  1141,  1142,  1143,  1144,
    1145,  1146,  1147,  1148,  1149,  1150,  1151,  1152,  1153,  1154,
    1155,  1156,  1157,  1158,  1159,  1160,  1161,  1162,  1163,  1164,
    1165,  1166,  1167,  1168,  1169,  1170,  1171,  1172,  1173,  1174,
    1175,  1176,  1177,  1178,  1179,  1180,  1181,  1182,  1183,  1184,
    1185,  1186,  1187,  1188,  1189,  1190,  1191,  1192,  1193,  1194,
    1195,  1196,  1197,  1198,  1199,  1200,  1201,  1202,  1203,  1204,
    1205,  1206,  1207,  1208,  1209,  1210,  1211,  1212,  1213,  1214,
    1215,  1216,  1217,  1218,  1219,  1220,  1221,  1222,  1223,  1224,
    1225,  1226,  1227
};
#endif

#define YYPACT_NINF (-3999)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-3466)

#define yytable_value_is_error(Yyn) \
  0

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const yytype_int16 yypact[] =
{
   -3999,   563,  1914, -3999, -3999, -3999,   447, -3999,   839, -3999,
    1256,  1732,   769, -3999,  1239,   786, -3999, -3999,  1383, -3999,
   -3999, -3999, -3999, -3999,  1053, -3999, -3999,  1562, -3999, -3999,
    1556,  1501, -3999, -3999, -3999, -3999, -3999, -3999,   959,   839,
    1032,   839,  1721,  1563, -3999,  1832,  1925, -3999,  1767,  3653,
    1460, -3999,   786,  2033,     4,  1960,     4,  2039,   786, -3999,
    1625,  1653,  2056, -3999, -3999,  1526,  2162, -3999, -3999, -3999,
    1680,  2143,   167,   167,  1633,  1713,  1563,  1563,  1563,   167,
    1725,   786,   786,  1563,   786,   786,  1386, -3999, -3999, -3999,
     167, -3999,  3653, -3999, -3999, -3999, -3999, -3999, -3999,   220,
   -3999, -3999, -3999, -3999, -3999,  2055, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,   786, -3999,
   -3999, -3999, -3999, -3999,  2418, -3999, -3999,  1960, -3999,  2418,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,  2065,  1563,
    2135,  1863, -3999,  1840, -3999,   786,   786,   786, -3999, -3999,
   -3999, -3999,  1331,  1563, -3999,  1563,  1648,  2480,  1648,  1563,
    1563, -3999, -3999,  1648, -3999, -3999, -3999,  1700,   -45,  1563,
   -3999, -3999, -3999, -3999, -3999,  1997,   210, -3999, -3999,  1897,
    2176,   856,    31, -3999,   893,    31, -3999,  1563,   115,  1985,
     786, -3999, -3999, -3999, -3999,   786,    79, -3999, -3999, -3999,
     -41,  1331, -3999,  1563,   300,  1648,  2206,    88, -3999, -3999,
   -3999, -3999,  2236,  1843,   266,    94, -3999,  1770, -3999,  1700,
   -3999,  1563,  1786,   167,   606, -3999, -3999, -3999, -3999, -3999,
    1327,   978,  1563,   166, -3999, -3999, -3999, -3999, -3999, -3999,
    1886, -3999,  1887,   583, -3999, -3999,   786, -3999,  2089,   786,
     789, -3999, -3999, -3999, -3999,  1563, -3999,  2517,  4846, 11993,
   -3999, -3999, -3999,  1802, -3999,   788,   173,   786, -3999, -3999,
   -3999,   232, -3999, -3999, -3999,   736,  1720, -3999, -3999, -3999,
    -208, -3999, -3999,  1648, -3999,  1999, -3999,  1984, -3999,  1563,
   -3999, -3999,   648, -3999, -3999, -3999, -3999, -3999,   737,  2644,
    2639,   163,  1824, -3999,   226, -3999, -3999,    46, -3999,   711,
   -3999,  1786, -3999,   146, -3999, -3999,  1852, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,  1930, -3999,
     978, -3999,  2349,   167,   167, -3999,  1327,   191, -3999,   841,
   -3999,   786, -3999, -3999,  2142, -3999,  2642, -3999,   786, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,  1438,
   -3999, -3999, 14341, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999,  2437, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999,   117, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
    2779, -3999, -3999, -3999, -3999, -3999,  1042, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999,  1193, -3999, -3999,
   -3999, -3999, -3999,  2050,  2645, -3999,    77,  1686, -3999, -3999,
   -3999,  1636,  2140, -3999,  2214,  1280, -3999,   980, -3999, -3999,
   -3999, -3999, -3999, -3999,  1563,  1563, -3999, -3999, -3999,  1553,
   -3999,  1967, -3999, -3999, -3999,  2182, -3999, -3999, -3999,  1563,
    2330, -3999, -3999, -3999, -3999,   770,  1563, -3999, -3999,  2051,
    2381, -3999,  2418,  1397,  2418,  1957, -3999, -3999,  1962,  2606,
   -3999, -3999, -3999, -3999, -3999,  2339, -3999,  1852,   167, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999,  2593, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999,   126, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,  -177,  8259,
   20091,   -91,   126,   158,  1567,  1705,  2811,  -337,   175,  1330,
    5755, 18331,  1330,  1568,  5136,  2705,  1913,  1705,  1648,  1977,
    1448,  9782,  1705,  1878,   236,  2764,  1648,   236, 15186, 18331,
    2073,  2519,   927,  1885,    -8,  1890,  1885,  1648,  1890,  1399,
     677,   744,  1648,  1890, -3999, 14466,  2199,  1878,  1648,  1890,
    6743,  1648,  1399,  2461,   126, -3999, -3999, -3999,  1648, -3999,
   -3999, -3999, -3999, -3999,  1648, -3999, -3999, -3999, -3999, -3999,
   -3999,  1978, -3999, -3999,   177,   907, -3999,  2099,  2363,  1700,
    1700,  1700,   892,   907,  6984, -3999, -3999, -3999,  -141, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,  2259, -3999,
     167,  2214,  1977,  1977,  2271,  2214,  2214,  1977,  2214,  2214,
    1977,  2214,  2214,  1996, -3999,  2549,   873, -3999, -3999, -3999,
    2826,   906, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
    2325,  1788, -3999, -3999,  1720,  2382,  2330, -3999, -3999,   884,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,  2347,
   -3999,  2339, -3999, -3999, -3999,  1563, -3999,  2009,  1239,  1239,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999,  1917, -3999, -3999,
    1356,  2607, -3999, 20264,  1998,  2359,  2502,  2271, -3999, -3999,
   -3999,  1648, -3999, -3999,  2004,  2005,  2006, -3999, -3999,  2010,
      88,    88,  2011,  2012,  2013, -3999, -3999,  2014,    88, -3999,
   -3999, -3999,  1648,  2015, -3999,  2006, -3999,  2616, -3999, 16699,
   -3999, -3999, 13122, -3999, -3999, -3999,  2017,  2018,  2021, -3999,
   21336, 21336, 20091, 21336, -3999,   110,   315, -3999,  2571, -3999,
   -3999, 13122, -3999, -3999,  2471,  2165,  1930, -3999, -3999,   -91,
   -3999,  2041, -3999,    88, -3999,  2634,   927, -3999, -3999, -3999,
   -3999,   880, -3999, -3999, -3999, -3999, -3999,  1890, -3999,  1517,
    2271,  2636, -3999,   754, -3999,  2171, -3999, -3999,  1978,  1930,
   -3999, -3999,  1890,  2635,  2229,  2725, -3999, -3999,  1648,  2071,
    2075, -3999, -3999, -3999,  1885, -3999,  2520, -3999,  1841,  2817,
   -3999, -3999, -3999, -3999, -3999,  2646,  1371, 17536, -3999, -3999,
   -3999, -3999,  1958,  1998, -3999, -3999, -3999, -3999, -3999,  2520,
   16979,  1846,  1860,  2736,  2647,  1308, -3999, -3999, -3999,  2649,
     164, -3999, -3999, -3999, 17472,  -193, -3999, -3999, -3999, -3999,
   -3999,  2395, -3999, -3999,  2722,  1448, -3999, -3999, -3999,  1705,
   -3999, -3999, -3999, -3999, -3999,  2630, -3999,    82, -3999, 18331,
   -3999, -3999,  2081, -3999, -3999,  1502, -3999,  1878, -3999, -3999,
    1648, 15865,  1267, -3999,  1273, -3999, -3999,  5136, -3999, -3999,
   -3999,  2054, 15082,  1267,  2661, 18331, -3999,  2084,  2665,  2843,
   -3999, -3999,  1981, -3999,  2008, -3999, -3999, 18589,  2101, -3999,
   -3999,  1989, -3999, -3999,  2668,  1257,  2670,   -42, -3999,  2576,
   -3999,  2671,  2229,  1994,  2683, -3999,  2576, 18331, -3999,  2687,
   -3999,  2595, 13122,  2655, -3999, -3999, -3999, -3999, -3999, -3999,
    2457, -3999,  1705, -3999, -3999, -3999,  2335,   -77, -3999,   944,
    2932, -3999,   199, -3999,  2696,  1697,  2697,  2556, 18331,  1648,
    1648,  2706, 17615, -3999, -3999,  1878, -3999, -3999,  2865, -3999,
   -3999,  1683, -3999,  2710,  2771, -3999, -3999,  1648, -3999,  2712,
    2576,  2148,  2521, -3999,  1648,  1648,  1648,  2720,  2070, -3999,
   12093, -3999, 20091,  2138, -3999,  1648,  1648, -3999,   203, -3999,
   -3999,  -174, -3999, -3999, -3999,  8171, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999,   786, -3999,  2260,
    2528, -3999, -3999, -3999,  2316,   907, -3999,  2154, -3999, -3999,
   -3999,  2844, -3999, -3999,  1685, -3999, -3999,  1648,  1648,  2330,
   -3999,  2330,  1890,  1890,  2330,  1890,  1890,  1648,  1890,  1890,
   -3999,  2185, -3999,  1348, -3999, -3999, -3999, -3999,  2659, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999,  1106, -3999,   206, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999,   188, -3999, -3999, -3999, -3999, -3999,
   -3999,  2068,   -53, -3999, -3999,  -346,  1563, -3999,  1556, -3999,
   -3999, -3999,    66, -3999, -3999, 20264,   821, -3999, -3999,  1563,
   -3999, 20264, -3999, -3999, -3999,  1449,  2168, 20955,    59,  1648,
   -3999,  2836,  3094,    15,  2172, 20091, 20091,  7247,  2017, -3999,
    2072,  2074, 20091, 20091, 20091, 13122,  2078,  2174, 13122,  2017,
   -3999, -3999, 18395,  2657, -3999, -3999,  1930, -3999, 20091, -3999,
   13122, 20091, -3999, -3999,  1748, -3999,  2618, 20091, 20091, 20091,
   20091, 20091, 20091, 20091, 20091, 20091, 20091, 20091, 20091, -3999,
    1930, -3999, -3999,  2544, -3999,  2396,  2561, -3999, -3999,  6743,
   -3999,  1648,  1517, -3999, -3999, -3999,  1668,    27,  1648, -3999,
   -3999, -3999, -3999, -3999, 20091,  2529, -3999,  2138, -3999, 20091,
     -26, -3999, -3999, -3999, -3999,  2334, -3999, -3999, -3999, -3999,
   -3999, -3999,  -113,  1958, -3999,  2098, -3999, 18331, -3999, -3999,
   -3999, -3999, -3999, -3999,  2481,  1207, -3999, -3999, -3999, 16979,
     380,  5173, -3999,  1717,  2147,  2107,  1371,  1371,  1371,  1371,
   17536, -3999, -3999, 18331, 18395, -3999, -3999,  1568, -3999, -3999,
    2114, -3999,    -2, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999,  -130, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, 16394, -3999, -3999, -3999,  1616,   200, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999,  2580,    34,  2750, -3999, -3999,
   -3999,  2808,  1355,  2727, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
     -19, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999,  2330, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999,   -19, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, 15865, -3999,   -19,   -19,   -19,  1267, -3999,    93,   249,
   20091, -3999, -3999,   853, 11406, -3999, -3999,   186, 19241,  1267,
   -3999, -3999,  2216,  1705, -3999, -3999, 18395, -3999, -3999, -3999,
   -3999, -3999,  2299,  2271, -3999,   731, -3999,  2678,  2678,  -352,
    2231,  2577,  2223, -3999,  1466, -3999, -3999,  2239, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999,  2229, -3999, -3999, -3999, -3999,
    2648,  5136, -3999, -3999, -3999,  2650, -3999, -3999, -3999,  2334,
    2595, -3999,  1648,  2119,   306,  2232, -3999, -3999,  1930, -3999,
    2233, -3999, -3999,  1547,  2234,  1327, -3999, -3999,  7339, -3999,
    2982,  1152,   224, -3999, -3999, -3999,  1563, -3999,   808, -3999,
   -3999,  1648, 18331, -3999,  2861,  2713,  2717, -3999, -3999, 18395,
   -3999,  2718, -3999, -3999, -3999, -3999, -3999,  2991,  2660, -3999,
   -3999, -3999,   511, -3999,  1917,  2820,  2723,  2820,  2663,  2720,
     434, -3999, -3999,  1648,   434, 18331, -3999, -3999,  1183,   172,
    1752, 20091, -3999,  2815,  2732,  2815,     5, -3999, -3999, -3999,
     170,   788, -3999,   786, -3999,  2355,  2408,  1621,  1512, -3999,
   -3999, -3999, 16209,  1512,  2938,  1563,  1844,  1844,  1563,    58,
    2065,  1563,  3076,  2526, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999,  2158, -3999,   253, 10364,  1648, -3999,
    2214,  2214,  1570,  1890, -3999,  1890,  2214,  1890,  1890,  2214,
    1890,  1890, -3999,  2938,  2271,  2271,  2442,  1890, -3999, -3999,
   -3999,  1106, -3999, -3999, -3999, -3999,    88, -3999, -3999,   739,
   -3999, -3999,  -346,  2336,  1925,  1925,   212, -3999, -3999,  2409,
    2043, -3999, -3999, -3999, -3999,  3035, -3999, -3999, -3999,  2551,
   -3999, -3999, -3999, -3999,  2551,   883, -3999,  1563, -3999, -3999,
   -3999, -3999, -3999,  1563, -3999, -3999,  1563, -3999,  1563, -3999,
   -3999, -3999, -3999, -3999,   168, -3999, -3999, -3999,    85, -3999,
   -3999, -3999, -3999, -3999, -3999,    36, -3999, -3999, -3999,  3110,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999,  2682,  2352,   925,
   -3999,  2978,  1794, -3999, -3999, -3999, -3999, -3999,  2043, -3999,
   -3999, -3999,  2166,  2169, -3999, 13122,  2043,  2689,  2331,  2337,
    2562, -3999, -3999, -3999, -3999, -3999, -3999,  2619, -3999, -3999,
   -3999, -3999, -3999, -3999,   926, -3999,  1648,   179,  1796,  2287,
     397,  2289, -3999,   439, -3999,   963, 13122, -3999, -3999,   392,
    2291,  2293,  2294,   443, -3999,  1930, -3999,  2297, -3999,  1648,
     446,  2298, -3999,  2271,  2774,   161, -3999,   -75,   346,  1705,
    1827,  2300,   464, -3999,  2303,  2544,   315,   315, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,  2330,  2443,
    2306,   -91, -3999, -3999,  1274,  3120,  -156, -3999, -3999,  2445,
    2472, -3999,   837,  1563, -3999, -3999,  1210, -3999, -3999,  2228,
      81, -3999, -3999, -3999,  2719, -3999, -3999, 18331, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999,   313, -3999, -3999, 12549, -3999,
   -3999,  5540,   853, -3999, -3999, -3999, -3999,   -33, -3999,  1563,
   -3999,    39,   853, -3999, -3999, -3999, -3999,    65,  1563, -3999,
   -3999, -3999,  5173, -3999, -3999,  1717, -3999, -3999,  1930,  1648,
   -3999, -3999, -3999, -3999, -3999, -3999,  1371,  2788,   161,  2791,
   -3999,  9108,  2572, -3999, -3999, -3999, -3999, -3999, -3999,  2203,
    1616, -3999, -3999, -3999, -3999, -3999,  1977, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,  2833,  1835,
     197,  1998, -3999,   235, -3999,  2214, -3999, -3999, -3999, -3999,
   -3999,  2905, -3999,  1977, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999,  2482,  1977, -3999, -3999, -3999,  1648, -3999, -3999,  1648,
   -3999,  1648,  1648,  1648, -3999,  1445,   217, -3999, -3999,  2483,
   -3999, -3999,   228,   444,  2931, -3999, -3999,   936, -3999, -3999,
   -3999, -3999, 17809, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999,  1705,  1705,   161,  2803,
    2119,  2334,  2577,  2768, 18732,   344,  9625,  1648,   -91,  2332,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,   511,
    2650,  1648, -3999, -3999, -3999, -3999,  1648,   310,  1174,  2478,
   -3999,   511,    17, 13122,  2612,  1622,   870, -3999,  2271,   926,
    2608, -3999, -3999, -3999, 18331,  1327,  1327,  1327,  1327,  1327,
    1327,  1327,  1327,  1152, -3999,   939,    81,   -31,   835, -3999,
    2991, -3999,  1648,  1648,   161,  2821,  1445, -3999,  3180,  1648,
     949, -3999, -3999,  2334,  3186,  2724,  2283, -3999, -3999,  1648,
   -3999,  1648, -3999, -3999, -3999,  2258, -3999, -3999, -3999,  2263,
   -3999,  2411,  2411, -3999, -3999, -3999, 20091, 18173,  1752, -3999,
   -3999,  1648, -3999,  2497,  2956,  2330, -3999, -3999, -3999, -3999,
     786, -3999,  2476,  1563,  3076,  4556, -3999,  2292, -3999,  2837,
    1648,    56, -3999,  2272,  1563,  1563,  1563,  1266,  2274,  2500,
    1648,  1344, -3999,  2277,  1648,  3187,  2281,  2795,   -14,  1977,
    1563,  1563,  1847,  1352,  2276, -3999, -3999, 19215, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, 14662, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
    4556, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999,  1408,   -59,   348,  2852, -3999,  2330,   210,   349,   349,
    2278,  1288,   965,  2330,  2301,  1563, -3999, -3999, -3999,    61,
   -3999,  2158, -3999, -3999, -3999,   906, -3999, 10255, -3999,  1890,
    1890, -3999, -3999,  2214, -3999,  1890,  1890,  1890,   800,  1890,
   -3999,  1890,  1106, -3999,  2068,  1563,  1563,  2279, -3999,  2447,
   -3999,  2528,  2596,  2596, -3999, -3999, -3999,  2759,   152,   152,
    -152, -3999, -3999, -3999, -3999, -3999, -3999,  2076,  1648,  1688,
   -3999, -3999, -3999, -3999, -3999,   821,   821, -3999, -3999, -3999,
   -3999,   821,   821,   883,   821, -3999, -3999, -3999,  1563,   936,
   -3999,   936, -3999,   883,  2768,  1563,  2386,  1092,  2762,  2762,
   -3999, -3999, -3999,  2043, -3999, -3999, -3999, -3999, -3999, -3999,
     196, -3999, -3999, -3999, -3999,  2171, 19581,  2017, 19733,  2017,
   -3999,  2389,  2017, -3999,  1648,  2017,  2017,  2017, 13122,  2017,
    2171,   920,  2017,    15, -3999, -3999, -3999,  2672,  2467,    -1,
    2872,   161, 19808,  2017,  2017,   916, -3999,  2443, -3999,  1705,
   -3999, -3999, -3999,  2678, -3999, -3999, -3999, -3999, -3999,  2711,
   -3999, -3999, -3999,   789, -3999, -3999, 20091, -3999, -3999, -3999,
   -3999,  2680,  2822,   989,  2147,   400, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999,   821, -3999, -3999,   821,
   -3999, -3999, -3999, -3999,     2,  2997,   821,   936,   936,   821,
   -3999, -3999, -3999,  3052,  3052, -3999,  1705, -3999,  1705, -3999,
   -3999, -3999, -3999,  3230, -3999,  2415,    63,  9108, -3999, -3999,
   -3999, -3999, -3999,  3162, -3999, -3999, -3999,  2919,  1835,  2960,
   -3999, -3999, -3999,  1648, -3999, -3999, -3999,  3008,  2340,  1987,
      41,  2341, -3999, -3999, -3999, -3999, -3999,  2413, -3999, -3999,
    1930, -3999,  3168, -3999, -3999, -3999,   218, -3999,  1445,  6463,
   -3999, -3999, -3999,  2503, -3999, -3999,  2689,  1216, -3999, -3999,
   -3999, 18331, -3999,  1705, -3999,  1705,   295,  1890, -3999,  1648,
   -3999, -3999,   373, -3999, -3999, -3999,  3253, -3999,  2906, -3999,
   -3999, -3999,   180,  1148, -3999, -3999, -3999,  2708,   434, -3999,
      81, -3999,  1691,  1648,  2579, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999,   282, -3999, 18331, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,    55,
   -3999,  1648, -3999, -3999,  1170, -3999, -3999, -3999, 20091,  -139,
    2652, 17694,  2171,  2171, -3999,  1705,  2428, -3999,  2685, -3999,
   13122, -3999,  3062,  2455, -3999,  1174, -3999,  1246, -3999, -3999,
   -3999, -3999,  3103,    19, -3999, -3999,  9782, -3999,  2263, -3999,
   18331, 18331,  1796, -3999,  1751,  3103,  2763,  2360, 13122,  2431,
   -3999,  3181,   788, -3999,  2545, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,  2452, -3999,
   -3999,  4556, -3999,  1563, -3999,  2453, -3999, -3999, -3999,  2328,
     772, 18058,  1705, -3999, -3999, -3999,  3097, 10816, -3999, -3999,
    2432, -3999,  3197,  2412,  2456,  1415, 10816, -3999, -3999,  1648,
   -3999, -3999, -3999, -3999, -3999,  2354, 10450,  1705,  2435,  4556,
    2435,  4556,  2937,  2276, -3999, -3999, -3999,  -282,  -247,  -192,
     661,  1164,  3294, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
    1977,  2739, -3999, -3999, -3999,  1194,  -171, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,  3940,
   -3999,  3272, -3999,  2991, -3999,  2504,  2554,  2554,  2358, -3999,
    4556, -3999,  2465,  2959, -3999, -3999, -3999,  2278, -3999, -3999,
   -3999, -3999, -3999, -3999,  2842,   131,  2768,   560,  1563, -3999,
   -3999,  1563, -3999, -3999,  2065,  2689,  2229,  1977, -3999, -3999,
   -3999, -3999,  2557,  2689,  1563,  3199,   238,   101,    73,  2119,
   -3999, -3999,  1563,  1563, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999,  2518, -3999,  2835, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
    2563,  3257,   349,  1890,  1890,  1890,  1890,  1890,  1890, -3999,
    2700, -3999, -3999,  3303, -3999, -3999, -3999, -3999, -3999,   256,
    2631, -3999, -3999,  1960,  2039, -3999,   265, -3999,   685,  -242,
     265, -3999, -3999,   170, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,   989,
   -3999,  2222, -3999, -3999,  1648,   870, -3999, -3999,  2485, -3999,
   -3999, -3999,  1563,   289, -3999, -3999,  1023, -3999, -3999, -3999,
   -3999,  2017, -3999, -3999, -3999, -3999, -3999, -3999, -3999,  2962,
   -3999, -3999, -3999,  2955, -3999, -3999, -3999, -3999, -3999, -3999,
    2957, -3999, -3999,  1778, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999,  1917,  3105, -3999,  1755, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999,   853,   853,   853,   853, 18331, -3999,   400,
   -3999,  6502, -3999, -3999, -3999, -3999,  2271, -3999, -3999, -3999,
   -3999, -3999, -3999,  2040,   821,  2826, -3999, -3999, -3999, 20160,
   -3999, -3999, -3999,   185, -3999, -3999, -3999, -3999,  6761, 20160,
     161,  2653,   161,  2654,  9108, -3999, -3999, -3999, -3999, -3999,
    3230,  1835, -3999,  2658, -3999,   916, -3999, -3999, -3999, -3999,
    1987, -3999,  3097, -3999, -3999,  1977, -3999,   916, 13122, -3999,
   -3999,  3242, -3999,   538, -3999, -3999,  6463, -3999,   538,  2986,
    2988,   255, -3999, -3999,  2753, -3999, -3999, 18252,   161,  2756,
    2756,  2767, -3999,   372, -3999,  3077, -3999, -3999, -3999,  1648,
   18331,  2214,  2871,  2918, -3999,   943, -3999, -3999, -3999,   889,
   -3999, -3999, -3999,  3164,  2823, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999,  2878, -3999, -3999,  2902, -3999,  2271,  2271, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999,  1796, -3999, -3999, -3999,
    2805,  2511,  1563, -3999, -3999, -3999,  1023,  2962,   161,   916,
    3180, -3999,  2768,  3103,  2768,  -139,  1695, -3999, -3999,  2230,
     149,  2768, -3999,  2857,  3156, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999,  2119,  2740, -3999,  2470, -3999,
   -3999,   167,   788, -3999,   788,   786,  2637,   388,   227, -3999,
    3039,  1648, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999,  1705, -3999, -3999, -3999, -3999,
   -3999, -3999, 16911,  2908, -3999, -3999,  2768,  3017,  2543,  2330,
    2543,  2330,  2214,  -107, -3999, -3999, -3999, -3999, 10299, -3999,
   -3999, -3999,  2709, -3999, -3999,  2272,  2912,  1563,  3940,  4315,
    3076,  4556, -3999,  2686, 21413,  3297, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,  3020,
    4079, -3999,  2354, -3999,  2751,   -62, -3999, -3999, -3999,  2920,
   -3999,   989,   492, -3999, -3999,  3199, -3999, -3999, -3999,  4556,
   -3999,  2330,   169,  1648, -3999, -3999, -3999, -3999,  2330, -3999,
    1984, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,   998,
     998,  1563,  1563,  2689,  1417, -3999,  1563,  1830,  1563,  1563,
    1563,  1563, -3999,  2285, -3999,   295,   965,  2330,  1563,  2065,
    2819, -3999,  2643,   965,  1890, -3999,  2330, -3999,  1106,   124,
    1341, -3999, -3999, -3999, -3999,   256,    83, -3999, -3999, -3999,
    3160, -3999, -3999, -3999,  1563,  2628,  2816, -3999, -3999, -3999,
   -3999,  3195, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
     870, -3999, -3999, -3999,  2996,  3189, -3999,  2283, -3999, -3999,
   -3999,  3052, 18331, 18331, 18331, 18331, -3999, -3999, -3999, -3999,
   -3999,  1648, -3999,   853, -3999, -3999, -3999, -3999,  2565,  -268,
   -3999, -3999,  1705, -3999,  1705, -3999, -3999, -3999,  3318, -3999,
     969, -3999, -3999, -3999, -3999, -3999,  3319,  3201,   538, -3999,
   -3999,   538,   916,  2558,  2558, -3999,  3403,  3351, -3999, -3999,
   -3999,  2780,  1890,  1231,  1134,  1648, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999,   202, -3999, -3999, -3999, -3999, -3999,  2881,
   -3999,  -172, -3999, -3999,  2882,  1498, -3999, -3999, -3999,  3327,
    2936, -3999,  1563,  1459, -3999, -3999,   984,  2939,  2940, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,  1890,
    1890, -3999, -3999, -3999, -3999, -3999, -3999,  1648, -3999,  3189,
   -3999, -3999, -3999,  1648, -3999,  1648, -3999, -3999, -3999, -3999,
   -3999,  2863,  3134, -3999, -3999, -3999, -3999,  8431, -3999,  9270,
      72,  1648,  2857,  2271,  2617, -3999, -3999, -3999,   192,  1407,
    2797, -3999, -3999,  2583, -3999, -3999, -3999, -3999,   786, -3999,
    2676, -3999, -3999, -3999,   -49,  2586, -3999,  2271, -3999,  4556,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, 16911, -3999,
     189, -3999, -3999, -3999,  2594,  2494,  2330,  2600, -3999,  3231,
   -3999,  3232, -3999,  1648,  2677,  2498, -3999, -3999, -3999,   157,
    2868,  1188,   475, -3999, -3999, -3999, -3999, -3999,  2128,  2435,
    2609, -3999, -3999, 21413, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999,  1235, -3999, -3999,  2976, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999,  2543,  3203, -3999, -3999,  2662, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,  1648,    84,
    2865,  1192, -3999, -3999, -3999, -3999,   451,  1648,  1563, -3999,
   -3999,  3603, -3999,  1648, -3999, -3999,   965, -3999,  1648,  1648,
   -3999, -3999, -3999, -3999,  2865,  1570,  1648,  1563,  1648, -3999,
     965,  2624, -3999, -3999,  2942,  3445,   107, -3999, -3999,    66,
     311,  1563, -3999, -3999,  2525, -3999, -3999, -3999, -3999,   870,
    2996,  1023,    50, 20160, -3999, -3999, -3999, -3999, -3999,  1648,
     853, -3999, -3999,  1023,  1023,  1835, -3999, -3999, -3999, -3999,
   18331, -3999, -3999, -3999,   538, -3999, 18331, 18331, -3999, -3999,
    1563,  1890,  1890,  2830, -3999, -3999,   757,   210, -3999, -3999,
    2873, -3999, -3999, -3999, -3999, -3999, -3999,  2755, -3999, -3999,
   -3999, -3999,  5497,  2574, -3999,  1648, -3999, -3999,  2708,   434,
   -3999, -3999, -3999, -3999, -3999, -3999,  1023, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, 18331, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999,  2617,  1648,  1648,  1371,
    2961,   192, -3999,   140,  2536, -3999, -3999,  1563,  1992, -3999,
   -3999, -3999, -3999,  2629, -3999, -3999,  2546,  1563,  1648, -3999,
   -3999, -3999, -3999, -3999, -3999,  2330,  3071,  2214,  2214,  1447,
   -3999,  1563, -3999, -3999,  2271, -3999, -3999,  2129,  1158,  3135,
   -3999,  3191, -3999,  2912, -3999,  2435, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
     965,   965, -3999, -3999, -3999, -3999,  3140,  3277, -3999,  2465,
    2330, -3999, -3999, -3999, -3999, -3999,  1648, -3999, -3999, -3999,
   -3999,  3136, -3999, -3999, -3999, -3999,  3489, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999,   165,   577, -3999, -3999, -3999, -3999,
   -3999,   125,  1442, -3999, -3999, -3999,  1648,  1155,  1563,  2664,
     965,  1563,  1563, -3999,  2409, -3999, -3999, -3999,   319,  -145,
     170, -3999,  2666,   870, -3999,  1057,   312, -3999, 18331, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999,   -91,  1890,  1563,  1563,
    1563,   210, -3999, -3999, -3999, 13122, -3999, -3999, -3999, -3999,
    9782, -3999, -3999, -3999, -3999, -3999, -3999, -3999,  1648, -3999,
    1563,  1648, -3999, -3999, -3999,  1563,  2987, -3999, -3999, 13122,
   -3999, -3999, -3999,   -91, -3999, -3999, -3999, -3999, -3999, -3999,
    1793, -3999, -3999, -3999, -3999,  1989,  2869,  3295,  1541,  2849,
     -55, -3999,  9782, -3999,   388, -3999, -3999,  1447,  1648,  1648,
    2991, -3999,  3093, -3999,   444,  2689,   456,  2330, -3999, -3999,
    2929, -3999, -3999, -3999,  1648, -3999, -3999, -3999, -3999, -3999,
    3476,  2214, -3999,  2865, -3999,  1442,  1648,  1996, -3999, -3999,
   -3999, -3999,  1648, -3999, -3999, -3999, -3999, -3999,  1563, -3999,
    2909, -3999, -3999, -3999,   662,  -142,   662, -3999,   210,   965,
   -3999, -3999, -3999,   786, -3999, -3999,  3016, -3999,   178,   870,
   -3999, -3999, -3999, -3999,  2954,   -10, -3999,  2271, -3999, -3999,
   -3999, -3999, -3999,  1648, -3999, -3999,   -91,   210,   210, -3999,
   -3999,  1930, -3999, -3999,  1371, -3999,  1191, -3999, 13122,  2271,
    2641, -3999, -3999,  2834,  2742,  2684,  1989, -3999,    48,  2214,
   -3999, -3999, -3999,  -162, -3999, -3999,  8569, -3999, -3999,   -55,
    2679, -3999, -3999, -3999,  1447, -3999, -3999, -3999, -3999,  1563,
     444, -3999, -3999, -3999,  1648, -3999, -3999,   965,  1648,  3277,
      32, -3999, -3999, -3999, -3999, -3999,    32, -3999,  1648,  1648,
     -34, -3999, -3999,  2807, -3999,  3037, -3999, -3999, -3999, -3999,
   -3999, -3999,  2758,    -7, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999,  1648, -3999, -3999,   124,  1341, -3999, -3999, -3999,
    3015,  1648,  2271,  2726,  1371,  1648, -3999,  1956,  1890,  2688,
   -3999, -3999, -3999, -3999,   181,   962,  1583,  1878,  2691,  2058,
    2701, -3999, -3999,  2279, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999,  2909,  1100,  1563, -3999, -3999, -3999, -3999, -3999,
    2965, -3999, -3999,  1563, -3999, -3999,  3019,  3518,  1563, -3999,
    1648, -3999,  1563,  1648,   245, -3999, -3999, -3999, -3999, -3999,
    2922, -3999,  1890,  1712,   181, -3999, -3999,   193,  3113,  3115,
    3340,  3104, -3999,   962, -3999,  2675,  1410, -3999, -3999, -3999,
    2459, -3999, -3999,  2279, -3999,  2746, -3999,  3322,  1648,  1353,
     883,  3354,  1563,  1563, 13122, -3999,   711,  1648, -3999,  1563,
    1315,   -37,   245, -3999, -3999,  1371, -3999,  2214, -3999, -3999,
   -3999,  2989,  1648, -3999,  1563,  2995,  1648,  1563,  1563,  1563,
    1563, -3999,  3124,    78,  3128, -3999,  3117, -3999,  2235, -3999,
   -3999,  1648,  3398,  1651,  3138,   216,  3141,  3126, -3999,  1133,
   -3999, -3999,  1648,  2749,  1480, 20756,   936, -3999, -3999, -3999,
    2640, -3999, -3999, -3999,  1884, -3999, -3999,   698, -3999, -3999,
     210,   210, -3999, -3999, -3999,  2106, -3999, -3999, -3999,  2106,
    2106, -3999, -3999, -3999, -3999, -3999, -3999,  2994, -3999, -3999,
   -3999,   303, -3999, -3999,  1648,  2330, -3999,  1648,  1648,  1648,
    1648,  1563,  1563,  1563,  1563,  1563, -3999,  1648,  1563,  1563,
    1563,  1563,  1563,  1563,  1563,  1563,  1563,  1563,  1563, -3999,
    1648,  1563,   907,  2761, -3999,  1563, -3999, -3999, -3999, -3999,
     859, -3999,  2551,  2551,  1563,   853,    39,  1563,  5136, -3999,
   -3999, -3999, -3999,  2551,   853, -3999,  3342,  2330, -3999,  3467,
   -3999, -3999,   853, -3999, -3999,  1648, -3999, -3999,  1563,  1648,
    1563, -3999, -3999,    44, -3999, -3999, -3999, -3999, -3999,  1852,
   -3999, -3999, -3999, -3999,  3214,  2551, -3999, -3999, -3999, 12734,
     153,   698, -3999, -3999,   170, -3999, -3999, -3999, -3999, -3999,
   -3999,   -37, -3999, -3999, -3999, -3999, -3999,  1890, -3999,  2543,
   -3999, -3999, -3999, -3999,  1648,  1648,  1648,  1648,  1648,  1648,
    1648,  1648,  1648,  1648,  1648,  1648,  1648,  1648,  1648,  1648,
    1648,  1648,  1648, -3999, -3999,   349,   349,  2060, -3999, -3999,
   -3999, -3999,  3217,  3463,   -40,   821, -3999, -3999, -3999,  1563,
   -3999,  1563,   821,   936, -3999, -3999,   821, -3999, -3999,   821,
    2543,  1563,   936, -3999,   184, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999,  1930, -3999, -3999, -3999, 13626,  1852, -3999, -3999,
   -3999, -3999, -3999, -3999,  3093, -3999, -3999, -3999, -3999, -3999,
    1648, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999,  1648, -3999, -3999, -3999,   349,   349,   915,    53,
   -3999,  1563, -3999, -3999,  1648,  1648, -3999, -3999, -3999,  1392,
    1392, -3999, -3999, -3999, -3999, -3999,   233, -3999,   989, -3999,
   -3999, -3999, 21011, -3999, -3999, -3999,  1648,  1648, -3999, -3999,
   -3999, -3999, -3999,  1875, -3999, -3999, -3999,  5654, -3999,   989,
    1648, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
     821, -3999, -3999,   821, -3999, -3999, -3999, -3999, -3999,  1648,
   -3999,  2311,   975,  1026, -3999, -3999,   915,   907, -3999, -3999,
   -3999, -3999, -3999,  1648,   324,  1563,  1563,  2284,  1563, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999,  2049, -3999, -3999, -3999,
    1648, -3999, -3999,  1563,   915,   915, -3999,  3204,  1563,  1563,
     915,  5059,  1648,   915, -3999, -3999, -3999,   915,   915, -3999,
   -3999, -3999, -3999,  3182,  2103,  3076,  1563,  2330, -3999,  1563,
    2271,   596, -3999, -3999, -3999, -3999, -3999, -3999, -3999,  4556,
   -3999, -3999, -3999, -3999, -3999, -3999,   194, -3999, -3999,   938,
   -3999,    25, -3999, -3999, -3999, -3999, -3999,  2103,  1648, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999,   349, -3999,  2019,  2600,
   21413, 21413,  2155,  4556,  3063,  3063,  1916,  9782, -3999, -3999,
     938,   278, -3999, -3999, -3999,  2330,   278, -3999,   718, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999,  2330, -3999,  2543,  2171,
   21136, -3999, -3999,  1543,  1781, -3999, -3999,  1876, -3999, -3999,
   -3999, -3999,  1104,  1104, -3999, -3999, -3999, -3999, -3999,   922,
     922,  3063,  3063, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999,   349, -3999, -3999,  3232, -3999,  2214,  1648, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999,   -21,   174, -3999,
   -3999, -3999,   922, -3999, -3999,  2999,  3000, -3999,  2796,    40,
   -3999,  3006, -3999,  3006, -3999,  3006, -3999,  3006, -3999, -3999,
   -3999,  2330, -3999, -3999, -3999, -3999,  3002, -3999, -3999, -3999,
   -3999, -3999, -3999
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_int16 yydefact[] =
{
       2,     0,    14,     1,     3,     5,    36,     4,    79,    35,
       0,    53,     0,    15,   102,  3240,    58,    57,    53,     8,
      10,    11,    12,    13,     0,    54,    55,    82,   104,    50,
     107,     0,   103,  3239,    37,     9,    61,    59,     0,    79,
       0,    79,     0,  3333,    80,    88,   490,   109,   285,   111,
       0,   108,  3240,    39,     0,    18,     0,     0,  3240,  3334,
       0,     0,    90,   492,    51,   495,     0,   491,   284,   101,
       0,   287,     0,     0,     0,  3400,  3333,  3333,  3333,     0,
       0,  3240,  3240,  3333,  3240,  3240,  3295,   197,   281,   196,
       0,   106,   112,   113,   115,   116,   119,   117,   118,     0,
     176,   179,   194,   180,   181,   247,   182,   184,   183,   187,
     185,   186,   188,   189,   190,   191,   192,   193,  3240,   105,
      40,    38,    64,    63,    67,    22,    16,    19,    20,    67,
      24,    17,    56,    84,    85,    86,    87,    83,  3364,  3333,
      95,  1526,   494,     0,   497,  3240,  3240,  3240,   289,  2937,
    2936,   207,   244,  3333,  3401,  3333,     0,     0,     0,  3333,
    3333,   128,   160,     0,   122,   174,  3296,     0,  3313,  3333,
     268,   114,   178,   175,   177,  3333,     0,   249,   110,     0,
       0,  3333,     0,    21,  3333,     0,  3365,  3333,     0,     0,
    3240,  1521,    52,  1520,  1580,  3240,   488,   493,   286,   288,
     434,   213,  3314,  3333,     0,     0,     0,  3046,   277,  2925,
     275,   280,     0,     0,   130,   162,   279,   124,   640,   258,
     259,  3333,     0,     0,     0,  3055,  2442,  2441,   195,   201,
     204,  3379,  3333,     0,   378,   377,   375,   376,   374,   248,
       0,    68,     0,     0,    66,    65,  3240,    62,     0,  3240,
       0,    92,    94,    93,    91,  3333,    81,     0,     0,     0,
     496,   503,   504,   620,   498,   623,     0,  3240,   291,   290,
     283,   437,   208,   209,   211,     0,     0,   245,   246,   278,
     273,  3460,  3461,     0,   267,     0,  3294,  3407,  3390,  3333,
     156,   129,  3389,   134,   136,   137,   138,   139,  3389,     0,
    3297,     0,     0,   161,     0,   165,   123,   126,   260,     0,
    2939,   250,   251,  3338,   254,   282,     0,  3065,  3072,  3066,
    3064,  3062,  3067,   271,  3063,   269,  3073,   270,  3068,  3070,
    3379,  3382,  3381,     0,     0,   198,   202,    42,    60,    71,
      74,  3240,    78,    77,  3389,    72,    73,    23,  3240,    25,
    3146,  3147,  3148,  3149,  3150,  3151,  3152,  3153,    89,     0,
    1522,  3268,     0,  1651,  1765,  1775,  1783,  1790,  1848,  1856,
    1876,  1871,  1877,  1886,  1882,  1894,  1904,  2036,  2045,  2047,
    2054,  2181,  2087,  2101,  2114,  2117,  2120,  2126,  2128,  2139,
    2161,  2165,  2169,  2226,  2244,  2246,  2252,  2256,  1648,  2262,
    2296,  2323,  2325,  2330,  2360,  2361,  2377,  2380,  2381,  2386,
    2395,  2396,  2414,  2431,  2472,  2490,  2509,  2528,  2544,  2552,
    2556,  3267,  2560,  2563,  2566,  2583,  2623,  2639,  3269,  1582,
    1583,  1584,  1585,  1586,  1587,  1588,  1589,  1591,  1590,  1592,
    1594,  1593,  1595,  1596,  1597,  1598,  2048,  1599,  1600,  1602,
    1603,  1604,  1605,  1606,  1607,  1608,  1609,  1610,  1611,  1612,
    1601,     0,  1613,  1614,  1615,  1616,  1617,  1618,  1619,  1620,
    1621,  1622,  1623,  1624,  1625,  1626,  1627,  1628,  1629,  1630,
    2397,  1631,  1632,  1633,  1634,  1635,     0,  1636,  1637,  1638,
    1639,  1640,  1641,  1642,  1643,  1644,  1645,     0,  1646,  1647,
    1559,  1581,   619,     0,   565,   499,  3122,     0,  2907,   500,
     436,  3139,     0,   464,  3374,   447,   435,     0,   440,   442,
     443,   455,   444,   445,  3333,  3333,   214,   215,  3060,   247,
     263,   265,  3061,  3432,   272,     0,  3047,   276,  3408,  3333,
       0,   133,   135,   131,   157,  3389,  3333,  3298,   141,     0,
       0,   172,    67,     0,    67,     0,   163,   166,     0,     0,
     261,   252,  3340,  3339,   255,     0,  3069,     0,     0,  3380,
     205,   199,   200,   203,    45,    41,    47,    76,    26,    70,
      75,    29,    97,    98,    99,   100,    96,  1800,  3164,  3165,
    3166,  3167,  3168,  3169,  3170,  3171,  3172,  3173,  3174,  3175,
    3176,  3162,  3216,  3217,  3218,  3219,  3220,  3221,  3222,  3223,
    3224,  3225,  3226,  3227,  3228,  3229,  3230,  3231,  3232,  3233,
    3234,  3235,  3236,  3237,  3238,  3177,  3178,  3180,  3179,  3181,
    3182,  3183,  3184,  3185,  3186,  3187,  3189,  3188,  3190,  3191,
    3192,  3193,  3194,  3195,  3196,  3197,  3198,  3199,  3200,  3201,
    3202,  3203,  3204,  3205,  3206,  3207,  3208,  3209,  3210,  3160,
    3211,  3212,  3213,  3214,  3215,  1650,  3161,  3163,  1683,     0,
    3043,     0,  1800,     0,     0,     0,  1879,     0,     0,  1899,
    1948,     0,  1899,  2785,     0,  2091,  2103,     0,     0,  3423,
    2110,     0,     0,     0,     0,  2172,     0,     0,     0,     0,
       0,  2267,  2772,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2531,     0,  2554,     0,     0,     0,
       0,     0,     0,     0,  1800,  2227,  2239,  2399,     0,  2512,
    2524,  2527,  2510,  2525,  2777,  2526,  2513,  2522,  2514,  2523,
    3027,  3031,  2640,  2692,  1580,     0,   564,     0,   977,   675,
       0,     0,   625,     0,     0,   629,   630,   628,     0,  3257,
    3259,  3244,  3258,  3243,  3245,   502,  3246,   505,     0,  3140,
       0,  3374,  3423,  3423,  3372,  3374,  3374,  3423,  3374,  3374,
    3423,  3374,  3374,  3311,  3375,  3309,     0,   448,   449,   450,
    3276,     0,  3255,  3254,  3256,  3253,  3241,   441,   438,  3242,
       0,     0,   262,   264,     0,     0,     0,   150,   132,  3048,
     142,   167,   168,   171,   173,   169,   170,   164,   125,     0,
    3056,   253,   256,  3071,   206,  3333,    48,     0,   475,   475,
    1805,  1808,  1807,  1802,  1803,  1806,  1804,  1794,  1801,  1682,
    3046,  1763,  1653,  1695,     0,  3362,  1681,  3372,  3098,  3096,
    3099,     0,  3092,  3100,     0,     0,  3106,  3477,  3478,     0,
    2890,  2892,     0,     0,     0,  3095,  2961,     0,  2894,  3097,
    3101,  3102,     0,     0,  3094,  3106,  3093,  1773,  2955,  1771,
    2947,  2950,     0,  2949,  2953,  2954,  3103,     0,     0,  2962,
       0,     0,     0,     0,  1776,     0,  2871,  2881,  2883,  2887,
    2971,     0,  2889,  2968,  3128,  3044,  2969,  2970,  2922,  1784,
    1785,     0,  2918,  2920,  2919,  1846,  2772,  1851,  2999,  1855,
    1849,  1850,  1852,  1854,  2998,  1867,  1857,  1858,  1859,  1862,
    3372,  1874,  3038,     0,  2896,  3142,  2942,  3037,  3042,  2943,
    1880,  1878,     0,  1892,  3393,  3301,  1883,  3032,  1885,  3417,
       0,  1901,  1903,  1895,     0,  1945,  1979,  1978,  3072,  3289,
    1925,  1977,  1970,  1976,  1969,  2034,  2717,  2945,  1920,  1922,
    1912,  1913,  1926,     0,  1914,  1915,  1966,  1916,  1917,  1979,
    1919,     0,  2949,     0,  2043,     0,  2046,  2061,  2060,  2085,
       0,  2057,  2059,  2784,  3333,     0,  2174,  2175,  2176,  2092,
    2088,  2093,  2105,  2109,  2107,  2110,  2108,  2102,  2115,  2116,
    2940,  2118,  2119,  3424,  2121,  2916,  1833,     0,  1832,     0,
    2127,  2783,  2133,  2782,  2140,  2142,  2909,  2162,  2163,  1213,
    1985,     0,     0,  2166,  1212,  2173,  2170,     0,  2245,  2476,
    3019,  3020,  3137,     0,  2250,     0,  2253,     0,  2260,     0,
    1649,  2268,  2263,  2264,     0,  3318,  2297,  2309,     0,  2908,
    2324,     0,  2326,  2328,  2358,  3134,  2375,     0,  2378,  2626,
    2899,  2384,  3393,     0,  2393,  2900,  2626,     0,  2415,     0,
    2417,  2420,     0,     0,  2912,  2432,  2433,  2434,  2435,  2436,
    2437,  2463,  2438,  2466,  2439,  2440,     0,     0,  2910,     0,
       0,  3018,  3042,  2473,  2507,  2495,  2542,     0,     0,     0,
       0,  2550,     0,  2555,  2553,  2557,  2558,  2561,  3295,  3022,
    2564,  3395,  3001,  2581,  2569,  3000,  3002,  2584,  2585,  2637,
    2626,     0,     0,  2049,     0,     0,     0,  2411,  2403,  2902,
    2515,  2776,     0,  3029,  3030,     0,     0,  1566,     0,  1567,
    1560,     0,  1561,  1562,  1565,     0,  3262,  3260,  3264,  3263,
    3261,  3265,  3266,  3250,  3251,   621,  3252,  3240,   976,     0,
     981,   676,   673,   678,     0,     0,   626,     0,   637,   638,
     631,   639,   634,   635,  3333,  3141,   292,     0,     0,     0,
    3373,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3312,  3415,  3310,     0,   349,   472,   350,  3277,  3313,   439,
     220,   219,   240,   236,  3048,   241,   225,   239,   237,   217,
     218,   238,   210,   216,   227,   228,   230,   222,   223,   224,
     212,   221,   266,   274,     0,   153,   155,   154,   151,   152,
    2930,     0,  3313,   127,   257,     0,  3333,    43,   476,    27,
      30,  1795,  1528,  1764,  1652,  1695,  3284,  3286,  1700,  3333,
    1679,  1696,  1697,  1699,  1701,     0,     0,  3303,     0,     0,
    3363,     0,     0,     0,     0,     0,     0,     0,  3103,  3112,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3103,
    1774,  1766,     0,     0,  2948,  2956,  2957,  2958,     0,  3078,
       0,     0,  2886,  2885,     0,  2884,  3130,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2972,
    2973,  2974,  3129,  1779,  1786,  1788,     0,  1847,  1791,  1811,
    1853,     0,  1862,  3473,  3474,  1860,     0,  1863,     0,  1875,
    1872,  3455,  3454,  2897,     0,  3144,  2898,  3040,  3041,     0,
    2717,  1890,  1893,  1887,  3394,  2343,  3302,  1884,  3033,  3418,
    1900,  1902,  1897,  1926,  1980,     0,  3290,     0,  2035,  1905,
    3443,  1577,  3442,  1910,  2723,  2720,  1577,  1921,  1918,  2946,
    3431,     0,  1947,     0,  1981,     0,  2717,  2717,  2717,  2717,
       0,  2044,  2037,     0,     0,  2086,  2055,  2785,  2072,  2056,
    2063,  2064,  1577,  2801,  2803,  2806,  2804,  2805,  2807,  2808,
    2809,  2810,  2799,  3334,  2841,  2802,  2794,  2798,  2796,  2797,
    2793,  2795,  2786,  2787,  2800,  2789,     0,     0,  2183,  2182,
    2094,  2089,  2106,  2104,  2941,     0,  2124,  3436,  2112,  2111,
    2134,  2135,  2144,     0,  2164,  1984,  1294,  1323,  1291,  1373,
    1308,  1307,  1372,  1374,  1396,  1375,  1359,  1442,  1476,  1392,
    1421,  1395,  1418,  1464,  1367,  1390,  1386,  1393,  1416,  1462,
    1293,  1296,  1403,  1400,  1292,  1399,  1398,  1448,  1320,  1402,
    1321,  1477,  1325,  1385,  1414,  1411,  1438,  1429,  1466,  1265,
    1439,  1449,  1412,  1347,  1349,  1348,  1415,  1450,  1451,  1452,
    1453,  1311,  1312,  1441,  1404,  1406,  1405,  1410,  1345,  1426,
    1319,  1428,  1435,  1436,  1327,  1329,  1440,  1332,  1271,  1424,
    3319,  1370,  1346,  1318,  1288,  1447,  1287,  1290,  1289,  1445,
    1437,  1413,  1397,  1458,  1433,  1434,  1369,  1455,  1456,  1457,
    1446,  1461,     0,  1322,  1423,  1419,  1422,  1454,  1409,  1420,
    1328,  1361,  1391,  1387,  1383,  1394,  1417,  1459,  1460,  1427,
    1330,  1331,  1295,  1463,  1324,  1368,  1326,  1407,  1408,  1444,
    1360,  1362,  1264,  1333,  1350,  1371,  1443,  1475,  1401,  1384,
    1425,  1366,  1389,  1388,  3319,  1224,  1239,  1240,  1241,  1242,
    1243,  1244,  1245,  1246,  1247,  1248,  1249,  1250,  1251,  1252,
    1253,  2167,  1481,  3319,  3319,  3319,  2168,  1485,     0,  2480,
       0,  3021,  3138,  3335,  2248,  1216,  1218,  3341,     0,  2249,
    2251,  2247,     0,     0,  2261,  2257,     0,  2265,  2272,  2269,
    2271,  2270,  2273,  3372,  2311,  2922,  3004,  2774,  2774,     0,
    2307,     0,     0,  3003,  2919,   643,  3005,     0,  2773,  2329,
    2327,  2359,  2331,  3135,  3136,  3393,  2376,  2362,  2364,  2365,
       0,     0,  2379,  2385,  2382,  2333,  2901,  2394,  2387,  2343,
       0,  2416,     0,  3431,  2423,     0,  2988,  2993,  2994,  2995,
       0,  2464,  2467,     0,     0,     0,  2911,  2444,     0,  2443,
       0,     0,  3040,  2508,  2491,  2497,  3333,  2498,  2493,  2543,
    2529,     0,  2532,  2533,  2536,     0,     0,  2551,  2545,     0,
    2559,     0,  3396,  3397,  2565,  2582,  2567,  3291,     0,  2586,
    2638,  2624,  2628,  2050,  1794,  2237,     0,  2237,     0,  2411,
    2405,  2413,  2398,     0,  2405,     0,  2511,  2517,     0,  2866,
    2864,     0,  3028,  2690,     0,  2690,  2696,  1574,  1569,  1573,
       0,   623,   566,  3240,   980,     0,   984,     0,   743,  3122,
     627,   633,   777,   641,  3299,  3333,     0,     0,  3333,  3299,
    3364,  3333,  3274,     0,   506,   509,   510,   511,   512,   513,
     514,   515,   516,   517,     0,   501,     0,     0,   451,  2923,
    3374,  3374,     0,   459,  2903,   452,  3374,   453,   461,  3374,
     454,   463,  3416,  3299,  3372,  3372,     0,     0,   226,   229,
     232,     0,  3468,  3470,  3469,   140,  3050,  3049,   143,     0,
    3048,    46,     0,   120,  1517,  1517,     0,  1531,  1529,  1551,
    2704,  3008,  1712,  3006,  3007,     0,  1698,  3451,  3450,  3368,
    3453,  3452,  1710,  1711,  3368,     0,  1716,  3333,  1730,  1731,
    1732,  1718,  1720,  3333,  3304,  1721,  3333,  1762,  3333,  1723,
    1726,  1724,  1725,  1727,     0,  1756,  1757,  1734,  1736,  3392,
    1737,  1760,  1758,  1759,  1728,  3425,  1739,  1729,  1717,  3272,
    1741,  1761,  1744,  1702,  1733,  1738,  1743,     0,     0,     0,
    2981,     0,  1690,  1694,  1693,  1684,  1680,  1675,  2704,  3447,
    3446,  1672,  1662,  1664,  1665,     0,  2704,  3348,     0,     0,
       0,  1708,  1670,  1655,  1660,  1659,  1669,     0,  1678,  1657,
    1677,  1658,  2985,  2984,     0,  2960,     0,  2866,  2864,     0,
    2866,     0,  3108,  2866,  3090,     0,     0,  2891,  2893,  2866,
       0,     0,     0,  2866,  2965,  2966,  2967,     0,  2895,     0,
    2866,     0,  3091,  3372,  3038,  2726,  1772,  3042,  2943,     0,
       0,     0,  2866,  2888,  3132,  1779,  2870,  2869,  2874,  2875,
    2876,  2877,  2878,  2879,  2880,  2873,  2872,  2882,     0,  1781,
       0,     0,  2921,  1792,     0,  1809,  1869,  1861,  1866,     0,
       0,  2944,  2726,  3333,  3143,  3039,     0,  1889,  1891,  3313,
    2762,  2344,  2345,  1896,     0,  1946,  1971,  1955,  2725,  1578,
    2718,  2724,  2719,  2721,  2722,     0,  1935,  1934,  1923,  1930,
    1932,     0,  3335,  2022,  2023,  2024,  2011,     0,  2014,  3333,
    2015,  3307,  3335,  2018,  2019,  2025,  2020,  3425,  3333,  2021,
    2028,  2026,  1927,  1928,  1954,  1949,  1950,  1952,  1953,     0,
    1967,  1974,  1908,  1909,  1906,  1907,  2717,     0,  2726,     0,
    2058,     0,  2072,  2065,  2062,  2067,  2068,  2074,  2066,     0,
    2840,  2788,  2851,  2852,  2853,  2842,  3423,  2859,  2862,  2861,
    2863,  2855,  2848,  2850,  2849,  2854,  2856,  2858,  2860,  2790,
    2843,  2844,  2845,  2846,  2847,  2189,  2191,  2190,     0,     0,
       0,  1685,  2915,  2124,  2913,  3374,  2122,  2917,  3437,  2113,
    2136,  2137,  1577,  3423,  2152,  2153,  2155,  2157,  2158,  2154,
    2156,  2147,  3423,  2143,  3320,  3321,     0,  1223,  1480,     0,
    1482,     0,     0,     0,  1486,     0,  2213,  2197,  2171,  2178,
    2179,  2180,  2482,     0,     0,  3336,  3337,     0,  1217,  3343,
    3342,  3344,     0,  1259,  1382,  1343,  1286,  1302,  1353,  1272,
    1376,  1351,  1300,  1268,  1381,  1468,  1378,  1364,  1297,  1365,
    1363,  1334,  1336,  1339,  1298,  1352,  1306,  1355,  1304,  1344,
    1341,  1257,  1356,  1377,  1266,  1310,  1431,  1469,  1280,  1338,
    1274,  1281,  1301,  1273,  1357,  1471,  1358,  1269,  1317,  1472,
    1256,  1263,  1283,  1314,  1315,  1284,  1299,  1260,  1261,  1316,
    1254,  1337,  1282,  1267,  1473,  1340,  1379,  1262,  1467,  1430,
    1474,  1432,  1285,  1303,  1335,  1255,  1380,  1470,  1270,  1305,
    1313,  1279,  1465,  1277,  1278,  1354,  1342,  1275,  1276,  1309,
    1258,  1222,  1225,  1226,  1227,  1228,  1229,  1230,  1231,  1232,
    1233,  1234,  1235,  1236,  1237,  1238,     0,  2254,  2726,     0,
    3431,  2343,     0,  3317,  2309,  2299,     0,     0,     0,     0,
     652,   648,   651,   650,   649,   654,   851,   666,   662,   664,
     665,   667,   663,   853,   852,   655,  2982,   668,   669,   644,
     658,   659,   660,   653,   656,   657,   647,   646,  2310,     0,
    2333,     0,  2627,  3015,  3016,  3017,     0,     0,  2389,     0,
    2422,  2628,     0,     0,     0,     0,     0,  2465,  3372,     0,
       0,  2469,  2468,  2460,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2446,  2447,  3137,  2762,     0,  2540,  2534,
    3291,  2535,     0,     0,  2726,     0,     0,  3292,  3123,     0,
    2540,  2633,  2632,  2343,  3270,     0,  1815,  2238,  2228,     0,
    2240,     0,  2400,  3438,  3439,     0,  2407,  2412,  2404,     0,
    2516,  3411,  3411,  2867,  2868,  3052,     0,     0,     0,  2691,
    2641,     0,  2693,  2698,     0,  1575,  1564,   622,   568,   978,
    3240,   985,  1123,  3333,  3274,     0,   674,     0,   744,     0,
       0,     0,   908,  3427,  3333,  3333,  3333,     0,     0,  3398,
       0,   876,   761,     0,     0,  3281,     0,  3405,   904,  3423,
    3333,  3333,  3333,  3274,     0,   760,   632,   777,   699,   701,
     704,   702,   703,   705,   707,   706,   722,   723,   721,   708,
     710,   709,     0,   711,   712,   713,   714,   715,   716,   717,
       0,   724,   725,   726,   729,   727,   728,   718,   719,   720,
     730,     0,     0,  3281,     0,  3300,     0,     0,  3338,  3338,
       0,     0,     0,     0,     0,  3333,   560,  3275,   561,     0,
    2938,   559,   562,   507,   508,     0,   293,  3393,  2924,     0,
       0,  3479,  3480,  3374,  2904,     0,     0,     0,     0,     0,
     473,   446,     0,   231,     0,  3333,  3333,   144,    49,     0,
     121,   981,    32,    32,  1798,  1799,  1797,     0,  1536,  1536,
       0,  1523,  3441,  2715,  2716,  3440,  1654,  2712,  1752,  2707,
    1577,  2710,  2711,  1715,  3369,     0,     0,  3057,  1703,  3009,
    3010,     0,     0,     0,     0,  1719,  1755,  1742,  3333,  2778,
    3426,  2778,  3273,     0,  3317,  3333,     0,     0,     0,     0,
    1676,  1661,  1663,  2704,  1673,  3349,  1666,  1667,  1668,  1709,
    3283,  1671,  2987,  2959,  2986,  3142,     0,  3103,     0,  3103,
    3107,     0,  3103,  3113,     0,  3103,  3103,  3103,     0,  3103,
    3142,     0,  3103,     0,  1577,  1577,  1767,  2732,  2729,  3040,
    3041,  2726,     0,  3103,  3103,     0,  3131,  1781,  1780,     0,
    1777,  1789,  1787,  2774,  1813,  1814,  1810,  1812,  1868,     0,
    1865,  1864,  1873,     0,  1881,  2348,     0,  1577,  1577,  1888,
    2763,  2769,  2766,     0,  1981,  1957,  1580,  1943,  1944,  1941,
    1940,  1942,  1939,  1931,  1933,  1936,     0,  2012,  2013,     0,
    1490,  1492,  2016,  2017,     0,     0,     0,  2778,  2778,     0,
    1929,  1951,  1982,  3431,  3431,  1911,     0,  2038,     0,  2082,
    2079,  2081,  2080,  2073,  2076,  2083,  1577,     0,  2792,  2791,
    2857,  2192,  2195,     0,  2196,  2186,  2187,     0,     0,  2095,
    1686,  2123,  2914,     0,  1577,  2138,  2129,  2132,     0,     0,
    2159,     0,  1484,  1483,  1489,  1488,  1487,     0,  3045,  2989,
    2990,  2214,     0,  2216,  2215,  2217,  2199,  2209,     0,     0,
    2177,  2483,  2474,     0,   894,   895,  3348,  3322,  1221,  1479,
    1478,     0,  1219,  2255,  2258,     0,     0,     0,   645,     0,
    2298,  1577,     0,  2316,  2312,  2317,  2313,  2318,     0,  2308,
     661,  2315,  2335,  2366,  2334,  1577,  2383,  2751,     0,  1577,
    2762,  2390,     0,     0,  2429,  2428,  2427,  2426,  2425,  2445,
    2470,  3012,  2471,  3011,  3013,  3014,     0,  2457,     0,  2462,
    2449,  2450,  2451,  2455,  2452,  2456,  2453,  2454,  2448,  3138,
    2506,     0,  2504,  2499,     0,  2492,  3476,  3475,     0,  2735,
       0,     0,  3142,  3142,  2546,     0,     0,  3124,  2570,  2571,
       0,  2574,  2577,  2579,  2575,  2389,  3271,     0,  2053,  2051,
    1816,  2052,  2780,  2242,  2785,  1577,     0,  2401,  2408,  3412,
    2520,  2520,  2865,  3053,     0,  2780,     0,  2700,     0,     0,
    1576,   567,   623,   982,     0,  1124,   489,   929,   930,   694,
     696,   695,   689,   693,   691,   692,   688,   690,   687,   941,
     935,   937,   938,  3333,   745,   671,   972,   973,  3428,     0,
       0,     0,     0,   757,   758,   759,  3305,     0,  3399,   902,
     733,  3025,   880,     0,   874,   763,     0,   731,  3282,     0,
     752,  3406,   905,   906,   903,     0,     0,     0,     0,     0,
       0,     0,  1098,  1094,  1095,   700,   783,  3402,  3402,  3402,
    3402,  3402,   784,   786,   787,   788,   791,   792,   793,   794,
     796,   795,   798,   835,   832,   830,   831,   833,   834,   797,
    3423,   804,   799,   836,   800,   840,   838,   815,   816,   814,
     818,   819,   817,   837,   771,   789,   790,   687,   933,   923,
     931,   741,   974,  3291,   746,   738,  3154,  3154,     0,   677,
       0,   642,   529,   557,  3471,  3472,  2933,   538,  2931,  3463,
    3462,   531,  2935,  2934,  3358,  3295,  3317,     0,  3333,   535,
     534,  3333,   563,   295,  3364,  3348,  3393,  3423,   360,  3458,
    3459,   399,     0,  3348,  3333,  3293,  3348,   401,     0,  3431,
     382,   381,  3333,  3333,   297,   298,   303,   308,   317,   305,
     364,   306,   309,     0,   310,     0,   300,   398,   301,   302,
     307,   304,   299,   311,   312,   313,   314,   315,   316,   294,
       0,  3287,  3338,   456,   457,     0,   460,   462,   465,   466,
     469,   474,   471,   233,   234,  3051,  3048,  3048,   145,   479,
     158,  1518,    33,     0,     0,  1796,  1532,  1533,  1539,     0,
    1530,  1552,  1553,     0,  2705,  2713,  1577,  1753,  1754,  3023,
    2706,  2708,  2714,  1713,  1714,  1747,  1745,  1722,  1746,     0,
    1749,     0,  1748,  1750,     0,     0,  1689,  1688,     0,  1692,
    1691,  1674,  3333,  1656,  1704,  1706,  2726,  3119,  3088,  3121,
    3089,  3103,  3082,  3117,  3085,  3086,  3087,  3115,  3084,  3156,
    3110,  3111,  3081,  2944,  2734,  2731,  2727,  2733,  2728,  2730,
    3039,  1768,  3104,     0,  3079,  3080,  3133,  2996,  2997,  1778,
    1782,  1794,     0,  3145,     0,  2768,  2771,  2764,  2770,  2765,
    2767,  1898,  1972,  3335,  3335,  3335,  3335,     0,  1956,  1958,
    1959,     0,  2031,  2029,  1491,  1493,  3372,  2030,  2033,  2032,
    2027,  2000,  1997,  3345,     0,  3276,  1996,  1999,  1990,  1968,
    1986,  1992,  1993,  2003,  1994,  1988,  2007,  2008,     0,  1975,
    2726,  2896,  2726,  2896,     0,  2785,  2078,  2070,  2071,  2069,
    2075,     0,  2188,  2193,  2096,     0,  2125,  2131,  2136,  2145,
    2148,  2149,  3305,  3420,  2141,  3423,  2146,     0,     0,  2210,
    2212,     0,  2205,  2219,  2206,  2207,  2198,  2201,  2219,     0,
    2993,  2484,   365,  2478,     0,  3323,  2481,     0,  2726,  3383,
    3383,     0,  2274,  2275,  2775,  2303,  2305,  2306,  2302,     0,
       0,  3374,     0,  2354,  2336,  2349,  2342,  2338,  2351,     0,
    1577,  1577,  2363,  2372,  2369,  2753,  2744,  2752,  2745,  2750,
    2388,  2391,     0,  2418,  2419,  3350,  2424,  3372,  3372,  2461,
    2505,  2496,  2500,  2501,  2502,  2503,  2494,  1577,  1577,  2530,
    2741,  2738,  3333,  2538,  2537,  2539,  2726,  3156,  2726,     0,
    3123,  2573,  3317,  2780,  3317,  2735,  2634,  2631,  2630,  3352,
    1823,  3317,  2229,  2662,     0,  1577,  2406,  1577,  2409,  2518,
    2521,  2519,  3054,  2642,  2699,  3431,     0,  2697,  1571,   571,
     569,     0,   623,   979,   623,  3240,     0,     0,   942,   939,
       0,     0,   670,   907,   963,   964,   965,   966,   967,   962,
     968,   961,   960,   958,   959,   969,  3306,   756,  2812,   971,
    2811,  2813,     0,     0,   732,   734,  3317,   872,  3421,   877,
    3421,     0,  3374,   767,   762,   766,   970,   736,     0,  3026,
     770,   774,     0,   773,   772,  3427,     0,  3333,     0,   909,
    3274,   910,   914,   923,     0,  1100,  1096,  3403,   829,   828,
     821,   820,   827,   826,   825,   824,   823,   822,   785,     0,
       0,   801,     0,   803,     0,  3423,   913,   924,   932,     0,
     740,     0,     0,   739,   737,  3293,   863,   864,   681,   680,
     685,     0,   519,     0,   556,  2932,  3359,   540,     0,   522,
    3407,   549,   551,   555,   554,   550,   552,   548,   553,     0,
       0,  3333,  3333,  3348,   345,   402,  3333,  3393,  3333,  3333,
    3333,  3333,   421,  3278,   422,     0,     0,     0,  3333,  3364,
     365,  3288,     0,     0,   458,   467,     0,   468,     0,   146,
     147,   485,   486,   487,   478,   480,     0,   483,   477,   159,
       0,    28,    31,  1534,  3333,     0,  1549,  1540,  1545,  1537,
    1538,  1554,  2709,  1735,  3464,  3465,  2779,  1751,  1740,  1687,
       0,  1705,  1769,  3083,  3325,  3158,  3105,  1815,  1870,  2347,
    2346,  3431,     0,     0,     0,     0,  1965,  1960,  3308,  3347,
    3346,     0,  1989,  3335,  1987,  2002,  2001,  2004,     0,     0,
    1995,  2040,     0,  2039,     0,  2077,  2084,  2185,     0,  2184,
    1937,  2097,  2099,  2100,  1577,  2150,     0,     0,  2219,  2991,
    2992,  2219,     0,  3329,  3329,  2204,  2220,  2221,  2202,  2208,
    2203,     0,     0,  2487,  3333,  2477,  3324,  1220,  2259,  3384,
     424,   425,   426,     0,  2295,  3435,  2293,  2294,  2292,  3434,
    2266,  2276,  2277,  2279,     0,     0,  2304,  2300,  2319,  2321,
       0,  2339,  3333,  2762,  2337,  2350,     0,     0,     0,  2353,
    2374,  2371,  2367,  2373,  2368,  2370,  2392,  3351,  2430,     0,
       0,  2743,  2740,  2736,  2742,  2737,  2739,     0,  2548,  3158,
    2547,  2562,  2572,     0,  2576,     0,  2568,  1577,  1577,  2625,
    2636,  2759,  2756,  2635,  3353,  3354,  2629,  1817,  1818,     0,
       0,     0,  2662,  3372,  2232,  2243,  2402,  2410,  2645,     0,
       0,  2587,  1570,     0,   572,   570,   983,   986,  3240,   940,
       0,   936,   943,   944,     0,     0,   684,  3372,   679,   682,
     672,  2829,  2831,  2834,  2832,  2833,  2835,  2836,  2837,  2838,
    2828,  2830,  2823,  2827,  2825,  2826,  2822,  2824,  2815,  2816,
       0,  2819,  2818,  2983,     0,     0,     0,   874,  3422,     0,
     875,   878,   865,     0,     0,     0,   755,   753,   754,   843,
     954,     0,  2866,   927,   918,   912,   917,   915,     0,     0,
     920,   911,  1099,     0,  1097,   802,  1207,  1203,  1204,  1197,
    1201,  1209,  1195,   854,  1202,  1194,   861,  1200,   809,  1196,
    1198,  1199,  1208,   806,   808,  1205,   810,  1206,   805,   813,
     812,   841,   839,  3421,     0,   742,   975,     0,   748,   751,
     750,   747,  3155,   686,   530,   521,   520,   518,   558,   539,
    3295,   527,   536,   533,   537,   532,     0,     0,  3333,   348,
     347,   323,   346,     0,   401,   397,     0,   404,     0,     0,
    3279,  3280,   420,   423,  3295,     0,     0,  3333,     0,   400,
     427,     0,   470,   235,     0,     0,     0,   481,   484,  1528,
       0,  3333,  1544,  1550,     0,  1555,  1524,  1707,  3326,     0,
    3325,  2726,  1827,  1973,  1964,  1963,  1961,  1962,  2010,     0,
    3335,  2005,  2006,  2726,  2726,     0,  2090,  1938,  2098,  2130,
       0,  2160,  2200,  2211,  2219,  3330,     0,     0,  2222,  2223,
    3333,  2485,     0,     0,  2475,   366,     0,     0,  2479,  2290,
    3385,  2287,  2289,  2288,  2281,  2286,  2278,     0,  2284,  2282,
    2283,  2280,     0,     0,  2341,     0,  2332,  2357,  2751,  2748,
    2356,  2340,  2352,  2458,  2459,  2541,  2726,  2578,  2580,  2758,
    2761,  2754,  2760,  2755,  2757,  1819,  1820,     0,  1821,  2952,
    2951,  3024,  1825,  1824,  1826,  2781,  2232,     0,     0,  2717,
    2653,  2646,  2647,     0,     0,  2701,  2702,  3333,  2595,  1572,
     574,   988,  1125,     0,   948,   947,   949,  3333,     0,  2817,
    2821,  2820,   735,   881,   873,     0,   882,  3374,  3374,   884,
     765,  3333,   769,   768,  3372,   844,   842,     0,     0,     0,
     952,     0,   922,     0,   919,     0,   916,  1101,   855,   856,
     860,   859,   858,   857,   807,   862,   811,   925,   926,   749,
       0,     0,   541,   542,   543,   544,     0,   525,  3316,   529,
       0,   353,   354,   352,   351,   430,     0,   337,   338,   339,
     333,   334,   328,   340,   341,   329,     0,   342,   343,   332,
     330,   331,   336,   335,     0,   322,   326,   327,   324,   431,
     403,     0,   411,   419,   432,   433,  2926,     0,  3333,     0,
       0,  3333,  3333,   482,  1551,  1541,  1542,  1546,     0,  1547,
       0,  1559,     0,     0,  1770,  1836,  3331,  2009,     0,  2042,
    2041,  2194,  2151,  2218,  2225,  2224,     0,  2488,  3333,  3333,
    3333,   367,  3386,  2285,  2291,     0,  2322,  2976,  2975,  2977,
       0,  2355,  2746,  2747,  2749,  2549,  1822,  2230,  2663,  2664,
    3333,  2233,  2234,  2236,  2241,  3333,  2657,  2648,  2652,     0,
    2651,  2649,  2703,     0,  3284,  2622,  2621,  2596,  2588,  2589,
    3272,  2590,  2591,  2592,  2593,     0,     0,     0,  3313,   987,
    1127,  3430,     0,   946,     0,   683,   883,   884,     0,     0,
    3291,   869,   889,   890,   891,  3348,   888,     0,   848,   845,
     849,   956,   955,   957,     0,   953,   928,   921,   547,   546,
    3283,  3374,   523,  3295,   528,   411,     0,  3311,  3481,  3482,
     319,   318,     0,   408,   407,   406,   409,   405,  3333,   413,
     356,   415,  2927,   379,   388,   395,   388,   384,     0,     0,
     428,  3048,  3048,  3240,  1543,  1535,     0,  1559,  1580,     0,
    3159,  1577,  1577,  1793,  1843,  1839,  1577,  3372,  3332,  1830,
    1835,  1834,  1829,     0,  1991,  2486,     0,     0,     0,   368,
    2978,  2979,  2980,  2320,  2717,  2665,     0,  2235,     0,  3372,
    2668,  2650,  2694,     0,  3409,  2619,  2616,  2617,     0,  3374,
     575,   573,  3247,  3329,   990,   989,     0,  1131,  1126,  1128,
       0,   950,   945,   871,   884,   879,  3048,   885,   892,  3333,
       0,   764,   850,   846,   951,  3034,  3036,     0,     0,   525,
    3125,   321,   344,   320,   414,   358,  3125,   357,   412,     0,
    3360,   386,   391,     0,   387,     0,   385,   373,   429,   148,
     149,    34,     0,  1580,  3157,  1845,  1842,  1837,  1844,  1838,
    1840,  1841,     0,  1828,  2489,   369,   370,  2231,  2667,  2666,
    2655,     0,  3372,  2678,  2717,     0,  3410,     0,     0,  2620,
    2618,  2614,  2613,  2612,     0,   596,     0,     0,     0,  1132,
       0,  1129,   870,   898,   899,   901,  3048,   887,  3035,   545,
     526,   524,   356,     0,  3333,   410,   417,   418,   416,  3361,
       0,   394,   396,  3333,  1556,  1831,     0,     0,  3333,  2654,
    2658,  2659,  3333,     0,     0,  2643,  2695,  2615,  3457,  3456,
    3387,  2905,     0,  2608,  2602,  2603,  2605,  3333,     0,     0,
       0,     0,   577,   597,   598,   579,   607,   991,  1137,  1138,
       0,  1130,   900,   893,  2928,   361,  3127,     0,     0,     0,
       0,     0,  3333,  3333,     0,  2660,     0,  2669,  2670,  3333,
       0,     0,  2679,  2680,  2682,  2717,  3388,  3374,  2906,  2611,
    2606,  2609,     0,  2604,  3333,     0,     0,  3333,  3333,  3333,
    3333,   599,     0,  3363,     0,  3414,     0,   576,   580,   582,
     581,     0,     0,     0,     0,     0,     0,     0,   578,   608,
     610,   609,     0,     0,     0,  1190,     0,  1135,  1192,  2929,
       0,   355,  3126,   359,     0,  3466,  3467,   392,  1548,  1557,
       0,     0,  2656,  2661,  2671,     0,  2675,  2677,  2676,  2673,
    2673,  2687,  2683,  3076,  3077,  3074,  3075,  2684,  2688,  2681,
    2644,     0,  2610,  2607,     0,     0,   605,     0,     0,     0,
       0,  3333,  3333,  3333,  3333,  3333,   583,     0,  3333,  3333,
    3333,  3333,  3333,  3333,  3333,  3333,  3333,  3333,  3333,   611,
       0,  3333,     0,  3333,  1161,  3333,  1149,  1150,  1151,  1142,
    3427,  1143,  3368,  3368,  3333,  3335,  3307,  3333,     0,  1166,
    1159,  1146,  1160,  3368,  3335,  1147,     0,     0,  1158,  1168,
    1165,  1163,  3335,  1148,  1162,     0,  1169,  1157,  3333,     0,
    3333,  1184,  1178,     0,  1182,  1181,  1179,  1139,  1183,     0,
    1185,  1180,  1164,  1152,     0,  3368,  1193,  1211,  1210,  3137,
       0,   392,   389,   393,     0,   371,   372,  2672,  2686,  2674,
    2685,     0,  2601,  2598,  2600,  2599,  2594,  2597,   600,  3421,
     604,   602,   606,   601,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   995,  3248,  3338,  3338,  3355,   994,   998,
     999,  1028,     0,     0,     0,     0,  1140,  1141,  1174,  3333,
    1172,  3333,     0,     0,  1144,  1145,     0,  1187,  1170,     0,
    3421,  3333,     0,  1188,     0,  1186,  1191,   779,   780,   781,
     782,   775,  1189,  1516,  1173,  1138,  3137,     0,   242,   243,
     363,   390,  1558,  2689,   896,   592,   588,   589,   593,   591,
       0,   594,   584,   590,   585,   586,   587,   616,   612,   613,
     617,   615,     0,   614,  3497,  3498,  3338,  3338,     0,   992,
     996,  3333,  1004,  1000,  1002,  1003,  1005,  1007,  1177,  1512,
    1508,  1175,  1155,  1156,  1176,  1171,  1505,  1515,     0,  1154,
    1153,   776,  1190,   362,   603,   897,     0,     0,  3356,  3357,
    3059,  1015,  1010,  3352,  1014,  3058,  1013,     0,  1029,     0,
    1001,  1006,  1500,  1497,  1501,  1498,  1513,  1496,  1514,  1499,
       0,  1509,  1510,     0,  1506,  1504,  1502,  1503,  1167,     0,
     618,  1008,  3353,  3354,  1009,  1012,     0,     0,  1030,   639,
     997,  1511,  1507,     0,     0,  3333,  3333,     0,  3333,  1016,
    1017,  1018,  1019,  1020,  1021,  1011,     0,  1032,  3249,  1033,
       0,  3484,  3483,  3333,     0,     0,  3486,     0,  3333,  3333,
       0,   777,     0,     0,  1027,  1023,  3485,     0,     0,  1022,
    1088,  3445,  3444,  3327,  3368,  3274,  3333,     0,  1087,  3333,
    3372,  3333,  1038,  1040,  1039,  1041,  1050,  1042,  1044,     0,
    1047,  1034,  1035,  1036,  1046,  1048,     0,  1051,  1037,  1105,
    1043,     0,  1045,  1049,  1031,  3448,  3449,  3368,     0,  1024,
    1026,  1025,  3328,  1122,  3371,  3370,  3338,  1104,     0,   874,
       0,     0,     0,   934,  3366,  3366,     0,     0,  1107,  1102,
    1105,     0,  1495,  1109,  1117,  1118,     0,  1120,  1111,   595,
    1103,  1075,  1073,  1074,  1069,  1072,     0,  1070,  3421,  3142,
    1077,  2963,  3488,     0,     0,  3490,  3492,     0,  3496,  3494,
    1052,  1057,  3376,  3376,  1054,  1058,  1053,  1059,  3367,  1089,
    1089,  3366,  3366,  1082,  1106,  1108,  1119,  1116,  1115,  1113,
    1114,  3338,  1112,  1071,   878,  1121,  3374,     0,  1076,  2964,
    3487,  3491,  3489,  3495,  3493,  3378,  3377,  1060,  1065,  1093,
    1091,  1083,  1089,  1092,  1085,     0,     0,  1110,   867,     0,
    1079,  1063,  1055,  1063,  1068,  1063,  1056,  1063,  1090,  1084,
    1086,     0,   866,  1081,  1078,  1080,     0,  1062,  1061,  1067,
    1066,   868,  1064
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -3999, -3999, -3999, -3999, -3999, -3999, -3999,  3585, -3999, -3999,
   -3999, -3999, -3999, -3999,  -103, -3999,   550, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999,  1098, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999,  2667, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999,  3556,  3428,   234,
   -3999, -3999, -3999,  3275, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999,  3601, -3999, -3999, -3999,
    2368, -3999, -3999,  3526, -3999,  1797, -3999, -3999, -3999, -3999,
   -3999, -3999,  3321,   147, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999,  3404, -3999,   574, -3999, -3999, -3999,  3323, -3999,
    1116, -3999, -3999,  3527, -3999, -3999, -1019, -3999, -3999,  3292,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
    2829, -3999,  2407, -3999, -3999,  -743, -3999,  3464,  3107, -3999,
   -3999, -3999,  3329, -3999, -3999, -3999, -3999,  3414, -3999, -3999,
    3109,  2344, -3999, -3999, -3999,  2366, -3999,  2440, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,  -671, -3999,
   -3999, -3999, -3999, -3999,  1156, -3999, -3999, -3999, -2369, -3999,
   -3999, -3999, -3999, -3999,  -514,  -906, -3915, -3999, -3999,   201,
   -3999, -3999, -3999, -3999, -3999,  -488, -3999, -3999, -3999,  -600,
   -3999, -3999, -3999, -3999,   195, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999,  3137, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999,   613, -3999, -3999, -3999, -3999,  2824, -3999,
   -3999, -3999,   187, -2305, -3999, -3999, -3999, -3999,  3610, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999,  -580, -3999,  -319, -3999, -3999, -3999,   229, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999,  -745, -3999, -3999, -3999,  -689,
   -3999, -3999,  -753, -3999, -3999, -3999, -3999, -1635, -3999, -3999,
    2916, -3999, -3459, -3999, -3865,  -738, -3999, -1040,  1409, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3589, -3999,
   -3999, -3999,   343, -2258, -3999, -3999,  1249, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999,  1923, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3998, -3999, -3999,
   -3999, -3999, -1089, -3999, -1088, -1482, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999,  1243,  1244, -3999, -3999, -3026, -3999,
   -3999, -3999, -3999, -3999, -3548, -3999, -1207, -3999, -3999, -2499,
   -3999,  -542,  -425, -3999,  1549, -3999, -3816, -3999,  -613, -2641,
   -3999, -3999, -2640, -3999, -3999, -3999,   314, -3999, -3999, -3999,
   -2744,   317,   316, -3999, -1075, -2797, -2411, -3999, -3999, -3999,
   -3999, -3999,   836, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999,  1187, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,  -973,
   -2316, -3999, -3999, -1034, -1928, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -2225, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -2555, -3999, -1068, -3999,   809, -3999, -3999, -3999, -3999, -1129,
   -3999, -3999, -3999, -3999, -3999, -3999, -1132, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999,  -504, -3999, -3999, -3999,  -919,
   -3999, -3999, -3999, -3999,  -643, -3999,  3021, -3999,  -828, -1595,
   -3999,  -691, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999,  2121,  2681,   781,  -783,
    -781, -3999, -2624, -3999,  -954, -3999, -3999, -3999, -3999,  -786,
   -3999,  -817, -3999, -3999, -3999,  1905, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999,   -76, -3999, -3999,  1213,  -428, -3999, -3999,
      95,   254, -3999, -3999,  -284, -3999, -3999, -3999, -3999, -3524,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -1160,
   -3999, -3999,  -160, -3999,  3482, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999,  -832, -1617, -3999,  2487, -3999,
    2484, -3999,   650, -3999,  -784, -3999, -3999, -1023, -3999, -3999,
     660,  2479, -1252,  1883, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999,  1783,  1142, -3999, -3999, -3999,  2841, -3999,
   -3999, -3999, -3999, -3999, -1601, -3999, -3999,  1225, -3999, -3999,
   -3999, -3999,   244, -3999, -3999,   116, -3999, -3999, -1109, -3999,
   -3999, -3999,  -423, -3999,  -420, -3999, -3999, -3999, -3999, -3999,
    2838, -3999, -3999, -3999, -3999,  2423, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,  3074, -3999,
   -3999, -3999, -3999, -3999,  2371, -3999,  2798, -3999, -3999,  2399,
   -3999, -3999,  1740, -3999,   230, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999,  1719, -3999, -3999, -3999, -3999,   617, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,  2789,  1135,
    3070, -2469, -2830, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -1887, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,  2374,
   -3999, -3999,  2372, -3999, -3999, -3999, -3999,  1096,   591, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,   237,
   -3999, -3999, -3999,  2773, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999,  1673, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999,   582, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
     584,  2343, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999,  2752, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -2546, -3999, -3999,  1644, -3999, -3999,   570, -3999,
    1071, -3999, -3999, -2883,   231,   239, -3999, -3999, -3999, -3999,
   -3999, -3999,  -115, -3999,  -279,  2066, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999,  2745, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999,   219, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3567,  1534, -3999, -3999, -3999,   562,
   -3999, -3999, -3999, -3999, -3999,  2782,  2741, -3999, -3999, -3999,
    1504, -3999, -3999, -3999, -1387,  1054, -3999, -3999,   565, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,   553,
   -3999,   555, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999,   996, -2436, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999,  2079, -3999,   988, -3999,  2088,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999,  2149, -3999, -3999,
   -3999, -3999, -3999, -3999,  -161, -3999, -3999, -3999, -3999,  1485,
   -3999, -3999, -3999,  2731, -3999,  2733, -3999, -3999, -3999, -3999,
    3111, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
     997, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,  2127,
   -3999, -3999,  1488, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999,   540, -3999,  1489, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999, -3999,
   -3999, -3999,  -503, -3999, -3999, -3999, -3999, -3999, -3999,  -363,
   -3999, -3999, -3999, -3999,  -530,  1533,  1548, -3999, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -3999,   -65, -3999, -3999,
   -3999, -3999, -3999,  -482,   207, -3999,  -218, -3999, -3999,  -526,
    -598, -3847, -3999, -3999,  -528, -3999, -3999,  2111, -3999, -3999,
   -3999, -3999, -3999, -3999, -3999, -3999, -1606, -3999,  1328, -3999,
   -3999,  1332, -3999, -1310, -3999,  2488, -3999,  2486, -1844, -3999,
    1264, -3999,  1268,   569, -3999,   585, -3999,   588, -3999, -3999,
   -3999, -2595,    -9, -2172, -3999, -3999,   240, -3999,   242, -2200,
     578, -3999,  1238, -3999,  1245,  2963, -1476,  3166,  -109, -1970,
   -2237,  -650, -1909, -3999, -3999,  2458, -2462, -3999, -3999, -3999,
   -3999,   190, -3999, -1370, -1375, -1990,  1081,  1093,  1094,  1095,
    1317, -1817,  -467,  1425,  1642, -3999,  1777,    -4, -1172,  -629,
    -684,  3169,  2754, -1087, -3999,  -257,  1478,  -712, -3999, -1025,
   -3999,  1790, -3999,  -557, -3999,  2560,   472,  -131, -3999, -3999,
   -1192, -3999,   929, -2251,   -43,  1416,  3586,  -612,  -560, -3999,
    -587,   223,     1, -3207,  2814, -3999, -1157, -3259, -3999,    37,
   -3999,    38, -3999,  1587,  -997, -1968, -2826, -2721, -3999,  -670,
    2584, -3999, -2312, -2452, -2939,  -206,  -599,  -693,  -754,  -607,
   -3999, -2612, -3999, -2841,   512,  3656,  -782, -3999, -3999,  -318,
   -3999, -2207, -3999, -1705,    26, -3696, -3999,  1411,  -774,  -848,
    -175,  3096, -3057, -2153,  3116,   977,  -223,  3809,  -314,  -642,
     785, -3999, -3999, -3999, -1128,  3046, -3999, -3999, -3999, -3999,
    1455, -3999, -3999,  2163, -3999,  -322, -3999, -3999, -3999, -3999,
    1590, -3999, -2515, -3999,  1304,   971,   643,   318, -3999, -3999,
   -3999,    12,  -708,  -230,  2747, -3999,  -561,  -838,  -739, -3999,
   -3999, -3999, -1724, -3999,  -155, -2356,   771, -3999,  1471, -3444,
   -3999, -3999, -3999, -1676, -1747, -1097,  -690, -1191, -3999, -3999,
     741, -3999, -3999,  -199,  -198, -3999, -2110,   950, -3999,   119,
   -3999, -3270, -3999,   -15, -1978, -2403, -3999, -3999, -2597, -3999,
    -762, -3999, -3999, -3999,  3099, -1686, -2396, -1802,  -872,  -827,
    -726,  -927,  3617,   719, -3999, -3999,  3604, -3999,  -871, -3999,
   -3999, -3999,  -118, -3999,   520, -3999,  1579, -3814, -3999, -3999,
   -3999, -3245,  -685,  1915,   579, -3999,  -272, -3999, -3999,  1000,
   -3999, -1759, -3999, -1265, -3999,  2690, -3999, -3999, -3999,  -663,
   -3999,  -750,  -477, -3999,  2192,  1462, -3999, -3999,   171, -3999,
   -3235,  -868, -3999, -3999, -3999, -3999, -3999, -3999
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
       0,     1,     2,     4,     5,     6,    18,    19,     7,     8,
      20,    21,   126,   127,   128,   182,   131,   185,    22,   828,
    1824,    23,   829,  1825,  3053,  3480,    10,    11,    53,   121,
     179,   575,   576,   825,   827,  1246,    13,    46,   141,    24,
      25,    42,    26,    38,    39,    40,    41,   124,   246,   181,
     242,   344,   345,   346,    14,    44,    45,   137,    62,   140,
     254,   190,   586,    29,    30,    31,  1248,    48,    49,    50,
      51,    91,    92,    93,  2509,    94,   217,   306,   558,    95,
     214,   291,   292,   293,   294,   295,   548,  1242,  1818,   296,
     297,  1238,   298,  3478,    96,   215,   303,   304,   305,   553,
      97,    98,    99,   100,   101,   175,   102,   228,   572,   229,
     230,   103,   201,   272,   524,   525,   273,   274,  1222,  1230,
    1223,  1224,  1225,  2502,  3043,  2682,  4640,   203,   177,   104,
     105,   311,   312,   313,   821,   106,   219,   220,   107,   529,
     530,  3471,   109,   224,   325,  3472,   534,  3473,   112,   113,
     114,   115,   116,   117,   169,    69,    70,    71,   148,   200,
     269,   511,  1787,  2486,  2487,  3004,  3005,  4004,  4005,  4006,
    4007,  4008,  3781,  3782,  1205,  3006,  3984,  3007,  4246,  4247,
    4314,  3008,  4431,  3009,  2721,  3564,  3855,  3011,   239,  3012,
    3013,  3014,  3015,  4157,  4251,  4552,  4252,  4254,  3016,  3017,
    3018,  3019,  4011,  4147,  3020,  4150,  4151,  4248,  4249,  4316,
    3021,  3022,  3453,  3023,  3232,  3024,  3800,  3025,  3026,  3027,
    3028,   270,   271,   516,   517,   518,   519,   790,   520,   521,
     522,   783,  3038,  3039,  3467,   523,   785,  1805,  1249,  3050,
    3474,  3475,  3476,  3477,    64,   263,    65,    66,  2511,   143,
     144,   196,   264,   265,   767,   266,  1184,  1774,  1775,  3767,
    1776,  4132,  3979,  3422,  1777,  1778,  2981,  3773,  1779,  1780,
    3769,  3972,  3973,  3974,  3975,  1781,  3437,  3438,  1782,  3424,
    1783,  1784,  2481,   747,   748,  2388,  2841,  3320,  3321,  3322,
    3920,  4098,  4210,  4407,  4408,  4409,  4410,  4352,  4353,  4354,
    4418,  4419,  4420,  4421,   503,   504,  1751,   505,   506,   752,
     753,  1762,   754,  1179,  1180,   221,  2463,  2947,  2289,  2290,
    2291,  2292,  2293,   755,  3332,   756,  1757,  1172,   757,  1758,
    2959,  3668,  3419,  2948,  2426,  2427,  2428,  2429,  2430,  3354,
    3355,  2431,  2432,  3414,  2433,  3410,  2397,  2434,  2435,  3412,
    3761,  2436,  3368,  3707,  2437,  2876,  2438,  2439,  2885,  3364,
    3704,  3943,  2440,  2441,  4532,  4533,  4631,  2944,  3403,  3401,
    3374,  3946,  3947,  4233,  2294,  2295,  3964,  3966,  2443,  3365,
    4796,  4932,  2444,  3697,  3360,  2883,  3939,  3357,  4107,  4111,
    4230,  4112,  4113,  4114,  4115,  4694,  4116,  4303,  4304,  2445,
    2446,  2894,  2447,  2448,  2449,  3381,  3382,  2450,  3720,  3956,
    3377,  3406,  3407,  3712,  2395,  2949,  3408,  4800,  2396,  3328,
    2860,  2861,  2862,  3661,  3662,  3663,  3926,  4103,  2451,  3710,
    3949,  2452,  3343,  2453,  3341,  2454,  2455,  2456,  2457,  2458,
    2459,  1169,  1170,  2842,  1755,  1756,  3324,  2392,  2844,  3921,
    4099,  4215,  4297,  4424,  4493,  4598,  4599,  4673,  4674,  4675,
    4676,  4600,  4701,  4702,  4703,  4731,  4749,  4750,  4751,  4752,
    4753,  4754,  4669,  4708,  4759,  4771,  4801,  4802,  4870,  4922,
    4937,  4926,  4803,  4854,  4855,  4804,  4898,  4934,  4805,  4806,
    4911,  4912,  2460,  2903,  2904,  3385,  3724,  4808,  4809,  4839,
    4840,  4810,  4811,  4891,  4892,  4843,  4844,  4845,  4812,  4813,
    2846,  3326,  4100,  4218,  4219,  4220,  4359,  4360,  4549,  4425,
    4537,  4538,  4539,  4427,  3750,  4546,  1031,  4635,  1614,  1615,
    1616,  1617,  2241,  1585,  2242,  1586,  2243,  1587,  2244,  1588,
    2245,  1589,  2246,  1590,  2247,  1591,  2248,  2249,  1592,  2250,
    1593,  2251,  1594,  1595,  2252,  1596,  2253,  1597,  1598,  2254,
    1599,  2255,  1600,  2728,  2127,  1601,  1602,  1606,  1607,  2652,
    2653,  4841,  4842,  4717,  4718,  4719,  4685,  4726,  4727,  4610,
    4723,  4608,  4720,  4540,  4541,  2512,   192,   193,   257,   587,
    3063,  4031,   194,  1829,  2519,  2518,  3056,  3057,  3058,  3486,
    3487,  3488,  4165,  3814,  2521,  3816,  4030,  4371,  4554,   744,
    1150,  1750,  1151,  1152,  2385,  3652,  1153,  1154,  2839,  2008,
    2009,  2636,  1155,   259,   429,   700,   430,   668,   841,  1255,
    2570,   842,   843,   844,  2689,  1269,  1891,  1892,  1260,  1261,
    1262,  3093,  3094,  1919,  3168,  1842,  1843,  1264,  1883,  3066,
    3067,  4542,  2041,  1886,  1254,   431,   669,   877,  1293,  1291,
     432,   670,   894,  1979,  2610,   433,   671,   909,   910,  1981,
     434,   672,   915,  2613,  1252,  1826,  2517,   837,   838,  1983,
    1984,  2616,  2821,  3300,  3637,  3638,  3639,  4035,  1019,  4182,
    4173,  4269,  4174,  4267,  4175,  1328,   435,   673,   920,   921,
     922,   436,   674,   926,   927,  1335,   928,  1331,  2618,   437,
     675,   931,  1340,   438,   439,   676,   941,  1349,   440,   678,
     946,   441,   677,   943,  1350,  1353,   442,   679,   953,  2003,
     954,   443,   680,   965,   966,   967,   968,  1380,   969,  1382,
    2042,  2018,  2019,  3836,  2020,  2641,   970,  1363,   971,   972,
     973,  2045,  2046,   974,  2635,  3148,  3149,  3150,   975,  1384,
    2663,   976,   977,  2634,  3511,   978,  2664,   979,  1365,  2050,
    1032,  3169,  3170,  3171,  3172,  3173,  3528,  3174,  3175,  3176,
    3177,  2043,  1369,   444,   681,   984,  1392,   445,   682,   446,
     447,   724,  2355,  1133,  2819,   448,   683,   989,   990,   991,
    1399,  1400,  1401,  2064,  1402,  2061,  2677,  2673,  2674,  3186,
    1396,   449,   685,  1000,  2101,  1001,  1431,  3195,  3540,  3541,
     450,   686,  1007,  1020,   451,   687,  1008,   452,   688,  1011,
     453,   689,  1014,  2106,   454,   690,   455,   691,  2111,  1441,
    2112,  2694,  2696,   456,   692,  1024,  1442,  2121,  2700,  3200,
    3201,  3202,  3204,   457,   693,  1027,   458,   694,  1033,   459,
     695,  1036,  1037,   995,  2138,   460,   684,  1429,  2100,  2688,
    2099,  3539,  2683,  2139,  2719,  2140,  2141,  3216,  3217,  2716,
    2717,  2718,  3210,  3555,  3556,  3557,   461,   462,  1134,  1725,
    3642,  4194,  3909,  4071,  4072,  2358,   463,  1135,  1727,  3303,
     464,   696,   465,   697,  1044,  1621,   466,   698,  1046,   467,
     699,  1048,  1625,   468,   701,  1052,  1053,  1054,  1632,  2261,
    3580,  3581,  3871,  3864,  3865,  3582,  3583,   469,   702,  1056,
    2741,  2742,  3587,  3238,  1637,  1638,  1639,  2744,  2746,  2747,
    3873,   470,   703,   471,   704,  1062,  4205,   472,   705,  1064,
    2307,  3243,  3244,  3245,  2000,  2001,  2002,  3594,  3247,  3593,
    3876,  1652,   473,   474,   706,  1066,  1660,  3252,  3604,  3253,
    3602,  3254,  1657,   475,   707,  1068,   476,   477,   708,  1071,
    1664,   478,   709,  1074,  2760,  2761,  1668,   479,   480,   481,
     728,  1136,  1137,  1729,  1734,  2365,  2825,  2827,  2828,  1732,
    2367,   482,   710,  1078,  1079,  3263,  1673,  1674,  1080,  2311,
    3266,   483,   711,  1085,   231,  1690,  1086,  1087,  2333,  2334,
    1088,  1089,  1090,  1091,  1092,  1093,  1094,  1095,   484,   712,
    1038,  3221,  1609,  3565,  2142,  2722,  3563,  3854,   485,   713,
    1104,  2336,  1698,  2791,  2792,  1694,   486,   487,  1140,  1736,
    3309,   736,   737,   488,   714,  1106,  1107,  1108,  1702,  1703,
    2341,  3284,  2799,  1700,   489,   715,  1111,  1708,   490,   716,
    1114,   491,   717,  1115,   492,   718,  1117,   493,   719,  1120,
     494,   720,  1123,  1718,  2808,  2809,  2350,  2811,  3293,  3295,
    1716,   495,   721,  1127,  3653,  3918,  4088,  4089,  4090,  4566,
    4091,  4344,  4345,  4392,  4092,  4293,  4093,  4094,  4206,  4207,
    4095,   496,   722,  1129,  1662,  2353,  2354,  3629,  1721,   497,
     498,  1145,  1743,  3648,  4385,  3910,  3911,  3912,  4081,  4076,
    4329,  4200,  4330,  4331,  3644,  4068,  4069,  4283,  4377,  4378,
    4558,  4559,  4335,  4382,  4383,  4452,  4457,  2380,   499,  1146,
    1745,  4284,  2383,  2837,  3316,  3915,  2526,  3070,  2527,  2528,
    3064,  2529,  2530,  1373,  2012,  1374,  2010,  1375,  2596,  3118,
    2597,  3116,  2598,  3279,  3615,  3280,  3613,  3281,  2756,  3877,
    4063,  2757,  3256,  3257,  3630,  3893,  3631,  3891,  3632,  2629,
    2630,  3139,  2631,  3137,  2632,  1057,  2264,   738,  3080,  3302,
    1022,  1023,   993,   994,  1422,  1423,  3349,  3350,  3351,  3352,
    3688,  3689,  2069,  1424,  3691,  2090,  2091,  2092,  2093,  2094,
    1739,  2376,  1928,   896,   897,   898,   899,   878,   933,  1343,
    1075,  1076,  1138,  1793,  4289,  1794,   845,  1028,  1097,  1098,
    2103,  2104,  1436,  1640,   912,   913,  1788,  2973,  4153,  4363,
    1239,  2967,  2968,  2974,   151,  2482,   314,  1009,   935,  1378,
     980,   880,  3898,   881,   882,  4860,  1943,   902,  4056,  1893,
    2296,  3694,  1924,  2573,  3218,  2707,  3548,  1676,  3126,   923,
    1124,  1642,  1832,  2538,  2772,  2773,  2302,  1833,  1039,  1101,
    1118,  3068,  3900,  2880,  3370,   883,   740,   948,  4234,  4235,
     936,   937,   904,  2709,   741,  1240,  1241,  1817,  1143,  1144,
    1834,   822,  2540,  4706,   531,   326,   884,   328,   329,  4458,
     885,   886,   887,   888,  1299,  1278,  1951,  1935,  1936,  1947,
    1940,  1929,  1931,   758,  2810,  4312,  1323,  1965,  2606,  1655,
    1618,   770,  1346,  1994,   358,  3416,  3505,  3821,   665,   666,
     667,    34,   798,  1164,   765,  4211,  4593,  4757,  4594,   799,
     766,  1166,   500,  2817,  2553,  2478,  1208,  3792,  2889,  1265,
    1266,  3462,  1367,  3059,   299,   168,   549,  2466,  1357,  1887,
    3347,  2654,  1203,  1201,   204,  3980,  1058,  2126,  3226,  3819,
    4823,  3846,  4183,  1426,  2147,   565,  2152,  3521,  2566,  3608,
    3636,  4668,  3427,  4320,  4412,   187,  4879,  4609,  4826,  1191,
     786,  4907,   333,  3570,  4053,  4387,   300,  1888,  3031,  1714,
    2879,   155,  3389,  2462,   539,  4287,  2830,  4413,  1803,  1360,
    3205,  3699,  2655,  2551,  2869,  3665,  3178,  3585,  2109,  2759,
    2531,  1376,  4815,  4735,  4817,  4545,  1344,  4340,  3032,   283,
    2971,  3496,  4437,  1815,  2470,  1337,  2798,   889,  2493,  4142,
    4763,  4769,  4873,  4874,  4875,  4876,  4877,  4604
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
     232,   327,   566,   275,  1015,  1116,  1165,  1921,   535,   509,
     981,  1171,  1173,  1174,  1176,  1885,  1181,  1636,  1100,  2148,
    1273,  1711,  1808,  1069,   183,   208,  2386,   211,    60,  2745,
     152,  1735,   216,   992,   258,   559,   159,  2535,  2848,  2950,
    1997,  2348,  2536,  2070,  2646,  1187,   934,   170,  3367,  1192,
    1193,  2089,  1195,  1196,  2656,  1198,  1199,  1226,  1226,  1263,
    3096,   156,   157,   158,   119,  2964,  2965,  2901,   163,   330,
     132,  2532,  1686,  1355,   279,  3109,  2052,  2053,  2054,  2055,
    1025,  3196,   879,  1209,  2475,  1675,   560,  1188,  1189,  1040,
    1348,  3077,  1194,   161,   162,  1197,   164,   165,  2963,  1099,
    1295,  3083,  3378,  1338,  3383,  1040,  1795,  3219,  1797,  1798,
    2576,  1800,  1801,  2578,   911,  3701,  2387,  3317,  1287,  1319,
    1955,  2548,  2584,  2356,   188,  3722,  2588,  1010,  1112,  3223,
     178,  1950,  1010,  2591,  2645,  2758,  2795,  2859,   205,  2532,
     206,  1383,  3193,  1961,   212,   213,  3498,  2532,  2622,  3936,
    1934,  1010,  2675,  2739,   223,  2660,  3380,   197,   198,   199,
     233,  1952,  2265,  3258,  1347,  -847,   243,   149,   149,   248,
     361,  4637,   250,   930,   507,  3970,   917, -1527, -1525,   562,
     315,   550,   209,   316,   209,  4691,  4078,  1827,   276,   209,
     336,  1397,  4924,   945,  3241,  3179,   574,  1280,  1281,  4343,
    4143,  1665,   256,   895,  1747,  1286,   309,   260,   286,  4834,
    1889,  2072,  2073,  2074,  2667,  2685,  2014,   334,  2095,  2149,
    3859,   172,  2058,  3073,  3074,   830,  1821,   555,  2465,  3075,
    3076,   209,  3078,  1810,  1306,  2711,  2711,  2545, -3431,  1256,
     359,    72,  2068,  3902, -3020, -3431,  2347,  1920,   251,  2347,
    1326,   234,  4324,   823,  1348,   166,  2105, -3419,   347, -3431,
     562,   349,  4835, -3431,   512,  1040,  2065,  1611,  2765, -3021,
      75,  2135,  2556,  2766,   540,  4627,  4628,   764, -3431,   510,
    2442,  2549,  2308,  4472,  3847,  -847,  1370,  3286,  3287, -3374,
     570,   571,  2560,  3765,    75,  1742,  4227,    77, -3423,  4672,
    2564,  3525,  1370, -3031,  1061,  1922,   202,  4291, -3394,   536,
    2657,  2514,  1812,  3229,   202,  1444,  3248,  2075,  4921,  3713,
   -3291,    77,  2767,  2373,  4177,   277,  1182,    59,  1692,   749,
    2373,  3187,  1256, -3431,  3152,  3559,  2650,  3153,  2651,  3524,
    1584,  2712,  2712,  4724,  3157,  2793,    73,  3160,  3753,  3524,
     335,  4299,   911,   578,  2363,  2076,  1706,  2017, -3431,  4025,
     581, -3431,  2347,   184,   547,   807,  4453,  4164,  1309, -3431,
    1310,  1311,  1312,  1313,  1314,  1315,  4394, -3029,  2806,  4933,
    1379,    59,   562,  3924,  1857, -3431,   202,  2888,  3442,   286,
     908,  2978,  3573, -3293,  1061,  2124,  3446,  2956,  4079,  3450,
    3451,   267, -3389,  1710,    74,   261,   316,    75,   983,    76,
     839,  1029, -3122, -3431,  2734,  -778,  -778,   929,  2546,  2537,
     944,  4485,   -44,  1256,  3366,  1304, -3283,  4531,  1016,  1414,
   -3283,  2796,  3899,  3277,    77,  3061,  1760,  1084,  4295,   542,
    2647,  3489, -3431,    75,  3084,  2892, -1527, -1525,  1065,  1434,
   -3431,  1072, -1527, -1525,  2258,  4319,  1105,  2105,   235,  3449,
    4454,   997,  1121,  3621,  3957,  1434, -3433,   301,  1658,  2979,
      77,  1263, -3374,  3831,  4096,  3154, -3423,  1263,  2363,  4185,
    1683,  1226,  3944,   202,  2724,   122,  1633,    87,  3379,  2076,
    2950,  1925,    59,  3387,   725, -3431,  -886,  2637,  2638,  1995,
    2804,  3340,   281,  1040,  1427,  3299,   225,  4168,  3967,   800,
     801,  4217,   244,  4925,  2627,   908,  4202, -3283,  2866, -3293,
   -3122, -3283,  4553,   942,   806,   824,  2351,  4026,  3387,    78,
    4305,   809,  1010,  4451,  1437, -3348,  4761,  2344,   551,  1434,
    1890,  2096,  4423,  2373,  1371,  3578,  1669,  2565,  2373,  2266,
    4762, -1527, -1525,  3553,   225,  4380,  1991, -2421,  2713,  2713,
    3260,  3817, -2421,     3,   317,  1372, -3293,    79,   317,  2364,
    4629,  1267,  1922, -3431,  1748,  2483,  2077,  2078,  2473,  2352,
     563,  1372,  2267,  3387,  3718, -1527, -1525, -1527, -1525,  3307,
    2373,    79, -3431,  3242,  2373,  -325,  2016,  2373,  4557,   301,
    1722,  4144,  3574,  2859,  3219,  4423,  3554,  4305,    89,  3267,
    3268, -2421,  2497,  3388,  3452,  2373,  3143,   508, -2301,  4274,
    2150, -2213,     9,  4562,   316, -3431,  2373,    59,  2507,  3463,
    4217,  1234,  2484,   860,  2867,   861,  4553,  1428,  4836,   918,
     831,  4216,   318,  4263,  3526,  3537,   318,  3236,  3390,  4713,
   -3313,   123,  2628,  2686,  2079,  2080,  2097,  1336,   319, -3338,
    1923,   563,   319,   934,  2801,  3842,   900,  2725,  3843, -3431,
    1332,   932,   282,  2714,  2714,  1740,  3757,  3561,   245,  -886,
    1013,  3758,  1749,   932,  2565,  1351,  4237,  3490,   932,  3832,
    3899, -3432,   542,  2364,  4531,  2679,   905,   914,  3981, -2213,
    3845,   938,  3420,  3392,    79,  1813,  2648,   932,  2893,  1659,
    -778,   750,   268,   938,  1012, -2213,  2102,  2958,   938, -3313,
    2501, -3431,  1041,  2081, -3068,  4563,  3844,  1186,  3278,   316,
     726,  3575,   832,  1070,  2594,  1070,   339,  1102,  1041,   302,
      79,  3155,  4178,  3860,  4564,   533,  2665,   992,  1070,  2797,
    3211,  4455,   513,  1443,  1139,  3903,   930,  3121,  2082,   225,
    4216,   526, -3283,  1018,  2505,   934,   930,  2083,  2675,   868,
    2532,   286,   287,  4792,  1685, -3293,  2084,   840,  1016,  2583,
    2007,   533,  4049,   563,  2300,  1647,   812,  2601,   816,  1013,
    2136,   317,   225,  1142,  3334,  3335,  3336,   533,    80,  3270,
     225,  3759,  3062,  2508,  2532,   919,  2262,  3144,   533,  3248,
    1245,   533,  1206,   234,   997,  1939,  1939,  1939,  2515,  2085,
    2957,   320,   262, -1527, -1525,   320,   278,  1084,  4695,  1183,
    3576,  1960, -3291,  4888,  1645, -3291,  3230,   784,  2125, -2839,
     533,   350,  4738,   750,  1995,  4292,  3778, -3333,  3766,  1147,
     857,   858,  3522, -3283,  2066,  4725,   751,  4172, -1536,  2297,
     286, -3433,  3337,   207, -3293,  3313,  3430,  1741,  1738,   318,
    3861,   302, -3433,  4179,  2737,  3925,  2755,  1992, -2213,  2107,
    4032,  3203,  1996,  2143,  3431,   319,   900,   900,   900,   900,
    1013,  1999, -3419,   286,  4715,  1259,  4126, -3293,  1041,  4180,
    3338, -3333,  3432,  4565,   985,   340,  3708,  3527,  2563,  -244,
    1584,   288,  2086, -3431,   207, -3122, -3283, -3283,  4145,  3188,
     252,  1047,  1049,  2137,  4473,  3664,   833,  1923,   508,   932,
    2374,   834,  4456,   207,   316,   914,   514,  2374,  2550,  3807,
    3088,  4638,  2595,  4296,  2067,  2442,   207,  1148, -3291,   321,
    2639, -1568,  2697,   321,   764,  3971,   930,  3091,   533,   938,
      83,  4043,  3231,  4023,  1149,  4630,  2815,  2550,   515,   207,
    2950,   207,   533,   253,  1307,  3954,  3092,  2498,  2499,  1308,
    -325,   791,  3428,  1267,   835,   533,  1828,   316,   207,  1267,
    2642, -3297, -3333,  3524,   207,  2017,  2640,   934,  3878,   533,
     544,  3904, -3394,   236,   237,   932, -2213, -3283, -3283,   317,
    1807,  2257,   512,   207,  1791,  2980,  1792,  2516,   289,  1796,
     235,   932,  4395, -3122,  3716,  2375,   421,   322,  1806, -3389,
      59,   322, -3118,  1147,  1147,   938,   207,   533,  1082, -3293,
    -624,    86,  3823,  2151,  1819, -1536,  2086,   -44,   320,  1811,
    2087,   938,  2088,    87,  1341, -3348,  1789,  1790,  -325, -1568,
    1336,  1156,  4486,  1010,  2489,  2490,  1799,  1142,  2503,  3092,
    2495,  1881,  3420,  2496,  -325,  3577,   173,   836, -3291,  4146,
     934, -3291,   556,  1644, -2213,  4138, -3429,   318,   932,  3578,
    2004,    88,  1741,  1998,  4170,   932,  2715,  2715,  2687,  4139,
     310,  2098,  1294,   319,  4080,  -778,  3862,   792,  2021,  2600,
    1398,  3945,   207,  1018,   317,   207,  3982,   552,   938,   207,
     150,   150,  4639,  1434, -3431,   938,  2593,   508,   207,   207,
     324,  1148,  1148,   533,   324,   207,  1041,  3131,   900,  1990,
    4837,   428,  2574,  1814,   749,   533,    87,   317,  1149,  1149,
    2374, -3338,  2539,  2504,   287,  2374, -3431,   317,  3930, -3313,
   -1536,  3763,  1139,  3863,   238,  3512,  3513,  3514,  3515,  1786,
    1316,  3808, -2213,  3660,    89,  3562,   321,  4889,  4181,  1752,
    1317,   792,  3623,  2599,  3625,    90,  4347, -2213,  1030,  1687,
     207,  3641,   318,  4381, -3291,  2590,  1083,  2374,   567,   207,
   -2301,  2374,   533,  1294,  2374,  3794,  4154,  3323,   319,   316,
    4707,  4127,  3801,   209,   209,  3983,   860,  1425,   861, -1536,
     290,  2325,  2374,   209,  1636,   318,   860,  1820,   861,  3237,
    4264,  1822,  3760,  2374,  2016,   318,   207,  -325,   341,  2076,
    2326,   319,  1439,   287,  1835, -3116,  3695,  4700,  3448,  3145,
   -3120,   319,  3502,   532,   322,  -624,  1307,   508,  1084, -2421,
   -2421,  1308,   527,   342,  4348,  2506,   320,    89,  1622,  2690,
   -3431,   900,   900,   900,  2378,  2675,   287,  3411,   900,   900,
     900,  4858,  1041,  4050,  4064,  2015,  3146,  2145,  1954,  4041,
      59,  3530,  2580,   288,   900,  3433, -3114,   900,  3441, -3109,
    1670,  3597,   225,   900,   900,   900,   900,   900,   900,   900,
     900,   900,   900,   900,   900,  3048,  2769,  2604,  1957,   317,
     351,   352,   353,  3624,  4644,  3579,   508,    59,  3952,  4121,
     934,  1704,  4606,   533,  3598,  1294,  3531,  2144,  3533,  3491,
     900,  1055,  1040,  2873,   729,   900,  4366,   317,   793,  3250,
    3339,   225,   868,  2708,  1204,  2858, -3313,   324,  4201, -3122,
    4446,   918,   868,  1737,  2537,  -325, -3313,  2128,  1235,  1370,
    3072,   320,   317,  2113,  1157,  4687,  3110,  2114,  3261,  2693,
    2115,  2116,   288,    -7,  3568,  2477,  1158, -3431, -3431,  2874,
    1954,  2680,  4414,  3880,   321,  1159,   225,   318,   813,  4534,
     289,  2312,  3033,  3034,   320,  1393,  1890,  2572,  3036,  3037,
    2594,  3763,   331,   319,   320,   288,   860,   225,   861, -1494,
    1957,  3879,   793, -3431,  2612,   318,  2337,    36,  2698,  3598,
    3262,  3107, -3431,    12,  3114,  3115,  3387,  2701,  2304,   354,
    4890,   319,  3618,  -325,  3620,   343,  2972,  1013,  3434,  3098,
     318,  3100,  2723,  3958,  3102,   907, -3464,  3104,  3105,  3106,
   -3431,  3108,   914,  4905,  3112,  3484,   319,  3135,  3136,   998,
     918,  4155,   322,  3261,  2384,  3124,  3125,  4280,  4838,  3772,
    2297,  4492,  1333,  3435, -3431,  2371,  4447,  2724,  4051,   289,
    3950,  2776,  3436,   202,  3180,    15,  3182,  -325,  2789,   321,
     513,  3808,  3549,  2363,   541,  1126,   532, -3465,  2790,  1212,
     166,  -325,  4768,  3361,   930,  1956,  3189,  4909,  4229,  1370,
    4122,   342,   289,   730,  2317,  3262,  3147,   919,  1077,  4910,
    3507,  -325,   321,    28,  3197,  4010,  2494,  2574,  2494, -2908,
    2494,  2494,   321,  2494,  2494,  3829,  -325,   794,  1160,  4019,
   -3423,  4463,   868,  2327,  -624,   167,  3394,  2077,  2078,   930,
     323,  3978,  4713,  3228,  2708,   236,   237,  -624,    59,  4448,
     742,  4859,  4861,  1890, -3431,   324,   320,   322,  3959, -3072,
    3485,  3235,  2581, -3072,  3549,   734,  1837,  1213, -3431,  2803,
    1838,  2882,  3868,   543,   317,  3255,  2594,  4871,  4607,  3259,
      43,  4899,  1294,  1215,   320,  1161,   900,  1804,  4223,  3852,
     322,  1342,  2328,  4894,  -993,  4250,  2057,  2059,  2595,   932,
     322,   794,  1954,  2774,  3640,    27,   808,  4171,  2881,   320,
    3224,  1059,  2887,  3288,  -993,  2079,  2080,  3362,  2072,  2073,
    2074,  4367,    33,  4415,  2733,  1425,  1162,  2329,  1372,   938,
    3233,   533,  1957,  4442,  4156,  -993,  -993,  2488,   750,   795,
   -3313,   355,   356, -3431,  3779,  3306,  4534,  1297,  3762,  4414,
    2725,   751,   318, -3315,   357,   907,   907,   907,   907,   932,
     324,  2335,  4189,  1370,   514,  3960,  1321,  3655,   319,  3656,
     202,   544,  4906,  1334,  3251,  1156,  1010,  1434,   207,    37,
     202,  1307,   731,   343,   321,  1954,  1308,  1236,   207,   938,
    2146,  2749,   -69,   324,  2619, -3431,   515,   930,  2364,  4128,
    4129,  2900,  1603,   324,    47,  4302,   238,   225, -1983,  3951,
    2951,  2952,   321,   795,  2895,  1957,  1040,   900,  1394,  3780,
      52,  2372,  3961,  2399,  2075,  4795,  2021,  2461,  2464,   247,
    2467,  3120,   949,  2472,  2474,  2330,  2476,   321,  -624,  3044,
    1084,   533,   796,  1163,  4349,  2389,  1217,  3035, -3317,  4160,
     281,   950,   814,  3797,  1764,   207,   732,  2983,  4278,  3029,
     332,   532,   322,  4350,  4535,  4536,  3095,  2864,   533,  4257,
    1831,    16,  3298,    17,  1653,  1688,  2086,  3030,  1372,  3111,
    4351,  2626,  1237,  2608,  2595,  2868,   743,  4715,  2552,  2614,
     322,  3113,  3225,  3291,   209,    54,  2582,  2953,  4275,  4276,
    1765,  2858,   998,  4193,   207,   225,  1016,   207,   815,   225,
     733,  3853,  2541,  3599,   207,   322,   796,   207,  2542,  2771,
   -3431,  2543,  1646,  2544,  2875,  4123,  1689,  3549,   317,  2259,
    2539,   320,  4038,  3297,  3469,  3470,  2774, -3313,  2774,  -993,
    2539,  4203, -3122, -1519,  4110,  4221, -2908,  1679,  2331,   207,
     207,  1041,  4449,  4434,  2015,  2969,   207,   763,  3429,   207,
     207,  2117,  2118,   734,  4700,   324,  1766, -3431,    56,  1654,
     207, -3333,  2627,  4450,  1218,  3953,   533,   916,   207,  3363,
     202,  4900,   533,   207,  4712,   317,  3492, -1494,  4258,  2832,
    2834,  2323,   226,   324,  -993,   227,  2076,  4236,  4438,   207,
    4415,  2615,  1839,   207,  4172,  1704,   318,   907,  3599, -3464,
     951,  4881,  2345,  2119,  2120,  4416,  2708,  4776,   324,  3387,
     282,  1371,   319,   207, -3464,  3087,    59,  -993,  3464,  1132,
     317,   932,   207,   787,  4405,   932,   317,  2624,  2370,  -993,
      58,  3640,  1372,  3141,  2774,  2774, -3413,   176,  -993,   582,
     583,  4417,  2730,  3503,   860,  1041,   861,  4034,  2623,   321,
   -3465,   938,  3690,   318,  4882,   938,  4309,  3869,  2736,  4039,
    4040,  2522,  1647,  3627,  1925, -3465,   207,    59,  3870,   319,
    1370,  4682,  4833,  2077,  2078,  4355, -3431,   914,  1157,  2114,
    4689,   735,  2115,  2116,  2649,  1899,  4713,  3962,  2044,   860,
    1158,   861,  1900,  2659,  4356,  2755,  4435,  4236,   318,  1159,
    2628,  2087,  4436,  2088,   528,  4084,  2762,  3181,  1695,  3183,
    3147,  1645,  4065,  2332,   319,  1013,   207,  1604,    61,  3130,
     319,  4535,  4536, -1983,   932,  4716,  4721,   322, -3431,  3396,
     907,   907,   907,   788,   789, -1134,  2800,   907,   907,   907,
    1946,  4555,  4556,  1946,  1307,  1221,  1840,  1841,  2800,  1308,
    2970,  2079,  2080,   907,   938,  1946,   907,  -993,   584,    -6,
    3600,  3601,   907,   907,   907,   907,   907,   907,   907,   907,
     907,   907,   907,   907,  3400,   320,   934,  2881,   317,  2832,
     868,  2832,  1017,  3963,  1126,  3443,  1605,  3611,  3612,    59,
     317,  -993, -1983,   317, -1134,  2684,    63,   533,  2627,   907,
    4797,  4798, -1519,  1767,   907,  3123, -1134,  4119, -1519,  4901,
      16,  2775,    17,  1696,  3227,  3646,   316,  3647, -3423,  1697,
    2081,  4446,   759,   759,   133,   868,  1768,  1988,  2849,  3134,
     324,  1018,   320,   952,  2780,  2781,  2782,  2783,  2784,  2785,
    2786,  2787,  1645,  1434,  3305,  4902,   934,   860,  -993,   861,
    3261,  1060,  1160, -1134,  1067,  2082,   318,  4846,  1081,  1899,
      68,  1212,  4664,  4665,  2083,   768,  1900,  2954,   318,  1333,
     207,   528,   319,  2084,  4856, -3313, -1134,   320,   118,  1989,
    2840,  3551,  4416,   320,   319,  1831,  2898,   319, -3031,  -993,
   -3031, -3031, -3031, -3031, -3031, -3031,  1633,  1645,  4148,   769,
    1294,  4405,  3262,   321,  4903,   125,  2884, -1519,  1212,  1161,
    3040,  4085,  3042, -3413,  2494,  3399,  2085,  2991,  4417,   120,
    3402,  3404,   932,   932,   932,   317,  4714,  4120,  4338,  1073,
    3345,  4715,  3628,  4698,  4699, -1134,  2628,  3914,  4339,  1213,
    4904, -1519,  1214, -1519,  4862,  4766,  4176,  4447,  2525,  1372,
    1162,    59,   938,   938,   938,  1215,  1002,  3659,    -6, -3031,
     321,  2962,   771,  4678,   914,  2955,  4389,  1051,  2975,  4149,
    4681, -2267,  3444,  2992,  4684,  4086,  4167,  4686,   130,  3095,
    4479,   322,  1010,   868, -3031,  3931,  1213,  1216,  3690,  3790,
    3791,   772,    -6,   585,    -6,  4914,   760,   760,  1628,  3518,
    4863,  3276,  1215,   318,  1142,   321,  -993,  3375,   773,   774,
     932,   321,  1041,  3081,  4895,  3081,  2522,   139,  4732,   319,
   -1134,   202,  4733,   207,  4390,  1370,  1712,  4928,  1769,  4711,
    4448,   207,  1713,  1770,   207,   320,  1210,  4761,   322,  1041,
     938,  4087,   900,   900,  2775,  2732,  2775,   320,  2847,   138,
     320,  4762,  3128,  1771,  3839,  1772,   142,  2134,  2950,  2870,
    2871,  2872,  2774,   108,  4711,   907,  4391,  1163,  2315,   207,
    2134,   145,  2843, -2267,  4766,  2896,  2897,  2899,  4741,  3493,
    1334,  4742,  2461,   322,   324,   110,  4176,   134, -3362,   322,
     135,   136, -2267,  4850, -1134,  2708,  2865,   987,   146,  4827,
    1629,    59,  1362,  -993,  4226,   153,   108,  4480,   988,  4880,
    3609,  3610,  3082,   108,  2491,  2492,  2305,  2850,  1217,  1630,
    -993,  3081,  3081,  3103,  3519,   533,   207,   180,   110,  4767,
    2977,   775,  4481,  4482,  4483,   110,  3726,  3889,  3890,   176,
     533,   324,   147,  2086,  3520,  3851,  3151,  2087,   225,  2088,
    3249,  2321,  2775,  2775, -3031,  4915,  4916,   154,  4917,   111,
    3046,  3047,  2322,   321,  4402,  1217,  4761,  3719,   209,   160,
     225,   207,  3509,  1354,   191,   321, -1134,  2708,   321, -1519,
    4762,   763,   320,  2117,  2118,  3590,   324,  2468,  3784,   925,
    3547,   508,   324,  2469,  1003,  3727,   907,  4613,  1004,  4666,
    4667,   317,   111,  3079,  2129,  3536,  4619,  3728, -1134,   111,
    3085,   761,   761,  2762,  4622,   762,   762,  2779,  3158,  3159,
    2393,  3304,  2394,  2131,  2132,  2133,  4851,  4435,  1005,  4852,
      -6,  1041,  1041,  4436,   189,  2119,  2120,  1041,  1041,  1041,
    1041,   322,   900,  1211,   900,  1041,  1218,  1041,  2269,  1041,
     186, -2267,   226,   322,  3729,   227,   322,   202,   195,  2625,
     857,   858,  1927,  1930,  1933,  3089,  3090,   932,   900,  4074,
    4883,  1963,   207,  3510,  3312,   932,  2377,  3730,  1631,   318,
     209,  2523,  1307,  2524,  1773,  1307,  1307,  1308,  1962,  1307,
    1308,  1308,   900,  1218,  1308,   319,  4853,   938,  3483,   210,
     776,  3506,  3483,  2525,  1372,   938,  3703, -3283,  1645, -1134,
     321,   777,  1307,  4713,  2523,   240,  2524,  1308,  2270,  2271,
    2272,  2273,  4744,  2274,   218,   763,   763,   241,  2558,   207,
    1307,  1006,   932,  2559,   932,  1308,  3731,  1302,  1303,  4745,
    1305,   207,  1041,  3977,   324,  1041,  1645,  1227,  1645,  2534,
    4824,  2602,  1041,  1041,  1041,  1041,   324,   280,  4885,   324,
    1679,  1307,   938,  4887,   938,  3494,  1308,  4014,  4938,  3495,
    4939,  4611,  4940,  3634,   316,  4746,    55,  3635,    57,  1228,
    1229,  4611,   255,  4036,  2684, -1134,  2849,   284,   322, -1134,
    3754,  1946,   285,  2851,   290,  3803,  1645,  3455,  1212,   932,
    2366,   932,  1966,  1967,  2366,  2275,  2276,  1645,  1941,  1942,
     310,  3756,   337,   338,   348,  4403, -3372, -2999, -2999, -2999,
   -2999,  3732,  1386,  1387,  1388,  1389,   360,  1221,   502,   938,
     537,   938,  4864,  4747,   538,  4047, -2998, -2998, -2998, -2998,
    2708,   546,  4865,  4866,   778,   547,  2494,  2494,   554,  2494,
    2494,  3040,   567,   569,  1633,  1434,  4748,   288,   320,   207,
    3391,  3393,  3395,  3397,   900,   580,   723,   727,   745,   746,
   -1134,   932,   784,   805,  1221, -3372,  1213,  2774,  4756,  1214,
     804,   225,   811,   817,   810,   779,  3907, -3372,   818,   819,
     820,   324,  1215,  3454,   826,  3734,   940,   999,  1013,  1035,
    4642,   938,  1026,  1050,   780,  1051,  4774,  4775,  1113,  1059,
    3928,  1131,  4779,  1041,   508,  4819,  1142,  1167,  3330,  4820,
    4821,  1168,  1185,  4867,  1216,  1190,  1200,  3901, -3362,  1202,
    1207, -1134,  1243,  1233, -3372,  1247,  1268,  1253,   932,  1270,
    1251,  1272,  1275,  1276,  1277,  4868,  4869,  1290,  1279,  1282,
    1283,  1284,  1285,  1288,  4277,  1298,  1300, -3372,  4715,  1301,
    1318,  1322,  1325,   932, -3413, -3431,  1327,  1345,   938,  1339,
    1352,  1356,  1354,  3833,  1359,  3834,  1364,  3735,  1361,  1366,
    2775,  1381,  1368,  1390,  1391,  1156,   321,  1395,  1430,  1432,
    1435,  1440,  1610,   938,  2277,  2278,  2279,  2280,  2281,  2282,
    2283,  2284,  2285,  1620,  4402,  1623,  4595,  4596,  1624,  3737,
    1626, -1134,  1648,  1649,  1651,  1661, -3372,  1656,  1666,  1663,
    3481,  1968,  1969,  1970,  1971,  1972,  1973,  1974,  1975,  1976,
    1977,  3584,  1667,  3439,  1672,  3916,  3440,  1680,  1671,  4259,
    4260,  1084,  3543,  3596,  4336,  1684,  2494,  1691,  1693,  3447,
    1699,  2852,  4825,  2853,  3550,  1217,  1701,  3456,  3457,   166,
    1707,  1717,  2854,  2855,   322,  1715,  2856,  2857,  1720,  1723,
    1731,  3269,  1724, -1134,  1733,  2850,  1741,  1754,  1753,  1759,
    1761,  4265,  4266,  1763,  1845,  4825,  4271,  1802,   202,  1896,
   -3031, -3413,  1816,  1926,  3285,  1949,  1937,  1978,  1938, -3031,
   -3031, -3372,  1948,  1142, -3031,  1959,  4239,  4404,  1964,  1980,
    4426,  2148,   908,  3649,  1993,  1999, -3413, -3413, -3413,  1646,
    2006,  1371,  2049,  3310,  3310,  3719,  4405,   316,  2286,  2051,
    2062,  2102,  2108,  2110,  4222,  2123,  3550,  2256,  2260,  2849,
    2263,  2298,   533,  4406,  2268,  4460,  2299,  3500,  2301,  2324,
    2306,  2340,  2342,  2313,  2314,  2316,  2343,  2346,  2347,   317,
    2349,  2357,  2359,  2361,  3344,  1256, -3372,   324,  1679,   781,
     782,  2381,  2379,  2390,  1645, -3372,  2391,  1645,  2465,  2477,
    2479,  1041,  2480,  1218,  4364,  3901,  3739,  4118,  1219,  1220,
    3740,  2500,  2520,    84,  2533,  2552,  2774,  2534,  2554,  2557,
    1897,  1898,  2555,  2567,  2561,  2565,  2562,  1633,  2569,  2568,
    2577,  2571,  2579,  3161,  2585,  3162,  2586,  2587,   857,   858,
    2589,  2592, -2955,  2603,  2605,  1645,  2609,  2611,  1645,  2617,
    1645,   907,   907,  2620,  2621,  2633,  2666,   318, -1998,  2668,
    2676,  4429,  2678,  4543,  2681,  2695,   932,  2727,   932,  2699,
    2136,  2735,  1055,   319,  3700,  4403,  3702, -3372,  2750, -3283,
    1041,  2763,  2778, -3283, -3372,    59,  1645,  2770,  2807,  2805,
    2816,  3741,  2287,  2820,  2824,  2818,   938,  2494,   938,  2826,
    2836,  4108,  4109,  2829,  2838,  2845,  2864,  2684,  2868, -3372,
    2877,  2863,  2878,  2886,   932,  2288,  2888,  2890,  1157,  2891,
    2902,  2961,  2966, -3048,  1899,  2976,    85,  3052,  3055,  3086,
    1158,  1900,  3101,  1890,  1901,  2594,  3764, -3372,  2595,  1159,
   -3030,  2628,  3132,  3770,   938,  2627,  3156,  3184,  3185,  3191,
    3192,  3194,  3742,  3198,  3207,  3208,  3222,  3617,  3239,  3199,
    3206,  3804,  3805,  4190,  2755,  3240,  3265,  3282,  3654,  3289,
    3290,  2851,  3795,  3292,   932,  3294,  3301,  3318,  3315,  3314,
    3319,  3802,  1789,  3325,  1221,  3327,  3331,  3333,  3346,  1902,
    3353,  3356,  3358,  3376,  1903,  1904,  3384,  3359,  3369,  3584,
    3398,  3409,  3418,  3413,   938,  3415,  3421,  3543,  3423,  3426,
    3458,  3445,   286,  1190,  3459,  2775,  3460,  3461,  3466,  3550,
    3468,  3504,    82, -2960, -3413, -3028,  3508,  3657,  3499,  3552,
    2774,   932,  3745,  3532,  3534,  3560,   320, -3023,  3705,  3566,
    4272,  3586,  3883,  3884,  3569,  3538,  3572,  3670,  2850,  4212,
    3591,   907,  3714,   907,  3592,  3250,  3856,  3606,  4597,  3251,
    3516,   938,  4281,  1946,  4567,  3607,  3913,  3277,  3278,  3643,
     900,  3405,  3645,  3651,  3650,  3658,  3696,   907,  1905,  3693,
    1906,  3698,  3709,  2537,  3723,  3725, -3372,  1907,  3752,  3809,
   -3372,  3755,  1160,  3798,  3747,  4238,  1908,  3799,  3811,  3813,
    3815,   907,  3818,  3820,  3830,  3835,  3840,  3841,  3553,  3554,
    3845,  3850, -3432,  3867,  3872,  3874,  3776,  3777,  3881,  3882,
    3628,  3783,  3627,  3786,  3787,  3788,  3789,  3908,  3917,  3919,
    4543,  3923,   317,  3796,  3163,  3927,  1645,  3932,  3933,   209,
    1294,  3935,  3942,  3937,  3938,  4333,  3948,  3941,  3965,  1161,
    3955, -3413,  3968,  3589,  3969,  3774,  3774,  4020,  4021,  3810,
    4022,  4048,  4052,  4054,   321,  4060,  2774,  4404,  1181,  4029,
    4101, -3372,   209,  4294,   901,  4075, -3413, -3413, -3413,   209,
    4082,  4106,  4102,  4125,  4124,  1645,  4405,  3976,  4130,  4131,
    1162,   857,   858,  4137,  1679,  4136,  4816,  4159,  4209,  4199,
    4110, -1998,  4346,  4406,  4208,  4214,  1909,  4169,  4232,  4084,
     318,  3934,  4262,  4245,  4171, -3283,  1041,  4282,   932,  3164,
     932,   207,  4321,  4285,  4286,  4301,   319,  4322,  4323,  2852,
    4328,  2853, -3372,  4373,  4288,  4372,  4334,  4358,  4342,  3857,
    2854,  2855,   322,  4369,  2856,  2857, -3372,  4361,   938,  4397,
     938,  4398,  4346,  4386,  4399,  4430,  4400,  1910,  4432,  4439,
    4471,  1911,  3940,  4462,  4474,  3692,  3666,  3875,  4465,  4475,
   -3372,  4478,  4491,   907,  4484,  4357,  4550,  4487,  4488,  4561,
    4621,  3858,  2546,  4633,  2494,  1679,  4670,  4671,  4776,  4878,
    4822,  4936,  4931,    35,  3482,  1912,  4929,  4930,  1084,  4942,
    2881,  3054,   129,   249,   577,    32,  1823,  1163,   171,   545,
    2510,   307, -3372,  1679,  3479,  3049,   174,   557,   573,   207,
    1231,  1809,   222,   308,  2851,  4027,   802,  2488,   803,  3913,
     561,  4365,  4256,  3010,  2775,  4641,  3985,  4240,  3785,  4318,
    3793,  3465,  4009,  1250,   797,   324,    67,  4012,  4013,  4311,
    4133,  4461,  3806,  4476,  4401,  4016,  4489,  4018,  1175,  3775,
    3922,  2738, -3372,  3669,    72,  1070,  2905,  2539,  3165, -3283,
   -3283,  2398,  4793,  4794, -3372,  2945,  2946,  4918,  4307,  4228,
    4362, -3372,  2726, -3372,  3715,  3717,  4799,  3329,  3051,   320,
    3721,  4710,  4755,  4807,   901,   901,   901,   901,  3987,  3988,
    3989,  4884,  3386,  4886,   533,  4300,  4692,  4428,  1042,   900,
    4097,  4636,  2130,  4614,  1619,  4615,  4722,  4618,  4634,   209,
    2513,   763,  3060,  4024,  3897,  3824,  3825,  3826,  3827,  3812,
    4163,   501,  1830,  3501,  3497,  1836,  1884,  2547,  2607,  3129,
    1324,  3822,  4270,  3895,  4268,  1987,   986,  4166,  2643,  1330,
    3700,  2056,  2005,  3986,  2661,  1377,  3517,  1043,  1385,  3142,
    3837,  2060,  2063,  3190, -1998,  3535,  2691,  3838,  1433,    73,
    3544,  4141,  4017,  2720,  3545,  2122,  3558,  3209,  3849,  1608,
    2494,  4067,  4197,  2360,   209,  3848,  4028,  1627,  2740,  1438,
    3866,  3588,  1650,   209,  2752,  4134,  3246,  3605,  3603,   209,
    3595,  3296,   209,  2369,   209,   209,  3308,  2362,  2788,  2309,
    3166,  1681,   209,  1103,   209,  1682,   209,   321,  3311,  2339,
    3622,  3990,  3991,  1913,  3992,  4046,  3667,    74,  2813,  2814,
      75,  4393,    76,  4290,  2764,  1041,  4077,  2751,  4375,  3906,
    4195,  4444,  4560,  4027,  4459,  4135,  2382,  3071,  2775,  3065,
    2011,  2684,  3119,  2013,  3626,  3117,  3616,    77,  3614,  4062,
    3140,  1641,  3894,  3892,  3633,  3272,  3138,  1096,  3929,  1329,
    2071,  1645,  4253,  4255,  4253,  4152,  1982,  3273,  3274,  3275,
    1730,  1130,  2852,  2692,  2853,  3768,  3425,  2982,  4066,   564,
    4213, -1998,  4083,  2854,  2855,   322,  2777,  2856,  2857,  4617,
    4057,  3692,  4104,  1985,  3751,  3045,  4308,  1244,  1914,  4643,
    1232,  1289,  2400,  3167,  4315,  2794,  4117,  3133,  3417,  1915,
    3619,  1785,  4601,  4814,  2960,  4204,  3523,  3886,  4242,  4033,
    1916,  4734,  4231,  3546,  1271,  4848,  4908,   568,   579,  3571,
    3771,  2831,  2658,  4736,  3711,  1844,   901,  4551,   316,  2471,
    3041,     0,    78,  4831,  4872,     0,  4015,     0,  4313,  4739,
    2849,     0,     0,  4279,  4313,     0,     0,  4224,  4225,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1679,  2775,     0,   209,   209,  4758,     0,
       0,  1679,     0,  4158,     0,   533,  4161,  4162,   324,     0,
       0,  1917,   209,     0,     0,     0,     0,     0,  4728,     0,
       0,     0,     0,     0,     0,  3993,  3994,     0,     0,     0,
    4140,  4341,  4758,  4186,  4187,  4188,     0,     0,  1633,  4740,
       0,     0,   209,     0,     0,     0,   209,     0,  1918,     0,
    3995,     0,     0,     0,     0,  4196,     0,     0,     0,  1041,
    4198,     0,     0,  4042,     0,     0,     0,     0,     0,  4044,
    4045,     0,   914,     0,     0,     0,  3996,  4326,  4327,     0,
       0,     0,     0,     0,     0,  4388,  3726,     0,     0,   901,
     901,   901,     0,     0,     0,     0,   901,   901,   901,     0,
       0,  3997,     0,     0,     0,     0,  2895,  4310,     0,   914,
       0,     0,   901,     0,     0,   901,     0,  4317,  4317,     0,
       0,   901,   901,   901,   901,   901,   901,   901,   901,   901,
     901,   901,   901,  4244,   209,   209,     0,    79,     0,     0,
       0,     0,   739,     0,     0,  3727,     0,     0,     0,     0,
     938,     0,     0,  4443,     0,     0,     0,  3728,   901,     0,
       0,     0,  4241,   901,     0,  4253,     0,     0,  4243,   907,
    4919,     0,     0,     0,     0,  4261,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   209,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1041,     0,     0,     0,     0,
       0,     0,     0,  3998,  3729,     0,     0,     0,     0,     0,
       0,     0,   914,     0,  4306,     0,     0,     0,     0,     0,
       0,  4603,     0,     0,     0,     0,     0,  3730,     0,     0,
       0,    80,     0,     0,     0,    81,  3999,  4433,     0,     0,
    4000,  4001,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4548,     0,     0,     0,     0,     0,     0,     0,  2850,
     938,  4184,     0,   209,   209,     0,     0,     0,  4002,     0,
       0,     0,     0,     0,   209,   209,     0,     0,     0,  4253,
       0,     0,     0,     0,     0,  2304,  3731,     0,     0,     0,
    4569,     0,     0,     0,     0,     0,     0,     0,     0,  4368,
       0,     0,     0,     0,     0,     0,     0,     0,  4370,     0,
    2494,     0,     0,  4374,     0,     0,     0,  4376,     0,     0,
       0,     0,     0,  4693,   846,     0,   903,     0,     0,   924,
       0,     0,  4396,  -931,   947,     0,   982,     0,     0,     0,
     996,     0,  4620,   317,     0,  -931,     0,     0,     0,     0,
    1034,     0,     0,  1034,    82,     0,     0,  4440,  4441,     0,
    1063,     0,     0,     0,  4445,     0,     0,     0,     0,     0,
       0,  3732,     0,     0,  1119,     0,  1125,  1128,     0,  4464,
       0,     0,  4467,  4468,  4469,  4470,     0,     0,     0,     0,
    1141,     0,     0,    83,   209,     0,  1041,     0,     0,     0,
       0,     0,   857,   858,     0,     0,     0,     0,     0,     0,
    4544,     0,     0,  -931,     0,     0,     0,     0,     0,     0,
       0,   318,     0,     0,   901,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4003,  3733,   319,  4683,     0,
      84,     0,    85,     0,     0,  3734,     0,  4690,     0,     0,
       0,     0,     0,     0,     0,     0,  4574,  4575,  4576,  4577,
    4578,     0,     0,  4580,  4581,  4582,  4583,  4584,  4585,  4586,
    4587,  4588,  4589,  4590,    86,     0,  4592,     0,  4602,   906,
    4605,     0,     0,     0,   939,     0,    87,     0,     0,  4612,
       0,     0,  4616,  4705,     0,     0,   939,     0,     0,     0,
       0,   939,     0,     0,     0,     0,     0,  1274,   907,     0,
       0,     0,     0,  4624,     0,  4626,     0,     0,     0,     0,
     939,     0,     0,     0,    88,     0,     0,  3735,     0,     0,
       0,     0,     0,     0,  3736,  2851,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   903,   903,   903,   903,
       0,     0,     0,     0,     0,   901,     0,     0,     0,  3737,
       0,  4705,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   316,     0,  1645,   924,     0,     0,
       0,     0,     0,     0,     0,     0,  2849,  3738,     0,  4705,
    4705,     0,     0,     0,  4679,  4705,  4680,     0,  4705,     0,
     320,     0,  4705,  4705,  1358,     0,  4688,    89,     0,     0,
    1645,     0,  4829,     0,     0,     0,     0,     0,    90,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1041,     0,     0,  -931,  3405,  4847,     0,  1041,     0,
       0,     0,  1041,     0,     0,  1041,     0,     0,     0,     0,
       0,     0,     0,  4857,  1633,     0,  4709,  4059,     0,     0,
       0,     0,     0,     0,     0,     0,  4705,     0,     0,     0,
    4847,  4705,     0,  1063,     0,     0,     0,  4544,     0,     0,
       0,  4893,     0,     0,     0,     0,  1445,     0,     0,     0,
       0,  1296,     0,   996,     0,     0,     0,     0,     0,   906,
     906,   906,   906,     0,     0,     0,     0,     0,     0,     0,
    1320,     0,     0,  1643,     0,     0,     0,     0,  -931,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   321,     0,
    4764,  4765,     0,  4770,     0,     0,  3739,     0,  1677,     0,
    3740,     0,   939,     0,     0,     0,  1041,     0,  4773,  1041,
       0,     0,     0,  4777,  4778,     0,  4941,     0,     0,     0,
       0,     0,     0,     0,     0,  1705,     0,     0,     0,     0,
       0,  4828,     0,     0,  4830,     0,  4832,  -931,  -931,     0,
       0,     0,     0,  1719,     0,     0,     0,     0,     0,     0,
    1726,  1728,     0,  2852,     0,  2853,  -931,     0,   903,     0,
       0,  1744,  1746,     0,  2854,  2855,   322,     0,  2856,  2857,
       0,     0,  -931,     0,     0,     0,     0,     0,   939,     0,
       0,  3741,     0,     0,     0,     0,   900,   900,     0,     0,
       0,     0,     0,     0,   939,     0,     0,     0,     0,     0,
    4192,     0,     0,     0,     0,     0,   361,   362,     0,     0,
       0,   363,     0,     0,     0,     0,   900,   364,     0,     0,
       0,     0,     0,     0,  1679,   365,     0,     0,     0,     0,
       0,     0,     0,     0,   366,  2850,     0,     0,     0,     0,
       0,     0,  3742,     0,     0,     0,     0,     0,     0,     0,
       0,  1678,     0,     0,     0,     0,  3743,     0,     0,     0,
       0,   939,     0,     0,     0,     0,     0,     0,   939,   324,
    -931,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3744,     0,     0,     0,  1894,  1895,     0,     0,     0,     0,
       0,   903,   903,   903,     0,     0,     0,     0,   903,   903,
     903,  1944,     0,     0,  1944,     0,     0,   367,   368,     0,
       0,   906,     0,     0,   903,     0,  1944,   903,     0,   317,
       0,     0,  3745,   903,   903,   903,   903,   903,   903,   903,
     903,   903,   903,   903,   903,  -931,     0,     0,   369,     0,
       0,     0,     0,  1679,     0,  1125,     0,  1986,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   370,     0,
     903,     0,   371,     0,     0,   903,     0,     0,     0,     0,
    -931,     0,  3746,     0,     0,     0,     0,     0,   857,   858,
     372,     0,     0,     0,  3747,     0,     0,     0,     0,     0,
       0,  3748,     0,  3749,     0,     0,     0,   318,     0,  2047,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   319,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4780,     0,   373,     0,     0,     0,     0,
       0,   374,     0,   375,     0,     0,     0,   376,  1641,     0,
       0,     0,   377,     0,   906,   906,   906,     0,     0,     0,
       0,   906,   906,   906,  1945,     0,     0,  1945,     0,   378,
       0,  1958,     0,  -931,     0,     0,     0,   906,     0,  1945,
     906,     0,     0,     0,     0,     0,   906,   906,   906,   906,
     906,   906,   906,   906,   906,   906,   906,   906,     0,     0,
       0,     0,     0,     0,     0,     0,   379,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2403,     0,     0,     0,
       0,  2851,   380,   906,   316,     0,     0,   381,   906,  1679,
       0,     0,     0,   382,   383,     0,     0,     0,  -931,     0,
    -931,     0,     0,     0,     0,     0,     0,     0,     0,  -931,
    -931,  -931,     0,  -931,  -931,     0,     0,     0,     0,     0,
     901,   901,  2048,     0,     0,     0,  4781,     0,     0,  1899,
    4782,     0,     0,  1958,     0,     0,  1900,     0,     0,  1641,
       0,     0,     0,  1156,   384,     0,   320,     0,     0,     0,
       0,     0,     0,   385,     0,     0,   386,     0,     0,     0,
       0,   387,     0,     0,  2022,  2023,  2024,  2025,     0,     0,
       0,     0,  2026,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   388,     0,     0,
    2027,  2028,     0,     0,  1641,   389,   903,   390,     0,     0,
     391,     0,     0,   392,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  -931,     0,     0,     0,     0,   393,
       0,     0,     0,  2305,     0,     0,     0,     0,     0,     0,
       0,     0,   848,     0,     0,     0,     0,     0,   849,   850,
       0,  2029,     0,     0,     0,     0,     0,  2303,     0,     0,
       0,     0,     0,     0,   852,     0,     0,     0,  2310,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   321,     0,     0,     0,     0,     0,
    2030,     0,     0,     0,     0,   394,     0,  2338,     0,     0,
       0,     0,   395,     0,   396,     0,     0,   397,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   398,     0,     0,     0,     0,     0,  2368,
     901,     0,   901,     0,     0,     0,     0,   903,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2852,
       0,  2853,     0,     0,     0,     0,   901,     0,     0,   906,
    2854,  2855,   322,     0,  2856,  2857,     0,     0,     0,     0,
       0,     0,   939,     0,     0,  1958,     0,     0,   399,     0,
     901,     0,     0,     0,     0,     0,     0,     0,     0,  4783,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   400,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2031,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   939,     0,     0,     0,     0,     0,     0,   853,
     854,   855,   401,  2409,     0,     0,     0,     0,   402,     0,
       0,   856,     0,   403,     0, -3404,   404,   405,  1958,     0,
       0,     0,     0,     0,     0,   324,  1157,     0,     0,     0,
       0,     0,  4784,  2032,     0,   406,  4785,     0,  1158,   317,
       0,     0,     0,     0,     0,  1894,     0,  1159,     0,     0,
     906,     0,     0,   407,     0,     0,     0,     0,   408,     0,
       0,  1677,     0,     0,     0,   409,     0,     0,     0,     0,
       0,   410,     0,     0,  2033,     0,     0,     0,     0,     0,
       0,     0,  2575,     0,     0,     0,     0,     0,     0,     0,
     411,     0,  1944,     0,     0,     0,     0,     0,  4786,     0,
     859,  2022,  2023,  2024,  2025,   412,     0,     0,     0,  2026,
       0,   413,   901,     0,     0,   907,   907,   318,     0,     0,
       0,   862,   863,   864,     0,     0,     0,  2027,  2028,   414,
     865,     0,     0,   319,     0,     0,     0,     0,     0,     0,
       0,     0,  4787,   415,     0,   907,     0,     0,     0,     0,
       0,     0,     0,   416,   417,  4737,     0,     0,  -636,     0,
       0,     0,   418,   848,     0,   419,     0,     0,  2034,   849,
     850,     0,     0,     0,     0,  1641,     0,     0,  2029,  2412,
     420,     0,     0,     0,     0,   852,     0,     0,     0,     0,
    4788,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1160,  2047,   421,     0,     0,  2662,     0,     0,     0,     0,
       0,     0,     0,  1641,  1678,  1641,   867,  2030,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   422,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     423,  -636,     0,     0,     0,  1945,   424,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1161,     0,     0,
       0,     0,     0,  1641,   939,     0,     0,   847,   939,     0,
       0,   425,     0,   316,  1641,     0,  2035,     0,     0,     0,
       0,     0,  2702,     0,     0,  2703,     0,  2704,  2705,  2706,
       0,  -636,     0,     0,  -636,  -636,   320,     0,  1162,     0,
       0,  -636,     0,  2729,   426,     0,     0,     0,  -636,   427,
       0,     0,     0,     0,     0,     0,     0,   428,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2417,     0,     0,     0,     0,     0,     0,
       0,  2031,     0,     0,     0,  4789,     0,     0,     0,     0,
       0,   869,     0,     0,  2048,     0,     0,     0,     0,     0,
     853,   854,   855,     0,     0,     0,     0,   939,     0,     0,
       0,     0,   856,     0,     0,     0,     0,  4790,     0,     0,
       0,     0,     0,     0,     0,  -636,  -636,  1871,     0,  1872,
    1873,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2032,     0,     0,     0,     0,     0,     0,     0,     0,  2036,
       0,     0,     0,     0,  2037,  1163,     0,     0,     0,     0,
    1643,   848,     0,  2748,   321,     0,     0,   849,   850,     0,
       0,     0, -3431,     0,     0,     0,     0,     0, -3404,     0,
       0,  2033,     0,   852,  2710,  4791,     0,     0,     0,     0,
     870,   871,     0,  2038,     0,     0,     0,  2753,     0,   857,
     858,   859,  2754,     0,     0,  2039,     0,     0,  2768,  1677,
       0,  4528,     0,     0,     0,     0,     0,     0,  3693,     0,
       0,     0,   862,   863,   864,     0,     0,     0,  2393,     0,
    2394,   865,  1178,  2424,     0,     0,     0,     0,  2802,     0,
       0,     0,   322,     0,     0,  2812,  2812,     0,     0,     0,
       0,     0,     0,     0,     0,  2822,     0,  2823,     0,     0,
     873,     0,     0,     0,     0,     0,     0,     0,     0,   763,
       0,     0,   903,   903,     0,  2034,     0,  2835,     0,     0,
       0,     0,     0,     0,  -636,     0,     0,   874,     0,     0,
       0,     0,     0,     0,     0,   875,   955,     0,     0,     0,
       0,     0,     0,     0,  2040,   939,   939,   939,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   867,     0,     0,
       0,     0,  2644,   876,     0,     0,     0,     0,     0,     0,
     207,     0,     0,     0,     0,     0,     0,     0,  -636,     0,
       0,     0,     0,     0,     0,   324,     0,     0,     0,     0,
    -636,   956,     0,     0,     0,     0,     0,     0,   853,   854,
     855,  -636,  1678,     0,     0,     0,     0,  -636,     0,     0,
     856,  -636,     0,  -636,     0,     0,     0,     0,     0,     0,
       0,  1641,  -636,  2035,  1641,     0,     0,     0,     0,     0,
       0,     0,     0,   939,     0,  2710,     0,     0,   317,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     957,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    -636,     0,     0,     0,  3069,   906,   906,     0,     0,     0,
       0,     0,  1641,  -636,     0,  1641,     0,  1641,   901,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   869,  1894,     0,     0,     0,   857,   858,   859,
       0,     0,     0,     0,     0,     0,     0,   860,     0,   861,
       0,     0,   903,  1641,   903,     0,   958,  -636,     0,     0,
     862,   863,   864,     0,  1944,     0,     0,     0,     0,   865,
       0,     0,   319,     0,  1871,     0,  1872,  1873,   903,     0,
       0,  3127,     0,     0,     0,   959,     0,     0,     0,   866,
       0,     0,     0,     0,  -636,     0,  2036,     0,     0,     0,
       0,  2037,   903,     0,     0,  -636,     0,     0,     0,   924,
       0,     0,     0,     0,     0,  -636,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   870,   871,     0,     0,     0,     0,     0,     0,     0,
    2038,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2039,     0,     0,   867,     0,     0,     0,     0,
       0,     0,   960,     0,     0,     0,     0,     0,     0,  3069,
       0,     0,  -636,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   868,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3220,     0,     0,     0,     0,
       0,   873,     0,     0,     0,   906,     0,   906,     0,     0,
       0,     0,     0,  -636,     0,  3234,     0,  1945,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   874,     0,
     939,   906,     0,     0,     0,   320,   875,     0,   939,  3264,
       0,     0,     0,     0,     0,     0,     0,     0,  -636,     0,
       0,  2040,     0,     0,     0,   906,     0,     0,     0,     0,
    -636,     0,     0,     0,   876,     0,     0,  3271,     0,     0,
       0,   207,     0,     0,   903,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1677,     0,     0,     0,
     869,     0,  -636,     0,     0,   939,     0,   939,     0,     0,
       0,  3212,     0,  1641,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1677,     0,     0,     0,     0,     0,
       0,     0, -1579,   362,     0,     0,     0,   363,     0,     0,
    -636,     0,     0,   364,     0,     0,     0,     0,     0,     0,
       0,   365,     0,     0,     0,     0,     0,  2710,  1678,     0,
     366,     0,  1641,  -636,     0,     0,     0,   901,     0,     0,
    -636,     0,   939,   321,   939,     0, -1579,   961,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  -636,     0,     0,   870,
     871,     0,   962,     0,     0,  -636,     0,     0,     0,     0,
       0,     0,     0,  -636,     0,  -636,     0,  3213,  -636,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   367,   368,     0,     0,   906,   218,     0,
       0,     0,     0,     0,   939,     0,     0,   963,     0,  1678,
       0,   322,     0,     0,  -636,     0,     0,     0,     0,   848,
       0,     0,     0,     0,   369,   849,   850,     0,     0,   873,
       0,     0,     0,     0,     0,     0,     0,  1678,     0,     0,
       0,   852,     0,     0,   370,     0,     0,     0,   371,     0,
       0,     0,     0,     0,     0,     0,   874,     0,     0,     0,
       0,     0,     0,     0,   875,     0,   372,     0,     0,     0,
       0,   939,     0,     0,     0,     0,  4055,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   876, -1579,     0,     0,   939,   964,   533,   207,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   373,     0,     0,   324,     0,     0,   374,     0,   375,
       0,     0,     0,   376,     0,   924,     0,     0,   377,     0,
    3069,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   378,     0, -1579,     0,     0,
       0, -1579, -1579, -1579, -1579, -1579,     0, -1579, -1579, -1579,
   -1579,     0, -1579, -1579,     0, -1579, -1579,     0, -1579, -1579,
   -1579, -1579, -1579,     0, -1579, -1579, -1579, -1579, -1579, -1579,
       0,     0,   379,     0,     0,     0,     0,     0,     0,     0,
   -1579,     0,     0,     0,     0, -1579,     0,     0,   380,     0,
       0,     0,     0,   381, -1579,     0,     0,     0,     0,   382,
     383,     0,  2022,  2023,  2024,  2025,   853,   854,   855,     0,
    2026,     0,     0,     0,     0,     0,     0,     0,   856,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2027,  2028,
       0,  3542,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1677,     0,   317,     0,     0,     0,
     384,     0,  3220,     0,     0,     0,     0,     0,     0,   385,
       0,     0,   386,     0,     0,     0,     0,   387,     0,     0,
       0,     0,     0,     0,     0,  2748,     0,     0,     0,  2029,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   848,
       0,     0,     0,   388,     0,   849,   850,     0,  1641,  3214,
       0,   389,     0,   390,     0,     0,   391,   859,     0,   392,
       0,   852,     0,     0,     0, -1579,     0,     0,  2030,     0,
       0,     0,     0,     0,   318,   393,     0,     0,   862,   863,
     864,     0,     0,     0,     0,     0,     0,   865,     0,     0,
     319,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1177,     0,     0,     0,   939,
       0,   939,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   394,     0,     0,     0,  -636,     0,  1678,   395,     0,
     396,     0,     0,   397,     0,  1678,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   939,     0,   398,
     903,     0,     0,   867,     0,     0,     0,     0, -1579,     0,
       0,  -636,     0,     0,  -636,  -636,  -636,  -636,  -636,     0,
    -636,  -636,  2031,     0,     0,     0,     0,   924, -1579, -1579,
   -1579,  -636, -1579, -1579, -1579, -1579,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -1579, -1579,   399,     0,     0,   939,     0,     0,
       0,     0,     0,     0,     0,     0,   853,   854,   855,     0,
    -636,     0,     0,     0,     0,     0,     0,   400,   856,     0,
       0,  2032,     0,   320,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -636,  -636,
       0,  -636,  -636,  -636,  -636,  -636,  -636,  -636,  -636,  -636,
       0,     0,     0,     0,   939,     0,     0,     0,   401,     0,
       0,     0,  2033,     0,   402,     0,     0,     0,     0,   403,
       0,     0,   404,   405,     0,     0,     0,  3828,   869,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   406,     0,   906,     0,     0,  3542,     0,     0,     0,
    -636,     0,     0,     0,     0,     0,     0,   859,  -636,   407,
       0,     0,     0,     0,   408,  -636,  -636,     0,     0,     0,
       0,   409,     0,     0,  1122,     0,     0,   410,   862,   863,
     864,     0,     0,     0,     0,     0,     0,   865,     0,     0,
       0,     0,     0,     0,     0,     0,   411,     0,     0,     0,
       0,   321,     0,     0,     0,     0,  2034,     0,     0,     0,
       0,   412,     0,     0,     0,     0,     0,   413,     0,     0,
       0,     0,     0,  3885,     0,     0,     0,   870,   871,  3887,
       0,  3888,     0, -1579,     0,   414,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3905,     0,   415,
       0,   890,  3529,     0,     0,     0,  -636,  -636,     0,   416,
     417,     0,     0,     0,     0,     0,     0,     0,   418,     0,
       0,   419,  1178,   867,     0,     0,     0,     0,     0,   322,
       0,  -636,  -636,  -636,  -636,  -636,   420,  -636,  -636,  -636,
       0,   939,  3215,   939,     0,     0,  -636,   873,     0,     0,
       0,  2318,     0,     0,     0,     0,     0,   316, -1579,     0,
    -636,     0,     0,  -636,  2035,     0,     0,     0,     0, -1579,
       0,     0,     0,     0,   874,     0,  -636,     0,     0,   903,
       0,     0,   875,   422,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  -636,     0,     0,   423,     0,     0,     0,
    -636,     0,   424,     0,     0,     0,     0,     0,     0,     0,
     876,     0,     0,   848,     0,     0,  -636,   207,  -636,   849,
     850,     0,     0,     0,     0,     0,     0,   425,  -636,     0,
       0,     0,   324,     0,     0,   852,     0,     0,     0,     0,
    -636,     0,     0,     0,     0,     0,     0,     0, -1579,     0,
       0,  -636,  -636,     0,     0,     0,     0,     0,   869,     0,
     426,     0,     0,  -636,     0,   427,     0,     0,     0,     0,
       0,     0,  -636, -1579,     0,  1871,     0,  1872,  1873,     0,
       0,     0,     0,     0,     0,  4037,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2036,     0,     0,
       0,     0,  2037,     0,     0,   848,     0,     0,     0,     0,
    -636,   849,   850,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   852,  4058,     0,
       0,  4061,   906,     0,     0,     0,     0,     0,     0,     0,
       0,  2038,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2039,     0,     0,     0,   870,   871,     0,
       0,     0,     0,  4070,  4073,     0,     0,  -636,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4105,     0,     0,     0,  -636,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  -636,     0,     0,     0,     0,  -636,
     853,   854,   855,  1641,     0,  -636,     0,     0,     0,     0,
       0,     0,   856,     0,     0,  -636,     0,   873,     0,  2319,
       0,     0,  -636,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   901,   901,     0,  1641,     0,     0,
     317,     0,  2040,     0,   874,     0,     0,     0,     0,     0,
       0,     0,   875,     0,     0,  -636,     0,     0,     0,     0,
       0,     0,     0,     0,   901,     0,     0,     0,     0,     0,
       0,     0,  -636,     0,     0,     0,     0,     0,     0,     0,
     876,     0,     0,     0,     0,     0,     0,   207,     0,     0,
       0,     0,   853,   854,   855,     0,     0,     0,     0,   857,
     858,   859,     0,     0,   856,     0,     0,     0,     0,   860,
    -636,   861,     0,  -636,  4070,     0,     0,  4073,   318,     0,
       0,     0,   862,   863,   864,  1677,     0,  -636,     0,     0,
       0,   865,   317,     0,   319,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -636,     0,
    -636,  -636,  -636,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  -636,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   857,   858,   859,     0,     0,  -636,     0,     0,     0,
       0,   860,     0,   861,     0,     0,     0,     0,     0,     0,
     318,     0,     0,     0,   862,   863,   864,   867,     0,     0,
       0,     0,     0,   865,     0,     0,   319,     0,     0,  4273,
    -636,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   866,  1677,   868,     0,     0,     0,     0,
       0,     0,     0,  -636,  4191,     0,     0,     0,     0,     0,
    -636,  -636,     0,     0,     0,     0,     0,     0,     0,     0,
    -636,  -636,  -636,     0,     0,     0,     0,     0,  1678,     0,
       0,     0,     0,     0,     0,     0,  -636,     0,     0,     0,
       0,     0,     0,     0,     0,  -636,     0,   320,     0,     0,
       0,  -636,     0,  -636,     0,  -636,     0,     0,  -636,   867,
       0,     0,  -636,     0,     0,     0,     0,     0,  4325,     0,
       0,     0,     0,     0,     0,     0,     0,  4332,   218,     0,
       0,  4337,     0,     0,     0,     0,     0,   868,     0,     0,
       0,     0,     0,     0,  -636,     0,     0,     0,     0,     0,
       0,     0,   869,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4332,     0,     0,  4379,
    4384,     0,     0,     0,     0,     0,     0,     0,     0,   320,
       0,     0,     0,     0,     0,     0,     0,  1678,     0,     0,
       0,  4411,  4422,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1677,     0,     0,  4379,     0,   321,     0,     0,  4384,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4466,     0,   869,     0,     0,     0,     0,     0,
       0,   870,   871,     0,     0,     0,     0,  4477,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4490,     0,
       0,     0,  4547,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1932,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   891,     0,   322,     0,   892,   893,     0,     0,  2320,
    4568,     0,     0,  4570,  4571,  4572,  4573,   321,     0,     0,
       0,   873,     0,  4579,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4591,     0,     0,     0,
       0,     0,     0,   870,   871,     0,     0,     0,   874,     0,
       0,     0,     0,     0,  2303,     0,   875,     0,     0,     0,
       0, -1563,   362,     0,     0,     0,   363,     0,     0,     0,
       0,  4623,   364,  1678,     0,  4625,     0,     0,     0,     0,
     365,     0,     0,     0,   876,     0,     0,     0,  2321,   366,
       0,   207,     0,     0,     0,   322,     0,     0,     0,  2322,
       0,     0,     0,     0,     0,     0,   324,     0,     0,     0,
       0,     0,     0,   873,     0,     0,     0,     0,     0,     0,
    4645,  4646,  4647,  4648,  4649,  4650,  4651,  4652,  4653,  4654,
    4655,  4656,  4657,  4658,  4659,  4660,  4661,  4662,  4663,     0,
     874,     0,     0,     0,     0,     0,     0,     0,   875,     0,
    4677,     0,     0,     0,     0,     0,     0,     0,     0,  3069,
       0,   847,   367,   368,     0,     0,     0,   316,  3069,     0,
       0,     0,     0,     0,     0,     0,   876,     0,     0,     0,
       0,     0,     0,   207,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   369,     0,     0,  4696,     0,   324,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4697,     0,
       0,     0,     0,   370,  4704,     0,     0,   371,     0,     0,
    4677,  4677,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   924,   372,     0,     0,  4632,     0,
       0,     0,  4729,  4730,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   924,  4677,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4743,     0,     0,     0,     0,
     373,     0,  4704,     0,     0,     0,   374,     0,   375,  4760,
       0,     0,   376,     0,     0,     0,     0,   377,     0,     0,
       0,     0,     0,     0,     0,     0,  4772,     0,     0,     0,
    4704,  4704,     0,     0,   378,   848,  4704,     0,  4818,  4704,
       0,   849,   850,  4704,  4704,     0,     0,     0,     0,     0,
       0,   851,     0, -1823,     0,     0,     0,   852,     0, -1823,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   379,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4849,     0,     0,   380,     0,     0,
       0,     0,   381,     0,     0,     0,   903,   903,   382,   383,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   903,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2347,     0,
       0,     0,     0,     0,     0,  4913,  4913,     0,     0,   384,
       0,     0,     0,     0,     0,     0,     0,     0,   385,     0,
       0,   386,     0,  4920,     0,     0,   387,     0,     0,     0,
       0,     0,     0,  4923,  4927,     0,     0,     0,  4913,     0,
    4298,     0,     0,     0,     0,  4935,  -636,     0,     0,     0,
       0,     0,   388,     0,     0,     0,     0,     0,     0,     0,
     389,     0,   390,     0,     0,   391,     0, -1823,   392,     0,
       0,     0, -3291, -1823, -1823,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   393,     0,     0,  -636,     0, -1823,
       0,     0,   853,   854,   855,     0,     0,     0,     0,     0,
    -636,  -636,  -636,  -636,   856,  -636,     0,     0,  -636,   906,
     906,     0,     0,     0,     0,     0,     0,  -636,     0,     0,
       0,     0,     0,     0,     0,     0,  -636,  -636,     0,     0,
       0,     0,   317,     0,     0,     0,     0,     0,     0,   906,
       0,     0,     0,     0,     0,     0,     0,  -636,     0,     0,
     394,     0,     0,     0,     0,     0,     0,   395,     0,   396,
       0,     0,   397,     0,  -636,     0,     0,     0,     0,  -636,
       0,     0,     0,     0,     0,     0,  -636,  -636,   398,     0,
    -636,     0,     0,     0,     0,     0,     0,  -636,     0,     0,
       0,   857,   858,   859,     0,     0,     0,     0,     0,     0,
       0,   860,     0,   861,     0,     0,     0,     0,     0,     0,
     318,     0,     0,     0,   862,   863,   864,     0,     0,     0,
       0,     0,     0,   865,     0,  -636,   319,     0,     0,     0,
       0,     0,     0,   399,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   866,     0,     0,  -636,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   400,     0,     0,     0,
       0,     0,     0,     0, -1823, -1823, -1823,     0,     0,     0,
    -636,  -636,     0,     0,     0,     0, -1823,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   401,     0,     0,
       0,     0,     0,   402, -1823,     0,     0,     0,   403,   867,
       0,   404,   405,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     406,  -636,     0,     0,     0,     0,     0,   868,     0,     0,
    -636,     0,     0,     0,     0,     0,     0,     0,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
     409,     0,     0, -1823, -1823, -1823,   410,     0,     0,     0,
       0,     0,     0, -1823,     0, -1823,     0,  1178,     0,     0,
       0,     0, -1823,     0,     0,   411, -1823, -1823, -1823,   320,
       0,     0,     0,     0,     0, -1823,     0,     0, -1823,  -636,
     412,     0,     0,     0,     0,  -636,   413,     0,  -636,     0,
    -636,     0,     0,     0,     0, -1823,     0,     0,  -636,     0,
       0,     0,     0,     0,   414,     0,     0,     0,  -636,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   415,     0,
    -636,     0,  -636,     0,   869,     0,     0,     0,   416,   417,
       0,     0,     0,     0,     0,     0,     0,   418,     0,     0,
     419,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  -636,     0,   420,     0,     0,     0,     0,
       0, -1823,     0,  -636,     0,     0,     0,  -636, -1823,     0,
       0,     0,     0,     0,     0,  -636,     0, -1563,     0,  -636,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -1823,
       0,     0,  -636,     0,     0,     0,  -636,   321,     0,  -636,
    -636,     0,   422,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  -636,   423,  -636,     0,     0,     0,
       0,   424,     0,   870,   871,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   872,     0,
       0, -1823,     0,     0,     0,  -636,   425,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2669,
    -636,     0,     0,     0, -3291,     0,     0,  -636,     0,     0,
   -2785,     0,     0,     0,     0,   322, -2785,     0,     0,   426,
   -2785, -2785, -2785,     0,   427,     0,     0,     0, -2785,  2670,
       0,     0, -1563,   873,     0,     0, -1823,     0,     0,     0,
    -636,     0,  -636,     0,  -636,     0,     0,     0,     0,     0,
       0, -2785, -2785, -2785, -2785, -2785, -2785, -2785, -2785,     0,
     874,     0,  -636,     0,     0,     0,     0,     0,   875,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  -636,
       0,     0,     0,     0,     0,     0,  -636,  -636,     0,     0,
       0,     0,     0,     0,     0,     0,   876,     0,     0,     0,
       0, -1823,     0,   207,     0,     0,     0,     0,     0, -1823,
    -636,     0,     0,     0,     0,     0,  -636,     0,   324,  -636,
    -636,     0,     0,     0,     0,     0, -2785,     0,     0,     0,
       0,     0,     0,     0,     0, -1823, -1823,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -636,     0,     0, -2785,     0,     0,     0,     0,     0,
   -2785, -2785,   847,  -636,     0,  -636,  -636,     0,   316,     0,
       0,     0,     0,     0,     0,     0, -2785, -1823,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -636,     0,     0,     0, -1823,     0,     0,  -636,     0,
       0,     0,     0,     0,     0,     0, -1823,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -1823,  -636,     0,     0,     0,     0,     0,  -636,
   -1823,     0,     0,     0,     0,     0,     0,  -636,     0,     0,
   -3291,  -636,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  -636,     0,     0,     0,     0,     0, -1823,     0,
       0,     0,     0,     0,     0, -1823,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  -636,     0,     0,     0,     0,
   -1823,     0,     0,     0,     0,     0,     0,     0, -2785,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    -636,     0,     0,     0,     0,  -636,     0, -2785,     0,     0,
       0,  -636,     0,     0,     0,  -636,   848,     0,     0,     0,
       0,     0,   849,   850,     0,     0,     0,     0,  -636,     0,
       0,     0,  -636,     0,     0,     0,     0,     0,   852,     0,
    -636,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -2785, -2785, -2785,     0,     0,     0,     0,     0,     0,
       0,  -636,     0, -2785,     0,     0,     0,     0,     0,  -636,
    -636,     0,     0,     0,     0, -2785, -2785,     0,  -636,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -2785,     0,     0,  -636,     0,     0,     0,     0,     0,
       0,     0,     0,   218,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -636,     0,
       0,     0, -2785,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -2785, -2785, -2785, -2785, -2785,     0,     0,     0,     0,     0,
   -2785,     0, -2785,     0,     0,     0,     0,     0,     0, -2785,
       0,     0,     0, -2785, -2785, -2785,     0,     0,     0,     0,
       0,     0, -2785,     0,     0, -2785,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -2785,     0,     0,     0,  1021,     0,     0,     0,
       0,     0,     0,   853,   854,   855,     0, -2785,     0,     0,
       0,     0, -2785, -2785,     0,   856,     0, -2785, -2785, -2785,
       0,     0,     0,     0,     0, -2785,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -2785,     0,     0,
       0,     0,     0,   317,     0,     0,     0, -2785, -2785, -2785,
   -2785, -2785, -2785, -2785, -2785, -2785, -2785,     0, -2785,     0,
       0,     0,     0,     0,     0, -2785,     0,     0,     0,     0,
       0,     0,     0, -2785,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -2785,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   857,   858,   859,     0,     0,     0, -2785,     0,
       0,     0,   860,     0,   861,     0,     0,     0,     0,     0,
       0,   318,     0, -2785,     0,   862,   863,   864,     0,     0,
       0,     0,     0,     0,   865,     0,     0,   319, -2785,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1021,   866,     0,     0,     0,     0,     0,
       0, -2785,     0,     0, -2785,     0,     0, -2785, -2785,     0,
   -2785,     0,     0,     0, -2785, -2785, -2785,     0,     0,     0,
       0,     0, -2785, -2785,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -2785,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0, -2785, -2785, -2785, -2785, -2785,
   -2785, -2785, -2785,     0,     0,     0,     0,     0,     0,     0,
     867,     0,     0,     0,     0,     0,     0,  3896,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   868,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -2785,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -2785,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -2785, -2785,     0, -2785,     0,     0,     0,     0,
     320,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2743, -2785,     0,     0,     0, -2785,     0,
       0,     0,     0,     0, -2785, -2785,     0,     0,     0,     0,
       0, -2785,     0, -2785,     0, -2785,     0,  2671,     0, -2785,
   -2785, -2785, -2785, -2785, -2785,     0, -2785, -2785,  2672,     0,
       0,     0,     0,     0,     0,   869,     0,     0, -2785, -2785,
   -2785,     0, -2785,     0,     0,     0,     0,     0,     0,     0,
   -2785,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -2785, -2785,     0,     0,     0,     0,     0, -2785,
       0,     0,     0,     0,     0,     0,     0, -2785, -2785,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3484,     0,     0,     0,     0, -2785,     0,     0,   321, -2785,
       0,     0, -2785,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -2785,     0,     0,
       0,     0, -2785,     0,   870,   871,     0, -2785, -2785, -2785,
   -2785, -2785,     0,     0,     0,     0,     0, -2785,     0, -2785,
       0, -2785,     0,     0,     0,     0, -2785,     0,     0,     0,
   -2785, -2785, -2785,     0,     0,     0,     0,     0,     0, -2785,
       0,     0, -2785,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   322,     0,     0, -2785,
       0,     0,     0,     0,     0, -2785, -2785, -2785,     0,     0,
       0,     0,     0,     0,   873,     0,     0, -2785,     0, -2785,
       0,     0,     0,     0,     0,  3485,     0,     0,     0, -2785,
   -2785,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   874,     0,     0, -2785, -2785,     0,     0,     0,   875,
       0,     0,     0,     0, -2785,     0,     0,     0,     0,     0,
       0,     0,     0, -2785,     0, -2785,     0,     0,     0,     0,
       0,     0, -2785,     0,     0,     0, -2785,   876,     0,     0,
   -2785,     0,     0,     0,   207,     0,     0,     0,     0,     0,
       0,     0,     0, -2785,     0,     0,     0,     0,     0,   324,
       0,     0,     0,     0, -2785, -2785, -2785, -2785, -2785,     0,
       0,     0,     0,     0, -2785, -2785, -2785,     0,     0,     0,
       0,  2984,     0, -2785,     0,  2985,     0, -2785, -2785, -2785,
       0,     0,     0,     0,     0,     0, -2785,     0,     0, -2785,
       0,     0,     0,     0,  2986, -2785,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -2785,  2987,     0,     0,
    3348,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -2814,     0,     0,     0,     0, -2785, -2814,     0,     0,
       0, -2814, -2814, -2814,     0,     0,     0,     0,     0, -2814,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -2785, -2785,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -2785, -2814, -2814, -2814, -2814, -2814, -2814, -2814, -2814,
   -2785,     0, -2785,     0,     0,  2485,     0,     0,     0, -2785,
    -296,     0,     0,     0,  -296,     0,     0, -2785,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -2785,   547,     0,  -296,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  -296,     0,     0,     0,
       0,     0, -2785, -2785,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -2814,     0,     0,
       0,     0,     0,     0,  -296,     0,     0,     0,     0, -2785,
   -2785,     0, -2785,     0,     0,     0,     0,     0,     0,     0,
       0,  3371,     0,     0,     0,     0,   792,     0,     0,     0,
       0,     0,     0,     0,     0, -2814,     0,     0,     0,     0,
       0, -2814, -2814,     0,     0,     0,     0,     0, -2785,     0,
   -2785,     0, -2785,     0,     0,     0, -2785, -2814, -2785, -2785,
   -2785, -2785,     0, -2785, -2785,     0,     0, -2785,     0,     0,
    -296,     0,     0,     0,     0,     0,     0,     0,     0, -2785,
       0,     0,  2988,     0,     0,     0,     0,     0,     0,     0,
    -778,  -778,  -778,  -778,  -778,     0,  -778,  -778,     0,     0,
       0,     0,     0,     0,     0,     0, -2785,     0,     0,     0,
       0,     0,     0,     0, -2785,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  -296,     0,     0,     0,     0,
   -2785,     0, -2785,     0,     0,     0,     0,     0,     0, -2785,
       0,     0,     0,     0,     0,     0,  2989,  2990,     0,     0,
       0,     0,     0,     0, -2785,     0, -2785, -2785,     0, -2814,
       0,     0,     0,     0,     0,  -778,     0,  -778,  -778,  -778,
    -778,  -778,  -778,  -778,  -778,  -778,     0,     0, -2814,     0,
       0,  -296,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0, -2785,     0, -2785,     0, -2785,
       0,     0,     0, -2785,     0, -2785, -2785, -2785, -2785,     0,
   -2785, -2785,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -2814, -2814, -2814,     0, -2785,     0,     0,     0,
       0,     0,  2991,     0, -2814,     0,     0,     0,     0,     0,
       0,  -778,  -778,     0,     0,     0, -2814, -2814,     0,     0,
       0,     0,     0, -2785,     0,  -296,  -296,   793,     0,     0,
       0, -2785, -2814,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2992, -2785,
       0,     0,     0,     0,     0,     0, -2785,     0,     0,     0,
       0,     0,     0,     0,  -383,     0,     0,     0,     0,     0,
       0, -2785,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -2814, -2814, -2814, -2814, -2814,     0,     0,     0,     0,
       0, -2814,     0, -2814,     0,     0,     0,     0,     0,     0,
   -2814,  -296,     0,     0, -2814, -2814, -2814,     0,     0,     0,
       0,     0,     0, -2814,     0,     0, -2814,  -778,  -778,  -778,
    -778,  -778,     0,  -778,  -778,  -778,  -296,     0,     0,     0,
    2993,     0,     0, -2814,     0,     0,     0,  3348,     0,     0,
       0,     0,     0,     0,     0,     0,  -778,     0, -2814,     0,
       0,     0,     0, -2814, -2814,     0,     0,  -296, -2814, -2814,
   -2814,     0,  -778,     0,     0,     0, -2814,     0,     0,     0,
       0,     0,  2994,  -296,     0,     0,     0,     0, -2814,     0,
    2995,     0,     0,     0,     0,     0,  -778,     0, -2814, -2814,
   -2814, -2814, -2814, -2814, -2814, -2814, -2814, -2814,     0, -2814,
       0,     0,     0,     0,     0,     0, -2814,     0,     0,     0,
       0,     0,     0,     0, -2814,     0,   794,  3706,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -2814,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  -296,
       0,     0,     0,     0,     0,     0,     0,     0,  2996, -2814,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2997, -2814,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -2814,
    2998,  -296,     0,     0,     0,     0,     0,     0,     0,  -296,
       0,     0,     0,     0,     0,     0,  -778,     0,     0,     0,
       0,     0, -2814,     0,     0,     0,     0,     0, -2814, -2814,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -2814,  -296,     0,     0,   795,     0,
       0,     0,     0,     0, -2814,     0,     0,     0, -3297,     0,
       0,     0,     0,     0,  2999,     0,     0,     0,     0,     0,
       0,  3372,     0,     0,     0,     0,     0,  -296,  3000,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  -296,     0,  -778,     0,     0,  -380,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  -296,
       0,     0,     0,     0,     0,  -778,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -2814,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -778,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   796,     0, -2814, -2814,  3001, -2814,  -296,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -296,  -296,     0,
       0,  3002,  3003,  -296,     0, -2814,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -296,     0,     0,
       0,     0, -2814,     0, -2814,     0, -2814,     0,     0,     0,
   -2814,     0, -2814, -2814, -2814, -2814,  -296, -2814, -2814,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -2814,
   -2814, -2814,     0, -2814,     0,     0,     0,     0,     0,     0,
       0, -2814,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -2814, -2814,     0,     0,     0,     0,     0,
   -2814,     0,     0,     0,     0,     0,     0,     0, -2814, -2814,
    -296,     0,     0,     0,  -296,     0,  -778,  -778,  -778,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    -296,  -296,     0,     0,     0,     0, -2814,     0,     0,     0,
       0,     0,     0, -2814,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -2814,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -2814, -2814,
   -2814, -2814, -2814,     0,     0,     0,     0,     0, -2814,     0,
   -2814,     0,     0,     0,     0,     0,     0, -2814,     0,     0,
       0, -2814, -2814, -2814,     0,     0,     0,     0,     0,     0,
   -2814,     0,     0, -2814,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -2814,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  -778,  -778,  -778,     0,
   -2814,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -778,     0,     0,     0, -2814,     0,     0,     0,     0,
       0,     0,     0,     0,     0, -2814,     0,     0,     0,     0,
       0,     0,     0,     0, -2814,     0, -2814,     0,     0,     0,
       0,     0,     0, -2814,  3373,     0,     0,     0,     0, -3137,
       0, -2814,     0,     0,     0,  1446,     0,     0,     0, -3137,
       0,     0,     0,  1447, -2814,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0, -3137,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -2814,     0,     0,     0,
       0,     0,     0,     0,     0,  1448, -3137,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -2814,     0,     0,     0,
       0,     0,     0,     0, -3137,  1449,  1450,  1451,  1452,  1453,
    1454,  1455,  1456,     0,     0,     0,     0, -3137, -3137, -3137,
       0,  1457, -3137,     0,     0,     0,  1458,     0,     0, -3137,
       0,     0,     0,     0,     0,     0,     0,  1459,  1460,  1461,
    1462, -3137,     0, -3137, -3137,     0,     0,     0,     0,     0,
       0, -2814,     0,     0,     0,  1463,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1464,     0,     0,  1465,  1466,
    1467, -3137,  1468,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1469,     0,     0,     0,
       0,     0,     0,     0,     0,  1470,  1471,  1472,  1473,  1474,
    1475,  1476,  1477,     0, -2814,     0, -3137,     0,  1478,     0,
    1479,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -3137,     0,     0,     0,     0,     0,     0,
   -2814, -2814,     0,     0,     0,     0,     0,     0,     0,  1480,
    1481,     0,     0,  1482,  1483,     0, -3137, -3137,  1484, -3137,
   -3137,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -2814,
    1485, -2814,     0, -2814,     0,     0,     0, -2814,     0, -2814,
   -2814, -2814, -2814,     0, -2814, -2814,     0,     0,     0,     0,
       0,     0,     0,     0, -3137,  1486,     0,     0,     0,  1487,
   -2814,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -3137,     0,     0,     0,  1488,     0,     0,     0,     0,     0,
    1489,  1490,     0,     0,     0,     0,     0, -2814,     0,     0,
       0,     0,     0,     0,     0, -2814,     0,     0,     0,  1491,
    1492,  1493,  1494,  1495,     0,     0,  1496,     0,     0,     0,
   -3137, -3137, -3137,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -2814,     0,     0,     0,     0,     0,     0,
   -2814,     0,     0, -3137,     0,     0,     0,     0, -3137,     0,
       0,     0,     0,     0,     0, -2814,     0,  1497,  1498,  1499,
    1500,     0,     0,     0,     0,     0,  1501,  1502,     0,  1503,
       0,  1504,  1505,  1506, -3137, -3137,  1507,     0,  1508,     0,
   -3137, -3137,  1509,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1510,  1511,     0,     0,     0,     0,     0,     0,     0,
       0,  1512,  1513,  1514,  1515,  1516,  1517,     0,     0,     0,
       0,     0,     0,     0,     0,  1518,     0,     0,     0,  1519,
       0,     0,     0,  1521,     0, -3137,     0, -3137,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -3137,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -3137, -3137, -3137,
       0,     0,  1522,     0,     0,     0,  1523,     0,  1524,  1525,
    1526,  1527,     0,     0,     0,     0,     0,     0,     0,  1528,
       0,     0,     0,     0,     0, -3137,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1529,     0,     0,     0,
       0,     0,     0,     0,  1530,     0,     0,     0,     0, -3137,
   -3137, -3137,     0, -3137,     0, -3137, -3137,     0, -3137, -3137,
   -3137,     0,     0,     0,     0,  1612, -3137,     0, -3137, -3137,
   -3137, -3137,     0,     0,     0,     0,     0,     0,     0,     0,
    1531,  1532,     0,     0, -3137,     0,     0,     0,     0,     0,
       0,     0, -3137,     0,   362,     0,     0,     0,   363,     0,
       0,     0,     0,     0,   364,     0,     0, -3137, -3137,     0,
       0,     0,   365,     0,     0,  1533, -3137,     0,  1534,     0,
       0,   366, -3137,     0,     0,     0,     0,     0,     0,  1535,
       0,     0,     0,     0,     0,  1536,     0,     0,     0,  1537,
       0,  1538,  1539,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1540,     0,     0,  1541,  1542,
       0,     0,     0,     0,  1543,     0,     0,     0,     0, -3137,
       0,     0,     0,     0,     0, -3137,     0,     0,     0,     0,
    1544,     0,  1545,  1546,     0,     0,     0,     0,     0,     0,
       0,  1547,  1548,     0,   367,   368,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   847,     0,     0,     0,     0,
       0,   316,     0,     0,  1549,  1550,  1551,     0,     0,     0,
       0,     0,     0,     0,     0,   369,     0,     0, -3137, -3137,
   -3137,     0,     0,     0,  1552,  1553,  1554,  1555, -3137,  1556,
       0,     0,     0,  1557,  1558,   370,     0,     0,     0,   371,
       0,  1559,  1560,     0,     0,     0,     0,     0,     0,     0,
    1561,  1562,  1563, -3137,     0,     0,     0,   372,  1564,     0,
       0,     0,     0,  1565,     0,     0, -3137, -3137, -3137, -3137,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1566,     0,     0,     0,     0, -3137, -3137,     0,     0,
       0,     0,     0,     0,  1567,  1568,     0, -3137,     0,     0,
    1569,     0,   373,     0,     0,     0,  1613,     0,   374,     0,
     375,     0,     0,     0,   376,     0,     0,     0,     0,   377,
       0,     0,     0,  1570,  1571,     0,     0, -3137,     0,     0,
       0,     0,  1572,     0,     0,     0,   378,     0,     0,     0,
    1573, -3137, -3137,     0,     0,     0,  1574,     0,     0,   848,
       0,     0,     0,     0,     0,   849,   850,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   852,     0,   379,     0,     0,  1575,     0, -3137,     0,
       0,     0,  1576,     0,     0,     0,     0,     0, -3137,   380,
       0,     0,     0,     0,   381, -3137,     0,     0,     0,     0,
     382,   383,     0,     0,     0,     0, -3137,     0,     0,     0,
   -3137, -3137, -3137,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1577,     0,     0,     0,
       0, -3137, -3137,  1578,     0,  1579, -3137, -3137,  1580, -3137,
       0,     0,     0,     0,     0,  1581, -3137,     0,     0,     0,
       0,   384,     0,     0,     0,     0,     0,     0,  1582,     0,
     385,     0,  1583,   386,     0,     0,     0,     0,   387,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0, -3431,     0,     0,     0,     0,
       0,     0,     0,     0,   388,     0,     0,     0,     0,     0,
       0,     0,   389,     0,   390,     0,     0,   391,     0,     0,
     392,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   393,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   853,   854,   855,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   856,     0,
       0,  1016,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   317,     0,     0,     0,
       0,     0,   394,     0,     0,     0,     0,     0,     0,   395,
       0,   396,     0,     0,   397,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     398,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   857,   858,   859,     0,     0,
       0,     0,     0,     0,     0,   860,     0,   861,     0,     0,
       0,     0,     0,     0,   318,     0,     0,     0,   862,   863,
     864,     0,     0,     0,     0,   399,     0,   865,     0,     0,
     319,     0,  1256,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   866,   400,     0,
   -3431, -3431, -3431, -3431,     0,     0,     0,     0, -3431,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -3431, -3431,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   401,
       0, -3431,     0,     0,     0,   402,     0,     0,     0,     0,
     403,     0,     0,   404,   405,     0,     0,     0,     0,     0,
       0,     0,     0,   867,     0,     0,     0,     0,     0,     0,
       0,     0,   406,     0,     0,     0, -3283, -3431,     0,     0,
   -3283,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     407,   868,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,   409,     0,     0,     0,     0,     0,   410,     0,
       0,     0,     0,     0,     0,     0, -3431,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   411,     0,     0,
       0,     0,     0,  1446,     0,     0,     0,     0,     0,     0,
       0,  1447,   412,   320,     0,     0,     0,     0,   413,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   414,     0,     0,     0,
       0,     0, -1214,  1448,     0,     0,     0,     0,     0,     0,
     415,     0,     0,     0,     0, -1214, -1214, -1214, -1214,     0,
     416,   417,     0, -1214,     0,     0,  1018,     0,   869,   418,
       0,     0,   419,  1449,  1450,  1451,  1452,  1453,  1454,  1455,
    1456, -1214, -1214,     0,     0,     0,     0,   420,     0,  1457,
       0,     0,     0,     0,  1458,     0,     0,     0,     0,     0,
       0,     0, -1214,     0,     0,  1459,  1460,  1461,  1462,     0,
   -3431,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1463, -1214,     0,     0,     0,     0,     0,
       0, -1214, -1214,  1464,   422, -1214,  1465,  1466,  1467,     0,
    1468,   321,     0,     0,     0,     0,     0,   423,     0,     0,
       0,     0,     0,   424,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   870,   871, -3431,
       0,     0,     0,     0,  1469,     0,     0,     0,   425,     0,
   -1214,     0,     0,  1470,  1471,  1472,  1473,  1474,  1475,  1476,
    1477,     0,     0,     0,     0,     0,  1478,     0,  1479,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -3431,   426,     0,     0,     0,     0,   427,     0,     0,   322,
       0,     0,     0,     0,     0, -1214, -1214,  1480,  1481,     0,
       0,  1482,  1483,     0,     0,     0,  1484,   873,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1485,     0,
       0,     0,     0,     0,   874,     0,     0,     0,     0,     0,
       0,     0,   875,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -3283,  1486,     0,     0,     0,  1487,     0,     0,
       0,     0,     0,     0,     0, -1214,     0,     0,     0,     0,
     876,     0,  1488,     0, -3431,     0,   533,   207,  1489,  1490,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   324,     0,  1259,     0,     0,  1491,  1492,  1493,
    1494,  1495,     0,     0,  1496,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -3431,     0,     0, -1214,     0,     0,     0,     0,     0,
       0,     0,     0, -1214,     0, -1214,     0,     0,     0,     0,
       0,     0,     0, -1214,     0,  1497,  1498,  1499,  1500,     0,
       0,     0,     0, -1214,  1501,  1502,     0,  1503,     0,  1504,
    1505,  1506,     0,     0,  1507, -1214,  1508, -1214,     0,     0,
    1509,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -3431,     0,     0,     0,     0,     0,     0,  1510,
    1511,     0,     0,     0,     0,     0,     0,     0, -1214,  1512,
    1513,  1514,  1515,  1516,  1517,     0, -3283, -3283, -1214,     0,
       0,     0,     0,  1518,     0,     0,     0,  1519,     0,     0,
   -1214,  1521,     0,     0, -1214,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -1214,     0,     0,
       0, -1214,     0,     0,     0, -1214,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -1214,
    1522, -1214,     0,     0,  1523,     0,  1524,  1525,  1526,  1527,
       0,     0,     0,     0,     0,     0,     0,  1528,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -1214,     0,     0, -3431,  1529, -3431, -3431,     0,     0,     0,
       0,     0,  1530,     0,     0, -1214,     0,     0,     0,     0,
       0,     0, -1214,     0,     0, -3431,     0,     0,   848,     0,
   -3431,     0,     0,  1612,   849,   850,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1531,  1532,
     852,     0,     0,     0,     0,     0,     0, -1214,     0, -1214,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -3431,
       0,     0,     0,     0,     0,     0,     0, -1214,     0,     0,
       0, -3431,     0,  1533,     0,     0,  1534,     0,     0,     0,
       0,     0,     0,     0, -1214,     0,     0,  1535,     0,     0,
       0, -1214, -1214,  1536,     0,     0,     0,  1537,     0,  1538,
    1539,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1540,     0, -1214,  1541,  1542,     0,     0,
       0,     0,  1543,     0, -1214,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1544,     0,
    1545,  1546,     0,     0,     0,     0,     0,     0,     0,  1547,
    1548,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -1214,     0,     0,     0,
   -3431,     0,  1549,  1550,  1551,     0,     0,     0, -1214,     0,
   -1214, -1214,     0,     0,  2015,     0,     0,     0,     0,     0,
       0,     0,  1552,  1553,  1554,  1555,     0,  1556,     0,     0,
       0,  1557,  1558,     0,     0,     0,     0,     0,     0,  1559,
    1560,     0,     0, -1214,     0,   853,   854,   855,  1561,  1562,
    1563,     0,     0,     0,     0,     0,  1564,   856,     0,     0,
       0,  1565,   533,     0,     0,     0,     0,     0, -1214,     0,
       0,     0,     0,     0, -1214,     0,     0,     0,     0,  1566,
       0,     0, -1214,     0,     0,   317, -1214,     0,     0,     0,
       0,     0,  1567,  1568,     0,     0,     0,     0,  1569,     0,
       0,     0,     0,     0,  1613,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -1214,  1570,  1571,     0,     0,     0,     0,     0,     0,     0,
    1572,     0,     0,     0,     0,     0,     0,     0,  1573,     0,
       0,     0,     0,     0,  1574, -1214,   859,     0,     0,     0,
   -1214,     0,     0,     0,     0,     0, -1214,     0,     0,     0,
   -1214,     0,     0,   318,     0,     0,     0,   862,   863,   864,
       0,     0,     0, -1214,  1575,     0,   865,     0,     0,   319,
    1576,     0,     0,     0,     0, -1214,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1446,     0,     0,     0,     0,
       0,     0,     0,  1447,     0,     0, -1214,     0,     0,     0,
       0,     0,     0,     0, -1214, -1214,     0,     0,     0,     0,
       0,     0,     0, -1214,  1577,     0,     0,     0,     0,     0,
       0,  1578,     0,  1579, -1215,  1448,  1580,     0,     0,     0,
       0,     0,     0,  1581,     0,     0,     0, -1215, -1215, -1215,
   -1215,     0,     0,     0,     0, -1215,  1582,     0,     0,     0,
    1583,     0,   867, -1214,     0,  1449,  1450,  1451,  1452,  1453,
    1454,  1455,  1456, -1215, -1215,     0,     0,     0,     0,     0,
       0,  1457,     0,     0,     0,     0,  1458,     0,     0,     0,
       0,     0,     0,     0, -1215,     0,     0,  1459,  1460,  1461,
    1462,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1463, -1215,     0,     0,     0,
       0,     0,     0, -1215, -1215,  1464,     0, -1215,  1465,  1466,
    1467,     0,  1468,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   320,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1469,     0,     0,     0,
       0,     0, -1215,     0,     0,  1470,  1471,  1472,  1473,  1474,
    1475,  1476,  1477,     0,     0,     0,     0,     0,  1478,     0,
    1479,     0,     0,     0,     0,     0,     0,   869,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -1215, -1215,  1480,
    1481,     0,     0,  1482,  1483,     0,     0,     0,  1484,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1485,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     321,     0,     0,     0,     0,  1486,     0,     0,     0,  1487,
       0,     0,     0,     0,     0,     0,     0, -1215,     0,     0,
       0,     0,     0,     0,  1488,     0,   870,   871,     0,     0,
    1489,  1490,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1491,
    1492,  1493,  1494,  1495,     0,     0,  1496,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -1215,     0,   322,     0,
       0,     0,     0,     0,     0, -1215,     0, -1215,     0,     0,
       0,     0,     0,     0,     0, -1215,   873,  1497,  1498,  1499,
    1500,     0,     0,     0,     0, -1215,  1501,  1502,     0,  1503,
       0,  1504,  1505,  1506,     0,     0,  1507, -1215,  1508, -1215,
       0,     0,  1509,   874,     0,     0,     0,     0,     0,     0,
       0,   875,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1510,  1511,     0,     0,     0,     0,     0,     0,     0,
   -1215,  1512,  1513,  1514,  1515,  1516,  1517,     0,     0,   876,
   -1215,     0,     0,     0,     0,  1518,   207,     0,     0,  1519,
       0,     0, -1215,  1521,     0,     0, -1215,     0,     0,     0,
       0,   324,     0,     0,     0,     0,     0,     0,     0, -1215,
       0,     0,     0, -1215,     0,     0,     0, -1215,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -1215,  1522, -1215,     0,     0,  1523,     0,  1524,  1525,
    1526,  1527,     0,     0,     0,     0,     0,     0,     0,  1528,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -1215,     0,     0,     0,  1529,     0,     0,     0,
       0,     0,     0,     0,  1530,     0,     0, -1215,     0,     0,
       0,     0,     0,     0, -1215,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1612,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1531,  1532,     0,     0,     0,     0,     0,     0,     0, -1215,
       0, -1215,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -1215,
       0,     0,     0,     0,     0,  1533,     0,     0,  1534,     0,
       0,     0,     0,     0,     0,     0, -1215,     0,     0,  1535,
       0,     0,     0, -1215, -1215,  1536,     0,     0,     0,  1537,
       0,  1538,  1539,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1540,     0, -1215,  1541,  1542,
       0,     0,     0,     0,  1543,     0, -1215,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1544,     0,  1545,  1546,     0,     0,     0,     0,     0,     0,
       0,  1547,  1548,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -1215,     0,
       0,     0,     0,     0,  1549,  1550,  1551,     0,     0,     0,
   -1215,     0, -1215, -1215,     0,     0,   588,     0,     0,     0,
       0,     0,   589,     0,  1552,  1553,  1554,  1555,     0,  1556,
     590,     0,     0,  1557,  1558,     0,     0,     0,     0,   591,
       0,  1559,  1560,     0,     0, -1215,     0,     0,     0,     0,
    1561,  1562,  1563,     0,     0,     0,     0,     0,  1564,     0,
       0,     0,     0,  1565,     0,     0,     0,     0,     0,     0,
   -1215,     0,     0,     0,     0,     0, -1215,     0,     0,     0,
       0,  1566,     0,     0, -1215,     0,     0,     0, -1215,     0,
       0,     0,     0,     0,  1567,  1568,     0,     0,     0,     0,
    1569,     0,     0,     0,     0,     0,  1613,     0,     0,     0,
       0,     0,   592,   593,     0,     0,     0,     0,     0,     0,
       0,     0, -1215,  1570,  1571,     0,     0,     0,     0,     0,
       0,     0,  1572,     0,     0,     0,     0,     0,     0,     0,
    1573,     0,     0,   594,     0,     0,  1574, -1215,   847,     0,
       0,     0, -1215,     0,   316,     0,     0,     0, -1215,     0,
       0,     0, -1215,   595,     0,     0,     0,   596,     0,     0,
       0,     0,     0,     0,     0, -1215,  1575,     0,     0,     0,
       0,     0,  1576,     0,     0,   597,     0, -1215,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -1215,     0,
       0,     0,     0,     0,     0,     0, -1215, -1215,     0,     0,
       0,     0,     0,     0,     0, -1215,  1577,     0,     0,     0,
     598,     0,     0,  1578,     0,  1579,     0,     0,  1580,     0,
       0,     0,   599,     0,     0,  1581,     0,   600,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1582,     0,
       0,     0,  1583,     0,     0, -1215,   601,     0,     0,     0,
       0,   602,   603,   604,   605,     0,   606,   607,   608,   609,
       0,   610,     0,   611,   612,   613,     0,   614,   615,   616,
     617,   618,     0,   619,   620,   621,   622,   623,   624,     0,
       0,   625,   848,     0,     0,     0,     0,     0,   849,   850,
       0,     0,     0,     0,     0,     0,     0,   626,  1109,     0,
       0,     0,     0,     0,   852,     0,     0,     0,   627,   628,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   629,
       0,     0,     0,     0,     0,     0,     0,     0,   630,     0,
       0,   631,     0,     0,     0,     0,   632,     0,     0,     0,
       0,     0,  2906,  2907,  2908,  2909,  2910,     0,  2911,  2912,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   633,     0,     0,     0,     0,     0,     0,     0,
     634,     0,   635,     0,     0,   636,     0,     0,   637,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2913,     0,  2914,
    2915,  2276,  2916,  2917,  2918,  2919,  2920,  2921,     0,   853,
     854,   855,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   856,     0,     0,     0,     0,     0,     0,     0,     0,
     638,     0,     0,     0,     0,     0,     0,   639,     0,   640,
       0,     0,   641,     0,     0,     0,     0,     0,     0,   317,
       0,     0,     0,     0,     0,     0,     0,     0,   642,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2922,  2923,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   857,   858,
     859,     0,     0,   643,     0,     0,     0,     0,   860,     0,
     861,     0,     0,     0,     0,     0,     0,   318,     0,     0,
       0,   862,   863,   864,     0,     0,   644,     0,     0,     0,
     865,     0,     0,   319,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     866,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   645,  2924,
    2925,  2926,  2927,  2928,     0,  2283,  2284,  2929,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     646,     0,     0,     0,     0,     0,     0,     0,  2930,     0,
       0,     0,     0,     0,     0,     0,   867,     0,     0,     0,
       0,     0,     0,   647,  2931,     0,     0,     0,     0,     0,
     648,     0,     0,     0,     0,     0,   649,     0,     0,     0,
       0,     0,     0,     0,   868,     0,     0,     0,  2932,     0,
       0,     0,     0,     0,     0,   650,     0,     0,     0,     0,
       0,  1446,     0,     0,     0,     0,     0,     0,     0,  1447,
       0,     0,     0,     0,     0,     0,   651,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   652,     0,   320,     0,     0,     0,
       0,  1448,     0,     0,     0,     0,     0,     0,   653,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   654,   655,
       0,     0,     0,     0,     0,     0,     0,   656,     0,     0,
     657,  1449,  1450,  1451,  1452,  1453,  1454,  1455,  1456,     0,
       0,     0,     0,     0,     0,   658,     0,  1457,     0,     0,
       0,   869,  1458,     0,     0,     0,     0,     0,  2933,     0,
       0,     0,     0,  1459,  1460,  1461,  1462,   659,   847,     0,
       0,     0,     0,     0,   316,     0,     0,     0,     0,     0,
       0,  1463,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1464,   660,     0,  1465,  1466,  1467,     0,  1468,     0,
       0,     0,     0,     0,     0,   661,     0,     0,     0,     0,
       0,   662,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   321,     0,     0,     0,     0,     0,
       0,     0,  1469,     0,     0,     0,  2934,     0,     0,     0,
       0,  1470,  1471,  1472,  1473,  1474,  1475,  1476,  1477,     0,
     870,   871,     0,     0,  1478,     0,  1479,  2935,     0,     0,
       0,     0,     0,     0,     0,  1110,     0,     0,     0,   663,
       0,     0,     0,     0,   664,     0,     0,     0,     0,     0,
    2936,     0,     0,     0,     0,  1480,  1481,     0,     0,  1482,
    1483,     0,     0,     0,  1484,     0,     0,     0,     0,     0,
       0,     0,   322,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1485,     0,     0,     0,
     873,     0,   848,     0,     0,     0,     0,     0,   849,   850,
       0,     0,     0,     0,     0,     0,     0,     0,  1045,     0,
       0,  1486,     0,     0,   852,  1487,     0,   874,     0,     0,
       0,     0,     0,     0,     0,   875,     0,     0,     0,     0,
    1488,     0,     0,     0,     0,     0,  1489,  1490,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   876,     0,  1491,  1492,  1493,  1494,  1495,
     207,     0,  1496,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   324,     0,     0,  2937,  2938,
    2939,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1497,  1498,  1499,  1500,     0,     0,     0,
       0,     0,  1501,  1502,     0,  1503,     0,  1504,  1505,  1506,
       0,     0,  1507,     0,  1508,     0,     0,     0,  1509,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1510,  1511,     0,
       0,     0,     0,     0,     0,     0,     0,  1512,  1513,  1514,
    1515,  1516,  1517,     0,     0,     0,     0,     0,     0,     0,
       0,  1518,     0,     0,     0,  1519,     0,     0,     0,  1521,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   853,
     854,   855,     0,     0,     0,     0,     0,     0,  2940,  2941,
    2942,   856,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1522,     0,
       0,     0,  1523,  2943,  1524,  1525,  1526,  1527,     0,   317,
       0,     0,     0,     0,     0,  1528,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1529,     0,     0,     0,     0,     0,     0,     0,
    1530,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1612,     0,     0,     0,     0,     0,     0,   857,   858,
     859,     0,     0,     0,     0,     0,  1531,  1532,   860,     0,
     861,     0,     0,     0,     0,     0,     0,   318,     0,     0,
       0,   862,   863,   864,     0,     0,     0,     0,     0,     0,
     865,     0,     0,   319,     0,     0,     0,     0,     0,     0,
       0,  1533,     0,     0,  1534,     0,     0,     0,     0,     0,
     866,     0,     0,     0,     0,  1535,     0,     0,     0,     0,
       0,  1536,     0,     0,     0,  1537,     0,  1538,  1539,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1540,     0,     0,  1541,  1542,     0,     0,     0,     0,
    1543,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1544,     0,  1545,  1546,
       0,     0,     0,     0,     0,     0,   867,  1547,  1548,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1549,  1550,  1551,     0,   868,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1552,  1553,  1554,  1555,     0,  1556,     0,     0,     0,  1557,
    1558,     0,     0,     0,     0,     0,     0,  1559,  1560,     0,
       0,     0,     0,     0,     0,     0,  1561,  1562,  1563,     0,
       0,     0,     0,     0,  1564,     0,   320,     0,     0,  1565,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1566,     0,     0,
       0,     0,     0,     0,  1446,     0,     0,     0,     0,     0,
    1567,  1568,  1447,     0,     0,     0,  1569,     0,     0,     0,
       0,     0,  1613,     0,     0,     0,     0,     0,     0,     0,
       0,   869,     0,     0,     0,     0,     0,     0,     0,  1570,
    1571,     0,     0,     0,  1448,     0,     0,     0,  1572,     0,
       0,     0,     0,     0,     0,     0,  1573,     0,     0,     0,
       0,     0,  1574,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1449,  1450,  1451,  1452,  1453,  1454,
    1455,  1456,     0,     0,     0,     0,     0,     0,     0,     0,
    1457,     0,  1575,     0,     0,  1458,     0,     0,  1576,     0,
       0,     0,     0,     0,   321,     0,  1459,  1460,  1461,  1462,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1463,     0,     0,     0,     0,     0,
     870,   871,     0,     0,  1464,     0,     0,  1465,  1466,  1467,
       0,  1468,  1577,     0,     0,     0,     0,     0,     0,  1578,
       0,  1579,     0,     0,  1580,     0,     0,     0,     0,     0,
       0,  1581,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1582,  1469,     0,     0,  1583,     0,
       0,     0,   322,     0,  1470,  1471,  1472,  1473,  1474,  1475,
    1476,  1477,     0,     0,     0,     0,     0,  1478,     0,  1479,
     873,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   874,  1480,  1481,
       0,     0,  1482,  1483,     0,   875,     0,  1484,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1485,
       0,     0,     0,   876,     0,     0,     0,     0,     0,     0,
     207,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1486,   324,     0,     0,  1487,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1488,     0,     0,     0,     0,     0,  1489,
    1490,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1491,  1492,
    1493,  1494,  1495,     0,     0,  1496,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2401,     0,     0,     0,     0,     0,  1497,  1498,  1499,  1500,
       0,     0,     0,     0,     0,  1501,  1502,     0,  1503,     0,
    1504,  1505,  1506,     0,     0,  1507,     0,  1508,     0,     0,
       0,  1509,     0,     0,     0,     0,  2402,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1510,  1511,     0,     0,     0,     0,  2403,     0,     0,     0,
    1512,  1513,  1514,  1515,  1516,  1517,     0,     0,     0,     0,
       0,     0,     0,     0,  1518,     0,     0,     0,  1519,  1520,
       0,     0,  1521,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2404,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1522,     0,  -697,     0,  1523,     0,  1524,  1525,  1526,
    1527,     0,     0,     0,     0,     0,     0,     0,  1528,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1529,     0,     0,     0,     0,
       0,     0,     0,  1530,     0,     0,   847,     0,     0,     0,
       0,     0,   316,     0,     0,     0, -3333, -3333, -3333,     0,
       0,     0,     0,     0,  1403,  2405,     0,     0,     0,     0,
       0,     0,     0,  2406,     0,     0,     0,     0,     0,  1531,
    1532,     0,     0,     0,     0,     0,     0,  1404,  1405,  1406,
    1407,  1408,  1409,  1410,  1411,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1533,     0,     0,  1534,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1535,     0,
       0,     0,     0,     0,  1536,     0,     0,     0,  1537,     0,
    1538,  1539,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1540,     0,     0,  1541,  1542,     0,
       0,     0, -3333,  1543,     0,     0,     0,     0,     0,     0,
       0, -3333, -3333,     0,     0,     0,     0,     0,     0,  1544,
       0,  1545,  1546,     0,     0,     0,     0,     0,     0,     0,
    1547,  1548,     0,     0,     0,     0,     0,     0,     0,     0,
     848,     0,     0,     0,     0,     0,   849,   850,     0,     0,
       0,  2407,     0,  1549,  1550,  1551,     0,     0,     0,     0,
       0,     0,   852,     0,     0,     0,     0,     0, -3333,     0,
       0,     0,     0,  1552,  1553,  1554,  1555,     0,  1556,     0,
       0,     0,  1557,  1558,     0,     0,     0,     0,     0,     0,
    1559,  1560,     0,     0,     0,     0,     0,     0, -3333,  1561,
    1562,  1563,     0,     0,     0,     0,     0,  1564,     0,     0,
       0,     0,  1565,     0,     0,     0,     0,     0,     0,     0,
       0,  2408,     0,    59,     0,     0,     0,     0,     0,     0,
    1566,     0,     0,  2409,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1567,  1568, -3404,     0,     0,     0,  1569,
       0,     0,     0,     0,     0,     0,  -697,  2410,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -697,     0,
       0,     0,  1570,  1571, -3333,     0,     0,  -697,     0,     0,
       0,  1572,     0,     0,     0,     0,     0,     0,     0,  1573,
       0,   847,     0,  1412,     0,  1574,     0,   316,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1575,     0,     0,     0,     0,
       0,  1576,     0,     0,     0,     0,     0,   853,   854,   855,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   856,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -3333, -3333,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2411,     0,     0,  1577,     0,   317,     0,     0,
       0,     0,  1578,     0,  1579,     0,     0,  1580,     0,     0,
       0,     0,     0,     0,  1581,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1582,  1413,  2412,
       0,  1583,     0,     0,     0,     0,     0,     0,     0,     0,
    2413,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    -697,     0,     0,     0,     0,     0,   857,   858,   859, -3333,
   -3333,     0,     0,     0,     0,   848,   860,     0,   861,     0,
       0,   849,   850,     0,     0,   318,     0,     0,     0,   862,
     863,   864,     0,     0,     0,     0,     0,   852,   865,     0,
    2414,   319,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -697,   866,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   847,     0,     0,     0,     0, -3333,   316,
       0,     0,     0,  2072,  2073,  2074,     0,     0,     0,     0,
       0,  3671,     0,     0,     0,  2415,     0,     0,  -697,     0,
       0,     0,     0,  1414,     0,     0,     0,     0,     0,     0,
       0,     0,  2416, -3333,  3672,  3673,  3674,  3675,  3676,  3677,
    3678,  3679, -3333,     0,   867,     0,     0,     0,     0,     0,
       0, -3333,     0,  2417,     0,     0,     0,     0,     0,  1415,
       0,   847,     0,     0,     0,     0,     0,   316, -3333,     0,
       0,     0,   868,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -1924,     0, -3333,     0,     0,     0,     0,     0,
       0,  2418,     0,     0,     0,     0,     0,     0,     0,  2075,
   -1924, -1924, -1924, -1924,     0,     0,     0,     0, -1924,     0,
       0,     0,     0,     0,   320,     0,     0,     0,     0,     0,
       0,     0,   853,   854,   855,  -697, -1924, -1924,     0,     0,
       0,     0,     0,     0,   856,     0,     0,   848,     0,     0,
       0,     0,     0,   849,   850,     0,     0,     0, -3404,     0,
       0,     0,     0,     0,     0,  2419, -3333,     0,     0,   852,
       0,     0,   317,     0,     0,     0,     0,     0,     0,   869,
       0,     0,     0,     0,     0,     0, -1924, -1924,     0,     0,
   -1924,  2420,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2421,     0,  2422,     0,
    2423,     0,     0,  2424,     0,   848,     0,  2425,     0,     0,
       0,   849,   850,     0,     0,     0, -1924,     0,     0,     0,
       0,   857,   858,   859,     0,     0,     0,   852,     0,     0,
       0,   860,     0,   861,     0,     0,     0,     0,     0,  -697,
     318,     0,   321,     0,   862,   863,   864,     0,     0,     0,
       0,     0,     0,   865,     0,     0,   319,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   870,   871,
       0,  2076,     0,   866,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3680,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1416,     0,  1417,
       0, -3333,     0,     0,     0, -3333,     0, -3333,  1418,  1419,
     322,     0,  1420,  1421,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   853,   854,   855,     0,   873,   867,
   -1924,     0,     0,     0,     0,     0,   856,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2077,  2078,
       0,     0,     0,     0,     0,   874,     0,   868,     0,     0,
       0,     0,     0,   875,   317,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -1924,
       0,   876,   853,   854,   855,     0,     0,     0,   207,     0,
       0,     0,     0,     0,   856,     0,     0,     0,     0,   320,
       0,     0,     0,   324,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   857,   858,   859,  2079,  2080,     0,     0,
   -1924,     0,   317,   860,     0,   861,     0,     0,     0,     0,
       0,     0,   318,     0,     0,     0,   862,   863,   864,     0,
       0,     0,     0,     0,     0,   865,     0,     0,   319,     0,
       0,     0,     0,     0,   869,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   866,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   857,   858,   859,     0,  2081,     0,     0,     0,     0,
       0,   860, -1924,   861,     0,     0,     0,     0,     0,     0,
     318,     0,     0,     0,   862,   863,   864,     0,     0,     0,
    1414,     0,     0,   865, -1924,     0,   319,     0,     0,     0,
    2082,     0,     0,     0,   847,     0,     0,   321,     0,  2083,
     316,   867,     0,   866, -1924,     0,     0,     0,  2084,     0,
       0,     0,  1403,     0,     0,     0,  3681,     0,     0,     0,
       0,     0,     0,   870,   871,     0,     0,     0,     0,   868,
       0, -1924,     0,     0,     0,  1404,  1405,  1406,  1407,  1408,
    1409,  1410,  1411,     0,     0,     0,     0,     0,     0,     0,
       0,  2085,     0,     0,     0,     0,     0,     0,   847,     0,
    1292,     0,     0,     0,   316,     0,     0,     0,     0,   867,
       0,     0,     0,     0,     0,   322,     0,     0,     0,     0,
       0,   320,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -1924,   873,     0,     0,     0,   868,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -1924, -1924,     0,     0,
     874,     0,     0,     0,     0,     0,     0,     0,   875,     0,
       0,     0,     0,     0,     0,     0,   869,   847,     0,     0,
       0,     0,     0,   316,     0,     0,     0,     0,   848,   320,
       0,     0,     0,     0,   849,   850,   876,     0,     0,     0,
       0,     0,     0,   207,     0,     0,     0,     0,     0,     0,
     852,     0,     0,     0,     0,     0,     0,     0,   324,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -1924,   869, -1924, -1924,     0,     0,   321,
       0,     0,   848,     0,     0,     0,   847,     0,   849,   850,
       0,     0,   316,     0,     0, -1924,     0,     0,     0,     0,
   -1924,     0,     0,     0,   852,   870,   871,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -1924,
       0,     0,     0,     0,  3682,     0,  3683,   321,  2086,     0,
       0, -1924,  2087,     0,  2088,  3684,  3685,   322,     0,  3686,
    3687,   848,     0,     0,     0,     0,     0,   849,   850,     0,
       0,  1412,     0,   870,   871,   873,     0,     0,     0,     0,
       0,     0,     0,   852,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   847,   874,     0,     0,     0,     0,   316,     0,     0,
     875,     0,     0,     0,     0,   853,   854,   855,     0,     0,
       0,     0,     0,     0,     0,   322,     0,   856,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   876,     0,
     848,     0,     0,   873,     0,   207,   849,   850,     0,     0,
   -1924,     0,     0,     0,     0,   317,     0,     0,     0,     0,
     324,     0,   852,     0, -1924,     0,     0,     0,     0,     0,
     874,     0,     0,     0,     0,     0,     0,     0,   875,   853,
     854,   855,     0,     0,     0,     0,  1413,     0,     0,     0,
       0,   856,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   876,     0,     0,     0,
       0,     0, -1924,   207,   857,   858,   859,     0,     0,   317,
       0,     0,     0,     0,   860,     0,   861,     0,   324,     0,
       0,     0,     0,   318,     0,     0,     0,   862,   863,   864,
       0,     0,     0,     0,     0,     0,   865,     0,     0,   319,
       0,     0,     0,     0,     0,   848,     0,     0,   853,   854,
     855,   849,   850,     0,  1709,     0,   866,     0,     0,     0,
     856,     0,     0,     0,     0,     0,     0,   852,   857,   858,
     859,     0,     0,     0,     0,     0,     0,     0,   860,     0,
     861,     0,     0,     0,     0,     0,     0,   318,   317,     0,
       0,   862,   863,   864,     0,     0,     0,     0,     0,     0,
     865,  1414,     0,   319,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     866,     0,   867,     0,     0,     0,     0,   853,   854,   855,
       0,     0,     0,     0,     0,     0,     0,  1415,     0,   856,
     847,     0,     0,     0,     0,     0,   316,   857,   858,   859,
     868,     0,     0,     0,     0,     0,     0,   860,     0,   861,
       0,     0,     0,     0,     0,     0,   318,   317,     0,     0,
     862,   863,   864,     0,     0,     0,     0,     0,     0,   865,
       0,     0,   319,     0,     0,     0,   867,     0,     0,     0,
       0,     0,     0,   960,     0,     0,     0,     0,     0,   866,
       0,     0,   320,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   868,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   857,   858,   859,     0,
       0,     0,     0,     0,     0,     0,   860,     0,   861,     0,
       0,     0,   853,   854,   855,   318,     0,     0,     0,   862,
     863,   864,     0,     0,   856,     0,     0,   869,   865,     0,
       0,   319,     0,     0,     0,   867,   320,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   866,     0,
       0,     0,   317,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   868,   848,     0,     0,   890,     0,     0,
     849,   850,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   852,     0,     0,     0,
       0,   869,     0,     0,     0,     0,     0,     0,     0,     0,
     321,     0,     0,     0,   847,     0,     0,     0,     0,     0,
     316,   857,   858,   859,   867,   320,     0,     0,     0,     0,
       0,   860,     0,   861,     0,     0,   870,   871,     0,     0,
     318,     0,     0,     0,   862,   863,   864,     0,     0,     0,
       0,     0,   868,   865,     0,     0,   319,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   866,   321,  1416,     0,  1417,     0,     0,
     869,     0,     0,     0,     0,     0,  1418,  1419,   322,   848,
    1420,  1421,     0,   847,     0,   849,   850,     0,     0,   316,
     870,   871,     0,     0,   320,     0,   873,     0,     0,     0,
       0,   852,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   874,     0,     0,     0,     0,     0,   867,
       0,   875,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   322,   321,     0,     0,     0,  1953,     0,   869,
       0,     0,     0,   316,     0,     0,     0,   868,   848,   876,
     873,   853,   854,   855,   849,   850,   207,     0,     0,   870,
     871,     0,     0,   856,     0,     0,     0,     0,     0,     0,
     852,   324,     0,     0,     0,     0,     0,   874,     0,     0,
       0,     0,     0,     0,     0,   875,     0,     0,     0,     0,
       0,   317,     0,     0,     0,     0,     0,     0,     0,   320,
       0,     0,     0,     0,  3283,     0,     0,     0,     0,     0,
       0,   322,   321,   876,     0,     0,     0,     0,     0,     0,
     207,     0,     0,     0,     0,     0,     0,   848,     0,   873,
       0,     0,     0,   849,   850,   324,     0,     0,   870,   871,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   852,
     857,   858,   859,     0,   869,     0,   874,     0,     0,     0,
     860,     0,   861,     0,   875,     0,   853,   854,   855,   318,
       0,     0,     0,   862,   863,   864,     0,     0,   856,     0,
       0,     0,   865,     0,     0,   319,     0,     0,     0,     0,
     322,   848,   876,     0,     0,     0,     0,   849,   850,   207,
       0,     0,   866,     0,     0,     0,   317,     0,   873,     0,
       0,     0,     0,   852,   324,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   321,     0,     0,
       0,     0,     0,     0,     0,   874,     0,   316,     0,     0,
       0,     0,     0,   875,  3342,   853,   854,   855,     0,     0,
       0,     0,     0,   870,   871,     0,     0,   856,     0,     0,
       0,     0,     0,     0,     0,   857,   858,   859,   867,     0,
       0,   876,     0,     0,     0,   860,     0,   861,   207,     0,
       0,     0,     0,     0,   318,   317,     0,     0,   862,   863,
     864,     0,     0,   324,     0,     0,   868,   865,     0,     0,
     319,     0,     0,     0,     0,   322,     0,  2731,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1633,     0,     0,
       0,     0,     0,   873,   853,   854,   855,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   856,     0,     0,     0,
       0,     0,     0,     0,   857,   858,   859,     0,   320,     0,
     874,     0,     0,     0,   860,     0,   861,     0,   875,     0,
       0,     0,     0,   318,   317,     0,     0,   862,   863,   864,
       0,     0,     0,     0,     0,     0,   865,     0,     0,   319,
     316,     0,     0,   867,     0,   848,   876,     0,   853,   854,
     855,   849,   850,   207,     0,     0,   866,     0,     0,     0,
     856,     0,     0,   869,     0,     0,     0,   852,   324,     0,
       0,   868,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   857,   858,   859,     0,     0,   317,     0,
       0,     0,     0,   860,     0,   861,     0,     0,     0,     0,
       0,     0,   318,     0,     0,     0,   862,   863,   864,     0,
       0,     0,     0,     0,     0,   865,     0,     0,   319,     0,
    1633,     0,   867,   320,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   866,   321,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   857,   858,   859,
     868,     0,     0,     0,     0,     0,     0,   860,     0,   861,
       0,     0,   870,   871,     0,     0,   318,     0,     0,     0,
     862,   863,   864,     0,     0,     0,     0,     0,   869,   865,
       0,     0,   319,     0,     0,     0,     0,     0,   848,     0,
       0,     0,     0,     0,   849,   850,     0,     0,     0,   866,
       0,   867,   320,     0,     0,     0,     0,     0,     0,     0,
     852,     0,     0,     0,   322,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   868,
       0,     0,   873,     0,     0,     0,     0,     0,     0,     0,
    1634,     0,   853,   854,   855,     0,     0,     0,     0,     0,
       0,   321,     0,     0,   856,     0,     0,   869,     0,   874,
       0,     0,     0,     0,     0,   867,     0,   875,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   870,   871,     0,
       0,   320,   317,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   868,     0,   876,     0,     0,     0,     0,
       0,     0,   207,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2833,   324,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   891,     0,   322,
     321,   892,   893,     0,     0,     0,   869,     0,     0,     0,
       0,   857,   858,   859,     0,   320,     0,   873,     0,     0,
       0,     0,     0,     0,     0,     0,   870,   871,     0,     0,
    1635,     0,     0,     0,   862,   863,   864,     0,     0,     0,
       0,     0,     0,   865,   874,     0,   319,     0,     0,     0,
       0,     0,   875,  1634,     0,   853,   854,   855,     0,     0,
       0,     0,     0,     0,     0,  3567,     0,   856,     0,     0,
     869,     0,     0,     0,     0,     0,     0,     0,   322,   321,
     876,     0,     0,     0,     0,     0,     0,   207,     0,     0,
       0,     0,     0,     0,     0,   317,   873,     0,     0,     0,
       0,     0,   324,     0,     0,   870,   871,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   874,     0,     0,     0,     0,     0,   867,
       0,   875,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   321,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   857,   858,   859,   322,     0,   876,
       0,     0,     0,     0,     0,     0,   207,     0,     0,   870,
     871,     0,     0,   318,     0,   873,     0,   862,   863,   864,
       0,   324,     0,     0,     0,     0,   865,     0,     0,   319,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   874,     0,  2153,     0,  2401,     0,     0,   320,
     875,     0,     0,     0,  2154,     0,     0,     0,     0,     0,
       0,   322,     0,     0,     0,     0,     0,     0,     0,     0,
    2155,     0,     0,     0,     0,     0,     0,     0,   876,   873,
       0,     0,  2402,     0,     0,   207,     0,     0,     0,     0,
       0,  2156,     0,     0,     0,     0,     0,     0,     0,     0,
     324,     0,  2403,     0,   869,     0,   874,     0,     0,     0,
       0,     0,   867,     0,   875,     0,     0,     0,     0,  2157,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2158,  2159,  2160,     0,     0,  2161,     0,     0,
       0,  2404,   876,     0,  2162,     0,     0,     0,     0,   207,
       0,     0,     0,     0,     0,     0,  2163,     0,  2164,  2165,
       0,     0,     0,     0,   324,     0,     0,     0,     0,  -698,
       0,     0,     0,     0,     0,     0,     0,   321,     0,     0,
       0,     0,     0,     0,     0,     0,  2166,     0,     0,     0,
       0,     0,   320,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   870,   871,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -3431,     0,     0,     0,
       0,  2405,     0,     0,     0,     0,     0,     0,     0,  2406,
       0,  2167,     0,     0,     0,     0,     0,   869,     0,     0,
       0,     0,     0,     0,     0,   322,     0,     0,  2168,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   873,     0,     0,     0,     0,     0,     0,
       0,  2169,  2170,     0,  2171,  2172,     0,     0,     0,     0,
   -2314,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     874,     0,     0,     0,     0,     0,     0,     0,   875,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     321,     0,     0, -2314,     0,     0,     0,     0,     0,  2173,
       0,     0,     0,     0,     0,     0,   876, -3333, -3333,     0,
       0,     0,   533,   207,     0,  2174,   870,   871,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   324,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -3431,
       0,     0,     0,     0,     0,     0,     0,  2407,     0,     0,
       0,     0,     0,     0,     0,  2175,  2176,  2177,     0,     0,
       0,     0,     0,     0, -3333,     0,     0,     0,   322,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2178,     0,
       0,     0,     0,  2179,     0,     0,   873,     0,     0,     0,
       0,     0,     0,     0, -3333,     0,     0,     0,     0,     0,
       0,     0,     0, -2314,     0,   890,     0,     0,     0,  2180,
    2181,     0,     0,   874,     0,  2182,  2183,  2408,     0,    59,
       0,   875,     0,     0,     0,     0,     0,     0,     0,  2409,
       0,     0,     0,     0,     0,     0, -2314,     0,     0,     0,
       0, -3404,     0,     0,     0,     0,     0,     0,     0,   876,
       0,     0,  -698,  2410,     0,   533,   207,     0,     0,     0,
       0,     0,     0,     0,  -698,     0,     0,     0,     0,     0,
    2184,   324,  2185,  -698,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2186,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2187,  2188,  2189,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   848,     0,     0,
       0,     0,     0,   849,   850,     0,     0,     0,     0,     0,
    2190,     0,     0,     0,     0,     0,     0,     0,     0,   852,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2191,  2192,  2193,   890,  2194,     0,
    2195,  2196,     0,  2197,  2198,  2199,     0,     0,  2411,     0,
       0,  2200,     0,  2201,  2202,  2203,  2204,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2205,
       0,     0,     0,     0,     0,     0,     0,  2206,     0,     0,
       0,     0,     0,     0,     0,  2412,     0,     0,     0,     0,
       0,     0,  2207,  2208,     0,     0,  2413,     0,     0,     0,
       0,  2209,     0,     0,     0,     0,  -698,  2210,     0,     0,
       0,     0,   890,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2414,     0,     0,   848,
       0,     0,     0,     0,  2211,   849,   850,     0,     0,     0,
    2212,     0,     0,  -698,     0,     0,     0,     0,     0,     0,
       0,   852,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   853,   854,   855,     0,     0,     0,
       0,  2415,     0,     0,  -698,     0,   856,     0,     0,     0,
       0,     0,     0,  2213,  2214,  2215,     0,     0,  2416,     0,
       0,     0,     0,  2216,   848,     0,     0,     0,     0,     0,
     849,   850,     0,     0,   317,     0,     0,     0,     0,  2417,
       0,     0,     0,     0,     0,     0,   852,     0,  2217,     0,
       0,     0,     0,     0, -3333,     0,     0,     0,     0,     0,
       0,  2218,  2219,  2220,  2221,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2222,  2223,     0,     0,     0,     0,  2418,     0,     0,
       0,     0,  2224,   857,   858,   859,     0,     0,     0,     0,
       0,     0,     0,   860,     0,   861,     0,     0,     0,     0,
       0,     0,   318,     0,     0,     0,   862,   863,   864,     0,
       0,  -698,  2225,     0,     0,   865,     0,     0,   319,     0,
       0,     0,     0,     0,     0,     0,  2226,  2227,     0,     0,
       0,     0,     0,     0, -3404,     0,   853,   854,   855,     0,
       0,  2419, -3333,     0,     0,     0,     0,     0,   856,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2228,     0,     0,     0,  2420,     0,     0,
       0,     0,     0,  2229,     0,     0,   317,     0,     0,     0,
    2230,     0,  2421,     0,  2422,   890,  2423,     0,     0,  2424,
       0,  2231,     0,  2425,     0,  2232,  2233,  2234,     0,     0,
       0,   867,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   853,   854,   855,     0,     0,  2235,  2236,     0,     0,
       0,  2237,  2238,   856,  2239,  -698,     0,     0,     0,   868,
       0,  2240,     0,     0,     0,   857,   858,   859,     0,     0,
       0,     0,     0,  1256,     0,   860,     0,   861,     0,     0,
       0,   317,     0,     0,   318,     0,     0,     0,   862,   863,
     864, -3431, -3431, -3431, -3431,     0,     0,   865,     0, -3431,
     319,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   320,     0,     0,     0,     0,     0, -3431, -3431,     0,
       0,  3161,     0,  3162,     0,     0,     0,   848,     0,     0,
       0,     0,     0,   849,   850,     0,     0,     0,     0,     0,
     857,   858,   859,     0,     0,     0, -1998,     0,     0,   852,
     860,     0,   861,     0,     0,     0,     0,     0,     0,   318,
       0,     0,     0,   862,   863,   864,   869, -3283, -3431,     0,
       0, -3283,   865,     0,     0,   319,     0,  1256,     0,     0,
       0,     0, -3431,   867,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0, -3431, -3431, -3431, -3431,     0,
       0,     0,  1257, -3431,     0,     0,     0, -3431,     0,     0,
       0,   868,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -3431,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   321,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   867,     0,
       0,     0,     0,   320,     0,   870,   871,     0,     0,     0,
       0, -3283, -3431,     0,     0, -3283,  3097,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   868,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -3431,
       0, -3431,     0,     0,     0,   891,     0,   322,   869,   892,
     893,     0,     0, -3431,   853,   854,   855,     0,     0,     0,
       0, -3431,     0,     0,     0,   873,   856,     0,   320,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -3431,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   874,     0,   317,     0,     0,     0,     0,     0,
     875,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -3431,   321,     0,   869,     0,     0,     0,     0,   876,     0,
       0,     0,     0,     0,     0,   207,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   870,   871,     0,
     324,     0,  3163,   857,   858,   859,     0,     0,  3099,     0,
       0, -3431,     0,   860,     0,   861,     0,     0,     0,     0,
       0,     0,   318,     0,     0,     0,   862,   863,   864,     0,
       0,     0,     0,     0,     0,   865,     0,     0,   319,     0,
       0,     0,     0,     0,     0,     0,   321,   891,     0,   322,
       0,   892,   893,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   873,     0, -1998,
       0,     0,   870,   871, -3431,     0,     0,     0,     0,     0,
       0,     0,     0, -3283,  1258, -3431,     0,  3164,     0,     0,
       0,     0,     0,     0,   874,     0,     0,     0,     0,     0,
       0,     0,   875,     0,     0, -3431,     0,     0,     0,     0,
       0,  3122,     0,     0,     0, -3431,     0,     0,     0,     0,
       0,   867,   891,     0,   322,     0,   892,   893,     0,     0,
     876,     0,     0,     0,     0,     0,     0,   207,     0,     0,
       0,     0,   873,     0,     0,     0,     0,     0,     0,   868,
       0, -3431,   324,     0,     0,     0,     0,     0,     0,     0,
   -3431,     0,     0,     0,     0,     0,     0,     0,     0,   874,
       0,     0,     0,     0, -3431,     0,     0,   875,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -3283,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   320,     0,     0,     0,   876, -3431,     0,     0, -3431,
       0,     0,   207, -3431,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   324,     0,  1259,
       0,     0,     0,     0,     0,     0,  3165, -3283, -3283,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4494, -3431,   869,     0,     0,     0,
       0,     0, -3431,     0,     0,     0,     0,  4495,  4496,  4497,
    4498,     0,     0,     0,     0,  4499,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4500,  4501,     0,     0,     0,     0, -3431,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4502,     0,     0, -3431,     0,     0,
       0,     0,     0,     0, -3431,     0, -3431, -3431,     0,   321,
       0,     0, -1998,     0,     0,     0,  4503,     0,     0,     0,
       0, -3283, -3283,  1837,  4504,     0, -3431,  1838,     0,     0,
       0, -3431,     0,     0,     0,   870,   871,     0,     0,     0,
       0,     0,     0,     0,     0, -3431,     0,     0, -3431,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3166,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -3431,     0,  4505,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -3431,     0,     0,   891,     0,   322,     0,   892,
     893,     0,     0,     0,     0,     0, -3431,     0,     0,     0,
       0,     0,     0,     0,     0,   873,     0,     0, -3431,     0,
   -3431, -3431,     0,     0,     0,     0,     0,  -777,  -777,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -3431,     0,   874,  1846,     0, -3431,     0,     0,     0, -1998,
     875,     0,     0, -3431,     0,     0,  1847,  1848,  1849,  1850,
       0,     0,     0,     0,  1851,     0,     0,     0,     0,     0,
       0,  3167,     0,     0,     0,     0,     0,     0,   876,     0,
       0,     0,     0,  1852, -3431,   207,     0,     0,     0,     0,
       0, -3431,     0,     0,     0,     0, -3431,  4506,     0,  4494,
     324,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4495,  4496,  4497,  4498,     0,     0,     0,     0,
    4499,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -3431,     0,     0,  1853,     0,     0,     0,     0,  4500,  4501,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -3285, -3431,     0,   533,     0,     0,  4507,     0,     0,  4502,
       0,     0,     0,     0,     0,  4508,     0,  4509,     0,     0,
    1854,     0,  1855,     0,     0, -3333,     0,     0,     0,     0,
       0,  4503,     0,     0,  1856,  4510,     0,     0,  1837,  4504,
       0,     0,  1838,     0,     0, -3431,     0,  4511,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -3431,     0,     0,
       0,  1857,     0,     0, -3431,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      59,     0,     0,     0,     0,     0,     0,  4505,     0,     0,
    2409,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -3404,     0,     0,     0,  4512,   533,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4513,
       0,     0,     0,  4514,     0,     0,     0,     0,     0,     0,
       0,     0,  -777,  -777,     0,     0,     0,     0,     0,     0,
       0,  4515,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  -777,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4516,     0,     0,
       0,     0,   848,     0,  1865,     0,     0,     0,   849,   850,
       0,     0,  4506,     0,     0,  1858,     0,     0,     0,     0,
       0,     0,     0,     0,   852,     0,  1859,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4517,
       0,  1866,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1860,     0,     0,  4518,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4507,     0,     0,     0,     0,  2412,     0,     0,     0,
    4508,     0,  4509,  1840,  1841,     0,     0,     0,     0,     0,
   -3333,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4510,     0,     0,     0,     0,     0,     0,  4519,     0,     0,
       0,     0,  4511,     0,     0,  1861,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    59,     0,  1862,     0,     0,
    1863,     0,     0,     0,     0,  2409,     0,     0,  4520,     0,
       0,     0,     0,     0,     0,     0,     0, -3404,     0,     0,
    1871,  4512,  1872,  1873,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4513,     0,     0,     0,  4514,     0,
       0,     0,     0,     0,     0,     0,  1864,     0,     0,   853,
     854,   855,   848,  1865,     0,  4521,  4515,     0,   849,   850,
       0,   856,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   852,     0,     0,     0,     0,     0,
    2417,     0,     0,     0,     0,     0,  4522,  -777,     0,   317,
    1866,     0,     0,     0,     0,     0,     0,     0,  4523,     0,
       0,     0,  4516,     0,     0,     0,     0,     0,  1867,  1865,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   848,
       0,     0,  4524,     0,     0,   849,   850,     0,     0,     0,
       0,     0,     0,     0,  4517,     0,  1866,     0,   857,   858,
     859,   852,     0,     0,     0,     0,  1868,  4525,   860,  1869,
     861,     0, -1133,     0,  4518,     0,     0,   318,  4526,     0,
       0,   862,   863,   864,     0,     0,     0,     0,     0,     0,
     865,  2412,     0,   319,     0, -3404,     0,     0,  1840,  1841,
       0,     0,     0,     0,     0,     0,     0,  4527,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1870,     0,     0,
       0,     0,  4519,     0,     0,     0,     0,     0,  4528,  1871,
       0,  1872,  1873,     0,     0,     0,  4529,  -777,     0,     0,
       0,     0,     0,     0,     0,  4530,     0,     0,     0,     0,
       0,  1874,     0,     0,     0,     0,  1875,     0,     0,   853,
     854,   855,     0,     0,  1876,     0,     0,     0,     0,     0,
       0,   856,     0,  4520,     0,     0,   867,     0,     0,     0,
       0,     0,     0,     0,     0,  1871,     0,  1872,  1873,     0,
       0,     0,     0,     0,     0, -3391,     0,     0,     0,   317,
       0,     0,     0,     0,   868,     0,     0,  1877,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4521,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   853,   854,   855,     0,
       0,  1878,     0,     0,     0,  2417,     0,     0,   856,     0,
       0,  4522,     0,     0,     0,     0,   320,     0,   857,   858,
     859,     0,  1879,  4523,     0,     0,     0,     0,   860,     0,
     861,     0,     0,     0,     0,     0,   317,   318,     0,     0,
       0,   862,   863,   864,     0,     0,     0,     0,     0,     0,
     865,     0,     0,   319,     0,     0,     0,  4524,     0,     0,
       0,     0,  4896,     0,     0,     0,  1880,     0,     0,     0,
       0,   869,     0,     0,     0,     0,     0,     0,  1881,     0,
       0,     0,  4525,     0,     0,  1882,     0, -1136,     0,     0,
       0,     0,     0,  4526,     0,   857,   858,   859,     0,     0,
       0,     0,     0,     0,     0,   860,     0,   861,     0,     0,
   -3404,     0,     0,     0,   318,     0,     0,     0,   862,   863,
     864,     0,  4527,     0,     0,     0,     0,   865,     0,     0,
     319,     0,     0,     0,     0,     0,   867,     0,     0,     0,
       0,     0,     0,  4528,   321,     0,     0,     0,     0,     0,
       0,  4529,  -777,     0,     0,     0,     0,     0,     0,     0,
    4530,     0,     0,     0,   868,     0,     0,     0,     0,     0,
     870,   871,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   867,     0,     0,   320,     0,     0,     0,
       0,     0,   322,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     873,   868,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4897,     0,     0,     0,     0,     0,   874,     0,     0,
       0,   869,     0,     0,     0,   875,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   320,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   876,     0,     0,     0,     0,     0,     0,
     207,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   324,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   321,     0,     0,     0,   869,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     870,   871,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   321,   322,     0,   892,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     873,     0,     0,     0,     0,     0,     0,   870,   871,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   874,     0,     0,
       0,     0,     0,     0,     0,   875,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   322,
       0,     0,     0,   876,     0,     0,     0,     0,     0,     0,
     207,     0,     0,     0,     0,     0,     0,   873,     0,     0,
       0,     0,     0,     0,     0,   324,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   874,     0,     0,     0,     0,     0,
       0,     0,   875,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     876,     0,     0,     0,     0,     0,     0,   207,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   324
};

static const yytype_int16 yycheck[] =
{
     175,   224,   316,   201,   689,   717,   745,  1272,   280,   266,
     680,   749,   750,   751,   753,  1267,   754,  1057,   711,  1614,
     847,  1118,  1214,   707,   127,   156,  1750,   158,    43,  2266,
      73,  1140,   163,   683,   194,   307,    79,  1839,  2394,  2450,
    1350,  1717,  1844,  1413,  2022,   771,   675,    90,  2889,   775,
     776,  1426,   778,   779,  2032,   781,   782,   800,   801,   843,
    2575,    76,    77,    78,    52,  2468,  2469,  2423,    83,   230,
      58,  1830,  1097,   944,   205,  2590,  1386,  1387,  1388,  1389,
     692,  2693,   669,   791,  1770,  1082,   309,   772,   773,   696,
     938,  2543,   777,    81,    82,   780,    84,    85,  2467,   711,
     882,  2553,  2899,   930,  2901,   712,  1193,  2719,  1195,  1196,
    1927,  1198,  1199,  1930,   671,  3360,  1751,  2838,   872,   901,
    1292,  1868,  1939,  1724,   139,  3384,  1943,   687,   715,  2726,
     118,  1288,   692,  1950,  2021,  2307,  2336,  2395,   153,  1898,
     155,   973,  2688,  1300,   159,   160,  3085,  1906,  1992,  3697,
    1278,   711,  2061,  2263,   169,  2042,  2900,   145,   146,   147,
     175,  1289,  1638,  2758,   938,     8,   181,     1,     1,   184,
       0,    18,   187,    12,     1,    91,    18,     0,     0,    33,
     223,    18,   156,    18,   158,     1,    46,   121,   203,   163,
     233,    27,    18,    18,    14,  2664,     5,   860,   861,    18,
      75,  1072,   190,   670,     1,   868,   221,   195,   123,    15,
     151,    22,    23,    24,  2058,    18,  1376,   232,    18,    33,
      18,     1,  1394,  2535,  2536,    99,  1245,     1,   170,  2541,
    2542,   205,  2544,    27,   124,    18,    18,    69,    46,    43,
     255,    21,  1402,   171,    45,   226,    97,  1272,   133,    97,
     913,    41,   259,   567,  1102,   124,   222,   216,   246,   213,
      33,   249,    68,   258,    32,   872,   268,  1041,   251,    45,
     187,   178,  1889,   256,   289,   231,   232,   507,   246,   267,
    1762,   245,  1669,   205,  3554,   128,   312,  2802,  2803,    40,
     333,   334,  1898,   124,   187,  1143,  4112,   214,   259,   339,
    1906,   116,   312,   378,   312,   290,   359,   259,    70,   283,
     245,    99,   124,    18,   359,  1027,  2752,   128,   339,  3376,
     171,   214,   305,   151,    12,    25,   467,   434,  1102,   252,
     151,   268,    43,   446,  2646,  3218,   297,  2649,   299,  3169,
    1031,   124,   124,   110,  2656,  2335,   126,  2659,  3405,  3179,
     184,  4216,   909,   341,    44,   300,  1110,  1380,   500,    48,
     348,   506,    97,   129,   136,   540,   403,    48,    53,   541,
      55,    56,    57,    58,    59,    60,   183,   378,  2346,   339,
     967,   434,    33,   432,   216,   541,   359,    39,  2985,   123,
     481,   330,    20,   127,   312,   414,  2993,   456,   258,  2996,
    2997,   442,   136,  1115,   184,   326,    18,   187,   680,   189,
     587,   175,   467,   621,  2258,   231,   232,   674,   250,   481,
     677,   205,   231,    43,  2886,   892,   137,  4425,   378,   559,
     141,   462,  3639,   572,   214,   587,  1175,   514,   600,   292,
     473,   683,   358,   187,  2554,   459,   269,   269,   705,  1009,
     258,   708,   275,   275,  1626,   489,   713,   222,   248,   221,
     497,   684,   719,  3289,  3723,  1025,    94,   373,   510,   408,
     214,  1255,   223,   741,  3918,   473,   647,  1261,    44,  4046,
    1092,  1224,   325,   359,    40,   481,    98,   833,  2899,   300,
    2901,  1273,   434,   775,   377,   246,    40,   184,   185,  1347,
    2344,  2870,   414,  1110,   697,  2817,   481,  4031,  3753,   524,
     525,  4100,   481,   339,   433,   481,  4083,   137,   462,   434,
     467,   141,  4437,   860,   539,   568,    15,   216,   775,   309,
    4226,   546,  1092,  4380,   452,   434,   212,  1709,   375,  1099,
     481,   341,  4356,   151,   570,   717,  1076,   446,   151,   901,
     226,   374,   374,    15,   481,   310,  1338,   251,   341,   341,
    2760,  3500,   256,     0,   403,   591,   481,   484,   403,   259,
     526,   843,   290,   541,   748,   322,   387,   388,  1769,    68,
     434,   591,   934,   775,  3381,   408,   408,   410,   410,  2826,
     151,   484,   412,   413,   151,    18,  1380,   151,  4445,   373,
    1130,   476,   230,  2861,  3216,  4419,    68,  4303,   954,   327,
     328,   305,  1803,   895,   541,   151,   216,   954,   274,  4186,
     434,   403,   175,   320,    18,   445,   151,   434,  1820,  3032,
    4219,   806,   379,   472,   578,   474,  4551,   830,   444,   481,
     514,  4100,   481,  4167,   459,  3191,   481,   274,   895,   624,
     526,   647,   571,   456,   465,   466,   456,   929,   497,   432,
     645,   434,   497,  1292,  2340,  3548,   670,   223,  3551,   489,
     927,   675,   584,   456,   456,  1142,   184,   422,   647,   223,
     851,   189,   856,   687,   446,   942,  4130,   929,   692,   957,
    3897,   725,   545,   259,  4692,  2070,   670,   671,   247,   481,
     862,   675,  2960,   895,   484,   517,   739,   711,   722,   751,
     526,   766,   753,   687,   688,   497,   481,   369,   692,   692,
    1807,   541,   696,   534,   378,   422,  3552,   770,   867,    18,
     613,   359,   606,   707,   573,   709,   153,   711,   712,   645,
     484,   739,   430,   541,   441,   953,  2056,  1397,   722,   780,
    2718,   788,   520,  1025,   728,   683,    12,  2601,   569,   481,
    4219,    25,   473,   713,    25,  1394,    12,   578,  2677,   608,
    2529,   123,   506,  4771,   851,   127,   587,   954,   378,  1936,
    1367,   953,    25,   434,  1655,  1057,   552,  1959,   554,   851,
     697,   403,   481,   868,    22,    23,    24,   953,   578,  2789,
     481,   309,   954,  1822,  2563,   647,  1633,   407,   953,  3245,
     825,   953,   786,    41,  1037,  1282,  1283,  1284,   606,   630,
     879,   660,   743,   646,   646,   660,   526,   514,  4644,   970,
     458,  1298,   683,   115,  1057,   683,   541,   588,   857,   969,
     953,    52,  4707,   766,  1692,   797,  3443,   954,   679,   856,
     462,   463,  3164,   473,   856,   622,   779,   867,   593,  1641,
     123,   489,    90,   954,   127,  2835,  2976,   868,  1140,   481,
     668,   645,   500,   561,  2261,   924,   566,  1344,   660,  1436,
    3819,   840,  1349,  1609,   324,   497,   890,   891,   892,   893,
     851,   711,   851,   123,   869,   515,  3953,   127,   872,   587,
     128,   954,   342,   600,   681,   322,  3368,   722,  1905,   954,
    1601,   645,   857,   541,   954,   970,   627,   628,   793,   856,
     805,   698,   699,   830,   846,  3328,   800,   645,   954,   933,
     758,   805,   969,   954,    18,   909,   704,   758,   902,   856,
    2557,   788,   781,  4213,   946,  2427,   954,   954,   683,   788,
     637,   748,  2112,   788,  1184,   871,    12,  2563,   953,   933,
     740,  3844,   667,   856,   971,   921,  2353,   902,   736,   954,
    3381,   954,   953,   858,   864,  3719,   780,  1804,  1805,   869,
     403,     1,   851,  1255,   858,   953,   920,    18,   954,  1261,
    2015,   763,   934,  3823,   954,  2018,  2015,  1626,  3593,   953,
     954,   929,   764,   793,   794,  1009,   788,   627,   628,   403,
    1208,  1623,    32,   954,  1189,   954,  1191,   805,   752,  1194,
     248,  1025,   829,   970,  3380,   853,   856,   866,  1203,   763,
     434,   866,   853,   856,   856,  1009,   954,   953,   294,   954,
     252,   821,  3511,   857,  1242,   780,   857,   856,   660,   843,
     861,  1025,   863,   833,   300,   954,  1187,  1188,   481,   856,
    1332,   154,   846,  1623,  1790,  1791,  1197,   868,  1811,   780,
    1796,   903,  3330,  1799,   497,   703,   856,   951,   929,   954,
    1709,   929,   856,  1057,   866,   920,   859,   481,  1092,   717,
    1362,   871,   868,  1350,  4033,  1099,   879,   879,   901,   934,
     954,   901,   879,   497,   964,   921,   904,   201,  1380,  1957,
     946,   954,   954,   713,   403,   954,   665,   954,  1092,   954,
     954,   954,   969,  1683,   944,  1099,  1953,   954,   954,   954,
     969,   954,   954,   953,   969,   954,  1110,  2613,  1142,  1337,
     946,   971,  1924,   955,   252,   953,   833,   403,   971,   971,
     758,   924,  1845,  1816,   506,   758,   964,   403,   969,    25,
     895,  3419,  1136,   961,   954,  3143,  3144,  3145,  3146,  1184,
     855,  3476,   954,   946,   954,   920,   788,   459,   866,  1167,
     865,   201,  3292,  1957,  3294,   965,   224,   969,   952,   245,
     954,  3301,   481,   948,   929,  1949,   452,   758,   852,   954,
     856,   758,   953,   980,   758,  3456,    51,  2842,   497,    18,
    4669,  3955,  3463,  1187,  1188,   764,   472,   994,   474,   954,
     954,    69,   758,  1197,  2264,   481,   472,  1242,   474,   856,
    4169,  1246,   740,   758,  2018,   481,   954,   660,   655,   300,
      88,   497,  1019,   506,  1259,   853,  3356,   969,  2995,   849,
     853,   497,  3096,   276,   866,   467,   864,   954,   514,   953,
     954,   869,   526,   680,   302,   526,   660,   954,  1045,  2101,
     462,  1275,  1276,  1277,  1741,  3184,   506,  2953,  1282,  1283,
    1284,  4829,  1256,   526,  3879,   905,   886,   434,  1292,  3835,
     434,  3178,   853,   645,  1298,   735,   853,  1301,  2984,   853,
    1077,   412,   481,  1307,  1308,  1309,  1310,  1311,  1312,  1313,
    1314,  1315,  1316,  1317,  1318,  2507,  2313,   853,  1292,   403,
     531,   532,   533,  3293,  4569,   953,   954,   434,   853,   171,
    1959,  1108,   473,   953,   445,  1112,  3180,  1609,  3182,  3063,
    1344,   414,  1949,    77,   302,  1349,   246,   403,   442,   201,
     578,   481,   608,  2135,   481,  2395,    25,   969,  4079,   467,
      45,   481,   608,  1140,   481,   788,    25,  1542,   484,   312,
    2530,   660,   403,    18,   467,  4620,   456,    22,   489,  2105,
      25,    26,   645,     0,  3228,    33,   479,   725,   445,   123,
    1394,  2076,   259,  3593,   788,   488,   481,   481,     1,  4425,
     752,  1673,  2489,  2490,   660,    97,   481,   481,  2495,  2496,
     573,  3669,   434,   497,   660,   645,   472,   481,   474,   481,
    1394,  3593,   442,   725,  1981,   481,  1698,   374,  2113,   445,
     541,  2588,   489,   594,  2594,  2595,   775,  2122,  1661,   650,
     722,   497,  3286,   866,  3288,   862,   481,   851,   888,  2577,
     481,  2579,  2142,   218,  2582,   670,   481,  2585,  2586,  2587,
     625,  2589,  1436,   359,  2592,   780,   497,  2627,  2628,   684,
     481,   316,   866,   489,  1746,  2603,  2604,  4198,   540,   481,
    2262,     1,   682,   923,   541,   302,   171,    40,  3857,   752,
     302,  2318,   932,   359,  2666,   239,  2668,   920,   559,   788,
     520,  3806,  3207,    44,   856,   720,   529,   481,   569,   403,
     124,   934,  4747,    98,    12,  1292,  2676,   595,  4115,   312,
     362,   680,   752,   481,  1685,   541,  2635,   647,   851,   607,
    3131,   954,   788,   294,  2694,  3786,  1793,  2319,  1795,   183,
    1797,  1798,   788,  1800,  1801,  3523,   969,   641,   641,  3800,
     954,  4392,   608,   401,   766,   169,   895,   387,   388,    12,
     954,   369,   624,  2735,  2346,   793,   794,   779,   434,   254,
     377,  4830,  4831,   481,   625,   969,   660,   866,   343,   848,
     895,  2741,   619,   852,  3289,   841,   137,   481,   780,  2343,
     141,   247,    94,   856,   403,  2755,   573,  4832,   739,  2759,
      38,  4860,  1379,   497,   660,   698,  1610,   259,  4107,   378,
     866,   857,   460,  4858,   134,   953,  1393,  1394,   781,  1623,
     866,   641,  1626,  2316,  3300,   856,   856,   570,  2410,   660,
     414,   954,  2414,  2805,   154,   465,   466,   222,    22,    23,
      24,   541,   856,   510,  2256,  1422,   739,   495,   591,  1623,
    2737,   953,  1626,  4374,   499,   175,   176,  1788,   766,   753,
     526,   872,   873,   489,   247,  2825,  4692,   882,  3415,   259,
     223,   779,   481,   481,   885,   890,   891,   892,   893,  1683,
     969,  1696,  4051,   312,   704,   450,   901,  3322,   497,  3324,
     359,   954,   588,   893,   546,   154,  2256,  2257,   954,   646,
     359,   864,   660,   862,   788,  1709,   869,   823,   954,  1683,
     857,  2268,   856,   969,  1986,   541,   736,    12,   259,  3970,
    3971,   369,   455,   969,   168,  4224,   954,   481,   455,   541,
     322,   323,   788,   753,  2419,  1709,  2343,  1741,   430,   322,
     239,   558,   507,  1758,   128,  4771,  2018,  1762,  1763,   856,
    1765,  2599,   422,  1768,  1769,   603,  1771,   788,   970,  2502,
     514,   953,   856,   856,   802,  1753,   660,  2493,   841,  4020,
     414,   441,   375,  3459,    89,   954,   734,  2485,   587,  2487,
     802,   804,   866,   821,  4425,  4425,  2570,   379,   953,  4158,
     969,   408,  2817,   410,   537,   851,   857,  2487,   591,   879,
     838,  1999,   918,  1978,   781,   946,   613,   869,    15,   535,
     866,  2593,   596,  2810,  1788,   856,   853,   409,  4187,  4188,
     135,  2861,  1037,  4060,   954,   481,   378,   954,   431,   481,
     788,   600,  1847,   944,   954,   866,   856,   954,  1853,   969,
     338,  1856,  1057,  1858,   578,   687,   902,  3552,   403,  1626,
    2543,   660,  3830,   607,  3046,  3047,  2549,   526,  2551,   379,
    2553,    68,   970,     0,   417,  4102,   510,  1082,   716,   954,
     954,  1845,   557,   520,   905,   587,   954,   970,  2975,   954,
     954,   526,   527,   841,   969,   969,   201,   944,   856,   632,
     954,   379,   433,   578,   788,  3712,   953,   672,   954,   484,
     359,   358,   953,   954,   512,   403,  3066,   969,  4159,  2376,
    2377,  1688,   585,   969,   434,   588,   300,  4124,  4370,   954,
     510,   647,   473,   954,   867,  1702,   481,  1142,   944,   954,
     600,    15,  1709,   578,   579,   802,  2718,   394,   969,   775,
     584,   570,   497,   954,   969,   853,   434,   467,  3035,   724,
     403,  1955,   954,   673,   821,  1959,   403,   747,  1735,   479,
     239,  3637,   591,  2633,  2657,  2658,   833,   414,   488,   531,
     532,   838,  2147,  3101,   472,  1949,   474,  3821,  1993,   788,
     954,  1955,  3352,   481,    68,  1959,  4237,   489,  2260,  3833,
    3834,   303,  2264,   298,  2776,   969,   954,   434,   500,   497,
     312,  4613,  4799,   387,   388,   422,   489,  1981,   467,    22,
    4622,   969,    25,    26,  2029,   140,   624,   782,   301,   472,
     479,   474,   147,  2038,   441,   566,   673,  4234,   481,   488,
     571,   861,   679,   863,   481,    43,  2308,  2666,   341,  2668,
    3149,  2264,  3886,   891,   497,   851,   954,   780,   216,  2609,
     497,  4692,  4692,   780,  2058,  4679,  4680,   866,   541,   895,
    1275,  1276,  1277,   783,   784,     7,  2338,  1282,  1283,  1284,
    1285,  4440,  4441,  1288,   864,   969,   627,   628,  2350,   869,
     792,   465,   466,  1298,  2058,  1300,  1301,   607,   650,   175,
    3250,  3251,  1307,  1308,  1309,  1310,  1311,  1312,  1313,  1314,
    1315,  1316,  1317,  1318,  2931,   660,  2735,  2889,   403,  2576,
     608,  2578,   664,   878,  1329,  2986,   849,  3277,  3278,   434,
     403,   641,   849,   403,    66,  2099,   201,   953,   433,  1344,
    4771,  4771,   269,   448,  1349,  2602,    78,     8,   275,   358,
     408,  2316,   410,   446,  2731,  3305,    18,  3307,   954,   452,
     534,    45,   467,   467,   529,   608,   471,   489,    30,  2626,
     969,   713,   660,   833,  2325,  2326,  2327,  2328,  2329,  2330,
    2331,  2332,  2395,  2733,  2824,   394,  2805,   472,   698,   474,
     489,   703,   641,   125,   706,   569,   481,  4811,   710,   140,
     423,   403,  4595,  4596,   578,   559,   147,   789,   481,   682,
     954,   481,   497,   587,  4828,   213,   148,   660,   748,   541,
    2385,  3208,   802,   660,   497,   969,   369,   497,    53,   739,
      55,    56,    57,    58,    59,    60,    98,  2450,   786,   593,
    2007,   821,   541,   788,   358,   275,  2411,   374,   403,   698,
    2497,   249,  2499,   833,  2501,  2930,   630,   417,   838,   216,
    2935,  2936,  2256,  2257,  2258,   403,   864,   128,   302,   860,
    2872,   869,   567,  4666,  4667,   207,   571,   860,   312,   481,
     394,   408,   484,   410,   119,   120,  4035,   171,   590,   591,
     739,   434,  2256,  2257,  2258,   497,   373,  3327,   374,   124,
     788,  2466,   152,  4605,  2268,   887,   584,   316,  2473,   857,
    4612,   320,  2987,   473,  4616,   313,  4030,  4619,   269,  3093,
     659,   866,  2872,   608,   848,  3690,   481,   529,  3688,    34,
      35,   181,   408,   885,   410,  4880,   641,   641,   320,  3156,
     175,  2798,   497,   481,   868,   788,   856,  2897,   198,   199,
    2344,   788,  2316,  2549,  4859,  2551,   303,   291,   473,   497,
     292,   359,   477,   954,   642,   312,   673,  4912,   673,  4675,
     254,   954,   679,   678,   954,   660,    41,   212,   866,  2343,
    2344,   379,  2376,  2377,  2549,  2152,  2551,   660,  2393,   726,
     660,   226,  2605,   698,  3544,   700,   860,  1606,  4799,  2404,
    2405,  2406,  3085,    49,  4710,  1610,   684,   856,   851,   954,
    1619,   239,  2390,   422,   120,  2420,  2421,  2422,  4720,  3079,
     893,  4723,  2427,   866,   969,    49,  4175,   792,   183,   866,
     795,   796,   441,  4826,   366,  3207,  2400,   859,   748,  4785,
     422,   434,   954,   953,  4110,   802,    92,   786,   870,  4835,
    3267,  3268,  2551,    99,   874,   875,  1661,   319,   660,   441,
     970,  2657,  2658,  2584,   414,   953,   954,    39,    92,   175,
    2475,   321,   811,   812,   813,    99,     7,  3627,  3628,   414,
     953,   969,   329,   857,   434,  3562,  2636,   861,   481,   863,
    2752,   859,  2657,  2658,   319,  4881,  4882,   774,  4891,    49,
    2505,  2506,   870,   788,   259,   660,   212,   369,  2472,   774,
     481,   954,   747,   673,   641,   788,   448,  3289,   788,   646,
     226,   970,   660,   526,   527,  3241,   969,   673,   688,   952,
    3205,   954,   969,   679,   611,    66,  1741,  4505,   615,   469,
     470,   403,    92,  2548,  1584,  3185,  4514,    78,   480,    99,
    2555,   856,   856,  2815,  4522,   860,   860,  2324,  2657,  2658,
     929,  2823,   931,  1603,  1604,  1605,   537,   673,   645,   540,
     646,  2535,  2536,   679,   429,   578,   579,  2541,  2542,  2543,
    2544,   866,  2576,   248,  2578,  2549,   788,  2551,     1,  2553,
     515,   600,   585,   866,   125,   588,   866,   359,   748,   361,
     462,   463,  1275,  1276,  1277,  2558,  2559,  2601,  2602,  3909,
    4837,   853,   954,   848,   853,  2609,   854,   148,   600,   481,
    2584,   568,   864,   570,   929,   864,   864,   869,  1301,   864,
     869,   869,  2626,   788,   869,   497,   607,  2601,  3056,   149,
     490,   853,  3060,   590,   591,  2609,  3362,   645,  2861,   581,
     788,   501,   864,   624,   568,   748,   570,   869,    71,    72,
      73,    74,   341,    76,   954,   970,   970,   481,   864,   954,
     864,   748,  2666,   869,  2668,   869,   207,   890,   891,   358,
     893,   954,  2646,  3770,   969,  2649,  2899,   889,  2901,   576,
     577,   854,  2656,  2657,  2658,  2659,   969,   481,  4841,   969,
    1905,   864,  2666,  4846,  2668,   473,   869,  3794,  4923,   477,
    4925,  4503,  4927,   473,    18,   394,    39,   477,    41,   921,
     922,  4513,   727,  3822,  2688,   657,    30,   481,   866,   661,
    3405,  1936,   879,   595,   954,  3468,  2949,  2999,   403,  2733,
    1730,  2735,  1307,  1308,  1734,   158,   159,  2960,  1283,  1284,
     954,  3411,   856,   856,   655,   510,     7,   906,   907,   908,
     909,   292,   906,   907,   908,   909,   239,   969,   956,  2733,
     761,  2735,   607,   452,   780,  3852,   906,   907,   908,   909,
    3552,   127,   617,   618,   634,   136,  3033,  3034,   954,  3036,
    3037,  3038,   852,   434,    98,  3345,   475,   645,   660,   954,
    2908,  2909,  2910,  2911,  2798,   153,   359,    18,   748,   154,
     742,  2805,   588,   621,   969,    66,   481,  3500,  4736,   484,
     843,   481,   431,   856,   763,   675,  3643,    78,   856,   213,
     481,   969,   497,  2998,   231,   366,    15,   122,   851,    65,
    4554,  2805,   954,   760,   694,   316,  4764,  4765,   639,   954,
    3667,   380,  4770,  2817,   954,  4773,   868,   748,  2863,  4777,
    4778,   488,   593,   698,   529,   584,   860,  3639,   183,   310,
      34,   803,   515,   481,   125,   856,   868,   260,  2872,   510,
     953,   369,   868,   868,   868,   720,   721,   261,   868,   868,
     868,   868,   868,   868,  4194,   868,   868,   148,   869,   868,
     319,   420,   851,  2897,   659,   134,   262,   726,  2872,   263,
     265,   176,   673,  3532,   833,  3534,   386,   448,   833,    92,
    3085,   953,   266,   177,   267,   154,   788,   268,   523,   197,
     290,   840,   868,  2897,   347,   348,   349,   350,   351,   352,
     353,   354,   355,   272,   259,   851,   175,   176,   273,   480,
      97,   883,   841,   954,   276,   369,   207,   277,   954,   278,
    3053,  1309,  1310,  1311,  1312,  1313,  1314,  1315,  1316,  1317,
    1318,  3233,   279,  2978,   369,  3649,  2981,   312,   281,  4161,
    4162,   514,  3195,  3245,  4284,   640,  3233,    45,   282,  2994,
     283,   853,  4784,   855,  3207,   660,   430,  3002,  3003,   124,
     284,   220,   864,   865,   866,   285,   868,   869,   286,   851,
     280,  2778,   481,   945,   934,   319,   868,   479,   748,   693,
     856,  4171,  4172,   169,   846,  4817,  4176,   832,   359,   183,
     855,   786,   954,   851,  2801,   851,   954,   483,   954,   864,
     865,   292,   954,   868,   869,   378,  4133,   802,   420,   643,
     581,  4636,   481,  3315,   515,   711,   811,   812,   813,  2264,
     952,   570,   905,  2830,  2831,   369,   821,    18,   481,   952,
     946,   481,   312,   255,  4104,   338,  3289,   851,   769,    30,
     392,   848,   953,   838,   843,  4385,   837,  3092,   430,    97,
     430,   220,   369,   851,   851,   851,   369,   369,    97,   403,
     430,   271,   369,   430,  2871,    43,   357,   969,  2313,   959,
     960,   369,   287,   748,  3327,   366,   698,  3330,   170,    33,
     584,  3085,   954,   788,  4306,  3897,   657,  3944,   793,   794,
     661,   679,   713,   787,    89,    15,  3819,   576,   446,   151,
      36,    37,   780,   802,   968,   446,   967,    98,   576,   802,
     853,   522,   853,    91,   853,    93,   853,   853,   462,   463,
     853,   853,   378,   853,   851,  3378,   713,   851,  3381,    39,
    3383,  2376,  2377,   718,   692,   446,   378,   481,   116,   378,
     598,  4363,   969,  4425,   341,   270,  3180,   246,  3182,   697,
     697,   378,   414,   497,  3359,   510,  3361,   448,   856,   137,
    3164,   713,   584,   141,   455,   434,  3419,   585,    18,   378,
      14,   742,   625,   920,   946,   481,  3180,  3464,  3182,   946,
     713,  3937,  3938,   802,   258,   739,   379,  3191,   946,   480,
     946,   929,   722,   946,  3228,   648,    39,   946,   467,   434,
     954,   379,   954,   954,   140,   934,   789,   641,   479,   853,
     479,   147,   853,   481,   150,   573,  3421,   508,   781,   488,
     378,   571,   541,  3428,  3228,   433,   259,    27,   843,    97,
     341,   301,   803,   255,   851,    97,   763,  3282,    15,   929,
     929,  3469,  3470,  4055,   566,   369,   697,   625,  3321,   851,
     595,   595,  3457,   221,  3288,   830,   183,   856,   928,   526,
     109,  3466,  3423,   748,   969,   843,   843,   969,   201,   205,
     868,   104,   890,   868,   210,   211,   369,   851,   954,  3581,
      16,    39,   954,   809,  3288,   761,   851,  3540,   359,   477,
     802,   764,   123,   584,   489,  3500,   763,    70,   628,  3552,
      27,   369,   701,   378,   659,   378,   231,  3325,   853,    97,
    4033,  3345,   883,   690,   690,   359,   660,   359,  3363,   596,
    4177,   274,  3609,  3610,   598,   697,   589,  3331,   319,  4098,
     489,  2576,  3377,  2578,   446,   201,  3564,   489,   607,   546,
    3147,  3345,  4199,  2588,  4461,   473,  3648,   572,   867,   522,
    3384,   695,   226,   913,   644,   748,   369,  2602,   294,   481,
     296,   848,   683,   481,    97,   375,   657,   303,   647,   239,
     661,   481,   641,   584,   945,  4131,   312,   764,   780,   593,
     215,  2626,   416,   224,   849,    97,    97,   216,    15,    68,
     862,   641,   541,   541,    97,   489,  3441,  3442,   489,   489,
     567,  3446,   298,  3448,  3449,  3450,  3451,   820,   641,   856,
    4692,   765,   403,  3458,   392,   859,  3669,   853,   954,  3423,
    3227,   851,   954,   222,   222,  4282,   588,   780,   482,   698,
     851,   786,   259,  3240,   802,  3439,  3440,   843,   526,  3484,
      25,   641,   599,   718,   788,   901,  4169,   802,  4216,   954,
     851,   742,  3456,  4209,   670,   524,   811,   812,   813,  3463,
     954,   420,   946,   302,   359,  3718,   821,  3769,   358,   222,
     739,   462,   463,    14,  2719,   369,  4771,   843,   213,   522,
     417,   459,  4294,   838,   645,   666,   422,   851,   589,    43,
     481,  3696,   506,   614,   570,   473,  3500,   886,  3532,   477,
    3534,   954,   725,   699,   792,   856,   497,   500,   780,   853,
     525,   855,   803,    25,   860,   526,   820,   856,   860,  3564,
     864,   865,   866,   588,   868,   869,   817,   856,  3532,   446,
    3534,   446,  4344,   641,   224,   819,   462,   473,   246,   215,
     446,   477,  3703,   584,   446,  3352,   537,  3592,   583,   462,
     841,   183,   833,  2798,   446,  4297,   946,   446,   462,   595,
     123,  3565,   250,   379,  3851,  2810,   379,   134,   394,   536,
     418,   595,   806,    18,  3054,   511,   607,   607,   514,   607,
    4392,  2513,    56,   185,   339,    14,  1248,   856,    92,   298,
    1823,   217,   883,  2838,  3050,  2509,    99,   304,   336,   954,
     801,  1224,   168,   219,   595,  3810,   529,  3768,   529,  3911,
     311,  4312,  4156,  2487,  3819,  4551,  3777,  4135,  3447,  4249,
    3455,  3038,  3783,   829,   517,   969,    46,  3788,  3789,  4239,
    3979,  4387,  3475,  4408,  4353,  3796,  4419,  3798,   752,  3440,
    3658,  2262,   933,  3330,    21,  3649,  2427,  4370,   626,   627,
     628,  1758,  4771,  4771,   945,  2442,  2442,  4894,  4230,  4114,
    4303,   952,  2143,   954,  3378,  3381,  4771,  2861,  2511,   660,
    3383,  4674,  4736,  4771,   890,   891,   892,   893,   105,   106,
     107,  4840,  2903,  4845,   953,  4219,  4635,  4360,   697,  3723,
    3918,  4549,  1601,  4506,  1043,  4506,  4680,  4513,  4545,  3703,
    1825,   970,  2519,  3809,  3639,  3512,  3513,  3514,  3515,  3485,
    4024,   259,  1255,  3093,  3084,  1261,  1267,  1864,  1965,  2607,
     909,  3507,  4175,  3637,  4174,  1332,   682,  4029,  2018,   921,
    3935,  1390,  1363,  3778,  2045,   967,  3149,   697,   979,  2634,
    3540,  1397,  1400,  2677,   722,  3184,  2103,  3540,  1005,   126,
    3198,  4004,  3797,  2139,  3200,  1442,  3216,  2716,  3557,  1037,
    4047,  3906,  4071,  1727,  3768,  3556,  3811,  1052,  2264,  1017,
    3581,  3239,  1061,  3777,  2300,  3980,  2752,  3254,  3253,  3783,
    3245,  2815,  3786,  1734,  3788,  3789,  2828,  1729,  2333,  1670,
     768,  1090,  3796,   712,  3798,  1092,  3800,   788,  2831,  1702,
    3290,   228,   229,   739,   231,  3850,   797,   184,  2350,  2350,
     187,  4344,   189,  4206,  2311,  3819,  3911,  2299,  4330,  3642,
    4068,  4377,  4450,  4028,  4382,  3986,  1745,  2529,  4033,  2527,
    1374,  3835,  2598,  1375,  3295,  2597,  3281,   214,  3280,  3878,
    2632,  1057,  3632,  3631,  3296,  2794,  2631,   711,  3688,   916,
    1422,  4104,  4154,  4155,  4156,  4016,  1326,  2794,  2794,  2794,
    1136,   722,   853,  2103,   855,  3423,  2967,  2481,  3897,   313,
    4098,   849,  3917,   864,   865,   866,  2319,   868,   869,  4508,
    3872,  3688,  3927,  1329,  3402,  2504,  4234,   821,   824,  4561,
     804,   875,  1759,   871,  4246,  2335,  3941,  2623,  2957,   835,
    3287,  1184,  4493,  4771,  2463,  4090,  3165,  3619,  4137,  3820,
     846,  4703,  4117,  3202,   845,  4817,  4873,   330,   344,  3230,
    3430,  2372,  2037,  4703,  3375,  1265,  1142,  4434,    18,  1767,
    2498,    -1,   309,  4790,  4832,    -1,  3795,    -1,  4240,  4707,
      30,    -1,    -1,  4196,  4246,    -1,    -1,  4108,  4109,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3208,  4169,    -1,  3970,  3971,  4737,    -1,
      -1,  3216,    -1,  4018,    -1,   953,  4021,  4022,   969,    -1,
      -1,   917,  3986,    -1,    -1,    -1,    -1,    -1,  4688,    -1,
      -1,    -1,    -1,    -1,    -1,   422,   423,    -1,    -1,    -1,
    4004,  4288,  4771,  4048,  4049,  4050,    -1,    -1,    98,  4709,
      -1,    -1,  4016,    -1,    -1,    -1,  4020,    -1,   954,    -1,
     447,    -1,    -1,    -1,    -1,  4070,    -1,    -1,    -1,  4033,
    4075,    -1,    -1,  3840,    -1,    -1,    -1,    -1,    -1,  3846,
    3847,    -1,  4046,    -1,    -1,    -1,   473,  4275,  4276,    -1,
      -1,    -1,    -1,    -1,    -1,  4342,     7,    -1,    -1,  1275,
    1276,  1277,    -1,    -1,    -1,    -1,  1282,  1283,  1284,    -1,
      -1,   498,    -1,    -1,    -1,    -1,  4791,  4238,    -1,  4083,
      -1,    -1,  1298,    -1,    -1,  1301,    -1,  4248,  4249,    -1,
      -1,  1307,  1308,  1309,  1310,  1311,  1312,  1313,  1314,  1315,
    1316,  1317,  1318,  4148,  4108,  4109,    -1,   484,    -1,    -1,
      -1,    -1,   486,    -1,    -1,    66,    -1,    -1,    -1,    -1,
    4124,    -1,    -1,  4376,    -1,    -1,    -1,    78,  1344,    -1,
      -1,    -1,  4136,  1349,    -1,  4437,    -1,    -1,  4142,  3384,
    4896,    -1,    -1,    -1,    -1,  4163,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4159,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4169,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   600,   125,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4186,    -1,  4229,    -1,    -1,    -1,    -1,    -1,
      -1,  4493,    -1,    -1,    -1,    -1,    -1,   148,    -1,    -1,
      -1,   578,    -1,    -1,    -1,   582,   633,  4368,    -1,    -1,
     637,   638,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4426,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   319,
    4234,  4038,    -1,  4237,  4238,    -1,    -1,    -1,   665,    -1,
      -1,    -1,    -1,    -1,  4248,  4249,    -1,    -1,    -1,  4551,
      -1,    -1,    -1,    -1,    -1,  4508,   207,    -1,    -1,    -1,
    4465,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4314,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4323,    -1,
    4567,    -1,    -1,  4328,    -1,    -1,    -1,  4332,    -1,    -1,
      -1,    -1,    -1,  4637,   668,    -1,   670,    -1,    -1,   673,
      -1,    -1,  4347,    18,   678,    -1,   680,    -1,    -1,    -1,
     684,    -1,  4517,   403,    -1,    30,    -1,    -1,    -1,    -1,
     694,    -1,    -1,   697,   701,    -1,    -1,  4372,  4373,    -1,
     704,    -1,    -1,    -1,  4379,    -1,    -1,    -1,    -1,    -1,
      -1,   292,    -1,    -1,   718,    -1,   720,   721,    -1,  4394,
      -1,    -1,  4397,  4398,  4399,  4400,    -1,    -1,    -1,    -1,
     734,    -1,    -1,   740,  4368,    -1,  4370,    -1,    -1,    -1,
      -1,    -1,   462,   463,    -1,    -1,    -1,    -1,    -1,    -1,
    4425,    -1,    -1,    98,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   481,    -1,    -1,  1610,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   832,   357,   497,  4613,    -1,
     787,    -1,   789,    -1,    -1,   366,    -1,  4622,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4471,  4472,  4473,  4474,
    4475,    -1,    -1,  4478,  4479,  4480,  4481,  4482,  4483,  4484,
    4485,  4486,  4487,  4488,   821,    -1,  4491,    -1,  4493,   670,
    4495,    -1,    -1,    -1,   675,    -1,   833,    -1,    -1,  4504,
      -1,    -1,  4507,  4668,    -1,    -1,   687,    -1,    -1,    -1,
      -1,   692,    -1,    -1,    -1,    -1,    -1,   851,  3723,    -1,
      -1,    -1,    -1,  4528,    -1,  4530,    -1,    -1,    -1,    -1,
     711,    -1,    -1,    -1,   871,    -1,    -1,   448,    -1,    -1,
      -1,    -1,    -1,    -1,   455,   595,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   890,   891,   892,   893,
      -1,    -1,    -1,    -1,    -1,  1741,    -1,    -1,    -1,   480,
      -1,  4736,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    18,    -1,  4799,   921,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    30,   508,    -1,  4764,
    4765,    -1,    -1,    -1,  4609,  4770,  4611,    -1,  4773,    -1,
     660,    -1,  4777,  4778,   948,    -1,  4621,   954,    -1,    -1,
    4833,    -1,  4787,    -1,    -1,    -1,    -1,    -1,   965,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4605,    -1,    -1,   319,   695,  4811,    -1,  4612,    -1,
      -1,    -1,  4616,    -1,    -1,  4619,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4828,    98,    -1,  4671,  3872,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4841,    -1,    -1,    -1,
    4845,  4846,    -1,  1017,    -1,    -1,    -1,  4692,    -1,    -1,
      -1,  4856,    -1,    -1,    -1,    -1,  1030,    -1,    -1,    -1,
      -1,   882,    -1,  1037,    -1,    -1,    -1,    -1,    -1,   890,
     891,   892,   893,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     901,    -1,    -1,  1057,    -1,    -1,    -1,    -1,   403,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   788,    -1,
    4745,  4746,    -1,  4748,    -1,    -1,   657,    -1,  1082,    -1,
     661,    -1,   933,    -1,    -1,    -1,  4720,    -1,  4763,  4723,
      -1,    -1,    -1,  4768,  4769,    -1,  4931,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1109,    -1,    -1,    -1,    -1,
      -1,  4786,    -1,    -1,  4789,    -1,  4791,   462,   463,    -1,
      -1,    -1,    -1,  1127,    -1,    -1,    -1,    -1,    -1,    -1,
    1134,  1135,    -1,   853,    -1,   855,   481,    -1,  1142,    -1,
      -1,  1145,  1146,    -1,   864,   865,   866,    -1,   868,   869,
      -1,    -1,   497,    -1,    -1,    -1,    -1,    -1,  1009,    -1,
      -1,   742,    -1,    -1,    -1,    -1,  4830,  4831,    -1,    -1,
      -1,    -1,    -1,    -1,  1025,    -1,    -1,    -1,    -1,    -1,
    4055,    -1,    -1,    -1,    -1,    -1,     0,     1,    -1,    -1,
      -1,     5,    -1,    -1,    -1,    -1,  4860,    11,    -1,    -1,
      -1,    -1,    -1,    -1,  4079,    19,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    28,   319,    -1,    -1,    -1,    -1,
      -1,    -1,   803,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1082,    -1,    -1,    -1,    -1,   817,    -1,    -1,    -1,
      -1,  1092,    -1,    -1,    -1,    -1,    -1,    -1,  1099,   969,
     595,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     841,    -1,    -1,    -1,  1268,  1269,    -1,    -1,    -1,    -1,
      -1,  1275,  1276,  1277,    -1,    -1,    -1,    -1,  1282,  1283,
    1284,  1285,    -1,    -1,  1288,    -1,    -1,   101,   102,    -1,
      -1,  1142,    -1,    -1,  1298,    -1,  1300,  1301,    -1,   403,
      -1,    -1,   883,  1307,  1308,  1309,  1310,  1311,  1312,  1313,
    1314,  1315,  1316,  1317,  1318,   660,    -1,    -1,   132,    -1,
      -1,    -1,    -1,  4198,    -1,  1329,    -1,  1331,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   152,    -1,
    1344,    -1,   156,    -1,    -1,  1349,    -1,    -1,    -1,    -1,
     695,    -1,   933,    -1,    -1,    -1,    -1,    -1,   462,   463,
     174,    -1,    -1,    -1,   945,    -1,    -1,    -1,    -1,    -1,
      -1,   952,    -1,   954,    -1,    -1,    -1,   481,    -1,  1383,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   497,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,     4,    -1,   219,    -1,    -1,    -1,    -1,
      -1,   225,    -1,   227,    -1,    -1,    -1,   231,  2264,    -1,
      -1,    -1,   236,    -1,  1275,  1276,  1277,    -1,    -1,    -1,
      -1,  1282,  1283,  1284,  1285,    -1,    -1,  1288,    -1,   253,
      -1,  1292,    -1,   788,    -1,    -1,    -1,  1298,    -1,  1300,
    1301,    -1,    -1,    -1,    -1,    -1,  1307,  1308,  1309,  1310,
    1311,  1312,  1313,  1314,  1315,  1316,  1317,  1318,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   290,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    87,    -1,    -1,    -1,
      -1,   595,   306,  1344,    18,    -1,    -1,   311,  1349,  4374,
      -1,    -1,    -1,   317,   318,    -1,    -1,    -1,   853,    -1,
     855,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   864,
     865,   866,    -1,   868,   869,    -1,    -1,    -1,    -1,    -1,
    2376,  2377,  1383,    -1,    -1,    -1,   137,    -1,    -1,   140,
     141,    -1,    -1,  1394,    -1,    -1,   147,    -1,    -1,  2395,
      -1,    -1,    -1,   154,   368,    -1,   660,    -1,    -1,    -1,
      -1,    -1,    -1,   377,    -1,    -1,   380,    -1,    -1,    -1,
      -1,   385,    -1,    -1,    61,    62,    63,    64,    -1,    -1,
      -1,    -1,    69,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   411,    -1,    -1,
      87,    88,    -1,    -1,  2450,   419,  1610,   421,    -1,    -1,
     424,    -1,    -1,   427,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   969,    -1,    -1,    -1,    -1,   443,
      -1,    -1,    -1,  4508,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   166,    -1,    -1,    -1,    -1,    -1,   172,   173,
      -1,   138,    -1,    -1,    -1,    -1,    -1,  1661,    -1,    -1,
      -1,    -1,    -1,    -1,   188,    -1,    -1,    -1,  1672,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   788,    -1,    -1,    -1,    -1,    -1,
     177,    -1,    -1,    -1,    -1,   509,    -1,  1701,    -1,    -1,
      -1,    -1,   516,    -1,   518,    -1,    -1,   521,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   537,    -1,    -1,    -1,    -1,    -1,  1733,
    2576,    -1,  2578,    -1,    -1,    -1,    -1,  1741,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   853,
      -1,   855,    -1,    -1,    -1,    -1,  2602,    -1,    -1,  1610,
     864,   865,   866,    -1,   868,   869,    -1,    -1,    -1,    -1,
      -1,    -1,  1623,    -1,    -1,  1626,    -1,    -1,   592,    -1,
    2626,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   390,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   615,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   301,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1683,    -1,    -1,    -1,    -1,    -1,    -1,   363,
     364,   365,   656,   444,    -1,    -1,    -1,    -1,   662,    -1,
      -1,   375,    -1,   667,    -1,   456,   670,   671,  1709,    -1,
      -1,    -1,    -1,    -1,    -1,   969,   467,    -1,    -1,    -1,
      -1,    -1,   473,   360,    -1,   689,   477,    -1,   479,   403,
      -1,    -1,    -1,    -1,    -1,  1889,    -1,   488,    -1,    -1,
    1741,    -1,    -1,   707,    -1,    -1,    -1,    -1,   712,    -1,
      -1,  1905,    -1,    -1,    -1,   719,    -1,    -1,    -1,    -1,
      -1,   725,    -1,    -1,   401,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1926,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     744,    -1,  1936,    -1,    -1,    -1,    -1,    -1,   539,    -1,
     464,    61,    62,    63,    64,   759,    -1,    -1,    -1,    69,
      -1,   765,  2798,    -1,    -1,  4830,  4831,   481,    -1,    -1,
      -1,   485,   486,   487,    -1,    -1,    -1,    87,    88,   783,
     494,    -1,    -1,   497,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   583,   797,    -1,  4860,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   807,   808,     1,    -1,    -1,     4,    -1,
      -1,    -1,   816,   166,    -1,   819,    -1,    -1,   495,   172,
     173,    -1,    -1,    -1,    -1,  2861,    -1,    -1,   138,   620,
     834,    -1,    -1,    -1,    -1,   188,    -1,    -1,    -1,    -1,
     631,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     641,  2045,   856,    -1,    -1,  2049,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2899,  1905,  2901,   580,   177,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   881,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     894,    87,    -1,    -1,    -1,  1936,   900,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   698,    -1,    -1,
      -1,    -1,    -1,  2949,  1955,    -1,    -1,    12,  1959,    -1,
      -1,   925,    -1,    18,  2960,    -1,   603,    -1,    -1,    -1,
      -1,    -1,  2126,    -1,    -1,  2129,    -1,  2131,  2132,  2133,
      -1,   137,    -1,    -1,   140,   141,   660,    -1,   739,    -1,
      -1,   147,    -1,  2147,   958,    -1,    -1,    -1,   154,   963,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   971,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   774,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   301,    -1,    -1,    -1,   786,    -1,    -1,    -1,    -1,
      -1,   715,    -1,    -1,  2045,    -1,    -1,    -1,    -1,    -1,
     363,   364,   365,    -1,    -1,    -1,    -1,  2058,    -1,    -1,
      -1,    -1,   375,    -1,    -1,    -1,    -1,   818,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   231,   232,   714,    -1,   716,
     717,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     360,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   736,
      -1,    -1,    -1,    -1,   741,   856,    -1,    -1,    -1,    -1,
    2264,   166,    -1,  2267,   788,    -1,    -1,   172,   173,    -1,
      -1,    -1,   177,    -1,    -1,    -1,    -1,    -1,   879,    -1,
      -1,   401,    -1,   188,  2135,   886,    -1,    -1,    -1,    -1,
     814,   815,    -1,   780,    -1,    -1,    -1,  2301,    -1,   462,
     463,   464,  2306,    -1,    -1,   792,    -1,    -1,  2312,  2313,
      -1,   912,    -1,    -1,    -1,    -1,    -1,    -1,   481,    -1,
      -1,    -1,   485,   486,   487,    -1,    -1,    -1,   929,    -1,
     931,   494,   338,   934,    -1,    -1,    -1,    -1,  2342,    -1,
      -1,    -1,   866,    -1,    -1,  2349,  2350,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2359,    -1,  2361,    -1,    -1,
     884,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   970,
      -1,    -1,  2376,  2377,    -1,   495,    -1,  2381,    -1,    -1,
      -1,    -1,    -1,    -1,   390,    -1,    -1,   911,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   919,   301,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   891,  2256,  2257,  2258,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   580,    -1,    -1,
      -1,    -1,   542,   947,    -1,    -1,    -1,    -1,    -1,    -1,
     954,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   444,    -1,
      -1,    -1,    -1,    -1,    -1,   969,    -1,    -1,    -1,    -1,
     456,   356,    -1,    -1,    -1,    -1,    -1,    -1,   363,   364,
     365,   467,  2313,    -1,    -1,    -1,    -1,   473,    -1,    -1,
     375,   477,    -1,   479,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3327,   488,   603,  3330,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2344,    -1,  2346,    -1,    -1,   403,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     415,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     526,    -1,    -1,    -1,  2528,  2376,  2377,    -1,    -1,    -1,
      -1,    -1,  3378,   539,    -1,  3381,    -1,  3383,  3384,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   715,  2557,    -1,    -1,    -1,   462,   463,   464,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   472,    -1,   474,
      -1,    -1,  2576,  3419,  2578,    -1,   481,   583,    -1,    -1,
     485,   486,   487,    -1,  2588,    -1,    -1,    -1,    -1,   494,
      -1,    -1,   497,    -1,   714,    -1,   716,   717,  2602,    -1,
      -1,  2605,    -1,    -1,    -1,   510,    -1,    -1,    -1,   514,
      -1,    -1,    -1,    -1,   620,    -1,   736,    -1,    -1,    -1,
      -1,   741,  2626,    -1,    -1,   631,    -1,    -1,    -1,  2633,
      -1,    -1,    -1,    -1,    -1,   641,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   814,   815,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     780,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   792,    -1,    -1,   580,    -1,    -1,    -1,    -1,
      -1,    -1,   587,    -1,    -1,    -1,    -1,    -1,    -1,  2693,
      -1,    -1,   698,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   608,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2719,    -1,    -1,    -1,    -1,
      -1,   884,    -1,    -1,    -1,  2576,    -1,  2578,    -1,    -1,
      -1,    -1,    -1,   739,    -1,  2739,    -1,  2588,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   911,    -1,
    2601,  2602,    -1,    -1,    -1,   660,   919,    -1,  2609,  2763,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   774,    -1,
      -1,   891,    -1,    -1,    -1,  2626,    -1,    -1,    -1,    -1,
     786,    -1,    -1,    -1,   947,    -1,    -1,  2791,    -1,    -1,
      -1,   954,    -1,    -1,  2798,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2810,    -1,    -1,    -1,
     715,    -1,   818,    -1,    -1,  2666,    -1,  2668,    -1,    -1,
      -1,    18,    -1,  3669,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2838,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,     0,     1,    -1,    -1,    -1,     5,    -1,    -1,
     856,    -1,    -1,    11,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    19,    -1,    -1,    -1,    -1,    -1,  2718,  2719,    -1,
      28,    -1,  3718,   879,    -1,    -1,    -1,  3723,    -1,    -1,
     886,    -1,  2733,   788,  2735,    -1,    44,   792,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   912,    -1,    -1,   814,
     815,    -1,   817,    -1,    -1,   921,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   929,    -1,   931,    -1,   124,   934,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   101,   102,    -1,    -1,  2798,   954,    -1,
      -1,    -1,    -1,    -1,  2805,    -1,    -1,   862,    -1,  2810,
      -1,   866,    -1,    -1,   970,    -1,    -1,    -1,    -1,   166,
      -1,    -1,    -1,    -1,   132,   172,   173,    -1,    -1,   884,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2838,    -1,    -1,
      -1,   188,    -1,    -1,   152,    -1,    -1,    -1,   156,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   911,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   919,    -1,   174,    -1,    -1,    -1,
      -1,  2872,    -1,    -1,    -1,    -1,  3872,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   947,   201,    -1,    -1,  2897,   952,   953,   954,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   219,    -1,    -1,   969,    -1,    -1,   225,    -1,   227,
      -1,    -1,    -1,   231,    -1,  3079,    -1,    -1,   236,    -1,
    3084,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   253,    -1,   255,    -1,    -1,
      -1,   259,   260,   261,   262,   263,    -1,   265,   266,   267,
     268,    -1,   270,   271,    -1,   273,   274,    -1,   276,   277,
     278,   279,   280,    -1,   282,   283,   284,   285,   286,   287,
      -1,    -1,   290,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     298,    -1,    -1,    -1,    -1,   303,    -1,    -1,   306,    -1,
      -1,    -1,    -1,   311,   312,    -1,    -1,    -1,    -1,   317,
     318,    -1,    61,    62,    63,    64,   363,   364,   365,    -1,
      69,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   375,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    87,    88,
      -1,  3195,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3208,    -1,   403,    -1,    -1,    -1,
     368,    -1,  3216,    -1,    -1,    -1,    -1,    -1,    -1,   377,
      -1,    -1,   380,    -1,    -1,    -1,    -1,   385,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3239,    -1,    -1,    -1,   138,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   166,
      -1,    -1,    -1,   411,    -1,   172,   173,    -1,  4104,   456,
      -1,   419,    -1,   421,    -1,    -1,   424,   464,    -1,   427,
      -1,   188,    -1,    -1,    -1,   433,    -1,    -1,   177,    -1,
      -1,    -1,    -1,    -1,   481,   443,    -1,    -1,   485,   486,
     487,    -1,    -1,    -1,    -1,    -1,    -1,   494,    -1,    -1,
     497,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     1,    -1,    -1,    -1,  3180,
      -1,  3182,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   509,    -1,    -1,    -1,    31,    -1,  3208,   516,    -1,
     518,    -1,    -1,   521,    -1,  3216,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3228,    -1,   537,
    3384,    -1,    -1,   580,    -1,    -1,    -1,    -1,   546,    -1,
      -1,    67,    -1,    -1,    70,    71,    72,    73,    74,    -1,
      76,    77,   301,    -1,    -1,    -1,    -1,  3411,   566,   567,
     568,    87,   570,   571,   572,   573,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   590,   591,   592,    -1,    -1,  3288,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   363,   364,   365,    -1,
     126,    -1,    -1,    -1,    -1,    -1,    -1,   615,   375,    -1,
      -1,   360,    -1,   660,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   154,   155,
      -1,   157,   158,   159,   160,   161,   162,   163,   164,   165,
      -1,    -1,    -1,    -1,  3345,    -1,    -1,    -1,   656,    -1,
      -1,    -1,   401,    -1,   662,    -1,    -1,    -1,    -1,   667,
      -1,    -1,   670,   671,    -1,    -1,    -1,  3521,   715,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   689,    -1,  3384,    -1,    -1,  3540,    -1,    -1,    -1,
     216,    -1,    -1,    -1,    -1,    -1,    -1,   464,   224,   707,
      -1,    -1,    -1,    -1,   712,   231,   232,    -1,    -1,    -1,
      -1,   719,    -1,    -1,   481,    -1,    -1,   725,   485,   486,
     487,    -1,    -1,    -1,    -1,    -1,    -1,   494,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   744,    -1,    -1,    -1,
      -1,   788,    -1,    -1,    -1,    -1,   495,    -1,    -1,    -1,
      -1,   759,    -1,    -1,    -1,    -1,    -1,   765,    -1,    -1,
      -1,    -1,    -1,  3617,    -1,    -1,    -1,   814,   815,  3623,
      -1,  3625,    -1,   781,    -1,   783,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3641,    -1,   797,
      -1,    54,   541,    -1,    -1,    -1,   322,   323,    -1,   807,
     808,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   816,    -1,
      -1,   819,   338,   580,    -1,    -1,    -1,    -1,    -1,   866,
      -1,   347,   348,   349,   350,   351,   834,   353,   354,   355,
      -1,  3532,   879,  3534,    -1,    -1,   362,   884,    -1,    -1,
      -1,    12,    -1,    -1,    -1,    -1,    -1,    18,   856,    -1,
     376,    -1,    -1,   379,   603,    -1,    -1,    -1,    -1,   867,
      -1,    -1,    -1,    -1,   911,    -1,   392,    -1,    -1,  3723,
      -1,    -1,   919,   881,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   409,    -1,    -1,   894,    -1,    -1,    -1,
     416,    -1,   900,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     947,    -1,    -1,   166,    -1,    -1,   432,   954,   434,   172,
     173,    -1,    -1,    -1,    -1,    -1,    -1,   925,   444,    -1,
      -1,    -1,   969,    -1,    -1,   188,    -1,    -1,    -1,    -1,
     456,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   946,    -1,
      -1,   467,   468,    -1,    -1,    -1,    -1,    -1,   715,    -1,
     958,    -1,    -1,   479,    -1,   963,    -1,    -1,    -1,    -1,
      -1,    -1,   488,   971,    -1,   714,    -1,   716,   717,    -1,
      -1,    -1,    -1,    -1,    -1,  3829,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   736,    -1,    -1,
      -1,    -1,   741,    -1,    -1,   166,    -1,    -1,    -1,    -1,
     526,   172,   173,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   188,  3872,    -1,
      -1,  3875,  3723,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   780,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   792,    -1,    -1,    -1,   814,   815,    -1,
      -1,    -1,    -1,  3907,  3908,    -1,    -1,   583,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3928,    -1,    -1,    -1,   604,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   620,    -1,    -1,    -1,    -1,   625,
     363,   364,   365,  4799,    -1,   631,    -1,    -1,    -1,    -1,
      -1,    -1,   375,    -1,    -1,   641,    -1,   884,    -1,   290,
      -1,    -1,   648,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4830,  4831,    -1,  4833,    -1,    -1,
     403,    -1,   891,    -1,   911,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   919,    -1,    -1,   681,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4860,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   698,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     947,    -1,    -1,    -1,    -1,    -1,    -1,   954,    -1,    -1,
      -1,    -1,   363,   364,   365,    -1,    -1,    -1,    -1,   462,
     463,   464,    -1,    -1,   375,    -1,    -1,    -1,    -1,   472,
     736,   474,    -1,   739,  4068,    -1,    -1,  4071,   481,    -1,
      -1,    -1,   485,   486,   487,  4079,    -1,   753,    -1,    -1,
      -1,   494,   403,    -1,   497,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   774,    -1,
     776,   777,   778,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   789,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   462,   463,   464,    -1,    -1,   822,    -1,    -1,    -1,
      -1,   472,    -1,   474,    -1,    -1,    -1,    -1,    -1,    -1,
     481,    -1,    -1,    -1,   485,   486,   487,   580,    -1,    -1,
      -1,    -1,    -1,   494,    -1,    -1,   497,    -1,    -1,  4183,
     856,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   514,  4198,   608,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   879,  4055,    -1,    -1,    -1,    -1,    -1,
     886,   887,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     896,   897,   898,    -1,    -1,    -1,    -1,    -1,  4079,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   912,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   921,    -1,   660,    -1,    -1,
      -1,   927,    -1,   929,    -1,   931,    -1,    -1,   934,   580,
      -1,    -1,   938,    -1,    -1,    -1,    -1,    -1,  4272,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4281,   954,    -1,
      -1,  4285,    -1,    -1,    -1,    -1,    -1,   608,    -1,    -1,
      -1,    -1,    -1,    -1,   970,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   715,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4330,    -1,    -1,  4333,
    4334,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   660,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4198,    -1,    -1,
      -1,  4355,  4356,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4374,    -1,    -1,  4377,    -1,   788,    -1,    -1,  4382,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4396,    -1,   715,    -1,    -1,    -1,    -1,    -1,
      -1,   814,   815,    -1,    -1,    -1,    -1,  4411,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4422,    -1,
      -1,    -1,  4426,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     853,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   864,    -1,   866,    -1,   868,   869,    -1,    -1,   780,
    4464,    -1,    -1,  4467,  4468,  4469,  4470,   788,    -1,    -1,
      -1,   884,    -1,  4477,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4490,    -1,    -1,    -1,
      -1,    -1,    -1,   814,   815,    -1,    -1,    -1,   911,    -1,
      -1,    -1,    -1,    -1,  4508,    -1,   919,    -1,    -1,    -1,
      -1,     0,     1,    -1,    -1,    -1,     5,    -1,    -1,    -1,
      -1,  4525,    11,  4374,    -1,  4529,    -1,    -1,    -1,    -1,
      19,    -1,    -1,    -1,   947,    -1,    -1,    -1,   859,    28,
      -1,   954,    -1,    -1,    -1,   866,    -1,    -1,    -1,   870,
      -1,    -1,    -1,    -1,    -1,    -1,   969,    -1,    -1,    -1,
      -1,    -1,    -1,   884,    -1,    -1,    -1,    -1,    -1,    -1,
    4574,  4575,  4576,  4577,  4578,  4579,  4580,  4581,  4582,  4583,
    4584,  4585,  4586,  4587,  4588,  4589,  4590,  4591,  4592,    -1,
     911,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   919,    -1,
    4604,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4613,
      -1,    12,   101,   102,    -1,    -1,    -1,    18,  4622,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   947,    -1,    -1,    -1,
      -1,    -1,    -1,   954,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   132,    -1,    -1,  4650,    -1,   969,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4662,    -1,
      -1,    -1,    -1,   152,  4668,    -1,    -1,   156,    -1,    -1,
    4674,  4675,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4688,   174,    -1,    -1,  4539,    -1,
      -1,    -1,  4696,  4697,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4709,  4710,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4729,    -1,    -1,    -1,    -1,
     219,    -1,  4736,    -1,    -1,    -1,   225,    -1,   227,  4743,
      -1,    -1,   231,    -1,    -1,    -1,    -1,   236,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4760,    -1,    -1,    -1,
    4764,  4765,    -1,    -1,   253,   166,  4770,    -1,  4772,  4773,
      -1,   172,   173,  4777,  4778,    -1,    -1,    -1,    -1,    -1,
      -1,   182,    -1,    12,    -1,    -1,    -1,   188,    -1,    18,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   290,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4818,    -1,    -1,   306,    -1,    -1,
      -1,    -1,   311,    -1,    -1,    -1,  4830,  4831,   317,   318,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4860,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    97,    -1,
      -1,    -1,    -1,    -1,    -1,  4879,  4880,    -1,    -1,   368,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   377,    -1,
      -1,   380,    -1,  4897,    -1,    -1,   385,    -1,    -1,    -1,
      -1,    -1,    -1,  4907,  4908,    -1,    -1,    -1,  4912,    -1,
       1,    -1,    -1,    -1,    -1,  4919,     7,    -1,    -1,    -1,
      -1,    -1,   411,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     419,    -1,   421,    -1,    -1,   424,    -1,   166,   427,    -1,
      -1,    -1,   171,   172,   173,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   443,    -1,    -1,    48,    -1,   188,
      -1,    -1,   363,   364,   365,    -1,    -1,    -1,    -1,    -1,
      61,    62,    63,    64,   375,    66,    -1,    -1,    69,  4830,
    4831,    -1,    -1,    -1,    -1,    -1,    -1,    78,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    87,    88,    -1,    -1,
      -1,    -1,   403,    -1,    -1,    -1,    -1,    -1,    -1,  4860,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   108,    -1,    -1,
     509,    -1,    -1,    -1,    -1,    -1,    -1,   516,    -1,   518,
      -1,    -1,   521,    -1,   125,    -1,    -1,    -1,    -1,   130,
      -1,    -1,    -1,    -1,    -1,    -1,   137,   138,   537,    -1,
     141,    -1,    -1,    -1,    -1,    -1,    -1,   148,    -1,    -1,
      -1,   462,   463,   464,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   472,    -1,   474,    -1,    -1,    -1,    -1,    -1,    -1,
     481,    -1,    -1,    -1,   485,   486,   487,    -1,    -1,    -1,
      -1,    -1,    -1,   494,    -1,   186,   497,    -1,    -1,    -1,
      -1,    -1,    -1,   592,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   514,    -1,    -1,   207,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   615,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   363,   364,   365,    -1,    -1,    -1,
     231,   232,    -1,    -1,    -1,    -1,   375,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   656,    -1,    -1,
      -1,    -1,    -1,   662,   403,    -1,    -1,    -1,   667,   580,
      -1,   670,   671,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     689,   292,    -1,    -1,    -1,    -1,    -1,   608,    -1,    -1,
     301,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   707,    -1,
      -1,    -1,    -1,   712,    -1,    -1,    -1,    -1,    -1,    -1,
     719,    -1,    -1,   462,   463,   464,   725,    -1,    -1,    -1,
      -1,    -1,    -1,   472,    -1,   474,    -1,   338,    -1,    -1,
      -1,    -1,   481,    -1,    -1,   744,   485,   486,   487,   660,
      -1,    -1,    -1,    -1,    -1,   494,    -1,    -1,   497,   360,
     759,    -1,    -1,    -1,    -1,   366,   765,    -1,   369,    -1,
     371,    -1,    -1,    -1,    -1,   514,    -1,    -1,   379,    -1,
      -1,    -1,    -1,    -1,   783,    -1,    -1,    -1,   389,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   797,    -1,
     401,    -1,   403,    -1,   715,    -1,    -1,    -1,   807,   808,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   816,    -1,    -1,
     819,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   434,    -1,   834,    -1,    -1,    -1,    -1,
      -1,   580,    -1,   444,    -1,    -1,    -1,   448,   587,    -1,
      -1,    -1,    -1,    -1,    -1,   456,    -1,   856,    -1,   460,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   608,
      -1,    -1,   473,    -1,    -1,    -1,   477,   788,    -1,   480,
     481,    -1,   881,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   495,   894,   497,    -1,    -1,    -1,
      -1,   900,    -1,   814,   815,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   829,    -1,
      -1,   660,    -1,    -1,    -1,   526,   925,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     1,
     541,    -1,    -1,    -1,   683,    -1,    -1,   548,    -1,    -1,
      12,    -1,    -1,    -1,    -1,   866,    18,    -1,    -1,   958,
      22,    23,    24,    -1,   963,    -1,    -1,    -1,    30,    31,
      -1,    -1,   971,   884,    -1,    -1,   715,    -1,    -1,    -1,
     581,    -1,   583,    -1,   585,    -1,    -1,    -1,    -1,    -1,
      -1,    53,    54,    55,    56,    57,    58,    59,    60,    -1,
     911,    -1,   603,    -1,    -1,    -1,    -1,    -1,   919,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   620,
      -1,    -1,    -1,    -1,    -1,    -1,   627,   628,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   947,    -1,    -1,    -1,
      -1,   780,    -1,   954,    -1,    -1,    -1,    -1,    -1,   788,
     651,    -1,    -1,    -1,    -1,    -1,   657,    -1,   969,   660,
     661,    -1,    -1,    -1,    -1,    -1,   128,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   814,   815,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   702,    -1,    -1,   166,    -1,    -1,    -1,    -1,    -1,
     172,   173,    12,   714,    -1,   716,   717,    -1,    18,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   188,   866,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   742,    -1,    -1,    -1,   884,    -1,    -1,   749,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   895,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   911,   774,    -1,    -1,    -1,    -1,    -1,   780,
     919,    -1,    -1,    -1,    -1,    -1,    -1,   788,    -1,    -1,
     929,   792,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   803,    -1,    -1,    -1,    -1,    -1,   947,    -1,
      -1,    -1,    -1,    -1,    -1,   954,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   826,    -1,    -1,    -1,    -1,
     969,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   300,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     851,    -1,    -1,    -1,    -1,   856,    -1,   319,    -1,    -1,
      -1,   862,    -1,    -1,    -1,   866,   166,    -1,    -1,    -1,
      -1,    -1,   172,   173,    -1,    -1,    -1,    -1,   879,    -1,
      -1,    -1,   883,    -1,    -1,    -1,    -1,    -1,   188,    -1,
     891,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   363,   364,   365,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   912,    -1,   375,    -1,    -1,    -1,    -1,    -1,   920,
     921,    -1,    -1,    -1,    -1,   387,   388,    -1,   929,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   403,    -1,    -1,   945,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   954,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   969,    -1,
      -1,    -1,   434,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     462,   463,   464,   465,   466,    -1,    -1,    -1,    -1,    -1,
     472,    -1,   474,    -1,    -1,    -1,    -1,    -1,    -1,   481,
      -1,    -1,    -1,   485,   486,   487,    -1,    -1,    -1,    -1,
      -1,    -1,   494,    -1,    -1,   497,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   514,    -1,    -1,    -1,     1,    -1,    -1,    -1,
      -1,    -1,    -1,   363,   364,   365,    -1,    12,    -1,    -1,
      -1,    -1,   534,    18,    -1,   375,    -1,    22,    23,    24,
      -1,    -1,    -1,    -1,    -1,    30,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   559,    -1,    -1,
      -1,    -1,    -1,   403,    -1,    -1,    -1,   569,    53,    54,
      55,    56,    57,    58,    59,    60,   578,    -1,   580,    -1,
      -1,    -1,    -1,    -1,    -1,   587,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   595,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   608,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   462,   463,   464,    -1,    -1,    -1,   630,    -1,
      -1,    -1,   472,    -1,   474,    -1,    -1,    -1,    -1,    -1,
      -1,   481,    -1,   128,    -1,   485,   486,   487,    -1,    -1,
      -1,    -1,    -1,    -1,   494,    -1,    -1,   497,   660,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,     1,   514,    -1,    -1,    -1,    -1,    -1,
      -1,   166,    -1,    -1,    12,    -1,    -1,   172,   173,    -1,
      18,    -1,    -1,    -1,    22,    23,    24,    -1,    -1,    -1,
      -1,    -1,    30,   188,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   715,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    53,    54,    55,    56,    57,
      58,    59,    60,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     580,    -1,    -1,    -1,    -1,    -1,    -1,   587,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   608,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   788,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     128,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   814,   815,    -1,   300,    -1,    -1,    -1,    -1,
     660,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   318,   319,    -1,    -1,    -1,   166,    -1,
      -1,    -1,    -1,    -1,   172,   173,    -1,    -1,    -1,    -1,
      -1,   853,    -1,   855,    -1,   857,    -1,   859,    -1,   861,
     188,   863,   864,   865,   866,    -1,   868,   869,   870,    -1,
      -1,    -1,    -1,    -1,    -1,   715,    -1,    -1,   363,   364,
     365,    -1,   884,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     375,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   387,   388,    -1,    -1,    -1,    -1,    -1,   911,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   919,   403,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     780,    -1,    -1,    -1,    -1,   947,    -1,    -1,   788,   434,
      -1,    -1,   954,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   969,    -1,    -1,
      -1,    -1,   300,    -1,   814,   815,    -1,   462,   463,   464,
     465,   466,    -1,    -1,    -1,    -1,    -1,   472,    -1,   474,
      -1,   319,    -1,    -1,    -1,    -1,   481,    -1,    -1,    -1,
     485,   486,   487,    -1,    -1,    -1,    -1,    -1,    -1,   494,
      -1,    -1,   497,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   866,    -1,    -1,   514,
      -1,    -1,    -1,    -1,    -1,   363,   364,   365,    -1,    -1,
      -1,    -1,    -1,    -1,   884,    -1,    -1,   375,    -1,   534,
      -1,    -1,    -1,    -1,    -1,   895,    -1,    -1,    -1,   387,
     388,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   911,    -1,    -1,   559,   403,    -1,    -1,    -1,   919,
      -1,    -1,    -1,    -1,   569,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   578,    -1,   580,    -1,    -1,    -1,    -1,
      -1,    -1,   587,    -1,    -1,    -1,   434,   947,    -1,    -1,
     595,    -1,    -1,    -1,   954,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   608,    -1,    -1,    -1,    -1,    -1,   969,
      -1,    -1,    -1,    -1,   462,   463,   464,   465,   466,    -1,
      -1,    -1,    -1,    -1,   472,   630,   474,    -1,    -1,    -1,
      -1,     6,    -1,   481,    -1,    10,    -1,   485,   486,   487,
      -1,    -1,    -1,    -1,    -1,    -1,   494,    -1,    -1,   497,
      -1,    -1,    -1,    -1,    29,   660,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   514,    42,    -1,    -1,
       1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    12,    -1,    -1,    -1,    -1,   534,    18,    -1,    -1,
      -1,    22,    23,    24,    -1,    -1,    -1,    -1,    -1,    30,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     715,   559,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   569,    53,    54,    55,    56,    57,    58,    59,    60,
     578,    -1,   580,    -1,    -1,     1,    -1,    -1,    -1,   587,
       6,    -1,    -1,    -1,    10,    -1,    -1,   595,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     608,   136,    -1,    29,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    42,    -1,    -1,    -1,
      -1,    -1,   630,   788,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   128,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    -1,    -1,    -1,    -1,   814,
     815,    -1,   660,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,     1,    -1,    -1,    -1,    -1,   201,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   166,    -1,    -1,    -1,    -1,
      -1,   172,   173,    -1,    -1,    -1,    -1,    -1,   853,    -1,
     855,    -1,   857,    -1,    -1,    -1,   861,   188,   863,   864,
     865,   866,    -1,   868,   869,    -1,    -1,   715,    -1,    -1,
     136,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   884,
      -1,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    71,    72,    73,    74,    -1,    76,    77,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   911,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   919,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   201,    -1,    -1,    -1,    -1,
     788,    -1,   947,    -1,    -1,    -1,    -1,    -1,    -1,   954,
      -1,    -1,    -1,    -1,    -1,    -1,   331,   332,    -1,    -1,
      -1,    -1,    -1,    -1,   969,    -1,   814,   815,    -1,   300,
      -1,    -1,    -1,    -1,    -1,   155,    -1,   157,   158,   159,
     160,   161,   162,   163,   164,   165,    -1,    -1,   319,    -1,
      -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   853,    -1,   855,    -1,   857,
      -1,    -1,    -1,   861,    -1,   863,   864,   865,   866,    -1,
     868,   869,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   363,   364,   365,    -1,   884,    -1,    -1,    -1,
      -1,    -1,   417,    -1,   375,    -1,    -1,    -1,    -1,    -1,
      -1,   231,   232,    -1,    -1,    -1,   387,   388,    -1,    -1,
      -1,    -1,    -1,   911,    -1,   331,   332,   442,    -1,    -1,
      -1,   919,   403,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   473,   947,
      -1,    -1,    -1,    -1,    -1,    -1,   954,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   489,    -1,    -1,    -1,    -1,    -1,
      -1,   969,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   462,   463,   464,   465,   466,    -1,    -1,    -1,    -1,
      -1,   472,    -1,   474,    -1,    -1,    -1,    -1,    -1,    -1,
     481,   417,    -1,    -1,   485,   486,   487,    -1,    -1,    -1,
      -1,    -1,    -1,   494,    -1,    -1,   497,   347,   348,   349,
     350,   351,    -1,   353,   354,   355,   442,    -1,    -1,    -1,
     555,    -1,    -1,   514,    -1,    -1,    -1,     1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   376,    -1,    12,    -1,
      -1,    -1,    -1,   534,    18,    -1,    -1,   473,    22,    23,
      24,    -1,   392,    -1,    -1,    -1,    30,    -1,    -1,    -1,
      -1,    -1,   597,   489,    -1,    -1,    -1,    -1,   559,    -1,
     605,    -1,    -1,    -1,    -1,    -1,   416,    -1,   569,    53,
      54,    55,    56,    57,    58,    59,    60,   578,    -1,   580,
      -1,    -1,    -1,    -1,    -1,    -1,   587,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   595,    -1,   641,   598,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   608,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   555,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   673,   630,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   688,   128,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   660,
     705,   597,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   605,
      -1,    -1,    -1,    -1,    -1,    -1,   526,    -1,    -1,    -1,
      -1,    -1,   166,    -1,    -1,    -1,    -1,    -1,   172,   173,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   188,   641,    -1,    -1,   753,    -1,
      -1,    -1,    -1,    -1,   715,    -1,    -1,    -1,   763,    -1,
      -1,    -1,    -1,    -1,   769,    -1,    -1,    -1,    -1,    -1,
      -1,   581,    -1,    -1,    -1,    -1,    -1,   673,   783,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   688,    -1,   604,    -1,    -1,   802,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   705,
      -1,    -1,    -1,    -1,    -1,   625,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   788,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   648,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   856,    -1,   814,   815,   860,   300,   753,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   763,   764,    -1,
      -1,   876,   877,   769,    -1,   319,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   783,    -1,    -1,
      -1,    -1,   853,    -1,   855,    -1,   857,    -1,    -1,    -1,
     861,    -1,   863,   864,   865,   866,   802,   868,   869,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   363,
     364,   365,    -1,   884,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   375,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   387,   388,    -1,    -1,    -1,    -1,    -1,
     911,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   919,   403,
     856,    -1,    -1,    -1,   860,    -1,   776,   777,   778,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     876,   877,    -1,    -1,    -1,    -1,   947,    -1,    -1,    -1,
      -1,    -1,    -1,   954,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   969,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   462,   463,
     464,   465,   466,    -1,    -1,    -1,    -1,    -1,   472,    -1,
     474,    -1,    -1,    -1,    -1,    -1,    -1,   481,    -1,    -1,
      -1,   485,   486,   487,    -1,    -1,    -1,    -1,    -1,    -1,
     494,    -1,    -1,   497,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     514,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   896,   897,   898,    -1,
     534,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   921,    -1,    -1,    -1,   559,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   569,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   578,    -1,   580,    -1,    -1,    -1,
      -1,    -1,    -1,   587,   954,    -1,    -1,    -1,    -1,     3,
      -1,   595,    -1,    -1,    -1,     9,    -1,    -1,    -1,    13,
      -1,    -1,    -1,    17,   608,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    29,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   630,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    49,    50,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   660,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    -1,    -1,    -1,    -1,    91,    92,    93,
      -1,    95,    96,    -1,    -1,    -1,   100,    -1,    -1,   103,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   111,   112,   113,
     114,   115,    -1,   117,   118,    -1,    -1,    -1,    -1,    -1,
      -1,   715,    -1,    -1,    -1,   129,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   139,    -1,    -1,   142,   143,
     144,   145,   146,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   180,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   189,   190,   191,   192,   193,
     194,   195,   196,    -1,   788,    -1,   200,    -1,   202,    -1,
     204,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   217,    -1,    -1,    -1,    -1,    -1,    -1,
     814,   815,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   233,
     234,    -1,    -1,   237,   238,    -1,   240,   241,   242,   243,
     244,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   853,
     264,   855,    -1,   857,    -1,    -1,    -1,   861,    -1,   863,
     864,   865,   866,    -1,   868,   869,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   288,   289,    -1,    -1,    -1,   293,
     884,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     304,    -1,    -1,    -1,   308,    -1,    -1,    -1,    -1,    -1,
     314,   315,    -1,    -1,    -1,    -1,    -1,   911,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   919,    -1,    -1,    -1,   333,
     334,   335,   336,   337,    -1,    -1,   340,    -1,    -1,    -1,
     344,   345,   346,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   947,    -1,    -1,    -1,    -1,    -1,    -1,
     954,    -1,    -1,   367,    -1,    -1,    -1,    -1,   372,    -1,
      -1,    -1,    -1,    -1,    -1,   969,    -1,   381,   382,   383,
     384,    -1,    -1,    -1,    -1,    -1,   390,   391,    -1,   393,
      -1,   395,   396,   397,   398,   399,   400,    -1,   402,    -1,
     404,   405,   406,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   425,   426,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   435,   436,   437,   438,   439,   440,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   449,    -1,    -1,    -1,   453,
      -1,    -1,    -1,   457,    -1,   459,    -1,   461,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   478,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   491,   492,   493,
      -1,    -1,   496,    -1,    -1,    -1,   500,    -1,   502,   503,
     504,   505,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   513,
      -1,    -1,    -1,    -1,    -1,   519,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   530,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   538,    -1,    -1,    -1,    -1,   543,
     544,   545,    -1,   547,    -1,   549,   550,    -1,   552,   553,
     554,    -1,    -1,    -1,    -1,   559,   560,    -1,   562,   563,
     564,   565,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     574,   575,    -1,    -1,   578,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   586,    -1,     1,    -1,    -1,    -1,     5,    -1,
      -1,    -1,    -1,    -1,    11,    -1,    -1,   601,   602,    -1,
      -1,    -1,    19,    -1,    -1,   609,   610,    -1,   612,    -1,
      -1,    28,   616,    -1,    -1,    -1,    -1,    -1,    -1,   623,
      -1,    -1,    -1,    -1,    -1,   629,    -1,    -1,    -1,   633,
      -1,   635,   636,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   649,    -1,    -1,   652,   653,
      -1,    -1,    -1,    -1,   658,    -1,    -1,    -1,    -1,   663,
      -1,    -1,    -1,    -1,    -1,   669,    -1,    -1,    -1,    -1,
     674,    -1,   676,   677,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   685,   686,    -1,   101,   102,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    12,    -1,    -1,    -1,    -1,
      -1,    18,    -1,    -1,   708,   709,   710,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   132,    -1,    -1,   722,   723,
     724,    -1,    -1,    -1,   728,   729,   730,   731,   732,   733,
      -1,    -1,    -1,   737,   738,   152,    -1,    -1,    -1,   156,
      -1,   745,   746,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     754,   755,   756,   757,    -1,    -1,    -1,   174,   762,    -1,
      -1,    -1,    -1,   767,    -1,    -1,   770,   771,   772,   773,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   785,    -1,    -1,    -1,    -1,   790,   791,    -1,    -1,
      -1,    -1,    -1,    -1,   798,   799,    -1,   801,    -1,    -1,
     804,    -1,   219,    -1,    -1,    -1,   810,    -1,   225,    -1,
     227,    -1,    -1,    -1,   231,    -1,    -1,    -1,    -1,   236,
      -1,    -1,    -1,   827,   828,    -1,    -1,   831,    -1,    -1,
      -1,    -1,   836,    -1,    -1,    -1,   253,    -1,    -1,    -1,
     844,   845,   846,    -1,    -1,    -1,   850,    -1,    -1,   166,
      -1,    -1,    -1,    -1,    -1,   172,   173,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   188,    -1,   290,    -1,    -1,   880,    -1,   882,    -1,
      -1,    -1,   886,    -1,    -1,    -1,    -1,    -1,   892,   306,
      -1,    -1,    -1,    -1,   311,   899,    -1,    -1,    -1,    -1,
     317,   318,    -1,    -1,    -1,    -1,   910,    -1,    -1,    -1,
     914,   915,   916,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   930,    -1,    -1,    -1,
      -1,   935,   936,   937,    -1,   939,   940,   941,   942,   943,
      -1,    -1,    -1,    -1,    -1,   949,   950,    -1,    -1,    -1,
      -1,   368,    -1,    -1,    -1,    -1,    -1,    -1,   962,    -1,
     377,    -1,   966,   380,    -1,    -1,    -1,    -1,   385,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   302,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   411,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   419,    -1,   421,    -1,    -1,   424,    -1,    -1,
     427,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   443,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   363,   364,   365,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   375,    -1,
      -1,   378,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   403,    -1,    -1,    -1,
      -1,    -1,   509,    -1,    -1,    -1,    -1,    -1,    -1,   516,
      -1,   518,    -1,    -1,   521,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     537,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   462,   463,   464,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   472,    -1,   474,    -1,    -1,
      -1,    -1,    -1,    -1,   481,    -1,    -1,    -1,   485,   486,
     487,    -1,    -1,    -1,    -1,   592,    -1,   494,    -1,    -1,
     497,    -1,    43,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   514,   615,    -1,
      61,    62,    63,    64,    -1,    -1,    -1,    -1,    69,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    87,    88,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   656,
      -1,   558,    -1,    -1,    -1,   662,    -1,    -1,    -1,    -1,
     667,    -1,    -1,   670,   671,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   580,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   689,    -1,    -1,    -1,   137,   138,    -1,    -1,
     141,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     707,   608,    -1,    -1,    -1,   712,    -1,    -1,    -1,    -1,
      -1,    -1,   719,    -1,    -1,    -1,    -1,    -1,   725,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   177,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   744,    -1,    -1,
      -1,    -1,    -1,     9,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    17,   759,   660,    -1,    -1,    -1,    -1,   765,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   783,    -1,    -1,    -1,
      -1,    -1,    48,    49,    -1,    -1,    -1,    -1,    -1,    -1,
     797,    -1,    -1,    -1,    -1,    61,    62,    63,    64,    -1,
     807,   808,    -1,    69,    -1,    -1,   713,    -1,   715,   816,
      -1,    -1,   819,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    -1,    -1,    -1,   834,    -1,    95,
      -1,    -1,    -1,    -1,   100,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   108,    -1,    -1,   111,   112,   113,   114,    -1,
     301,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   129,   130,    -1,    -1,    -1,    -1,    -1,
      -1,   137,   138,   139,   881,   141,   142,   143,   144,    -1,
     146,   788,    -1,    -1,    -1,    -1,    -1,   894,    -1,    -1,
      -1,    -1,    -1,   900,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   814,   815,   360,
      -1,    -1,    -1,    -1,   180,    -1,    -1,    -1,   925,    -1,
     186,    -1,    -1,   189,   190,   191,   192,   193,   194,   195,
     196,    -1,    -1,    -1,    -1,    -1,   202,    -1,   204,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     401,   958,    -1,    -1,    -1,    -1,   963,    -1,    -1,   866,
      -1,    -1,    -1,    -1,    -1,   231,   232,   233,   234,    -1,
      -1,   237,   238,    -1,    -1,    -1,   242,   884,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   264,    -1,
      -1,    -1,    -1,    -1,   911,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   919,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   473,   289,    -1,    -1,    -1,   293,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   301,    -1,    -1,    -1,    -1,
     947,    -1,   308,    -1,   495,    -1,   953,   954,   314,   315,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   969,    -1,   515,    -1,    -1,   333,   334,   335,
     336,   337,    -1,    -1,   340,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   542,    -1,    -1,   360,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   369,    -1,   371,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   379,    -1,   381,   382,   383,   384,    -1,
      -1,    -1,    -1,   389,   390,   391,    -1,   393,    -1,   395,
     396,   397,    -1,    -1,   400,   401,   402,   403,    -1,    -1,
     406,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   603,    -1,    -1,    -1,    -1,    -1,    -1,   425,
     426,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   434,   435,
     436,   437,   438,   439,   440,    -1,   627,   628,   444,    -1,
      -1,    -1,    -1,   449,    -1,    -1,    -1,   453,    -1,    -1,
     456,   457,    -1,    -1,   460,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   473,    -1,    -1,
      -1,   477,    -1,    -1,    -1,   481,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   495,
     496,   497,    -1,    -1,   500,    -1,   502,   503,   504,   505,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   513,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     526,    -1,    -1,   714,   530,   716,   717,    -1,    -1,    -1,
      -1,    -1,   538,    -1,    -1,   541,    -1,    -1,    -1,    -1,
      -1,    -1,   548,    -1,    -1,   736,    -1,    -1,   166,    -1,
     741,    -1,    -1,   559,   172,   173,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   574,   575,
     188,    -1,    -1,    -1,    -1,    -1,    -1,   583,    -1,   585,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   780,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   603,    -1,    -1,
      -1,   792,    -1,   609,    -1,    -1,   612,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   620,    -1,    -1,   623,    -1,    -1,
      -1,   627,   628,   629,    -1,    -1,    -1,   633,    -1,   635,
     636,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   649,    -1,   651,   652,   653,    -1,    -1,
      -1,    -1,   658,    -1,   660,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   674,    -1,
     676,   677,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   685,
     686,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   702,    -1,    -1,    -1,
     891,    -1,   708,   709,   710,    -1,    -1,    -1,   714,    -1,
     716,   717,    -1,    -1,   905,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   728,   729,   730,   731,    -1,   733,    -1,    -1,
      -1,   737,   738,    -1,    -1,    -1,    -1,    -1,    -1,   745,
     746,    -1,    -1,   749,    -1,   363,   364,   365,   754,   755,
     756,    -1,    -1,    -1,    -1,    -1,   762,   375,    -1,    -1,
      -1,   767,   953,    -1,    -1,    -1,    -1,    -1,   774,    -1,
      -1,    -1,    -1,    -1,   780,    -1,    -1,    -1,    -1,   785,
      -1,    -1,   788,    -1,    -1,   403,   792,    -1,    -1,    -1,
      -1,    -1,   798,   799,    -1,    -1,    -1,    -1,   804,    -1,
      -1,    -1,    -1,    -1,   810,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     826,   827,   828,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     836,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   844,    -1,
      -1,    -1,    -1,    -1,   850,   851,   464,    -1,    -1,    -1,
     856,    -1,    -1,    -1,    -1,    -1,   862,    -1,    -1,    -1,
     866,    -1,    -1,   481,    -1,    -1,    -1,   485,   486,   487,
      -1,    -1,    -1,   879,   880,    -1,   494,    -1,    -1,   497,
     886,    -1,    -1,    -1,    -1,   891,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     9,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,   912,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   920,   921,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   929,   930,    -1,    -1,    -1,    -1,    -1,
      -1,   937,    -1,   939,    48,    49,   942,    -1,    -1,    -1,
      -1,    -1,    -1,   949,    -1,    -1,    -1,    61,    62,    63,
      64,    -1,    -1,    -1,    -1,    69,   962,    -1,    -1,    -1,
     966,    -1,   580,   969,    -1,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    -1,    -1,    -1,    -1,   100,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   108,    -1,    -1,   111,   112,   113,
     114,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   129,   130,    -1,    -1,    -1,
      -1,    -1,    -1,   137,   138,   139,    -1,   141,   142,   143,
     144,    -1,   146,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   660,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   180,    -1,    -1,    -1,
      -1,    -1,   186,    -1,    -1,   189,   190,   191,   192,   193,
     194,   195,   196,    -1,    -1,    -1,    -1,    -1,   202,    -1,
     204,    -1,    -1,    -1,    -1,    -1,    -1,   715,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   231,   232,   233,
     234,    -1,    -1,   237,   238,    -1,    -1,    -1,   242,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     788,    -1,    -1,    -1,    -1,   289,    -1,    -1,    -1,   293,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   301,    -1,    -1,
      -1,    -1,    -1,    -1,   308,    -1,   814,   815,    -1,    -1,
     314,   315,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   333,
     334,   335,   336,   337,    -1,    -1,   340,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   360,    -1,   866,    -1,
      -1,    -1,    -1,    -1,    -1,   369,    -1,   371,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   379,   884,   381,   382,   383,
     384,    -1,    -1,    -1,    -1,   389,   390,   391,    -1,   393,
      -1,   395,   396,   397,    -1,    -1,   400,   401,   402,   403,
      -1,    -1,   406,   911,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   919,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   425,   426,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     434,   435,   436,   437,   438,   439,   440,    -1,    -1,   947,
     444,    -1,    -1,    -1,    -1,   449,   954,    -1,    -1,   453,
      -1,    -1,   456,   457,    -1,    -1,   460,    -1,    -1,    -1,
      -1,   969,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   473,
      -1,    -1,    -1,   477,    -1,    -1,    -1,   481,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   495,   496,   497,    -1,    -1,   500,    -1,   502,   503,
     504,   505,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   513,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   526,    -1,    -1,    -1,   530,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   538,    -1,    -1,   541,    -1,    -1,
      -1,    -1,    -1,    -1,   548,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   559,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     574,   575,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   583,
      -1,   585,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   603,
      -1,    -1,    -1,    -1,    -1,   609,    -1,    -1,   612,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   620,    -1,    -1,   623,
      -1,    -1,    -1,   627,   628,   629,    -1,    -1,    -1,   633,
      -1,   635,   636,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   649,    -1,   651,   652,   653,
      -1,    -1,    -1,    -1,   658,    -1,   660,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     674,    -1,   676,   677,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   685,   686,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   702,    -1,
      -1,    -1,    -1,    -1,   708,   709,   710,    -1,    -1,    -1,
     714,    -1,   716,   717,    -1,    -1,     5,    -1,    -1,    -1,
      -1,    -1,    11,    -1,   728,   729,   730,   731,    -1,   733,
      19,    -1,    -1,   737,   738,    -1,    -1,    -1,    -1,    28,
      -1,   745,   746,    -1,    -1,   749,    -1,    -1,    -1,    -1,
     754,   755,   756,    -1,    -1,    -1,    -1,    -1,   762,    -1,
      -1,    -1,    -1,   767,    -1,    -1,    -1,    -1,    -1,    -1,
     774,    -1,    -1,    -1,    -1,    -1,   780,    -1,    -1,    -1,
      -1,   785,    -1,    -1,   788,    -1,    -1,    -1,   792,    -1,
      -1,    -1,    -1,    -1,   798,   799,    -1,    -1,    -1,    -1,
     804,    -1,    -1,    -1,    -1,    -1,   810,    -1,    -1,    -1,
      -1,    -1,   101,   102,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   826,   827,   828,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   836,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     844,    -1,    -1,   132,    -1,    -1,   850,   851,    12,    -1,
      -1,    -1,   856,    -1,    18,    -1,    -1,    -1,   862,    -1,
      -1,    -1,   866,   152,    -1,    -1,    -1,   156,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   879,   880,    -1,    -1,    -1,
      -1,    -1,   886,    -1,    -1,   174,    -1,   891,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   912,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   920,   921,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   929,   930,    -1,    -1,    -1,
     219,    -1,    -1,   937,    -1,   939,    -1,    -1,   942,    -1,
      -1,    -1,   231,    -1,    -1,   949,    -1,   236,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   962,    -1,
      -1,    -1,   966,    -1,    -1,   969,   255,    -1,    -1,    -1,
      -1,   260,   261,   262,   263,    -1,   265,   266,   267,   268,
      -1,   270,    -1,   272,   273,   274,    -1,   276,   277,   278,
     279,   280,    -1,   282,   283,   284,   285,   286,   287,    -1,
      -1,   290,   166,    -1,    -1,    -1,    -1,    -1,   172,   173,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   306,   182,    -1,
      -1,    -1,    -1,    -1,   188,    -1,    -1,    -1,   317,   318,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   368,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   377,    -1,
      -1,   380,    -1,    -1,    -1,    -1,   385,    -1,    -1,    -1,
      -1,    -1,    70,    71,    72,    73,    74,    -1,    76,    77,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   411,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     419,    -1,   421,    -1,    -1,   424,    -1,    -1,   427,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   155,    -1,   157,
     158,   159,   160,   161,   162,   163,   164,   165,    -1,   363,
     364,   365,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   375,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     509,    -1,    -1,    -1,    -1,    -1,    -1,   516,    -1,   518,
      -1,    -1,   521,    -1,    -1,    -1,    -1,    -1,    -1,   403,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   537,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   231,   232,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   462,   463,
     464,    -1,    -1,   592,    -1,    -1,    -1,    -1,   472,    -1,
     474,    -1,    -1,    -1,    -1,    -1,    -1,   481,    -1,    -1,
      -1,   485,   486,   487,    -1,    -1,   615,    -1,    -1,    -1,
     494,    -1,    -1,   497,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     514,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   667,   347,
     348,   349,   350,   351,    -1,   353,   354,   355,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     689,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   376,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   580,    -1,    -1,    -1,
      -1,    -1,    -1,   712,   392,    -1,    -1,    -1,    -1,    -1,
     719,    -1,    -1,    -1,    -1,    -1,   725,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   608,    -1,    -1,    -1,   416,    -1,
      -1,    -1,    -1,    -1,    -1,   744,    -1,    -1,    -1,    -1,
      -1,     9,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    -1,    -1,    -1,    -1,   765,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   783,    -1,   660,    -1,    -1,    -1,
      -1,    49,    -1,    -1,    -1,    -1,    -1,    -1,   797,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   807,   808,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   816,    -1,    -1,
     819,    79,    80,    81,    82,    83,    84,    85,    86,    -1,
      -1,    -1,    -1,    -1,    -1,   834,    -1,    95,    -1,    -1,
      -1,   715,   100,    -1,    -1,    -1,    -1,    -1,   526,    -1,
      -1,    -1,    -1,   111,   112,   113,   114,   856,    12,    -1,
      -1,    -1,    -1,    -1,    18,    -1,    -1,    -1,    -1,    -1,
      -1,   129,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   139,   881,    -1,   142,   143,   144,    -1,   146,    -1,
      -1,    -1,    -1,    -1,    -1,   894,    -1,    -1,    -1,    -1,
      -1,   900,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   788,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   180,    -1,    -1,    -1,   604,    -1,    -1,    -1,
      -1,   189,   190,   191,   192,   193,   194,   195,   196,    -1,
     814,   815,    -1,    -1,   202,    -1,   204,   625,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   829,    -1,    -1,    -1,   958,
      -1,    -1,    -1,    -1,   963,    -1,    -1,    -1,    -1,    -1,
     648,    -1,    -1,    -1,    -1,   233,   234,    -1,    -1,   237,
     238,    -1,    -1,    -1,   242,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   866,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   264,    -1,    -1,    -1,
     884,    -1,   166,    -1,    -1,    -1,    -1,    -1,   172,   173,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   182,    -1,
      -1,   289,    -1,    -1,   188,   293,    -1,   911,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   919,    -1,    -1,    -1,    -1,
     308,    -1,    -1,    -1,    -1,    -1,   314,   315,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   947,    -1,   333,   334,   335,   336,   337,
     954,    -1,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   969,    -1,    -1,   776,   777,
     778,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   381,   382,   383,   384,    -1,    -1,    -1,
      -1,    -1,   390,   391,    -1,   393,    -1,   395,   396,   397,
      -1,    -1,   400,    -1,   402,    -1,    -1,    -1,   406,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   425,   426,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   435,   436,   437,
     438,   439,   440,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   449,    -1,    -1,    -1,   453,    -1,    -1,    -1,   457,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   363,
     364,   365,    -1,    -1,    -1,    -1,    -1,    -1,   896,   897,
     898,   375,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   496,    -1,
      -1,    -1,   500,   921,   502,   503,   504,   505,    -1,   403,
      -1,    -1,    -1,    -1,    -1,   513,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   530,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     538,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   559,    -1,    -1,    -1,    -1,    -1,    -1,   462,   463,
     464,    -1,    -1,    -1,    -1,    -1,   574,   575,   472,    -1,
     474,    -1,    -1,    -1,    -1,    -1,    -1,   481,    -1,    -1,
      -1,   485,   486,   487,    -1,    -1,    -1,    -1,    -1,    -1,
     494,    -1,    -1,   497,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   609,    -1,    -1,   612,    -1,    -1,    -1,    -1,    -1,
     514,    -1,    -1,    -1,    -1,   623,    -1,    -1,    -1,    -1,
      -1,   629,    -1,    -1,    -1,   633,    -1,   635,   636,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   649,    -1,    -1,   652,   653,    -1,    -1,    -1,    -1,
     658,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   674,    -1,   676,   677,
      -1,    -1,    -1,    -1,    -1,    -1,   580,   685,   686,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     708,   709,   710,    -1,   608,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     728,   729,   730,   731,    -1,   733,    -1,    -1,    -1,   737,
     738,    -1,    -1,    -1,    -1,    -1,    -1,   745,   746,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   754,   755,   756,    -1,
      -1,    -1,    -1,    -1,   762,    -1,   660,    -1,    -1,   767,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   785,    -1,    -1,
      -1,    -1,    -1,    -1,     9,    -1,    -1,    -1,    -1,    -1,
     798,   799,    17,    -1,    -1,    -1,   804,    -1,    -1,    -1,
      -1,    -1,   810,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   715,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   827,
     828,    -1,    -1,    -1,    49,    -1,    -1,    -1,   836,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   844,    -1,    -1,    -1,
      -1,    -1,   850,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    79,    80,    81,    82,    83,    84,
      85,    86,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    -1,   880,    -1,    -1,   100,    -1,    -1,   886,    -1,
      -1,    -1,    -1,    -1,   788,    -1,   111,   112,   113,   114,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   129,    -1,    -1,    -1,    -1,    -1,
     814,   815,    -1,    -1,   139,    -1,    -1,   142,   143,   144,
      -1,   146,   930,    -1,    -1,    -1,    -1,    -1,    -1,   937,
      -1,   939,    -1,    -1,   942,    -1,    -1,    -1,    -1,    -1,
      -1,   949,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   962,   180,    -1,    -1,   966,    -1,
      -1,    -1,   866,    -1,   189,   190,   191,   192,   193,   194,
     195,   196,    -1,    -1,    -1,    -1,    -1,   202,    -1,   204,
     884,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   911,   233,   234,
      -1,    -1,   237,   238,    -1,   919,    -1,   242,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   264,
      -1,    -1,    -1,   947,    -1,    -1,    -1,    -1,    -1,    -1,
     954,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   289,   969,    -1,    -1,   293,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   308,    -1,    -1,    -1,    -1,    -1,   314,
     315,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   333,   334,
     335,   336,   337,    -1,    -1,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      31,    -1,    -1,    -1,    -1,    -1,   381,   382,   383,   384,
      -1,    -1,    -1,    -1,    -1,   390,   391,    -1,   393,    -1,
     395,   396,   397,    -1,    -1,   400,    -1,   402,    -1,    -1,
      -1,   406,    -1,    -1,    -1,    -1,    67,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     425,   426,    -1,    -1,    -1,    -1,    87,    -1,    -1,    -1,
     435,   436,   437,   438,   439,   440,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   449,    -1,    -1,    -1,   453,   454,
      -1,    -1,   457,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   126,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   496,    -1,   154,    -1,   500,    -1,   502,   503,   504,
     505,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   513,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   530,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   538,    -1,    -1,    12,    -1,    -1,    -1,
      -1,    -1,    18,    -1,    -1,    -1,    22,    23,    24,    -1,
      -1,    -1,    -1,    -1,    30,   216,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   224,    -1,    -1,    -1,    -1,    -1,   574,
     575,    -1,    -1,    -1,    -1,    -1,    -1,    53,    54,    55,
      56,    57,    58,    59,    60,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   609,    -1,    -1,   612,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   623,    -1,
      -1,    -1,    -1,    -1,   629,    -1,    -1,    -1,   633,    -1,
     635,   636,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   649,    -1,    -1,   652,   653,    -1,
      -1,    -1,   128,   658,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   322,   323,    -1,    -1,    -1,    -1,    -1,    -1,   674,
      -1,   676,   677,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     685,   686,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     166,    -1,    -1,    -1,    -1,    -1,   172,   173,    -1,    -1,
      -1,   362,    -1,   708,   709,   710,    -1,    -1,    -1,    -1,
      -1,    -1,   188,    -1,    -1,    -1,    -1,    -1,   379,    -1,
      -1,    -1,    -1,   728,   729,   730,   731,    -1,   733,    -1,
      -1,    -1,   737,   738,    -1,    -1,    -1,    -1,    -1,    -1,
     745,   746,    -1,    -1,    -1,    -1,    -1,    -1,   409,   754,
     755,   756,    -1,    -1,    -1,    -1,    -1,   762,    -1,    -1,
      -1,    -1,   767,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   432,    -1,   434,    -1,    -1,    -1,    -1,    -1,    -1,
     785,    -1,    -1,   444,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   798,   799,   456,    -1,    -1,    -1,   804,
      -1,    -1,    -1,    -1,    -1,    -1,   467,   468,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   479,    -1,
      -1,    -1,   827,   828,   300,    -1,    -1,   488,    -1,    -1,
      -1,   836,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   844,
      -1,    12,    -1,   319,    -1,   850,    -1,    18,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   880,    -1,    -1,    -1,    -1,
      -1,   886,    -1,    -1,    -1,    -1,    -1,   363,   364,   365,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   375,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   387,   388,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   583,    -1,    -1,   930,    -1,   403,    -1,    -1,
      -1,    -1,   937,    -1,   939,    -1,    -1,   942,    -1,    -1,
      -1,    -1,    -1,    -1,   949,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   962,   434,   620,
      -1,   966,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     631,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     641,    -1,    -1,    -1,    -1,    -1,   462,   463,   464,   465,
     466,    -1,    -1,    -1,    -1,   166,   472,    -1,   474,    -1,
      -1,   172,   173,    -1,    -1,   481,    -1,    -1,    -1,   485,
     486,   487,    -1,    -1,    -1,    -1,    -1,   188,   494,    -1,
     681,   497,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   698,   514,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    12,    -1,    -1,    -1,    -1,   534,    18,
      -1,    -1,    -1,    22,    23,    24,    -1,    -1,    -1,    -1,
      -1,    30,    -1,    -1,    -1,   736,    -1,    -1,   739,    -1,
      -1,    -1,    -1,   559,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   753,   569,    53,    54,    55,    56,    57,    58,
      59,    60,   578,    -1,   580,    -1,    -1,    -1,    -1,    -1,
      -1,   587,    -1,   774,    -1,    -1,    -1,    -1,    -1,   595,
      -1,    12,    -1,    -1,    -1,    -1,    -1,    18,   789,    -1,
      -1,    -1,   608,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    43,    -1,   630,    -1,    -1,    -1,    -1,    -1,
      -1,   822,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   128,
      61,    62,    63,    64,    -1,    -1,    -1,    -1,    69,    -1,
      -1,    -1,    -1,    -1,   660,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   363,   364,   365,   856,    87,    88,    -1,    -1,
      -1,    -1,    -1,    -1,   375,    -1,    -1,   166,    -1,    -1,
      -1,    -1,    -1,   172,   173,    -1,    -1,    -1,   879,    -1,
      -1,    -1,    -1,    -1,    -1,   886,   887,    -1,    -1,   188,
      -1,    -1,   403,    -1,    -1,    -1,    -1,    -1,    -1,   715,
      -1,    -1,    -1,    -1,    -1,    -1,   137,   138,    -1,    -1,
     141,   912,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   927,    -1,   929,    -1,
     931,    -1,    -1,   934,    -1,   166,    -1,   938,    -1,    -1,
      -1,   172,   173,    -1,    -1,    -1,   177,    -1,    -1,    -1,
      -1,   462,   463,   464,    -1,    -1,    -1,   188,    -1,    -1,
      -1,   472,    -1,   474,    -1,    -1,    -1,    -1,    -1,   970,
     481,    -1,   788,    -1,   485,   486,   487,    -1,    -1,    -1,
      -1,    -1,    -1,   494,    -1,    -1,   497,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   814,   815,
      -1,   300,    -1,   514,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     319,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   853,    -1,   855,
      -1,   857,    -1,    -1,    -1,   861,    -1,   863,   864,   865,
     866,    -1,   868,   869,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   363,   364,   365,    -1,   884,   580,
     301,    -1,    -1,    -1,    -1,    -1,   375,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   387,   388,
      -1,    -1,    -1,    -1,    -1,   911,    -1,   608,    -1,    -1,
      -1,    -1,    -1,   919,   403,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   360,
      -1,   947,   363,   364,   365,    -1,    -1,    -1,   954,    -1,
      -1,    -1,    -1,    -1,   375,    -1,    -1,    -1,    -1,   660,
      -1,    -1,    -1,   969,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   462,   463,   464,   465,   466,    -1,    -1,
     401,    -1,   403,   472,    -1,   474,    -1,    -1,    -1,    -1,
      -1,    -1,   481,    -1,    -1,    -1,   485,   486,   487,    -1,
      -1,    -1,    -1,    -1,    -1,   494,    -1,    -1,   497,    -1,
      -1,    -1,    -1,    -1,   715,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   514,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   462,   463,   464,    -1,   534,    -1,    -1,    -1,    -1,
      -1,   472,   473,   474,    -1,    -1,    -1,    -1,    -1,    -1,
     481,    -1,    -1,    -1,   485,   486,   487,    -1,    -1,    -1,
     559,    -1,    -1,   494,   495,    -1,   497,    -1,    -1,    -1,
     569,    -1,    -1,    -1,    12,    -1,    -1,   788,    -1,   578,
      18,   580,    -1,   514,   515,    -1,    -1,    -1,   587,    -1,
      -1,    -1,    30,    -1,    -1,    -1,   595,    -1,    -1,    -1,
      -1,    -1,    -1,   814,   815,    -1,    -1,    -1,    -1,   608,
      -1,   542,    -1,    -1,    -1,    53,    54,    55,    56,    57,
      58,    59,    60,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   630,    -1,    -1,    -1,    -1,    -1,    -1,    12,    -1,
     851,    -1,    -1,    -1,    18,    -1,    -1,    -1,    -1,   580,
      -1,    -1,    -1,    -1,    -1,   866,    -1,    -1,    -1,    -1,
      -1,   660,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   603,   884,    -1,    -1,    -1,   608,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   627,   628,    -1,    -1,
     911,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   919,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   715,    12,    -1,    -1,
      -1,    -1,    -1,    18,    -1,    -1,    -1,    -1,   166,   660,
      -1,    -1,    -1,    -1,   172,   173,   947,    -1,    -1,    -1,
      -1,    -1,    -1,   954,    -1,    -1,    -1,    -1,    -1,    -1,
     188,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   969,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   714,   715,   716,   717,    -1,    -1,   788,
      -1,    -1,   166,    -1,    -1,    -1,    12,    -1,   172,   173,
      -1,    -1,    18,    -1,    -1,   736,    -1,    -1,    -1,    -1,
     741,    -1,    -1,    -1,   188,   814,   815,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   780,
      -1,    -1,    -1,    -1,   853,    -1,   855,   788,   857,    -1,
      -1,   792,   861,    -1,   863,   864,   865,   866,    -1,   868,
     869,   166,    -1,    -1,    -1,    -1,    -1,   172,   173,    -1,
      -1,   319,    -1,   814,   815,   884,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   188,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    12,   911,    -1,    -1,    -1,    -1,    18,    -1,    -1,
     919,    -1,    -1,    -1,    -1,   363,   364,   365,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   866,    -1,   375,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   947,    -1,
     166,    -1,    -1,   884,    -1,   954,   172,   173,    -1,    -1,
     891,    -1,    -1,    -1,    -1,   403,    -1,    -1,    -1,    -1,
     969,    -1,   188,    -1,   905,    -1,    -1,    -1,    -1,    -1,
     911,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   919,   363,
     364,   365,    -1,    -1,    -1,    -1,   434,    -1,    -1,    -1,
      -1,   375,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   947,    -1,    -1,    -1,
      -1,    -1,   953,   954,   462,   463,   464,    -1,    -1,   403,
      -1,    -1,    -1,    -1,   472,    -1,   474,    -1,   969,    -1,
      -1,    -1,    -1,   481,    -1,    -1,    -1,   485,   486,   487,
      -1,    -1,    -1,    -1,    -1,    -1,   494,    -1,    -1,   497,
      -1,    -1,    -1,    -1,    -1,   166,    -1,    -1,   363,   364,
     365,   172,   173,    -1,   369,    -1,   514,    -1,    -1,    -1,
     375,    -1,    -1,    -1,    -1,    -1,    -1,   188,   462,   463,
     464,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   472,    -1,
     474,    -1,    -1,    -1,    -1,    -1,    -1,   481,   403,    -1,
      -1,   485,   486,   487,    -1,    -1,    -1,    -1,    -1,    -1,
     494,   559,    -1,   497,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     514,    -1,   580,    -1,    -1,    -1,    -1,   363,   364,   365,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   595,    -1,   375,
      12,    -1,    -1,    -1,    -1,    -1,    18,   462,   463,   464,
     608,    -1,    -1,    -1,    -1,    -1,    -1,   472,    -1,   474,
      -1,    -1,    -1,    -1,    -1,    -1,   481,   403,    -1,    -1,
     485,   486,   487,    -1,    -1,    -1,    -1,    -1,    -1,   494,
      -1,    -1,   497,    -1,    -1,    -1,   580,    -1,    -1,    -1,
      -1,    -1,    -1,   587,    -1,    -1,    -1,    -1,    -1,   514,
      -1,    -1,   660,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   608,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   462,   463,   464,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   472,    -1,   474,    -1,
      -1,    -1,   363,   364,   365,   481,    -1,    -1,    -1,   485,
     486,   487,    -1,    -1,   375,    -1,    -1,   715,   494,    -1,
      -1,   497,    -1,    -1,    -1,   580,   660,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   514,    -1,
      -1,    -1,   403,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   608,   166,    -1,    -1,    54,    -1,    -1,
     172,   173,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   188,    -1,    -1,    -1,
      -1,   715,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     788,    -1,    -1,    -1,    12,    -1,    -1,    -1,    -1,    -1,
      18,   462,   463,   464,   580,   660,    -1,    -1,    -1,    -1,
      -1,   472,    -1,   474,    -1,    -1,   814,   815,    -1,    -1,
     481,    -1,    -1,    -1,   485,   486,   487,    -1,    -1,    -1,
      -1,    -1,   608,   494,    -1,    -1,   497,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   514,   788,   853,    -1,   855,    -1,    -1,
     715,    -1,    -1,    -1,    -1,    -1,   864,   865,   866,   166,
     868,   869,    -1,    12,    -1,   172,   173,    -1,    -1,    18,
     814,   815,    -1,    -1,   660,    -1,   884,    -1,    -1,    -1,
      -1,   188,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   911,    -1,    -1,    -1,    -1,    -1,   580,
      -1,   919,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   866,   788,    -1,    -1,    -1,    12,    -1,   715,
      -1,    -1,    -1,    18,    -1,    -1,    -1,   608,   166,   947,
     884,   363,   364,   365,   172,   173,   954,    -1,    -1,   814,
     815,    -1,    -1,   375,    -1,    -1,    -1,    -1,    -1,    -1,
     188,   969,    -1,    -1,    -1,    -1,    -1,   911,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   919,    -1,    -1,    -1,    -1,
      -1,   403,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   660,
      -1,    -1,    -1,    -1,   780,    -1,    -1,    -1,    -1,    -1,
      -1,   866,   788,   947,    -1,    -1,    -1,    -1,    -1,    -1,
     954,    -1,    -1,    -1,    -1,    -1,    -1,   166,    -1,   884,
      -1,    -1,    -1,   172,   173,   969,    -1,    -1,   814,   815,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   188,
     462,   463,   464,    -1,   715,    -1,   911,    -1,    -1,    -1,
     472,    -1,   474,    -1,   919,    -1,   363,   364,   365,   481,
      -1,    -1,    -1,   485,   486,   487,    -1,    -1,   375,    -1,
      -1,    -1,   494,    -1,    -1,   497,    -1,    -1,    -1,    -1,
     866,   166,   947,    -1,    -1,    -1,    -1,   172,   173,   954,
      -1,    -1,   514,    -1,    -1,    -1,   403,    -1,   884,    -1,
      -1,    -1,    -1,   188,   969,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   788,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   911,    -1,    18,    -1,    -1,
      -1,    -1,    -1,   919,   556,   363,   364,   365,    -1,    -1,
      -1,    -1,    -1,   814,   815,    -1,    -1,   375,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   462,   463,   464,   580,    -1,
      -1,   947,    -1,    -1,    -1,   472,    -1,   474,   954,    -1,
      -1,    -1,    -1,    -1,   481,   403,    -1,    -1,   485,   486,
     487,    -1,    -1,   969,    -1,    -1,   608,   494,    -1,    -1,
     497,    -1,    -1,    -1,    -1,   866,    -1,   868,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,
      -1,    -1,    -1,   884,   363,   364,   365,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   375,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   462,   463,   464,    -1,   660,    -1,
     911,    -1,    -1,    -1,   472,    -1,   474,    -1,   919,    -1,
      -1,    -1,    -1,   481,   403,    -1,    -1,   485,   486,   487,
      -1,    -1,    -1,    -1,    -1,    -1,   494,    -1,    -1,   497,
      18,    -1,    -1,   580,    -1,   166,   947,    -1,   363,   364,
     365,   172,   173,   954,    -1,    -1,   514,    -1,    -1,    -1,
     375,    -1,    -1,   715,    -1,    -1,    -1,   188,   969,    -1,
      -1,   608,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   462,   463,   464,    -1,    -1,   403,    -1,
      -1,    -1,    -1,   472,    -1,   474,    -1,    -1,    -1,    -1,
      -1,    -1,   481,    -1,    -1,    -1,   485,   486,   487,    -1,
      -1,    -1,    -1,    -1,    -1,   494,    -1,    -1,   497,    -1,
      98,    -1,   580,   660,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   514,   788,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   462,   463,   464,
     608,    -1,    -1,    -1,    -1,    -1,    -1,   472,    -1,   474,
      -1,    -1,   814,   815,    -1,    -1,   481,    -1,    -1,    -1,
     485,   486,   487,    -1,    -1,    -1,    -1,    -1,   715,   494,
      -1,    -1,   497,    -1,    -1,    -1,    -1,    -1,   166,    -1,
      -1,    -1,    -1,    -1,   172,   173,    -1,    -1,    -1,   514,
      -1,   580,   660,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     188,    -1,    -1,    -1,   866,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   608,
      -1,    -1,   884,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     361,    -1,   363,   364,   365,    -1,    -1,    -1,    -1,    -1,
      -1,   788,    -1,    -1,   375,    -1,    -1,   715,    -1,   911,
      -1,    -1,    -1,    -1,    -1,   580,    -1,   919,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   814,   815,    -1,
      -1,   660,   403,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   608,    -1,   947,    -1,    -1,    -1,    -1,
      -1,    -1,   954,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   853,   969,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   864,    -1,   866,
     788,   868,   869,    -1,    -1,    -1,   715,    -1,    -1,    -1,
      -1,   462,   463,   464,    -1,   660,    -1,   884,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   814,   815,    -1,    -1,
     481,    -1,    -1,    -1,   485,   486,   487,    -1,    -1,    -1,
      -1,    -1,    -1,   494,   911,    -1,   497,    -1,    -1,    -1,
      -1,    -1,   919,   361,    -1,   363,   364,   365,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   853,    -1,   375,    -1,    -1,
     715,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   866,   788,
     947,    -1,    -1,    -1,    -1,    -1,    -1,   954,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   403,   884,    -1,    -1,    -1,
      -1,    -1,   969,    -1,    -1,   814,   815,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   911,    -1,    -1,    -1,    -1,    -1,   580,
      -1,   919,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   788,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   462,   463,   464,   866,    -1,   947,
      -1,    -1,    -1,    -1,    -1,    -1,   954,    -1,    -1,   814,
     815,    -1,    -1,   481,    -1,   884,    -1,   485,   486,   487,
      -1,   969,    -1,    -1,    -1,    -1,   494,    -1,    -1,   497,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   911,    -1,     3,    -1,    31,    -1,    -1,   660,
     919,    -1,    -1,    -1,    13,    -1,    -1,    -1,    -1,    -1,
      -1,   866,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      29,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   947,   884,
      -1,    -1,    67,    -1,    -1,   954,    -1,    -1,    -1,    -1,
      -1,    50,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     969,    -1,    87,    -1,   715,    -1,   911,    -1,    -1,    -1,
      -1,    -1,   580,    -1,   919,    -1,    -1,    -1,    -1,    78,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    91,    92,    93,    -1,    -1,    96,    -1,    -1,
      -1,   126,   947,    -1,   103,    -1,    -1,    -1,    -1,   954,
      -1,    -1,    -1,    -1,    -1,    -1,   115,    -1,   117,   118,
      -1,    -1,    -1,    -1,   969,    -1,    -1,    -1,    -1,   154,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   788,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   145,    -1,    -1,    -1,
      -1,    -1,   660,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   814,   815,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   837,    -1,    -1,    -1,
      -1,   216,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   224,
      -1,   200,    -1,    -1,    -1,    -1,    -1,   715,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   866,    -1,    -1,   217,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   884,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   240,   241,    -1,   243,   244,    -1,    -1,    -1,    -1,
     901,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     911,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   919,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     788,    -1,    -1,   934,    -1,    -1,    -1,    -1,    -1,   288,
      -1,    -1,    -1,    -1,    -1,    -1,   947,   322,   323,    -1,
      -1,    -1,   953,   954,    -1,   304,   814,   815,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   969,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   837,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   344,   345,   346,    -1,    -1,
      -1,    -1,    -1,    -1,   379,    -1,    -1,    -1,   866,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   367,    -1,
      -1,    -1,    -1,   372,    -1,    -1,   884,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   409,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   901,    -1,    54,    -1,    -1,    -1,   398,
     399,    -1,    -1,   911,    -1,   404,   405,   432,    -1,   434,
      -1,   919,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   444,
      -1,    -1,    -1,    -1,    -1,    -1,   934,    -1,    -1,    -1,
      -1,   456,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   947,
      -1,    -1,   467,   468,    -1,   953,   954,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   479,    -1,    -1,    -1,    -1,    -1,
     459,   969,   461,   488,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   478,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   491,   492,   493,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   166,    -1,    -1,
      -1,    -1,    -1,   172,   173,    -1,    -1,    -1,    -1,    -1,
     519,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   188,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   543,   544,   545,    54,   547,    -1,
     549,   550,    -1,   552,   553,   554,    -1,    -1,   583,    -1,
      -1,   560,    -1,   562,   563,   564,   565,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   578,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   586,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   620,    -1,    -1,    -1,    -1,
      -1,    -1,   601,   602,    -1,    -1,   631,    -1,    -1,    -1,
      -1,   610,    -1,    -1,    -1,    -1,   641,   616,    -1,    -1,
      -1,    -1,    54,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   681,    -1,    -1,   166,
      -1,    -1,    -1,    -1,   663,   172,   173,    -1,    -1,    -1,
     669,    -1,    -1,   698,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   188,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   363,   364,   365,    -1,    -1,    -1,
      -1,   736,    -1,    -1,   739,    -1,   375,    -1,    -1,    -1,
      -1,    -1,    -1,   722,   723,   724,    -1,    -1,   753,    -1,
      -1,    -1,    -1,   732,   166,    -1,    -1,    -1,    -1,    -1,
     172,   173,    -1,    -1,   403,    -1,    -1,    -1,    -1,   774,
      -1,    -1,    -1,    -1,    -1,    -1,   188,    -1,   757,    -1,
      -1,    -1,    -1,    -1,   789,    -1,    -1,    -1,    -1,    -1,
      -1,   770,   771,   772,   773,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   790,   791,    -1,    -1,    -1,    -1,   822,    -1,    -1,
      -1,    -1,   801,   462,   463,   464,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   472,    -1,   474,    -1,    -1,    -1,    -1,
      -1,    -1,   481,    -1,    -1,    -1,   485,   486,   487,    -1,
      -1,   856,   831,    -1,    -1,   494,    -1,    -1,   497,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   845,   846,    -1,    -1,
      -1,    -1,    -1,    -1,   879,    -1,   363,   364,   365,    -1,
      -1,   886,   887,    -1,    -1,    -1,    -1,    -1,   375,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   882,    -1,    -1,    -1,   912,    -1,    -1,
      -1,    -1,    -1,   892,    -1,    -1,   403,    -1,    -1,    -1,
     899,    -1,   927,    -1,   929,    54,   931,    -1,    -1,   934,
      -1,   910,    -1,   938,    -1,   914,   915,   916,    -1,    -1,
      -1,   580,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   363,   364,   365,    -1,    -1,   935,   936,    -1,    -1,
      -1,   940,   941,   375,   943,   970,    -1,    -1,    -1,   608,
      -1,   950,    -1,    -1,    -1,   462,   463,   464,    -1,    -1,
      -1,    -1,    -1,    43,    -1,   472,    -1,   474,    -1,    -1,
      -1,   403,    -1,    -1,   481,    -1,    -1,    -1,   485,   486,
     487,    61,    62,    63,    64,    -1,    -1,   494,    -1,    69,
     497,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   660,    -1,    -1,    -1,    -1,    -1,    87,    88,    -1,
      -1,    91,    -1,    93,    -1,    -1,    -1,   166,    -1,    -1,
      -1,    -1,    -1,   172,   173,    -1,    -1,    -1,    -1,    -1,
     462,   463,   464,    -1,    -1,    -1,   116,    -1,    -1,   188,
     472,    -1,   474,    -1,    -1,    -1,    -1,    -1,    -1,   481,
      -1,    -1,    -1,   485,   486,   487,   715,   137,   138,    -1,
      -1,   141,   494,    -1,    -1,   497,    -1,    43,    -1,    -1,
      -1,    -1,    48,   580,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    61,    62,    63,    64,    -1,
      -1,    -1,    68,    69,    -1,    -1,    -1,   177,    -1,    -1,
      -1,   608,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   788,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   580,    -1,
      -1,    -1,    -1,   660,    -1,   814,   815,    -1,    -1,    -1,
      -1,   137,   138,    -1,    -1,   141,   825,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   608,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   175,
      -1,   177,    -1,    -1,    -1,   864,    -1,   866,   715,   868,
     869,    -1,    -1,   189,   363,   364,   365,    -1,    -1,    -1,
      -1,   301,    -1,    -1,    -1,   884,   375,    -1,   660,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     216,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   911,    -1,   403,    -1,    -1,    -1,    -1,    -1,
     919,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     360,   788,    -1,   715,    -1,    -1,    -1,    -1,   947,    -1,
      -1,    -1,    -1,    -1,    -1,   954,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   814,   815,    -1,
     969,    -1,   392,   462,   463,   464,    -1,    -1,   825,    -1,
      -1,   401,    -1,   472,    -1,   474,    -1,    -1,    -1,    -1,
      -1,    -1,   481,    -1,    -1,    -1,   485,   486,   487,    -1,
      -1,    -1,    -1,    -1,    -1,   494,    -1,    -1,   497,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   788,   864,    -1,   866,
      -1,   868,   869,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   884,    -1,   459,
      -1,    -1,   814,   815,   360,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   473,   370,   371,    -1,   477,    -1,    -1,
      -1,    -1,    -1,    -1,   911,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   919,    -1,    -1,   495,    -1,    -1,    -1,    -1,
      -1,   853,    -1,    -1,    -1,   401,    -1,    -1,    -1,    -1,
      -1,   580,   864,    -1,   866,    -1,   868,   869,    -1,    -1,
     947,    -1,    -1,    -1,    -1,    -1,    -1,   954,    -1,    -1,
      -1,    -1,   884,    -1,    -1,    -1,    -1,    -1,    -1,   608,
      -1,   541,   969,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     446,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   911,
      -1,    -1,    -1,    -1,   460,    -1,    -1,   919,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   473,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   660,    -1,    -1,    -1,   947,   492,    -1,    -1,   495,
      -1,    -1,   954,   603,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   969,    -1,   515,
      -1,    -1,    -1,    -1,    -1,    -1,   626,   627,   628,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    48,   541,   715,    -1,    -1,    -1,
      -1,    -1,   548,    -1,    -1,    -1,    -1,    61,    62,    63,
      64,    -1,    -1,    -1,    -1,    69,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    87,    88,    -1,    -1,    -1,    -1,   585,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   108,    -1,    -1,   603,    -1,    -1,
      -1,    -1,    -1,    -1,   714,    -1,   716,   717,    -1,   788,
      -1,    -1,   722,    -1,    -1,    -1,   130,    -1,    -1,    -1,
      -1,   627,   628,   137,   138,    -1,   736,   141,    -1,    -1,
      -1,   741,    -1,    -1,    -1,   814,   815,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   651,    -1,    -1,   654,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   768,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     780,    -1,   186,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   792,    -1,    -1,   864,    -1,   866,    -1,   868,
     869,    -1,    -1,    -1,    -1,    -1,   702,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   884,    -1,    -1,   714,    -1,
     716,   717,    -1,    -1,    -1,    -1,    -1,   231,   232,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     736,    -1,   911,    48,    -1,   741,    -1,    -1,    -1,   849,
     919,    -1,    -1,   749,    -1,    -1,    61,    62,    63,    64,
      -1,    -1,    -1,    -1,    69,    -1,    -1,    -1,    -1,    -1,
      -1,   871,    -1,    -1,    -1,    -1,    -1,    -1,   947,    -1,
      -1,    -1,    -1,    88,   780,   954,    -1,    -1,    -1,    -1,
      -1,   891,    -1,    -1,    -1,    -1,   792,   301,    -1,    48,
     969,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    61,    62,    63,    64,    -1,    -1,    -1,    -1,
      69,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     826,    -1,    -1,   138,    -1,    -1,    -1,    -1,    87,    88,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     846,   847,    -1,   953,    -1,    -1,   360,    -1,    -1,   108,
      -1,    -1,    -1,    -1,    -1,   369,    -1,   371,    -1,    -1,
     175,    -1,   177,    -1,    -1,   379,    -1,    -1,    -1,    -1,
      -1,   130,    -1,    -1,   189,   389,    -1,    -1,   137,   138,
      -1,    -1,   141,    -1,    -1,   891,    -1,   401,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   903,    -1,    -1,
      -1,   216,    -1,    -1,   910,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     434,    -1,    -1,    -1,    -1,    -1,    -1,   186,    -1,    -1,
     444,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   456,    -1,    -1,    -1,   460,   953,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   473,
      -1,    -1,    -1,   477,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   231,   232,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   495,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   526,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   541,    -1,    -1,
      -1,    -1,   166,    -1,   548,    -1,    -1,    -1,   172,   173,
      -1,    -1,   301,    -1,    -1,   360,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   188,    -1,   371,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   583,
      -1,   585,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   401,    -1,    -1,   603,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   360,    -1,    -1,    -1,    -1,   620,    -1,    -1,    -1,
     369,    -1,   371,   627,   628,    -1,    -1,    -1,    -1,    -1,
     379,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     389,    -1,    -1,    -1,    -1,    -1,    -1,   651,    -1,    -1,
      -1,    -1,   401,    -1,    -1,   460,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   434,    -1,   492,    -1,    -1,
     495,    -1,    -1,    -1,    -1,   444,    -1,    -1,   702,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   456,    -1,    -1,
     714,   460,   716,   717,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   473,    -1,    -1,    -1,   477,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   541,    -1,    -1,   363,
     364,   365,   166,   548,    -1,   749,   495,    -1,   172,   173,
      -1,   375,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   188,    -1,    -1,    -1,    -1,    -1,
     774,    -1,    -1,    -1,    -1,    -1,   780,   526,    -1,   403,
     585,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   792,    -1,
      -1,    -1,   541,    -1,    -1,    -1,    -1,    -1,   603,   548,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   166,
      -1,    -1,   826,    -1,    -1,   172,   173,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   583,    -1,   585,    -1,   462,   463,
     464,   188,    -1,    -1,    -1,    -1,   651,   851,   472,   654,
     474,    -1,   856,    -1,   603,    -1,    -1,   481,   862,    -1,
      -1,   485,   486,   487,    -1,    -1,    -1,    -1,    -1,    -1,
     494,   620,    -1,   497,    -1,   879,    -1,    -1,   627,   628,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   891,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   702,    -1,    -1,
      -1,    -1,   651,    -1,    -1,    -1,    -1,    -1,   912,   714,
      -1,   716,   717,    -1,    -1,    -1,   920,   921,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   929,    -1,    -1,    -1,    -1,
      -1,   736,    -1,    -1,    -1,    -1,   741,    -1,    -1,   363,
     364,   365,    -1,    -1,   749,    -1,    -1,    -1,    -1,    -1,
      -1,   375,    -1,   702,    -1,    -1,   580,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   714,    -1,   716,   717,    -1,
      -1,    -1,    -1,    -1,    -1,   780,    -1,    -1,    -1,   403,
      -1,    -1,    -1,    -1,   608,    -1,    -1,   792,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     749,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   363,   364,   365,    -1,
      -1,   826,    -1,    -1,    -1,   774,    -1,    -1,   375,    -1,
      -1,   780,    -1,    -1,    -1,    -1,   660,    -1,   462,   463,
     464,    -1,   847,   792,    -1,    -1,    -1,    -1,   472,    -1,
     474,    -1,    -1,    -1,    -1,    -1,   403,   481,    -1,    -1,
      -1,   485,   486,   487,    -1,    -1,    -1,    -1,    -1,    -1,
     494,    -1,    -1,   497,    -1,    -1,    -1,   826,    -1,    -1,
      -1,    -1,   706,    -1,    -1,    -1,   891,    -1,    -1,    -1,
      -1,   715,    -1,    -1,    -1,    -1,    -1,    -1,   903,    -1,
      -1,    -1,   851,    -1,    -1,   910,    -1,   856,    -1,    -1,
      -1,    -1,    -1,   862,    -1,   462,   463,   464,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   472,    -1,   474,    -1,    -1,
     879,    -1,    -1,    -1,   481,    -1,    -1,    -1,   485,   486,
     487,    -1,   891,    -1,    -1,    -1,    -1,   494,    -1,    -1,
     497,    -1,    -1,    -1,    -1,    -1,   580,    -1,    -1,    -1,
      -1,    -1,    -1,   912,   788,    -1,    -1,    -1,    -1,    -1,
      -1,   920,   921,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     929,    -1,    -1,    -1,   608,    -1,    -1,    -1,    -1,    -1,
     814,   815,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   580,    -1,    -1,   660,    -1,    -1,    -1,
      -1,    -1,   866,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     884,   608,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   905,    -1,    -1,    -1,    -1,    -1,   911,    -1,    -1,
      -1,   715,    -1,    -1,    -1,   919,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   660,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   947,    -1,    -1,    -1,    -1,    -1,    -1,
     954,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   969,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   788,    -1,    -1,    -1,   715,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     814,   815,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   788,   866,    -1,   868,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     884,    -1,    -1,    -1,    -1,    -1,    -1,   814,   815,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   911,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   919,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   866,
      -1,    -1,    -1,   947,    -1,    -1,    -1,    -1,    -1,    -1,
     954,    -1,    -1,    -1,    -1,    -1,    -1,   884,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   969,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   911,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   919,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     947,    -1,    -1,    -1,    -1,    -1,    -1,   954,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   969
};

  /* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
     symbol of state STATE-NUM.  */
static const yytype_int16 yystos[] =
{
       0,   974,   975,     0,   976,   977,   978,   981,   982,   175,
     999,  1000,   594,  1009,  1027,   239,   408,   410,   979,   980,
     983,   984,   991,   994,  1012,  1013,  1015,   856,   294,  1036,
    1037,  1038,  1039,   856,  2324,   980,   374,   646,  1016,  1017,
    1018,  1019,  1014,    38,  1028,  1029,  1010,   168,  1040,  1041,
    1042,  1043,   239,  1001,   856,  1009,   856,  1009,   239,   434,
    2366,   216,  1031,   201,  1217,  1219,  1220,  1221,   423,  1128,
    1129,  1130,    21,   126,   184,   187,   189,   214,   309,   484,
     578,   582,   701,   740,   787,   789,   821,   833,   871,   954,
     965,  1044,  1045,  1046,  1048,  1052,  1067,  1073,  1074,  1075,
    1076,  1077,  1079,  1084,  1102,  1103,  1108,  1111,  1114,  1115,
    1118,  1120,  1121,  1122,  1123,  1124,  1125,  1126,   748,  2324,
     216,  1002,   481,   647,  1020,   275,   985,   986,   987,  1020,
     269,   989,  2324,   529,   792,   795,   796,  1030,   726,   291,
    1032,  1011,   860,  1222,  1223,   239,   748,   329,  1131,     1,
     954,  2227,  2227,   802,   774,  2394,  2366,  2366,  2366,  2227,
     774,  2324,  2324,  2366,  2324,  2324,   124,   169,  2348,  1127,
    2227,  1046,     1,   856,  1076,  1078,   414,  1101,  2324,  1003,
      39,  1022,   988,   987,  1022,   990,   515,  2378,  2366,   429,
    1034,   641,  1559,  1560,  1565,   748,  1224,  2324,  2324,  2324,
    1132,  1085,   359,  1100,  2357,  2366,  2366,   954,  2220,  2277,
     149,  2220,  2366,  2366,  1053,  1068,  2220,  1049,   954,  1109,
    1110,  1288,  1100,  2366,  1116,   481,   585,   588,  1080,  1082,
    1083,  1987,  2283,  2366,    41,   248,   793,   794,   954,  1161,
     748,   481,  1023,  2366,   481,   647,  1021,   856,  2366,  1021,
    2366,   133,   805,   858,  1033,   727,  2324,  1561,  1595,  1596,
    2324,   326,   743,  1218,  1225,  1226,  1228,   442,   753,  1133,
    1194,  1195,  1086,  1089,  1090,  2357,  2366,    25,   526,  2220,
     481,   414,   584,  2422,   481,   879,   123,   506,   645,   752,
     954,  1054,  1055,  1056,  1057,  1058,  1062,  1063,  1065,  2347,
    2389,   373,   645,  1069,  1070,  1071,  1050,  1065,  1110,  2366,
     954,  1104,  1105,  1106,  2229,  2227,    18,   403,   481,   497,
     660,   788,   866,   954,   969,  1117,  2288,  2289,  2290,  2291,
    1987,   434,   802,  2385,  2366,   184,  2227,   856,   856,   153,
     322,   655,   680,   862,  1024,  1025,  1026,  2324,   655,  2324,
      52,   531,   532,   533,   650,   872,   873,   885,  2317,  2366,
     239,     0,     1,     5,    11,    19,    28,   101,   102,   132,
     152,   156,   174,   219,   225,   227,   231,   236,   253,   290,
     306,   311,   317,   318,   368,   377,   380,   385,   411,   419,
     421,   424,   427,   443,   509,   516,   518,   521,   537,   592,
     615,   656,   662,   667,   670,   671,   689,   707,   712,   719,
     725,   744,   759,   765,   783,   797,   807,   808,   816,   819,
     834,   856,   881,   894,   900,   925,   958,   963,   971,  1597,
    1599,  1628,  1633,  1638,  1643,  1669,  1674,  1682,  1686,  1687,
    1691,  1694,  1699,  1704,  1756,  1760,  1762,  1763,  1768,  1784,
    1793,  1797,  1800,  1803,  1807,  1809,  1816,  1826,  1829,  1832,
    1838,  1859,  1860,  1869,  1873,  1875,  1879,  1882,  1886,  1900,
    1914,  1916,  1920,  1935,  1936,  1946,  1949,  1950,  1954,  1960,
    1961,  1962,  1974,  1984,  2001,  2011,  2019,  2020,  2026,  2037,
    2041,  2044,  2047,  2050,  2053,  2064,  2084,  2092,  2093,  2121,
    2335,  1597,   956,  1277,  1278,  1280,  1281,     1,   954,  2208,
    2324,  1134,    32,   520,   704,   736,  1196,  1197,  1198,  1199,
    1201,  1202,  1203,  1208,  1087,  1088,    25,   526,   481,  1112,
    1113,  2287,  2288,   953,  1119,  2409,  2277,   761,   780,  2397,
    2366,   856,  1056,   856,   954,  1055,   127,   136,  1059,  2349,
      18,   375,   954,  1072,   954,     1,   856,  1071,  1051,  2409,
    2289,  1105,    33,   434,  2229,  2368,  2291,   852,  2385,   434,
    2227,  2227,  1081,  1082,     5,  1004,  1005,  1026,  2324,  2389,
     153,  2324,   531,   532,   650,   885,  1035,  1562,     5,    11,
      19,    28,   101,   102,   132,   152,   156,   174,   219,   231,
     236,   255,   260,   261,   262,   263,   265,   266,   267,   268,
     270,   272,   273,   274,   276,   277,   278,   279,   280,   282,
     283,   284,   285,   286,   287,   290,   306,   317,   318,   368,
     377,   380,   385,   411,   419,   421,   424,   427,   509,   516,
     518,   521,   537,   592,   615,   667,   689,   712,   719,   725,
     744,   765,   783,   797,   807,   808,   816,   819,   834,   856,
     881,   894,   900,   958,   963,  2321,  2322,  2323,  1600,  1629,
    1634,  1639,  1644,  1670,  1675,  1683,  1688,  1695,  1692,  1700,
    1705,  1757,  1761,  1769,  1839,  1785,  1794,  1798,  1801,  1804,
    1808,  1810,  1817,  1827,  1830,  1833,  1874,  1876,  1880,  1883,
    1598,  1887,  1901,  1915,  1917,  1921,  1937,  1947,  1951,  1955,
    1975,  1985,  2002,  2012,  2027,  2038,  2042,  2045,  2048,  2051,
    2054,  2065,  2085,   359,  1764,   377,   613,    18,  1963,   302,
     481,   660,   734,   788,   841,   969,  2024,  2025,  2170,  2268,
    2269,  2277,   377,   613,  1582,   748,   154,  1256,  1257,   252,
     766,   779,  1282,  1283,  1285,  1296,  1298,  1301,  2306,   467,
     641,   856,   860,   970,  2326,  2327,  2333,  1227,   559,   593,
    2314,   152,   181,   198,   199,   321,   490,   501,   634,   675,
     694,   959,   960,  1204,   588,  1209,  2383,   673,   783,   784,
    1200,     1,   201,   442,   641,   753,   856,  1198,  2325,  2332,
    2366,  2366,  1101,  1113,   843,   621,  2366,  2283,   856,  2366,
     763,   431,  1022,     1,   375,   431,  1022,   856,   856,   213,
     481,  1107,  2284,  2291,  2227,  1006,   231,  1007,   992,   995,
      99,   514,   606,   800,   805,   858,   951,  1650,  1651,   587,
     954,  1601,  1604,  1605,  1606,  2209,  2268,    12,   166,   172,
     173,   182,   188,   363,   364,   365,   375,   462,   463,   464,
     472,   474,   485,   486,   487,   494,   514,   580,   608,   715,
     814,   815,   829,   884,   911,   919,   947,  1630,  2200,  2233,
    2234,  2236,  2237,  2268,  2289,  2293,  2294,  2295,  2296,  2430,
      54,   864,   868,   869,  1635,  2195,  2196,  2197,  2198,  2199,
    2200,  2237,  2240,  2268,  2275,  2277,  2290,  2293,   481,  1640,
    1641,  2216,  2217,  2218,  2277,  1645,  1650,    18,   481,   647,
    1671,  1672,  1673,  2252,  2268,   952,  1676,  1677,  1679,  2208,
      12,  1684,  2200,  2201,  2202,  2231,  2273,  2274,  2277,  2290,
      15,  1689,   860,  1696,  2208,    18,  1693,  2268,  2270,   422,
     441,   600,   833,  1701,  1703,   301,   356,   415,   481,   510,
     587,   792,   817,   862,   952,  1706,  1707,  1708,  1709,  1711,
    1719,  1721,  1722,  1723,  1726,  1731,  1734,  1735,  1738,  1740,
    2233,  2252,  2268,  2409,  1758,  2234,  1701,   859,   870,  1770,
    1771,  1772,  2174,  2175,  2176,  1836,  2268,  2289,  2293,   122,
    1786,  1788,   373,   611,   615,   645,   748,  1795,  1799,  2230,
    2231,  1802,  2277,   851,  1805,  2405,   378,   664,   713,  1661,
    1796,     1,  2173,  2174,  1818,  2230,   954,  1828,  2210,   175,
     952,  1499,  1743,  1831,  2268,    65,  1834,  1835,  2003,  2261,
    2262,  2277,  1499,  1743,  1877,   182,  1881,  2234,  1884,  2234,
     760,   316,  1888,  1889,  1890,   414,  1902,  2168,  2359,   954,
    2209,   312,  1918,  2268,  1922,  2208,  1938,  2209,  1948,  2203,
    2277,  1952,  2208,   860,  1956,  2203,  2204,   851,  1976,  1977,
    1981,  2209,   294,   452,   514,  1986,  1989,  1990,  1993,  1994,
    1995,  1996,  1997,  1998,  1999,  2000,  2170,  2211,  2212,  2230,
    2260,  2262,  2277,  2003,  2013,  2208,  2028,  2029,  2030,   182,
     829,  2039,  2233,   639,  2043,  2046,  2210,  2049,  2263,  2268,
    2052,  2208,   481,  2055,  2253,  2268,  2293,  2066,  2268,  2086,
    2204,   380,  1650,  1766,  1861,  1870,  1964,  1965,  2205,  2277,
    2021,  2268,   868,  2281,  2282,  2094,  2122,   856,   954,   971,
    1583,  1585,  1586,  1589,  1590,  1595,   154,   467,   479,   488,
     641,   698,   739,   856,  2326,  2331,  2334,   748,   488,  1414,
    1415,  1288,  1300,  1288,  1288,  1283,  2331,     1,   338,  1286,
    1287,  1288,   467,   970,  1229,   593,  2227,  2383,  2405,  2405,
     584,  2382,  2383,  2383,  2405,  2383,  2383,  2405,  2383,  2383,
     860,  2356,   310,  2355,   481,  1147,  2277,    34,  2339,  2325,
      41,   248,   403,   481,   484,   497,   529,   660,   788,   793,
     794,   969,  1091,  1093,  1094,  1095,  1098,   889,   921,   922,
    1092,  1093,  2287,   481,  2283,   484,   823,   918,  1064,  2223,
    2278,  2279,  1060,   515,  2284,  2366,  1008,   856,  1039,  1211,
    1211,   953,  1647,   260,  1627,  1602,    43,    68,   370,   515,
    1611,  1612,  1613,  1617,  1620,  2342,  2343,  2409,   868,  1608,
     510,  2377,   369,  2382,  2268,   868,   868,   868,  2298,   868,
    2422,  2422,   868,   868,   868,   868,  2422,  2261,   868,  2298,
     261,  1632,   851,  1631,  2234,  2269,  2290,  2293,   868,  2297,
     868,   868,  2199,  2199,  2195,  2199,   124,   864,   869,    53,
      55,    56,    57,    58,    59,    60,   855,   865,   319,  2269,
    2290,  2293,   420,  2309,  1641,   851,  2422,   262,  1668,  2168,
    1673,  1680,  2208,   682,   893,  1678,  2409,  2428,  2382,   263,
    1685,   300,   857,  2202,  2419,   726,  2315,  2281,  2282,  1690,
    1697,  2208,   265,  1698,   673,  2391,   176,  2351,  2268,   833,
    2402,   833,  2209,  1720,   386,  1741,    92,  2345,   266,  1755,
     312,   570,   591,  2136,  2138,  2140,  2414,  1709,  2232,  2233,
    1710,   953,  1712,  1608,  1732,  1741,   906,   907,   908,   909,
     177,   267,  1759,    97,   430,   268,  1783,    27,   946,  1773,
    1774,  1775,  1777,    30,    53,    54,    55,    56,    57,    58,
      59,    60,   319,   434,   559,   595,   853,   855,   864,   865,
     868,   869,  2177,  2178,  2186,  2234,  2366,   697,   830,  1840,
     523,  1789,   197,  1796,  2231,   290,  2215,   452,  1918,  2234,
     840,  1812,  1819,  2409,  2210,  2268,     9,    17,    49,    79,
      80,    81,    82,    83,    84,    85,    86,    95,   100,   111,
     112,   113,   114,   129,   139,   142,   143,   144,   146,   180,
     189,   190,   191,   192,   193,   194,   195,   196,   202,   204,
     233,   234,   237,   238,   242,   264,   289,   293,   308,   314,
     315,   333,   334,   335,   336,   337,   340,   381,   382,   383,
     384,   390,   391,   393,   395,   396,   397,   400,   402,   406,
     425,   426,   435,   436,   437,   438,   439,   440,   449,   453,
     454,   457,   496,   500,   502,   503,   504,   505,   513,   530,
     538,   574,   575,   609,   612,   623,   629,   633,   635,   636,
     649,   652,   653,   658,   674,   676,   677,   685,   686,   708,
     709,   710,   728,   729,   730,   731,   733,   737,   738,   745,
     746,   754,   755,   756,   762,   767,   785,   798,   799,   804,
     827,   828,   836,   844,   850,   880,   886,   930,   937,   939,
     942,   949,   962,   966,  1504,  1506,  1508,  1510,  1512,  1514,
    1516,  1518,  1521,  1523,  1525,  1526,  1528,  1530,  1531,  1533,
    1535,  1538,  1539,   455,   780,   849,  1540,  1541,  1836,  2005,
     868,  2281,   559,   810,  1501,  1502,  1503,  1504,  2313,  1540,
     272,  1878,  2234,   851,   273,  1885,    97,  1889,   320,   422,
     441,   600,  1891,    98,   361,   481,  1290,  1907,  1908,  1909,
    2216,  2237,  2254,  2268,  2277,  2289,  2293,  2409,   841,   954,
    1919,   276,  1934,   537,   632,  2312,   277,  1945,   510,   751,
    1939,   369,  2087,   278,  1953,  2391,   954,   279,  1959,  2087,
    2234,   281,   369,  1979,  1980,  2247,  2250,  2268,  2290,  2293,
     312,  1996,  1998,  2230,   640,   851,  2212,   245,   851,   902,
    1988,    45,  2281,   282,  2018,   341,   446,   452,  2015,   283,
    2036,   430,  2031,  2032,  2234,  2268,  2261,   284,  2040,   369,
    2210,  2348,   673,   679,  2392,   285,  2063,   220,  2056,  2268,
     286,  2091,  2087,   851,   481,  1862,  2268,  1871,  2268,  1966,
    2205,   280,  1972,   934,  1967,  1661,  2022,  2234,  2409,  2193,
    2195,   868,  2282,  2095,  2268,  2123,  2268,     1,   748,   856,
    1584,  1279,  2324,   748,   479,  1417,  1418,  1299,  1302,   693,
    2331,   856,  1284,   169,    89,   135,   201,   448,   471,   673,
     678,   698,   700,   929,  1230,  1231,  1233,  1237,  1238,  1241,
    1242,  1248,  1251,  1253,  1254,  2327,  2366,  1135,  2219,  2220,
    2220,  2283,  2283,  2206,  2208,  2206,  2283,  2206,  2206,  2220,
    2206,  2206,   832,  2401,   259,  1210,  2283,  2357,  2223,  1095,
      27,   843,   124,   517,   955,  2426,   954,  2280,  1061,  2357,
    2366,  1079,  2366,  1043,   993,   996,  1648,   121,   920,  1566,
    1611,   969,  2255,  2260,  2283,  2366,  1613,   137,   141,   473,
     627,   628,  1618,  1619,  2418,   846,    48,    61,    62,    63,
      64,    69,    88,   138,   175,   177,   189,   216,   360,   371,
     401,   460,   492,   495,   541,   548,   585,   603,   651,   654,
     702,   714,   716,   717,   736,   741,   749,   792,   826,   847,
     891,   903,   910,  1621,  1624,  1625,  1626,  2352,  2390,   151,
     481,  1609,  1610,  2242,  2268,  2268,   183,    36,    37,   140,
     147,   150,   205,   210,   211,   294,   296,   303,   312,   422,
     473,   477,   511,   739,   824,   835,   846,   917,   954,  1616,
    2212,  2416,   290,   645,  2245,  2269,   851,  2193,  2195,  2304,
    2193,  2305,   853,  2193,  2297,  2300,  2301,   954,   954,  2195,
    2303,  2303,  2303,  2239,  2268,  2290,  2293,  2302,   954,   851,
    2239,  2299,  2297,    12,  2200,  2201,  2234,  2277,  2290,   378,
    2195,  2239,  2193,   853,   420,  2310,  2196,  2196,  2197,  2197,
    2197,  2197,  2197,  2197,  2197,  2197,  2197,  2197,   483,  1636,
     643,  1642,  2218,  1652,  1653,  2253,  2268,  1678,   489,   541,
    2357,  2269,  2195,   515,  2316,  2282,  2195,  2136,  2208,   711,
    1927,  1928,  1929,  1702,  2409,  1712,   952,  2233,  1592,  1593,
    2139,  2140,  2137,  2138,  1592,   905,  1617,  1620,  1714,  1715,
    1717,  2409,    61,    62,    63,    64,    69,    87,    88,   138,
     177,   301,   360,   401,   495,   603,   736,   741,   780,   792,
     891,  1625,  1713,  1754,   301,  1724,  1725,  2268,  2290,   905,
    1742,   952,  2136,  2136,  2136,  2136,  1707,  2234,  2201,  2234,
    1772,  1778,   946,  1775,  1776,   268,   856,   946,  1592,  2185,
    2186,  2178,    22,    23,    24,   128,   300,   387,   388,   465,
     466,   534,   569,   578,   587,   630,   857,   861,   863,  2187,
    2188,  2189,  2190,  2191,  2192,    18,   341,   456,   901,  1843,
    1841,  1787,   481,  2213,  2214,   222,  1806,  2216,   312,  2411,
     255,  1811,  1813,    18,    22,    25,    26,   526,   527,   578,
     579,  1820,  1824,   338,   414,   857,  2360,  1537,  2283,  2360,
    1539,  2360,  2360,  2360,  1541,   178,   697,   830,  1837,  1846,
    1848,  1849,  2007,  2383,  2409,   434,   857,  2367,  1502,    33,
     434,   857,  2369,     3,    13,    29,    50,    78,    91,    92,
      93,    96,   103,   115,   117,   118,   145,   200,   217,   240,
     241,   243,   244,   288,   304,   344,   345,   346,   367,   372,
     398,   399,   404,   405,   459,   461,   478,   491,   492,   493,
     519,   543,   544,   545,   547,   549,   550,   552,   553,   554,
     560,   562,   563,   564,   565,   578,   586,   601,   602,   610,
     616,   663,   669,   722,   723,   724,   732,   757,   770,   771,
     772,   773,   790,   791,   801,   831,   845,   846,   882,   892,
     899,   910,   914,   915,   916,   935,   936,   940,   941,   943,
     950,  1505,  1507,  1509,  1511,  1513,  1515,  1517,  1519,  1520,
    1522,  1524,  1527,  1529,  1532,  1534,   851,  2230,  2201,  2234,
     769,  1892,  2382,   392,  2169,  2169,   901,   934,   843,     1,
      71,    72,    73,    74,    76,   158,   159,   347,   348,   349,
     350,   351,   352,   353,   354,   355,   481,   625,   648,  1291,
    1292,  1293,  1294,  1295,  1347,  1348,  2243,  2269,   848,   837,
    2391,   430,  2259,  2268,  2289,  2293,   430,  1923,  1927,  1980,
    2268,  1982,  2409,   851,   851,   851,   851,  1987,    12,   290,
     780,   859,   870,  2234,    97,    69,    88,   401,   460,   495,
     603,   716,   891,  1991,  1992,  2366,  2014,  2409,  2268,  2032,
     220,  2033,   369,   369,  2201,  2234,   369,    97,  2346,   430,
    2059,    15,    68,  2088,  2089,  1765,  1647,   271,  1868,   369,
    1868,   430,  1972,    44,   259,  1968,  2412,  1973,  2268,  1968,
    2234,   302,   558,   151,   758,   853,  2194,   854,  2195,   287,
    2120,   369,  2120,  2125,  2409,  1587,  2335,  1280,  1258,  2324,
     748,   698,  1420,   929,   931,  1387,  1391,  1319,  1320,  2366,
    2306,    31,    67,    87,   126,   216,   224,   362,   432,   444,
     468,   583,   620,   631,   681,   736,   753,   774,   822,   886,
     912,   927,   929,   931,   934,   938,  1307,  1308,  1309,  1310,
    1311,  1314,  1315,  1317,  1320,  1321,  1324,  1327,  1329,  1330,
    1335,  1336,  1338,  1351,  1355,  1372,  1373,  1375,  1376,  1377,
    1380,  1401,  1404,  1406,  1408,  1409,  1410,  1411,  1412,  1413,
    1465,  2366,  2396,  1289,  2366,   170,  2350,  2366,   673,   679,
    2427,  2427,  2366,  2350,  2366,  2378,  2366,    33,  2338,   584,
     954,  1255,  2228,   322,   379,     1,  1136,  1137,  2220,  2383,
    2383,   874,   875,  2431,  2208,  2383,  2383,  2350,  2382,  2382,
     679,  2206,  1096,  1098,  2422,    25,   526,  2223,  1079,  1047,
    1048,  1221,  1558,  1558,    99,   606,   805,  1649,  1568,  1567,
     713,  1577,   303,   568,   570,   590,  2129,  2131,  2132,  2134,
    2135,  2413,  2414,    89,   576,  2380,  2380,   481,  2256,  2260,
    2285,  2366,  2366,  2366,  2366,    69,   250,  1626,  2347,   245,
     902,  2406,    15,  2337,   446,   780,  1609,   151,   864,   869,
    2129,   968,   967,  2247,  2129,   446,  2371,   802,   802,   576,
    1603,   522,   481,  2246,  2269,  2268,  2194,   853,  2194,   853,
     853,   619,   853,  2239,  2194,   853,   853,   853,  2194,   853,
    2261,  2194,   853,  2382,   573,   781,  2141,  2143,  2145,  2281,
    2282,  2201,   854,   853,   853,   851,  2311,  1636,  2283,   713,
    1637,   851,  2216,  1646,   535,   647,  1654,    39,  1681,  2409,
     718,   692,  2141,  2366,   747,   361,  2357,   433,   571,  2162,
    2163,  2165,  2167,   446,  1736,  1727,  1594,   184,   185,   637,
    1079,  1718,  2212,  1715,   542,  1754,  2367,   473,   739,  2366,
     297,   299,  1542,  1543,  2354,  2405,  2367,   245,  2406,  2366,
    1754,  1725,  2268,  1733,  1739,  2136,   378,  2141,   378,     1,
      31,   859,   870,  1780,  1781,  2175,   598,  1779,   969,  2187,
    2405,   341,  1098,  1845,  2277,    18,   456,   901,  1842,  1607,
    1608,  1806,  2214,  2383,  1814,   270,  1815,  1592,  2405,   697,
    1821,  2405,  2268,  2268,  2268,  2268,  2268,  2248,  2269,  2276,
    2290,    18,   124,   341,   456,   879,  1852,  1853,  1854,  1847,
    1848,  1157,  2008,  2349,    40,   223,  1367,   246,  1536,  2268,
    2283,   868,  2234,  2230,  2141,   378,  2409,  1927,  1291,  2359,
    1908,  1903,  1904,   318,  1910,  2173,  1911,  1912,  2268,  2216,
     856,  2089,  1923,  2268,  2268,   566,  2151,  2154,  2156,  2412,
    1957,  1958,  2409,   713,  2088,   251,   256,   305,  2268,  2247,
     585,   969,  2257,  2258,  2260,  2283,  2382,  2246,   584,  2234,
    1987,  1987,  1987,  1987,  1987,  1987,  1987,  1987,  1992,   559,
     569,  2016,  2017,  2188,  2313,  2162,   462,   780,  2429,  2035,
    2409,  2346,  2268,  2261,  2141,   378,  2248,    18,  2057,  2058,
    2307,  2060,  2268,  2035,  2060,  1927,    14,  2336,   481,  1767,
     920,  1655,  2268,  2268,   946,  1969,   946,  1970,  1971,   802,
    2399,  2399,  2195,   853,  2195,  2268,   713,  2126,   258,  1591,
    2283,  1259,  1416,  2324,  1421,   739,  1483,  2366,  2338,    30,
     319,   595,   853,   855,   864,   865,   868,   869,  1290,  1306,
    1393,  1394,  1395,   929,   379,  2277,   462,   578,   946,  2407,
    2366,  2366,  2366,    77,   123,   578,  1328,   946,   722,  2393,
    2266,  2269,   247,  1358,  2283,  1331,   946,  2269,    39,  2341,
     946,   434,   459,   722,  1374,  2405,  2366,  2366,   369,  2366,
     369,  2338,   954,  1466,  1467,  1309,    70,    71,    72,    73,
      74,    76,    77,   155,   157,   158,   160,   161,   162,   163,
     164,   165,   231,   232,   347,   348,   349,   350,   351,   355,
     376,   392,   416,   526,   604,   625,   648,   776,   777,   778,
     896,   897,   898,   921,  1340,  1347,  1348,  1290,  1306,  1388,
    1389,   322,   323,   409,   789,   887,   456,   879,   369,  1303,
    2341,   379,  2283,  1161,  2368,  2368,   954,  2224,  2225,   587,
     792,  2423,   481,  2220,  2226,  2283,   934,  2366,   330,   408,
     954,  1239,  2228,  2325,     6,    10,    29,    42,   257,   331,
     332,   417,   473,   555,   597,   605,   673,   688,   705,   769,
     783,   860,   876,   877,  1138,  1139,  1148,  1150,  1154,  1156,
    1157,  1160,  1162,  1163,  1164,  1165,  1171,  1172,  1173,  1174,
    1177,  1183,  1184,  1186,  1188,  1190,  1191,  1192,  1193,  2325,
    2349,  2391,  2421,  2206,  2206,  2383,  2206,  2206,  1205,  1206,
    2208,  2428,  2208,  1097,  1098,  2280,  2366,  2366,  2223,  1073,
    1212,  1418,   641,   997,   997,   479,  1569,  1570,  1571,  2346,
    1569,   587,   954,  1563,  2133,  2134,  1622,  1623,  2264,  2268,
    2130,  2131,  1592,  2255,  2255,  2255,  2255,  2256,  2255,  2366,
    2171,  2258,  2171,  2256,  2359,  2366,   853,   853,  1609,  2242,
    2242,  2129,   780,  1614,  1615,  1617,  2315,   825,  2297,   825,
    2297,   853,  2297,  2220,  2297,  2297,  2297,  2239,  2297,  2315,
     456,   879,  2297,  2269,  1592,  1592,  2144,  2145,  2142,  2143,
    2282,  2141,   853,  2195,  2297,  2297,  2251,  2268,  2289,  1637,
    2231,  2169,   541,  2317,  2195,  1592,  1592,  2166,  2167,  2164,
    2165,  2252,  1742,   216,   407,   849,   886,  1661,  1728,  1729,
    1730,  1595,  2255,  2255,   473,   739,   259,  2255,  2171,  2171,
    2255,    91,    93,   392,   477,   626,   768,   871,  1617,  1744,
    1745,  1746,  1747,  1748,  1750,  1751,  1752,  1753,  2409,  1744,
    2201,  2202,  2201,  2202,    27,   843,  1782,   268,   856,  1592,
    1780,    97,   341,  1845,   301,  1790,  2264,  1592,   255,   929,
    1822,  1823,  1824,   840,  1825,  2403,   929,   851,    97,  1853,
    1855,  2248,    18,   124,   456,   879,  1850,  1851,  2247,  2264,
    2268,  2004,   763,  2371,   414,   596,  2361,  2233,  2201,    18,
     541,   667,  1187,  2206,  2268,  1592,   274,   856,  1906,    15,
     369,    14,   413,  1924,  1925,  1926,  1928,  1931,  1958,  2409,
     201,   546,  1940,  1942,  1944,  1592,  2155,  2156,  2154,  1592,
    2162,   489,   541,  1978,  2268,   697,  1983,   327,   328,  2234,
    2188,  2268,  2189,  2190,  2191,  2192,  2195,   572,   867,  2146,
    2148,  2150,   625,   780,  2034,  2234,  2315,  2315,  2201,   851,
     595,  2247,   221,  2061,   830,  2062,  1957,   607,  2212,  2255,
    1656,   183,  2172,  1872,  2409,  2174,  1592,  2173,  1970,  2023,
    2234,  2023,   853,  2172,   526,   928,  2127,  2250,   856,   109,
    1260,  1261,  1262,  1280,  1419,   748,  1484,   843,  1392,  1395,
    2366,   843,  1297,   969,    22,    23,    24,    90,   128,   578,
    1161,  1407,   556,  1405,  2234,  2230,   201,  2353,     1,  2179,
    2180,  2181,  2182,   868,  1312,  1313,   104,  1360,   890,   851,
    1357,    98,   222,   484,  1332,  1352,  2179,  2266,  1325,   954,
    2267,     1,   581,   954,  1343,  2231,   868,  1383,  1388,  1389,
    1383,  1378,  1379,  1388,   369,  1468,  1467,   775,   895,  2395,
     895,  2395,   895,  2395,   895,  2395,   895,  2395,    16,  2405,
    2382,  1342,  2405,  1341,  2405,   695,  1384,  1385,  1389,    39,
    1318,  2346,  1322,   809,  1316,   761,  2318,  2318,   954,  1305,
    1306,   851,  1236,   359,  1252,  2225,   477,  2375,   851,  2348,
    2359,   324,   342,   735,   888,   923,   932,  1249,  1250,  2366,
    2366,  2378,  2371,  2391,  2405,   764,  2371,  2366,  2347,   221,
    2371,  2371,   541,  1185,  2283,  2409,  2366,  2366,   802,   489,
     763,    70,  2344,  2368,  2206,  1206,   628,  1207,    27,  2223,
    2223,  1114,  1118,  1120,  1213,  1214,  1215,  1216,  1066,  1067,
     998,   987,   989,  1570,   780,   895,  1572,  1573,  1574,   683,
     929,  2335,  1592,  2252,   473,   477,  2424,  1623,  2257,   853,
    2366,  1615,  2141,  2297,   369,  2319,   853,  1647,   231,   747,
     848,  1737,  2367,  2367,  2367,  2367,  2234,  1730,  2382,   414,
     434,  2370,  2255,  2339,  1745,   116,   459,   722,  1749,   541,
    1754,  2141,   690,  2141,   690,  1781,  2174,  1845,   697,  1844,
    1791,  1792,  2268,  2289,  1814,  1823,  2353,  2405,  2249,  2276,
    2289,  2247,    97,    15,    68,  1856,  1857,  1858,  1851,  1856,
     359,   422,   920,  2009,  1158,  2006,   596,   853,  2141,   598,
    2386,  2386,   589,    20,   230,   359,   458,   703,   717,   953,
    1893,  1894,  1898,  1899,  2409,  2410,   274,  1905,  1912,  2234,
    2383,   489,   446,  1932,  1930,  1931,  2409,   412,   445,   944,
    1592,  1592,  1943,  1944,  1941,  1942,   489,   473,  2372,  2382,
    2382,  1592,  1592,  2149,  2150,  2147,  2148,  2366,  2141,  2319,
    2141,  2249,  2058,  2359,  2172,  2359,  2146,   298,   567,  2090,
    2157,  2159,  2161,  2163,   473,   477,  2373,  1657,  1658,  1659,
    2346,  2359,  1863,   522,  2107,   226,  1592,  1592,  2096,  2409,
     644,   913,  1588,  2067,  2227,  1280,  1280,  2324,   748,  1290,
     946,  1396,  1397,  1398,  2368,  2408,   537,   797,  1304,  1305,
    2277,    30,    53,    54,    55,    56,    57,    58,    59,    60,
     319,   595,   853,   855,   864,   865,   868,   869,  2183,  2184,
    2186,  2187,  2234,   481,  2244,  2359,   369,  1356,   848,  2404,
    2283,  2404,  2283,  2383,  1333,  2366,   598,  1326,  2179,   683,
    1402,  2407,  1386,  2285,  2366,  1385,  2338,  1379,  1388,   369,
    1381,  1384,  2240,    97,  1469,   375,     7,    66,    78,   125,
     148,   207,   292,   357,   366,   448,   455,   480,   508,   657,
     661,   742,   803,   817,   841,   883,   933,   945,   952,   954,
    1497,  2267,   647,  2285,  2405,   481,  2252,   184,   189,   309,
     740,  1323,  2347,  1306,  2283,   124,   679,  1232,  2219,  1243,
    2283,  2397,   481,  1240,  2277,  1240,  2366,  2366,  2371,   247,
     322,  1145,  1146,  2366,   688,  1172,  2366,  2366,  2366,  2366,
      34,    35,  2340,  1187,  2226,  2283,  2366,  2378,   584,   764,
    1189,  2226,  2283,  1098,  2357,  2357,  1215,   856,  1216,   239,
    2366,   780,  1574,   593,  1576,   215,  1578,  2257,   416,  2362,
     224,  2320,  1655,  1744,  2234,  2234,  2234,  2234,  2268,  2367,
     849,   741,   957,  2202,  2202,    97,  1716,  1717,  1792,  1592,
      97,   216,  1856,  1856,  2249,   862,  2364,  2364,  1858,  1857,
     641,  2206,   378,   600,  2010,  1159,  2357,  2366,  2277,    18,
     541,   668,   904,   961,  1896,  1897,  1898,   541,    94,   489,
     500,  1895,    97,  1913,   489,  2366,  1933,  2152,  2154,  2156,
    2162,   489,   489,  2208,  2208,  2268,  2320,  2268,  2268,  1592,
    1592,  2160,  2161,  2158,  2159,  1658,   587,  1573,  2235,  2236,
    2265,  2269,   171,   683,   929,  2268,  2107,  2382,   820,  1865,
    2098,  2099,  2100,  2409,   860,  2128,  2203,   641,  2068,   856,
    1263,  1422,  2324,   765,   432,   924,  1399,   859,  2382,  2184,
     969,  2187,   853,   954,  2283,   851,  1357,   222,   222,  1359,
    2220,   780,   954,  1334,   325,   954,  1344,  1345,   588,  1403,
     302,   541,   853,  2194,  1383,   851,  1382,  2240,   218,   343,
     450,   507,   782,   878,  1349,   482,  1350,  2404,   259,   802,
      91,   871,  1244,  1245,  1246,  1247,  2409,  2348,   369,  1235,
    2358,   247,   665,   764,  1149,  2220,  2366,   105,   106,   107,
     228,   229,   231,   422,   423,   447,   473,   498,   600,   633,
     637,   638,   665,   832,  1140,  1141,  1142,  1143,  1144,  2220,
    2226,  1175,  2220,  2220,  2348,  2431,  2220,  2366,  2220,  2226,
     843,   526,    25,   856,  1566,    48,   216,  2283,  2366,   954,
    1579,  1564,  2257,  2362,  2141,  1660,  1661,  2268,  2367,  2141,
    2141,  1845,  2234,  1856,  2234,  2234,  2366,  2206,   641,    25,
     526,  1161,   599,  2387,   718,  2237,  2241,  2244,  2268,  2293,
     901,  2268,  2155,  2153,  2154,  2141,  2235,  1865,  2108,  2109,
    2268,  1866,  1867,  2268,  2136,   524,  2102,  2100,    46,   258,
     964,  2101,   954,  2366,    43,   249,   313,   379,  2069,  2070,
    2071,  2073,  2077,  2079,  2080,  2083,  2342,  2357,  1264,  1423,
    1485,   851,   946,  1400,  2366,  2268,   420,  1361,  2383,  2383,
     417,  1362,  1364,  1365,  1366,  1367,  1369,  2366,  2382,     8,
     128,   171,   362,   687,   359,   302,  2285,  1383,  2226,  2226,
     358,   222,  1234,  1236,  2283,  2220,   369,    14,   920,   934,
    2277,  2289,  2432,    75,   476,   793,   954,  1176,   786,   857,
    1178,  1179,  2220,  2221,    51,   316,   499,  1166,  2366,   843,
    2226,  2366,  2366,  1577,    48,  1575,  2409,  2335,  1582,   851,
    2257,   570,   867,  1663,  1665,  1667,  2414,    12,   430,   561,
     587,   866,  1662,  2365,  2234,  1907,  2366,  2366,  2366,  1161,
    2269,  2290,  2293,  2173,  1864,  2109,  2366,  1867,  2366,   522,
    2104,  2250,  1907,    68,  2337,  1919,  2081,  2082,   645,   213,
    1265,  2328,  2331,  2357,   666,  1424,  1285,  1301,  1486,  1487,
    1488,  2173,  1290,  1362,  2220,  2220,  2346,  1369,  1365,  2371,
    1363,  2283,   589,  1346,  2271,  2272,  2274,  2342,  2383,  2348,
    1178,  2277,  2356,  2277,  2366,   614,  1151,  1152,  1180,  1181,
     953,  1167,  1169,  2409,  1170,  2409,  1167,  1161,  2226,  2223,
    2223,  2324,   506,  1582,  2257,  1592,  1592,  1666,  1667,  1664,
    1665,  1592,  2382,  2268,  1907,  1161,  1161,  2136,   587,  2289,
    2250,  2382,   886,  2110,  2124,   699,   792,  2398,   860,  2207,
    2082,   259,   797,  2078,  2383,   600,  2364,  1425,     1,  1287,
    1488,   856,  1362,  1370,  1371,  2278,  2366,  1364,  2272,  2226,
    2220,  1234,  2308,  2409,  1153,  2308,  1182,  2220,  1182,   489,
    2376,   725,   500,   780,   259,  2268,  2357,  2357,   525,  2103,
    2105,  2106,  2268,  2382,   820,  2115,  2136,  2268,   302,   312,
    2420,  2208,   860,    18,  2074,  2075,  2269,   224,   302,   802,
     821,   838,  1270,  1271,  1272,   422,   441,  2210,   856,  1489,
    1490,   856,  1371,  2222,  2223,  1151,   246,   541,  2366,   588,
    2366,  1580,   526,    25,  2366,  2106,  2366,  2111,  2112,  2268,
     310,   948,  2116,  2117,  2268,  2097,   641,  2388,  2208,   584,
     642,   684,  2076,  2075,   183,   829,  2366,   446,   446,   224,
     462,  1272,   259,   510,   802,   821,   838,  1266,  1267,  1268,
    1269,  2268,  2377,  2400,   259,   510,   802,   838,  1273,  1274,
    1275,  1276,  2268,  2400,  1426,  1492,   581,  1496,  1497,  2223,
     819,  1155,   246,  2220,   520,   673,   679,  2425,  2256,   215,
    2366,  2366,  2250,  2289,  2112,  2366,    45,   171,   254,   557,
     578,  2114,  2118,   403,   497,   788,   969,  2119,  2292,  2117,
    2136,  2383,   584,  2266,  2366,   583,  2268,  2366,  2366,  2366,
    2366,   446,   205,   846,   446,   462,  1268,  2268,   183,   659,
     786,   811,   812,   813,   446,   205,   846,   446,   462,  1275,
    2268,   833,     1,  1427,    48,    61,    62,    63,    64,    69,
      87,    88,   108,   130,   138,   186,   301,   360,   369,   371,
     389,   401,   460,   473,   477,   495,   541,   583,   603,   651,
     702,   749,   780,   792,   826,   851,   862,   891,   912,   920,
     929,  1330,  1337,  1338,  1351,  1372,  1375,  1493,  1494,  1495,
    1556,  1557,  1624,  1625,  2366,  2418,  1498,  2268,  2283,  1491,
     946,  2425,  1168,  1169,  1581,  1161,  1161,  2114,  2113,  2114,
    2113,   595,   320,   422,   441,   600,  2072,  2206,  2268,  2283,
    2268,  2268,  2268,  2268,  2366,  2366,  2366,  2366,  2366,  2268,
    2366,  2366,  2366,  2366,  2366,  2366,  2366,  2366,  2366,  2366,
    2366,  2268,  2366,  2329,  2331,   175,   176,   607,  1428,  1429,
    1434,  2329,  2366,  2409,  2440,  2366,   473,   739,  1554,  2380,
    1552,  2380,  2366,  2367,  1542,  1543,  2366,  2259,  1552,  2367,
    2283,   123,  2367,  2268,  2366,  2268,  2366,   231,   232,   526,
     921,  1339,  2290,   379,  1554,  1500,  1501,    18,   788,   969,
    1099,  1168,  2335,  2292,  2404,  2268,  2268,  2268,  2268,  2268,
    2268,  2268,  2268,  2268,  2268,  2268,  2268,  2268,  2268,  2268,
    2268,  2268,  2268,  2268,  2368,  2368,   469,   470,  2374,  1445,
     379,   134,   339,  1430,  1431,  1432,  1433,  2268,  2255,  2366,
    2366,  2255,  2264,  2283,  2255,  1549,  2255,  2404,  2366,  2264,
    2283,     1,  1492,  2291,  1368,  1369,  2268,  2268,  2368,  2368,
     969,  1435,  1436,  1437,  2268,  2283,  2286,  1285,  1446,  2366,
    1432,  1433,   512,   624,   864,   869,  1545,  1546,  1547,  1548,
    1555,  1545,  1547,  1553,   110,   622,  1550,  1551,  2252,  2268,
    2268,  1438,   473,   477,  2373,  2416,  2424,     1,  1287,  1288,
    2252,  2255,  2255,  2268,   341,   358,   394,   452,   475,  1439,
    1440,  1441,  1442,  1443,  1444,  1436,  1437,  2330,  2331,  1447,
    2268,   212,   226,  2433,  2366,  2366,   120,   175,  2433,  2434,
    2366,  1448,  2268,  2366,  1437,  1437,   394,  2366,  2366,  1437,
       4,   137,   141,   390,   473,   477,   539,   583,   631,   786,
     818,   886,  1330,  1335,  1337,  1351,  1353,  1372,  1375,  1387,
    1390,  1449,  1450,  1455,  1458,  1461,  1462,  1465,  1470,  1471,
    1474,  1475,  1481,  1482,  2330,  2415,  2416,  2417,  2268,  1437,
    1437,  1437,   418,  2363,   577,  2380,  2381,  2338,  2366,  2283,
    2366,  2382,  2366,  1388,    15,    68,   444,   946,   540,  1472,
    1473,  1544,  1545,  1478,  1479,  1480,  1545,  2283,  2381,  2268,
    2368,   537,   540,   607,  1456,  1457,  1545,  2283,  1357,  2240,
    2238,  2240,   119,   175,   607,   617,   618,   698,   720,   721,
    1451,  2433,  2434,  2435,  2436,  2437,  2438,  2439,   536,  2379,
    2379,    15,    68,  2173,  1472,  2286,  1479,  2286,   115,   459,
     722,  1476,  1477,  2283,  2404,  2315,   706,   905,  1459,  2240,
     358,   358,   394,   358,   394,   359,   588,  2384,  2384,   595,
     607,  1463,  1464,  2268,  1463,  2379,  2379,  2368,  1359,  2383,
    2268,   339,  1452,  2268,    18,   339,  1454,  2268,  1463,   607,
     607,   806,  1354,   339,  1460,  2268,   595,  1453,  1453,  1453,
    1453,  2283,   607
};

  /* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_int16 yyr1[] =
{
       0,   973,   975,   974,   976,   976,   978,   977,   979,   979,
     980,   980,   980,   980,   982,   981,   983,   984,   985,   985,
     986,   986,   988,   987,   990,   989,   992,   993,   991,   995,
     996,   994,   997,   998,   997,   999,  1000,  1001,  1000,  1002,
    1003,  1002,  1004,  1004,  1005,  1006,  1005,  1007,  1008,  1007,
    1010,  1011,  1009,  1012,  1012,  1014,  1013,  1015,  1015,  1016,
    1017,  1018,  1019,  1020,  1020,  1021,  1021,  1022,  1022,  1023,
    1023,  1024,  1024,  1024,  1024,  1025,  1025,  1026,  1026,  1027,
    1027,  1028,  1029,  1029,  1030,  1030,  1030,  1030,  1031,  1031,
    1032,  1032,  1033,  1033,  1033,  1034,  1034,  1035,  1035,  1035,
    1035,  1036,  1037,  1037,  1038,  1039,  1040,  1041,  1041,  1042,
    1043,  1044,  1044,  1045,  1045,  1046,  1046,  1046,  1046,  1046,
    1047,  1047,  1049,  1048,  1050,  1050,  1051,  1051,  1053,  1052,
    1054,  1054,  1054,  1054,  1055,  1055,  1056,  1056,  1056,  1056,
    1057,  1058,  1060,  1059,  1061,  1061,  1061,  1061,  1061,  1061,
    1062,  1063,  1064,  1064,  1064,  1064,  1065,  1065,  1066,  1066,
    1068,  1067,  1069,  1069,  1069,  1070,  1070,  1071,  1071,  1071,
    1071,  1071,  1072,  1072,  1073,  1074,  1075,  1075,  1075,  1076,
    1076,  1076,  1076,  1076,  1076,  1076,  1076,  1076,  1076,  1076,
    1076,  1076,  1076,  1076,  1078,  1077,  1079,  1079,  1080,  1080,
    1080,  1080,  1081,  1081,  1082,  1083,  1083,  1085,  1084,  1087,
    1086,  1088,  1086,  1089,  1089,  1090,  1091,  1091,  1091,  1091,
    1091,  1092,  1092,  1092,  1092,  1093,  1093,  1093,  1094,  1094,
    1095,  1095,  1096,  1095,  1097,  1097,  1098,  1098,  1098,  1098,
    1098,  1098,  1099,  1099,  1100,  1100,  1100,  1101,  1101,  1102,
    1103,  1104,  1104,  1105,  1106,  1106,  1107,  1107,  1108,  1109,
    1109,  1110,  1111,  1112,  1112,  1113,  1113,  1114,  1116,  1115,
    1117,  1117,  1118,  1119,  1119,  1120,  1121,  1122,  1123,  1124,
    1125,  1127,  1126,  1128,  1129,  1130,  1130,  1131,  1131,  1132,
    1132,  1134,  1135,  1133,  1136,  1136,  1137,  1137,  1138,  1138,
    1138,  1138,  1138,  1138,  1138,  1138,  1138,  1138,  1138,  1138,
    1138,  1138,  1138,  1138,  1138,  1138,  1138,  1138,  1139,  1139,
    1139,  1139,  1139,  1140,  1140,  1140,  1141,  1141,  1141,  1141,
    1141,  1141,  1141,  1142,  1142,  1142,  1142,  1143,  1143,  1143,
    1143,  1143,  1143,  1143,  1144,  1145,  1145,  1146,  1146,  1147,
    1147,  1148,  1149,  1149,  1149,  1150,  1151,  1151,  1153,  1152,
    1154,  1155,  1155,  1155,  1156,  1158,  1157,  1159,  1159,  1159,
    1159,  1159,  1159,  1160,  1161,  1161,  1161,  1161,  1161,  1162,
    1163,  1163,  1163,  1165,  1164,  1166,  1166,  1166,  1167,  1167,
    1167,  1167,  1168,  1168,  1169,  1170,  1170,  1171,  1171,  1172,
    1172,  1172,  1172,  1173,  1175,  1174,  1176,  1176,  1176,  1176,
    1177,  1178,  1178,  1179,  1179,  1181,  1180,  1180,  1182,  1183,
    1184,  1185,  1185,  1186,  1187,  1187,  1187,  1188,  1189,  1189,
    1190,  1191,  1192,  1193,  1194,  1194,  1195,  1196,  1196,  1196,
    1197,  1197,  1198,  1198,  1198,  1198,  1199,  1200,  1200,  1200,
    1200,  1201,  1201,  1201,  1201,  1201,  1202,  1202,  1202,  1202,
    1202,  1202,  1202,  1202,  1204,  1203,  1205,  1205,  1206,  1207,
    1207,  1208,  1209,  1210,  1210,  1211,  1211,  1211,  1212,  1213,
    1213,  1214,  1214,  1215,  1215,  1216,  1216,  1216,  1218,  1217,
    1219,  1219,  1220,  1221,  1222,  1223,  1223,  1224,  1224,  1225,
    1227,  1226,  1226,  1228,  1228,  1229,  1229,  1230,  1230,  1230,
    1230,  1230,  1230,  1230,  1230,  1230,  1230,  1230,  1231,  1232,
    1232,  1232,  1233,  1233,  1233,  1234,  1234,  1235,  1235,  1236,
    1236,  1237,  1238,  1238,  1239,  1239,  1240,  1240,  1241,  1242,
    1243,  1243,  1244,  1244,  1244,  1245,  1246,  1247,  1248,  1249,
    1249,  1249,  1249,  1249,  1250,  1250,  1251,  1252,  1252,  1253,
    1254,  1254,  1255,  1255,  1256,  1257,  1258,  1257,  1259,  1259,
    1260,  1261,  1263,  1262,  1264,  1264,  1265,  1265,  1265,  1266,
    1266,  1266,  1267,  1267,  1268,  1268,  1268,  1268,  1268,  1268,
    1268,  1268,  1268,  1268,  1268,  1269,  1270,  1270,  1271,  1271,
    1272,  1272,  1272,  1272,  1272,  1272,  1272,  1273,  1273,  1273,
    1274,  1274,  1275,  1275,  1275,  1275,  1275,  1275,  1276,  1277,
    1278,  1279,  1278,  1280,  1281,  1280,  1282,  1282,  1283,  1283,
    1283,  1284,  1283,  1283,  1285,  1285,  1286,  1286,  1287,  1287,
    1288,  1289,  1289,  1290,  1290,  1290,  1291,  1291,  1291,  1291,
    1291,  1291,  1291,  1291,  1291,  1291,  1291,  1291,  1291,  1291,
    1291,  1291,  1292,  1292,  1293,  1293,  1294,  1294,  1295,  1295,
    1296,  1297,  1297,  1299,  1298,  1300,  1300,  1301,  1302,  1301,
    1303,  1303,  1304,  1304,  1304,  1305,  1305,  1306,  1306,  1306,
    1306,  1306,  1306,  1306,  1306,  1306,  1306,  1307,  1307,  1308,
    1308,  1309,  1309,  1309,  1309,  1309,  1309,  1309,  1309,  1309,
    1309,  1309,  1309,  1309,  1309,  1309,  1309,  1309,  1309,  1309,
    1309,  1309,  1309,  1309,  1309,  1309,  1309,  1309,  1309,  1309,
    1309,  1310,  1311,  1312,  1312,  1313,  1314,  1315,  1316,  1316,
    1317,  1318,  1318,  1319,  1319,  1320,  1322,  1321,  1323,  1323,
    1323,  1323,  1325,  1324,  1326,  1326,  1327,  1328,  1328,  1328,
    1329,  1331,  1330,  1332,  1332,  1332,  1332,  1333,  1333,  1334,
    1335,  1336,  1336,  1336,  1336,  1337,  1337,  1338,  1338,  1339,
    1339,  1339,  1339,  1340,  1340,  1340,  1340,  1340,  1340,  1340,
    1340,  1340,  1340,  1340,  1340,  1340,  1340,  1340,  1340,  1340,
    1340,  1340,  1340,  1340,  1340,  1340,  1340,  1340,  1340,  1340,
    1340,  1340,  1340,  1340,  1340,  1340,  1340,  1340,  1340,  1340,
    1340,  1340,  1340,  1340,  1340,  1340,  1340,  1340,  1340,  1340,
    1340,  1340,  1340,  1340,  1340,  1340,  1340,  1340,  1341,  1341,
    1342,  1342,  1343,  1344,  1344,  1344,  1344,  1345,  1345,  1346,
    1346,  1347,  1347,  1348,  1349,  1349,  1349,  1349,  1349,  1349,
    1349,  1350,  1350,  1351,  1351,  1352,  1353,  1354,  1354,  1355,
    1355,  1355,  1356,  1356,  1357,  1357,  1358,  1358,  1359,  1359,
    1360,  1360,  1361,  1361,  1362,  1362,  1363,  1362,  1362,  1362,
    1364,  1365,  1365,  1366,  1367,  1367,  1368,  1368,  1369,  1370,
    1370,  1371,  1372,  1373,  1374,  1374,  1374,  1375,  1376,  1377,
    1377,  1377,  1377,  1377,  1378,  1378,  1379,  1380,  1380,  1381,
    1382,  1382,  1383,  1384,  1384,  1385,  1385,  1386,  1386,  1387,
    1387,  1388,  1388,  1389,  1390,  1392,  1391,  1393,  1394,  1394,
    1395,  1395,  1396,  1396,  1396,  1397,  1398,  1399,  1399,  1400,
    1400,  1401,  1402,  1402,  1403,  1403,  1403,  1403,  1404,  1405,
    1405,  1406,  1407,  1407,  1407,  1407,  1407,  1407,  1407,  1408,
    1409,  1410,  1411,  1411,  1412,  1413,  1414,  1415,  1416,  1415,
    1417,  1418,  1419,  1418,  1420,  1421,  1422,  1420,  1423,  1423,
    1425,  1426,  1424,  1427,  1427,  1427,  1428,  1428,  1428,  1428,
    1429,  1430,  1430,  1430,  1431,  1432,  1432,  1433,  1434,  1435,
    1435,  1435,  1436,  1437,  1437,  1438,  1438,  1439,  1439,  1439,
    1439,  1439,  1439,  1440,  1441,  1442,  1443,  1444,  1445,  1445,
    1447,  1446,  1446,  1448,  1448,  1449,  1449,  1449,  1449,  1449,
    1449,  1449,  1449,  1449,  1449,  1449,  1449,  1449,  1449,  1449,
    1449,  1449,  1450,  1451,  1451,  1451,  1451,  1451,  1451,  1451,
    1452,  1452,  1452,  1453,  1453,  1454,  1454,  1454,  1454,  1455,
    1456,  1456,  1456,  1457,  1457,  1457,  1458,  1459,  1459,  1459,
    1460,  1460,  1461,  1461,  1461,  1461,  1461,  1462,  1462,  1463,
    1463,  1464,  1464,  1464,  1465,  1466,  1466,  1467,  1468,  1468,
    1469,  1469,  1470,  1471,  1471,  1472,  1472,  1473,  1473,  1474,
    1475,  1476,  1476,  1477,  1477,  1477,  1478,  1478,  1479,  1479,
    1480,  1481,  1482,  1483,  1484,  1485,  1483,  1486,  1486,  1487,
    1487,  1488,  1489,  1488,  1490,  1491,  1488,  1488,  1492,  1492,
    1493,  1493,  1493,  1493,  1493,  1493,  1493,  1493,  1493,  1493,
    1493,  1493,  1493,  1493,  1493,  1493,  1493,  1493,  1493,  1493,
    1493,  1493,  1493,  1493,  1493,  1493,  1493,  1493,  1493,  1493,
    1493,  1493,  1493,  1493,  1493,  1493,  1493,  1493,  1493,  1493,
    1493,  1493,  1493,  1493,  1493,  1493,  1493,  1493,  1493,  1494,
    1495,  1495,  1496,  1496,  1497,  1497,  1497,  1497,  1497,  1497,
    1497,  1497,  1497,  1497,  1497,  1497,  1497,  1497,  1497,  1497,
    1498,  1498,  1499,  1499,  1500,  1500,  1501,  1501,  1502,  1502,
    1502,  1503,  1503,  1504,  1504,  1505,  1505,  1505,  1505,  1505,
    1505,  1505,  1505,  1505,  1505,  1505,  1505,  1505,  1505,  1506,
    1506,  1506,  1506,  1506,  1506,  1506,  1506,  1506,  1506,  1506,
    1506,  1506,  1506,  1506,  1507,  1507,  1507,  1507,  1507,  1507,
    1507,  1507,  1507,  1507,  1508,  1508,  1509,  1509,  1509,  1509,
    1509,  1510,  1511,  1511,  1511,  1511,  1511,  1511,  1511,  1511,
    1511,  1511,  1511,  1511,  1511,  1511,  1511,  1512,  1512,  1512,
    1512,  1512,  1512,  1512,  1512,  1512,  1512,  1513,  1513,  1513,
    1513,  1513,  1513,  1513,  1513,  1513,  1513,  1514,  1514,  1515,
    1515,  1516,  1516,  1517,  1517,  1517,  1517,  1517,  1518,  1518,
    1518,  1518,  1518,  1518,  1518,  1518,  1518,  1518,  1518,  1518,
    1518,  1518,  1518,  1518,  1519,  1519,  1519,  1520,  1520,  1520,
    1520,  1520,  1520,  1520,  1520,  1521,  1521,  1521,  1521,  1521,
    1521,  1522,  1522,  1522,  1522,  1522,  1522,  1522,  1522,  1523,
    1523,  1523,  1523,  1524,  1524,  1524,  1525,  1525,  1525,  1525,
    1525,  1525,  1526,  1526,  1526,  1526,  1527,  1527,  1527,  1527,
    1527,  1527,  1527,  1528,  1528,  1528,  1528,  1528,  1528,  1528,
    1528,  1528,  1528,  1528,  1528,  1528,  1528,  1528,  1528,  1528,
    1528,  1528,  1528,  1528,  1528,  1528,  1528,  1528,  1528,  1528,
    1528,  1528,  1528,  1528,  1528,  1528,  1528,  1528,  1528,  1528,
    1528,  1528,  1528,  1528,  1528,  1528,  1528,  1528,  1528,  1528,
    1529,  1529,  1529,  1530,  1530,  1530,  1530,  1530,  1530,  1530,
    1530,  1530,  1531,  1531,  1531,  1531,  1531,  1531,  1531,  1531,
    1531,  1531,  1531,  1531,  1531,  1531,  1531,  1531,  1531,  1531,
    1531,  1531,  1531,  1531,  1531,  1532,  1533,  1534,  1534,  1534,
    1534,  1534,  1534,  1534,  1534,  1535,  1535,  1535,  1536,  1536,
    1537,  1538,  1538,  1539,  1539,  1540,  1540,  1541,  1541,  1541,
    1542,  1542,  1543,  1543,  1544,  1544,  1545,  1546,  1546,  1547,
    1548,  1548,  1549,  1550,  1550,  1551,  1551,  1552,  1553,  1553,
    1553,  1554,  1555,  1555,  1555,  1556,  1557,  1558,  1558,  1559,
    1559,  1561,  1562,  1563,  1564,  1560,  1565,  1560,  1566,  1567,
    1566,  1568,  1566,  1569,  1569,  1570,  1571,  1571,  1571,  1572,
    1572,  1573,  1573,  1573,  1573,  1573,  1574,  1575,  1575,  1576,
    1576,  1577,  1577,  1577,  1578,  1579,  1580,  1581,  1578,  1582,
    1582,  1583,  1583,  1584,  1583,  1583,  1583,  1585,  1585,  1587,
    1586,  1588,  1588,  1589,  1590,  1591,  1591,  1593,  1594,  1592,
    1596,  1595,  1595,  1597,  1597,  1597,  1597,  1597,  1597,  1597,
    1597,  1597,  1597,  1597,  1597,  1597,  1597,  1597,  1597,  1597,
    1597,  1597,  1597,  1597,  1597,  1597,  1597,  1597,  1597,  1597,
    1597,  1597,  1597,  1597,  1597,  1597,  1597,  1597,  1597,  1597,
    1597,  1597,  1597,  1597,  1597,  1597,  1597,  1597,  1597,  1597,
    1597,  1597,  1597,  1597,  1597,  1597,  1597,  1597,  1597,  1597,
    1597,  1597,  1597,  1597,  1597,  1597,  1597,  1597,  1598,  1597,
    1597,  1600,  1599,  1602,  1601,  1603,  1601,  1601,  1601,  1601,
    1601,  1601,  1601,  1601,  1601,  1601,  1601,  1601,  1601,  1601,
    1601,  1601,  1601,  1601,  1601,  1601,  1601,  1601,  1601,  1601,
    1601,  1604,  1604,  1606,  1605,  1607,  1607,  1608,  1608,  1608,
    1609,  1609,  1609,  1610,  1610,  1611,  1611,  1612,  1612,  1613,
    1613,  1613,  1613,  1613,  1614,  1614,  1615,  1615,  1616,  1616,
    1617,  1617,  1617,  1618,  1619,  1620,  1621,  1621,  1621,  1621,
    1621,  1621,  1621,  1621,  1621,  1621,  1621,  1621,  1621,  1621,
    1621,  1621,  1621,  1621,  1621,  1621,  1621,  1621,  1621,  1621,
    1621,  1621,  1621,  1621,  1621,  1621,  1621,  1621,  1621,  1621,
    1621,  1621,  1622,  1622,  1623,  1624,  1624,  1624,  1625,  1625,
    1625,  1626,  1626,  1627,  1627,  1629,  1628,  1630,  1630,  1630,
    1630,  1631,  1631,  1632,  1632,  1634,  1633,  1635,  1635,  1636,
    1636,  1637,  1637,  1639,  1638,  1640,  1640,  1641,  1642,  1642,
    1644,  1643,  1646,  1645,  1647,  1648,  1647,  1649,  1649,  1649,
    1650,  1650,  1651,  1651,  1651,  1651,  1651,  1651,  1651,  1652,
    1652,  1653,  1653,  1654,  1654,  1655,  1656,  1655,  1657,  1657,
    1658,  1658,  1658,  1659,  1659,  1659,  1659,  1660,  1660,  1660,
    1660,  1660,  1661,  1661,  1662,  1662,  1663,  1663,  1663,  1664,
    1664,  1665,  1665,  1666,  1666,  1667,  1668,  1668,  1670,  1669,
    1671,  1671,  1672,  1672,  1673,  1673,  1675,  1674,  1676,  1676,
    1677,  1677,  1678,  1678,  1678,  1678,  1678,  1680,  1679,  1681,
    1681,  1683,  1682,  1684,  1685,  1685,  1686,  1688,  1687,  1689,
    1690,  1689,  1692,  1691,  1693,  1693,  1695,  1694,  1696,  1696,
    1697,  1697,  1698,  1698,  1700,  1699,  1701,  1702,  1702,  1703,
    1703,  1703,  1703,  1703,  1705,  1704,  1706,  1706,  1706,  1706,
    1706,  1706,  1706,  1706,  1706,  1706,  1706,  1706,  1707,  1707,
    1708,  1708,  1710,  1709,  1711,  1711,  1712,  1712,  1713,  1713,
    1714,  1714,  1715,  1715,  1715,  1715,  1715,  1716,  1716,  1717,
    1717,  1717,  1717,  1718,  1718,  1720,  1719,  1721,  1723,  1722,
    1724,  1724,  1725,  1725,  1725,  1727,  1726,  1728,  1728,  1729,
    1729,  1730,  1730,  1730,  1730,  1730,  1732,  1733,  1731,  1734,
    1734,  1736,  1737,  1735,  1739,  1738,  1740,  1740,  1740,  1741,
    1741,  1742,  1742,  1743,  1743,  1743,  1744,  1744,  1745,  1745,
    1745,  1745,  1745,  1745,  1745,  1745,  1746,  1747,  1748,  1748,
    1748,  1749,  1749,  1749,  1749,  1750,  1750,  1751,  1751,  1752,
    1753,  1754,  1754,  1754,  1754,  1754,  1754,  1754,  1754,  1754,
    1754,  1754,  1754,  1754,  1754,  1754,  1754,  1754,  1754,  1754,
    1754,  1754,  1754,  1754,  1755,  1755,  1757,  1756,  1758,  1758,
    1758,  1758,  1758,  1759,  1759,  1761,  1760,  1762,  1764,  1763,
    1765,  1763,  1766,  1767,  1769,  1768,  1770,  1771,  1771,  1772,
    1772,  1772,  1773,  1773,  1774,  1774,  1775,  1775,  1775,  1776,
    1776,  1776,  1778,  1777,  1779,  1777,  1780,  1780,  1781,  1781,
    1781,  1781,  1781,  1782,  1782,  1783,  1783,  1785,  1784,  1787,
    1786,  1788,  1788,  1789,  1789,  1790,  1790,  1791,  1791,  1792,
    1792,  1794,  1793,  1795,  1795,  1795,  1795,  1795,  1795,  1795,
    1796,  1796,  1796,  1796,  1798,  1797,  1799,  1801,  1800,  1802,
    1804,  1803,  1805,  1805,  1806,  1806,  1808,  1807,  1810,  1809,
    1811,  1811,  1811,  1812,  1812,  1813,  1814,  1815,  1815,  1817,
    1816,  1818,  1819,  1819,  1820,  1820,  1820,  1821,  1821,  1822,
    1822,  1823,  1824,  1824,  1824,  1824,  1824,  1824,  1824,  1825,
    1825,  1827,  1826,  1828,  1828,  1830,  1829,  1831,  1831,  1833,
    1832,  1834,  1835,  1835,  1836,  1836,  1836,  1837,  1837,  1837,
    1837,  1839,  1838,  1841,  1840,  1840,  1842,  1842,  1842,  1843,
    1843,  1843,  1843,  1844,  1844,  1845,  1845,  1847,  1846,  1848,
    1849,  1850,  1850,  1851,  1851,  1851,  1851,  1851,  1851,  1852,
    1852,  1853,  1853,  1854,  1854,  1854,  1854,  1854,  1855,  1856,
    1856,  1856,  1856,  1856,  1857,  1858,  1859,  1861,  1860,  1863,
    1864,  1862,  1865,  1865,  1866,  1866,  1867,  1868,  1868,  1870,
    1869,  1871,  1872,  1872,  1874,  1873,  1876,  1875,  1877,  1877,
    1878,  1878,  1880,  1879,  1881,  1881,  1883,  1882,  1884,  1884,
    1885,  1885,  1887,  1886,  1888,  1888,  1889,  1890,  1890,  1891,
    1891,  1891,  1891,  1892,  1892,  1893,  1893,  1893,  1893,  1893,
    1894,  1894,  1895,  1895,  1895,  1896,  1896,  1896,  1897,  1897,
    1897,  1898,  1898,  1899,  1899,  1899,  1901,  1900,  1902,  1903,
    1902,  1904,  1902,  1905,  1905,  1906,  1906,  1907,  1907,  1908,
    1908,  1908,  1908,  1908,  1909,  1909,  1910,  1910,  1911,  1911,
    1912,  1913,  1913,  1915,  1914,  1917,  1916,  1918,  1918,  1919,
    1921,  1920,  1922,  1923,  1923,  1924,  1924,  1924,  1924,  1925,
    1925,  1926,  1926,  1927,  1927,  1928,  1929,  1929,  1929,  1930,
    1930,  1931,  1931,  1931,  1932,  1932,  1933,  1933,  1934,  1934,
    1935,  1937,  1936,  1938,  1939,  1939,  1940,  1940,  1940,  1941,
    1941,  1942,  1943,  1943,  1944,  1945,  1945,  1947,  1946,  1948,
    1949,  1951,  1950,  1952,  1953,  1953,  1955,  1954,  1956,  1957,
    1957,  1958,  1958,  1959,  1959,  1960,  1961,  1963,  1962,  1964,
    1962,  1965,  1966,  1967,  1967,  1968,  1968,  1969,  1970,  1970,
    1971,  1972,  1972,  1973,  1975,  1974,  1976,  1976,  1977,  1978,
    1979,  1979,  1980,  1981,  1981,  1982,  1982,  1982,  1982,  1983,
    1983,  1985,  1984,  1986,  1986,  1986,  1986,  1986,  1986,  1986,
    1986,  1987,  1987,  1988,  1988,  1989,  1990,  1991,  1991,  1992,
    1992,  1992,  1992,  1992,  1992,  1992,  1992,  1993,  1993,  1993,
    1993,  1993,  1994,  1995,  1995,  1996,  1997,  1997,  1998,  1998,
    1999,  2000,  2002,  2001,  2004,  2003,  2005,  2005,  2006,  2006,
    2007,  2007,  2008,  2008,  2009,  2009,  2009,  2010,  2010,  2010,
    2012,  2011,  2013,  2014,  2014,  2015,  2015,  2015,  2015,  2016,
    2016,  2016,  2016,  2016,  2016,  2017,  2017,  2018,  2018,  2019,
    2021,  2020,  2020,  2020,  2020,  2022,  2022,  2022,  2022,  2022,
    2023,  2023,  2024,  2024,  2025,  2025,  2025,  2025,  2027,  2026,
    2028,  2030,  2029,  2031,  2031,  2032,  2033,  2033,  2034,  2034,
    2035,  2035,  2036,  2036,  2038,  2037,  2039,  2039,  2039,  2039,
    2040,  2040,  2042,  2041,  2043,  2043,  2045,  2044,  2046,  2046,
    2048,  2047,  2049,  2051,  2050,  2052,  2054,  2053,  2055,  2056,
    2056,  2057,  2057,  2058,  2059,  2059,  2060,  2061,  2061,  2062,
    2062,  2063,  2063,  2065,  2064,  2066,  2066,  2068,  2067,  2069,
    2069,  2069,  2069,  2069,  2070,  2071,  2071,  2072,  2072,  2072,
    2072,  2072,  2073,  2074,  2074,  2075,  2075,  2075,  2076,  2076,
    2076,  2076,  2077,  2078,  2078,  2079,  2080,  2081,  2081,  2082,
    2082,  2083,  2083,  2085,  2084,  2086,  2087,  2087,  2088,  2088,
    2088,  2088,  2089,  2089,  2090,  2090,  2090,  2091,  2091,  2092,
    2094,  2093,  2096,  2097,  2095,  2098,  2098,  2099,  2099,  2100,
    2101,  2101,  2101,  2102,  2102,  2103,  2103,  2104,  2104,  2105,
    2105,  2106,  2107,  2107,  2108,  2108,  2109,  2109,  2110,  2110,
    2111,  2111,  2112,  2113,  2113,  2114,  2114,  2114,  2115,  2115,
    2116,  2116,  2117,  2117,  2117,  2118,  2118,  2118,  2119,  2119,
    2120,  2120,  2122,  2121,  2124,  2123,  2125,  2125,  2126,  2126,
    2127,  2127,  2128,  2128,  2129,  2129,  2129,  2130,  2130,  2131,
    2132,  2132,  2133,  2133,  2134,  2135,  2135,  2136,  2136,  2136,
    2137,  2137,  2138,  2139,  2139,  2140,  2141,  2141,  2141,  2142,
    2142,  2143,  2144,  2144,  2145,  2146,  2146,  2146,  2147,  2147,
    2148,  2149,  2149,  2150,  2151,  2151,  2152,  2152,  2153,  2153,
    2154,  2155,  2155,  2156,  2157,  2157,  2158,  2158,  2159,  2160,
    2160,  2161,  2162,  2162,  2163,  2163,  2164,  2164,  2165,  2166,
    2166,  2167,  2168,  2168,  2169,  2169,  2170,  2170,  2171,  2171,
    2172,  2172,  2173,  2173,  2174,  2176,  2175,  2177,  2177,  2178,
    2178,  2178,  2178,  2178,  2178,  2178,  2178,  2178,  2178,  2178,
    2178,  2178,  2178,  2178,  2178,  2178,  2178,  2178,  2178,  2178,
    2178,  2179,  2179,  2180,  2182,  2181,  2183,  2183,  2184,  2184,
    2184,  2184,  2184,  2184,  2184,  2184,  2184,  2184,  2184,  2184,
    2184,  2184,  2184,  2184,  2184,  2184,  2184,  2184,  2184,  2185,
    2185,  2186,  2187,  2187,  2187,  2187,  2187,  2187,  2187,  2187,
    2187,  2187,  2187,  2187,  2187,  2187,  2188,  2188,  2189,  2189,
    2190,  2190,  2191,  2192,  2193,  2193,  2194,  2194,  2194,  2195,
    2195,  2195,  2196,  2196,  2196,  2196,  2196,  2196,  2196,  2196,
    2196,  2196,  2197,  2197,  2198,  2198,  2198,  2198,  2199,  2199,
    2200,  2200,  2200,  2200,  2200,  2200,  2201,  2201,  2202,  2203,
    2204,  2204,  2205,  2206,  2206,  2207,  2207,  2208,  2209,  2210,
    2211,  2211,  2212,  2213,  2213,  2214,  2215,  2215,  2216,  2217,
    2217,  2217,  2218,  2219,  2219,  2220,  2221,  2221,  2222,  2222,
    2223,  2224,  2224,  2225,  2226,  2226,  2227,  2227,  2228,  2229,
    2230,  2230,  2231,  2231,  2231,  2232,  2232,  2233,  2233,  2234,
    2234,  2235,  2235,  2236,  2236,  2236,  2236,  2236,  2236,  2236,
    2236,  2236,  2237,  2238,  2238,  2239,  2239,  2239,  2240,  2240,
    2240,  2240,  2240,  2240,  2240,  2241,  2241,  2241,  2241,  2241,
    2241,  2242,  2243,  2244,  2245,  2245,  2246,  2246,  2247,  2248,
    2248,  2249,  2249,  2250,  2250,  2250,  2251,  2251,  2252,  2252,
    2253,  2253,  2253,  2254,  2254,  2254,  2255,  2255,  2255,  2256,
    2256,  2257,  2257,  2258,  2258,  2259,  2259,  2259,  2260,  2261,
    2262,  2262,  2263,  2264,  2265,  2266,  2267,  2268,  2269,  2269,
    2269,  2269,  2270,  2270,  2271,  2271,  2272,  2273,  2273,  2274,
    2274,  2274,  2274,  2275,  2275,  2276,  2277,  2277,  2279,  2278,
    2280,  2280,  2281,  2282,  2282,  2283,  2284,  2285,  2286,  2286,
    2287,  2287,  2288,  2288,  2288,  2288,  2288,  2288,  2289,  2289,
    2290,  2290,  2291,  2291,  2292,  2292,  2292,  2292,  2293,  2293,
    2293,  2293,  2293,  2293,  2293,  2293,  2293,  2293,  2293,  2293,
    2293,  2293,  2294,  2294,  2295,  2295,  2295,  2295,  2296,  2296,
    2296,  2296,  2296,  2297,  2297,  2297,  2298,  2298,  2298,  2299,
    2299,  2299,  2301,  2300,  2302,  2302,  2303,  2303,  2304,  2304,
    2305,  2305,  2306,  2307,  2307,  2308,  2308,  2308,  2309,  2309,
    2310,  2310,  2311,  2311,  2312,  2312,  2312,  2313,  2313,  2314,
    2314,  2314,  2315,  2315,  2316,  2316,  2317,  2317,  2317,  2317,
    2317,  2317,  2317,  2317,  2318,  2318,  2319,  2319,  2320,  2320,
    2321,  2321,  2321,  2321,  2322,  2322,  2322,  2322,  2322,  2322,
    2322,  2322,  2322,  2322,  2322,  2322,  2322,  2322,  2322,  2322,
    2322,  2322,  2322,  2322,  2322,  2322,  2322,  2322,  2322,  2322,
    2322,  2322,  2322,  2322,  2322,  2322,  2322,  2322,  2322,  2322,
    2322,  2322,  2322,  2322,  2322,  2322,  2322,  2322,  2322,  2322,
    2322,  2322,  2322,  2322,  2322,  2322,  2323,  2323,  2323,  2323,
    2323,  2323,  2323,  2323,  2323,  2323,  2323,  2323,  2323,  2323,
    2323,  2323,  2323,  2323,  2323,  2323,  2323,  2323,  2323,  2324,
    2324,  2325,  2325,  2326,  2327,  2327,  2327,  2328,  2329,  2330,
    2331,  2331,  2331,  2332,  2332,  2332,  2332,  2333,  2333,  2333,
    2334,  2334,  2334,  2334,  2334,  2334,  2334,  2335,  2335,  2335,
    2336,  2336,  2337,  2337,  2338,  2338,  2339,  2339,  2340,  2340,
    2340,  2341,  2341,  2342,  2342,  2343,  2343,  2344,  2344,  2345,
    2345,  2346,  2346,  2347,  2347,  2348,  2348,  2349,  2349,  2350,
    2350,  2351,  2351,  2352,  2352,  2353,  2353,  2354,  2354,  2355,
    2355,  2356,  2356,  2357,  2357,  2358,  2358,  2359,  2359,  2360,
    2360,  2360,  2361,  2361,  2361,  2362,  2362,  2363,  2363,  2364,
    2364,  2365,  2365,  2366,  2366,  2367,  2367,  2367,  2368,  2368,
    2368,  2369,  2369,  2369,  2369,  2370,  2370,  2370,  2371,  2371,
    2372,  2372,  2373,  2373,  2373,  2374,  2374,  2374,  2375,  2375,
    2376,  2376,  2377,  2377,  2378,  2378,  2379,  2379,  2380,  2380,
    2381,  2381,  2382,  2382,  2383,  2383,  2384,  2384,  2384,  2385,
    2385,  2385,  2385,  2386,  2386,  2387,  2387,  2388,  2388,  2389,
    2389,  2390,  2390,  2391,  2391,  2392,  2392,  2392,  2393,  2393,
    2394,  2394,  2395,  2395,  2396,  2396,  2396,  2397,  2397,  2398,
    2398,  2399,  2399,  2400,  2400,  2401,  2401,  2402,  2402,  2403,
    2403,  2404,  2404,  2405,  2405,  2406,  2406,  2407,  2407,  2408,
    2408,  2409,  2409,  2410,  2410,  2410,  2411,  2411,  2412,  2412,
    2413,  2413,  2414,  2414,  2415,  2415,  2416,  2416,  2417,  2417,
    2418,  2418,  2418,  2418,  2419,  2419,  2420,  2420,  2421,  2421,
    2422,  2422,  2423,  2423,  2424,  2424,  2425,  2425,  2426,  2426,
    2426,  2427,  2427,  2428,  2428,  2429,  2429,  2430,  2430,  2431,
    2431,  2432,  2432,  2433,  2433,  2434,  2434,  2435,  2435,  2436,
    2436,  2437,  2437,  2438,  2438,  2439,  2439,  2440,  2440
};

  /* YYR2[YYN] -- Number of symbols on the right hand side of rule YYN.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     0,     2,     1,     1,     0,     3,     1,     2,
       1,     1,     1,     1,     0,     2,     4,     4,     0,     1,
       1,     2,     0,     4,     0,     4,     0,     0,    14,     0,
       0,    14,     0,     0,     6,     1,     0,     0,     5,     0,
       0,     5,     0,     3,     0,     0,     4,     0,     0,     4,
       0,     0,     6,     0,     1,     0,     4,     1,     1,     1,
       6,     1,     5,     1,     1,     1,     1,     0,     2,     0,
       3,     1,     1,     1,     1,     2,     2,     1,     1,     0,
       3,     5,     0,     3,     1,     1,     1,     1,     0,     5,
       0,     3,     1,     1,     1,     0,     4,     1,     1,     1,
       1,     3,     0,     1,     1,     3,     2,     0,     1,     1,
       3,     0,     1,     1,     2,     1,     1,     1,     1,     1,
       0,     1,     0,     4,     0,     3,     0,     3,     0,     4,
       0,     2,     3,     2,     1,     2,     1,     1,     1,     1,
       5,     2,     0,     4,     2,     3,     4,     4,     8,     8,
       3,     4,     1,     1,     1,     1,     1,     2,     0,     1,
       0,     4,     0,     2,     3,     1,     2,     3,     3,     3,
       3,     3,     1,     2,     2,     2,     1,     2,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     0,     3,     1,     1,     2,     3,
       3,     1,     0,     1,     1,     3,     4,     0,     4,     0,
       4,     0,     4,     0,     2,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     1,     1,     2,
       1,     3,     0,     4,     1,     3,     1,     1,     1,     1,
       1,     1,     1,     1,     0,     2,     2,     0,     2,     2,
       4,     1,     2,     3,     1,     2,     1,     2,     3,     1,
       2,     3,     6,     1,     2,     1,     3,     4,     0,     4,
       1,     1,     5,     0,     3,     3,     5,     3,     4,     3,
       3,     0,     4,     4,     1,     0,     3,     0,     2,     0,
       2,     0,     0,     6,     2,     2,     0,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     5,     5,
       6,     6,     4,     0,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     3,     0,     1,     1,     1,     1,
       1,     4,     1,     1,     1,     9,     0,     1,     0,     4,
       1,     0,     4,     3,     1,     0,     4,     2,     3,     4,
       4,     8,     8,     6,     1,     1,     1,     1,     1,     5,
       0,     1,     1,     0,     5,     2,     2,     2,     0,     5,
       6,     1,     0,     1,     2,     0,     2,     3,     1,     1,
       3,     1,     2,     4,     0,     5,     1,     1,     1,     1,
       7,     0,     2,     1,     2,     0,     2,     2,     1,     4,
       3,     1,     1,     3,     2,     2,     2,     3,     3,     4,
       4,     4,     4,     4,     0,     2,     2,     0,     2,     3,
       1,     2,     1,     1,     1,     1,     5,     0,     1,     1,
       1,     4,     4,     4,     4,     1,     6,     6,     7,     4,
       6,     4,     6,     4,     0,     6,     1,     2,     2,     0,
       2,     6,     2,     2,     3,     0,     1,     5,     2,     0,
       1,     2,     3,     1,     2,     1,     1,     1,     0,    10,
       0,     1,     1,     3,     1,     0,     3,     0,     2,     2,
       0,     5,     3,     1,     1,     0,     2,     2,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     5,     0,
       1,     1,     4,     7,     9,     0,     3,     0,     2,     0,
       2,     3,     5,     5,     1,     1,     1,     1,     3,     5,
       0,     2,     1,     1,     1,     4,     2,     2,     4,     1,
       1,     1,     1,     1,     1,     1,     4,     0,     2,     2,
       2,     2,     1,     2,     1,     0,     0,     5,     0,     2,
       2,     1,     0,     5,     0,     2,     4,     3,     4,     0,
       1,     1,     1,     2,     4,     4,     4,     4,     4,     4,
       4,     4,     4,     4,     4,    11,     0,     1,     1,     2,
       4,     4,     4,     6,     4,     3,     4,     0,     1,     1,
       1,     2,     4,     4,     4,     4,     4,     4,     6,     1,
       0,     0,     5,     0,     0,     2,     2,     3,     1,     1,
       1,     0,     4,     3,     2,     2,     0,     1,     1,     1,
       1,     0,     2,     1,     2,     3,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       6,     0,     2,     0,     4,     0,     1,     5,     0,     7,
       2,     2,     1,     3,     1,     1,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     0,     1,     1,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     3,     0,     1,     3,     3,     3,     0,     1,
       3,     0,     2,     0,     1,     2,     0,     4,     1,     2,
       1,     1,     0,     4,     1,     1,     3,     1,     1,     1,
       1,     0,     3,     0,     5,     3,     1,     0,     2,     1,
       3,     2,     3,     3,     3,     2,     3,     0,     2,     1,
       1,     1,     1,     1,     1,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     3,     2,     1,     3,     3,     4,     3,     3,
       3,     4,     3,     3,     1,     1,     1,     1,     1,     1,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     0,     2,
       0,     2,     3,     0,     1,     2,     3,     0,     2,     0,
       1,     1,     1,     1,     0,     1,     1,     1,     1,     1,
       1,     0,     1,     3,     3,     2,     6,     0,     2,     6,
       8,     7,     0,     2,     0,     2,     0,     2,     0,     3,
       0,     3,     0,     1,     0,     2,     0,     3,     1,     1,
       1,     1,     2,     4,     1,     1,     0,     1,     3,     1,
       2,     1,     2,     2,     0,     1,     1,     3,     1,     3,
       3,     4,     4,     3,     1,     2,     3,     4,     4,     2,
       0,     2,     3,     0,     1,     3,     3,     1,     3,     2,
       2,     1,     2,     1,     2,     0,     4,     1,     1,     2,
       3,     1,     0,     1,     1,     4,     3,     1,     1,     0,
       2,     7,     2,     3,     0,     2,     2,     2,     3,     1,
       1,     3,     1,     1,     1,     1,     1,     1,     1,     3,
       3,     3,     2,     2,     2,     4,     1,     0,     0,     5,
       1,     0,     0,     5,     0,     0,     0,     6,     0,     2,
       0,     0,     7,     0,     2,     2,     2,     4,     1,     1,
       2,     2,     1,     1,     1,     1,     2,     1,     4,     2,
       1,     3,     2,     1,     1,     0,     2,     1,     1,     1,
       1,     1,     3,     3,     4,     4,     4,     3,     0,     2,
       0,     5,     3,     0,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     3,     1,     1,     3,     3,     1,     1,     1,
       0,     2,     2,     0,     2,     0,     2,     2,     1,     3,
       1,     2,     1,     1,     1,     1,     4,     0,     3,     2,
       1,     1,     3,     4,     5,     4,     5,     1,     1,     0,
       2,     1,     1,     1,     2,     1,     2,     3,     0,     2,
       0,     2,     2,     3,     2,     0,     2,     1,     2,     2,
       4,     0,     1,     1,     1,     1,     2,     1,     1,     2,
       1,     4,     2,     0,     0,     0,     6,     0,     1,     2,
       3,     1,     0,     4,     0,     0,     7,     3,     0,     2,
       2,     2,     1,     1,     2,     2,     1,     1,     1,     1,
       1,     1,     1,     3,     3,     3,     3,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     4,     1,     1,
       2,     3,     2,     2,     2,     3,     3,     3,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     2,     2,     2,
       0,     2,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     0,     1,     1,     2,     1,     3,
       5,     3,     2,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     3,     3,     1,     2,     3,     3,     3,
       1,     2,     1,     2,     0,     1,     1,     1,     1,     1,
       1,     1,     2,     1,     1,     0,     1,     4,     0,     1,
       1,     4,     0,     1,     1,     3,     2,     0,     2,     0,
       1,     0,     0,     0,     0,    13,     0,     4,     0,     0,
       3,     0,     3,     1,     2,     5,     0,     2,     2,     0,
       1,     3,     3,     4,     2,     1,     3,     0,     5,     0,
       1,     0,     2,     2,     0,     0,     0,     0,     9,     0,
       2,     1,     1,     0,     3,     1,     1,     1,     1,     0,
       6,     0,     2,     2,     2,     0,     1,     0,     0,     3,
       0,     2,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     0,     3,
       2,     0,     4,     0,     4,     0,     5,     3,     3,     3,
       3,     4,     3,     4,     3,     3,     4,     4,     4,     3,
       3,     4,     3,     4,     5,     3,     4,     3,     3,     2,
       3,     1,     1,     0,     3,     0,     1,     5,     4,     4,
       1,     3,     3,     1,     1,     0,     1,     1,     2,     1,
       1,     1,     2,     3,     1,     2,     1,     3,     1,     2,
       2,     2,     2,     3,     3,     3,     1,     1,     1,     2,
       1,     1,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     4,     1,     1,     1,     1,
       4,     1,     2,     1,     1,     3,     3,     3,     3,     3,
       3,     4,     0,     1,     1,     2,     1,     1,     1,     1,
       1,     1,     1,     0,     1,     0,     4,     4,     5,     6,
       8,     0,     2,     0,     1,     0,     3,     4,     5,     0,
       2,     0,     2,     0,     3,     1,     2,     4,     0,     2,
       0,     4,     0,     9,     0,     0,     4,     1,     1,     1,
       0,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     0,     2,     1,     1,     0,     0,     3,     1,     2,
       2,     2,     3,     0,     2,     2,     2,     0,     3,     2,
       2,     4,     1,     1,     1,     1,     0,     2,     2,     0,
       1,     2,     2,     0,     1,     2,     0,     1,     0,     3,
       1,     1,     1,     2,     1,     1,     0,     3,     1,     1,
       2,     3,     0,     1,     3,     3,     2,     0,     4,     0,
       3,     0,     4,     4,     0,     1,     1,     0,     3,     0,
       0,     4,     0,     3,     2,     1,     0,     4,     4,     3,
       1,     2,     0,     1,     0,     3,     3,     0,     3,     0,
       2,     1,     2,     1,     0,     4,     3,     3,     3,     3,
       2,     4,     1,     1,     1,     1,     1,     1,     2,     1,
       1,     2,     0,     3,     1,     1,     0,     2,     1,     2,
       1,     2,     1,     2,     1,     1,     2,     0,     1,     2,
       2,     2,     2,     1,     1,     0,     3,     2,     0,     3,
       1,     2,     1,     1,     1,     0,     5,     0,     1,     1,
       2,     3,     3,     3,     3,     2,     0,     0,     5,     1,
       1,     0,     0,     7,     0,     5,     1,     1,     1,     0,
       1,     0,     2,     1,     2,     1,     1,     2,     1,     2,
       1,     5,     1,     1,     1,     2,     1,     1,     0,     1,
       1,     1,     1,     0,     1,     3,     3,     1,     1,     4,
       3,     1,     2,     2,     1,     1,     2,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     3,     1,     3,
       3,     3,     3,     3,     0,     1,     0,     4,     4,     6,
       6,     8,     8,     0,     1,     0,     3,     1,     0,     3,
       0,     6,     4,     1,     0,     4,     2,     1,     3,     1,
       1,     1,     2,     1,     1,     2,     2,     2,     2,     3,
       3,     3,     0,     3,     0,     4,     1,     3,     2,     1,
       1,     1,     1,     0,     2,     0,     1,     0,     3,     0,
       7,     0,     1,     0,     1,     0,     1,     1,     2,     1,
       1,     0,     3,     0,     2,     1,     2,     1,     1,     1,
       0,     2,     2,     3,     0,     3,     1,     0,     3,     1,
       0,     3,     3,     4,     0,     3,     0,     3,     0,     6,
       5,     3,     2,     0,     1,     0,     0,     0,     1,     0,
       3,     5,     0,     2,     0,     3,     3,     0,     2,     1,
       2,     4,     1,     1,     1,     1,     1,     1,     1,     0,
       3,     0,     3,     1,     2,     0,     3,     2,     2,     0,
       3,     3,     0,     1,     1,     1,     1,     2,     1,     1,
       1,     0,     4,     0,     5,     5,     1,     1,     2,     1,
       1,     1,     2,     0,     3,     1,     1,     0,     3,     2,
       5,     1,     2,     2,     2,     1,     1,     1,     2,     1,
       2,     4,     2,     0,     1,     1,     1,     1,     4,     0,
       1,     1,     2,     2,     3,     3,     1,     0,     5,     0,
       0,     9,     0,     2,     1,     2,     1,     0,     1,     0,
       5,     7,     0,     2,     0,     3,     0,     4,     2,     2,
       0,     1,     0,     3,     3,     4,     0,     4,     4,     6,
       0,     1,     0,     3,     1,     2,     6,     0,     1,     1,
       1,     1,     1,     0,     3,     0,     1,     1,     2,     1,
       2,     2,     1,     1,     1,     2,     1,     1,     1,     1,
       1,     3,     1,     1,     1,     1,     0,     3,     4,     0,
       6,     0,     5,     0,     1,     1,     1,     1,     3,     0,
       2,     1,     3,     3,     0,     3,     1,     1,     1,     3,
       6,     0,     2,     0,     3,     0,     3,     2,     1,     1,
       0,     4,     7,     0,     2,     0,     1,     2,     1,     2,
       3,     3,     1,     0,     1,     1,     4,     4,     2,     0,
       1,     1,     3,     2,     0,     3,     1,     1,     0,     1,
       1,     0,     4,     5,     1,     1,     0,     2,     2,     0,
       1,     2,     0,     1,     2,     0,     1,     0,     3,     2,
       1,     0,     4,     4,     0,     1,     0,     4,     5,     0,
       1,     2,     3,     0,     1,     1,     1,     0,     4,     0,
       5,     4,     5,     0,     2,     0,     3,     0,     1,     2,
       3,     0,     2,     0,     0,     3,     2,     1,     5,     1,
       0,     1,     2,     2,     5,     2,     2,     2,     2,     0,
       2,     0,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     4,     3,     1,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     4,     7,     7,
       3,     5,     4,     1,     2,     3,     1,     2,     3,     3,
       4,     4,     0,     3,     0,     7,     0,     5,     0,     2,
       0,     3,     0,     1,     0,     2,     4,     0,     2,     4,
       0,     4,     4,     0,     3,     0,     4,     1,     1,     1,
       2,     2,     2,     2,     1,     2,     1,     0,     1,     1,
       0,     4,     2,     2,     2,     0,     2,     1,     4,     4,
       0,     1,     1,     1,     1,     1,     1,     1,     0,     4,
       5,     0,     2,     1,     2,     2,     0,     3,     1,     1,
       0,     4,     0,     1,     0,     4,     4,     6,     6,     8,
       0,     1,     0,     3,     0,     1,     0,     3,     1,     2,
       0,     3,     6,     0,     3,     2,     0,     4,     6,     0,
       3,     1,     3,     2,     2,     2,     3,     0,     3,     0,
       3,     0,     1,     0,     3,     1,     2,     0,     3,     1,
       1,     1,     1,     1,     7,     0,     1,     1,     1,     1,
       1,     1,     4,     1,     2,     1,     2,     3,     0,     1,
       2,     1,     3,     1,     1,     4,     2,     1,     2,     1,
       2,     1,     1,     0,     4,     6,     0,     2,     0,     4,
       3,     3,     1,     1,     0,     1,     1,     0,     1,     1,
       0,     5,     0,     0,    12,     0,     1,     1,     2,     2,
       2,     1,     1,     0,     4,     0,     3,     0,     3,     1,
       2,     3,     0,     3,     1,     2,     3,     3,     0,     3,
       1,     2,     3,     0,     1,     1,     1,     1,     0,     2,
       1,     2,     1,     2,     2,     2,     2,     1,     1,     3,
       0,     1,     0,     5,     0,    10,     0,     3,     0,     2,
       0,     3,     1,     2,     0,     2,     2,     0,     1,     3,
       1,     1,     0,     1,     2,     1,     1,     0,     2,     2,
       0,     1,     2,     0,     1,     2,     0,     2,     2,     0,
       1,     2,     0,     1,     2,     0,     2,     2,     0,     1,
       2,     0,     1,     2,     2,     2,     2,     2,     0,     1,
       2,     0,     1,     2,     2,     2,     0,     1,     2,     0,
       1,     2,     0,     1,     2,     2,     0,     1,     2,     0,
       1,     2,     0,     2,     0,     3,     2,     1,     0,     2,
       0,     3,     1,     1,     1,     0,     2,     1,     2,     1,
       2,     3,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     0,     2,     1,     2,     1,     1,
       2,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     1,     1,
       1,     1,     1,     1,     1,     3,     0,     1,     1,     3,
       3,     1,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     1,     3,     1,     2,     2,     2,     1,     3,     1,
       1,     3,     1,     3,     1,     3,     1,     2,     2,     1,
       1,     2,     1,     1,     2,     2,     3,     1,     1,     1,
       1,     2,     1,     1,     2,     1,     0,     2,     1,     1,
       1,     3,     1,     1,     2,     1,     0,     1,     1,     2,
       1,     1,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     1,     1,     3,     0,     1,     1,     2,     1,
       1,     1,     1,     1,     1,     1,     2,     2,     2,     4,
       3,     1,     1,     1,     2,     1,     1,     1,     1,     1,
       1,     1,     2,     2,     2,     1,     1,     1,     2,     2,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     1,     1,     1,     1,     1,     1,     3,     2,
       2,     1,     1,     2,     1,     2,     1,     1,     1,     3,
       2,     2,     1,     0,     1,     1,     1,     3,     0,     2,
       1,     3,     3,     4,     5,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       1,     3,     1,     1,     1,     1,     1,     1,     2,     5,
       5,     5,     5,     6,     5,     5,     5,     5,     5,     5,
       3,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     0,     4,     5,     0,     3,     2,     1,
       3,     3,     0,     2,     1,     3,     1,     3,     1,     3,
       1,     3,     0,     0,     1,     0,     3,     2,     0,     1,
       0,     2,     0,     2,     0,     1,     1,     0,     1,     0,
       1,     2,     0,     2,     0,     3,     1,     1,     1,     1,
       1,     1,     1,     1,     0,     2,     0,     5,     0,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       0,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       0,     1,     0,     1,     0,     1,     0,     1,     0,     1,
       1,     0,     1,     0,     1,     0,     1,     0,     1,     0,
       1,     0,     1,     0,     1,     0,     1,     0,     1,     0,
       1,     0,     1,     0,     1,     0,     1,     0,     3,     0,
       1,     0,     1,     0,     1,     0,     1,     0,     1,     0,
       1,     1,     0,     1,     2,     0,     1,     0,     1,     0,
       1,     0,     1,     0,     1,     0,     1,     1,     0,     1,
       1,     0,     1,     1,     1,     0,     1,     1,     0,     1,
       0,     1,     0,     1,     1,     0,     2,     2,     0,     1,
       0,     1,     0,     1,     0,     1,     0,     1,     0,     1,
       1,     1,     0,     1,     0,     1,     0,     1,     1,     0,
       2,     1,     1,     0,     1,     0,     1,     0,     1,     0,
       1,     0,     1,     0,     1,     0,     1,     1,     0,     1,
       0,     1,     0,     1,     0,     1,     2,     0,     1,     0,
       1,     0,     1,     0,     1,     0,     1,     0,     1,     0,
       1,     0,     1,     0,     1,     0,     1,     0,     1,     0,
       3,     0,     1,     0,     1,     1,     0,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     1,     2,     1,     2,
       1,     2,     1,     2,     1,     2,     1,     2,     2
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)

/* This macro is provided for backward compatibility. */
# ifndef YY_LOCATION_PRINT
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif


# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yykind < YYNTOKENS)
    YYPRINT (yyo, yytoknum[yykind], *yyvaluep);
# endif
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)]);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


/* Context of a parse error.  */
typedef struct
{
  yy_state_t *yyssp;
  yysymbol_kind_t yytoken;
} yypcontext_t;

/* Put in YYARG at most YYARGN of the expected tokens given the
   current YYCTX, and return the number of tokens stored in YYARG.  If
   YYARG is null, return the number of expected tokens (guaranteed to
   be less than YYNTOKENS).  Return YYENOMEM on memory exhaustion.
   Return 0 if there are more than YYARGN expected tokens, yet fill
   YYARG up to YYARGN. */
static int
yypcontext_expected_tokens (const yypcontext_t *yyctx,
                            yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  int yyn = yypact[+*yyctx->yyssp];
  if (!yypact_value_is_default (yyn))
    {
      /* Start YYX at -YYN if negative to avoid negative indexes in
         YYCHECK.  In other words, skip the first -YYN actions for
         this state because they are default actions.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;
      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yyx;
      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
        if (yycheck[yyx + yyn] == yyx && yyx != YYSYMBOL_YYerror
            && !yytable_value_is_error (yytable[yyx + yyn]))
          {
            if (!yyarg)
              ++yycount;
            else if (yycount == yyargn)
              return 0;
            else
              yyarg[yycount++] = YY_CAST (yysymbol_kind_t, yyx);
          }
    }
  if (yyarg && yycount == 0 && 0 < yyargn)
    yyarg[0] = YYSYMBOL_YYEMPTY;
  return yycount;
}




#ifndef yystrlen
# if defined __GLIBC__ && defined _STRING_H
#  define yystrlen(S) (YY_CAST (YYPTRDIFF_T, strlen (S)))
# else
/* Return the length of YYSTR.  */
static YYPTRDIFF_T
yystrlen (const char *yystr)
{
  YYPTRDIFF_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
# endif
#endif

#ifndef yystpcpy
# if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#  define yystpcpy stpcpy
# else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
# endif
#endif

#ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYPTRDIFF_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYPTRDIFF_T yyn = 0;
      char const *yyp = yystr;
      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            else
              goto append;

          append:
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (yyres)
    return yystpcpy (yyres, yystr) - yyres;
  else
    return yystrlen (yystr);
}
#endif


static int
yy_syntax_error_arguments (const yypcontext_t *yyctx,
                           yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yyctx->yytoken != YYSYMBOL_YYEMPTY)
    {
      int yyn;
      if (yyarg)
        yyarg[yycount] = yyctx->yytoken;
      ++yycount;
      yyn = yypcontext_expected_tokens (yyctx,
                                        yyarg ? yyarg + 1 : yyarg, yyargn - 1);
      if (yyn == YYENOMEM)
        return YYENOMEM;
      else
        yycount += yyn;
    }
  return yycount;
}

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return -1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return YYENOMEM if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYPTRDIFF_T *yymsg_alloc, char **yymsg,
                const yypcontext_t *yyctx)
{
  enum { YYARGS_MAX = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat: reported tokens (one for the "unexpected",
     one per "expected"). */
  yysymbol_kind_t yyarg[YYARGS_MAX];
  /* Cumulated lengths of YYARG.  */
  YYPTRDIFF_T yysize = 0;

  /* Actual size of YYARG. */
  int yycount = yy_syntax_error_arguments (yyctx, yyarg, YYARGS_MAX);
  if (yycount == YYENOMEM)
    return YYENOMEM;

  switch (yycount)
    {
#define YYCASE_(N, S)                       \
      case N:                               \
        yyformat = S;                       \
        break
    default: /* Avoid compiler warnings. */
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
#undef YYCASE_
    }

  /* Compute error message size.  Don't count the "%s"s, but reserve
     room for the terminator.  */
  yysize = yystrlen (yyformat) - 2 * yycount + 1;
  {
    int yyi;
    for (yyi = 0; yyi < yycount; ++yyi)
      {
        YYPTRDIFF_T yysize1
          = yysize + yytnamerr (YY_NULLPTR, yytname[yyarg[yyi]]);
        if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
          yysize = yysize1;
        else
          return YYENOMEM;
      }
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return -1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yytname[yyarg[yyi++]]);
          yyformat += 2;
        }
      else
        {
          ++yyp;
          ++yyformat;
        }
  }
  return 0;
}


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep)
{
  YY_USE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/* Lookahead token kind.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;




/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYPTRDIFF_T yymsg_alloc = sizeof yymsgbuf;

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */
  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    goto yyexhaustedlab;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          goto yyexhaustedlab;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex ();
    }

  if (yychar <= TOKEN_EOF)
    {
      yychar = TOKEN_EOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 2: /* $@1: %empty  */
#line 3451 "../../cobc/parser.y"
  {
	clear_initial_values ();
	defined_prog_list = NULL;
	cobc_cs_check = 0;
	main_flag_set = 0;

	current_program = cb_build_program (NULL, 0);

	backup_source_file = cb_source_file;
	cb_source_file = "register-definition";
	cb_set_intr_when_compiled ();
	cb_build_registers ();
	cb_add_external_defined_registers ();
	cb_source_file = backup_source_file;
  }
#line 15227 "parser.c"
    break;

  case 3: /* start: $@1 compilation_group  */
#line 3467 "../../cobc/parser.y"
  {
	if (!current_program->flag_validated) {
		current_program->flag_validated = 1;
		cb_validate_program_body (current_program);
	}
	if (depth > 1) {
		cb_error (_("multiple PROGRAM-ID's without matching END PROGRAM"));
	}
	if (cobc_flag_main && !main_flag_set) {
		cb_error (_("executable requested but no program found"));
	}
	if (errorcount > 0) {
		YYABORT;
	}
	if (!current_program->entry_list) {
		emit_main_entry (current_program, NULL);
	}
  }
#line 15250 "parser.c"
    break;

  case 6: /* $@2: %empty  */
#line 3493 "../../cobc/parser.y"
  {
	first_prog = 1;
	depth = 0;
	setup_from_identification = 0;
  }
#line 15260 "parser.c"
    break;

  case 14: /* $@3: %empty  */
#line 3515 "../../cobc/parser.y"
  {
	program_init_without_program_id ();
  }
#line 15268 "parser.c"
    break;

  case 15: /* simple_prog: $@3 _program_body  */
#line 3520 "../../cobc/parser.y"
  {
	backup_current_pos ();
	clean_up_program (NULL, COB_MODULE_TYPE_PROGRAM);
  }
#line 15277 "parser.c"
    break;

  case 18: /* _end_program_list: %empty  */
#line 3546 "../../cobc/parser.y"
  {
	backup_current_pos ();
	clean_up_program (NULL, COB_MODULE_TYPE_PROGRAM);
  }
#line 15286 "parser.c"
    break;

  case 22: /* $@4: %empty  */
#line 3560 "../../cobc/parser.y"
  {
	check_area_a_of ("END PROGRAM");
	backup_current_pos ();
  }
#line 15295 "parser.c"
    break;

  case 23: /* end_program: "END PROGRAM" $@4 end_program_name _dot  */
#line 3565 "../../cobc/parser.y"
  {
	first_nested_program = 0;
	clean_up_program (yyvsp[-1], COB_MODULE_TYPE_PROGRAM);
  }
#line 15304 "parser.c"
    break;

  case 24: /* $@5: %empty  */
#line 3573 "../../cobc/parser.y"
  {
	backup_current_pos ();
  }
#line 15312 "parser.c"
    break;

  case 25: /* end_function: "END FUNCTION" $@5 end_program_name _dot  */
#line 3577 "../../cobc/parser.y"
  {
	clean_up_program (yyvsp[-1], COB_MODULE_TYPE_FUNCTION);
  }
#line 15320 "parser.c"
    break;

  case 26: /* $@6: %empty  */
#line 3587 "../../cobc/parser.y"
  {
	/* Error if program_id_name is a literal */

	/* Check that we either have no previous program or it was also a prototype */
	if (current_program->next_program && !current_program->flag_prototype) {
		/* Technically, prototypes must come before all other *source units*.  */
		cb_error (_("prototypes must be come before any program/function definitions"));
	}

	if (setup_program (yyvsp[-4], yyvsp[-3], COB_MODULE_TYPE_PROGRAM, 1)) {
		YYABORT;
	}
	setup_prototype (yyvsp[-4], yyvsp[-3], COB_MODULE_TYPE_PROGRAM, 1);
	cobc_cs_check = 0;
	cobc_in_id = 0;

	CB_UNFINISHED ("PROGRAM PROTOTYPE");

	/*
	 Must record:
	  * externalised name
	  * type of source unit (program/function/class/interface)
	  * description of parameters, whether they are BY REFERENCE or BY VALUE, whether they are OPTIONAL
	  * description of return item
	  * exceptions that may be raised
	  * entry convention
	  * object properties
	  * methods contained
	  * type declarations required
	  * whether DECIMAL-POINT IS COMMA is required
	  * CURRENCY SYMBOLS and their corresponding currency strings
	  * any external locales associated with linkage items
	 */
  }
#line 15359 "parser.c"
    break;

  case 27: /* $@7: %empty  */
#line 3622 "../../cobc/parser.y"
  {
	if (!current_program->entry_convention) {
		current_program->entry_convention = cb_int (CB_CONV_COBOL);
	}
  }
#line 15369 "parser.c"
    break;

  case 28: /* program_prototype: _identification_header program_id_header "." program_id_name _as_literal _is PROTOTYPE _dot $@6 _prototype_environment_division $@7 _prototype_data_division _prototype_procedure_division_header end_program  */
#line 3630 "../../cobc/parser.y"
  {
	cb_check_definition_matches_prototype (current_program);

	/* Write information to external repository, if permitted */
  }
#line 15379 "parser.c"
    break;

  case 29: /* $@8: %empty  */
#line 3642 "../../cobc/parser.y"
  {
	/* Error if program_id_name is a literal */

	if (setup_program (yyvsp[-4], yyvsp[-3], COB_MODULE_TYPE_FUNCTION, 1)) {
		YYABORT;
	}
	setup_prototype (yyvsp[-4], yyvsp[-3], COB_MODULE_TYPE_FUNCTION, 1);
	cobc_cs_check = 0;
	cobc_in_id = 0;

	CB_UNFINISHED ("FUNCTION PROTOTYPE");

	/*
	 Must record:
	  * externalised name
	  * type of source unit (program/function/class/interface)
	  * description of parameters, whether they are BY REFERENCE or BY VALUE, whether they are OPTIONAL
	  * description of return item
	  * exceptions that may be raised
	  * entry convention
	  * object properties
	  * methods contained
	  * type declarations required
	  * whether DECIMAL-POINT IS COMMA is required
	  * CURRENCY SYMBOLS and their corresponding currency strings
	  * any external locales associated with linkage items
	 */
  }
#line 15412 "parser.c"
    break;

  case 30: /* $@9: %empty  */
#line 3671 "../../cobc/parser.y"
  {
	if (!current_program->entry_convention) {
		current_program->entry_convention = cb_int (CB_CONV_COBOL);
	}
  }
#line 15422 "parser.c"
    break;

  case 31: /* function_prototype: _identification_header function_id_header "." program_id_name _as_literal _is PROTOTYPE _dot $@8 _prototype_environment_division $@9 _prototype_data_division _prototype_procedure_division_header end_function  */
#line 3679 "../../cobc/parser.y"
  {
	cb_check_definition_matches_prototype (current_program);

	/* Write information to external repository, if permitted */
  }
#line 15432 "parser.c"
    break;

  case 33: /* $@10: %empty  */
#line 3688 "../../cobc/parser.y"
            { check_area_a_of ("PROCEDURE DIVISION"); }
#line 15438 "parser.c"
    break;

  case 34: /* _prototype_procedure_division_header: PROCEDURE $@10 DIVISION _procedure_using_chaining _procedure_returning _dot  */
#line 3690 "../../cobc/parser.y"
  {
	cb_validate_parameters_and_returning (current_program, yyvsp[-2]);
	current_program->num_proc_params = cb_list_length (yyvsp[-2]);
	/* add pseudo-entry as it contains the actual USING parameters */
	emit_main_entry (current_program, yyvsp[-2]);
  }
#line 15449 "parser.c"
    break;

  case 35: /* control: CONTROL  */
#line 3700 "../../cobc/parser.y"
                 { check_area_a_of ("CONTROL DIVISION"); }
#line 15455 "parser.c"
    break;

  case 37: /* $@11: %empty  */
#line 3704 "../../cobc/parser.y"
  {
	  cb_verify (cb_control_division, "CONTROL DIVISION");
  }
#line 15463 "parser.c"
    break;

  case 40: /* $@12: %empty  */
#line 3712 "../../cobc/parser.y"
          { check_area_a_of ("DEFAULT SECTION"); }
#line 15469 "parser.c"
    break;

  case 41: /* _default_section: DEFAULT $@12 SECTION "." _default_clauses  */
#line 3715 "../../cobc/parser.y"
  {
	cobc_cs_check = 0;
  }
#line 15477 "parser.c"
    break;

  case 45: /* $@13: %empty  */
#line 3729 "../../cobc/parser.y"
          { check_non_area_a (yyvsp[0]); }
#line 15483 "parser.c"
    break;

  case 46: /* _default_accept_clause: ACCEPT $@13 _is word_or_terminal  */
#line 3731 "../../cobc/parser.y"
  {
	  CB_PENDING ("ACCEPT statement in DEFAULT SECTION");
	  /* TODO: setup_default_accept ($3); */
  }
#line 15492 "parser.c"
    break;

  case 48: /* $@14: %empty  */
#line 3739 "../../cobc/parser.y"
          { check_non_area_a (yyvsp[0]); }
#line 15498 "parser.c"
    break;

  case 49: /* _default_display_clause: DISPLAY $@14 _is word_or_terminal  */
#line 3741 "../../cobc/parser.y"
  {
	  CB_PENDING ("DISPLAY statement in DEFAULT SECTION");
	  /* TODO: setup_default_display ($3); */
  }
#line 15507 "parser.c"
    break;

  case 50: /* $@15: %empty  */
#line 3752 "../../cobc/parser.y"
  {
	cb_validate_program_environment (current_program);
  }
#line 15515 "parser.c"
    break;

  case 51: /* $@16: %empty  */
#line 3756 "../../cobc/parser.y"
  {
	/* note:
	   we also validate all references we found so far here */
	cb_validate_program_data (current_program);
	within_typedef_definition = 0;
  }
#line 15526 "parser.c"
    break;

  case 55: /* $@17: %empty  */
#line 3773 "../../cobc/parser.y"
                       { check_area_a_of ("IDENTIFICATION DIVISION"); }
#line 15532 "parser.c"
    break;

  case 56: /* identification_header: identification_or_id $@17 DIVISION _dot  */
#line 3775 "../../cobc/parser.y"
  {
	setup_program_start ();
	setup_from_identification = 1;
  }
#line 15541 "parser.c"
    break;

  case 59: /* program_id_header: "PROGRAM-ID"  */
#line 3788 "../../cobc/parser.y"
  {
	cobc_in_id = 1;
	save_tree = NULL;
  }
#line 15550 "parser.c"
    break;

  case 60: /* program_id_paragraph: program_id_header "." program_id_name _as_literal _program_type "."  */
#line 3796 "../../cobc/parser.y"
  {
	if (setup_program (yyvsp[-3], yyvsp[-2], COB_MODULE_TYPE_PROGRAM, 0)) {
		YYABORT;
	}


	setup_prototype (yyvsp[-3], yyvsp[-2], COB_MODULE_TYPE_PROGRAM, 1);

	if (yyvsp[-1]) {
		if (!current_program->nested_level) {
			cb_error (_("COMMON may only be used in a contained program"));
		} else {
			current_program->flag_common = 1;
			cb_add_common_prog (current_program);
		}
	}

	/* TODO: do that more clean, this and above was only moved here
	         to fix a shift/reduce conflict with program prototype */
	if (save_tree == cb_int1) {
		current_program->flag_initial = 1;
	} else if (save_tree == cb_int2) {
		current_program->flag_recursive = 1;
	}

	cobc_cs_check = 0;
	cobc_in_id = 0;
  }
#line 15583 "parser.c"
    break;

  case 61: /* function_id_header: "FUNCTION-ID"  */
#line 3828 "../../cobc/parser.y"
  {
	cobc_in_id = 1;
  }
#line 15591 "parser.c"
    break;

  case 62: /* function_id_paragraph: function_id_header "." program_id_name _as_literal "."  */
#line 3835 "../../cobc/parser.y"
  {
	if (setup_program (yyvsp[-2], yyvsp[-1], COB_MODULE_TYPE_FUNCTION, 0)) {
		YYABORT;
	}
	setup_prototype (yyvsp[-2], yyvsp[-1], COB_MODULE_TYPE_FUNCTION, 1);
	cobc_cs_check = 0;
	cobc_in_id = 0;
  }
#line 15604 "parser.c"
    break;

  case 63: /* program_id_name: "program name"  */
#line 3847 "../../cobc/parser.y"
  {
	if (CB_REFERENCE_P (yyvsp[0]) && CB_WORD_COUNT (yyvsp[0]) > 0) {
		redefinition_error (yyvsp[0]);
	}
	/*
	  The program name is a key part of defining the current_program, so we
	  mustn't lose it (unlike in undefined_word).
	*/
	yyval = yyvsp[0];
  }
#line 15619 "parser.c"
    break;

  case 64: /* program_id_name: "Literal"  */
#line 3858 "../../cobc/parser.y"
  {
	cb_trim_program_id (yyvsp[0]);
  }
#line 15627 "parser.c"
    break;

  case 66: /* end_program_name: "Literal"  */
#line 3866 "../../cobc/parser.y"
  {
	cb_trim_program_id (yyvsp[0]);
  }
#line 15635 "parser.c"
    break;

  case 67: /* _as_literal: %empty  */
#line 3872 "../../cobc/parser.y"
                                { yyval = NULL; }
#line 15641 "parser.c"
    break;

  case 68: /* _as_literal: AS "Literal"  */
#line 3873 "../../cobc/parser.y"
                                { yyval = yyvsp[0]; }
#line 15647 "parser.c"
    break;

  case 69: /* _program_type: %empty  */
#line 3877 "../../cobc/parser.y"
                                { yyval = NULL; }
#line 15653 "parser.c"
    break;

  case 70: /* _program_type: _is program_type_clause _program  */
#line 3878 "../../cobc/parser.y"
                                        { yyval = yyvsp[-1]; }
#line 15659 "parser.c"
    break;

  case 71: /* program_type_clause: COMMON  */
#line 3883 "../../cobc/parser.y"
  {
	yyval = cb_int1;
  }
#line 15667 "parser.c"
    break;

  case 72: /* program_type_clause: init_or_recurse_and_common  */
#line 3887 "../../cobc/parser.y"
  {
	yyval = cb_int2;
  }
#line 15675 "parser.c"
    break;

  case 74: /* program_type_clause: EXTERNAL  */
#line 3892 "../../cobc/parser.y"
  {
	CB_PENDING (_("CALL prototypes"));
  }
#line 15683 "parser.c"
    break;

  case 77: /* init_or_recurse: "INITIAL"  */
#line 3904 "../../cobc/parser.y"
  {
	save_tree = cb_int1;
  }
#line 15691 "parser.c"
    break;

  case 78: /* init_or_recurse: RECURSIVE  */
#line 3908 "../../cobc/parser.y"
  {
	save_tree = cb_int2;
  }
#line 15699 "parser.c"
    break;

  case 80: /* _options_paragraph: OPTIONS "." _options_clauses  */
#line 3917 "../../cobc/parser.y"
  {
	cobc_cs_check = 0;
  }
#line 15707 "parser.c"
    break;

  case 84: /* arithmetic_choice: NATIVE  */
#line 3937 "../../cobc/parser.y"
  {
/* FIXME: the IBM-compatible ARITHMETIC should only be disabled
          for the specified program (and its nested programs)
   note: ibm-strict.conf has no OPTIONS paragraph, but ibm.conf does */
	cb_arithmetic_osvs = 0;
  }
#line 15718 "parser.c"
    break;

  case 85: /* arithmetic_choice: STANDARD  */
#line 3944 "../../cobc/parser.y"
  {
	CB_PENDING ("STANDARD ARITHMETIC");
  }
#line 15726 "parser.c"
    break;

  case 86: /* arithmetic_choice: "STANDARD-BINARY"  */
#line 3948 "../../cobc/parser.y"
  {
	CB_PENDING ("STANDARD-BINARY ARITHMETIC");
  }
#line 15734 "parser.c"
    break;

  case 87: /* arithmetic_choice: "STANDARD-DECIMAL"  */
#line 3952 "../../cobc/parser.y"
  {
	CB_PENDING ("STANDARD-DECIMAL ARITHMETIC");
  }
#line 15742 "parser.c"
    break;

  case 88: /* _default_rounded_clause: %empty  */
#line 3967 "../../cobc/parser.y"
  {
	default_rounded_mode = cb_int (COB_STORE_ROUND);
  }
#line 15750 "parser.c"
    break;

  case 89: /* _default_rounded_clause: DEFAULT ROUNDED _mode _is round_choice  */
#line 3971 "../../cobc/parser.y"
  {
	if (yyvsp[0]) {
		default_rounded_mode = yyvsp[0];
	} else {
		default_rounded_mode = cb_int (COB_STORE_ROUND);
	}
  }
#line 15762 "parser.c"
    break;

  case 91: /* _entry_convention_clause: "ENTRY-CONVENTION" _is convention_type  */
#line 3983 "../../cobc/parser.y"
  {
	current_program->entry_convention = yyvsp[0];
  }
#line 15770 "parser.c"
    break;

  case 92: /* convention_type: COBOL  */
#line 3990 "../../cobc/parser.y"
  {
	yyval = cb_int (CB_CONV_COBOL);
  }
#line 15778 "parser.c"
    break;

  case 93: /* convention_type: "EXTERN"  */
#line 3994 "../../cobc/parser.y"
  {
	yyval = cb_int0;
  }
#line 15786 "parser.c"
    break;

  case 94: /* convention_type: STDCALL  */
#line 3998 "../../cobc/parser.y"
  {
	yyval = cb_int (CB_CONV_STDCALL);
  }
#line 15794 "parser.c"
    break;

  case 96: /* _intermediate_rounding_clause: INTERMEDIATE ROUNDING _is intermediate_rounding_choice  */
#line 4006 "../../cobc/parser.y"
  {
	CB_PENDING ("INTERMEDIATE ROUNDING");
  }
#line 15802 "parser.c"
    break;

  case 97: /* intermediate_rounding_choice: "NEAREST-AWAY-FROM-ZERO"  */
#line 4013 "../../cobc/parser.y"
  {
	yyval = cb_int (COB_STORE_ROUND | COB_STORE_NEAR_AWAY_FROM_ZERO);
  }
#line 15810 "parser.c"
    break;

  case 98: /* intermediate_rounding_choice: "NEAREST-EVEN"  */
#line 4017 "../../cobc/parser.y"
  {
	yyval = cb_int (COB_STORE_ROUND | COB_STORE_NEAR_EVEN);
  }
#line 15818 "parser.c"
    break;

  case 99: /* intermediate_rounding_choice: PROHIBITED  */
#line 4021 "../../cobc/parser.y"
  {
	yyval = cb_int (COB_STORE_ROUND | COB_STORE_PROHIBITED);
  }
#line 15826 "parser.c"
    break;

  case 100: /* intermediate_rounding_choice: TRUNCATION  */
#line 4025 "../../cobc/parser.y"
  {
	yyval = cb_int (COB_STORE_ROUND | COB_STORE_TRUNCATION);
  }
#line 15834 "parser.c"
    break;

  case 104: /* environment: ENVIRONMENT  */
#line 4042 "../../cobc/parser.y"
                         { check_area_a_of ("ENVIRONMENT DIVISION"); }
#line 15840 "parser.c"
    break;

  case 105: /* environment_header: environment DIVISION _dot  */
#line 4045 "../../cobc/parser.y"
  {
	header_check |= COBC_HD_ENVIRONMENT_DIVISION;
  }
#line 15848 "parser.c"
    break;

  case 109: /* configuration: CONFIGURATION  */
#line 4061 "../../cobc/parser.y"
                             { check_area_a_of ("CONFIGURATION SECTION"); }
#line 15854 "parser.c"
    break;

  case 110: /* configuration_header: configuration SECTION _dot  */
#line 4064 "../../cobc/parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION, 0, 0, 0);
	header_check |= COBC_HD_CONFIGURATION_SECTION;
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "CONFIGURATION SECTION");
	}
  }
#line 15866 "parser.c"
    break;

  case 122: /* $@18: %empty  */
#line 4099 "../../cobc/parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION, 0, 0);
	check_conf_section_order (COBC_HD_SOURCE_COMPUTER);
	set_conf_section_part (COBC_HD_SOURCE_COMPUTER);
  }
#line 15877 "parser.c"
    break;

  case 127: /* _with_debugging_mode: _with DEBUGGING MODE  */
#line 4115 "../../cobc/parser.y"
  {
	current_program->flag_debugging = 1;
	needs_debug_item = 1;
	cobc_cs_check = 0;
	cb_build_debug_item ();
  }
#line 15888 "parser.c"
    break;

  case 128: /* $@19: %empty  */
#line 4127 "../../cobc/parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION, 0, 0);
	check_conf_section_order (COBC_HD_OBJECT_COMPUTER);
	set_conf_section_part (COBC_HD_OBJECT_COMPUTER);
  }
#line 15899 "parser.c"
    break;

  case 129: /* object_computer_paragraph: "OBJECT-COMPUTER" _dot $@19 _object_computer_entry  */
#line 4134 "../../cobc/parser.y"
  {
	cobc_cs_check = 0;
  }
#line 15907 "parser.c"
    break;

  case 140: /* object_computer_memory: MEMORY _size _is integer object_char_or_word_or_modules  */
#line 4160 "../../cobc/parser.y"
  {
	cb_verify (cb_memory_size_clause, "MEMORY SIZE");
  }
#line 15915 "parser.c"
    break;

  case 141: /* object_computer_sequence: _program program_collating_sequence  */
#line 4168 "../../cobc/parser.y"
  {
	current_program->collating_sequence = alphanumeric_collation;
	current_program->collating_sequence_n = national_collation;
  }
#line 15924 "parser.c"
    break;

  case 142: /* $@20: %empty  */
#line 4176 "../../cobc/parser.y"
  {
	alphanumeric_collation = national_collation = NULL;
  }
#line 15932 "parser.c"
    break;

  case 144: /* program_coll_sequence_values: _is single_reference  */
#line 4184 "../../cobc/parser.y"
  {
	alphanumeric_collation = yyvsp[0];
  }
#line 15940 "parser.c"
    break;

  case 145: /* program_coll_sequence_values: _is single_reference single_reference  */
#line 4188 "../../cobc/parser.y"
  {
	alphanumeric_collation = yyvsp[-1];
	CB_PENDING_X (yyvsp[0], "NATIONAL COLLATING SEQUENCE");
	national_collation = yyvsp[0];
  }
#line 15950 "parser.c"
    break;

  case 146: /* program_coll_sequence_values: _for ALPHANUMERIC _is single_reference  */
#line 4194 "../../cobc/parser.y"
  {
	alphanumeric_collation = yyvsp[0];
  }
#line 15958 "parser.c"
    break;

  case 147: /* program_coll_sequence_values: _for NATIONAL _is single_reference  */
#line 4198 "../../cobc/parser.y"
  {
	CB_PENDING_X (yyvsp[0], "NATIONAL COLLATING SEQUENCE");
	national_collation = yyvsp[0];
  }
#line 15967 "parser.c"
    break;

  case 148: /* program_coll_sequence_values: _for ALPHANUMERIC _is single_reference _for NATIONAL _is single_reference  */
#line 4204 "../../cobc/parser.y"
  {
	alphanumeric_collation = yyvsp[-4];
	CB_PENDING_X (yyvsp[0], "NATIONAL COLLATING SEQUENCE");
	national_collation = yyvsp[0];
  }
#line 15977 "parser.c"
    break;

  case 149: /* program_coll_sequence_values: _for NATIONAL _is single_reference _for ALPHANUMERIC _is single_reference  */
#line 4211 "../../cobc/parser.y"
  {
	CB_PENDING_X (yyvsp[-4], "NATIONAL COLLATING SEQUENCE");
	national_collation = yyvsp[-4];
	alphanumeric_collation = yyvsp[0];
  }
#line 15987 "parser.c"
    break;

  case 150: /* object_computer_segment: "SEGMENT-LIMIT" _is integer  */
#line 4220 "../../cobc/parser.y"
  {
	if (cb_verify (cb_section_segments, "SEGMENT LIMIT")) {
		int segnum = cb_get_int (yyvsp[0]);
		if (segnum == 0 || segnum > 49) {
			cb_error (_("segment-number must be in range of values 1 to 49"));
			yyval = NULL;
		}
	}
	/* Ignore */
  }
#line 16002 "parser.c"
    break;

  case 151: /* object_computer_class: _character CLASSIFICATION _is locale_class  */
#line 4234 "../../cobc/parser.y"
  {
	if (current_program->classification) {
		cb_error (_("duplicate CLASSIFICATION clause"));
	} else {
		current_program->classification = yyvsp[0];
	}
  }
#line 16014 "parser.c"
    break;

  case 152: /* locale_class: single_reference  */
#line 4245 "../../cobc/parser.y"
  {
	yyval = yyvsp[0];
  }
#line 16022 "parser.c"
    break;

  case 153: /* locale_class: LOCALE  */
#line 4249 "../../cobc/parser.y"
  {
	yyval = NULL;
  }
#line 16030 "parser.c"
    break;

  case 154: /* locale_class: "USER-DEFAULT"  */
#line 4253 "../../cobc/parser.y"
  {
	yyval = cb_int1;
  }
#line 16038 "parser.c"
    break;

  case 155: /* locale_class: "SYSTEM-DEFAULT"  */
#line 4257 "../../cobc/parser.y"
  {
	yyval = cb_int1;
  }
#line 16046 "parser.c"
    break;

  case 160: /* $@21: %empty  */
#line 4274 "../../cobc/parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION, 0, 0);
	check_conf_section_order (COBC_HD_REPOSITORY);
	set_conf_section_part (COBC_HD_REPOSITORY);
  }
#line 16057 "parser.c"
    break;

  case 161: /* repository_paragraph: REPOSITORY _dot $@21 _repository_entry  */
#line 4281 "../../cobc/parser.y"
  {
	cobc_in_repository = 0;
  }
#line 16065 "parser.c"
    break;

  case 164: /* _repository_entry: repository_list error "."  */
#line 4290 "../../cobc/parser.y"
  {
	yyerrok;
  }
#line 16073 "parser.c"
    break;

  case 167: /* repository_name: FUNCTION ALL INTRINSIC  */
#line 4302 "../../cobc/parser.y"
  {
	functions_are_all = 1;
  }
#line 16081 "parser.c"
    break;

  case 168: /* repository_name: FUNCTION "Identifier" _as_literal  */
#line 4306 "../../cobc/parser.y"
  {
	if (yyvsp[-1] != cb_error_node) {
		setup_prototype (yyvsp[-1], yyvsp[0], COB_MODULE_TYPE_FUNCTION, 0);
	}
  }
#line 16091 "parser.c"
    break;

  case 170: /* repository_name: PROGRAM "Identifier" _as_literal  */
#line 4313 "../../cobc/parser.y"
  {
	  if (yyvsp[-1] != cb_error_node
	      && cb_verify (cb_program_prototypes, _("PROGRAM phrase"))) {
		setup_prototype (yyvsp[-1], yyvsp[0], COB_MODULE_TYPE_PROGRAM, 0);
	}
  }
#line 16102 "parser.c"
    break;

  case 171: /* repository_name: FUNCTION repository_name_list error  */
#line 4320 "../../cobc/parser.y"
  {
	yyerrok;
  }
#line 16110 "parser.c"
    break;

  case 172: /* repository_name_list: "intrinsic function name"  */
#line 4327 "../../cobc/parser.y"
  {
	current_program->function_spec_list =
		cb_list_add (current_program->function_spec_list, yyvsp[0]);
  }
#line 16119 "parser.c"
    break;

  case 173: /* repository_name_list: repository_name_list "intrinsic function name"  */
#line 4332 "../../cobc/parser.y"
  {
	current_program->function_spec_list =
		cb_list_add (current_program->function_spec_list, yyvsp[0]);
  }
#line 16128 "parser.c"
    break;

  case 174: /* special_names_header: "SPECIAL-NAMES" _dot  */
#line 4343 "../../cobc/parser.y"
  {
	check_duplicate = 0;
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION, 0, 0);
	check_conf_section_order (COBC_HD_SPECIAL_NAMES);
	set_conf_section_part (COBC_HD_SPECIAL_NAMES);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	}
	cobc_cs_check = CB_CS_SPECIAL_NAMES;
  }
#line 16144 "parser.c"
    break;

  case 194: /* $@22: %empty  */
#line 4390 "../../cobc/parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	check_duplicate = 0;
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
		save_tree = NULL;
	} else {
		/* lookup system name with special translation
		   note: result in NULL + raised error if not found */
		save_tree = get_system_name_translated (yyvsp[0]);
	}
  }
#line 16163 "parser.c"
    break;

  case 196: /* word_or_terminal: "Identifier"  */
#line 4408 "../../cobc/parser.y"
           { yyval = yyvsp[0]; }
#line 16169 "parser.c"
    break;

  case 197: /* word_or_terminal: TERMINAL  */
#line 4410 "../../cobc/parser.y"
           { yyval = cb_build_reference ("TERMINAL"); }
#line 16175 "parser.c"
    break;

  case 198: /* mnemonic_choices: _is CRT  */
#line 4414 "../../cobc/parser.y"
  {
	if (save_tree) {
		if (CB_SYSTEM_NAME(save_tree)->token != CB_DEVICE_CONSOLE) {
			cb_error_x (save_tree, _("invalid %s clause"), "");
		} else {
			current_program->flag_console_is_crt = 1;
		}
	}
  }
#line 16189 "parser.c"
    break;

  case 199: /* mnemonic_choices: integer _is undefined_word  */
#line 4425 "../../cobc/parser.y"
  {
	if (save_tree) {
		if (CB_SYSTEM_NAME(save_tree)->token != CB_FEATURE_CONVENTION) {
			cb_error_x (save_tree, _("invalid %s clause"), "SPECIAL NAMES");
		} else if (CB_VALID_TREE (yyvsp[0])) {
			const char *name = CB_NAME (yyvsp[0]);
			CB_SYSTEM_NAME(save_tree)->value = yyvsp[-2];
			cb_define (yyvsp[0], save_tree);
			CB_CHAIN_PAIR (current_program->mnemonic_spec_list,
					yyvsp[0], save_tree);
			/* remove non-standard context-sensitive words when identical to mnemonic */
			if (cb_strcasecmp (name, "EXTERN" ) == 0
			 || cb_strcasecmp (name, "STDCALL") == 0
			 || cb_strcasecmp (name, "WINAPI") == 0
			 || cb_strcasecmp (name, "STATIC" ) == 0
			 || cb_strcasecmp (name, "C"      ) == 0
			 || cb_strcasecmp (name, "PASCAL" ) == 0) {
				remove_context_sensitivity (name, CB_CS_CALL);
			}
		}
	}
  }
#line 16216 "parser.c"
    break;

  case 200: /* mnemonic_choices: _is undefined_word _special_name_mnemonic_on_off  */
#line 4448 "../../cobc/parser.y"
  {
	if (save_tree && CB_VALID_TREE (yyvsp[-1])) {
		cb_define (yyvsp[-1], save_tree);
		CB_CHAIN_PAIR (current_program->mnemonic_spec_list,
				yyvsp[-1], save_tree);
	}
  }
#line 16228 "parser.c"
    break;

  case 204: /* on_off_clauses: on_off_clauses_1  */
#line 4464 "../../cobc/parser.y"
  {
	  check_on_off_duplicate = 0;
  }
#line 16236 "parser.c"
    break;

  case 205: /* on_off_clauses_1: on_or_off _onoff_status undefined_word  */
#line 4471 "../../cobc/parser.y"
  {
	cb_tree		x;

	/* cb_define_switch_name checks param validity */
	x = cb_define_switch_name (yyvsp[0], save_tree, yyvsp[-2] == cb_int1);
	if (x) {
		if (yyvsp[-2] == cb_int1) {
			check_repeated ("ON", SYN_CLAUSE_1, &check_on_off_duplicate);
		} else {
			check_repeated ("OFF", SYN_CLAUSE_2, &check_on_off_duplicate);
		}
		CB_CHAIN_PAIR (current_program->mnemonic_spec_list, yyvsp[0], x);
	}
  }
#line 16255 "parser.c"
    break;

  case 206: /* on_off_clauses_1: on_off_clauses_1 on_or_off _onoff_status undefined_word  */
#line 4486 "../../cobc/parser.y"
  {
	cb_tree		x;

	/* cb_define_switch_name checks param validity */
	x = cb_define_switch_name (yyvsp[0], save_tree, yyvsp[-2] == cb_int1);
	if (x) {
		if (yyvsp[-2] == cb_int1) {
			check_repeated ("ON", SYN_CLAUSE_1, &check_on_off_duplicate);
		} else {
			check_repeated ("OFF", SYN_CLAUSE_2, &check_on_off_duplicate);
		}
		CB_CHAIN_PAIR (current_program->mnemonic_spec_list, yyvsp[0], x);
	}
  }
#line 16274 "parser.c"
    break;

  case 207: /* @23: %empty  */
#line 4506 "../../cobc/parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
		yyval = NULL;
	} else {
		/* Returns null on error */
		yyval = cb_build_alphabet_name (yyvsp[0]);
	}
  }
#line 16291 "parser.c"
    break;

  case 208: /* alphabet_name_clause: ALPHABET undefined_word @23 alphabet_definition  */
#line 4519 "../../cobc/parser.y"
  {
	if (yyvsp[-1]) {
		current_program->alphabet_name_list =
			cb_list_add (current_program->alphabet_name_list, yyvsp[-1]);
	}
	cobc_cs_check = 0;
  }
#line 16303 "parser.c"
    break;

  case 209: /* @24: %empty  */
#line 4530 "../../cobc/parser.y"
  {
	yyval = yyvsp[-1];
	if (yyvsp[-1]) {
		CB_ALPHABET_NAME (yyvsp[-1])->alphabet_target = CB_ALPHABET_ALPHANUMERIC;
	}
  }
#line 16314 "parser.c"
    break;

  case 211: /* @25: %empty  */
#line 4538 "../../cobc/parser.y"
  {
	yyval = yyvsp[-1];
	if (yyvsp[-1]) {
		CB_ALPHABET_NAME(yyvsp[-1])->alphabet_target = CB_ALPHABET_NATIONAL;
	}
  }
#line 16325 "parser.c"
    break;

  case 217: /* alphabet_type_alphanumeric: "STANDARD-1"  */
#line 4559 "../../cobc/parser.y"
  {
	if (yyvsp[(-1) - (1)]) {
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_ASCII;
	}
  }
#line 16335 "parser.c"
    break;

  case 218: /* alphabet_type_alphanumeric: "STANDARD-2"  */
#line 4565 "../../cobc/parser.y"
  {
	if (yyvsp[(-1) - (1)]) {
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_ASCII;
	}
  }
#line 16345 "parser.c"
    break;

  case 219: /* alphabet_type_alphanumeric: EBCDIC  */
#line 4571 "../../cobc/parser.y"
  {
	if (yyvsp[(-1) - (1)]) {
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_EBCDIC;
	}
  }
#line 16355 "parser.c"
    break;

  case 220: /* alphabet_type_alphanumeric: ASCII  */
#line 4577 "../../cobc/parser.y"
  {
	if (yyvsp[(-1) - (1)]) {
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_ASCII;
	}
  }
#line 16365 "parser.c"
    break;

  case 222: /* alphabet_type_national: "UCS-4"  */
#line 4587 "../../cobc/parser.y"
  {
	if (yyvsp[(-1) - (1)]) {
		CB_PENDING_X (yyvsp[(-1) - (1)], "ALPHABET UCS-4");
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_UCS_4;
	}
  }
#line 16376 "parser.c"
    break;

  case 223: /* alphabet_type_national: "UTF-8"  */
#line 4594 "../../cobc/parser.y"
  {
	if (yyvsp[(-1) - (1)]) {
		CB_PENDING_X (yyvsp[(-1) - (1)], "ALPHABET UTF-8");
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_UTF_8;
	}
  }
#line 16387 "parser.c"
    break;

  case 224: /* alphabet_type_national: "UTF-16"  */
#line 4601 "../../cobc/parser.y"
  {
	if (yyvsp[(-1) - (1)]) {
		CB_PENDING_X (yyvsp[(-1) - (1)], "ALPHABET UTF-16");
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_UTF_16;
	}
  }
#line 16398 "parser.c"
    break;

  case 225: /* alphabet_type_common: NATIVE  */
#line 4611 "../../cobc/parser.y"
  {
	if (yyvsp[(-1) - (1)]) {
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_NATIVE;
	}
  }
#line 16408 "parser.c"
    break;

  case 226: /* alphabet_type_common: LOCALE single_reference  */
#line 4617 "../../cobc/parser.y"
  {
	if (yyvsp[(-1) - (2)]) {
		CB_ALPHABET_NAME (yyvsp[(-1) - (2)])->alphabet_type = CB_ALPHABET_LOCALE;
		CB_ALPHABET_NAME (yyvsp[(-1) - (2)])->custom_list = yyvsp[0];
		CB_PENDING_X (yyvsp[(-1) - (2)], "LOCALE ALPHABET");
	}
  }
#line 16420 "parser.c"
    break;

  case 227: /* alphabet_type_common: alphabet_literal_list  */
#line 4625 "../../cobc/parser.y"
  {
	if (yyvsp[(-1) - (1)]) {
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_CUSTOM;
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->custom_list = yyvsp[0];
	}
  }
#line 16431 "parser.c"
    break;

  case 228: /* alphabet_literal_list: alphabet_literal  */
#line 4635 "../../cobc/parser.y"
  {
	yyval = CB_LIST_INIT (yyvsp[0]);
  }
#line 16439 "parser.c"
    break;

  case 229: /* alphabet_literal_list: alphabet_literal_list alphabet_literal  */
#line 4639 "../../cobc/parser.y"
  {
	yyval = cb_list_add (yyvsp[-1], yyvsp[0]);
  }
#line 16447 "parser.c"
    break;

  case 230: /* alphabet_literal: alphabet_lits  */
#line 4646 "../../cobc/parser.y"
  {
	yyval = yyvsp[0];
  }
#line 16455 "parser.c"
    break;

  case 231: /* alphabet_literal: alphabet_lits THRU alphabet_lits  */
#line 4650 "../../cobc/parser.y"
  {
	yyval = CB_BUILD_PAIR (yyvsp[-2], yyvsp[0]);
  }
#line 16463 "parser.c"
    break;

  case 232: /* @26: %empty  */
#line 4654 "../../cobc/parser.y"
  {
	yyval = CB_LIST_INIT (yyvsp[-1]);
  }
#line 16471 "parser.c"
    break;

  case 233: /* alphabet_literal: alphabet_lits ALSO @26 alphabet_also_sequence  */
#line 4658 "../../cobc/parser.y"
  {
	yyval = yyvsp[-1];
  }
#line 16479 "parser.c"
    break;

  case 234: /* alphabet_also_sequence: alphabet_lits  */
#line 4665 "../../cobc/parser.y"
  {
	cb_list_add (yyvsp[-1], yyvsp[0]);
  }
#line 16487 "parser.c"
    break;

  case 235: /* alphabet_also_sequence: alphabet_also_sequence ALSO alphabet_lits  */
#line 4669 "../../cobc/parser.y"
  {
	cb_list_add (yyvsp[-3], yyvsp[0]);
  }
#line 16495 "parser.c"
    break;

  case 236: /* alphabet_lits: "Literal"  */
#line 4675 "../../cobc/parser.y"
                                { yyval = yyvsp[0]; }
#line 16501 "parser.c"
    break;

  case 237: /* alphabet_lits: SPACE  */
#line 4676 "../../cobc/parser.y"
                                { yyval = cb_space; }
#line 16507 "parser.c"
    break;

  case 238: /* alphabet_lits: ZERO  */
#line 4677 "../../cobc/parser.y"
                                { yyval = cb_zero; }
#line 16513 "parser.c"
    break;

  case 239: /* alphabet_lits: QUOTE  */
#line 4678 "../../cobc/parser.y"
                                { yyval = cb_quote; }
#line 16519 "parser.c"
    break;

  case 240: /* alphabet_lits: "HIGH-VALUE"  */
#line 4679 "../../cobc/parser.y"
                        { yyval = cb_norm_high; /* -> special case, not cb_high */ }
#line 16525 "parser.c"
    break;

  case 241: /* alphabet_lits: "LOW-VALUE"  */
#line 4680 "../../cobc/parser.y"
                                { yyval = cb_norm_low; }
#line 16531 "parser.c"
    break;

  case 242: /* space_or_zero: SPACE  */
#line 4684 "../../cobc/parser.y"
                                { yyval = cb_space; }
#line 16537 "parser.c"
    break;

  case 243: /* space_or_zero: ZERO  */
#line 4685 "../../cobc/parser.y"
                                { yyval = cb_zero; }
#line 16543 "parser.c"
    break;

  case 244: /* _alphnat_target: %empty  */
#line 4690 "../../cobc/parser.y"
  {
	yyval = NULL;
  }
#line 16551 "parser.c"
    break;

  case 245: /* _alphnat_target: _for ALPHANUMERIC  */
#line 4694 "../../cobc/parser.y"
  {
	yyval = NULL;
  }
#line 16559 "parser.c"
    break;

  case 246: /* _alphnat_target: _for NATIONAL  */
#line 4698 "../../cobc/parser.y"
  {
	yyval = cb_int0;
  }
#line 16567 "parser.c"
    break;

  case 247: /* _in_alphabet: %empty  */
#line 4705 "../../cobc/parser.y"
  {
	yyval = NULL;
  }
#line 16575 "parser.c"
    break;

  case 248: /* _in_alphabet: IN alphabet_name  */
#line 4709 "../../cobc/parser.y"
  {
	/* note: IN is really mandatory here */
	yyval = yyvsp[0];
  }
#line 16584 "parser.c"
    break;

  case 249: /* symbolic_characters_clause: symbolic_collection _in_alphabet  */
#line 4720 "../../cobc/parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		cb_tree type = CB_PAIR_X (yyvsp[-1]);
		cb_tree chars_list = CB_PAIR_Y (yyvsp[-1]);
		cb_tree alph = yyvsp[0];
		
		/* TODO: at least add a check that $3 and $6 match by type */
		if (type && !alph) {
			cb_error_x (type, _("type does not match alphabet"));
		} else
		if (type) {
			CB_PENDING_X (type, "NATIONAL SYMBOLIC CHARACTER");
		}
		CB_CHAIN_PAIR (current_program->symbolic_char_list, chars_list, alph);
	}
  }
#line 16610 "parser.c"
    break;

  case 250: /* symbolic_collection: SYMBOLIC _characters _alphnat_target symbolic_chars_list  */
#line 4747 "../../cobc/parser.y"
  {
	yyval = CB_BUILD_PAIR (yyvsp[-1], yyvsp[0]);
  }
#line 16618 "parser.c"
    break;

  case 251: /* symbolic_chars_list: symbolic_chars_phrase  */
#line 4754 "../../cobc/parser.y"
  {
	yyval = yyvsp[0];
  }
#line 16626 "parser.c"
    break;

  case 252: /* symbolic_chars_list: symbolic_chars_list symbolic_chars_phrase  */
#line 4758 "../../cobc/parser.y"
  {
	if (yyvsp[0]) {
		yyval = cb_list_append (yyvsp[-1], yyvsp[0]);
	} else {
		yyval = yyvsp[-1];
	}
  }
#line 16638 "parser.c"
    break;

  case 253: /* symbolic_chars_phrase: char_list _is_are integer_list  */
#line 4769 "../../cobc/parser.y"
  {
	cb_tree		l1;
	cb_tree		l2;

	if (cb_list_length (yyvsp[-2]) != cb_list_length (yyvsp[0])) {
		cb_error (_("invalid %s clause"), "SYMBOLIC");
		yyval = NULL;
	} else {
		l1 = yyvsp[-2];
		l2 = yyvsp[0];
		for (; l1; l1 = CB_CHAIN (l1), l2 = CB_CHAIN (l2)) {
			CB_PURPOSE (l1) = CB_VALUE (l2);
		}
		yyval = yyvsp[-2];
	}
  }
#line 16659 "parser.c"
    break;

  case 254: /* char_list: unique_word  */
#line 4789 "../../cobc/parser.y"
  {
	if (yyvsp[0] == NULL) {
		yyval = NULL;
	} else {
		yyval = CB_LIST_INIT (yyvsp[0]);
	}
  }
#line 16671 "parser.c"
    break;

  case 255: /* char_list: char_list unique_word  */
#line 4797 "../../cobc/parser.y"
  {
	if (yyvsp[0] == NULL) {
		yyval = yyvsp[-1];
	} else {
		yyval = cb_list_add (yyvsp[-1], yyvsp[0]);
	}
  }
#line 16683 "parser.c"
    break;

  case 256: /* integer_list: symbolic_integer  */
#line 4807 "../../cobc/parser.y"
                                { yyval = CB_LIST_INIT (yyvsp[0]); }
#line 16689 "parser.c"
    break;

  case 257: /* integer_list: integer_list symbolic_integer  */
#line 4808 "../../cobc/parser.y"
                                { yyval = cb_list_add (yyvsp[-1], yyvsp[0]); }
#line 16695 "parser.c"
    break;

  case 258: /* symbolic_constant_clause: SYMBOLIC CONSTANT symbolic_constant_list  */
#line 4817 "../../cobc/parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	}
	(void)cb_verify (cb_symbolic_constant, "SYMBOLIC CONSTANT");
  }
#line 16709 "parser.c"
    break;

  case 261: /* symbolic_constant: user_entry_name _is literal  */
#line 4835 "../../cobc/parser.y"
  {
	struct cb_field *f;

	f = CB_FIELD (cb_build_constant (yyvsp[-2], yyvsp[0]));
	f->flag_item_78 = 1;
	f->flag_constant = 1;
	f->flag_is_global = 1;
	f->level = 1;
	f->values = yyvsp[0];
	cb_needs_01 = 1;
	/* Ignore return value */
	(void)cb_validate_78_item (f, 0);
  }
#line 16727 "parser.c"
    break;

  case 262: /* class_name_clause: CLASS undefined_word _alphnat_target _is class_item_list _in_alphabet  */
#line 4854 "../../cobc/parser.y"
  {
	cb_tree		x;

	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		/* Returns null on error */
		x = cb_build_class_name (yyvsp[-4], yyvsp[-1]);
		if (x) {
			current_program->class_name_list =
				cb_list_add (current_program->class_name_list, x);
		}
		/* TODO: at least add a check that $3 and $6 match by type */
		if (yyvsp[-3] && !yyvsp[0]) {
			cb_error_x (yyvsp[-3], _("type does not match alphabet"));
		} else
		if (yyvsp[-3]) {
			CB_PENDING_X (yyvsp[-3], "NATIONAL CLASS");
		}
		if (yyvsp[0]) {
			CB_PENDING_X (yyvsp[0], _("CLASS IS integer IN alphabet-name"));
		}
	}
  }
#line 16759 "parser.c"
    break;

  case 263: /* class_item_list: class_item  */
#line 4884 "../../cobc/parser.y"
                                { yyval = CB_LIST_INIT (yyvsp[0]); }
#line 16765 "parser.c"
    break;

  case 264: /* class_item_list: class_item_list class_item  */
#line 4885 "../../cobc/parser.y"
                                { yyval = cb_list_add (yyvsp[-1], yyvsp[0]); }
#line 16771 "parser.c"
    break;

  case 265: /* class_item: class_value  */
#line 4890 "../../cobc/parser.y"
  {
	yyval = yyvsp[0];
  }
#line 16779 "parser.c"
    break;

  case 266: /* class_item: class_value THRU class_value  */
#line 4894 "../../cobc/parser.y"
  {
	if (CB_TREE_CLASS (yyvsp[-2]) != CB_CLASS_NUMERIC &&
	    CB_LITERAL_P (yyvsp[-2]) && CB_LITERAL (yyvsp[-2])->size != 1) {
		cb_error (_("CLASS literal with THRU must have size 1"));
	}
	if (CB_TREE_CLASS (yyvsp[0]) != CB_CLASS_NUMERIC &&
	    CB_LITERAL_P (yyvsp[0]) && CB_LITERAL (yyvsp[0])->size != 1) {
		cb_error (_("CLASS literal with THRU must have size 1"));
	}
	if (cb_literal_value (yyvsp[-2]) <= cb_literal_value (yyvsp[0])) {
		yyval = CB_BUILD_PAIR (yyvsp[-2], yyvsp[0]);
	} else {
		yyval = CB_BUILD_PAIR (yyvsp[0], yyvsp[-2]);
	}
  }
#line 16799 "parser.c"
    break;

  case 267: /* locale_clause: LOCALE undefined_word _is "Literal"  */
#line 4915 "../../cobc/parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		/* Returns null on error */
		cb_tree	l = cb_build_locale_name (yyvsp[-2], yyvsp[0]);
		if (l) {
			current_program->locale_list =
				cb_list_add (current_program->locale_list, l);
		}
	}
  }
#line 16819 "parser.c"
    break;

  case 268: /* @27: %empty  */
#line 4936 "../../cobc/parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
		yyval = NULL;
	} else {
		/* Returns null on error */
		yyval = cb_build_schema_name (yyvsp[0]);
	}
  }
#line 16836 "parser.c"
    break;

  case 269: /* xml_schema_clause: "XML-SCHEMA" undefined_word @27 schema_definition  */
#line 4949 "../../cobc/parser.y"
  {
	if (yyvsp[-1]) {
		current_program->schema_name_list =
			cb_list_add (current_program->schema_name_list, yyvsp[-1]);
	}
	cobc_cs_check = 0;
  }
#line 16848 "parser.c"
    break;

  case 270: /* schema_definition: literal  */
#line 4960 "../../cobc/parser.y"
  {
	yyval = yyvsp[-1];
	if (yyvsp[-1]) {
		CB_SCHEMA_NAME (yyvsp[-1])->data = (const char *) CB_LITERAL (yyvsp[0])->data;
	}
  }
#line 16859 "parser.c"
    break;

  case 271: /* schema_definition: "Identifier"  */
#line 4967 "../../cobc/parser.y"
  {
	yyval = yyvsp[-1];
	if (yyvsp[-1]) {
		CB_SCHEMA_NAME (yyvsp[-1])->data = CB_REFERENCE (yyvsp[0])->word->name;
	}
  }
#line 16870 "parser.c"
    break;

  case 272: /* currency_sign_clause: CURRENCY _sign _is "Literal" _with_pic_symbol  */
#line 4979 "../../cobc/parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		unsigned int	error_ind = 0;

		/* FIXME: actual allowed (depending on dialect), see FR #246 */
		check_repeated ("CURRENCY", SYN_CLAUSE_1, &check_duplicate);

		/* checks of CURRENCY SIGN (being currency string) when separate */
		if (yyvsp[0]) {
			unsigned int	char_seen = 0;
			unsigned char	*s = CB_LITERAL (yyvsp[-1])->data;

			CB_PENDING_X (yyvsp[-1], _("separate currency symbol and currency string"));
			while (*s) {
				switch (*s) {
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
				case '+':
				case '-':
				case ',':
				case '.':
				case '*':
					error_ind = 1;
					break;
				case ' ':
					break;
				default:
					char_seen = 1;
					break;
				}
				s++;
			}
			if (!char_seen) {
				error_ind = 1;
			}
		}
		if (error_ind) {
			cb_error_x (yyvsp[-1], _("invalid CURRENCY SIGN '%s'"), (char*)CB_LITERAL (yyvsp[-1])->data);
		}
		if (yyvsp[0]) {
			set_currency_picture_symbol (yyvsp[0]);
		} else {
			if (!error_ind) {
				set_currency_picture_symbol (yyvsp[-1]);
			}
		}
	}
  }
#line 16936 "parser.c"
    break;

  case 273: /* _with_pic_symbol: %empty  */
#line 5045 "../../cobc/parser.y"
  {
	yyval = NULL;
  }
#line 16944 "parser.c"
    break;

  case 274: /* _with_pic_symbol: _with "PICTURE SYMBOL" "Literal"  */
#line 5049 "../../cobc/parser.y"
  {
	yyval = yyvsp[0];
  }
#line 16952 "parser.c"
    break;

  case 275: /* decimal_point_clause: "DECIMAL-POINT" _is COMMA  */
#line 5058 "../../cobc/parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		check_repeated ("DECIMAL-POINT", SYN_CLAUSE_2, &check_duplicate);
		current_program->decimal_point = ',';
		current_program->numeric_separator = '.';
	}
  }
#line 16969 "parser.c"
    break;

  case 276: /* numeric_sign_clause: NUMERIC SIGN _is TRAILING SEPARATE  */
#line 5077 "../../cobc/parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		current_program->flag_trailing_separate = 1;
	}
  }
#line 16984 "parser.c"
    break;

  case 277: /* cursor_clause: CURSOR _is reference  */
#line 5093 "../../cobc/parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		check_repeated ("CURSOR", SYN_CLAUSE_3, &check_duplicate);
		current_program->cursor_pos = yyvsp[0];
	}
  }
#line 17000 "parser.c"
    break;

  case 278: /* crt_status_clause: CRT STATUS _is reference  */
#line 5111 "../../cobc/parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		check_repeated ("CRT STATUS", SYN_CLAUSE_4, &check_duplicate);
		current_program->crt_status = yyvsp[0];
	}
  }
#line 17016 "parser.c"
    break;

  case 279: /* screen_control: "SCREEN CONTROL" _is reference  */
#line 5129 "../../cobc/parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		check_repeated ("SCREEN CONTROL", SYN_CLAUSE_5, &check_duplicate);
		CB_PENDING ("SCREEN CONTROL");
	}
  }
#line 17032 "parser.c"
    break;

  case 280: /* event_status: "EVENT STATUS" _is reference  */
#line 5146 "../../cobc/parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		check_repeated ("EVENT STATUS", SYN_CLAUSE_6, &check_duplicate);
		CB_PENDING ("EVENT STATUS");
	}
  }
#line 17048 "parser.c"
    break;

  case 281: /* $@28: %empty  */
#line 5163 "../../cobc/parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	check_duplicate = 0;
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
		save_tree = NULL;
	} else {
		/* lookup system name
		   note: result in NULL + raised error if not found */
		save_tree = get_system_name ("TOP");
	}
  }
#line 17067 "parser.c"
    break;

  case 282: /* top_clause: TOP $@28 _is undefined_word  */
#line 5178 "../../cobc/parser.y"
  {
	if (save_tree && CB_VALID_TREE (yyvsp[0])) {
		cb_define (yyvsp[0], save_tree);
		CB_CHAIN_PAIR (current_program->mnemonic_spec_list,
				yyvsp[0], save_tree);
	}
  }
#line 17079 "parser.c"
    break;

  case 284: /* input_output: "INPUT-OUTPUT"  */
#line 5196 "../../cobc/parser.y"
                           { check_area_a_of ("INPUT-OUTPUT SECTION"); }
#line 17085 "parser.c"
    break;

  case 286: /* _input_output_header: input_output SECTION _dot  */
#line 5199 "../../cobc/parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION, 0, 0, 0);
	header_check |= COBC_HD_INPUT_OUTPUT_SECTION;
  }
#line 17094 "parser.c"
    break;

  case 288: /* _file_control_header: "FILE-CONTROL" _dot  */
#line 5209 "../../cobc/parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_INPUT_OUTPUT_SECTION, 0, 0);
	header_check |= COBC_HD_FILE_CONTROL;
  }
#line 17104 "parser.c"
    break;

  case 291: /* $@29: %empty  */
#line 5221 "../../cobc/parser.y"
         { check_non_area_a (yyvsp[0]); }
#line 17110 "parser.c"
    break;

  case 292: /* $@30: %empty  */
#line 5223 "../../cobc/parser.y"
  {
	char	buff[COB_MINI_BUFF];

	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_INPUT_OUTPUT_SECTION,
			       COBC_HD_FILE_CONTROL, 0);
	check_duplicate = 0;
	if (CB_VALID_TREE (yyvsp[0])) {
		/* Build new file */
		current_file = build_file (yyvsp[0]);
		current_file->optional = CB_INTEGER (yyvsp[-1])->val;

		/* Add file to current program list */
		CB_ADD_TO_CHAIN (CB_TREE (current_file),
				 current_program->file_list);
	} else {
		/* Create dummy file */
		snprintf (buff, COB_MINI_BUFF, "SELECT on line %d",
			  cb_source_line);
		current_file = build_file (cb_build_reference (buff));
		CB_ADD_TO_CHAIN (CB_TREE (current_file),
				 current_program->file_list);

	}
	key_type = NO_KEY;
  }
#line 17141 "parser.c"
    break;

  case 293: /* file_control_entry: SELECT $@29 flag_optional undefined_word $@30 _select_clauses_or_error  */
#line 5250 "../../cobc/parser.y"
  {
	cobc_cs_check = 0;
	if (CB_VALID_TREE (yyvsp[-2])) {
		if (current_file->organization == COB_ORG_INDEXED
		    && key_type == RELATIVE_KEY) {
			cb_error_x (current_file->key,
				    _("cannot use RELATIVE KEY clause on INDEXED files"));
		} else if (current_file->organization == COB_ORG_RELATIVE
			   && key_type == RECORD_KEY) {
			cb_error_x (current_file->key,
				    _("cannot use RECORD KEY clause on RELATIVE files"));
		}

		validate_file (current_file, yyvsp[-2]);
	}
  }
#line 17162 "parser.c"
    break;

  case 295: /* _select_clauses_or_error: error _dot_or_else_end_of_file_control  */
#line 5271 "../../cobc/parser.y"
  {
	yyerrok;
  }
#line 17170 "parser.c"
    break;

  case 297: /* _select_clause_sequence: _select_clause_sequence select_clause  */
#line 5278 "../../cobc/parser.y"
  {
	/* reset context-sensitive words for next clauses */
	cobc_cs_check = CB_CS_SELECT;
  }
#line 17179 "parser.c"
    break;

  case 318: /* assign_clause: ASSIGN _to _ext_clause _assign_device_or_line_adv_file literal  */
#line 5329 "../../cobc/parser.y"
  {
	check_repeated ("ASSIGN", SYN_CLAUSE_1, &check_duplicate);
	if (ext_dyn_specified) {
		cb_error (_("EXTERNAL/DYNAMIC cannot be used with literals"));
	}

	current_file->assign_type = CB_ASSIGN_EXT_FILE_NAME_REQUIRED;
	current_file->assign = cb_build_assignment_name (current_file, yyvsp[0]);
  }
#line 17193 "parser.c"
    break;

  case 319: /* assign_clause: ASSIGN _to _ext_clause _assign_device_or_line_adv_file qualified_word  */
#line 5339 "../../cobc/parser.y"
  {
	check_repeated ("ASSIGN", SYN_CLAUSE_1, &check_duplicate);

	/* current_file->assign_type is set by _ext_clause */
	if (!ext_dyn_specified) {
		current_file->flag_assign_no_keyword = 1;
	}
	current_file->assign = cb_build_assignment_name (current_file, yyvsp[0]);
  }
#line 17207 "parser.c"
    break;

  case 320: /* assign_clause: ASSIGN _to _ext_clause _assign_device_or_line_adv_file using_or_varying qualified_word  */
#line 5349 "../../cobc/parser.y"
  {
	check_repeated ("ASSIGN", SYN_CLAUSE_1, &check_duplicate);
	if (ext_dyn_specified) {
		cb_error (_("EXTERNAL/DYNAMIC cannot be used with USING/VARYING"));
	}
	cb_verify (cb_assign_using_variable, "ASSIGN USING/VARYING variable");

	current_file->assign_type = CB_ASSIGN_VARIABLE_REQUIRED;
	current_file->assign = cb_build_assignment_name (current_file, yyvsp[0]);
  }
#line 17222 "parser.c"
    break;

  case 321: /* assign_clause: ASSIGN _to _ext_clause DISK FROM qualified_word  */
#line 5360 "../../cobc/parser.y"
  {
	check_repeated ("ASSIGN", SYN_CLAUSE_1, &check_duplicate);
	if (ext_dyn_specified) {
		cb_error (_("EXTERNAL/DYNAMIC cannot be used with DISK FROM"));
	}
	cb_verify (cb_assign_disk_from, "ASSIGN DISK FROM");

	current_file->assign_type = CB_ASSIGN_VARIABLE_REQUIRED;
	current_file->assign = cb_build_assignment_name (current_file, yyvsp[0]);
  }
#line 17237 "parser.c"
    break;

  case 322: /* assign_clause: ASSIGN _to _ext_clause assign_device  */
#line 5371 "../../cobc/parser.y"
  {
	if (assign_device == CB_ASSIGN_DISPLAY_DEVICE) {
		current_file->assign =
			cb_build_alphanumeric_literal ("stdout", (size_t)6);
		current_file->special = COB_SELECT_STDOUT;
	} else if (assign_device == CB_ASSIGN_KEYBOARD_DEVICE) {
		current_file->assign =
			cb_build_alphanumeric_literal ("stdin", (size_t)5);
		current_file->special = COB_SELECT_STDIN;
	} else if (assign_device == CB_ASSIGN_PRINTER_DEVICE) {
		current_file->organization = COB_ORG_LINE_SEQUENTIAL;
		current_file->assign =
			cb_build_alphanumeric_literal ("PRINTER", (size_t)7);
	} else if (assign_device == CB_ASSIGN_PRINTER_1_DEVICE) {
		current_file->organization = COB_ORG_LINE_SEQUENTIAL;
		current_file->assign =
			cb_build_alphanumeric_literal ("PRINTER-1", (size_t)9);
	} else if (assign_device == CB_ASSIGN_PRINT_DEVICE) {
		current_file->organization = COB_ORG_LINE_SEQUENTIAL;
		current_file->assign =
			cb_build_alphanumeric_literal ("LPT1", (size_t)4);
	} else if (assign_device == CB_ASSIGN_LINE_SEQ_DEVICE
		   || assign_device == CB_ASSIGN_GENERAL_DEVICE) {
		current_file->flag_fileid = 1;
	}
  }
#line 17268 "parser.c"
    break;

  case 323: /* _assign_device_or_line_adv_file: %empty  */
#line 5401 "../../cobc/parser.y"
  {
	assign_device = CB_ASSIGN_NO_DEVICE;
  }
#line 17276 "parser.c"
    break;

  case 324: /* _assign_device_or_line_adv_file: line_adv_file  */
#line 5405 "../../cobc/parser.y"
  {
	assign_device = CB_ASSIGN_NO_DEVICE;
  }
#line 17284 "parser.c"
    break;

  case 326: /* assign_device: general_device_name  */
#line 5413 "../../cobc/parser.y"
  {
	assign_device = CB_ASSIGN_GENERAL_DEVICE;
  }
#line 17292 "parser.c"
    break;

  case 327: /* assign_device: line_seq_device_name  */
#line 5417 "../../cobc/parser.y"
  {
	current_file->organization = COB_ORG_LINE_SEQUENTIAL;
	assign_device = CB_ASSIGN_LINE_SEQ_DEVICE;
  }
#line 17301 "parser.c"
    break;

  case 328: /* assign_device: DISPLAY  */
#line 5422 "../../cobc/parser.y"
  {
	assign_device = CB_ASSIGN_DISPLAY_DEVICE;
  }
#line 17309 "parser.c"
    break;

  case 329: /* assign_device: KEYBOARD  */
#line 5426 "../../cobc/parser.y"
  {
	assign_device = CB_ASSIGN_KEYBOARD_DEVICE;
  }
#line 17317 "parser.c"
    break;

  case 330: /* assign_device: PRINTER  */
#line 5434 "../../cobc/parser.y"
  {
	assign_device = CB_ASSIGN_PRINTER_DEVICE;
	current_file->organization = COB_ORG_LINE_SEQUENTIAL;
	current_file->flag_line_adv = 1;
  }
#line 17327 "parser.c"
    break;

  case 331: /* assign_device: "PRINTER-1"  */
#line 5440 "../../cobc/parser.y"
  {
	assign_device = CB_ASSIGN_PRINTER_1_DEVICE;
	current_file->organization = COB_ORG_LINE_SEQUENTIAL;
	current_file->flag_line_adv = 1;
  }
#line 17337 "parser.c"
    break;

  case 332: /* assign_device: PRINT  */
#line 5446 "../../cobc/parser.y"
  {
	assign_device = CB_ASSIGN_PRINT_DEVICE;
	current_file->organization = COB_ORG_LINE_SEQUENTIAL;
	current_file->flag_line_adv = 1;
  }
#line 17347 "parser.c"
    break;

  case 344: /* line_adv_file: LINE ADVANCING _file  */
#line 5473 "../../cobc/parser.y"
  {
	current_file->flag_line_adv = 1;
  }
#line 17355 "parser.c"
    break;

  case 345: /* _ext_clause: %empty  */
#line 5480 "../../cobc/parser.y"
  {
	ext_dyn_specified = 0;
	current_file->assign_type = cb_assign_type_default;
  }
#line 17364 "parser.c"
    break;

  case 346: /* _ext_clause: ext_clause  */
#line 5485 "../../cobc/parser.y"
  {
	ext_dyn_specified = 1;
	cb_verify (cb_assign_ext_dyn, _("ASSIGN EXTERNAL/DYNAMIC"));
  }
#line 17373 "parser.c"
    break;

  case 347: /* ext_clause: EXTERNAL  */
#line 5493 "../../cobc/parser.y"
  {
	current_file->assign_type = CB_ASSIGN_EXT_FILE_NAME_REQUIRED;
  }
#line 17381 "parser.c"
    break;

  case 348: /* ext_clause: DYNAMIC  */
#line 5497 "../../cobc/parser.y"
  {
	current_file->assign_type = CB_ASSIGN_VARIABLE_REQUIRED;
  }
#line 17389 "parser.c"
    break;

  case 351: /* access_mode_clause: ACCESS _mode _is access_mode  */
#line 5511 "../../cobc/parser.y"
  {
	check_repeated ("ACCESS", SYN_CLAUSE_2, &check_duplicate);
  }
#line 17397 "parser.c"
    break;

  case 352: /* access_mode: SEQUENTIAL  */
#line 5517 "../../cobc/parser.y"
                        { current_file->access_mode = COB_ACCESS_SEQUENTIAL; }
#line 17403 "parser.c"
    break;

  case 353: /* access_mode: DYNAMIC  */
#line 5518 "../../cobc/parser.y"
                        { current_file->access_mode = COB_ACCESS_DYNAMIC; }
#line 17409 "parser.c"
    break;

  case 354: /* access_mode: RANDOM  */
#line 5519 "../../cobc/parser.y"
                        { current_file->access_mode = COB_ACCESS_RANDOM; }
#line 17415 "parser.c"
    break;

  case 355: /* alternate_record_key_clause: ALTERNATE _record _key _is reference _split_keys flag_duplicates _password_clause _suppress_clause  */
#line 5527 "../../cobc/parser.y"
  {
	struct cb_alt_key *p;
	struct cb_alt_key *l;

	cb_tree composite_key;

	p = cobc_parse_malloc (sizeof (struct cb_alt_key));
	p->key = yyvsp[-4];
	p->component_list = NULL;
	if (yyvsp[-2]) {
		p->duplicates = CB_INTEGER (yyvsp[-2])->val;
	} else {
		/* note: we may add a compiler configuration here,
		         as at least ICOBOL defaults to WITH DUPLICATES
		         for ALTERNATE keys if not explicit deactivated
		*/
		p->duplicates = 0;
	}
	p->password = yyvsp[-1];
	if (yyvsp[0]) {
		p->tf_suppress = 1;
		p->char_suppress = CB_INTEGER (yyvsp[0])->val;
	} else {
		p->tf_suppress = 0;
	}
	p->next = NULL;

	/* handle split keys */
	if (yyvsp[-3]) {
		/* generate field (in w-s) for composite-key */
		composite_key = cb_build_field(yyvsp[-4]);
		if (composite_key == cb_error_node) {
			YYERROR;
		} else {
			composite_key->category = CB_CATEGORY_ALPHANUMERIC;
			((struct cb_field *)composite_key)->count = 1;
			p->key = cb_build_field_reference((struct cb_field *)composite_key, NULL);
			p->component_list = key_component_list;
		}
	}

	/* Add to the end of list */
	if (current_file->alt_key_list == NULL) {
		current_file->alt_key_list = p;
	} else {
		l = current_file->alt_key_list;
		for (; l->next; l = l->next) { ; }
		l->next = p;
	}
  }
#line 17470 "parser.c"
    break;

  case 356: /* _password_clause: %empty  */
#line 5581 "../../cobc/parser.y"
  {
	yyval = NULL;
  }
#line 17478 "parser.c"
    break;

  case 358: /* $@31: %empty  */
#line 5589 "../../cobc/parser.y"
  {
	CB_PENDING ("PASSWORD clause");
  }
#line 17486 "parser.c"
    break;

  case 359: /* password_clause: PASSWORD $@31 _is reference  */
#line 5593 "../../cobc/parser.y"
  {
	yyval = yyvsp[0];
  }
#line 17494 "parser.c"
    break;

  case 360: /* encryption_clause: ENCRYPTION  */
#line 5601 "../../cobc/parser.y"
  {
	if (current_file->organization == COB_ORG_INDEXED) {
		cb_error (_("%s only valid with ORGANIZATION %s"), "WITH ENCRYPTION", "INDEXED");
	} else {
		CB_PENDING ("WITH ENCRYPTION");
		current_file->password = cb_int0;
	}
  }
#line 17507 "parser.c"
    break;

  case 361: /* _suppress_clause: %empty  */
#line 5613 "../../cobc/parser.y"
  {
	yyval = NULL;
  }
#line 17515 "parser.c"
    break;

  case 362: /* _suppress_clause: SUPPRESS WHEN ALL basic_value  */
#line 5617 "../../cobc/parser.y"
  {
	yyval = cb_int (cb_literal_value (yyvsp[0]));
  }
#line 17523 "parser.c"
    break;

  case 363: /* _suppress_clause: SUPPRESS WHEN space_or_zero  */
#line 5621 "../../cobc/parser.y"
  {
	yyval = cb_int (cb_literal_value (yyvsp[0]));
  }
#line 17531 "parser.c"
    break;

  case 364: /* collating_sequence_clause: collating_sequence  */
#line 5631 "../../cobc/parser.y"
  {
	check_repeated ("COLLATING", SYN_CLAUSE_3, &check_duplicate);
	current_file->collating_sequence = alphanumeric_collation;
	current_file->collating_sequence_n = national_collation;
	CB_PENDING ("FILE COLLATING SEQUENCE");
  }
#line 17542 "parser.c"
    break;

  case 365: /* $@32: %empty  */
#line 5641 "../../cobc/parser.y"
  {
	alphanumeric_collation = national_collation = default_collation;
  }
#line 17550 "parser.c"
    break;

  case 367: /* coll_sequence_values: _is alphabet_name  */
#line 5649 "../../cobc/parser.y"
  {
	alphanumeric_collation = yyvsp[0];
  }
#line 17558 "parser.c"
    break;

  case 368: /* coll_sequence_values: _is alphabet_name alphabet_name  */
#line 5653 "../../cobc/parser.y"
  {
	alphanumeric_collation = yyvsp[-1];
	CB_PENDING_X (yyvsp[0], "NATIONAL COLLATING SEQUENCE");
	national_collation = yyvsp[0];
  }
#line 17568 "parser.c"
    break;

  case 369: /* coll_sequence_values: _for ALPHANUMERIC _is alphabet_name  */
#line 5659 "../../cobc/parser.y"
  {
	alphanumeric_collation = yyvsp[0];
  }
#line 17576 "parser.c"
    break;

  case 370: /* coll_sequence_values: _for NATIONAL _is alphabet_name  */
#line 5663 "../../cobc/parser.y"
  {
	CB_PENDING_X (yyvsp[0], "NATIONAL COLLATING SEQUENCE");
	national_collation = yyvsp[0];
  }
#line 17585 "parser.c"
    break;

  case 371: /* coll_sequence_values: _for ALPHANUMERIC _is alphabet_name _for NATIONAL _is alphabet_name  */
#line 5669 "../../cobc/parser.y"
  {
	alphanumeric_collation = yyvsp[-4];
	CB_PENDING_X (yyvsp[0], "NATIONAL COLLATING SEQUENCE");
	national_collation = yyvsp[0];
  }
#line 17595 "parser.c"
    break;

  case 372: /* coll_sequence_values: _for NATIONAL _is alphabet_name _for ALPHANUMERIC _is alphabet_name  */
#line 5676 "../../cobc/parser.y"
  {
	CB_PENDING_X (yyvsp[-4], "NATIONAL COLLATING SEQUENCE");
	national_collation = yyvsp[-4];
	alphanumeric_collation = yyvsp[0];
  }
#line 17605 "parser.c"
    break;

  case 373: /* collating_sequence_clause_key: _collating SEQUENCE OF reference _is alphabet_name  */
#line 5685 "../../cobc/parser.y"
  {
	/* note: both entries must be resolved later on
	   and also attached to the correct key later, so just store in a list here: */
	current_file->collating_sequence_keys =
		cb_list_add(current_file->collating_sequence_keys, CB_BUILD_PAIR (yyvsp[0], yyvsp[-2]));
	CB_PENDING ("KEY COLLATING SEQUENCE");
  }
#line 17617 "parser.c"
    break;

  case 374: /* alphabet_name: "Identifier"  */
#line 5696 "../../cobc/parser.y"
  {
	if (CB_ALPHABET_NAME_P (cb_ref (yyvsp[0]))) {
		yyval = yyvsp[0];
	} else {
		cb_error_x (yyvsp[0], _("'%s' is not an alphabet-name"),
			cb_name (yyvsp[0]));
		yyval = cb_error_node;
	}
  }
#line 17631 "parser.c"
    break;

  case 375: /* alphabet_name: "STANDARD-1"  */
#line 5706 "../../cobc/parser.y"
  {
	yyval = build_colseq (CB_COLSEQ_NATIVE);
  }
#line 17639 "parser.c"
    break;

  case 376: /* alphabet_name: "STANDARD-2"  */
#line 5710 "../../cobc/parser.y"
  {
	yyval = build_colseq (CB_COLSEQ_ASCII);
  }
#line 17647 "parser.c"
    break;

  case 377: /* alphabet_name: EBCDIC  */
#line 5714 "../../cobc/parser.y"
  {
	yyval = build_colseq (CB_COLSEQ_EBCDIC);
  }
#line 17655 "parser.c"
    break;

  case 378: /* alphabet_name: ASCII  */
#line 5718 "../../cobc/parser.y"
  {
	yyval = build_colseq (CB_COLSEQ_ASCII);
  }
#line 17663 "parser.c"
    break;

  case 379: /* file_status_clause: _file_or_sort STATUS _is reference _reference  */
#line 5727 "../../cobc/parser.y"
  {
	check_repeated ("STATUS", SYN_CLAUSE_4, &check_duplicate);
	current_file->file_status = yyvsp[-1];
	if (yyvsp[0]) {
		/* Ignore VSAM STATUS field */
		cb_verify (cb_vsam_status, _("VSAM status"));
	}
  }
#line 17676 "parser.c"
    break;

  case 383: /* $@33: %empty  */
#line 5746 "../../cobc/parser.y"
  {
	check_repeated ("LOCK", SYN_CLAUSE_5, &check_duplicate);
  }
#line 17684 "parser.c"
    break;

  case 385: /* lock_mode: MANUAL _lock_with  */
#line 5754 "../../cobc/parser.y"
  {
	current_file->lock_mode |= COB_LOCK_MANUAL;
  }
#line 17692 "parser.c"
    break;

  case 386: /* lock_mode: AUTOMATIC _lock_with  */
#line 5758 "../../cobc/parser.y"
  {
	current_file->lock_mode |= COB_LOCK_AUTOMATIC;
  }
#line 17700 "parser.c"
    break;

  case 387: /* lock_mode: EXCLUSIVE _with_mass_update  */
#line 5762 "../../cobc/parser.y"
  {
	current_file->lock_mode |= COB_LOCK_EXCLUSIVE;
  }
#line 17708 "parser.c"
    break;

  case 390: /* _lock_with: WITH _lock ON MULTIPLE lock_records _with_rollback  */
#line 5771 "../../cobc/parser.y"
  {
	current_file->lock_mode |= COB_LOCK_MULTIPLE;
  }
#line 17716 "parser.c"
    break;

  case 391: /* _lock_with: with_rollback  */
#line 5775 "../../cobc/parser.y"
  {
	current_file->lock_mode |= COB_LOCK_MULTIPLE;
  }
#line 17724 "parser.c"
    break;

  case 394: /* with_rollback: _with ROLLBACK  */
#line 5786 "../../cobc/parser.y"
  {
	CB_PENDING ("WITH ROLLBACK");
  }
#line 17732 "parser.c"
    break;

  case 396: /* _with_mass_update: _with "MASS-UPDATE"  */
#line 5793 "../../cobc/parser.y"
  {
	if (current_file->organization == COB_ORG_INDEXED) {
		current_file->lock_mode |= COB_LOCK_EXCLUSIVE;
		/* TODO: pass extra flag to fileio */
		CB_PENDING ("WITH MASS-UPDATE");
	} else {
		cb_error (_("%s only valid with ORGANIZATION %s"), "MASS-UPDATE", "INDEXED");
	}
  }
#line 17746 "parser.c"
    break;

  case 399: /* organization: INDEXED  */
#line 5814 "../../cobc/parser.y"
  {
	check_repeated ("ORGANIZATION", SYN_CLAUSE_6, &check_duplicate);
	error_if_record_delimiter_incompatible (COB_ORG_INDEXED, "INDEXED");
	current_file->organization = COB_ORG_INDEXED;
  }
#line 17756 "parser.c"
    break;

  case 400: /* organization: _record _binary SEQUENTIAL  */
#line 5820 "../../cobc/parser.y"
  {
	check_repeated ("ORGANIZATION", SYN_CLAUSE_6, &check_duplicate);
	error_if_record_delimiter_incompatible (COB_ORG_SEQUENTIAL, "SEQUENTIAL");
	current_file->organization = COB_ORG_SEQUENTIAL;
  }
#line 17766 "parser.c"
    break;

  case 401: /* organization: RELATIVE  */
#line 5826 "../../cobc/parser.y"
  {
	check_repeated ("ORGANIZATION", SYN_CLAUSE_6, &check_duplicate);
	error_if_record_delimiter_incompatible (COB_ORG_RELATIVE, "RELATIVE");
	current_file->organization = COB_ORG_RELATIVE;
  }
#line 17776 "parser.c"
    break;

  case 402: /* organization: LINE SEQUENTIAL  */
#line 5832 "../../cobc/parser.y"
  {
	check_repeated ("ORGANIZATION", SYN_CLAUSE_6, &check_duplicate);
	error_if_record_delimiter_incompatible (COB_ORG_LINE_SEQUENTIAL,
						"LINE SEQUENTIAL");
	current_file->organization = COB_ORG_LINE_SEQUENTIAL;
  }
#line 17787 "parser.c"
    break;

  case 403: /* padding_character_clause: PADDING _character _is reference_or_literal  */
#line 5845 "../../cobc/parser.y"
  {
	check_repeated ("PADDING", SYN_CLAUSE_7, &check_duplicate);
	cb_verify (cb_padding_character_clause, "PADDING CHARACTER");
  }
#line 17796 "parser.c"
    break;

  case 404: /* $@34: %empty  */
#line 5855 "../../cobc/parser.y"
  {
	check_repeated ("RECORD DELIMITER", SYN_CLAUSE_8, &check_duplicate);
	current_file->flag_delimiter = 1;
  }
#line 17805 "parser.c"
    break;

  case 406: /* record_delimiter_option: "STANDARD-1"  */
#line 5864 "../../cobc/parser.y"
  {
	if (current_file->organization != COB_ORG_SEQUENTIAL) {
		cb_error (_("RECORD DELIMITER %s only allowed with SEQUENTIAL files"),
			  "STANDARD-1");
		current_file->flag_delimiter = 0;
	} else if (cb_verify (cb_record_delimiter, _("RECORD DELIMITER clause"))) {
		cb_warning (cb_warn_additional,
			    _("%s ignored"), "RECORD DELIMITER STANDARD-1");
	}
  }
#line 17820 "parser.c"
    break;

  case 407: /* record_delimiter_option: "LINE-SEQUENTIAL"  */
#line 5875 "../../cobc/parser.y"
  {
	if (current_file->organization != COB_ORG_SEQUENTIAL
	 && current_file->organization != COB_ORG_LINE_SEQUENTIAL) {
		cb_error (_("RECORD DELIMITER %s only allowed with (LINE) SEQUENTIAL files"),
			  "LINE-SEQUENTIAL");
		current_file->flag_delimiter = 0;
	}

	if (cb_verify (cb_record_delimiter, _("RECORD DELIMITER clause"))
	 && cb_verify (cb_sequential_delimiters, _("LINE-SEQUENTIAL phrase"))) {
		current_file->organization = COB_ORG_LINE_SEQUENTIAL;
	}
  }
#line 17838 "parser.c"
    break;

  case 408: /* record_delimiter_option: "BINARY-SEQUENTIAL"  */
#line 5889 "../../cobc/parser.y"
  {
	if (current_file->organization != COB_ORG_SEQUENTIAL) {
		cb_error (_("RECORD DELIMITER %s only allowed with SEQUENTIAL files"),
			  "BINARY-SEQUENTIAL");
		current_file->flag_delimiter = 0;
	}

	if (cb_verify (cb_record_delimiter, _("RECORD DELIMITER clause"))
	 && cb_verify (cb_sequential_delimiters, _("BINARY-SEQUENTIAL phrase"))) {
		current_file->organization = COB_ORG_SEQUENTIAL;
	}
  }
#line 17855 "parser.c"
    break;

  case 409: /* record_delimiter_option: "Identifier"  */
#line 5902 "../../cobc/parser.y"
  {
	if (current_file->organization != COB_ORG_SEQUENTIAL
	 && current_file->organization != COB_ORG_LINE_SEQUENTIAL) {
		cb_error (_("RECORD DELIMITER clause only allowed with (LINE) SEQUENTIAL files"));
		current_file->flag_delimiter = 0;
	} else if (cb_verify (cb_record_delimiter, _("RECORD DELIMITER clause"))) {
		cb_warning (cb_warn_additional,
			    _("RECORD DELIMITER %s not recognized; will be ignored"), cb_name (yyvsp[0]));
	}
  }
#line 17870 "parser.c"
    break;

  case 410: /* record_key_clause: RECORD _key _is reference _split_keys _password_clause flag_duplicates  */
#line 5918 "../../cobc/parser.y"
  {
	cb_tree composite_key;

	check_repeated ("RECORD KEY", SYN_CLAUSE_9, &check_duplicate);
	current_file->key = yyvsp[-3];
	key_type = RECORD_KEY;

	/* handle split keys */
	if (yyvsp[-2]) {
		/* generate field (in w-s) for composite-key */
		composite_key = cb_build_field (yyvsp[-3]);
		if (composite_key == cb_error_node) {
			YYERROR;
		} else {
			composite_key->category = CB_CATEGORY_ALPHANUMERIC;
			((struct cb_field *)composite_key)->count = 1;
			current_file->key = cb_build_field_reference ((struct cb_field *)composite_key, NULL);
			current_file->component_list = key_component_list;
		}
	}
	current_file->password = yyvsp[-1];
	if (yyvsp[0]) {
		/* note: we *may* add a compiler configuration here,
		         as most dialects do not allow this clause
		         on primary keys */
		if (CB_INTEGER (yyvsp[0])->val) {
			/* note: see ACUCOBOL docs for implementation notes, including [RE]WRITE rules
			         and "if the underlying (file) system does not support them OPEN
					 result in (sucessfull) io-status 0M" */
			CB_PENDING (_("DUPLICATES for primary keys"));
		};

	}
  }
#line 17909 "parser.c"
    break;

  case 411: /* _split_keys: %empty  */
#line 5956 "../../cobc/parser.y"
  {
  	yyval = NULL;
  }
#line 17917 "parser.c"
    break;

  case 412: /* _split_keys: source_is split_key_list  */
#line 5960 "../../cobc/parser.y"
  {
  	yyval = cb_int0;
  }
#line 17925 "parser.c"
    break;

  case 415: /* $@35: %empty  */
#line 5971 "../../cobc/parser.y"
  {
	key_component_list = NULL;
  }
#line 17933 "parser.c"
    break;

  case 418: /* split_key: reference  */
#line 5981 "../../cobc/parser.y"
  {
	struct cb_key_component *c;
	struct cb_key_component *comp = cobc_main_malloc (sizeof(struct cb_key_component));
	comp->next = NULL;
	comp->component = yyvsp[0];
	if (key_component_list == NULL) {
		key_component_list = comp;
	} else {
		for (c = key_component_list; c->next != NULL; c = c->next);
		c->next = comp;
	}
  }
#line 17950 "parser.c"
    break;

  case 419: /* relative_key_clause: RELATIVE _key _is reference  */
#line 5999 "../../cobc/parser.y"
  {
	check_repeated ("RELATIVE KEY", SYN_CLAUSE_10, &check_duplicate);
	current_file->key = yyvsp[0];
	key_type = RELATIVE_KEY;
  }
#line 17960 "parser.c"
    break;

  case 420: /* reserve_clause: RESERVE no_or_integer _areas  */
#line 6010 "../../cobc/parser.y"
  {
	check_repeated ("RESERVE", SYN_CLAUSE_11, &check_duplicate);
  }
#line 17968 "parser.c"
    break;

  case 423: /* sharing_clause: SHARING _with sharing_option  */
#line 6024 "../../cobc/parser.y"
  {
	check_repeated ("SHARING", SYN_CLAUSE_12, &check_duplicate);
	current_file->sharing = yyvsp[0];
  }
#line 17977 "parser.c"
    break;

  case 424: /* sharing_option: ALL _other  */
#line 6036 "../../cobc/parser.y"
                                { yyval = NULL; }
#line 17983 "parser.c"
    break;

  case 425: /* sharing_option: NO _other  */
#line 6037 "../../cobc/parser.y"
                                { yyval = cb_int (COB_LOCK_OPEN_EXCLUSIVE); }
#line 17989 "parser.c"
    break;

  case 426: /* sharing_option: READ ONLY  */
#line 6038 "../../cobc/parser.y"
                                { yyval = NULL; }
#line 17995 "parser.c"
    break;

  case 427: /* file_limit_clause: file_limit_or_limits _is_are thru_list  */
#line 6045 "../../cobc/parser.y"
  {
	(void)cb_verify (CB_OBSOLETE, "FILE-LIMIT");
	check_repeated ("FILE-LIMIT", SYN_CLAUSE_13, &check_duplicate);
  }
#line 18004 "parser.c"
    break;

  case 430: /* actual_key_clause: ACTUAL _key _is reference  */
#line 6060 "../../cobc/parser.y"
  {
	(void)cb_verify (CB_OBSOLETE, "ACTUAL KEY");
	check_repeated ("ACTUAL KEY", SYN_CLAUSE_14, &check_duplicate);
  }
#line 18013 "parser.c"
    break;

  case 431: /* nominal_key_clause: NOMINAL _key _is reference  */
#line 6070 "../../cobc/parser.y"
  {
	(void)cb_verify (CB_OBSOLETE, "NOMINAL KEY");
	check_repeated ("NOMINAL KEY", SYN_CLAUSE_15, &check_duplicate);
  }
#line 18022 "parser.c"
    break;

  case 432: /* track_area_clause: "TRACK-AREA" _is reference_or_literal _characters  */
#line 6080 "../../cobc/parser.y"
  {
	(void)cb_verify (CB_OBSOLETE, "TRACK-AREA");
	check_repeated ("TRACK-AREA", SYN_CLAUSE_16, &check_duplicate);
  }
#line 18031 "parser.c"
    break;

  case 433: /* track_limit_clause: "TRACK-LIMIT" _is integer track_or_tracks  */
#line 6090 "../../cobc/parser.y"
  {
	(void)cb_verify (CB_OBSOLETE, "TRACK-LIMIT");
	check_repeated ("TRACK-LIMIT", SYN_CLAUSE_17, &check_duplicate);
  }
#line 18040 "parser.c"
    break;

  case 435: /* _i_o_control: i_o_control_header _i_o_control_entries  */
#line 6101 "../../cobc/parser.y"
  {
	cobc_cs_check = 0;
  }
#line 18048 "parser.c"
    break;

  case 436: /* i_o_control_header: "I-O-CONTROL" _dot  */
#line 6108 "../../cobc/parser.y"
{
	check_headers_present(COBC_HD_ENVIRONMENT_DIVISION,
				 COBC_HD_INPUT_OUTPUT_SECTION, 0, 0);
	header_check |= COBC_HD_I_O_CONTROL;
}
#line 18058 "parser.c"
    break;

  case 439: /* _i_o_control_entries: i_o_control_list error _dot_or_else_end_of_file_control  */
#line 6118 "../../cobc/parser.y"
  {
	yyerrok;
  }
#line 18066 "parser.c"
    break;

  case 446: /* same_clause: SAME _same_option _area _for file_name_list  */
#line 6139 "../../cobc/parser.y"
  {
	cb_tree l;

	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_INPUT_OUTPUT_SECTION,
			       COBC_HD_I_O_CONTROL, 0);
	switch (CB_INTEGER (yyvsp[-3])->val) {
	case 0:
		/* SAME AREA */
		break;
	case 1:
		/* SAME RECORD */
		for (l = yyvsp[0]; l; l = CB_CHAIN (l)) {
			if (CB_VALID_TREE (CB_VALUE (l))) {
				CB_FILE (cb_ref (CB_VALUE (l)))->same_clause = same_area;
			}
		}
		same_area++;
		break;
	case 2:
		/* SAME SORT-MERGE */
		break;
	}
  }
#line 18095 "parser.c"
    break;

  case 447: /* _same_option: %empty  */
#line 6166 "../../cobc/parser.y"
                                { yyval = cb_int0; }
#line 18101 "parser.c"
    break;

  case 448: /* _same_option: RECORD  */
#line 6167 "../../cobc/parser.y"
                                { yyval = cb_int1; }
#line 18107 "parser.c"
    break;

  case 449: /* _same_option: SORT  */
#line 6168 "../../cobc/parser.y"
                                { yyval = cb_int2; }
#line 18113 "parser.c"
    break;

  case 450: /* _same_option: "SORT-MERGE"  */
#line 6169 "../../cobc/parser.y"
                                { yyval = cb_int2; }
#line 18119 "parser.c"
    break;

  case 451: /* apply_clause: APPLY COMMIT _on reference_list  */
#line 6176 "../../cobc/parser.y"
  {
	current_program->apply_commit = yyvsp[0];
	CB_PENDING("APPLY COMMIT");
  }
#line 18128 "parser.c"
    break;

  case 452: /* apply_clause: APPLY "LOCK-HOLDING" _on file_name_list  */
#line 6181 "../../cobc/parser.y"
  {
	CB_PENDING ("APPLY LOCK-HOLDING");
  }
#line 18136 "parser.c"
    break;

  case 453: /* apply_clause: APPLY "PRINT-CONTROL" _on file_name_list  */
#line 6185 "../../cobc/parser.y"
  {
	CB_PENDING ("APPLY PRINT-CONTROL");
  }
#line 18144 "parser.c"
    break;

  case 455: /* apply_clause: obsolete_dos_vs_apply_phrase  */
#line 6190 "../../cobc/parser.y"
  {
	cb_verify (CB_OBSOLETE, _("DOS/VS APPLY phrase"));
  }
#line 18152 "parser.c"
    break;

  case 464: /* $@36: %empty  */
#line 6210 "../../cobc/parser.y"
  {
	/* Fake for TAPE */
	cobc_cs_check = CB_CS_ASSIGN;
  }
#line 18161 "parser.c"
    break;

  case 465: /* multiple_file_tape_clause: MULTIPLE $@36 _file _tape _contains multiple_file_list  */
#line 6215 "../../cobc/parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_INPUT_OUTPUT_SECTION,
			       COBC_HD_I_O_CONTROL, 0);
	cb_verify (cb_multiple_file_tape_clause, "MULTIPLE FILE TAPE");
	cobc_cs_check = 0;
  }
#line 18173 "parser.c"
    break;

  case 488: /* $@37: %empty  */
#line 6295 "../../cobc/parser.y"
  {
	current_storage = CB_STORAGE_WORKING;
  }
#line 18181 "parser.c"
    break;

  case 492: /* data: DATA  */
#line 6310 "../../cobc/parser.y"
           { check_area_a_of ("DATA DIVISION"); }
#line 18187 "parser.c"
    break;

  case 493: /* data_division_header: data DIVISION _dot  */
#line 6313 "../../cobc/parser.y"
  {
	header_check |= COBC_HD_DATA_DIVISION;
  }
#line 18195 "parser.c"
    break;

  case 494: /* tok_file: "FILE"  */
#line 6320 "../../cobc/parser.y"
                   { check_area_a_of ("FILE SECTION"); }
#line 18201 "parser.c"
    break;

  case 496: /* _file_section_header: tok_file SECTION _dot  */
#line 6323 "../../cobc/parser.y"
  {
	current_storage = CB_STORAGE_FILE;
	check_headers_present (COBC_HD_DATA_DIVISION, 0, 0, 0);
	header_check |= COBC_HD_FILE_SECTION;
  }
#line 18211 "parser.c"
    break;

  case 499: /* file_description: file_description_entry _record_description_list  */
#line 6337 "../../cobc/parser.y"
  {
	if (CB_VALID_TREE (current_file)) {
		if (CB_VALID_TREE (yyvsp[0])) {
			/* Do not keep Record if this is really a report */
			if (!current_file->reports) {
				finalize_file (current_file, CB_FIELD (yyvsp[0]));
			}
		} else if (!current_file->reports) {
			cb_error (_("RECORD description missing or invalid"));
		}
	}
  }
#line 18228 "parser.c"
    break;

  case 500: /* $@38: %empty  */
#line 6355 "../../cobc/parser.y"
  {
	current_storage = CB_STORAGE_FILE;
	check_headers_present (COBC_HD_DATA_DIVISION,
			       COBC_HD_FILE_SECTION, 0, 0);
	check_duplicate = 0;
	if (CB_INVALID_TREE (yyvsp[0])) {
		current_file = NULL;
		YYERROR;
	}
	current_file = CB_FILE (cb_ref (yyvsp[0]));
	current_file->description_entry = yyvsp[0];
	if (CB_VALID_TREE (current_file)) {
		if (yyvsp[-1] == cb_int1) {
			current_file->organization = COB_ORG_SORT;
		}
		/* note: this is a HACK and should be moved */
		if (current_file->flag_finalized) {
			cb_error_x (yyvsp[0], _("duplicate file description for %s"),
				cb_name (CB_TREE (current_file)));
		}
	}
  }
#line 18255 "parser.c"
    break;

  case 502: /* file_description_entry: file_type error _dot_or_else_end_of_file_description  */
#line 6379 "../../cobc/parser.y"
  {
	yyerrok;
  }
#line 18263 "parser.c"
    break;

  case 503: /* file_type: FD  */
#line 6386 "../../cobc/parser.y"
  {
	check_area_a_of ("FD");
	yyval = cb_int0;
  }
#line 18272 "parser.c"
    break;

  case 504: /* file_type: SD  */
#line 6391 "../../cobc/parser.y"
  {
	check_area_a_of ("SD");
	yyval = cb_int1;
  }
#line 18281 "parser.c"
    break;

  case 507: /* file_description_clause: _is EXTERNAL  */
#line 6403 "../../cobc/parser.y"
  {
	check_repeated ("EXTERNAL", SYN_CLAUSE_1, &check_duplicate);
#if	0	/* RXWRXW - Global/External */
	if (current_file->flag_global) {
		cb_error (_("%s and %s are mutually exclusive"), "EXTERNAL", "GLOBAL");
	}
#endif
	current_file->flag_external = 1;
  }
#line 18295 "parser.c"
    break;

  case 508: /* file_description_clause: _is GLOBAL  */
#line 6413 "../../cobc/parser.y"
  {
	check_repeated ("GLOBAL", SYN_CLAUSE_2, &check_duplicate);
#if	0	/* RXWRXW - Global/External */
	if (current_file->flag_external) {
		cb_error (_("%s and %s are mutually exclusive"), "EXTERNAL", "GLOBAL");
	}
#endif
	if (current_program->prog_type == COB_MODULE_TYPE_FUNCTION) {
		cb_error (_("%s is invalid in a user FUNCTION"), "GLOBAL");
	} else {
		current_file->flag_global = 1;
		current_program->flag_file_global = 1;
	}
  }
#line 18314 "parser.c"
    break;

  case 518: /* block_contains_clause: BLOCK _contains integer _to_integer _records_or_characters  */
#line 6443 "../../cobc/parser.y"
  {
	check_repeated ("BLOCK", SYN_CLAUSE_3, &check_duplicate);
	/* ignore */
  }
#line 18323 "parser.c"
    break;

  case 522: /* record_clause: RECORD _contains integer _characters  */
#line 6456 "../../cobc/parser.y"
  {
	check_repeated ("RECORD", SYN_CLAUSE_4, &check_duplicate);
	if (current_file->organization == COB_ORG_LINE_SEQUENTIAL) {
		cb_warning (cb_warn_additional, _("RECORD clause ignored for LINE SEQUENTIAL"));
	} else {
		set_record_size (NULL, yyvsp[-1]);
	}
  }
#line 18336 "parser.c"
    break;

  case 523: /* record_clause: RECORD _contains integer TO integer _characters _record_depending  */
#line 6466 "../../cobc/parser.y"
  {
	check_repeated ("RECORD", SYN_CLAUSE_4, &check_duplicate);
	if (current_file->organization == COB_ORG_LINE_SEQUENTIAL) {
		cb_warning (cb_warn_additional, _("RECORD clause ignored for LINE SEQUENTIAL"));
	} else {
		set_record_size (yyvsp[-4], yyvsp[-2]);
		if (yyvsp[0]) {
			cb_verify (cb_record_contains_depending_clause, "RECORD CONTAINS DEPENDING");
			current_file->record_depending = yyvsp[0];
			current_file->flag_check_record_varying_limits =
				current_file->record_min == 0 || current_file->record_max == 0;
		}
	}
  }
#line 18355 "parser.c"
    break;

  case 524: /* record_clause: RECORD _is VARYING _in _size _from_integer _to_integer _characters _record_depending  */
#line 6482 "../../cobc/parser.y"
  {
	check_repeated ("RECORD", SYN_CLAUSE_4, &check_duplicate);
	set_record_size (yyvsp[-3], yyvsp[-2]);
	current_file->record_depending = yyvsp[0];
	current_file->flag_check_record_varying_limits =
		current_file->record_min == 0 || current_file->record_max == 0;
  }
#line 18367 "parser.c"
    break;

  case 525: /* _record_depending: %empty  */
#line 6492 "../../cobc/parser.y"
                                { yyval = NULL; }
#line 18373 "parser.c"
    break;

  case 526: /* _record_depending: DEPENDING _on reference  */
#line 6493 "../../cobc/parser.y"
                                { yyval = yyvsp[0]; }
#line 18379 "parser.c"
    break;

  case 527: /* _from_integer: %empty  */
#line 6497 "../../cobc/parser.y"
                                { yyval = NULL; }
#line 18385 "parser.c"
    break;

  case 528: /* _from_integer: _from integer  */
#line 6498 "../../cobc/parser.y"
                                { yyval = yyvsp[0]; }
#line 18391 "parser.c"
    break;

  case 529: /* _to_integer: %empty  */
#line 6502 "../../cobc/parser.y"
                                { yyval = NULL; }
#line 18397 "parser.c"
    break;

  case 530: /* _to_integer: TO integer  */
#line 6503 "../../cobc/parser.y"
                                { yyval = yyvsp[0]; }
#line 18403 "parser.c"
    break;

  case 531: /* label_records_clause: LABEL records label_option  */
#line 6511 "../../cobc/parser.y"
  {
	check_repeated ("LABEL", SYN_CLAUSE_5, &check_duplicate);
	cb_verify (cb_label_records_clause, "LABEL RECORDS");
  }
#line 18412 "parser.c"
    break;

  case 532: /* value_of_clause: VALUE OF file_id _is valueof_name  */
#line 6522 "../../cobc/parser.y"
  {
	check_repeated ("VALUE OF", SYN_CLAUSE_6, &check_duplicate);
	cb_verify (cb_value_of_clause, "VALUE OF");
  }
#line 18421 "parser.c"
    break;

  case 533: /* value_of_clause: VALUE OF "FILE-ID" _is valueof_name  */
#line 6527 "../../cobc/parser.y"
  {
	check_repeated ("VALUE OF", SYN_CLAUSE_6, &check_duplicate);
	cb_verify (cb_value_of_clause, "VALUE OF");
	if (!current_file->assign) {
		current_file->assign = cb_build_assignment_name (current_file, yyvsp[0]);
	}
  }
#line 18433 "parser.c"
    break;

  case 538: /* data_records_clause: DATA records optional_reference_list  */
#line 6550 "../../cobc/parser.y"
  {
	check_repeated ("DATA", SYN_CLAUSE_7, &check_duplicate);
	cb_verify (cb_data_records_clause, "DATA RECORDS");
  }
#line 18442 "parser.c"
    break;

  case 539: /* linage_clause: LINAGE _is reference_or_literal _lines _linage_sequence  */
#line 6562 "../../cobc/parser.y"
  {
	check_repeated ("LINAGE", SYN_CLAUSE_8, &check_duplicate);
	if (current_file->organization != COB_ORG_LINE_SEQUENTIAL &&
	    current_file->organization != COB_ORG_SEQUENTIAL) {
		cb_error (_("LINAGE clause with wrong file type"));
	} else {
		current_file->linage = yyvsp[-2];
		current_file->organization = COB_ORG_LINE_SEQUENTIAL;
		if (current_linage == 0) {
			linage_file = current_file;
		}
		current_linage++;
	}
  }
#line 18461 "parser.c"
    break;

  case 545: /* linage_footing: _with FOOTING _at reference_or_literal  */
#line 6590 "../../cobc/parser.y"
  {
	current_file->latfoot = yyvsp[0];
  }
#line 18469 "parser.c"
    break;

  case 546: /* linage_top: TOP reference_or_literal  */
#line 6597 "../../cobc/parser.y"
  {
	current_file->lattop = yyvsp[0];
  }
#line 18477 "parser.c"
    break;

  case 547: /* linage_bottom: BOTTOM reference_or_literal  */
#line 6604 "../../cobc/parser.y"
  {
	current_file->latbot = yyvsp[0];
  }
#line 18485 "parser.c"
    break;

  case 548: /* recording_mode_clause: RECORDING _mode _is recording_mode  */
#line 6613 "../../cobc/parser.y"
  {
	cobc_cs_check ^= CB_CS_RECORDING;
	check_repeated ("RECORDING", SYN_CLAUSE_9, &check_duplicate);
	/* ignore */
  }
#line 18495 "parser.c"
    break;

  case 553: /* recording_mode: u_or_s  */
#line 6626 "../../cobc/parser.y"
  {
	if (current_file->organization != COB_ORG_SEQUENTIAL) {
		cb_error (_("RECORDING MODE U or S can only be used with RECORD SEQUENTIAL files"));
	}
  }
#line 18505 "parser.c"
    break;

  case 556: /* code_set_clause: "CODE-SET" _is alphabet_name _for_sub_records_clause  */
#line 6642 "../../cobc/parser.y"
  {
	struct cb_alphabet_name	*al;

	check_repeated ("CODE SET", SYN_CLAUSE_10, &check_duplicate);

	if (CB_VALID_TREE (yyvsp[-1])) {
		al = CB_ALPHABET_NAME (cb_ref (yyvsp[-1]));
		/* FIXME: should be set depending on program alphabet */
		switch (al->alphabet_type) {
		case CB_ALPHABET_CUSTOM:
			CB_PENDING ("custom CODE-SET");
			current_file->code_set = al;
			break;
#ifdef	COB_EBCDIC_MACHINE
		case CB_ALPHABET_ASCII:
#else
		case CB_ALPHABET_EBCDIC:
#endif
			CB_UNFINISHED ("CODE-SET");
			current_file->code_set = al;
			break;
		default:
			if (get_warn_opt_value (cb_warn_additional) != COBC_WARN_DISABLED) {
				cb_note_x (cb_warn_additional, yyvsp[-1], _("ignoring CODE-SET '%s'"),
						  cb_name (yyvsp[-1]));
			}
			break;
		}
	}

	if (current_file->organization != COB_ORG_LINE_SEQUENTIAL &&
	    current_file->organization != COB_ORG_SEQUENTIAL) {
		cb_error (_("CODE-SET clause invalid for file type"));
	}

  }
#line 18546 "parser.c"
    break;

  case 558: /* _for_sub_records_clause: FOR reference_list  */
#line 6682 "../../cobc/parser.y"
  {
	  current_file->code_set_items = CB_LIST (yyvsp[0]);
  }
#line 18554 "parser.c"
    break;

  case 559: /* report_clause: report_keyword rep_name_list  */
#line 6691 "../../cobc/parser.y"
  {
	check_repeated ("REPORT", SYN_CLAUSE_11, &check_duplicate);
	if (current_file->organization != COB_ORG_LINE_SEQUENTIAL &&
	    current_file->organization != COB_ORG_SEQUENTIAL) {
		cb_error (_("REPORT clause with wrong file type"));
	} else {
		current_file->reports = yyvsp[0];
		current_file->organization = COB_ORG_LINE_SEQUENTIAL;
		current_file->flag_line_adv = 1;
	}
  }
#line 18570 "parser.c"
    break;

  case 562: /* rep_name_list: undefined_word_but_no_error  */
#line 6711 "../../cobc/parser.y"
  {
	if (CB_VALID_TREE (yyvsp[0])) {
		current_report = build_report (yyvsp[0]);
		current_report->file = current_file;
		current_program->report_list =
			cb_list_add (current_program->report_list,
				     CB_TREE (current_report));
		if (report_count == 0) {
			report_instance = current_report;
		}
		report_count++;
	}
  }
#line 18588 "parser.c"
    break;

  case 563: /* rep_name_list: rep_name_list undefined_word_but_no_error  */
#line 6725 "../../cobc/parser.y"
  {
	if (CB_VALID_TREE (yyvsp[0])) {
		current_report = build_report (yyvsp[0]);
		current_report->file = current_file;
		current_program->report_list =
			cb_list_add (current_program->report_list,
				     CB_TREE (current_report));
#if 0	/* not possible, as long as we don't have this code
     	   twice instead of in a function */
		if (report_count == 0) {
			report_instance = current_report;
		}
#endif
		report_count++;
	}
  }
#line 18609 "parser.c"
    break;

  case 564: /* communication: COMMUNICATION  */
#line 6745 "../../cobc/parser.y"
                             { check_area_a_of ("COMMUNICATION SECTION"); }
#line 18615 "parser.c"
    break;

  case 566: /* $@39: %empty  */
#line 6748 "../../cobc/parser.y"
  {
	current_storage = CB_STORAGE_COMMUNICATION;
	check_headers_present (COBC_HD_DATA_DIVISION, 0, 0, 0);
	header_check |= COBC_HD_COMMUNICATION_SECTION;
	/* add a compiler configuration if either */
	if (cb_std_define != CB_STD_85
	 && cb_std_define != CB_STD_RM
	 && cb_std_define != CB_STD_GC
	 && !cb_relaxed_syntax_checks) {
		cb_verify (CB_UNCONFORMABLE, "COMMUNICATION SECTION");
	} else if (cb_verify (CB_OBSOLETE, "COMMUNICATION SECTION")) {
		CB_PENDING ("COMMUNICATION SECTION");
	}
  }
#line 18634 "parser.c"
    break;

  case 570: /* communication_description: communication_description_entry _record_description_list  */
#line 6772 "../../cobc/parser.y"
  {
	if (CB_VALID_TREE (current_cd)) {
		if (CB_VALID_TREE (yyvsp[0])) {
			cb_finalize_cd (current_cd, CB_FIELD (yyvsp[0]));
		} else if (!current_cd->record) {
			cb_error (_("CD record missing"));
		}
	}
  }
#line 18648 "parser.c"
    break;

  case 571: /* cd: CD  */
#line 6785 "../../cobc/parser.y"
       { check_area_a_of ("CD"); }
#line 18654 "parser.c"
    break;

  case 572: /* $@40: %empty  */
#line 6788 "../../cobc/parser.y"
  {
	/* CD internally defines a new file */
	if (CB_VALID_TREE (yyvsp[0])) {
		current_cd = cb_build_cd (yyvsp[0]);

		CB_ADD_TO_CHAIN (CB_TREE (current_cd),
				 current_program->cd_list);
	} else {
		current_cd = NULL;
		/* TO-DO: Is this necessary? */
		if (current_program->cd_list) {
			current_program->cd_list
				= CB_CHAIN (current_program->cd_list);
		}
	}
	check_duplicate = 0;
  }
#line 18676 "parser.c"
    break;

  case 619: /* working_storage: "WORKING-STORAGE"  */
#line 6895 "../../cobc/parser.y"
                                 { check_area_a_of ("WORKING-STORAGE SECTION"); }
#line 18682 "parser.c"
    break;

  case 621: /* $@41: %empty  */
#line 6899 "../../cobc/parser.y"
  {
	check_headers_present (COBC_HD_DATA_DIVISION, 0, 0, 0);
	header_check |= COBC_HD_WORKING_STORAGE_SECTION;
	current_storage = CB_STORAGE_WORKING;
  }
#line 18692 "parser.c"
    break;

  case 622: /* _working_storage_section: working_storage SECTION _dot_or_else_end_of_record_description $@41 _record_description_list  */
#line 6905 "../../cobc/parser.y"
  {
	if (yyvsp[0]) {
		CB_FIELD_ADD (current_program->working_storage, CB_FIELD (yyvsp[0]));
	}
  }
#line 18702 "parser.c"
    break;

  case 623: /* _record_description_list: %empty  */
#line 6914 "../../cobc/parser.y"
  {
	yyval = NULL;
  }
#line 18710 "parser.c"
    break;

  case 624: /* $@42: %empty  */
#line 6918 "../../cobc/parser.y"
  {
	current_field = NULL;
	control_field = NULL;
	description_field = NULL;
	cb_clear_real_field ();
  }
#line 18721 "parser.c"
    break;

  case 625: /* _record_description_list: $@42 record_description_list  */
#line 6925 "../../cobc/parser.y"
  {
	yyval = get_finalized_description_tree ();
  }
#line 18729 "parser.c"
    break;

  case 631: /* $@43: %empty  */
#line 6940 "../../cobc/parser.y"
  {
	const int level = cb_get_level (yyvsp[-1]);
	if (current_field && !CB_INVALID_TREE (current_field->external_definition)) {
		/* finalize last field if target of SAME AS / type-name */
		inherit_external_definition (level);
	}
	if (set_current_field (level, yyvsp[0])) {
		YYERROR;
	}
	save_tree = NULL;
  }
#line 18745 "parser.c"
    break;

  case 632: /* data_description: level_number _entry_name $@43 _data_description_clause_sequence  */
#line 6952 "../../cobc/parser.y"
  {
	if (!qualifier) {
		current_field->flag_filler = 1;
	}
	if (!description_field) {
		description_field = current_field;
	}
  }
#line 18758 "parser.c"
    break;

  case 633: /* data_description: level_number error "."  */
#line 6961 "../../cobc/parser.y"
  {
	yyerrok;
	cb_unput_dot ();
	check_pic_duplicate = 0;
	check_duplicate = 0;
#if 0 /* CHECKME - *Why* would we want to change the field here? */
	current_field = cb_get_real_field ();
#endif
  }
#line 18772 "parser.c"
    break;

  case 634: /* level_number: not_const_word "level-number"  */
#line 6974 "../../cobc/parser.y"
  {
	const int	level = cb_get_level (yyvsp[0]);
	switch (level) {
	case 1:
	case 77:
		check_area_a (yyvsp[0]);
		break;
	default:
		break;
	}
	yyval = yyvsp[0];
  }
#line 18789 "parser.c"
    break;

  case 635: /* level_number: not_const_word "level-number (Area A)"  */
#line 6987 "../../cobc/parser.y"
  {
	yyval = yyvsp[0];
  }
#line 18797 "parser.c"
    break;

  case 638: /* _entry_name: _filler  */
#line 6999 "../../cobc/parser.y"
  {
	yyval = cb_build_filler ();
	qualifier = NULL;
	keys_list = NULL;
	non_const_word = 0;
  }
#line 18808 "parser.c"
    break;

  case 640: /* user_entry_name: "Identifier"  */
#line 7010 "../../cobc/parser.y"
  {
	yyval = yyvsp[0];
	qualifier = yyvsp[0];
	keys_list = NULL;
	non_const_word = 0;
  }
#line 18819 "parser.c"
    break;

  case 641: /* _const_global: %empty  */
#line 7020 "../../cobc/parser.y"
  {
	yyval = NULL;
  }
#line 18827 "parser.c"
    break;

  case 642: /* _const_global: _is GLOBAL  */
#line 7024 "../../cobc/parser.y"
  {
	if (current_program->prog_type == COB_MODULE_TYPE_FUNCTION) {
		cb_error (_("%s is invalid in a user FUNCTION"), "GLOBAL");
		yyval = NULL;
	} else {
		yyval = cb_null;
	}
  }
#line 18840 "parser.c"
    break;

  case 643: /* lit_or_length: literal  */
#line 7035 "../../cobc/parser.y"
                                        { yyval = yyvsp[0]; }
#line 18846 "parser.c"
    break;

  case 644: /* lit_or_length: length_of_register con_source  */
#line 7036 "../../cobc/parser.y"
                                                { yyval = cb_build_const_length (yyvsp[0]); }
#line 18852 "parser.c"
    break;

  case 645: /* lit_or_length: "BYTE-LENGTH" _of con_source  */
#line 7038 "../../cobc/parser.y"
                                { yyval = cb_build_const_length (yyvsp[0]); }
#line 18858 "parser.c"
    break;

  case 646: /* con_source: identifier_1  */
#line 7043 "../../cobc/parser.y"
  {
	yyval = yyvsp[0];
  }
#line 18866 "parser.c"
    break;

  case 647: /* con_source: non_numeric_literal  */
#line 7047 "../../cobc/parser.y"
  {
	yyval = yyvsp[0];
  }
#line 18874 "parser.c"
    break;

  case 648: /* con_source: "BINARY-CHAR"  */
#line 7053 "../../cobc/parser.y"
  {
	yyval = cb_int1;
  }
#line 18882 "parser.c"
    break;

  case 649: /* con_source: "BINARY-SHORT"  */
#line 7057 "../../cobc/parser.y"
  {
	yyval = cb_int2;
  }
#line 18890 "parser.c"
    break;

  case 650: /* con_source: "BINARY-LONG"  */
#line 7061 "../../cobc/parser.y"
  {
	yyval = cb_int4;
  }
#line 18898 "parser.c"
    break;

  case 651: /* con_source: "BINARY-DOUBLE"  */
#line 7065 "../../cobc/parser.y"
  {
	yyval = cb_int8;
  }
#line 18906 "parser.c"
    break;

  case 652: /* con_source: "BINARY-C-LONG"  */
#line 7069 "../../cobc/parser.y"
  {
	yyval = cb_int ((int)sizeof(long));
  }
#line 18914 "parser.c"
    break;

  case 653: /* con_source: pointer_len  */
#line 7073 "../../cobc/parser.y"
  {
	yyval = cb_int ((int)sizeof(void *));
  }
#line 18922 "parser.c"
    break;

  case 654: /* con_source: "COMP-1"  */
#line 7077 "../../cobc/parser.y"
  {
	if (cb_binary_comp_1) {
		yyval = cb_int2;
	} else {
		yyval = cb_int ((int)sizeof(float));
	}
  }
#line 18934 "parser.c"
    break;

  case 655: /* con_source: "FLOAT-SHORT"  */
#line 7085 "../../cobc/parser.y"
  {
	yyval = cb_int ((int)sizeof(float));
  }
#line 18942 "parser.c"
    break;

  case 656: /* con_source: double_usage  */
#line 7089 "../../cobc/parser.y"
  {
	yyval = cb_int ((int)sizeof(double));
  }
#line 18950 "parser.c"
    break;

  case 657: /* con_source: long_double  */
#line 7093 "../../cobc/parser.y"
  {
#if 1 /* fixed-sized as in field.c */
	yyval = cb_int (16);
#else
	yyval = cb_int ((int)sizeof(long double));
#endif
  }
#line 18962 "parser.c"
    break;

  case 658: /* con_source: fp32_usage  */
#line 7101 "../../cobc/parser.y"
  {
	yyval = cb_int4;
  }
#line 18970 "parser.c"
    break;

  case 659: /* con_source: fp64_usage  */
#line 7105 "../../cobc/parser.y"
  {
	yyval = cb_int8;
  }
#line 18978 "parser.c"
    break;

  case 660: /* con_source: fp128_usage  */
#line 7109 "../../cobc/parser.y"
  {
	yyval = cb_int16;
  }
#line 18986 "parser.c"
    break;

  case 661: /* con_source: error "."  */
#line 7113 "../../cobc/parser.y"
  {
	yyerrok;
	cb_unput_dot ();
	check_pic_duplicate = 0;
	check_duplicate = 0;
	current_field = cb_get_real_field ();
  }
#line 18998 "parser.c"
    break;

  case 670: /* renames_entry: "level-number 66" user_entry_name RENAMES not_const_word qualified_word _renames_thru  */
#line 7144 "../../cobc/parser.y"
  {
	cb_tree renames_target = cb_ref (yyvsp[-1]);

	size_t sav = cb_needs_01;
	cb_needs_01 = 0;

	non_const_word = 0;

	if (set_current_field (66, yyvsp[-4])) {
		/* error in the definition, no further checks possible */
	} else if (renames_target == cb_error_node) {
		/* error in the target, skip further checks */
		current_field->flag_invalid = 1;
	} else {
		cb_tree renames_thru = yyvsp[0];

		current_field->redefines = CB_FIELD (renames_target);
		if (renames_thru) {
			renames_thru = cb_ref (renames_thru);
		}
		if (CB_VALID_TREE (renames_thru)) {
			current_field->rename_thru = CB_FIELD (renames_thru);
		} else {
			/* If there is no THRU clause, RENAMES acts like REDEFINES. */
			current_field->pic = current_field->redefines->pic;
		}

		if (cb_validate_renames_item (current_field, yyvsp[-1], yyvsp[0])) {
			current_field->flag_invalid = 1;
		} else {
			/* ensure the reference was validated as this
			   also calculates the reference' picture and size */
			if (!current_field->redefines->flag_is_verified) {
				cb_validate_field (current_field->redefines);
			}
		}
	}
	cb_needs_01 = sav;
  }
#line 19042 "parser.c"
    break;

  case 671: /* _renames_thru: %empty  */
#line 7187 "../../cobc/parser.y"
  {
	yyval = NULL;
  }
#line 19050 "parser.c"
    break;

  case 672: /* _renames_thru: THRU qualified_word  */
#line 7191 "../../cobc/parser.y"
  {
	yyval = yyvsp[0] == cb_error_node ? NULL : yyvsp[0];
  }
#line 19058 "parser.c"
    break;

  case 673: /* $@44: %empty  */
#line 7198 "../../cobc/parser.y"
  {
	if (set_current_field (88, yyvsp[0])) {
		YYERROR;
	}
  }
#line 19068 "parser.c"
    break;

  case 674: /* condition_name_entry: "level-number 88" _user_entry_name $@44 value_clause_condition  */
#line 7204 "../../cobc/parser.y"
  {
	cb_validate_88_item (current_field);
  }
#line 19076 "parser.c"
    break;

  case 675: /* _user_entry_name: %empty  */
#line 7211 "../../cobc/parser.y"
  {
	yyval = cb_build_filler ();
	qualifier = NULL;
	keys_list = NULL;
	non_const_word = 0;
  }
#line 19087 "parser.c"
    break;

  case 677: /* constant_entry: level_number user_entry_name CONSTANT _const_global constant_source  */
#line 7222 "../../cobc/parser.y"
  {
	cb_tree x;
	const int level = cb_get_level (yyvsp[-4]);

	cobc_cs_check = 0;
	if (level != 1) {
		cb_error (_("C