/*
 *  GNU Kart
 *
 *  Copyright (C) 2010 Eric P. Hutchins
 *
 *  GNU Kart is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *  
 *  GNU Kart is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Kart.  If not, see <http://www.gnu.org/licenses/>.
 **/

#ifndef KART_H
#define KART_H

#include "SDL.h"
#include <GL/gl.h>

#include "model.h"

typedef struct
{
  double size;
  double x;
  double y;
  double z;
  int turning;
  double speed;
  double direction;
  int forward;
  double r;
  double g;
  double b;
  Model *model;
  int *current_edges;
  int n_current_edges;
} Kart;

extern double camdir;
extern double camx;
extern double camy;
extern double camz;

Kart *kart_new (double size, double x, double y, double z,
                double r, double g, double b, double direction, Model *model);

void kart_draw (Kart *a);

void kart_destroy (Kart *kart);

#endif
