/*
 *  GNU Kart
 *
 *  Copyright (C) 2010 Eric P. Hutchins
 *
 *  GNU Kart is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *  
 *  GNU Kart is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Kart.  If not, see <http://www.gnu.org/licenses/>.
 **/

#ifndef MODEL_H
#define MODEL_H

#include <stdio.h>

#include <GL/gl.h>

typedef struct
{
  float x;
  float y;
  float z;
} Vert;

typedef struct
{
  int v1;
  int v2;
  int v3;
  int vn1;
  int vn2;
  int vn3;
} Face;

typedef struct
{
  char *name;
  int face_count;
  Face *faces;
  int material_index;
} Object;

typedef struct
{
  char *name;
  float r;
  float g;
  float b;
} Material;

typedef struct
{
  int vert_count;
  int normal_count;
  int material_count;
  int object_count;
  Vert *normals;
  Vert *verts;
  Object *objects;
  Material *materials;
} Model;

extern double camdir;
extern double camx;
extern double camy;
extern double camz;

Model *model_new_from_obj (char *filename);

void model_draw (Model *model, float x, float y, float z,
                 float direction, float r, float g, float b);

void model_destroy (Model *model);

#endif
