/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.vm.buildins.misc;

import gnu.prolog.database.Predicate;
import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.CompoundTermTag;
import gnu.prolog.term.IntegerTerm;
import gnu.prolog.term.Term;
import gnu.prolog.term.VariableTerm;
import gnu.prolog.vm.BacktrackInfo;
import gnu.prolog.vm.ExecuteOnlyCode;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologException;
import gnu.prolog.vm.TermConstants;
import java.util.HashSet;
import java.util.Iterator;

public class Predicate_current_functor
extends ExecuteOnlyCode {
    @Override
    public int execute(Interpreter interpreter, boolean backtrackMode, Term[] args) throws PrologException {
        if (backtrackMode) {
            CurrentPredicateBacktrackInfo bi = (CurrentPredicateBacktrackInfo)interpreter.popBacktrackInfo();
            interpreter.undo(bi.startUndoPosition);
            return Predicate_current_functor.nextSolution(interpreter, bi);
        }
        Term functor = args[0];
        Term arity = args[1];
        if (!(functor instanceof VariableTerm) && !(functor instanceof AtomTerm)) {
            PrologException.typeError(TermConstants.atomAtom, functor);
        }
        if (!(arity instanceof VariableTerm) && !(arity instanceof IntegerTerm)) {
            PrologException.typeError(TermConstants.integerAtom, arity);
        }
        HashSet<CompoundTermTag> tagSet = new HashSet<CompoundTermTag>(interpreter.getEnvironment().getModule().getPredicateTags());
        CurrentPredicateBacktrackInfo bi = new CurrentPredicateBacktrackInfo();
        bi.startUndoPosition = interpreter.getUndoPosition();
        bi.functor = functor;
        bi.arity = arity;
        bi.tagsIterator = tagSet.iterator();
        return Predicate_current_functor.nextSolution(interpreter, bi);
    }

    private static int nextSolution(Interpreter interpreter, CurrentPredicateBacktrackInfo bi) throws PrologException {
        while (bi.tagsIterator.hasNext()) {
            CompoundTermTag tag = bi.tagsIterator.next();
            Predicate p = interpreter.getEnvironment().getModule().getDefinedPredicate(tag);
            if (p == null) continue;
            int rc = interpreter.unify(bi.functor, tag.functor);
            if (rc == -1) {
                interpreter.undo(bi.startUndoPosition);
                continue;
            }
            rc = interpreter.unify(bi.arity, IntegerTerm.get(tag.arity));
            if (rc == -1) {
                interpreter.undo(bi.startUndoPosition);
                continue;
            }
            interpreter.pushBacktrackInfo(bi);
            return 0;
        }
        return -1;
    }

    private static class CurrentPredicateBacktrackInfo
    extends BacktrackInfo {
        int startUndoPosition;
        Iterator<CompoundTermTag> tagsIterator;
        Term functor;
        Term arity;

        CurrentPredicateBacktrackInfo() {
            super(-1, -1);
        }
    }
}

