/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.database;

import gnu.prolog.database.Predicate;
import gnu.prolog.database.PrologTextLoaderError;
import gnu.prolog.database.PrologTextLoaderState;
import gnu.prolog.io.OperatorSet;
import gnu.prolog.io.ParseException;
import gnu.prolog.io.TermReader;
import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.CompoundTerm;
import gnu.prolog.term.CompoundTermTag;
import gnu.prolog.term.IntegerTerm;
import gnu.prolog.term.Term;
import gnu.prolog.term.VariableTerm;
import gnu.prolog.vm.TermConstants;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Stack;

public class PrologTextLoader {
    protected String rootFile;
    protected String currentFile;
    protected TermReader currentReader;
    protected Stack<TermReader> readerStack = new Stack();
    protected Stack<String> fileStack = new Stack();
    protected OperatorSet operatorSet = new OperatorSet();
    protected PrologTextLoaderState prologTextLoaderState;
    public static final CompoundTermTag includeTag = CompoundTermTag.get("include", 1);
    public static final CompoundTermTag multifileTag = CompoundTermTag.get("multifile", 1);
    public static final CompoundTermTag dynamicTag = CompoundTermTag.get("dynamic", 1);
    public static final CompoundTermTag discontiguousTag = CompoundTermTag.get("discontiguous", 1);
    public static final CompoundTermTag opTag = CompoundTermTag.get("op", 3);
    public static final CompoundTermTag char_conversionTag = CompoundTermTag.get("char_conversion", 2);
    public static final CompoundTermTag initializationTag = CompoundTermTag.get("initialization", 1);
    public static final CompoundTermTag ensure_loadedTag = CompoundTermTag.get("ensure_loaded", 1);
    public static final CompoundTermTag set_prolog_flagTag = CompoundTermTag.get("set_prolog_flag", 2);
    public static final CompoundTermTag externalTag = CompoundTermTag.get("external", 2);
    public static final CompoundTermTag build_inTag = CompoundTermTag.get("build_in", 2);
    public static final CompoundTermTag controlTag = CompoundTermTag.get("control", 2);
    public static final CompoundTermTag url1Tag = CompoundTermTag.get("url", 1);
    public static final CompoundTermTag resource1Tag = CompoundTermTag.get("resource", 1);
    public static final CompoundTermTag file1Tag = CompoundTermTag.get("file", 1);

    protected PrologTextLoader(PrologTextLoaderState prologTextLoaderState) {
        this.prologTextLoaderState = prologTextLoaderState;
    }

    public PrologTextLoader(PrologTextLoaderState prologTextLoaderState, Term root) {
        this(prologTextLoaderState);
        this.currentFile = this.rootFile = prologTextLoaderState.getInputName(root);
        try {
            this.currentReader = new TermReader(new InputStreamReader(prologTextLoaderState.getInputStream(root)), prologTextLoaderState.getEnvironment());
        }
        catch (Exception ex) {
            this.logError("could not open file '" + this.currentFile + "': " + ex.getMessage());
            return;
        }
        this.processFile();
    }

    public PrologTextLoader(PrologTextLoaderState prologTextLoaderState, Reader stream) {
        this(prologTextLoaderState, stream, "input:");
    }

    public PrologTextLoader(PrologTextLoaderState prologTextLoaderState, Reader stream, String streamName) {
        this(prologTextLoaderState);
        if (streamName == null || streamName.length() == 0) {
            streamName = "input:";
        }
        this.currentFile = this.rootFile = streamName;
        try {
            this.currentReader = new TermReader(stream, prologTextLoaderState.getEnvironment());
        }
        catch (Exception ex) {
            this.logError("could not open stream '" + this.currentFile + "': " + ex.getMessage());
            return;
        }
        this.processFile();
    }

    public String getCurrentFile() {
        return this.currentFile;
    }

    public int getCurrentLine() {
        if (this.currentReader == null) {
            return 0;
        }
        return this.currentReader.getCurrentLine();
    }

    public int getCurrentColumn() {
        if (this.currentReader == null) {
            return 0;
        }
        return this.currentReader.getCurrentColumn();
    }

    public PrologTextLoaderError getCurrentPartialLoaderError() {
        return new PrologTextLoaderError(this.getCurrentFile(), this.getCurrentLine(), this.getCurrentColumn(), null);
    }

    public PrologTextLoaderState getPrologTextLoaderState() {
        return this.prologTextLoaderState;
    }

    protected void processFile() {
        this.prologTextLoaderState.beforeProcessFile(this);
        while (this.currentReader != null) {
            Term term;
            try {
                term = this.currentReader.readTerm(this.operatorSet);
            }
            catch (ParseException ex) {
                this.logError(ex);
                continue;
            }
            if (term == null) {
                this.processEof();
                continue;
            }
            if (term instanceof AtomTerm) {
                this.processClause(term);
                continue;
            }
            if (term instanceof CompoundTerm) {
                CompoundTerm cterm = (CompoundTerm)term;
                if (cterm.tag != TermConstants.directiveTag) {
                    this.processClause(term);
                    continue;
                }
                if (!(cterm.args[0] instanceof CompoundTerm)) {
                    this.logError("invalid directive term");
                    continue;
                }
                CompoundTerm dirTerm = (CompoundTerm)cterm.args[0];
                CompoundTermTag dirTag = dirTerm.tag;
                if (dirTag == includeTag) {
                    this.processIncludeDirective(dirTerm.args[0]);
                    continue;
                }
                if (dirTag == multifileTag) {
                    this.processMultifileDirective(dirTerm.args[0]);
                    continue;
                }
                if (dirTag == dynamicTag) {
                    this.processDynamicDirective(dirTerm.args[0]);
                    continue;
                }
                if (dirTag == discontiguousTag) {
                    this.processDiscontiguousDirective(dirTerm.args[0]);
                    continue;
                }
                if (dirTag == opTag) {
                    this.processOpDirective(dirTerm.args[0], dirTerm.args[1], dirTerm.args[2]);
                    continue;
                }
                if (dirTag == char_conversionTag) {
                    this.processCharConversionDirective(dirTerm.args[0], dirTerm.args[1]);
                    continue;
                }
                if (dirTag == initializationTag) {
                    this.processInitializationDirective(dirTerm.args[0]);
                    continue;
                }
                if (dirTag == ensure_loadedTag) {
                    this.processEnsureLoadedDirective(dirTerm.args[0]);
                    continue;
                }
                if (dirTag == set_prolog_flagTag) {
                    this.processSetPrologFlagDirective(dirTerm.args[0], dirTerm.args[1]);
                    continue;
                }
                if (dirTag == externalTag) {
                    this.processExternalDirective(dirTerm.args[0], dirTerm.args[1]);
                    continue;
                }
                if (dirTag == controlTag) {
                    this.processControlDirective(dirTerm.args[0], dirTerm.args[1]);
                    continue;
                }
                if (dirTag == build_inTag) {
                    this.processBuildInDirective(dirTerm.args[0], dirTerm.args[1]);
                    continue;
                }
                this.processInitializationDirective(dirTerm);
                continue;
            }
            this.logError("term is not a clause or directive");
        }
        this.prologTextLoaderState.afterProcessFile(this);
    }

    protected void processSetPrologFlagDirective(Term arg0, Term arg1) {
        this.prologTextLoaderState.addInitialization(this, new CompoundTerm(set_prolog_flagTag, arg0, arg1));
    }

    protected void processBuildInDirective(Term pi, Term className) {
        if (!(className instanceof AtomTerm)) {
            this.logError("class name should be atom term");
            return;
        }
        if (!(pi instanceof CompoundTerm)) {
            this.logError("predicate indicator should be a compound term");
            return;
        }
        this.prologTextLoaderState.defineExternal(this, (CompoundTerm)pi, ((AtomTerm)className).value, Predicate.TYPE.BUILD_IN);
    }

    protected void processControlDirective(Term pi, Term className) {
        if (!(className instanceof AtomTerm)) {
            this.logError("class name should be atom term");
            return;
        }
        if (!(pi instanceof CompoundTerm)) {
            this.logError("predicate indicator should be a compound term");
            return;
        }
        this.prologTextLoaderState.defineExternal(this, (CompoundTerm)pi, ((AtomTerm)className).value, Predicate.TYPE.CONTROL);
    }

    protected void processExternalDirective(Term pi, Term className) {
        if (!(className instanceof AtomTerm)) {
            this.logError("class name should be atom term");
            return;
        }
        if (!(pi instanceof CompoundTerm)) {
            this.logError("predicate indicator should be a compound term");
            return;
        }
        this.prologTextLoaderState.defineExternal(this, (CompoundTerm)pi, ((AtomTerm)className).value, Predicate.TYPE.EXTERNAL);
    }

    protected void processInitializationDirective(Term term) {
        this.prologTextLoaderState.addInitialization(this, term);
    }

    protected void processCharConversionDirective(Term from, Term to) {
        if (from instanceof AtomTerm) {
            if (((AtomTerm)from).value.length() != 1) {
                this.logError("Should be a single length atom");
                return;
            }
        } else {
            if (from instanceof VariableTerm) {
                this.logError("instantiation error");
                return;
            }
            this.logError("representation error");
            return;
        }
        if (to instanceof AtomTerm) {
            if (((AtomTerm)to).value.length() != 1) {
                this.logError("Should be a single length atom");
                return;
            }
        } else {
            if (to instanceof VariableTerm) {
                this.logError("instantiation error");
                return;
            }
            this.logError("representation error");
            return;
        }
        char cfrom = ((AtomTerm)from).value.charAt(0);
        char cto = ((AtomTerm)to).value.charAt(0);
        this.prologTextLoaderState.getConversionTable().setConversion(cfrom, cto);
    }

    protected void processOpDirective(Term priority, Term specifier, Term operatorAtom) {
        if (!(specifier instanceof AtomTerm)) {
            this.logError("the specifier should be an atom term");
            return;
        }
        if (!(priority instanceof IntegerTerm)) {
            this.logError("the priority should be an integer term");
            return;
        }
        if (!(operatorAtom instanceof AtomTerm)) {
            this.logError("the functor should be an atom term");
            return;
        }
        int spec = -1;
        if (specifier == TermConstants.fxAtom) {
            spec = 0;
        } else if (specifier == TermConstants.fyAtom) {
            spec = 1;
        } else if (specifier == TermConstants.xfxAtom) {
            spec = 2;
        } else if (specifier == TermConstants.xfyAtom) {
            spec = 3;
        } else if (specifier == TermConstants.yfxAtom) {
            spec = 4;
        } else if (specifier == TermConstants.xfAtom) {
            spec = 5;
        } else if (specifier == TermConstants.yfAtom) {
            spec = 6;
        } else {
            this.logError("invalid operator specifier");
        }
        this.operatorSet.add(((IntegerTerm)priority).value, spec, ((AtomTerm)operatorAtom).value);
        this.prologTextLoaderState.addInitialization(this, new CompoundTerm(opTag, new Term[]{priority, specifier, operatorAtom}));
    }

    protected void processDiscontiguousDirective(Term pi) {
        if (!CompoundTermTag.isPredicateIndicator(pi)) {
            this.logError("the predicate indicator is not valid.");
            return;
        }
        CompoundTermTag tag = CompoundTermTag.get((CompoundTerm)pi);
        this.prologTextLoaderState.declareDiscontiguous(this, tag);
    }

    protected void processMultifileDirective(Term pi) {
        if (!CompoundTermTag.isPredicateIndicator(pi)) {
            this.logError("the predicate indicator is not valid.");
            return;
        }
        CompoundTermTag tag = CompoundTermTag.get((CompoundTerm)pi);
        this.prologTextLoaderState.declareMultifile(this, tag);
    }

    protected void processDynamicDirective(Term pi) {
        if (!CompoundTermTag.isPredicateIndicator(pi)) {
            this.logError("the predicate indicator is not valid.");
            return;
        }
        CompoundTermTag tag = CompoundTermTag.get((CompoundTerm)pi);
        this.prologTextLoaderState.declareDynamic(this, tag);
    }

    protected void processClause(Term argument) {
        this.prologTextLoaderState.addClause(this, argument);
    }

    protected void processIncludeDirective(Term argument) {
        try {
            this.prologTextLoaderState.beforeIncludeFile(this, argument);
            TermReader reader = new TermReader(new InputStreamReader(this.prologTextLoaderState.getInputStream(argument)), this.prologTextLoaderState.getEnvironment());
            this.readerStack.push(this.currentReader);
            this.fileStack.push(this.currentFile);
            this.currentReader = reader;
            this.currentFile = this.prologTextLoaderState.getInputName(argument);
        }
        catch (Exception ex) {
            this.logError("could not open datasource '" + this.prologTextLoaderState.getInputName(argument) + "': " + ex.getMessage());
            return;
        }
    }

    protected void processEnsureLoadedDirective(Term argument) {
        this.prologTextLoaderState.ensureLoaded(argument);
    }

    protected void processEof() {
        if (!this.fileStack.isEmpty()) {
            this.prologTextLoaderState.afterIncludeFile(this);
            this.currentFile = null;
            try {
                this.currentReader.close();
            }
            catch (IOException ex) {
                this.logError("error during closing file: " + ex.getMessage());
            }
            this.currentFile = this.fileStack.pop();
            this.currentReader = this.readerStack.pop();
        } else {
            this.currentFile = null;
            this.currentReader = null;
        }
    }

    public void logError(String message) {
        this.prologTextLoaderState.logError(this, message);
    }

    public void logError(ParseException ex) {
        this.prologTextLoaderState.logError(this, ex);
    }
}

