#!/usr/bin/env python

from gnuradio import gr
from gnuradio import usrp

def main (decim, rx_freq, filename):
    fg = gr.flow_graph ()
    u = usrp.source_c (0, decim)
    u.set_rx_freq (0, rx_freq)
    dst = gr.file_sink (gr.sizeof_gr_complex, filename)
    fg.connect (u, dst)
    
    fg.start ()
    raw_input ('Press Enter to quit: ')
    fg.stop ()


if __name__ == '__main__':
    decim = 16                          # => 4 MS/sec => 16 MB/sec across USB
    rx_freq = 0
    filename = "usrp_rx.dat"
    main (decim, rx_freq, filename)

