/* -*- c++ -*- */
/*
 * Copyright 2004 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

%include "exception.i"
%import "gnuradio.i"				// the common stuff

%{
#include "gnuradio_swig_bug_workaround.h"	// mandatory bug fix
#include "usrp_sink_c.h"
#include "usrp_source_c.h"
#include <stdexcept>
%}

// ----------------------------------------------------------------

GR_SWIG_BLOCK_MAGIC(usrp,sink_c)

usrp_sink_c_sptr
usrp_make_sink_c (int which_board, unsigned int interp_rate) throw (std::runtime_error);

class usrp_sink_c : public gr_sync_block {
 protected:
  usrp_sink_c (int which_board, unsigned int interp_rate);

 public:
  ~usrp_sink_c ();
  bool set_interp_rate (unsigned int rate);
  bool set_tx_freq (int channel, double freq);

  long dac_freq () const;
  unsigned int interp_rate () const;
  double tx_freq (int channel) const;
  int nunderruns () const { return d_nunderruns; }
};

// ----------------------------------------------------------------

GR_SWIG_BLOCK_MAGIC(usrp,source_c)

usrp_source_c_sptr
usrp_make_source_c (int which_board, unsigned int decim_rate) throw (std::runtime_error);

class usrp_source_c : public gr_sync_block {
 protected:
  usrp_source_c (int which_board, unsigned int decim_rate);

 public:
  ~usrp_source_c ();
  bool set_decim_rate (unsigned int rate);
  bool set_rx_freq (int channel, double freq);

  long adc_freq () const;
  unsigned int decim_rate () const;
  double rx_freq (int channel) const;
  int noverruns () const { return d_noverruns; }
};

