.TH pdfmom @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
pdfmom \- produce PDF documents using the
.I mom
macro package for
.I groff
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 2012-2020 Free Software Foundation, Inc.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of
.\" this manual under the conditions for verbatim copying, provided that
.\" the entire resulting derived work is distributed under the terms of
.\" a permission notice identical to this one.
.\"
.\" Permission is granted to copy and distribute translations of this
.\" manual into another language, under the above conditions for
.\" modified versions, except that this permission notice may be
.\" included in translations approved by the Free Software Foundation
.\" instead of in the original English.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_pdfmom_1_man_C \n[.cp]
.cp 0
.
.\" Define fallback for groff 1.23's MR macro if the system lacks it.
.nr do-fallback 0
.if !\n(.f           .nr do-fallback 1 \" mandoc
.if  \n(.g .if !d MR .nr do-fallback 1 \" older groff
.if !\n(.g           .nr do-fallback 1 \" non-groff *roff
.if \n[do-fallback]  \{\
.  de MR
.    ie \\n(.$=1 \
.      I \%\\$1
.    el \
.      IR \%\\$1 (\\$2)\\$3
.  .
.\}
.rr do-fallback
.
.
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
.
.SY pdfmom
.RB [ \-Tpdf ]
.RI [ groff-options ]
.RI [ file\~ .\|.\|.]
.YS
.
.
.SY pdfmom
.B \-Tps
.RI [ pdfroff-options ]
.RI [ groff-options ]
.RI [ file\~ .\|.\|.]
.YS
.
.
.SY pdfmom
.B \-v
.
.SY pdfmom
.B \-\-version
.YS
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
.I pdfmom
is a wrapper around
.MR groff @MAN1EXT@
that facilitates the production of PDF documents from files
formatted with the
.I mom
macros.
.
.
.P
.I pdfmom
prints to the standard output,
so output must usually be redirected to a destination file.
.
The size of the final PDF can be reduced by piping the output
through
.MR ps2pdf 1 .
.
.
.P
If called with the
.B \-Tpdf
option (which is the default),
.I pdfmom
processes files using
.IR groff 's
native PDF driver,
.MR gropdf @MAN1EXT@ .
.
If
.B \-Tps
is given,
processing is passed over to
.IR pdfroff ,
which uses
.IR groff 's
PostScript driver.
.
In either case,
multiple runs of the source file are performed in order to satisfy any
forward references in the document.
.
.
.P
.I pdfmom
accepts all the same options as
.IR groff .
.
If
.B \-Tps
is given,
the options associated with
.I pdfroff
are accepted as well.
.
When
.I pdfmom
calls
.IR pdfroff ,
the options
.RB \[lq] "\-mpdfmark \-mom \-\-no\-toc" \[rq]
options are implied and should not be given on the command line.
.
Equally,
it is not necessary to supply the
.B \-mom
or
.B "\-m\~mom"
options when
.B \-Tps
is absent.
.
.
.P
PDF integration with the
.I mom
macros is discussed in full in the manual
\[lq]Producing PDFs with
.I groff
and
.IR mom \[rq],
which was itself produced with
.IR pdfmom .
.
.
.P
If called with the
.B \-v
or
.B \-\-version
options,
.I pdfmom
displays its version information and exits.
.
.
.\" ====================================================================
.SH Authors
.\" ====================================================================
.
.I pdfmom
was written by
.MT deri@\:chuzzlewit\:.myzen\:.co\:.uk
Deri James
.ME
and
.MT peter@\:schaffter\:.ca
Peter Schaffter
.ME .
.
.
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
.TP
.I @PDFDOCDIR@/\:mom\-pdf.pdf
\[lq]Producing PDFs with
.I groff
and
.IR mom \[rq],
by Deri James and Peter Schaffter.
.
This file,
together with its source,
.IR mom\-pdf.mom ,
is part of the
.I groff
distribution.
.
.
.P
.MR groff @MAN1EXT@ ,
.MR gropdf @MAN1EXT@ ,
.MR pdfroff @MAN1EXT@ ,
.MR ps2pdf 1
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_pdfmom_1_man_C]
.do rr *groff_pdfmom_1_man_C
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
