.TH @g@lookbib @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
@g@lookbib \- search bibliographic databases
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 1989-2020 Free Software Foundation, Inc.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of
.\" this manual under the conditions for verbatim copying, provided that
.\" the entire resulting derived work is distributed under the terms of
.\" a permission notice identical to this one.
.\"
.\" Permission is granted to copy and distribute translations of this
.\" manual into another language, under the above conditions for
.\" modified versions, except that this permission notice may be
.\" included in translations approved by the Free Software Foundation
.\" instead of in the original English.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_lookbib_1_man_C \n[.cp]
.cp 0
.
.\" Define fallback for groff 1.23's MR macro if the system lacks it.
.nr do-fallback 0
.if !\n(.f           .nr do-fallback 1 \" mandoc
.if  \n(.g .if !d MR .nr do-fallback 1 \" older groff
.if !\n(.g           .nr do-fallback 1 \" non-groff *roff
.if \n[do-fallback]  \{\
.  de MR
.    ie \\n(.$=1 \
.      I \%\\$1
.    el \
.      IR \%\\$1 (\\$2)\\$3
.  .
.\}
.rr do-fallback
.
.
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
.
.SY @g@lookbib
.RB [ \-i\~\c
.IR string ]
.RB [ \-t\~\c
.IR n ]
.I file
\&.\|.\|.\&
.YS
.
.
.SY @g@lookbib
.B \-\-help
.YS
.
.
.SY @g@lookbib
.B \-v
.
.SY @g@lookbib
.B \-\-version
.YS
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
.I @g@lookbib
prints a prompt on the standard error (unless the standard input is not
a terminal),
reads from the standard input a line containing a set of keywords,
searches the bibliographic databases
.I file
\&.\|.\|.\& for references containing those keywords,
prints any references found on the standard output,
and repeats this process until the end of input.
.
For each database
.I file
to be searched,
if an index
.RI file @INDEX_SUFFIX@
created by
.MR @g@indxbib @MAN1EXT@
exists, then it will be searched instead;
each index can cover multiple databases.
.
.
.\" ====================================================================
.SH Options
.\" ====================================================================
.
.B \-\-help
displays a usage message,
while
.B \-v
and
.B \-\-version
show version information;
all exit afterward.
.
.
.TP
.BI \-i\~ string
When searching files for which no index exists,
ignore the contents of fields whose names are in
.IR string .
.
.
.TP
.BI \-t\~ n
Only require the first
.I n
characters of keys to be given.
.
Initially,
.I n
is\~6.
.
.
.\" ====================================================================
.SH Files
.\" ====================================================================
.
.TP
.RI file @INDEX_SUFFIX@
Index files.
.
.
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
\[lq]Some Applications of Inverted Indexes on the Unix System\[rq],
by M.\& E.\& Lesk,
1978,
AT&T Bell Laboratories Computing Science Technical Report No.\& 69.
.
.
.LP
.MR @g@refer @MAN1EXT@ ,
.MR lkbib @MAN1EXT@ ,
.MR @g@indxbib @MAN1EXT@
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_lookbib_1_man_C]
.do rr *groff_lookbib_1_man_C
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
