# lgetline.m4 serial 1

dnl Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003 Free Software
dnl Foundation, Inc.

dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

AC_PREREQ(2.52)

dnl See if there's a working, system-supplied version of the getline function.
dnl We can't just do AC_REPLACE_FUNCS(getline) because some systems
dnl have a function by that name in -linet that doesn't have anything
dnl to do with the function we need.
AC_DEFUN([lgl_FUNC_GETLINE],
[
  dnl Persuade glibc <stdio.h> to declare getline() and getdelim().
  AC_REQUIRE([AC_GNU_SOURCE])

  am_getline_needs_run_time_check=no
  AC_CHECK_FUNC(getline,
		dnl Found it in some library.  Verify that it works.
		am_getline_needs_run_time_check=yes,
		am_cv_func_working_getline=no)
  if test $am_getline_needs_run_time_check = yes; then
    AC_CACHE_CHECK([for working getline function], am_cv_func_working_getline,
    [echo fooN |tr -d '\012'|tr N '\012' > conftest.data
    AC_TRY_RUN([
#    include <stdio.h>
#    include <stdlib.h>
#    include <string.h>
    int main ()
    { /* Based on a test program from Karl Heuer.  */
      char *line = NULL;
      size_t siz = 0;
      int len;
      FILE *in = fopen ("./conftest.data", "r");
      if (!in)
	return 1;
      len = getline (&line, &siz, in);
      exit ((len == 4 && line && strcmp (line, "foo\n") == 0) ? 0 : 1);
    }
    ], am_cv_func_working_getline=yes dnl The library version works.
    , am_cv_func_working_getline=no dnl The library version does NOT work.
    , am_cv_func_working_getline=no dnl We're cross compiling.
    )])
  fi

  if test $am_cv_func_working_getline = no; then
    dnl We must choose a different name for our function, since on ELF systems
    dnl a broken getline() in libc.so would override our getline() in
    dnl libgettextlib.so.
    AC_DEFINE([getline], [gnu_getline],
      [Define to a replacement function name for getline().])

    lgl_PREREQ_GETLINE
    lgl_PREREQ_GETDELIM
  fi

  AM_CONDITIONAL(HAVE_GETLINE, test $am_cv_func_working_getline != no)
])

# Prerequisites of lib/lgetline.c.
AC_DEFUN([lgl_PREREQ_GETLINE],
[
  :
])

AC_DEFUN([lgl_AUTOPROTO_GETLINE],
[
  AC_CHECK_DECLS_ONCE(getline)
  AH_BOTTOM([/* Prototype for getline. */
#include <stddef.h>
#include <stdio.h>
#include <sys/types.h>
#if !HAVE_DECL_GETLINE
extern ssize_t getline (char **_lineptr, size_t *_linesize, FILE *_stream);
#endif])
])
