;;; GNU Guix --- Functional package management for GNU
;;; Copyright © 2012, 2013, 2014, 2015, 2016 Ludovic Courtès <ludo@gnu.org>
;;;
;;; This file is part of GNU Guix.
;;;
;;; GNU Guix is free software; you can redistribute it and/or modify it
;;; under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 3 of the License, or (at
;;; your option) any later version.
;;;
;;; GNU Guix is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with GNU Guix.  If not, see <http://www.gnu.org/licenses/>.

(define-module (guix config)
  #:export (%guix-package-name
            %guix-version
            %guix-bug-report-address
            %guix-home-page-url

            %storedir
            %localstatedir
            %sysconfdir
            %sbindir

            %store-directory
            %state-directory
            %config-directory
            %guix-register-program

            %system
            %libgcrypt
            %libz
            %nix-instantiate
            %gzip
            %bzip2
            %xz))

;;; Commentary:
;;;
;;; Compile-time configuration of Guix.  When adding a substitution variable
;;; here, make sure to equip (guix scripts pull) to substitute it.
;;;
;;; Code:

(define %guix-package-name
  "GNU Guix")

(define %guix-version
  "0.11.0")

(define %guix-bug-report-address
  "bug-guix@gnu.org")

(define %guix-home-page-url
  "http://www.gnu.org/software/guix/")

(define %storedir
  "/gnu/store")

(define %localstatedir
  "/var")

(define %sysconfdir
  "/etc")

(define %sbindir
  "/gnu/store/5drb0ijbszvy8xmps89qcav1p4vy9wqr-guix-0.11.0/sbin")

(define %store-directory
  (or (and=> (getenv "NIX_STORE_DIR") canonicalize-path)
      %storedir))

(define %state-directory
  ;; This must match `NIX_STATE_DIR' as defined in `nix/local.mk'.
  (or (getenv "NIX_STATE_DIR")
      (string-append %localstatedir "/guix")))

(define %config-directory
  ;; This must match `GUIX_CONFIGURATION_DIRECTORY' as defined in `nix/local.mk'.
  (or (getenv "GUIX_CONFIGURATION_DIRECTORY")
      (string-append %sysconfdir "/guix")))

(define %guix-register-program
  ;; The 'guix-register' program.
  (or (getenv "GUIX_REGISTER")
      (string-append %sbindir "/guix-register")))

(define %system
  "x86_64-linux")

(define %libgcrypt
  "/gnu/store/mpm281yzwcxzfc9n86krr61yhs2ja6gd-libgcrypt-1.7.0/lib/libgcrypt")

(define %libz
  "/gnu/store/5992iq1v7arqa14ym3di58n4la0893nv-zlib-1.2.8/lib/libz")

(define %nix-instantiate
  "nix-instantiate")

(define %gzip
  "/gnu/store/54ilw1jcicj7n259cpra59y6gik2mig2-gzip-1.8/bin/gzip")

(define %bzip2
  "/gnu/store/pzk986yikywnql4x393pbhzbiz7vl72n-bzip2-1.0.6/bin/bzip2")

(define %xz
  "/gnu/store/p9c6hk9rdln5rz752fkwd6zxj2xs3sa9-xz-5.2.2/bin/xz")

;;; config.scm ends here
