/* stringprep.h	header file for libstringprep                         -*- c -*-
 * Copyright (C) 2002  Simon Josefsson
 *
 * This file is part of Libstringprep.
 *
 * Libstringprep is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Libstringprep is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Libstringprep; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef _STRINGPREP_H
#define _STRINGPREP_H

#ifdef __cplusplus
extern "C"
{
#if 0 /* keep Emacsens's auto-indent happy */
}
#endif
#endif

#define STRINGPREP_VERSION "0.0.0"

/* Error codes */
enum {
  STRINGPREP_OK = 0,
  STRINGPREP_NFKC_FAILED,
  STRINGPREP_TOO_SMALL_BUFFER,
  STRINGPREP_MALLOC_ERROR,
  STRINGPREP_BIDI_NOT_IN_PROFILE,
  STRINGPREP_BIDI_BOTH_L_AND_RAL,
  STRINGPREP_BIDI_LEADTRAIL_NOT_RAL,
  STRINGPREP_UTF8_TOO_LARGE
};

enum { 
  /* Flags in API */
  STRINGPREP_NO_NFKC = (1<<1),
  STRINGPREP_NO_BIDI = (1<<2),
  /* Internal flags */
  STRINGPREP_BIDI_PROHIBITED = (1<<27),
  STRINGPREP_BIDI_RAL = (1<<28),
  STRINGPREP_BIDI_L = (1<<29),
  STRINGPREP_INVERT_MAGIC = (1<<30)
};

#define STRINGPREP_BIDI_PROHIBITED_MASK (~STRINGPREP_NO_BIDI & \
					 STRINGPREP_BIDI_PROHIBITED)
#define STRINGPREP_BIDI_RAL_MASK (~STRINGPREP_NO_BIDI & \
				  STRINGPREP_BIDI_RAL)
#define STRINGPREP_BIDI_L_MASK (~STRINGPREP_NO_BIDI & \
				STRINGPREP_BIDI_L)

#define MAX_MAP_CHARS 5

struct stringprep_table_element
{
  long start;
  long end;                /* 0 if only one character     */
  long map[MAX_MAP_CHARS]; /* Always NULL if end is non-0 */
};

struct stringprep_table
{
  int flags;
  struct stringprep_table_element *table;
};

typedef struct stringprep_table stringprep_profile;

/* API */

extern int stringprep (char *in, int maxlen, int flags, 
		       stringprep_profile * profile);

extern const char *stringprep_check_version (const char *req_version);

/* Utility */

extern int stringprep_unichar_to_utf8 (long c, char *outbuf);
extern char *stringprep_utf8_nfkc_normalize (const char *str, int len);
extern long *stringprep_ucs4_nfkc_normalize (long *str, int len);
extern long *stringprep_utf8_to_ucs4_fast (const char *str,
					   int  len, int *items_written);
extern char *stringprep_ucs4_to_utf8 (const long * str, int len, 
				      int * items_read, int * items_written);

#ifdef __cplusplus
}
#endif
#endif				/* _STRINGPREP_H */
