#line 2 "mimetypes.l"
/* GNU Mailutils -- a suite of utilities for electronic mail
   Copyright (C) 2005, 2007, 2009-2012, 2014-2017 Free Software
   Foundation, Inc.

   GNU Mailutils is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Mailutils is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Mailutils.  If not, see <http://www.gnu.org/licenses/>. */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif



#line 26 "mimetypes-lex.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

/* %not-for-header */

/* %if-c-only */
/* %if-not-reentrant */

/* %endif */
/* %endif */
/* %ok-for-header */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 35
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* %if-c++-only */
/* %endif */

/* %if-c-only */
    
/* %endif */

/* %if-c-only */

/* %endif */

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
/* %if-c-only */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>
/* %endif */

/* %if-tables-serialization */
/* %endif */
/* end standard C headers. */

/* %if-c-or-c++ */
/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;
#endif /* ! C99 */

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! FLEXINT_H */

/* %endif */

/* %if-c++-only */
/* %endif */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

/* C99 requires __STDC__ to be defined as 1. */
#if defined (__STDC__)

#define YY_USE_CONST

#endif	/* defined (__STDC__) */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define mimetypes_yyconst const
#else
#define mimetypes_yyconst
#endif

/* %not-for-header */

/* Returned upon end-of-file. */
#define YY_NULL 0
/* %ok-for-header */

/* %not-for-header */

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)
/* %ok-for-header */

/* %if-reentrant */
/* %endif */

/* %if-not-reentrant */

/* %endif */

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (mimetypes_yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((mimetypes_yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE mimetypes_yyrestart(mimetypes_yyin  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE 16384
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(mimetypes_yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct mimetypes_yy_buffer_state *YY_BUFFER_STATE;
#endif

/* %if-not-reentrant */
extern int mimetypes_yyleng;
/* %endif */

/* %if-c-only */
/* %if-not-reentrant */
extern FILE *mimetypes_yyin, *mimetypes_yyout;
/* %endif */
/* %endif */

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define mimetypes_yyless(n) \
	do \
		{ \
		/* Undo effects of setting up mimetypes_yytext. */ \
        int mimetypes_yyless_macro_arg = (n); \
        YY_LESS_LINENO(mimetypes_yyless_macro_arg);\
		*mimetypes_yy_cp = (mimetypes_yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(mimetypes_yy_c_buf_p) = mimetypes_yy_cp = mimetypes_yy_bp + mimetypes_yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up mimetypes_yytext again */ \
		} \
	while ( 0 )

#define unput(c) mimetypes_yyunput( c, (mimetypes_yytext_ptr)  )

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t mimetypes_yy_size_t;
#endif

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct mimetypes_yy_buffer_state
	{
/* %if-c-only */
	FILE *mimetypes_yy_input_file;
/* %endif */

/* %if-c++-only */
/* %endif */

	char *mimetypes_yy_ch_buf;		/* input buffer */
	char *mimetypes_yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	mimetypes_yy_size_t mimetypes_yy_buf_size;

	/* Number of characters read into mimetypes_yy_ch_buf, not including EOB
	 * characters.
	 */
	int mimetypes_yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int mimetypes_yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int mimetypes_yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int mimetypes_yy_at_bol;

    int mimetypes_yy_bs_lineno; /**< The line count. */
    int mimetypes_yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int mimetypes_yy_fill_buffer;

	int mimetypes_yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via mimetypes_yyrestart()), so that the user can continue scanning by
	 * just pointing mimetypes_yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* %if-c-only Standard (non-C++) definition */
/* %not-for-header */

/* %if-not-reentrant */

/* Stack of input buffers. */
static size_t mimetypes_yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t mimetypes_yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * mimetypes_yy_buffer_stack = 0; /**< Stack as an array. */
/* %endif */
/* %ok-for-header */

/* %endif */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (mimetypes_yy_buffer_stack) \
                          ? (mimetypes_yy_buffer_stack)[(mimetypes_yy_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (mimetypes_yy_buffer_stack)[(mimetypes_yy_buffer_stack_top)]

/* %if-c-only Standard (non-C++) definition */

/* %if-not-reentrant */
/* %not-for-header */

/* mimetypes_yy_hold_char holds the character lost when mimetypes_yytext is formed. */
static char mimetypes_yy_hold_char;
static int mimetypes_yy_n_chars;		/* number of characters read into mimetypes_yy_ch_buf */
int mimetypes_yyleng;

/* Points to current character in buffer. */
static char *mimetypes_yy_c_buf_p = (char *) 0;
static int mimetypes_yy_init = 0;		/* whether we need to initialize */
static int mimetypes_yy_start = 0;	/* start state number */

/* Flag which is used to allow mimetypes_yywrap()'s to do buffer switches
 * instead of setting up a fresh mimetypes_yyin.  A bit of a hack ...
 */
static int mimetypes_yy_did_buffer_switch_on_eof;
/* %ok-for-header */

/* %endif */

void mimetypes_yyrestart (FILE *input_file  );
void mimetypes_yy_switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE mimetypes_yy_create_buffer (FILE *file,int size  );
void mimetypes_yy_delete_buffer (YY_BUFFER_STATE b  );
void mimetypes_yy_flush_buffer (YY_BUFFER_STATE b  );
void mimetypes_yypush_buffer_state (YY_BUFFER_STATE new_buffer  );
void mimetypes_yypop_buffer_state (void );

static void mimetypes_yyensure_buffer_stack (void );
static void mimetypes_yy_load_buffer_state (void );
static void mimetypes_yy_init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER mimetypes_yy_flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE mimetypes_yy_scan_buffer (char *base,mimetypes_yy_size_t size  );
YY_BUFFER_STATE mimetypes_yy_scan_string (mimetypes_yyconst char *mimetypes_yy_str  );
YY_BUFFER_STATE mimetypes_yy_scan_bytes (mimetypes_yyconst char *bytes,int len  );

/* %endif */

void *mimetypes_yyalloc (mimetypes_yy_size_t  );
void *mimetypes_yyrealloc (void *,mimetypes_yy_size_t  );
void mimetypes_yyfree (void *  );

#define mimetypes_yy_new_buffer mimetypes_yy_create_buffer

#define mimetypes_yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        mimetypes_yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            mimetypes_yy_create_buffer(mimetypes_yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->mimetypes_yy_is_interactive = is_interactive; \
	}

#define mimetypes_yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        mimetypes_yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            mimetypes_yy_create_buffer(mimetypes_yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->mimetypes_yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->mimetypes_yy_at_bol)

/* %% [1.0] mimetypes_yytext/mimetypes_yyin/mimetypes_yyout/mimetypes_yy_state_type/mimetypes_yylineno etc. def's & init go here */
/* Begin user sect3 */

#define FLEX_DEBUG

typedef unsigned char YY_CHAR;

FILE *mimetypes_yyin = (FILE *) 0, *mimetypes_yyout = (FILE *) 0;

typedef int mimetypes_yy_state_type;

extern int mimetypes_yylineno;

int mimetypes_yylineno = 1;

extern char *mimetypes_yytext;
#define mimetypes_yytext_ptr mimetypes_yytext

/* %if-c-only Standard (non-C++) definition */

static mimetypes_yy_state_type mimetypes_yy_get_previous_state (void );
static mimetypes_yy_state_type mimetypes_yy_try_NUL_trans (mimetypes_yy_state_type current_state  );
static int mimetypes_yy_get_next_buffer (void );
static void mimetypes_yy_fatal_error (mimetypes_yyconst char msg[]  );

/* %endif */

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up mimetypes_yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(mimetypes_yytext_ptr) = mimetypes_yy_bp; \
/* %% [2.0] code to fiddle mimetypes_yytext and mimetypes_yyleng for mimetypes_yymore() goes here \ */\
	mimetypes_yyleng = (size_t) (mimetypes_yy_cp - mimetypes_yy_bp); \
	(mimetypes_yy_hold_char) = *mimetypes_yy_cp; \
	*mimetypes_yy_cp = '\0'; \
/* %% [3.0] code to copy mimetypes_yytext_ptr to mimetypes_yytext[] goes here, if %array \ */\
	(mimetypes_yy_c_buf_p) = mimetypes_yy_cp;

/* %% [4.0] data tables for the DFA and the user's section 1 definitions go here */
#define YY_NUM_RULES 26
#define YY_END_OF_BUFFER 27
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct mimetypes_yy_trans_info
	{
	flex_int32_t mimetypes_yy_verify;
	flex_int32_t mimetypes_yy_nxt;
	};
static mimetypes_yyconst flex_int16_t mimetypes_yy_accept[77] =
    {   0,
        0,    0,    0,    0,    0,    0,    0,    0,   27,   26,
        2,   26,   26,   13,    6,    5,    7,   13,   13,   13,
       13,   13,   13,   18,   16,   17,   14,   15,   25,   25,
       25,   25,   25,    0,    0,    0,    0,    1,    0,    6,
        8,   12,   12,   11,   12,    4,   12,    9,   16,   22,
       22,   24,   24,   23,    0,   19,    0,    0,   24,   20,
       23,    0,    3,    3,   12,    0,   20,    0,   12,   21,
       12,   12,   12,   12,   10,    0
    } ;

static mimetypes_yyconst flex_int32_t mimetypes_yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    4,    5,    6,    1,    1,    7,    8,    9,
       10,    1,   11,   12,   13,   14,   15,   16,   16,   16,
       16,   16,   16,   16,   16,   16,   16,    1,    1,   17,
        1,   18,    1,    1,   19,   19,   19,   19,   19,   19,
       14,   14,   14,   14,   14,   14,   14,   14,   14,   14,
       14,   14,   14,   14,   14,   14,   14,   14,   14,   14,
        1,   20,    1,    1,   14,    1,   19,   19,   19,   19,

       19,   19,   14,   14,   21,   14,   14,   14,   14,   14,
       22,   23,   14,   24,   14,   25,   14,   14,   14,   14,
       26,   14,    1,   27,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static mimetypes_yyconst flex_int32_t mimetypes_yy_meta[28] =
    {   0,
        1,    2,    3,    1,    1,    1,    1,    1,    4,    5,
        1,    5,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1
    } ;

static mimetypes_yyconst flex_int16_t mimetypes_yy_base[92] =
    {   0,
      135,    0,   15,    0,   41,   52,   63,   79,  136,  281,
      281,  119,   43,  281,  131,  281,  281,  124,   84,  102,
      119,   96,   92,  281,  115,  281,  281,  281,  127,  281,
      109,  143,   33,   98,    0,   45,  109,  281,    2,  102,
      281,  281,  148,  281,    0,  281,   80,  281,   97,  173,
      281,  281,   62,  281,   83,  281,  189,   77,   75,   69,
       70,   40,    0,    5,   54,   85,  281,   76,   48,  281,
       48,   38,   31,    0,  281,  281,  206,  211,  216,  221,
      226,  231,  236,  241,  246,  251,  256,  261,  266,  271,
      275

    } ;

static mimetypes_yyconst flex_int16_t mimetypes_yy_def[92] =
    {   0,
       77,   78,   76,    3,   79,   79,   80,   80,   76,   76,
       76,   81,   82,   76,   76,   76,   76,   76,   83,   83,
       76,   20,   76,   76,   76,   76,   76,   76,   84,   76,
       85,   86,   76,   81,   87,   82,   88,   76,   89,   76,
       76,   76,   83,   76,   20,   76,   20,   76,   76,   84,
       76,   76,   90,   76,   85,   76,   86,   91,   91,   90,
       91,   76,   87,   89,   20,   90,   76,   76,   20,   76,
       20,   20,   20,   20,   76,    0,   76,   76,   76,   76,
       76,   76,   76,   76,   76,   76,   76,   76,   76,   76,
       76

    } ;

static mimetypes_yyconst flex_int16_t mimetypes_yy_nxt[309] =
    {   0,
       76,   10,   11,   37,   38,   13,   37,   38,   75,   76,
       76,   76,   76,   76,   10,   14,   15,   16,   17,   14,
       14,   18,   14,   17,   17,   17,   17,   19,   20,   17,
       19,   14,   14,   20,   21,   20,   20,   22,   20,   20,
       20,   23,   25,   26,   37,   38,   37,   38,   62,   27,
       28,   62,   27,   25,   26,   68,   74,   39,   68,   39,
       27,   28,   73,   27,   30,   10,   52,   31,   72,   53,
       32,   71,   30,   52,   30,   69,   53,   67,   54,   33,
       30,   10,   67,   31,   67,   54,   32,   56,   30,   52,
       30,   62,   53,   70,   62,   33,   43,   43,   49,   43,

       65,   54,   43,   40,   43,   43,   43,   43,   43,   43,
       44,   38,   35,   56,   45,   45,   49,   45,   48,   47,
       45,   46,   45,   45,   45,   45,   45,   45,   51,   51,
       41,   52,   40,   35,   53,   76,   51,   11,   51,   76,
       76,   76,   76,   54,   58,   76,   76,   59,   76,   76,
       60,   76,   58,   76,   58,   76,   76,   76,   76,   61,
       43,   43,   76,   43,   76,   76,   43,   76,   43,   43,
       43,   43,   43,   43,   51,   51,   76,   52,   76,   76,
       53,   76,   51,   76,   51,   76,   76,   76,   76,   54,
       58,   76,   76,   59,   76,   76,   60,   76,   58,   76,

       58,   76,   76,   76,   76,   61,   10,   10,   10,   10,
       10,   12,   12,   12,   12,   12,   24,   24,   24,   24,
       24,   29,   29,   29,   29,   29,   34,   76,   76,   34,
       34,   36,   36,   36,   36,   36,   42,   42,   42,   76,
       42,   50,   50,   50,   50,   50,   55,   55,   76,   55,
       55,   57,   57,   76,   57,   57,   63,   76,   76,   63,
       63,   37,   37,   37,   37,   37,   64,   64,   64,   64,
       64,   66,   76,   76,   66,   58,   58,   76,   58,   58,
        9,   76,   76,   76,   76,   76,   76,   76,   76,   76,
       76,   76,   76,   76,   76,   76,   76,   76,   76,   76,

       76,   76,   76,   76,   76,   76,   76,   76
    } ;

static mimetypes_yyconst flex_int16_t mimetypes_yy_chk[309] =
    {   0,
        0,    2,    2,   39,   39,    2,   64,   64,   74,    0,
        0,    0,    0,    0,    2,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    5,    5,   13,   13,   36,   36,   33,    5,
        5,   33,    5,    6,    6,   62,   73,   13,   62,   36,
        6,    6,   72,    6,    7,    7,   53,    7,   71,   53,
        7,   69,    7,   60,    7,   65,   60,   61,   53,    7,
        8,    8,   59,    8,   58,   60,    8,   55,    8,   66,
        8,   68,   66,   68,   68,    8,   19,   19,   49,   19,

       47,   66,   19,   40,   19,   19,   19,   19,   19,   19,
       20,   37,   34,   31,   20,   20,   25,   20,   23,   22,
       20,   21,   20,   20,   20,   20,   20,   20,   29,   29,
       18,   29,   15,   12,   29,    9,   29,    1,   29,    0,
        0,    0,    0,   29,   32,    0,    0,   32,    0,    0,
       32,    0,   32,    0,   32,    0,    0,    0,    0,   32,
       43,   43,    0,   43,    0,    0,   43,    0,   43,   43,
       43,   43,   43,   43,   50,   50,    0,   50,    0,    0,
       50,    0,   50,    0,   50,    0,    0,    0,    0,   50,
       57,    0,    0,   57,    0,    0,   57,    0,   57,    0,

       57,    0,    0,    0,    0,   57,   77,   77,   77,   77,
       77,   78,   78,   78,   78,   78,   79,   79,   79,   79,
       79,   80,   80,   80,   80,   80,   81,    0,    0,   81,
       81,   82,   82,   82,   82,   82,   83,   83,   83,    0,
       83,   84,   84,   84,   84,   84,   85,   85,    0,   85,
       85,   86,   86,    0,   86,   86,   87,    0,    0,   87,
       87,   88,   88,   88,   88,   88,   89,   89,   89,   89,
       89,   90,    0,    0,   90,   91,   91,    0,   91,   91,
       76,   76,   76,   76,   76,   76,   76,   76,   76,   76,
       76,   76,   76,   76,   76,   76,   76,   76,   76,   76,

       76,   76,   76,   76,   76,   76,   76,   76
    } ;

static mimetypes_yy_state_type mimetypes_yy_last_accepting_state;
static char *mimetypes_yy_last_accepting_cpos;

extern int mimetypes_yy_flex_debug;
int mimetypes_yy_flex_debug = 1;

static mimetypes_yyconst flex_int16_t mimetypes_yy_rule_linenum[26] =
    {   0,
      120,  121,  122,  133,  134,  138,  141,  144,  145,  147,
      151,  159,  165,  169,  170,  174,  175,  180,  190,  193,
      198,  208,  212,  216,  220
    } ;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define mimetypes_yymore() mimetypes_yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *mimetypes_yytext;
#line 1 "mimetypes.l"

#line 25 "mimetypes.l"
#include <unistd.h>
#include <stdio.h>
#include <sys/stat.h>
#include <mimeview.h>
#include <mimetypes-decl.h>  
#include <mailutils/io.h>
 
static struct mu_locus loc;
static int newline;

static mu_opool_t pool;
 
static unsigned 
digit_to_number (char c)
{
  return (unsigned) (c >= '0' && c <= '9' ? c-'0' :
                     c >= 'A' && c <= 'Z' ? c-'A'+10 :
                     c-'a'+10);
}

static struct mu_locus prev_loc;
static struct mu_locus string_beg;
static int prev_newline;
 
static void
advance_locus (void)
{
  prev_loc = loc;
  prev_newline = newline;
  
  if (newline)
    {
      loc.mu_line++;
      loc.mu_col = 1;
    }
  mimetypes_yylloc.beg = loc;
  loc.mu_col += mimetypes_yyleng;
  mimetypes_yylloc.end = loc;
  mimetypes_yylloc.end.mu_col--;

#if 0
  printf ("+%2d> %u:%u-%u:%u: %s\n",
	  mimetypes_yyleng,
	  mimetypes_yylloc.beg.mu_line, mimetypes_yylloc.beg.mu_col, 
	  mimetypes_yylloc.end.mu_line, mimetypes_yylloc.end.mu_col, mimetypes_yytext);
#endif
  newline = mimetypes_yytext[mimetypes_yyleng-1] == '\n';
  mu_stream_ioctl (mu_strerr, MU_IOCTL_LOGSTREAM,
                   MU_IOCTL_LOGSTREAM_SET_LOCUS, &loc);
}

static void
retreat_locus (void)
{
  loc = prev_loc;
  newline = prev_newline;
}

static void
finish_string (void)
{
  mu_opool_append_char (pool, 0);
  mimetypes_yylval.string.ptr = mu_opool_finish (pool, &mimetypes_yylval.string.len);
  mimetypes_yylval.string.len--;
  mimetypes_yylloc.end = mimetypes_yylloc.beg;
  mimetypes_yylloc.end.mu_col--;
  mimetypes_yylloc.beg = string_beg;
  if (mu_debug_level_p (MU_DEBCAT_APP, MU_DEBUG_TRACE5))
    {
      size_t i;
      mu_debug_log_begin ("string %zu: ", mimetypes_yylval.string.len);
      for (i = 0; i < mimetypes_yylval.string.len; i++)
	if (mu_isprint (mimetypes_yylval.string.ptr[i]))
	  mu_debug_log_cont ("%c", mimetypes_yylval.string.ptr[i]);
        else
	  mu_debug_log_cont ("\\%03o", mimetypes_yylval.string.ptr[i]);
      mu_debug_log_nl ();
    }
#if 0
  YY_LOCATION_PRINT (stderr, mimetypes_yylloc);
  fprintf (stderr, ": %s\n", mimetypes_yylval.string.ptr);
#endif
}  

#define YY_USER_ACTION advance_locus ();

#line 745 "mimetypes-lex.c"

#define INITIAL 0
#define RULE 1
#define ARGS 2
#define ASTRING 3

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
/* %if-c-only */
#include <unistd.h>
/* %endif */
/* %if-c++-only */
/* %endif */
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

/* %if-c-only Reentrant structure and macros (non-C++). */
/* %if-reentrant */
/* %if-c-only */

static int mimetypes_yy_init_globals (void );

/* %endif */
/* %if-reentrant */
/* %endif */
/* %endif End reentrant structures and macros. */

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int mimetypes_yylex_destroy (void );

int mimetypes_yyget_debug (void );

void mimetypes_yyset_debug (int debug_flag  );

YY_EXTRA_TYPE mimetypes_yyget_extra (void );

void mimetypes_yyset_extra (YY_EXTRA_TYPE user_defined  );

FILE *mimetypes_yyget_in (void );

void mimetypes_yyset_in  (FILE * in_str  );

FILE *mimetypes_yyget_out (void );

void mimetypes_yyset_out  (FILE * out_str  );

int mimetypes_yyget_leng (void );

char *mimetypes_yyget_text (void );

int mimetypes_yyget_lineno (void );

void mimetypes_yyset_lineno (int line_number  );

/* %if-bison-bridge */
/* %endif */

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int mimetypes_yywrap (void );
#else
extern int mimetypes_yywrap (void );
#endif
#endif

/* %not-for-header */

    static void mimetypes_yyunput (int c,char *buf_ptr  );
    
/* %ok-for-header */

/* %endif */

#ifndef mimetypes_yytext_ptr
static void mimetypes_yy_flex_strncpy (char *,mimetypes_yyconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int mimetypes_yy_flex_strlen (mimetypes_yyconst char * );
#endif

#ifndef YY_NO_INPUT
/* %if-c-only Standard (non-C++) definition */
/* %not-for-header */

#ifdef __cplusplus
static int mimetypes_yyinput (void );
#else
static int input (void );
#endif
/* %ok-for-header */

/* %endif */
#endif

/* %if-c-only */

/* %endif */

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* %if-c-only Standard (non-C++) definition */
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO fwrite( mimetypes_yytext, mimetypes_yyleng, 1, mimetypes_yyout )
/* %endif */
/* %if-c++-only C++ definition */
/* %endif */
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
/* %% [5.0] fread()/read() definition of YY_INPUT goes here unless we're doing C++ \ */\
	if ( YY_CURRENT_BUFFER_LVALUE->mimetypes_yy_is_interactive ) \
		{ \
		int c = '*'; \
		int n; \
		for ( n = 0; n < max_size && \
			     (c = getc( mimetypes_yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( mimetypes_yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, mimetypes_yyin))==0 && ferror(mimetypes_yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(mimetypes_yyin); \
			} \
		}\
\
/* %if-c++-only C++ definition \ */\
/* %endif */

#endif

/* No semi-colon after return; correct usage is to write "mimetypes_yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef mimetypes_yyterminate
#define mimetypes_yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
/* %if-c-only */
#define YY_FATAL_ERROR(msg) mimetypes_yy_fatal_error( msg )
/* %endif */
/* %if-c++-only */
/* %endif */
#endif

/* %if-tables-serialization structures and prototypes */
/* %not-for-header */

/* %ok-for-header */

/* %not-for-header */

/* %tables-mimetypes_yydmap generated elements */
/* %endif */
/* end tables serialization structures and prototypes */

/* %ok-for-header */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1
/* %if-c-only Standard (non-C++) definition */

extern int mimetypes_yylex (void);

#define YY_DECL int mimetypes_yylex (void)
/* %endif */
/* %if-c++-only C++ definition */
/* %endif */
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after mimetypes_yytext and mimetypes_yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

/* %% [6.0] YY_RULE_SETUP definition goes here */
#define YY_RULE_SETUP \
	if ( mimetypes_yyleng > 0 ) \
		YY_CURRENT_BUFFER_LVALUE->mimetypes_yy_at_bol = \
				(mimetypes_yytext[mimetypes_yyleng - 1] == '\n'); \
	YY_USER_ACTION

/* %not-for-header */

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register mimetypes_yy_state_type mimetypes_yy_current_state;
	register char *mimetypes_yy_cp, *mimetypes_yy_bp;
	register int mimetypes_yy_act;
    
/* %% [7.0] user's declarations go here */
#line 116 "mimetypes.l"


#line 996 "mimetypes-lex.c"

	if ( !(mimetypes_yy_init) )
		{
		(mimetypes_yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (mimetypes_yy_start) )
			(mimetypes_yy_start) = 1;	/* first start state */

		if ( ! mimetypes_yyin )
/* %if-c-only */
			mimetypes_yyin = stdin;
/* %endif */
/* %if-c++-only */
/* %endif */

		if ( ! mimetypes_yyout )
/* %if-c-only */
			mimetypes_yyout = stdout;
/* %endif */
/* %if-c++-only */
/* %endif */

		if ( ! YY_CURRENT_BUFFER ) {
			mimetypes_yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				mimetypes_yy_create_buffer(mimetypes_yyin,YY_BUF_SIZE );
		}

		mimetypes_yy_load_buffer_state( );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
/* %% [8.0] mimetypes_yymore()-related code goes here */
		mimetypes_yy_cp = (mimetypes_yy_c_buf_p);

		/* Support of mimetypes_yytext. */
		*mimetypes_yy_cp = (mimetypes_yy_hold_char);

		/* mimetypes_yy_bp points to the position in mimetypes_yy_ch_buf of the start of
		 * the current run.
		 */
		mimetypes_yy_bp = mimetypes_yy_cp;

/* %% [9.0] code to set up and find next match goes here */
		mimetypes_yy_current_state = (mimetypes_yy_start);
		mimetypes_yy_current_state += YY_AT_BOL();
mimetypes_yy_match:
		do
			{
			register YY_CHAR mimetypes_yy_c = mimetypes_yy_ec[YY_SC_TO_UI(*mimetypes_yy_cp)];
			if ( mimetypes_yy_accept[mimetypes_yy_current_state] )
				{
				(mimetypes_yy_last_accepting_state) = mimetypes_yy_current_state;
				(mimetypes_yy_last_accepting_cpos) = mimetypes_yy_cp;
				}
			while ( mimetypes_yy_chk[mimetypes_yy_base[mimetypes_yy_current_state] + mimetypes_yy_c] != mimetypes_yy_current_state )
				{
				mimetypes_yy_current_state = (int) mimetypes_yy_def[mimetypes_yy_current_state];
				if ( mimetypes_yy_current_state >= 77 )
					mimetypes_yy_c = mimetypes_yy_meta[(unsigned int) mimetypes_yy_c];
				}
			mimetypes_yy_current_state = mimetypes_yy_nxt[mimetypes_yy_base[mimetypes_yy_current_state] + (unsigned int) mimetypes_yy_c];
			++mimetypes_yy_cp;
			}
		while ( mimetypes_yy_base[mimetypes_yy_current_state] != 281 );

mimetypes_yy_find_action:
/* %% [10.0] code to find the action number goes here */
		mimetypes_yy_act = mimetypes_yy_accept[mimetypes_yy_current_state];
		if ( mimetypes_yy_act == 0 )
			{ /* have to back up */
			mimetypes_yy_cp = (mimetypes_yy_last_accepting_cpos);
			mimetypes_yy_current_state = (mimetypes_yy_last_accepting_state);
			mimetypes_yy_act = mimetypes_yy_accept[mimetypes_yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

/* %% [11.0] code for mimetypes_yylineno update goes here */

do_action:	/* This label is used only to access EOF actions. */

/* %% [12.0] debug code goes here */
		if ( mimetypes_yy_flex_debug )
			{
			if ( mimetypes_yy_act == 0 )
				fprintf( stderr, "--scanner backing up\n" );
			else if ( mimetypes_yy_act < 26 )
				fprintf( stderr, "--accepting rule at line %ld (\"%s\")\n",
				         (long)mimetypes_yy_rule_linenum[mimetypes_yy_act], mimetypes_yytext );
			else if ( mimetypes_yy_act == 26 )
				fprintf( stderr, "--accepting default rule (\"%s\")\n",
				         mimetypes_yytext );
			else if ( mimetypes_yy_act == 27 )
				fprintf( stderr, "--(end of buffer or a NUL)\n" );
			else
				fprintf( stderr, "--EOF (start condition %d)\n", YY_START );
			}

		switch ( mimetypes_yy_act )
	{ /* beginning of action switch */
/* %% [13.0] actions go here */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*mimetypes_yy_cp = (mimetypes_yy_hold_char);
			mimetypes_yy_cp = (mimetypes_yy_last_accepting_cpos);
			mimetypes_yy_current_state = (mimetypes_yy_last_accepting_state);
			goto mimetypes_yy_find_action;

/* Comments */
case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 120 "mimetypes.l"
;
	YY_BREAK
case 2:
/* rule 2 can match eol */
YY_RULE_SETUP
#line 121 "mimetypes.l"
;
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 122 "mimetypes.l"
{
  mu_opool_append (pool, mimetypes_yytext, mimetypes_yyleng);
  mu_opool_append_char (pool, 0);
  mimetypes_yylval.string.ptr = mu_opool_finish (pool, &mimetypes_yylval.string.len);
  mimetypes_yylval.string.len--;
  BEGIN (RULE);
  return TYPE;
}
	YY_BREAK


case 4:
/* rule 4 can match eol */
YY_RULE_SETUP
#line 133 "mimetypes.l"
;
	YY_BREAK
case 5:
/* rule 5 can match eol */
YY_RULE_SETUP
#line 134 "mimetypes.l"
{
  BEGIN (INITIAL);
  return EOL;
}
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 138 "mimetypes.l"
;
	YY_BREAK
/* Operators */
case 7:
YY_RULE_SETUP
#line 141 "mimetypes.l"
return mimetypes_yytext[0];
	YY_BREAK
/* Special cases: && and ||. Docs don't say anything about them, but
     I've found them in my mime.types file...         --Sergey */
case 8:
YY_RULE_SETUP
#line 144 "mimetypes.l"
return '+';
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 145 "mimetypes.l"
return ',';
	YY_BREAK
case 10:
*mimetypes_yy_cp = (mimetypes_yy_hold_char); /* undo effects of setting up mimetypes_yytext */
(mimetypes_yy_c_buf_p) = mimetypes_yy_cp = mimetypes_yy_bp + 8;
YY_DO_BEFORE_ACTION; /* set up mimetypes_yytext again */
YY_RULE_SETUP
#line 147 "mimetypes.l"
{
  return PRIORITY;
}
	YY_BREAK
case 11:
*mimetypes_yy_cp = (mimetypes_yy_hold_char); /* undo effects of setting up mimetypes_yytext */
(mimetypes_yy_c_buf_p) = mimetypes_yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up mimetypes_yytext again */
YY_RULE_SETUP
#line 151 "mimetypes.l"
{
  mu_opool_append (pool, mimetypes_yytext, mimetypes_yyleng);
  mu_opool_append_char (pool, 0);
  mimetypes_yylval.string.ptr = mu_opool_finish (pool, &mimetypes_yylval.string.len);
  BEGIN (ARGS);
  return IDENT;
} 
	YY_BREAK
case 12:
/* rule 12 can match eol */
*mimetypes_yy_cp = (mimetypes_yy_hold_char); /* undo effects of setting up mimetypes_yytext */
(mimetypes_yy_c_buf_p) = mimetypes_yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up mimetypes_yytext again */
YY_RULE_SETUP
#line 159 "mimetypes.l"
{
  mu_opool_append (pool, mimetypes_yytext, mimetypes_yyleng);
  mimetypes_yylval.string.ptr = mu_opool_finish (pool, &mimetypes_yylval.string.len);
  return STRING;
}
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 165 "mimetypes.l"
mu_error("unexpected character '%c'", mimetypes_yytext[0]);
	YY_BREAK


case 14:
YY_RULE_SETUP
#line 169 "mimetypes.l"
return mimetypes_yytext[0];
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 170 "mimetypes.l"
{
  BEGIN (RULE);
  return mimetypes_yytext[0];
}
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 174 "mimetypes.l"
mu_error ("unexpected whitespace in argument list");
	YY_BREAK
case 17:
/* rule 17 can match eol */
YY_RULE_SETUP
#line 175 "mimetypes.l"
{
  mu_error ("unexpected newline in argument list");
  BEGIN (RULE);
  return EOL;
}
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 180 "mimetypes.l"
{
  string_beg = mimetypes_yylloc.beg;
  retreat_locus ();
  mimetypes_yyless (0);
  BEGIN (ASTRING);
}
	YY_BREAK


/* Quoted string */
case 19:
YY_RULE_SETUP
#line 190 "mimetypes.l"
{
  mu_opool_append (pool, mimetypes_yytext+1, mimetypes_yyleng-2);
}
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 193 "mimetypes.l"
{
  mu_opool_append (pool, mimetypes_yytext+1, mimetypes_yyleng-2);
}
	YY_BREAK
/* Hex string */
case 21:
YY_RULE_SETUP
#line 198 "mimetypes.l"
{
  int i;
  for (i = 1; i < mimetypes_yyleng - 2; i += 2)
    {
      mu_opool_append_char (pool, digit_to_number (mimetypes_yytext[i])*16
                                  + digit_to_number (mimetypes_yytext[i+1]));
    }  
}
	YY_BREAK
/* Unquoted character sequence */
case 22:
/* rule 22 can match eol */
*mimetypes_yy_cp = (mimetypes_yy_hold_char); /* undo effects of setting up mimetypes_yytext */
(mimetypes_yy_c_buf_p) = mimetypes_yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up mimetypes_yytext again */
YY_RULE_SETUP
#line 208 "mimetypes.l"
{
  mu_opool_append (pool, mimetypes_yytext, mimetypes_yyleng);
}
	YY_BREAK
case 23:
*mimetypes_yy_cp = (mimetypes_yy_hold_char); /* undo effects of setting up mimetypes_yytext */
(mimetypes_yy_c_buf_p) = mimetypes_yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up mimetypes_yytext again */
YY_RULE_SETUP
#line 212 "mimetypes.l"
{
  mu_opool_append (pool, mimetypes_yytext, mimetypes_yyleng);
}
	YY_BREAK
case 24:
*mimetypes_yy_cp = (mimetypes_yy_hold_char); /* undo effects of setting up mimetypes_yytext */
(mimetypes_yy_c_buf_p) = mimetypes_yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up mimetypes_yytext again */
YY_RULE_SETUP
#line 216 "mimetypes.l"
{
  mu_opool_append (pool, mimetypes_yytext, mimetypes_yyleng);
}
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 220 "mimetypes.l"
{ 
  retreat_locus ();
  mimetypes_yyless (0);
  BEGIN (ARGS);
  finish_string ();  
  return STRING;
}
	YY_BREAK

case 26:
YY_RULE_SETUP
#line 229 "mimetypes.l"
ECHO;
	YY_BREAK
#line 1337 "mimetypes-lex.c"
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(RULE):
case YY_STATE_EOF(ARGS):
case YY_STATE_EOF(ASTRING):
	mimetypes_yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int mimetypes_yy_amount_of_matched_text = (int) (mimetypes_yy_cp - (mimetypes_yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*mimetypes_yy_cp = (mimetypes_yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->mimetypes_yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed mimetypes_yyin at a new source and called
			 * mimetypes_yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(mimetypes_yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->mimetypes_yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->mimetypes_yy_input_file = mimetypes_yyin;
			YY_CURRENT_BUFFER_LVALUE->mimetypes_yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for mimetypes_yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since mimetypes_yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (mimetypes_yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->mimetypes_yy_ch_buf[(mimetypes_yy_n_chars)] )
			{ /* This was really a NUL. */
			mimetypes_yy_state_type mimetypes_yy_next_state;

			(mimetypes_yy_c_buf_p) = (mimetypes_yytext_ptr) + mimetypes_yy_amount_of_matched_text;

			mimetypes_yy_current_state = mimetypes_yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * mimetypes_yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			mimetypes_yy_next_state = mimetypes_yy_try_NUL_trans( mimetypes_yy_current_state );

			mimetypes_yy_bp = (mimetypes_yytext_ptr) + YY_MORE_ADJ;

			if ( mimetypes_yy_next_state )
				{
				/* Consume the NUL. */
				mimetypes_yy_cp = ++(mimetypes_yy_c_buf_p);
				mimetypes_yy_current_state = mimetypes_yy_next_state;
				goto mimetypes_yy_match;
				}

			else
				{
/* %% [14.0] code to do back-up for compressed tables and set up mimetypes_yy_cp goes here */
				mimetypes_yy_cp = (mimetypes_yy_c_buf_p);
				goto mimetypes_yy_find_action;
				}
			}

		else switch ( mimetypes_yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(mimetypes_yy_did_buffer_switch_on_eof) = 0;

				if ( mimetypes_yywrap( ) )
					{
					/* Note: because we've taken care in
					 * mimetypes_yy_get_next_buffer() to have set up
					 * mimetypes_yytext, we can now set up
					 * mimetypes_yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(mimetypes_yy_c_buf_p) = (mimetypes_yytext_ptr) + YY_MORE_ADJ;

					mimetypes_yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (mimetypes_yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(mimetypes_yy_c_buf_p) =
					(mimetypes_yytext_ptr) + mimetypes_yy_amount_of_matched_text;

				mimetypes_yy_current_state = mimetypes_yy_get_previous_state(  );

				mimetypes_yy_cp = (mimetypes_yy_c_buf_p);
				mimetypes_yy_bp = (mimetypes_yytext_ptr) + YY_MORE_ADJ;
				goto mimetypes_yy_match;

			case EOB_ACT_LAST_MATCH:
				(mimetypes_yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->mimetypes_yy_ch_buf[(mimetypes_yy_n_chars)];

				mimetypes_yy_current_state = mimetypes_yy_get_previous_state(  );

				mimetypes_yy_cp = (mimetypes_yy_c_buf_p);
				mimetypes_yy_bp = (mimetypes_yytext_ptr) + YY_MORE_ADJ;
				goto mimetypes_yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of mimetypes_yylex */
/* %ok-for-header */

/* %if-c++-only */
/* %not-for-header */

/* %ok-for-header */

/* %endif */

/* mimetypes_yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
/* %if-c-only */
static int mimetypes_yy_get_next_buffer (void)
/* %endif */
/* %if-c++-only */
/* %endif */
{
    	register char *dest = YY_CURRENT_BUFFER_LVALUE->mimetypes_yy_ch_buf;
	register char *source = (mimetypes_yytext_ptr);
	register int number_to_move, i;
	int ret_val;

	if ( (mimetypes_yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->mimetypes_yy_ch_buf[(mimetypes_yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->mimetypes_yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (mimetypes_yy_c_buf_p) - (mimetypes_yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((mimetypes_yy_c_buf_p) - (mimetypes_yytext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->mimetypes_yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->mimetypes_yy_n_chars = (mimetypes_yy_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->mimetypes_yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER;

			int mimetypes_yy_c_buf_p_offset =
				(int) ((mimetypes_yy_c_buf_p) - b->mimetypes_yy_ch_buf);

			if ( b->mimetypes_yy_is_our_buffer )
				{
				int new_size = b->mimetypes_yy_buf_size * 2;

				if ( new_size <= 0 )
					b->mimetypes_yy_buf_size += b->mimetypes_yy_buf_size / 8;
				else
					b->mimetypes_yy_buf_size *= 2;

				b->mimetypes_yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					mimetypes_yyrealloc((void *) b->mimetypes_yy_ch_buf,b->mimetypes_yy_buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->mimetypes_yy_ch_buf = 0;

			if ( ! b->mimetypes_yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(mimetypes_yy_c_buf_p) = &b->mimetypes_yy_ch_buf[mimetypes_yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->mimetypes_yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->mimetypes_yy_ch_buf[number_to_move]),
			(mimetypes_yy_n_chars), (size_t) num_to_read );

		YY_CURRENT_BUFFER_LVALUE->mimetypes_yy_n_chars = (mimetypes_yy_n_chars);
		}

	if ( (mimetypes_yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			mimetypes_yyrestart(mimetypes_yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->mimetypes_yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((mimetypes_yy_size_t) ((mimetypes_yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->mimetypes_yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		mimetypes_yy_size_t new_size = (mimetypes_yy_n_chars) + number_to_move + ((mimetypes_yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->mimetypes_yy_ch_buf = (char *) mimetypes_yyrealloc((void *) YY_CURRENT_BUFFER_LVALUE->mimetypes_yy_ch_buf,new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->mimetypes_yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in mimetypes_yy_get_next_buffer()" );
	}

	(mimetypes_yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->mimetypes_yy_ch_buf[(mimetypes_yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->mimetypes_yy_ch_buf[(mimetypes_yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(mimetypes_yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->mimetypes_yy_ch_buf[0];

	return ret_val;
}

/* mimetypes_yy_get_previous_state - get the state just before the EOB char was reached */

/* %if-c-only */
/* %not-for-header */

    static mimetypes_yy_state_type mimetypes_yy_get_previous_state (void)
/* %endif */
/* %if-c++-only */
/* %endif */
{
	register mimetypes_yy_state_type mimetypes_yy_current_state;
	register char *mimetypes_yy_cp;
    
/* %% [15.0] code to get the start state into mimetypes_yy_current_state goes here */
	mimetypes_yy_current_state = (mimetypes_yy_start);
	mimetypes_yy_current_state += YY_AT_BOL();

	for ( mimetypes_yy_cp = (mimetypes_yytext_ptr) + YY_MORE_ADJ; mimetypes_yy_cp < (mimetypes_yy_c_buf_p); ++mimetypes_yy_cp )
		{
/* %% [16.0] code to find the next state goes here */
		register YY_CHAR mimetypes_yy_c = (*mimetypes_yy_cp ? mimetypes_yy_ec[YY_SC_TO_UI(*mimetypes_yy_cp)] : 1);
		if ( mimetypes_yy_accept[mimetypes_yy_current_state] )
			{
			(mimetypes_yy_last_accepting_state) = mimetypes_yy_current_state;
			(mimetypes_yy_last_accepting_cpos) = mimetypes_yy_cp;
			}
		while ( mimetypes_yy_chk[mimetypes_yy_base[mimetypes_yy_current_state] + mimetypes_yy_c] != mimetypes_yy_current_state )
			{
			mimetypes_yy_current_state = (int) mimetypes_yy_def[mimetypes_yy_current_state];
			if ( mimetypes_yy_current_state >= 77 )
				mimetypes_yy_c = mimetypes_yy_meta[(unsigned int) mimetypes_yy_c];
			}
		mimetypes_yy_current_state = mimetypes_yy_nxt[mimetypes_yy_base[mimetypes_yy_current_state] + (unsigned int) mimetypes_yy_c];
		}

	return mimetypes_yy_current_state;
}

/* mimetypes_yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = mimetypes_yy_try_NUL_trans( current_state );
 */
/* %if-c-only */
    static mimetypes_yy_state_type mimetypes_yy_try_NUL_trans  (mimetypes_yy_state_type mimetypes_yy_current_state )
/* %endif */
/* %if-c++-only */
/* %endif */
{
	register int mimetypes_yy_is_jam;
    /* %% [17.0] code to find the next state, and perhaps do backing up, goes here */
	register char *mimetypes_yy_cp = (mimetypes_yy_c_buf_p);

	register YY_CHAR mimetypes_yy_c = 1;
	if ( mimetypes_yy_accept[mimetypes_yy_current_state] )
		{
		(mimetypes_yy_last_accepting_state) = mimetypes_yy_current_state;
		(mimetypes_yy_last_accepting_cpos) = mimetypes_yy_cp;
		}
	while ( mimetypes_yy_chk[mimetypes_yy_base[mimetypes_yy_current_state] + mimetypes_yy_c] != mimetypes_yy_current_state )
		{
		mimetypes_yy_current_state = (int) mimetypes_yy_def[mimetypes_yy_current_state];
		if ( mimetypes_yy_current_state >= 77 )
			mimetypes_yy_c = mimetypes_yy_meta[(unsigned int) mimetypes_yy_c];
		}
	mimetypes_yy_current_state = mimetypes_yy_nxt[mimetypes_yy_base[mimetypes_yy_current_state] + (unsigned int) mimetypes_yy_c];
	mimetypes_yy_is_jam = (mimetypes_yy_current_state == 76);

	return mimetypes_yy_is_jam ? 0 : mimetypes_yy_current_state;
}

/* %if-c-only */

    static void mimetypes_yyunput (int c, register char * mimetypes_yy_bp )
/* %endif */
/* %if-c++-only */
/* %endif */
{
	register char *mimetypes_yy_cp;
    
    mimetypes_yy_cp = (mimetypes_yy_c_buf_p);

	/* undo effects of setting up mimetypes_yytext */
	*mimetypes_yy_cp = (mimetypes_yy_hold_char);

	if ( mimetypes_yy_cp < YY_CURRENT_BUFFER_LVALUE->mimetypes_yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		register int number_to_move = (mimetypes_yy_n_chars) + 2;
		register char *dest = &YY_CURRENT_BUFFER_LVALUE->mimetypes_yy_ch_buf[
					YY_CURRENT_BUFFER_LVALUE->mimetypes_yy_buf_size + 2];
		register char *source =
				&YY_CURRENT_BUFFER_LVALUE->mimetypes_yy_ch_buf[number_to_move];

		while ( source > YY_CURRENT_BUFFER_LVALUE->mimetypes_yy_ch_buf )
			*--dest = *--source;

		mimetypes_yy_cp += (int) (dest - source);
		mimetypes_yy_bp += (int) (dest - source);
		YY_CURRENT_BUFFER_LVALUE->mimetypes_yy_n_chars =
			(mimetypes_yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->mimetypes_yy_buf_size;

		if ( mimetypes_yy_cp < YY_CURRENT_BUFFER_LVALUE->mimetypes_yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--mimetypes_yy_cp = (char) c;

/* %% [18.0] update mimetypes_yylineno here */

	(mimetypes_yytext_ptr) = mimetypes_yy_bp;
	(mimetypes_yy_hold_char) = *mimetypes_yy_cp;
	(mimetypes_yy_c_buf_p) = mimetypes_yy_cp;
}
/* %if-c-only */

/* %endif */

/* %if-c-only */
#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int mimetypes_yyinput (void)
#else
    static int input  (void)
#endif

/* %endif */
/* %if-c++-only */
/* %endif */
{
	int c;
    
	*(mimetypes_yy_c_buf_p) = (mimetypes_yy_hold_char);

	if ( *(mimetypes_yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* mimetypes_yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (mimetypes_yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->mimetypes_yy_ch_buf[(mimetypes_yy_n_chars)] )
			/* This was really a NUL. */
			*(mimetypes_yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (mimetypes_yy_c_buf_p) - (mimetypes_yytext_ptr);
			++(mimetypes_yy_c_buf_p);

			switch ( mimetypes_yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because mimetypes_yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					mimetypes_yyrestart(mimetypes_yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( mimetypes_yywrap( ) )
						return EOF;

					if ( ! (mimetypes_yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return mimetypes_yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(mimetypes_yy_c_buf_p) = (mimetypes_yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (mimetypes_yy_c_buf_p);	/* cast for 8-bit char's */
	*(mimetypes_yy_c_buf_p) = '\0';	/* preserve mimetypes_yytext */
	(mimetypes_yy_hold_char) = *++(mimetypes_yy_c_buf_p);

/* %% [19.0] update BOL and mimetypes_yylineno */
	YY_CURRENT_BUFFER_LVALUE->mimetypes_yy_at_bol = (c == '\n');

	return c;
}
/* %if-c-only */
#endif	/* ifndef YY_NO_INPUT */
/* %endif */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
/* %if-c-only */
    void mimetypes_yyrestart  (FILE * input_file )
/* %endif */
/* %if-c++-only */
/* %endif */
{
    
	if ( ! YY_CURRENT_BUFFER ){
        mimetypes_yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            mimetypes_yy_create_buffer(mimetypes_yyin,YY_BUF_SIZE );
	}

	mimetypes_yy_init_buffer(YY_CURRENT_BUFFER,input_file );
	mimetypes_yy_load_buffer_state( );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
/* %if-c-only */
    void mimetypes_yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
/* %endif */
/* %if-c++-only */
/* %endif */
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		mimetypes_yypop_buffer_state();
	 *		mimetypes_yypush_buffer_state(new_buffer);
     */
	mimetypes_yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(mimetypes_yy_c_buf_p) = (mimetypes_yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->mimetypes_yy_buf_pos = (mimetypes_yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->mimetypes_yy_n_chars = (mimetypes_yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	mimetypes_yy_load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (mimetypes_yywrap()) processing, but the only time this flag
	 * is looked at is after mimetypes_yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(mimetypes_yy_did_buffer_switch_on_eof) = 1;
}

/* %if-c-only */
static void mimetypes_yy_load_buffer_state  (void)
/* %endif */
/* %if-c++-only */
/* %endif */
{
    	(mimetypes_yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->mimetypes_yy_n_chars;
	(mimetypes_yytext_ptr) = (mimetypes_yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->mimetypes_yy_buf_pos;
	mimetypes_yyin = YY_CURRENT_BUFFER_LVALUE->mimetypes_yy_input_file;
	(mimetypes_yy_hold_char) = *(mimetypes_yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
/* %if-c-only */
    YY_BUFFER_STATE mimetypes_yy_create_buffer  (FILE * file, int  size )
/* %endif */
/* %if-c++-only */
/* %endif */
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) mimetypes_yyalloc(sizeof( struct mimetypes_yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in mimetypes_yy_create_buffer()" );

	b->mimetypes_yy_buf_size = size;

	/* mimetypes_yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->mimetypes_yy_ch_buf = (char *) mimetypes_yyalloc(b->mimetypes_yy_buf_size + 2  );
	if ( ! b->mimetypes_yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in mimetypes_yy_create_buffer()" );

	b->mimetypes_yy_is_our_buffer = 1;

	mimetypes_yy_init_buffer(b,file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with mimetypes_yy_create_buffer()
 * 
 */
/* %if-c-only */
    void mimetypes_yy_delete_buffer (YY_BUFFER_STATE  b )
/* %endif */
/* %if-c++-only */
/* %endif */
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->mimetypes_yy_is_our_buffer )
		mimetypes_yyfree((void *) b->mimetypes_yy_ch_buf  );

	mimetypes_yyfree((void *) b  );
}

/* %if-c-only */

#ifndef __cplusplus
extern int isatty (int );
#endif /* __cplusplus */
    
/* %endif */

/* %if-c++-only */
/* %endif */

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a mimetypes_yyrestart() or at EOF.
 */
/* %if-c-only */
    static void mimetypes_yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file )
/* %endif */
/* %if-c++-only */
/* %endif */

{
	int oerrno = errno;
    
	mimetypes_yy_flush_buffer(b );

	b->mimetypes_yy_input_file = file;
	b->mimetypes_yy_fill_buffer = 1;

    /* If b is the current buffer, then mimetypes_yy_init_buffer was _probably_
     * called from mimetypes_yyrestart() or through mimetypes_yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->mimetypes_yy_bs_lineno = 1;
        b->mimetypes_yy_bs_column = 0;
    }

/* %if-c-only */

        b->mimetypes_yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
/* %endif */
/* %if-c++-only */
/* %endif */
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
/* %if-c-only */
    void mimetypes_yy_flush_buffer (YY_BUFFER_STATE  b )
/* %endif */
/* %if-c++-only */
/* %endif */
{
    	if ( ! b )
		return;

	b->mimetypes_yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->mimetypes_yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->mimetypes_yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->mimetypes_yy_buf_pos = &b->mimetypes_yy_ch_buf[0];

	b->mimetypes_yy_at_bol = 1;
	b->mimetypes_yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		mimetypes_yy_load_buffer_state( );
}

/* %if-c-or-c++ */
/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
/* %if-c-only */
void mimetypes_yypush_buffer_state (YY_BUFFER_STATE new_buffer )
/* %endif */
/* %if-c++-only */
/* %endif */
{
    	if (new_buffer == NULL)
		return;

	mimetypes_yyensure_buffer_stack();

	/* This block is copied from mimetypes_yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(mimetypes_yy_c_buf_p) = (mimetypes_yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->mimetypes_yy_buf_pos = (mimetypes_yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->mimetypes_yy_n_chars = (mimetypes_yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(mimetypes_yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from mimetypes_yy_switch_to_buffer. */
	mimetypes_yy_load_buffer_state( );
	(mimetypes_yy_did_buffer_switch_on_eof) = 1;
}
/* %endif */

/* %if-c-or-c++ */
/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
/* %if-c-only */
void mimetypes_yypop_buffer_state (void)
/* %endif */
/* %if-c++-only */
/* %endif */
{
    	if (!YY_CURRENT_BUFFER)
		return;

	mimetypes_yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((mimetypes_yy_buffer_stack_top) > 0)
		--(mimetypes_yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		mimetypes_yy_load_buffer_state( );
		(mimetypes_yy_did_buffer_switch_on_eof) = 1;
	}
}
/* %endif */

/* %if-c-or-c++ */
/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
/* %if-c-only */
static void mimetypes_yyensure_buffer_stack (void)
/* %endif */
/* %if-c++-only */
/* %endif */
{
	int num_to_alloc;
    
	if (!(mimetypes_yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		(mimetypes_yy_buffer_stack) = (struct mimetypes_yy_buffer_state**)mimetypes_yyalloc
								(num_to_alloc * sizeof(struct mimetypes_yy_buffer_state*)
								);
		if ( ! (mimetypes_yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in mimetypes_yyensure_buffer_stack()" );
								  
		memset((mimetypes_yy_buffer_stack), 0, num_to_alloc * sizeof(struct mimetypes_yy_buffer_state*));
				
		(mimetypes_yy_buffer_stack_max) = num_to_alloc;
		(mimetypes_yy_buffer_stack_top) = 0;
		return;
	}

	if ((mimetypes_yy_buffer_stack_top) >= ((mimetypes_yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (mimetypes_yy_buffer_stack_max) + grow_size;
		(mimetypes_yy_buffer_stack) = (struct mimetypes_yy_buffer_state**)mimetypes_yyrealloc
								((mimetypes_yy_buffer_stack),
								num_to_alloc * sizeof(struct mimetypes_yy_buffer_state*)
								);
		if ( ! (mimetypes_yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in mimetypes_yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((mimetypes_yy_buffer_stack) + (mimetypes_yy_buffer_stack_max), 0, grow_size * sizeof(struct mimetypes_yy_buffer_state*));
		(mimetypes_yy_buffer_stack_max) = num_to_alloc;
	}
}
/* %endif */

/* %if-c-only */
/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE mimetypes_yy_scan_buffer  (char * base, mimetypes_yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) mimetypes_yyalloc(sizeof( struct mimetypes_yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in mimetypes_yy_scan_buffer()" );

	b->mimetypes_yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->mimetypes_yy_buf_pos = b->mimetypes_yy_ch_buf = base;
	b->mimetypes_yy_is_our_buffer = 0;
	b->mimetypes_yy_input_file = 0;
	b->mimetypes_yy_n_chars = b->mimetypes_yy_buf_size;
	b->mimetypes_yy_is_interactive = 0;
	b->mimetypes_yy_at_bol = 1;
	b->mimetypes_yy_fill_buffer = 0;
	b->mimetypes_yy_buffer_status = YY_BUFFER_NEW;

	mimetypes_yy_switch_to_buffer(b  );

	return b;
}
/* %endif */

/* %if-c-only */
/** Setup the input buffer state to scan a string. The next call to mimetypes_yylex() will
 * scan from a @e copy of @a str.
 * @param mimetypes_yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       mimetypes_yy_scan_bytes() instead.
 */
YY_BUFFER_STATE mimetypes_yy_scan_string (mimetypes_yyconst char * mimetypes_yystr )
{
    
	return mimetypes_yy_scan_bytes(mimetypes_yystr,strlen(mimetypes_yystr) );
}
/* %endif */

/* %if-c-only */
/** Setup the input buffer state to scan the given bytes. The next call to mimetypes_yylex() will
 * scan from a @e copy of @a bytes.
 * @param bytes the byte buffer to scan
 * @param len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE mimetypes_yy_scan_bytes  (mimetypes_yyconst char * mimetypes_yybytes, int  _mimetypes_yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	mimetypes_yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _mimetypes_yybytes_len + 2;
	buf = (char *) mimetypes_yyalloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in mimetypes_yy_scan_bytes()" );

	for ( i = 0; i < _mimetypes_yybytes_len; ++i )
		buf[i] = mimetypes_yybytes[i];

	buf[_mimetypes_yybytes_len] = buf[_mimetypes_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = mimetypes_yy_scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in mimetypes_yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->mimetypes_yy_is_our_buffer = 1;

	return b;
}
/* %endif */

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

/* %if-c-only */
static void mimetypes_yy_fatal_error (mimetypes_yyconst char* msg )
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}
/* %endif */
/* %if-c++-only */
/* %endif */

/* Redefine mimetypes_yyless() so it works in section 3 code. */

#undef mimetypes_yyless
#define mimetypes_yyless(n) \
	do \
		{ \
		/* Undo effects of setting up mimetypes_yytext. */ \
        int mimetypes_yyless_macro_arg = (n); \
        YY_LESS_LINENO(mimetypes_yyless_macro_arg);\
		mimetypes_yytext[mimetypes_yyleng] = (mimetypes_yy_hold_char); \
		(mimetypes_yy_c_buf_p) = mimetypes_yytext + mimetypes_yyless_macro_arg; \
		(mimetypes_yy_hold_char) = *(mimetypes_yy_c_buf_p); \
		*(mimetypes_yy_c_buf_p) = '\0'; \
		mimetypes_yyleng = mimetypes_yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/* %if-c-only */
/* %if-reentrant */
/* %endif */

/** Get the current line number.
 * 
 */
int mimetypes_yyget_lineno  (void)
{
        
    return mimetypes_yylineno;
}

/** Get the input stream.
 * 
 */
FILE *mimetypes_yyget_in  (void)
{
        return mimetypes_yyin;
}

/** Get the output stream.
 * 
 */
FILE *mimetypes_yyget_out  (void)
{
        return mimetypes_yyout;
}

/** Get the length of the current token.
 * 
 */
int mimetypes_yyget_leng  (void)
{
        return mimetypes_yyleng;
}

/** Get the current token.
 * 
 */

char *mimetypes_yyget_text  (void)
{
        return mimetypes_yytext;
}

/* %if-reentrant */
/* %endif */

/** Set the current line number.
 * @param line_number
 * 
 */
void mimetypes_yyset_lineno (int  line_number )
{
    
    mimetypes_yylineno = line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 * 
 * @see mimetypes_yy_switch_to_buffer
 */
void mimetypes_yyset_in (FILE *  in_str )
{
        mimetypes_yyin = in_str ;
}

void mimetypes_yyset_out (FILE *  out_str )
{
        mimetypes_yyout = out_str ;
}

int mimetypes_yyget_debug  (void)
{
        return mimetypes_yy_flex_debug;
}

void mimetypes_yyset_debug (int  bdebug )
{
        mimetypes_yy_flex_debug = bdebug ;
}

/* %endif */

/* %if-reentrant */
/* %if-bison-bridge */
/* %endif */
/* %endif if-c-only */

/* %if-c-only */
static int mimetypes_yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from mimetypes_yylex_destroy(), so don't allocate here.
     */

    (mimetypes_yy_buffer_stack) = 0;
    (mimetypes_yy_buffer_stack_top) = 0;
    (mimetypes_yy_buffer_stack_max) = 0;
    (mimetypes_yy_c_buf_p) = (char *) 0;
    (mimetypes_yy_init) = 0;
    (mimetypes_yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    mimetypes_yyin = stdin;
    mimetypes_yyout = stdout;
#else
    mimetypes_yyin = (FILE *) 0;
    mimetypes_yyout = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * mimetypes_yylex_init()
     */
    return 0;
}
/* %endif */

/* %if-c-only SNIP! this currently causes conflicts with the c++ scanner */
/* mimetypes_yylex_destroy is for both reentrant and non-reentrant scanners. */
int mimetypes_yylex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		mimetypes_yy_delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		mimetypes_yypop_buffer_state();
	}

	/* Destroy the stack itself. */
	mimetypes_yyfree((mimetypes_yy_buffer_stack) );
	(mimetypes_yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * mimetypes_yylex() is called, initialization will occur. */
    mimetypes_yy_init_globals( );

/* %if-reentrant */
/* %endif */
    return 0;
}
/* %endif */

/*
 * Internal utility routines.
 */

#ifndef mimetypes_yytext_ptr
static void mimetypes_yy_flex_strncpy (char* s1, mimetypes_yyconst char * s2, int n )
{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int mimetypes_yy_flex_strlen (mimetypes_yyconst char * s )
{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *mimetypes_yyalloc (mimetypes_yy_size_t  size )
{
	return (void *) malloc( size );
}

void *mimetypes_yyrealloc  (void * ptr, mimetypes_yy_size_t  size )
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void mimetypes_yyfree (void * ptr )
{
	free( (char *) ptr );	/* see mimetypes_yyrealloc() for (char *) cast */
}

/* %if-tables-serialization definitions */
/* %define-mimetypes_yytables   The name for this specific scanner's tables. */
#define YYTABLES_NAME "mimetypes_yytables"
/* %endif */

/* %ok-for-header */

#line 229 "mimetypes.l"


int
mimetypes_open (const char *name)
{
  struct stat st;
  int mode;

  mimetypes_yy_flex_debug = mu_debug_level_p (MU_DEBCAT_MIME, MU_DEBUG_TRACE4);

  if (stat (name, &st))
    {
      mu_error (_("cannot stat `%s': %s"), name, mu_strerror (errno));
      return -1;
    }
  
  if (S_ISDIR (st.st_mode))
    loc.mu_file = mu_make_file_name (name, "mime.types");
  else
    loc.mu_file = mu_strdup (name);
  loc.mu_line = 1;
  loc.mu_col = 1;
  newline = 0;

  mimetypes_yyin = fopen (loc.mu_file, "r");
  if (!mimetypes_yyin)
    {
      mu_error (_("cannot open `%s': %s"), loc.mu_file, mu_strerror (errno));
      free (loc.mu_file);
      return -1;
    }

  mu_stream_ioctl (mu_strerr, MU_IOCTL_LOGSTREAM,
                   MU_IOCTL_LOGSTREAM_GET_MODE, &mode);
  mode |= MU_LOGMODE_LOCUS;
  mu_stream_ioctl (mu_strerr, MU_IOCTL_LOGSTREAM,
                   MU_IOCTL_LOGSTREAM_SET_MODE, &mode);
  mu_stream_ioctl (mu_strerr, MU_IOCTL_LOGSTREAM,
                   MU_IOCTL_LOGSTREAM_SET_LOCUS, &loc);

  mu_opool_create (&pool, MU_OPOOL_ENOMEMABRT);
  return 0;
}

void
mimetypes_close ()
{
  int mode;

  fclose (mimetypes_yyin);
  /* FIXME: Don't free (loc.mu_file), because it is referenced by
     mu_locus structures in the parse tree */

  mu_stream_ioctl (mu_strerr, MU_IOCTL_LOGSTREAM,
                   MU_IOCTL_LOGSTREAM_GET_MODE, &mode);
  mode &= ~MU_LOGMODE_LOCUS;
  mu_stream_ioctl (mu_strerr, MU_IOCTL_LOGSTREAM,
                   MU_IOCTL_LOGSTREAM_SET_MODE, &mode);
  mu_stream_ioctl (mu_strerr, MU_IOCTL_LOGSTREAM,
                   MU_IOCTL_LOGSTREAM_SET_LOCUS, NULL);
}

int
mimetypes_yyerror (char *s)
{
  mu_error (s);
  return 0;
}

int
mimetypes_yywrap ()
{
  return 1;
}

struct mimetypes_string *     
mimetypes_string_dup (struct mimetypes_string *s)
{
  mu_opool_append (pool, s, sizeof *s);
  return mu_opool_finish (pool, NULL);
}

void *
mimetypes_malloc (size_t size)
{
  mu_opool_alloc (pool, size);
  return mu_opool_finish (pool, NULL);
}

/* Position input at the beginning of the next rule as a final part of error
   recovery */
void
lex_next_rule (void)
{
  int bol = 0;
  int c;

  if (newline)
    {
      loc.mu_col = 0;
      loc.mu_line++;
      newline = 0;
      bol = 1;
    }
  
  if (mimetypes_yy_flex_debug)
    {
      YY_LOCATION_PRINT (stderr, mimetypes_yylloc);
      fprintf (stderr, ": started error recovery\n");
    }
  while ((c = input ()) != EOF)
    {
      loc.mu_col++;
      if (c == '\n')
	{
	  loc.mu_line++;
	  loc.mu_col = 0;
	  bol = 1;
	}
      else if (bol)
	{
	  bol = 0;
	  if (!(c == ' ' || c == '\t'))
	    {
	      unput (c);
	      break;
	    }
	}
    }
  if (mimetypes_yy_flex_debug)
    {
      mimetypes_yylloc.beg = mimetypes_yylloc.end = loc;
      YY_LOCATION_PRINT (stderr, mimetypes_yylloc);
      fprintf (stderr, ": finished error recovery\n");
    }
  BEGIN (RULE);
  unput ('\n');
  loc.mu_col = 0;
  loc.mu_line--;
}

