/* src/language/stats/means.c		-*- mode: c; buffer-read-only: t -*-

   Generated by q2c from ../src/language/stats/means.q.
   Do not modify!
 */
#line 1 "../src/language/stats/means.q"
/* PSPP - a program for statistical analysis.
   Copyright (C) 1997-9, 2000 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>. */

#include <config.h>

#include <stdlib.h>
#include <stdio.h>

#include <data/dictionary.h>
#include <data/procedure.h>
#include <data/variable.h>
#include <language/command.h>
#include <language/lexer/lexer.h>
#include <libpspp/alloc.h>
#include <libpspp/hash.h>
#include <libpspp/magic.h>
#include <libpspp/message.h>

#include "gettext.h"
#define _(msgid) gettext (msgid)

#line 42 "src/language/stats/means.c"
#include <stdlib.h>
#include <libpspp/alloc.h>
#include <libpspp/assertion.h>
#include <libpspp/message.h>
#include <language/lexer/lexer.h>
#include <language/lexer/variable-parser.h>
#include <data/settings.h>
#include <libpspp/magic.h>
#include <libpspp/str.h>
#include <language/lexer/subcommand-list.h>
#include <data/variable.h>

#include "gettext.h"
#define _(msgid) gettext (msgid)

#line 36 "../src/language/stats/means.q"

#line 60 "src/language/stats/means.c"
#line 48 "../src/language/stats/means.q"
#line 62 "src/language/stats/means.c"
struct dataset;
/* Settings for subcommand specifiers. */
enum
  {
    MNS_LABELS = 1000,
    MNS_NOLABELS,
    MNS_NOCATLABS,
    MNS_NAMES,
    MNS_NONAMES,
    MNS_VALUES,
    MNS_NOVALUES,
    MNS_TABLE,
    MNS_TREE,
    MNS_INCLUDE,
    MNS_DEPENDENT
  };

#define MAXLISTS 10
/* Array indices for CELLS subcommand. */
enum
  {
    MNS_CL_DEFAULT = 0,
    MNS_CL_COUNT = 1,
    MNS_CL_SUM = 2,
    MNS_CL_MEAN = 3,
    MNS_CL_STDDEV = 4,
    MNS_CL_VARIANCE = 5,
    MNS_CL_ALL = 6,
    MNS_CL_count
  };

/* Array indices for STATISTICS subcommand. */
enum
  {
    MNS_ST_ANOVA = 0,
    MNS_ST_LINEARITY = 1,
    MNS_ST_ALL = 2,
    MNS_ST_NONE = 3,
    MNS_ST_count
  };

/* MEANS structure. */
struct cmd_means
  {
    /* TABLES subcommand. */
    int sbc_tables;
    
    /* FORMAT subcommand. */
    int sbc_format;
    long lab;
    long name;
    long val;
    long fmt;
    
    /* MISSING subcommand. */
    int sbc_missing;
    long miss;
    
    /* CELLS subcommand. */
    int sbc_cells;
    int a_cells[MNS_CL_count];
    
    /* STATISTICS subcommand. */
    int sbc_statistics;
    int a_statistics[MNS_ST_count];
  };

/* Prototype for custom subcommands of MEANS. */
static int mns_custom_tables (struct lexer *, struct dataset *, struct cmd_means *, void *);

/* Command parsing functions. */
static int parse_means (struct lexer *, struct dataset *, struct cmd_means *, void *);
static void free_means (struct cmd_means *);

#line 49 "../src/language/stats/means.q"
#line 138 "src/language/stats/means.c"
static int
parse_means (struct lexer *lexer, struct dataset *ds UNUSED, struct cmd_means *p, void *aux UNUSED)
{
  p->sbc_tables = 0;
  p->sbc_format = 0;
  p->lab = MNS_LABELS;
  p->name = MNS_NAMES;
  p->val = MNS_VALUES;
  p->fmt = MNS_TABLE;
  p->sbc_missing = 0;
  p->miss = MNS_TABLE;
  p->sbc_cells = 0;
  memset (p->a_cells, 0, sizeof p->a_cells);
  p->sbc_statistics = 0;
  memset (p->a_statistics, 0, sizeof p->a_statistics);
  for (;;)
    {
      switch (mns_custom_tables (lexer, ds, p, aux))
        {
        case 0:
          goto lossage;
        case 1:
          p->sbc_tables++;
          continue;
        case 2:
          break;
        default:
          NOT_REACHED ();
        }
      if (lex_match_id (lexer, "TABLES"))
        {
          lex_match (lexer, '=');
          p->sbc_tables++;
          if (p->sbc_tables > 1)
            {
              msg (SE, _("TABLES subcommand may be given only once."));
              goto lossage;
            }
          switch (mns_custom_tables (lexer, ds, p, aux))
            {
            case 0:
              goto lossage;
            case 1:
              break;
            case 2:
              lex_error (lexer, NULL);
              goto lossage;
            default:
              NOT_REACHED ();
            }
        }
      else if (lex_match_id (lexer, "FORMAT"))
        {
          lex_match (lexer, '=');
          p->sbc_format++;
          while (lex_token (lexer) != '/' && lex_token (lexer) != '.')
            {
              if (lex_match_id (lexer, "LABELS"))
                p->lab = MNS_LABELS;
              else if (lex_match_id (lexer, "NOLABELS"))
                p->lab = MNS_NOLABELS;
              else if (lex_match_id (lexer, "NOCATLABS"))
                p->lab = MNS_NOCATLABS;
              else if (lex_match_id (lexer, "NAMES"))
                p->name = MNS_NAMES;
              else if (lex_match_id (lexer, "NONAMES"))
                p->name = MNS_NONAMES;
              else if (lex_match_id (lexer, "VALUES"))
                p->val = MNS_VALUES;
              else if (lex_match_id (lexer, "NOVALUES"))
                p->val = MNS_NOVALUES;
              else if (lex_match_id (lexer, "TABLE"))
                p->fmt = MNS_TABLE;
              else if (lex_match_id (lexer, "TREE"))
                p->fmt = MNS_TREE;
              else
                {
                  lex_error (lexer, NULL);
                  goto lossage;
                }
              lex_match (lexer, ',');
            }
        }
      else if (lex_match_id (lexer, "MISSING"))
        {
          lex_match (lexer, '=');
          p->sbc_missing++;
          if (p->sbc_missing > 1)
            {
              msg (SE, _("MISSING subcommand may be given only once."));
              goto lossage;
            }
          while (lex_token (lexer) != '/' && lex_token (lexer) != '.')
            {
              if (lex_match_id (lexer, "TABLE"))
                p->miss = MNS_TABLE;
              else if (lex_match_id (lexer, "INCLUDE"))
                p->miss = MNS_INCLUDE;
              else if (lex_match_id (lexer, "DEPENDENT"))
                p->miss = MNS_DEPENDENT;
              else
                {
                  lex_error (lexer, NULL);
                  goto lossage;
                }
              lex_match (lexer, ',');
            }
        }
      else if (lex_match_id (lexer, "CELLS"))
        {
          lex_match (lexer, '=');
          p->sbc_cells++;
          while (lex_token (lexer) != '/' && lex_token (lexer) != '.')
            {
              if (lex_match_id (lexer, "DEFAULT"))
                p->a_cells[MNS_CL_DEFAULT] = 1;
              else if (lex_match_id (lexer, "COUNT"))
                p->a_cells[MNS_CL_COUNT] = 1;
              else if (lex_match_id (lexer, "SUM"))
                p->a_cells[MNS_CL_SUM] = 1;
              else if (lex_match_id (lexer, "MEAN"))
                p->a_cells[MNS_CL_MEAN] = 1;
              else if (lex_match_id (lexer, "STDDEV"))
                p->a_cells[MNS_CL_STDDEV] = 1;
              else if (lex_match_id (lexer, "VARIANCE"))
                p->a_cells[MNS_CL_VARIANCE] = 1;
              else if (lex_match (lexer, T_ALL))
                p->a_cells[MNS_CL_ALL] = 1;
              else
                {
                  lex_error (lexer, NULL);
                  goto lossage;
                }
              lex_match (lexer, ',');
            }
        }
      else if (lex_match_id (lexer, "STATISTICS"))
        {
          lex_match (lexer, '=');
          p->sbc_statistics++;
          while (lex_token (lexer) != '/' && lex_token (lexer) != '.')
            {
              if (lex_match_id (lexer, "ANOVA"))
                p->a_statistics[MNS_ST_ANOVA] = 1;
              else if (lex_match_id (lexer, "LINEARITY"))
                p->a_statistics[MNS_ST_LINEARITY] = 1;
              else if (lex_match (lexer, T_ALL))
                p->a_statistics[MNS_ST_ALL] = 1;
              else if (lex_match_id (lexer, "NONE"))
                p->a_statistics[MNS_ST_NONE] = 1;
              else
                {
                  lex_error (lexer, NULL);
                  goto lossage;
                }
              lex_match (lexer, ',');
            }
        }
      else if ( get_syntax() != COMPATIBLE && lex_match_id(lexer, "ALGORITHM"))
        {
          lex_match (lexer, '=');
          if (lex_match_id(lexer, "COMPATIBLE"))
            set_cmd_algorithm(COMPATIBLE);
          else if (lex_match_id(lexer, "ENHANCED"))
            set_cmd_algorithm(ENHANCED);
          }
        if (!lex_match (lexer, '/'))
          break;
      }
    
    if (lex_token (lexer) != '.')
      {
        lex_error (lexer, _("expecting end of command"));
        goto lossage;
      }
      
  return true;
  
lossage:
  free_means (p);
  return false;
}

static void
free_means (struct cmd_means *p UNUSED)
{
}
#line 50 "../src/language/stats/means.q"

/* TABLES: Variable lists for each dimension. */
static int n_dim;		/* Number of dimensions. */
static size_t *nv_dim;		/* Number of variables in each dimension. */
static const struct variable ***v_dim;	/* Variables in each dimension.  */

/* VARIABLES: List of variables. */
static struct variable **v_var;

/* Parses and executes the T-TEST procedure. */
int
cmd_means (struct lexer *lexer, struct dataset *ds)
{
  struct cmd_means cmd;
  int success = CMD_FAILURE;

  n_dim = 0;
  nv_dim = NULL;
  v_dim = NULL;
  v_var = NULL;

  if (!parse_means (lexer, ds, &cmd, NULL))
    goto free;

  if (cmd.sbc_cells)
    {
      int i;
      for (i = 0; i < MNS_CL_count; i++)
	if (cmd.a_cells[i])
	  break;
      if (i >= MNS_CL_count)
	cmd.a_cells[MNS_CL_ALL] = 1;
    }
  else
    cmd.a_cells[MNS_CL_DEFAULT] = 1;
  if (cmd.a_cells[MNS_CL_DEFAULT] || cmd.a_cells[MNS_CL_ALL])
    cmd.a_cells[MNS_CL_MEAN] = cmd.a_cells[MNS_CL_STDDEV] = cmd.a_cells[MNS_CL_COUNT] = 1;
  if (cmd.a_cells[MNS_CL_ALL])
    cmd.a_cells[MNS_CL_SUM] = cmd.a_cells[MNS_CL_VARIANCE] = 1;

  if (cmd.sbc_statistics)
    {
      if (!cmd.a_statistics[MNS_ST_ANOVA] && !cmd.a_statistics[MNS_ST_LINEARITY])
	cmd.a_statistics[MNS_ST_ANOVA] = 1;
      if (cmd.a_statistics[MNS_ST_ALL])
	cmd.a_statistics[MNS_ST_ANOVA] = cmd.a_statistics[MNS_ST_LINEARITY] = 1;
    }

  if (!cmd.sbc_tables)
    {
      msg (SE, _("Missing required subcommand TABLES."));
      goto free;
    }

  success = CMD_SUCCESS;

free:
  {
    int i;

    for (i = 0; i < n_dim; i++)
      free (v_dim[i]);
    free (nv_dim);
    free (v_dim);
    free (v_var);
  }

  return success;
}

/* Parses the TABLES subcommand. */
static int
mns_custom_tables (struct lexer *lexer, struct dataset *ds, struct cmd_means *cmd, void *aux UNUSED)
{
  struct const_var_set *var_set;

  if (!lex_match_id (lexer, "TABLES")
      && (lex_token (lexer) != T_ID || dict_lookup_var (dataset_dict (ds), lex_tokid (lexer)) == NULL)
      && lex_token (lexer) != T_ALL)
    return 2;
  lex_match (lexer, '=');

  if (cmd->sbc_tables)
    {
      msg (SE, _("TABLES subcommand may not appear more "
		 "than once."));
      return 0;
    }

  var_set = const_var_set_create_from_dict (dataset_dict (ds));
  assert (var_set != NULL);

  do
    {
      size_t nvl;
      const struct variable **vl;

      if (!parse_const_var_set_vars (lexer, var_set, &vl, &nvl,
                               PV_NO_DUPLICATE | PV_NO_SCRATCH))
        goto lossage;

      n_dim++;
      nv_dim = xnrealloc (nv_dim, n_dim, sizeof *nv_dim);
      v_dim = xnrealloc (v_dim, n_dim, sizeof *v_dim);

      nv_dim[n_dim - 1] = nvl;
      v_dim[n_dim - 1] = vl;
    }
  while (lex_match (lexer, T_BY));

  const_var_set_destroy (var_set);
  return 1;

 lossage:
  const_var_set_destroy (var_set);
  return 0;
}

/*
   Local Variables:
   mode: c
   End:
*/
