/* src/language/tests/check-model.c		-*- mode: c; buffer-read-only: t -*-

   Generated by q2c from ../src/language/tests/check-model.q.
   Do not modify!
 */
#line 1 "../src/language/tests/check-model.q"
/* PSPP - a program for statistical analysis.
   Copyright (C) 2007 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>. */

#include <config.h>

#include <language/tests/check-model.h>

#include <errno.h>

#include <libpspp/model-checker.h>
#include <language/lexer/lexer.h>

#include "error.h"
#include "fwriteerror.h"

#include "gettext.h"
#define _(msgid) gettext (msgid)
#define N_(msgid) msgid

#line 40 "src/language/tests/check-model.c"
#include <stdlib.h>
#include <libpspp/alloc.h>
#include <libpspp/assertion.h>
#include <libpspp/message.h>
#include <language/lexer/lexer.h>
#include <language/lexer/variable-parser.h>
#include <data/settings.h>
#include <libpspp/magic.h>
#include <libpspp/str.h>
#include <language/lexer/subcommand-list.h>
#include <data/variable.h>

#include "gettext.h"
#define _(msgid) gettext (msgid)

#line 34 "../src/language/tests/check-model.q"

#line 58 "src/language/tests/check-model.c"
#line 52 "../src/language/tests/check-model.q"
#line 60 "src/language/tests/check-model.c"
struct dataset;
/* Settings for subcommand specifiers. */
enum
  {
    CHM_BROAD = 1000,
    CHM_DEEP,
    CHM_RANDOM,
    CHM_MXD,
    CHM_HASH,
    CHM_LIMIT,
    CHM_NEWEST,
    CHM_OLDEST,
    CHM_STATES,
    CHM_ERRORS,
    CHM_TIMEOUT,
    CHM_NONE,
    CHM_DOTS,
    CHM_FANCY,
    CHM_VERBOSITY,
    CHM_ERRVERBOSITY,
    CHM_FILE
  };

#define MAXLISTS 10
/* CHECK MODEL structure. */
struct cmd_check_model
  {
    /* SEARCH subcommand. */
    int sbc_search;
    long strategy;
    long max_depth;
    long hash_bits;
    
    /* PATH subcommand. */
    int sbc_path;
    subc_list_int il_path[MAXLISTS];
    
    /* QUEUE subcommand. */
    int sbc_queue;
    long queue_limit;
    long drop;
    
    /* SEED subcommand. */
    int sbc_seed;
    long n_seed[MAXLISTS];
    
    /* STOP subcommand. */
    int sbc_stop;
    long max_unique_states;
    long max_errors;
    double time_limit;
    
    /* PROGRESS subcommand. */
    int sbc_progress;
    long progress;
    
    /* OUTPUT subcommand. */
    int sbc_output;
    long verbosity;
    long err_verbosity;
    char * output_file;
  };

/* Command parsing functions. */
static int parse_check_model (struct lexer *, struct dataset *, struct cmd_check_model *, void *);
static void free_check_model (struct cmd_check_model *);

#line 53 "../src/language/tests/check-model.q"
#line 129 "src/language/tests/check-model.c"
static int
parse_check_model (struct lexer *lexer, struct dataset *ds UNUSED, struct cmd_check_model *p, void *aux UNUSED)
{
  p->sbc_search = 0;
  p->strategy = -1;
  p->max_depth = NOT_LONG;
  p->hash_bits = NOT_LONG;
  p->sbc_path = 0;
  {
    int i;
    for (i = 0; i < MAXLISTS; ++i)
      subc_list_int_create(&p->il_path[i]) ;
  }
  p->sbc_queue = 0;
  p->queue_limit = NOT_LONG;
  p->drop = -1;
  p->sbc_seed = 0;
  {
    int i;
    for (i = 0; i < MAXLISTS; ++i)
      p->n_seed[i] = NOT_LONG;
  }
  p->sbc_stop = 0;
  p->max_unique_states = NOT_LONG;
  p->max_errors = NOT_LONG;
  p->time_limit = SYSMIS;
  p->sbc_progress = 0;
  p->progress = -1;
  p->sbc_output = 0;
  p->verbosity = NOT_LONG;
  p->err_verbosity = NOT_LONG;
  p->output_file = NULL;
  for (;;)
    {
      if (lex_match_id (lexer, "SEARCH"))
        {
          lex_match (lexer, '=');
          p->sbc_search++;
          if (p->sbc_search > 1)
            {
              msg (SE, _("SEARCH subcommand may be given only once."));
              goto lossage;
            }
          while (lex_token (lexer) != '/' && lex_token (lexer) != '.')
            {
              if (lex_match_id (lexer, "BROAD"))
                p->strategy = CHM_BROAD;
              else if (lex_match_id (lexer, "DEEP"))
                p->strategy = CHM_DEEP;
              else if (lex_match_id (lexer, "RANDOM"))
                p->strategy = CHM_RANDOM;
              else if (lex_match_id (lexer, "MXD"))
                {
                  if (!lex_match (lexer, '('))
                    {
                      msg (SE, _("`(' expected after MXD specifier of SEARCH subcommand."));
                      goto lossage;
                    }
                  if (!lex_is_integer (lexer))
                    {
                      msg (SE, _("MXD specifier of SEARCH subcommand requires an integer argument."));
                      goto lossage;
                    }
                  p->max_depth = lex_integer (lexer);
                  lex_get (lexer);
                  if (!lex_match (lexer, ')'))
                    {
                      msg (SE, _("`)' expected after argument for MXD specifier of SEARCH."));
                      goto lossage;
                    }
                }
              else if (lex_match_id (lexer, "HASH"))
                {
                  if (!lex_match (lexer, '('))
                    {
                      msg (SE, _("`(' expected after HASH specifier of SEARCH subcommand."));
                      goto lossage;
                    }
                  if (!lex_is_integer (lexer))
                    {
                      msg (SE, _("HASH specifier of SEARCH subcommand requires an integer argument."));
                      goto lossage;
                    }
                  p->hash_bits = lex_integer (lexer);
                  lex_get (lexer);
                  if (!lex_match (lexer, ')'))
                    {
                      msg (SE, _("`)' expected after argument for HASH specifier of SEARCH."));
                      goto lossage;
                    }
                }
              else
                {
                  lex_error (lexer, NULL);
                  goto lossage;
                }
              lex_match (lexer, ',');
            }
        }
      else if (lex_match_id (lexer, "PATH"))
        {
          lex_match (lexer, '=');
          p->sbc_path++;
          if (p->sbc_path > 1)
            {
              msg (SE, _("PATH subcommand may be given only once."));
              goto lossage;
            }
          if ( p->sbc_path > MAXLISTS)
          {
            msg (SE, "No more than %d path subcommands allowed",MAXLISTS);
            goto lossage;
          }
          while (lex_token (lexer) != '/' && lex_token (lexer) != '.')
            {
              lex_match (lexer, ',');
              if (!lex_force_num (lexer))
              {
                goto lossage;
              }
              subc_list_int_push (&p->il_path[p->sbc_path-1], lex_number (lexer));
              lex_get (lexer);
            }
          }
        else if (lex_match_id (lexer, "QUEUE"))
          {
            lex_match (lexer, '=');
            p->sbc_queue++;
            if (p->sbc_queue > 1)
              {
                msg (SE, _("QUEUE subcommand may be given only once."));
                goto lossage;
              }
            while (lex_token (lexer) != '/' && lex_token (lexer) != '.')
              {
                if (lex_match_id (lexer, "LIMIT"))
                  {
                    if (!lex_match (lexer, '('))
                      {
                        msg (SE, _("`(' expected after LIMIT specifier of QUEUE subcommand."));
                        goto lossage;
                      }
                    if (!lex_is_integer (lexer))
                      {
                        msg (SE, _("LIMIT specifier of QUEUE subcommand requires an integer argument."));
                        goto lossage;
                      }
                    p->queue_limit = lex_integer (lexer);
                    if (!(p->queue_limit>0))
                      {
                        msg (SE, _("Bad argument for LIMIT specifier of QUEUE subcommand."));
                        goto lossage;
                      }
                    lex_get (lexer);
                    if (!lex_match (lexer, ')'))
                      {
                        msg (SE, _("`)' expected after argument for LIMIT specifier of QUEUE."));
                        goto lossage;
                      }
                  }
                else if (lex_match_id (lexer, "NEWEST"))
                  p->drop = CHM_NEWEST;
                else if (lex_match_id (lexer, "OLDEST"))
                  p->drop = CHM_OLDEST;
                else if (lex_match_id (lexer, "RANDOM"))
                  p->drop = CHM_RANDOM;
                else
                  {
                    lex_error (lexer, NULL);
                    goto lossage;
                  }
                lex_match (lexer, ',');
              }
          }
        else if (lex_match_id (lexer, "SEED"))
          {
            lex_match (lexer, '=');
            p->sbc_seed++;
            if (p->sbc_seed > 1)
              {
                msg (SE, _("SEED subcommand may be given only once."));
                goto lossage;
              }
            {
              int x;
              if (!lex_force_int (lexer))
                goto lossage;
              x = lex_integer (lexer);
              lex_get(lexer);
              p->n_seed[p->sbc_seed - 1] = x;
            }
          }
        else if (lex_match_id (lexer, "STOP"))
          {
            lex_match (lexer, '=');
            p->sbc_stop++;
            if (p->sbc_stop > 1)
              {
                msg (SE, _("STOP subcommand may be given only once."));
                goto lossage;
              }
            while (lex_token (lexer) != '/' && lex_token (lexer) != '.')
              {
                if (lex_match_id (lexer, "STATES"))
                  {
                    if (!lex_match (lexer, '('))
                      {
                        msg (SE, _("`(' expected after STATES specifier of STOP subcommand."));
                        goto lossage;
                      }
                    if (!lex_is_integer (lexer))
                      {
                        msg (SE, _("STATES specifier of STOP subcommand requires an integer argument."));
                        goto lossage;
                      }
                    p->max_unique_states = lex_integer (lexer);
                    if (!(p->max_unique_states>0))
                      {
                        msg (SE, _("Bad argument for STATES specifier of STOP subcommand."));
                        goto lossage;
                      }
                    lex_get (lexer);
                    if (!lex_match (lexer, ')'))
                      {
                        msg (SE, _("`)' expected after argument for STATES specifier of STOP."));
                        goto lossage;
                      }
                  }
                else if (lex_match_id (lexer, "ERRORS"))
                  {
                    if (!lex_match (lexer, '('))
                      {
                        msg (SE, _("`(' expected after ERRORS specifier of STOP subcommand."));
                        goto lossage;
                      }
                    if (!lex_is_integer (lexer))
                      {
                        msg (SE, _("ERRORS specifier of STOP subcommand requires an integer argument."));
                        goto lossage;
                      }
                    p->max_errors = lex_integer (lexer);
                    lex_get (lexer);
                    if (!lex_match (lexer, ')'))
                      {
                        msg (SE, _("`)' expected after argument for ERRORS specifier of STOP."));
                        goto lossage;
                      }
                  }
                else if (lex_match_id (lexer, "TIMEOUT"))
                  {
                    if (!lex_match (lexer, '('))
                      {
                        msg (SE, _("`(' expected after TIMEOUT specifier of STOP subcommand."));
                        goto lossage;
                      }
                    if (!lex_is_number (lexer))
                      {
                        msg (SE, _("Number expected after TIMEOUT specifier of STOP subcommand."));
                        goto lossage;
                      }
                    p->time_limit = lex_tokval (lexer);
                    if (!(p->time_limit>0))
                      {
                        msg (SE, _("Bad argument for TIMEOUT specifier of STOP subcommand."));
                        goto lossage;
                      }
                    lex_get (lexer);
                    if (!lex_match (lexer, ')'))
                      {
                        msg (SE, _("`)' expected after argument for TIMEOUT specifier of STOP."));
                        goto lossage;
                      }
                  }
                else
                  {
                    lex_error (lexer, NULL);
                    goto lossage;
                  }
                lex_match (lexer, ',');
              }
          }
        else if (lex_match_id (lexer, "PROGRESS"))
          {
            lex_match (lexer, '=');
            p->sbc_progress++;
            if (p->sbc_progress > 1)
              {
                msg (SE, _("PROGRESS subcommand may be given only once."));
                goto lossage;
              }
            while (lex_token (lexer) != '/' && lex_token (lexer) != '.')
              {
                if (lex_match_id (lexer, "NONE"))
                  p->progress = CHM_NONE;
                else if (lex_match_id (lexer, "DOTS"))
                  p->progress = CHM_DOTS;
                else if (lex_match_id (lexer, "FANCY"))
                  p->progress = CHM_FANCY;
                else
                  {
                    lex_error (lexer, NULL);
                    goto lossage;
                  }
                lex_match (lexer, ',');
              }
          }
        else if (lex_match_id (lexer, "OUTPUT"))
          {
            lex_match (lexer, '=');
            p->sbc_output++;
            if (p->sbc_output > 1)
              {
                msg (SE, _("OUTPUT subcommand may be given only once."));
                goto lossage;
              }
            while (lex_token (lexer) != '/' && lex_token (lexer) != '.')
              {
                if (lex_match_id (lexer, "VERBOSITY"))
                  {
                    if (!lex_match (lexer, '('))
                      {
                        msg (SE, _("`(' expected after VERBOSITY specifier of OUTPUT subcommand."));
                        goto lossage;
                      }
                    if (!lex_is_integer (lexer))
                      {
                        msg (SE, _("VERBOSITY specifier of OUTPUT subcommand requires an integer argument."));
                        goto lossage;
                      }
                    p->verbosity = lex_integer (lexer);
                    lex_get (lexer);
                    if (!lex_match (lexer, ')'))
                      {
                        msg (SE, _("`)' expected after argument for VERBOSITY specifier of OUTPUT."));
                        goto lossage;
                      }
                  }
                else if (lex_match_id (lexer, "ERRVERBOSITY"))
                  {
                    if (!lex_match (lexer, '('))
                      {
                        msg (SE, _("`(' expected after ERRVERBOSITY specifier of OUTPUT subcommand."));
                        goto lossage;
                      }
                    if (!lex_is_integer (lexer))
                      {
                        msg (SE, _("ERRVERBOSITY specifier of OUTPUT subcommand requires an integer argument."));
                        goto lossage;
                      }
                    p->err_verbosity = lex_integer (lexer);
                    lex_get (lexer);
                    if (!lex_match (lexer, ')'))
                      {
                        msg (SE, _("`)' expected after argument for ERRVERBOSITY specifier of OUTPUT."));
                        goto lossage;
                      }
                  }
                else if (lex_match_id (lexer, "FILE"))
                  {
                    if (!lex_match (lexer, '('))
                      {
                        msg (SE, _("`(' expected after FILE specifier of OUTPUT subcommand."));
                        goto lossage;
                      }
                    if (lex_token (lexer) != T_ID && lex_token (lexer) != T_STRING)
                      {
                        msg (SE, _("FILE specifier of OUTPUT subcommand requires a string argument."));
                        goto lossage;
                      }
                    free (p->output_file);
                    p->output_file = xstrdup (ds_cstr (lex_tokstr (lexer)));
                    lex_get (lexer);
                    if (!lex_match (lexer, ')'))
                      {
                        msg (SE, _("`)' expected after argument for FILE specifier of OUTPUT."));
                        goto lossage;
                      }
                  }
                else
                  {
                    lex_error (lexer, NULL);
                    goto lossage;
                  }
                lex_match (lexer, ',');
              }
          }
        else if ( get_syntax() != COMPATIBLE && lex_match_id(lexer, "ALGORITHM"))
          {
            lex_match (lexer, '=');
            if (lex_match_id(lexer, "COMPATIBLE"))
              set_cmd_algorithm(COMPATIBLE);
            else if (lex_match_id(lexer, "ENHANCED"))
              set_cmd_algorithm(ENHANCED);
            }
          if (!lex_match (lexer, '/'))
            break;
        }
      
      if (lex_token (lexer) != '.')
        {
          lex_error (lexer, _("expecting end of command"));
          goto lossage;
        }
        
    return true;
    
  lossage:
    free_check_model (p);
    return false;
  }
  
static void
free_check_model (struct cmd_check_model *p UNUSED)
{
  {
  int i;
    for(i = 0; i < MAXLISTS ; ++i)
        subc_list_int_destroy(&p->il_path[i]);
          }
        free (p->output_file);
      }
#line 54 "../src/language/tests/check-model.q"

static struct mc_options *parse_options (struct lexer *);
static void print_results (const struct mc_results *, FILE *);

/* Parses a syntax description of model checker options from
   LEXER and passes them, along with AUX, to the CHECKER
   function, which must wrap a call to mc_run and return the
   mc_results that it returned.  This function then prints a
   description of the mc_results to the output file.  Returns
   true if the model checker run found no errors, false
   otherwise. */
bool
check_model (struct lexer *lexer,
             struct mc_results *(*checker) (struct mc_options *, void *aux),
             void *aux)
{
  struct mc_options *options;
  struct mc_results *results;
  FILE *output_file;
  bool ok;

  options = parse_options (lexer);
  if (options == NULL)
    return false;
  output_file = mc_options_get_output_file (options);

  results = checker (options, aux);

  print_results (results, output_file);

  if (output_file != stdout && output_file != stderr)
    {
      if (fwriteerror (output_file) < 0)
        {
          /* We've already discarded the name of the output file.
             Oh well. */
          error (0, errno, "error closing output file");
        }
    }

  ok = mc_results_get_error_count (results) == 0;
  mc_results_destroy (results);

  return ok;
}

/* Fancy progress function for mc_options_set_progress_func. */
static bool
fancy_progress (struct mc *mc)
{
  const struct mc_results *results = mc_get_results (mc);
  if (mc_results_get_stop_reason (results) == MC_CONTINUING)
    fprintf (stderr, "Processed %d unique states, max depth %d, "
             "dropped %d duplicates...\r",
             mc_results_get_unique_state_count (results),
             mc_results_get_max_depth_reached (results),
             mc_results_get_duplicate_dropped_states (results));
  else
    putc ('\n', stderr);
  return true;
}

/* Parses options from LEXER and returns a corresponding
   mc_options, or a null pointer if parsing fails. */
static struct mc_options *
parse_options (struct lexer *lexer)
{
  struct cmd_check_model cmd;
  struct mc_options *options;

  if (!parse_check_model (lexer, NULL, &cmd, NULL))
    return NULL;

  options = mc_options_create ();
  if (cmd.strategy != -1)
    mc_options_set_strategy (options,
                             cmd.strategy == CHM_BROAD ? MC_BROAD
                             : cmd.strategy == CHM_DEEP ? MC_DEEP
                             : cmd.strategy == CHM_RANDOM ? MC_RANDOM
                             : -1);
  if (cmd.sbc_path > 0)
    {
      if (cmd.sbc_search > 0)
        msg (SW, _("PATH and SEARCH subcommands are mutually exclusive.  "
                   "Ignoring PATH."));
      else
        {
          struct subc_list_int *list = &cmd.il_path[0];
          int count = subc_list_int_count (list);
          if (count > 0)
            {
              struct mc_path path;
              int i;

              mc_path_init (&path);
              for (i = 0; i < count; i++)
                mc_path_push (&path, subc_list_int_at (list, i));
              mc_options_set_follow_path (options, &path);
              mc_path_destroy (&path);
            }
          else
            msg (SW, _("At least one value must be specified on PATH."));
        }
    }
  if (cmd.max_depth != NOT_LONG)
    mc_options_set_max_depth (options, cmd.max_depth);
  if (cmd.hash_bits != NOT_LONG)
    {
      int hash_bits;
      mc_options_set_hash_bits (options, cmd.hash_bits);
      hash_bits = mc_options_get_hash_bits (options);
      if (hash_bits != cmd.hash_bits)
        msg (SW, _("Hash bits adjusted to %d."), hash_bits);
    }
  if (cmd.queue_limit != NOT_LONG)
    mc_options_set_queue_limit (options, cmd.queue_limit);
  if (cmd.drop != -1)
    {
      enum mc_queue_limit_strategy drop
        = (cmd.drop == CHM_NEWEST ? MC_DROP_NEWEST
           : cmd.drop == CHM_OLDEST ? MC_DROP_OLDEST
           : cmd.drop == CHM_RANDOM ? MC_DROP_RANDOM
           : -1);
      mc_options_set_queue_limit_strategy (options, drop);
    }
  if (cmd.sbc_search > 0)
    mc_options_set_seed (options, cmd.n_seed[0]);
  if (cmd.max_unique_states != NOT_LONG)
    mc_options_set_max_unique_states (options, cmd.max_unique_states);
  if (cmd.max_errors != NOT_LONG)
    mc_options_set_max_errors (options, cmd.max_errors);
  if (cmd.time_limit != SYSMIS)
    mc_options_set_time_limit (options, cmd.time_limit);
  if (cmd.verbosity != NOT_LONG)
    mc_options_set_verbosity (options, cmd.verbosity);
  if (cmd.err_verbosity != NOT_LONG)
    mc_options_set_failure_verbosity (options, cmd.err_verbosity);
  if (cmd.progress != -1)
    {
      if (cmd.progress == CHM_NONE)
        mc_options_set_progress_usec (options, 0);
      else if (cmd.progress == CHM_DOTS)
        {
          /* Nothing to do: that's the default anyway. */
        }
      else if (cmd.progress == CHM_FANCY)
        mc_options_set_progress_func (options, fancy_progress);
    }
  if (cmd.output_file != NULL)
    {
      FILE *output_file = fopen (cmd.output_file, "w");
      if (output_file == NULL)
        {
          error (0, errno, _("error opening \"%s\" for writing"),
                 cmd.output_file);
          free_check_model (&cmd);
          mc_options_destroy (options);
          return NULL;
        }
      mc_options_set_output_file (options, output_file);
    }


  free_check_model (&cmd);

  return options;
}

/* Prints a description of RESULTS to stream F. */
static void
print_results (const struct mc_results *results, FILE *f)
{
  enum mc_stop_reason reason = mc_results_get_stop_reason (results);

  fputs ("\n"
         "MODEL CHECKING SUMMARY\n"
         "----------------------\n\n", f);

  fprintf (f, "Stopped by: %s\n",
           reason == MC_SUCCESS ? "state space exhaustion"
           : reason == MC_MAX_UNIQUE_STATES ? "reaching max unique states"
           : reason == MC_MAX_ERROR_COUNT ? "reaching max error count"
           : reason == MC_END_OF_PATH ? "reached end of specified path"
           : reason == MC_TIMEOUT ? "reaching time limit"
           : reason == MC_INTERRUPTED ? "user interruption"
           : "unknown reason");
  fprintf (f, "Errors found: %d\n\n", mc_results_get_error_count (results));

  fprintf (f, "Unique states checked: %d\n",
           mc_results_get_unique_state_count (results));
  fprintf (f, "Maximum depth reached: %d\n",
           mc_results_get_max_depth_reached (results));
  fprintf (f, "Mean depth reached: %.2f\n\n",
           mc_results_get_mean_depth_reached (results));

  fprintf (f, "Dropped duplicate states: %d\n",
           mc_results_get_duplicate_dropped_states (results));
  fprintf (f, "Dropped off-path states: %d\n",
           mc_results_get_off_path_dropped_states (results));
  fprintf (f, "Dropped too-deep states: %d\n",
           mc_results_get_depth_dropped_states (results));
  fprintf (f, "Dropped queue-overflow states: %d\n",
           mc_results_get_queue_dropped_states (results));
  fprintf (f, "Checked states still queued when stopped: %d\n",
           mc_results_get_queued_unprocessed_states (results));
  fprintf (f, "Maximum queue length reached: %d\n\n",
           mc_results_get_max_queue_length (results));

  fprintf (f, "Runtime: %.2f seconds\n",
           mc_results_get_duration (results));

  putc ('\n', f);
}

/*
  Local Variables:
  mode: c
  End:
*/
