#!/bin/sh

# This program tests the LIST command.

TEMPDIR=/tmp/pspp-tst-$$
TESTFILE=$TEMPDIR/`basename $0`.sps

# ensure that top_builddir  are absolute
if [ -z "$top_builddir" ] ; then top_builddir=. ; fi
if [ -z "$top_srcdir" ] ; then top_srcdir=. ; fi
top_builddir=`cd $top_builddir; pwd`
PSPP=$top_builddir/src/ui/terminal/pspp

# ensure that top_srcdir is absolute
top_srcdir=`cd $top_srcdir; pwd`

STAT_CONFIG_PATH=$top_srcdir/config
export STAT_CONFIG_PATH

LANG=C
export LANG

cleanup()
{
     cd /
     rm -rf $TEMPDIR
}


fail()
{
    echo $activity
    echo FAILED
    cleanup;
    exit 1;
}


no_result()
{
    echo $activity
    echo NO RESULT;
    cleanup;
    exit 2;
}

pass()
{
    cleanup;
    exit 0;
}

mkdir -p $TEMPDIR

cd $TEMPDIR


activity="create program"
cat > $TESTFILE << EOF
*** Single lines.
data list file='$top_srcdir/tests/weighting.data'/AVAR 1-5 BVAR 6-10.
weight by BVAR.
list.
*list /cases=from 5 to 20 by 2 /format numbered.
list /format numbered weight.

*** Multiple lines.
data list file='$top_srcdir/tests/list.data' notable /X000 to X126 1-127.
*list /cases=from 1 to 25 by 5 /format numbered.
list x000 to x030.
list /cases=from 1 to 25.

EOF
if [ $? -ne 0 ] ; then no_result ; fi

activity="run program"
$SUPERVISOR $PSPP --testing-mode $TESTFILE
if [ $? -ne 0 ] ; then no_result ; fi


activity="compare results"
perl -pi -e 's/^\s*$//g' $TEMPDIR/pspp.list
diff -b  $TEMPDIR/pspp.list - <<EOF
1.1 DATA LIST.  Reading 1 record from "$top_srcdir/tests/weighting.data".
+--------+------+-------+------+
|Variable|Record|Columns|Format|
#========#======#=======#======#
|AVAR    |     1|  1-  5|F5.0  |
|BVAR    |     1|  6- 10|F5.0  |
+--------+------+-------+------+
 AVAR  BVAR
----- -----
   18     1 
   19     7 
   20    26 
   21    76 
   22    57 
   23    58 
   24    38 
   25    38 
   26    30 
   27    21 
   28    23 
   29    24 
   30    23 
   31    14 
   32    21 
   33    21 
   34    14 
   35    14 
   36    17 
   37    11 
   38    16 
   39    14 
   40    15 
   41    14 
   42    14 
   43     8 
   44    15 
   45    10 
   46    12 
   47    13 
   48    13 
   49     5 
   50     5 
   51     3 
   52     7 
   53     6 
   54     2 
   55     2 
   56     2 
   57     3 
   58     1 
   59     3 
   61     1 
   62     3 
   63     1 
   64     1 
   65     2 
   70     1 
   78     1 
   79     1 
   80     1 
   94     1 
Case#  AVAR  BVAR
----- ----- -----
    1    18     1 
    2    19     7 
    3    20    26 
    4    21    76 
    5    22    57 
    6    23    58 
    7    24    38 
    8    25    38 
    9    26    30 
   10    27    21 
   11    28    23 
   12    29    24 
   13    30    23 
   14    31    14 
   15    32    21 
   16    33    21 
   17    34    14 
   18    35    14 
   19    36    17 
   20    37    11 
   21    38    16 
   22    39    14 
   23    40    15 
   24    41    14 
   25    42    14 
   26    43     8 
   27    44    15 
   28    45    10 
   29    46    12 
   30    47    13 
   31    48    13 
   32    49     5 
   33    50     5 
   34    51     3 
   35    52     7 
   36    53     6 
   37    54     2 
   38    55     2 
   39    56     2 
   40    57     3 
   41    58     1 
   42    59     3 
   43    61     1 
   44    62     3 
   45    63     1 
   46    64     1 
   47    65     2 
   48    70     1 
   49    78     1 
   50    79     1 
   51    80     1 
   52    94     1 
X000 X001 X002 X003 X004 X005 X006 X007 X008 X009 X010 X011 X012 X013 X014 X015 X016 X017 X018 X019 X020 X021 X022 X023 X024 X025 X026 X027 X028 X029 X030
---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ----
   7    6    7    5    3    2    4    6    6    3    4    8    5    1    3    7    8    9    0    7    3    4    8    3    1    0    6    4    0    9    1 
   8    8    8    6    9    3    0    8    9    4    2    4    1    7    7    5    4    2    3    7    8    3    3    4    1    8    6    7    6    0    3 
   4    9    2    6    1    1    5    0    7    9    0    9    1    8    7    1    5    2    7    2    6    4    2    7    8    5    2    2    4    2    4 
   8    1    9    8    4    8    8    9    2    0    2    3    1    9    5    8    7    5    8    7    9    3    3    2    0    0    1    4    9    1    7 
   4    5    2    7    7    7    8    9    8    7    0    9    5    6    3    7    2    9    8    4    5    5    4    1    5    1    6    6    5    0    6 
   2    3    9    9    6    1    9    6    7    0    7    7    7    3    2    7    6    0    6    6    3    5    2    5    1    1    5    0    7    3    5 
   1    6    6    7    7    9    9    6    9    1    2    6    6    4    7    6    9    9    4    4    0    4    7    4    3    9    8    9    2    3    7 
   1    6    2    3    9    1    4    6    8    4    1    9    6    8    9    2    3    1    6    8    4    7    1    1    7    0    1    1    5    4    3 
   3    6    8    1    3    9    3    2    3    3    7    6    0    1    2    9    4    8    9    1    1    3    1    2    1    8    2    9    5    9    9 
   6    4    1    8    7    3    1    1    4    5    4    3    1    0    8    2    9    9    4    8    5    6    8    1    6    5    0    5    0    3    5 
   2    2    8    4    5    3    4    0    8    3    7    4    9    5    0    7    7    1    6    6    5    1    0    8    6    4    2    9    0    7    1 
   6    6    1    7    6    3    7    4    5    2    0    4    0    7    4    9    1    8    1    3    4    9    9    1    1    7    8    8    9    7    4 
   9    8    6    5    7    1    3    5    8    2    6    8    6    6    1    2    0    0    7    2    2    2    0    1    0    7    8    2    6    8    2 
   1    1    6    3    2    3    4    5    3    7    7    6    2    2    0    0    8    0    7    7    9    4    9    6    0    2    5    2    4    4    7 
   9    9    8    1    6    6    3    6    3    7    5    6    3    8    3    3    3    0    0    0    3    5    4    2    6    1    3    6    7    0    2 
   6    8    2    1    5    6    7    7    4    6    0    5    9    1    0    3    5    6    5    0    0    5    7    3    8    9    6    0    2    4    8 
   0    9    5    2    7    7    4    9    5    2    6    7    5    2    6    1    5    4    5    9    5    5    2    8    0    8    0    5    3    4    0 
   1    6    4    1    7    9    0    1    9    3    2    1    1    8    6    1    5    0    9    1    0    6    8    3    9    2    1    7    1    1    9 
   3    7    6    3    1    8    2    8    7    1    5    8    0    1    7    4    7    8    9    3    2    8    8    3    7    1    9    4    9    6    8 
   2    0    4    6    8    2    0    7    5    3    0    6    2    2    2    4    0    4    5    5    3    5    8    9    0    9    3    2    7    2    1 
   7    9    7    0    6    2    0    0    9    1    9    4    0    3    8    5    9    2    8    7    6    2    6    3    2    7    6    4    6    1    8 
   4    8    4    1    1    7    6    0    1    7    0    2    5    1    0    5    7    7    4    5    0    6    5    0    0    8    9    6    2    5    2 
   6    9    4    9    9    7    3    7    9    7    9    9    0    9    5    6    2    9    1    0    7    2    1    5    8    1    2    3    8    8    7 
   1    3    9    6    2    8    5    9    9    6    5    3    5    4    8    9    4    4    0    8    1    6    1    2    4    7    0    0    6    8    2 
   0    7    0    0    4    8    9    5    2    4    3    5    8    2    0    8    3    5    8    6    9    7    3    4    9    4    5    0    0    3    6 
X000 X001 X002 X003 X004 X005 X006 X007 X008 X009 X010 X011 X012 X013 X014 X015 X016 X017 X018 X019 X020 X021 X022 X023 X024 X025 X026 X027 X028 X029 X030 X031 X032 X033 X034 X035 X036 X037 X038 X039 X040 X041 X042 X043 X044 X045 X046 X047 X048 X049 X050 X051 X052 X053 X054 X055 X056 X057 X058 X059 X060 X061 X062 X063 X064 X065 X066 X067 X068 X069 X070 X071 X072 X073 X074 X075 X076 X077 X078 X079 X080 X081 X082 X083 X084 X085 X086 X087 X088 X089 X090 X091 X092 X093 X094 X095 X096 X097 X098 X099 X100 X101 X102 X103 X104 X105 X106 X107 X108 X109 X110 X111 X112 X113 X114 X115 X116 X117 X118 X119 X120 X121 X122 X123 X124 X125 X126
---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ----
   7    6    7    5    3    2    4    6    6    3    4    8    5    1    3    7    8    9    0    7    3    4    8    3    1    0    6    4    0    9    1    7    5    8    5    9    2    9    5    8    4    2    8    1    5    2    9    5    1    1    3    7    5    3    2    6    5    9    4    1    8    7    5    2    3    3    8    1    5    7    6    7    5    3    2    4    6    6    3    4    8    5    1    3    7    8    9    0    7    3    4    8    3    1    0    6    4    0    9    1    7    5    8    5    9    2    9    5    8    4    2    8    1    5    2    9    5    1    1    3    7    5    3    2    6    5    8 
   8    8    8    6    9    3    0    8    9    4    2    4    1    7    7    5    4    2    3    7    8    3    3    4    1    8    6    7    6    0    3    6    8    1    4    7    5    5    8    6    9    0    0    2    7    9    7    3    1    0    2    2    6    6    8    7    4    1    6    8    4    5    5    5    0    6    7    1    4    8    8    8    6    9    3    0    8    9    4    2    4    1    7    7    5    4    2    3    7    8    3    3    4    1    8    6    7    6    0    3    6    8    1    4    7    5    5    8    6    9    0    0    2    7    9    7    3    1    0    2    2    6    6    8    7    4    6 
   4    9    2    6    1    1    5    0    7    9    0    9    1    8    7    1    5    2    7    2    6    4    2    7    8    5    2    2    4    2    4    8    3    8    5    6    2    0    6    9    9    8    0    2    7    8    3    4    2    1    8    8    7    2    5    5    8    6    2    6    0    0    4    1    5    2    6    0    2    4    9    2    6    1    1    5    0    7    9    0    9    1    8    7    1    5    2    7    2    6    4    2    7    8    5    2    2    4    2    4    8    3    8    5    6    2    0    6    9    9    8    0    2    7    8    3    4    2    1    8    8    7    2    5    5    8    9 
   8    1    9    8    4    8    8    9    2    0    2    3    1    9    5    8    7    5    8    7    9    3    3    2    0    0    1    4    9    1    7    7    3    6    8    9    6    8    8    0    1    3    3    2    2    1    0    1    6    0    8    8    4    4    0    6    4    0    2    3    6    2    6    5    7    2    7    0    0    8    1    9    8    4    8    8    9    2    0    2    3    1    9    5    8    7    5    8    7    9    3    3    2    0    0    1    4    9    1    7    7    3    6    8    9    6    8    8    0    1    3    3    2    2    1    0    1    6    0    8    8    4    4    0    6    4    1 
   4    5    2    7    7    7    8    9    8    7    0    9    5    6    3    7    2    9    8    4    5    5    4    1    5    1    6    6    5    0    6    9    5    0    6    4    7    7    4    6    6    4    5    1    2    0    8    4    9    8    8    7    6    4    0    1    6    0    6    5    9    5    0    5    3    9    1    4    9    4    5    2    7    7    7    8    9    8    7    0    9    5    6    3    7    2    9    8    4    5    5    4    1    5    1    6    6    5    0    6    9    5    0    6    4    7    7    4    6    6    4    5    1    2    0    8    4    9    8    8    7    6    4    0    1    6    6 
   2    3    9    9    6    1    9    6    7    0    7    7    7    3    2    7    6    0    6    6    3    5    2    5    1    1    5    0    7    3    5    1    8    6    0    5    9    1    1    8    1    8    6    9    1    0    8    8    0    4    6    5    1    9    0    3    2    8    1    9    6    2    4    6    8    9    6    7    5    2    3    9    9    6    1    9    6    7    0    7    7    7    3    2    7    6    0    6    6    3    5    2    5    1    1    5    0    7    3    5    1    8    6    0    5    9    1    1    8    1    8    6    9    1    0    8    8    0    4    6    5    1    9    0    3    2    5 
   1    6    6    7    7    9    9    6    9    1    2    6    6    4    7    6    9    9    4    4    0    4    7    4    3    9    8    9    2    3    7    3    1    5    3    9    4    2    7    6    4    1    2    0    7    9    7    6    0    3    1    0    7    0    6    3    9    5    1    0    3    2    9    9    4    4    1    5    7    1    6    6    7    7    9    9    6    9    1    2    6    6    4    7    6    9    9    4    4    0    4    7    4    3    9    8    9    2    3    7    3    1    5    3    9    4    2    7    6    4    1    2    0    7    9    7    6    0    3    1    0    7    0    6    3    9    4 
   1    6    2    3    9    1    4    6    8    4    1    9    6    8    9    2    3    1    6    8    4    7    1    1    7    0    1    1    5    4    3    6    2    7    1    1    9    5    9    7    9    0    8    5    9    9    7    4    0    5    2    5    2    4    6    1    6    4    1    9    1    5    0    8    0    1    3    2    0    1    6    2    3    9    1    4    6    8    4    1    9    6    8    9    2    3    1    6    8    4    7    1    1    7    0    1    1    5    4    3    6    2    7    1    1    9    5    9    7    9    0    8    5    9    9    7    4    0    5    2    5    2    4    6    1    6    8 
   3    6    8    1    3    9    3    2    3    3    7    6    0    1    2    9    4    8    9    1    1    3    1    2    1    8    2    9    5    9    9    8    5    7    2    8    8    5    0    1    0    9    9    1    2    3    2    8    3    1    9    6    6    2    8    7    1    4    1    4    8    9    6    5    0    8    4    5    7    3    6    8    1    3    9    3    2    3    3    7    6    0    1    2    9    4    8    9    1    1    3    1    2    1    8    2    9    5    9    9    8    5    7    2    8    8    5    0    1    0    9    9    1    2    3    2    8    3    1    9    6    6    2    8    7    1    0 
   6    4    1    8    7    3    1    1    4    5    4    3    1    0    8    2    9    9    4    8    5    6    8    1    6    5    0    5    0    3    5    9    9    7    9    8    2    0    9    6    7    3    2    1    5    0    3    5    9    7    5    4    5    4    7    2    9    9    6    1    8    4    8    7    8    8    5    3    0    6    4    1    8    7    3    1    1    4    5    4    3    1    0    8    2    9    9    4    8    5    6    8    1    6    5    0    5    0    3    5    9    9    7    9    8    2    0    9    6    7    3    2    1    5    0    3    5    9    7    5    4    5    4    7    2    9    7 
   2    2    8    4    5    3    4    0    8    3    7    4    9    5    0    7    7    1    6    6    5    1    0    8    6    4    2    9    0    7    1    2    1    9    7    6    5    1    6    3    7    5    9    8    2    9    7    9    3    4    7    8    5    8    7    1    4    7    2    3    4    3    4    1    2    3    4    4    2    2    2    8    4    5    3    4    0    8    3    7    4    9    5    0    7    7    1    6    6    5    1    0    8    6    4    2    9    0    7    1    2    1    9    7    6    5    1    6    3    7    5    9    8    2    9    7    9    3    4    7    8    5    8    7    1    4    9 
   6    6    1    7    6    3    7    4    5    2    0    4    0    7    4    9    1    8    1    3    4    9    9    1    1    7    8    8    9    7    4    7    5    7    5    2    2    4    6    9    6    6    4    8    3    8    8    6    7    9    0    1    0    1    4    1    8    2    4    8    6    6    9    7    5    7    2    9    5    6    6    1    7    6    3    7    4    5    2    0    4    0    7    4    9    1    8    1    3    4    9    9    1    1    7    8    8    9    7    4    7    5    7    5    2    2    4    6    9    6    6    4    8    3    8    8    6    7    9    0    1    0    1    4    1    8    5 
   9    8    6    5    7    1    3    5    8    2    6    8    6    6    1    2    0    0    7    2    2    2    0    1    0    7    8    2    6    8    2    7    7    8    2    6    9    8    3    9    2    9    9    8    7    1    3    9    3    0    1    5    4    3    6    4    0    2    0    2    6    9    8    5    4    0    9    0    8    9    8    6    5    7    1    3    5    8    2    6    8    6    6    1    2    0    0    7    2    2    2    0    1    0    7    8    2    6    8    2    7    7    8    2    6    9    8    3    9    2    9    9    8    7    1    3    9    3    0    1    5    4    3    6    4    0    6 
   1    1    6    3    2    3    4    5    3    7    7    6    2    2    0    0    8    0    7    7    9    4    9    6    0    2    5    2    4    4    7    7    7    3    0    9    8    4    4    3    3    4    0    7    6    2    8    4    4    7    3    4    3    5    0    3    7    8    7    5    0    4    4    0    9    0    2    9    5    1    1    6    3    2    3    4    5    3    7    7    6    2    2    0    0    8    0    7    7    9    4    9    6    0    2    5    2    4    4    7    7    7    3    0    9    8    4    4    3    3    4    0    7    6    2    8    4    4    7    3    4    3    5    0    3    7    7 
   9    9    8    1    6    6    3    6    3    7    5    6    3    8    3    3    3    0    0    0    3    5    4    2    6    1    3    6    7    0    2    8    9    3    9    8    9    4    6    4    1    2    3    5    2    6    0    8    7    3    8    0    8    3    4    4    4    5    1    3    2    8    0    7    9    0    5    5    4    9    9    8    1    6    6    3    6    3    7    5    6    3    8    3    3    3    0    0    0    3    5    4    2    6    1    3    6    7    0    2    8    9    3    9    8    9    4    6    4    1    2    3    5    2    6    0    8    7    3    8    0    8    3    4    4    4    9 
   6    8    2    1    5    6    7    7    4    6    0    5    9    1    0    3    5    6    5    0    0    5    7    3    8    9    6    0    2    4    8    8    4    2    1    9    8    9    9    5    5    9    0    6    0    2    2    8    8    7    0    0    4    7    6    2    8    2    3    0    7    1    1    0    2    9    1    6    8    6    8    2    1    5    6    7    7    4    6    0    5    9    1    0    3    5    6    5    0    0    5    7    3    8    9    6    0    2    4    8    8    4    2    1    9    8    9    9    5    5    9    0    6    0    2    2    8    8    7    0    0    4    7    6    2    8    4 
   0    9    5    2    7    7    4    9    5    2    6    7    5    2    6    1    5    4    5    9    5    5    2    8    0    8    0    5    3    4    0    3    5    7    5    4    5    9    4    2    4    0    0    1    5    6    2    0    1    9    1    8    6    3    8    7    4    2    0    8    2    1    3    4    2    4    3    3    3    0    9    5    2    7    7    4    9    5    2    6    7    5    2    6    1    5    4    5    9    5    5    2    8    0    8    0    5    3    4    0    3    5    7    5    4    5    9    4    2    4    0    0    1    5    6    2    0    1    9    1    8    6    3    8    7    4    8 
   1    6    4    1    7    9    0    1    9    3    2    1    1    8    6    1    5    0    9    1    0    6    8    3    9    2    1    7    1    1    9    4    9    6    8    6    5    8    7    7    1    1    8    4    0    6    5    7    9    6    1    9    4    9    2    6    1    4    7    4    4    1    1    4    8    6    9    0    2    1    6    4    1    7    9    0    1    9    3    2    1    1    8    6    1    5    0    9    1    0    6    8    3    9    2    1    7    1    1    9    4    9    6    8    6    5    8    7    7    1    1    8    4    0    6    5    7    9    6    1    9    4    9    2    6    1    5 
   3    7    6    3    1    8    2    8    7    1    5    8    0    1    7    4    7    8    9    3    2    8    8    3    7    1    9    4    9    6    8    5    3    6    8    7    6    0    7    4    3    4    4    5    6    2    9    3    2    1    8    7    9    6    0    8    9    3    2    7    5    8    8    1    6    5    6    4    4    3    7    6    3    1    8    2    8    7    1    5    8    0    1    7    4    7    8    9    3    2    8    8    3    7    1    9    4    9    6    8    5    3    6    8    7    6    0    7    4    3    4    4    5    6    2    9    3    2    1    8    7    9    6    0    8    9    1 
   2    0    4    6    8    2    0    7    5    3    0    6    2    2    2    4    0    4    5    5    3    5    8    9    0    9    3    2    7    2    1    1    3    7    8    1    9    8    0    7    3    3    3    7    5    7    1    7    1    9    2    6    4    2    5    4    4    2    9    7    3    4    3    9    4    2    6    7    9    2    0    4    6    8    2    0    7    5    3    0    6    2    2    2    4    0    4    5    5    3    5    8    9    0    9    3    2    7    2    1    1    3    7    8    1    9    8    0    7    3    3    3    7    5    7    1    7    1    9    2    6    4    2    5    4    4    1 
   7    9    7    0    6    2    0    0    9    1    9    4    0    3    8    5    9    2    8    7    6    2    6    3    2    7    6    4    6    1    8    5    2    5    8    9    9    8    9    0    1    8    6    1    3    5    9    2    9    7    9    7    1    7    0    4    5    6    3    3    9    5    8    9    3    1    8    3    4    7    9    7    0    6    2    0    0    9    1    9    4    0    3    8    5    9    2    8    7    6    2    6    3    2    7    6    4    6    1    8    5    2    5    8    9    9    8    9    0    1    8    6    1    3    5    9    2    9    7    9    7    1    7    0    4    5    8 
   4    8    4    1    1    7    6    0    1    7    0    2    5    1    0    5    7    7    4    5    0    6    5    0    0    8    9    6    2    5    2    7    5    7    0    7    6    6    9    0    3    9    2    0    3    4    6    0    1    2    8    3    8    3    4    0    4    8    3    0    8    8    4    3    6    3    2    6    4    4    8    4    1    1    7    6    0    1    7    0    2    5    1    0    5    7    7    4    5    0    6    5    0    0    8    9    6    2    5    2    7    5    7    0    7    6    6    9    0    3    9    2    0    3    4    6    0    1    2    8    3    8    3    4    0    4    5 
   6    9    4    9    9    7    3    7    9    7    9    9    0    9    5    6    2    9    1    0    7    2    1    5    8    1    2    3    8    8    7    4    7    3    5    8    2    9    6    2    6    7    3    8    7    8    5    1    9    6    1    9    8    3    4    8    6    8    8    0    1    5    6    8    5    3    6    3    2    6    9    4    9    9    7    3    7    9    7    9    9    0    9    5    6    2    9    1    0    7    2    1    5    8    1    2    3    8    8    7    4    7    3    5    8    2    9    6    2    6    7    3    8    7    8    5    1    9    6    1    9    8    3    4    8    6    8 
   1    3    9    6    2    8    5    9    9    6    5    3    5    4    8    9    4    4    0    8    1    6    1    2    4    7    0    0    6    8    2    9    3    3    8    7    4    3    6    5    1    2    8    7    8    6    8    2    3    8    2    4    7    5    8    1    3    3    4    6    1    1    5    6    6    4    9    7    2    1    3    9    6    2    8    5    9    9    6    5    3    5    4    8    9    4    4    0    8    1    6    1    2    4    7    0    0    6    8    2    9    3    3    8    7    4    3    6    5    1    2    8    7    8    6    8    2    3    8    2    4    7    5    8    1    3    8 
   0    7    0    0    4    8    9    5    2    4    3    5    8    2    0    8    3    5    8    6    9    7    3    4    9    4    5    0    0    3    6    2    0    8    3    7    8    4    2    1    8    7    8    8    0    0    6    3    6    4    2    7    1    5    1    2    1    1    1    8    5    3    2    0    1    9    4    6    6    0    7    0    0    4    8    9    5    2    4    3    5    8    2    0    8    3    5    8    6    9    7    3    4    9    4    5    0    0    3    6    2    0    8    3    7    8    4    2    1    8    7    8    8    0    0    6    3    6    4    2    7    1    5    1    2    1    8 
EOF
if [ $? -ne 0 ] ; then fail ; fi


pass
