dnl I'd like this to be edited in -*- Autoconf -*- mode...
dnl
AC_DEFUN([GST_CHECK_ALIGNMENT], [
AS_LITERAL_IF([$1], [],
               [AC_FATAL([$0: requires literal arguments])])dnl

AC_REQUIRE([AC_TYPE_SIGNAL])
AC_CACHE_CHECK([for $1 alignment], AS_TR_SH([gst_cv_$1_alignment]), [
if test "$cross_compiling" = yes; then
  _AC_COMPUTE_INT_COMPILE([sizeof($1)], [AS_TR_SH([gst_cv_$1_alignment])], [$2])
else
  _AC_COMPUTE_INT_RUN(alignment(), [AS_TR_SH([gst_cv_$1_alignment])], [$2
  #include <stdio.h>
  #include <setjmp.h>
  #include <signal.h>

  jmp_buf jb;
  char buffer@<:@200@:>@;
  
  RETSIGTYPE
  sig_handler(sig)
       int sig;
  {
    longjmp (jb, 1);
  }

  int
  alignment()
  {
    long vec@<:@(sizeof($1) + sizeof(long) * 2 - 1) / sizeof(long)@:>@;
    $1 *misaligned;
    long ptr;

    /* Find a position in vec so that doubleptr is misaligned. */
    ptr = (long) vec;			/* xxxxxxxxxxxxxyyy */
    ptr |= sizeof($1) - 1;		/* xxxxxxxxxxxxx111 */
    ptr ^= sizeof(long) - 1;		/* xxxxxxxxxxxxx100 */
    misaligned = ($1 *) ptr;

    /* The sprintf only fools the compiler, what's important is
     * that we dereference the misaligned pointer. */
    if (setjmp (jb) == 0)
      sprintf(buffer, "%d", *misaligned);
    else
      return sizeof ($1);

    return sizeof (long);
  }])
fi
])

AC_DEFINE_UNQUOTED(AS_TR_CPP($1_alignment), $AS_TR_SH([gst_cv_$1_alignment]),
                   [The alignment required for a value of type `$1'])

])dnl
