# GNU Solfege - ear training for GNOME
# Copyright (C) 2000, 2001, 2002, 2003, 2004  Tom Cato Amundsen
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

__exercise_data__ = {
    'exercise_name': 'polyrhythm',
    'menu_path': '%s/%s' % (_("_Junk"), _("_Polyrhythm")),
    #'icon': 'graphics/chord24.png',
    #'toolbar': 0,
    #'accel_key': gtk.keysyms.F2,
    #'accel_mods': 0,
}
import exercise_setup
exercise_setup.register_exercise(__exercise_data__)


import gtk, gnome
import gu, widgets
import soundcard, mpd
import abstract, const
import random, string

class Teacher(abstract.Teacher):
    exercise_data = __exercise_data__
    def __init__(self, exname, app, config):
        abstract.Teacher.__init__(self, exname, app, config)
        self.m_timeout = None
    def timeout_x_y(self, x, y, bpm):
        A = 60; B = 61
        t = soundcard.Track()
        for n in range(x):
            t.note(x, 9, A, 100)
        t2 = soundcard.Track()
        for n in range(y):
            t2.note(y, 9, B, 100)
        t.merge_with(t2)
        t.prepend_bpm(bpm)
        soundcard.synth.addplay_track(t)
        return 1
    def stop(self, _o):
        if self.m_timeout:
            gtk.timeout_remove(self.m_timeout)
            self.m_timeout = None
        soundcard.solfege_c_midi.sndctl_seq_reset()
    def play(self, x, y, bpm):
        if self.m_timeout:
            gtk.timeout_remove(self.m_timeout)
            self.m_timeout = None
        m = soundcard.Track()
        soundcard.synth.play_track(m)
        self.timeout_x_y(x, y, bpm)
        self.m_timeout = gtk.timeout_add(300, lambda self=self, x=x, y=y, bpm=bpm: self.more_xy(x, y, bpm))
        self.m_pos = 0
        self.m_count = 0
    def more_xy(self, x, y, bpm):
        i = soundcard.solfege_c_midi.sndctl_seq_gettime()
        if self.m_count * 96*4 < i:
            self.timeout_x_y(x, y, bpm)
            self.m_count = self.m_count + 1
        return 1

class Gui(abstract.Gui):
    def __init__(self, teacher, window):
        abstract.Gui.__init__(self, teacher, window, no_notebook=1)
        self.m_correct = [0, 0, 0]
        ################
        # practice_box #
        ################
        hbox = gu.bHBox(self.practise_box)
        adj = gtk.Adjustment(2, 1, 20, 1, 10)
        self.g_x = gtk.SpinButton(adj, digits=0)
        hbox.pack_start(self.g_x)
        adj = gtk.Adjustment(3, 1, 20, 1, 10)
        self.g_y = gtk.SpinButton(adj, digits=0)
        hbox.pack_start(self.g_y)
        adj = gtk.Adjustment(130, 40, 400, 1, 10)
        self.g_tempo = gtk.SpinButton(adj, digits=0)
        hbox.pack_start(self.g_tempo)
        gu.bButton(self.practise_box, _("Go"), self.go)
        gu.bButton(self.practise_box, _("Stop"), self.m_t.stop)
        self.practise_box.show_all()
    def go(self, _o):
        self.m_t.play(self.g_x.get_value_as_int(), self.g_y.get_value_as_int(),
                      self.g_tempo.get_value_as_int())
