#! /bin/sh
# -*- ksh -*-

# This program verifies that any inline function is static.
# This test is meant to avoid problems I had on IRIX.

: ${SRCDIR=.}

# Set up other vars
. $SRCDIR/defs || exit 1

# Get the guilty lines in *.c files
# Omit strfime, coz' its inline is safe
# Exclude the word inlined.
# Don't use grep -v 'static\|inlined\|lib/strftime.c' coz 
# some grep reject this (HP)
res=`fgrep 'inline' $top_srcdir/src/*.c $top_srcdir/lib/*.c | fgrep -v 'static' | fgrep -v 'inlined' | fgrep -v 'lib/strftime.c' | sed -e "s#$top_srcdir/##g;s#:.*##g" | sort -u`

if test -n "$res"; then
  echo "The following files use non static inline"
  echo "$res"
  exit 1
fi

# No inline is allowed in a header.
res=`fgrep 'inline' $top_srcdir/src/*.h $top_srcdir/lib/*.h | sed -e "s#$top_srcdir/##g;s#:.*##g" | sort -u`
if test -n "$res"; then
  echo "The following headers use inline"
  echo "$res"
  exit 1
fi

exit 0
