#ifndef __polkaIDL_hh__
#define __polkaIDL_hh__

#include <omniORB2/CORBA.h>

#include <polkaTypes.hh>
_CORBA_MODULE polka {
_CORBA_MODULE_PUBLIC

#ifndef __polka_loader__
#define __polka_loader__
  class   loader;
  typedef loader* loader_ptr;
  typedef loader_ptr loaderRef;

  class loader_Helper {
    public:
    static loader_ptr _nil();
    static CORBA::Boolean is_nil(loader_ptr p);
    static void release(loader_ptr p);
    static void duplicate(loader_ptr p);
    static size_t NP_alignedSize(loader_ptr obj,size_t initialoffset);
    static void marshalObjRef(loader_ptr obj,NetBufferedStream &s);
    static loader_ptr unmarshalObjRef(NetBufferedStream &s);
    static void marshalObjRef(loader_ptr obj,MemBufferedStream &s);
    static loader_ptr unmarshalObjRef(MemBufferedStream &s);
  };
  typedef _CORBA_ObjRef_Var<loader,loader_Helper> loader_var;

#endif
#define polka_loader_IntfRepoID "IDL:polka/loader:1.0"

  class loader : public virtual omniObject, public virtual CORBA::Object {
  public:

    virtual void dump (  ) = 0;
    virtual polkaStatus  enregistreServeur ( const char *  name ) = 0;
    virtual polkaStatus  enregistreClient ( const char *  name, CORBA::Long & numSerie ) = 0;
    virtual polkaStatus  supprimeServeur ( const char *  name ) = 0;
    virtual polkaStatus  supprimeClient ( const char *  name, CORBA::Long  numSerie ) = 0;
    virtual void terminaisonClient (  ) = 0;
    static loader_ptr _duplicate(loader_ptr);
    static loader_ptr _narrow(CORBA::Object_ptr);
    static loader_ptr _nil();

    static inline size_t NP_alignedSize(loader_ptr obj,size_t initialoffset) {
      return CORBA::AlignedObjRef(obj,polka_loader_IntfRepoID,21,initialoffset);
    }

    static inline void marshalObjRef(loader_ptr obj,NetBufferedStream &s) {
      CORBA::MarshalObjRef(obj,polka_loader_IntfRepoID,21,s);
    }

    static inline loader_ptr unmarshalObjRef(NetBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(polka_loader_IntfRepoID,s);
      loader_ptr _result = polka::loader::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static inline void marshalObjRef(loader_ptr obj,MemBufferedStream &s) {
      CORBA::MarshalObjRef(obj,polka_loader_IntfRepoID,21,s);
    }

    static inline loader_ptr unmarshalObjRef(MemBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(polka_loader_IntfRepoID,s);
      loader_ptr _result = polka::loader::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static CORBA::Boolean _is_a(const char *base_repoId);

  protected:

    loader() {
      if (!is_proxy())
        omniObject::PR_IRRepositoryId(polka_loader_IntfRepoID);
      this->PR_setobj(this);
    }
    virtual ~loader() {}
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId);

  private:

    loader(const loader&);
    loader &operator=(const loader&);
  };

  class _sk_loader :  public virtual loader {
  public:

    _sk_loader() {}
    _sk_loader(const omniORB::objectKey& k);
    virtual ~_sk_loader() {}
    loader_ptr _this() { return loader::_duplicate(this); }
    void _obj_is_ready(CORBA::BOA_ptr boa) { boa->obj_is_ready(this); }
    CORBA::BOA_ptr _boa() { return CORBA::BOA::getBOA(); }
    void _dispose() { _boa()->dispose(this); }
    omniORB::objectKey _key();
    virtual void dump (  ) = 0;
    virtual polkaStatus  enregistreServeur ( const char *  name ) = 0;
    virtual polkaStatus  enregistreClient ( const char *  name, CORBA::Long & numSerie ) = 0;
    virtual polkaStatus  supprimeServeur ( const char *  name ) = 0;
    virtual polkaStatus  supprimeClient ( const char *  name, CORBA::Long  numSerie ) = 0;
    virtual void terminaisonClient (  ) = 0;
    virtual CORBA::Boolean dispatch(GIOP_S &s,const char *op,CORBA::Boolean response);

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId) {
      return loader::_widenFromTheMostDerivedIntf(repoId);
    }
  private:
    _sk_loader (const _sk_loader&);
    _sk_loader &operator=(const _sk_loader&);
  };

  class _proxy_loader :  public virtual loader {
  public:

    _proxy_loader (Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release) :
      omniObject(polka_loader_IntfRepoID,r,key,keysize,profiles,release) {
        omni::objectIsReady(this);
    }
    virtual ~_proxy_loader() {}
    virtual void dump (  );
    virtual polkaStatus  enregistreServeur ( const char *  name );
    virtual polkaStatus  enregistreClient ( const char *  name, CORBA::Long & numSerie );
    virtual polkaStatus  supprimeServeur ( const char *  name );
    virtual polkaStatus  supprimeClient ( const char *  name, CORBA::Long  numSerie );
    virtual void terminaisonClient (  );

  protected:

    _proxy_loader () {}

    virtual void *_widenFromTheMostDerivedIntf(const char *repoId) {
      return loader::_widenFromTheMostDerivedIntf(repoId);
    }
  private:

    _proxy_loader (const _proxy_loader&);
    _proxy_loader &operator=(const _proxy_loader&);
  };

  class _nil_loader :   public virtual loader {
  public:
    _nil_loader() { this->PR_setobj(0); }
    virtual ~_nil_loader() {}
    void dump (  ){
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
      // never reach here! Dummy return to keep some compilers happy.
      return;
    }

    polkaStatus  enregistreServeur ( const char *  name ){
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
      // never reach here! Dummy return to keep some compilers happy.
      polkaStatus _result = 0;
      return _result;
    }

    polkaStatus  enregistreClient ( const char *  name, CORBA::Long & numSerie ){
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
      // never reach here! Dummy return to keep some compilers happy.
      polkaStatus _result = 0;
      return _result;
    }

    polkaStatus  supprimeServeur ( const char *  name ){
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
      // never reach here! Dummy return to keep some compilers happy.
      polkaStatus _result = 0;
      return _result;
    }

    polkaStatus  supprimeClient ( const char *  name, CORBA::Long  numSerie ){
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
      // never reach here! Dummy return to keep some compilers happy.
      polkaStatus _result = 0;
      return _result;
    }

    void terminaisonClient (  ){
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
      // never reach here! Dummy return to keep some compilers happy.
      return;
    }

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId) {
      return loader::_widenFromTheMostDerivedIntf(repoId);
    }
  };

  class loader_proxyObjectFactory : public proxyObjectFactory {
  public:
    loader_proxyObjectFactory () {}
    virtual ~loader_proxyObjectFactory () {}
    virtual const char *irRepoId() const;
    virtual CORBA::Object_ptr newProxyObject(Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release);
    virtual CORBA::Boolean is_a(const char *base_repoId) const;
    static polka::loader_ptr _nil() {
      if (!__nil_loader) {
        __nil_loader = new polka::_nil_loader;
      }
      return __nil_loader;
    }
  private:
    static polka::loader_ptr __nil_loader;
  };

#ifndef __polka_scheduler__
#define __polka_scheduler__
  class   scheduler;
  typedef scheduler* scheduler_ptr;
  typedef scheduler_ptr schedulerRef;

  class scheduler_Helper {
    public:
    static scheduler_ptr _nil();
    static CORBA::Boolean is_nil(scheduler_ptr p);
    static void release(scheduler_ptr p);
    static void duplicate(scheduler_ptr p);
    static size_t NP_alignedSize(scheduler_ptr obj,size_t initialoffset);
    static void marshalObjRef(scheduler_ptr obj,NetBufferedStream &s);
    static scheduler_ptr unmarshalObjRef(NetBufferedStream &s);
    static void marshalObjRef(scheduler_ptr obj,MemBufferedStream &s);
    static scheduler_ptr unmarshalObjRef(MemBufferedStream &s);
  };
  typedef _CORBA_ObjRef_Var<scheduler,scheduler_Helper> scheduler_var;

#endif
#define polka_scheduler_IntfRepoID "IDL:polka/scheduler:1.0"

  class scheduler : public virtual omniObject, public virtual CORBA::Object {
  public:

    virtual void dump (  ) = 0;
    virtual polkaStatus  setPolkaFile ( const char *  qosFile, const char *  varFile, const char *  astFile ) = 0;
    virtual void reOrdonnance ( const char *  node ) = 0;
    static scheduler_ptr _duplicate(scheduler_ptr);
    static scheduler_ptr _narrow(CORBA::Object_ptr);
    static scheduler_ptr _nil();

    static inline size_t NP_alignedSize(scheduler_ptr obj,size_t initialoffset) {
      return CORBA::AlignedObjRef(obj,polka_scheduler_IntfRepoID,24,initialoffset);
    }

    static inline void marshalObjRef(scheduler_ptr obj,NetBufferedStream &s) {
      CORBA::MarshalObjRef(obj,polka_scheduler_IntfRepoID,24,s);
    }

    static inline scheduler_ptr unmarshalObjRef(NetBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(polka_scheduler_IntfRepoID,s);
      scheduler_ptr _result = polka::scheduler::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static inline void marshalObjRef(scheduler_ptr obj,MemBufferedStream &s) {
      CORBA::MarshalObjRef(obj,polka_scheduler_IntfRepoID,24,s);
    }

    static inline scheduler_ptr unmarshalObjRef(MemBufferedStream &s) {
      CORBA::Object_ptr _obj = CORBA::UnMarshalObjRef(polka_scheduler_IntfRepoID,s);
      scheduler_ptr _result = polka::scheduler::_narrow(_obj);
      CORBA::release(_obj);
      return _result;
    }

    static CORBA::Boolean _is_a(const char *base_repoId);

  protected:

    scheduler() {
      if (!is_proxy())
        omniObject::PR_IRRepositoryId(polka_scheduler_IntfRepoID);
      this->PR_setobj(this);
    }
    virtual ~scheduler() {}
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId);

  private:

    scheduler(const scheduler&);
    scheduler &operator=(const scheduler&);
  };

  class _sk_scheduler :  public virtual scheduler {
  public:

    _sk_scheduler() {}
    _sk_scheduler(const omniORB::objectKey& k);
    virtual ~_sk_scheduler() {}
    scheduler_ptr _this() { return scheduler::_duplicate(this); }
    void _obj_is_ready(CORBA::BOA_ptr boa) { boa->obj_is_ready(this); }
    CORBA::BOA_ptr _boa() { return CORBA::BOA::getBOA(); }
    void _dispose() { _boa()->dispose(this); }
    omniORB::objectKey _key();
    virtual void dump (  ) = 0;
    virtual polkaStatus  setPolkaFile ( const char *  qosFile, const char *  varFile, const char *  astFile ) = 0;
    virtual void reOrdonnance ( const char *  node ) = 0;
    virtual CORBA::Boolean dispatch(GIOP_S &s,const char *op,CORBA::Boolean response);

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId) {
      return scheduler::_widenFromTheMostDerivedIntf(repoId);
    }
  private:
    _sk_scheduler (const _sk_scheduler&);
    _sk_scheduler &operator=(const _sk_scheduler&);
  };

  class _proxy_scheduler :  public virtual scheduler {
  public:

    _proxy_scheduler (Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release) :
      omniObject(polka_scheduler_IntfRepoID,r,key,keysize,profiles,release) {
        omni::objectIsReady(this);
    }
    virtual ~_proxy_scheduler() {}
    virtual void dump (  );
    virtual polkaStatus  setPolkaFile ( const char *  qosFile, const char *  varFile, const char *  astFile );
    virtual void reOrdonnance ( const char *  node );

  protected:

    _proxy_scheduler () {}

    virtual void *_widenFromTheMostDerivedIntf(const char *repoId) {
      return scheduler::_widenFromTheMostDerivedIntf(repoId);
    }
  private:

    _proxy_scheduler (const _proxy_scheduler&);
    _proxy_scheduler &operator=(const _proxy_scheduler&);
  };

  class _nil_scheduler :   public virtual scheduler {
  public:
    _nil_scheduler() { this->PR_setobj(0); }
    virtual ~_nil_scheduler() {}
    void dump (  ){
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
      // never reach here! Dummy return to keep some compilers happy.
      return;
    }

    polkaStatus  setPolkaFile ( const char *  qosFile, const char *  varFile, const char *  astFile ){
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
      // never reach here! Dummy return to keep some compilers happy.
      polkaStatus _result = 0;
      return _result;
    }

    void reOrdonnance ( const char *  node ){
      throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
      // never reach here! Dummy return to keep some compilers happy.
      return;
    }

  protected:
    virtual void *_widenFromTheMostDerivedIntf(const char *repoId) {
      return scheduler::_widenFromTheMostDerivedIntf(repoId);
    }
  };

  class scheduler_proxyObjectFactory : public proxyObjectFactory {
  public:
    scheduler_proxyObjectFactory () {}
    virtual ~scheduler_proxyObjectFactory () {}
    virtual const char *irRepoId() const;
    virtual CORBA::Object_ptr newProxyObject(Rope *r,CORBA::Octet *key,size_t keysize,IOP::TaggedProfileList *profiles,CORBA::Boolean release);
    virtual CORBA::Boolean is_a(const char *base_repoId) const;
    static polka::scheduler_ptr _nil() {
      if (!__nil_scheduler) {
        __nil_scheduler = new polka::_nil_scheduler;
      }
      return __nil_scheduler;
    }
  private:
    static polka::scheduler_ptr __nil_scheduler;
  };

};

#endif // __polkaIDL_hh__
