/* constants.h -- This file is part of Archimedes release 0.0.1.
   Archimedes is a simulator for Submicron 2D Silicon
   Devices. It implements both the Monte Carlo method
   for the simulation of the semiclassical Boltzmann equation for both
   electrons and holes. It also includes the quantum effects by means 
   of effective potential method.

   Copyright (C) 2004 Jean Michel Sellier <sellier@dmi.unict.it>
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
   USA.  */


// ######################################################
// Created on 5 aug.2004, Siracusa, J.M.Sellier
// Last modif. : 07 oct.2004, Siracusa, J.M.Sellier
// ######################################################

// Universal Physical Constants in M.K.S.C. system

// ######################################################
// ######################################################

// Boltzmann constant (Joule/Kelvin)
 const real KB=1.380658e-23;
 // Electron charge in absolute value (Coulomb)
 const real Q=1.60217733e-19;
// Reduced Planck constant (Joule*sec)
 const real HBAR=1.05457266e-34;
// Permittivity of free space (F/m)
 const real EPS0=8.854187817e-12;
// Relative Permittivity of Silicon Carbide 6H
 const real EPSR=11.7;
// Electron Mass (Kg)
 const real M=9.1093897e-31;
// Silicon intrinsic density for room temperature
 const real NI=1.45e16;
// Pi number
 const real PI=3.141592654;
// Silicon Crystal Density (Kg/m^3)
 const real SiRHO=2330.;
// Silicon longitudinal sound velocity (m/sec)
 const real UL=9040.;
// Siliconacustic deformation potential(Joule)
 const real SiDA=9.*1.60217733e-19;
// electron energy step (eV) for the MC method
 const real DE=0.002;
// mstar coefficient for Silicon
 const real mstarSILICON=0.32;
// mstar coefficient for Si heavy hole
 const real mstarHSILICON=0.57;
// non-parabolicity coefficient for Silicon
 const real alphaSILICON=0.5;
// Constants for the 6 Silicon non-polar optical phonons 
// (inelastic scattering) 
// Silicon optical coupling constants (eV/m)
 double SiDTK[6]={0.05e11,0.08e11,0.03e11,0.20e11,1.14e11,0.20e11};
// Silicon optical phonon scattering energy (eV)
 double SiHWO[6]={0.0120,0.0185,0.0190,0.0474,0.0612,0.0590};
// Silicon optical phonon Z-factor
 double ZF[6]={1.,1.,4.,4.,1.,4.};
      
// ######################################################
// ######################################################
