#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include "vec.h"
#include "process.h"
#include "interop-isar.h"
#include "list.h"
#include "proof.h"
#include "sen-data.h"

// Defined sequences.
vec_t * seqs;

// List of null keys.
static const char * null_keys[] = {
  "text",
  "text_raw",
  "subsection",
  "subsubsection",
  NULL
};

/* Main Idea:
 *  Parse the definitions from the .thy file,
 *  then parse the lemmas and theorems.
 *  Create a vector of references from the definitions,
 *  the for each proof, create a proof_t with
 *  the def. refs., and the lemmas as conclusions.
 *  Use (R0 & R1 & R2 & ... & RN) $ Conc for each lemma.
 */

/*TODO:
 *  Most of these functions don't do anything yet, but stand as place holders.
 *  Still need to parse notation, such as 'infix'.
 *  Still need:
 *    class
 *    theorem
 *    instance
 *    instantiation
 */

//Might need to input function descriptions, such as input.
char *
isar_correct_gens (char * in_str)
{

  int gg;
  unsigned char conn[CL + 1];
  vec_t * gens;

  conn[0] = '\0';
  gg = get_generalities (in_str, conn, gens);
  if (gg == -3)
    return NULL;

  if (gg == -2)
    {
      // The only time -2 is returned when a conn isn't specified
      // is when the connectives don't match up.

      // Check the connectives, and group them as necessary.
      // The priority in Isar is as follows:
      // ~, &, |, $, %

      // These all associate to the right (except, of course, ~).

      // get_generalities destroys the vector,
      // so a modified version might be necessary.

      // Parse the top level for each connective in order of priority.
    }

  return NULL;
}

int
isar_parse_null (char * in_str)
{
  // Find '{' character, then find matching '}'.
  // Return offset.
  // Should be able to use modified 'parse_parens'.

  printf ("Got null\n");

  int pos = 0;

  while (strncmp (in_str + pos, "*}", 2))
    pos++;

  return pos;
}

char *
isar_mod_fun (char * in_str, char * fun_name)
{
  // Determine the input from in_str.
  // If from the nats, use 'v(n,x)'...
  // If suc (x) => v(n,s(x))
  // If 1 => v(n,s(z(x)))
  // Will need to know type sequences.

  // Suc 0 => suc (0) / v(n,s(x))
  

  // Summation starts as (\<Sum>i::nat=0..n. i) (Taken from Summation.thy)
  // 

  return NULL;
}

int
isar_parse_syn (char * syn, char ** out_str)
{
  // type_synonym

  char * left, * right;

  // Determine the sequence both are defined by,
  // and return (maybe):
  // @x(v(L,x) = v(R,x))

  printf ("Got synonym\n");

  return 0;
}

// Remember kids: Logic is FUN!!
int
isar_parse_fun (char * fun, char ** out_str)
{
  printf ("Got fun\n");

  char * fun_name;
  int init_pos, pos;
  int chk;

  init_pos = 4;
  while (isspace(fun[init_pos]))
    init_pos++;

  pos = init_pos;
  while (fun[pos] != ':')
    pos++;

  pos -= 1;

  fun_name = (char *) calloc (pos - init_pos + 1, sizeof (char));
  if (!fun_name)
    {
      perror (NULL);
      return -1;
    }

  strncpy (fun_name, fun + init_pos, pos - init_pos);
  fun_name[pos - init_pos] = '\0';

  // Next should come "::"
  // pos points to two characters before it.
  // Determine what this function is mapping.

  char * map_str;

  init_pos = pos + 5;

  if (fun[init_pos] == '\"')
    init_pos++;

  pos = init_pos;

  while (fun[pos] != '\"')
    pos++;

  map_str = (char *) calloc (pos - init_pos + 1, sizeof (char));
  if (!map_str)
    {
      perror (NULL);
      return -1;
    }

  strncpy (map_str, fun + init_pos, pos - init_pos);
  map_str[pos - init_pos] = '\0';

  //TODO: Use map_str to determine what is being mapped.

  // Next, find the word 'where'

  init_pos = pos + 1;
  while (strncmp (fun + init_pos, "where", 5))
    init_pos++;

  // Now, find the next '"'

  while (fun[init_pos] != '\"')
    init_pos++;

  init_pos++;

  vec_t * base_cases;
  unsigned char * tmp_str;

  base_cases = init_vec (sizeof (char *));
  if (!base_cases)
    return -1;

  pos = init_pos;

  while (fun[pos] != '\"')
    pos++;

  tmp_str = (char *) calloc (pos - init_pos + 1, sizeof (char));
  if (!tmp_str)
    {
      perror (NULL);
      return -1;
    }

  strncpy (tmp_str, fun + init_pos, pos - init_pos);
  tmp_str[pos - init_pos] = '\0';

  while (fun[pos + 2] == '|')
    {
      char * mod_str;
      /*
      mod_str = isar_mod_fun (tmp_str, fun_name);
      if (!mod_str)
	return -1;
      */

      mod_str = tmp_str;

      chk = vec_str_add_obj (base_cases, mod_str);
      if (chk < 0)
	return -1;
      free (tmp_str);
      //free (mod_str);

      pos += 2;
      init_pos = pos;

      while (fun[init_pos] != '\"')
	init_pos++;

      init_pos++;
      pos = init_pos;

      while (fun[pos] != '\"')
	pos++;

      tmp_str = (char *) calloc (pos - init_pos + 1, sizeof (char));
      if (!tmp_str)
	{
	  perror (NULL);
	  return -1;
	}

      strncpy (tmp_str, fun + init_pos, pos - init_pos);
      tmp_str[pos - init_pos] = '\0';

      init_pos = pos + 2;
    }

  // Now, base_cases will hold the base cases, and tmp_str will hold the recursive step.

  int fin_pos = pos;

  char * mod_tmp_str;
  /*
  mod_tmp_str = isar_mod_fun (tmp_str, fun_name);
  if (!mod_tmp_str)
    return -1;
  */
  mod_tmp_str = tmp_str;

  // Use seqlog to construct what is needed.


  // Example:
  // From fibonacci.thy => 'fib' should look like this in the end:
  //@y(@z(v(y,z) = fib(v(n,z))) $ @z(v(y,z(z)) = 0 & v(y,s(z(z))) = v(n,s(z(z))) & v(y,s(s(z))) = v(y,z) + v(y,s(z))))

  //CURRENTLY: Only accounts for if inputs are natural numbers.

  int num_inputs = 0;
  char ** inputs;
  // Parse map_str for '\<Rightarrow>' to determine the amount of inputs.

  for (pos = 0; map_str[pos] != '\0'; pos++)
    {
      if (!strncmp (map_str + pos, "\\<Rightarrow>", 13))
	{
	  num_inputs++;
	  pos += 12;
	}
    }

  inputs = (char **) calloc (num_inputs, sizeof (char *));
  if (!inputs)
    {
      perror (NULL);
      return -1;
    }

  int i,j;

  i = 0;
  pos = 0;
  while (1)
    {
      char * type;
      init_pos = pos;
      while (strncmp (map_str + pos, "\\<Rightarrow>", 13) && map_str[pos] != '\0')
	pos++;

      int alloc_size = pos - init_pos - 1;
      if (map_str[pos] == '\0')
	alloc_size++;

      type = (char *) calloc (alloc_size + 1, sizeof (char));
      if (!type)
	{
	  perror (NULL);
	  return -1;
	}
      strncpy (type, map_str + init_pos, alloc_size);
      type[alloc_size] = '\0';

      for (j = 0; j < seqs->num_stuff; j++)
	{
	  in_type * cur;
	  cur = vec_nth (seqs, j);
	  if (!strcmp (type, cur->type))
	    {
	      inputs[i] = cur->seq;
	      break;
	    }
	}

      if (j == seqs->num_stuff)
	{
	  // New sequence.
	  // Not sure how to handle this exactly (yet).
	}

      if (map_str[pos] == '\0')
	break;
      else
	pos += 14;
    }

  int fun_pos;

  //TODO: Calculate the ACTUAL size this should be.

  *out_str = (char *) calloc (1024, sizeof (char));
  if (!(*out_str))
    {
      perror (NULL);
      return -1;
    }

  for (i = 0; i < num_inputs - 1; i++)
    fun_pos += sprintf ((*out_str) + fun_pos, "%sx%i(", UNV, i);

  fun_pos += sprintf ((*out_str) + fun_pos, "%sy(%sz(v(y,z) = %s(",
		      UNV, UNV, fun_name);

  // TODO: Determine how the inputs are ordered, maybe.

  for (i = 0; i < num_inputs - 1; i++)
    fun_pos += sprintf ((*out_str) + fun_pos, "v(%s,x%i),", inputs[i], i);

  fun_pos += sprintf ((*out_str) + fun_pos, "v(%s,z)))", inputs[i]);
  fun_pos += sprintf ((*out_str) + fun_pos, "%s", CON);
  fun_pos += sprintf ((*out_str) + fun_pos, "%sz(", UNV);

  for (i = 0; i < base_cases->num_stuff; i++)
    {
      fun_pos += sprintf ((*out_str) + fun_pos, "%s%s",
			  vec_str_nth (base_cases, i), AND);
    }

  fun_pos += sprintf ((*out_str) + fun_pos, "%s))", mod_tmp_str);

  for (i = 0; i < num_inputs - 1; i++)
    fun_pos += sprintf ((*out_str) + fun_pos, ")");

  printf ("fun_str = '%s'\n", *out_str);

  free (tmp_str);
  //free (mod_tmp_str);

  return fin_pos;
}

int
isar_parse_lemma (char * lemma, char ** out_str)
{
  printf ("Got lemma\n");

  // Find the next instance of proof.
  //char * proof;
  //proof = strstr (lemma, "proof");

  int pos = 5;
  while (isspace (lemma[pos]))
    pos++;

  int init_pos;
  if (lemma[pos] != '\"')
    {
      if (!strncmp (lemma + pos, "proof", 5))
	{
	  pos += 5;
	  while (isspace (lemma[pos]))
	    pos++;
	}

      if (!strncmp (lemma + pos, "assume", 6))
	{
	  pos += 6;
	  if (lemma[pos] == 's')
	    {
	      // Move to assumption.
	    }

	  // Move to show statement.
	  // Exit.
	}

      while (!isspace (lemma[pos]))
	pos++;

      while (isspace (lemma[pos]))
	pos++;
    }

  char * tmp_str;

  init_pos = pos + 1;
  pos = init_pos;

  while (lemma[pos] != '\"')
    pos++;

  tmp_str = (char *) calloc (pos - init_pos + 1, sizeof (char));
  if (!tmp_str)
    {
      perror (NULL);
      return -1;
    }

  strncpy (tmp_str, lemma + init_pos, pos - init_pos);
  tmp_str[pos - init_pos] = '\0';

  /*
  printf ("lemma = '%s'\n", tmp_str);
  *out_str = (char *) calloc (pos - init_pos + 1, sizeof (char));
  if (!(*out_str))
    {
      perror (NULL);
      return -1;
    }
  strcpy (*out_str, tmp_str);
  */

  *out_str = isar_to_aris (tmp_str);
  if (!(*out_str))
    return -1;
  printf ("lemma = '%s'\n", *out_str);
  free (tmp_str);

  // Find any instances of 'assume' and 'show'
  // May not be necessary.
  // Most instances of 'lemma' come with the sentence needed.
  // Might be able to grab everything from the starting line.

  /*
  char ** assume;
  char * show;

  assume = (char **) calloc (1024, sizeof (char *));
  if (!assume)
    {
      perror (NULL);
      return -1;
    }

  char * find_tmp, * show_pos;
  int i, pos;
  i = pos = 0;

  find_tmp = strstr (proof, "assume");
  show_pos = strstr (proof, "show");

  while (find_tmp < show_pos)
    {
      // Find the next newline or the next instance of the word 'and'.
      // Copy from find_tmp to the newline into assume[i]
      pos = 0;

      while (find_tmp[pos] != '\n' && strncmp (find_tmp + pos, "and", 3))
	pos++;

      int init_pos = 0;
      if (!strncmp (find_tmp, "assume", 6))
	init_pos = 6;
      if (!strncmp (find_tmp, "and", 3))
	init_pos = 3;

      assume[i] = (char *) calloc (pos - init_pos, sizeof (char));
      if (!assume[i])
	{
	  perror (NULL);
	  return -1;
	}

      strncpy (assume[i], find_tmp + init_pos, pos - init_pos);
      assume[i][pos - init_pos] = '\0';

      if (find_tmp[pos] == '\n')
	find_tmp = strstr (find_tmp + pos, "assume");
      else
	find_tmp += pos;

      i++;
    }

  pos = 0;
  // Also might want to check for '..' at the end of the show statement.
  while (show_pos[pos] != '\n' && strncmp (show_pos + pos, "by", 2))
    pos++;

  show = (char *) calloc (pos, sizeof (char *));
  if (!show)
    {
      perror (NULL);
      return -1;
    }

  strncpy (show, show_pos + 4, pos - 4);
  show[pos - 4] = '\0';

  // For each instance of assume, load a premise.

  unsigned char ** prems, * conc;

  prems = (unsigned char **) calloc (i + 1, sizeof (char *));
  if (!prems)
    {
      perror (NULL);
      return -1;
    }

  //printf ("Proof: %i\n", count);
  for (i = 0; assume[i]; i++)
    {
      //OMG isar is an anagram of aris.
      //SO COOL!!
      printf ("assume[%i]: %s\n", i, assume[i]);
      prems[i] = isar_to_aris (assume[i]);
      if (!prems[i])
	return -1;
      printf ("prems[%i]: %s\n", i, prems[i]);
    }
  prems[i] = NULL;

  printf ("show: %s\n", show);
  conc = isar_to_aris (show);
  if (!conc)
    return -1;

  printf ("conc: %s\n", conc);

  int out_pos = 0;

  if (prems[1])
    out_pos += sprintf (*out_str + out_pos, "(");

  for (i = 0; prems[i]; i++)
    {
      out_pos += sprintf (*out_str + out_pos, "%s", prems[i]);
      if (prems[i + 1])
	out_pos += sprintf (*out_str + out_pos, "%s", AND);
    }

  if (prems[1])
    out_pos += sprintf (*out_str + out_pos, ")");

  */

  // In order to determine the end of the lemma,
  // find 'qed' or 'done',
  // although that might not work.

  return pos;
}

int
isar_parse_theorem (char * thm, char ** out_str)
{
  int pos;

  pos = isar_parse_lemma (thm + 2, out_str);
  if (pos == -1)
    return -1;

  return pos + 2;
}

int
isar_parse_datatype (char * type, vec_t * constructors)
{
  int init_pos, pos;
  int i, chk;

  init_pos = 0;

  // Determine the type name.
  // Determine the constructors.

  //IDEA: For each constructor with n args, create the string:
  // @x0@x1...@xn(#y0(y0 = v(tk, x0)) & ... & #yn(yn = v(tk, xn)) $ #z(z = constructor(x0,...,xn)))

  return pos;
}

int
isar_parse_primrec (char * prim, char ** out_str)
{
  //Should be similar to isar_parse_fun
  int ret;
  ret = isar_parse_fun (prim + 4, out_str);
  if (ret == -1)
    return -1;

  return ret + 4;
}

int
isar_parse_case (char * cs, char ** out_str)
{
  vec_t * pre, * post;
  int i, pos, init_pos;
  char * var;
  int out_pos;

  // get var

  init_pos = pos = 5;

  while (!isspace (cs[pos]))
    pos++;

  var = (char *) calloc (pos - init_pos + 1, sizeof (char));
  if (!var)
    {
      perror (NULL);
      return -1;
    }

  strncpy (var, cs + init_pos, pos - init_pos);
  var[pos - init_pos] = '\0';

  pos = init_pos + 4;

  // case 'var' of arg0 | arg1 | ... | argn

  // parse the arguments.
  // get the pred variable

  while (1)
    {
      char * tmp_str;

      init_pos = pos;

      while (cs[pos] != '|')
	pos++;

      tmp_str = (char *) calloc (pos - init_pos + 1, sizeof (char));
      if (!tmp_str)
	{
	  perror (NULL);
	  return -1;
	}

      strncpy (tmp_str, cs + init_pos, pos - init_pos);
      tmp_str[pos - init_pos] = '\0';

      // Process it, converting it to a notation aris will recognize.
      char * new_str;
      //new_str = isar_convert (tmp_str);
      //if (!new_str)
      //  return -1;

      free (tmp_str);

      int gg;
      unsigned char * lsen, * rsen;

      gg = get_gen (new_str, 0, &lsen);
      if (gg == -1)
	return -1;

      strcpy (rsen, new_str + gg + CL);

      free (new_str);

      gg = vec_str_add_obj (pre, lsen);
      if (gg < 0)
	return -1;

      gg = vec_str_add_obj (post, rsen);
      if (gg < 0)
	return -1;

      free (lsen);
      free (rsen);

      break;
    }

  int fin_pos = pos;

  // Get the last argument.

  // case(xs) = y % ((xs = pre0 $ y = post0) & ...)

  for (i = 0; i < pre->num_stuff; i++)
    {
    }

  return fin_pos;
}

int
isar_parse_def (char * def, char ** out_str)
{
  // Definition keyword.
  // Not particularly certain what to do with this yet,
  // since I'm not sure how definitions are used in Isabelle.

  //definition def where "stuff = more"
  // Logical eq (three horizontal lines) MUST be used in this.

  // Basic parsing.

  int pos, init_pos;
  char * defn;

  init_pos = 10;

  while (isspace(def[init_pos]))
    init_pos++;

  pos = init_pos;
  while (strncmp (def + pos, "where", 5))
    pos++;

  defn = (char *) calloc (pos - init_pos + 1, sizeof (char));
  if (!defn)
    {
      perror (NULL);
      return -1;
    }

  strncpy (defn, def + init_pos, pos - init_pos);
  defn[pos - init_pos] = '\0';

  // Need to check for '::',
  // and possibly determine the sequences (again).

  init_pos += 6;
  if (def[init_pos] == '\"')
    init_pos++;
  pos = init_pos;

  while (def[pos] != '\"')
    pos++;

  char * defin;
  int fin_pos = pos;

  defin = (char *) calloc (pos - init_pos + 1, sizeof (char));
  if (!defin)
    {
      perror (NULL);
      return -1;
    }
  strncpy (defin, def + init_pos, pos - init_pos);
  defin[pos - init_pos] = '\0';

  // Parse the definition for the logical eq symbol.

  free (defn);
  free (defin);

  return fin_pos;
}

unsigned char *
correct_conditionals (unsigned char * in_str)
{
  unsigned char * out_str;
  int in_len;
  unsigned char * alt_in_str;

  alt_in_str = die_spaces_die (in_str);
  if (!alt_in_str)
    return NULL;

  in_len = strlen (alt_in_str);
  out_str = (unsigned char *) calloc (in_len * 3, sizeof (char));
  if (!out_str)
    {
      perror (NULL);
      return NULL;
    }

  int gg;
  vec_t * gg_vec;

  gg_vec = init_vec (sizeof (char));
  if (!gg_vec)
    return NULL;

  gg = get_generalities (alt_in_str, U_CON, gg_vec);
  if (gg == -3)
    return NULL;

  /*
  if (gg > 0)
    destroy_str_vec (gg_vec);
  */

  int out_pos = 0;

  if (gg > 2)
    {
      int conn_pos;
      unsigned char * tmp_str;
      unsigned int tmp_pos;
      tmp_pos = 0;

      conn_pos = get_gen (alt_in_str, tmp_pos, &tmp_str);
      if (conn_pos == -1)
	return NULL;

      out_pos += sprintf (out_str + out_pos, "%s%s(", tmp_str, CON);
      free (tmp_str);

      unsigned char * oth_str;
      oth_str = correct_conditionals (alt_in_str + conn_pos + CL);
      if (!oth_str)
	return NULL;

      out_pos += sprintf (out_str + out_pos, "%s)", oth_str);
      free (oth_str);

      out_str[out_pos] = '\0';
    }
  else
    {
      strcpy (out_str, alt_in_str);
    }

  return out_str;
}

unsigned char *
isar_to_aris (char * isar)
{
  unsigned char * aris;
  int i, j, is_len;

  is_len = strlen (isar);
  aris = (unsigned char *) calloc (is_len, sizeof (char *));
  if (!aris)
    {
      perror (NULL);
      return NULL;
    }

  for (i = 0, j = 0; i < is_len; i++)
    {
      if (isar[i] == '\"')
	continue;

      if (!strncmp (isar + i, "-->", 3) || !strncmp (isar + i, "==>", 3))
	{
	  strcpy (aris + j, CON);
	  j += CL;
	  i += 2;
	  continue;
	}

      if(!strncmp (isar + i, "\\<longrightarrow>", 17))
	{
	  strcpy (aris + j, CON);
	  j += CL;
	  i += 16;
	  continue;
	}

      if (isar[i] == '&')
	{
	  strcpy (aris + j, AND);
	  j += CL;
	  continue;
	}

      if (isar[i] == '|')
	{
	  strcpy (aris + j, OR);
	  j += CL;
	  continue;
	}

      //TODO: For quantifiers;
      //1.  Check for a parenthesis BEFORE the quantifier.
      //2.  If there is one, remove it from the aris string,
      //3.  and make a note of this somehow,
      //      so the processor knows how to handle it later.

      if (!strncmp (isar + i, "EX", 2))
	{
	  // Copy in an existential.
	  // EX x. ...
	  if (j != 0 && aris[j - 1] == '(')
	    j--;

	  strcpy (aris + j, EXL);
	  j += CL;

	  if (islower(isar[i + 3]))
	    {
	      aris[j] = isar[i + 3];
	      aris[j + 1] = '(';
	      i += 3;
	      j += 2;
	    }
	  i+= 1;
	  continue;
	}

      if (!strncmp (isar + i, "\\<exists>", 9))
	{
	  if (j != 0 && aris[j - 1] == '(')
	    j--;

	  strcpy (aris + j, EXL);
	  j += CL;

	  if (islower(isar[i + 10]))
	    {
	      aris[j] = isar[i + 10];
	      aris[j + 1] = '(';
	      i += 3;
	      j += 2;
	    }
	  i+= 8;
	  continue;
	}

      if (!strncmp (isar + i, "ALL", 3))
	{
	  if (j != 0 && aris[j - 1] == '(')
	    j--;

	  strcpy (aris + j, UNV);
	  j += CL;

	  if (islower(isar[i + 4]))
	    {
	      aris[j] = isar[i + 4];
	      aris[j + 1] = '(';
	      i += 3;
	      j += 2;
	    }
	  i += 2;
	  continue;
	}

      if (!strncmp (isar + i, "\\<forall>", 9))
	{
	  if (j != 0 && aris[j - 1] == '(')
	    j--;

	  strcpy (aris + j, UNV);
	  j += CL;

	  if (islower(isar[i + 10]))
	    {
	      aris[j] = isar[i + 10];
	      aris[j + 1] = '(';
	      i += 3;
	      j += 2;
	    }

	  i += 8;
	  continue;
	}

      if (!strncmp (isar + i, "<->", 3))
	{
	  strcpy (aris + j, BIC);
	  j += CL;
	  i += 2;
	  continue;
	}

      if (!strncmp (isar + i, "\\<longleftrightarrow>", 21))
	{
	  strcpy (aris + j, BIC);
	  j += CL;
	  i += 20;
	  continue;
	}

      if (!strncmp (isar + i, "\\<not>", 6))
	{
	  strcpy (aris + j, NOT);
	  j += NL;
	  i += 5;
	  continue;
	}

      if (isar[i] == '~')
	{
	  strcpy (aris + j, NOT);
	  j += NL;
	  continue;
	}

      aris[j] = isar[i];
      j++;
    }

  aris[j] = '\0';

  printf ("aris = '%s'\n", aris);

  unsigned char * final_aris;

  //TODO: Check for predicates (don't always contain parentheses).
  //correct_parens (aris);
  
  final_aris = correct_conditionals (aris);
  if (!final_aris)
    return NULL;

  free (aris);
  aris = final_aris;

  return aris;
}

int
parse_thy (char * filename, proof_t * proof)
{
  FILE * file;

  file = fopen (filename, "r");
  if (!file)
    {
      perror (NULL);
      return -1;
    }

  int chk;
  long file_size;
  chk = fseek (file, 0, SEEK_END);
  if (chk)
    {
      fclose (file);
      perror (NULL);
      return -1;
    }

  file_size = ftell (file);

  chk = fseek (file, 0, SEEK_SET);
  if (chk)
    {
      fclose (file);
      perror (NULL);
      return -1;
    }

  char * buffer;

  buffer = (char *) calloc (file_size, sizeof (char));
  if (!buffer)
    {
      perror (NULL);
      return -1;
    }

  fread (buffer, 1, file_size, file);
  fclose (file);
  // Read in the file buffer to buffer.

  // Determine the main start of the file.
  char * ret_chk_str;
  ret_chk_str = strstr (buffer, "theory");
  if (!ret_chk_str)
    {
      // Invalid .thy file, return an error.
      return -2;
    }

  item_t * ls_chk;
  int i;

  //TODO: Check declarations (datatypes, functions, etc.)
  //TODO: Create a seqlog sequence (n for nats, etc.) for each one.
  //IDEA: Thinking t0, t1, (type 0, etc.) and store each in a map-like structure.
  //      Makes it easier to determine the input from functions.
  //NOTE: Datatypes are declared by constructor functions.
  //NOTE: ALL functions are recursive.

  vec_t * refs, * lms;
  in_type seq_0;
  char * buf_pos = ret_chk_str;
  //TODO: Parse the imports.
  // ???
  // Profit!!

  seqs = init_vec (sizeof (in_type));
  if (!seqs)
    return -1;

  seq_0.type = "nat";
  seq_0.seq = "n";
  chk = vec_add_obj (seqs, &seq_0);
  if (chk < 0)
    return -1;

  refs = init_vec (sizeof (char *));
  if (!refs)
    return -1;

  lms = init_vec (sizeof (char *));
  if (!lms)
    return -1;

  // After this, buf_pos will point to the position of 'begin'.
  buf_pos = strstr (buffer, "begin");

  if (strncmp (buf_pos, "begin", 5))
    {
      // Error stuff.
      return -2;
    }

  buf_pos += 5;

  while (isspace (*buf_pos))
    buf_pos++;

  while (1)
    {
      char * tmp_str, * cur_key;
      // Determine how to handle the current keyword.

      int pos = 0;
      while (isalnum (buf_pos[pos]) || buf_pos[pos] == '_')
	pos++;

      cur_key = (char *) calloc (pos + 1, sizeof (char));
      if (!cur_key)
	{
	  perror (NULL);
	  return -1;
	}
      strncpy (cur_key, buf_pos, pos);
      cur_key[pos] = '\0';

      // Determine the keyword.

      if (!strcmp (cur_key, "end"))
	{
	  free (cur_key);
	  break;
	}

      pos = 0;
      tmp_str = NULL;

      for (i = 0; i < KF_NUM_FUNCS; i++)
	{
	  if (!strcmp (cur_key, kfs[i].key))
	    {
	      pos = kfs[i].func (buf_pos, &tmp_str);
	      if (pos == -1)
		return -1;
	      break;
	    }
	}

      // Might need to parse brackets in the event of 'text', 'section', etc.

      for (i = 0; null_keys[i]; i++)
	{
	  if (!strcmp (cur_key, null_keys[i]))
	    {
	      pos = isar_parse_null (buf_pos);
	      if (pos == -1)
		return -1;
	      break;
	    }
	}

      if (!null_keys[i])
	{
	  if (!strcmp (cur_key, "datatype"))
	    {
	      pos = isar_parse_datatype (buf_pos, refs);
	      if (pos == -1)
		return -1;
	    }
	  else if (!strcmp (cur_key, "lemma"))
	    {
	      chk = vec_str_add_obj (lms, tmp_str);
	      if (chk < 0)
		return -1;
	    }
	  else if (tmp_str)
	    {
	      chk = vec_str_add_obj (refs, tmp_str);
	      if (chk < 0)
		return -1;
	    }
	}

      if (pos == 0)
	{
	  // Not a recognized keyword.
	}


      while (strncmp (buf_pos + pos, "\n\n", 2))
	buf_pos++;

      // Find the next non-whitespace character.
      while (isspace(buf_pos[pos]))
	pos++;

      buf_pos += pos;
      free (tmp_str);
      free (cur_key);
    }



  // Construct the proof.

  for (i = 0; i < refs->num_stuff; i++)
    {
      sen_data * sd;
      sd = sen_data_init (i, -1, vec_str_nth (refs, i), NULL, 1, NULL, 0, 0);
      if (!sd)
	return -1;

      ls_chk = ls_ins_obj (proof->everything, sd, proof->everything->tail);
      if (!ls_chk)
	return -1;
    }

  int ln_offset = refs->num_stuff;

  for (i = 0; i < lms->num_stuff; i++)
    {
      sen_data * sd;
      sd = sen_data_init (i + ln_offset, -1, vec_str_nth (lms, i),
			  NULL, 0, NULL, 0, 0);
      if (!sd)
	return -1;

      ls_chk = ls_ins_obj (proof->everything, sd, proof->everything->tail);
      if (!ls_chk)
	return -1;

      ls_chk = ls_ins_obj (proof->goals, vec_str_nth (lms, i),
			   proof->goals->tail);
      if (!ls_chk)
	return -1;
    }

  destroy_str_vec (refs);
  destroy_str_vec (lms);
  free (buffer);

  destroy_vec (seqs);

  return 0;
}
