/*  -*- Mode: C -*-  */

/* list-test.c --- test the list ADT */

/* Author:	       Gary V. Vaughan <gvv@techie.com>
 * Maintainer:	       Gary V. Vaughan <gvv@techie.com>
 * Created:	       Thu Apr 29 14:26:29 1999
 * Last Modified:      Wed Jul 14 15:06:47 1999
 *            by:      Gary V. Vaughan <gvv@techie.com>
 * ---------------------------------------------------------------------
 * @(#) $Id$
 * ---------------------------------------------------------------------
 */

/* Copyright (C) 1999 Gary V. Vaughan */

/* This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * As a special exception to the GNU General Public License, if you
 * distribute this file as part of a program that also links with and
 * uses the libopts library from AutoGen, you may include it under
 * the same distribution terms used by the libopts library.
 */

/* Code: */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "snprintfv/compat.h"
#include "snprintfv/list.h"
#include "snprintfv/mem.h"

#ifndef DIR_SEPARATOR
#define DIR_SEPARATOR '/'
#endif

struct node {
    struct node *next;
    int *data;
};

static const char *progname;

static void
slist_dump (stream, list)
    FILE* stream;
    slist *list;
{
    fprintf(stream, "(");
    if (list != NIL)
    {
	while (list != NIL)
	{
	    slist *tail = slist_tail(list);
	    fprintf(stream, " %d", *((struct node*)slist_head(list))->data);
	    if (tail != NIL)
	    {
		fprintf(stream, ",");
	    }
	    list = tail;
	}
	fprintf(stream, " ");
    }
    fprintf(stream, ")\n");
}

int
main (argc, argv)
    int   argc;
    char *argv[];
{
    slist *list, *st;
    FILE *stream = NULL;
    int nums[10];
    int i;

    progname = argv[0] + strlen(argv[0]);
    while (progname > argv[0] && *(progname -1) != DIR_SEPARATOR)
    {
	progname--;
    }

    for (i = 0; i < 10; i++)
    {
	nums[i] = i;
    }
    
    if (getenv("VERBOSE"))
    {
	stream = stdout;
    }
    else
    {
	stream = fopen("/dev/null", "w");
    }
    
    fprintf(stream, "=== running test %s\n", progname);

    list = NIL;
    slist_dump(stream, list);
    
    for (i = 0; i < 10; i++)
    {
	struct node *new = snv_new(struct node, 1);
	new->data = &nums[i];
	list = slist_cons(new, list);
    }
    
    for (i = 0; i < 10; i++)
    {
	st = slist_nth (list, i);
	snv_fassert (stream, *((struct node*)st)->data == 9 - i);
    }
    slist_dump(stream, list);
    
    list = slist_reverse(list);
    for (i = 0; i < 10; i++)
    {
	st = slist_nth (list, i);
	snv_fassert (stream, *((struct node*)st)->data == i);
    }
    slist_dump(stream, list);
    
    slist_delete(list, (slist_delete_func*)snv_free);
    list = NULL;
    
    return EXIT_SUCCESS;
}

/* list-test.c ends here */
