// Copyright (C) 2000-2001 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include <cc++/misc.h>
#include <cc++/file.h>
#include <getopt.h>
#include <stdio.h>
#include <stdlib.h>
#include <pwd.h>

#ifdef	CCXX_NAMESPACES
namespace ost {
using namespace std;
#endif

static char prefix[128] = "/etc/httpd";
static char httpd[256];
static char bayonne[256];
static int port = 1080;

static struct option long_options[] = {
	{"config", 1, 0, 'd'},
	{"prefix", 1, 0, 'd'},
	{"create", 0, 0, 'C'},
	{"port", 1, 0, 'P'}, 
	{"install", 1, 0, 'I'},
	{0, 0, 0, 0}};

#ifndef	HAVE_SETENV
static void setenv(char *name, const char *value, int overwrite)
{
	char strbuf[256];
	snprintf(strbuf, sizeof(strbuf), "%s=%s", name, value);
	putenv(strbuf);
}
#endif

static void Make(char *home, const char *runfiles)
{
	char buffer[256];
	char *cp;
	bool vhost = false;

	ifstream cf(httpd);
	ofstream bf(bayonne, ios::out | ios::trunc);
	
	chmod(bayonne, 0644);
	
	if(!runfiles)
		runfiles = "/var/run/bayonne";
	
	if(!cf.is_open())
	{
		cerr << "bayonne_apache: " << httpd << ": unable to access" << endl;
		exit(-1);
	}
	if(!bf.is_open())
	{
		cerr << "bayonne_apache: " << bayonne << ": unable to update" << endl;
		exit(-1);
	}
	
	for(;;)
	{
		cf.getline(buffer, sizeof(buffer) - 1);
		if(cf.eof())
			break;
		
		if(vhost)
		{
			if(strnicmp(buffer, "</VirtualHost>", 14))
				continue;
			vhost = false;
			continue;
		}
		if(!strnicmp(buffer, "<VirtualHost", 12))
		{
			vhost = true;		  
			continue;
		}
		if(!strnicmp(buffer, "ServerRoot", 10))
			sprintf(buffer, "ServerRoot \"%s\"", home);
		else if(!strnicmp(buffer, "PidFile", 7))
		{
			cp = strchr(buffer, '/');
			strcpy(cp, runfiles);
			strcat(cp, "/apache.pid");
		} 
		else if(!strnicmp(buffer, "ScoreBoardFile", 14))
		{
			cp = strchr(buffer, '/');
			strcpy(cp, runfiles);
			strcat(cp, "/apache.scoreboard");
		} 
		else if(!strnicmp(buffer, "Port", 4))
			sprintf(buffer, "Port %d", port);
		else if(!strnicmp(buffer, "User", 4))
			strcpy(buffer, "User bayonne");
		else if(!strnicmp(buffer, "Group", 5))
			strcpy(buffer, "Group bayonne");
		else if(!strnicmp(buffer, "DocumentRoot", 12))
			sprintf(buffer, "DocumentRoot \"%s/httpd\"", home);
			
		bf << buffer << endl;
	}
	cout << "bayonne apache configuration created" << endl;
	exit(0);
}

		
extern "C" int main(int argc, char **argv)
{
	static bool make = false;
	static bool usage = false;
	static bool install = false;
	const char *cp;
	char *ext;
	char buffer[128];
	int uid;
	int pid;
	ifstream pidfile;

	Keydata paths("/bayonne/paths");
	Keydata server("/bayonne/server");
	Keydata policy("/bayonne/trunks");

	struct passwd *pwd = getpwnam("bayonne");
	char *args[6];

	int opt, opt_index;
	char *env = getenv("APACHE_PREFIX");
	
	umask(002);
	if(env)
	{
		strncpy(prefix, env, sizeof(prefix) - 1);
		prefix[sizeof(prefix) - 1] = 0;
	}
	
	if(!pwd)
	{
		cerr << "bayonne_apache: bayonne: no such user" << endl;	
		exit(-1);
	}

	uid = getuid();
	if(uid != geteuid() && uid != pwd->pw_uid)
	{
		cerr << "bauonne_apache: denied for this user" << endl;
		exit(-1);
	}

	while(EOF != (opt = getopt_long(argc, argv, "CD:I:P:",
	   long_options, &opt_index)))
		switch(opt)
		{
		case 'd':
			strncpy(prefix, optarg, sizeof(prefix) - 1);
			prefix[sizeof(prefix) - 1] = 0;
			break;
		case 'I':
			strncpy(httpd, optarg, sizeof(httpd) - 1);
			httpd[sizeof(httpd) - 1] = 0;
			make = true;
			install = true;
			break;
		case 'C':
			make = true;
			break;
		case 'P':
			make = true;
			port = atoi(optarg);
			break;
		default:
			usage = true;
		}

	if(usage)
	{
		cerr << "bayonne_apache: [--prefix dir] [--create] [--port portnum]" << endl;
		exit(-1);
	}

	if(!install)
	{
		strcpy(httpd, prefix);
		strcat(httpd, "/conf/httpd.conf");
	}
	strcpy(bayonne, prefix);
	strcat(bayonne, "/conf/bayonne.conf");
	if(make)
		Make(pwd->pw_dir, paths.getLast("runfiles"));

	if(!canAccess(bayonne))
	{
		cerr << "bayonne_apache: " << bayonne << ": missing" << endl;
		exit(-1);
	}

	cp = paths.getLast("runfiles");
	if(!cp)
		cp = "/var/run/bayonne";
	setenv("BAYONNE_RUNFILES", cp, 1);

	cp = paths.getLast("datafiles");
	if(!cp)
		cp = "/var/bayonne";
	setenv("BAYONNE_DATAFILES", cp, 1);

	cp = paths.getLast("prompts");
	if(!cp)
		cp = "/usr/share/aaprompts";
	setenv("BAYONNE_PROMPTS", cp, 1);

	cp = paths.getLast("scripts");
	if(!cp)
		cp = "/usr/share/aascripts";
	setenv("BAYONNE_SCRIPTS", cp, 1);

	cp = server.getLast("token");
	if(!cp)
		cp = "&";
	setenv("BAYONNE_TOKEN", cp, 1);

	cp = policy.getLast("groups");
	if(!cp)
		cp = "";

	setenv("BAYONNE_POLICIES", cp, 1);
	setenv("BAYONNE_GROUPS", cp, 1);
	setenv("BAYONNE_VERSION", VERPATH, 1);
	setenv("APACHE_PREFIX", prefix, 1);

	cp = server.getLast("node");
	if(!cp)
	{
		gethostname(httpd, sizeof(httpd) - 1);
		cp = httpd;
		ext = strchr(httpd, '.');
		if(ext)
			*ext = 0;
	}
	setenv("BAYONNE_NODE", cp, 1);

	strcpy(buffer, paths.getLast("runfiles"));
	strcat(buffer, "/apache.pid");
	pidfile.open(buffer);
	if(pidfile.is_open())
	{
		sleep(2);
		pidfile.getline(buffer, sizeof(buffer) - 1);
		kill(atoi(buffer), SIGTERM);
		pidfile.close();
		sleep(2);
	}

	args[0] = "bayonne_httpd";
	args[1] = "-f";
	args[2] = bayonne;
	args[3] = "-D";
	args[4] = "BAYONNE";
	args[5] = NULL;
	execvp("httpd", args);
	cerr << "bayonne_apache: unable to start server" << endl;
	exit(-1);
}

#ifdef	CCXX_NAMESPACES
};
#endif



























